package com.a3spl.omnifin.model;

import java.io.Serializable;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;

@Entity
@Table(name = "com_branch_m")
public class ComBranchM implements Serializable {
	private static final long serialVersionUID = 1L;

	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@Column(name = "BRANCH_ID", unique = true, nullable = false)
	@Basic(fetch = FetchType.EAGER)
	private Integer branchId;

	@Column(name = "BRANCH_SHORT_CODE")
	private String branchShortCode;

	@Column(name = "BRANCH_DESC")
	private String branchDesc;

	@Column(name = "BRANCH_DESC_L")
	private String branchDescL;

	@Column(name = "BRANCH_ACCOUNT")
	private String branchAccount;

	@Column(name = "REGION_ID")
	private Integer regionId;

	@Column(name = "REC_STATUS")
	private String recStatus;

	@Column(name = "MAKER_ID")
	private String makerId;

	@Column(name = "MAKER_DATE")
	private String makerDate;

	@Column(name = "AUTHOR_ID")
	private String authorId;

	@Column(name = "AUTHOR_DATE")
	private String authorDate;

	@Column(name = "OPERATION_DATE")
	private String operationDate;

	@Column(name = "COMPANY_ID")
	private Integer companyId;

	@Column(name = "COUNTRY_ID")
	private Integer countryId;

	@Column(name = "STATE_ID")
	private Integer stateId;

	@Column(name = "DISTRICT_ID")
	private Integer districtId;

	@Column(name = "ZONE_ID")
	private Integer zoneId;

	@Column(name = "CLUSTER_ID")
	private Integer clusterId;

	@Column(name = "BRANCH_CATEGORY")
	private String branchCategory;

	@Column(name = "DEPOSIT_BANK_ID")
	private Integer depositBankId;

	@Column(name = "DEPOSIT_BRANCH_ID")
	private Integer depositBranchId;

	@Column(name = "DEPOSIT_MICR_CODE")
	private String depositMicrCode;

	@Column(name = "DEPOSIT_IFSC_CODE")
	private String depositIfscCode;

	@Column(name = "DEPOSIT_BANK_ACCOUNT")
	private String depositBankAccount;

	@Column(name = "BRANCH_ADDRESS_LINE1")
	private String branchAddressLine1;

	@Column(name = "BRANCH_ADDRESS_LINE2")
	private String branchAddressLine2;

	@Column(name = "BRANCH_ADDRESS_LINE3")
	private String branchAddressLine3;

	@Column(name = "BRANCH_PINCODE")
	private String branchPinCode;

	@Column(name = "BRANCH_TYPE")
	private String branchType;

	@Column(name = "ORGANIZATION_GSTIN")
	private String organizationGstin;

	@Column(name = "LENDER_DIVISION_NAME")
	private String lenderDivisionName;

	@Column(name = "LENDER_BRANCH_NAME")
	private String lenderBranchName;

	@Column(name = "USER_EMAIL_ID")
	private String userEmailId;
	
	//Added by Amol S on 03-Dec-24 strt
	 @Column(name = "BRANCH_STATUS")  
	 private String branchStatus;  
	//Added by Amol S on 03-Dec-24 end


	public void setBranchId(Integer branchId) {
		this.branchId = branchId;
	}

	public void setBranchShortCode(String branchShortCode) {
		this.branchShortCode = branchShortCode;
	}

	public void setBranchDesc(String branchDesc) {
		this.branchDesc = branchDesc;
	}

	public void setBranchDescL(String branchDescL) {
		this.branchDescL = branchDescL;
	}

	public void setBranchAccount(String branchAccount) {
		this.branchAccount = branchAccount;
	}

	public void setRegionId(Integer regionId) {
		this.regionId = regionId;
	}

	public void setRecStatus(String recStatus) {
		this.recStatus = recStatus;
	}

	public void setMakerId(String makerId) {
		this.makerId = makerId;
	}

	public void setMakerDate(String makerDate) {
		this.makerDate = makerDate;
	}

	public void setAuthorId(String authorId) {
		this.authorId = authorId;
	}

	public void setAuthorDate(String authorDate) {
		this.authorDate = authorDate;
	}

	public void setOperationDate(String operationDate) {
		this.operationDate = operationDate;
	}

	public void setCompanyId(Integer companyId) {
		this.companyId = companyId;
	}

	public void setCountryId(Integer countryId) {
		this.countryId = countryId;
	}

	public void setStateId(Integer stateId) {
		this.stateId = stateId;
	}

	public void setDistrictId(Integer districtId) {
		this.districtId = districtId;
	}

	public void setZoneId(Integer zoneId) {
		this.zoneId = zoneId;
	}

	public void setClusterId(Integer clusterId) {
		this.clusterId = clusterId;
	}

	public void setBranchCategory(String branchCategory) {
		this.branchCategory = branchCategory;
	}

	public void setDepositBankId(Integer depositBankId) {
		this.depositBankId = depositBankId;
	}

	public void setDepositBranchId(Integer depositBranchId) {
		this.depositBranchId = depositBranchId;
	}

	public void setDepositMicrCode(String depositMicrCode) {
		this.depositMicrCode = depositMicrCode;
	}

	public void setDepositIfscCode(String depositIfscCode) {
		this.depositIfscCode = depositIfscCode;
	}

	public void setDepositBankAccount(String depositBankAccount) {
		this.depositBankAccount = depositBankAccount;
	}

	public void setBranchAddressLine1(String branchAddressLine1) {
		this.branchAddressLine1 = branchAddressLine1;
	}

	public void setBranchAddressLine2(String branchAddressLine2) {
		this.branchAddressLine2 = branchAddressLine2;
	}

	public void setBranchAddressLine3(String branchAddressLine3) {
		this.branchAddressLine3 = branchAddressLine3;
	}

	public void setBranchPinCode(String branchPinCode) {
		this.branchPinCode = branchPinCode;
	}

	public void setBranchType(String branchType) {
		this.branchType = branchType;
	}

	public void setOrganizationGstin(String organizationGstin) {
		this.organizationGstin = organizationGstin;
	}

	public void setLenderDivisionName(String lenderDivisionName) {
		this.lenderDivisionName = lenderDivisionName;
	}

	public void setLenderBranchName(String lenderBranchName) {
		this.lenderBranchName = lenderBranchName;
	}

	public void setUserEmailId(String userEmailId) {
		this.userEmailId = userEmailId;
	}
	//Added by Amol S  on 03-Dec-24 setter for branch status --strt
	 public void setBranchStatus(String branchStatus)
	 {
	     this.branchStatus = branchStatus;
	 }
	//Added by Amol S  on 03-Dec-24 setter for branch status --end


	public boolean equals(Object o) {
		if (o == this)
			return true;
		if (!(o instanceof com.a3spl.omnifin.model.ComBranchM))
			return false;
		com.a3spl.omnifin.model.ComBranchM other = (com.a3spl.omnifin.model.ComBranchM) o;
		if (!other.canEqual(this))
			return false;
		Object this$branchId = getBranchId(), other$branchId = other.getBranchId();
		if ((this$branchId == null) ? (other$branchId != null) : !this$branchId.equals(other$branchId))
			return false;
		Object this$regionId = getRegionId(), other$regionId = other.getRegionId();
		if ((this$regionId == null) ? (other$regionId != null) : !this$regionId.equals(other$regionId))
			return false;
		Object this$companyId = getCompanyId(), other$companyId = other.getCompanyId();
		if ((this$companyId == null) ? (other$companyId != null) : !this$companyId.equals(other$companyId))
			return false;
		Object this$countryId = getCountryId(), other$countryId = other.getCountryId();
		if ((this$countryId == null) ? (other$countryId != null) : !this$countryId.equals(other$countryId))
			return false;
		Object this$stateId = getStateId(), other$stateId = other.getStateId();
		if ((this$stateId == null) ? (other$stateId != null) : !this$stateId.equals(other$stateId))
			return false;
		Object this$districtId = getDistrictId(), other$districtId = other.getDistrictId();
		if ((this$districtId == null) ? (other$districtId != null) : !this$districtId.equals(other$districtId))
			return false;
		Object this$zoneId = getZoneId(), other$zoneId = other.getZoneId();
		if ((this$zoneId == null) ? (other$zoneId != null) : !this$zoneId.equals(other$zoneId))
			return false;
		Object this$clusterId = getClusterId(), other$clusterId = other.getClusterId();
		if ((this$clusterId == null) ? (other$clusterId != null) : !this$clusterId.equals(other$clusterId))
			return false;
		Object this$depositBankId = getDepositBankId(), other$depositBankId = other.getDepositBankId();
		if ((this$depositBankId == null) ? (other$depositBankId != null)
				: !this$depositBankId.equals(other$depositBankId))
			return false;
		Object this$depositBranchId = getDepositBranchId(), other$depositBranchId = other.getDepositBranchId();
		if ((this$depositBranchId == null) ? (other$depositBranchId != null)
				: !this$depositBranchId.equals(other$depositBranchId))
			return false;
		Object this$branchShortCode = getBranchShortCode(), other$branchShortCode = other.getBranchShortCode();
		if ((this$branchShortCode == null) ? (other$branchShortCode != null)
				: !this$branchShortCode.equals(other$branchShortCode))
			return false;
		Object this$branchDesc = getBranchDesc(), other$branchDesc = other.getBranchDesc();
		if ((this$branchDesc == null) ? (other$branchDesc != null) : !this$branchDesc.equals(other$branchDesc))
			return false;
		Object this$branchDescL = getBranchDescL(), other$branchDescL = other.getBranchDescL();
		if ((this$branchDescL == null) ? (other$branchDescL != null) : !this$branchDescL.equals(other$branchDescL))
			return false;
		Object this$branchAccount = getBranchAccount(), other$branchAccount = other.getBranchAccount();
		if ((this$branchAccount == null) ? (other$branchAccount != null)
				: !this$branchAccount.equals(other$branchAccount))
			return false;
		Object this$recStatus = getRecStatus(), other$recStatus = other.getRecStatus();
		if ((this$recStatus == null) ? (other$recStatus != null) : !this$recStatus.equals(other$recStatus))
			return false;
		Object this$makerId = getMakerId(), other$makerId = other.getMakerId();
		if ((this$makerId == null) ? (other$makerId != null) : !this$makerId.equals(other$makerId))
			return false;
		Object this$makerDate = getMakerDate(), other$makerDate = other.getMakerDate();
		if ((this$makerDate == null) ? (other$makerDate != null) : !this$makerDate.equals(other$makerDate))
			return false;
		Object this$authorId = getAuthorId(), other$authorId = other.getAuthorId();
		if ((this$authorId == null) ? (other$authorId != null) : !this$authorId.equals(other$authorId))
			return false;
		Object this$authorDate = getAuthorDate(), other$authorDate = other.getAuthorDate();
		if ((this$authorDate == null) ? (other$authorDate != null) : !this$authorDate.equals(other$authorDate))
			return false;
		Object this$operationDate = getOperationDate(), other$operationDate = other.getOperationDate();
		if ((this$operationDate == null) ? (other$operationDate != null)
				: !this$operationDate.equals(other$operationDate))
			return false;
		Object this$branchCategory = getBranchCategory(), other$branchCategory = other.getBranchCategory();
		if ((this$branchCategory == null) ? (other$branchCategory != null)
				: !this$branchCategory.equals(other$branchCategory))
			return false;
		Object this$depositMicrCode = getDepositMicrCode(), other$depositMicrCode = other.getDepositMicrCode();
		if ((this$depositMicrCode == null) ? (other$depositMicrCode != null)
				: !this$depositMicrCode.equals(other$depositMicrCode))
			return false;
		Object this$depositIfscCode = getDepositIfscCode(), other$depositIfscCode = other.getDepositIfscCode();
		if ((this$depositIfscCode == null) ? (other$depositIfscCode != null)
				: !this$depositIfscCode.equals(other$depositIfscCode))
			return false;
		Object this$depositBankAccount = getDepositBankAccount(),
				other$depositBankAccount = other.getDepositBankAccount();
		if ((this$depositBankAccount == null) ? (other$depositBankAccount != null)
				: !this$depositBankAccount.equals(other$depositBankAccount))
			return false;
		Object this$branchAddressLine1 = getBranchAddressLine1(),
				other$branchAddressLine1 = other.getBranchAddressLine1();
		if ((this$branchAddressLine1 == null) ? (other$branchAddressLine1 != null)
				: !this$branchAddressLine1.equals(other$branchAddressLine1))
			return false;
		Object this$branchAddressLine2 = getBranchAddressLine2(),
				other$branchAddressLine2 = other.getBranchAddressLine2();
		if ((this$branchAddressLine2 == null) ? (other$branchAddressLine2 != null)
				: !this$branchAddressLine2.equals(other$branchAddressLine2))
			return false;
		Object this$branchAddressLine3 = getBranchAddressLine3(),
				other$branchAddressLine3 = other.getBranchAddressLine3();
		if ((this$branchAddressLine3 == null) ? (other$branchAddressLine3 != null)
				: !this$branchAddressLine3.equals(other$branchAddressLine3))
			return false;
		Object this$branchPinCode = getBranchPinCode(), other$branchPinCode = other.getBranchPinCode();
		if ((this$branchPinCode == null) ? (other$branchPinCode != null)
				: !this$branchPinCode.equals(other$branchPinCode))
			return false;
		Object this$branchType = getBranchType(), other$branchType = other.getBranchType();
		if ((this$branchType == null) ? (other$branchType != null) : !this$branchType.equals(other$branchType))
			return false;
		Object this$organizationGstin = getOrganizationGstin(), other$organizationGstin = other.getOrganizationGstin();
		if ((this$organizationGstin == null) ? (other$organizationGstin != null)
				: !this$organizationGstin.equals(other$organizationGstin))
			return false;
		Object this$lenderDivisionName = getLenderDivisionName(),
				other$lenderDivisionName = other.getLenderDivisionName();
		if ((this$lenderDivisionName == null) ? (other$lenderDivisionName != null)
				: !this$lenderDivisionName.equals(other$lenderDivisionName))
			return false;
		Object this$lenderBranchName = getLenderBranchName(), other$lenderBranchName = other.getLenderBranchName();
		if ((this$lenderBranchName == null) ? (other$lenderBranchName != null)
				: !this$lenderBranchName.equals(other$lenderBranchName))
			return false;
		Object this$userEmailId = getUserEmailId(), other$userEmailId = other.getUserEmailId();
		return !((this$userEmailId == null) ? (other$userEmailId != null)
				: !this$userEmailId.equals(other$userEmailId));
	}

	protected boolean canEqual(Object other) {
		return other instanceof com.a3spl.omnifin.model.ComBranchM;
	}

	public int hashCode() {
		int PRIME = 59;
		int result = 1;
		Object $branchId = getBranchId();
		result = result * 59 + (($branchId == null) ? 43 : $branchId.hashCode());
		Object $regionId = getRegionId();
		result = result * 59 + (($regionId == null) ? 43 : $regionId.hashCode());
		Object $companyId = getCompanyId();
		result = result * 59 + (($companyId == null) ? 43 : $companyId.hashCode());
		Object $countryId = getCountryId();
		result = result * 59 + (($countryId == null) ? 43 : $countryId.hashCode());
		Object $stateId = getStateId();
		result = result * 59 + (($stateId == null) ? 43 : $stateId.hashCode());
		Object $districtId = getDistrictId();
		result = result * 59 + (($districtId == null) ? 43 : $districtId.hashCode());
		Object $zoneId = getZoneId();
		result = result * 59 + (($zoneId == null) ? 43 : $zoneId.hashCode());
		Object $clusterId = getClusterId();
		result = result * 59 + (($clusterId == null) ? 43 : $clusterId.hashCode());
		Object $depositBankId = getDepositBankId();
		result = result * 59 + (($depositBankId == null) ? 43 : $depositBankId.hashCode());
		Object $depositBranchId = getDepositBranchId();
		result = result * 59 + (($depositBranchId == null) ? 43 : $depositBranchId.hashCode());
		Object $branchShortCode = getBranchShortCode();
		result = result * 59 + (($branchShortCode == null) ? 43 : $branchShortCode.hashCode());
		Object $branchDesc = getBranchDesc();
		result = result * 59 + (($branchDesc == null) ? 43 : $branchDesc.hashCode());
		Object $branchDescL = getBranchDescL();
		result = result * 59 + (($branchDescL == null) ? 43 : $branchDescL.hashCode());
		Object $branchAccount = getBranchAccount();
		result = result * 59 + (($branchAccount == null) ? 43 : $branchAccount.hashCode());
		Object $recStatus = getRecStatus();
		result = result * 59 + (($recStatus == null) ? 43 : $recStatus.hashCode());
		Object $makerId = getMakerId();
		result = result * 59 + (($makerId == null) ? 43 : $makerId.hashCode());
		Object $makerDate = getMakerDate();
		result = result * 59 + (($makerDate == null) ? 43 : $makerDate.hashCode());
		Object $authorId = getAuthorId();
		result = result * 59 + (($authorId == null) ? 43 : $authorId.hashCode());
		Object $authorDate = getAuthorDate();
		result = result * 59 + (($authorDate == null) ? 43 : $authorDate.hashCode());
		Object $operationDate = getOperationDate();
		result = result * 59 + (($operationDate == null) ? 43 : $operationDate.hashCode());
		Object $branchCategory = getBranchCategory();
		result = result * 59 + (($branchCategory == null) ? 43 : $branchCategory.hashCode());
		Object $depositMicrCode = getDepositMicrCode();
		result = result * 59 + (($depositMicrCode == null) ? 43 : $depositMicrCode.hashCode());
		Object $depositIfscCode = getDepositIfscCode();
		result = result * 59 + (($depositIfscCode == null) ? 43 : $depositIfscCode.hashCode());
		Object $depositBankAccount = getDepositBankAccount();
		result = result * 59 + (($depositBankAccount == null) ? 43 : $depositBankAccount.hashCode());
		Object $branchAddressLine1 = getBranchAddressLine1();
		result = result * 59 + (($branchAddressLine1 == null) ? 43 : $branchAddressLine1.hashCode());
		Object $branchAddressLine2 = getBranchAddressLine2();
		result = result * 59 + (($branchAddressLine2 == null) ? 43 : $branchAddressLine2.hashCode());
		Object $branchAddressLine3 = getBranchAddressLine3();
		result = result * 59 + (($branchAddressLine3 == null) ? 43 : $branchAddressLine3.hashCode());
		Object $branchPinCode = getBranchPinCode();
		result = result * 59 + (($branchPinCode == null) ? 43 : $branchPinCode.hashCode());
		Object $branchType = getBranchType();
		result = result * 59 + (($branchType == null) ? 43 : $branchType.hashCode());
		Object $organizationGstin = getOrganizationGstin();
		result = result * 59 + (($organizationGstin == null) ? 43 : $organizationGstin.hashCode());
		Object $lenderDivisionName = getLenderDivisionName();
		result = result * 59 + (($lenderDivisionName == null) ? 43 : $lenderDivisionName.hashCode());
		Object $lenderBranchName = getLenderBranchName();
		result = result * 59 + (($lenderBranchName == null) ? 43 : $lenderBranchName.hashCode());
		Object $userEmailId = getUserEmailId();
		return result * 59 + (($userEmailId == null) ? 43 : $userEmailId.hashCode());
	}

	public String toString() {
		return "ComBranchM(branchId=" + getBranchId() + ", branchShortCode=" + getBranchShortCode() + ", branchDesc="
				+ getBranchDesc() + ", branchDescL=" + getBranchDescL() + ", branchAccount=" + getBranchAccount()
				+ ", regionId=" + getRegionId() + ", recStatus=" + getRecStatus() + ", makerId=" + getMakerId()
				+ ", makerDate=" + getMakerDate() + ", authorId=" + getAuthorId() + ", authorDate=" + getAuthorDate()
				+ ", operationDate=" + getOperationDate() + ", companyId=" + getCompanyId() + ", countryId="
				+ getCountryId() + ", stateId=" + getStateId() + ", districtId=" + getDistrictId() + ", zoneId="
				+ getZoneId() + ", clusterId=" + getClusterId() + ", branchCategory=" + getBranchCategory()
				+ ", depositBankId=" + getDepositBankId() + ", depositBranchId=" + getDepositBranchId()
				+ ", depositMicrCode=" + getDepositMicrCode() + ", depositIfscCode=" + getDepositIfscCode()
				+ ", depositBankAccount=" + getDepositBankAccount() + ", branchAddressLine1=" + getBranchAddressLine1()
				+ ", branchAddressLine2=" + getBranchAddressLine2() + ", branchAddressLine3=" + getBranchAddressLine3()
				+ ", branchPinCode=" + getBranchPinCode() + ", branchType=" + getBranchType() + ", organizationGstin="
				+ getOrganizationGstin() + ", lenderDivisionName=" + getLenderDivisionName() + ", lenderBranchName="
				+ getLenderBranchName() + ", userEmailId=" + getUserEmailId() + ", branchStatus=" + getBranchStatus() + ")";
	}

	public Integer getBranchId() {
		return this.branchId;
	}

	public String getBranchShortCode() {
		return this.branchShortCode;
	}

	public String getBranchDesc() {
		return this.branchDesc;
	}

	public String getBranchDescL() {
		return this.branchDescL;
	}

	public String getBranchAccount() {
		return this.branchAccount;
	}

	public Integer getRegionId() {
		return this.regionId;
	}

	public String getRecStatus() {
		return this.recStatus;
	}

	public String getMakerId() {
		return this.makerId;
	}

	public String getMakerDate() {
		return this.makerDate;
	}

	public String getAuthorId() {
		return this.authorId;
	}

	public String getAuthorDate() {
		return this.authorDate;
	}

	public String getOperationDate() {
		return this.operationDate;
	}

	public Integer getCompanyId() {
		return this.companyId;
	}

	public Integer getCountryId() {
		return this.countryId;
	}

	public Integer getStateId() {
		return this.stateId;
	}

	public Integer getDistrictId() {
		return this.districtId;
	}

	public Integer getZoneId() {
		return this.zoneId;
	}

	public Integer getClusterId() {
		return this.clusterId;
	}

	public String getBranchCategory() {
		return this.branchCategory;
	}

	public Integer getDepositBankId() {
		return this.depositBankId;
	}

	public Integer getDepositBranchId() {
		return this.depositBranchId;
	}

	public String getDepositMicrCode() {
		return this.depositMicrCode;
	}

	public String getDepositIfscCode() {
		return this.depositIfscCode;
	}

	public String getDepositBankAccount() {
		return this.depositBankAccount;
	}

	public String getBranchAddressLine1() {
		return this.branchAddressLine1;
	}

	public String getBranchAddressLine2() {
		return this.branchAddressLine2;
	}

	public String getBranchAddressLine3() {
		return this.branchAddressLine3;
	}

	public String getBranchPinCode() {
		return this.branchPinCode;
	}

	public String getBranchType() {
		return this.branchType;
	}

	public String getOrganizationGstin() {
		return this.organizationGstin;
	}

	public String getLenderDivisionName() {
		return this.lenderDivisionName;
	}

	public String getLenderBranchName() {
		return this.lenderBranchName;
	}

	public String getUserEmailId() {
		return this.userEmailId;
	}
	//Added by Amol S on 03-Dec-24 , getter for branch statud --strt
	 public String getBranchStatus()
	{
	  return this.branchStatus;
	}
	//Added by Amol S on 03-Dec-24 , getter for branch statud --end

	
}
