/*
 * Decompiled with CFR 0.152.
 */
package ibase.bankIntegration.scheduledSFTP;

import ibase.bankIntegration.CommonMethods;
import ibase.scheduler.utility.interfaces.Schedule;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.utility.ITMException;
import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.json.JsonObject;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ScheduledSFTPUploader
implements Schedule {
    E12GenericUtility e12GenericUtility = new E12GenericUtility();
    boolean bankCodeBool = false;
    String formattedTime = "";
    String bankCode = "";
    String schId = "sch-1310637816";
    UserInfoBean userInfoGlobal = new UserInfoBean();
    NodeList argNodeList = null;

    public String schedule(HashMap arg0) throws Exception {
        return null;
    }

    public String schedule(String name) throws Exception {
        File[] files;
        UserInfoBean userInfo;
        BaseLogger.log((String)"3", null, null, (Object)"ScheduledSFTPUploader gsb calling test 24-jan------------------");
        BaseLogger.log((String)"3", null, null, (Object)("name::[ " + name + " ]"));
        Document schdulerInfoDocument = this.e12GenericUtility.parseString(name);
        this.userInfoGlobal = userInfo = new UserInfoBean(this.e12GenericUtility.serializeDom(schdulerInfoDocument.getElementsByTagName("USERINFOXML").item(0).getChildNodes().item(0)));
        this.argNodeList = schdulerInfoDocument.getElementsByTagName("ACTUALPARAMETER");
        int i = 0;
        while (i < this.argNodeList.getLength()) {
            Node childNode = this.argNodeList.item(i);
            if (childNode.getNodeType() == 1 && childNode != null) {
                System.out.println("childNode gsb=[" + childNode + "]");
                this.bankCodeBool = this.isParameterPresent(childNode, "BANK_CODE");
                if (this.bankCodeBool && childNode.getAttributes().getNamedItem("name").getNodeValue().equalsIgnoreCase("BANK_CODE")) {
                    this.bankCode = E12GenericUtility.checkNull((String)childNode.getFirstChild().getNodeValue());
                    System.out.println("BankCode = [" + this.bankCode + "]");
                }
            }
            ++i;
        }
        String uploadFileToSFTPResult = "";
        CommonMethods commonMethods = new CommonMethods();
        DBAccessEJB dbAccessEJB = new DBAccessEJB();
        String payIntArgs = dbAccessEJB.getDBColumnValue("BANK", "PAY_INT_ARGS", "BANK_CODE  = '" + this.bankCode + "'", userInfo.getTransDB());
        BaseLogger.log((String)"3", null, null, (Object)("Inside actionHandler generateXML.. payIntArgs[ " + payIntArgs + "]"));
        JsonObject payIntArgsJSON = CommonMethods.parseJsonString(payIntArgs);
        String localFolderPath = CommonMethods.getValueFromJson(payIntArgsJSON, "bank_specific_folder");
        localFolderPath = String.valueOf(localFolderPath) + File.separator + "XML_files";
        BaseLogger.log((String)"3", null, null, (Object)("Inside localFolderPath[ " + localFolderPath + "]"));
        int fileCount = 0;
        File localFolder = new File(localFolderPath);
        if (localFolder.exists() && localFolder.isDirectory() && (files = localFolder.listFiles((directory, fileName) -> fileName.endsWith(".xml"))) != null) {
            fileCount = files.length - 1;
        }
        BaseLogger.log((String)"3", null, null, (Object)("Number of XML files in the local folder: " + fileCount));
        int count = this.getConfirmedTransactionCount(name, userInfo, this.formattedTime);
        BaseLogger.log((String)"3", null, null, (Object)("Trancasction confirm in misc_payment table Count: " + count));
        LocalDateTime currentTime = LocalDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        this.formattedTime = currentTime.format(formatter);
        BaseLogger.log((String)"3", null, null, (Object)("File uploaded at Time : " + this.formattedTime));
        Timestamp startingTimestamp = this.getStartingTimestamp(name, userInfo);
        BaseLogger.log((String)"3", null, null, (Object)("startingTimestampTime : " + startingTimestamp));
        uploadFileToSFTPResult = commonMethods.uploadFileToSFTP(this.bankCode, userInfo);
        System.out.println("uploadFileToSFTPResult gsb=[" + uploadFileToSFTPResult + "]");
        return null;
    }

    public String schedulePriority(String arg0) throws Exception {
        return null;
    }

    private boolean isParameterPresent(Node childNode, String attribName) throws ITMException {
        boolean attribFound = false;
        try {
            System.out.println("attribFound test= [" + childNode.getAttributes() + "]");
            if (childNode != null && childNode.getAttributes() != null) {
                System.out.println("attribFound name= [" + childNode.getAttributes().getNamedItem("name").getNodeValue() + "]");
                if (childNode.getAttributes().getNamedItem("name").getNodeValue().equalsIgnoreCase(attribName)) {
                    attribFound = true;
                }
            }
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        System.out.println("attribFound = [" + attribFound + "]");
        return attribFound;
    }

    public Timestamp getStartingTimestamp(String schId, UserInfoBean userInfo) throws Exception {
        BaseLogger.log((String)"3", null, null, (Object)"Inside the method getStartingTimestamp:: \t");
        Connection connection = null;
        Statement preparedStatement = null;
        ResultSet resultSet = null;
        Timestamp startingTimestamp = null;
        schId = "sch-1310637816";
        try {
            try {
                ConnDriver connDriver = new ConnDriver();
                String transDB = userInfo.getTransDB();
                connection = connDriver.getConnectDB(transDB);
                String query = "SELECT LAST_EXE_DATE FROM schedule_log WHERE SCH_ID = ? ORDER BY LAST_EXE_DATE DESC FETCH FIRST 1 ROW ONLY";
                preparedStatement = connection.prepareStatement(query);
                preparedStatement.setString(1, schId);
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    startingTimestamp = resultSet.getTimestamp("LAST_EXE_DATE");
                }
            }
            catch (Exception e) {
                BaseLogger.log((String)"3", null, null, (Object)("Error in getStartingTimestamp: [" + E12GenericUtility.getStackTrace((Exception)e) + "]"));
                throw new Exception("Error fetching the starting timestamp: " + e.getMessage(), e);
            }
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception e) {
                    BaseLogger.log((String)"3", null, null, (Object)("Error closing ResultSet: [" + E12GenericUtility.getStackTrace((Exception)e) + "]"));
                }
            }
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (Exception e) {
                    BaseLogger.log((String)"3", null, null, (Object)("Error closing PreparedStatement: [" + E12GenericUtility.getStackTrace((Exception)e) + "]"));
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception e) {
                    BaseLogger.log((String)"3", null, null, (Object)("Error closing Connection: [" + E12GenericUtility.getStackTrace((Exception)e) + "]"));
                }
            }
        }
        BaseLogger.log((String)"3", null, null, (Object)("startingTimestamp ===> [" + startingTimestamp + "]"));
        return startingTimestamp;
    }

    public int getConfirmedTransactionCount(String schId, UserInfoBean userInfo, String formattedTime) throws Exception {
        BaseLogger.log((String)"3", null, null, (Object)"Inside the method getConfirmedTransactionCount--> \t");
        String query = "SELECT COUNT(*) AS total_confirmed_transactions FROM misc_payment WHERE CONFIRM = 'Y' AND tran_date BETWEEN ? AND ?";
        int totalCount = 0;
        Connection connection = null;
        Statement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            try {
                ConnDriver connDriver = new ConnDriver();
                connection = connDriver.getConnectDB(userInfo.getTransDB());
                Timestamp startingTimestamp = this.getStartingTimestamp(schId, userInfo);
                preparedStatement = connection.prepareStatement(query);
                preparedStatement.setTimestamp(1, startingTimestamp);
                preparedStatement.setTimestamp(2, Timestamp.valueOf(formattedTime));
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    totalCount = resultSet.getInt("total_confirmed_transactions");
                }
            }
            catch (Exception e) {
                throw new Exception("Error fetching confirmed transaction count: " + e.getMessage(), e);
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
        BaseLogger.log((String)"3", null, null, (Object)("totalCount of transactions:: ===> [" + totalCount + "]"));
        return totalCount;
    }

    public List<String> findMissingGeneratedFiles(String localFolderPath, Timestamp startingTimestamp, Timestamp currentTimestamp, UserInfoBean userInfo) throws Exception {
        File[] files;
        BaseLogger.log((String)"3", null, null, (Object)"Inside the method findMissingGeneratedFiles...AMS  \t");
        ArrayList<String> missingFiles = new ArrayList<String>();
        List<String> confirmedTranIds = this.getConfirmedTransactionIds(startingTimestamp, currentTimestamp, userInfo);
        File localFolder = new File(localFolderPath);
        ArrayList<String> localFileNames = new ArrayList<String>();
        if (localFolder.exists() && localFolder.isDirectory() && (files = localFolder.listFiles((dir, name) -> name.endsWith(".xml"))) != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                Object file = fileArray[n2];
                localFileNames.add(((File)file).getName());
                ++n2;
            }
        }
        for (String tranId : confirmedTranIds) {
            boolean isFileFound = false;
            for (String fileName : localFileNames) {
                if (!fileName.startsWith(tranId)) continue;
                isFileFound = true;
                break;
            }
            if (!isFileFound) {
                missingFiles.add(tranId);
            }
            BaseLogger.log((String)"3", null, null, (Object)("missingFiles in findMissingGeneratedFiles  \t" + missingFiles));
        }
        return missingFiles;
    }

    private List<String> getConfirmedTransactionIds(Timestamp startingTimestamp, Timestamp currentTimestamp, UserInfoBean userInfo) throws Exception {
        BaseLogger.log((String)"3", null, null, (Object)"Inside the method getConfirmedTransactionIds::::: \t");
        String query = "SELECT tran_id FROM misc_payment WHERE status = 'Y' AND tran_date BETWEEN ? AND ?";
        ArrayList<String> confirmedTranIds = new ArrayList<String>();
        Connection connection = null;
        Statement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            try {
                ConnDriver connDriver = new ConnDriver();
                connection = connDriver.getConnectDB(userInfo.getTransDB());
                preparedStatement = connection.prepareStatement(query);
                preparedStatement.setTimestamp(1, startingTimestamp);
                preparedStatement.setTimestamp(2, currentTimestamp);
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    confirmedTranIds.add(resultSet.getString("tran_id"));
                }
            }
            catch (Exception e) {
                throw new Exception("Error fetching confirmed transaction IDs: " + e.getMessage(), e);
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
        BaseLogger.log((String)"3", null, null, (Object)("confirmedTranIds in getConfirmedTransactionIds :::-->  \t" + confirmedTranIds));
        return confirmedTranIds;
    }
}

