/*
 * Decompiled with CFR 0.152.
 */
package ibase.utility.training.bankIntegration;

import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.UserInfoBean;
import ibase.utility.training.bankIntegration.BankBean;
import ibase.webitm.ejb.EventManagerEJB;
import ibase.webitm.ejb.MasterStatefulLocal;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Random;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class BankIntegration {
    BankBean bankBean = new BankBean();

    public String confirmfual(String tranID, String xtraParam, Connection conn) throws RemoteException, ibase.planner.utility.ITMException {
        String result = "";
        System.out.println(" Inside BankIntegration GSB confirm tranID [" + tranID + "]");
        System.out.println(" Inside BankIntegration GSB confirm xtraParam [" + xtraParam + "]");
        return result;
    }

    public boolean isIntegrated(String bankCode, UserInfoBean userInfo) throws SQLException {
        boolean result = false;
        BaseLogger.log((String)"3", null, null, (Object)"Inside isIntegrated method of BankIntegration class ...");
        Connection connection = null;
        Statement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                ConnDriver connDriver = new ConnDriver();
                connection = connDriver.getConnectDB(userInfo.getTransDB());
                String isIntegratedSQL = "SELECT IS_INTEGRATED, PAY_INT_SERVICE FROM BANK WHERE BANK_CODE = ?";
                pstmt = connection.prepareStatement(isIntegratedSQL);
                pstmt.setString(1, bankCode);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    String isIntegrated = rs.getString("IS_INTEGRATED");
                    String payIntService = rs.getString("PAY_INT_SERVICE");
                    BaseLogger.log((String)"3", null, null, (Object)("Inside isIntegrated method of BankIntegration class isIntegrated [" + isIntegrated + "]"));
                    BaseLogger.log((String)"3", null, null, (Object)("Inside isIntegrated method of BankIntegration class payIntService [" + payIntService + "]"));
                    this.bankBean.setPayInitService(payIntService);
                    if (!isIntegrated.equalsIgnoreCase("Y")) continue;
                    result = true;
                }
            }
            catch (Exception exp) {
                exp.printStackTrace();
                if (connection != null) {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (connection != null) {
                        connection.close();
                        connection = null;
                    }
                }
            }
        }
        finally {
            if (connection != null) {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (connection != null) {
                    connection.close();
                    connection = null;
                }
            }
        }
        return result;
    }

    public String getBankCodeFromTranID(String tranID, UserInfoBean userInfo) throws SQLException {
        String bankCode = "";
        BaseLogger.log((String)"3", null, null, (Object)"Inside getBankCodeFromTranID method of BankIntegration class ...");
        Connection connection = null;
        Statement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                ConnDriver connDriver = new ConnDriver();
                connection = connDriver.getConnectDB(userInfo.getTransDB());
                String getBankCodeSQL = "SELECT BANK_CODE FROM MISC_PAYMENT WHERE TRAN_ID = ?";
                pstmt = connection.prepareStatement(getBankCodeSQL);
                pstmt.setString(1, tranID);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    bankCode = rs.getString("BANK_CODE");
                    BaseLogger.log((String)"3", null, null, (Object)("Inside isIntegrated method of BankIntegration class bankCode [" + bankCode + "]"));
                }
            }
            catch (Exception exp) {
                exp.printStackTrace();
                if (connection != null) {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (connection != null) {
                        connection.close();
                        connection = null;
                    }
                }
            }
        }
        finally {
            if (connection != null) {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (connection != null) {
                    connection.close();
                    connection = null;
                }
            }
        }
        return bankCode;
    }

    public String executeSystemEvent(String tranID, UserInfoBean userInfo, String xtraParams) {
        BaseLogger.log((String)"3", null, null, (Object)("Inside isIntegrated method of BankIntegration class tranID gsb [" + tranID + "]"));
        String result = "";
        String eventCode = this.bankBean.getPayInitService();
        BaseLogger.log((String)"3", null, null, (Object)("Inside executeSystemEvent method of BankIntegration class eventCode [" + eventCode + "]"));
        tranID = "P2BPH0083";
        try {
            String xmlString = this.getDetailXMLDomString("misc_pay", "1", "V", tranID, null, userInfo);
            BaseLogger.log((String)"3", null, null, (Object)("Inside executeSystemEvent method of BankIntegration class xmlString [" + xmlString + "]"));
            EventManagerEJB eventManagerEJB = new EventManagerEJB();
            result = eventManagerEJB.executeSystemEvent("misc_pay", eventCode, xmlString, xmlString, xmlString, xtraParams, "1", userInfo);
        }
        catch (ibase.planner.utility.ITMException | ITMException | RemoteException e) {
            e.printStackTrace();
        }
        return result;
    }

    private String getDetailXMLDomString(String objName, String objContext, String editFlag, String pkValues, String argFieldValues, UserInfoBean userInfo) throws RemoteException, ITMException, ibase.planner.utility.ITMException {
        String resultString = "";
        MasterStatefulLocal masterStateful = null;
        try {
            try {
                masterStateful = (MasterStatefulLocal)this.getInitialContext().lookup("ibase/MasterStatefulEJB/local");
                int randInt = new Random().nextInt();
                masterStateful.setEditorId("" + randInt);
                masterStateful.setUserInfo(userInfo);
                resultString = masterStateful.getDetailXMLDomString(objName, objContext, editFlag, pkValues, argFieldValues);
            }
            catch (NamingException e) {
                BaseLogger.log((String)"0", null, null, (Object)("NamingException :: getDetailXMLDomString() :==>\n" + e.getMessage()));
                throw new ibase.planner.utility.ITMException((Exception)e);
            }
        }
        finally {
            if (masterStateful != null) {
                masterStateful.remove();
                masterStateful = null;
            }
        }
        return resultString;
    }

    private InitialContext getInitialContext() throws ibase.planner.utility.ITMException {
        InitialContext ctx = null;
        try {
            AppConnectParm appConnect = new AppConnectParm();
            ctx = new InitialContext(appConnect.getProperty());
        }
        catch (ibase.planner.utility.ITMException itme) {
            BaseLogger.log((String)"0", null, null, (Object)("ITMException : getInitialContext : " + itme.getMessage()));
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log((String)"0", null, null, (Object)("Exception : getInitialContext : " + e.getMessage()));
            throw new ibase.planner.utility.ITMException(e);
        }
        return ctx;
    }
}

