/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.utility;

import ibase.ai.entityid.AIEngine;
import ibase.ai.entityid.DocumentProcessTrail;
import ibase.ai.entityid.ItemLookUp;
import ibase.ai.entityid.RasaAIEngine;
import ibase.ai.entityid.WitAIEngine;
import ibase.hibernate.dao.DocTypeProcDAO;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.utility.APIUtility;
import ibase.webitm.utility.ITMException;
import java.io.File;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Map;
import org.json.JSONObject;

public class InvoiceReader {
    String templatePath;
    File invoiceFile;
    String docProcTrailData = "";
    private String procStatus = "I";

    public String getDocProcTrailData() {
        return this.docProcTrailData;
    }

    public void setDocProcTrailData(String docProcTrailData) {
        this.docProcTrailData = docProcTrailData;
    }

    public String getProcStatus() {
        return this.procStatus;
    }

    public void setProcStatus(String procStatus) {
        this.procStatus = procStatus;
    }

    public InvoiceReader(File invoiceFile) {
        this.invoiceFile = invoiceFile;
        String fileSeperator = File.separator;
        this.templatePath = String.valueOf(CommonConstants.getBIHOME()) + fileSeperator + "server" + fileSeperator + "default" + fileSeperator + "deploy" + fileSeperator + "ibase.ear" + fileSeperator + "ibase.war" + fileSeperator + "webitm" + fileSeperator + "InvoiceTemplate";
    }

    public String readInvoice(UserInfoBean userInfo, String extractTempl) throws ITMException {
        return this.readInvoice(userInfo, extractTempl, true);
    }

    public String readInvoice(UserInfoBean userInfo, String extractTempl, boolean itemCodeRequired) throws ITMException {
        return this.readInvoice(userInfo, extractTempl, true, "", "", "", "");
    }

    public String readInvoice(UserInfoBean userInfo, String extractTempl, boolean itemCodeRequired, String docType, String entType, String entCode, String objName) throws ITMException {
        E12GenericUtility genericUtility;
        DocumentProcessTrail docProcTrail;
        String currentReqParamTrail;
        String currentProcessMtd;
        JSONObject procTrailObj;
        ArrayList<Object> apiKeyParams;
        JSONObject docTypeProcObj;
        String procApiName;
        String procApiScope;
        String extData;
        block25: {
            BaseLogger.log("3", null, null, "InvoiceReader readInvoice() extractTempl[" + extractTempl + "],itemCodeRequired[" + itemCodeRequired + "]");
            extData = "";
            String procApiKey = "";
            procApiScope = "";
            procApiName = "";
            docTypeProcObj = new JSONObject();
            apiKeyParams = new ArrayList();
            procTrailObj = new JSONObject();
            currentProcessMtd = "";
            currentReqParamTrail = "";
            docProcTrail = new DocumentProcessTrail();
            genericUtility = new E12GenericUtility();
            if (this.invoiceFile.exists()) break block25;
            BaseLogger.log("3", null, null, "InvoiceReader readInvoice() file not exist");
            return "";
        }
        try {
            String dataExtractorService;
            String fileName = this.invoiceFile.getName();
            String fileType = fileName.substring(fileName.lastIndexOf(".") + 1);
            APIUtility apiUtility = new APIUtility();
            DocTypeProcDAO docTypeProcDAO = new DocTypeProcDAO();
            docTypeProcObj = docTypeProcDAO.getDocTypeProcParams(userInfo, docType, entType, entCode, fileType.toUpperCase());
            apiKeyParams = apiUtility.getAPIKey(userInfo, docTypeProcObj.optString("proc_mtd"));
            docTypeProcObj.put("extract_templ", (Object)extractTempl);
            docTypeProcObj.put("objName", (Object)objName);
            docTypeProcObj.put("userId", (Object)userInfo.getLoginCode());
            if (!apiKeyParams.isEmpty() && apiKeyParams.size() > 0) {
                docTypeProcObj.put("proc_api_key", apiKeyParams.get(0));
            }
            docTypeProcObj.put("IS_OCR_EXIST", (Object)"false");
            if (!apiKeyParams.isEmpty() && apiKeyParams.size() > 1) {
                procApiScope = (String)apiKeyParams.get(1);
            }
            procApiName = docTypeProcObj.optString("proc_mtd");
            String[] procMethods = procApiName.split("-");
            docTypeProcObj.put("file_type", (Object)fileType.toUpperCase());
            String apiUrl = dataExtractorService = this.getDataExtractorServiceURL();
            String reqParamsStr = docTypeProcObj.toString();
            reqParamsStr = URLEncoder.encode(reqParamsStr, "UTF-8");
            if (extractTempl.length() > 1) {
                dataExtractorService = String.valueOf(dataExtractorService) + "?jsonData=" + reqParamsStr;
            }
            BaseLogger.log("3", null, null, "InvoiceReader readInvoice() final dataExtractorService::" + dataExtractorService);
            currentProcessMtd = procMethods[0];
            currentReqParamTrail = "jsonData=" + reqParamsStr;
            BaseLogger.log("3", null, null, "171 makeMultipartRequest START [" + System.currentTimeMillis() + "]");
            byte[] response = E12GenericUtility.makeMultipartRequest(dataExtractorService, this.invoiceFile);
            BaseLogger.log("3", null, null, "173 makeMultipartRequest END [" + System.currentTimeMillis() + "]");
            String result = new String(response);
            JSONObject jsonObject = new JSONObject(result);
            BaseLogger.log("3", null, "InvoiceReader.readInvoice()", "jsonObject[" + jsonObject + "]");
            int status = jsonObject.getInt("status");
            apiUtility.writeApiCallLog(userInfo, result, "" + status, "", "", reqParamsStr, procApiName, apiUrl, procApiScope, "A", "", "");
            if (status == 1) {
                ItemLookUp itemLookup;
                JSONObject jsonItemCodes;
                AIEngine aiEngine;
                JSONObject extractedData = new JSONObject();
                extractedData = jsonObject.optJSONObject("result");
                String ocrData = "";
                if (extractedData.has("OCR_DATA")) {
                    ocrData = extractedData.optString("OCR_DATA");
                }
                procTrailObj.put(procMethods[0], (Object)docProcTrail.setProcTrailJSON(procApiName, ocrData, currentReqParamTrail, ""));
                String queryParamStr = "";
                if (procMethods.length > 1 && "AI".equalsIgnoreCase(procMethods[1])) {
                    JSONObject templateObj;
                    String isTempExtracted;
                    String templateData;
                    String csvData = extractedData.optString("EXTRACT_LAYOUT_DATA");
                    if (extractedData.has("EXTRACT_TEMPLATE_DATA") && !"false".equalsIgnoreCase(templateData = extractedData.optString("EXTRACT_TEMPLATE_DATA")) && !"".equalsIgnoreCase(templateData) && "true".equalsIgnoreCase(isTempExtracted = (templateObj = new JSONObject(templateData)).optString("isTemplateExtracted"))) {
                        String exEntCode = templateObj.optString("ent_code");
                        String exEntType = templateObj.optString("ent_type");
                        String exEntName = templateObj.optString("ent_name");
                        JSONObject exdocTypeProcObj = docTypeProcDAO.getDocTypeProcParams(userInfo, docType, exEntType, exEntCode, fileType.toUpperCase());
                        docTypeProcObj.put("ent_type", (Object)exEntType);
                        docTypeProcObj.put("ent_code", (Object)exEntCode);
                        docTypeProcObj.put("ent_name", (Object)exEntName);
                        docTypeProcObj.put("proc_mtd", (Object)exdocTypeProcObj.optString("proc_mtd"));
                        docTypeProcObj.put("proc_instr", (Object)exdocTypeProcObj.optString("proc_instr"));
                        docTypeProcObj.put("IS_OCR_EXIST", (Object)"true");
                        currentProcessMtd = "AI";
                        currentReqParamTrail = docTypeProcObj.toString();
                        docTypeProcObj.put("OCR_DATA", (Object)ocrData);
                        queryParamStr = docTypeProcObj.toString();
                        queryParamStr = URLEncoder.encode(queryParamStr, "UTF-8");
                        String dataExtractorServiceURL = String.valueOf(this.getDataExtractorServiceURL()) + "?jsonData=" + queryParamStr;
                        BaseLogger.log("3", null, null, "215 makeMultipartRequest START [" + System.currentTimeMillis() + "]");
                        byte[] byteResp = E12GenericUtility.makeMultipartRequest(dataExtractorServiceURL, this.invoiceFile);
                        BaseLogger.log("3", null, null, "217 makeMultipartRequest END [" + System.currentTimeMillis() + "]");
                        String pyResponse = new String(byteResp);
                        BaseLogger.log("3", null, null, "InvoiceReader.readInvoice() pyResponse [" + pyResponse + "]");
                        E12GenericUtility e12GenericUtility = new E12GenericUtility();
                        JSONObject exJSONObject = new JSONObject(pyResponse);
                        extractedData = exJSONObject.optJSONObject("result");
                        csvData = extractedData.optString("EXTRACT_LAYOUT_DATA");
                    }
                    procTrailObj.put("AI", (Object)docProcTrail.setProcTrailJSON(procApiName, csvData, currentReqParamTrail, ""));
                    extractedData = genericUtility.convertCSVToJSON(csvData, userInfo);
                    if (procMethods.length > 2 && E12GenericUtility.checkNull(procMethods[2]).equalsIgnoreCase("IL")) {
                        currentProcessMtd = "IL";
                        ItemLookUp itemLookup2 = new ItemLookUp();
                        extractedData = itemLookup2.itemCodeLookUp(extractedData, procMethods, userInfo);
                        procTrailObj.put("IL", (Object)docProcTrail.setProcTrailJSON(procApiName, extractedData.toString(), currentReqParamTrail, ""));
                    }
                    if ("UC".equalsIgnoreCase(procMethods[procMethods.length - 1])) {
                        procTrailObj.put("UC", (Object)docProcTrail.setProcTrailJSON(procApiName, extractedData.toString(), currentReqParamTrail, ""));
                    }
                } else {
                    extractedData = jsonObject.getJSONObject("result");
                }
                BaseLogger.log("3", null, null, "InvoiceReader.readInvoice() extractedData[" + extractedData + "]");
                String dataJsonStr = extractedData.toString();
                if (!itemCodeRequired) {
                    BaseLogger.log("3", null, null, "InvoiceReader.readInvoice() hanse itemcode not required returning dataJsonStr:: " + dataJsonStr + "]");
                    return dataJsonStr;
                }
                String AIEngineStr = CommonConstants.AI_ENGINE;
                BaseLogger.log("3", null, null, "postdata dataJsonStr[" + dataJsonStr + "]AIEngineStr[" + AIEngineStr + "]");
                if (procMethods.length > 2 && "ADW".equalsIgnoreCase(procMethods[2])) {
                    aiEngine = new WitAIEngine();
                    currentProcessMtd = "ADW";
                    result = ((WitAIEngine)aiEngine).getItemCodeList(dataJsonStr, userInfo);
                    currentReqParamTrail = ((WitAIEngine)aiEngine).getProcTrailObj().optString("REQUEST_PARAM");
                    procTrailObj.put("ADW", (Object)((WitAIEngine)aiEngine).getProcTrailObj());
                    BaseLogger.log("3", null, null, "readInvoice GET_ITEM_CODE_LIST WitAIEngine result[" + result + "]");
                    jsonItemCodes = new JSONObject(result);
                    jsonItemCodes = jsonItemCodes.getJSONObject("result");
                    jsonItemCodes = jsonItemCodes.getJSONObject("itemCodeList");
                    BaseLogger.log("3", null, null, "result jsonItemCodes[" + jsonItemCodes + "]");
                    extractedData.put("itemCodeList", (Object)jsonItemCodes);
                    if (procMethods.length > 3 && "IL".equalsIgnoreCase(procMethods[3])) {
                        itemLookup = new ItemLookUp();
                        extractedData = itemLookup.itemCodeLookUp(extractedData, procMethods, userInfo);
                        procTrailObj.put("IL", (Object)docProcTrail.setProcTrailJSON(procApiName, extractedData.toString(), currentReqParamTrail, ""));
                        if ("UC".equalsIgnoreCase(procMethods[procMethods.length - 1])) {
                            procTrailObj.put("UC", (Object)docProcTrail.setProcTrailJSON(procApiName, extractedData.toString(), currentReqParamTrail, ""));
                        }
                    }
                } else if (procMethods.length > 2 && "ADR".equalsIgnoreCase(procMethods[2])) {
                    aiEngine = new RasaAIEngine();
                    currentProcessMtd = "ADR";
                    result = ((RasaAIEngine)aiEngine).getItemCodeList(dataJsonStr, userInfo);
                    currentReqParamTrail = ((RasaAIEngine)aiEngine).getProcTrailObj().optString("REQUEST_PARAM");
                    jsonItemCodes = new JSONObject(result);
                    procTrailObj.put("ADR", (Object)((RasaAIEngine)aiEngine).getProcTrailObj());
                    BaseLogger.log("3", null, null, " rasa result jsonItemCodes[" + jsonItemCodes + "]");
                    extractedData.put("itemCodeList", (Object)jsonItemCodes);
                    if (procMethods.length > 3 && "IL".equalsIgnoreCase(procMethods[3])) {
                        itemLookup = new ItemLookUp();
                        extractedData = itemLookup.itemCodeLookUp(extractedData, procMethods, userInfo);
                        procTrailObj.put("IL", (Object)docProcTrail.setProcTrailJSON(procApiName, extractedData.toString(), currentReqParamTrail, ""));
                        if ("UC".equalsIgnoreCase(procMethods[procMethods.length - 1])) {
                            procTrailObj.put("UC", (Object)docProcTrail.setProcTrailJSON(procApiName, extractedData.toString(), currentReqParamTrail, ""));
                        }
                    }
                }
                if (docTypeProcObj != null) {
                    extractedData.put("doc_type", (Object)E12GenericUtility.checkNull(docTypeProcObj.optString("doc_type")));
                    extractedData.put("ent_type", (Object)E12GenericUtility.checkNull(docTypeProcObj.optString("ent_type")));
                    extractedData.put("ent_code", (Object)E12GenericUtility.checkNull(docTypeProcObj.optString("ent_code")));
                    extractedData.put("ent_name", (Object)E12GenericUtility.checkNull(docTypeProcObj.optString("ent_name")));
                    extractedData.put("file_type", (Object)E12GenericUtility.checkNull(docTypeProcObj.optString("file_type")));
                    extractedData.put("proc_mtd", (Object)E12GenericUtility.checkNull(docTypeProcObj.optString("proc_mtd")));
                    extractedData.put("proc_instr", (Object)E12GenericUtility.checkNull(docTypeProcObj.optString("proc_instr")));
                }
                this.setProcStatus("C");
                extData = String.valueOf(extractedData);
            } else {
                procTrailObj.put(procMethods[0], (Object)docProcTrail.setProcTrailJSON(procApiName, "", currentReqParamTrail, result));
                this.setProcStatus("E");
                BaseLogger.log("3", null, "InvoiceReader.readInvoice()", "Error occurred while extracting data [" + jsonObject.get("error") + "]");
            }
        }
        catch (Exception ex) {
            try {
                procTrailObj.put(currentProcessMtd, (Object)docProcTrail.setProcTrailJSON(procApiName, "", currentReqParamTrail, genericUtility.writePrintStacktrace(ex)));
            }
            catch (Exception exception) {
                // empty catch block
            }
            extData = "";
            this.setProcStatus("E");
            BaseLogger.log("0", null, "InvoiceReader.readInvoice()", "Exception in readInvoice : " + ex);
        }
        this.setDocProcTrailData(procTrailObj.toString());
        BaseLogger.log("3", null, "InvoiceReader.readInvoice()", "Extracted data : [" + extData + "]");
        return extData;
    }

    public String getDataExtractorServiceURL() {
        String dataExtractorServiceURL = null;
        Map<String, Map<String, String>> pythonServicesMap = CommonConstants.EXTRACTION_PYTHON_SERVICES;
        BaseLogger.log("3", null, null, "InvoiceReader readInvoice() getDataExtractorServiceURL pythonServicesMap::" + pythonServicesMap);
        if (pythonServicesMap != null) {
            Map<String, String> proteusSenseServiceDetails = pythonServicesMap.get("DATA_EXTRACTOR");
            String protocol = proteusSenseServiceDetails.get("PROTOCOL");
            String host = proteusSenseServiceDetails.get("HOST");
            String port = E12GenericUtility.checkNull(proteusSenseServiceDetails.get("PORT"));
            String path = proteusSenseServiceDetails.get("ENDPOINT");
            dataExtractorServiceURL = String.format("%s://%s%s/%s", protocol, host, port, path);
        }
        return dataExtractorServiceURL;
    }
}

