/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.ejb;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import ibase.scheduler.ejb.BaseRegisteredEJB;
import ibase.scheduler.utility.interfaces.Schedule;
import ibase.system.config.ConnDriver;
import ibase.system.config.nosql.NoSQLConnDriver;
import ibase.system.config.resource.NoSQLConnection;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.EMail;
import ibase.utility.MongoDBHandler;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.ejb.ITMUploadFileLocal;
import ibase.webitm.ejb.ITMUploadFileRemote;
import ibase.webitm.ejb.MasterApplyEJB;
import ibase.webitm.ejb.Messages;
import ibase.webitm.ejb.UploadFileEJB;
import ibase.webitm.utility.ITMException;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.Vector;
import javax.annotation.PostConstruct;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.bson.types.ObjectId;
import org.json.JSONException;
import org.json.JSONObject;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Stateless
public class ITMUploadFileEJB
extends BaseRegisteredEJB
implements ITMUploadFileRemote,
ITMUploadFileLocal,
Schedule {
    public String globalTranID = "";
    private E12GenericUtility genericUtility = new E12GenericUtility();
    private DBAccessEJB dbAccess = null;
    private File DUMP_DIR = null;
    protected UserInfoBean userInfo = null;
    private boolean IS_FTP_PATH = false;
    private String FILE_UPLOAD_SRC_PATH = "";
    private String FILE_UPLOAD_REJ_PATH = "";
    private String FILE_UPLOAD_SUCC_PATH = "";
    private String FILE_UPLOAD_LOG_PATH = "";
    private String FTP_HOST_URL = "";
    private String ftpUserName = "";
    private String ftpPassword = "";
    private FTPClient ftpClient = null;
    private boolean IS_SFTP_PATH = false;
    private String fileUploadPort = "";
    private ChannelSftp sftpChannel = null;
    private Session session = null;
    private String mailAddr = "";
    private String commonUploadFailedFilePath = "";
    private String commonUploadSuccessFilePath = "";
    private HashMap<String, MasterApplyEJB> objWiseMasterApplyMap = new HashMap();

    public void setSessionContext(SessionContext sessionContext) {
    }

    public ITMUploadFileEJB() {
        try {
            this.setDefaultParms();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @PostConstruct
    public void ejbCreate() {
        try {
            this.setDefaultParms();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void ejbActivate() {
    }

    public void ejbPassivate() {
    }

    public void ejbRemove() {
    }

    private void setDefaultParms() {
        this.IS_FTP_PATH = false;
        this.FILE_UPLOAD_SRC_PATH = "";
        this.FILE_UPLOAD_REJ_PATH = "";
        this.FILE_UPLOAD_SUCC_PATH = "";
        this.FILE_UPLOAD_LOG_PATH = "";
        this.FTP_HOST_URL = "";
        this.ftpUserName = "";
        this.ftpPassword = "";
        this.ftpClient = null;
        this.userInfo = null;
        this.mailAddr = "";
        this.fileUploadPort = "";
        this.IS_SFTP_PATH = false;
        this.DUMP_DIR = this.FILE_UPLOAD_SRC_PATH.length() > 0 ? new File("" + new File(this.FILE_UPLOAD_SRC_PATH)) : new File(new File(CommonConstants.UPLOAD_LOC) + File.separator + "dump");
        BaseLogger.log("3", this.userInfo, null, "DUMP_DIR : [" + this.DUMP_DIR + "]");
        if (!this.DUMP_DIR.exists()) {
            this.DUMP_DIR.mkdirs();
        }
        this.commonUploadFailedFilePath = new File(CommonConstants.UPLOAD_LOC) + File.separator + "upload_failed";
        this.commonUploadSuccessFilePath = new File(CommonConstants.UPLOAD_LOC) + File.separator + "upload_success";
    }

    @Override
    public String schedule(HashMap map) throws RemoteException, ITMException {
        return "";
    }

    @Override
    public String schedulePriority(String wrkflwPriority) throws RemoteException, ITMException {
        return this.schedule("");
    }

    @Override
    public String schedule(String scheduleParamXML) throws RemoteException, ITMException {
        try {
            try {
                UserInfoBean userInfo;
                BaseLogger.log("3", this.userInfo, null, "scheduleParamXML [" + scheduleParamXML + "]");
                Document paramDom = this.genericUtility.parseString(scheduleParamXML);
                String userInfoList = this.genericUtility.serializeDom(paramDom.getElementsByTagName("USERINFOXML").item(0).getChildNodes().item(0));
                this.userInfo = userInfo = new UserInfoBean(userInfoList);
                this.setEnterpriseWiseUploadPath(userInfo);
                if (this.FILE_UPLOAD_SRC_PATH.length() > 0) {
                    this.DUMP_DIR = this.IS_FTP_PATH || this.IS_SFTP_PATH ? new File(new File(CommonConstants.UPLOAD_LOC) + File.separator + "dump") : new File("" + new File(this.FILE_UPLOAD_SRC_PATH));
                    if (!this.DUMP_DIR.exists()) {
                        this.DUMP_DIR.mkdirs();
                    }
                }
                NodeList paramList = paramDom.getElementsByTagName("ACTUALPARAMETER");
                String userInfoStr = "";
                String newFileName = "";
                String isIntractive = "";
                String objName = "";
                String oriFileName = "";
                String appId = "";
                boolean isExcelDriver = false;
                boolean isRetainPkValue = false;
                String templateName = "";
                int noOfParam = paramList.getLength();
                int paramCnt = 0;
                while (paramCnt < noOfParam) {
                    String value = paramList.item(paramCnt).getFirstChild().getNodeValue();
                    String string = value = value == null || value.length() == 0 || value.equalsIgnoreCase("null") ? "" : value;
                    if (paramCnt == 0) {
                        userInfoStr = value;
                    } else if (paramCnt == 1) {
                        newFileName = value;
                    } else if (paramCnt == 2) {
                        isIntractive = value;
                    } else if (paramCnt == 3) {
                        objName = value;
                    } else if (paramCnt == 4) {
                        oriFileName = value;
                    } else if (paramCnt == 6) {
                        if (value.length() == 0) {
                            value = "false";
                        }
                        isExcelDriver = Boolean.valueOf(value);
                    } else if (paramCnt == 7) {
                        templateName = value;
                    } else if (paramCnt == 8) {
                        appId = value;
                    } else if (paramCnt == 9) {
                        if (value.length() == 0) {
                            value = "false";
                        }
                        isRetainPkValue = Boolean.valueOf(value);
                    }
                    ++paramCnt;
                }
                BaseLogger.log("3", userInfo, null, "userInfoStr [" + userInfoStr + "]");
                BaseLogger.log("3", userInfo, null, "newFileName [" + newFileName + "]");
                BaseLogger.log("3", userInfo, null, "isIntractive [" + isIntractive + "]");
                BaseLogger.log("3", userInfo, null, "objName [" + objName + "]");
                BaseLogger.log("3", userInfo, null, "oriFileName [" + oriFileName + "]");
                BaseLogger.log("3", userInfo, null, "isExcelDriver [" + isExcelDriver + "]");
                BaseLogger.log("3", userInfo, null, "templateName [" + templateName + "]");
                BaseLogger.log("3", userInfo, null, "appId [" + appId + "]");
                BaseLogger.log("3", userInfo, null, "isRetainPkValue [" + isRetainPkValue + "]");
                if ("EDI_BATCHLOAD".equalsIgnoreCase(newFileName)) {
                    String[] fileInfoArr = new String[]{isIntractive, newFileName, objName, oriFileName, templateName, appId, "" + isRetainPkValue};
                    this.processEDIBatchload(fileInfoArr);
                } else {
                    if (newFileName != null && newFileName.trim().length() > 0) {
                        if (new File(newFileName).isAbsolute()) {
                            this.DUMP_DIR = new File(newFileName);
                        } else if (newFileName.indexOf(".") == 0) {
                            this.DUMP_DIR = this.FILE_UPLOAD_SRC_PATH.length() > 0 && !this.IS_FTP_PATH && !this.IS_SFTP_PATH ? new File(new File(this.FILE_UPLOAD_SRC_PATH) + File.separator + new File(newFileName)) : new File(new File(CommonConstants.DUMP_DIR) + File.separator + new File(newFileName));
                        }
                    }
                    if (this.IS_FTP_PATH) {
                        this.readFilesByFTP(this.DUMP_DIR, userInfo, isIntractive, objName, oriFileName, isExcelDriver, isRetainPkValue);
                    } else if (this.IS_SFTP_PATH) {
                        this.readFilesBySFTP(this.DUMP_DIR, userInfo, isIntractive, objName, oriFileName, isExcelDriver, isRetainPkValue);
                    } else if (newFileName != null && newFileName.indexOf(".") > 0) {
                        String[] fileInfoArr = new String[]{isIntractive, newFileName, objName, oriFileName, templateName};
                        this.insertFileData(fileInfoArr, userInfo, this.DUMP_DIR, CommonConstants.APPLICATION_CONTEXT, "", isExcelDriver, isRetainPkValue);
                    } else {
                        String[] fileList = this.DUMP_DIR.list();
                        int fileCtr = 0;
                        while (fileCtr < fileList.length) {
                            String directoryFileName = fileList[fileCtr];
                            BaseLogger.log("3", userInfo, null, "directoryFileName [" + directoryFileName + "]");
                            if (new File(this.DUMP_DIR + File.separator + new File(directoryFileName)).isDirectory()) {
                                BaseLogger.log("3", userInfo, null, "The UploadedFile [" + directoryFileName + "] is Directory");
                            } else {
                                String[] fileInfoArr = new String[]{isIntractive, directoryFileName, objName, oriFileName, templateName};
                                this.insertFileData(fileInfoArr, userInfo, this.DUMP_DIR, CommonConstants.APPLICATION_CONTEXT, "", isExcelDriver, isRetainPkValue);
                            }
                            ++fileCtr;
                        }
                    }
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", this.userInfo, null, "UploadFileEJB :==>Schedule");
                e.printStackTrace();
                try {
                    if (this.ftpClient != null) {
                        this.ftpClient.logout();
                        this.ftpClient.disconnect();
                    }
                    if (this.sftpChannel != null) {
                        this.sftpChannel.exit();
                        this.session.disconnect();
                    }
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (this.ftpClient != null) {
                    this.ftpClient.logout();
                    this.ftpClient.disconnect();
                }
                if (this.sftpChannel != null) {
                    this.sftpChannel.exit();
                    this.session.disconnect();
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        return "";
    }

    @Override
    public String insertFileData(String[] fileInfoArr, UserInfoBean userInfo, File DUMP_DIR, String applicationContext, String menuObjName, boolean isExcelDriver) throws RemoteException, ITMException {
        return this.insertFileData(fileInfoArr, userInfo, DUMP_DIR, applicationContext, menuObjName, isExcelDriver, true);
    }

    @Override
    public String insertFileData(String[] fileInfoArr, UserInfoBean userInfo, File DUMP_DIR, String applicationContext, String menuObjName, boolean isExcelDriver, boolean isRetainPkValue) throws RemoteException, ITMException {
        return this.insertFileData(fileInfoArr, userInfo, DUMP_DIR, applicationContext, menuObjName, isExcelDriver, isRetainPkValue, null, 1);
    }

    /*
     * Exception decompiling
     */
    public String insertFileData(String[] fileInfoArr, UserInfoBean userInfo, File DUMP_DIR, String applicationContext, String menuObjName, boolean isExcelDriver, boolean isRetainPkValue, String batchID, int tranSl) throws RemoteException, ITMException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK], 0[TRYBLOCK], 18[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String getDetailXmlString(String filePath, HashMap<String, String> keyDetailMap) {
        String xmlString = "<Root>";
        try {
            StringBuilder strBuilder = new StringBuilder("<Root>");
            System.out.println("file path=" + filePath);
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = documentBuilder.parse(filePath);
            NodeList rootNodeList = document.getChildNodes();
            Node rootNode = rootNodeList.item(0);
            NodeList rootChildList = rootNode.getChildNodes();
            BaseLogger.log("0", this.userInfo, null, "Root Node List Length==>" + rootChildList.getLength());
            HashMap nodeMap = new HashMap();
            int i = 0;
            while (i < rootChildList.getLength()) {
                Node rootChild = rootChildList.item(i);
                if (!rootChild.getNodeName().contains("#")) {
                    if (nodeMap.containsKey(rootChild.getNodeName())) {
                        ((List)nodeMap.get(rootChild.getNodeName())).add(rootChild);
                    } else {
                        nodeMap.put(rootChild.getNodeName(), new ArrayList());
                        ((List)nodeMap.get(rootChild.getNodeName())).add(rootChild);
                    }
                }
                ++i;
            }
            BaseLogger.log("0", this.userInfo, null, "Key Details Map=" + keyDetailMap);
            BaseLogger.log("0", this.userInfo, null, "Node Map=" + nodeMap);
            for (Map.Entry<String, String> entry : keyDetailMap.entrySet()) {
                BaseLogger.log("0", this.userInfo, null, "Key found in Map=" + entry.getKey());
                BaseLogger.log("0", this.userInfo, null, "value found in Map=" + entry.getValue());
                Object childNode = null;
                if (entry.getKey().equals("") && entry.getKey() == null && entry.getKey().equals(null) || !nodeMap.containsKey(entry.getKey())) continue;
                List childNodeList = (List)nodeMap.get(entry.getKey());
                int i2 = 0;
                while (i2 < childNodeList.size()) {
                    Node rowNode = (Node)childNodeList.get(i2);
                    BaseLogger.log("0", this.userInfo, null, "Row  Node Name=" + rowNode.getNodeName());
                    if (!rowNode.getNodeName().contains("#")) {
                        NodeList dataNodes = rowNode.getChildNodes();
                        int k = 0;
                        while (k < dataNodes.getLength()) {
                            Node data = dataNodes.item(k);
                            if (!data.getNodeName().contains("#")) {
                                strBuilder.append("<" + data.getNodeName() + "><![CDATA[" + data.getTextContent() + "]]>" + "</" + data.getNodeName() + ">");
                            }
                            ++k;
                        }
                        strBuilder.append("</" + entry.getValue() + ">");
                    }
                    ++i2;
                }
            }
            strBuilder.append("</Root>");
            System.out.println("String to return=with cdata[" + strBuilder.toString());
            BaseLogger.log("0", this.userInfo, null, "xmlString=[" + xmlString + "]");
            xmlString = strBuilder.toString();
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception in Reading xml file" + e.getMessage());
        }
        return xmlString;
    }

    private String getUploadDataDBId(String uploadData) {
        String dbId = "";
        try {
            Document uploadDataDom = this.genericUtility.parseString(uploadData);
            Node parentNode = uploadDataDom.getElementsByTagName("Detail1").item(0);
            if (parentNode != null && parentNode.getAttributes().getNamedItem("dbID") != null) {
                dbId = parentNode.getAttributes().getNamedItem("dbID").getNodeValue();
            }
        }
        catch (ITMException e) {
            BaseLogger.log("3", null, null, "Exception in getUploadDataDBId [" + E12GenericUtility.getStackTrace(e) + "]");
        }
        catch (DOMException e) {
            BaseLogger.log("3", null, null, "Exception in getUploadDataDBId [" + E12GenericUtility.getStackTrace(e) + "]");
        }
        BaseLogger.log("2", this.userInfo, null, "dbId : [" + dbId + "]");
        return dbId;
    }

    private MasterApplyEJB getMasterApplyEJB(String objName, UserInfoBean userInfo) {
        MasterApplyEJB masterApply = null;
        if (this.objWiseMasterApplyMap.containsKey(objName)) {
            masterApply = this.objWiseMasterApplyMap.get(objName);
        }
        if (masterApply == null) {
            masterApply = new MasterApplyEJB();
            masterApply.setObjFormDetail(objName, userInfo);
            this.objWiseMasterApplyMap.put(objName, masterApply);
        }
        return masterApply;
    }

    private String generateUploadResponse(String objName, String responseStr, String tempFileName, String batchId, int rowNo, String excelDataDBId, String xmlStr, Connection conn, MasterApplyEJB masterApplyEJB) throws ITMException {
        StringBuffer responseHTMLBuff = new StringBuffer();
        try {
            if (masterApplyEJB == null) {
                masterApplyEJB = new MasterApplyEJB();
            }
            String dataDumpFolderName = "XLS_UPLOAD";
            if (tempFileName.endsWith(".json")) {
                dataDumpFolderName = "JSON_UPLOAD";
            }
            String uploadedFilePath = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + dataDumpFolderName + File.separator + this.getUserInfoBean().getLoginCode() + File.separator + batchId;
            String uploadFileName = String.valueOf(batchId) + "_" + rowNo + ".xml";
            responseHTMLBuff.append("<TR>");
            Document responseDom = this.genericUtility.parseString(responseStr);
            Node errorsNode = null;
            if (responseDom != null && responseDom.getElementsByTagName("Errors") != null) {
                errorsNode = responseDom.getElementsByTagName("Errors").item(0);
            }
            BaseLogger.log("3", this.userInfo, null, "errorsNode [" + errorsNode + "]");
            if (errorsNode != null) {
                if (conn != null) {
                    BaseLogger.log("3", this.userInfo, null, "Rollback the Changes when error found......");
                    conn.rollback();
                }
                String errorMessage = "";
                String msg = "";
                String descr = "";
                String trace = "";
                String redirect = "";
                NodeList errorChildNodeList = errorsNode.getChildNodes();
                int appCnt = 0;
                while (appCnt < errorChildNodeList.getLength()) {
                    String errCode = "";
                    String errorType = "";
                    String columnName = "";
                    Node currChild = errorChildNodeList.item(appCnt);
                    if (currChild.getNodeName().equalsIgnoreCase("error")) {
                        errorType = currChild.getAttributes().getNamedItem("type").getNodeValue();
                        if (currChild.getAttributes().getNamedItem("column_name") != null) {
                            columnName = currChild.getAttributes().getNamedItem("column_name").getNodeValue();
                        }
                        errCode = currChild.getAttributes().getNamedItem("id") == null ? "" : currChild.getAttributes().getNamedItem("id").getNodeValue();
                        StringBuffer responseHTML = new StringBuffer();
                        NodeList currChildList = currChild.getChildNodes();
                        int ctr = 0;
                        while (ctr < currChildList.getLength()) {
                            Node currNode = currChildList.item(ctr);
                            if (currNode.getNodeName().equalsIgnoreCase("message") && currNode.getFirstChild() != null) {
                                msg = currNode.getFirstChild().getNodeValue();
                            } else if (currNode.getNodeName().equalsIgnoreCase("description") && currNode.getFirstChild() != null) {
                                String descrAppendStr = "";
                                descr = currNode.getFirstChild().getNodeValue().trim();
                                if (descr.endsWith("]")) {
                                    descr = descr.replaceAll(descr.substring(descr.lastIndexOf("]") - 1), String.valueOf(new Integer(rowNo).toString()) + "]");
                                } else {
                                    descrAppendStr = " Error occurred on insertion of record no. :[" + rowNo + "]";
                                }
                                responseHTML.append("<b>" + Messages.getString("ITMUploadFileEJB_description") + "</b>" + descr + descrAppendStr);
                            } else if (currNode.getNodeName().equalsIgnoreCase("trace") && currNode.getFirstChild() != null) {
                                trace = currNode.getFirstChild().getNodeValue();
                                responseHTML.append("</br><b>" + Messages.getString("ITMUploadFileEJB_trace") + "</b>" + trace);
                            } else if (currNode.getNodeName().equalsIgnoreCase("redirect") && currNode.getFirstChild() != null) {
                                redirect = currNode.getFirstChild().getNodeValue();
                            }
                            ++ctr;
                        }
                        if (errCode != null && errCode.length() > 0) {
                            if ((errorMessage = String.valueOf(errorMessage) + errorType + ":" + errCode + ":" + descr + ": trace: " + trace + "\n").length() > 2000) {
                                errorMessage = errorMessage.substring(0, 2000);
                            }
                        } else {
                            errorMessage = String.valueOf(errorMessage) + errorType + ":" + descr + "\n";
                        }
                        responseHTMLBuff.append("<TD WIDTH=4%>" + rowNo + "</TD>");
                        if ("P".equalsIgnoreCase(errorType)) {
                            responseHTMLBuff.append("<TD WIDTH=48%>" + Messages.getString("ITMUploadFileEJB_recordNo") + rowNo + Messages.getString("ITMUploadFileEJB_successUploaded") + "</TD>");
                            responseHTMLBuff.append("<TD WIDTH=48% VALIGN=TOP><P><FONT SIZE=1 STYLE='font-size: 10pt'>");
                            responseHTMLBuff.append("</FONT></P>");
                            responseHTMLBuff.append("</TD>");
                        } else {
                            responseHTMLBuff.append("<TD WIDTH=48%>" + Messages.getString("ITMUploadFileEJB_recoreNotUploaded") + "</TD>");
                            responseHTMLBuff.append("<TD WIDTH=48% VALIGN=TOP><P><FONT SIZE=1 STYLE='font-size: 10pt'>");
                            responseHTMLBuff.append(String.valueOf(Messages.getString("ITMUploadFileEJB_errorForColumnName")) + columnName + "</br>");
                            responseHTMLBuff.append(responseHTML);
                            responseHTMLBuff.append("</FONT></P>");
                            responseHTMLBuff.append("</TD>");
                        }
                    }
                    ++appCnt;
                }
                if (errorMessage != null && errorMessage.endsWith("\n")) {
                    errorMessage = errorMessage.substring(0, errorMessage.length() - 1);
                }
                String uploadLogFileName = String.valueOf(batchId) + "_" + rowNo + ".log";
                String logFilePath = String.valueOf(uploadedFilePath) + File.separator + "log";
                this.writeLog(uploadLogFileName, logFilePath, null, responseStr);
                String errorFilePath = String.valueOf(uploadedFilePath) + File.separator + "failed";
                this.moveFile(uploadFileName, uploadedFilePath, errorFilePath, null);
                masterApplyEJB.updateBatchLoad(batchId, rowNo, errorMessage, "E", excelDataDBId, conn, this.userInfo);
                this.sendNotification("E", objName, batchId, "" + rowNo, excelDataDBId, xmlStr, errorMessage, conn);
            } else {
                String tranId;
                this.globalTranID = tranId = this.genericUtility.getColumnValue("TranID", responseDom);
                BaseLogger.log("3", this.userInfo, null, "tranId.......[" + tranId + "]");
                responseHTMLBuff.append("<TD WIDTH=4%>" + rowNo + "</TD>");
                responseHTMLBuff.append("<TD WIDTH=48%>" + tranId + "</TD>");
                responseHTMLBuff.append("<TD WIDTH=48%>");
                responseHTMLBuff.append("<P>" + Messages.getString("ITMUploadFileEJB_recordNo") + rowNo + Messages.getString("ITMUploadFileEJB_successfullyUploaded") + "</P>");
                responseHTMLBuff.append("</TD>");
                String successFilePath = String.valueOf(uploadedFilePath) + File.separator + "success";
                this.moveFile(uploadFileName, uploadedFilePath, successFilePath, null);
                masterApplyEJB.updateBatchLoad(batchId, rowNo, "Uploaded successfully", "Y", tranId, conn, this.userInfo);
            }
            responseHTMLBuff.append("</TR>");
        }
        catch (ITMException e) {
            masterApplyEJB.updateBatchLoad(batchId, rowNo, "E", "", null, this.getUserInfoBean());
            BaseLogger.log("3", null, null, "Exception2 in processEDIBatchload [" + E12GenericUtility.getStackTrace(e) + "]");
            throw new ITMException(e);
        }
        catch (DOMException e) {
            masterApplyEJB.updateBatchLoad(batchId, rowNo, "E", "", null, this.getUserInfoBean());
            BaseLogger.log("3", null, null, "Exception2 in processEDIBatchload [" + E12GenericUtility.getStackTrace(e) + "]");
            throw new ITMException(e);
        }
        catch (SQLException e) {
            masterApplyEJB.updateBatchLoad(batchId, rowNo, "E", "", null, this.getUserInfoBean());
            BaseLogger.log("3", null, null, "Exception2 in processEDIBatchload [" + E12GenericUtility.getStackTrace(e) + "]");
            throw new ITMException(e);
        }
        return responseHTMLBuff.toString();
    }

    private String checkNull(String input) {
        if (input == null) {
            input = "";
        }
        return input;
    }

    private void createUploadLog(String errStr, String fileName) throws RemoteException, ITMException {
        try {
            BaseLogger.log("3", this.userInfo, null, "fileName [" + fileName + "]");
            String logFileName = fileName.substring(0, fileName.indexOf("."));
            String logFile = String.valueOf(System.currentTimeMillis()) + "_" + this.userInfo.getLoginCode() + "_" + logFileName + ".log";
            String commonDestinationFilePath = new File(CommonConstants.UPLOAD_LOC) + File.separator + "upload_log";
            String destinationFilePath = "";
            if (this.FILE_UPLOAD_LOG_PATH.length() > 0) {
                if (this.IS_FTP_PATH || this.IS_SFTP_PATH) {
                    this.moveLogFileOnRemote(this.FILE_UPLOAD_LOG_PATH, logFile, errStr);
                    return;
                }
                destinationFilePath = "" + new File(this.FILE_UPLOAD_LOG_PATH);
            } else {
                destinationFilePath = commonDestinationFilePath;
            }
            this.writeLog(logFile, destinationFilePath, commonDestinationFilePath, errStr);
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "ITMException :UploadFileEJB :==>createUploadLog[" + e.getMessage());
            e.printStackTrace();
            throw new ITMException(e);
        }
    }

    private void writeLog(String logFile, String destinationFilePath, String commonDestinationFilePath, String logData) throws ITMException {
        try {
            BaseLogger.log("3", this.userInfo, null, "logFile [" + logFile + "]");
            BaseLogger.log("3", this.userInfo, null, "destinationFilePath [" + destinationFilePath + "]");
            BaseLogger.log("3", this.userInfo, null, "commonDestinationFilePath [" + commonDestinationFilePath + "]");
            File dir = new File(destinationFilePath);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            BaseLogger.log("3", this.userInfo, null, "dir[" + dir + "]");
            dir = new File(destinationFilePath);
            if (!dir.exists()) {
                BaseLogger.log("3", this.userInfo, null, "Destination File Path not exist........");
                if (commonDestinationFilePath != null) {
                    dir = new File(commonDestinationFilePath);
                    if (!dir.exists()) {
                        dir.mkdirs();
                    }
                    BaseLogger.log("3", this.userInfo, null, "set to common log dir[" + dir + "]");
                }
            }
            FileWriter fstream = new FileWriter(dir + File.separator + logFile);
            BufferedWriter out = new BufferedWriter(fstream);
            out.write(logData);
            out.flush();
            out.close();
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "ITMException :UploadFileEJB :==>createUploadLog[" + e.getMessage());
            e.printStackTrace();
            throw new ITMException(e);
        }
    }

    @Override
    public void moveUploadFile(String newFileName, File DUMP_DIR) throws RemoteException, ITMException {
        BaseLogger.log("2", this.userInfo, null, "Enter in moveUploadFile function .........[" + newFileName + "]");
        try {
            String destinationFilePath = "";
            if (this.FILE_UPLOAD_SUCC_PATH.length() > 0) {
                if (this.IS_FTP_PATH) {
                    this.moveFileOnRemote(DUMP_DIR, this.FILE_UPLOAD_SUCC_PATH, newFileName);
                    return;
                }
                if (this.IS_SFTP_PATH) {
                    this.uploadFileSFTP(DUMP_DIR, this.FILE_UPLOAD_SUCC_PATH, newFileName);
                    return;
                }
                destinationFilePath = "" + new File(this.FILE_UPLOAD_SUCC_PATH);
            } else {
                destinationFilePath = this.commonUploadSuccessFilePath;
            }
            this.moveFile(newFileName, DUMP_DIR.getAbsolutePath(), destinationFilePath, this.commonUploadSuccessFilePath);
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception :UploadFileEJB : deleteUploadFile :==>\n" + e.getMessage());
            e.printStackTrace();
        }
    }

    private void moveErrorFile(String newFileName, File DUMP_DIR) throws RemoteException, ITMException {
        BaseLogger.log("2", this.userInfo, null, "Eneter in moveUploadFile function .........[" + newFileName + "]");
        try {
            String destinationFilePath = "";
            if (this.FILE_UPLOAD_REJ_PATH.length() > 0) {
                if (this.IS_FTP_PATH) {
                    this.moveFileOnRemote(DUMP_DIR, this.FILE_UPLOAD_REJ_PATH, newFileName);
                    return;
                }
                if (this.IS_SFTP_PATH) {
                    this.uploadFileSFTP(DUMP_DIR, this.FILE_UPLOAD_REJ_PATH, newFileName);
                    return;
                }
                destinationFilePath = "" + new File(this.FILE_UPLOAD_REJ_PATH);
            } else {
                destinationFilePath = this.commonUploadFailedFilePath;
            }
            this.moveFile(newFileName, DUMP_DIR.getAbsolutePath(), destinationFilePath, this.commonUploadFailedFilePath);
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception : ITMUploadFileEJB : moveErrorFile :==>\n" + e.getMessage());
            e.printStackTrace();
        }
    }

    private void moveFile(String newFileName, String sourceFilePathDir, String destinationFilePath, String commonDestinationFilePath) throws ITMException {
        String sourceFilePath = String.valueOf(sourceFilePathDir) + File.separator + newFileName;
        BaseLogger.log("3", this.userInfo, null, "sourceFilePath [" + sourceFilePath + "]");
        BaseLogger.log("3", this.userInfo, null, "destinationFilePath [" + destinationFilePath + "]");
        BaseLogger.log("3", this.userInfo, null, "commonDestinationFilePath [" + commonDestinationFilePath + "]");
        File file = new File(sourceFilePath);
        if (file.exists()) {
            boolean success;
            BaseLogger.log("3", this.userInfo, null, "File Exist........");
            File dir = new File(destinationFilePath);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            BaseLogger.log("3", this.userInfo, null, "dir[" + dir + "]");
            dir = new File(destinationFilePath);
            if (!dir.exists()) {
                BaseLogger.log("3", this.userInfo, null, "Destination File Path not exist........");
                if (commonDestinationFilePath != null) {
                    dir = new File(commonDestinationFilePath);
                    if (!dir.exists()) {
                        dir.mkdirs();
                    }
                    BaseLogger.log("3", this.userInfo, null, "moved to common failed dir[" + dir + "]");
                }
            }
            if (!(success = file.renameTo(new File(dir, file.getName())))) {
                BaseLogger.log("3", this.userInfo, null, "File was not moved");
            }
        } else {
            BaseLogger.log("3", this.userInfo, null, "File not exist to move");
        }
    }

    private String getXtraParams(UserInfoBean userInfo) throws Exception {
        String XTRA_PARAMS_SEPARATOR = "~~";
        StringBuffer xtraParamsBuff = new StringBuffer();
        xtraParamsBuff.append("loginCode=" + userInfo.getLoginCode());
        xtraParamsBuff.append("~~").append("loginEmpCode=" + userInfo.getEmpCode());
        xtraParamsBuff.append("~~").append("loginSiteCode=" + userInfo.getSiteCode());
        xtraParamsBuff.append("~~").append("entityCode=" + userInfo.getEntityCode());
        xtraParamsBuff.append("~~").append("profileId=" + userInfo.getProfileId());
        xtraParamsBuff.append("~~").append("userType=" + userInfo.getUserType());
        xtraParamsBuff.append("~~").append("runMode=I");
        xtraParamsBuff.append("~~").append("termId=" + userInfo.getRemoteHost());
        String chgTerm = userInfo.getRemoteHostName();
        if (chgTerm != null && chgTerm.length() > 15) {
            chgTerm = chgTerm.substring(0, 15);
        } else if (chgTerm == null || chgTerm.length() == 0) {
            chgTerm = userInfo.getRemoteHost();
        }
        xtraParamsBuff.append("~~").append("chgTerm=" + chgTerm);
        return xtraParamsBuff.toString();
    }

    public UserInfoBean getUserInfoBean() {
        return this.userInfo;
    }

    public void setUserInfoBean(UserInfoBean userInfoBean) {
        this.userInfo = userInfoBean;
    }

    private DBAccessEJB getDBAccess() {
        try {
            if (this.dbAccess == null) {
                this.dbAccess = new DBAccessEJB();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.dbAccess;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setEnterpriseWiseUploadPath(UserInfoBean userInfo) throws Exception {
        String enterpriseValue = E12GenericUtility.checkNull(userInfo.getEnterprise());
        BaseLogger.log("2", userInfo, null, "enterpriseValue ; [" + enterpriseValue + "]");
        if (enterpriseValue.length() > 0) {
            Connection conn = null;
            Statement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    ConnDriver connDriver = new ConnDriver();
                    String transDB = userInfo.getTransDB();
                    conn = connDriver.getConnectDB(transDB);
                    connDriver = null;
                    String sql = "SELECT FILE_UPLOAD_SRC,FILE_UPLOAD_REJ,FILE_UPLOAD_SUC, FILE_UPLOAD_LOG,FILE_UPLOAD_USER,FILE_UPLOAD_PASS,FILE_UPLOAD_HOST,FILE_UPLOAD_PORT  FROM ENTERPRISE  WHERE TRIM( ENTERPRISE ) = ?";
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setString(1, enterpriseValue);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        this.FTP_HOST_URL = E12GenericUtility.checkNull(rs.getString("FILE_UPLOAD_HOST"));
                        this.ftpUserName = E12GenericUtility.checkNull(rs.getString("FILE_UPLOAD_USER"));
                        this.ftpPassword = E12GenericUtility.checkNull(rs.getString("FILE_UPLOAD_PASS"));
                        this.fileUploadPort = E12GenericUtility.checkNull(rs.getString("FILE_UPLOAD_PORT"));
                        String fileUploadSrcPath = E12GenericUtility.checkNull(rs.getString("FILE_UPLOAD_SRC"));
                        String fileUploadRejectPath = E12GenericUtility.checkNull(rs.getString("FILE_UPLOAD_REJ"));
                        String fileUploadSuccessPath = E12GenericUtility.checkNull(rs.getString("FILE_UPLOAD_SUC"));
                        String fileUploadLogPath1 = E12GenericUtility.checkNull(rs.getString("FILE_UPLOAD_LOG"));
                        BaseLogger.log("3", userInfo, null, "fileUploadSrcPath : [" + this.FILE_UPLOAD_SRC_PATH + "]" + "\n fileUploadRejectPath : [" + this.FILE_UPLOAD_REJ_PATH + "]" + "\n fileUploadSuccessPath : [" + this.FILE_UPLOAD_SUCC_PATH + "]" + "\n fileUploadLogPath : [" + this.FILE_UPLOAD_LOG_PATH + "]" + "\n ftpUserName : [" + this.ftpUserName + "]" + "\n ftpPassword : [" + this.ftpPassword + "]" + "\n FTP_HOST_URL : [" + this.FTP_HOST_URL + "]" + "\n FILE_UPLOAD_PORT : [" + this.fileUploadPort + "]" + "\n fileUploadSrcPath : [" + fileUploadSrcPath + "]" + "\n fileUploadRejectPath : [" + fileUploadRejectPath + "]" + "\n fileUploadLogPath1 : [" + fileUploadSuccessPath + "]");
                        if (this.FTP_HOST_URL.length() > 0) {
                            if (this.FTP_HOST_URL.toLowerCase().startsWith("ftp")) {
                                this.IS_FTP_PATH = true;
                            } else if (this.FTP_HOST_URL.toLowerCase().startsWith("sftp")) {
                                this.IS_SFTP_PATH = true;
                            }
                        } else {
                            this.IS_FTP_PATH = false;
                            this.IS_SFTP_PATH = false;
                        }
                        this.FILE_UPLOAD_SRC_PATH = this.updatePath(fileUploadSrcPath);
                        this.FILE_UPLOAD_REJ_PATH = this.updatePath(fileUploadRejectPath);
                        this.FILE_UPLOAD_SUCC_PATH = this.updatePath(fileUploadSuccessPath);
                        this.FILE_UPLOAD_LOG_PATH = this.updatePath(fileUploadLogPath1);
                    }
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (conn == null) return;
                    conn.close();
                    return;
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    throw new ITMException(e);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (conn == null) return;
                    conn.close();
                    return;
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (conn != null) {
                    conn.close();
                }
            }
        } else {
            this.FILE_UPLOAD_SRC_PATH = "";
            this.FILE_UPLOAD_REJ_PATH = "";
            this.FILE_UPLOAD_SUCC_PATH = "";
            this.FILE_UPLOAD_LOG_PATH = "";
        }
    }

    private String updatePath(String fileUploadSrcPath) {
        String strDate;
        SimpleDateFormat sd;
        Date currentDate = new Date(System.currentTimeMillis());
        if (fileUploadSrcPath.contains("YYYY")) {
            sd = new SimpleDateFormat("YYYY");
            strDate = sd.format(currentDate);
            fileUploadSrcPath = fileUploadSrcPath.replace("YYYY", strDate);
        }
        if (fileUploadSrcPath.contains("MMM")) {
            sd = new SimpleDateFormat("MMM");
            strDate = sd.format(currentDate);
            fileUploadSrcPath = fileUploadSrcPath.replace("MMM", strDate.toUpperCase());
        }
        if (fileUploadSrcPath.contains("MM")) {
            sd = new SimpleDateFormat("MM");
            strDate = sd.format(currentDate);
            fileUploadSrcPath = fileUploadSrcPath.replace("MM", strDate);
        }
        BaseLogger.log("2", this.userInfo, null, "fileUploadSrcPath[" + fileUploadSrcPath + "]");
        return fileUploadSrcPath;
    }

    private boolean createFTPConnection() throws Exception {
        boolean ftpConn = false;
        try {
            BaseLogger.log("3", this.userInfo, null, "createFTPConnection ftpClient[" + this.ftpClient + "]");
            this.ftpClient = null;
            String ftpHostUrl = "";
            if (this.FTP_HOST_URL.startsWith("ftp://")) {
                ftpHostUrl = this.FTP_HOST_URL.replace("ftp://", "");
                BaseLogger.log("0", this.userInfo, null, String.valueOf(ftpHostUrl) + " ftp =" + ftpHostUrl.length());
            }
            String server = ftpHostUrl;
            int port = 21;
            if (this.fileUploadPort != null) {
                port = Integer.valueOf(this.fileUploadPort);
            }
            String user = this.ftpUserName;
            String pass = this.ftpPassword;
            BaseLogger.log("3", this.userInfo, null, "ftpClient[" + this.ftpClient + "]");
            this.ftpClient = new FTPClient();
            BaseLogger.log("3", this.userInfo, null, "ftpClient1[" + this.ftpClient + "]");
            this.ftpClient.connect(server, port);
            this.ftpClient.login(user, pass);
            this.ftpClient.enterLocalPassiveMode();
            this.ftpClient.setFileType(2);
            BaseLogger.log("3", this.userInfo, null, "ftpClient[" + this.ftpClient + "]");
            BaseLogger.log("3", this.userInfo, null, "ftp client connected on Dir[" + this.ftpClient.printWorkingDirectory() + "]");
            int replyCode = this.ftpClient.getReplyCode();
            if (this.ftpClient.getReplyCode() == 530) {
                this.createLogAndSendMail(replyCode, this.getServerReplyString());
                ftpConn = false;
            } else {
                ftpConn = true;
            }
            return ftpConn;
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception in createFTPConnection()[" + e.getMessage() + "]");
            this.setFTPExceptionLog(this.ftpClient.getReplyCode(), this.getServerReplyString(), e.getMessage());
            return false;
        }
    }

    private void readFilesByFTP(File dUMP_DIR, UserInfoBean userInfo, String isIntractive, String objName, String oriFileName, boolean isExcelDriver, boolean isRetainPkValue) throws IOException {
        BaseLogger.log("2", userInfo, null, "readFilesByFTP called");
        try {
            boolean ftpConn = this.createFTPConnection();
            if (!ftpConn) {
                return;
            }
            try {
                FTPFile[] files;
                BaseLogger.log("3", userInfo, null, "FILE_UPLOAD_SRC_PATH : [" + this.FILE_UPLOAD_SRC_PATH + "]");
                FTPFile[] fTPFileArray = files = this.ftpClient.listFiles(this.FILE_UPLOAD_SRC_PATH);
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    FTPFile file = fTPFileArray[n2];
                    String fileName = file.getName();
                    if (!file.isDirectory()) {
                        BaseLogger.log("3", userInfo, null, "fileName1[" + fileName + "]");
                        boolean isDownload = this.downloadRemoteFile(this.ftpClient, fileName, dUMP_DIR);
                        if (isDownload) {
                            try {
                                BaseLogger.log("3", userInfo, null, "file download ");
                                String[] fileInfoArr = new String[]{isIntractive, fileName, objName, oriFileName};
                                this.insertFileData(fileInfoArr, userInfo, dUMP_DIR, CommonConstants.APPLICATION_CONTEXT, "", isExcelDriver, isRetainPkValue);
                            }
                            catch (Exception e) {
                                BaseLogger.log("3", userInfo, null, "Error in insertFileData By FTP: " + e.getMessage());
                                e.printStackTrace();
                                this.setFTPExceptionLog(this.ftpClient.getReplyCode(), this.getServerReplyString(), e.getMessage());
                            }
                        } else {
                            this.createLogAndSendMail(this.ftpClient.getReplyCode(), this.getServerReplyString());
                        }
                    } else {
                        BaseLogger.log("3", userInfo, null, "isDirectory : [" + fileName + "]");
                    }
                    ++n2;
                }
                boolean completed = false;
                try {
                    completed = this.ftpClient.completePendingCommand();
                }
                catch (Exception e) {
                    if (this.ftpClient != null) {
                        this.ftpClient.logout();
                        this.ftpClient.disconnect();
                    }
                    BaseLogger.log("0", userInfo, null, "Exception in completePendingCommand");
                }
                if (completed) {
                    this.disconnectFTP();
                    BaseLogger.log("3", userInfo, null, "file Moving completed");
                }
            }
            catch (Exception ex) {
                BaseLogger.log("0", userInfo, null, "Error in read Files By FTP: " + ex.getMessage());
                ex.printStackTrace();
                this.setFTPExceptionLog(this.ftpClient.getReplyCode(), this.getServerReplyString(), ex.getMessage());
                this.ftpClient.logout();
                this.ftpClient.disconnect();
            }
        }
        finally {
            try {
                if (this.ftpClient.isConnected()) {
                    this.ftpClient.logout();
                    this.ftpClient.disconnect();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    private void disconnectFTP() throws IOException {
        try {
            boolean completed = this.ftpClient.completePendingCommand();
            if (completed) {
                this.ftpClient.logout();
                this.ftpClient.disconnect();
            }
        }
        catch (IOException e) {
            this.ftpClient.logout();
            this.ftpClient.disconnect();
        }
    }

    private boolean downloadRemoteFile(FTPClient ftpClient, String fileName, File dUMP_DIR) throws IOException {
        boolean isDownload = false;
        try {
            File downloadFile = new File("" + dUMP_DIR);
            if (!downloadFile.exists()) {
                downloadFile.mkdirs();
                BaseLogger.log("3", this.userInfo, null, "Download file path created");
            }
            downloadFile = new File(new File("" + downloadFile) + File.separator + fileName);
            BaseLogger.log("3", this.userInfo, null, "downloadFile path: [" + downloadFile + "]");
            BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(downloadFile));
            isDownload = ftpClient.retrieveFile(String.valueOf(this.FILE_UPLOAD_SRC_PATH) + File.separator + fileName, (OutputStream)outputStream);
            ((OutputStream)outputStream).close();
            if (isDownload) {
                BaseLogger.log("3", this.userInfo, null, "File name:" + fileName + "has been downloaded successfully");
            } else {
                BaseLogger.log("3", this.userInfo, null, "File could not download");
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception in downloadRemoteFile[" + e.getMessage() + "]");
        }
        return isDownload;
    }

    private void moveFileOnRemote(File dUMP_DIR, String remotePath, String newFileName) {
        try {
            if (this.ftpClient != null) {
                BaseLogger.log("3", this.userInfo, null, "Start uploading downloaded file");
                BaseLogger.log("3", this.userInfo, null, "remoteFilePath[" + remotePath + "]");
                FileInputStream inputStream = new FileInputStream(dUMP_DIR + File.separator + newFileName);
                BaseLogger.log("3", this.userInfo, null, "dUMP_DIR[" + dUMP_DIR + "]");
                String currentFtpDir = this.ftpClient.printWorkingDirectory();
                BaseLogger.log("3", this.userInfo, null, "currentFtpDir[" + currentFtpDir + "]");
                boolean exist = this.ftpClient.changeWorkingDirectory(remotePath);
                if (!exist) {
                    boolean created = this.makeFTPDirectories(remotePath);
                    BaseLogger.log("3", this.userInfo, null, "success[" + created + "]");
                    if (!created) {
                        this.createLogAndSendMail(this.ftpClient.getReplyCode(), this.getServerReplyString());
                        ((InputStream)inputStream).close();
                        return;
                    }
                    this.ftpClient.changeWorkingDirectory(currentFtpDir);
                } else {
                    this.ftpClient.changeWorkingDirectory(currentFtpDir);
                }
                BaseLogger.log("3", this.userInfo, null, "currentFtpDir1[" + currentFtpDir + "]");
                String fileMovePath = String.valueOf(remotePath) + File.separator + newFileName;
                BaseLogger.log("3", this.userInfo, null, "inputStream[" + inputStream + "]");
                boolean done = this.ftpClient.storeFile(fileMovePath, (InputStream)inputStream);
                ((InputStream)inputStream).close();
                if (done) {
                    BaseLogger.log("3", this.userInfo, null, "File move successfully on Remote");
                    this.deleteRemoteFile(newFileName, dUMP_DIR);
                } else {
                    BaseLogger.log("3", this.userInfo, null, "File could not Move");
                    this.createLogAndSendMail(this.ftpClient.getReplyCode(), this.getServerReplyString());
                }
            } else {
                BaseLogger.log("3", this.userInfo, null, "ftp connection closed");
                this.createLogAndSendMail(-1, "FTP connection closed");
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception in moveFileOnRemote[" + e.getMessage() + "]");
            e.printStackTrace();
            this.setFTPExceptionLog(this.ftpClient.getReplyCode(), this.getServerReplyString(), e.getMessage());
        }
    }

    private void deleteRemoteFile(String newFileName, File dumpDir) throws IOException {
        boolean deleted = false;
        if (this.IS_FTP_PATH && this.ftpClient != null) {
            deleted = this.ftpClient.deleteFile(String.valueOf(this.FILE_UPLOAD_SRC_PATH) + File.separator + newFileName);
        } else if (this.IS_SFTP_PATH && this.sftpChannel != null) {
            try {
                this.sftpChannel.rm(String.valueOf(this.FILE_UPLOAD_SRC_PATH) + File.separator + newFileName);
                deleted = true;
            }
            catch (SftpException e) {
                deleted = false;
            }
        }
        if (deleted) {
            BaseLogger.log("3", this.userInfo, null, "Remote file " + newFileName + " deleted successfully");
            this.deleteLocalFile(dumpDir, newFileName);
        } else {
            BaseLogger.log("3", this.userInfo, null, "Remote file" + newFileName + " could not delete");
            if (this.IS_FTP_PATH && this.ftpClient != null) {
                this.createLogAndSendMail(this.ftpClient.getReplyCode(), this.getServerReplyString());
            }
        }
    }

    private void deleteLocalFile(File dUMP_DIR2, String newFileName) {
        File localDownloadedFile = new File(dUMP_DIR2 + File.separator + newFileName);
        boolean deleted = localDownloadedFile.delete();
        if (deleted) {
            BaseLogger.log("3", this.userInfo, null, "localDownloadedFile " + newFileName + "deletetd successfully");
        } else {
            BaseLogger.log("3", this.userInfo, null, "localDownloadedFile " + newFileName + "could not delete");
            this.createLogAndSendMail(-1, "localDownloadedFile " + newFileName + "could not delete");
        }
    }

    private void moveLogFileOnRemote(String fileUploadLogPath, String logFileName, String errStr) throws Exception {
        block11: {
            try {
                if (this.ftpClient != null) {
                    BaseLogger.log("3", this.userInfo, null, "Start uploading log file");
                    String currentFtpDir = this.ftpClient.printWorkingDirectory();
                    BaseLogger.log("3", this.userInfo, null, "currentFtpDir[" + currentFtpDir + "]");
                    boolean exist = this.ftpClient.changeWorkingDirectory(fileUploadLogPath);
                    BaseLogger.log("3", this.userInfo, null, "ftp client[" + this.ftpClient.getReplyCode() + "]");
                    if (!exist) {
                        boolean created = this.makeFTPDirectories(fileUploadLogPath);
                        BaseLogger.log("3", this.userInfo, null, "success[" + created + "]");
                        if (!created) {
                            this.createLogAndSendMail(this.ftpClient.getReplyCode(), this.getServerReplyString());
                            return;
                        }
                        this.ftpClient.changeWorkingDirectory(currentFtpDir);
                    } else {
                        this.ftpClient.changeWorkingDirectory(currentFtpDir);
                    }
                    BaseLogger.log("3", this.userInfo, null, "ftpClient.workin[" + this.ftpClient.printWorkingDirectory());
                    String fileMovePath = String.valueOf(fileUploadLogPath) + File.separator + logFileName;
                    OutputStream outputStream = this.ftpClient.storeFileStream(fileMovePath);
                    BufferedOutputStream buffer = new BufferedOutputStream(outputStream);
                    ObjectOutputStream output = new ObjectOutputStream(buffer);
                    output.writeObject(errStr);
                    output.close();
                    ((OutputStream)buffer).close();
                    outputStream.close();
                    BaseLogger.log("3", this.userInfo, null, "log file created successfully");
                    this.ftpClient.changeWorkingDirectory(currentFtpDir);
                    BaseLogger.log("3", this.userInfo, null, "ftpClient[" + this.ftpClient + "]");
                    BaseLogger.log("3", this.userInfo, null, "ftpClient.working Directory[" + this.ftpClient.printWorkingDirectory());
                    this.createFTPConnection();
                    break block11;
                }
                if (this.sftpChannel != null) {
                    try {
                        this.createSFTPConnection();
                        boolean exist = this.changeWorkingDirectory(this.sftpChannel, fileUploadLogPath);
                        if (!exist && !(exist = this.makeSFTPDirectories(fileUploadLogPath))) {
                            BaseLogger.log("3", this.userInfo, null, "Directory not created");
                        }
                        if (exist) {
                            ByteArrayInputStream stream = new ByteArrayInputStream(errStr.getBytes());
                            this.sftpChannel.put((InputStream)stream, logFileName);
                            ((InputStream)stream).close();
                            BaseLogger.log("3", this.userInfo, null, "Log file moved");
                        }
                        break block11;
                    }
                    catch (SftpException s) {
                        BaseLogger.log("0", this.userInfo, null, "[Sftp Exceptiojn = " + (Object)((Object)s) + "]");
                        this.createLogAndSendMailSFTP(s.id, s.getMessage());
                    }
                    break block11;
                }
                BaseLogger.log("3", this.userInfo, null, "FTP connection closed");
                this.createLogAndSendMail(-1, "FTP connection closed");
            }
            catch (Exception e) {
                BaseLogger.log("0", this.userInfo, null, "Exception in uploadFileOnRemote[" + e.getMessage() + "]");
                this.setFTPExceptionLog(this.ftpClient.getReplyCode(), this.getServerReplyString(), e.getMessage());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean makeFTPDirectories(String dirPath) throws IOException {
        try {
            BaseLogger.log("3", this.userInfo, null, "dirPath[" + dirPath + "]");
            String[] pathElements = dirPath.split("/");
            if (pathElements != null && pathElements.length > 0) {
                String[] stringArray = pathElements;
                int n = pathElements.length;
                int n2 = 0;
                while (n2 < n) {
                    boolean dirExisted;
                    String singleDir = stringArray[n2];
                    BaseLogger.log("3", this.userInfo, null, "singleDir[" + singleDir + "]");
                    if (singleDir.trim().length() != 0 && !(dirExisted = this.ftpClient.changeWorkingDirectory(singleDir))) {
                        boolean dirCreated = this.ftpClient.makeDirectory(singleDir);
                        if (!dirCreated) {
                            BaseLogger.log("3", this.userInfo, null, "COULD NOT create directory: " + singleDir);
                            return false;
                        }
                        BaseLogger.log("3", this.userInfo, null, "CREATED directory: [" + singleDir + "]");
                        this.ftpClient.changeWorkingDirectory(singleDir);
                    }
                    ++n2;
                }
            }
            return true;
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception in makeDirectories[" + e.getMessage() + "]");
            e.printStackTrace();
            return false;
        }
    }

    private String getServerReplyString() {
        String[] replies = this.ftpClient.getReplyStrings();
        if (replies != null && replies.length > 0) {
            String[] stringArray = replies;
            if (replies.length != 0) {
                String aReply = stringArray[0];
                return aReply;
            }
        }
        return "server:" + this.ftpClient.getReplyCode();
    }

    private void createLogAndSendMail(int replyCode, String serverReply) {
        try {
            String errLogString = "";
            boolean mailFlag = true;
            boolean fileLogFlag = true;
            if (replyCode == 0) {
                errLogString = "Error code " + serverReply + "\n";
                errLogString = String.valueOf(errLogString) + "Messgae: Please check server credentials or contact administrator";
            } else if (replyCode == 530) {
                errLogString = "Error code " + serverReply + "\n";
                errLogString = String.valueOf(errLogString) + "Messgae: Please check server credentials or contact administrator";
            } else if (replyCode == 550) {
                errLogString = "Error code " + serverReply + "\n";
                errLogString = String.valueOf(errLogString) + "Messgae: Requested action not taken. File unavailable (for example, file not found, or no access).";
            } else if (replyCode == 553) {
                errLogString = "Error code " + serverReply + "\n";
                errLogString = String.valueOf(errLogString) + "Messgae: Requested action not taken. File name not allowed. (for example, file not found, or no access).";
            } else if (replyCode == 421) {
                errLogString = "Error code " + serverReply + "\n";
                errLogString = String.valueOf(errLogString) + "Service not available, closing control connection. This may be a reply to any command if the service knows it must shut down.";
                mailFlag = false;
                fileLogFlag = false;
            } else if (replyCode == 226) {
                errLogString = "Error code " + serverReply + "\n";
                fileLogFlag = false;
                mailFlag = false;
            } else if (replyCode == -1) {
                errLogString = "Error code " + serverReply + "\n";
            } else {
                errLogString = "Error code " + serverReply + "\n";
                mailFlag = false;
                fileLogFlag = false;
            }
            if (mailFlag) {
                this.sendLogViaMail(errLogString, "FTP log: XML file upload");
            }
            if (fileLogFlag) {
                this.writeLogInFile(errLogString, "FTP_log");
            }
            BaseLogger.log("3", this.userInfo, null, "Log String[" + errLogString + "]");
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception in createLogAndSendMail[" + e.getMessage() + "]");
        }
    }

    private void setFTPExceptionLog(int replyCode, String serverReplyString, String message) {
        this.createLogAndSendMail(this.ftpClient.getReplyCode(), String.valueOf(this.getServerReplyString()) + "\nException: " + message);
    }

    private String getRoleCodeEmailAddr() {
        String usrType = this.userInfo.getUserType();
        BaseLogger.log("2", this.userInfo, null, "[ITMUploadFileEJB] argType getRoleCodeEmailAddr 1:" + usrType + ":");
        String retEmailAddr = "";
        try {
            String masterTable = null;
            String whereFieldName = null;
            String selFieldName = null;
            if (usrType.equalsIgnoreCase("C")) {
                masterTable = "CUSTOMER";
                whereFieldName = "CUST_CODE";
                selFieldName = "EMAIL_ADDR";
            } else if (usrType.equalsIgnoreCase("S")) {
                masterTable = "SUPPLIER";
                whereFieldName = "SUPP_CODE";
                selFieldName = "EMAIL_ADDR";
            } else if (usrType.equalsIgnoreCase("E")) {
                masterTable = "EMPLOYEE";
                whereFieldName = "EMP_CODE";
                selFieldName = "EMAIL_ID_OFF";
            } else if (usrType.equalsIgnoreCase("P")) {
                masterTable = "SALES_PERS";
                whereFieldName = "SALES_PERS";
                selFieldName = "EMAIL_ADDR";
            }
            BaseLogger.log("3", this.userInfo, null, "userInfo.getEntityCode[" + this.userInfo.getEntityCode() + "]");
            retEmailAddr = this.getDBAccess().getEmailAddr(selFieldName, masterTable, whereFieldName, this.userInfo.getEntityCode(), this.userInfo);
            this.dbAccess = null;
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception :ITMUploadFileEJB :getEmailAddr :==>\n" + e.getMessage());
        }
        return retEmailAddr;
    }

    private boolean createSFTPConnection() {
        boolean sftpConn = false;
        String sftpHostUrl = "";
        if (this.FTP_HOST_URL.startsWith("sftp://")) {
            sftpHostUrl = this.FTP_HOST_URL.replace("sftp://", "");
            BaseLogger.log("0", this.userInfo, null, "sftpHostUrl : [" + sftpHostUrl + "]");
        }
        String server = sftpHostUrl;
        int port = 22;
        if (this.fileUploadPort != null) {
            port = Integer.valueOf(this.fileUploadPort);
        }
        String user = this.ftpUserName;
        String pass = this.ftpPassword;
        try {
            JSch jsch = new JSch();
            this.session = jsch.getSession(user, server, port);
            this.session.setPassword(pass);
            Properties config = new Properties();
            config.put("StrictHostKeyChecking", "no");
            this.session.setConfig(config);
            this.session.connect();
            BaseLogger.log("3", this.userInfo, null, "connection established! session created as : [" + config + "]");
            Channel channel = this.session.openChannel("sftp");
            channel.connect();
            BaseLogger.log("3", this.userInfo, null, "channel connected as = " + channel);
            this.sftpChannel = (ChannelSftp)channel;
            if (this.sftpChannel != null) {
                sftpConn = true;
                BaseLogger.log("3", this.userInfo, null, "sftpChannel connection established as [" + this.sftpChannel + "]");
            } else {
                sftpConn = false;
            }
            return sftpConn;
        }
        catch (JSchException s) {
            BaseLogger.log("0", this.userInfo, null, "SftpException in createSFTPConnection : [" + (Object)((Object)s) + "]");
            this.createLogAndSendMailSFTP(10, s.getMessage());
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private void readFilesBySFTP(File dUMP_DIR, UserInfoBean userInfo, String isIntractive, String objName, String oriFileName, boolean isExcelDriver, boolean isRetainPkValue) throws Exception {
        BaseLogger.log("0", userInfo, null, "In readFilesBySFTP method");
        boolean sftpConn = false;
        boolean isDownload = false;
        sftpConn = this.createSFTPConnection();
        if (!sftpConn) {
            return;
        }
        boolean isDirExist = this.changeWorkingDirectory(this.sftpChannel, this.FILE_UPLOAD_SRC_PATH, true);
        if (!isDirExist) {
            return;
        }
        String fileName = "";
        try {
            Vector list = this.sftpChannel.ls(this.FILE_UPLOAD_SRC_PATH);
            for (ChannelSftp.LsEntry entry : list) {
                isDownload = false;
                fileName = entry.getFilename();
                BaseLogger.log("0", userInfo, null, "SFTP file : [" + entry.getFilename() + "]");
                if (!".".equals(fileName) && !"..".equals(fileName)) {
                    fileName = entry.getFilename();
                    isDownload = this.downloadFileSFTP(fileName, dUMP_DIR);
                }
                if (isDownload) {
                    try {
                        BaseLogger.log("3", userInfo, null, "SFTP file download");
                        String[] fileInfoArr = new String[]{isIntractive, fileName, objName, oriFileName};
                        this.insertFileData(fileInfoArr, userInfo, dUMP_DIR, CommonConstants.APPLICATION_CONTEXT, "", isExcelDriver, isRetainPkValue);
                    }
                    catch (Exception e) {
                        BaseLogger.log("3", userInfo, null, "Error readFilesBySFTP By FTP : [" + e.getMessage() + "]");
                        e.printStackTrace();
                        this.setFTPExceptionLog(this.ftpClient.getReplyCode(), this.getServerReplyString(), e.getMessage());
                        this.disconnectSFTP();
                    }
                    continue;
                }
                BaseLogger.log("0", userInfo, null, "Sftp files not downloaded");
            }
        }
        catch (SftpException s) {
            BaseLogger.log("0", userInfo, null, "SftpException in readFilesBySFTP : [" + (Object)((Object)s) + "]");
            this.createLogAndSendMailSFTP(s.id, s.getMessage());
            this.disconnectSFTP();
        }
        catch (Exception e) {
            BaseLogger.log("0", userInfo, null, "Exception in readFilesBySFTP : [" + e.getMessage() + "]");
            this.disconnectSFTP();
        }
    }

    private boolean changeWorkingDirectory(ChannelSftp channelSftp, String path, boolean isSendMail) throws IOException {
        try {
            channelSftp.cd(path);
            BaseLogger.log("0", this.userInfo, null, "ChangeWorkingDirectory to: " + path);
            return true;
        }
        catch (SftpException s) {
            BaseLogger.log("0", this.userInfo, null, "SftpException in changeWorkingDirectory : [" + (Object)((Object)s) + "]" + "- Cannot change directory because mat be specified path was wrong or directoty does'nt exist!");
            if (isSendMail) {
                this.createLogAndSendMailSFTP(s.id, s.getMessage());
            }
            return false;
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception in changeWorkingDirectory : [" + e.getMessage() + "]");
            return false;
        }
    }

    private boolean changeWorkingDirectory(ChannelSftp channelSftp, String path) throws IOException {
        return this.changeWorkingDirectory(channelSftp, path, false);
    }

    private boolean downloadFileSFTP(String readFileName, File dUMP_DIR) throws Exception {
        BaseLogger.log("2", this.userInfo, null, "downloadFileSFTP : [" + readFileName + "], dUMP_DIR : [" + dUMP_DIR + "]");
        boolean isDownload = false;
        String downloadFileName = readFileName;
        this.changeWorkingDirectory(this.sftpChannel, this.FILE_UPLOAD_SRC_PATH);
        try {
            this.sftpChannel.get(String.valueOf(this.FILE_UPLOAD_SRC_PATH) + File.separator + downloadFileName, dUMP_DIR + File.separator + downloadFileName);
            BaseLogger.log("0", this.userInfo, null, "Downloaded fileName [" + downloadFileName + "]");
            File file = new File(dUMP_DIR + File.separator + downloadFileName);
            if (file.exists()) {
                isDownload = true;
            }
        }
        catch (SftpException s) {
            BaseLogger.log("0", this.userInfo, null, "SftpException in downloadFileSFTP : [" + (Object)((Object)s) + "]");
            this.createLogAndSendMailSFTP(s.id, s.getMessage());
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception in downloadFileSFTP : [" + e.getMessage() + "]");
        }
        return isDownload;
    }

    private void uploadFileSFTP(File dUMP_DIR, String SFTP_REM_WORK_Dir, String uploadFileName) throws Exception {
        BaseLogger.log("2", this.userInfo, null, "In uploadFileSFTP : dUMP_DIR : [" + dUMP_DIR + "], SFTP_REM_WORK_Dir : [" + SFTP_REM_WORK_Dir + "], uploadFileName : [" + uploadFileName + "]");
        boolean sftpConn = this.createSFTPConnection();
        if (sftpConn) {
            boolean created;
            boolean exist = this.changeWorkingDirectory(this.sftpChannel, SFTP_REM_WORK_Dir);
            if (!exist && !(created = this.makeSFTPDirectories(SFTP_REM_WORK_Dir))) {
                BaseLogger.log("3", this.userInfo, null, "SFTP Directory not created");
            }
            try {
                boolean dirChange = this.changeWorkingDirectory(this.sftpChannel, SFTP_REM_WORK_Dir);
                if (dirChange) {
                    this.sftpChannel.put(dUMP_DIR + File.separator + uploadFileName, String.valueOf(SFTP_REM_WORK_Dir) + File.separator + uploadFileName);
                }
                this.deleteRemoteFile(uploadFileName, dUMP_DIR);
            }
            catch (SftpException s) {
                BaseLogger.log("0", this.userInfo, null, "SftpException in uploadFileSFTP : [" + (Object)((Object)s) + "]");
                this.createLogAndSendMailSFTP(s.id, s.getMessage());
            }
            catch (Exception e) {
                BaseLogger.log("0", this.userInfo, null, "Exception in uploadFileSFTP : [" + e.getMessage() + "]");
            }
        }
    }

    private boolean makeSFTPDirectories(String dirPath) throws IOException {
        BaseLogger.log("2", this.userInfo, null, "In makeSFTPDirectories : [" + dirPath + "]");
        boolean exist = false;
        try {
            String[] folders = dirPath.split("/");
            if (folders[0].isEmpty()) {
                folders[0] = "/";
            }
            String fullPath = folders[0];
            int i = 1;
            while (i < folders.length) {
                Vector ls = this.sftpChannel.ls(fullPath);
                boolean isExist = false;
                for (Object o : ls) {
                    ChannelSftp.LsEntry e;
                    if (!(o instanceof ChannelSftp.LsEntry) || !(e = (ChannelSftp.LsEntry)o).getAttrs().isDir() || !e.getFilename().equals(folders[i])) continue;
                    isExist = true;
                    exist = false;
                }
                if (!isExist && !folders[i].isEmpty()) {
                    this.sftpChannel.mkdir(String.valueOf(fullPath) + folders[i]);
                    BaseLogger.log("3", this.userInfo, null, "Directory created");
                    exist = true;
                }
                fullPath = String.valueOf(fullPath) + folders[i] + "/";
                ++i;
            }
            return exist;
        }
        catch (SftpException s) {
            BaseLogger.log("0", this.userInfo, null, "SftpException in makeSFTPDirectories : [" + (Object)((Object)s) + "]");
            this.createLogAndSendMailSFTP(s.id, s.getMessage());
            return false;
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception in makeSFTPDirectories : [" + e.getMessage() + "]");
            e.printStackTrace();
            return false;
        }
    }

    private void createLogAndSendMailSFTP(int replyCode, String serverReply) {
        BaseLogger.log("2", this.userInfo, null, "In createLogAndSendMailSFTP : replyCode [" + replyCode + "], serverReply : [" + serverReply + "]");
        try {
            String errLogString = "";
            boolean mailFlag = true;
            boolean fileLogFlag = true;
            if (replyCode == 2) {
                errLogString = "Error code " + serverReply + "\n";
                errLogString = String.valueOf(errLogString) + "Messgae: No Such File on Remote server or invalid remote directory path";
            } else if (replyCode == 4) {
                errLogString = "Error code " + serverReply + "\n";
                errLogString = String.valueOf(errLogString) + "Messgae: No such File on local machine or invalid local directory path";
            } else if (replyCode == 10) {
                errLogString = "Error code " + serverReply + "\n";
                errLogString = String.valueOf(errLogString) + "Messgae: Connection to SFTP server failed [causes: invalid inputs(username/password) / server credentials or contact administrator ]";
            } else {
                errLogString = "Error code " + serverReply + "\n";
                mailFlag = false;
                fileLogFlag = false;
            }
            if (mailFlag) {
                this.sendLogViaMail(errLogString, "SFTP log: XML file upload");
            }
            if (fileLogFlag) {
                this.writeLogInFile(errLogString, "SFTP_log");
            }
            BaseLogger.log("3", this.userInfo, null, "Log String[" + errLogString + "]");
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception in createLogAndSendMailSFTP : [" + e.getMessage() + "]");
        }
    }

    private void sendLogViaMail(String errorLog, String subject) {
        BaseLogger.log("2", this.userInfo, null, "In sendSFTPLogViaMail");
        if (E12GenericUtility.checkNull(this.mailAddr).length() == 0) {
            this.mailAddr = this.getRoleCodeEmailAddr();
        }
        BaseLogger.log("3", this.userInfo, null, "mailAddr[" + this.mailAddr + "]");
        if (this.mailAddr.length() > 0) {
            EMail mail = new EMail();
            try {
                String mailInfoStr = "<Root><TO_ADD>" + this.mailAddr + "</TO_ADD> " + "<SUBJECT>" + subject + "</SUBJECT>" + "<MESSAGE>" + errorLog + "</MESSAGE>" + "</Root>";
                mail.sendMail(mailInfoStr, "", this.userInfo);
            }
            catch (Exception e) {
                BaseLogger.log("0", this.userInfo, null, "Exception in sendSFTPLogViaMail[" + e.getMessage() + "]");
            }
        }
    }

    private void writeLogInFile(String errorLog, String folderName) {
        BaseLogger.log("2", this.userInfo, null, "In writeSFTPLogInFile : errorLog [" + errorLog + "]");
        try {
            boolean exist;
            String destinationFilePath = new File(CommonConstants.UPLOAD_LOC) + File.separator + "upload_log" + File.separator + folderName;
            String userId = "";
            if (this.userInfo != null) {
                userId = this.userInfo.getLoginCode();
            }
            String logFileName = "SFTP_log_" + userId + "_" + System.currentTimeMillis() + ".log";
            if (!new File(destinationFilePath).exists()) {
                new File(destinationFilePath).mkdir();
            }
            if (!new File(String.valueOf(destinationFilePath) + File.separator + logFileName).exists()) {
                new File(String.valueOf(destinationFilePath) + File.separator + logFileName).createNewFile();
            }
            if (!(exist = this.changeWorkingDirectory(this.sftpChannel, this.FILE_UPLOAD_LOG_PATH)) && !(exist = this.makeSFTPDirectories(this.FILE_UPLOAD_LOG_PATH))) {
                BaseLogger.log("3", this.userInfo, null, "Directory not created");
            }
            if (exist) {
                ByteArrayInputStream stream = new ByteArrayInputStream(errorLog.getBytes());
                this.sftpChannel.put((InputStream)stream, logFileName);
                ((InputStream)stream).close();
                BaseLogger.log("3", this.userInfo, null, "Error Log file write");
            }
        }
        catch (SftpException s) {
            BaseLogger.log("0", this.userInfo, null, "SftpException in writeLogInFile : [" + (Object)((Object)s) + "]");
            this.createLogAndSendMailSFTP(s.id, s.getMessage());
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception in writeLogInFile : [" + e.getMessage() + "]");
        }
    }

    private void disconnectSFTP() {
        BaseLogger.log("2", this.userInfo, null, "In disconnectSFTP");
        try {
            this.sftpChannel.quit();
            this.sftpChannel.exit();
            this.session.disconnect();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void processEDIBatchload(String[] scheduleInfoArr) throws ITMException {
        Connection conn = null;
        Statement pstmt = null;
        ResultSet rs = null;
        String batchID = "";
        int tranSl = 0;
        String dependency = "";
        String loadStat = "";
        MasterApplyEJB masterApplyEJB = new MasterApplyEJB();
        LinkedHashMap<Integer, HashMap<String, String>> dataMap = null;
        try {
            try {
                ConnDriver connDriver = new ConnDriver();
                conn = connDriver.getConnectDB(this.userInfo.getTransDB());
                connDriver = null;
                String appId = this.checkNull(scheduleInfoArr[5]);
                BaseLogger.log("3", this.userInfo, null, "appId : [" + appId + "]");
                String appIdAddr = "";
                if (appId.length() > 0) {
                    appIdAddr = String.valueOf(appId) + "_";
                }
                String sql = "SELECT BATCH.BATCH_ID, BATCH.WIN_NAME, BATCH.DATA_FILE_NAME, BATCH.SUBJECT, BATCH.XFRM_TEMPLATE, TEMPL.TEMPLATE_NAME, BATCH.TRAN_SL, BATCH.EDI_ADDR, BATCH.THREAD_KEY, BATCH.ADD_USER, BATCH.LOAD_STAT, TRAN.LOAD_ORDER, BATCH.LOAD_ORDER  FROM TRANSETUP TRAN, BATCHLOAD BATCH LEFT OUTER JOIN OBJ_FILE_TEMPLATE TEMPL ON BATCH.XFRM_TEMPLATE = TEMPL.TEMPLATE_ID  WHERE ( BATCH.LOAD_STAT IN ( 'N', 'R' )  OR ERROR_MSG Like '%Load file not exist%') AND TRAN.TRAN_WINDOW = BATCH.WIN_NAME  AND BATCH.EDI_ADDR IS NOT NULL AND BATCH.EDI_ADDR IN ( '" + appIdAddr + "fileSystem', '" + appIdAddr + CommonConstants.API_FILE_DESTINATION + "' ) " + " ORDER BY TRAN.LOAD_ORDER, BATCH.LOAD_ORDER, BATCH.ADD_DATE, BATCH.BATCH_ID, BATCH.TRAN_SL ";
                pstmt = conn.prepareStatement(sql);
                rs = pstmt.executeQuery();
                dataMap = new LinkedHashMap<Integer, HashMap<String, String>>();
                ResultSetMetaData rsmd = rs.getMetaData();
                int noOfColumns = rsmd.getColumnCount();
                int index = 0;
                while (rs.next()) {
                    HashMap<String, String> tempMap = new HashMap<String, String>();
                    int ctr = 1;
                    while (ctr <= noOfColumns) {
                        if ("mysql".equalsIgnoreCase(CommonConstants.DB_NAME)) {
                            tempMap.put(rsmd.getColumnName(ctr).toUpperCase(), rs.getString(ctr));
                        } else {
                            tempMap.put(rsmd.getColumnName(ctr), rs.getString(ctr));
                        }
                        ++ctr;
                    }
                    dataMap.put(++index, tempMap);
                }
                rs.close();
                rs = null;
                pstmt.close();
                pstmt = null;
                masterApplyEJB.updateBatchLoad(dataMap, "I", conn, this.getUserInfoBean());
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
                BaseLogger.log("3", this.userInfo, null, "index : [" + index + "], dataMap : [" + dataMap + "]");
                String fileName = "";
                String objName = "";
                String subject = "";
                String templateId = "";
                String templateName = "";
                String ediAddr = "";
                String threadKey = "";
                String addUser = "";
                String tranSlStr = "0";
                for (Map.Entry dataEntry : ((HashMap)dataMap).entrySet()) {
                    HashMap tempDataMap = (HashMap)dataEntry.getValue();
                    objName = this.checkNull((String)tempDataMap.get("WIN_NAME"));
                    objName = objName.substring(objName.indexOf("_") + 1);
                    batchID = this.checkNull((String)tempDataMap.get("BATCH_ID"));
                    fileName = this.checkNull((String)tempDataMap.get("DATA_FILE_NAME"));
                    subject = this.checkNull((String)tempDataMap.get("SUBJECT"));
                    templateId = this.checkNull((String)tempDataMap.get("XFRM_TEMPLATE"));
                    templateName = this.checkNull((String)tempDataMap.get("TEMPLATE_NAME"));
                    tranSlStr = this.checkNull((String)tempDataMap.get("TRAN_SL"));
                    if (tranSlStr.length() > 0) {
                        tranSl = Integer.parseInt(tranSlStr);
                    }
                    ediAddr = this.checkNull((String)tempDataMap.get("EDI_ADDR"));
                    threadKey = this.checkNull((String)tempDataMap.get("THREAD_KEY"));
                    addUser = this.checkNull((String)tempDataMap.get("ADD_USER")).trim();
                    loadStat = this.checkNull((String)tempDataMap.get("LOAD_STAT"));
                    BaseLogger.log("3", this.userInfo, null, "objName : [" + objName + "]");
                    BaseLogger.log("3", this.userInfo, null, "batchID : [" + batchID + "]");
                    BaseLogger.log("3", this.userInfo, null, "fileName : [" + fileName + "]");
                    BaseLogger.log("3", this.userInfo, null, "subject : [" + subject + "]");
                    BaseLogger.log("3", this.userInfo, null, "templateId : [" + templateId + "]");
                    BaseLogger.log("3", this.userInfo, null, "templateName : [" + templateName + "]");
                    BaseLogger.log("3", this.userInfo, null, "ediAddr : [" + ediAddr + "]");
                    BaseLogger.log("3", this.userInfo, null, "threadKey : [" + threadKey + "]");
                    BaseLogger.log("3", this.userInfo, null, "addUser : [" + addUser + "]");
                    BaseLogger.log("3", this.userInfo, null, "loadStat : [" + loadStat + "]");
                    if (fileName.length() == 0 || fileName.indexOf(".") == -1) continue;
                    dependency = "";
                    if ((threadKey = this.checkNull(threadKey)).length() > 0) {
                        dependency = this.getDBAccess().getDBColumnValue("BATCHLOAD", "(BATCH_ID || ':' || TRAN_SL)~AS~DEPENDENCY", " THREAD_KEY = '" + threadKey + "' AND LOAD_STAT = 'E' ", this.userInfo.getTransDB());
                    }
                    if ((dependency = this.checkNull(dependency)).length() > 0) {
                        if (loadStat.equalsIgnoreCase("E")) {
                            String fromPath = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "server" + File.separator + "default" + File.separator + "log" + File.separator + "server.log";
                            String toPath = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "upload_failed";
                            String movedFileName = String.valueOf(batchID) + "_server.log";
                            BaseLogger.log("3", null, null, "Inside processEDIBatchload gsb fromPath [" + fromPath + "]");
                            BaseLogger.log("3", null, null, "Inside processEDIBatchload gsb toPath [" + toPath + "]");
                            BaseLogger.log("3", null, null, "Inside processEDIBatchload gsb movedFileName [" + movedFileName + "]");
                            this.genericUtility.copyFileWithNewName(fromPath, toPath, movedFileName);
                        }
                        masterApplyEJB.updateBatchLoad(batchID, tranSl, loadStat, dependency, null, this.getUserInfoBean());
                        continue;
                    }
                    String[] fileInfoArr = new String[]{"false", fileName, objName, "", templateName, subject};
                    String fileType = fileName.substring(fileName.lastIndexOf(".") + 1);
                    BaseLogger.log("3", this.userInfo, null, "fileType : [" + fileType + "]");
                    String uploadFilePath = "";
                    String dataDumpFolderName = "";
                    if ("json".equalsIgnoreCase(fileType)) {
                        dataDumpFolderName = "JSON_UPLOAD";
                    } else {
                        dataDumpFolderName = "XLS_UPLOAD";
                        fileType = "xml";
                    }
                    uploadFilePath = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + dataDumpFolderName + File.separator + addUser + File.separator + batchID;
                    this.DUMP_DIR = new File(uploadFilePath);
                    if (!this.DUMP_DIR.exists()) {
                        this.DUMP_DIR.mkdirs();
                    }
                    if ("R".equalsIgnoreCase(loadStat)) {
                        this.moveFailedFileToUpload(uploadFilePath, fileName);
                    }
                    if (ediAddr.equalsIgnoreCase(String.valueOf(appIdAddr) + CommonConstants.API_FILE_DESTINATION) && subject.length() > 0) {
                        String inputData = this.getProcessData("EDI_DATA", subject);
                        if ((inputData = this.checkNull(inputData)).length() > 0) {
                            new E12GenericUtility().writeFile(uploadFilePath, fileName, inputData);
                        }
                    }
                    this.insertFileData(fileInfoArr, this.userInfo, this.DUMP_DIR, CommonConstants.APPLICATION_CONTEXT, "", false, false, batchID, tranSl);
                }
            }
            catch (SQLException e) {
                BaseLogger.log("3", null, null, "Exception2 in processEDIBatchload [" + E12GenericUtility.getStackTrace(e) + "]");
                e.getMessage();
                String errorMsg = e.getMessage();
                if (errorMsg != null && errorMsg.length() > 1500) {
                    errorMsg = errorMsg.substring(0, 1500);
                }
                masterApplyEJB.updateBatchLoad(batchID, tranSl, errorMsg, "E", "", conn, this.userInfo);
                throw new ITMException(e);
            }
            catch (Exception e) {
                BaseLogger.log("3", null, null, "Exception2 in processEDIBatchload [" + E12GenericUtility.getStackTrace(e) + "]");
                e.getMessage();
                String errorMsg = e.getMessage();
                if (errorMsg != null && errorMsg.length() > 1500) {
                    errorMsg = errorMsg.substring(0, 1500);
                }
                masterApplyEJB.updateBatchLoad(batchID, tranSl, errorMsg, "E", "", conn, this.userInfo);
                throw new ITMException(e);
            }
        }
        finally {
            try {
                for (Map.Entry dataEntry : ((HashMap)dataMap).entrySet()) {
                    BaseLogger.log("3", null, null, " Inside finally for loop dataEntry [:" + dataEntry + "]");
                    HashMap tempDataMap = (HashMap)dataEntry.getValue();
                    BaseLogger.log("3", null, null, " Inside finally for loop tempDataMap [:" + tempDataMap + "]");
                    String errorMsg = "Transaction got stucked at I. Please reload it";
                    String batchId = this.checkNull((String)tempDataMap.get("BATCH_ID"));
                    String tranSlStr = this.checkNull((String)tempDataMap.get("TRAN_SL"));
                    tranSl = Integer.parseInt(tranSlStr);
                    BaseLogger.log("3", null, null, " Inside finally for loop batchId [" + batchId + "]");
                    BaseLogger.log("3", null, null, " Inside finally for loop tranSl [" + tranSl + "]");
                    BaseLogger.log("3", null, null, " Inside finally for loop userInfo.getTransDB()  [" + this.userInfo.getTransDB() + "]");
                    String loadStatFromBatchload = this.getDBAccess().getDBColumnValue("BATCHLOAD", "LOAD_STAT", " BATCH_ID = '" + batchId + "'", this.userInfo.getTransDB());
                    BaseLogger.log("3", null, null, " loadStatFromBatchload [" + loadStatFromBatchload + "]");
                    if (!loadStatFromBatchload.equalsIgnoreCase("I")) continue;
                    BaseLogger.log("3", null, null, " Inside load stat from batch load is I [" + tranSl + "]");
                    masterApplyEJB.updateBatchLoad(batchId, tranSl, errorMsg, "E", "", conn, this.userInfo);
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (SQLException e) {
                BaseLogger.log("3", null, null, "Exception2 in processEDIBatchload [" + E12GenericUtility.getStackTrace(e) + "]");
                e.getMessage();
                String errorMsg = e.getMessage();
                if (errorMsg != null && errorMsg.length() > 1500) {
                    errorMsg = errorMsg.substring(0, 1500);
                }
                masterApplyEJB.updateBatchLoad(batchID, tranSl, errorMsg, "E", "", conn, this.userInfo);
                throw new ITMException(e);
            }
            catch (RemoteException e) {
                BaseLogger.log("3", null, null, "RemoteException in processEDIBatchload [" + E12GenericUtility.getStackTrace(e) + "]");
                e.getMessage();
                String errorMsg = e.getMessage();
                if (errorMsg != null && errorMsg.length() > 1500) {
                    errorMsg = errorMsg.substring(0, 1500);
                }
                masterApplyEJB.updateBatchLoad(batchID, tranSl, errorMsg, "E", "", conn, this.userInfo);
                throw new ITMException(e);
            }
        }
    }

    private void sendNotification(String notificationType, String objName, String batchId, String rowNo, String tranId, String xmlStr, String errorDescription, Connection conn) {
        try {
            String formatCode = this.getDBAccess().getDBColumnValue("SYSPARM", "VAR_VALUE", " VAR_NAME = '" + objName.toUpperCase() + "' AND VAR_TYPE = '" + notificationType + "' ", conn);
            BaseLogger.log("3", this.userInfo, null, "formatCode : [" + formatCode + "], errorDescription [" + errorDescription + "]");
            if (this.checkNull(formatCode).length() > 0 && "E".equalsIgnoreCase(notificationType)) {
                String winName = "w_" + objName;
                String objDescr = this.getDBAccess().getDBColumnValue("ITM2MENU", "DESCR", " WIN_NAME = '" + winName + "'", conn);
                BaseLogger.log("3", this.userInfo, null, "objDescr : [" + objDescr + "]");
                UploadFileEJB uploadFile = new UploadFileEJB();
                TreeMap batchloadDetails = uploadFile.getSortedErrorData(batchId, null, rowNo, this.userInfo, conn);
                uploadFile = null;
                HashMap batchloadDetailMap = (HashMap)batchloadDetails.get(Integer.parseInt(rowNo));
                BaseLogger.log("3", this.userInfo, null, "batchloadDetailMap : [" + batchloadDetailMap + "]");
                EMail emailObj = new EMail();
                StringBuffer xmlDataBuff = new StringBuffer();
                xmlDataBuff.append("<Detail1>");
                xmlDataBuff.append("<user_code><![CDATA[").append(this.userInfo.getLoginCode()).append("]]></user_code>");
                xmlDataBuff.append("<user_name><![CDATA[").append(this.userInfo.getUserName()).append("]]></user_name>");
                xmlDataBuff.append("<emp_code><![CDATA[").append(this.userInfo.getEmpCode()).append("]]></emp_code>");
                xmlDataBuff.append("<batch_id><![CDATA[").append(batchId).append("]]></batch_id>");
                xmlDataBuff.append("<row_no><![CDATA[").append(rowNo).append("]]></row_no>");
                xmlDataBuff.append("<obj_name><![CDATA[").append(objName).append("]]></obj_name>");
                xmlDataBuff.append("<obj_descr><![CDATA[").append(objDescr).append("]]></obj_descr>");
                xmlDataBuff.append("<load_date><![CDATA[").append(batchloadDetailMap.get("loadDate")).append("]]></load_date>");
                xmlDataBuff.append("<load_status><![CDATA[").append(batchloadDetailMap.get("loadStat")).append("]]></load_status>");
                xmlDataBuff.append("<load_order><![CDATA[").append(batchloadDetailMap.get("loadOrder")).append("]]></load_order>");
                xmlDataBuff.append("<thread_key><![CDATA[").append(batchloadDetailMap.get("threadKey")).append("]]></thread_key>");
                xmlDataBuff.append("<dependency><![CDATA[").append(batchloadDetailMap.get("dependency")).append("]]></dependency>");
                xmlDataBuff.append("<tran_id__ref><![CDATA[").append(batchloadDetailMap.get("tranIdRef")).append("]]></tran_id__ref>");
                xmlDataBuff.append("<error_descr><![CDATA[").append(batchloadDetailMap.get("errorMessage")).append("]]></error_descr>");
                xmlDataBuff.append("<edi_addr><![CDATA[").append(batchloadDetailMap.get("ediAddr")).append("]]></edi_addr>");
                xmlDataBuff.append("<template_id><![CDATA[").append(batchloadDetailMap.get("xfrmTemplate")).append("]]></template_id>");
                xmlDataBuff.append("<add_date><![CDATA[").append(batchloadDetailMap.get("addDate")).append("]]></add_date>");
                xmlDataBuff.append("<add_user><![CDATA[").append(batchloadDetailMap.get("addUser")).append("]]></add_user>");
                xmlDataBuff.append("<chg_date><![CDATA[").append(batchloadDetailMap.get("chgDate")).append("]]></chg_date>");
                xmlDataBuff.append("<chg_user><![CDATA[").append(batchloadDetailMap.get("chgUser")).append("]]></chg_user>");
                xmlDataBuff.append("</Detail1>");
                StringBuffer mailInfoXml = new StringBuffer();
                mailInfoXml.append("<?xml version=\"1.0\" ?>");
                mailInfoXml.append("<Root>");
                mailInfoXml.append("<Header></Header>");
                mailInfoXml.append("<Errors></Errors>");
                mailInfoXml.append("<ENTITY_CODE><![CDATA[" + this.userInfo.getLoginCode() + "]]></ENTITY_CODE>");
                mailInfoXml.append("<FORMAT_CODE><![CDATA[" + formatCode + "]]></FORMAT_CODE>");
                mailInfoXml.append("<XML_DATA>" + xmlDataBuff.toString() + "</XML_DATA>");
                mailInfoXml.append("<TRANSACTION_XML>" + xmlStr + "</TRANSACTION_XML>");
                mailInfoXml.append("<MESSAGE_TYPE><![CDATA[text/html]]></MESSAGE_TYPE>");
                mailInfoXml.append("</Root>");
                BaseLogger.log("3", this.userInfo, null, "mailInfoXml : [" + mailInfoXml + "]");
                emailObj.sendMail(mailInfoXml.toString(), "ITM", this.userInfo);
                emailObj = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            BaseLogger.log("0", this.userInfo, null, "Exception :: sendNotification : [" + e.getMessage() + "]");
        }
    }

    /*
     * Loose catch block
     */
    private String getProcessData(String collection, String refId) {
        String inputData;
        block25: {
            NoSQLConnection connection = null;
            inputData = null;
            try {
                if (CommonConstants.API_FILE_DESTINATION != null && CommonConstants.API_FILE_DESTINATION.length() > 0) {
                    NoSQLConnDriver connDriver = new NoSQLConnDriver();
                    connection = connDriver.getConnectNoSQLDB(String.valueOf(this.userInfo.getEnterprise()) + "_NOSQL", CommonConstants.API_FILE_DESTINATION);
                    connDriver = null;
                    MongoDBHandler dbHandler = new MongoDBHandler(connection, collection);
                    ObjectId mongoDBRefId = new ObjectId(refId);
                    BaseLogger.log("3", this.userInfo, null, "mongoDBRefId : [" + mongoDBRefId + "]");
                    JSONObject mongoDBDataJson = dbHandler.retrieve(mongoDBRefId);
                    BaseLogger.log("3", this.userInfo, null, "mongoDBDataJson : [" + mongoDBDataJson + "]");
                    if (mongoDBDataJson != null) {
                        inputData = E12GenericUtility.getJSONValue(mongoDBDataJson, "INPUT_DATA");
                    }
                }
            }
            catch (SQLException e) {
                BaseLogger.log("0", this.userInfo, null, "SQLException :: getProcessData : [" + e.getMessage() + "]");
                e.printStackTrace();
                try {
                    if (connection != null) {
                        connection.close();
                        connection = null;
                    }
                    break block25;
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                break block25;
            }
            catch (JSONException e) {
                BaseLogger.log("0", this.userInfo, null, "JSONException :: getProcessData : [" + e.getMessage() + "]");
                e.printStackTrace();
                break block25;
            }
            catch (Exception e) {
                BaseLogger.log("0", this.userInfo, null, "Exception :: getProcessData : [" + e.getMessage() + "]");
                e.printStackTrace();
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                try {
                    if (connection != null) {
                        connection.close();
                        connection = null;
                    }
                    break block25;
                }
                catch (Exception e3) {
                    e3.printStackTrace();
                }
                break block25;
            }
            {
                finally {
                    try {
                        if (connection != null) {
                            connection.close();
                            connection = null;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            try {
                if (connection != null) {
                    connection.close();
                    connection = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        BaseLogger.log("3", this.userInfo, null, "inputData : [" + inputData + "]");
        return inputData;
    }

    private void moveFailedFileToUpload(String uploadFilePath, String fileName) {
        File file = new File(String.valueOf(this.commonUploadFailedFilePath) + File.separator + fileName);
        if (file.exists()) {
            File dir = new File(uploadFilePath);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            BaseLogger.log("3", this.userInfo, null, "dir --> [" + dir + "]");
            boolean success = file.renameTo(new File(dir, file.getName()));
            if (!success) {
                BaseLogger.log("3", this.userInfo, null, "File was not moved");
            }
        } else {
            BaseLogger.log("3", this.userInfo, null, "File not exist In the failed path");
            file = new File(String.valueOf(this.commonUploadSuccessFilePath) + File.separator + fileName);
            if (file.exists()) {
                File dir = new File(uploadFilePath);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                BaseLogger.log("3", this.userInfo, null, "dir --> [" + dir + "]");
                boolean success = file.renameTo(new File(dir, file.getName()));
                if (!success) {
                    BaseLogger.log("3", this.userInfo, null, "File was not moved");
                }
            }
        }
    }

    public void moveLogFile(String batchID) {
        try {
            String fromPath = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "server" + File.separator + "default" + File.separator + "log" + File.separator + "server.log";
            String toPath = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "upload_failed";
            String movedFileName = String.valueOf(batchID) + "_server.log";
            BaseLogger.log("3", null, null, "Inside processEDIBatchload gsb fromPath [" + fromPath + "]");
            BaseLogger.log("3", null, null, "Inside processEDIBatchload gsb toPath [" + toPath + "]");
            BaseLogger.log("3", null, null, "Inside processEDIBatchload gsb movedFileName [" + movedFileName + "]");
            this.genericUtility.copyFileWithNewName(fromPath, toPath, movedFileName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getErrorString(Exception e) {
        String errorType;
        StringBuilder sb = new StringBuilder();
        String errorMessage = e.getMessage();
        if (errorMessage != null) {
            sb.append("Error Message: ").append(errorMessage).append("\n");
        }
        if ((errorType = e.getClass().getSimpleName()) != null) {
            sb.append("Error Type: ").append(errorType).append("\n");
        }
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        String stackTrace = sw.toString();
        if (stackTrace != null) {
            sb.append("Stack Trace: ").append(stackTrace).append("\n");
        }
        sb.append("Timestamp: ").append(System.currentTimeMillis()).append("\n");
        if (sb.length() > 2000) {
            return String.valueOf(sb.substring(0, 1997)) + "...";
        }
        return sb.toString();
    }
}

