/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.utility;

import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.InfinispanLocal;
import java.util.Date;
import java.util.Hashtable;
import javax.naming.InitialContext;

public class DMSConnLogMonitor {
    private String userId;
    private String transDB;
    private Date startTime;
    private Date endTime;
    private String connectionId;
    private String status;
    private String clientIP;
    private String className;
    private String methodName;
    private int lineNo;
    private String stackTrace;
    private int successCount;
    private Date lastSuccessTime;
    private int errorCount;
    private Date lastErrorTime;
    static InfinispanLocal infinispanLocalObj = null;
    static Hashtable<String, String> jndiProperties = null;
    static InitialContext ctx = null;

    static {
        try {
            if (CommonConstants.CACHE_OPT != 0) {
                jndiProperties = new Hashtable();
                jndiProperties.put("java.naming.factory.url.pkgs", "org.jboss.ejb.client.naming");
                ctx = new InitialContext(jndiProperties);
                infinispanLocalObj = (InfinispanLocal)ctx.lookup("ibase/InfinispanEJB/local");
                BaseLogger.log("3", null, null, "DMSConnLogMonitor infinispanLocalObj created.....");
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception in DMSConnLogMonitor static block : [" + e.getMessage() + "]");
            e.printStackTrace();
        }
    }

    public DMSConnLogMonitor(String userId, String transDB, Date startTime, Date endTime, String connectionId, String status, String clientIP, String className, String methodName, int lineNo, String stackTrace) {
        this.userId = userId;
        this.transDB = transDB;
        this.startTime = startTime;
        this.endTime = endTime;
        this.connectionId = connectionId;
        this.status = status;
        this.clientIP = clientIP;
        this.className = className;
        this.methodName = methodName;
        this.lineNo = lineNo;
        this.stackTrace = stackTrace;
    }

    public DMSConnLogMonitor(String userId, String transDB, String connectionId, String status, Date startTime, int successCount, Date lastSuccessTime, int errorCount, Date lastErrorTime, String clientIP) {
        this.userId = userId;
        this.transDB = transDB;
        this.connectionId = connectionId;
        this.status = status;
        this.clientIP = clientIP;
        this.startTime = startTime;
        this.successCount = successCount;
        this.lastSuccessTime = lastSuccessTime;
        this.errorCount = errorCount;
        this.lastErrorTime = lastErrorTime;
    }

    public void updateDMSConnMonitorDetails() {
        try {
            if (CommonConstants.CACHE_OPT != 0 && infinispanLocalObj != null) {
                if (infinispanLocalObj.containsDMSConnInfo(this.connectionId)) {
                    DMSConnLogMonitor dmsConnenctionInfoObj = infinispanLocalObj.getDMSConnInfo(this.connectionId);
                    if (dmsConnenctionInfoObj != null) {
                        dmsConnenctionInfoObj.setEndTime(this.endTime);
                        dmsConnenctionInfoObj.setClassName(this.className);
                        dmsConnenctionInfoObj.setMethodName(this.methodName);
                        dmsConnenctionInfoObj.setLineNo(this.lineNo);
                        dmsConnenctionInfoObj.setStackTrace(this.stackTrace);
                    }
                } else {
                    infinispanLocalObj.putDMSConnInfo(this.connectionId, this);
                }
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception in updateDMSConnMonitorDetails : [" + e.getMessage() + "]");
            e.printStackTrace();
        }
    }

    public void updateDMSConnMonitorSummary() {
        try {
            if (CommonConstants.CACHE_OPT != 0 && infinispanLocalObj != null) {
                if (infinispanLocalObj.containsDMSConnInfo(this.connectionId)) {
                    DMSConnLogMonitor dmsConnenctionInfoObj = infinispanLocalObj.getDMSConnInfo(this.connectionId);
                    if (dmsConnenctionInfoObj != null) {
                        this.status = E12GenericUtility.checkNull(this.status);
                        if (this.status.length() > 0) {
                            if ("new".equalsIgnoreCase(this.status) || "reused".equalsIgnoreCase(this.status)) {
                                if ("new".equalsIgnoreCase(this.status)) {
                                    dmsConnenctionInfoObj.setStartTime(this.startTime);
                                }
                                int successCount = dmsConnenctionInfoObj.getSuccessCount();
                                dmsConnenctionInfoObj.setSuccessCount(++successCount);
                                dmsConnenctionInfoObj.setLastSuccessTime(this.lastSuccessTime);
                            } else {
                                int errorCount = dmsConnenctionInfoObj.getErrorCount();
                                dmsConnenctionInfoObj.setErrorCount(++errorCount);
                                dmsConnenctionInfoObj.setLastErrorTime(this.lastErrorTime);
                            }
                        }
                    }
                } else {
                    infinispanLocalObj.putDMSConnInfo(this.connectionId, this);
                }
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception in updateDMSConnMonitorDetails : [" + e.getMessage() + "]");
            e.printStackTrace();
        }
    }

    public String toString() {
        StringBuffer logDetailBuf = new StringBuffer();
        logDetailBuf.append("<LogDetails status=\"" + this.status + "\" clientIP=\"" + this.clientIP + "\" connectionId=\"" + this.connectionId + "\" >");
        logDetailBuf.append("<userId>").append("<![CDATA[").append(this.userId).append("]]>").append("</userId>");
        logDetailBuf.append("<transDB>").append("<![CDATA[").append(this.transDB).append("]]>").append("</transDB>");
        logDetailBuf.append("<startTime>").append("<![CDATA[").append(this.startTime).append("]]>").append("</startTime>");
        logDetailBuf.append("<endTime>").append("<![CDATA[").append(this.endTime).append("]]>").append("</endTime>");
        logDetailBuf.append("<accessTime>").append("<![CDATA[").append(new Date()).append("]]>").append("</accessTime>");
        logDetailBuf.append("<className>").append("<![CDATA[").append(this.className).append("]]>").append("</className>");
        logDetailBuf.append("<methodName>").append("<![CDATA[").append(this.methodName).append("]]>").append("</methodName>");
        logDetailBuf.append("<lineNo>").append("<![CDATA[").append(this.lineNo).append("]]>").append("</lineNo>");
        logDetailBuf.append("<stackTrace>").append("<![CDATA[").append(this.stackTrace).append("]]>").append("</stackTrace>");
        logDetailBuf.append("<successCount>").append("<![CDATA[").append(this.successCount).append("]]>").append("</successCount>");
        logDetailBuf.append("<lastSuccessTime>").append("<![CDATA[").append(this.lastSuccessTime).append("]]>").append("</lastSuccessTime>");
        logDetailBuf.append("<errorCount>").append("<![CDATA[").append(this.errorCount).append("]]>").append("</errorCount>");
        logDetailBuf.append("<lastErrorTime>").append("<![CDATA[").append(this.lastErrorTime).append("]]>").append("</lastErrorTime>");
        logDetailBuf.append("</LogDetails>");
        BaseLogger.log("3", null, null, "logDetailBuf : [" + logDetailBuf + "]");
        return logDetailBuf.toString();
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getTransDB() {
        return this.transDB;
    }

    public void setTransDB(String transDB) {
        this.transDB = transDB;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    public void setConnectionId(String connectionId) {
        this.connectionId = connectionId;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getClientIP() {
        return this.clientIP;
    }

    public void setClientIP(String clientIP) {
        this.clientIP = clientIP;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public int getLineNo() {
        return this.lineNo;
    }

    public void setLineNo(int lineNo) {
        this.lineNo = lineNo;
    }

    public String getStackTrace() {
        return this.stackTrace;
    }

    public void setStackTrace(String stackTrace) {
        this.stackTrace = stackTrace;
    }

    public int getSuccessCount() {
        return this.successCount;
    }

    public void setSuccessCount(int successCount) {
        this.successCount = successCount;
    }

    public Date getLastSuccessTime() {
        return this.lastSuccessTime;
    }

    public void setLastSuccessTime(Date lastSuccessTime) {
        this.lastSuccessTime = lastSuccessTime;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public void setErrorCount(int errorCount) {
        this.errorCount = errorCount;
    }

    public Date getLastErrorTime() {
        return this.lastErrorTime;
    }

    public void setLastErrorTime(Date lastErrorTime) {
        this.lastErrorTime = lastErrorTime;
    }
}

