package ibase.webitm.ejb.wsfa.masters;

import ibase.utility.E12GenericUtility;

import ibase.webitm.utility.ITMException;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.GenericUtility;
import ibase.system.config.ConnDriver;

import java.rmi.RemoteException;
import java.util.Calendar;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.ejb.Stateless;
import javax.ejb.CreateException;
import org.w3c.dom.Document;


/* 
Author Name: Sachin Satre on [19-Apr-19] 
 Created Date : 26-Apr-19 
*/
//@Stateless		commented by Sagar M [22 Nov 2018].
public class SprsRouteCreationPos extends ValidatorEJB 
{
	E12GenericUtility genericUtility = new E12GenericUtility(); 
    public String postSaveRec() throws RemoteException,ITMException
	{
		return "";
	}
	public String postSaveRec(String xmlString1,String domId,String objContext,String editFlag, String xtraParams, Connection conn)throws RemoteException,ITMException
	{
		System.out.println("SprsRoutePos called!!!!!!!!!!!!!!!!!!");
		Document dom = null;
		try
		{
			if (xmlString1 != null && xmlString1.trim().length() > 0)
			{
				dom = new E12GenericUtility().parseString(xmlString1);
				executepostSaveRec(dom,domId,objContext,editFlag,xtraParams,conn);
			}
		}
	   	catch(Exception e)
		{
			System.out.println("Exception :SprsRoutePos :postSaveRec() :" + e.getMessage() + ":");
			e.printStackTrace();
			throw new ITMException(e);
		}
		return "";
	}
	private String executepostSaveRec(Document dom, String domID,String objContext,String editFlag, String xtraParams, Connection conn)throws RemoteException,ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String salesPers = "" ;
		String routeID = "";
		String sqlUpd = "";
		String userId = "";
		String chgTerm  = "";
		String status = "";

		java.sql.Timestamp chgDate = null;

		int updCnt = 0;
		String sqlSelect = "";
		int selectStkCnt = 0;
		int selectChemCnt = 0;
		
		try
		{
			conn.setAutoCommit(false);
			//E12GenericUtility genericUtility = new E12GenericUtility(); //Commented by vinayak on [29/04/2016] as object has been declared on class level

			if (dom != null )
			{
				salesPers	= genericUtility.getColumnValue("sprs_code",dom);
				routeID		= genericUtility.getColumnValue("route_id",dom);
				status		= genericUtility.getColumnValue("status",dom);

				chgDate = new java.sql.Timestamp(System.currentTimeMillis());
				userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
				chgTerm = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"termId");
				
			}
			if ( "N".equalsIgnoreCase(status) )
			{
				sqlUpd = "UPDATE STRG_SERIES SET STATUS = 'N', CHG_DATE = ?, CHG_USER = ?, CHG_TERM = ?  "+
								"WHERE SALES_PERS = '"+salesPers+"' " +
								"AND ROUTE_ID = '"+routeID+"' " +
								"AND STATUS = 'Y' ";
				System.out.println("Update Sql :"+sqlUpd);
				pstmt = conn.prepareStatement(sqlUpd);
				pstmt.setTimestamp(1,chgDate);
				pstmt.setString(2,userId);
				pstmt.setString(3,chgTerm);
				updCnt = pstmt.executeUpdate();
				if (updCnt >= 1)
				{
					System.out.println("Updated into strg_series Sucessfully : updCnt : " + updCnt);
				}
				pstmt.close();
				pstmt = null;
				
				
				sqlSelect = "SELECT COUNT(*) AS COUNT FROM SPRS_STOCKIST WHERE SPRS_CODE = '"+salesPers+"' AND ROUTE_ID = '"+routeID+"'";
				pstmt = conn.prepareStatement(sqlSelect);
				rs = pstmt.executeQuery();
				if (rs.next())
				{
					selectStkCnt = rs.getInt("COUNT");
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				
				if(selectStkCnt > 0)
				{
					sqlUpd = "UPDATE SPRS_STOCKIST SET STATUS = 'N', CHG_DATE = ?, CHG_USER = ?, CHG_TERM = ?  "+
							"WHERE SPRS_CODE = '"+salesPers+"' " +
							"AND ROUTE_ID = '"+routeID+"' " +
							"AND STATUS = 'Y' ";
					System.out.println("Update Sql :"+sqlUpd);
					pstmt = conn.prepareStatement(sqlUpd);
					pstmt.setTimestamp(1,chgDate);
					pstmt.setString(2,userId);
					pstmt.setString(3,chgTerm);
					updCnt = pstmt.executeUpdate();
					if (updCnt >= 1)
					{
						System.out.println("Updated into SPRS_STOCKIST Sucessfully : updCnt : " + updCnt);
					}
					pstmt.close();
					pstmt = null;
				}
				
				sqlSelect = "SELECT COUNT(*) AS COUNT FROM SPRS_CHEMIST WHERE SPRS_CODE = '"+salesPers+"' AND ROUTE_ID = '"+routeID+"'";
				pstmt = conn.prepareStatement(sqlSelect);
				rs = pstmt.executeQuery();
				if (rs.next())
				{
					selectChemCnt = rs.getInt("COUNT");
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}

				if(selectChemCnt > 0)
				{
					sqlUpd = "UPDATE SPRS_CHEMIST SET STATUS = 'N', CHG_DATE = ?, CHG_USER = ?, CHG_TERM = ?  "+
							"WHERE SPRS_CODE = '"+salesPers+"' " +
							"AND ROUTE_ID = '"+routeID+"' " +
							"AND STATUS = 'Y' ";
					System.out.println("Update Sql :"+sqlUpd);
					pstmt = conn.prepareStatement(sqlUpd);
					pstmt.setTimestamp(1,chgDate);
					pstmt.setString(2,userId);
					pstmt.setString(3,chgTerm);
					updCnt = pstmt.executeUpdate();
					if (updCnt >= 1)
					{
						System.out.println("Updated into SPRS_CHEMIST Sucessfully : updCnt : " + updCnt);
					}
					pstmt.close();
					pstmt = null;
				}
			}
			//user_type__login
			String loginEmpCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode");
			String userType= genericUtility.getColumnValue("user_type__login",dom);
			System.out.println("userType::["+userType+"]");
			SprsRouteConfirmation Sprsrouteonfirmation = new SprsRouteConfirmation();
			boolean isError = false ;
			if(userType != null && ("H".equalsIgnoreCase(userType) || "M".equalsIgnoreCase(userType)))
			{	
				isError =Sprsrouteonfirmation.insertRouteHistory( dom,  loginEmpCode, conn) ;
				System.out.println("isError::["+isError+"]");
			}	
			if(isError == true)
			{
				conn.rollback();
				System.out.println("connecyion rollback because insert into issue in history table");
			}	
			
		}
		catch (SQLException sqe)
		{
			System.out.println("The SQLException occurs in SprsRoutePos :: executepostSaveRec():: "+sqe);
			sqe.printStackTrace();
			try
			{
				conn.rollback();
			}
			catch(Exception e1){}
			throw new ITMException(sqe);
		}
		catch(Exception e)
		{
			System.out.println("The Exception occurs in SprsRoutePos :: executepostSaveRec():: "+e);
			e.printStackTrace();
			try
			{
				conn.rollback();
			}
			catch(Exception e1){}
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception :SprsRoutePos :: executepostSaveRec():: \n"+e.getMessage());
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return "";
	}
}
