
package ibase.webitm.utility.wsfa;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.StringTokenizer;
import java.util.Vector;

import javax.servlet.SingleThreadModel;

/**
 * This class used for different Utility function required all over application
 * 
 * @author 	Avinsh
 * @version 	1.0
 * Date of creation 22/2/2002
 * History OF change
 * 
 */

public class Utilities implements SingleThreadModel
{
	String months[] = {"Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"};
	public static int stringToInt(String str)
	{
		int retVal = 0;
		try
		{
				retVal = Integer.parseInt(str.trim());
		}
		catch (NumberFormatException e)
		{
			retVal = 0;
		}
		catch (Exception e)
		{
			retVal = 0;
		}

		return retVal;
	}

	public static String checkNull(String str)
	{
		if(str == null)
		str = "";

		return str.trim();
	}
	public static String[] checkNull(String[] str)
	{
		if(str == null)
		str = new String[0];

		return str;
	}

	
	public static Vector checkNull(Vector vect)
	{
		if(vect == null)
		vect = new Vector();

		return vect;
	}
	
	public static String addPrimaryKey(Connection con, String sColName,String sTableName) throws Exception
	{
		ResultSet rs = null;
		Statement stmt = null;
		//Connection con = null;
		String query = "SELECT MAX(TO_NUMBER("+sColName+")) AS COLVALUE FROM "+sTableName;
		//MLogger.writeToLog("addPrimaryKey Query" + query,Logger.LOG_LEVEL_DEBUG,"Utilities.java","addPrimaryKey()");
		int i;
		int cd = 0;
		try
		{
			//Changed by Monif on 07/11/09[Opening Connection only if it is Null].Start
			//Changed by nazia on 04-Jun-2009[Chage made to create new connection object and close immediately WS89SUN094]
			//dbCon = null;
			//dbCon = new DBConnection();
			//Changed by Monif on 07/11/09[Opening Connection only if it is Null].End
			//con = dbCon.getConnection();
			stmt = con.createStatement();
			rs = stmt.executeQuery(query);
			rs.next();
			i= rs.getInt("COLVALUE");
			cd = i+1;
			if (rs!=null)
			{
				rs.close();
			}
			if (stmt!=null)
			{
				stmt.close();
			}
		}
		catch(SQLException e)
		{
			throw e;
		}
		catch(NullPointerException e)
		{
			throw e;
		}
		catch(Exception e)
		{
			throw e;
		}
		finally
		{
			if (rs!=null)
			{
				rs.close();
			}
			if (stmt!=null)
			{
				stmt.close();
			}
		}
		return ""+cd;
		//return ((i+1) + "");
	}

	
/** 
 * This method returns the last Date of the month
 *
 * @param   month
 * @param   year
 * @return the last date of month in dd-Mon-YYYY format
 */

public String getLastDateOfMonth(String month,String year)
{
	int intMonth = 0;
//getting integer related to month		
	for(int i=0;i<months.length;i++)
	{
		if(months[i].equalsIgnoreCase(month))
		intMonth = i ;
	}

	Calendar cal = Calendar.getInstance();
	cal.set(Integer.parseInt(year),intMonth,1);
	cal.add(Calendar.MONTH,1); 
	cal.set(Calendar.DATE,0); 
	return cal.get(Calendar.DATE) +"-" + months[intMonth]+ "-" +cal.get(Calendar.YEAR);
	
}
	
/** This function is used to get the roundede float value upto the desired decimal
  *
  */
  public float limitDecimal(float f,int fract)
	{
		String formatString ="0.";
		for(int i=1;i<=fract;i++)
		{
			formatString = formatString + "#";
		}

		DecimalFormat df = new DecimalFormat(formatString);
		float d = Float.valueOf(df.format(f)).floatValue();
		return (d);
		
	}
/**  //Danish This function is used to appendZero while for floats containing only one character after decimal
  *
  */

	public String appendZero(float f)
	{
		String temp  = (new Float(f)).toString();
		if (temp.indexOf('.')==-1)
		{
			//System.out.println(". not found");
			temp = temp+".00";
		}

		if((temp.substring(temp.indexOf('.'))).length() < 3)//snehasish added 19/04/2006 to show upto two decimal point .problemno 22 snehasish sheet 1.
		{ 
			temp = temp+"0";
		}
		//System.out.println("\n\nlimitDecimal : temp :"+temp);
		return temp;
	}
	
	public static String replaceCommaWithOther(String data)
	{
		StringTokenizer st = new StringTokenizer(data,",");
		
		String str="";
		for(int i=0;st.hasMoreElements();i++)
		{
			if(i==0)
			{
				str = st.nextToken();
			}
			else
			{
				str = str +"," + st.nextToken();
			}
		}
		return "(Others)"+str;
	}

	public static String[] csvToArray(String csvString)
	{
		StringTokenizer st = new StringTokenizer(csvString,",");
		String retArray[] = new String[st.countTokens()];
		for(int i=0;st.hasMoreElements();i++)
		{
			retArray[i] = st.nextToken().trim();
		}
		return retArray;
	}
/**
 * This function returns String seperated by commas
 * @parameter : Vector
 *
*/

	public static String VectorToString(Vector str)
	{
		
		int k = str.size();
		String data = "";
		for(int i=0;i<str.size() ; i++)
		{
		if(i==0)
		{
			data = (String)str.elementAt(i);
		}
		else
		data = data +","+(String)str.elementAt(i);

		}
		return data;
	}

/**
 * Method Specific For View Application
 * In order to wrap the remark Data.
*/
	public static String getWrap(String data)
	{

		StringBuffer remark = new StringBuffer();
		StringBuffer remData = new StringBuffer();

		int k = data.length();
		if(k<70)
		{
			data = data.substring(0);
			remark.append(data).append("<BR>");
			remData.append(remark.toString());
			
		}
		else if(k>70 && k<170)
		{
			remark.append(data.substring(0,84)).append("<BR>").append(data.substring(85));
			remData.append(remark.toString());

		}
		else if (k>170 && k<255)
		{
			remark.append(data.substring(0,84)).append("<BR>").append(data.substring(85,170)).append("<BR>").append(data.substring(171));
			remData.append(remark.toString());
		}
		return remData.toString();
	}

	//takes a string and replaces char ' with ''
	public static String addEscapeChar(String strOrg)
	{
		StringBuffer sTemp= new StringBuffer(strOrg);
		for (int i=0; i<sTemp.length(); i++)
		{
			if(sTemp.charAt(i)=='\'')
			{
			sTemp.replace(i,i+1,"\'\'");	
			i++;
			}
		}
		return  sTemp.toString() ;
	}

	


	public static void main(String[] args) throws Exception
	{
		String t = Utilities.replaceCommaWithOther("a,b,c");
		//System.out.println(t);
	}

}
