package ibase.webitm.ejb.wsfa.transactions;

import java.rmi.RemoteException; 
import java.text.SimpleDateFormat;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.sql.Timestamp;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.w3c.dom.Node;
import java.util.Date;
import javax.ejb.Stateless;
import javax.ejb.CreateException;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.GenericUtility;
import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ValidatorEJB;
import org.w3c.dom.*;
import java.io.*;//Modified by Abhishek on [18/11/2013]
import ibase.utility.CommonConstants;//Modified by Abhishek on [18/11/2013]

//Modified by Ramchandra on [07/08/2012] [To add elements in to Vector class for validation]
import java.util.Vector;

@Stateless
public class StrgSeriesPsrCopyWiz extends ValidatorEJB implements StrgSeriesPsrCopyWizLocal,StrgSeriesPsrCopyWizRemote
{
	//Modified by Abhishek on [18/11/2013][Start]
	
	static String logOnOffFlag = "Y";//For On-Off Log file.
	File filePtr ;
	File logDir ;
	String logDirName = "";	
	
	//Modified by Abhishek on [18/11/2013][End]

	GenericUtility genericUtility = GenericUtility.getInstance(); 

	public String wfValData() throws RemoteException,ITMException
	{
		return "";
	}

	public String itemChanged() throws RemoteException,ITMException
	{
		return "";
	}
	public String wfValData(String xmlString, String xmlString1,String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String  errString = null;
		System.out.println("Validation Start..........");
		try
		{
			System.out.println("xmlString:::wfValData"+xmlString);
			System.out.println("xmlString1:::wfValData"+xmlString1);
			System.out.println("xmlString2:::wfValData"+xmlString2);

			dom = parseString(xmlString);
			dom1 = parseString(xmlString1); 
			if (xmlString2.trim().length() > 0 )
			{
				dom2 = parseString(xmlString2);
			}
			errString = wfValData(dom,dom1,dom2,objContext,editFlag,xtraParams);
		}
		catch(Exception e)
		{
			System.out.println("Exception : StrgSeriesPsrCopyEJB : wfValData(String xmlString) : ==>\n"+e.getMessage());
		}
		return (errString);
	}
	public String wfValData(Document dom, Document dom1,Document dom2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		ConnDriver connDriver = new ConnDriver();	
		Connection conn = null;
		Statement stmt = null;
		ResultSet rs = null;
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		String sql = "";
		String errString = "";
		String errCode = "";
		String childNodeName = null; 
		String userId = "";
		String userType = ""; // Modified by Rupesh on 04/09/2012 [To fetch user type of login employee code]
		int ctr,currentFormNo=0;
		int childNodeListLength;
		//Modified by Santosh on [30/07/2013][To parameterize the reporting site code][Start]
		String fldStaffSiteString = "";
		//Modified by Santosh on [30/07/2013][To parameterize the reporting site code][End]
		try
		{
			//Commented and changed by AMOL S. 10-Apr-2019[START]
			/*conn = connDriver.getConnectDB("DriverITM");
			conn.setAutoCommit(false);*/
			conn = getConnection();
			//Commented and changed by AMOL S. 10-Apr-2019[END]
			stmt = conn.createStatement();
			GenericUtility genericUtility = GenericUtility.getInstance(); 
			userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"userId");

			//Modified by Ramchandra on [07/08/2012] [To retrive Employee Hierarcy of loginEmpCode][Start]
			PreparedStatement pstmt2 = null;
			ResultSet rs2 = null;
			String loginEmpCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode");

			// Modified by Rupesh on 04/09/2012 [Fetch user type for login employee code like HO,Manager etc]
			userType = getUserType(loginEmpCode,conn);

			System.out.println("[StrgSeriesPsrCopy][wfValData()][loginEmpCode]" +loginEmpCode);
			Vector vec = new Vector();

			//Modified by Ramchandra on [13/10/2012][To Validate for sales persons if other than Hierarcy ][Start]
			//sql = "SELECT E.EMP_CODE EMP_CODE FROM EMPLOYEE E, GRADE G WHERE E.EMP_CODE IN (SELECT EMP_CODE  FROM EMPLOYEE WHERE EMP_SITE IN ('SP876','ST876','MP876','SP878','SP895')  AND RELIEVE_DATE IS NULL START WITH EMP_CODE = ?  CONNECT BY PRIOR emp_code = report_to ) AND G.GRADE_CODE = E.GRADE AND G.LEVEL_NO > 0 AND G.LEVEL_NO <= 4 AND E.RELIEVE_DATE IS NULL ";

			//Modified by Santosh on [30/07/2013][To parameterize the reporting site code][Start]
			
			//sql = "SELECT E.EMP_CODE EMP_CODE FROM EMPLOYEE E, GRADE G WHERE E.EMP_CODE IN (SELECT EMP_CODE  FROM EMPLOYEE WHERE EMP_SITE IN ('SP876','ST876','MP876','SP878','SP895')  START WITH EMP_CODE = ?  CONNECT BY PRIOR emp_code = report_to ) AND G.GRADE_CODE = E.GRADE AND G.LEVEL_NO > 0 AND G.LEVEL_NO <= 4 ";

			fldStaffSiteString = getFldStaffSiteList(conn);
			System.out.println("Inside [StrgSeriesPrsCopy][wfValData]fldStaffSiteString::["+fldStaffSiteString+"]");
			
			sql = "SELECT E.EMP_CODE EMP_CODE FROM EMPLOYEE E, GRADE G WHERE E.EMP_CODE IN (SELECT EMP_CODE  FROM EMPLOYEE WHERE EMP_SITE IN ("+getFormattedStringBuff(fldStaffSiteString)+")  START WITH EMP_CODE = ?  CONNECT BY PRIOR emp_code = report_to ) AND G.GRADE_CODE = E.GRADE AND G.LEVEL_NO > 0 AND G.LEVEL_NO <= 4 ";

			//Modified by Santosh on [30/07/2013][To parameterize the reporting site code][End]

			pstmt2 = conn.prepareStatement(sql);
			pstmt2.setString(1, loginEmpCode);
			System.out.println("[StrgSeriesPsrCopy][wfValData()][SQL ::]"+sql);
			rs2 = pstmt2.executeQuery();
			while(rs2.next())
			{
				String empCodeHierarchy = rs2.getString( 1 );
				vec.addElement(empCodeHierarchy.trim());
			}
			if (rs2 != null)
			{
				rs2.close();
				rs2 = null;
			}
			if (pstmt2 != null)
			{
				pstmt2.close();
				pstmt2 = null;
			}
			System.out.println("[StrgSeriesPsrCopy][wfValData()][Employee in Hierarcy] "+vec);
			//Modified by Ramchandra on [07/08/2012] [To retrive Employee Hierarcy of loginEmpCode][End]

			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			switch(currentFormNo)
			{
				case 1:
					parentNodeList = dom.getElementsByTagName("Detail1");
					parentNode = parentNodeList.item(0);
					childNodeList = parentNode.getChildNodes();
					childNodeListLength = childNodeList.getLength();
					for(ctr = 0; ctr < childNodeListLength; ctr++)
					{
						int cnt;
						childNode = childNodeList.item(ctr);
						childNodeName = childNode.getNodeName();
						if (childNodeName.equals("sales_pers__from"))
						{
							if ( childNode.getFirstChild() == null ) //Condition Added By Gulzar - 25/08/08 Req ID: SY89SUN001
							{
								errCode = "VMSALESPER";
								errString = getErrorString("sales_pers__from",errCode,userId);
								break;
							}
							else
							{
								String salesPersFrom = genericUtility.getColumnValue("sales_pers__from",dom);
								int spCntr = 0;
								sql = "SELECT COUNT(*) AS SPCNTR FROM SALES_PERS WHERE SALES_PERS = '"+ salesPersFrom +"' ";
								System.out.println("SQL from sales_pers :: "+sql);
								rs = stmt.executeQuery(sql);	
								if(rs.next())
								{
									spCntr = rs.getInt("SPCNTR");
								}
								rs.close();
								if (spCntr == 0)
								{
									errCode = "VSALPER";
									errString = getErrorString("sales_pers__from",errCode,userId);
									break;
								}

								//Modified by Ramchandra on [07/08/2012] [To Validate Employee not in Hierarcy of loginEmpCode] [Start]
								else
								{
									//Modified by Rupesh on [03/09/2012] [To Validate Hierarcy in case of Manager only]
									//if (!vec.contains(salesPersFrom.trim()))
									
									if (userType.trim().length() > 0 && userType.equalsIgnoreCase("M") && !vec.contains(salesPersFrom.trim()))
									{											
										errString = getErrorString("sales_pers__from","INVHIEEMP",userId);
										break;
									}									
								}
								//Modified by Ramchandra on [07/08/2012] [To Validate Employee not in Hierarcy of loginEmpCode] [End]

							}
						}
						else if (childNodeName.equals("sales_pers__to"))
						{
							if ( childNode.getFirstChild() == null ) //Condition Added By Gulzar - 25/08/08 Req ID: SY89SUN001
							{
								errCode = "VMSALESPER";
								errString = getErrorString("sales_pers__to",errCode,userId);
								break;
							}
							else
							{
								String salesPersTo = genericUtility.getColumnValue("sales_pers__to",dom);	

								//Modified by Rupesh on [08/08/2012] [To Validate duplicate emp][Start]							
								String salesPersFrom = genericUtility.getColumnValue("sales_pers__from",dom);
								salesPersFrom = salesPersFrom.trim();
								salesPersTo =salesPersTo.trim();
								//Modified by Rupesh on [08/08/2012] [To Validate duplicate emp][End]
								
								int spCntr = 0;
								
								sql = "SELECT COUNT(*) AS SPCNTR FROM SALES_PERS WHERE SALES_PERS = '"+ salesPersTo +"' ";
								System.out.println("SQL from sales_pers :: "+sql);
								rs = stmt.executeQuery(sql);	
								if(rs.next())
								{
									spCntr = rs.getInt("SPCNTR");
								}
								rs.close();
								if (spCntr == 0)
								{
									errCode = "VSALPER";
									errString = getErrorString("sales_pers__to",errCode,userId);
									break;
								}

								//Modified by Rupesh on [08/08/2012] [To Validate duplicate emp][Start]							
								else if (salesPersFrom.equalsIgnoreCase(salesPersTo))
								{
									errString = getErrorString("sales_pers__to","INVDUPEMP",userId);
									break;
								}
								//Modified by Rupesh on [08/08/2012] [To Validate duplicate emp][End]							

								//Modified by Ramchandra on [07/08/2012] [To validate for employee relieved or not] [Start]
								else 
								{
									String empRelieveDate = "";
									PreparedStatement pstmt1 = null;
									ResultSet rs1 = null;
									if(salesPersTo != null)
									{	
										sql = "SELECT RELIEVE_DATE FROM EMPLOYEE WHERE EMP_CODE =? ";
										pstmt1 = conn.prepareStatement(sql);
										pstmt1.setString(1, salesPersTo);
										rs1 = pstmt1.executeQuery();
										if(rs1.next())
										{
											empRelieveDate = rs1.getString("RELIEVE_DATE");
										}
										if (rs1 != null)
										{
											rs1.close();
											rs1 = null;
										}
										if (pstmt1 != null)
										{
											pstmt1.close();
											pstmt1 = null;
										}
										if (empRelieveDate != null && empRelieveDate.trim().length() > 0 )
										{
											errString = getErrorString("sales_pers__to","INVRELEMP",userId);
											break;
										}

										//Modified by Ramchandra on [07/08/2012] [To Validate Employee not in Hierarcy of loginEmpCode][Start]
										else
										{
											//Modified by Rupesh on [03/09/2012] [To Validate Hierarcy in case of Manager only]
											//if (!vec.contains(salesPersTo))
											
											if (userType.trim().length() > 0 && userType.equalsIgnoreCase("M") && !vec.contains(salesPersTo))
											{
												errString = getErrorString("sales_pers__to","INVHIEEMP",userId);
												break;
											}											
										}
										//Modified by Ramchandra on [07/08/2012] [To Validate Employee not in Hierarcy of loginEmpCode][End]

									}						 
								}
								//Modified by Ramchandra on [07/08/2012] [To validate for employee relieved or not] [End]

							}
						}
						else if (childNodeName.equals("division_opt"))
						{
							if (childNode.getFirstChild() == null)
							{
								errCode = "VDIVOPT";
								errString = getErrorString("division_opt",errCode,userId);
								break;
							}
						}
						else if (childNodeName.equals("copy_opt"))
						{
							if (childNode.getFirstChild() == null)
							{
								errCode = "VCOPYOPT";
								errString = getErrorString("copy_opt",errCode,userId);
								break;
							}
						}
					}//END FOR
					break;
			}//END SWITCH
		}//END TRY
		catch(Exception e)
		{
			System.out.println("Exception ::"+e);
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if ( stmt != null )
				{
					stmt.close();
					stmt = null;
				}
				if ( conn != null )
				{
					conn.close();
					conn = null;
				}
			}
			catch ( Exception e){}
		}
		System.out.println("ErrString ::"+ errString);
		return errString;
	}//END OF VALIDATION 

	public String itemChanged(String xmlString, String xmlString1,String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String valueXmlString = null;
		try
		{
			dom = parseString(xmlString); 
			System.out.println("xmlString" + xmlString);
			dom1 = parseString(xmlString1); 
			if (xmlString2.trim().length() > 0 )
			{
				dom2 = parseString(xmlString2);
			}
			valueXmlString = itemChanged(dom,dom1,dom2,objContext,currentColumn,editFlag,xtraParams);
		}
		catch(Exception e)
		{
			System.out.println("Exception : [StrgSeriesPsrCopyEJB][itemChanged(String,String)] :==>\n"+e.getMessage());
		}
        return valueXmlString; 
	}
	
	public String itemChanged(Document dom, Document dom1,Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		Statement stmt = null;
		ResultSet rs = null;
		NodeList parentNodeList = null;
		Node parentNode = null; 
		Node childNode = null;
		NodeList childNodeList = null;
		String childNodeName = "";
		StringBuffer valueXmlString = new StringBuffer();
		String columnValue = "";
		String sql = "";
		String userId = "";
		String entityCode = "";//Added By Gulzar - 25/08/08 Req ID : SY89SUN001
		
		int count = 0;
		int ctr = 0;
		int currentFormNo = 0;
		Exception exc = new Exception("Editing is not allowed......");
		GenericUtility genericUtility = GenericUtility.getInstance();

		//Modified by Abhishek on [16/11/2013][Request ID:WS3ASUN010][To migrate in gwt][Start]
		
		String windowName = "w_"+getObjName(dom,objContext);
		System.out.println("Window Name Got :::["+windowName+"]");		
		//Modified by Abhishek on [16/11/2013][Request ID:WS3ASUN010][To migrate in gwt][Start]


		try
		{
			//Commented and changed by AMOL S. 10-Apr-2019[START]
			/*conn = connDriver.getConnectDB("DriverITM");
			conn.setAutoCommit(false);*/
			conn = getConnection();
			//Commented and changed by AMOL S. 10-Apr-2019[END]
			//stmt = conn.createStatement();
			userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"userId");
			entityCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"entityCode"); //Added By Gulzar - 25/08/08 Req ID : SY89SUN001
			
			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			System.out.println("[StrgSeriesPsrCopyIcEJB] [itemChanged] :currentFormNo ....." +currentFormNo);
			//Modified by Ganesh [16/05/2013][To add utf-8 in xml format][Start]
			//valueXmlString = new StringBuffer("<?xml version=\"1.0\"?><Root><header><editFlag>");
			valueXmlString = new StringBuffer("<?xml version=\"1.0\" encoding='UTF-8'?><Root><header><editFlag>");
			//Modified by Ganesh [16/05/2013][To add utf-8 in xml format][End]
			valueXmlString.append(editFlag).append("</editFlag></header>");
			
			//Modified by Abhishek on [16/11/2013][To migration in GWT]
			//valueXmlString.append("<Detail>");					
			
			System.out.println("Current Form No ["+currentFormNo+"]");	
			switch (currentFormNo)
			{
				case 1:					
					parentNodeList = dom.getElementsByTagName("Detail1");
					parentNode = parentNodeList.item(0);
					childNodeList = parentNode.getChildNodes();
					ctr = 0;
					int childNodeListLength = childNodeList.getLength();
					do
					{
						childNode = childNodeList.item(ctr);
						childNodeName = childNode.getNodeName();
						if(childNodeName.equals(currentColumn))
						{
							if (childNode.getFirstChild() != null)
							{
								columnValue=childNode.getFirstChild().getNodeValue().trim();
							}
						}
						ctr++;
					}while(ctr < childNodeListLength  && !childNodeName.equals(currentColumn));	

					//Modified by Aadesh on [11/10/2013] [Migration in GWT] [Start]
									
					valueXmlString.append("<Detail1 dbID='' domID='1' objContext='1' objName='strgseriespsrcopy_gwt' selected='N'>\r\n" );
					valueXmlString.append("<attribute pkNames='' status='N' updateFlag='A' selected='N'/>\r\n");

					//Modified by Aadesh on [11/10/2013] [Migration in GWT] [End]

					if (currentColumn.trim().equals("itm_default"))
					{
						String salesPersTo = genericUtility.getColumnValue("sales_pers__to",dom);
						System.out.println("Sales Pers to ===========================>1 item default :: "+salesPersTo);
						String spName = "";

						// Modified by Ramchandra [07/08/2012][To enable if login employee is manager or ho][Start]						
						
						String loginEmpCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode");
							
						String userType = "";
						userType = getUserType(loginEmpCode,conn);
						System.out.println("[StrgSeriesPsrCopy] [itemChanged()][userType] "+userType);
						// Modified by Ramchandra [07/08/2012][To enable if login employee is manager or ho][End]
						
						//Added By Gulzar - 25/08/08 Req ID : SY89SUN001

						// Modified by Ramchandra [07/08/2012][To enable if login employee is manager or ho][Start]
						/*if ( salesPersTo == null || salesPersTo.trim().length() == 0 )
						{
							salesPersTo = entityCode;
						}*/
						// Modified by Ramchandra [07/08/2012][To enable if login employee is manager or ho][End]

						if (salesPersTo != null && salesPersTo.trim().length() > 0 )
						{
							sql = "SELECT COUNT(*) AS COUNT FROM SALES_PERS WHERE SALES_PERS = '"+salesPersTo+"'";
							stmt = conn.createStatement();
							rs = stmt.executeQuery(sql);
							if ( rs.next() )
							{
								count = rs.getInt("COUNT");
							}
							rs.close();
							if ( count > 0 )
							{
								sql = "SELECT SP_NAME FROM SALES_PERS WHERE SALES_PERS = '"+ salesPersTo +"' ";
								System.out.println("SQL for sp_name from sales_pers :: "+sql);
								rs = stmt.executeQuery(sql);	
								if(rs.next())
								{
									spName = rs.getString("SP_NAME");	
								}
								rs.close();
								
								//Modified By Rupesh [08/08/2012] [To protect sales_pers__to]
								//Modified By Ganesh [13/05/2013][To set the value in cdata of xml][Start]
								//valueXmlString.append("<sales_pers__to protect = '1'>").append(salesPersTo).append("</sales_pers__to>\r\n");	
								//valueXmlString.append("<sales_pers__to protect = '1'><![CDATA[").append(salesPersTo).append("]]></sales_pers__to>\r\n");
								valueXmlString.append("<sales_pers__to protect = '1'><![CDATA[").append(salesPersTo.toUpperCase()).append("]]></sales_pers__to>\r\n");
								//Modified By Ganesh [13/05/2013][To set the value in cdata of xml][End]
							}
							else
							{
								//Modified By Ganesh [13/05/2013][To set the value in cdata of xml][Start]
								//valueXmlString.append("<sales_pers__to protect = '0'>").append(salesPersTo).append("</sales_pers__to>\r\n");	
								//valueXmlString.append("<sales_pers__to protect = '0'><![CDATA[").append(salesPersTo).append("]]></sales_pers__to>\r\n");
								valueXmlString.append("<sales_pers__to protect = '0'><![CDATA[").append(salesPersTo.toUpperCase()).append("]]></sales_pers__to>\r\n");
								//Modified By Ganesh [13/05/2013][To set the value in cdata of xml][End]	
							}
							stmt.close();
						}
						//End Changes Gulzar - 25/08/08 Req ID : SY89SUN001

						// Modified by Ramchandra [07/08/2012][To enable if login employee is manager or ho][Start]
						/*valueXmlString.append("<sales_pers__to>").append(salesPersTo == null ? "" :salesPersTo).append("</sales_pers__to>\r\n");//Gulzar - 28/12/09 */
						else
						{
							salesPersTo = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode");
							System.out.println("[StrgSeriesPsrCopy][itemChanged()] [salesPersTo :: ]"+salesPersTo);
							Statement cstmt = null;
							ResultSet crs = null;
							String spnamesql = "";
							spnamesql = "SELECT SP_NAME FROM SALES_PERS WHERE SALES_PERS = '"+ salesPersTo +"' ";
							System.out.println("[StrgSeriesPsrCopy][itemChanged()] [spnameSQL] :: "+spnamesql);
							cstmt = conn.createStatement();
							crs = cstmt.executeQuery(spnamesql);	
							if(crs.next())
							{
								spName = crs.getString("SP_NAME");	
							}
							if (crs != null)
							{
								crs.close();
								crs = null;
							}
							if ( cstmt != null )
							{
								cstmt.close();
								cstmt = null;
							}
							if ( userType != null && (userType.equalsIgnoreCase("M")|| userType.equalsIgnoreCase("H")))
							{													
								//Modified By Rupesh [11/01/2013] [To set blank emp_to] [Start]
								//valueXmlString.append("<sales_pers__to protect= '0'>").append(salesPersTo).append("</sales_pers__to>\r\n");
								//Modified By Ganesh [13/05/2013][To set the value in cdata of xml][Start]
								//valueXmlString.append("<sales_pers__to protect= '0'>").append("").append("</sales_pers__to>\r\n");
								//valueXmlString.append("<name_to>").append("").append("</name_to>\r\n");
								valueXmlString.append("<sales_pers__to protect= '0'><![CDATA[").append("").append("]]></sales_pers__to>\r\n");
								valueXmlString.append("<name_to><![CDATA[").append("").append("]]></name_to>\r\n");
								//Modified By Ganesh [13/05/2013][To set the value in cdata of xml][Start]
								//Modified By Rupesh [11/01/2013] [To set blank emp_to] [End]
							}
							else
							{	
								//Modified By Ganesh [13/05/2013][To set the value in cdata of xml][Start]
								//valueXmlString.append("<sales_pers__to protect= '1'>").append(salesPersTo).append("</sales_pers__to>\r\n");
								//valueXmlString.append("<sales_pers__to protect= '1'><![CDATA[").append(salesPersTo).append("]]></sales_pers__to>\r\n");
								valueXmlString.append("<sales_pers__to protect= '1'><![CDATA[").append(salesPersTo.toUpperCase()).append("]]></sales_pers__to>\r\n");
								//Modified By Rupesh [11/01/2013] [To set name of emp_to] [Start]
								//valueXmlString.append("<name_to>").append(spName == null ? "" :spName).append("</name_to>\r\n");
								valueXmlString.append("<name_to><![CDATA[").append(spName == null ? "" :spName).append("]]></name_to>\r\n");
								//Modified By Ganesh [13/05/2013][To set the value in cdata of xml][End]
								//Modified By Rupesh [11/01/2013] [To set name of emp_to] [End]
							}
						}
						// Modified by Ramchandra [07/08/2012][To enable if login employee is manager or ho][End]
				
						//Modified By Rupesh [11/01/2013] [To set blank emp_to] [Start]
						//valueXmlString.append("<name_to>").append(spName == null ? "" :spName).append("</name_to>\r\n");
						//Modified By Rupesh [11/01/2013] [To set blank emp_to] End]
						//Modified By Ganesh [13/05/2013][To set the value in cdata of xml][Start]
						//valueXmlString.append("<division_opt>").append("N").append("</division_opt>\r\n");
						//valueXmlString.append("<copy_opt>").append("1").append("</copy_opt>\r\n");
						valueXmlString.append("<division_opt><![CDATA[").append("N").append("]]></division_opt>\r\n");
						valueXmlString.append("<copy_opt><![CDATA[").append("1").append("]]></copy_opt>\r\n");
						//Modified By Ganesh [13/05/2013][To set the value in cdata of xml][End]
					}
					else if (currentColumn.trim().equals("sales_pers__from"))
					{
						String salesPersFrom = genericUtility.getColumnValue("sales_pers__from",dom); 
						String spName = "";
						sql = "SELECT SP_NAME FROM SALES_PERS WHERE SALES_PERS = '"+ salesPersFrom +"' ";
						System.out.println("SQL for sp_name from sales_pers :: "+sql);
						stmt = conn.createStatement();
						rs = stmt.executeQuery(sql);	
						if(rs.next())
						{
							spName = rs.getString("SP_NAME");	
							//Modified By Ganesh [13/05/2013][To set the value in cdata of xml][Start]
							//valueXmlString.append("<name_from>").append(spName == null ? "" :spName).append("</name_from>\r\n");
							valueXmlString.append("<name_from><![CDATA[").append(spName == null ? "" :spName).append("]]></name_from>\r\n");
							//Modified By Ganesh [13/05/2013][To set the value in cdata of xml][End]
						}
						else
						{
							//Modified By Ganesh [13/05/2013][To set the value in cdata of xml][Start]
							//valueXmlString.append("<name_from>").append(" ").append("</name_from>\r\n");	
							valueXmlString.append("<name_from><![CDATA[").append(" ").append("]]></name_from>\r\n");
							//Modified By Ganesh [13/05/2013][To set the value in cdata of xml][End]
						}
						rs.close();
						stmt.close();

						//Modified by Abhishek on [16/11/2013][Request ID:WS3ASUN010][To migrate in gwt][Start]

						System.out.println("salesPersFrom got from sales_pers__from node ..::["+salesPersFrom+"]");
						valueXmlString.append("<sales_pers__from><![CDATA[").append(salesPersFrom == null ? "" :salesPersFrom.toUpperCase()).append("]]></sales_pers__from>\r\n");

						//Modified by Abhishek on [16/11/2013][Request ID:WS3ASUN010][To migrate in gwt][End]
						
						
						// ADDED BY VISHAKHA on [26/05/2015] [To migrate in mobile] [START]
						String salesPersTo = genericUtility.getColumnValue("sales_pers__to",dom); 
						String copyTo = genericUtility.getColumnValue("copy_opt",dom); 
						String salesPersToName = getFieldValue("SP_NAME", "SALES_PERS", "SALES_PERS", salesPersTo, conn);
						
						valueXmlString.append("<sales_pers__to><![CDATA[").append(salesPersTo == null ? "" :salesPersTo.toUpperCase()).append("]]></sales_pers__to>\r\n");	
						valueXmlString.append("<name_to><![CDATA[").append(salesPersToName == null ? "" :salesPersToName).append("]]></name_to>\r\n");
						valueXmlString.append("<division_opt><![CDATA[").append("N").append("]]></division_opt>\r\n");
						valueXmlString.append("<copy_opt><![CDATA[").append(copyTo).append("]]></copy_opt>\r\n");
						// ADDED BY VISHAKHA on [26/05/2015] [To migrate in mobile] [END]
						
						
					}
					else if (currentColumn.trim().equals("sales_pers__to"))
					{
						String salesPersTo = genericUtility.getColumnValue("sales_pers__to",dom); 
						System.out.println("Sales Pers to ===========================> "+salesPersTo);
						String spName = "";
						if (salesPersTo != null && salesPersTo.trim().length() > 0)
						{
							sql = "SELECT SP_NAME FROM SALES_PERS WHERE SALES_PERS = '"+ salesPersTo +"' ";
							System.out.println("SQL for sp_name from sales_pers :: "+sql);
							stmt = conn.createStatement();
							rs = stmt.executeQuery(sql);	
							if(rs.next())
							{
								spName = rs.getString("SP_NAME");	
							}
							rs.close();
							stmt.close();

							//Modified by Rupesh [08/08/2012] [To enable sales_pers__to]
							//valueXmlString.append("<sales_pers__to protect = '1' >").append(salesPersTo == null ? "" :salesPersTo).append("</sales_pers__to>\r\n");
							//Modified By Ganesh [13/05/2013][To set the value in cdata of xml][Start]
							//valueXmlString.append("<sales_pers__to>").append(salesPersTo == null ? "" :salesPersTo).append("</sales_pers__to>\r\n");	

							//valueXmlString.append("<name_to>").append(spName == null ? "" :spName).append("</name_to>\r\n");
							valueXmlString.append("<sales_pers__to><![CDATA[").append(salesPersTo == null ? "" :salesPersTo.toUpperCase()).append("]]></sales_pers__to>\r\n");	

							valueXmlString.append("<name_to><![CDATA[").append(spName == null ? "" :spName).append("]]></name_to>\r\n");
														//Modified By Ganesh [13/05/2013][To set the value in cdata of xml][End]
						}
						else
						{
							//Modified By Ganesh [13/05/2013][To set the value in cdata of xml][Start]
							//valueXmlString.append("<name_to>").append(spName == null ? "" :spName).append("</name_to>\r\n");
							valueXmlString.append("<name_to><![CDATA[").append(spName == null ? "" :spName).append("]]></name_to>\r\n");
							//Modified By Ganesh [13/05/2013][To set the value in cdata of xml][End]
						}

						//Modified by Abhishek on [16/11/2013][Request ID:WS3ASUN010][To migrate in gwt][Start]

						System.out.println("salesPersFrom got from sales_pers__from node ..::["+salesPersTo+"]");
						valueXmlString.append("<sales_pers__to><![CDATA[").append(salesPersTo == null ? "" :salesPersTo.toUpperCase()).append("]]></sales_pers__to>\r\n");

						//Modified by Abhishek on [16/11/2013][Request ID:WS3ASUN010][To migrate in gwt][End]
						
						
						// ADDED BY VISHAKHA on [26/05/2015] [To migrate in mobile] [START]
						String salesPersFrom = genericUtility.getColumnValue("sales_pers__from",dom); 
						String salesPersFromName = getFieldValue("SP_NAME", "SALES_PERS", "SALES_PERS", salesPersFrom, conn);
						String copyTo = genericUtility.getColumnValue("copy_opt",dom); 

						valueXmlString.append("<sales_pers__from><![CDATA[").append(salesPersFrom == null ? "" :salesPersFrom.toUpperCase()).append("]]></sales_pers__from>\r\n");	
						valueXmlString.append("<name_from><![CDATA[").append(salesPersFromName == null ? "" :salesPersFromName).append("]]></name_from>\r\n");
						valueXmlString.append("<division_opt><![CDATA[").append("N").append("]]></division_opt>\r\n");
						valueXmlString.append("<copy_opt><![CDATA[").append(copyTo).append("]]></copy_opt>\r\n");
						
						// ADDED BY VISHAKHA on [26/05/2015] [To migrate in mobile] [END]
						

					}
					//Modified by Abhishek on [16/11/2013][To migration in GWT]
					//valueXmlString.append("</Detail>");
					valueXmlString.append("</Detail1>");
					break;

					//Modified by Abhishek on [16/11/2013][Request ID:WS3ASUN010][To migrate in gwt][End]
	              case 2:
	            	  
						if (currentColumn.trim().equalsIgnoreCase("itm_default"))
						{							
							String doctorData = getData(dom2,dom2,windowName,xtraParams);
							System.out.println("doctorData xmlString got to append in detail2 ...::: ["+doctorData+"]");
							valueXmlString.append(doctorData);							
						}
						break;
						//Modified by Abhishek on [16/11/2013][Request ID:WS3ASUN010][To migrate in gwt][End]
			}//END OF SWITCH
			valueXmlString.append("</Root>");				
							
		}//END OF TRY		
		catch(Exception e)
		{
			System.out.println("Exception ::"+ e.getMessage());
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if ( stmt != null )
				{
					stmt.close();
					stmt = null;
				}
				if ( conn != null )
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				System.out.println("Exception ::"+e);
				e.printStackTrace();
			}			
		}
		return valueXmlString.toString();
	}//END OF ITEMCHANGE	

	// Modified by Ramchandra [07/08/2012][To identify login employee is manager or Ho][start]
	private String getUserType(String empCode,Connection conn) throws ITMException
	{
		System.out.println("In getUserType() method");
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String empCodeMGR = "";
		String empCodeHO = "";
		String userType1 = "";
		String selectSql = "";
		boolean isEmpMgr = false;
		try
		{
			selectSql = "SELECT A.EMP_CODE AS EMP_CODE FROM EMPLOYEE A, GRADE B " +
				  "WHERE A.EMP_CODE = ? " + 
				  "AND A.GRADE = B.GRADE_CODE " + 
				  "AND B.GRADE_TYPE = 'M' ";

			pstmt = conn.prepareStatement(selectSql);
			pstmt.setString( 1, empCode );
			System.out.println("[StrgSeriesPsrCopy][getUserType()][selectSQL >>]"+selectSql);
			rs = pstmt.executeQuery();	
			if(rs.next())
			{
				empCodeMGR = checkNull(rs.getString("EMP_CODE"));	
			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			if (empCodeMGR != null && empCodeMGR.trim().length() > 0)
			{
				userType1 = "M";
				isEmpMgr = true;
			}
			if (isEmpMgr == false)
			{
				selectSql = "SELECT EMP_CODE FROM USERS A, USER_RIGHTS B " + 
				  "WHERE A.EMP_CODE = ? " + 
				  "AND A.PROFILE_ID = B.PROFILE_ID " +
				  "AND B.APPLICATION = 'MRO' " +
				  "AND B.MENU_ROW = 1 " +       
				  "AND B.MENU_COL = 1 " +       
				  "AND B.MENU_SUBCOL = 1 " +
				  "AND B.LEVEL_4 = 1 " +        
				  "AND B.LEVEL_5 = 1 " +        
				  "AND B.MENU_NAME = 'MR Online Application' ";

				pstmt = conn.prepareStatement(selectSql);
				pstmt.setString( 1, empCode );
				System.out.println("[StrgSeriesPsrCopy][getUserType()][selectSQL for HO >>] "+selectSql);
				rs = pstmt.executeQuery();	
				if(rs.next())
				{
					empCodeHO = checkNull(rs.getString("EMP_CODE"));	
				}
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if (empCodeHO != null && empCodeHO.trim().length() > 0)
				{
					userType1 = "H";				
				}
			}	
			System.out.println("[StrgSeriesPsrCopy][getUserType()][userType1 >>]"+userType1);
		}
		catch ( Exception e )
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e1){}
		}
		return userType1;		
	}
	private String checkNull(String input)
	{
		if (input==null)
		{
			input="";
		}
		return input;
	}
	// Modified by Ramchandra [07/08/2012][To identify login employee is manager or Ho][End]

	//Modified by Santosh on [30/07/2013][To parameterize the reporting site code][Start]

	public String getFldStaffSiteList(Connection conn)
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String fldStaffSiteString = "";
		String sql = "";
		try
		{
			sql = "SELECT PROP_VALUE FROM PROPERTIES WHERE PROP_NAME = 'FIELDSTAFF_SITELIST' AND ITEM_SER = 'ALL'";
			 pstmt = conn.prepareStatement(sql);
			 rs = pstmt.executeQuery();
			System.out.println("Inside [StrgSeriesPrsCopy][getFldStaffSiteList]sql::>"+sql);

			 if (rs.next())
			 {
				fldStaffSiteString = rs.getString("PROP_VALUE");
				fldStaffSiteString = (fldStaffSiteString == null)? "" : fldStaffSiteString.trim();
				System.out.println("Inside [StrgSeriesPrsCopy][getFldStaffSiteList]fldStaffSiteString::["+fldStaffSiteString+"]");
			 }
			 if (rs!=null)
			 {
				 rs.close();
				 rs = null;
			 }
			 if (pstmt!=null)
			 {
				 pstmt.close();
				 pstmt = null;
			 }
			
		}
		catch (Exception exp)
		{
			System.out.println("Inside Exception catch [StrgSeriesPrsCopy][getFldStaffSiteList]Exception:>>"+exp.getMessage());
			exp.printStackTrace();
		}
		finally
		{
			try
			{
				if (rs!=null)
				{
				 rs.close();
				 rs = null;
				}
				if (pstmt!=null)
				{
				 pstmt.close();
				 pstmt = null;
				}				
			}
			catch (Exception e)
			{
				System.out.println("Inside Exception finally [StrgSeriesPrsCopy][getFldStaffSiteList]Exception:>>"+e.getMessage());
				e.printStackTrace();
			}
		}
		System.out.println("Returning from [StrgSeriesPrsCopy][getFldStaffSiteList]["+fldStaffSiteString+"]");
		return fldStaffSiteString;
	}

	public String getFormattedStringBuff( String data )
	{
		StringBuffer dataString = new StringBuffer();
		try
		{
			String[] dataArr = null;
			
			if ( data.indexOf(",") == -1 )
			{
				dataString.append( "'"+data+"'" );
			}
			else
			{
				dataArr = data.split(",");
				for (int i=0; i < dataArr.length; i++ )
				{
					if ( i == 0 )
					{
						dataString.append( "'"+dataArr[i]+"'" );
					}
					else
					{ 
						dataString.append( "," );
						dataString.append( "'"+dataArr[i]+"'" );
					}										
				}
			}
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
		}	
		return dataString.toString();
	}

	//Modified by Santosh on [30/07/2013][To parameterize the reporting site code][End]
	
	//Modified by Abhishek on [16/11/2013][Request ID:WS3ASUN010][To migrate in gwt][Start]

	public String getData(Document headerDom, Document detailDom, String windowName, String xtraParams) throws RemoteException,ITMException
	{
		//Modified by Abhishek on [To get the file directory][Start]

		if(CommonConstants.J2EE_VERSION.equals("1"))
		{
			logDirName =  CommonConstants.JBOSSHOME  + File.separator + "log" ;
		}
		else if(CommonConstants.J2EE_VERSION.equals("2"))
		{
			logDirName =  CommonConstants.JBOSSHOME   + File.separator + "server"+ File.separator +"default"+ File.separator +"log" ;
		}
		logDir = new File(logDirName);
		filePtr = new File(logDirName+ File.separator + "StrgSeriesPsrCopyPrcGWT.log");

		//Modified by Abhishek on [To get the file directory][End]

		//StringBuffer retTabSepStrBuff = new StringBuffer();//Gulzar - 31/05/08
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		String errCode = "";
		String resultString = "";
		String getSql= "";
		String salesPersFrom = "";
		String salesPersTo = "";
		String divisionOpt = "";
		String divisionTo = "";
		String copyOpt = "";
		String sql= null ;
		ResultSet rs = null;
		ResultSet rs1 = null;
		PreparedStatement pstmt = null;
		Statement stmt = null;
		try
		{
			//valueXmlString added to return the data in xml string format insted of tab separated format - Gulzar - 31/05/08
			//Modified by Ganesh [16/05/2013][To add utf-8 in xml format][Start]
			//StringBuffer valueXmlString = new StringBuffer("<?xml version=\"1.0\"?>\r\n<DocumentRoot>\r\n<description>Datawindow Root</description>\r\n<group0>\r\n<description>Group0 description</description>\r\n<Header0>\r\n<description>Header0 members</description>\r\n");

			//Modified by Abhishek on[18/11/2013][To build the xml string properly][Start]

			//StringBuffer valueXmlString = new StringBuffer("<?xml version=\"1.0\" encoding='UTF-8'?>\r\n<DocumentRoot>\r\n<description>Datawindow Root</description>\r\n<group0>\r\n<description>Group0 description</description>\r\n<Header0>\r\n<description>Header0 members</description>\r\n");
			StringBuffer valueXmlString = new StringBuffer();

			//Modified by Abhishek on[18/11/2013][To build the xml string properly][End]

			//Modified by Ganesh [16/05/2013][To add utf-8 in xml format][End]
			//Commented and changed by AMOL S. 10-Apr-2019[START]
			/*conn = connDriver.getConnectDB("DriverITM");
			conn.setAutoCommit(false);*/
			conn = getConnection();
			//Commented and changed by AMOL S. 10-Apr-2019[END]
			//DatabaseMetaData dbmd = conn.getMetaData();
			//For logonoff
			//logOnOffFlag = "N";
			getSql = "select var_value from disparm where prd_code='999999' and var_name='STRGSERCPY_LOGONOFF'";
			pstmt = conn.prepareStatement(getSql); 
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				logOnOffFlag = rs.getString(1);
				System.out.println("------------------in rs--------");
			}
			if (logOnOffFlag == null || logOnOffFlag.trim().length() == 0)
			{
				logOnOffFlag = "N";
			}
			System.out.println("----------------logOnOff:"+logOnOffFlag);
			rs.close();
			pstmt.close();
			

			salesPersFrom = genericUtility.getColumnValue("sales_pers__from",headerDom);
			salesPersTo = genericUtility.getColumnValue("sales_pers__to",headerDom);
			divisionOpt = genericUtility.getColumnValue("division_opt",headerDom);
			copyOpt = genericUtility.getColumnValue("copy_opt",headerDom);
			System.out.println("divisionOpt ============================> "+divisionOpt);
			System.out.println("copyOpt ============================> "+copyOpt);

			sql = "SELECT ITEM_SER FROM SALES_PERS WHERE SALES_PERS = '"+ salesPersTo +"' ";
			writeLog(filePtr,"sql-->"+sql,true);
			System.out.println("SQL from strg_customer :: "+sql);
			stmt = conn.createStatement();
			rs = stmt.executeQuery(sql);
			if (rs.next())
			{
				divisionTo = rs.getString("ITEM_SER");
			}
			rs.close();
			stmt.close();

			if ( copyOpt != null && copyOpt.trim().length()>0 )
			{
				getSql= "SELECT STRG_CUSTOMER.SC_CODE, "
					+" RTRIM(STRG_CUSTOMER.FIRST_NAME)||' '||RTRIM(STRG_CUSTOMER.MIDDLE_NAME)||' '||RTRIM(STRG_CUSTOMER.LAST_NAME) AS NAME, "
					+" STRG_CUSTOMER.QUALIFICATION, "
					+" STRG_CUSTOMER.CITY, "
					+" STRG_CUSTOMER.STATUS, "
					+" STRG_CUSTOMER.SEX, "
					+" STRG_CUSTOMER.ADDED_DATE, "
					+" STRG_CUSTOMER.RES_CITY, "
					+" STRG_CUSTOMER.EMAIL_ADDR, "
					+" STRG_SERIES.ITEM_SER, "
					+" CASE WHEN STRG_SERIES.CLASS_CODE IS NULL THEN 'N' ELSE STRG_SERIES.CLASS_CODE END AS CLASS_CODE, "
					+" STRG_SERIES.NO_VISIT, "
					+" STRG_SERIES.SHORT_ID, "
					+" STRG_CUSTOMER.LOCALITY_CODE, "
					+" RTRIM(STRG_CUSTOMER.ADDR1)  ADDR1, "
					+" RTRIM(STRG_CUSTOMER.ADDR2) ADDR2, "
					+" RTRIM(STRG_CUSTOMER.ADDR3) ADDR3, "
					+" STRG_CUSTOMER.STAN_CODE, "
					+" STRG_CUSTOMER.STATE_CODE, "
					+" STRG_CUSTOMER.PIN, "
					+" STRG_CUSTOMER.COUNT_CODE  , "
					+" ITEMSER.DESCR, "
					+" RTRIM(STRG_CUSTOMER.RES_ADDR1)  RESADDR1, "
					+" RTRIM(STRG_CUSTOMER.RES_ADDR2) RESADDR2, "
					+" RTRIM(STRG_CUSTOMER.RES_ADDR3) RESADDR3, "
					+" STRG_CUSTOMER.RES_STAN_CODE, "
					+" STRG_CUSTOMER.RES_STATE_CODE, "
					+" STRG_CUSTOMER.RES_PIN, "
					+" STRG_CUSTOMER.RES_COUNT_CODE, "
					+" STRG_CUSTOMER.RES_LOCALITY_CODE, "
					+" SALES_PERS.SP_NAME, "
					+" STRG_SERIES.SALES_PERS__OLD , "
					+" STRG_SERIES.REASON AS REASON, "
					+" STRG_SERIES.EFF_DATE AS EFF_DATE , "
					//Modified By Rupesh [11/01/2013] [To display speciality descr.][Start]
					//+" STRG_SERIES.SPL_CODE , "
					+"SPECIALITY.DESCR AS SPECIALITY_DESCR, "  
					//Modified By Rupesh [11/01/2013] [To display speciality descr.][End]
					// Modified by Prashant on [23/02/2013][To set spl_code and speciality_descr in xml]
					+" STRG_SERIES.SPL_CODE , "
					+" STRG_SERIES.ROUTE_ID, "
					+" STRG_SERIES.NO_PATIENT_DAY "
					//Added by satya on 03/06/10[WS90SUN031].start
					+", STRG_SERIES.RETAILER_CODE"
					+", STRG_SERIES.RETAILER_NAME"
					+", STRG_SERIES.RETAILER_ADR1"
					+", STRG_SERIES.RETAILER_ADR2"
					+", STRG_SERIES.RETAILER_ADR3"
					+", STRG_SERIES.RETAILER_CITY"
					+", STRG_SERIES.RETAILER_PIN "
					+", STRG_SERIES.RETAILER_TEL1"
					+", STRG_SERIES.RETAILER_TEL2"
					+", STRG_SERIES.RETAILER_MOBNO"
					+", STRG_SERIES.RETAILER_LOCALITY "
					//Added by satya on 03/06/10[WS90SUN031].end
					+", STRG_SERIES.CATEGORY "//Gulzar - 11/01/11
					//Modified by Rupesh on[30/07/2012] [To append required fields only][Start]
					+", LOCALITY.DESCR AS LOCALITY_DESCR"
					+", STRG_SERIES.SALES_PERS, ";
					//Modified by Rupesh on[30/07/2012] [To append required fields only][End]
				if (copyOpt.trim().equals("1") && divisionOpt.trim().equals("N"))
				{
					getSql = getSql +" 0 AS OPT "
					//Modified by Rupesh on[30/07/2012] [To append required fields only]
					//+" FROM STRG_CUSTOMER, "
					+" FROM STRG_CUSTOMER, LOCALITY, "
					//Modified By Rupesh [12/01/2013] [To display speciality descr.][Start]
					//+" STRG_SERIES, ITEMSER, SALES_PERS, SPRS_ROUTE"
					+" STRG_SERIES, ITEMSER, SALES_PERS, SPRS_ROUTE, SPECIALITY "
					//Modified By Rupesh [12/01/2013] [To display speciality descr.][End]
					+" WHERE ( STRG_SERIES.SALES_PERS__OLD = SALES_PERS.SALES_PERS (+)) AND "
					+" ( STRG_SERIES.SC_CODE = STRG_CUSTOMER.SC_CODE ) AND "
					+" ( STRG_SERIES.ITEM_SER = ITEMSER.ITEM_SER ) AND "
					+" ( STRG_SERIES.SALES_PERS = SPRS_ROUTE.SPRS_CODE) AND "
					+" ( STRG_SERIES.ROUTE_ID = SPRS_ROUTE.ROUTE_ID) AND "
					//Modified by Rupesh on[30/07/2012] [To append required fields only]
					+" (STRG_CUSTOMER.LOCALITY_CODE = LOCALITY.LOCALITY_CODE) AND "
					//Modified By Rupesh [12/01/2013] [To display speciality descr.][Start]
					+" ( SPECIALITY.SPL_CODE = STRG_SERIES.SPL_CODE ) AND  "
					//Modified By Rupesh [12/01/2013] [To display speciality descr.][End]
					+" ( STRG_SERIES.SC_CODE NOT IN "
					//+" 	( SELECT SC_CODE FROM STRG_SERIES WHERE SALES_PERS = ?)) AND " //Gulzar - 22/08/08 Req ID : SY89SUN001
					//+" ( STRG_SERIES.SALES_PERS = ? ) AND " //Gulzar - 22/08/08 Req ID : SY89SUN001
					+" 	( SELECT SC_CODE FROM STRG_SERIES WHERE SALES_PERS = '"+salesPersTo+"' )) AND " //Gulzar - 22/08/08 Req ID : SY89SUN001
					+" ( STRG_SERIES.SALES_PERS = '"+salesPersFrom+"' ) AND " //Gulzar - 22/08/08 Req ID : SY89SUN001
					+" 	( STRG_CUSTOMER.STATUS = 'A' ) AND "
					+" 	( STRG_SERIES.STATUS = 'Y' ) "
					+" 	AND SPRS_ROUTE.STATUS='Y' "
					+"ORDER BY  LOCALITY_DESCR ASC,  NAME ASC";  
					pstmt = conn.prepareStatement(getSql);   
					//pstmt.setString(1,salesPersTo); //Gulzar - 22/08/08 Req ID : SY89SUN001
					//pstmt.setString(2,salesPersFrom); //Gulzar - 22/08/08 Req ID : SY89SUN001
				}
				else if (copyOpt.trim().equals("1") && divisionOpt.trim().equals("Y"))
				{
					getSql = getSql+" 1 AS OPT "
					//Modified by Rupesh on[30/07/2012] [To append required fields only]
					//+" FROM STRG_CUSTOMER, "
					+" FROM STRG_CUSTOMER, LOCALITY, "				
					//Modified By Rupesh [12/01/2013] [To display speciality descr.][Start]
					//+" STRG_SERIES, ITEMSER, SALES_PERS, SPRS_ROUTE "
					+" STRG_SERIES, ITEMSER, SALES_PERS, SPRS_ROUTE, SPECIALITY "
					//Modified By Rupesh [12/01/2013] [To display speciality descr.][End]
					+" WHERE ( STRG_SERIES.SALES_PERS__OLD = SALES_PERS.SALES_PERS (+)) AND "
					+" ( STRG_SERIES.SC_CODE = STRG_CUSTOMER.SC_CODE ) AND "
					+" ( STRG_SERIES.ITEM_SER = ITEMSER.ITEM_SER ) AND "
					+" ( STRG_SERIES.SALES_PERS = SPRS_ROUTE.SPRS_CODE) AND "
					+" ( STRG_SERIES.ROUTE_ID = SPRS_ROUTE.ROUTE_ID) AND "
					//Modified by Rupesh on[30/07/2012] [To append required fields only]
					+" (STRG_CUSTOMER.LOCALITY_CODE = LOCALITY.LOCALITY_CODE) AND "
					//Modified By Rupesh [12/01/2013] [To display speciality descr.][Start]
					+" ( SPECIALITY.SPL_CODE = STRG_SERIES.SPL_CODE ) AND  "
					//Modified By Rupesh [12/01/2013] [To display speciality descr.][End]
					+" ( STRG_SERIES.SC_CODE NOT IN "
					//+" 	( SELECT SC_CODE FROM STRG_SERIES WHERE SALES_PERS = ?)) AND " //Gulzar - 22/08/08 Req ID : SY89SUN001
					+" 	( SELECT SC_CODE FROM STRG_SERIES WHERE SALES_PERS = '"+salesPersTo+"' )) AND " //Gulzar - 22/08/08 Req ID : SY89SUN001
					+" 	( STRG_CUSTOMER.STATUS = 'A' ) AND "
					+" 	( STRG_SERIES.STATUS = 'Y' ) "
					+" 	AND SPRS_ROUTE.STATUS='Y' "
					+"ORDER BY  LOCALITY_DESCR ASC,  NAME ASC";  
					pstmt = conn.prepareStatement(getSql);   
					//pstmt.setString(1,salesPersTo);//Gulzar - 22/08/08 Req ID : SY89SUN001
				}				
				else if (copyOpt.trim().equals("2") && divisionOpt.trim().equals("N"))
				{
					getSql = getSql+" 2 AS OPT "
					//Modified by Rupesh on[30/07/2012] [To append required fields only]
					//+" FROM STRG_CUSTOMER, "
					+" FROM STRG_CUSTOMER, LOCALITY, "
					//Modified By Rupesh [12/01/2013] [To display speciality descr.][Start]
					//+" STRG_SERIES, ITEMSER, SALES_PERS, SPRS_ROUTE "
					+" STRG_SERIES, ITEMSER, SALES_PERS, SPRS_ROUTE, SPECIALITY"
					//Modified By Rupesh [12/01/2013] [To display speciality descr.][End]
					+" WHERE ( STRG_SERIES.SALES_PERS__OLD = SALES_PERS.SALES_PERS (+)) AND "
					+" ( STRG_SERIES.SC_CODE = STRG_CUSTOMER.SC_CODE ) AND "
					+" ( STRG_SERIES.ITEM_SER = ITEMSER.ITEM_SER ) AND "
					+" ( STRG_SERIES.SALES_PERS = SPRS_ROUTE.SPRS_CODE) AND "
					+" ( STRG_SERIES.ROUTE_ID = SPRS_ROUTE.ROUTE_ID) AND "
					//Modified by Rupesh on[30/07/2012] [To append required fields only]
					+" (STRG_CUSTOMER.LOCALITY_CODE = LOCALITY.LOCALITY_CODE) AND "
					//Modified By Rupesh [12/01/2013] [To display speciality descr.][Start]
					+" ( SPECIALITY.SPL_CODE = STRG_SERIES.SPL_CODE ) AND  "
					//Modified By Rupesh [12/01/2013] [To display speciality descr.][End]
					+" ( STRG_SERIES.SC_CODE NOT IN "
					//+" ( SELECT SC_CODE FROM STRG_SERIES WHERE SALES_PERS = ?)) AND " //Gulzar - 22/08/08 Req ID : SY89SUN001
					//+" ( STRG_SERIES.ITEM_SER = ? ) AND " //Gulzar - 22/08/08 Req ID : SY89SUN001
					//+" ( STRG_SERIES.SALES_PERS = ? ) AND " //Gulzar - 22/08/08 Req ID : SY89SUN001
					+" ( SELECT SC_CODE FROM STRG_SERIES WHERE SALES_PERS = '"+salesPersTo+"' )) AND " //Gulzar - 22/08/08 Req ID : SY89SUN001
					+" ( STRG_SERIES.ITEM_SER = '"+divisionTo+"' ) AND " //Gulzar - 22/08/08 Req ID : SY89SUN001
					+" ( STRG_SERIES.SALES_PERS = '"+salesPersFrom+"' ) AND " //Gulzar - 22/08/08 Req ID : SY89SUN001
					+" 	( STRG_CUSTOMER.STATUS = 'A' ) AND "
					+" 	( STRG_SERIES.STATUS = 'Y' ) "
					+" 	AND SPRS_ROUTE.STATUS='Y' "
					+"ORDER BY  LOCALITY_DESCR ASC,  NAME ASC";  
					pstmt = conn.prepareStatement(getSql);   
					//pstmt.setString(1,salesPersTo); //Gulzar - 22/08/08 Req ID : SY89SUN001
					//pstmt.setString(2,divisionTo); //Gulzar - 22/08/08 Req ID : SY89SUN001
					//pstmt.setString(3,salesPersFrom); //Gulzar - 22/08/08 Req ID : SY89SUN001
				}				
				else if (copyOpt.trim().equals("2") && divisionOpt.trim().equals("Y"))
				{
					getSql = getSql+" 3 AS OPT "
					//Modified by Rupesh on[30/07/2012] [To append required fields only]
					//+" FROM STRG_CUSTOMER, "
					+" FROM STRG_CUSTOMER, LOCALITY, "
					//Modified By Rupesh [12/01/2013] [To display speciality descr.][Start]
					//+" STRG_SERIES, ITEMSER, SALES_PERS, SPRS_ROUTE "
					+" STRG_SERIES, ITEMSER, SALES_PERS, SPRS_ROUTE, SPECIALITY "
					//Modified By Rupesh [12/01/2013] [To display speciality descr.][End]
					+" WHERE ( STRG_SERIES.SALES_PERS__OLD = SALES_PERS.SALES_PERS (+)) AND "
					+" ( STRG_SERIES.SC_CODE = STRG_CUSTOMER.SC_CODE ) AND "
					+" ( STRG_SERIES.ITEM_SER = ITEMSER.ITEM_SER ) AND "
					+" ( STRG_SERIES.SALES_PERS = SPRS_ROUTE.SPRS_CODE) AND "
					+" ( STRG_SERIES.ROUTE_ID = SPRS_ROUTE.ROUTE_ID) AND "
					//Modified by Rupesh on[30/07/2012] [To append required fields only]
					+" (STRG_CUSTOMER.LOCALITY_CODE = LOCALITY.LOCALITY_CODE) AND "
					//Modified By Rupesh [12/01/2013] [To display speciality descr.][Start]
					+" ( SPECIALITY.SPL_CODE = STRG_SERIES.SPL_CODE ) AND  "
					//Modified By Rupesh [12/01/2013] [To display speciality descr.][End]
					+" ( STRG_SERIES.SC_CODE NOT IN "
					//+" ( SELECT SC_CODE FROM STRG_SERIES WHERE SALES_PERS = ?)) AND " //Gulzar - 22/08/08 Req ID : SY89SUN001
					//+" ( STRG_SERIES.ITEM_SER = ? ) AND " //Gulzar - 22/08/08 Req ID : SY89SUN001
					+" ( SELECT SC_CODE FROM STRG_SERIES WHERE SALES_PERS = '"+salesPersTo+"' )) AND " //Gulzar - 22/08/08
					+" ( STRG_SERIES.ITEM_SER = '"+divisionTo+"' ) AND " //Gulzar - 22/08/08
					+" 	( STRG_CUSTOMER.STATUS = 'A' ) AND "
					+" 	( STRG_SERIES.STATUS = 'Y' ) "
					+" 	AND SPRS_ROUTE.STATUS='Y' " 
					+"ORDER BY  LOCALITY_DESCR ASC,  NAME ASC";  
					
					pstmt = conn.prepareStatement(getSql);   
					//pstmt.setString(1,salesPersTo); //Gulzar - 22/08/08 Req ID : SY89SUN001
					//pstmt.setString(2,divisionTo); //Gulzar - 22/08/08 Req ID : SY89SUN001
				}				
				System.out.println("SQL==>"+getSql);
				writeLog(filePtr,"getSql -->"+getSql,true);
				rs = pstmt.executeQuery();
				int domID = 2;//Gulzar - 31/05/08
				while(rs.next())
				{
					/*-- Commented and Changes below to retun data in xml string format insted of tab separated format - Gulzar - 31/05/08
					retTabSepStrBuff.append((rs.getString("sc_code")==null)?" " :rs.getString("sc_code")).append("\t");					
					retTabSepStrBuff.append((rs.getString("name")==null)?" " :rs.getString("name")).append("\t");
					retTabSepStrBuff.append((rs.getString("qualification")==null)?" " :rs.getString("qualification")).append("\t");
					retTabSepStrBuff.append((rs.getString("city")==null)?" " :rs.getString("city")).append("\t");
					retTabSepStrBuff.append((rs.getString("status")==null)?" " :rs.getString("status")).append("\t");
					retTabSepStrBuff.append((rs.getString("sex")==null)?" " :rs.getString("sex")).append("\t");
					retTabSepStrBuff.append(rs.getTimestamp("added_date")).append("\t");
					retTabSepStrBuff.append((rs.getString("res_city")==null)?" " :rs.getString("res_city")).append("\t");
					retTabSepStrBuff.append((rs.getString("email_addr")==null)?" " :rs.getString("email_addr")).append("\t");
					retTabSepStrBuff.append((rs.getString("item_ser")==null)?" " :rs.getString("item_ser")).append("\t");
					retTabSepStrBuff.append((rs.getString("class_code")==null)?" " :rs.getString("class_code")).append("\t");
					retTabSepStrBuff.append((rs.getString("no_visit")==null)?" " :rs.getString("no_visit")).append("\t");////
					retTabSepStrBuff.append((rs.getString("short_id")==null)?" " :rs.getString("short_id")).append("\t");
					retTabSepStrBuff.append((rs.getString("locality_code")==null)?" " :rs.getString("locality_code")).append("\t");
					retTabSepStrBuff.append((rs.getString("addr1")==null)?" " :rs.getString("addr1")).append("\t");
					retTabSepStrBuff.append((rs.getString("addr2")==null)?" " :rs.getString("addr2")).append("\t");
					retTabSepStrBuff.append((rs.getString("addr3")==null)?" " :rs.getString("addr3")).append("\t");
					retTabSepStrBuff.append((rs.getString("stan_code")==null)?" " :rs.getString("stan_code")).append("\t");
					retTabSepStrBuff.append((rs.getString("state_code")==null)?" " :rs.getString("state_code")).append("\t");
					retTabSepStrBuff.append((rs.getString("pin")==null)?" " :rs.getString("pin")).append("\t");
					retTabSepStrBuff.append((rs.getString("count_code")==null)?" " :rs.getString("count_code")).append("\t");
					retTabSepStrBuff.append((rs.getString("descr")==null)?" " :rs.getString("descr")).append("\t");
					retTabSepStrBuff.append((rs.getString("resaddr1")==null)?" " :rs.getString("resaddr1")).append("\t");
					retTabSepStrBuff.append((rs.getString("resaddr2")==null)?" " :rs.getString("resaddr2")).append("\t");
					retTabSepStrBuff.append((rs.getString("resaddr3")==null)?" " :rs.getString("resaddr3")).append("\t");
					retTabSepStrBuff.append((rs.getString("res_stan_code")==null)?" " :rs.getString("res_stan_code")).append("\t");
					retTabSepStrBuff.append((rs.getString("res_state_code")==null)?" " :rs.getString("res_state_code")).append("\t");
					retTabSepStrBuff.append((rs.getString("res_pin")==null)?" " :rs.getString("res_pin")).append("\t");
					retTabSepStrBuff.append((rs.getString("res_count_code")==null)?" " :rs.getString("res_count_code")).append("\t");
					retTabSepStrBuff.append((rs.getString("res_locality_code")==null)?" " :rs.getString("res_locality_code")).append("\t");
					retTabSepStrBuff.append((rs.getString("sp_name")==null)?" " :rs.getString("sp_name")).append("\t");
					retTabSepStrBuff.append((rs.getString("sales_pers__old")==null)?" " :rs.getString("sales_pers__old")).append("\t");
					retTabSepStrBuff.append((rs.getString("reason")==null)?" " :rs.getString("reason")).append("\t");
					retTabSepStrBuff.append(rs.getTimestamp("eff_date")).append("\t");
					retTabSepStrBuff.append((rs.getString("spl_code")==null)?" " :rs.getString("spl_code")).append("\t");
					retTabSepStrBuff.append((rs.getString("route_id")==null)?" " :rs.getString("route_id")).append("\t");
					retTabSepStrBuff.append((rs.getString("no_patient_day")==null)?" " :rs.getString("no_patient_day")).append("\t");
					retTabSepStrBuff.append((rs.getString("opt")==null)?" " :rs.getString("opt")).append("\r\n");
					*/
					//Added - Changes belwo - Gulzar - 31/05/08
					
					//Modified by Abhishek on [16/11/2013][Request ID:WS3ASUN010][To migrate in gwt][Start]

					//valueXmlString.append("<Detail2 domID='"+domID+"' >\r\n");		
					
					//valueXmlString.append("<attribute updateFlag='N' selected='N' />\r\n");

					//valueXmlString.append( "<Detail2 dbID='' domID='"+domID+"' objContext='2' objName='strgseriespsrcopy_gwt' selected='N'>\r\n" );
					//valueXmlString.append("<attribute pkNames='' status='N' updateFlag='A' selected='N' />\r\n");	
					

					valueXmlString.append( "<Detail2 dbID='' domID='"+domID+"' objContext='2' objName='strgseriespsrcopy_gwt' selected='N'>\r\n" );
				//	valueXmlString.append("<attribute pkNames='' status='N' updateFlag='A' selected='N'/>\r\n");
					valueXmlString.append("<attribute pkNames='' status='N' updateFlag='N' selected='N'/>\r\n");

					//Modified by Abhishek on [16/11/2013][Request ID:WS3ASUN010][To migrate in gwt][End]

					valueXmlString.append("<is_selected><![CDATA[").append("").append("]]></is_selected>\r\n"); //Gulzar - 22/08/08

					//Modified by Rupesh on[30/07/2012] [To append required fields only][Start]
					/*
					valueXmlString.append("<sc_code><![CDATA[").append(checkNull(rs.getString("sc_code"))).append("]]></sc_code>\r\n");
					valueXmlString.append("<name><![CDATA[").append(checkNull(rs.getString("name"))).append("]]></name>\r\n");
					valueXmlString.append("<city><![CDATA[").append(checkNull(rs.getString("city"))).append("]]></city>\r\n");
					valueXmlString.append("<qualification><![CDATA[").append(checkNull(rs.getString("qualification"))).append("]]></qualification>\r\n");
					valueXmlString.append("<reason><![CDATA[").append(checkNull(rs.getString("reason"))).append("]]></reason>\r\n");
					valueXmlString.append("<eff_date><![CDATA[").append(rs.getTimestamp("eff_date")).append("]]></eff_date>\r\n");
					valueXmlString.append("<item_ser><![CDATA[").append(checkNull(rs.getString("item_ser"))).append("]]></item_ser>\r\n");
					valueXmlString.append("<descr><![CDATA[").append(checkNull(rs.getString("descr"))).append("]]></descr>\r\n");
					valueXmlString.append("<class_code><![CDATA[").append(checkNull(rs.getString("class_code"))).append("]]></class_code>\r\n");
					valueXmlString.append("<short_id><![CDATA[").append(checkNull(rs.getString("short_id"))).append("]]></short_id>\r\n");
					valueXmlString.append("<no_of_visit><![CDATA[").append(rs.getInt("no_visit")).append("]]></no_of_visit>\r\n");
					valueXmlString.append("<spl_code><![CDATA[").append(checkNull(rs.getString("spl_code"))).append("]]></spl_code>\r\n");
					valueXmlString.append("<addr1><![CDATA[").append(checkNull(rs.getString("addr1"))).append("]]></addr1>\r\n");
					valueXmlString.append("<addr2><![CDATA[").append(checkNull(rs.getString("addr2"))).append("]]></addr2>\r\n");
					valueXmlString.append("<addr3><![CDATA[").append(checkNull(rs.getString("addr3"))).append("]]></addr3>\r\n");
					valueXmlString.append("<locality_code><![CDATA[").append(checkNull(rs.getString("locality_code"))).append("]]></locality_code>\r\n");
					valueXmlString.append("<stan_code><![CDATA[").append(checkNull(rs.getString("stan_code"))).append("]]></stan_code>\r\n");
					valueXmlString.append("<state_code><![CDATA[").append(checkNull(rs.getString("state_code"))).append("]]></state_code>\r\n");
					valueXmlString.append("<pin><![CDATA[").append(checkNull(rs.getString("pin"))).append("]]></pin>\r\n");
					valueXmlString.append("<count_code><![CDATA[").append(checkNull(rs.getString("count_code"))).append("]]></count_code>\r\n");
					valueXmlString.append("<status><![CDATA[").append(checkNull(rs.getString("status"))).append("]]></status>\r\n");
					valueXmlString.append("<sex><![CDATA[").append(checkNull(rs.getString("sex"))).append("]]></sex>\r\n");
					valueXmlString.append("<added_date><![CDATA[").append(checkNull(rs.getString("added_date"))).append("]]></added_date>\r\n"); //Gulzar - 9/19/2008 - Check for null
					valueXmlString.append("<res_city><![CDATA[").append(checkNull(rs.getString("res_city"))).append("]]></res_city>\r\n");
					valueXmlString.append("<email_addr><![CDATA[").append(checkNull(rs.getString("email_addr"))).append("]]></email_addr>\r\n");
					valueXmlString.append("<sales_pers__old><![CDATA[").append(checkNull(rs.getString("sales_pers__old"))).append("]]></sales_pers__old>\r\n");
					valueXmlString.append("<sp_name><![CDATA[").append(checkNull(rs.getString("sp_name"))).append("]]></sp_name>\r\n");
					valueXmlString.append("<opt><![CDATA[").append(checkNull(rs.getString("opt"))).append("]]></opt>\r\n");
					valueXmlString.append("<resaddr1><![CDATA[").append(checkNull(rs.getString("resaddr1"))).append("]]></resaddr1>\r\n");
					valueXmlString.append("<resaddr2><![CDATA[").append(checkNull(rs.getString("resaddr2"))).append("]]></resaddr2>\r\n");
					valueXmlString.append("<resaddr3><![CDATA[").append(checkNull(rs.getString("resaddr3"))).append("]]></resaddr3>\r\n");
					valueXmlString.append("<res_stan_code><![CDATA[").append(checkNull(rs.getString("res_stan_code"))).append("]]></res_stan_code>\r\n");
					valueXmlString.append("<res_state_code><![CDATA[").append(checkNull(rs.getString("res_state_code"))).append("]]></res_state_code>\r\n");
					valueXmlString.append("<res_pin><![CDATA[").append(checkNull(rs.getString("res_pin"))).append("]]></res_pin>\r\n");
					valueXmlString.append("<res_count_code><![CDATA[").append(checkNull(rs.getString("res_count_code"))).append("]]></res_count_code>\r\n");
					valueXmlString.append("<res_locality_code><![CDATA[").append(checkNull(rs.getString("res_locality_code"))).append("]]></res_locality_code>\r\n");
					valueXmlString.append("<route_id><![CDATA[").append(checkNull(rs.getString("route_id"))).append("]]></route_id>\r\n");
					valueXmlString.append("<no_patient_day><![CDATA[").append(rs.getInt("no_patient_day")).append("]]></no_patient_day>\r\n");
					//Added by satya on 03/06/10[WS90SUN031].start
					valueXmlString.append("<retailer_code><![CDATA[").append(checkNull(rs.getString("RETAILER_CODE"))).append("]]></retailer_code>\r\n");
					valueXmlString.append("<retailer_name><![CDATA[").append(checkNull(rs.getString("RETAILER_NAME"))).append("]]></retailer_name>\r\n");
					valueXmlString.append("<retailer_adr1><![CDATA[").append(checkNull(rs.getString("RETAILER_ADR1"))).append("]]></retailer_adr1>\r\n");
					valueXmlString.append("<retailer_adr2><![CDATA[").append(checkNull(rs.getString("RETAILER_ADR2"))).append("]]></retailer_adr2>\r\n");
					valueXmlString.append("<retailer_adr3><![CDATA[").append(checkNull(rs.getString("RETAILER_ADR3"))).append("]]></retailer_adr3>\r\n");
					valueXmlString.append("<retailer_city><![CDATA[").append(checkNull(rs.getString("RETAILER_CITY"))).append("]]></retailer_city>\r\n");
					valueXmlString.append("<retailer_pin><![CDATA[").append(checkNull(rs.getString("RETAILER_PIN"))).append("]]></retailer_pin>\r\n");
					valueXmlString.append("<retailer_tel1><![CDATA[").append(checkNull(rs.getString("RETAILER_TEL1"))).append("]]></retailer_tel1>\r\n");
					valueXmlString.append("<retailer_tel2><![CDATA[").append(checkNull(rs.getString("RETAILER_TEL2"))).append("]]></retailer_tel2>\r\n");
					valueXmlString.append("<retailer_mobno><![CDATA[").append(checkNull(rs.getString("RETAILER_MOBNO"))).append("]]></retailer_mobno>\r\n");
					valueXmlString.append("<retailer_locality><![CDATA[").append(checkNull(rs.getString("RETAILER_LOCALITY"))).append("]]></retailer_locality>\r\n");
					//Added by satya on 03/06/10[WS90SUN031].end
					valueXmlString.append("<category><![CDATA[").append(checkNull(rs.getString("CATEGORY"))).append("]]></category>\r\n");
					*/					
					valueXmlString.append("<sc_code><![CDATA[").append(checkNull(rs.getString("sc_code"))).append("]]></sc_code>\r\n");
					valueXmlString.append("<name><![CDATA[").append(checkNull(rs.getString("name"))).append("]]></name>\r\n");
					valueXmlString.append("<item_ser><![CDATA[").append(checkNull(rs.getString("item_ser"))).append("]]></item_ser>\r\n");
					valueXmlString.append("<locality_descr><![CDATA[").append(checkNull(rs.getString("locality_descr"))).append("]]></locality_descr>\r\n");
					valueXmlString.append("<class_code><![CDATA[").append(checkNull(rs.getString("class_code"))).append("]]></class_code>\r\n");

					valueXmlString.append("<no_of_visit><![CDATA[").append(rs.getInt("no_visit")).append("]]></no_of_visit>\r\n");
				
					//Modified By Rupesh [12/01/2013] [To display speciality descr.][Start]	//valueXmlString.append("<spl_code><![CDATA[").append(checkNull(rs.getString("spl_code"))).append("]]></spl_code>\r\n");
					// Modified by Prashant on [23/02/2013][To set spl_code and speciality_descr in xml][Start]
					//valueXmlString.append("<spl_code><![CDATA[").append(checkNull(rs.getString("SPECIALITY_DESCR"))).append("]]></spl_code>\r\n");
					valueXmlString.append("<spl_code><![CDATA[").append(checkNull(rs.getString("SPL_CODE"))).append("]]></spl_code>\r\n");
					valueXmlString.append("<speciality_descr><![CDATA[").append(checkNull(rs.getString("SPECIALITY_DESCR"))).append("]]></speciality_descr>\r\n");
					// Modified by Prashant on [23/02/2013][To set spl_code and speciality_descr in xml][End]
					//Modified By Rupesh [12/01/2013] [To display speciality descr.][End]
					
					valueXmlString.append("<opt><![CDATA[").append(checkNull(rs.getString("opt"))).append("]]></opt>\r\n");

					valueXmlString.append("<sales_pers><![CDATA[").append(checkNull(rs.getString("sales_pers"))).append("]]></sales_pers>\r\n");
					valueXmlString.append("<route_id><![CDATA[").append(checkNull(rs.getString("route_id"))).append("]]></route_id>\r\n");

					//Modified by Rupesh on[30/07/2012] [To append required fields only][End]

					//Gulzar - 11/01/11 - WS01SUN038
					valueXmlString.append("</Detail2>\r\n");	
					domID++;
					//End Changes - Gulzar - 31/05/08
				}
				//resultString = retTabSepStrBuff.toString(); //Gulzar - 31/05/08

				//Modified by Abhishek on[18/11/2013][To build the xml string properly][Start]

				//valueXmlString.append("</Header0>\r\n"); //Gulzar - 31/05/08
				//valueXmlString.append("</group0>\r\n");	//Gulzar - 31/05/08
				//valueXmlString.append("</DocumentRoot>\r\n"); //Gulzar - 31/05/08

				//Modified by Abhishek on[18/11/2013][To build the xml string properly][End]

				resultString = valueXmlString.toString();//Gulzar - 31/05/08
			}
		}	
		catch(Exception e)
		{
			writeLog(filePtr,"Exception in getData-->"+e,true);
			System.out.println("Exception in getData-->"+e.toString());
			 throw new ITMException(e);				
		}
		finally
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if ( conn != null )
				{
					conn.close();
					conn = null;
				}
			}
			catch (Exception e)
			{
				writeLog(filePtr,"In Fianally... Exception in getData-->"+e,true);
				System.out.println(e.getMessage());					
			}
		}
		return resultString;	
	}
	private String getObjName(Document dom2,String objContext)
	{	
		Node elementName = null, parentNode = null;
		NodeList elementList = null;
		Element elementAttr = null;
		String objName = "";
		elementList = dom2.getElementsByTagName("Detail"+objContext);
		elementName = elementList.item(0);
		if (elementName!=null && ("Detail"+objContext).equalsIgnoreCase(elementName.getNodeName()))
		{
			NamedNodeMap etlAttributes = elementName.getAttributes();
			if (etlAttributes!=null)
			{
				if (etlAttributes.getNamedItem("objName")!=null)
				{
					objName = etlAttributes.getNamedItem("objName").getNodeValue();
				}
			}
		}
		return objName;
	}
	static void writeLog(File f,String Msg,boolean flag)
	{
		try
		{  
			PrintWriter pw = new PrintWriter((new FileOutputStream(f,flag)),flag);				
			if(logOnOffFlag.trim().equals("Y"))
			{
				pw.println("["+new java.util.Date() +"]   " + Msg);		
			}
			pw.close();
		}
		catch(Exception exWm){exWm.printStackTrace();}		
	}
	//Modified by Abhishek on [16/11/2013][Request ID:WS3ASUN010][To migrate in gwt][End]
	
	
	// ADDED BY VISHAKHA on [26/05/2015] [To migrate in mobile] [START]
	private String getFieldValue(String column,String tableName, String columnName, String columnValue,Connection conn)
    {	
    	PreparedStatement pstmt = null;
        ResultSet rs = null;
        String value = null;
        String sql = null;
   
        sql = " select "+column+" from "+tableName+" where "+columnName+" = '" + columnValue + "' ";
        try
        {
            pstmt = conn.prepareStatement(sql);
            rs = pstmt.executeQuery();
            System.out.println("\n\n\n Query Executed " + sql+ "\n\n******************");
            if(rs.next())
            {
            	value = rs.getString(1) != null ? rs.getString(1) : " ";            	
            }
            else
            {
            	value = " ";
            }   
            rs.close();
            pstmt.close();
        }
        catch(Exception exception)
        {
            exception.printStackTrace();
            System.out.println("Exception ::" + exception.getMessage());
        }
        return value;
    }
	// ADDED BY VISHAKHA on [26/05/2015] [To migrate in mobile] [END]
	
}
//Abhishek
