package ibase.webitm.ejb.wsfa.transactions;

import java.net.InetAddress;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

import javax.ejb.SessionContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;

import org.json.simple.parser.JSONParser;

import ibase.ejb.E12ReportComp;
import ibase.ejb.E12SMSComp;
import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.bean.wsfa.OrgStructure;
import ibase.webitm.ejb.ActionHandlerEJB;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.MasterStatefulLocal;
import ibase.webitm.ejb.adm_SAG.SampleStockInvtraceUpd;
import ibase.webitm.ejb.dis.StockUpdate;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.TransIDGenerator;
import ibase.webitm.utility.wsfa.WSFACommon;

//@javax.ejb.Stateless		commented by Sagar M [22 Nov 2018].

public class StrgMeetDCRWizConf extends ActionHandlerEJB implements  StrgMeetDCRWizConfRemote,StrgMeetDCRWizConfLocal
{
	SessionContext cSessionContext;
	E12GenericUtility genericUtility = new E12GenericUtility();
	boolean isTouringSeq = false;
	private String isRussia="N";
	
	WSFACommon wsfaCommon = new WSFACommon();

	public void setSessionContext(SessionContext mSessionContext)
	{
	}

	public String confirm(String dcrId, String xtraParams, String forcedFlag) throws RemoteException,ITMException
	{
		//System.out.println("Inside confirm method");
		String retString = "";
		boolean isError = false;
		PreparedStatement pStmt = null;
		PreparedStatement pstmtUpd = null;
		PreparedStatement pstmtItem = null;
		ResultSet selectResult = null;
		PreparedStatement pstmt1 = null;
		ResultSet rSet1 = null;
		ResultSet rs = null;
		boolean isLocalConn = false;
		//String dcrId = "";
		String empCodeConf = "" ,eventDate = "";
		String objName = "";
		String tranIdCol = "";
		int count = 0;

		Connection conn = null;
		PreparedStatement pstmtPrevRemark = null;
		ResultSet rsPrevRemark = null;
		StrgMeetDCRWizard strgMeetWizrad = new StrgMeetDCRWizard();
		OrgStructure orgStructure = new OrgStructure();

		try
		{
			System.out.println("dcrId ::"+dcrId);
			System.out.println("StrgMeetDCRWizConf confirm method is called.........");
			if(conn == null)
			{
				conn = getConnection();
				isLocalConn = true;
				conn.setAutoCommit( false );
			}
			//Document dom = genericUtility.parseString(xmlString);
			//dcrId = checkNull(genericUtility.getColumnValue("survey_id", dom, "1"));
			if(!xtraParams.contains("#"))
			{
				empCodeConf = checkNull(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode"));
			}
			else
			{
				String[] xtraParmArr = xtraParams.split("#");
				empCodeConf = xtraParmArr[0];
			}

			objName = checkNull(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "objName"));
			objName = "w_" + objName;
			String sql1 = "SELECT TRAN_ID_COL FROM TRANSETUP WHERE TRAN_WINDOW = ?";
			pStmt = conn.prepareStatement( sql1 );
			pStmt.setString( 1, objName);
			rs = pStmt.executeQuery();
			if( rs.next())
			{
				tranIdCol = rs.getString("TRAN_ID_COL");

			}
			System.out.println("tranIdCol =["+tranIdCol+"]");
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if( pStmt != null )
			{
				pStmt.close();
				pStmt = null;
			}
			
			if("tran_id".equalsIgnoreCase(tranIdCol))
			{
				sql1 = "SELECT DCR_ID FROM STRG_MEET WHERE TRAN_ID = ?";
				pStmt = conn.prepareStatement( sql1 );
				pStmt.setString( 1, dcrId);
				rs = pStmt.executeQuery();
				if( rs.next())
				{
					dcrId = checkNull(rs.getString("DCR_ID"));
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if( pStmt != null )
				{
					pStmt.close();
					pStmt = null;
				}
			}

			System.out.println("dcrId =["+dcrId+"], empCodeConf=["+empCodeConf+"]");



		    DateFormat dtFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());
			java.util.Date date = Calendar.getInstance().getTime();
			String currDate = dtFormat.format( date );

			currDate = genericUtility.getValidDateTimeString( currDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );
			System.out.println("currDate ::["+currDate+"]");

			String actCode = ""; // added by rupali on 14/03/18 for prescription menu
			String dateSql = "SELECT EVENT_DATE, ACTIVITY_CODE FROM SPRS_ACT_TRAN WHERE DCR_ID = ? AND SALES_PERS = ? ";

			pStmt = conn.prepareStatement( dateSql );
			pStmt.setString( 1, dcrId);
			pStmt.setString( 2, empCodeConf);
			rs = pStmt.executeQuery();
			if( rs.next())
			{
				eventDate = rs.getString("EVENT_DATE");
				actCode = rs.getString("ACTIVITY_CODE"); // added by rupali on 14/03/18 for prescription menu
			}
			System.out.println("eventDate =["+eventDate+"]");
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if( pStmt != null )
			{
				pStmt.close();
				pStmt = null;
			}

			/*retString = confirmReport(eventDate,  empCodeConf,  "",  conn);
			if(retString != null && retString.trim().length() > 0)
			{
				return retString;
			}*/
			//added by bhagyashri T for insert into SPRS_PLAN_COMPL [26/11/21][start]
			String applDate =  "'" + genericUtility.getApplDateFormat().replaceAll("\\s+","") + "'";
            //System.out.println("applDate BEFORE TRAN :: "+applDate);
            applDate = applDate.replace("MMM", "MON");
            //System.out.println("applDate After TRAN:: "+applDate);
            String EventDt = genericUtility.getValidDateString( eventDate,genericUtility.getDBDateFormat(), genericUtility.getApplDateFormat());
			//System.out.println("EventDt is as ::["+EventDt+"]");
            String weekDay = "";
            StringBuilder getDaySb = new StringBuilder("select  CASE to_number(to_char(to_date( to_date( ? ,"+applDate+"),'DD/MM/YYYY'),'W')) ");
            getDaySb.append("WHEN 1 THEN to_number(to_char(to_date( to_date( ? ,"+applDate+"),'DD/MM/YYYY'),'W')) || 'st ' || (select initcap(to_char( to_date( ? ,"+applDate+"), 'DAY')) from dual) ");
            getDaySb.append("WHEN 2 THEN to_number(to_char(to_date( to_date( ? ,"+applDate+"),'DD/MM/YYYY'),'W')) || 'nd ' || (select initcap(to_char( to_date( ? ,"+applDate+"), 'DAY')) from dual) ");
            getDaySb.append("WHEN 3 THEN to_number(to_char(to_date( to_date( ? ,"+applDate+"),'DD/MM/YYYY'),'W')) || 'rd ' || (select initcap(to_char( to_date( ? ,"+applDate+"), 'DAY')) from dual) ");
            getDaySb.append("ELSE  to_number(to_char(to_date( to_date( ? ,"+applDate+"),'DD/MM/YYYY'),'W')) || 'th ' || (select initcap(to_char( to_date( ? ,"+applDate+"), 'DAY')) ");
            getDaySb.append("from dual) END as WEEK_DAY from dual");
            pStmt    = conn.prepareStatement(getDaySb.toString());
            pStmt.setString(1, EventDt);
            pStmt.setString(2, EventDt);
            pStmt.setString(3, EventDt);
            pStmt.setString(4, EventDt);
            pStmt.setString(5, EventDt);
            pStmt.setString(6, EventDt);
            pStmt.setString(7, EventDt);
            pStmt.setString(8, EventDt);
            pStmt.setString(9, EventDt);
            rs= pStmt.executeQuery();
            if(rs.next())
            {
                weekDay = rs.getString("WEEK_DAY").trim();
            }

            if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pStmt != null)
			{
				pStmt.close();
				pStmt = null;
            }
            System.out.println("WEEK_DAY ARE AS :: "+weekDay);
          //added by bhagyashri T for insert into SPRS_PLAN_COMPL [26/11/21][end]
            
			/*int i=0;
			if(planRoute.size() >= visitRoute.size())
			{
				i= planRoute.size();
			}
			else 
			{
				i= visitRoute.size();
			}
			System.out.println("greter array list is  =["+i+"]");*/
			if( dcrId != null && dcrId.length() > 0)
			{
				// added and commented by rupali on 14/03/18 for prescription menu [start]
				//retString = confirmReport(eventDate,  empCodeConf,  "DCR",  conn);
				retString = confirmReport(eventDate,  empCodeConf, actCode,  conn);
				// added and commented by rupali on 14/03/18 for prescription menu [end]
				if(retString != null && retString.trim().length() > 0)
				{
					return retString;
				}
				String isFortune  = checkNull(strgMeetWizrad.getSfaParmValue(empCodeConf,"IS_FORTUNE_ACTIVITY",conn));

				String actType = "";
				String sprsActSql = "SELECT A.ACTIVITY_CODE AS ACTIVITY_CODE ,B.ACTIVITY_TYPE AS ACTIVITY_TYPE FROM SPRS_ACT_TRAN A, FIELDACTIVITY B WHERE A.ACTIVITY_CODE = B.ACTIVITY_CODE AND DCR_ID= ? ";
				PreparedStatement pstmtAct = conn.prepareStatement(sprsActSql);
				pstmtAct.setString(1, dcrId);
				ResultSet rsAct = pstmtAct.executeQuery();
				while(rsAct.next())
				{
					actType = checkNull(rsAct.getString("ACTIVITY_TYPE"));
				}
				if(rsAct != null)
				{
					rsAct.close();
					rsAct = null;
				}
				if( pstmtAct != null )
				{
					pstmtAct.close();
					pstmtAct = null;
				}
				if("Y".equalsIgnoreCase(isFortune))
				{

						String actSql = "SELECT A.ACTIVITY_CODE AS ACTIVITY_CODE ,B.ACTIVITY_TYPE AS ACTIVITY_TYPE "
								+ "FROM SPRS_ACTIVITY A, FIELDACTIVITY B WHERE A.ACTIVITY_CODE = B.ACTIVITY_CODE AND DCR_ID= ? ";
						pstmtAct = conn.prepareStatement(actSql);
						pstmtAct.setString(1, dcrId);
						rsAct = pstmtAct.executeQuery();
						while(rsAct.next())
						{
							actType = checkNull(rsAct.getString("ACTIVITY_TYPE"));
							if("FW".equalsIgnoreCase(actType))
							{
								break;
							}
						}
						if(rsAct != null)
						{
							rsAct.close();
							rsAct = null;
						}
						if( pstmtAct != null )
						{
							pstmtAct.close();
							pstmtAct = null;
						}
				}
				System.out.println("activity type is:["+actType+"]");
				retString = validConfirmReport(eventDate,empCodeConf,actType,isFortune,conn);
				if(retString != null && retString.trim().length() > 0)
				{
					return retString;
				}

				String confSql = "SELECT COUNT (1) COUNT FROM SPRS_ACT_TRAN WHERE DCR_ID = ? AND CONFIRMED ='Y'";

				pStmt = conn.prepareStatement( confSql );
				pStmt.setString( 1, dcrId);
				rs = pStmt.executeQuery();
				if( rs.next())
				{
					count = rs.getInt("COUNT");
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if( pStmt != null )
				{
					pStmt.close();
					pStmt = null;
				}

				System.out.println("count =["+count+"]");
				if(count == 0)
				{
					String sampleAllow = strgMeetWizrad.getSfaParmValue(empCodeConf,"SAMPLE_ALLOW",conn);

					if(sampleAllow.equalsIgnoreCase("E") || sampleAllow.equalsIgnoreCase("C"))
					{
						String dcrID="";
						System.out.println("....before query.....");
						String selectDcrSql="SELECT DCR_ID FROM STRG_MEET WHERE EVENT_DATE = ? AND SALES_PERS = ?";
						PreparedStatement pstmtDcrSql =  conn.prepareStatement(selectDcrSql);
						pstmtDcrSql.setTimestamp(1, java.sql.Timestamp.valueOf(eventDate));
						pstmtDcrSql.setString(2, empCodeConf);
						rs = pstmtDcrSql.executeQuery();
						if( rs.next() )
						{
							dcrID= rs.getString("DCR_ID");	
						}

						rs.close();
						rs=null;
						pstmtDcrSql.close();
						pstmtDcrSql=null;
						//Added by Bhagyashri T For Sample Validation[14/06/22][start]
						if(dcrID != null && dcrID.trim().length() > 0)
						{	
						
							String selectMeetItemSql = "SELECT SMI.ITEM_CODE,SUM(SMI.QUANTITY) AS QUANTITY,ITEM.DESCR AS DESCR FROM STRG_MEET_ITEMS SMI,ITEM ITEM WHERE SMI.DCR_ID = ? AND ITEM.ITEM_CODE=SMI.ITEM_CODE GROUP BY SMI.ITEM_CODE,ITEM.DESCR";
							pstmtItem =  conn.prepareStatement(selectMeetItemSql);
							pstmtItem.setString(1, dcrID);
							selectResult=pstmtItem.executeQuery();
							while(selectResult.next())
							{
								String itemCode="";
								String itemQuantity="";
								String itemDescr="";
								double sampleQuantity =0;
								itemCode=selectResult.getString("ITEM_CODE").trim();
								itemQuantity=selectResult.getString("QUANTITY");
								itemDescr = selectResult.getString("DESCR");
								sampleQuantity=Double.parseDouble(itemQuantity);
								
								String sampleTranId ="";
								String emploginSite ="";
								double samDetQuantity = 0;
								double quanTotal = 0;
								String sqlTrans = "SELECT ISS.TRAN_ID as TRAN_ID,ISS.site_code__iss as SITE_CODE,SID.QTY_ISS as QTY_ISS "+
										" FROM SAMPLE_ISS ISS,SAMPLE_ISS_DET SID  "+
										" WHERE ISS.emp_code__iss = ?  "+
										" AND ISS.TRAN_TYPE = 'A' "+
										" AND ISS.confirmed = 'N' "+
										" AND ISS.STATUS = 'S' " +
										"AND ISS.TRAN_ID=SID.TRAN_ID AND TRIM(SID.ITEM_CODE)= ? ";
								pstmt1 = conn.prepareStatement(sqlTrans);
								pstmt1.setString(1, empCodeConf);
								pstmt1.setString(2, itemCode);
								rSet1 = pstmt1.executeQuery();
								if(rSet1.next())
								{
									sampleTranId=rSet1.getString("TRAN_ID").trim();
									emploginSite = rSet1.getString("SITE_CODE").trim();
									String samDetQuan=rSet1.getString("QTY_ISS");
									samDetQuantity=Double.parseDouble(samDetQuan);
								}
								if(rSet1 != null)
								{
									rSet1.close();
									rSet1 = null;
								}
								if(pstmt1 != null)
								{
									pstmt1.close();
									pstmt1 = null;
								}
								
								/*String sammpleDet = "SELECT SIDET.QTY_ISS as QTY_ISS"+
											" FROM SAMPLE_ISS_DET SIDET "+
											" WHERE TRIM(SIDET.TRAN_ID) = ?  " +
											" AND TRIM(SIDET.ITEM_CODE) = ? ";
									pstmt1 = conn.prepareStatement(sammpleDet);
									pstmt1.setString(1, sampleTranId);
									pstmt1.setString(2, itemCode);
									rSet1 = pstmt1.executeQuery();
									if(rSet1.next())
									{
										String samDetQuan=rSet1.getString("QTY_ISS");
										samDetQuantity=Double.parseDouble(samDetQuan);
									}
									if(rSet1 != null)
									{
										rSet1.close();
										rSet1 = null;
									}
									if(pstmt1 != null)
									{
										pstmt1.close();
										pstmt1 = null;
									}*/
									if(samDetQuantity != 0 && sampleQuantity !=0)
									{
										quanTotal= sampleQuantity + samDetQuantity;	
									}
									if(quanTotal != 0)
									{
										String stkQuantity ="";
										double stkdouQuantity =0;
										String sql = "SELECT SS.QUANTITY as QUANTITY"+
												" FROM SAMPLE_STOCK SS "+
												" WHERE TRIM(SS.EMP_CODE) = TRIM(?)  " +
												" AND TRIM(SS.SITE_CODE) = TRIM(?) "+
												" AND TRIM(SS.ITEM_CODE) = ? " +
												" AND SS.INV_STAT ='SALE'";
										pStmt = conn.prepareStatement( sql); 
										pStmt.setString( 1, empCodeConf);
										pStmt.setString(2, emploginSite);
										pStmt.setString(3, itemCode);
										rs = pStmt.executeQuery();
										if( rs.next())
										{
											stkQuantity=rs.getString("QUANTITY");
											stkdouQuantity=Double.parseDouble(stkQuantity);
										}
										if(rs != null)
										{
											rs.close();
											rs = null;
										}
										if( pStmt != null )
										{
											pStmt.close();
											pStmt = null;
										}
										if(stkdouQuantity < quanTotal)
										{
											retString = new ITMDBAccessEJB().getErrorString("", "INSQUANTY", "");
											retString = getModifiedErrorString(retString, "Insufficiant Quantity for Item "+itemDescr);
										}
										if(retString != null && retString.length()>0 && (retString.indexOf("ERRORS")!=-1 || retString.indexOf("Errors")!=-1))
										{
											isError = true;
											return retString;
										}
										
									}
							}
							if(selectResult != null)
							{
								selectResult.close();
								selectResult = null;
							}
							if(pstmtItem != null)
							{
								pstmtItem.close();
								pstmtItem = null;
							}
						
						}
						//Added by Bhagyashri T For Sample Validation[14/06/22][end]
						 

						if(dcrID != null && dcrID.trim().length() > 0)
						{	
							System.out.println("Inside dcrID===========>"+dcrID);

							retString = updateIssueQty(empCodeConf, eventDate, dcrID, conn);
							if(retString != null && retString.length()>0 && (retString.indexOf("ERRORS")!=-1 || retString.indexOf("Errors")!=-1))
							{
								isError = true;
								return retString;
							}
						}
					}

					String upDateSql = "UPDATE SPRS_ACT_TRAN SET CONFIRMED = 'Y' , CONF_DATE = ?  " +
							"WHERE DCR_ID = ?"; // added by condition of dcr_id rupali on 14/03/17 for separate pr menu
					pstmtUpd = conn.prepareStatement(upDateSql);
					pstmtUpd.setTimestamp(1, new java.sql.Timestamp(System.currentTimeMillis()));
					pstmtUpd.setString( 2, dcrId); // added by condition rupali on 14/03/17 for separate pr menu

					int updCnt = pstmtUpd.executeUpdate();
					if( pstmtUpd != null )
					{
						pstmtUpd.close();
						pstmtUpd = null;
					}

					if(updCnt > 0)
					{
						
						String upDateSql1 = "UPDATE STRG_MEET SET CONFIRMED = 'Y' , CONF_DATE = ?  " +
								"WHERE SALES_PERS = ?  AND  EVENT_DATE = ? AND DCR_ID = ?";
						pstmtUpd = conn.prepareStatement(upDateSql1);

						pstmtUpd.setTimestamp(1, new java.sql.Timestamp(System.currentTimeMillis()));
						pstmtUpd.setString(2, empCodeConf);
						pstmtUpd.setTimestamp(3,java.sql.Timestamp.valueOf(eventDate));
						pstmtUpd.setString( 4, dcrId);

						int updCnt1 = pstmtUpd.executeUpdate();

						if( pstmtUpd != null )
						{
							pstmtUpd.close();
							pstmtUpd = null;
						}

						
						
						// commented by rupali on 12/03/18 for separating deletion of pr and dcr report [start]
						/*if(!"PR".equalsIgnoreCase(actType))
						{
							String upDateSql1 = "UPDATE STRG_MEET SET CONFIRMED = 'Y' , CONF_DATE = ?  " +
							          "WHERE SALES_PERS = ?  AND  EVENT_DATE = ? ";
							pstmtUpd = conn.prepareStatement(upDateSql1);

							pstmtUpd.setTimestamp(1,java.sql.Timestamp.valueOf(currDate));
							pstmtUpd.setString(2, empCodeConf);
							pstmtUpd.setTimestamp(3,java.sql.Timestamp.valueOf(eventDate));

							int updCnt1 = pstmtUpd.executeUpdate();

							if( pstmtUpd != null )
							{
								pstmtUpd.close();
								pstmtUpd = null;
							}

							System.out.println("count =["+updCnt1+"]");

							String upDateSql2 = "UPDATE STRG_CUST_ADD SET CONFIRMED = 'Y' , CONF_DATE = ?  " +
							          "WHERE SALES_PERS = ?  AND  EVENT_DATE = ? ";
							pstmtUpd = conn.prepareStatement(upDateSql2);

							pstmtUpd.setTimestamp(1,java.sql.Timestamp.valueOf(currDate));
							pstmtUpd.setString(2, empCodeConf);
							pstmtUpd.setTimestamp(3,java.sql.Timestamp.valueOf(eventDate));

							int updCnt2 = pstmtUpd.executeUpdate();

							if( pstmtUpd != null )
							{
								pstmtUpd.close();
								pstmtUpd = null;
							}
							System.out.println("count =["+updCnt2+"]");
						}*/
						// commented by rupali on 12/03/18 for separating deletion of pr and dcr report [end]
						retString = updateIssueQty1(empCodeConf, eventDate, dcrId, conn);
						if(retString != null && retString.length()>0 && (retString.indexOf("ERRORS")!=-1 || retString.indexOf("Errors")!=-1))
						{
							isError = true;
							return retString;
						}
						System.out.println("retString dcrID===========>"+retString);
						/*Added by sadique shaikh 02-01-2020 [creating user task After Confirm]*/
						createUserTasks(dcrId, objName, xtraParams, conn);

						HashSet<String> planDate=new HashSet<String> ();
						if(updCnt1>0)
						{
							planDate=insertIntoPlan(empCodeConf,eventDate,dcrId,currDate,conn);

						}
						//added by bhagyashri T for insert into SPRS_PLAN_COMPL [26/11/21][start][W21HSUN028]
						if(updCnt1>0)
						{
							ArrayList<String> planRoute = new ArrayList<String>();
				            String routeSql="SELECT SR.ROUTE_ID AS ROUTE_ID FROM SPRS_ROUTE SR, LOCALITY LOC,STATION S WHERE SR.LOCALITY_CODE = LOC.LOCALITY_CODE AND SR.SPRS_CODE = ? AND SR.STATUS='Y' AND SR.STAN_CODE=S.STAN_CODE AND SR.PLAN_DAYS LIKE '%"+weekDay+"%' ";
				            pStmt = conn.prepareStatement( routeSql );
							pStmt.setString( 1, empCodeConf);
							rs = pStmt.executeQuery();
							while(rs.next())
							{
								String routeId=checkNull(rs.getString("ROUTE_ID"));
								if(!planRoute.contains(routeId))
								{
									planRoute.add(routeId);
								}
								
							}
							System.out.println("planRoute array of sprs_route =["+planRoute+"]");
							if(rs != null)
							{
								rs.close();
								rs = null;
							}
							if( pStmt != null )
							{
								pStmt.close();
								pStmt = null;
							}
							ArrayList<String> visitRoute = new ArrayList<String>();
							ArrayList<String> plancomp = new ArrayList<String>();
							ArrayList<String> visunplan = new ArrayList<String>();
							ArrayList<String> allRoute = new ArrayList<String>();
							allRoute=planRoute;
				            String travelSql="SELECT DISTINCT(ROUTE_ID) AS ROUTE FROM SPRS_TRAVEL WHERE DCR_ID = ? AND SALES_PERS = ?";
				            pStmt = conn.prepareStatement( travelSql );
				            pStmt.setString( 1, dcrId);
							pStmt.setString( 2, empCodeConf);
							rs = pStmt.executeQuery();
							while(rs.next())
							{
								String trvRoute=checkNull(rs.getString("ROUTE"));
								//System.out.println("ROUTEe in sprs_travel::"+trvRoute);
								if(!visitRoute.contains(trvRoute))
								{
									visitRoute.add(trvRoute);
									if(planRoute.contains(trvRoute) )
									{
										plancomp.add(trvRoute);
									}
									else
									{
										visunplan.add(trvRoute);
									}
									if(!allRoute.contains(trvRoute))
									{
										allRoute.add(trvRoute);
									}
								}
								
							}
							if(rs != null)
							{
								rs.close();
								rs = null;
							}
							if( pStmt != null )
							{
								pStmt.close();
								pStmt = null;
							}
							if(!allRoute.isEmpty())
							{
								for (int i = 0; i < allRoute.size(); i++) 
								{
									String route = allRoute.get(i);
									String locCode ="";
									String descr ="";
									String locsql="SELECT SR.LOCALITY_CODE AS LOCALITY_CODE, (CASE WHEN SR.ROUTE_DESCR IS NOT NULL THEN SR.ROUTE_DESCR ELSE SR.DESCR END) AS DESCR FROM SPRS_ROUTE SR, LOCALITY LOC,STATION S WHERE SR.LOCALITY_CODE = LOC.LOCALITY_CODE AND SR.STAN_CODE=S.STAN_CODE AND SR.SPRS_CODE = ? AND SR.STATUS='Y' AND ROUTE_ID= ?";
									 pStmt = conn.prepareStatement( locsql );
									 pStmt.setString( 1, empCodeConf);
									 pStmt.setString( 2, route);
									 rs = pStmt.executeQuery();
									 if(rs.next())
									 {
										 locCode = checkNull(rs.getString("LOCALITY_CODE"));
										 descr=checkNull(rs.getString("DESCR"));
									 }
									 pStmt.clearParameters();
									 if(rs != null)
									 {
										rs.close();
										rs = null;
									 }
									 if( pStmt != null )
									 {
										pStmt.close();
										pStmt = null;
									 }
									 if(plancomp.contains(route) )
									 {
										 insertIntoPlanconf(empCodeConf,eventDate,dcrId,route,locCode,descr,"1","1",conn); 
									 }
									 else if(visunplan.contains(route))
									 {
										 insertIntoPlanconf(empCodeConf,eventDate,dcrId,route,locCode,descr,"1","2",conn);
									 }
									 else
									 {
										 insertIntoPlanconf(empCodeConf,eventDate,dcrId,route,locCode,descr,"1","3",conn); 
									 }
								}
							}
							
						}
						//added by bhagyashri T for insert into SPRS_PLAN_COMPL [26/11/21][END][W21HSUN028]
						//Added by bhagyashri t for Update remark and date in strg_series [start]
						if(updCnt1>0)
						{
							boolean isMANGR=false;
							ArrayList teamList = new ArrayList();
							isMANGR=isMGREmployee(empCodeConf);
							String getPrevRemarkSql = "SELECT REMARKS,STRG_CODE,SPRS_CODE__WW FROM STRG_MEET WHERE SALES_PERS = ? AND EVENT_DATE = ? ";
							String upDateser= "UPDATE STRG_SERIES SET  LAST_MEET_SUMM = ?  " +
									"WHERE SC_CODE = ? AND SALES_PERS = ? ";
							String upDateser1 = "UPDATE STRG_SERIES SET  LAST_MEET_DATE = ?  " +
									"WHERE SALES_PERS = ? AND SC_CODE =?";
							
							pstmtPrevRemark = conn.prepareStatement(getPrevRemarkSql);
							pstmtPrevRemark.setString(1,empCodeConf);
							pstmtPrevRemark.setTimestamp(2,java.sql.Timestamp.valueOf(eventDate));
							rsPrevRemark = pstmtPrevRemark.executeQuery();
							while (rsPrevRemark.next())
							{
								String prevRemark = checkNull(rsPrevRemark.getString("REMARKS"));
								String strgCode = checkNull(rsPrevRemark.getString("STRG_CODE"));
								String strgCodeWW = checkNull(rsPrevRemark.getString("SPRS_CODE__WW"));
								teamList.add(strgCode);
								
								if(prevRemark != null && prevRemark.trim().length() > 0)
								{
									
									PreparedStatement pstmtUpde = conn.prepareStatement(upDateser);

									pstmtUpde.setString(1,prevRemark);
									pstmtUpde.setString(2, strgCode);
									if(isMANGR)
									{
										pstmtUpde.setString(3, strgCodeWW);
									}
									else
									{
										pstmtUpde.setString(3, empCodeConf);
										
									}
									int updCnt2 = pstmtUpde.executeUpdate();
									if( pstmtUpde != null )
									{
										pstmtUpde.close();
										pstmtUpde = null;
									}
								
								}
								if(isMANGR)
								{
									
									PreparedStatement pstmtUpd1 = conn.prepareStatement(upDateser1);
									pstmtUpd1.setTimestamp(1,java.sql.Timestamp.valueOf(eventDate));
									pstmtUpd1.setString(2, strgCodeWW);
									pstmtUpd1.setString(3, strgCode);
									int updCnt2 = pstmtUpd1.executeUpdate();
									if( pstmtUpd1 != null )
									{
										pstmtUpd1.close();
										pstmtUpd1 = null;
									}
									
								}
								
							}
							if(rsPrevRemark != null)
							{
								rsPrevRemark.close(); 
								rsPrevRemark = null;
							}
							if(pstmtPrevRemark != null)
							{
								pstmtPrevRemark.close();
								pstmtPrevRemark = null;
							}
							String scCodes=wsfaCommon.getFormattedList(teamList);
							
							if(!isMANGR)
							{
								System.out.println("Upadation for SO DAR LAST_MEET_DATE");
								String upDateser2 = "UPDATE STRG_SERIES SET  LAST_MEET_DATE = ?  " +
										"WHERE SALES_PERS = ? AND SC_CODE IN ("+scCodes+")";
								PreparedStatement pstmtUpd2 = conn.prepareStatement(upDateser2);

								pstmtUpd2.setTimestamp(1,java.sql.Timestamp.valueOf(eventDate));
								pstmtUpd2.setString(2, empCodeConf);
								int updCnt2 = pstmtUpd2.executeUpdate();
								System.out.println("LAST_MEET_DATE updCnt2::"+updCnt2);
								if( pstmtUpd2 != null )
								{
									pstmtUpd2.close();
									pstmtUpd2 = null;
								}
								
							}
							
								
						}
						String upDateSql2 = "UPDATE STRG_CUST_ADD SET CONFIRMED = 'Y' , CONF_DATE = ?  " +
								"WHERE SALES_PERS = ?  AND  EVENT_DATE = ? AND DCR_ID = ?";
						pstmtUpd = conn.prepareStatement(upDateSql2);

						pstmtUpd.setTimestamp(1, new java.sql.Timestamp(System.currentTimeMillis()));
						pstmtUpd.setString(2, empCodeConf);
						pstmtUpd.setTimestamp(3,java.sql.Timestamp.valueOf(eventDate));
						pstmtUpd.setString( 4, dcrId);

						int updCnt2 = pstmtUpd.executeUpdate();

						if( pstmtUpd != null )
						{
							pstmtUpd.close();
							pstmtUpd = null;
						}
                        
                        /* Commented by prachi on 08-07-22[W22DJOH004]
						//CHANGES ADDED BY PRACHI  on 200622 [W22CJOH003]
						updateSurveyStat(dcrId,conn);
						System.out.println("survey status updated sucessfully");
                        //end
                        */
                        
						ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
						retString =	itmDBAccessEJB.getErrorString("","CONFIGSUCC","");
						if(!planDate.isEmpty())
						{
							retString = getModifiedErrorString(retString, "Plan Created For This Date"+planDate);
						}
						StringBuffer retBuf = new StringBuffer(retString);

						StringBuffer insertBuf = new StringBuffer("<Detail1 domID='1'>");


						insertBuf.append("<confirmed >").append("<![CDATA[").append("Y").append("]]>").append("</confirmed>\r\n");
						insertBuf.append("</Detail1>");
						
						//Added By Bhagyashri T for instance Workflow changes for LBCP Customer Start 20-11-22
						PreparedStatement pstmtwrkflw=null;
						ResultSet rswrkflw=null;
						String sqlwrk="",wrkflwInit="",wrkOptCust="0",wrkflwStock="",wrkOptStock="0";
						sqlwrk = "SELECT WRKFLW_INIT,WORKFLOW_OPT FROM TRANSETUP WHERE TRAN_WINDOW = 'w_strg_cust_add_aprv'";
						pstmtwrkflw = conn.prepareStatement(sqlwrk);
						rswrkflw = pstmtwrkflw.executeQuery();
						if (rswrkflw.next())
						{
							wrkflwInit = rswrkflw.getString("WRKFLW_INIT") == null ? "" : rswrkflw.getString("WRKFLW_INIT");
							wrkOptCust = rswrkflw.getString("WORKFLOW_OPT") == null ? "" : rswrkflw.getString("WORKFLOW_OPT");
						}
						if (rswrkflw != null)
						{
							rswrkflw.close();
							rswrkflw = null;
						}
						if (pstmtwrkflw != null)
						{
							pstmtwrkflw.close();
							pstmtwrkflw = null;
						}
						sqlwrk = "SELECT WRKFLW_INIT,WORKFLOW_OPT FROM TRANSETUP WHERE TRAN_WINDOW = 'w_invoice_stock_aprv'";
						pstmtwrkflw = conn.prepareStatement(sqlwrk);
						rswrkflw = pstmtwrkflw.executeQuery();
						if (rswrkflw.next())
						{
							wrkflwStock = rswrkflw.getString("WRKFLW_INIT") == null ? "" : rswrkflw.getString("WRKFLW_INIT");
							wrkOptStock = rswrkflw.getString("WORKFLOW_OPT") == null ? "" : rswrkflw.getString("WORKFLOW_OPT");
						}
						if (rswrkflw != null)
						{
							rswrkflw.close();
							rswrkflw = null;
						}
						if (pstmtwrkflw != null)
						{
							pstmtwrkflw.close();
							pstmtwrkflw = null;
						}
						//Added By Bhagyashri T for instance Workflow changes for LBCP Customer End 20-11-22
						//Added By Nilesh for instance Workflow changes for unlisted Changes Start 09-05-19
						//System.out.println("workflow opt for Cust is as:"+wrkOptCust+"Workflow opt for LBCP is:"+wrkOptStock);
						if(wrkOptCust !=null && wrkOptCust.trim().length()>0 && !(wrkOptCust.equals("0")))
						{
							if(updCnt1 > 0 && updCnt2 > 0)
							{
								
								checkStrgCustRecord(eventDate,empCodeConf ,dcrId ,conn);
	
							}
						}
						//Added By Nilesh for instance Workflow changes for unlisted Changes End 09-05-19
						//Added By Bhagyashri T for instance Workflow changes for LBCP customer Start 11-11-22
						/*if(wrkOptStock !=null && wrkOptStock.trim().length()>0 && !(wrkOptStock.equals("0")))
						{
							if(updCnt1 > 0 && updCnt > 0 )
							{
								createCustomerWrkflow(eventDate,empCodeConf ,dcrId ,conn);
	
							}
						}*/
						//Added By Bhagyashri T for instance Workflow changes for LBCP Customer Start 11-11-22
						if(retString != null && retString.indexOf("<Root>") != -1)
						{
							retBuf.insert(retBuf.indexOf("<Root>")+6,  insertBuf.toString());

							retString = retBuf.toString();
						}
					}//When update SPRS_ACT_TRAN as "Y"

					System.out.println("updCnt =["+updCnt+"]");


				}
			}
			
			/*
		   	if( dcrId != null && (dcrId.contains("WF") || dcrId.contains("WD")))
		   	{
		   		System.out.println("Confirm from MR DCR Reporting............");


		   		retString = confirmReport(eventDate,  empCodeConf,  "DCR",  conn);
				if(retString != null && retString.trim().length() > 0)
				{
					return retString;
				}


				//String upDateSql = "UPDATE SPRS_ACT_TRAN SET CONFIRMED = 'Y' , CONF_DATE = ? WHERE DCR_ID = ?";
				String upDateSql = "UPDATE SPRS_ACT_TRAN SET CONFIRMED = 'Y' , CONF_DATE = ?  " +
						           "WHERE SALES_PERS = ?  AND  EVENT_DATE = ? ";
				pstmtUpd = conn.prepareStatement(upDateSql);

				pstmtUpd.setTimestamp(1,java.sql.Timestamp.valueOf(currDate));
				pstmtUpd.setString(2, empCodeConf);
				pstmtUpd.setTimestamp(3,java.sql.Timestamp.valueOf(eventDate));

				int updCnt = pstmtUpd.executeUpdate();

				if(updCnt > 0)
				{
					String upDateSql1 = "UPDATE STRG_MEET SET CONFIRMED = 'Y' , CONF_DATE = ?  " +
					          "WHERE SALES_PERS = ?  AND  EVENT_DATE = ? ";
					pstmtUpd = conn.prepareStatement(upDateSql1);

					pstmtUpd.setTimestamp(1,java.sql.Timestamp.valueOf(currDate));
					pstmtUpd.setString(2, empCodeConf);
					pstmtUpd.setTimestamp(3,java.sql.Timestamp.valueOf(eventDate));

					int updCnt1 = pstmtUpd.executeUpdate();
					System.out.println("count =["+updCnt1+"]");

					String upDateSql2 = "UPDATE STRG_CUST_ADD SET CONFIRMED = 'Y' , CONF_DATE = ?  " +
					          "WHERE SALES_PERS = ?  AND  EVENT_DATE = ? ";
					pstmtUpd = conn.prepareStatement(upDateSql2);

					pstmtUpd.setTimestamp(1,java.sql.Timestamp.valueOf(currDate));
					pstmtUpd.setString(2, empCodeConf);
					pstmtUpd.setTimestamp(3,java.sql.Timestamp.valueOf(eventDate));

					int updCnt2 = pstmtUpd.executeUpdate();
					System.out.println("count =["+updCnt2+"]");

					ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
					retString =	itmDBAccessEJB.getErrorString("","CONFIGSUCC","");
					StringBuffer retBuf = new StringBuffer(retString);

					StringBuffer insertBuf = new StringBuffer("<Detail1 domID='1'>");


					insertBuf.append("<confirmed >").append("<![CDATA[").append("Y").append("]]>").append("</confirmed>\r\n");
					insertBuf.append("</Detail1>");
					if(retString != null && retString.indexOf("<Root>") != -1)
					{
						retBuf.insert(retBuf.indexOf("<Root>")+6,  insertBuf.toString());

						retString = retBuf.toString();
					}
				}

				System.out.println("updCnt =["+updCnt+"]");

				if( pstmtUpd != null )
				{
					pstmtUpd.close();
					pstmtUpd = null;
				}

		   	}
		   	else if(dcrId != null && dcrId.contains("WP"))
		   	{
		   		System.out.println("Confirm from Prescription Reporting............");

		   		retString = confirmReport(eventDate,  empCodeConf,  "DCR",  conn);
				if(retString != null && retString.trim().length() > 0)
				{
					return retString;
				}

		   		String confSql = "SELECT COUNT (1) COUNT FROM SPRS_ACT_TRAN WHERE DCR_ID = ? AND CONFIRMED ='Y'";

				pStmt = conn.prepareStatement( confSql );
				pStmt.setString( 1, dcrId);
				rs = pStmt.executeQuery();
				if( rs.next())
				{
					count = rs.getInt("COUNT");
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if( pStmt != null )
				{
					pStmt.close();
					pStmt = null;
				}

				System.out.println("count =["+count+"]");
				if(count == 0)
				{
					//String upDateSql = "UPDATE SPRS_ACT_TRAN SET CONFIRMED = 'Y' , CONF_DATE = ? WHERE DCR_ID = ?";
					String upDateSql = "UPDATE SPRS_ACT_TRAN SET CONFIRMED = 'Y' , CONF_DATE = ?  " +
							           "WHERE SALES_PERS = ?  AND  EVENT_DATE = ? ";
					pstmtUpd = conn.prepareStatement(upDateSql);

					pstmtUpd.setTimestamp(1,java.sql.Timestamp.valueOf(currDate));
					pstmtUpd.setString(2, empCodeConf);
					pstmtUpd.setTimestamp(3,java.sql.Timestamp.valueOf(eventDate));

					int updCnt = pstmtUpd.executeUpdate();

					if(updCnt > 0)
					{
						ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
						retString =	itmDBAccessEJB.getErrorString("","CONFIGSUCC","");
						StringBuffer retBuf = new StringBuffer(retString);

						StringBuffer insertBuf = new StringBuffer("<Detail1 domID='1'>");


						insertBuf.append("<confirmed >").append("<![CDATA[").append("Y").append("]]>").append("</confirmed>\r\n");
						insertBuf.append("</Detail1>");
						if(retString != null && retString.indexOf("<Root>") != -1)
						{
							retBuf.insert(retBuf.indexOf("<Root>")+6,  insertBuf.toString());

							retString = retBuf.toString();
						}
					}

					System.out.println("updCnt =["+updCnt+"]");

					if( pstmtUpd != null )
					{
						pstmtUpd.close();
						pstmtUpd = null;
					}
				}
				else if(count > 0)
				{
					ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
					retString =	itmDBAccessEJB.getErrorString("","CONFIGFLD","");
				}
		   	}
		   	else if(dcrId != null && dcrId.contains("WM"))
		   	{
		   		System.out.println("Confirm from MGR DCR Reporting............");

		   		retString = confirmReport(eventDate,  empCodeConf,  "DCR",  conn);
				if(retString != null && retString.trim().length() > 0)
				{
					return retString;
				}

		   		String confSql = "SELECT COUNT (1) COUNT FROM SPRS_ACT_TRAN WHERE DCR_ID = ? AND CONFIRMED ='Y'";

				pStmt = conn.prepareStatement( confSql );
				pStmt.setString( 1, dcrId);
				rs = pStmt.executeQuery();
				if( rs.next())
				{
					count = rs.getInt("COUNT");
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if( pStmt != null )
				{
					pStmt.close();
					pStmt = null;
				}

				System.out.println("count =["+count+"]");
				if(count == 0)
				{
					//String upDateSql = "UPDATE SPRS_ACT_TRAN SET CONFIRMED = 'Y' , CONF_DATE = ? WHERE DCR_ID = ?";
					String upDateSql = "UPDATE SPRS_ACT_TRAN SET CONFIRMED = 'Y' , CONF_DATE = ?  " +
							           "WHERE SALES_PERS = ? AND EVENT_DATE = ? ";
					pstmtUpd = conn.prepareStatement(upDateSql);

					pstmtUpd.setTimestamp(1,java.sql.Timestamp.valueOf(currDate));
					pstmtUpd.setString(2, empCodeConf);
					pstmtUpd.setTimestamp(3,java.sql.Timestamp.valueOf(eventDate));

					int updCnt = pstmtUpd.executeUpdate();

					if(updCnt > 0)
					{
						ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
						retString =	itmDBAccessEJB.getErrorString("","CONFIGSUCC","");
						StringBuffer retBuf = new StringBuffer(retString);

						StringBuffer insertBuf = new StringBuffer("<Detail1 domID='1'>");


						insertBuf.append("<confirmed >").append("<![CDATA[").append("Y").append("]]>").append("</confirmed>\r\n");
						insertBuf.append("</Detail1>");
						if(retString != null && retString.indexOf("<Root>") != -1)
						{
							retBuf.insert(retBuf.indexOf("<Root>")+6,  insertBuf.toString());

							retString = retBuf.toString();
						}
					}

					System.out.println("updCnt =["+updCnt+"]");

					if( pstmtUpd != null )
					{
						pstmtUpd.close();
						pstmtUpd = null;
					}
				}
				else if(count > 0)
				{
					ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
					retString =	itmDBAccessEJB.getErrorString("","CONFIGFLD","");
				}
		   	}
			 */
			
			
			
			
		}
		catch(Exception e)
		{
			isError = true;
			System.out.println("Exception :StrgMeetDCRWizConf :==>\n"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}

		finally
		{
			try
			{
				System.out.println("isError ["+isError+"]");
				System.out.println("isLocalConn ["+isLocalConn+"]");
				if( conn != null )
				{

					if( isError )
					{
						conn.rollback();
					}
					if(pStmt != null)
					{
						pStmt.close();
						pStmt = null;
					}
					if ( isLocalConn )
					{
						if ( ! isError )
						{
							conn.commit();
							System.out.println("StrgMeetDCRWizConf Connection commited........");
						}
						conn.close();
						conn = null;
                    }
                    
					//Added by Bhagyashri T For Sample Validation[14/06/22][start]
					if(selectResult != null)
					{
						selectResult.close();
						selectResult = null;
					}
					if(pstmtItem != null)
					{
						pstmtItem.close();
						pstmtItem = null;
					}
					if(rSet1 != null)
					{
						rSet1.close();
						rSet1 = null;
					}
					if(pstmt1 != null)
					{
						pstmt1.close();
						pstmt1 = null;
					}
					//Added by Bhagyashri T For Sample Validation[14/06/22][End]
				}
			}
			catch(Exception e)
			{
				System.out.println("Exception :StrgMeetDCRWizConf :confirm :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		System.out.println("[StrgMeetDCRWizConf]Return string :"+retString);
		return retString;
	}
	public String confirmAfterSubmit(String dcrIdInForm, String xtraParams, String forcedFlag,int updCnt1) throws RemoteException,ITMException
	{
		//System.out.println("Inside confirm method");
		String retString = "";
		boolean isError = false;
		PreparedStatement pStmt = null;
		PreparedStatement pstmtUpd = null;
		PreparedStatement pstmtItem = null;
		ResultSet selectResult = null;
		PreparedStatement pstmt1 = null;
		ResultSet rSet1 = null;
		ResultSet rs = null;
		boolean isLocalConn = false;
		//String dcrId = "";
		String empCodeConf = "" ;
		String objName = "";
		String tranIdCol = "";
		int count = 0;

		Connection conn = null;
		PreparedStatement pstmtPrevRemark = null;
		ResultSet rsPrevRemark = null;
		StrgMeetDCRWizard strgMeetWizrad = new StrgMeetDCRWizard();
		//OrgStructure orgStructure = new OrgStructure();

		try
		{
			System.out.println("dcrId ::"+dcrIdInForm);
			System.out.println("StrgMeetDCRWizConf confirm method is called.........");
			if(conn == null)
			{
				conn = getConnection();
				isLocalConn = true;
				conn.setAutoCommit( false );
			}
			//Document dom = genericUtility.parseString(xmlString);
			//dcrId = checkNull(genericUtility.getColumnValue("survey_id", dom, "1"));
			if(!xtraParams.contains("#"))
			{
				empCodeConf = checkNull(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode"));
			}
			else
			{
				String[] xtraParmArr = xtraParams.split("#");
				empCodeConf = xtraParmArr[0];
			}

		    DateFormat dtFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());
			java.util.Date date = Calendar.getInstance().getTime();
			String currDate = dtFormat.format( date );

			currDate = genericUtility.getValidDateTimeString( currDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );
			System.out.println("currDate ::["+currDate+"]");
			
			if( dcrIdInForm != null && dcrIdInForm.length() > 0)
			{
				String confSql = "SELECT COUNT (1) COUNT FROM SPRS_ACT_TRAN WHERE DCR_ID IN ("+dcrIdInForm+")  AND CONFIRMED ='Y'";

				pStmt = conn.prepareStatement( confSql );
				rs = pStmt.executeQuery();
				if( rs.next())
				{
					count = rs.getInt("COUNT");
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if( pStmt != null )
				{
					pStmt.close();
					pStmt = null;
				}

				System.out.println("count =["+count+"]");
				if(count == 0)
				{

					String upDateSql = "UPDATE SPRS_ACT_TRAN SET CONFIRMED = 'Y' , CONF_DATE = ?  " +
							"WHERE DCR_ID IN ("+dcrIdInForm+") "; // added by condition of dcr_id rupali on 14/03/17 for separate pr menu
					pstmtUpd = conn.prepareStatement(upDateSql);
					pstmtUpd.setTimestamp(1, new java.sql.Timestamp(System.currentTimeMillis()));

					int updCnt = pstmtUpd.executeUpdate();
					if( pstmtUpd != null )
					{
						pstmtUpd.close();
						pstmtUpd = null;
					}

					if(updCnt > 0)
					{
						String sql="SELECT DCR_ID,EVENT_DATE FROM SPRS_ACT_TRAN WHERE DCR_ID IN ("+dcrIdInForm+") ORDER BY EVENT_DATE ";
						pStmt = conn.prepareStatement( sql );
						rs = pStmt.executeQuery();
						while( rs.next())
						{
							String dcrId = rs.getString("DCR_ID");
							String eventDate = rs.getString("EVENT_DATE");

							retString = updateIssueQty1(empCodeConf, eventDate, dcrId, conn);
							if(retString != null && retString.length()>0 && (retString.indexOf("ERRORS")!=-1 || retString.indexOf("Errors")!=-1))
							{
								isError = true;
								return retString;
							}
							System.out.println("retString dcrID===========>"+retString);
						}
						if(rs != null)
						{
							rs.close();
							rs = null;
						}
						if( pStmt != null )
						{
							pStmt.close();
							pStmt = null;
						}
                        
						ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
						retString =	itmDBAccessEJB.getErrorString("","CONFIGSUCC","");

						StringBuffer insertBuf = new StringBuffer("<Detail1 domID='1'>");
						insertBuf.append("<confirmed >").append("<![CDATA[").append("Y").append("]]>").append("</confirmed>\r\n");
						insertBuf.append("</Detail1>");
						
					}//When update SPRS_ACT_TRAN as "Y"
				}
			}
		}
		catch(Exception e)
		{
			isError = true;
			System.out.println("Exception :StrgMeetDCRWizConf :==>\n"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}

		finally
		{
			try
			{
				System.out.println("isError ["+isError+"]");
				System.out.println("isLocalConn ["+isLocalConn+"]");
				if( conn != null )
				{

					if( isError )
					{
						conn.rollback();
					}
					if(pStmt != null)
					{
						pStmt.close();
						pStmt = null;
					}
					if ( isLocalConn )
					{
						if ( ! isError )
						{
							conn.commit();
							System.out.println("StrgMeetDCRWizConf Connection commited........");
						}
						conn.close();
						conn = null;
                    }
                    
					//Added by Bhagyashri T For Sample Validation[14/06/22][start]
					if(selectResult != null)
					{
						selectResult.close();
						selectResult = null;
					}
					if(pstmtItem != null)
					{
						pstmtItem.close();
						pstmtItem = null;
					}
					if(rSet1 != null)
					{
						rSet1.close();
						rSet1 = null;
					}
					if(pstmt1 != null)
					{
						pstmt1.close();
						pstmt1 = null;
					}
					//Added by Bhagyashri T For Sample Validation[14/06/22][End]
				}
			}
			catch(Exception e)
			{
				System.out.println("Exception :StrgMeetDCRWizConf :confirm :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		System.out.println("[StrgMeetDCRWizConf]Return string :"+retString);
		return retString;
	}
	private String checkNull(String value)
	{
		if ( value == null )
		{
			value = "";
		}
		return value.trim();
	}

	private String confirmReport(String eventDate, String salesPers, String reportType, Connection conn)throws ITMException
	{
		String returnString = "";
		//Connection conn = null;
		ConnDriver connDriver =  new ConnDriver();

		PreparedStatement pstmt = null;
		PreparedStatement pstmtSel = null;
		ResultSet rs = null;

		int updCnt = -1;
		int pendCnt = 0;
		try
		{
			E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
			ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
			//eventDate = genericUtility.getValidDateTimeString( eventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );
			StrgMeetDCRWizard strgMeetWizrad = new StrgMeetDCRWizard();

			/*//added by Rupali on 23/05/17 for defining sfaparam value for sequential confirmation[start]
			String parmValue = "";
			SimpleDateFormat dtFormat = new SimpleDateFormat(genericUtility.getDBDateTimeFormat());
			String currDate = dtFormat.format(new java.util.Date());
			String sfaParmSql = "SELECT PARM_VALUE FROM SFAPARM WHERE PARM_NAME='SEQUENTIAL_DAR_CONF' AND ? BETWEEN EFF_FROM AND VALID_UPTO AND ACTIVE='Y' ";
			PreparedStatement pstmtSfaParm = conn.prepareStatement(sfaParmSql);
			pstmtSfaParm.setTimestamp(1, java.sql.Timestamp.valueOf(currDate));
			ResultSet rsSfaParm = pstmtSfaParm.executeQuery();
			if (rsSfaParm.next())
			{
				parmValue = checkNull(rsSfaParm.getString("PARM_VALUE"));
			}
			if(rsSfaParm != null)
			{
				rsSfaParm.close();
				rsSfaParm = null;
			}
			if(pstmtSfaParm != null)
			{
				pstmtSfaParm.close();
				pstmtSfaParm = null;
			}*/
			String parmValue =strgMeetWizrad.getSfaParmValue(salesPers,"SEQUENTIAL_DAR_CONF",conn);
			System.out.println("In 1 If parmValue is :"+ parmValue);
			//added by Rupali on 23/05/17 for defining sfaparam value for sequential confirmation[end]
			if(parmValue.equalsIgnoreCase("Y") && !"PR".equalsIgnoreCase(reportType)) // added condition by rupali on 14/03/18 for prescription menu
			{
				//	System.out.println("In 2 If parmValue is :"+ parmValue);
				if("PR".equalsIgnoreCase(reportType))
				{
					String selectSql = "SELECT COUNT(*) AS COUNT FROM SPRS_ACT_TRAN WHERE SALES_PERS = ? AND EVENT_DATE < ? "+
							"AND (CASE WHEN CONFIRMED IS NULL THEN 'N' ELSE CONFIRMED END) = 'N' " +
							"AND ACTIVITY_CODE IN(SELECT ACTIVITY_CODE FROM FIELDACTIVITY WHERE ACTIVITY_TYPE='PR')";

					pstmtSel = conn.prepareStatement(selectSql);
					pstmtSel.setString(1, salesPers);
					pstmtSel.setTimestamp( 2 ,java.sql.Timestamp.valueOf(eventDate) );

					rs = pstmtSel.executeQuery();
					if(rs.next())
					{
						pendCnt = rs.getInt("COUNT");
					}
					System.out.println("pendCnt:"+pendCnt);
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
					if(pstmtSel != null)
					{
						pstmtSel.close();
						pstmtSel = null;
					}
					if(pendCnt > 0)
					{
						//returnString = "PENDING:" + getMessageDescr(conn,"PENDDCRCON");
						returnString =	itmDBAccessEJB.getErrorString("","PENDDCRCON","");
					}

				}
				else
				{
					String selectSql = "SELECT COUNT(*) AS COUNT FROM SPRS_ACT_TRAN WHERE SALES_PERS = ? AND EVENT_DATE < ? "+
							"AND (CASE WHEN CONFIRMED IS NULL THEN 'N' ELSE CONFIRMED END) = 'N' " +
							"AND ACTIVITY_CODE IN(SELECT ACTIVITY_CODE FROM FIELDACTIVITY WHERE ACTIVITY_TYPE !='PR')";

					pstmtSel = conn.prepareStatement(selectSql);
					pstmtSel.setString(1, salesPers);
					pstmtSel.setTimestamp( 2 ,java.sql.Timestamp.valueOf(eventDate) );

					rs = pstmtSel.executeQuery();
					if(rs.next())
					{
						pendCnt = rs.getInt("COUNT");
					}
					System.out.println("pendCnt:"+pendCnt);
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
					if(pstmtSel != null)
					{
						pstmtSel.close();
						pstmtSel = null;
					}
					if(pendCnt > 0)
					{
						returnString =	itmDBAccessEJB.getErrorString("","PENDDCRCON","");
					}
				}
			}
			// Added by Harion S for Activity form changes in fortune server --18-May-2021 [Start]
			String isFortuneActivity =checkNull(strgMeetWizrad.getSfaParmValue(salesPers,"IS_FORTUNE_ACTIVITY",conn));
			
			if(isFortuneActivity.trim().equalsIgnoreCase("Y"))
			{
				boolean isActDataPresent=false;
				SimpleDateFormat date12Format = new SimpleDateFormat("hh:mm a");
			    SimpleDateFormat date24Format = new SimpleDateFormat("HH:mm");
				
				ArrayList<String> fromTime = new ArrayList<String> ();
				ArrayList<String>  toTime = new ArrayList<String> ();
				String actCode="";
				String visitTimeFr="";
				String visitTimeTo="";
				String activitySql = "SELECT ACTIVITY_CODE, VISIT_TIME_FR, VISIT_TIME_TO,REMARK  FROM  SPRS_ACTIVITY WHERE SALES_PERS = ? AND EVENT_DATE = ? ";
				pstmt = conn.prepareStatement( activitySql );
				pstmt.setString( 1, salesPers);
				pstmt.setTimestamp( 2 ,java.sql.Timestamp.valueOf(eventDate) );
				//pstmt.setString( 3, activityCode);
				rs = pstmt.executeQuery();
				while(rs.next())
				{
					isActDataPresent=true;
					actCode = rs.getString("ACTIVITY_CODE");
					visitTimeFr = rs.getString("VISIT_TIME_FR");
					visitTimeTo = rs.getString("VISIT_TIME_TO");
					String time1 = date24Format.format(date12Format.parse(visitTimeFr));
					String time2 = date24Format.format(date12Format.parse(visitTimeTo));
					fromTime.add(time1);
					toTime.add(time2);
				}
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				
				
				//String time1 = date24Format.format(date12Format.parse(visitTimeFr));
				//String time2 = date24Format.format(date12Format.parse(visitTimeTo));
				System.out.println("isActDataPresent::["+isActDataPresent+"]");
				if(isActDataPresent)
				{
					String arrayFromData=(String) Collections.min(fromTime);  
					String arrayToData=(String) Collections.max(toTime);  
					SimpleDateFormat format = new SimpleDateFormat("hh:mm");
					java.util.Date date1 =  format.parse(arrayFromData);
					java.util.Date date2 =  format.parse(arrayToData);
					long difference = date2.getTime() - date1.getTime(); 
					String fixedTime =checkNull(strgMeetWizrad.getSfaParmValue(salesPers,"FIXED_TIME_FORTUNE_ACTIVITY",conn));
					
					String fixedHours=fixedTime.split(":")[0];
					int fixedHours1 =Integer.parseInt(fixedHours);

					String fixedMin=fixedTime.split(":")[1];
					int fixedMin1 =Integer.parseInt(fixedMin);
					
					String differentTime= (difference / 3600000)+":"+(difference % 3600000) / 60000;
					java.util.Date differentTimeDate =  format.parse(differentTime);
					
					
					String actualHours=differentTime.split(":")[0];
					int actualHours1 =Integer.parseInt(actualHours);
					String actualMin=differentTime.split(":")[1];
					int actualMin1 =Integer.parseInt(actualMin);
					

					if(actualHours1 < fixedHours1 )
					{
						returnString =	itmDBAccessEJB.getErrorString("","VTVSTTIM05","");
					}
					else if(actualHours1 == fixedHours1 && actualMin1 < fixedMin1 )
					{
						returnString =	itmDBAccessEJB.getErrorString("","VTVSTTIM05","");
					}
					else
					{
						System.out.println("Not validate.............");
					}
				}
				
						
				
			}
			// Added by Harion S for Activity form changes in fortune server --18-May-2021 [End]
			//System.out.println("updCnt =["+updCnt+"]");
		}
		catch(Exception e)
		{
			try
			{
				//conn.rollback();
				System.out.println("Exception :StrgMeetDCRWizConf confirmReport():==>\n"+e.getMessage());
				returnString =	new ITMDBAccessEJB().getErrorString("","CONFIGFLD","");
				e.printStackTrace();
			}
			catch(Exception e1)
			{
				e1.printStackTrace();
			}

		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}

				/*if(conn != null )
				{
					conn.close();
					conn = null;
				}*/
			}
			catch(Exception expRsc)
			{
				expRsc.printStackTrace();
			}
		}

		return returnString;
	}

	//Added by kailash on 03-12-18 for jasper reprot sending after confirmation of dcr[start]
	public String confirm(String dcrId, String xtraParams, String forcedFlag,Connection conn) throws RemoteException,ITMException
	{
		String retString = "";
		boolean isError = false;
		PreparedStatement pStmt = null;
		PreparedStatement pstmtUpd = null;
		ResultSet rs = null;
		boolean isLocalConn = false;
		//String dcrId = "";
		String empCodeConf = "" ,eventDate = "";
		String objName = "";
		String tranIdCol = "";
		int count = 0;

		String currDate = "";

		String xmlStringAll ="";

		//Connection conn = null;
		String transDB = getUserInfo().getTransDB();
		System.out.println("transDB>["+transDB+"]");
		try
		{
			System.out.println("dcrId ::759"+dcrId);
			System.out.println("xtraParams ::760"+xtraParams);
			System.out.println("postConfirm method is called.........");
			if(conn == null)
			{
				conn = getConnection();
				isLocalConn = true;
				conn.setAutoCommit( false );
			}
			if(!xtraParams.contains("#"))
			{
				empCodeConf = checkNull(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode"));
			}
			else
			{
				String[] xtraParmArr = xtraParams.split("#");
				empCodeConf = xtraParmArr[0];
			}

			objName = checkNull(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "objName"));
			objName = "w_" + objName;
			String sql1 = "SELECT TRAN_ID_COL FROM TRANSETUP WHERE TRAN_WINDOW = ?";
			pStmt = conn.prepareStatement( sql1 );
			pStmt.setString( 1, objName);
			rs = pStmt.executeQuery();
			if( rs.next())
			{
				tranIdCol = rs.getString("TRAN_ID_COL");

			}
			System.out.println("tranIdCol >>>>>>>>>>=["+tranIdCol+"]");
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if( pStmt != null )
			{
				pStmt.close();
				pStmt = null;
			}

			if("tran_id".equalsIgnoreCase(tranIdCol))
			{
				sql1 = "SELECT DCR_ID FROM STRG_MEET WHERE TRAN_ID = ?";
				pStmt = conn.prepareStatement( sql1 );
				pStmt.setString( 1, dcrId);
				rs = pStmt.executeQuery();
				if( rs.next())
				{
					dcrId = checkNull(rs.getString("DCR_ID"));
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if( pStmt != null )
				{
					pStmt.close();
					pStmt = null;
				}
			}

			System.out.println("dcrId =>>>>>>>>>["+dcrId+"], empCodeConf=["+empCodeConf+"]");

			DateFormat dtFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());
			java.util.Date date = Calendar.getInstance().getTime();
			currDate = dtFormat.format( date );

			currDate = genericUtility.getValidDateTimeString( currDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );
			System.out.println("currDate ::>>>>>>["+currDate+"]");


			if( dcrId != null && dcrId.length() > 0)
			{
				String confSql = "SELECT COUNT (1) COUNT FROM SPRS_ACT_TRAN WHERE DCR_ID = ? AND CONFIRMED ='Y'";

				pStmt = conn.prepareStatement( confSql );
				pStmt.setString( 1, dcrId);
				rs = pStmt.executeQuery();
				if( rs.next())
				{
					count = rs.getInt("COUNT");
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if( pStmt != null )
				{
					pStmt.close();
					pStmt = null;
				}

				System.out.println("count =["+count+"]");
				if(count > 0)
				{
					try
					{
						int emailCount = 0;
						int smsCount = 0;
						String sfaparmEmailSql = "SELECT COUNT (1) COUNT FROM SFAPARM WHERE ORG_UNIT = 'ALL' AND PARM_NAME='EMAIL_ORDER_REPORT' AND ACTIVE ='Y' AND (? BETWEEN EFF_FROM AND VALID_UPTO)";

						pStmt = conn.prepareStatement( sfaparmEmailSql );
						pStmt.setTimestamp(1,java.sql.Timestamp.valueOf(currDate));
						rs = pStmt.executeQuery();
						if( rs.next())
						{
							emailCount = rs.getInt("COUNT");
						}
						if(rs != null)
						{
							rs.close();
							rs = null;
						}
						if( pStmt != null )
						{
							pStmt.close();
							pStmt = null;
						}
						String sfaparmSMSSql = "SELECT COUNT (1) COUNT FROM SFAPARM WHERE ORG_UNIT = 'ALL' AND PARM_NAME='SMS_ORDER_REPORT' AND ACTIVE ='Y' AND (? BETWEEN EFF_FROM AND VALID_UPTO)";

						//pStmt = conn.prepareStatement( sfaparmEmailSql );
						pStmt = conn.prepareStatement( sfaparmSMSSql );
						pStmt.setTimestamp(1,java.sql.Timestamp.valueOf(currDate));
						rs = pStmt.executeQuery();
						if( rs.next())
						{
							smsCount = rs.getInt("COUNT");
						}
						if(rs != null)
						{
							rs.close();
							rs = null;
						}
						if( pStmt != null )
						{
							pStmt.close();
							pStmt = null;
						}
						
						System.out.println("emailCount>>["+emailCount+"]smsCount>>"+smsCount+"]");
						if(emailCount > 0 || smsCount > 0)
						{
							//Changed by Prasad on 18/06/2021 [create a seperate method for email notification] START
							sendNotification( dcrId, eventDate, empCodeConf, xtraParams, conn );
							//Changed by Prasad on 18/06/2021 [create a seperate method for email notification] END
						}
					}
					catch(Exception re)
					{
						re.printStackTrace();
					}
					finally
					{
						try
						{

						}
						catch(Exception e1)
						{

						}
					}
				}
			}
			//added by mrunalini sinkar on 08-01-2019 when order is not there then show this string (start )
			if(retString.trim().length()==0)
			{
				retString ="SEND_SUCCESS";
			}
			//added by mrunalini sinkar on 08-01-2019 when order is not there then show this string (end )
		}
		catch(Exception e)
		{
			isError = true;
			System.out.println("Exception :StrgMeetDCRWizConf :==>\n"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				System.out.println("isError ["+isError+"]");
				System.out.println("isLocalConn ["+isLocalConn+"]");
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if( pStmt != null )
				{
					pStmt.close();
					pStmt = null;
				}
				if(conn != null )
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				System.out.println("Exception :StrgMeetDCRWizConf :confirm :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		System.out.println("[StrgMeetDCRWizConf]Return string :"+retString);
		return retString;
	}
	
	//Changed by Prasad on 18/06/2021 [create a seperate method for email notification] START
	public void sendNotification( String dcrId, String eventDate, String empCodeConf, String xtraParams, Connection conn )
	{
		PreparedStatement pStmt = null;
		ResultSet rs = null;
		String retString = "";
		try
		{
			String transDB = getUserInfo().getTransDB();
			
			DateFormat dtFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());
			java.util.Date date = Calendar.getInstance().getTime();
			String currDate = dtFormat.format( date );

			currDate = genericUtility.getValidDateTimeString( currDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );
			System.out.println("currDate ::["+currDate+"]");
			
			String prefStockist = "";
			String strgCode = ""; 
			String evntDate = ""; 
			ArrayList<String> prefStockistList = new ArrayList<String>();
			ArrayList<String> strgList = new ArrayList<String>();
			String prefStockistSql = "SELECT DISTINCT SMO.STOCKIST_CODE, SM.SALES_PERS, '' AS STRG_CODE, SM.EVENT_DATE "
					+ " FROM STRG_MEET_ORDER SMO, STRG_MEET SM "
					+ " WHERE SM.STRG_CODE = SMO.STRG_CODE AND SM.DCR_ID = SMO.DCR_ID AND SMO.DCR_ID= ?";
			pStmt = conn.prepareStatement( prefStockistSql );
			pStmt.setString(1,dcrId);
			rs = pStmt.executeQuery();
			while( rs.next())
			{
				prefStockist = checkNull(rs.getString("STOCKIST_CODE"));
				strgCode = checkNull(rs.getString("STRG_CODE"));
				evntDate  = checkNull(rs.getString("EVENT_DATE"));
				System.out.println("evntDate>>>>>["+evntDate+"]");
				evntDate = genericUtility.getValidDateString( evntDate, genericUtility.getDBDateFormat(),genericUtility.getApplDateFormat() );
				System.out.println("evntDate in appl format ["+evntDate+"]");

				if(prefStockist.length() > 0 )
				{
					prefStockistList.add(prefStockist);
				}
				if(strgCode.length() > 0 )
				{
					strgList.add(strgCode);
				}
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if( pStmt != null )
			{
				pStmt.close();
				pStmt = null;
			}
			System.out.println("prefStockistList ["+ prefStockistList +"], strgList ["+ strgList +"]");
			
			String reportName ="";
			if( prefStockistList != null && prefStockistList.size() > 0 )	
			{
				System.out.println("inside prefStockistList");
				//reportName ="d_stockist_order";
				String objNameStockist ="d_stockist_rpt";
				reportName = objNameStockist;
				for( int i = 0; i < prefStockistList.size(); i++ )
				{
					StringBuffer xmlStrBuffer = new StringBuffer();
					prefStockist = (String)prefStockistList.get(i);
					System.out.println("prefStockist list >>>>>>>>>["+prefStockist+"]");
					
					xmlStrBuffer.append("<Root>");
					xmlStrBuffer.append("<Detail1 objContext='1' objName='"+ objNameStockist +"'>");
					xmlStrBuffer.append("<sc_code><![CDATA[").append(prefStockist).append("]]></sc_code>\n");
					xmlStrBuffer.append("<event_date><![CDATA[").append(evntDate).append("]]></event_date>\n");
					xmlStrBuffer.append("<sales_pers><![CDATA[").append(empCodeConf).append("]]></sales_pers>\n");
					xmlStrBuffer.append("<user_id><![CDATA[").append(empCodeConf).append("]]></user_id>\n");
					xmlStrBuffer.append("</Detail1>");
					xmlStrBuffer.append("</Root>");
					retString = emailReport( xmlStrBuffer.toString(), reportName, xtraParams, transDB );
					
					if( strgList != null && strgList.size() > 0 )
					{
						String custCode = (String)strgList.get(i);
						String xmlSmsStocksit = getStockistSmsDetail( empCodeConf, dcrId, custCode, prefStockist, conn, objNameStockist );
						System.out.println("xmlSmsStocksit>>>>>>>["+xmlSmsStocksit+"]");
						if( ! "".equals( xmlSmsStocksit ) )
						{
							smsReport( xmlSmsStocksit, reportName, xtraParams, transDB );
						}
					}
				}
			}
			if( strgList != null && strgList.size() > 0 )
			{
				System.out.println("inside strgList");
				//reportName ="d_retailer_order";
				String objNameRetail ="d_retailer_order";
				reportName = objNameRetail;
				for( int i = 0; i < strgList.size(); i++ )
				{
					StringBuffer xmlStrBuffer = new StringBuffer();
					strgCode = (String)strgList.get(i);
					System.out.println("strgCode list >>>>>>>>>["+strgCode+"]");
					
					xmlStrBuffer.append("<Root>");
					xmlStrBuffer.append("<Detail1 objContext='1' objName='"+ objNameRetail +"'>");
					xmlStrBuffer.append("<sc_code><![CDATA[").append(strgCode).append("]]></sc_code>\n");
					xmlStrBuffer.append("<event_date><![CDATA[").append(evntDate).append("]]></event_date>\n");
					xmlStrBuffer.append("<sales_pers><![CDATA[").append(empCodeConf).append("]]></sales_pers>\n");
					xmlStrBuffer.append("<user_id><![CDATA[").append(empCodeConf).append("]]></user_id>\n");
					xmlStrBuffer.append("</Detail1>");
					xmlStrBuffer.append("</Root>");
					retString = emailReport( xmlStrBuffer.toString(), reportName, xtraParams, transDB );
					
					String xmlSmsRetailer = getRetailerSmsDetail( empCodeConf, dcrId, strgCode, conn, objNameRetail );
					System.out.println("xmlSmsRetailer>>>>["+xmlSmsRetailer+"]");
					if( ! "".equals( xmlSmsRetailer ) )
					{
						smsReport( xmlSmsRetailer, reportName, xtraParams, transDB );
					}
				}
			}
			System.out.println("retString>>>>["+ retString +"]");
		}
		catch(Exception re)
		{
			System.out.println("Exception :: sendCustomerNotification : ["+ re.getMessage() +"]");
			re.printStackTrace();
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if( pStmt != null )
				{
					pStmt.close();
					pStmt = null;
				}
			}
			catch(Exception e1)
			{

			}
		}
	}
	//Changed by Prasad on 18/06/2021 [create a seperate method for email notification] END
	
	private String emailReport(String xmlString, String reportName, String xtraParams, String transDB) throws ITMException
	{
		System.out.println("inside emailReport transDB["+transDB+"]");
		String reportArgs ="";
		String reportType ="PDF";
		String formatCode ="ORDER_RPT";
		String retString ="";

		StringBuffer xmlStrBuf = new StringBuffer();
		try
		{
			reportArgs ="sc_code.String:as_sc_code,event_date.Date:as_date_fr,sales_pers.String:as_sales_pers,user_id.String:as_user_id";
			E12ReportComp e12ReportComp = new E12ReportComp();
			e12ReportComp.setUserInfo(getUserInfo());
			retString = e12ReportComp.sendReport( xmlString,  reportName,  reportArgs,  reportType,  formatCode,  xtraParams);
			System.out.println("retString emailReport>>>>>>>"+retString+"]");
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		return retString;
	}
	
	private void smsReport(String xmlString, String reportName, String xtraParams, String transDB) throws ITMException
	{
		String reportArgs ="";
		String formatCode ="";
		if(reportName.equalsIgnoreCase("d_retailer_order"))
		{
			formatCode ="ORDER_RTL";
		}
		if(reportName.equalsIgnoreCase("d_stockist_rpt"))
		{
			formatCode ="ORDER_RPT";
		}
		String retString ="";
		UserInfoBean userInfo = new UserInfoBean();
		try
		{
			String userInfoStr = "<UserInfo><transDB><![CDATA["+transDB+"]]></transDB></UserInfo>";
			userInfo = new UserInfoBean(userInfoStr); 
			E12SMSComp e12SMSComp = new E12SMSComp();
			retString = e12SMSComp.sendSMS(xmlString, formatCode, xtraParams, userInfo);
			System.out.println("retString>>>>>>>1184"+retString+"]");
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
	}
	private String getStockistSmsDetail(String salesPers, String dcrId,String custCode,String strgCode,Connection conn,String objName) throws ITMException
	{
		int quantity = 0;
		String spName ="";
		String mobile ="";
		String custName="",address="",promoDescr="",itemDescr="";
		String sql ="";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String xmlStringSms ="";
		try
		{
			StringBuffer xmlStrBuf = new StringBuffer();
			System.out.println("objName>>>["+objName+"]strgCode>>["+strgCode+"]custCode>>["+custCode+"]");
			xmlStrBuf.append("<Root>");
			xmlStrBuf.append("<Detail1 objName='"+objName+"'>");
			sql = "SELECT (SC.FIRST_NAME || ' ' || SC.MIDDLE_NAME || ' ' ||SC.LAST_NAME) AS CUSTOMER_NAME, (SC.ADDR1 ||' '|| SC.ADDR2 ||' '|| SC.ADDR3) AS ADDRESS  FROM STRG_CUSTOMER SC WHERE SC.SC_CODE = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString( 1, custCode);
			rs = pstmt.executeQuery();
			if( rs.next())
			{
				custName = checkNull(rs.getString("CUSTOMER_NAME"));
				address = checkNull(rs.getString("ADDRESS"));
				System.out.println("custName>>["+custName+"]address>>>"+address+"]");
				xmlStrBuf.append("<sc_code><![CDATA[").append(strgCode).append("]]></sc_code>\n");
				xmlStrBuf.append("<customer_name><![CDATA[").append(custName).append("]]></customer_name>\n");
				xmlStrBuf.append("<address><![CDATA[").append(address).append("]]></address>\n");
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}

			StringBuffer itembuffer = new StringBuffer();
			//StringBuffer schemebuffer = new StringBuffer();
			int srNo = 0;

			sql = "SELECT SMO.VALUE AS SKU,SMO.QUANTITY AS QUANTITY, SMO.DISC_PERC AS DISC_PERC,BM.DESCR AS PROMO_DESCR, ITM.DESCR AS ITEM_DESCR "
					+ " FROM STRG_MEET_ORDER SMO "
					+ " LEFT OUTER JOIN BOM BM ON  BM.BOM_CODE = SMO.PROMO_CODE "
					+ " LEFT OUTER JOIN ITEM ITM ON SMO.ITEM_CODE = ITM.ITEM_CODE "
					+ " WHERE SMO.DCR_ID = ? AND SMO.STOCKIST_CODE = ? AND SMO.STRG_CODE = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString( 1, dcrId);
			pstmt.setString( 2, strgCode);
			pstmt.setString( 3, custCode);
			rs = pstmt.executeQuery();
			while( rs.next())
			{
				srNo++;
				System.out.println("inside while getStockistSmsDetail");
				quantity = rs.getInt("QUANTITY");
				itemDescr = checkNull(rs.getString("ITEM_DESCR"));
				promoDescr = checkNull(rs.getString("PROMO_DESCR"));
				if(promoDescr != "")
				{
					itembuffer.append(srNo+"."+ itemDescr +" ("+promoDescr+") -"+quantity+"\n");
				}
				else
				{
					itembuffer.append(srNo+"."+ itemDescr +" "+"-"+quantity+"\n");
				}
				xmlStrBuf.append("<item_descr><![CDATA[").append(itemDescr).append("]]></item_descr>\n");
				xmlStrBuf.append("<item_details><![CDATA[").append(itembuffer.toString()).append("]]></item_details>\n");
				/*if(promoDescr != "")
				{
					schemebuffer.append(promoDescr+",");

				}
				xmlStrBuf.append("<bom_descr><![CDATA[").append(schemebuffer.toString()).append("]]></bom_descr>\n");*/
			}
			System.out.println("itembuffer>>>1382"+itembuffer.toString());
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}

			sql = "SELECT SALES_PERS,SP_NAME,MOBILE_NO FROM SALES_PERS S,EMPLOYEE EMP WHERE S.SALES_PERS = ? AND S.SALES_PERS = EMP.EMP_CODE ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString( 1, salesPers);
			rs = pstmt.executeQuery();
			if( rs.next())
			{
				spName = checkNull(rs.getString("SP_NAME"));
				mobile = checkNull(rs.getString("MOBILE_NO"));
				System.out.println("spName>>["+spName+"]mobile>>>"+mobile+"]");
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			xmlStrBuf.append("<sp_name><![CDATA[").append(spName).append("]]></sp_name>\n");
			xmlStrBuf.append("<mobile_no><![CDATA[").append(mobile).append("]]></mobile_no>\n");
			xmlStrBuf.append("</Detail1>");
			xmlStrBuf.append("</Root>");
			if(srNo > 0)
			{
				xmlStringSms = xmlStrBuf.toString();
			}
			System.out.println("xmlStringSms>>1419["+xmlStringSms+"]");
		}
		catch(Exception e)
		{
			System.out.println("excption occured"+e.getMessage());
			e.printStackTrace();
		}
		return xmlStringSms;
	}
	
	private String getRetailerSmsDetail(String salesPers, String dcrId,String custCode,Connection conn,String objName) throws ITMException
	{
		int quantity = 0;
		String spName ="";
		String mobile ="";
		String custName="",address="",promoDescr="",itemDescr="";
		String sql ="";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String xmlStringSms ="";
		try
		{
			StringBuffer xmlStrBuf = new StringBuffer();
			System.out.println("objName>>>["+objName+"]custCode>>["+custCode+"]");
			xmlStrBuf.append("<Root>");
			xmlStrBuf.append("<Detail1 objName='"+objName+"'>");
			sql = "SELECT (SC.FIRST_NAME || ' ' || SC.MIDDLE_NAME || ' ' ||SC.LAST_NAME) AS CUSTOMER_NAME, (SC.ADDR1 ||' '|| SC.ADDR2 ||' '|| SC.ADDR3) AS ADDRESS  FROM STRG_CUSTOMER SC WHERE SC.SC_CODE = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString( 1, custCode);
			rs = pstmt.executeQuery();
			if( rs.next())
			{
				custName = checkNull(rs.getString("CUSTOMER_NAME"));
				address = checkNull(rs.getString("ADDRESS"));
				xmlStrBuf.append("<sc_code><![CDATA[").append(custCode).append("]]></sc_code>\n");
				System.out.println("custName>>["+custName+"]address>>>"+address+"]");
				xmlStrBuf.append("<customer_name><![CDATA[").append(custName).append("]]></customer_name>\n");
				xmlStrBuf.append("<address><![CDATA[").append(address).append("]]></address>\n");
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			StringBuffer itembuffer = new StringBuffer();
			//StringBuffer schemebuffer = new StringBuffer();
			int srNo = 0;
			sql = "SELECT SMO.VALUE AS SKU,SMO.QUANTITY AS QUANTITY, SMO.DISC_PERC AS DISC_PERC,BM.DESCR AS PROMO_DESCR, ITM.DESCR AS ITEM_DESCR "
					+ " FROM STRG_MEET_ORDER SMO "
					+ " LEFT OUTER JOIN BOM BM ON  BM.BOM_CODE = SMO.PROMO_CODE "
					+ " LEFT OUTER JOIN ITEM ITM ON SMO.ITEM_CODE = ITM.ITEM_CODE "
					+ " WHERE SMO.DCR_ID = ? AND SMO.STRG_CODE = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString( 1, dcrId);
			pstmt.setString( 2, custCode);
			rs = pstmt.executeQuery();
			while( rs.next())
			{
				srNo++;
				System.out.println("inside while getRetailerSmsDetail");
				quantity = rs.getInt("QUANTITY");
				itemDescr = checkNull(rs.getString("ITEM_DESCR"));
				promoDescr = checkNull(rs.getString("PROMO_DESCR"));
				if(promoDescr != "")
				{
					itembuffer.append(srNo+"."+ itemDescr +" ("+promoDescr+") -"+quantity+"\n");
				}
				else
				{
					itembuffer.append(srNo+"."+ itemDescr +" "+"-"+quantity+"\n");
				}
				xmlStrBuf.append("<item_descr><![CDATA[").append(itemDescr).append("]]></item_descr>\n");
				xmlStrBuf.append("<item_details><![CDATA[").append(itembuffer.toString()).append("]]></item_details>\n");
				/*if(promoDescr != "")
				{
					schemebuffer.append(promoDescr+",");
				}
				xmlStrBuf.append("<bom_descr><![CDATA[").append(schemebuffer.toString()).append("]]></bom_descr>\n");*/
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}

			sql = "SELECT SALES_PERS,SP_NAME,MOBILE_NO FROM SALES_PERS S,EMPLOYEE EMP WHERE S.SALES_PERS = ? AND S.SALES_PERS = EMP.EMP_CODE ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString( 1, salesPers);
			rs = pstmt.executeQuery();
			if( rs.next())
			{
				spName = checkNull(rs.getString("SP_NAME"));
				mobile = checkNull(rs.getString("MOBILE_NO"));
				System.out.println("spName>>["+spName+"]mobile>>>1535["+mobile+"]");
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			xmlStrBuf.append("<sp_name><![CDATA[").append(spName).append("]]></sp_name>\n");
			xmlStrBuf.append("<mobile_no><![CDATA[").append(mobile).append("]]></mobile_no>\n");
			xmlStrBuf.append("</Detail1>");
			xmlStrBuf.append("</Root>");
			if(srNo > 0)
			{
				xmlStringSms = xmlStrBuf.toString();
			}
			System.out.println("xmlStringSms>>1061["+xmlStringSms+"]");
		}
		catch(Exception e)
		{
			System.out.println("excption occured"+e.getMessage());
			e.printStackTrace();
		}
		return xmlStringSms;
	}
	//Added by kailash on 03-12-18 for jasper reprot sending after confirmation of dcr[end]

	//Added By Nilesh for Instance Workflow on click on Confirm Button Start :: 08-05-19
	public ArrayList<String> checkStrgCustRecord(String dcrDate,String SalesPersonCode , String dcrId ,Connection connectionObject )
	{
		ResultSet rs = null;
		PreparedStatement pstmt = null;

		String sql = "";
		String userId = "";
		String sprsName = "";
		String actDescr = "";
		String currDate = "";
		String locDescr ="";
		String code="";
		String preFormDet ="";
		String retString="";
		String [] temp = new String [10];
		String returnStr = "";
		StringBuffer valueXmlString = new StringBuffer();
		int currentFormNo = 0;
		PreparedStatement planPstmt = null;
		ResultSet planRs = null;
		GenericWorkflowClass genWorkflow= new GenericWorkflowClass();
		ArrayList<String> tranIdList =new ArrayList<String>();
		try
		{

			DateFormat dtFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());
			java.util.Date date = Calendar.getInstance().getTime();
			currDate = dtFormat.format( date );

			String sfaParmSql = "SELECT PARM_VALUE FROM SFAPARM WHERE PARM_NAME='UNLISTED_REG_OPT' AND ORG_UNIT='ALL' AND ? BETWEEN EFF_FROM AND VALID_UPTO  ";
			System.out.println("QUERY IS:"+sfaParmSql);
			String parmValue = "";
			PreparedStatement pstmtSfaParm = connectionObject.prepareStatement(sfaParmSql);
			pstmtSfaParm.setTimestamp(1, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( currDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
			ResultSet rsSfaParm = pstmtSfaParm.executeQuery();
			if(rsSfaParm.next())
			{
				parmValue = checkNull(rsSfaParm.getString("PARM_VALUE"));
			}

			if(rsSfaParm != null)
			{
				rsSfaParm.close();
				rsSfaParm = null;
			}
			if(pstmtSfaParm != null)
			{
				pstmtSfaParm.close();
				pstmtSfaParm = null;
			}
			if(parmValue.equals("1"))
			{

				System.out.println("dcrDate:::::"+dcrDate);
				String getTranId = "SELECT TRAN_ID FROM  STRG_CUST_ADD WHERE EVENT_DATE = ? AND SALES_PERS = ? ";
				System.out.println("QUERY IS:"+getTranId);
				String tranID="";
				pstmt = connectionObject.prepareStatement(getTranId);
				pstmt.setTimestamp( 1, java.sql.Timestamp.valueOf(dcrDate));
				pstmt.setString( 2, SalesPersonCode);
				rs = pstmt.executeQuery();
				while(rs.next())
				{
					tranID = checkNull(rs.getString("TRAN_ID"));
					System.out.println("tranID IS:"+tranID);
					if(tranID != null && tranID.trim().length()>0)
					{
						tranIdList.add(tranID);
					}
				}

				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}

				if(tranIdList != null && !tranIdList.isEmpty())
				{
					StrgMeetDCRWizard strgMeetWizrad = new StrgMeetDCRWizard();
					String hoEmpCode = checkNull(strgMeetWizrad.getSfaParmValue(SalesPersonCode,"DAR_DIVISION_HO",connectionObject));
					String wrkflwAprvLevel = checkNull(strgMeetWizrad.getSfaParmValue(SalesPersonCode,"UNLIST_WRKFLW_LEVEL",connectionObject));
					for(int i=0; i< tranIdList.size(); i++)
					{
						String schTranId = tranIdList.get(i);

						//Change by sadique shaikh 04-03-2020 [unlisted customer event info realted changes]
						String getStrgCustAddSql = "SELECT S.DCR_ID, S.TRAN_ID, S.SALES_PERS, SP.SP_NAME, S.EVENT_DATE, S.EVENT_TYPE, S.STRG_CODE, S.ADDRESS_AS, S.STRG_NAME, S.STRG_TYPE, " +
								"S.GENDER, S.REMARKS, S.LOCALITY_CODE, S.CONFIRMED, S.CONF_DATE, S.WF_STATUS, S.EMP_CODE__APRV, S.CHG_DATE, S.CHG_USER, S.CHG_TERM, " +
								"S.ADDR1, S.ADDR2, S.ADDR3, S.MOBILE_NO, S.EMAIL_ADDR, L.DESCR,S.SUBCLASS_CODE,SCS.SUBCLASS_DESCR,S.STRG_CLASS_CODE,SCC.CLASS_CODE_DESCR, " +
								"S.SPL_CODE,SPE.DESCR AS SPECIALITY,S.PROMOTER_NAME,S.MAN_POWER,S.PIN,S.GST_NO,S.IMAGE_ID,s.strg_event_info, S.REG_NO " +
								"FROM  LOCALITY L, SALES_PERS SP, STRG_CUST_ADD S LEFT OUTER JOIN SPECIALITY SPE ON S.SPL_CODE = SPE.SPL_CODE " +
								"LEFT OUTER JOIN STRG_CUST_CLASS SCC ON S.STRG_CLASS_CODE = SCC.CLASS_CODE AND S.STRG_TYPE=SCC.CUST_TYPE " +
								"LEFT OUTER JOIN STRG_CUST_SUBCLASS SCS ON S.SUBCLASS_CODE = SCS.SUBCLASS_CODE AND S.STRG_TYPE=SCS.CUST_TYPE " +
								"WHERE S.LOCALITY_CODE = L.LOCALITY_CODE " +
								"AND S.SALES_PERS = SP.SALES_PERS " +
								"AND S.CONFIRMED ='Y' " +
								"AND S.WF_STATUS ='P' "+
								"AND S.TRAN_ID = ? ";

						pstmt = connectionObject.prepareStatement(getStrgCustAddSql);
						pstmt.setString(1,schTranId);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							StringBuffer valueXmlStringBuf = new StringBuffer();
							String dcrIDdb = checkNull(rs.getString("DCR_ID"));
							String tranIDdb = checkNull(rs.getString("TRAN_ID"));
							String salesPers = checkNull(rs.getString("SALES_PERS"));
							String eventDate = checkNull(rs.getString("EVENT_DATE"));
							if(eventDate != null)
							{
								eventDate = genericUtility.getValidDateTimeString( eventDate, genericUtility.getDBDateFormat(), genericUtility.getApplDateFormat() );
							}

							String eventType = checkNull(rs.getString("EVENT_TYPE"));
							String strgCodedb = checkNull(rs.getString("STRG_CODE"));
							String addressAs = checkNull(rs.getString("ADDRESS_AS"));
							String strgName = checkNull(rs.getString("STRG_NAME"));
							String strgType = checkNull(rs.getString("STRG_TYPE"));
							String gender = checkNull(rs.getString("GENDER"));
							String remarks = checkNull(rs.getString("REMARKS"));
							String localityCode = checkNull(rs.getString("LOCALITY_CODE"));
							String confirmed = checkNull(rs.getString("CONFIRMED"));
							String confDate = checkNull(rs.getString("CONF_DATE"));
							String regNo = checkNull(rs.getString("REG_NO"));
							/*if(confDate != null)
							{
								confDate = genericUtility.getValidDateTimeString( confDate, genericUtility.getDBDateFormat(), genericUtility.getApplDateFormat() );
							}*/
							String wfStatus = checkNull(rs.getString("WF_STATUS"));
							String empCodeAprv = checkNull(rs.getString("EMP_CODE__APRV"));
							String chgDate = checkNull(rs.getString("CHG_DATE"));
							
							if(chgDate != null)
							{
								chgDate = genericUtility.getValidDateTimeString( chgDate, genericUtility.getDBDateFormat(), genericUtility.getApplDateFormat() );
							}

							String chgUser = checkNull(rs.getString("CHG_USER"));
							String chgTerm = checkNull(rs.getString("CHG_TERM"));
							String addr1 = checkNull(rs.getString("ADDR1"));
							String addr2 = checkNull(rs.getString("ADDR2"));
							String addr3 = checkNull(rs.getString("ADDR3"));
							String mobileNo = checkNull(rs.getString("MOBILE_NO"));
							String emailAddr = checkNull(rs.getString("EMAIL_ADDR"));
							String localityDescr = checkNull(rs.getString("DESCR"));

							valueXmlStringBuf.append("<DocumentRoot><description>Datawindow Root</description><group0><description>Group0 description</description><Header0><description>Header0 members</description>\r\n");
							valueXmlStringBuf.append("<Detail1 dbID ='"+tranIDdb+"' domID='1' objName='strg_cust_add_aprv' objContext='1' >\r\n" );
							valueXmlStringBuf.append("<attribute pkNames='tran_id' status='N' updateFlag='A' selected='Y' />\r\n");
							valueXmlStringBuf.append("<tran_id><![CDATA[" ).append(tranIDdb).append( "]]></tran_id>\r\n" );
							valueXmlStringBuf.append("<dcr_id><![CDATA[" ).append(dcrIDdb).append( "]]></dcr_id>\r\n" );
							valueXmlStringBuf.append("<sales_pers><![CDATA[" ).append(salesPers).append( "]]></sales_pers>\r\n" );
							valueXmlStringBuf.append("<event_date><![CDATA[" ).append(eventDate).append( "]]></event_date>\r\n" );
							valueXmlStringBuf.append("<event_type><![CDATA[" ).append(eventType).append( "]]></event_type>\r\n" );
							valueXmlStringBuf.append("<strg_code><![CDATA[" ).append(strgCodedb).append( "]]></strg_code>\r\n" );
							valueXmlStringBuf.append("<address_as><![CDATA[" ).append(addressAs).append( "]]></address_as>\r\n" );
							valueXmlStringBuf.append("<strg_name><![CDATA[" ).append(strgName).append( "]]></strg_name>\r\n" );
							valueXmlStringBuf.append("<strg_type><![CDATA[" ).append(strgType).append( "]]></strg_type>\r\n" );
							valueXmlStringBuf.append("<gender><![CDATA[" ).append(gender).append( "]]></gender>\r\n" );
							valueXmlStringBuf.append("<remarks><![CDATA[" ).append(remarks).append( "]]></remarks>\r\n" );
							valueXmlStringBuf.append("<locality_code><![CDATA[" ).append(localityCode).append( "]]></locality_code>\r\n" );
							valueXmlStringBuf.append("<confirmed><![CDATA[" ).append(confirmed).append( "]]></confirmed>\r\n" );
							//valueXmlStringBuf.append("<conf_date><![CDATA[" ).append(confDate).append( "]]></conf_date>\r\n" );
							valueXmlStringBuf.append("<wf_status><![CDATA[" ).append("S").append( "]]></wf_status>\r\n" );
							valueXmlStringBuf.append("<emp_code__aprv><![CDATA[" ).append(empCodeAprv).append( "]]></emp_code__aprv>\r\n" );
							valueXmlStringBuf.append("<chg_date><![CDATA[" ).append(chgDate).append( "]]></chg_date>\r\n" );
							valueXmlStringBuf.append("<chg_user><![CDATA[" ).append(chgUser).append( "]]></chg_user>\r\n" );
							valueXmlStringBuf.append("<chg_term><![CDATA[" ).append(chgTerm).append( "]]></chg_term>\r\n" );
							valueXmlStringBuf.append("<addr1><![CDATA[" ).append(addr1).append( "]]></addr1>\r\n" );
							valueXmlStringBuf.append("<addr2><![CDATA[" ).append(addr2).append( "]]></addr2>\r\n" );
							valueXmlStringBuf.append("<addr3><![CDATA[" ).append(addr3).append( "]]></addr3>\r\n" );
							valueXmlStringBuf.append("<mobile_no><![CDATA[" ).append(mobileNo).append( "]]></mobile_no>\r\n" );
							valueXmlStringBuf.append("<email_addr><![CDATA[" ).append(emailAddr).append( "]]></email_addr>\r\n" );
							valueXmlStringBuf.append("<descr><![CDATA[" ).append(localityDescr).append( "]]></descr>\r\n" );
							valueXmlStringBuf.append("<dcr_id><![CDATA[" ).append(dcrId).append( "]]></dcr_id>\r\n" );
							valueXmlStringBuf.append("<emp_code_ho><![CDATA[" ).append(hoEmpCode).append( "]]></emp_code_ho>\r\n" );//Added by kailash on 17-12-18.
							//Added by kailash on 25-01-19 for chc related changes[start]
							valueXmlStringBuf.append("<spl_code><![CDATA[" ).append(checkNull(rs.getString("SPL_CODE"))).append( "]]></spl_code>\r\n" );
							valueXmlStringBuf.append("<speciality_descr><![CDATA[" ).append(checkNull(rs.getString("SPECIALITY"))).append( "]]></speciality_descr>\r\n" );
							valueXmlStringBuf.append("<strg_class_code><![CDATA[" ).append(checkNull(rs.getString("STRG_CLASS_CODE"))).append( "]]></strg_class_code>\r\n" );
							valueXmlStringBuf.append("<class_code_descr><![CDATA[" ).append(checkNull(rs.getString("CLASS_CODE_DESCR"))).append( "]]></class_code_descr>\r\n" );
							valueXmlStringBuf.append("<subclass_code><![CDATA[" ).append(checkNull(rs.getString("SUBCLASS_CODE"))).append( "]]></subclass_code>\r\n" );
							valueXmlStringBuf.append("<subclass_descr><![CDATA[" ).append(checkNull(rs.getString("SUBCLASS_DESCR"))).append( "]]></subclass_descr>\r\n" );
							valueXmlStringBuf.append("<pin><![CDATA[" ).append(checkNull(rs.getString("PIN"))).append( "]]></pin>\r\n" );
							valueXmlStringBuf.append("<promoter_name><![CDATA[" ).append(checkNull(rs.getString("PROMOTER_NAME"))).append( "]]></promoter_name>\r\n" );
							valueXmlStringBuf.append("<man_power><![CDATA[" ).append(rs.getInt("MAN_POWER")).append( "]]></man_power>\r\n" );
							valueXmlStringBuf.append("<gst_no><![CDATA[" ).append(checkNull(rs.getString("GST_NO"))).append( "]]></gst_no>\r\n" );
							valueXmlStringBuf.append("<image_id><![CDATA[" ).append(checkNull(rs.getString("IMAGE_ID"))).append( "]]></image_id>\r\n" );
							valueXmlStringBuf.append("<sp_name><![CDATA[" ).append(checkNull(rs.getString("SP_NAME"))).append( "]]></sp_name>\r\n" );
							//Added by sadique shaikh 04-03-2020 [unlisted customer event info realted changes]
							valueXmlStringBuf.append("<strg_event_info><![CDATA[" ).append(checkNull(rs.getString("strg_event_info"))).append( "]]></strg_event_info>\r\n" );
							//Added by kailash on 25-01-19 for chc related changes[end]
							valueXmlStringBuf.append("<wrkflw_aprv_level><![CDATA[" ).append(wrkflwAprvLevel).append( "]]></wrkflw_aprv_level>\r\n" );
							if (hoEmpCode != null && hoEmpCode.trim().length() > 0)
							{
								valueXmlStringBuf.append("<ho_exist><![CDATA[" ).append("Y").append( "]]></ho_exist>\r\n" );
							}
							else
							{
								valueXmlStringBuf.append("<ho_exist><![CDATA[" ).append("N").append( "]]></ho_exist>\r\n" );
							}
							valueXmlStringBuf.append("<reg_no><![CDATA[" ).append(regNo).append( "]]></reg_no>\r\n" );

							valueXmlStringBuf.append("</Detail1>\r\n");
							valueXmlStringBuf.append("</Header0>\r\n");
							valueXmlStringBuf.append("</group0>\r\n");
							valueXmlStringBuf.append("</DocumentRoot>\r\n");

							String xmlString = valueXmlStringBuf.toString();
							
							try
							{
								pstmt.setString(1, tranIDdb);
								int updStrgCnt = pstmt.executeUpdate();
								pstmt.clearParameters();

								System.out.println("updStrgCnt =["+updStrgCnt+"], tranIDdb =["+tranIDdb+"]");
								retString = genWorkflow.invokeWorkflow(connectionObject, tranIDdb, "", "strg_cust_add_aprv", xmlString, salesPers);
								if(retString != null && "success".equalsIgnoreCase(retString))
								{
									connectionObject.commit();
									//connectionObject=null;

								}
								else
								{
									connectionObject.rollback();
									//connectionObject=null;
								}
							}
							catch(Exception ee)
							{
								try
								{
									if(connectionObject != null)
									{
										connectionObject.rollback();
										//connectionObject.close();
									}
								}
								catch(Exception ex)
								{

								}
								ee.printStackTrace();
							}
							//retString = "";

						}
						//Added by Hariom S for connection close  -- 28-Dec-20 [Start]
						if(rs != null)
						{
							rs.close();
							rs = null;
						}
						if(pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						}
						//Added by Hariom S for connection close  -- 28-Dec-20 [End]

					}

				}
			}
		}	
		catch(Exception e)
		{

		}
		finally {

			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				/*if( connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
				}*/
			}
			catch(Exception e)
			{

			}

		}
		return tranIdList;
	}
	//Added By Nilesh for Instance Workflow on click on Confirm Button End :: 08-05-19

	//Added by mrunalini sinkar to insert plan on confirm if next paln date is present on23-08-2019---(start)
	public  HashSet<String> insertIntoPlan(String salesPers,String eventDate,String dcrID,String currDate,Connection conn) throws ITMException
	{
		PreparedStatement pstmt=null;
		ResultSet rs=null;

		PreparedStatement pstmtConf=null;
		ResultSet rsConf=null;

		PreparedStatement pstmtNonConf=null;
		ResultSet rsNonConf=null;

		PreparedStatement pstmtLocPlan=null;
		ResultSet rsLocPlan=null;

		PreparedStatement pstmtCustPlan=null;
		ResultSet rsCustPlan=null;

		PreparedStatement pstmtPlanId=null;
		ResultSet rsPlanId=null;

		PreparedStatement pstmtPlaceLin=null;
		ResultSet rsPlaceLin=null;

		PreparedStatement pstmtStan=null;
		ResultSet rsStan=null;

		PreparedStatement pstmtActType=null;
		ResultSet rsActType=null;

		PreparedStatement pstmtCustLin=null;
		ResultSet rsCustLin=null;

		PreparedStatement pstmtInsHdr=null;

		PreparedStatement pstmtInsPlace=null;

		PreparedStatement pstmtInsCust=null;

		PreparedStatement pstmtSPrsInst=null;

		HashSet<String> dateList = new HashSet<String>();
		String eventType="";
		try
		{
			InetAddress ownIP = InetAddress.getLocalHost();
			String chgTerm = ownIP.getHostAddress();

			SimpleDateFormat applFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());
			SimpleDateFormat dbFormat = new SimpleDateFormat(genericUtility.getDBDateFormat());


			//To get confirm plan count
			String confCntSql="SELECT COUNT(*) AS CONF_CNT FROM SPRS_PLAN WHERE PLAN_DATE=? AND SPRS_CODE__PLAN=? AND CONFIRM='Y' ";
			pstmtConf = conn.prepareStatement(confCntSql);

			//To get non EDIT  plan count
			String nonConfSql="SELECT COUNT(*) AS NON_CONF_CNT FROM SPRS_PLAN WHERE PLAN_DATE=? AND SPRS_CODE__PLAN=? AND (CASE WHEN CONFIRM IS NULL THEN 'N' ELSE CONFIRM END ) <> 'Y' ";
			pstmtNonConf = conn.prepareStatement(nonConfSql);

			//To get stan
			String stanSql="SELECT STAN_CODE FROM SPRS_ROUTE WHERE LOCALITY_CODE=? AND SPRS_CODE=? AND ROUTE_ID=?";
			pstmtStan= conn.prepareStatement(stanSql);

			//Plan is available then check activity type
			String actTypeSql="SELECT F.ACTIVITY_TYPE AS ACTIVITY_TYPE FROM FIELDACTIVITY F,SPRS_PLAN_HDR SPH WHERE F.ACTIVITY_CODE=SPH.PLAN_ACTIVITY AND SPH.SPRS_CODE__PLAN=? AND SPH.PLAN_DATE=?";
			pstmtActType= conn.prepareStatement(actTypeSql);

			//To check locality is present in plan or not 
			String locPlanSql="SELECT COUNT(*) AS LOC_CNT FROM SPRS_PLAN_HDR SPH ,SPRS_PLAN_PLACE SPP WHERE SPH.PLAN_ID=SPP.PLAN_ID " + 
					"AND SPH.PLAN_DATE=? AND SPH.SPRS_CODE__PLAN=? AND LOCALITY_CODE=? AND ROUTE_ID=? " ; 
			pstmtLocPlan = conn.prepareStatement(locPlanSql);

			//To check Customer Cnt
			String custPlanSql="SELECT COUNT(*) AS CUST_CNT FROM SPRS_PLAN_HDR SPH ,SPRS_PLAN_CUST SPP WHERE SPH.PLAN_ID=SPP.PLAN_ID " + 
					"AND SPH.PLAN_DATE=? AND SPH.SPRS_CODE__PLAN=? AND LOCALITY_CODE=? AND ROUTE_ID=? AND SPP.SC_CODE=?" ; 
			pstmtCustPlan = conn.prepareStatement(custPlanSql);

			//select plan id from sprs plan hdr table
			String planIdSql="SELECT PLAN_ID,PLAN_STATUS,PLAN_DESCR,EMP_CODE__APRV,CONF_DATE,CONFIRM FROM SPRS_PLAN_HDR WHERE PLAN_DATE=? AND SPRS_CODE__PLAN=?";
			pstmtPlanId = conn.prepareStatement(planIdSql);

			//select max line no from sprs_plan_place
			String planLinSql="SELECT MAX(LINE_NO) AS LINE_NO FROM SPRS_PLAN_PLACE WHERE PLAN_ID=?";
			pstmtPlaceLin= conn.prepareStatement(planLinSql);

			//select max line no from sprs_plan_cust
			String custLinSql="SELECT MAX(LINE_NO) AS LINE_NO FROM SPRS_PLAN_CUST WHERE PLAN_ID=?";
			pstmtCustLin= conn.prepareStatement(custLinSql);

			//insert intp sprs_plan_hdr
			String hdrInsSql="INSERT INTO SPRS_PLAN_HDR(CONFIRM,EMP_CODE__APRV,SPRS_CODE__WW,PLAN_STATUS,SPRS_CODE__FOR,CHG_DATE,CHG_TERM,SPRS_CODE__PLAN,PLAN_DATE,CHG_USER,PLAN_ACTIVITY,PLAN_ID,CONF_DATE,DATE_SUBMIT) "
					+ "VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?) " ; 
			pstmtInsHdr= conn.prepareStatement(hdrInsSql);

			//insert  data into sprs_plan_cust
			String planInsSql="INSERT INTO SPRS_PLAN_PLACE(VISITED_WITH_OTHER,VISITED_WITH_OTHER_NAME,WORK_STAN_CODE,ROUTE_ID,SPRS_CODE__WW,SALES_PERS__REQ,VISITED_WITH_PSR,VISITED_WITH_DESIG,PLAN_ID,LINE_NO,ORDER_OF_VISIT,PLAN_DESCR,TRAN_ID__REF,LOCALITY_CODE) "
					+ "VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?) " ; 
			pstmtInsPlace= conn.prepareStatement(planInsSql);

			//insert  data into sprs_plan_cust
			String custInsSql="INSERT INTO SPRS_PLAN_CUST(SC_TYPE,ROUTE_ID,SPRS_CODE__WW,CALL_OBJECTIVE,PLAN_ID,SC_CODE,LINE_NO,PLAN_TIME_END,REMARKS,MEETING_TYPE,PLAN_TIME_START,LOCALITY_CODE,DOC_ID) "
					+ "VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)";
			pstmtInsCust= conn.prepareStatement(custInsSql);

			//Insert into sprsPlan
			String sprsPlansql = " INSERT INTO SPRS_PLAN ( PLAN_ID , LINE__PLANBIFR ,PLAN_ID__PLANBIFR,TYPE__PLANBIFR , LOCALITY_CODE ,PLAN_TIME_START , PLAN_TIME_END ,SPRS_CODE__PLAN , SPRS_CODE__FOR , PLAN_STATUS , WORK_STAN_CODE , PLAN_DESCR , PLAN_DATE , CHG_DATE , CHG_USER , CHG_TERM , CONFIRM , EMP_CODE__APRV , PLAN_ACTIVITY , DATE_SUBMIT , CONF_DATE ,SPRS_CODE__WW,ROUTE_ID ) VALUES( ? , ? , ? , ? , ? , ? , ? , ? , ? , ? , ? , ? , ? , ? , ? , ? , ? , ? , ? , ? ,?,?,?)";
			pstmtSPrsInst=conn.prepareStatement(sprsPlansql);

			//To get activity because from strgMeet we gwt JW in case of joint work
			String actSql="SELECT ACTIVITY_CODE FROM SPRS_ACT_TRAN WHERE EVENT_DATE=? AND SALES_PERS=? AND DCR_ID=? ";
			pstmt=conn.prepareStatement(actSql);
			pstmt.setTimestamp(1,java.sql.Timestamp.valueOf(eventDate));
			pstmt.setString(2, salesPers);
			pstmt.setString(3, dcrID);
			rs=pstmt.executeQuery();
			if(rs.next())
			{
				eventType=checkNull(rs.getString("ACTIVITY_CODE"));
			}
			if (rs != null)
			{
				rs.close();
				rs = null;
			}
			if (pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			//To get customer from meet where next plan data is not null
			String sql="SELECT STRG_CODE,NEXT_PLAN_DATE,LOCALITY_CODE,ROUTE_ID,STRG_TYPE,SPRS_CODE__WW,EVENT_TYPE FROM STRG_MEET WHERE EVENT_DATE=? AND SALES_PERS=? AND DCR_ID=? AND NEXT_PLAN_DATE IS NOT NULL";
			pstmt=conn.prepareStatement(sql);
			pstmt.setTimestamp(1,java.sql.Timestamp.valueOf(eventDate));
			pstmt.setString(2, salesPers);
			pstmt.setString(3, dcrID);
			rs=pstmt.executeQuery();
			while(rs.next())
			{
				Date planDate=null;
				String showDate="";
				String nextPlanDate=checkNull(rs.getString("NEXT_PLAN_DATE"));
				String customerCode=checkNull(rs.getString("STRG_CODE"));
				String localityCode=checkNull(rs.getString("LOCALITY_CODE"));
				String routeId=checkNull(rs.getString("ROUTE_ID"));
				String strgType=checkNull(rs.getString("STRG_TYPE"));
				String sprsCodeWW=checkNull(rs.getString("SPRS_CODE__WW"));

				if(nextPlanDate!=null && nextPlanDate.trim().length()>0)
				{
					planDate=dbFormat.parse(nextPlanDate);
					showDate=applFormat.format(planDate);
				}


				if(nextPlanDate != null && nextPlanDate.trim().length() > 0) 
				{		
					//Checking confirm plan count
					int confCnt=0;
					pstmtConf.setTimestamp(1,java.sql.Timestamp.valueOf(nextPlanDate));
					pstmtConf.setString(2, salesPers);
					rsConf = pstmtConf.executeQuery();

					if(rsConf.next())
					{
						confCnt = rsConf.getInt("CONF_CNT");
					}
					if(rsConf != null)
					{
						rsConf.close();
						rsConf = null;
					}
					pstmtConf.clearParameters();
					System.out.println("confirm Plan cout is:["+confCnt+"]"); 

					if(confCnt > 0)// plan for date is already confirm
					{
						System.out.println("Plan is already confirm for this date["+nextPlanDate+"]");
					}
					else   
					{
						//Checking non confirm plan count

						int nonConfCnt=0;
						pstmtNonConf.setTimestamp(1,java.sql.Timestamp.valueOf(nextPlanDate));
						pstmtNonConf.setString(2, salesPers);
						rsNonConf = pstmtNonConf.executeQuery();
						if(rsNonConf.next())
						{
							nonConfCnt = rsNonConf.getInt("NON_CONF_CNT");
						}
						if(rsNonConf != null)
						{
							rsNonConf.close();
							rsNonConf = null;
						}
						pstmtNonConf.clearParameters();
						System.out.println("non Confirm Plan cout is:["+nonConfCnt+"]");

						//getting work_stan code
						String stanCode="";
						pstmtStan.setString(1, localityCode);
						if(sprsCodeWW!=null && sprsCodeWW.trim().length()>0)
						{
							pstmtStan.setString(2, sprsCodeWW);
						}
						else
						{
							pstmtStan.setString(2, salesPers);
						}

						pstmtStan.setString(3, routeId);


						rsStan = pstmtStan.executeQuery();
						if(rsStan.next())
						{
							stanCode=checkNull(rsStan.getString("STAN_CODE"));
						}
						if(rsStan != null)
						{
							rsStan.close();
							rsStan = null;
						}
						pstmtStan.clearParameters();

						if(nonConfCnt>0)
						{

							//To getting activity Type
							String actType="";
							pstmtActType.setString(1, salesPers);
							pstmtActType.setTimestamp(2,java.sql.Timestamp.valueOf(nextPlanDate));
							rsActType = pstmtActType.executeQuery();
							if(rsActType.next())
							{
								actType=checkNull(rsActType.getString("ACTIVITY_TYPE"));
							}
							if(rsActType != null)
							{
								rsActType.close();
								rsActType = null;
							}
							pstmtActType.clearParameters();

							if("FW".equalsIgnoreCase(actType))
							{
								// getting the plan id if customer is not presnt
								String planId="",planStatus="",planDescr="",empCodeaprv="",confirmDate="",confirm="";
								pstmtPlanId.setTimestamp(1,java.sql.Timestamp.valueOf(nextPlanDate));
								pstmtPlanId.setString(2, salesPers);
								rsPlanId = pstmtPlanId.executeQuery();
								if(rsPlanId.next())
								{
									planId=checkNull(rsPlanId.getString("PLAN_ID"));
									planStatus=checkNull(rsPlanId.getString("PLAN_STATUS"));
									planDescr=checkNull(rsPlanId.getString("PLAN_DESCR"));
									empCodeaprv=checkNull(rsPlanId.getString("EMP_CODE__APRV"));
									confirmDate = checkNull(rsPlanId.getString("CONF_DATE"));
									confirm = checkNull(rsPlanId.getString("CONFIRM"));


								}
								if(rsPlanId != null)
								{
									rsPlanId.close();
									rsPlanId = null;
								}
								pstmtPlanId.clearParameters();

								//Getting Place line number
								int placeMaxLine=0;
								pstmtPlaceLin.setString(1, planId);
								rsPlaceLin = pstmtPlaceLin.executeQuery();
								if(rsPlaceLin.next())
								{
									placeMaxLine=rsPlaceLin.getInt("LINE_NO");
								}
								if(rsPlaceLin != null)
								{
									rsPlaceLin.close();
									rsPlaceLin = null;
								}
								pstmtPlaceLin.clearParameters();

								placeMaxLine=placeMaxLine+1;

								//Getting customer line number
								int custMaxLine=0;
								pstmtCustLin.setString(1, planId);
								rsCustLin = pstmtCustLin.executeQuery();
								if(rsCustLin.next())
								{
									custMaxLine=rsCustLin.getInt("LINE_NO");
								}
								if(rsCustLin != null)
								{
									rsCustLin.close();
									rsCustLin = null;
								}
								pstmtCustLin.clearParameters();

								custMaxLine=custMaxLine+1;





								//Checking locality  count
								int locCnt=0;
								pstmtLocPlan.setTimestamp(1,java.sql.Timestamp.valueOf(nextPlanDate));
								pstmtLocPlan.setString(2, salesPers);
								pstmtLocPlan.setString(3, localityCode);
								pstmtLocPlan.setString(4, routeId);

								rsLocPlan = pstmtLocPlan.executeQuery();
								if(rsLocPlan.next())
								{
									locCnt=rsLocPlan.getInt("LOC_CNT");
								}
								if(rsLocPlan != null)
								{
									rsLocPlan.close();
									rsLocPlan = null;
								}
								pstmtLocPlan.clearParameters();
								System.out.println("non Confirm locality Plan cout is:["+locCnt+"]");

								if(locCnt>0) 
								{
									//Checking Customer  count

									int custCnt=0;
									pstmtCustPlan.setTimestamp(1,java.sql.Timestamp.valueOf(nextPlanDate));
									pstmtCustPlan.setString(2, salesPers);
									pstmtCustPlan.setString(3, localityCode);
									pstmtCustPlan.setString(4, routeId);
									pstmtCustPlan.setString(5, customerCode);
									rsCustPlan = pstmtCustPlan.executeQuery();
									if(rsCustPlan.next())
									{
										custCnt=rsCustPlan.getInt("CUST_CNT");
									}
									if(rsCustPlan != null)
									{
										rsCustPlan.close();
										rsCustPlan = null;
									}
									pstmtCustPlan.clearParameters();
									System.out.println("non Confirm customer Plan cout is:["+custCnt+"]");

									if(custCnt>0)
									{
										System.out.println("Plan is already Present for this date["+nextPlanDate+"] for this customer["+custCnt+"]");

									}//plan for date is entered and customer is  present
									else
									{

										//inserting into sprs plan customer
										pstmtInsCust.setString(1, strgType);
										pstmtInsCust.setString(2, routeId);
										pstmtInsCust.setString(3, sprsCodeWW);
										pstmtInsCust.setString(4, "");
										pstmtInsCust.setString(5, planId);
										pstmtInsCust.setString(6, customerCode);
										pstmtInsCust.setInt(7, custMaxLine);
										pstmtInsCust.setString(8,"");
										pstmtInsCust.setString(9, "");
										pstmtInsCust.setString(10, "");
										pstmtInsCust.setString(11, "");
										pstmtInsCust.setString(12, localityCode);
										pstmtInsCust.setString(13, "");
										int CustInsCnt = pstmtInsCust.executeUpdate();
										if(CustInsCnt>0)
										{
											System.out.println("Customer record inserted sucessfully");
											dateList.add(showDate);

										}
										pstmtInsCust.clearParameters();
									}//plan for date is entered and customer is not present  

								}//plan for date is entered and locality is present  
								else
								{

									//inserting into sprs plan place
									pstmtInsPlace.setString(1, "");
									pstmtInsPlace.setString(2, "");
									pstmtInsPlace.setString(3, stanCode);
									pstmtInsPlace.setString(4, routeId);
									pstmtInsPlace.setString(5, sprsCodeWW);
									pstmtInsPlace.setString(6, "");
									pstmtInsPlace.setString(7, "");
									pstmtInsPlace.setString(8, "");
									pstmtInsPlace.setString(9,planId);
									pstmtInsPlace.setInt(10, placeMaxLine);
									pstmtInsPlace.setInt(11, placeMaxLine);
									pstmtInsPlace.setString(12, "");
									pstmtInsPlace.setString(13, "");
									pstmtInsPlace.setString(14, localityCode);
									int planInsCnt = pstmtInsPlace.executeUpdate();
									if(planInsCnt>0)
									{
										System.out.println("sprs_plan_place record inserted sucessfully");
									}
									pstmtInsPlace.clearParameters();


									//inserting into sprs plan customer
									pstmtInsCust.setString(1, strgType);
									pstmtInsCust.setString(2, routeId);
									pstmtInsCust.setString(3, sprsCodeWW);
									pstmtInsCust.setString(4, "");
									pstmtInsCust.setString(5, planId);
									pstmtInsCust.setString(6, customerCode);
									pstmtInsCust.setInt(7, custMaxLine);
									pstmtInsCust.setString(8,"");
									pstmtInsCust.setString(9, "");
									pstmtInsCust.setString(10, "");
									pstmtInsCust.setString(11, "");
									pstmtInsCust.setString(12, localityCode);
									pstmtInsCust.setString(13, "");
									int CustInsCnt = pstmtInsCust.executeUpdate();
									if(CustInsCnt>0)
									{
										System.out.println("Customer record inserted sucessfully");
									}
									pstmtInsCust.clearParameters();

									//inserting into sprsplan
									String sprsPlanKey=getSprsPlanUniqueKey(conn);

									pstmtSPrsInst.setString(1, sprsPlanKey);
									pstmtSPrsInst.setInt(2, placeMaxLine);
									pstmtSPrsInst.setString(3, planId);
									pstmtSPrsInst.setString(4, "P");
									pstmtSPrsInst.setString(5, localityCode);
									pstmtSPrsInst.setString(6, "");
									pstmtSPrsInst.setString(7, "");
									pstmtSPrsInst.setString(8, salesPers);
									pstmtSPrsInst.setString(9,salesPers);
									pstmtSPrsInst.setString(10, planStatus);
									pstmtSPrsInst.setString(11, stanCode);
									pstmtSPrsInst.setString(12, planDescr);
									pstmtSPrsInst.setTimestamp(13,java.sql.Timestamp.valueOf(nextPlanDate));
									pstmtSPrsInst.setTimestamp(14,java.sql.Timestamp.valueOf(currDate));
									pstmtSPrsInst.setString(15,salesPers.trim());
									pstmtSPrsInst.setString(16,chgTerm.trim());
									pstmtSPrsInst.setString(17, confirm);
									pstmtSPrsInst.setString(18,empCodeaprv);
									pstmtSPrsInst.setString(19,eventType);
									pstmtSPrsInst.setTimestamp(20,java.sql.Timestamp.valueOf(currDate));

									if (confirmDate != null)
									{
										if (!confirmDate.equals(""))
										{
											pstmtSPrsInst.setTimestamp(21, java.sql.Timestamp.valueOf(confirmDate));
										} else
										{
											pstmtSPrsInst.setString(21, checkNullNew(confirmDate));
										}
									} else
									{
										pstmtSPrsInst.setString(21,checkNullNew(confirmDate));
									}
									pstmtSPrsInst.setString(22,sprsCodeWW);
									pstmtSPrsInst.setString(23,routeId);

									int sprsPlanCnt = pstmtSPrsInst.executeUpdate();
									if(sprsPlanCnt>0)
									{
										System.out.println("Sprs Plan record inserted sucessfully");
										dateList.add(showDate);

									}
									pstmtSPrsInst.clearParameters();

								}//plan for date is entered and locality is not present  

							}//activity type FW
						} //plan for date is entered but not confirm 
						else
						{

							String planNewId=generatePlanId(conn);
							//inserting into sprs plan hdr

							pstmtInsHdr.setString(1, "N");
							pstmtInsHdr.setString(2, "");
							pstmtInsHdr.setString(3, sprsCodeWW);
							pstmtInsHdr.setString(4, "P");
							pstmtInsHdr.setString(5, salesPers);
							pstmtInsHdr.setTimestamp(6,java.sql.Timestamp.valueOf(currDate));
							pstmtInsHdr.setString(7, chgTerm.trim());
							pstmtInsHdr.setString(8, salesPers);
							pstmtInsHdr.setTimestamp(9,java.sql.Timestamp.valueOf(nextPlanDate));
							pstmtInsHdr.setString(10, salesPers.trim());
							pstmtInsHdr.setString(11, eventType);
							pstmtInsHdr.setString(12, planNewId);
							pstmtInsHdr.setString(13,checkNullNew(""));
							pstmtInsHdr.setTimestamp(14,java.sql.Timestamp.valueOf(currDate));
							int hdrInsCnt = pstmtInsHdr.executeUpdate();
							if(hdrInsCnt>0)
							{
								System.out.println("sprs_plan_hdr record inserted sucessfully");
							}
							pstmtInsHdr.clearParameters();



							//inserting into sprs plan place
							pstmtInsPlace.setString(1, "");
							pstmtInsPlace.setString(2, "");
							pstmtInsPlace.setString(3, stanCode);
							pstmtInsPlace.setString(4, routeId);
							pstmtInsPlace.setString(5, sprsCodeWW);
							pstmtInsPlace.setString(6, "");
							pstmtInsPlace.setString(7, "");
							pstmtInsPlace.setString(8, "");
							pstmtInsPlace.setString(9,planNewId);
							pstmtInsPlace.setInt(10, 1);
							pstmtInsPlace.setInt(11, 1);
							pstmtInsPlace.setString(12, "");
							pstmtInsPlace.setString(13, "");
							pstmtInsPlace.setString(14, localityCode);
							int planInsCnt = pstmtInsPlace.executeUpdate();
							if(planInsCnt>0)
							{
								System.out.println("sprs_plan_place record inserted sucessfully");
							}
							pstmtInsPlace.clearParameters();


							//inserting into sprs plan customer
							pstmtInsCust.setString(1, strgType);
							pstmtInsCust.setString(2, routeId);
							pstmtInsCust.setString(3, sprsCodeWW);
							pstmtInsCust.setString(4, "");
							pstmtInsCust.setString(5, planNewId);
							pstmtInsCust.setString(6, customerCode);
							pstmtInsCust.setInt(7, 1);
							pstmtInsCust.setString(8,"");
							pstmtInsCust.setString(9, "");
							pstmtInsCust.setString(10, "");
							pstmtInsCust.setString(11, "");
							pstmtInsCust.setString(12, localityCode);
							pstmtInsCust.setString(13, "");
							int CustInsCnt = pstmtInsCust.executeUpdate();
							if(CustInsCnt>0)
							{
								System.out.println("sprs_plan_cust record inserted sucessfully");
							}
							pstmtInsCust.clearParameters();

							//inserting into sprs plan customer

							String sprsPlanKey=getSprsPlanUniqueKey(conn);

							pstmtSPrsInst.setString(1, sprsPlanKey);
							pstmtSPrsInst.setInt(2, 1);
							pstmtSPrsInst.setString(3, planNewId);
							pstmtSPrsInst.setString(4, "P");
							pstmtSPrsInst.setString(5, localityCode);
							pstmtSPrsInst.setString(6, "");
							pstmtSPrsInst.setString(7, "");
							pstmtSPrsInst.setString(8, salesPers);
							pstmtSPrsInst.setString(9,salesPers);
							pstmtSPrsInst.setString(10, "");
							pstmtSPrsInst.setString(11, stanCode);
							pstmtSPrsInst.setString(12, "");
							pstmtSPrsInst.setTimestamp(13,java.sql.Timestamp.valueOf(nextPlanDate));
							pstmtSPrsInst.setTimestamp(14,java.sql.Timestamp.valueOf(currDate));
							pstmtSPrsInst.setString(15,salesPers.trim());
							pstmtSPrsInst.setString(16,chgTerm.trim());
							pstmtSPrsInst.setString(17, "N");
							pstmtSPrsInst.setString(18,"");
							pstmtSPrsInst.setString(19,eventType);
							pstmtSPrsInst.setTimestamp(20,java.sql.Timestamp.valueOf(currDate));
							pstmtSPrsInst.setString(21,checkNullNew(""));
							pstmtSPrsInst.setString(22,sprsCodeWW);
							pstmtSPrsInst.setString(23,routeId);

							int sprsPlanCnt = pstmtSPrsInst.executeUpdate();
							if(sprsPlanCnt>0)
							{
								System.out.println("Sprs Plan record inserted sucessfully");
								dateList.add(showDate);

							}
							pstmtSPrsInst.clearParameters();
						}//plan for date is not entered  
					} // plan for date is Not confirm
				}

			}
			if(pstmtConf !=null)
			{
				pstmtConf.close();
				pstmtConf = null;
			}
			if(pstmtNonConf !=null)
			{
				pstmtNonConf.close();
				pstmtNonConf = null;
			}
			if(pstmtStan !=null)
			{
				pstmtStan.close();
				pstmtStan = null;
			}
			if(pstmtActType !=null)
			{
				pstmtActType.close();
				pstmtActType = null;
			}
			if(pstmtPlanId !=null)
			{
				pstmtPlanId.close();
				pstmtPlanId = null;
			}
			if(pstmtPlaceLin !=null)
			{
				pstmtPlaceLin.close();
				pstmtPlaceLin = null;
			}
			if(pstmtCustLin !=null)
			{
				pstmtCustLin.close();
				pstmtCustLin = null;
			}

			if(pstmtLocPlan !=null)
			{
				pstmtLocPlan.close();
				pstmtLocPlan = null;
			}
			if(pstmtCustPlan !=null)
			{
				pstmtCustPlan.close();
				pstmtCustPlan = null;
			}
			if(pstmtInsPlace !=null)
			{
				pstmtInsPlace.close();
				pstmtInsPlace = null;
			}
			if(pstmtInsCust !=null)
			{
				pstmtInsCust.close();
				pstmtInsCust = null;
			}
			if(pstmtSPrsInst !=null)
			{
				pstmtSPrsInst.close();
				pstmtSPrsInst = null;
			}
			if(pstmtInsHdr !=null)
			{
				pstmtInsHdr.close();
				pstmtInsHdr = null;
			}
			if (rs != null)
			{
				rs.close();
				rs = null;
			}
			if (pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}


		}
		catch(Exception e)
		{
			System.out.println( "Exception :getSummaryDetailDcrMeet():==>\n"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);


		}
		finally
		{
			try
			{

				if(pstmtConf !=null)
				{
					pstmtConf.close();
					pstmtConf = null;
				}
				if(pstmtNonConf !=null)
				{
					pstmtNonConf.close();
					pstmtNonConf = null;
				}
				if(pstmtStan !=null)
				{
					pstmtStan.close();
					pstmtStan = null;
				}
				if(pstmtActType !=null)
				{
					pstmtActType.close();
					pstmtActType = null;
				}
				if(pstmtPlanId !=null)
				{
					pstmtPlanId.close();
					pstmtPlanId = null;
				}
				if(pstmtPlaceLin !=null)
				{
					pstmtPlaceLin.close();
					pstmtPlaceLin = null;
				}
				if(pstmtCustLin !=null)
				{
					pstmtCustLin.close();
					pstmtCustLin = null;
				}

				if(pstmtLocPlan !=null)
				{
					pstmtLocPlan.close();
					pstmtLocPlan = null;
				}
				if(pstmtCustPlan !=null)
				{
					pstmtCustPlan.close();
					pstmtCustPlan = null;
				}
				if(pstmtInsPlace !=null)
				{
					pstmtInsPlace.close();
					pstmtInsPlace = null;
				}
				if(pstmtInsCust !=null)
				{
					pstmtInsCust.close();
					pstmtInsCust = null;
				}
				if(pstmtSPrsInst !=null)
				{
					pstmtSPrsInst.close();
					pstmtSPrsInst = null;
				}
				if(pstmtInsHdr !=null)
				{
					pstmtInsHdr.close();
					pstmtInsHdr = null;
				}
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch (Exception e) 
			{

			}
		}
		System.out.println("dateList : inserting plan is :==>\n["+dateList+"]");
		return dateList;
	}

	private String generatePlanId( Connection conn ) throws ITMException
	{
		String uniqueKey = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try
		{
			//System.out.println("RealTimeReportPos : Generating Primary Key ...........");

			String keyStringQuery = "SELECT KEY_STRING, TRAN_ID_COL, REF_SER FROM TRANSETUP WHERE TRAN_WINDOW = 'w_sprs_plan_bifur_gwt' ";
			pstmt = conn.prepareStatement(keyStringQuery);
			rs = pstmt.executeQuery();

			if(rs.next())
			{
				String keyString = rs.getString("KEY_STRING");
				String keyCol = rs.getString("TRAN_ID_COL");
				String tranSer = rs.getString("REF_SER");
				String xmlValues ="<?xml version=\"1.0\" encoding=\"utf-8\"?><Root>";
				xmlValues = xmlValues + "<Header></Header>";
				xmlValues = xmlValues + "<Detail1>";
				xmlValues = xmlValues +        "<plan_id></plan_id>";
				xmlValues = xmlValues + "</Detail1></Root>";
				TransIDGenerator tg = new TransIDGenerator(xmlValues, "BASE", CommonConstants.DB_NAME);
				uniqueKey = tg.generateTranSeqID(tranSer, keyCol, keyString, conn);
			}
			if (rs != null)
			{
				rs.close();
				rs = null;
			}
			if (pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		catch(Exception exp)
		{
			System.out.println("Exception : StrgMeetDcrWizConf :generateTransID :==>\n");
			throw new ITMException(exp);
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch (Exception e)
			{
				System.out.println("Exception : StrgMeetDcrWizConf :getUniqueKey :finally==>");
				throw new ITMException(e);
			}
		}
		System.out.println("Generated Primary Key :"+uniqueKey);
		return uniqueKey;
	}
	private String getSprsPlanUniqueKey(Connection con) throws ITMException
	{
		String uniqueKey = null;
		PreparedStatement pstmt = null;
		ResultSet rs=null;

		String objName = "sprs_plan";
		try
		{
			System.out.println("Generating Primary Key ...........");
			String keyStringQuery = "SELECT KEY_STRING, TRAN_ID_COL, REF_SER FROM TRANSETUP WHERE TRAN_WINDOW = 'w_" + objName + "' ";
			System.out.println("keyStringQuery [" + keyStringQuery + "]");
			pstmt = con.prepareStatement(keyStringQuery);
			rs = pstmt.executeQuery();


			if (rs.next())
			{
				String keyString = rs.getString("KEY_STRING");
				String keyCol = rs.getString("TRAN_ID_COL");
				String tranSer = rs.getString("REF_SER");
				TransIDGenerator tg = new TransIDGenerator("<Root></Root>", "BASE", CommonConstants.DB_NAME);
				uniqueKey = tg.generateTranSeqID(tranSer, keyCol, keyString, con);
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}

		} catch (ITMException itme)
		{
			System.out.println("Exception :XML2DBEJB :getUniqueKey :==>\n" + itme);
			throw itme;
		} catch (Exception e)
		{
			System.out.println("Exception :XML2DBEJB :getUniqueKey :==>\n" + e);
			uniqueKey = null;
			throw new ITMException(e);
		} finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			} catch (Exception e)
			{
				System.out.println("Exception :XML2DBEJB :getUniqueKey :finally==>");
				throw new ITMException(e);
			}
		}
		System.out.println("Generated Primary Key :" + uniqueKey);
		return uniqueKey;
	}
	private String checkNullNew(String input)
	{
		if (input == "")
		{
			input = null;
		}
		return input;
	}
	private String getModifiedErrorString(String errString, String modifiedString)
	{
		String xmlStr1 = "";
		String xmlStr2 = "";
		//String xmlStr3 = "";
		try
		{
			if(errString.indexOf("<trace>") != -1)
			{
				xmlStr1 = errString.substring(0,errString.indexOf("<trace>"));
				//xmlStr3 = errString.substring(errString.indexOf("<description>")+"<description>".length(),errString.indexOf("</description>"));
				xmlStr2 = errString.substring(errString.indexOf("</trace>")+"</trace>".length());

				modifiedString = "<trace>" + modifiedString + "</trace>";

				errString = xmlStr1 + modifiedString + xmlStr2;
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		//System.out.println("getModifiedErrorString >> errString ::"+errString);
		return errString;
	}
	//Added by mrunalini sinkar to insert plan on confirm if next paln date is present on23-08-2019---(end)

	private String updateIssueQty(String salesPers, String eventDate, String dcrId, Connection conn) throws ITMException
	{

		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String errString = "";
		E12GenericUtility genericUtility = null;
		String itemCode="";
		String scCode = "";
		int index = 0 ;
		HashMap []parentMap = null;
		int parentMapSize = 0 ;
		int issueQty  = 0 ;
		String unit = "";
		String siteCode = "";
		SampleStockInvtraceUpd updateStockEntry = new SampleStockInvtraceUpd();
		String xtraParams = "";
		String selQuerySprsItem = "" ;
		PreparedStatement pStmtSprsItem = null;
		ResultSet rsSprsItem = null;
		String updQuery = "" ;
		PreparedStatement pStmtUpd = null;
		PreparedStatement pstmtItem = null; //added by bhagyashri for open connection issue[01/06/2022]
		PreparedStatement pStmtSprsItemUpd = null;
		int result = 0;
		String sprsItemUpdQuery = "";

		try
		{
			genericUtility = new E12GenericUtility();
			Timestamp workDate = java.sql.Timestamp.valueOf(eventDate);
			xtraParams = "userId="+salesPers+"~~termId=SYSTEM";

			String siteCodeQuery = "SELECT EMPLOYEE.EMP_SITE SITE_CODE FROM  EMPLOYEE WHERE EMPLOYEE.EMP_CODE =?";
			PreparedStatement pstmtSiteCode = conn.prepareStatement(siteCodeQuery);
			pstmtSiteCode.setString(1,salesPers);
			ResultSet rsSiteCode = pstmtSiteCode.executeQuery();

			if (rsSiteCode.next())
			{
				siteCode = rsSiteCode.getString("site_code");
			}
			if (rsSiteCode != null)
			{
				rsSiteCode.close();
				rsSiteCode = null ;
			}
			if (pstmtSiteCode != null)
			{
				pstmtSiteCode.close();
				pstmtSiteCode = null ;
			}

			String selQuery =  "SELECT COUNT(*) CNT FROM  "+
					"(SELECT STRG_CODE , ITEM_CODE, QUANTITY AS QUANTITY FROM STRG_MEET_ITEMS "+
					"WHERE DCR_ID = ? ) MEET_ITEMS , ITEM "+
					"WHERE ITEM.ITEM_CODE = MEET_ITEMS.ITEM_CODE";
			pstmt = conn.prepareStatement(selQuery);
			pstmt.setString(1, dcrId);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				parentMapSize = rs.getInt("CNT");
			}
			if (rs != null )
			{
				rs.close();
				rs = null ;
			}
			if (pstmt != null )
			{
				pstmt.close();
				pstmt = null ;
			}

			if ( parentMapSize > 0 )
			{
				parentMap = new HashMap[parentMapSize] ;

				System.out.println("Inside dcrID===========>"+dcrId);
				String selectMeetItemSql = "SELECT SMI.ITEM_CODE AS ITEM_CODE,SMI.QUANTITY AS QUANTITY,STRG_CODE,UNIT FROM STRG_MEET_ITEMS SMI,ITEM ITEM " +
						"WHERE DCR_ID = ? AND SMI.ITEM_CODE = ITEM.ITEM_CODE ";
				//PreparedStatement pstmtItem =  conn.prepareStatement(selectMeetItemSql);//change by Bhagyashri to check dirty connection[01/06/2022]
				pstmtItem =  conn.prepareStatement(selectMeetItemSql);
				pstmtItem.setString(1, dcrId);

				selQuerySprsItem = " SELECT ITEM_CODE,CASE WHEN QUANTITY IS NULL THEN 0 ELSE QUANTITY END AS QUANTITY, "+
						" CASE WHEN ISSUE_QTY IS NULL THEN 0 ELSE ISSUE_QTY END AS ISSUE_QTY "+
						" FROM SPRS_ITEM WHERE SALES_PERS = ? AND ITEM_CODE = ? ";
				pStmtSprsItem = conn.prepareStatement(selQuerySprsItem);

				updQuery = "UPDATE SPRS_ITEM SET ISSUE_QTY = NVL(ISSUE_QTY,0) + ?, REPLY_STATUS = '0'  WHERE SALES_PERS = ?  AND ITEM_CODE = ? ";

				sprsItemUpdQuery = "UPDATE SPRS_ITEM SET STATUS = (CASE WHEN ((CASE WHEN QUANTITY IS NULL THEN 0 ELSE QUANTITY END) - (CASE WHEN ISSUE_QTY IS NULL THEN 0 ELSE ISSUE_QTY END)) > 0 THEN 'Y' ELSE 'N' END) WHERE SALES_PERS = ?  AND ITEM_CODE = ? " ;

				ResultSet selectResult=pstmtItem.executeQuery();
				while(selectResult.next())
				{
					int sprsItemIssQty = 0;
					int sprsItemQty  = 0 ;
					itemCode = "";
					String sprsItemCode = "" ;

					itemCode = selectResult.getString("ITEM_CODE");
					issueQty = selectResult.getInt("QUANTITY");
					scCode = selectResult.getString("STRG_CODE");
					unit = selectResult.getString("UNIT");


					pStmtSprsItem.setString(1,salesPers);
					pStmtSprsItem.setString(2,itemCode);					
					rsSprsItem = pStmtSprsItem.executeQuery();
					pStmtSprsItem.clearParameters();

					if (rsSprsItem.next())
					{
						sprsItemCode = rsSprsItem.getString("ITEM_CODE");
						sprsItemQty = rsSprsItem.getInt("QUANTITY");
						sprsItemIssQty = rsSprsItem.getInt("ISSUE_QTY");

						pStmtUpd = conn.prepareStatement(updQuery);

						pStmtUpd.setInt(1,issueQty);
						pStmtUpd.setString(2,salesPers);
						pStmtUpd.setString(3,itemCode);
						result = pStmtUpd.executeUpdate();
						System.out.println(result+" number of records are updated in sample item for issue quantity");
						//Added by Hariom S for connection close  -- 28-Dec-20 [Start]
						if(pStmtUpd != null)
						{
							pStmtUpd.close();
							pStmtUpd = null;
						}
						//Added by Hariom S for connection close  -- 28-Dec-20 [End]
						pStmtSprsItemUpd = conn.prepareStatement(sprsItemUpdQuery);

						pStmtSprsItemUpd.setString(1,salesPers);
						pStmtSprsItemUpd.setString(2,itemCode);
						result = pStmtSprsItemUpd.executeUpdate();
						System.out.println(result+" number of records are updated in sample item for status");
						//Added by Hariom S for connection close  -- 28-Dec-20 [Start]
						if(pStmtSprsItemUpd != null)
						{
							pStmtSprsItemUpd.close();
							pStmtSprsItemUpd = null;
						}
						//Added by Hariom S for connection close  -- 28-Dec-20 [End]

					}
					//Added by Hariom S for connection close  -- 28-Dec-20 [Start]
					if(rsSprsItem != null)
					{
						rsSprsItem.close();
						rsSprsItem = null;
					}
					
					//Added by Hariom S for connection close  -- 28-Dec-20 [Start]
					parentMap[index] = getDetailHashMap( itemCode, scCode, issueQty, unit, workDate); 
					System.out.println("parentMap[index]  =["+parentMap[index]+"]");
					index++;
				}
				if(pStmtSprsItem != null)
				{
					pStmtSprsItem.close();
					pStmtSprsItem = null;
				}
				if(selectResult!=null)
				{	
					selectResult.close();
					selectResult=null;
				}
				if(pstmtItem!=null)
				{	
					pstmtItem.close();
					pstmtItem = null;
				}

				if (parentMap.length > 0)
				{
					errString = updateStockEntry.updateSampleStock("w_confirm_dar","S-DISS",xtraParams , salesPers, salesPers, siteCode,siteCode,"","FRSH",parentMap,conn);
					System.out.println("updateIssueQty errString in if   =["+errString+"]\r\n");//Added by Aadesh on [29/09/2014]
					/*if ((errString != null && errString.trim().length() > 0) && (rptMode != null && rptMode.trim().equals(MOBILE_MODE)))
					{
						System.out.println("****error from updateSampleStock**** \n"+ errString);
						errString = getErrorMsg(errString);
					}*/
				}
			}	
		}
		catch(Exception e)
		{
			//e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(rs!=null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				//added by bhagyashri for open connection issue[01/06/2022][start]
				if(pstmtItem!=null)
				{
					pstmtItem.close();
					pstmtItem = null;
				}
				if(pStmtSprsItem!=null)
				{
					pStmtSprsItem.close();
					pStmtSprsItem = null;
				}
				if(pStmtUpd!=null)
				{
					pStmtUpd.close();
					pStmtUpd = null;
				}
				if(pStmtSprsItemUpd!=null)
				{
					pStmtSprsItemUpd.close();
					pStmtSprsItemUpd = null;
				}
				//added by bhagyashri for open connection issue[01/06/2022][end]
				
			}
			catch (Exception e)
			{
				throw new ITMException(e);
			}
		}

		System.out.println("errString is :--"+errString);
		return errString;
	}

	private HashMap getDetailHashMap( String itemCode, String scCode, int issQty, String unit , java.sql.Timestamp refDate) throws Exception
	{
		HashMap hMap = new HashMap();
		try
		{
			hMap.put("tran_id","");
			hMap.put("line_no"," ");
			hMap.put("item_code",itemCode);
			hMap.put("loc_code","FRSH");
			hMap.put("lot_no"," ");
			hMap.put("lot_sl"," ");
			hMap.put("unit",unit);
			hMap.put("qty_iss",(new Integer(issQty).doubleValue()));
			hMap.put("rate",new Double(0.00));
			hMap.put("sundry_code__ref",scCode);

			// Modified by Abhishek on [06/12/2011][to put work date into hash map][Start]

			System.out.println("Time Stamp Time before putting into hashmap	:"+refDate);
			hMap.put("ref_date",new java.sql.Date(refDate.getTime()));			
			System.out.println("Time after putting into hashmap	:"+new java.sql.Date(refDate.getTime()));	

			// Modified by Abhishek on [06/12/2011][to put work date into hash map][End]

		}
		catch (Exception ex)
		{
			throw ex;
		}			
		return hMap;
	}

	private String validConfirmReport(String workDate,String empCode,String actType,String isFortune,Connection con) throws Exception
	{
		String errString = "" ;
		PreparedStatement pstmt = null;
		ResultSet rs = null ;
		long datesCnt = 0;
		int maxallPrd = 0;
		String psrStatus = "";
		ITMDBAccessEJB ITMDBAccessEJB = null;
		String holString = "";

		try
		{

			workDate =  genericUtility.getValidDateTimeString( workDate , genericUtility.getDBDateFormat(), genericUtility.getApplDateFormat());

			ITMDBAccessEJB = new ITMDBAccessEJB();
			StrgMeetDCRWizard strgMeetWizrad = new StrgMeetDCRWizard();
			String parmValue =strgMeetWizrad.getSfaParmValue(empCode,"SEQUENTIAL_DAR_CONF",con);
			String delayParmValue =strgMeetWizrad.getSfaParmValue(empCode,"ALLW_DELY_ON_CONF",con);

			String salesSql ="SELECT ALLWD_DELAY_PRD,LOCK_STATUS FROM SALES_PERS WHERE SALES_PERS=?";

			pstmt = con.prepareStatement(salesSql);
			pstmt.setString(1,empCode);
			rs = pstmt.executeQuery();

			while(rs.next())
			{
				maxallPrd = rs.getInt("ALLWD_DELAY_PRD");
				psrStatus = checkNull(rs.getString("LOCK_STATUS"));
			}
			if (rs!= null)
			{
				rs.close();
				rs = null ;
			}
			if (pstmt!= null)
			{
				pstmt.close();
				pstmt = null ;
			}

			java.util.Date currDate = new java.util.Date();
			java.util.Date tempDate = null;
			Calendar cal = Calendar.getInstance();
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			cal.setTime( sdf.parse(workDate) );
			tempDate = cal.getTime();
			long diff = currDate.getTime() - tempDate.getTime();
			datesCnt = diff / (24 * 60 * 60 * 1000);


			holString = strgMeetWizrad.valHoliday( workDate, empCode, empCode, ITMDBAccessEJB, con,"");
			System.out.println("errString isHolidayWrkdt::["+holString+"]");
			if(holString != null && holString.length()>0)
			{
				System.out.println("Holiday!");
			}
			else
			{
				boolean blockConfirmation = isNoMAPForTheWorkDate(empCode,workDate,con);
				if (blockConfirmation)
				{		
					System.out.println("Error: Plan for the date is not exist or un-confirmed, you are not allowed to submit or confirm the report");
					errString = ITMDBAccessEJB.getErrorString("", "DARNOMAP",empCode);
					return errString;
				}
			}		

			ArrayList<String> holiList = new ArrayList<String>();
			String eventdate = genericUtility.getValidDateTimeString( workDate , genericUtility.getApplDateFormat() , genericUtility.getDBDateFormat());
			String holtblno = strgMeetWizrad.getHoltblno(empCode,eventdate, con);
			DateFormat applFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());
			Calendar calBef = Calendar.getInstance(); 
			calBef.add(Calendar.DAY_OF_MONTH,- maxallPrd );
			java.util.Date befoDate = calBef.getTime();
			String befoDateAppl = applFormat.format( befoDate );
			String befoDateDB= genericUtility.getValidDateTimeString( befoDateAppl , genericUtility.getApplDateFormat() , genericUtility.getDBDateFormat());

			Calendar calAft = Calendar.getInstance(); 
			java.util.Date aftDate = calAft.getTime();
			String aftDateAppl = applFormat.format( aftDate );
			String aftDateDB= genericUtility.getValidDateTimeString( aftDateAppl , genericUtility.getApplDateFormat() , genericUtility.getDBDateFormat());
			holiList = strgMeetWizrad.getHolidayList(befoDateDB,aftDateDB,holtblno,empCode,con);

			int holCnt = holiList.size();

			System.out.println("datesCnt::1::["+datesCnt+"]");
			datesCnt = datesCnt - holCnt - 1;

			System.out.println("datesCnt::2::["+datesCnt+"] alwdDelPrd:::["+maxallPrd+"]");

			String selUnconfReportQuery =" SELECT COUNT(*) UNCONFIRM_WORK_DATE_CNT FROM SPRS_ACT_TRAN " +
					" WHERE SALES_PERS =?  AND  (CASE WHEN CONFIRMED IS NULL THEN 'N' ELSE CONFIRMED END) <> ?   AND EVENT_DATE < ? ";
			pstmt = con.prepareStatement(selUnconfReportQuery);
			pstmt.setString(1,empCode);
			pstmt.setString(2,"Y");
			pstmt.setTimestamp(3, java.sql.Timestamp.valueOf(eventdate));
			rs = pstmt.executeQuery();

			int noOfUnconfirmedRpts = 0;
			if (rs.next())
			{
				noOfUnconfirmedRpts = rs.getInt("UNCONFIRM_WORK_DATE_CNT") ;
			}
			if (rs!= null)
			{
				rs.close();
				rs = null ;
			}
			if (pstmt!= null)
			{
				pstmt.close();
				pstmt = null ;
			}


			String sql = "SELECT CONFIRMED FROM SPRS_ACT_TRAN WHERE SALES_PERS = ? AND EVENT_DATE = ? ";
			pstmt = con.prepareStatement(sql);
			pstmt.setString(1,empCode);
			pstmt.setTimestamp(2, java.sql.Timestamp.valueOf(eventdate));
			rs = pstmt.executeQuery();
			boolean confirmStatus = false ;
			if (rs.next())
			{
				String confFlag = rs.getString("CONFIRMED");
				confirmStatus = confFlag != null && confFlag.trim().equalsIgnoreCase("Y") ? true : false;
			}
			if (rs!= null)
			{
				rs.close();
				rs = null ;
			}
			if (pstmt!= null)
			{
				pstmt.close();
				pstmt = null ;
			}
			if(isPsrAllow(psrStatus,datesCnt,maxallPrd,actType))
			{
				System.out.println("Valid PSR");
				if(reportCompFlag(con,workDate,empCode,actType,isFortune))
				{
					if (noOfUnconfirmedRpts > 0 && "Y".equalsIgnoreCase(parmValue))
					{
						System.out.println("Error:Please View Dates of reports to be confirmed to know your earlier pending reports and confirm the same before trying to confirm this report !!!");
						errString = ITMDBAccessEJB.getErrorString("", "UNCONFRPT",empCode);
					}
					else if (confirmStatus)
					{
						System.out.println("Error:Report for this date has been already confirmed!");
						errString = ITMDBAccessEJB.getErrorString("", "CONFIRMED",empCode);	
					}
					else if (isWorkRouteIdAndFromRouteIdBlank(workDate, empCode, con))
					{

						if (isTouringSeq == true)
						{
							System.out.println("Error:Touring sequence not selected properly, please delete and make new report");
							errString = ITMDBAccessEJB.getErrorString("", "INVDTOURSQ",empCode);
						}

						else	
						{
							System.out.println("Error:No record found!");
							errString = ITMDBAccessEJB.getErrorString("", "NULLDARDET",empCode);

						}
					}
					else if ( !actType.equalsIgnoreCase("FW") )
					{
						if( isDARExist(workDate, empCode, con) )
						{
							System.out.println("Error:Doctor/Stockist/Chemist should not exist , if activity type is not field work !");
							errString = ITMDBAccessEJB.getErrorString("", "INVALIDDAR",empCode);
						}
					}

				}
				else
				{
					if(isRussia.equalsIgnoreCase("Y"))
					{
						System.out.println("Error:To confirm a report you need to select either  Activity,Listed,Unlisted Doctors,Chemist or Stockist !!!");
						errString = ITMDBAccessEJB.getErrorString("", "UNCOMPRPT",empCode);
					}
					else
					{
						System.out.println("Error:To confirm a report you need to select either  Activity,Listed,Unlisted Doctors or Stockist !!!");
						errString = ITMDBAccessEJB.getErrorString("", "UNCOMPRPD",empCode);
					}
				}
			}
			else if("Y".equalsIgnoreCase(delayParmValue))
			{
				System.out.println("Invalid PSR");
				
				System.out.println("Error:You are not authorised to confirm report " + maxallPrd + " days after workdate Please get HO approval for confirming your report !!!");
				System.out.println("Inside Error of MAX Allowed :::");
				errString = ITMDBAccessEJB.getErrorString("","VTCNFALWPR",empCode);
			}

		}
		catch(Exception e)
		{
			e.printStackTrace();
			System.out.println("Error:Exception occured while getting confirmation status !!!");
			throw e ;
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}

			}
			catch (Exception e)
			{
				e.printStackTrace();
			}
		}
		

		return errString;
	}

	private boolean isPsrAllow(String psrVal,long datesCnt,int maxAllowprd,String actType)
	{
		boolean isAllow = false;

		if(actType.equalsIgnoreCase("FW")) 
		{
			if(datesCnt > maxAllowprd)
			{
				System.out.println("Count check");
				isAllow = true;
			}
		}
		if(isAllow)
		{
			System.out.println("iNSIDE ISALLOW------------------");
			if(psrVal != null)
			{
				System.out.println("iNSIDE ISALLOW------------------"+psrVal+"--");
				psrVal = psrVal.trim();
				if(psrVal.equals("0")  || psrVal.equals("1"))
				{
					System.out.println("is invalid User");
					isAllow =  false;
				}
				else
				{
					System.out.println("is valid User");
					isAllow =  true;
				}
			}
		}
		else
		{
			isAllow =  true;
		}

		return isAllow;
	}

	public boolean isNoMAPForTheWorkDate(String userId,String evtDate,Connection connectionObject)
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null ;
		String sql = "";

		String darWMap = "";
		String itemSer = "";

		boolean blockConfirmation = false;	
		GenericUtility genericUtility = GenericUtility.getInstance();
		try
		{
			sql = "SELECT ALLOW_DAR_WO_MAP AS DARWMAP,ITEM_SER FROM SALES_PERS WHERE SALES_PERS = ?";

			pstmt = connectionObject.prepareStatement(sql);
			pstmt.setString(1,userId);			

			rs = pstmt.executeQuery();

			if(rs.next())
			{
				darWMap = checkNull(rs.getString("DARWMAP"));
				itemSer = checkNull(rs.getString("ITEM_SER"));
			}

			if (rs != null)
			{
				rs.close();
				rs = null;
			}
			if (pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if (darWMap == null || darWMap.trim().length() == 0)
			{
				darWMap = "Y";
			}
			if (!darWMap.equalsIgnoreCase("Y"))
			{

				int cnt = 0;
				sql = "SELECT COUNT(*) AS COUNT FROM SPRS_PLAN_FROZEN WHERE SPRS_CODE__FOR = ? AND PLAN_DATE = ? AND CONFIRM ='Y'";

				pstmt = connectionObject.prepareStatement(sql);
				pstmt.setString(1,userId);			
				pstmt.setTimestamp( 2, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString(evtDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
				rs = pstmt.executeQuery();
				if (rs.next())
				{
					cnt = rs.getInt("COUNT");
					System.out.println("COUNT ::"+cnt);
				}

				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}

				if (cnt == 0)
				{				
					blockConfirmation = true;
				}
			}
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}

			}
			catch (Exception e)
			{
				e.printStackTrace();
			}
		}
		return blockConfirmation;
	}

	private boolean reportCompFlag (Connection con,String workDate,String salesCode,String actType,String isFortune) 
	{
		System.out.println("reportCompFlag ....");

		PreparedStatement pStmt = null;
		PreparedStatement pStmt1 = null;
		PreparedStatement pStmt2 = null;
		PreparedStatement pStmt3 = null;
		PreparedStatement pStmt4 = null;
		ResultSet rs = null;
		ResultSet rs1 = null;
		ResultSet rs2 = null;
		ResultSet rs3 = null;
		ResultSet rs4 = null;
		String sqlDoctorVisit  = "";
		String sqlChemistVisit = "";
		String sqlStockistVisit = "";
		String sqlOtherVisit="";
		String sqlTravelDet = "";
		String activityDescr = "";

		boolean reportFlag = false;

		try
		{

			String eventdate = genericUtility.getValidDateTimeString( workDate , genericUtility.getApplDateFormat() , genericUtility.getDBDateFormat());

			sqlTravelDet =" SELECT DTD.ACTIVITY_CODE,FA.ACTIVITY_TYPE FROM SPRS_TRAVEL DTD, "
					+" FIELDACTIVITY FA WHERE DTD.SALES_PERS=?" 
					+"	AND DTD.TRAVEL_DATE=?"
					+"	AND DTD.ACTIVITY_CODE= FA.ACTIVITY_CODE";
			pStmt = con.prepareStatement(sqlTravelDet);
			pStmt.setString(1,salesCode);
			pStmt.setTimestamp(2,java.sql.Timestamp.valueOf( eventdate ));
			rs= pStmt.executeQuery();

			String activityCode = "";
			while(rs.next())
			{
				activityDescr =rs.getString( "ACTIVITY_TYPE" );
				activityCode =rs.getString( "ACTIVITY_CODE" );
			}
			if (rs!=null)
			{
				rs.close();
				rs = null;
			}

			if (pStmt!=null)
			{
				pStmt.close();
				pStmt = null;
			}
			if("Y".equalsIgnoreCase(isFortune))
			{
				activityDescr=isFortune;
			}

			if( activityDescr.equalsIgnoreCase("FW") && ! "CA".equalsIgnoreCase( activityCode ) )
			{
				sqlDoctorVisit = " SELECT COUNT(*) FROM STRG_MEET WHERE SALES_PERS=?" 
						+" AND EVENT_DATE=? AND STRG_TYPE IN (SELECT TYPE FROM STRG_CUST_TYPE WHERE DCR_GROUP = 'D')";
				pStmt1 = con.prepareStatement(sqlDoctorVisit);
				pStmt1.setString(1,salesCode);
				pStmt1.setTimestamp(2,java.sql.Timestamp.valueOf( eventdate ));
				rs1= pStmt1.executeQuery();
				while(rs1.next())
				{
					if(rs1.getInt(1) > 0)
					{											
						reportFlag = true;
					}
				}
				if (rs1!=null)
				{
					rs1.close();
					rs1 = null;
				}

				if (pStmt1!=null)
				{
					pStmt1.close();
					pStmt1 = null;
				}

				if (!reportFlag)
				{
					if(isRussia.length()!=0 && isRussia.equalsIgnoreCase("Y"))
					{
						sqlChemistVisit =" SELECT COUNT(*) FROM STRG_MEET WHERE SALES_PERS=?"
								+" AND EVENT_DATE=? AND STRG_TYPE IN (SELECT TYPE FROM STRG_CUST_TYPE WHERE DCR_GROUP = 'R')";
						pStmt2 = con.prepareStatement(sqlChemistVisit);
						pStmt2.setString(1,salesCode);
						pStmt2.setTimestamp(2,java.sql.Timestamp.valueOf( eventdate ));
						rs2 = pStmt2.executeQuery();

						while(rs2.next())
						{
							if(rs2.getInt(1) > 0)
							{                                           
								reportFlag = true;
							}
						}
						if (rs2 != null)
						{
							rs2.close();
							rs2 = null;
						}

						if (pStmt2 != null)
						{
							pStmt2.close();
							pStmt2 = null;
						}
					}
					else if(!isRussia.equalsIgnoreCase("Y"))
					{
						sqlChemistVisit =" SELECT COUNT(*) FROM STRG_MEET WHERE SALES_PERS=?" 
								+" AND EVENT_DATE=? AND STRG_TYPE IN (SELECT TYPE FROM STRG_CUST_TYPE WHERE DCR_GROUP = 'C') ";
						pStmt2 = con.prepareStatement(sqlChemistVisit);
						pStmt2.setString(1,salesCode);
						pStmt2.setTimestamp(2,java.sql.Timestamp.valueOf( eventdate ));
						rs2 = pStmt2.executeQuery();

						while(rs2.next())
						{
							if(rs2.getInt(1) > 0)
							{											
								reportFlag = true;
							}
						}
						if (rs2 != null)
						{
							rs2.close();
							rs2 = null;
						}

						if (pStmt2 != null)
						{
							pStmt2.close();
							pStmt2 = null;
						}
					}
				}

				if (!reportFlag)
				{
					sqlStockistVisit =" SELECT COUNT(*) FROM STRG_MEET WHERE SALES_PERS=?" 
							+" AND EVENT_DATE=? AND STRG_TYPE IN (SELECT TYPE FROM STRG_CUST_TYPE WHERE DCR_GROUP = 'S') ";

					pStmt3 = con.prepareStatement(sqlStockistVisit);
					pStmt3.setString(1,salesCode);
					pStmt3.setTimestamp(2,java.sql.Timestamp.valueOf( eventdate ));
					rs3 = pStmt3.executeQuery();

					while(rs3.next())
					{
						if(rs3.getInt(1) > 0)
						{											
							reportFlag = true;
						}
					}
					if (rs3 != null)
					{
						rs3.close();
						rs3 = null;
					}

					if (pStmt3 != null)
					{
						pStmt3.close();
						pStmt3 = null;
					}
				}
				// Added by Hariom for other dcr group -- 10-Feb-2021 [ Start]
				if (!reportFlag)
				{
					sqlOtherVisit =" SELECT COUNT(*) FROM STRG_MEET WHERE SALES_PERS=?" 
							+" AND EVENT_DATE=? AND STRG_TYPE IN (SELECT TYPE FROM STRG_CUST_TYPE WHERE DCR_GROUP = 'O') ";

					pStmt4 = con.prepareStatement(sqlOtherVisit);
					pStmt4.setString(1,salesCode);
					pStmt4.setTimestamp(2,java.sql.Timestamp.valueOf( eventdate ));
					rs4 = pStmt4.executeQuery();

					while(rs4.next())
					{
						if(rs4.getInt(1) > 0)
						{											
							reportFlag = true;
						}
					}
					if (rs4 != null)
					{
						rs4.close();
						rs4 = null;
					}

					if (pStmt4 != null)
					{
						pStmt4.close();
						pStmt4 = null;
					}
				}
				// Added by Hariom for other dcr group -- 10-Feb-2021 [ End]
				
			}
			else if (activityDescr == null || activityDescr.trim().equalsIgnoreCase(""))
			{
				reportFlag = false;
			}
			else
			{
				reportFlag= true;
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if (rs!=null)
				{
					rs.close();
					rs = null;
				}
				if (pStmt!=null)
				{
					pStmt.close();
					pStmt = null;
				}
				if (rs1!=null)
				{
					rs1.close();
					rs1 = null;
				}
				if (pStmt1!=null)
				{
					pStmt1.close();
					pStmt1 = null;
				}
				if (rs2!=null)
				{
					rs2.close();
					rs2 = null;
				}
				if (pStmt2!=null)
				{
					pStmt2.close();
					pStmt2 = null;
				}
				if (rs3!=null)
				{
					rs3.close();
					rs3 = null;
				}
				if (pStmt3!=null)
				{
					pStmt3.close();
					pStmt3 = null;
				}
			}
			catch (Exception e)
			{
			}
		}

		return reportFlag;
	}

	public boolean isWorkRouteIdAndFromRouteIdBlank(String workDate,String empCode, Connection con) throws  RemoteException,ITMException
	{
		boolean isBlank=false;
		int workRouteId ;
		int fromRouteId ;

		PreparedStatement pstmt = null;
		ResultSet rs = null;

		int count = 0;
		int workRouteIdTourSeq = 0;

		try
		{
			String eventdate = genericUtility.getValidDateTimeString( workDate , genericUtility.getApplDateFormat() , genericUtility.getDBDateFormat());

			//String sql = "SELECT ROUTE_ID,ROUTE_ID_FROM FROM SPRS_TRAVEL WHERE SALES_PERS = ? AND TRAVEL_DATE = ? ORDER BY LINE_NO";
			String sql = "SELECT ROUTE_ID,ROUTE_ID_FROM FROM SPRS_TRAVEL WHERE SALES_PERS = ? AND TRAVEL_DATE = ? ORDER BY ORDER_OF_VISIT";

			pstmt = con.prepareStatement(sql);
			pstmt.setString(1,empCode);
			pstmt.setTimestamp(2, java.sql.Timestamp.valueOf( eventdate ));
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				System.out.println("inside while::::::");
				workRouteId = rs.getInt("ROUTE_ID");
				fromRouteId = rs.getInt("ROUTE_ID_FROM");

				if( workRouteId == 0 || (String.valueOf(workRouteId).trim().length() <= 0) )
				{
					isBlank = true;
					break;	
				}
				else if( (fromRouteId == 0) || (String.valueOf(fromRouteId).trim().length() <= 0) )
				{
					isBlank = true;
					break;	
				}

				else
				{
					count = count + 1;

					System.out.println("Tour Count:::["+count+"]");
					System.out.println("workRouteIdTourSeq :::["+workRouteIdTourSeq+"]");
					System.out.println("fromRouteId :::["+fromRouteId+"]");
					System.out.println("workRouteId :::["+workRouteId+"]");
					System.out.println("isTouringSeq :::["+isTouringSeq+"]");

					if( count > 1 && fromRouteId != workRouteIdTourSeq )
					{						
						isTouringSeq = true;
						isBlank = true;
						break;					
					}
					workRouteIdTourSeq = workRouteId;
				}
			}	
			System.out.println("isWorkRouteIdAndFromRouteIdBlank : "+isBlank);
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
		finally
		{ 
			try
			{
				if(rs != null)
				{
					rs.close();
					rs=null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt=null;
				}
			}
			catch (Exception e)
			{
				e.printStackTrace();
			}
		}
		return isBlank;
	}

	public boolean isDARExist(String workDate, String empCode, Connection con) throws  RemoteException,ITMException
	{
		System.out.println("inside isDARExist....");

		boolean isDARExist = false;

		try
		{
			isDARExist = isRecordExist( workDate, empCode, con, "D");
			if (!isDARExist)
			{
				isDARExist = isRecordExist( workDate, empCode, con, "S");
			}
			if (!isDARExist)
			{
				isDARExist = isRecordExist( workDate, empCode, con, "C");		
			}
			System.out.println("isDARExist : "+isDARExist);
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
		return isDARExist;
	}

	public boolean isRecordExist(String workDate,String empCode, Connection con, String custType) throws  RemoteException,ITMException
	{
		System.out.println("inside isRecordExist....");

		boolean  isRecordExist = false;
		int cnt = 0; 

		PreparedStatement pstmt = null;
		ResultSet rs = null;

		try
		{
			String eventdate = genericUtility.getValidDateTimeString( workDate , genericUtility.getApplDateFormat() , genericUtility.getDBDateFormat());
			String sql = "SELECT COUNT(*) AS CNT FROM STRG_MEET WHERE SALES_PERS = ? AND EVENT_DATE = ? AND STRG_TYPE IN (SELECT TYPE FROM STRG_CUST_TYPE WHERE DCR_GROUP = ?) ";
			pstmt = con.prepareStatement(sql);
			pstmt.setString(1,empCode);
			pstmt.setTimestamp(2, java.sql.Timestamp.valueOf( eventdate ));
			pstmt.setString(3,custType);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				cnt = rs.getInt("CNT");
			}
			if( cnt > 0 )
			{
				isRecordExist = true;
			}		
		}
		catch (Exception e)
		{
			e.printStackTrace();

		}
		finally
		{ 
			try
			{
				if(rs != null)
				{
					rs.close();
					rs=null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt=null;
				}
			}
			catch (Exception e)
			{
				e.printStackTrace();
			}
		}
		return isRecordExist;
	}

	/*Added by sadique shaikh 02-01-2020 [creating user task After Confirm] Start*/
	private void createUserTasks( String dcrId,String objName, String xtraParams, Connection conn ) throws ITMException
	{
		PreparedStatement pstm = null;
		try
		{
			/*SimpleDateFormat sdfDBDateFormat = new SimpleDateFormat( genericUtility.getApplDateFormat() );
			Date currDate = new Date();
			String currDateStr = sdfDBDateFormat.format(currDate);*/

			String chgUser = "", chgTerm ="";
			chgUser = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" );
			InetAddress ownIP = InetAddress.getLocalHost();
			chgTerm = ownIP.getHostAddress();

			String taskDomain = "SFA"; //SFA

			HashMap<String,String> typeCodeMap  = getTaskDetails( taskDomain, conn ); 
			String taskType = typeCodeMap.get("TASK_TYPE");
			String taskCode = typeCodeMap.get("TASK_CODE");
			/*Added by sadique shaikh 07-01-2020[getting ref-id]*/
			String refSer = getRefSer( objName, conn );

			String taskStatus = "P"; //Pending
			String taskDescr = "", assignedTo = "";
			/*Change by sadique shaikh 07-01-2020[to store ref-ser and ref-id in user_task table]*/
			HashMap<String, ArrayList<String>> coachingTaskMap = getCoachingTask( dcrId ,conn );

			DBAccessEJB dbAccessEJB = new DBAccessEJB();
			String sql = "INSERT INTO USER_TASKS(TRAN_ID,TRAN_DATE,USER_ID,TASK_DESCR,TASK_TYPE,TASK_DOMAIN,TASK_CODE,USER_ID__ASSIGNED,EXP_COMPL_DATE,CURR_STATUS,STATUS_DATE,COMPL_REMARKS,ADD_DATE,ADD_USER,ADD_TERM,CHG_DATE,CHG_USER,CHG_TERM,REF_SER,REF_ID) "
					+ "VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
			pstm = conn.prepareStatement(sql);
			
			int taskCnt = 0;
			//StringBuffer xmlString = null;
			for ( Map.Entry<String, ArrayList<String>> coachingTaskEntry : coachingTaskMap.entrySet() ) 
			{
				/*Added by sadique shaikh 07-01-2020[to store tranid as ref-id in user_task table]*/
				String tranId = coachingTaskEntry.getKey();
				ArrayList<String> dataList = coachingTaskEntry.getValue();
				
				String result = dataList.get( 0 );
				JSONParser parser = new JSONParser(); 
				org.json.simple.JSONObject userTaskJson = null;
				try 
				{
					userTaskJson = (org.json.simple.JSONObject) parser.parse( result );
				}
				catch (Exception e) 
				{
					e.printStackTrace();
					continue;
				}

				System.out.println( "json: ["+ userTaskJson +"]" );

				taskDescr = (String) userTaskJson.get( "task_descr" ); //Prasad
				if( taskDescr != null && taskDescr.trim().length() > 0 )
				{
					assignedTo = checkNull( ( (String) userTaskJson.get( "assigned_to" ) ) ); //Prasad
					if ( assignedTo.length() == 0 )
					{
						assignedTo = checkNull( dataList.get( 1 ) );
					}
					if ( assignedTo.length() == 0 )
					{
						continue;
					}
					/*xmlString = new StringBuffer();
					xmlString.append("<Root>\r\n");
					xmlString.append("<Header0>\r\n");
					xmlString.append("<objName><![CDATA[user_tasks]]></objName>\r\n");
					xmlString.append("<pageContext><![CDATA[1]]></pageContext>\r\n");
					xmlString.append("<editFlag><![CDATA[A]]></editFlag>\r\n");
					xmlString.append("<focusedColumn><![CDATA[]]></focusedColumn>\r\n");
					xmlString.append("<action><![CDATA[SAVE]]></action>\r\n");
					xmlString.append("<elementName><![CDATA[]]></elementName>\r\n");
					xmlString.append("<taxKeyValue><![CDATA[]]></taxKeyValue>\r\n");
					xmlString.append("<taxInFocus><![CDATA[false]]></taxInFocus>\r\n");
					xmlString.append("<objContext><![CDATA[1]]></objContext>\r\n");
					xmlString.append("<forcedSave><![CDATA[true]]></forcedSave>\r\n");
					xmlString.append("<keyValue><![CDATA[1]]></keyValue>\r\n");
					xmlString.append("<pkValues><![CDATA[]]></pkValues>\r\n");
					xmlString.append("<description>Header0 members</description>\r\n");
					xmlString.append("</Header0>\r\n");
					xmlString.append("<description>Header0 members</description>\r\n");
					xmlString.append("<Detail1 objContext=\"1\" objName=\"user_tasks\" domID=\"1\" dbID=\"\" selected=\"Y\">\r\n");
					xmlString.append("<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\" />\r\n");
					xmlString.append("<tran_id>").append("<![CDATA[]]>").append("</tran_id>\r\n");
					xmlString.append("<tran_date>").append("<![CDATA[").append( currDateStr ).append("]]>").append("</tran_date>\r\n");
					xmlString.append("<user_id>").append("<![CDATA[").append( chgUser ).append("]]>").append("</user_id>\r\n");
					xmlString.append("<task_descr>").append("<![CDATA[").append( taskDescr ).append("]]>").append("</task_descr>\r\n");
					xmlString.append("<task_type>").append("<![CDATA[").append( taskType ).append("]]>").append("</task_type>\r\n");
					xmlString.append("<task_domain>").append("<![CDATA[").append( taskDomain ).append("]]>").append("</task_domain>\r\n");
					xmlString.append("<task_code>").append("<![CDATA[").append( taskCode ).append("]]>").append("</task_code>\r\n");
					xmlString.append("<user_id__assigned>").append("<![CDATA[").append( assignedTo ).append("]]>").append("</user_id__assigned>\r\n");
					xmlString.append("<exp_compl_date>").append("<![CDATA[]]>").append("</exp_compl_date>\r\n");
					xmlString.append("<curr_status>").append("<![CDATA[").append( taskStatus ).append("]]>").append("</curr_status>\r\n");
					xmlString.append("<status_date>").append("<![CDATA[").append( currDateStr ).append("]]>").append("</status_date>\r\n");
					xmlString.append("<compl_remarks>").append("<![CDATA[]]>").append("</compl_remarks>\r\n");
					//Commented by sadique shaikh 07-01-2020 Start
					//xmlString.append("<add_date>").append("<![CDATA[").append( currDateStr ).append("]]>").append("</add_date>\r\n");
					//xmlString.append("<add_user>").append("<![CDATA[").append( chgUser ).append("]]>").append("</add_user>\r\n");
					//xmlString.append("<add_term>").append("<![CDATA[").append( chgTerm ).append("]]>").append("</add_term>\r\n");					
					//Commented by sadique shaikh 07-01-2020 End
					//Added by sadique shaikh 07-01-2020[to store ref-ser and ref-id in user_task table] Start
					xmlString.append("<ref_ser>").append("<![CDATA[").append( refSer ).append("]]>").append("</ref_ser>\r\n");
					xmlString.append("<ref_id>").append("<![CDATA[").append( tranId ).append("]]>").append("</ref_id>\r\n");
					//Added by sadique shaikh 07-01-2020[to store ref-ser and ref-id in user_task table] End
					xmlString.append("</Detail1>\r\n");
					xmlString.append("</Root>\r\n");
					System.out.println( "xmlString.toString() createUserTasks : ["+ xmlString.toString() +"]" );

					String responseStr = callProcessRequest( xmlString.toString(), conn );
					System.out.println( "callProcessRequest :: responseStr :: ["+ responseStr +"]" );*/
					String tranID = dbAccessEJB.generateTranId( "W_USER_TASKS", getUserInfo().getSiteCode(), getUserInfo().getLoginCode(), conn );
					System.out.println( ":: tranID :: ["+ tranID +"]" );
					
					pstm.setString( 1, tranID );
					pstm.setTimestamp( 2, new java.sql.Timestamp(System.currentTimeMillis()) );
					pstm.setString( 3, chgUser );
					pstm.setString( 4, taskDescr );
					pstm.setString( 5, taskType );
					pstm.setString( 6, taskDomain );
					pstm.setString( 7, taskCode );
					pstm.setString( 8, assignedTo );
					pstm.setString( 9, "" );
					pstm.setString( 10, taskStatus );
					pstm.setTimestamp( 11, new java.sql.Timestamp(System.currentTimeMillis()) );
					pstm.setString( 12, "" );
					pstm.setTimestamp( 13, new java.sql.Timestamp(System.currentTimeMillis()) );
					pstm.setString( 14, chgUser );
					pstm.setString( 15, chgTerm );
					pstm.setTimestamp( 16, new java.sql.Timestamp(System.currentTimeMillis()) );
					pstm.setString( 17, chgUser );
					pstm.setString( 18, chgTerm );
					pstm.setString( 19, refSer );
					pstm.setString( 20, tranId );

					pstm.addBatch();
					pstm.clearParameters();
					taskCnt++;
				}
			}
			if( taskCnt > 0 )
			{
				int insertCnt[] = pstm.executeBatch();
				System.out.println( "no of record inserted : ["+ insertCnt.length +"]" );
			}
			pstm.clearBatch();
		}
		catch(SQLException e)
		{
			System.out.println( "SQLException :: createUserTasks : ["+ e.getMessage() +"]" );
		}
		catch(Exception e)
		{
			System.out.println( "Exception :: createUserTasks : ["+ e.getMessage() +"]" );
			throw new ITMException(e);
		}
		finally
		{
			try 
			{
				if ( pstm != null )
				{
					pstm.close();
					pstm = null;
				}
			}
			catch (SQLException e) 
			{
				e.printStackTrace();
			}
		}
	}

	private HashMap<String,String> getTaskDetails(String taskDomain,Connection connection)
	{
		HashMap<String,String> taskCodeArr = new HashMap<String,String>();
		PreparedStatement pstm = null;
		ResultSet rs = null;
		try
		{
			String sql  = "SELECT TASK_TYPE,TASK_CODE FROM TASK WHERE TASK_DOMAIN = ?";
			pstm = connection.prepareStatement(sql);
			pstm.setString(1, taskDomain );
			rs = pstm.executeQuery();
			while( rs.next() )
			{
				taskCodeArr.put("TASK_TYPE", checkNull(rs.getString("TASK_TYPE")));
				taskCodeArr.put("TASK_CODE", checkNull(rs.getString("TASK_CODE")));
			}

			if( rs !=null )
			{
				rs.close();
				rs = null;
			}
			if( pstm !=null )
			{
				pstm.close();
				pstm = null;
			}
		}
		catch(Exception e)
		{
			System.out.println("StrgMeetDCRWizConf.getTaskDetails()[ "+e.getMessage()+" ]");
		}
		finally 
		{
			try 
			{
				if( rs !=null )
				{
					rs.close();
					rs = null;
				}
				if( pstm != null) 
				{
					pstm.close();
					pstm = null;
				}
			}
			catch (SQLException e)
			{
				e.printStackTrace();
			}
		}
		return taskCodeArr;
	}

	private HashMap<String, ArrayList<String>> getCoachingTask(String taskTranId,Connection connection)
	{
		PreparedStatement pstm = null;
		ResultSet rs = null;
		/*Change by sadique shaikh 07-01-2020 [Use Hashmap to store result,tranid ]*/
		HashMap<String, ArrayList<String>> taskJsonTranIdMap = new HashMap<String, ArrayList<String>>();
		try
		{
			/*Change by sadique shaikh 07-01-2020 [getting tranid ]*/
			String sql  = " SELECT SC.TRAN_ID, SC.RESULT, S_M.SPRS_CODE__WW " + 
					" FROM SPRS_COACHING SC, SURVEY_MASTER SM, STRG_MEET S_M " + 
					" WHERE SC.SURVEY_CODE = SM.SURVEY_CODE " + 
					" AND S_M.TRAN_ID = SC.TRAN_ID " + 
					" AND SM.RESULT_TYPE = 'A' AND SC.DCR_ID = ? ";
			pstm = connection.prepareStatement(sql);
			pstm.setString(1, taskTranId );
			rs = pstm.executeQuery();
			while( rs.next() )
			{
				ArrayList<String> dataList = new ArrayList<String>();
				dataList.add( checkNull( rs.getString("RESULT") ) );
				dataList.add( checkNull( rs.getString("SPRS_CODE__WW") ) );
				/*Change by sadique shaikh 07-01-2020 [Use Hashmap to store result,tranid[tranid = key,result = value] ]*/
				taskJsonTranIdMap.put( rs.getString("TRAN_ID"), dataList );
			}
			if( rs !=null )
			{
				rs.close();
				rs = null;
			}
			if( pstm != null) 
			{
				pstm.close();
				pstm = null;
			}
		}
		catch(Exception e)
		{
			System.out.println("StrgMeetDCRWizConf.getCoachingTask()[ "+e.getMessage()+" ]");
		}
		finally 
		{
			try 
			{
				if( rs !=null )
				{
					rs.close();
					rs = null;
				}
				if( pstm != null) 
				{
					pstm.close();
					pstm = null;
				}
			}
			catch (SQLException e)
			{
				e.printStackTrace();
			}
		}
		return taskJsonTranIdMap;
	}

	private String callProcessRequest( String xmlString, Connection conn ) throws ITMException
	{
		String retStr = "";
		try 
		{
			AppConnectParm appConnect = new AppConnectParm();
			InitialContext ctx = new InitialContext( appConnect.getProperty() );
			MasterStatefulLocal masterStateful = ( MasterStatefulLocal )ctx.lookup( "ibase/MasterStatefulEJB/local" );
			retStr = masterStateful.processRequest( getUserInfo(), xmlString.toString(), false, conn );
			masterStateful.remove();
			masterStateful = null;
		}
		catch (RemoteException e) 
		{
			throw new ITMException(e);
		}
		catch (ITMException e) 
		{
			throw e;
		}
		catch (NamingException e) 
		{
			throw new ITMException(e);
		}
		catch (Exception e) 
		{
			throw new ITMException(e);
		}
		return retStr;
	}
	/*Added by sadique shaikh 02-01-2020 [creating user task After Confirm] End*/
	
	/*Added by sadique shaikh 07-01-2020 [Get ref-ser from transetup table ] Start*/
	private String getRefSer(String objName,Connection connection)
	{
		PreparedStatement pstm = null;
		ResultSet rs = null;
		String refSer = "";
		try
		{
			String sql  = "select ref_ser from transetup where tran_window = ?";
			pstm = connection.prepareStatement(sql);
			pstm.setString(1, objName );
			rs = pstm.executeQuery();
			while( rs.next() )
			{
				refSer = rs.getString("ref_ser");
			}
			if( rs !=null )
			{
				rs.close();
				rs = null;
			}
			if( pstm != null) 
			{
				pstm.close();
				pstm = null;
			}
		}
		catch(Exception e)
		{
			System.out.println("StrgMeetDCRWizConf.getRefSer()[ "+e.getMessage()+" ]");
		}
		finally 
		{
			try 
			{
				if( rs !=null )
				{
					rs.close();
					rs = null;
				}
				if( pstm != null) 
				{
					pstm.close();
					pstm = null;
				}
			}
			catch (SQLException e)
			{
				e.printStackTrace();
			}
		}
		return refSer;
	}
	/*Added by sadique shaikh 07-01-2020 [Get ref-ser from transetup table ] End*/
     //Added By Bhagyashri T for INSERT planConfirm on [25-11-2021] START[W21HSUN028]
	public void insertIntoPlanconf(String salesPers,String eventDate, String dcrId, String routeId,String LocCode,String routeDescr,String plantype,String complType,Connection conn) throws ITMException, Exception
	{
		//System.out.println("Inside insert into planConf");
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		//eventDate = genericUtility.getValidDateString(eventDate,genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat());
		int insCount= 0;
		try 
		{
			String tranId = generateTranid(conn);
			String query = "INSERT INTO SPRS_PLAN_COMPL(TRAN_ID,SALES_PERS,WORK_DATE,ROUTE_ID,LOCALITY_CODE,ROUTE_DESCR,PLAN_TYPE,COMPL_TYPE,DCR_ID,PLAN_ID) "
					+ "VALUES(?,?,?,?,?,?,?,?,?,?)";
			pstmt = conn.prepareStatement(query);
			pstmt.setString(1, tranId);
			pstmt.setString(2, salesPers);
			pstmt.setTimestamp(3,java.sql.Timestamp.valueOf(eventDate));
			pstmt.setString(4, routeId);
			pstmt.setString(5, LocCode);
			pstmt.setString(6, routeDescr);
			pstmt.setString(7, plantype);
			pstmt.setString(8, complType);
			pstmt.setString(9, dcrId);
			pstmt.setString(10, "");
			insCount = pstmt.executeUpdate();
			System.out.println("insCount into sprs_plan_compl["+routeId+"] = ["+insCount+"]");
			pstmt.clearParameters();
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt=null;
			}
		} 
		catch (Exception e) 
		{
			// TODO: handle exception
			e.printStackTrace();
			throw e;
		}
		finally 
		{
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt=null;
			}
			
		}
	}
	private String generateTranid( Connection conn ) throws ITMException
	{
		String uniqueKey = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try
		{
			String keyStringQuery = "SELECT KEY_STRING, TRAN_ID_COL, REF_SER FROM TRANSETUP WHERE TRAN_WINDOW = 'w_sprs_plan_compl' ";
			pstmt = conn.prepareStatement(keyStringQuery);
			rs = pstmt.executeQuery();

			if(rs.next())
			{
				String keyString = rs.getString("KEY_STRING");
				String keyCol = rs.getString("TRAN_ID_COL");
				String tranSer = rs.getString("REF_SER");
				String xmlValues ="<?xml version=\"1.0\" encoding=\"utf-8\"?><Root>";
				xmlValues = xmlValues + "<Header></Header>";
				xmlValues = xmlValues + "<Detail1>";
				xmlValues = xmlValues +        "<tran_id></tran_id>";
				xmlValues = xmlValues + "</Detail1></Root>";
				TransIDGenerator tg = new TransIDGenerator(xmlValues, "BASE", CommonConstants.DB_NAME);
				uniqueKey = tg.generateTranSeqID(tranSer, keyCol, keyString, conn);
			}
			rs.close();	rs = null;
			pstmt.close();
			pstmt = null;
		}
		catch(Exception exp)
		{
			System.out.println("Exception : strgMeetDCRConf :generateTransID :==>\n");
			throw new ITMException(exp);
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch (Exception e)
			{
				System.out.println("Exception : StrgMeetDCrWizConf :getUniqueKey :finally==>");
				throw new ITMException(e);
			}
		}
		System.out.println("Generated Primary Key tranid:"+uniqueKey);
		return uniqueKey;
	}
    //added by bhagyashri T for insert into SPRS_PLAN_COMPL [25/11/21][end][W21HSUN028]
	//Added by Bhagyashri For check manager or not[start]
	public boolean isMGREmployee(String empCode) throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String empCodeMGR = "";
		String selectSql = "";
		boolean isMGR=false;
		Connection con = null;
		try
		{
			//Commented by vinayak on [08/07/2016] [start]
			/*ConnDriver connDriver = new ConnDriver();
			con = connDriver.getConnectDB("DriverValidator");*/
			//Commented by vinayak on [08/07/2016] [end]
			con = getConnection();//Added by vinayak on [08/07/2016] to get connection.

			selectSql = "SELECT A.EMP_CODE AS EMP_CODE FROM EMPLOYEE A, GRADE B " + "WHERE A.EMP_CODE = ? " + "AND A.GRADE = B.GRADE_CODE " + "AND B.GRADE_TYPE = 'M' ";

			pstmt = con.prepareStatement(selectSql);
			pstmt.setString(1, empCode);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				empCodeMGR = checkNull(rs.getString("EMP_CODE"));
			}
			rs.close();
		} 
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if (con != null)
				{
					con.close();
					con = null;
				}
			} 
			catch (Exception e1)
			{
				
			}
		}
		if(empCodeMGR.trim().length()>0)
		{
			isMGR=true;
		}
		return isMGR;
	}
	//Added by bhagayshri t for check manageror not[end]
	//Added By Bhagyashri T for instance Workflow changes for LBCP customer Start 11-11-22
	public ArrayList<String> createCustomerWrkflow(String dcrDate,String SalesPersonCode , String dcrIdWf ,Connection connectionObject ) throws ITMException
	{
		System.out.println("Inside createCustomerWrkflw when submit click::"+dcrDate);
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		String currDate = "";
		String retString="";
		StringBuffer valueXmlString = new StringBuffer();
		GenericWorkflowClass genWorkflow= new GenericWorkflowClass();
		ArrayList<String> tranIdList =new ArrayList<String>();
		ArrayList<String> dcrIdList =new ArrayList<String>();
		String getTranId = "";
		String tranID="";
		String dcrID="";

		try
		{
			DateFormat dtFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());
			java.util.Date date = Calendar.getInstance().getTime();
			currDate = dtFormat.format( date );
			String eventDt = genericUtility.getValidDateTimeString( dcrDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );
			
			//Added by mrunalini sinkar for Load Number changes28 Feb 2023 :Start
			/* -- Commented and changed by Gulzar on 15DEC23 - if more than one load is created in the same day.
			String maxDaySummDate="";
			String minDaySummDate="";

			String daySummMaxSQL="SELECT MAX(EVENT_DATE)AS MAX_DAY_SUMM_DATE   FROM SPRS_DAY_SUMM WHERE SALES_PERS=? AND EVENT_DATE<=? ";
			pstmt =  connectionObject.prepareStatement(daySummMaxSQL);
			pstmt.setString(1, SalesPersonCode);
			pstmt.setTimestamp(2, java.sql.Timestamp.valueOf(eventDt));
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				maxDaySummDate=checkNull(rs.getString("MAX_DAY_SUMM_DATE"));
			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			String daySummMinSQL="SELECT MIN(EVENT_DATE) AS MIN_DAY_SUMM_DATE FROM SPRS_DAY_SUMM WHERE SALES_PERS=? AND EVENT_DATE >? ";
			pstmt =  connectionObject.prepareStatement(daySummMinSQL);
			pstmt.setString(1, SalesPersonCode);
			pstmt.setTimestamp(2, java.sql.Timestamp.valueOf(eventDt));
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				minDaySummDate=checkNull(rs.getString("MIN_DAY_SUMM_DATE"));

			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			
			String minCon="";
			if(minDaySummDate != null && minDaySummDate.trim().length() > 0) 
			{

				minCon=" AND EVENT_DATE< ? ";
				
			}
			//System.out.println("maxEvdDate["+maxDaySummDate+"minEveDate["+minDaySummDate+"]");
			//Added by mrunalini sinkar for Load Number changes28 Feb 2023 :End

			//Added & Commented by mrunalini sinkar for Load Number changes28 Feb 2023 :End

			//String getTranId = "SELECT TRAN_ID,DCR_ID FROM  STRG_MEET WHERE EVENT_DATE = ? AND SALES_PERS = ? ";
			//String tranID="";
			//String dcrID="";
			//pstmt = connectionObject.prepareStatement(getTranId);
			//pstmt.setTimestamp( 1, java.sql.Timestamp.valueOf(eventDt));
			//pstmt.setString( 2, SalesPersonCode);

			String getTranId = "SELECT TRAN_ID,DCR_ID FROM  STRG_MEET WHERE EVENT_DATE >= ?  "+
					 			minCon+" "+
					 			" AND SALES_PERS =? ORDER BY EVENT_DATE ";
			System.out.println("getTranId Sql["+getTranId+"minEveDate["+minDaySummDate+"]");

			pstmt = connectionObject.prepareStatement(getTranId);
			pstmt.setTimestamp(1,java.sql.Timestamp.valueOf(maxDaySummDate));

			if(minDaySummDate != null && minDaySummDate.trim().length() > 0) 
			{
				pstmt.setTimestamp(2,java.sql.Timestamp.valueOf(minDaySummDate));
				pstmt.setString( 3, SalesPersonCode);


			}
			else
			{
				pstmt.setString( 2, SalesPersonCode);

			}
			//Added & Commented by mrunalini sinkar for Load Number changes28 Feb 2023 :End

			*/
			//End changes Gulzar on 15DEC23
			
			String loadNo = wsfaCommon.getLoadNo(SalesPersonCode, connectionObject);
			
			getTranId = "SELECT TRAN_ID,DCR_ID FROM  STRG_MEET WHERE SALES_PERS = ? AND DCR_ID IN( SELECT DCR_ID FROM SPRS_ACT_TRAN WHERE SALES_PERS = ? AND LOAD_NO = ?) "; 
			pstmt = connectionObject.prepareStatement(getTranId);
			pstmt.setString(1, SalesPersonCode);
			pstmt.setString(2, SalesPersonCode);
			pstmt.setString(3, loadNo);
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				tranID = checkNull(rs.getString("TRAN_ID"));
				dcrID = checkNull(rs.getString("DCR_ID"));
				if(tranID != null && tranID.trim().length()>0)
				{
					tranIdList.add(tranID);
				}
				//Added by mrunalini sinkar for Load Number changes28 Feb 2023 :Start
				if(dcrID != null && dcrID.trim().length()>0)
				{
					if(!dcrIdList.contains(dcrID))
					{
						dcrIdList.add(dcrID);
					}

				}
				//Added by mrunalini sinkar for Load Number changes28 Feb 2023 :End
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			
			//Added & Commented by mrunalini sinkar for Load Number changes28 Feb 2023 :Start

			System.out.println("dcrIdList["+dcrIdList+"tranIdList["+tranIdList);

			
			OrgStructure orgStructure=new OrgStructure();
			String dcrIdInForm=orgStructure.getFormattedList(dcrIdList);
			if(dcrIdInForm==null || dcrIdInForm.trim().length()==0)
			{
				dcrIdInForm="'X'";
			}
			
			/*String upDateSql1 = "UPDATE STRG_MEET SET WF_STATUS = 'S',CONFIRMED='N'  " +
					"WHERE SALES_PERS = ?  AND  EVENT_DATE = ? AND DCR_ID = ?";
			pstmt = connectionObject.prepareStatement(upDateSql1);
			pstmt.setString(1, SalesPersonCode);
			pstmt.setTimestamp(2,java.sql.Timestamp.valueOf(eventDt));
			pstmt.setString( 3, dcrId);*/
			
			String upDateSql1 = "UPDATE STRG_MEET SET WF_STATUS = 'S',CONFIRMED='N'  " +
					"WHERE DCR_ID IN("+dcrIdInForm+")";
			pstmt = connectionObject.prepareStatement(upDateSql1);
			int updCnt1 = pstmt.executeUpdate();

			if( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			System.out.println("Updatecount in workflow for update::"+updCnt1);
			//Added & Commented by mrunalini sinkar for Load Number changes28 Feb 2023 :End

			StringBuffer valueXmlStringBuf = new StringBuffer();
			valueXmlStringBuf.append("<DocumentRoot><description>Datawindow Root</description><group0><description>Group0 description</description><Header0><description>Header0 members</description>\r\n");
			if(dcrIdInForm !=null && tranIdList != null && !tranIdList.isEmpty())
			{
				int lineNo=1;
				int loaded_qt_sum = 0;
				int invoice_qt_sum = 0;
				int trans_in_sum = 0;
				int trans_out_sum = 0;
				int break_add_sum = 0;
				int break_deduct_sum = 0;
				int return_depo_sum = 0;
				int intCnt=0;
				//Added & Commented by mrunalini sinkar for Load Number changes28 Feb 2023 :Start
				/*String invoiceSql="SELECT A.ITEM_CODE,A.DESCR,A.LOADED_QTY,A.QUANTITY,A.TRANSFER_IN,A.TRANSFER_OUT,A.BREAK_ADD_QTY, "
						+ "A.BREAK_DEDUCT_QTY, " + 
						"(A.LOADED_QTY+A.TRANSFER_IN+A.BREAK_ADD_QTY-A.QUANTITY-A.TRANSFER_OUT-A.BREAK_DEDUCT_QTY) AS retDepot,SP.SP_NAME " +
						"FROM SALES_PERS SP , " + 
						"(SELECT DISTINCT smi.item_code ITEM_CODE,i.descr AS DESCR, " + 
						"(case WHEN smi.LOAD_QTY is null then 0 else smi.LOAD_QTY END) AS LOADED_QTY, " + 
						"sum(smi.quantity) as QUANTITY, " + 
						"FN_GET_STOCK_TRANFER_DATA('TRANSFER_IN',SMI.ITEM_CODE,?,?) AS TRANSFER_IN, " + 
						"FN_GET_STOCK_TRANFER_DATA('TRANSFER_OUT',SMI.ITEM_CODE,?,?) AS TRANSFER_OUT, " + 
						"FN_GET_STOCK_TRANFER_DATA('BREAK_ADD_QTY',SMI.ITEM_CODE,?,?) AS BREAK_ADD_QTY, " + 
						"FN_GET_STOCK_TRANFER_DATA('BREAK_DEDUCT_QTY',SMI.ITEM_CODE,?,?) AS BREAK_DEDUCT_QTY " + 
						"FROM " + 
						"strg_meet_invoice smi " + 
						"left outer join item i  on smi.item_code = i.item_code " + 
						"WHERE  SMI.DCR_ID = ? " + 
						"group by smi.item_code,i.descr,smi.LOAD_QTY) A WHERE SP.SALES_PERS= ? ORDER BY A.DESCR";
				PreparedStatement pstmtInvoice = connectionObject.prepareStatement(invoiceSql);
				pstmtInvoice.setString( 1, SalesPersonCode);
				pstmtInvoice.setTimestamp( 2, java.sql.Timestamp.valueOf(eventDt));
				pstmtInvoice.setString( 3, SalesPersonCode);
				pstmtInvoice.setTimestamp( 4, java.sql.Timestamp.valueOf(eventDt));
				pstmtInvoice.setString( 5, SalesPersonCode);
				pstmtInvoice.setTimestamp( 6, java.sql.Timestamp.valueOf(eventDt));
				pstmtInvoice.setString( 7, SalesPersonCode);
				pstmtInvoice.setTimestamp( 8, java.sql.Timestamp.valueOf(eventDt));
				pstmtInvoice.setString(9, dcrID);
				pstmtInvoice.setString( 10, SalesPersonCode);*/
				
				/*
				
				String invoiceSql="SELECT A.ITEM_CODE,A.DESCR,A.LOADED_QTY,A.QUANTITY,A.TRANSFER_IN,A.TRANSFER_OUT,A.BREAK_ADD_QTY, "
						+ "A.BREAK_DEDUCT_QTY, " + 
						"(A.LOADED_QTY+A.TRANSFER_IN+A.BREAK_ADD_QTY-A.QUANTITY-A.TRANSFER_OUT-A.BREAK_DEDUCT_QTY) AS retDepot " +
						"FROM (SELECT DISTINCT smi.item_code ITEM_CODE,i.descr AS DESCR, " + 
						"(case WHEN smi.LOAD_QTY is null then 0 else smi.LOAD_QTY END) AS LOADED_QTY, " + 
						"sum(smi.quantity) as QUANTITY, " + 
						"FN_GET_STOCK_TRANFER_DATA('TRANSFER_IN',SMI.ITEM_CODE,?,?) AS TRANSFER_IN, " + 
						"FN_GET_STOCK_TRANFER_DATA('TRANSFER_OUT',SMI.ITEM_CODE,?,?) AS TRANSFER_OUT, " + 
						"FN_GET_STOCK_TRANFER_DATA('BREAK_ADD_QTY',SMI.ITEM_CODE,?,?) AS BREAK_ADD_QTY, " + 
						"FN_GET_STOCK_TRANFER_DATA('BREAK_DEDUCT_QTY',SMI.ITEM_CODE,?,?) AS BREAK_DEDUCT_QTY " + 
						"FROM " + 
						"strg_meet_invoice smi " + 
						"left outer join item i  on smi.item_code = i.item_code " + 
						"WHERE  SMI.DCR_ID IN("+dcrIdInForm+") " + 
						"group by smi.item_code,i.descr,smi.LOAD_QTY) A ORDER BY A.DESCR";
				 */
				
				//comment above sql by Sanket D on 02-06-23 

				StrgMeetDCRWizard strgMeetWizrad = new StrgMeetDCRWizard();

				String priceList = getPriceList(connectionObject, pstmt, rs, dcrIdInForm);
				System.out.println("Sanket PriceList "+priceList);
				String itemUSage="";
				String parmItemUsage = strgMeetWizrad.getSfaParmValue(SalesPersonCode,"SAMPLE_ITEM_USAGE",connectionObject);
				if(parmItemUsage!=null && parmItemUsage.trim().length()>0)
				{
					itemUSage=checkNull(strgMeetWizrad.getFormattedStringBuff( parmItemUsage ));
				}
				else
				{
					itemUSage="'G','S'";
				}
				System.out.println("Sanket itemUSage "+itemUSage);
				
				//Added by Sanket . for unlisted item show in workflow on 02-06-23
				
				String sql="SELECT A.ITEM_CODE,A.DESCR,A.LOADED_QTY,A.QUANTITY,A.TRANSFER_IN,A.TRANSFER_OUT,A.BREAK_ADD_QTY, A.BREAK_DEDUCT_QTY, " + 
						" (A.LOADED_QTY+A.TRANSFER_IN+A.BREAK_ADD_QTY-A.QUANTITY-A.TRANSFER_OUT-A.BREAK_DEDUCT_QTY) AS retDepot" + 
						" FROM (SELECT DISTINCT smi.item_code ITEM_CODE,i.descr AS DESCR, " + 
						" (case WHEN smi.LOAD_QTY is null then 0 else smi.LOAD_QTY END) AS LOADED_QTY, sum(smi.quantity) as QUANTITY, " + 
						" FN_GET_STOCK_TRANFER_DATA('TRANSFER_IN',SMI.ITEM_CODE,?,?) AS TRANSFER_IN," + 
						" FN_GET_STOCK_TRANFER_DATA('TRANSFER_OUT',SMI.ITEM_CODE,?,?) AS TRANSFER_OUT, " + 
						" FN_GET_STOCK_TRANFER_DATA('BREAK_ADD_QTY',SMI.ITEM_CODE,?,?) AS BREAK_ADD_QTY, " + 
						" FN_GET_STOCK_TRANFER_DATA('BREAK_DEDUCT_QTY',SMI.ITEM_CODE,?,?) AS BREAK_DEDUCT_QTY " + 
						" FROM strg_meet_invoice smi  " + 
						" left outer join item i  on smi.item_code = i.item_code WHERE  SMI.DCR_ID IN ("+dcrIdInForm+") " + 
						" group by smi.item_code,i.descr,smi.LOAD_QTY " + 
						" UNION " + 
						" SELECT DISTINCT ITEM.ITEM_CODE AS ITEM_CODE ,ITEM.DESCR AS DESCR,(S.QUANTITY-S.ALLOC_QTY) AS LOADED_QTY " + 
						" ,0 AS QUANTITY, " + 
						" FN_GET_STOCK_TRANFER_DATA('TRANSFER_IN',ITEM.ITEM_CODE,?,?) AS TRANSFER_IN, " + 
						" FN_GET_STOCK_TRANFER_DATA('TRANSFER_OUT',ITEM.ITEM_CODE,?,?) AS TRANSFER_OUT, " + 
						" FN_GET_STOCK_TRANFER_DATA('BREAK_ADD_QTY',ITEM.ITEM_CODE,?,?) AS BREAK_ADD_QTY, " + 
						" FN_GET_STOCK_TRANFER_DATA('BREAK_DEDUCT_QTY',ITEM.ITEM_CODE,?,?) AS BREAK_DEDUCT_QTY " + 
						" FROM ITEM ITEM LEFT OUTER JOIN PRICELIST  PM ON ITEM.ITEM_CODE = PM.ITEM_CODE,STOCK S,SALES_PERS SP " + 
						" WHERE PM.PRICE_LIST IN ("+priceList+") " + 
						" AND ITEM.ACTIVE = 'Y' AND SP.ITEM_SER=ITEM.ITEM_SER " + 
						" AND RTRIM((CASE WHEN ITEM.ITEM_USAGE IS NULL THEN 'O' ELSE ITEM.ITEM_USAGE END )) NOT IN("+itemUSage+") " + 
						" AND RTRIM((CASE WHEN ITEM.ITEM_USAGE IS NULL THEN 'O' ELSE ITEM.ITEM_USAGE END ))='F' " + 
						" AND S.ITEM_CODE=ITEM.ITEM_CODE AND S.SITE_CODE =(SELECT EMP_SITE FROM EMPLOYEE WHERE EMP_CODE= ? ) " + 
						" AND S.LOC_CODE=? AND S.ITEM_SER=ITEM.ITEM_SER AND S.INV_STAT='SALE'  AND S.QUANTITY >0 " + 
						" AND S.ITEM_CODE NOT IN (SELECT DISTINCT item_code FROM strg_meet_invoice WHERE DCR_ID IN ("+dcrIdInForm+"))" + 
						") A ORDER BY A.DESCR";
				
				PreparedStatement prepareStatement = connectionObject.prepareStatement(sql);
				prepareStatement.setString(1, SalesPersonCode);
				prepareStatement.setTimestamp( 2, java.sql.Timestamp.valueOf(eventDt));
				prepareStatement.setString(3, SalesPersonCode);
				prepareStatement.setTimestamp( 4, java.sql.Timestamp.valueOf(eventDt));
				prepareStatement.setString(5, SalesPersonCode);
				prepareStatement.setTimestamp( 6, java.sql.Timestamp.valueOf(eventDt));
				prepareStatement.setString(7, SalesPersonCode);
				prepareStatement.setTimestamp( 8, java.sql.Timestamp.valueOf(eventDt));

				prepareStatement.setString(9, SalesPersonCode);
				prepareStatement.setTimestamp( 10, java.sql.Timestamp.valueOf(eventDt));
				prepareStatement.setString(11, SalesPersonCode);
				prepareStatement.setTimestamp( 12, java.sql.Timestamp.valueOf(eventDt));
				prepareStatement.setString(13, SalesPersonCode);
				prepareStatement.setTimestamp( 14, java.sql.Timestamp.valueOf(eventDt));
				prepareStatement.setString(15, SalesPersonCode);
				prepareStatement.setTimestamp( 16, java.sql.Timestamp.valueOf(eventDt));
				
				prepareStatement.setString(17, SalesPersonCode);
				prepareStatement.setString(18, SalesPersonCode);

				/*	PreparedStatement pstmtInvoice = connectionObject.prepareStatement(invoiceSql);
				pstmtInvoice.setString( 1, SalesPersonCode);
				pstmtInvoice.setTimestamp( 2, java.sql.Timestamp.valueOf(eventDt));
				pstmtInvoice.setString( 3, SalesPersonCode);
				pstmtInvoice.setTimestamp( 4, java.sql.Timestamp.valueOf(eventDt));
				pstmtInvoice.setString( 5, SalesPersonCode);
				pstmtInvoice.setTimestamp( 6, java.sql.Timestamp.valueOf(eventDt));
				pstmtInvoice.setString( 7, SalesPersonCode);
				pstmtInvoice.setTimestamp( 8, java.sql.Timestamp.valueOf(eventDt));
				//Added & Commented by mrunalini sinkar for Load Number changes28 Feb 2023 :End
				 */
				
				ResultSet rsInvoice = prepareStatement.executeQuery();
				while(rsInvoice.next())
				{
					String invoiceQty = "0",loadedQty = "0",retDepot = "0";
					String transferIn="0",transferOut="0",breakAddQty="0",breakDeductQty="0";
					invoiceQty=checkNull(rsInvoice.getString("QUANTITY"));
					String itmCode =checkNull(rsInvoice.getString("ITEM_CODE"));
					String itmDescr =checkNull(rsInvoice.getString("DESCR"));
					loadedQty=checkNull(rsInvoice.getString("LOADED_QTY"));
					retDepot=checkNull(rsInvoice.getString("retDepot"));
					transferIn=checkNull(rsInvoice.getString("TRANSFER_IN"));
					transferOut=checkNull(rsInvoice.getString("TRANSFER_OUT"));
					breakAddQty=checkNull(rsInvoice.getString("BREAK_ADD_QTY"));
					breakDeductQty=checkNull(rsInvoice.getString("BREAK_DEDUCT_QTY"));
					if(invoiceQty != null && invoiceQty.length()> 0)
					{	
						int loadQuan = Integer.parseInt(loadedQty);
						int invQuan = Integer.parseInt(invoiceQty);
						int tranIN = Integer.parseInt(transferIn);
						int tranOut = Integer.parseInt(transferOut);
						int breakAdd = Integer.parseInt(breakAddQty);
						int breakDeduct = Integer.parseInt(breakDeductQty);
						int retDepotD = Integer.parseInt(retDepot);
						
						loaded_qt_sum = loaded_qt_sum + loadQuan;
						invoice_qt_sum = invoice_qt_sum + invQuan;
						trans_in_sum = trans_in_sum + tranIN;
						trans_out_sum = trans_out_sum + tranOut;
						break_add_sum = break_add_sum + breakAdd;
						break_deduct_sum = break_deduct_sum + breakDeduct;
						return_depo_sum = return_depo_sum +retDepotD;
					}
					intCnt++;
					String dbId=dcrID+":"+itmCode;
					valueXmlStringBuf.append("<Detail1 dbID ='"+dcrID+"' domID='"+dbId+"' parentFormdomID='"+lineNo+"' objName='invoice_stock_aprv' objContext='1' >\r\n" );
					valueXmlStringBuf.append("<attribute pkNames='tran_id' status='N' updateFlag='A' selected='Y' />\r\n");
					valueXmlStringBuf.append( "<line_no><![CDATA[" ).append(lineNo).append( "]]></line_no>\r\n" );
					valueXmlStringBuf.append( "<invoice_qty><![CDATA[" ).append(invoiceQty).append( "]]></invoice_qty>\r\n" );
					valueXmlStringBuf.append( "<loaded_qty><![CDATA[" ).append(loadedQty).append( "]]></loaded_qty>\r\n" );
					valueXmlStringBuf.append( "<item_code><![CDATA[" ).append(itmCode).append( "]]></item_code>\r\n" );
					valueXmlStringBuf.append( "<item_descr><![CDATA[" ).append(itmDescr).append( "]]></item_descr>\r\n" );
					valueXmlStringBuf.append( "<transfer_in><![CDATA[" ).append(transferIn).append( "]]></transfer_in>\r\n" );
					valueXmlStringBuf.append( "<transfer_out><![CDATA[" ).append(transferOut).append( "]]></transfer_out>\r\n" );
					valueXmlStringBuf.append( "<break_add_qty><![CDATA[" ).append(breakAddQty).append( "]]></break_add_qty>\r\n" );
					valueXmlStringBuf.append( "<break_deduct_qty><![CDATA[" ).append(breakDeductQty).append( "]]></break_deduct_qty>\r\n" );
					valueXmlStringBuf.append( "<return_to_depot><![CDATA[" ).append(retDepot).append( "]]></return_to_depot>\r\n" );
					valueXmlStringBuf.append("<host_url><![CDATA[" ).append(CommonConstants.TOMCAT_HOME).append( "]]></host_url>\r\n" );
					valueXmlStringBuf.append("</Detail1>\r\n");
				}
				lineNo++;
				rsInvoice.close();
				rsInvoice = null;
				prepareStatement.close();
				prepareStatement = null;
				valueXmlStringBuf.append("<Detail3 dbID ='"+dcrID+"' domID='1' parentFormdomID='"+lineNo+"' objName='invoice_stock_aprv' objContext='3' >\r\n" );
				valueXmlStringBuf.append("<attribute pkNames='tran_id' status='N' updateFlag='A' selected='Y' />\r\n");
				valueXmlStringBuf.append( "<count_of_item><![CDATA[" ).append(intCnt+" Items").append( "]]></count_of_item>\r\n" );
				valueXmlStringBuf.append( "<loaded_qt_sum><![CDATA[" ).append(loaded_qt_sum).append( "]]></loaded_qt_sum>\r\n" );
				valueXmlStringBuf.append( "<invoice_qt_sum><![CDATA[" ).append(invoice_qt_sum).append( "]]></invoice_qt_sum>\r\n" );
				valueXmlStringBuf.append( "<trans_in_sum><![CDATA[" ).append(trans_in_sum).append( "]]></trans_in_sum>\r\n" );
				valueXmlStringBuf.append( "<trans_out_sum><![CDATA[" ).append(trans_out_sum).append( "]]></trans_out_sum>\r\n" );
				valueXmlStringBuf.append( "<break_add_sum><![CDATA[" ).append(break_add_sum).append( "]]></break_add_sum>\r\n" );
				valueXmlStringBuf.append( "<break_deduct_sum><![CDATA[" ).append(break_deduct_sum).append( "]]></break_deduct_sum>\r\n" );
				valueXmlStringBuf.append( "<return_depo_sum><![CDATA[" ).append(return_depo_sum).append( "]]></return_depo_sum>\r\n" );
				valueXmlStringBuf.append("</Detail3>\r\n");
				
			}
			int custCnt=0;
			double bill_amt_sum = 0d;
			double inv_amt_sum = 0d;
			String bill_sum="",inv_sum="";
			if(tranIdList != null && !tranIdList.isEmpty())
			{
				int lineNo=1;
				StrgMeetDCRWizard strgMeetWizrad = new StrgMeetDCRWizard();
				String hoEmpCode = checkNull(strgMeetWizrad.getSfaParmValue(SalesPersonCode,"DAR_DIVISION_HO",connectionObject));
				String wrkflwAprvLevel = checkNull(strgMeetWizrad.getSfaParmValue(SalesPersonCode,"UNLIST_WRKFLW_LEVEL",connectionObject));
				String totalAmt="",invId="";
				ArrayList<String> invIdDetailList=new ArrayList<String>();
				ArrayList<String> invoiceIdList=new ArrayList<String>();
				
				//Added & Commented by mrunalini sinkar for Load Number changes28 Feb 2023 :Start
				
				/*String invIdSql="SELECT DISTINCT smi.STRG_CODE ,smi.tran_id, " + 
						"SUM((smi.quantity*smi.rate)+(smi.quantity*smi.rate*DDF_TOTAL_TAX_AMOUNT( 'IGST' )/100)) as total_amount, " + 
						"SMI.INVOICE_ID " + 
						"FROM strg_meet_invoice smi,item i,STRG_MEET_COLLECT smc  " + 
						"WHERE " + 
						"smi.item_code = i.item_code and smi.tran_id = smc.tran_id and trim(smc.pay_mode)='C' and  " + 
						"SMI.DCR_ID =? " + 
						"group by smi.STRG_CODE,smi.tran_id,SMI.INVOICE_ID order by smi.strg_code,smi.invoice_id";
				pstmt = connectionObject.prepareStatement(invIdSql);
				pstmt.setString(1, dcrID);*/
				
				String invIdSql="SELECT DISTINCT smi.STRG_CODE ,smi.tran_id as tran_id, " + 
						"round(SUM((smi.quantity*smi.rate)+(smi.quantity*smi.rate*DDF_TOTAL_TAX_AMOUNT( 'IGST' )/100))) as total_amount, " + 
						"SMI.INVOICE_ID " + 
						"FROM strg_meet_invoice smi,item i,STRG_MEET_COLLECT smc  " + 
						"WHERE " + 
						"smi.item_code = i.item_code and smi.tran_id = smc.tran_id "+ 
						//" and trim(smc.pay_mode)='C' " + 
						"and SMI.DCR_ID IN("+dcrIdInForm+") " + 
						"group by smi.STRG_CODE,smi.tran_id,SMI.INVOICE_ID order by smi.strg_code,smi.invoice_id";
				
				//Added & Commented by mrunalini sinkar for Load Number changes28 Feb 2023 :End
				pstmt = connectionObject.prepareStatement(invIdSql);
				rs = pstmt.executeQuery();
				while(rs.next())
				{
					totalAmt = checkNull(rs.getString("total_amount"));
					invId = checkNull(rs.getString("INVOICE_ID"));
					String tranId = checkNull(rs.getString("tran_id"));
					if(invId != null && invId.trim().length()>0)
					{
						//invoiceIdList.add(invId);
						invoiceIdList.add(invId.trim()+"@@"+tranId.trim());// CHanges by Hariom S for proper data should show in workflow screen data should show proper -03-July-2023
						invIdDetailList.add(invId+"@"+totalAmt);
					}
				}

				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				//System.out.println("invIdDetailList is as::"+invIdDetailList);
				//System.out.println("invoiceIdList is as::"+invoiceIdList);
				ArrayList strgCodeList = new ArrayList();
				ArrayList dubinvoiceIdList = new ArrayList();
				for(int i=0; i< tranIdList.size(); i++)
				{
					String schTranId = tranIdList.get(i);
					String getStrgMeetSql = "select distinct a.dcr_id,a.tran_id,a.sales_pers,a.sp_name,a.event_date,a.event_type,a.strg_code,a.address_as "
							+ ",a.sales_type,a.strg_name,a.strg_type,a.cust_type_descr,a.LOCALITY_CODE,a.CONFIRMED,a.CONF_DATE "
							+ ",a.WF_STATUS,a.EMP_CODE__APRV,a.CHG_DATE,a.CHG_USER,a.CHG_TERM,a.LOCALITY_DESCR "
							+ ",a.BILL_AMT,a.AMOUNT,a.REF_DATE,a.PAY_MODE,a.StrgCode "
							+ ",a.TranID,a.DcrID,a.REF_NO, a.REF_BANK,a.INVOICE_ID, a.INVOICE_STATUS  "
							+ "from ("
							+ "SELECT SM.DCR_ID, SM.TRAN_ID, SM.SALES_PERS, SP.SP_NAME, SM.EVENT_DATE, SM.EVENT_TYPE, SM.STRG_CODE, SM.ADDRESS_AS, (CASE WHEN SM.SALES_TYPE ='I' THEN 'B2B' WHEN SM.SALES_TYPE ='C' THEN 'Sales' ELSE SM.SALES_TYPE END ) AS SALES_TYPE, " +
							" SM.STRG_NAME, SM.STRG_TYPE,sct.descr as cust_type_descr,SM.LOCALITY_CODE, SM.CONFIRMED, SM.CONF_DATE, SM.WF_STATUS, SM.EMP_CODE__APRV, SM.CHG_DATE, SM.CHG_USER," +
							" SM.CHG_TERM,L.DESCR AS LOCALITY_DESCR,SMC.BILL_AMT,SMC.AMOUNT, SMC.REF_DATE,SMC.PAY_MODE,SMC.STRG_CODE as StrgCode,SMC.TRAN_ID AS TranID,SMC.DCR_ID as DcrID,SMC.REF_NO,"+
							// Changed by Rahul P. on 20-Feb-24 to add invoice_status in xml
							" SMC.REF_BANK,SMI.INVOICE_ID AS INVOICE_ID, SMI.INVOICE_STATUS "+
							// Changed by Rahul P. on 20-Feb-24
							" FROM  LOCALITY L, SALES_PERS SP, STRG_MEET SM LEFT OUTER JOIN STRG_CUST_TYPE SCT ON sm.STRG_TYPE = SCT.TYPE,STRG_MEET_COLLECT SMC,STRG_MEET_INVOICE SMI " +
							" WHERE SM.LOCALITY_CODE = L.LOCALITY_CODE " +
							"AND SM.SALES_PERS = SP.SALES_PERS " +
							" AND SMC.TRAN_ID=SM.TRAN_ID "+
							" AND sm.TRAN_ID=SMI.TRAN_ID "+
							" AND SM.STRG_CODE=SMC.STRG_CODE "+
							"AND SM.CONFIRMED ='N' " +
							"AND SM.WF_STATUS ='S' "+
							"AND SM.TRAN_ID = ?  )a order by a.strg_name,a.INVOICE_ID";

					pstmt = connectionObject.prepareStatement(getStrgMeetSql);
					pstmt.setString(1,schTranId);
					rs = pstmt.executeQuery();
					while(rs.next())
					{
						String dcrIDdb = checkNull(rs.getString("DCR_ID"));
						String tranIDdb = checkNull(rs.getString("TRAN_ID"));
						String salesPers = checkNull(rs.getString("SALES_PERS"));
						String eventDate = checkNull(rs.getString("EVENT_DATE"));
			
						if(eventDate != null)
						{
							eventDate = genericUtility.getValidDateString( eventDate, genericUtility.getDBDateFormat(), genericUtility.getApplDateFormat() );
						}
						String eventType = checkNull(rs.getString("EVENT_TYPE"));
						String strgCodedb = checkNull(rs.getString("STRG_CODE")).trim();
						String addressAs = checkNull(rs.getString("ADDRESS_AS"));
						//Added salesType in query
						String salesType = checkNull(rs.getString("SALES_TYPE"));
						//Added salesType in query
						String strgName = checkNull(rs.getString("STRG_NAME"));
						String strgType = checkNull(rs.getString("STRG_TYPE"));
						String localityCode = checkNull(rs.getString("LOCALITY_CODE"));
						String confirmed = checkNull(rs.getString("CONFIRMED"));
						String confDate = checkNull(rs.getString("CONF_DATE"));
						String wfStatus = checkNull(rs.getString("WF_STATUS"));
						String empCodeAprv = checkNull(rs.getString("EMP_CODE__APRV"));
						String chgDate = checkNull(rs.getString("CHG_DATE"));
						if(chgDate != null)
						{
							chgDate = genericUtility.getValidDateTimeString( chgDate, genericUtility.getDBDateFormat(), genericUtility.getApplDateFormat() );
						}

						String chgUser = checkNull(rs.getString("CHG_USER"));
						String chgTerm = checkNull(rs.getString("CHG_TERM"));
						String localityDescr = checkNull(rs.getString("LOCALITY_DESCR"));
						String custTypeDescr = checkNull(rs.getString("cust_type_descr"));
						String payMode = checkNull(rs.getString("PAY_MODE")).trim();
						String invoiceId = checkNull(rs.getString("INVOICE_ID")).trim();
						String invoiceNumber=invoiceId;
						String invno="";
						/* --Commented by Gulzar on 27FEB24
						if(invoiceId.indexOf("/")!=-1)
						{
							invno=invoiceId.split("/")[0];
							invoiceNumber=invoiceId.split("/")[1];

						}
						else 
						{
							invoiceNumber=invoiceId;
						}
						*/
						//System.out.println("After split invoice no is::"+invoiceNumber);
						//System.out.println("After split invno is::"+invno);
						
						String invScCode=invoiceId+"@"+strgCodedb;
						//System.out.println("for double invoicelist invScCode::"+invScCode);
						
						//System.out.println("strgCodeList is as ::"+strgCodeList);
						/*--Commented by Gulzar on 27FEB24
						if(strgCodeList == null || !strgCodeList.contains(strgCodedb))
						{
							strgCodeList.add(strgCodedb);
							System.out.println("Inside strgCode  not prsent strgCodeList");
						}
						
						else if(strgCodeList != null && !strgCodeList.isEmpty() && strgCodeList.contains(strgCodedb) && !payMode.equals("C"))
						{
							System.out.println("Inside strgCode prsent with no CASH pay mode");
							break;
						}
						*/
						//System.out.println("strgCodeList is as after all break n continu::"+strgCodeList);
						//System.out.println("for double invoicelist dubinvoiceIdList::"+dubinvoiceIdList);
						if(dubinvoiceIdList == null || !dubinvoiceIdList.contains(invScCode))
						{
							//System.out.println("Invoice Id with sc code not present in list");
							dubinvoiceIdList.add(invScCode);
							//valueXmlStringBuf.append("<Detail2 dbID ='"+dbId+"' domID='"+lineNo+"' objName='invoice_stock_aprv' objContext='2' >\r\n" );
							valueXmlStringBuf.append("<Detail2 dbID ='"+invoiceNumber+"' domID='"+lineNo+"' objName='invoice_stock_aprv' objContext='2' >\r\n" );
							valueXmlStringBuf.append("<attribute pkNames='' status='O' updateFlag='E' selected='Y' IS_CHANGE='Y' />\r\n");
							valueXmlStringBuf.append("<tran_id><![CDATA[" ).append(tranIDdb).append( "]]></tran_id>\r\n" );
							valueXmlStringBuf.append("<dcr_id><![CDATA[" ).append(dcrIDdb).append( "]]></dcr_id>\r\n" );
							valueXmlStringBuf.append("<sales_pers><![CDATA[" ).append(salesPers).append( "]]></sales_pers>\r\n" );
							valueXmlStringBuf.append("<event_date><![CDATA[" ).append(eventDate).append( "]]></event_date>\r\n" );
							valueXmlStringBuf.append("<event_type><![CDATA[" ).append(eventType).append( "]]></event_type>\r\n" );
							valueXmlStringBuf.append("<strg_code><![CDATA[" ).append(strgCodedb).append( "]]></strg_code>\r\n" );
							valueXmlStringBuf.append("<address_as><![CDATA[" ).append(addressAs).append( "]]></address_as>\r\n" );
							//Appended salesType in XML
							valueXmlStringBuf.append("<sales_type><![CDATA[" ).append(salesType).append( "]]></sales_type>\r\n" );
							//Appended salesType in XML
							valueXmlStringBuf.append("<strg_name><![CDATA[" ).append(strgName).append( "]]></strg_name>\r\n" );
							valueXmlStringBuf.append("<strg_type><![CDATA[" ).append(strgType).append( "]]></strg_type>\r\n" );
							valueXmlStringBuf.append("<locality_code><![CDATA[" ).append(localityCode).append( "]]></locality_code>\r\n" );
							valueXmlStringBuf.append("<cust_type_descr><![CDATA[" ).append(custTypeDescr).append( "]]></cust_type_descr>\r\n" );
							valueXmlStringBuf.append("<confirmed><![CDATA[" ).append(confirmed).append( "]]></confirmed>\r\n" );
							valueXmlStringBuf.append("<wf_status><![CDATA[" ).append("S").append( "]]></wf_status>\r\n" );
							valueXmlStringBuf.append("<emp_code__aprv><![CDATA[" ).append(empCodeAprv).append( "]]></emp_code__aprv>\r\n" );
							valueXmlStringBuf.append("<chg_date><![CDATA[" ).append(chgDate).append( "]]></chg_date>\r\n" );
							valueXmlStringBuf.append("<chg_user><![CDATA[" ).append(chgUser).append( "]]></chg_user>\r\n" );
							valueXmlStringBuf.append("<chg_term><![CDATA[" ).append(chgTerm).append( "]]></chg_term>\r\n" );
							valueXmlStringBuf.append("<locality_descr><![CDATA[" ).append(localityDescr).append( "]]></locality_descr>\r\n" );
							valueXmlStringBuf.append("<invoice_no><![CDATA[" ).append(invno).append( "]]></invoice_no>\r\n" );
							valueXmlStringBuf.append("<invoice_id><![CDATA[" ).append(invoiceNumber).append( "]]></invoice_id>\r\n" );
							valueXmlStringBuf.append("<emp_code_ho><![CDATA[" ).append(hoEmpCode).append( "]]></emp_code_ho>\r\n" );
							valueXmlStringBuf.append("<sp_name><![CDATA[" ).append(checkNull(rs.getString("SP_NAME"))).append( "]]></sp_name>\r\n" );
							valueXmlStringBuf.append("<wrkflw_aprv_level><![CDATA[" ).append(wrkflwAprvLevel).append( "]]></wrkflw_aprv_level>\r\n" );
							if (hoEmpCode != null && hoEmpCode.trim().length() > 0)
							{
								valueXmlStringBuf.append("<ho_exist><![CDATA[" ).append("Y").append( "]]></ho_exist>\r\n" );
							}
							else
							{
								valueXmlStringBuf.append("<ho_exist><![CDATA[" ).append("N").append( "]]></ho_exist>\r\n" );
							}
							String refDate = checkNull(rs.getString("REF_DATE"));
							if(refDate != null && refDate.trim().length()>0)
							{
								refDate = genericUtility.getValidDateTimeString( refDate, genericUtility.getDBDateFormat(), genericUtility.getApplDateFormat() );
							}
							
							String billAmt="0",invAmt="0";
							String invoiceTranId= invoiceId.trim()+"@@"+tranIDdb.trim();
							//if(invoiceIdList.contains(invoiceId))
							if(invoiceIdList.contains(invoiceTranId))// CHanges by Hariom S for proper data should show in workflow screen data should show proper -03-July-2023
							{
								if(invIdDetailList!=null && invIdDetailList.size()>0)
								{
									for( int j=0; j<invIdDetailList.size(); j++)
									{
										String words=(String)invIdDetailList.get(j);
										String [] splitMapValue=words.split("@");
										String listInvoiceId=checkNull(splitMapValue[0]);
										
										String billInvAmt=checkNull(splitMapValue[1]);
										if(listInvoiceId.equals(invoiceId))
										{
											//System.out.println("Inside Cash pay ode total AMount");
											billAmt=billInvAmt;
											invAmt=billInvAmt;
											break;
										}
									}
									//System.out.println("Outside Cash pay ode total AMount");
								}
								
							}
							else
							{
								//System.out.println("else of pay mode not cash");
								billAmt= checkNull(rs.getString("BILL_AMT"));
								invAmt = checkNull(rs.getString("AMOUNT"));
							}
							//System.out.println("billAmt for the paymode::"+billAmt);
							//System.out.println("invAmtfor the payMode::"+invAmt);
							DecimalFormat dFormatter = new DecimalFormat("#.##");
							if(billAmt!=null && billAmt.trim().length()>0 && invAmt!=null && invAmt.trim().length()>0)
							{
								double bilAmount = Double.parseDouble(billAmt);
								double invoiceAmount = Double.parseDouble(invAmt);
								
								bill_amt_sum=bill_amt_sum+bilAmount;
								
								bill_sum=dFormatter.format(bill_amt_sum);
								
								inv_amt_sum=inv_amt_sum+invoiceAmount;
								
								inv_sum=dFormatter.format(inv_amt_sum);
								
							}
							//added by prachi on 24-feb-2023
							int billAmtround =0;
							int amtround=0;
							if(billAmt!=null && billAmt.trim().length()>0 && invAmt!=null && invAmt.trim().length()>0)
							{	
								double billAmtD =Double.parseDouble(billAmt);
								billAmtround= (int)Math.round(billAmtD);
								double amtroundD = Double.parseDouble(invAmt);
								amtround = (int)Math.round(amtroundD);
							}
							valueXmlStringBuf.append("<bill_amt><![CDATA[").append(billAmtround).append("]]></bill_amt>\r\n");
							valueXmlStringBuf.append("<amount><![CDATA[").append(amtround).append("]]></amount>\r\n");
							
							//valueXmlStringBuf.append("<bill_amt><![CDATA[").append(billAmt).append("]]></bill_amt>\r\n");
							//valueXmlStringBuf.append("<amount><![CDATA[").append(invAmt).append("]]></amount>\r\n");
							valueXmlStringBuf.append( "<dcr_id><![CDATA[" ).append(checkNull(rs.getString("DcrID"))).append( "]]></dcr_id>\r\n" );
							valueXmlStringBuf.append("<tran_id><![CDATA[").append( checkNull(rs.getString("TranID")) ).append("]]></tran_id>\r\n");
							valueXmlStringBuf.append("<pay_mode><![CDATA[").append(payMode).append("]]></pay_mode>\r\n");
							valueXmlStringBuf.append("<ref_no><![CDATA[").append( checkNull(rs.getString("REF_NO")) ).append("]]></ref_no>\r\n");
							valueXmlStringBuf.append("<ref_date><![CDATA[").append(refDate).append("]]></ref_date>\r\n");
							valueXmlStringBuf.append("<ref_bank><![CDATA[").append( checkNull(rs.getString("REF_BANK")) ).append("]]></ref_bank>\r\n");	
							// Added by Rahul P. on 20-Feb-24 to add invoice_status in xml
							valueXmlStringBuf.append("<invoice_status><![CDATA[").append( checkNull(rs.getString("INVOICE_STATUS")) ).append("]]></invoice_status>\r\n");
							// Added by Rahul P. on 20-Feb-24
							valueXmlStringBuf.append("</Detail2>\r\n");
							lineNo++;
						}
						else
						{
							System.out.println("Invoice id with sc code present in else");
						}
						//System.out.println("dubinvoiceIdList is  after break that list as ::"+dubinvoiceIdList);
						
					}
					custCnt++;
					//lineNo++;
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}

				}//End of For loop of Customer tran-id
				

			}//End of Tran_if list is not null
			
			//added by prachi on 24-feb-2023
			int invAmtSumround =0;
			int billAmtSumround=0;
			if(bill_sum!=null && bill_sum.trim().length()>0 && inv_sum!=null && inv_sum.trim().length()>0)
			{	
			  double billAmtSumD=Double.parseDouble(bill_sum);
			  billAmtSumround= (int)Math.round(billAmtSumD);
			  double amtroundSumD= Double.parseDouble(inv_sum);
			  invAmtSumround = (int)Math.round(amtroundSumD);
			}
			
			valueXmlStringBuf.append("<Detail4 dbID ='"+dcrID+"' domID='1' objName='invoice_stock_aprv' objContext='4' >\r\n" );
			valueXmlStringBuf.append("<attribute pkNames='tran_id' status='N' updateFlag='A' selected='Y' />\r\n");
			valueXmlStringBuf.append( "<count_of_cust><![CDATA[" ).append(custCnt+" Customers").append( "]]></count_of_cust>\r\n" );
			//valueXmlStringBuf.append( "<bill_amt_sum><![CDATA[" ).append(bill_sum).append( "]]></bill_amt_sum>\r\n" );
			//valueXmlStringBuf.append( "<inv_amt_sum><![CDATA[" ).append(inv_sum).append( "]]></inv_amt_sum>\r\n" );
			
			valueXmlStringBuf.append( "<bill_amt_sum><![CDATA[" ).append(billAmtSumround).append( "]]></bill_amt_sum>\r\n" );
			valueXmlStringBuf.append( "<inv_amt_sum><![CDATA[" ).append(invAmtSumround).append( "]]></inv_amt_sum>\r\n" );
			valueXmlStringBuf.append("</Detail4>\r\n");
			
			int count=1;
			//Added & Commented by mrunalini sinkar for Load Number changes28 Feb 2023 :Start

			/*String countSql="select sc.pay_mode as MODE_PAYMENT,(CASE WHEN sc.pay_mode='C' THEN 'CASH' \r\n"
					+ "WHEN sc.pay_mode='Q'THEN 'CHEQUE'"
					+ "WHEN sc.pay_mode='R' THEN 'RTGS'"
					+ "WHEN sc.pay_mode='N' THEN 'NEFT'"
					+ "ELSE 'UPI' END) AS pay_mode, " + 
					"count(sc.pay_mode) count, " + 
					"sum(round(SC.AMOUNT)) AS AMOUNT from strg_meet_collect sc,strg_meet sm where " + 
					"sm.tran_id=sc.tran_id and sm.strg_code=sc.strg_code and sm.event_date=? " + 
					"and sm.sales_pers=? group by sc.pay_mode";
			PreparedStatement pstmtCount = connectionObject.prepareStatement(countSql);
			pstmtCount.setTimestamp( 1, java.sql.Timestamp.valueOf(eventDt));
			pstmtCount.setString( 2, SalesPersonCode);*/
			
			
			String countSql="select sc.pay_mode as MODE_PAYMENT,(CASE WHEN sc.pay_mode='C' THEN 'CASH' "
					+ "WHEN sc.pay_mode='Q'THEN 'CHEQUE' "
					+ "WHEN sc.pay_mode='R' THEN 'RTGS' "
					+ "WHEN sc.pay_mode='N' THEN 'NEFT' "
					+ "ELSE 'UPI' END) AS pay_mode, " + 
					"count(sc.pay_mode) count, " + 
					"sum(round(SC.AMOUNT)) AS AMOUNT from strg_meet_collect sc,strg_meet sm where " + 
					"sm.tran_id=sc.tran_id and sm.strg_code=sc.strg_code and sm.dcr_id IN("+dcrIdInForm+") " + 
					" group by sc.pay_mode";
			//Added & Commented by mrunalini sinkar for Load Number changes28 Feb 2023 :Start

			PreparedStatement pstmtCount = connectionObject.prepareStatement(countSql);
			ResultSet rsCount = pstmtCount.executeQuery();
			System.out.println("Sanket Changes");
			while(rsCount.next())
			{
				String payMode=checkNull(rsCount.getString("pay_mode"));
				int payCount =rsCount.getInt("count");
				int payAmount =rsCount.getInt("AMOUNT");
				valueXmlStringBuf.append("<Detail5 dbID ='"+dcrID+"' domID='"+count+"' objName='invoice_stock_aprv' objContext='5' >\r\n" );
				valueXmlStringBuf.append("<attribute pkNames='tran_id' status='N' updateFlag='A' selected='Y' />\r\n");
				valueXmlStringBuf.append( "<line_no><![CDATA[" ).append(count).append( "]]></line_no>\r\n" );
				valueXmlStringBuf.append( "<paymode><![CDATA[" ).append(payMode).append( "]]></paymode>\r\n" );
				valueXmlStringBuf.append( "<paycount><![CDATA[" ).append(payCount).append( "]]></paycount>\r\n" );
				valueXmlStringBuf.append( "<payamount><![CDATA[" ).append(payAmount).append( "]]></payamount>\r\n" );
				valueXmlStringBuf.append("<host_url><![CDATA[" ).append(CommonConstants.TOMCAT_HOME).append( "]]></host_url>\r\n" );
				valueXmlStringBuf.append("</Detail5>\r\n");
				count++;
			}
			rsCount.close();
			rsCount = null;
			pstmtCount.close();
			pstmtCount = null;

			valueXmlStringBuf.append("</Header0>\r\n");
			valueXmlStringBuf.append("</group0>\r\n");
			valueXmlStringBuf.append("</DocumentRoot>\r\n");

			String xmlString = valueXmlStringBuf.toString();
			System.out.println("All xml after all change of sql in workflw::"+xmlString);
			try
			{
				//retString = genWorkflow.invokeWorkflow(connectionObject, dcrID, "", "invoice_stock_aprv", xmlString, SalesPersonCode);
				retString = genWorkflow.invokeWorkflow(connectionObject, dcrIdWf, "", "invoice_stock_aprv", xmlString, SalesPersonCode);
				System.out.println("retstring sfter invoke workflow on submit::"+retString);
				if(retString != null && "success".equalsIgnoreCase(retString))
				{
					connectionObject.commit();

				}
				else
				{
					connectionObject.rollback();
				}
			}
			catch(Exception ee)
			{
				try
				{
					if(connectionObject != null)
					{
						connectionObject.rollback();
					}
				}
				catch(Exception ex)
				{
					throw new ITMException(ex);
				}
				ee.printStackTrace();
			}
		}	
		catch(Exception e)
		{
			System.out.println("Exception :StrgMeetDCRWizConf for submit :==>\n"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally {

			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				System.out.println("Exception :StrgMeetDCRWizConf for submit in finally:==>\n"+e.getMessage());
				e.printStackTrace();
				throw new ITMException(e);
			}

		}
		return tranIdList;
	}
	//Added By Bhagyashri T for instance Workflow changes for LBCP customer Start 11-11-22
	/* Commented by prachi on 08-07-2022 [W22DJOH004]
		private void updateSurveyStat(String dcrID,Connection conn) throws SQLException
	    {
		//CHANGES ADDED BY PRACHI  on 200622 [W22CJOH003]
		PreparedStatement pStmt = null;
		PreparedStatement pstmtUpd = null;
		ResultSet rs = null;
        String sqlSuv ="SELECT DISTINCT(STRG_CODE) AS STRG_CODE FROM STRG_SURV_RES WHERE DCR_ID=?";
        pStmt = conn.prepareStatement( sqlSuv );
		pStmt.setString( 1, dcrID);		
		rs = pStmt.executeQuery();
		while(rs.next())
		{
			String strgCode = checkNull(rs.getString("STRG_CODE"));
			System.out.println("survey changes dcr_id::["+dcrID+"] strg_code::["+strgCode+"]");
			
			String updSql1 ="UPDATE STRG_SURV_RES SET SURV_STATUS='Y' WHERE DCR_ID=? AND STRG_CODE=?";
			
			pstmtUpd = conn.prepareStatement(updSql1);
			pstmtUpd.setString(1, dcrID);
			pstmtUpd.setString(2, strgCode);
			
			int upCount = pstmtUpd.executeUpdate();
			System.out.println("upCount::["+upCount+"]");
			if( pstmtUpd != null )
			{
				pstmtUpd.close();
				pstmtUpd = null;
			}
			
           String updSql2 ="UPDATE STRG_SURV_RES SET SURV_STATUS='N' WHERE DCR_ID<>? AND STRG_CODE=? AND SURV_STATUS = 'Y'";
			
			pstmtUpd = conn.prepareStatement(updSql2);
			pstmtUpd.setString(1, dcrID);
			pstmtUpd.setString(2, strgCode);
			
			int upCount1 = pstmtUpd.executeUpdate();
			System.out.println("upCount1::["+upCount1+"]");
			if( pstmtUpd != null )
			{
				pstmtUpd.close();
				pstmtUpd = null;
			}
		}
		if(rs != null)
		{
			rs.close();
			rs = null;
		}
		if( pStmt != null )
		{
			pStmt.close();
			pStmt = null;
		}
		//END		
	}
	*/
	private String updateIssueQty1(String salesPers, String eventDate, String dcrId, Connection conn) throws ITMException
	{

		HashMap hMap = new HashMap();
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		PreparedStatement pstmt1 = null;
		ResultSet rs1 = null;
		String errString = "";
		E12GenericUtility genericUtility = null;
		String itemCode="";
		String scCode = "";
		int index = 0 ;
		HashMap []parentMap = null;
		HashMap parentMap1 = null;
		int parentMapSize = 0 ;
		int issueQty  = 0 ;
		String unit = "";
		String lineNo="";
		String siteCode = "";
		SampleStockInvtraceUpd updateStockEntry = new SampleStockInvtraceUpd();
		StockUpdate stockUpdate = new StockUpdate();
		String xtraParams = "";
		String selQuerySprsItem = "" ;
		PreparedStatement pStmtSprsItem = null;
		ResultSet rsSprsItem = null;
		String updQuery = "" ;
		PreparedStatement pStmtUpd = null;
		PreparedStatement pstmtItem = null; //added by bhagyashri for open connection issue[01/06/2022]
		PreparedStatement pStmtSprsItemUpd = null;
		int result = 0;
		String sprsItemUpdQuery = "";
		Timestamp tranDate = null,effDate=null;
		try
		{
			String loginSite = "";

			String siteSql="SELECT EMP_SITE FROM EMPLOYEE WHERE EMP_CODE = ?";
			pstmt = conn.prepareStatement(siteSql);
			pstmt.setString(1,salesPers);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				loginSite=checkNull(rs.getString("EMP_SITE"));
			}
			if (rs != null)
			{
				rs.close();
				rs = null ;
			}
			if (pstmt != null)
			{
				pstmt.close();
				pstmt = null ;
			}
			
			genericUtility = new E12GenericUtility();
			Timestamp workDate = java.sql.Timestamp.valueOf(eventDate);
			xtraParams = "userId="+salesPers+"~~termId=SYSTEM";

			String siteCodeQuery = "SELECT EMPLOYEE.EMP_SITE SITE_CODE FROM  EMPLOYEE WHERE EMPLOYEE.EMP_CODE =?";
			PreparedStatement pstmtSiteCode = conn.prepareStatement(siteCodeQuery);
			pstmtSiteCode.setString(1,salesPers);
			ResultSet rsSiteCode = pstmtSiteCode.executeQuery();

			if (rsSiteCode.next())
			{
				siteCode = rsSiteCode.getString("site_code");
			}
			if (rsSiteCode != null)
			{
				rsSiteCode.close();
				rsSiteCode = null ;
			}
			if (pstmtSiteCode != null)
			{
				pstmtSiteCode.close();
				pstmtSiteCode = null ;
			}

			String selQuery =  "SELECT COUNT(*) CNT FROM  " + 
					" (SELECT  ITEM_CODE, QUANTITY AS QUANTITY FROM strg_meet_invoice " + 
					" WHERE DCR_ID = ? ) MEET_INVOICE , ITEM " + 
					" WHERE ITEM.ITEM_CODE = MEET_INVOICE.ITEM_CODE";
			pstmt = conn.prepareStatement(selQuery);
			pstmt.setString(1, dcrId);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				parentMapSize = rs.getInt("CNT");
			}
			if (rs != null )
			{
				rs.close();
				rs = null ;
			}
			if (pstmt != null )
			{
				pstmt.close();
				pstmt = null ;
			}
			
			String selQuery1 =  "select event_date from sprs_act_tran where dcr_id = ? ";
			pstmt = conn.prepareStatement(selQuery1);
			pstmt.setString(1, dcrId);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				tranDate = rs.getTimestamp("event_date");
			}
			if (rs != null )
			{
				rs.close();
				rs = null ;
			}
			if (pstmt != null )
			{
				pstmt.close();
				pstmt = null ;
			}

			if ( parentMapSize > 0 )
			{
				parentMap = new HashMap[parentMapSize] ;

				System.out.println("Inside dcrID===========>"+dcrId);
				String selectMeetItemSql = "SELECT SMI.TRAN_ID AS TRAN_ID, SMI.LINE_NO AS LINE_NO, SMI.ITEM_CODE AS ITEM_CODE"
						+ ",SMI.QUANTITY AS QUANTITY,STRG_CODE,UNIT,SMI.RATE AS RATE FROM strg_meet_invoice SMI,ITEM ITEM " + 
						" WHERE DCR_ID = ? AND SMI.ITEM_CODE = ITEM.ITEM_CODE ";
				pstmtItem =  conn.prepareStatement(selectMeetItemSql);
				pstmtItem.setString(1, dcrId);

				/*selQuerySprsItem = " SELECT ITEM_CODE,CASE WHEN QUANTITY IS NULL THEN 0 ELSE QUANTITY END AS QUANTITY, "+
						" CASE WHEN ISSUE_QTY IS NULL THEN 0 ELSE ISSUE_QTY END AS ISSUE_QTY "+
						" FROM SPRS_ITEM WHERE SALES_PERS = ? AND ITEM_CODE = ? ";
				pStmtSprsItem = conn.prepareStatement(selQuerySprsItem);
*/
				//updQuery = "UPDATE SPRS_ITEM SET ISSUE_QTY = NVL(ISSUE_QTY,0) + ?, REPLY_STATUS = '0'  WHERE SALES_PERS = ?  AND ITEM_CODE = ? ";

				//sprsItemUpdQuery = "UPDATE SPRS_ITEM SET STATUS = (CASE WHEN ((CASE WHEN QUANTITY IS NULL THEN 0 ELSE QUANTITY END) - (CASE WHEN ISSUE_QTY IS NULL THEN 0 ELSE ISSUE_QTY END)) > 0 THEN 'Y' ELSE 'N' END) WHERE SALES_PERS = ?  AND ITEM_CODE = ? " ;

				ResultSet selectResult=pstmtItem.executeQuery();
				while(selectResult.next())
				{
					int sprsItemIssQty = 0;
					int sprsItemQty  = 0 ;
					itemCode = "";
					String sprsItemCode = "" ;
					String lotNo="",lotSl="";

					itemCode = selectResult.getString("ITEM_CODE");
					issueQty = selectResult.getInt("QUANTITY");
					scCode = selectResult.getString("STRG_CODE");
					unit = selectResult.getString("UNIT");
					lineNo = selectResult.getString("LINE_NO");
					String rate = selectResult.getString("RATE");
					String tranId = selectResult.getString("TRAN_ID");
	
					System.out.println("issueQty ==="+issueQty);
					System.out.println("issueQty ==="+issueQty);
					
					String stockSql="SELECT LOT_NO,LOT_SL FROM STOCK WHERE SITE_CODE= ? AND ITEM_CODE= ? AND LOC_CODE = ?";
					pstmt1 = conn.prepareStatement(stockSql);
					pstmt1.setString(1,loginSite);
					pstmt1.setString(2,itemCode);
					pstmt1.setString(3,salesPers);
					rs1 = pstmt1.executeQuery();
					if(rs1.next())
					{
						lotNo=rs1.getString("LOT_NO");
						lotSl=rs1.getString("LOT_SL");
					}
					if (rs1 != null)
					{
						rs1.close();
						rs1 = null ;
					}
					if (pstmt1 != null)
					{
						pstmt1.close();
						pstmt1 = null ;
					}
					if(lotNo.trim().length() == 0)
					{
						lotNo=" ";
					}
					if(lotSl.trim().length() == 0)
					{
						lotSl=" ";
					}	
					
					//hMap.put("line_no"," ");
					hMap.put("item_code",itemCode);
					hMap.put("loc_code",salesPers);
					hMap.put("lot_no",lotNo);
					hMap.put("lot_sl",lotSl);
					hMap.put("unit",unit);
					hMap.put("quantity",(new Integer(issueQty).doubleValue()));
					hMap.put("rate","0");


					hMap.put("site_code",loginSite);
					
					hMap.put("acct_code_inv","");
					hMap.put("cctr_code_inv","");
					hMap.put("tran_type","ID");	
					hMap.put("tran_date", tranDate);
					hMap.put("tran_ser","FG01");
					hMap.put("tran_id",tranId);
					hMap.put("acct_code__cr","");
					hMap.put("acct_code__dr","");
					hMap.put("cctr_code__cr","");
					hMap.put("cctr_code__dr","");
					lineNo= "    "+lineNo;
					lineNo = lineNo.substring(lineNo.length()-4, lineNo.length());
					hMap.put("line_no",lineNo);
					hMap.put("qty_stduom",issueQty);
					hMap.put("no_art","0");
					hMap.put("inv_stat","SALE");
					hMap.put("item_ser","R-DCR");
					hMap.put("grade","");
					hMap.put("gross_rate",rate);				
					hMap.put("gross_weight","0");
					hMap.put("tare_weight","0");
					hMap.put("conv__qty_stduom","0");	
					hMap.put("alloc_qty", new Double(0));
					errString	= stockUpdate.updateStock(hMap,xtraParams, conn);
					System.out.println("errString ===="+errString);
					if(errString !=null && errString.trim().length() >0)  
					{
											
						return errString;
					}
										
				}
				
				if(selectResult!=null)
				{	
					selectResult.close();
					selectResult=null;
				}
				if(pstmtItem!=null)
				{	
					pstmtItem.close();
					pstmtItem = null;
				}
				
			}	
		}
		catch(Exception e)
		{
			//e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(rs!=null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(pstmtItem!=null)
				{
					pstmtItem.close();
					pstmtItem = null;
				}
				if(pStmtSprsItem!=null)
				{
					pStmtSprsItem.close();
					pStmtSprsItem = null;
				}
				if(pStmtUpd!=null)
				{
					pStmtUpd.close();
					pStmtUpd = null;
				}
				if(pStmtSprsItemUpd!=null)
				{
					pStmtSprsItemUpd.close();
					pStmtSprsItemUpd = null;
				}				
			}
			catch (Exception e)
			{
				throw new ITMException(e);
			}
		}

		System.out.println("errString is :--"+errString);
		return errString;
	}
	// Added by sanket D on 02-06-23 for get pricelist
	public String getPriceList(Connection conn,PreparedStatement pstmt,ResultSet rs,String dcrIdInForm) throws SQLException {
		String sql = " select DISTINCT price_list from strg_meet where dcr_id  IN ("+dcrIdInForm+")";
		ArrayList<String > arrayList = new ArrayList<>();
		pstmt = conn.prepareStatement(sql);
		rs = pstmt.executeQuery();
		while(rs.next())
		{
			String pricelist = rs.getString("price_list");
			arrayList.add(pricelist);
		}
		String formattedList = new OrgStructure().getFormattedList(arrayList);
		System.out.println("Formated List "+formattedList);
		return formattedList;	
	}
}