package ibase.webitm.ejb.wsfa.masters;

import ibase.ejb.*;
import ibase.system.config.*;
import ibase.webitm.ejb.*;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;

import java.io.*;
import java.rmi.RemoteException;
import java.sql.*;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.*;

import javax.ejb.*;
import javax.naming.InitialContext;
import javax.xml.parsers.*;
import org.w3c.dom.*;

import com.sybase.jaguar.jdmk.SYBASE_Easnew_MIB;
//import oracle.jdbc.driver.OraclePreparedStatement; 

@Stateless
public class StrgCustomerAmdEJB extends ValidatorEJB 
{
	E12GenericUtility genericUtility = new E12GenericUtility();
	protected static String database = CommonConstants.DB_NAME;

	public String wfValData() throws RemoteException, ITMException
	{
		return "";
	}

	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = null;
		try
		{
			System.out.println("xmlString in wfvaldata:"+xmlString);
			System.out.println("xmlString1 in wfvaldata:"+xmlString1);
			System.out.println("xmlString2 in wfvaldata:"+xmlString2);

			if(xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString); 
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1); 
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2); 
			}
			errString = wfValData(dom, dom1, dom2, objContext, editFlag, xtraParams);
			System.out.println("ErrString: " + errString);
		}
		catch(Exception e)
		{
			System.out.println("Exception: StrgCustomer: wfValData(String xmlString): " + e.getMessage() + ":");
			errString = genericUtility.createErrorString(e);
			e.printStackTrace();
		}
		System.out.println("Returning from StrgCustomer wfValData");
		return (errString); 
	}

	public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		System.out.println("Inside wfValData of Strg Customer Amd");
		String userId = "";
		String errString = "";
		Connection connectionObject = null;		
		PreparedStatement pstmt = null;
		ResultSet rs = null;

		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;
		String childNodeName = null;

		int ctr = 0;
		int noOfChilds = 0;
		int currentFormNo = 0;
		try
		{
			connectionObject = getConnection(); 
			userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			parentList = dom.getElementsByTagName("Detail" + currentFormNo);
			parentNode = parentList.item(0);
			childList = parentNode.getChildNodes();
			noOfChilds = childList.getLength();
			for(ctr = 0; ctr < noOfChilds; ctr++)
			{
				childNode = childList.item(ctr);
				childNodeName = childNode.getNodeName();
				System.out.println("childNodeName in validation strg_customer_amd::"+childNodeName);
				switch(currentFormNo)
				{
				case 1:
					//Added by Mrunalini Sinkar on 01-Dec-2017 for validation on sc Code,qualification_ca,email_addr_ca,mobile_no_ca,name,city_ca,pin_ca,locality_code_ca,address fields [StrgCustomer Amendment Menu(W16DSUN004)]-----(start)

					if ("sc_code".equalsIgnoreCase(childNodeName))
					{
						if(childNode.getFirstChild() == null)				
						{
							errString =  getErrorString("sc_code","NULLSCCODE",userId);
							break;
						}
						else
						{
							String strgCustInitiator = genericUtility.getColumnValue("strg_cust__initiator",dom);
							strgCustInitiator = (strgCustInitiator == null) ?"":strgCustInitiator.trim();

							//System.out.println("strgCustInitiator is:"+strgCustInitiator);

							int scCodeCount=0;
							String scCode = genericUtility.getColumnValue("sc_code",dom);
							scCode = (scCode == null) ?"":scCode.trim();
							//System.out.println("scCode is::"+scCode);
							//String sql="SELECT COUNT(*) AS COUNT FROM STRG_CUSTOMER SC, STRG_SERIES SS WHERE SS.SALES_PERS IN(SELECT EMP_CODE FROM EMPLOYEE WHERE REPORT_TO= ?) AND SS.STATUS='Y' AND SS.SC_CODE=SC.SC_CODE AND SC.SC_CODE=? ";
							String sql="SELECT COUNT(*) AS COUNT FROM STRG_CUSTOMER SC, STRG_SERIES SS WHERE SS.SALES_PERS IN (SELECT EMP_CODE  FROM EMPLOYEE START WITH EMP_CODE = ? CONNECT BY PRIOR EMP_CODE = REPORT_TO ) AND SS.STATUS='Y' AND SS.SC_CODE=SC.SC_CODE AND SC.SC_CODE=? ";
							pstmt = connectionObject.prepareStatement(sql);
							pstmt.setString(1, strgCustInitiator);
							pstmt.setString(2, scCode);

							rs = pstmt.executeQuery();
							if(rs.next())
							{
								scCodeCount=rs.getInt("COUNT");
							}
							if(pstmt!=null)
							{
								pstmt.close();
								pstmt=null;
							}
							if(rs!=null)
							{
								rs.close();
								rs=null;
							}
							if(scCodeCount==0)
							{
								errString =  getErrorString("sc_code","INVASCCODE",userId);
								break;

							}
							String tranIDs ="";
							String sql1="SELECT MAX(TRAN_ID) AS TRAN_ID FROM STRG_CUSTOMER_AMD WHERE SC_CODE=? ";
							pstmt = connectionObject.prepareStatement(sql1);
							pstmt.setString(1, scCode);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								tranIDs=checkNull(rs.getString("TRAN_ID")).trim();
							}
							if(pstmt!=null)
							{
								pstmt.close();
								pstmt=null;
							}
							if(rs!=null)
							{
								rs.close();
								rs=null;
							}
							String tranIdDom = genericUtility.getColumnValue("tran_id",dom);
							//System.out.println("tranIDs is as::["+tranIDs+"]");
							//System.out.println("tranIdDom is as::["+tranIdDom+"]");
							if( !tranIdDom.trim().equalsIgnoreCase(tranIDs) &&!"null".equalsIgnoreCase(tranIDs) && tranIDs != null && tranIDs.length() > 0 )
							{
								//System.out.println("Inside tranIdDom");
								if(tranIDs != null && tranIDs.length() > 0 &&!"null".equalsIgnoreCase(tranIDs))
								{
									String confirm="";
									String wfStatus="";
									String sql2="SELECT CONFIRM,WF_STATUS FROM STRG_CUSTOMER_AMD WHERE SC_CODE=? AND TRAN_ID=? ";
									pstmt = connectionObject.prepareStatement(sql2);
									pstmt.setString(1, scCode);
									pstmt.setString(2, tranIDs);
									rs = pstmt.executeQuery();
									if(rs.next())
									{
										confirm=checkNull(rs.getString("CONFIRM"));
										wfStatus=checkNull(rs.getString("WF_STATUS"));
									}
									if(pstmt!=null)
									{
										pstmt.close();
										pstmt=null;
									}
									if(rs!=null)
									{
										rs.close();
										rs=null;
									}
									//System.out.println("confirm is as::["+confirm+"]");
									//System.out.println("wfStatus is as::["+wfStatus+"]");
									if(confirm != null && confirm.length() > 0 && "Y".equalsIgnoreCase(confirm) && !"A".equalsIgnoreCase(wfStatus))
									{
										errString = getErrorString("sc_code","TRANINWRK",userId);
										break;
									}
								}
							}
							String firstName = genericUtility.getColumnValue("first_name_ca",dom);
							String middleName = genericUtility.getColumnValue("middle_name_ca",dom);
							String lastName = genericUtility.getColumnValue("last_name_ca",dom);
							String city = genericUtility.getColumnValue("city_ca",dom);
							String locality = genericUtility.getColumnValue("locality_code_ca",dom);
							String  qualification= genericUtility.getColumnValue("qualification_ca",dom);
							String addr1 = genericUtility.getColumnValue("addr1_ca",dom);
							String addr2 = genericUtility.getColumnValue("addr2_ca",dom);
							String addr3 = genericUtility.getColumnValue("addr3_ca",dom);
							String pin = genericUtility.getColumnValue("pin_ca",dom);
							String mobileNo = genericUtility.getColumnValue("mobile_no_ca",dom);
							String emaillId = genericUtility.getColumnValue("email_addr_ca",dom);
							System.out.println("firstName:["+firstName+"]locality::["+locality+"]qualification::["+qualification+"]");
							if(firstName==null&middleName==null&&lastName==null&city==null&&locality==null&qualification==null&&addr1==null&addr2==null&&addr3==null&pin==null&&mobileNo==null&emaillId==null)
							{
								errString =  getErrorString("sc_code","ALLBLANK",userId);
								break;

							}


						}

					}						
					else if("qualification_ca".equalsIgnoreCase(childNodeName))
					{
						if (childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null && !"null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue()) && childNode.getFirstChild().getNodeValue().trim().length() > 0)
						{
							int qualificationCount=0;
							
							String qualification = checkNull(genericUtility.getColumnValue("qualification_ca",dom));
							System.out.println("qualification is::"+qualification);
							qualification = (qualification == null) ?"":qualification.trim();

							System.out.println("qualification after trim is::"+qualification);
							String sql="SELECT COUNT(*) AS COUNT FROM QUALIFICATION WHERE TYPE ='MEDICAL' and SH_DESCR='"+qualification+"'";
							pstmt = connectionObject.prepareStatement(sql);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								qualificationCount=rs.getInt("COUNT");
							}
							if(pstmt!=null)
							{
								pstmt.close();
								pstmt=null;
							}
							if(rs!=null)
							{
								rs.close();
								rs=null;
							}
							if(qualificationCount==0)
							{
								errString =  getErrorString("qualification_ca","INVALQUAN",userId);
								break;

							}
							String oldQual = checkNull(genericUtility.getColumnValue("qualification",dom));
							oldQual = (oldQual == null) ?"":oldQual.trim();
							System.out.println("oldQual is::"+oldQual);
							if(qualification.equalsIgnoreCase(oldQual))
							{
								errString = getErrorString("qualification_ca","QUALSAME",userId);
								break;
							}


						}
					}
					else if("locality_code_ca".equalsIgnoreCase(childNodeName))
					{
						System.out.println("Inside Locality_code_ca");
						if (childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null && !"null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue()) && childNode.getFirstChild().getNodeValue().trim().length() > 0)
						{
							System.out.println("Inside Locality_code_ca not equal to null or blank");
							int localityCount=0;
							String locality= checkNull(genericUtility.getColumnValue("locality_code_ca",dom));
							locality = (locality == null) ?"":locality.trim();
							String SpCode= checkNull(genericUtility.getColumnValue("strg_cust__initiator",dom));
							SpCode = (SpCode == null) ?"":SpCode.trim();
							System.out.println("locality after trim is as ::"+locality+"SpCode after trim is as::"+SpCode);
							//String sql="SELECT COUNT(*) AS COUNT FROM SPRS_ROUTE WHERE LOCALITY_CODE='"+locality+"' AND SPRS_CODE IN(SELECT EMP_CODE FROM EMPLOYEE WHERE REPORT_TO='"+SpCode+"') AND STATUS='Y' ";
							String sql="SELECT COUNT(*) AS COUNT FROM SPRS_ROUTE WHERE LOCALITY_CODE='"+locality+"' AND SPRS_CODE IN (SELECT EMP_CODE  FROM EMPLOYEE START WITH EMP_CODE = '"+SpCode+"' CONNECT BY PRIOR EMP_CODE = REPORT_TO ) AND STATUS='Y' ";
							pstmt = connectionObject.prepareStatement(sql);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								localityCount=rs.getInt("COUNT");
							}
							if(pstmt!=null)
							{
								pstmt.close();
								pstmt=null;
							}
							if(rs!=null)
							{
								rs.close();
								rs=null;
							}
							if(localityCount==0)
							{
								errString =  getErrorString("locality_code_ca","INVALLOC",userId);
								break;

							}

							String oldLocalityCode=checkNull(genericUtility.getColumnValue("locality_code", dom));
							oldLocalityCode = (oldLocalityCode == null) ?"":oldLocalityCode.trim();
							System.out.println("Old locality code is as ::["+locality+"]");
							if(locality.equalsIgnoreCase(oldLocalityCode))
							{
								errString = getErrorString("locality_code_ca","LOCASAME",userId);
								break;
							}

						}
					}
					else if("email_addr_ca".equalsIgnoreCase(childNodeName))
					{
						if (childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null && !"null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue()) && childNode.getFirstChild().getNodeValue().trim().length() > 0)
						{
							String emailAddr = checkNull(genericUtility.getColumnValue("email_addr_ca", dom));
							emailAddr = (emailAddr == null) ?"":emailAddr.trim();

							System.out.println("email_addr ::::["+emailAddr+"]");
							boolean isEmail = true;
							String ePattern = "^[a-zA-Z0-9.!#$%&'*+/=?^_`{|}~-]+@((\\[[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\])|(([a-zA-Z\\-0-9]+\\.)+[a-zA-Z]{2,}))$";
							if(emailAddr != null )
							{
								isEmail = emailAddr.matches(ePattern);
								if(!(isEmail))
								{
									errString = getErrorString("email_addr_ca","INVDEMAILD",userId);
									break;
								}
							}
							String oldemailAddr=checkNull(genericUtility.getColumnValue("email_addr", dom));
							oldemailAddr = (oldemailAddr == null) ?"":oldemailAddr.trim();
							if(oldemailAddr.equalsIgnoreCase(emailAddr))
							{
								errString = getErrorString("email_addr_ca","EMAILSAME",userId);
								break;
							}


						}
					}
					else if("mobile_no_ca".equalsIgnoreCase(childNodeName))
					{
						if (childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null && !"null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue()) && childNode.getFirstChild().getNodeValue().trim().length() > 0)
						{
							String phoneNo = checkNull(genericUtility.getColumnValue("mobile_no_ca", dom));
							phoneNo = (phoneNo == null) ?"":phoneNo.trim();
							System.out.println("phone::::["+phoneNo+"]");

							if(phoneNo.length() < 10 || phoneNo.length() > 10 || phoneNo.startsWith("0"))
							{
								System.out.println("Invalid PHONE no.....");
								errString = getErrorString("mobile_no_ca","INVDPHNLNO",userId);
								break;
							}
							String oldPhoneNo=checkNull(genericUtility.getColumnValue("mobile_no", dom));
							oldPhoneNo = (oldPhoneNo == null) ?"":oldPhoneNo.trim();
							if(oldPhoneNo.equalsIgnoreCase(phoneNo))
							{
								errString = getErrorString("mobile_no_ca","MOBNOSAME",userId);
								break;
							}

						}
					}
					else if("first_name_ca".equalsIgnoreCase(childNodeName))
					{
						if (childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null && !"null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue()) && childNode.getFirstChild().getNodeValue().trim().length() > 0)
						{
							String oldFirstName=checkNull(genericUtility.getColumnValue("first_name", dom));
							oldFirstName=oldFirstName.trim();
							String oldMiddleName=checkNull(genericUtility.getColumnValue("middle_name", dom));
							oldMiddleName=oldMiddleName.trim();
							String oldLastName=checkNull(genericUtility.getColumnValue("last_name", dom));
							oldLastName=oldLastName.trim();
							String oldName=oldFirstName+" "+oldMiddleName+" "+oldLastName;

							String NewFirstName=checkNull(genericUtility.getColumnValue("first_name_ca", dom));
							NewFirstName=NewFirstName.trim();
							String NewMiddleName=checkNull(genericUtility.getColumnValue("middle_name_ca", dom));
							NewMiddleName=NewMiddleName.trim();
							String NewLastName=checkNull(genericUtility.getColumnValue("last_name_ca", dom));
							NewLastName=NewLastName.trim();
							String NewName=NewFirstName+" "+NewMiddleName+" "+NewLastName;

							if(oldName.equalsIgnoreCase(NewName))
							{
								errString = getErrorString("first_name_ca","NAMESAME",userId);
								break;
							}

						}
					}
					else if("addr1_ca".equalsIgnoreCase(childNodeName))
					{
						if (childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null && !"null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue()) && childNode.getFirstChild().getNodeValue().trim().length() > 0)
						{
							String newAddr1=checkNull(genericUtility.getColumnValue("addr1_ca", dom));
							newAddr1 = (newAddr1 == null) ?"":newAddr1.trim();
							System.out.println("newAddr1 ONE IS["+newAddr1+"]");
							String oldAddr1=checkNull(genericUtility.getColumnValue("addr1", dom));
							System.out.println("oldAddr1 ONE IS["+oldAddr1+"]");
							oldAddr1 = (oldAddr1 == null) ?"":oldAddr1.trim();

							if(newAddr1.equalsIgnoreCase(oldAddr1))
							{
								errString = getErrorString("addr1_ca","FADDRSAME",userId);
								break;
							}

						}
					}
					else if("addr2_ca".equalsIgnoreCase(childNodeName))
					{
						if (childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null && !"null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue()) && childNode.getFirstChild().getNodeValue().trim().length() > 0)
						{
							String newAddr2=checkNull(genericUtility.getColumnValue("addr2_ca", dom));
							newAddr2 = (newAddr2 == null) ?"":newAddr2.trim();
							System.out.println("newAddr2 is["+newAddr2+"]");
							String oldAddr2=checkNull(genericUtility.getColumnValue("addr2", dom));
							System.out.println("oldAddr2 is["+oldAddr2+"]");

							oldAddr2 = (oldAddr2 == null) ?"":oldAddr2.trim();

							if(newAddr2.equalsIgnoreCase(oldAddr2))
							{
								errString = getErrorString("addr1_ca","SADDRSAME",userId);
								break;
							}

						}
					}
					else if("addr3_ca".equalsIgnoreCase(childNodeName))
					{
						if (childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null && !"null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue()) && childNode.getFirstChild().getNodeValue().trim().length() > 0)
						{
							String newAddr3=checkNull(genericUtility.getColumnValue("addr3_ca", dom));
							newAddr3 = (newAddr3 == null) ?"":newAddr3.trim();
							System.out.println("newAddr3 is["+newAddr3+"]");

							String oldAddr3=checkNull(genericUtility.getColumnValue("addr3", dom));
							oldAddr3 = (oldAddr3 == null) ?"":oldAddr3.trim();
							System.out.println("oldAddr3 is["+oldAddr3+"]");

							if(newAddr3.equalsIgnoreCase(oldAddr3))
							{
								errString = getErrorString("addr3_ca","TADDRSAME",userId);
								break;
							}

						}
					}
					else if("pin_ca".equalsIgnoreCase(childNodeName))
					{
						if (childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null && !"null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue()) && childNode.getFirstChild().getNodeValue().trim().length() > 0)
						{
							String newPin=checkNull(genericUtility.getColumnValue("pin_ca", dom));
							newPin = (newPin == null) ?"":newPin.trim();
							String oldPin=checkNull(genericUtility.getColumnValue("pin", dom));
							oldPin = (oldPin == null) ?"":oldPin.trim();

							if(newPin.equalsIgnoreCase(oldPin))
							{
								errString = getErrorString("pin_ca","PINSAME",userId);
								break;
							}

						}
					}
					else if("emp_ho".equalsIgnoreCase(childNodeName))
					{
						if(childNode.getFirstChild() == null)				
						{
							errString =  getErrorString("emp_ho","NULLEMPHO",userId);
							break;
						}
					}
					if ("confirm".equalsIgnoreCase(childNodeName))
					{
						//System.out.println("Inside confirm column");
						String confirm=checkNull(genericUtility.getColumnValue("confirm", dom));
						confirm = (confirm == null) ?"":confirm.trim();
						//System.out.println("Inside confirm column value is::"+confirm);
						if(!confirm.equalsIgnoreCase("Y"))
						{
							errString = getErrorString("confirm","NTCONFIRM",userId);
							break;
						}
					}
					
//Added by Mrunalini Sinkar on 01-Dec-2017 for validation on sc Code,qualification_ca,email_addr_ca,mobile_no_ca,name,city_ca,pin_ca,locality_code_ca,address fields [StrgCustomer Amendment Menu(W16DSUN004)]-----(end)
					break;

				}

				if (errString != null && errString.trim().length()>0)
				{
					break;
				}
			}
		}
		catch(Exception se)
		{
			System.out.println("Exception: StrgCustomer: wfValData(Document dom): " + se.getMessage() + ":");
			errString = genericUtility.createErrorString(se);
		}
		finally
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if ( connectionObject != null )
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{
				throw new ITMException(e);
			}			
		}
		return (errString);
	}
	
	public String itemChanged() throws RemoteException, ITMException
	{
		return "";
	}

	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = null;
		try
		{
			if (xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString); 
			}
			if (xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1); 
			}
			if (xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2); 
			}
			errString = itemChanged(dom, dom1, dom2, objContext, currentColumn, editFlag, xtraParams);
			System.out.println ("ErrString :" + errString);
		}
		catch (Exception e)
		{
			System.out.println ("Exception :StrgCustomer :itemChanged(String,String):" + e.getMessage() + ":");
			errString = genericUtility.createErrorString(e);
		}
		System.out.println ("returning from StrgCustomer itemChanged");
		return errString;
	}

	public String itemChanged(Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		System.out.println("STRG CUSTOMER AMD EJB ITEMCHANGE");
		String columnValue = "";
		String logInEmpCode = "";
		String sql=null;
		Connection connectionObject = null;		
		PreparedStatement pstmt = null;
        ResultSet rs = null;
        String tranID = "";
		StringBuffer valueXmlString = new StringBuffer();

		int currentFormNo = 0;
		try
		{
			connectionObject = getConnection();
			columnValue = genericUtility.getColumnValue(currentColumn,dom);
			logInEmpCode = getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode");
			logInEmpCode=logInEmpCode.trim();
			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}

			DateFormat dtFormat = new SimpleDateFormat(getApplDateFormat());
			java.util.Date date = Calendar.getInstance().getTime(); 
			String chgDateAdd = dtFormat.format( date );
			String chgTerm = checkNull(genericUtility.getValueFromXTRA_PARAMS(xtraParams,"termId"));

			valueXmlString = new StringBuffer("<?xml version=\"1.0\" encoding='UTF-8'?>\r\n<Root>\r\n<Header>\r\n<editFlag>");
			valueXmlString.append(editFlag).append("</editFlag>\r\n</Header>\r\n");
			System.out.println("currentFormNo ["+currentFormNo+"] currentColumn ["+currentColumn+"]");
			String itmSer=getItemSer(logInEmpCode,connectionObject);
			String empHo=getDivisionHO(itmSer, connectionObject);
			switch (currentFormNo)
			{
			case 1:
					//Added by sachin satre on [21-Feb-18] for on Edit mode emp_ho not set [start]
					//System.out.println("Inside case first::["+logInEmpCode+"]");
					String empName="";
					if(logInEmpCode != null && logInEmpCode.trim().length()>0 && !"null".equalsIgnoreCase(logInEmpCode))
					{
	
						sql="SELECT TRIM(EMP_FNAME)||' '||TRIM(EMP_LNAME) AS INITIATOR FROM EMPLOYEE WHERE EMP_CODE='"+logInEmpCode+"'";
						pstmt=connectionObject.prepareStatement(sql);
						rs=pstmt.executeQuery();
						if(rs.next())
						{
							empName=checkNull(rs.getString("INITIATOR"));
						}
						if(pstmt!=null)
						{
							pstmt.close();
							pstmt=null;
						}
						if(rs!=null)
						{
							rs.close();
							rs=null;
						}
					}
					System.out.println("empName Of Login emp code::"+empName);
					//Added by sachin satre on [21-Feb-18] for on Edit mode emp_ho not set [end]
					//Added By Bhagyashri t For Locality change[04/APR/2022][START]
					String salesPersName="";
					String salesPers = checkNull(genericUtility.getColumnValue("strg_cust__initiator", dom2, "1"));
					//System.out.println("salesPersfirst is::["+salesPers+"]");
					salesPers=salesPers.replaceAll("[^a-zA-Z0-9_-]", "");
					//System.out.println("salesPersfirst is final::["+salesPers+"]");
					String itmSerS ="";
					String empHoS ="";
					if(salesPers != null && salesPers.trim().length()>0 && !"null".equalsIgnoreCase(salesPers))
					{
						itmSerS=getItemSer(salesPers,connectionObject);
						empHoS=getDivisionHO(itmSerS, connectionObject);
					}
                    
					if(salesPers != null && salesPers.trim().length()>0 && !"null".equalsIgnoreCase(salesPers))
					{
	
						sql="SELECT TRIM(EMP_FNAME)||' '||TRIM(EMP_LNAME) AS INITIATOR FROM EMPLOYEE WHERE trim(EMP_CODE)='"+salesPers+"'";
						pstmt=connectionObject.prepareStatement(sql);
						rs=pstmt.executeQuery();
						if(rs.next())
						{
							salesPersName=checkNull(rs.getString("INITIATOR"));
						}
						if(pstmt!=null)
						{
							pstmt.close();
							pstmt=null;
						}
						if(rs!=null)
						{
							rs.close();
							rs=null;
						}
					}
                	System.out.println("salesPersName is as::"+salesPersName);
                	//Added By Bhagyashri t For Locality change[04/APR/2022][END]
					//Added by Mrunalini Sinkar on 01-Dec-2017 for itm_default  [StrgCustomer Amendment Menu(W16DSUN004)]-----(start)
					if (currentColumn.trim().equalsIgnoreCase("itm_default"))
					{	
	
						//String empName="";
						//System.out.println("Inside Itm Default of strgcustomer amd");
                        String scCode = checkNull(genericUtility.getColumnValue("sc_code", dom2, "1"));
    					//System.out.println("scCodeFirst is::["+scCode+"]");
                        scCode=scCode.replaceAll("[^a-zA-Z0-9_-]", "");
                        System.out.println("scCode is::["+scCode+"]salesPers is:["+salesPers+"]");
                        if(scCode != null && scCode.trim().length()>0)
                        {
                            sql="SELECT * FROM STRG_CUSTOMER WHERE SC_CODE='"+scCode+"'";
		                	pstmt = connectionObject.prepareStatement(sql);
			                rs=pstmt.executeQuery();
			                if(rs.next())
			                {
				                String firstName=checkNull(rs.getString("FIRST_NAME"));
	                            String lastName=checkNull(rs.getString("LAST_NAME"));
	                            String middleName=checkNull(rs.getString("MIDDLE_NAME"));
	                            String addressAs=checkNull(rs.getString("ADDRESS_AS"));
	                            String prefix=checkNull(rs.getString("PREFIX"));
	                            String qualification=checkNull(rs.getString("QUALIFICATION"));
	                            String addr1=checkNull(rs.getString("ADDR1"));
	                            String addr2=checkNull(rs.getString("ADDR2"));
	                            String addr3=checkNull(rs.getString("ADDR3"));
	                            String city=checkNull(rs.getString("CITY"));
	                            String district=checkNull(rs.getString("DISTRICT"));
	                            String stanCode=checkNull(rs.getString("STAN_CODE"));
	                            String stateCode=checkNull(rs.getString("STATE_CODE"));
	                            String pin=checkNull(rs.getString("PIN"));
	                            String countCode=checkNull(rs.getString("COUNT_CODE"));
	                            String tele1=checkNull(rs.getString("TELE1"));
	                            String tele2=checkNull(rs.getString("TELE2"));
	                            String tele3=checkNull(rs.getString("TELE3"));
	                            String fax=checkNull(rs.getString("FAX"));
	                            String mobileNo=checkNull(rs.getString("MOBILE_NO"));
	                            String status=checkNull(rs.getString("STATUS"));
	                            String visitTimeFr=checkNull(rs.getString("VISIT_TIME_FR"));
	                            String visitTimeTo=checkNull(rs.getString("VISIT_TIME_TO"));
	                            int visitNo=rs.getInt("VISIT_NO");
	                            int noVisit=rs.getInt("NO_VISIT");
	                            int noPatientsDay=rs.getInt("NO_PATIENT_DAY");
	                            String sex=checkNull(rs.getString("SEX"));
	                            String birthDate=checkNull(rs.getString("BIRTH_DATE"));
	                            String addedDate=checkNull(rs.getString("ADDED_DATE"));
	                            String addedSource=checkNull(rs.getString("ADDED_SOURCE"));
	                            String classCode=checkNull(rs.getString("CLASS_CODE"));
	                            String sector=checkNull(rs.getString("SECTOR"));
	                            String resAddr1=checkNull(rs.getString("RES_ADDR1"));
	                            String resAddr2=checkNull(rs.getString("RES_ADDR2"));
	                            String resAddr3=checkNull(rs.getString("RES_ADDR3"));
	                            String resCity=checkNull(rs.getString("RES_CITY"));
	                            String resStanCode=checkNull(rs.getString("RES_STAN_CODE"));
	                            String resStateCode=checkNull(rs.getString("RES_STATE_CODE"));
	                            String resPin=checkNull(rs.getString("RES_PIN"));
	                            String resCountCode=checkNull(rs.getString("RES_COUNT_CODE"));
	                            int practicingSince=rs.getInt("PRACTICING_SINCE");
	                            String internetUser=checkNull(rs.getString("INTERNET_USER"));
	                            String preferdComm=checkNull(rs.getString("PREFERRED_COMM"));
	                            String emailAddr=checkNull(rs.getString("EMAIL_ADDR"));
	                            int totalBusiness=rs.getInt("TOTAL_BUSINESS");
	                            int businessToUs=rs.getInt("BUSINESS_TO_US");
	                            String comments=checkNull(rs.getString("COMMENTS"));
	                            String weddAniv=checkNull(rs.getString("WEDD_ANIV"));
	                            String districtRes=checkNull(rs.getString("DISTRICT_RES"));
	                            String districtOff=checkNull(rs.getString("DISTRICT_OFF"));
	                            String regNo=checkNull(rs.getString("REG_NO"));
	                            String regDate=checkNull(rs.getString("REG_DATE"));
	                            String resTele1=checkNull(rs.getString("RES_TELE1"));
	                            String resTele2=checkNull(rs.getString("RES_TELE2"));
	                            String deactDate=checkNull(rs.getString("DEACT_DATE"));
	                            String localityCode=checkNull(rs.getString("LOCALITY_CODE"));
	                            String resLocalityCode=checkNull(rs.getString("RES_LOCALITY_CODE"));
	                            String custCode=checkNull(rs.getString("CUST_CODE"));
	                            String acctCodeAp=checkNull(rs.getString("ACCT_CODE__AP"));
	                            String cctrCodeAp=checkNull(rs.getString("CCTR_CODE__AP"));
	                            String delvAddr1=checkNull(rs.getString("DELV_ADDR1"));
	                            String delvAddr2=checkNull(rs.getString("DELV_ADDR2"));
	                            String delvAddr3=checkNull(rs.getString("DELV_ADDR3"));
	                            String delvCity=checkNull(rs.getString("DELV_CITY"));
	                            String delvDistrict=checkNull(rs.getString("DELV_DISTRICT"));
	                            String delvPin=checkNull(rs.getString("DELV_PIN"));
	                            String stanCodeDelv=checkNull(rs.getString("STAN_CODE__DELV"));
	                            String stateCodeDelv=checkNull(rs.getString("STATE_CODE__DELV"));
	                            String countCodeDelv=checkNull(rs.getString("COUNT_CODE__DELV"));
	                            String chqName=checkNull(rs.getString("CHQ_NAME"));
	                            String currCode=checkNull(rs.getString("CURR_CODE"));
	                            String panNo=checkNull(rs.getString("PAN_NO"));
	                            String serTaxReg=checkNull(rs.getString("SER_TAX_REG"));
	                            String investLevel=checkNull(rs.getString("INVEST_LEVEL"));
	                            String custType=checkNull(rs.getString("CUST_TYPE"));
	                            String taxClass=checkNull(rs.getString("TAX_CLASS"));
	                            String taxChap=checkNull(rs.getString("TAX_CHAP"));
	                            String taxEnv=checkNull(rs.getString("TAX_ENV"));
	                            String permStatus=checkNull(rs.getString("PERM_STATUS"));
	                            String confirm=checkNull(rs.getString("CONFIRM"));
	                            String wfStatus=checkNull(rs.getString("WF_STATUS"));
	                            String wfRejRemark=checkNull(rs.getString("WF_REJ__REMARK"));
	                            String otherRemark=checkNull(rs.getString("OTHER_REMARK"));
	                            int noAttachments=rs.getInt("NO_ATTACHMENTS");
	                            int noComments=rs.getInt("NO_COMMENTS");
	                            String siteCodePay=checkNull(rs.getString("SITE_CODE__PAY"));
	                            String mktInfluence=checkNull(rs.getString("MKT_INFLUNCE"));
	                            String assoType=checkNull(rs.getString("ASSO_TYPE"));
	                            String category=checkNull(rs.getString("CATEGORY"));
	
	                            valueXmlString.append("<Detail1 domId ='1'>\r\n");
	                            valueXmlString.append("<strg_cust__initiator>").append("<![CDATA["+salesPers+"]]>").append("</strg_cust__initiator>");
	                            valueXmlString.append("<initiator>").append("<![CDATA["+salesPersName+"]]>").append("</initiator>");
	                            if(tranID != null && tranID.length() > 0)
		                        {
		                            valueXmlString.append("<tran_id><![CDATA[" ).append(tranID).append( "]]></tran_id>");
		                        }
		                        else
		                        {
		                            tranID = generateTranID(connectionObject);
		                            valueXmlString.append("<tran_id><![CDATA[" ).append(tranID).append( "]]></tran_id>");
		                        }
	                            valueXmlString.append("<sc_code protect='1'><![CDATA[" ).append(scCode).append( "]]></sc_code>");
	                            valueXmlString.append("<first_name protect='1'><![CDATA[" ).append(firstName).append( "]]></first_name>");
	                            valueXmlString.append("<middle_name protect='1'><![CDATA[" ).append(middleName).append( "]]></middle_name>");
	                            valueXmlString.append("<last_name protect='1'><![CDATA[" ).append(lastName).append( "]]></last_name>");
	                            valueXmlString.append("<address_as><![CDATA[" ).append(addressAs).append( "]]></address_as>");
	                            valueXmlString.append("<prefix><![CDATA[" ).append(prefix).append( "]]></prefix>");
	                            valueXmlString.append("<qualification protect='1'><![CDATA[" ).append(qualification).append( "]]></qualification>");
	                            valueXmlString.append("<addr1 protect='1'><![CDATA[" ).append(addr1).append( "]]></addr1>");
	                            valueXmlString.append("<addr2 protect='1'><![CDATA[" ).append(addr2).append( "]]></addr2>");
	                            valueXmlString.append("<addr3 protect='1'><![CDATA[" ).append(addr3).append( "]]></addr3>");
	                            valueXmlString.append("<city protect='1'><![CDATA[" ).append(city).append( "]]></city>");
	                            valueXmlString.append("<district><![CDATA[" ).append(district).append( "]]></district>");
	                            valueXmlString.append("<stan_code><![CDATA[" ).append(stanCode).append( "]]></stan_code>");
	                            valueXmlString.append("<state_code><![CDATA[" ).append(stateCode).append( "]]></state_code>");
	                            valueXmlString.append("<pin protect='1'><![CDATA[" ).append(pin).append( "]]></pin>");
	                            valueXmlString.append("<count_code><![CDATA[" ).append(countCode).append( "]]></count_code>");
	                            valueXmlString.append("<tele1><![CDATA[" ).append(tele1).append( "]]></tele1>");
	                            valueXmlString.append("<tele2><![CDATA[" ).append(tele2).append( "]]></tele2>");
	                            valueXmlString.append("<tele3><![CDATA[" ).append(tele3).append( "]]></tele3>");
	                            valueXmlString.append("<fax><![CDATA[" ).append(fax).append( "]]></fax>");
	                            valueXmlString.append("<mobile_no protect='1'><![CDATA[" ).append(mobileNo).append( "]]></mobile_no>");
	                            valueXmlString.append("<status><![CDATA[" ).append(status).append( "]]></status>");
	                            valueXmlString.append("<visit_time_fr><![CDATA[" ).append(visitTimeFr).append( "]]></visit_time_fr>");
	                            valueXmlString.append("<visit_time_to><![CDATA[" ).append(visitTimeTo).append( "]]></visit_time_to>");
	                            valueXmlString.append("<visit_no><![CDATA[" ).append(visitNo).append( "]]></visit_no>");
	                            valueXmlString.append("<no_visit><![CDATA[" ).append(noVisit).append( "]]></no_visit>");
	                            valueXmlString.append("<no_patient_day><![CDATA[" ).append(noPatientsDay).append( "]]></no_patient_day>");
	                            valueXmlString.append("<sex><![CDATA[" ).append(sex).append( "]]></sex>");
	                            valueXmlString.append("<birth_date><![CDATA[" ).append(birthDate).append( "]]></birth_date>");
	                            valueXmlString.append("<added_date><![CDATA[" ).append(addedDate).append( "]]></added_date>");
	                            valueXmlString.append("<added_source><![CDATA[" ).append(addedSource).append( "]]></added_source>");
	                            valueXmlString.append("<class_code><![CDATA[" ).append(classCode).append( "]]></class_code>");
	                            valueXmlString.append("<sector><![CDATA[" ).append(sector).append( "]]></sector>");
	                            valueXmlString.append("<res_addr1><![CDATA[" ).append(resAddr1).append( "]]></res_addr1>");
	                            valueXmlString.append("<res_addr2><![CDATA[" ).append(resAddr2).append( "]]></res_addr2>");
	                            valueXmlString.append("<res_addr3><![CDATA[" ).append(resAddr3).append( "]]></res_addr3>");
	                            valueXmlString.append("<res_city><![CDATA[" ).append(resCity).append( "]]></res_city>");
	                            valueXmlString.append("<res_stan_code><![CDATA[" ).append(resStanCode).append( "]]></res_stan_code>");
	                            valueXmlString.append("<res_state_code><![CDATA[" ).append(resStateCode).append( "]]></res_state_code>");
	                            valueXmlString.append("<res_pin><![CDATA[" ).append(resPin).append( "]]></res_pin>");
	                            valueXmlString.append("<res_count_code><![CDATA[" ).append(resCountCode).append( "]]></res_count_code>");
	                            valueXmlString.append("<practicing_since><![CDATA[" ).append(practicingSince).append( "]]></practicing_since>");
	                            valueXmlString.append("<internet_user><![CDATA[" ).append(internetUser).append( "]]></internet_user>");
	                            valueXmlString.append("<preferred_comm><![CDATA[" ).append(preferdComm).append( "]]></preferred_comm>");
	                            valueXmlString.append("<email_addr protect='1'><![CDATA[" ).append(emailAddr).append( "]]></email_addr>");
	                            valueXmlString.append("<total_business><![CDATA[" ).append(totalBusiness).append( "]]></total_business>");
	                            valueXmlString.append("<business_to_us><![CDATA[" ).append(businessToUs).append( "]]></business_to_us>");
	                            valueXmlString.append("<comments><![CDATA[" ).append(comments).append( "]]></comments>");
	                            valueXmlString.append("<wedd_aniv><![CDATA[" ).append(weddAniv).append( "]]></wedd_aniv>");
	                            valueXmlString.append("<district_off><![CDATA[" ).append(districtOff).append( "]]></district_off>");
	                            valueXmlString.append("<district_res><![CDATA[" ).append(districtRes).append( "]]></district_res>");
	                            valueXmlString.append("<reg_no><![CDATA[" ).append(regNo).append( "]]></reg_no>");
	                            valueXmlString.append("<reg_date><![CDATA[" ).append(regDate).append( "]]></reg_date>");
	                            valueXmlString.append("<res_tele1><![CDATA[" ).append(resTele1).append( "]]></res_tele1>");
	                            valueXmlString.append("<res_tele2><![CDATA[" ).append(resTele2).append( "]]></res_tele2>");
	                            valueXmlString.append("<deact_date><![CDATA[" ).append(deactDate).append( "]]></deact_date>");
	                            valueXmlString.append("<locality_code><![CDATA[" ).append(localityCode).append( "]]></locality_code>");
	                            valueXmlString.append("<res_locality_code><![CDATA[" ).append(resLocalityCode).append( "]]></res_locality_code>");
	                            valueXmlString.append("<cust_code><![CDATA[" ).append(custCode).append( "]]></cust_code>");
	                            valueXmlString.append("<acct_code__ap><![CDATA[" ).append(acctCodeAp).append( "]]></acct_code__ap>");
	                            valueXmlString.append("<cctr_code__ap><![CDATA[" ).append(cctrCodeAp).append( "]]></cctr_code__ap>");
	                            valueXmlString.append("<delv_addr1><![CDATA[" ).append(delvAddr1).append( "]]></delv_addr1>");
	                            valueXmlString.append("<delv_addr2><![CDATA[" ).append(delvAddr2).append( "]]></delv_addr2>");
	                            valueXmlString.append("<delv_addr3><![CDATA[" ).append(delvAddr3).append( "]]></delv_addr3>");
	                            valueXmlString.append("<delv_city><![CDATA[" ).append(delvCity).append( "]]></delv_city>");
	                            valueXmlString.append("<delv_district><![CDATA[" ).append(delvDistrict).append( "]]></delv_district>");
	                            valueXmlString.append("<delv_pin><![CDATA[" ).append(delvPin).append( "]]></delv_pin>");
	                            valueXmlString.append("<stan_code__delv><![CDATA[" ).append(stanCodeDelv).append( "]]></stan_code__delv>");
	                            valueXmlString.append("<state_code__delv><![CDATA[" ).append(stateCodeDelv).append( "]]></state_code__delv>");
	                            valueXmlString.append("<count_code__delv><![CDATA[" ).append(countCodeDelv).append( "]]></count_code__delv>");
	                            valueXmlString.append("<chq_name><![CDATA[" ).append(chqName).append( "]]></chq_name>");
	                            valueXmlString.append("<curr_code><![CDATA[" ).append(currCode).append( "]]></curr_code>");
	                            valueXmlString.append("<pan_no><![CDATA[" ).append(panNo).append( "]]></pan_no>");
	                            valueXmlString.append("<ser_tax_reg><![CDATA[" ).append(serTaxReg).append( "]]></ser_tax_reg>");
	                            valueXmlString.append("<invest_level><![CDATA[" ).append(investLevel).append( "]]></invest_level>");
	                            valueXmlString.append("<cust_type><![CDATA[" ).append(custType).append( "]]></cust_type>");
	                            valueXmlString.append("<tax_class><![CDATA[" ).append(taxClass).append( "]]></tax_class>");
	                            valueXmlString.append("<tax_chap><![CDATA[" ).append(taxChap).append( "]]></tax_chap>");
	                            valueXmlString.append("<tax_env><![CDATA[" ).append(taxEnv).append( "]]></tax_env>");
	                            valueXmlString.append("<perm_status><![CDATA[" ).append(permStatus).append( "]]></perm_status>");
	                            valueXmlString.append("<confirm><![CDATA[" ).append(confirm).append( "]]></confirm>");
	                            valueXmlString.append("<wf_status><![CDATA[" ).append(wfStatus).append( "]]></wf_status>");
	                            valueXmlString.append("<wf_rej__remark><![CDATA[" ).append(wfRejRemark).append( "]]></wf_rej__remark>");
	                            valueXmlString.append("<other_remark><![CDATA[" ).append(otherRemark).append( "]]></other_remark>");
	                            valueXmlString.append("<no_attachments><![CDATA[" ).append(noAttachments).append( "]]></no_attachments>");
	                            valueXmlString.append("<no_comments><![CDATA[" ).append(noComments).append( "]]></no_comments>");
	                            valueXmlString.append("<site_code__pay><![CDATA[" ).append(siteCodePay).append( "]]></site_code__pay>");
	                            valueXmlString.append("<mkt_influnce><![CDATA[" ).append(mktInfluence).append( "]]></mkt_influnce>");
	                            valueXmlString.append("<asso_type><![CDATA[" ).append(assoType).append( "]]></asso_type>");
	                            valueXmlString.append("<category><![CDATA[" ).append(category).append( "]]></category>");
	                            valueXmlString.append("<chg_date><![CDATA[" ).append(chgDateAdd).append( "]]></chg_date>");
						    	valueXmlString.append("<chg_user><![CDATA[" ).append(logInEmpCode).append( "]]></chg_user>");
							    valueXmlString.append("<chg_term><![CDATA[" ).append(chgTerm).append( "]]></chg_term>");
	                            valueXmlString.append("<emp_ho><![CDATA[" ).append(empHoS).append( "]]></emp_ho>");
							    valueXmlString.append("<item_ser><![CDATA[" ).append(itmSerS).append( "]]></item_ser>");
	                            valueXmlString.append("</Detail1>\r\n");
		                	}
			                //added by prachi on 19 May 2022
			                if ( rs != null )
							{
								rs.close();
								rs = null;
							}
							if ( pstmt != null )
							{
								pstmt.close();
								pstmt = null;
							}//end 
                        }//end sc_code if
							
						else
						{
                        	//System.out.println("Inside else of Itmdefault");
							valueXmlString.append("<Detail1 domId =\"1\">\r\n");
							//Commented by sachin satre on [21-Feb-18] for on Edit mode emp_ho not set [start]
							/*
						if(logInEmpCode != null && logInEmpCode.trim().length()>0 && !"null".equalsIgnoreCase(logInEmpCode))
						{
	
							sql="SELECT TRIM(EMP_FNAME)||' '||TRIM(EMP_LNAME) AS INITIATOR FROM EMPLOYEE WHERE EMP_CODE='"+logInEmpCode+"'";
							pstmt=connectionObject.prepareStatement(sql);
							rs=pstmt.executeQuery();
							if(rs.next())
							{
								empName=checkNull(rs.getString("INITIATOR"));
							}
							if(pstmt!=null)
							{
								pstmt.close();
								pstmt=null;
							}
							if(rs!=null)
							{
								rs.close();
								rs=null;
							}
							valueXmlString.append("<strg_cust__initiator>").append("<![CDATA["+logInEmpCode+"]]>").append("</strg_cust__initiator>");
							valueXmlString.append("<initiator>").append("<![CDATA["+empName+"]]>").append("</initiator>");
	
						}
						*/
						//Commented by sachin satre on [21-Feb-18] for on Edit mode emp_ho not set [end] 
						
						valueXmlString.append("<strg_cust__initiator>").append("<![CDATA["+logInEmpCode+"]]>").append("</strg_cust__initiator>");
                        valueXmlString.append("<initiator>").append("<![CDATA["+empName+"]]>").append("</initiator>");
                        if(tranID != null && tranID.length() > 0)
                        {
                            valueXmlString.append("<tran_id><![CDATA[" ).append(tranID).append( "]]></tran_id>");
                        }
                        else
                        {
                            tranID = generateTranID(connectionObject);
                            valueXmlString.append("<tran_id><![CDATA[" ).append(tranID).append( "]]></tran_id>");
                        }
                        //valueXmlString.append("<tran_id><![CDATA[" ).append("").append( "]]></tran_id>");
                        valueXmlString.append("<sc_code><![CDATA[" ).append("").append( "]]></sc_code>");
						valueXmlString.append("<first_name protect='1'><![CDATA[" ).append("").append( "]]></first_name>");
						valueXmlString.append("<middle_name protect='1'><![CDATA[" ).append("").append( "]]></middle_name>");
						valueXmlString.append("<last_name protect='1'><![CDATA[" ).append("").append( "]]></last_name>");
						valueXmlString.append("<address_as><![CDATA[" ).append("").append( "]]></address_as>");
						valueXmlString.append("<prefix><![CDATA[" ).append("").append( "]]></prefix>");
						valueXmlString.append("<qualification><![CDATA[" ).append("").append( "]]></qualification>");
						valueXmlString.append("<addr1><![CDATA[" ).append("").append( "]]></addr1>");
						valueXmlString.append("<addr2><![CDATA[" ).append("").append( "]]></addr2>");
						valueXmlString.append("<addr3><![CDATA[" ).append("").append( "]]></addr3>");
						valueXmlString.append("<city><![CDATA[" ).append("").append( "]]></city>");
						valueXmlString.append("<district><![CDATA[" ).append("").append( "]]></district>");
						valueXmlString.append("<stan_code><![CDATA[" ).append("").append( "]]></stan_code>");
						valueXmlString.append("<state_code><![CDATA[" ).append("").append( "]]></state_code>");
						valueXmlString.append("<pin><![CDATA[" ).append("").append( "]]></pin>");
						valueXmlString.append("<count_code><![CDATA[" ).append("").append( "]]></count_code>");
						valueXmlString.append("<tele1><![CDATA[" ).append("").append( "]]></tele1>");
						valueXmlString.append("<tele2><![CDATA[" ).append("").append( "]]></tele2>");
						valueXmlString.append("<tele3><![CDATA[" ).append("").append( "]]></tele3>");
						valueXmlString.append("<fax><![CDATA[" ).append("").append( "]]></fax>");
						valueXmlString.append("<mobile_no><![CDATA[" ).append("").append( "]]></mobile_no>");
						valueXmlString.append("<visit_time_fr><![CDATA[" ).append("").append( "]]></visit_time_fr>");
						valueXmlString.append("<visit_time_to><![CDATA[" ).append("").append( "]]></visit_time_to>");
						valueXmlString.append("<visit_no><![CDATA[" ).append("").append( "]]></visit_no>");
						valueXmlString.append("<no_visit><![CDATA[" ).append("").append( "]]></no_visit>");
						valueXmlString.append("<no_patient_day><![CDATA[" ).append("").append( "]]></no_patient_day>");
						valueXmlString.append("<sex><![CDATA[" ).append("").append( "]]></sex>");
						valueXmlString.append("<birth_date><![CDATA[" ).append("").append( "]]></birth_date>");
						valueXmlString.append("<added_date><![CDATA[" ).append("").append( "]]></added_date>");
						valueXmlString.append("<added_source><![CDATA[" ).append("").append( "]]></added_source>");
						valueXmlString.append("<class_code><![CDATA[" ).append("").append( "]]></class_code>");
						valueXmlString.append("<sector><![CDATA[" ).append("").append( "]]></sector>");
						valueXmlString.append("<res_addr1><![CDATA[" ).append("").append( "]]></res_addr1>");
						valueXmlString.append("<res_addr2><![CDATA[" ).append("").append( "]]></res_addr2>");
						valueXmlString.append("<res_addr3><![CDATA[" ).append("").append( "]]></res_addr3>");
						valueXmlString.append("<res_city><![CDATA[" ).append("").append( "]]></res_city>");
						valueXmlString.append("<res_stan_code><![CDATA[" ).append("").append( "]]></res_stan_code>");
						valueXmlString.append("<res_state_code><![CDATA[" ).append("").append( "]]></res_state_code>");
						valueXmlString.append("<res_pin><![CDATA[" ).append("").append( "]]></res_pin>");
						valueXmlString.append("<res_count_code><![CDATA[" ).append("").append( "]]></res_count_code>");
						valueXmlString.append("<practicing_since><![CDATA[" ).append("").append( "]]></practicing_since>");
						valueXmlString.append("<internet_user><![CDATA[" ).append("").append( "]]></internet_user>");
						valueXmlString.append("<preferred_comm><![CDATA[" ).append("").append( "]]></preferred_comm>");
						valueXmlString.append("<email_addr><![CDATA[" ).append("").append( "]]></email_addr>");
						valueXmlString.append("<total_business><![CDATA[" ).append("").append( "]]></total_business>");
						valueXmlString.append("<business_to_us><![CDATA[" ).append("").append( "]]></business_to_us>");
						valueXmlString.append("<comments><![CDATA[" ).append("").append( "]]></comments>");
						valueXmlString.append("<wedd_aniv><![CDATA[" ).append("").append( "]]></wedd_aniv>");
						valueXmlString.append("<district_off><![CDATA[" ).append("").append( "]]></district_off>");
						valueXmlString.append("<district_res><![CDATA[" ).append("").append( "]]></district_res>");
						valueXmlString.append("<reg_no><![CDATA[" ).append("").append( "]]></reg_no>");
						valueXmlString.append("<reg_date><![CDATA[" ).append("").append( "]]></reg_date>");
						valueXmlString.append("<res_tele1><![CDATA[" ).append("").append( "]]></res_tele1>");
						valueXmlString.append("<res_tele2><![CDATA[" ).append("").append( "]]></res_tele2>");
						valueXmlString.append("<deact_date><![CDATA[" ).append("").append( "]]></deact_date>");
						valueXmlString.append("<locality_code><![CDATA[" ).append("").append( "]]></locality_code>");
						valueXmlString.append("<res_locality_code><![CDATA[" ).append("").append( "]]></res_locality_code>");
						valueXmlString.append("<cust_code><![CDATA[" ).append("").append( "]]></cust_code>");
						valueXmlString.append("<acct_code__ap><![CDATA[" ).append("").append( "]]></acct_code__ap>");
						valueXmlString.append("<cctr_code__ap><![CDATA[" ).append("").append( "]]></cctr_code__ap>");
						valueXmlString.append("<delv_addr1><![CDATA[" ).append("").append( "]]></delv_addr1>");
						valueXmlString.append("<delv_addr2><![CDATA[" ).append("").append( "]]></delv_addr2>");
						valueXmlString.append("<delv_addr3><![CDATA[" ).append("").append( "]]></delv_addr3>");
						valueXmlString.append("<delv_city><![CDATA[" ).append("").append( "]]></delv_city>");
						valueXmlString.append("<delv_district><![CDATA[" ).append("").append( "]]></delv_district>");
						valueXmlString.append("<delv_pin><![CDATA[" ).append("").append( "]]></delv_pin>");
						valueXmlString.append("<stan_code__delv><![CDATA[" ).append("").append( "]]></stan_code__delv>");
						valueXmlString.append("<state_code__delv><![CDATA[" ).append("").append( "]]></state_code__delv>");
						valueXmlString.append("<count_code__delv><![CDATA[" ).append("").append( "]]></count_code__delv>");
						valueXmlString.append("<chq_name><![CDATA[" ).append("").append( "]]></chq_name>");
						valueXmlString.append("<curr_code><![CDATA[" ).append("").append( "]]></curr_code>");
						valueXmlString.append("<pan_no><![CDATA[" ).append("").append( "]]></pan_no>");
						valueXmlString.append("<ser_tax_reg><![CDATA[" ).append("").append( "]]></ser_tax_reg>");
						valueXmlString.append("<invest_level><![CDATA[" ).append("").append( "]]></invest_level>");
						valueXmlString.append("<cust_type><![CDATA[" ).append("").append( "]]></cust_type>");
						valueXmlString.append("<tax_class><![CDATA[" ).append("").append( "]]></tax_class>");
						valueXmlString.append("<tax_chap><![CDATA[" ).append("").append( "]]></tax_chap>");
						valueXmlString.append("<tax_env><![CDATA[" ).append("").append( "]]></tax_env>");
						valueXmlString.append("<perm_status><![CDATA[" ).append("").append( "]]></perm_status>");
						valueXmlString.append("<confirm><![CDATA[" ).append("").append( "]]></confirm>");
						valueXmlString.append("<wf_status><![CDATA[" ).append("").append( "]]></wf_status>");
						valueXmlString.append("<wf_rej__remark><![CDATA[" ).append("").append( "]]></wf_rej__remark>");
						valueXmlString.append("<other_remark><![CDATA[" ).append("").append( "]]></other_remark>");
						valueXmlString.append("<no_attachments><![CDATA[" ).append("").append( "]]></no_attachments>");
						valueXmlString.append("<no_comments><![CDATA[" ).append("").append( "]]></no_comments>");
						valueXmlString.append("<site_code__pay><![CDATA[" ).append("").append( "]]></site_code__pay>");
						valueXmlString.append("<mkt_influnce><![CDATA[" ).append("").append( "]]></mkt_influnce>");
						valueXmlString.append("<asso_type><![CDATA[" ).append("").append( "]]></asso_type>");
						valueXmlString.append("<category><![CDATA[" ).append("").append( "]]></category>");
						//valueXmlString.append("<city_ca><![CDATA[" ).append("").append( "]]></city_ca>");
						valueXmlString.append("<addr1_ca><![CDATA[" ).append("").append( "]]></addr1_ca>");
						valueXmlString.append("<addr2_ca><![CDATA[" ).append("").append( "]]></addr2_ca>");
						valueXmlString.append("<addr3_ca><![CDATA[" ).append("").append( "]]></addr3_ca>");
						valueXmlString.append("<pin_ca><![CDATA[" ).append("").append( "]]></pin_ca>");
						valueXmlString.append("<qualification_ca><![CDATA[" ).append("").append( "]]></qualification_ca>");
						valueXmlString.append("<first_name_ca><![CDATA[" ).append("").append( "]]></first_name_ca>");
						valueXmlString.append("<middle_name_ca><![CDATA[" ).append("").append( "]]></middle_name_ca>");
						valueXmlString.append("<last_name_ca><![CDATA[" ).append("").append( "]]></last_name_ca>");
						valueXmlString.append("<mobile_no_ca><![CDATA[" ).append("").append( "]]></mobile_no_ca>");
						valueXmlString.append("<email_addr_ca><![CDATA[" ).append("").append( "]]></email_addr_ca>");
						valueXmlString.append("<chg_date><![CDATA[" ).append(chgDateAdd).append( "]]></chg_date>");
						valueXmlString.append("<chg_user><![CDATA[" ).append(logInEmpCode).append( "]]></chg_user>");
						valueXmlString.append("<chg_term><![CDATA[" ).append(chgTerm).append( "]]></chg_term>");
						//valueXmlString.append("<locality_code_ca><![CDATA[" ).append("").append( "]]></locality_code_ca>");
	
						//valueXmlString.append("<stan_code_ca><![CDATA[" ).append("").append( "]]></stan_code_ca>");
						//valueXmlString.append("<state_code_ca><![CDATA[" ).append("").append( "]]></state_code_ca>");
						//valueXmlString.append("<coun_code_ca><![CDATA[" ).append("").append( "]]></coun_code_ca>");
						//valueXmlString.append("<district_off_ca><![CDATA[" ).append("").append( "]]></district_off_ca>");
	
						valueXmlString.append("<first_name_check><![CDATA[" ).append("").append( "]]></first_name_check>");
						valueXmlString.append("<middle_name_check><![CDATA[" ).append("").append( "]]></middle_name_check>");
						valueXmlString.append("<last_name_check><![CDATA[" ).append("").append( "]]></last_name_check>");
	
						valueXmlString.append("<addr1_check><![CDATA[" ).append("").append( "]]></addr1_check>");
						valueXmlString.append("<addr2_check><![CDATA[" ).append("").append( "]]></addr2_check>");
						valueXmlString.append("<addr3_check><![CDATA[" ).append("").append( "]]></addr3_check>");
						valueXmlString.append("<qual_check><![CDATA[" ).append("").append( "]]></qual_check>");
						//valueXmlString.append("<city_check><![CDATA[" ).append("").append( "]]></city_check>");
						//valueXmlString.append("<locality_check><![CDATA[" ).append("").append( "]]></locality_check>");
	
						valueXmlString.append("<pin_check><![CDATA[" ).append("").append( "]]></pin_check>");
						valueXmlString.append("<mobile_check><![CDATA[" ).append("").append( "]]></mobile_check>");
						valueXmlString.append("<email_check><![CDATA[" ).append("").append( "]]></email_check>");
						valueXmlString.append("<emp_ho><![CDATA[" ).append(empHo).append( "]]></emp_ho>");
						valueXmlString.append("<item_ser><![CDATA[" ).append(itmSer).append( "]]></item_ser>");
	
						valueXmlString.append("</Detail1>\r\n");
                    }
	
				}//end itm_default
				//Added by Mrunalini Sinkar on 01-Dec-2017 for itm_default  [StrgCustomer Amendment Menu(W16DSUN004)]-----(end)				
				//Added by sachin satre on [21-Feb-18] for on Edit mode emp_ho not set [start]
				else if (currentColumn.trim().equalsIgnoreCase("itm_defaultedit"))
				{
					//System.out.println("Inside item default edit");
					valueXmlString.append("<Detail1 domId =\"1\">\r\n");
					valueXmlString.append("<strg_cust__initiator>").append("<![CDATA["+salesPers+"]]>").append("</strg_cust__initiator>");
					valueXmlString.append("<initiator>").append("<![CDATA["+salesPersName+"]]>").append("</initiator>");
					valueXmlString.append("<chg_date><![CDATA[" ).append(chgDateAdd).append( "]]></chg_date>");
					valueXmlString.append("<chg_user><![CDATA[" ).append(logInEmpCode).append( "]]></chg_user>");
					valueXmlString.append("<chg_term><![CDATA[" ).append(chgTerm).append( "]]></chg_term>");
					valueXmlString.append("<emp_ho><![CDATA[" ).append(empHoS).append( "]]></emp_ho>");
					valueXmlString.append("<item_ser><![CDATA[" ).append(itmSerS).append( "]]></item_ser>");
					valueXmlString.append("</Detail1>\r\n");
				}
				//Added by sachin satre on [21-Feb-18] for on Edit mode emp_ho not set [end]

					break;


			}			

		}
		catch(SQLException se)
		{
			System.out.println("Exception: StrgCustomerAmd: itemChanged(Document,String): " + se.getMessage() + ":");
			valueXmlString = valueXmlString.append(genericUtility.createErrorString(se));
		}
		catch(Exception e)
		{
			System.out.println("Exception :StrgCustomerAmd :itemChanged(Document,String):" + e.getMessage() + ":");
			valueXmlString = valueXmlString.append(genericUtility.createErrorString(e));
		}
		finally 
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if ( connectionObject != null )
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{
				throw new ITMException(e);
			}
		}
		valueXmlString.append("</Root>\r\n");	
		//System.out.println("\n****ValueXmlString :" + valueXmlString + ":********");
		return valueXmlString.toString();
	}

	private String checkNull(String input)
	{
		if (input == null || "null".equalsIgnoreCase(input))		
		{
			input="";
		}
		else
		{
			input = input.trim();
		}
		return input;
	}

	//Added by Mrunalini Sinkar on 01-Dec-2017 to get HO employee [StrgCustomer Amendment Menu(W16DSUN004)]-----(start)				
	public String getDivisionHO(String itemSer,Connection conn) throws ITMException
	{
		System.out.println("In side getDivisionHO............");
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		String hoCode="";
		
		try
		{
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String sysDate = sdf.format(new java.util.Date());
			sysDate  = genericUtility.getValidDateString(sysDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateTimeFormat());
			System.out.println("itemSer:::["+itemSer+"]");
			String sql=" SELECT PARM_VALUE FROM SFAPARM WHERE ORG_UNIT =?  "+
					" AND ACTIVE='Y'  "+
					" AND PARM_NAME='STRG_CUST_HO' "+
					" AND ?  BETWEEN EFF_FROM AND VALID_UPTO ";
			pstmt = conn.prepareStatement(sql);		
			pstmt.setString(1, "X"+"_"+itemSer);
			pstmt.setTimestamp(2,java.sql.Timestamp.valueOf(sysDate));										
			rs = pstmt.executeQuery();					
			if( rs.next() )
			{
				hoCode  = checkNull(rs.getString(1));				
			}
			System.out.println("hoCode:::["+hoCode+"]");
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}						
		}
		catch (Exception e) {
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
		}
		System.out.println("hoCode..:::=["+hoCode+"]");
		return hoCode;
	}
	//Added by Mrunalini Sinkar on 01-Dec-2017 to get HO employee [StrgCustomer Amendment Menu(W16DSUN004)]-----(end)				
	
	//Added by Mrunalini Sinkar on 01-Dec-2017 to get Itemser of employee [StrgCustomer Amendment Menu(W16DSUN004)]-----(start)				
	public String getItemSer(String salesPers,Connection conn)  throws ITMException
	{
		PreparedStatement pstmt=null;
		ResultSet rs = null;
		String itemSer="";
		try
		{
			String sqlItmser="SELECT ITEM_SER FROM SALES_PERS WHERE SALES_PERS= ?";
			pstmt = conn.prepareStatement(sqlItmser);
			pstmt.setString(1, salesPers);
			rs=pstmt.executeQuery();
			if(rs.next())
			{
				itemSer=checkNull(rs.getString("ITEM_SER"));
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}	
		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
		return itemSer;
	}
	//Added by Mrunalini Sinkar on 01-Dec-2017 to get Itemser of employee [StrgCustomer Amendment Menu(W16DSUN004)]-----(end)				

	protected InitialContext getInitialContext()throws ITMException
	{
		InitialContext ctx = null;
		try
		{
			AppConnectParm appConnect = new AppConnectParm();
			ctx = new InitialContext(appConnect.getProperty());
		}
		catch(ITMException itme)
		{
			System.out.println("ITMException :[StrgCustomer] :getInitialContext :==>");
			throw itme;
		}
		catch(Exception e)
		{
			System.out.println("Exception :[StrgCustomer] :getInitialContext :==>");
			throw new ITMException(e);
		}
		return ctx;
    }
    //Changes by Jatin M to generate new Tran ID manually when itm_default is called - START
    public String generateTranID(Connection conn)
	{
		PreparedStatement pStmt = null;
		ResultSet rs = null;
		String sql = "";
		String TranIdSeq = "";
		String newTranId = null;
		try
		{

			int count = 0;
			String nextseqQuery = " SELECT STRG_CUSTOMER_AMD_SEQ.NEXTVAL AS NEW_TRAN_ID FROM DUAL ";
			pStmt = conn.prepareStatement(nextseqQuery);

			rs = pStmt.executeQuery();
			while(rs.next())
			{
				TranIdSeq = rs.getString("NEW_TRAN_ID");
			}
			int newTranIdLen = 0;

			if( TranIdSeq != null && TranIdSeq.trim().length() > 0 )
			{
				newTranId = "0000000000"+TranIdSeq;
				newTranIdLen = newTranId.trim().length();
                newTranId = newTranId.substring(newTranIdLen-10, newTranIdLen);
			}
			else
			{
				newTranId = "0000000001";
				System.out.println("Create sequence STP_TRAN_ID_SEQ [ Refer office sql ] in case duplicate tran_id issue...");
			}
			System.out.println("newTranId =["+newTranId+"]");
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pStmt != null)
			{
				pStmt.close();
				pStmt = null;
			}

		}
		catch (Exception exp)
		{
			System.out.println("Inside Exception catch [StrgCustomerAmdEJB][generateTranID]Exception:>>"+exp.getMessage());
			exp.printStackTrace();
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pStmt != null)
				{
					pStmt.close();
					pStmt = null;
				}				
			}
			catch (Exception e)
			{
				System.out.println("Inside Exception finally [StrgCustomerAmdEJB][generateTranID]Exception:>>"+e.getMessage());
				e.printStackTrace();
			}
		}
		return newTranId;
	}
  //Changes by Jatin M to generate new Tran ID manually when itm_default is called - START
}


