package ibase.webitm.bean.wsfa;

import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Vector;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.wsfa.transactions.ShowStatus;

public class ShowStatusBean implements Serializable 
{
	public String asHoliday;
	public String asLeave;
	public String user;
	public String password;
	private String path;
	private String XMLMain;
	private String profileID;
	private String empCodes;
	private String psrName;
	private String dateOfJoin;
	private String confirmationDate_Time;

	String lsXmlName,lsYearName,lsCalName,lsJanName,lsFebName,lsMarName,lsAprName,lsMayName,lsJunName,lsJulName,lsAugName,lsSepName,lsOctName,lsNovName,lsDecName;
	String CalFT,LeaveDateFT,LeaveFT,YearFT,CodeFT,JanFT,From,To;

	//Added By Ravindra C on 03-05-19 to make connection dynamic - start
	private UserInfoBean userInfoBean = null;

	public UserInfoBean getUserInfoBean() {

		return userInfoBean;
	}
	public void setUserInfoBean(UserInfoBean userInfoBean) {

		this.userInfoBean = userInfoBean;
	}
	//Added By Ravindra C on 03-05-19 to make connection dynamic - End
	public ShowStatusBean()
	{
	}
	public void setHoliday(String asHoliday)
	{
		this.asHoliday = asHoliday;
	}

	public void setLeave(String asLeave)
	{
		this.asLeave = asLeave;
	}

	public String getHoliday()
	{
		return asHoliday;
	}

	public String getLeave()
	{
		return asLeave;
	}
	public void setUser(String user)
	{
		this.user = user;
	}
	public void setPassword(String password)
	{
		this.password = password;
	}
	public String getUser()
	{
		return user;
	}
	public String getPassword()
	{
		return password;
	}

	public String getPsrName()
	{
		return this.psrName;
	}

	public String getProfileID()
	{
		if (profileID != null)
		{
			return profileID.trim();
		}
		return null;
	}
	public String getDateOfJoin()
	{
		return this.dateOfJoin;
	}
	public String getLeaveDetails(String lsEmpCode,String lsYear,String lsStartDate,String lsEndDate)
	{
		if(lsYear==null)
		{
			lsYear="2000";
		}
		else
		{
			lsYear=lsYear;
		}
		//	ibase.sfa.ejb.LeaveDetailsHome home = null;
		//ibase.sfa.ejb.LeaveDetailsRemote ejbObj = null;
		this.path = path;
		try 
		{
			String startDate = lsStartDate;
			String endDate = lsEndDate;
			
			//commented by Ravindra C on 07-05-19 for show staus related changes - start
			/*AppConnectParm appConnect = new AppConnectParm();
			Properties p = appConnect.getProperty();
			InitialContext ctx = new InitialContext(p);
			//Changed by Uday [07/05/10].Below Replace 'sunpharma' by 'ibase' 
			ejbObj = (ibase.sfa.ejb.LeaveDetailsRemote)ctx.lookup("ibase/LeaveDetails/remote");
			//ejbObj = home.create(); */
			//commented by Ravindra C on 07-05-19 for show staus related changes - end
			
			ShowStatus leaveDetails = new ShowStatus();
			XMLMain = leaveDetails.getLeaveDetails(lsEmpCode,lsYear,startDate,endDate );
			psrName= leaveDetails.getEmployeeName(lsEmpCode );
			dateOfJoin =  leaveDetails.getDateOfJoin(lsEmpCode );

			BaseLogger.log("3",null,null,"XMLMain : ["+ XMLMain +"]");
		}
		catch(Exception e)
		{
			BaseLogger.log("0",null,null,"Exception: LeaveDetails: getLeaveDetails: ==> \n"+e);
			e.printStackTrace();
		}
		return XMLMain;
	}
	//This function creates the hashtable for the different calender 
	//childs in XML file for eg: Holiday,Leave etc etc., that is passed as an argument to this function.
	public Hashtable getNewHashCalender(String XMLString)throws Exception
	{
		String lsArrayHol[]= new String[13];

		String strData = "";
		int iMon=0;
		String lsFrom="",lsTo="";
		Hashtable hstVecVals = new Hashtable();
		try
		{
			DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
			DocumentBuilder db = dbf.newDocumentBuilder();
			//Changed by Nazia on 7/30/2008[To use UTF-8 encoding WS89SUN004]start
			//Document doc = db.parse(new ByteArrayInputStream(XMLString.getBytes()));
			ByteArrayInputStream bais = new ByteArrayInputStream(XMLString.getBytes("UTF-8"));
			Document doc = db.parse(bais);
			//Changed by Nazia on 7/30/2008[To use UTF-8 encoding WS89SUN004]end

			NodeList nlRoot = doc.getElementsByTagName("ROOT");
			Node ndCal = nlRoot.item(0).getChildNodes().item(0); //give calendar tag
			NodeList nlCalChilds=ndCal.getChildNodes(); //leave,holiday etc tags

			for(int iCal=0; iCal<nlCalChilds.getLength(); iCal++)
			{
				Vector vecDetail = new Vector();
				String strEvent = nlCalChilds.item(iCal).getNodeName();
				NodeList nlMonthChilds=nlCalChilds.item(iCal).getChildNodes();

				for(int iCal1=0; iCal1<nlMonthChilds.getLength(); iCal1++)
				{
					String strMonth = nlCalChilds.item(iCal).getChildNodes().item(iCal1).getNodeName();
					NodeList nlDateChilds=nlMonthChilds.item(iCal1).getChildNodes();
					for(int iCal2=0; iCal2<nlDateChilds.getLength(); iCal2++)
					{
						String strDateAdded = nlMonthChilds.item(iCal1).getChildNodes().item(iCal2).getNodeName();
						strDateAdded = strDateAdded.substring(1,strDateAdded.length());
						Node ndDate = nlMonthChilds.item(iCal1).getChildNodes().item(iCal2);
						String strDateValue = ndDate.getFirstChild().getNodeValue();
						String getActivities ="'"+strMonth+"',"+strDateAdded+",'"+strDateValue+"','"+ndDate.getChildNodes().item(1)+"','"+ndDate.getChildNodes().item(2)+"'";
						vecDetail.addElement(getActivities);
					}   
				}
				hstVecVals.put(strEvent,vecDetail);
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			BaseLogger.log("0",null,null,"Exception in LeaveDetailsBeans :["+ e.getMessage() +"]");
		}
		return 	hstVecVals;
	}

	public String getLastDateOfMonth(String month,String year)
	{
		String months[] = {"Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"};

		int intMonth = 0;
		//getting integer related to month		
		for(int i=0; i<months.length; i++)
		{
			if(months[i].equalsIgnoreCase(month))
				intMonth = i ;
		}
		Calendar cal = Calendar.getInstance();
		cal.set(Integer.parseInt(year),intMonth,1);
		cal.add(Calendar.MONTH,1); 
		cal.set(Calendar.DATE,0); 
		String strMon = (new Integer(intMonth+1).toString());
		return cal.get(Calendar.DATE) +"/" + ( ( strMon.length() == 1) ? ("0"+strMon) : strMon)+ "/" +year.substring(2);
	}

	//Modified by Santosh on [09/05/2013][1.) To solve the issue of weekly off color not getting in show status in russian server 2.) Made overloaded method with addition default string object][Start]	
	public String getLeaveDetails(String lsEmpCode,String lsYear,String lsStartDate,String lsEndDate, String defaultStr)
	{
		if(lsYear==null)
		{
			lsYear="2000";
		}
		else
		{
			lsYear=lsYear;
		}
		//	ibase.sfa.ejb.LeaveDetailsHome home = null;
		//ibase.sfa.ejb.LeaveDetailsRemote ejbObj = null;
		this.path = path;
		try 
		{
			String startDate = lsStartDate;
			String endDate = lsEndDate;

			//commented By Ravindra C on 03-05-19 to make connection dynamic - start
			/*AppConnectParm appConnect = new AppConnectParm();
			Properties p = appConnect.getProperty();
			InitialContext ctx = new InitialContext(p);

			Changed by Uday [07/05/10].Below Replace 'sunpharma' by 'ibase' 
			ejbObj = (ibase.sfa.ejb.LeaveDetailsRemote)ctx.lookup("ibase/LeaveDetails/remote");
			ejbObj = home.create(); */
			//Commented By Ravindra C on 03-05-19 to make connection dynamic - End

			//Added By Ravindra C on 03-05-19 to make connection dynamic - start
			ShowStatus leaveDetails = new ShowStatus();
			leaveDetails.setUserInfoBean( userInfoBean );
			XMLMain = leaveDetails.getLeaveDetails(lsEmpCode,lsYear,startDate,endDate,"");

			psrName= leaveDetails.getEmployeeName(lsEmpCode );
			dateOfJoin =  leaveDetails.getDateOfJoin(lsEmpCode);
			//Added By Ravindra C on 03-05-19 to make connection dynamic - start

			BaseLogger.log("3",null,null,"XMLMain : ["+ XMLMain +"]");
		}
		catch(Exception e)
		{
			BaseLogger.log("0",null,null,"Exception: LeaveDetails: getLeaveDetails: ==> \n"+e);
			e.printStackTrace();
		}
		return XMLMain;
	}
	//Modified by Santosh on [09/05/2013][1.) To solve the issue of weekly off color not getting in show status in russian server 2.) Made overloaded method with addition default string object][End]
	
	//Added BY Ravindra C on 27-06-19 to get Item_ser against login user emp_code. - Start
	public String getItemSer( String salesPer ) throws SQLException
	{
		String itmSer ="";
		Connection connection = null;
		String sql ="";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		ConnDriver conndriver = new ConnDriver();
		try
		{
			BaseLogger.log("3",null,null,"userInfoBean : ["+ userInfoBean +"]");
			if( userInfoBean !=null )
			{
				String transDB = userInfoBean.getTransDB();
				connection = conndriver.getConnectDB(transDB);
			}
			sql = "SELECT ITEM_SER FROM SALES_PERS WHERE SALES_PERS = ?";
			BaseLogger.log("3",null,null,"sql of item Ser :--> ["+sql);
			pstmt =  connection.prepareStatement(sql);
			pstmt.setString(1, salesPer);
			rs = pstmt.executeQuery();	
			if( rs.next() )
			{
				itmSer  = rs.getString("ITEM_SER");
			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			if(connection !=null)
			{
				connection.close();
				connection = null;
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			System.out.println("In the getItemSer Exception : ["+ e.getMessage() +"]");
		}
		finally
		{
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			if(connection !=null)
			{
				connection.close();
				connection = null;
			}
		}
		return itmSer;
	}
	//Added BY Ravindra C on 27-06-19 to get Item_ser against login user emp_code. - End
	
	//Added by Ravindra C on 22-11-19 for analysis report related migration- Start
	public boolean checkDateConfirmation( String salesPer, String workDate, UserInfoBean userInfo ) throws SQLException
	{
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		
		try 
		{
			ConnDriver connDriver = null;
			connDriver = new ConnDriver();
			String transDB =  userInfo.getTransDB();
			if( transDB.trim().length() > 0 )
			{
				conn = connDriver.getConnectDB( transDB );
			}
			connDriver = null;
			String getTempCont =    
					"SELECT DISTINCT A.ACTIVITY_CODE, A.DESCR,C.WORK_DATE,A.ACTIVITY_TYPE FROM FIELDACTIVITY A, DR_TRAVEL_DETAILS C, DR_MAIN DR "
					+ "WHERE C.SALES_PERS = DR.SALES_PERS AND C.WORK_DATE = DR.WORK_DATE AND C.ACTIVITY_CODE    = A.ACTIVITY_CODE AND "
					+ "C.ACTIVITY_CODE  = A.ACTIVITY_CODE AND DR.CONFIRMATION_FLAG = 'Y' AND C.SALES_PERS = ? AND C.WORK_DATE  = ?";      
					
			
			System.out.println("getTempCont --> ["+ getTempCont +"]");
			pstmt = conn.prepareStatement(getTempCont);
			pstmt.setString(1, salesPer);
			pstmt.setString(2, workDate);
			rs = pstmt.executeQuery();
			
			if (rs.next())
			{
				return true;
			}
			rs.close();
			pstmt.close();
			conn.close();
		} 
		catch (Exception e) 
		{
			BaseLogger.log("0", userInfo,  null,"In the Exception Catch Block==> ["+ e.getMessage()+"]");
		}
		finally
		{
			try
			{
				if(rs!=null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(conn!=null)
				{
					conn.close();
					conn = null;
				}
			} 
			catch (Exception e1) 
			{
				e1.printStackTrace();
			}
		}
		return false;
	}
	//Added by Ravindra C on 22-11-19 for analysis report related migration- End
	
}
