/**
 * 
 */
package ibase.webitm.servlet.wsfa;

import ibase.system.config.AppConnectParm;
import ibase.utility.CommonConstants;

import ibase.webitm.bean.wsfa.StrgMeetWizardBean;
import ibase.webitm.utility.ITMException;


import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;

import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class ActivityServlet extends HttpServlet 
{
	InitialContext ctx = null;
	public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		 doPost( request, response );
	}
    
	public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		System.out.println("XXXXXXXXXXXXXXXXXXXXXX[ActivityServlet]XXXXXXXXXXXXXXXXXXXX");
		ServletOutputStream outputStream = null;
		HttpSession sess = null;
		String responseStr ="";
		try 
		{  
			String workDate=request.getParameter("EVENT_DATE"); 
			String salesPers=request.getParameter("SALES_PERS");
			String objName= (request.getParameter("OBJ_NAME")==null) ?"":request.getParameter("OBJ_NAME").trim();
			System.out.println(" WORK_DATE = ["+workDate+"] \n SALES_PERSON =["+salesPers+"] OBJ_NAME=["+objName+"]");
			sess = request.getSession();
			System.out.println( "\nsess.getId() :["+sess.getId()+"]" );	
			if(ctx == null)
			{
				ctx = getInitialContext();  
			}
			
			if("wsfa_zuvius_dsr_wiz".equalsIgnoreCase(objName))
			{
				StrgMeetWizardBean dsrWizbean = new StrgMeetWizardBean(); 
				responseStr = dsrWizbean.getActivityDescr(salesPers, workDate);
			}
			
            System.out.println("returnXMLString=["+responseStr+"]");
            response.setContentType("text/xml");

			if(CommonConstants.CONTENT_ENCODING != null && CommonConstants.CONTENT_ENCODING.equalsIgnoreCase("gzip"))
			{
				response.setHeader("Content-Encoding", "gzip");
				GZIPOutputStream gzOutStream = new GZIPOutputStream(response.getOutputStream());
				gzOutStream.write(responseStr.getBytes());
				gzOutStream.flush();
				gzOutStream.close();
			}
			else
			{
				response.setHeader("Content-Encoding", "");
				OutputStream outStream = response.getOutputStream();
				outStream.write(responseStr.getBytes());
				outStream.flush();
				outStream.close();
			}
			System.out.println("****** ActivityServlet call end successfully ***********");
            
		}
		catch (Exception e)
		{
			e.printStackTrace();
	        System.out.println("Exception :ActivityServlet: doPost :==>");
	        try 
	        {
				throw new ITMException(e);
			} 
	        catch (ITMException e1) 
	        {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			}
			
		}
		catch (Error er)
		{
			System.out.println("Inside error");
			er.printStackTrace();
			
		}
	
	}
	protected InitialContext getInitialContext()throws ITMException
	{
		InitialContext ctx = null;
		try
		{
			AppConnectParm appConnect = new AppConnectParm();
			ctx = new InitialContext(appConnect.getProperty());
		}
		catch(ITMException itme)
		{
			System.out.println("ITMException :[ActivityServlet] :getInitialContext :==>");
			throw itme;
		}
		catch(Exception e)
		{
			System.out.println("Exception :[ActivityServlet] :getInitialContext :==>");
			throw new ITMException(e);
		}
		return ctx;
	}
}
