/*
 * Decompiled with CFR 0.152.
 */
package ibase.communication;

import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12EvaluateExpression;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.TransIDGenerator;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SMSComm
extends ValidatorEJB {
    private SMSType smsType;
    private String smsURL;
    HashMap smsParamMap = null;
    String tblName = "SMSPARAM";
    String prmValue = "PARAM_VALUE";
    String prmName = "PARAM_NAME";
    String toParamName = "";
    String textParamName = "";
    String xmlString = "";
    String entityCode = "";
    String entityType = "";
    String formatCode = "";
    String objName = "";
    String senderID = "";
    String templateIdName = "";
    String smsTextType = "";
    String inputVariable = "inputVariable";
    String smsApiKeyName = "";
    private String appHashCode;
    private String serviceProviderUrl = "";
    UserInfoBean userInfoBean = null;
    private String templateKeyName = "";
    E12GenericUtility genericUtility = new E12GenericUtility();

    public String sendSMS() throws ITMException {
        return "";
    }

    public String sendSMS(String xmlString, String formatCode, String xtraParams, UserInfoBean userInfoBean) throws ITMException {
        return this.sendSMS(xmlString, formatCode, xtraParams, SMSType.TRANSACTIONAL, userInfoBean);
    }

    public String sendSMS(String xmlString, String formatCode, String xtraParams, SMSType smsType, UserInfoBean userInfoBean) throws ITMException {
        String messageStr;
        block30: {
            HttpURLConnection connection;
            boolean isError;
            String resposeStr;
            block29: {
                this.smsType = smsType;
                resposeStr = "";
                messageStr = "SEND_SUCCESS";
                isError = false;
                connection = null;
                try {
                    try {
                        this.userInfoBean = userInfoBean;
                        this.xmlString = xmlString;
                        this.setUserInfo(userInfoBean);
                        Document smsDom = this.genericUtility.parseString(xmlString);
                        this.formatCode = this.genericUtility.getColumnValue("format_code", smsDom, "1");
                        this.appHashCode = this.genericUtility.getColumnValue("APP_HASH", smsDom);
                        System.out.println((Object)((Object)this.smsType) + " this.smsType :: E12SMSComp :: sendSMS() : " + this.appHashCode);
                        if (this.formatCode == null || this.formatCode.trim().length() == 0) {
                            this.formatCode = formatCode;
                        }
                        this.objName = this.getObjNameFromDom(smsDom, "objName");
                        if (this.evaluateExpression(userInfoBean)) {
                            this.ConfigureSMSParam();
                            String transDB = userInfoBean.getTransDB();
                            String mobileNo = E12GenericUtility.checkNull((String)((String)this.smsParamMap.get(this.toParamName)));
                            String smsText = E12GenericUtility.checkNull((String)((String)this.smsParamMap.get(this.textParamName)));
                            String tempId = E12GenericUtility.checkNull((String)((String)this.smsParamMap.get(this.templateIdName)));
                            BaseLogger.log((String)"3", (UserInfoBean)userInfoBean, null, (Object)("this.smsParamMap ::" + this.smsParamMap));
                            if (mobileNo != null && mobileNo.trim().length() > 0 && !"null".equalsIgnoreCase(mobileNo) && (smsText != null && smsText.trim().length() > 0 && !"null".equalsIgnoreCase(smsText) || tempId != null && tempId.trim().length() > 0)) {
                                DBAccessEJB dbAccess = new DBAccessEJB();
                                String smsURL = "";
                                smsURL = this.serviceProviderUrl.contains("2factor") ? this.fillPlaceHolders(this.serviceProviderUrl) : this.buildSMSURL();
                                BaseLogger.log((String)"3", (UserInfoBean)userInfoBean, null, (Object)("smsURL: [" + smsURL + "] "));
                                URL smsServiceURL = new URL(smsURL);
                                connection = (HttpURLConnection)smsServiceURL.openConnection();
                                if (this.smsType == SMSType.TRANSACTIONAL && "T".equalsIgnoreCase(this.smsTextType)) {
                                    connection.setRequestProperty("Content-Type", "application/json");
                                    connection.setRequestProperty(this.smsApiKeyName, (String)this.smsParamMap.get(this.smsApiKeyName));
                                }
                                connection.setConnectTimeout(15000);
                                connection.setReadTimeout(15000);
                                String proxyHost = dbAccess.getDBColumnValue(this.tblName, this.prmValue, String.valueOf(this.prmName) + " ='PROXY_HOST'", transDB);
                                String proxyPort = dbAccess.getDBColumnValue(this.tblName, this.prmValue, String.valueOf(this.prmName) + " ='PROXY_PORT'", transDB);
                                String proxyUser = dbAccess.getDBColumnValue(this.tblName, this.prmValue, String.valueOf(this.prmName) + " ='PROXY_USER'", transDB);
                                String proxyPswd = dbAccess.getDBColumnValue(this.tblName, this.prmValue, String.valueOf(this.prmName) + " ='PROXY_PSWD'", transDB);
                                Properties systemSettings = System.getProperties();
                                systemSettings.put("http.proxyHost", proxyHost);
                                systemSettings.put("http.proxyPort", proxyPort);
                                String encodedUserPwd = Base64.getEncoder().encodeToString((String.valueOf(proxyUser) + ":" + proxyPswd).getBytes());
                                connection.setRequestProperty("Proxy-Authorization", "Basic " + encodedUserPwd);
                                connection.setRequestMethod("POST");
                                connection.setRequestProperty("Content-Length", Integer.toString(smsURL.getBytes().length));
                                connection.setDoOutput(true);
                                connection.setDoInput(true);
                                connection.setUseCaches(false);
                                connection.connect();
                                String urlParameters = "";
                                if (this.smsType == SMSType.TRANSACTIONAL && "T".equalsIgnoreCase(this.smsTextType)) {
                                    urlParameters = (String)this.smsParamMap.get(this.inputVariable);
                                } else if (smsURL.indexOf("?") != -1) {
                                    urlParameters = smsURL.substring(smsURL.indexOf("?") + 1);
                                }
                                BaseLogger.log((String)"3", (UserInfoBean)userInfoBean, null, (Object)("urlParameters ::" + urlParameters));
                                DataOutputStream wr = new DataOutputStream(connection.getOutputStream());
                                wr.writeBytes(urlParameters);
                                wr.flush();
                                wr.close();
                                try {
                                    InputStream in1 = connection.getInputStream();
                                    InputStreamReader isr = new InputStreamReader(in1);
                                    StringBuffer buffer = new StringBuffer();
                                    int letter = 0;
                                    while ((letter = isr.read()) != -1) {
                                        buffer.append((char)letter);
                                    }
                                    resposeStr = buffer.toString();
                                    BaseLogger.log((String)"3", (UserInfoBean)userInfoBean, null, (Object)("resposeStr ::" + resposeStr));
                                    if (resposeStr != null && resposeStr.toUpperCase().indexOf("ERROR") != -1) {
                                        isError = true;
                                        messageStr = this.getErrorString("", "SMSFAILED", "");
                                        this.generateLog(messageStr, xtraParams, userInfoBean);
                                    }
                                }
                                catch (Exception er) {
                                    er.printStackTrace();
                                }
                                dbAccess = null;
                                break block29;
                            }
                            String msg = "Mobile No/ SMSText is null or not defined ";
                            BaseLogger.log((String)"3", (UserInfoBean)userInfoBean, null, (Object)"Mobile No/ SMSText is null or not defined , SMS can not be send without Mobile No/SMS Text ");
                            messageStr = this.getErrorString("", "SMSPARAM", "");
                            isError = true;
                            this.generateLog(msg, xtraParams, userInfoBean);
                            break block29;
                        }
                        BaseLogger.log((String)"3", (UserInfoBean)userInfoBean, null, (Object)"Expression Evaluation failed...........");
                        isError = true;
                        this.generateLog("Expression Evaluation failed", xtraParams, userInfoBean);
                    }
                    catch (Exception e) {
                        isError = true;
                        try {
                            BaseLogger.log((String)"0", (UserInfoBean)userInfoBean, (String)"", (Object)("Exception in E12SMSComp :: sendSMS() : " + e));
                            messageStr = this.getErrorString("", "SMSFAILED", "");
                            this.generateLog("SMS Send Failed", xtraParams, userInfoBean);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        BaseLogger.log((String)"0", (UserInfoBean)userInfoBean, null, (Object)("Exception ::" + e.getMessage()));
                        e.printStackTrace();
                        try {
                            if (connection != null) {
                                connection.disconnect();
                            }
                            if (!isError) {
                                this.generateLog("Status : SMS Send Successfully \n" + resposeStr, xtraParams, userInfoBean);
                            }
                            break block30;
                        }
                        catch (Exception exception) {}
                        break block30;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (connection != null) {
                            connection.disconnect();
                        }
                        if (!isError) {
                            this.generateLog("Status : SMS Send Successfully \n" + resposeStr, xtraParams, userInfoBean);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            try {
                if (connection != null) {
                    connection.disconnect();
                }
                if (!isError) {
                    this.generateLog("Status : SMS Send Successfully \n" + resposeStr, xtraParams, userInfoBean);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        BaseLogger.log((String)"0", (UserInfoBean)userInfoBean, null, (Object)("messageStr ::" + messageStr));
        return messageStr;
    }

    private void ConfigureSMSParam() throws ITMException {
        try {
            this.buildSMSParamMap();
            this.setSMSDetails();
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
    }

    private void buildSMSParamMap() throws ITMException {
        Object smsParamDom = null;
        try {
            this.smsParamMap = new HashMap();
            String transDB = this.userInfoBean.getTransDB();
            switch (this.smsType) {
                case OTP: {
                    this.buildSMSParamMapOTP(transDB);
                    break;
                }
                case PROMOTIONAL: {
                    BaseLogger.log((String)"3", null, (String)"E12SMSComp", (Object)"PROMOTIONAL sms parameters configuration not implemented yet.");
                    break;
                }
                default: {
                    this.buildSMSParamMapTransactional(transDB);
                    break;
                }
            }
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
    }

    private void buildSMSParamMapTransactional(String transDB) throws RemoteException, ITMException {
        DBAccessEJB dbAccess = new DBAccessEJB();
        String smsUserName = dbAccess.getDBColumnValue(this.tblName, this.prmValue, String.valueOf(this.prmName) + " ='USER_VAR_NAME'", transDB);
        String smsUserVal = dbAccess.getDBColumnValue(this.tblName, this.prmValue, String.valueOf(this.prmName) + " ='USER_VAR_VALUE'", transDB);
        String smsPasswdName = dbAccess.getDBColumnValue(this.tblName, this.prmValue, String.valueOf(this.prmName) + " ='PASSWD_VAR_NAME'", transDB);
        String smsPasswdVal = dbAccess.getDBColumnValue(this.tblName, this.prmValue, String.valueOf(this.prmName) + " ='PASSWD_VAR_VALUE'", transDB);
        String smsFromName = dbAccess.getDBColumnValue(this.tblName, this.prmValue, String.valueOf(this.prmName) + " ='FROM_VAR_NAME'", transDB);
        String smsFromVal = dbAccess.getDBColumnValue(this.tblName, this.prmValue, String.valueOf(this.prmName) + " ='FROM_VAR_VALUE'", transDB);
        String smsToName = dbAccess.getDBColumnValue(this.tblName, this.prmValue, String.valueOf(this.prmName) + " ='TO_VAR_NAME'", transDB);
        String smsTextName = dbAccess.getDBColumnValue(this.tblName, this.prmValue, String.valueOf(this.prmName) + " ='MSG_VAR_NAME'", transDB);
        String smsFeedidName = dbAccess.getDBColumnValue(this.tblName, this.prmValue, String.valueOf(this.prmName) + " ='USER_FEEDID_NAME'", transDB);
        String smsFeedidVal = dbAccess.getDBColumnValue(this.tblName, this.prmValue, String.valueOf(this.prmName) + " ='USER_FEEDID_VALUE'", transDB);
        String smsModeVarName = dbAccess.getDBColumnValue(this.tblName, this.prmValue, String.valueOf(this.prmName) + " ='SMS_MODE_VAR_NAME'", transDB);
        String smsModeVarVal = dbAccess.getDBColumnValue(this.tblName, this.prmValue, String.valueOf(this.prmName) + " ='SMS_MODE_VAR_VALUE'", transDB);
        String msgTypeVarName = dbAccess.getDBColumnValue(this.tblName, this.prmValue, String.valueOf(this.prmName) + " ='MSG_TYPE_VAR_NAME'", transDB);
        String msgTypeVarVal = dbAccess.getDBColumnValue(this.tblName, this.prmValue, String.valueOf(this.prmName) + " ='MSG_TYPE_VAR_VALUE'", transDB);
        String smsApiKeyName = dbAccess.getDBColumnValue(this.tblName, this.prmValue, String.valueOf(this.prmName) + " ='MSG_API_KEY_NAME'", transDB);
        String smsApiKeyValue = dbAccess.getDBColumnValue(this.tblName, this.prmValue, String.valueOf(this.prmName) + " ='MSG_API_KEY_VALUE'", transDB);
        String smsResFormatName = dbAccess.getDBColumnValue(this.tblName, this.prmValue, String.valueOf(this.prmName) + " ='RES_FORMAT_NAME'", transDB);
        String smsResFormatValue = dbAccess.getDBColumnValue(this.tblName, this.prmValue, String.valueOf(this.prmName) + " ='RES_FORMAT_VALUE'", transDB);
        String smsMethodName = dbAccess.getDBColumnValue(this.tblName, this.prmValue, String.valueOf(this.prmName) + " ='MSG_METHOD_NAME'", transDB);
        String smsMethodValue = dbAccess.getDBColumnValue(this.tblName, this.prmValue, String.valueOf(this.prmName) + " ='MSG_METHOD_VALUE'", transDB);
        String smsRouteName = dbAccess.getDBColumnValue(this.tblName, this.prmValue, String.valueOf(this.prmName) + " ='MSG_ROUTE_NAME'", transDB);
        String smsRouteValue = dbAccess.getDBColumnValue(this.tblName, this.prmValue, String.valueOf(this.prmName) + " ='MSG_ROUTE_VALUE'", transDB);
        String smsURL = dbAccess.getDBColumnValue(this.tblName, this.prmValue, String.valueOf(this.prmName) + "='SMS_SERVICE_URL'", transDB);
        String smsDltIdKey = dbAccess.getDBColumnValue(this.tblName, this.prmValue, String.valueOf(this.prmName) + "='MSG_DLT_ID_KEY_NAME'", transDB);
        String smsDltIdVal = dbAccess.getDBColumnValue(this.tblName, this.prmValue, String.valueOf(this.prmName) + "='MSG_DLT_ID_KEY_VALUE'", transDB);
        String templateKeyName = dbAccess.getDBColumnValue(this.tblName, this.prmValue, String.valueOf(this.prmName) + "='MSG_TEMPL_KEY_NAME'", transDB);
        this.toParamName = smsToName;
        this.textParamName = smsTextName;
        this.senderID = smsFromVal;
        this.smsApiKeyName = smsApiKeyName;
        this.templateKeyName = templateKeyName;
        if (!this.smsParamMap.containsKey(smsUserName) && smsUserName.trim().length() > 0) {
            this.smsParamMap.put(smsUserName, smsUserVal);
        }
        if (!this.smsParamMap.containsKey(smsPasswdName) && smsPasswdName.trim().length() > 0) {
            this.smsParamMap.put(smsPasswdName, smsPasswdVal);
        }
        if (!this.smsParamMap.containsKey(smsFromName) && smsFromName.trim().length() > 0) {
            this.smsParamMap.put(smsFromName, smsFromVal);
        }
        if (!this.smsParamMap.containsKey(smsToName) && smsToName.trim().length() > 0) {
            this.smsParamMap.put(smsToName, "");
        }
        if (!this.smsParamMap.containsKey(smsTextName) && smsTextName.trim().length() > 0) {
            this.smsParamMap.put(smsTextName, "");
        }
        if (!this.smsParamMap.containsKey(smsFeedidName) && smsFeedidName.trim().length() > 0) {
            this.smsParamMap.put(smsFeedidName, smsFeedidVal);
        }
        if (!this.smsParamMap.containsKey(smsModeVarName) && smsModeVarName.trim().length() > 0) {
            this.smsParamMap.put(smsModeVarName, smsModeVarVal);
        }
        if (!this.smsParamMap.containsKey(msgTypeVarName) && msgTypeVarName.trim().length() > 0) {
            this.smsParamMap.put(msgTypeVarName, msgTypeVarVal);
        }
        if (smsApiKeyName.length() > 0) {
            this.smsParamMap.put(smsApiKeyName, smsApiKeyValue);
        }
        if (smsResFormatName.length() > 0) {
            this.smsParamMap.put(smsResFormatName, smsResFormatValue);
        }
        if (smsMethodName.length() > 0) {
            this.smsParamMap.put(smsMethodName, smsMethodValue);
        }
        if (smsRouteName.length() > 0) {
            this.smsParamMap.put(smsRouteName, smsRouteValue);
        }
        if (smsDltIdKey.length() > 0) {
            this.smsParamMap.put(smsDltIdKey, smsDltIdVal);
        }
        if (smsURL.length() > 0) {
            this.smsURL = smsURL;
        }
        dbAccess = null;
    }

    private void buildSMSParamMapOTP(String transDB) throws Exception {
        String smsURL;
        DBAccessEJB dbAccess = new DBAccessEJB();
        this.serviceProviderUrl = smsURL = dbAccess.getDBColumnValue(this.tblName, this.prmValue, String.valueOf(this.prmName) + "='OTP_SERVICE_URL'", transDB);
        String authKeyName = dbAccess.getDBColumnValue(this.tblName, this.prmValue, String.valueOf(this.prmName) + "='MSG_API_KEY_NAME_OTP'", transDB);
        String authKeyValue = dbAccess.getDBColumnValue(this.tblName, this.prmValue, String.valueOf(this.prmName) + "='MSG_API_KEY_VALUE_OTP'", transDB);
        String messageKeyName = dbAccess.getDBColumnValue(this.tblName, this.prmValue, String.valueOf(this.prmName) + "='MSG_VAR_NAME_OTP'", transDB);
        String fromKeyName = dbAccess.getDBColumnValue(this.tblName, this.prmValue, String.valueOf(this.prmName) + "='FROM_VAR_NAME_OTP'", transDB);
        String fromKeyValue = dbAccess.getDBColumnValue(this.tblName, this.prmValue, String.valueOf(this.prmName) + "='FROM_VAR_VALUE_OTP'", transDB);
        String toKeyValue = dbAccess.getDBColumnValue(this.tblName, this.prmValue, String.valueOf(this.prmName) + "='TO_VAR_NAME_OTP'", transDB);
        String otpKeyName = dbAccess.getDBColumnValue(this.tblName, this.prmValue, String.valueOf(this.prmName) + "='OTP_VAR_NAME'", transDB);
        String otpKeyValue = dbAccess.getDBColumnValue(this.tblName, this.prmValue, String.valueOf(this.prmName) + "='OTP_VAR_VALUE'", transDB);
        String retryName = dbAccess.getDBColumnValue(this.tblName, this.prmValue, String.valueOf(this.prmName) + "='RETRY_TYPE_VAR_NAME_OTP'", transDB);
        String retryValue = dbAccess.getDBColumnValue(this.tblName, this.prmValue, String.valueOf(this.prmName) + "='RETRY_TYPE_VAR_VALUE_OTP'", transDB);
        String templateName = dbAccess.getDBColumnValue(this.tblName, this.prmValue, String.valueOf(this.prmName) + "='TEMPLATE_KEY_NAME_OTP'", transDB);
        String templateValue = dbAccess.getDBColumnValue(this.tblName, this.prmValue, String.valueOf(this.prmName) + "='TEMPLATE_KEY_VALUE_OTP'", transDB);
        String templateIdName = dbAccess.getDBColumnValue(this.tblName, this.prmValue, String.valueOf(this.prmName) + "='TEMPLATE_ID_NAME_OTP'", transDB);
        this.toParamName = toKeyValue;
        this.textParamName = messageKeyName;
        this.senderID = fromKeyValue;
        this.templateIdName = templateIdName;
        if (templateName.trim().length() > 0) {
            this.smsParamMap.put(templateName, templateValue);
        }
        if (authKeyName.trim().length() > 0) {
            this.smsParamMap.put(authKeyName, authKeyValue);
        }
        if (fromKeyName.trim().length() > 0) {
            this.smsParamMap.put(fromKeyName, fromKeyValue);
        }
        if (retryName.trim().length() > 0) {
            this.smsParamMap.put(retryName, retryValue);
        }
        if (otpKeyName.trim().length() > 0 && otpKeyValue.length() > 0) {
            String resultValue = this.customizeDataStr(otpKeyValue, this.xmlString);
            this.smsParamMap.put(otpKeyName, resultValue);
        }
        if (smsURL.length() > 0) {
            this.smsURL = smsURL;
        }
    }

    private String buildSMSURL() throws ITMException {
        String paramName = "";
        String paramValue = "";
        String smsParamStr = "";
        String mobileNo = "";
        String smsUrlStr = "";
        int i = 1;
        int mapSize = 0;
        try {
            String smsUrlInEnterprise = "";
            if (this.checkNull(this.userInfoBean.getTransDB()).length() > 0) {
                DBAccessEJB accessEJB = new DBAccessEJB();
                smsUrlInEnterprise = accessEJB.getDBColumnValue("ENTERPRISE", "SMS_URL", "ENTERPRISE ='" + this.userInfoBean.getEnterprise() + "'", this.userInfoBean.getTransDB());
            }
            if (this.checkNull(smsUrlInEnterprise).length() > 0) {
                smsUrlStr = smsUrlInEnterprise;
            } else {
                if (CommonConstants.TOMCAT_HOME == null || CommonConstants.TOMCAT_HOME.trim().length() == 0) {
                    CommonConstants.setIBASEHOME();
                }
                if ((smsUrlStr = this.smsURL) == null || smsUrlStr.trim().length() == 0) {
                    smsUrlStr = CommonConstants.SMSURL;
                }
            }
            BaseLogger.log((String)"3", null, (String)"E12SMSComp", (Object)("smsUrlStr : [" + smsUrlStr + "]"));
            if (this.smsType != SMSType.TRANSACTIONAL || !"T".equalsIgnoreCase(this.smsTextType)) {
                if (this.smsParamMap != null) {
                    mapSize = this.smsParamMap.size();
                }
                if (mapSize > 0) {
                    for (Map.Entry pairs : this.smsParamMap.entrySet()) {
                        paramName = (String)pairs.getKey() == null ? "" : (String)pairs.getKey();
                        paramValue = (String)pairs.getValue() == null ? "" : (String)pairs.getValue();
                        paramValue = paramValue.replace("+", "%2B");
                        paramValue = URLEncoder.encode(paramValue);
                        smsParamStr = i == mapSize ? String.valueOf(smsParamStr) + paramName + "=" + paramValue : String.valueOf(smsParamStr) + paramName + "=" + paramValue + "&";
                        ++i;
                    }
                }
                smsUrlStr = smsUrlStr.indexOf("?") != -1 ? String.valueOf(smsUrlStr) + "&" + smsParamStr : String.valueOf(smsUrlStr) + "?" + smsParamStr;
            }
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        BaseLogger.log((String)"2", null, null, (Object)("##### FINAL SMS URL Query String :: " + smsUrlStr));
        return smsUrlStr;
    }

    private void setSMSDetails() throws ITMException {
        ArrayList smsDetailList = null;
        String sendTo = "";
        String smsHeader = "";
        String smsBody = "";
        String smsFooter = "";
        String smsText = "";
        String templateId = "";
        try {
            DBAccessEJB dbAccess = new DBAccessEJB();
            smsDetailList = dbAccess.getSMSDetailList(this.formatCode, this.userInfoBean);
            BaseLogger.log((String)"3", null, null, (Object)("[E12SMSComp] SMS detail found for format code :" + this.formatCode + ":"));
            BaseLogger.log((String)"3", null, null, (Object)("[E12SMSComp] smsDetailList  : [" + smsDetailList + "]:"));
            BaseLogger.log((String)"3", null, null, (Object)("this.toParamName =[" + this.toParamName + "]"));
            BaseLogger.log((String)"3", null, null, (Object)("this.textParamName =[" + this.textParamName + "]"));
            BaseLogger.log((String)"3", null, null, (Object)("smsDetailList.size() : [" + smsDetailList.size() + "]"));
            if (smsDetailList.size() > 0) {
                String to = "";
                String cc = "";
                String bcc = "";
                this.smsTextType = (String)smsDetailList.get(4);
                if ((String)smsDetailList.get(0) != null) {
                    to = (String)smsDetailList.get(0);
                }
                if (to.length() > 0) {
                    StringBuffer toAddrBuff = new StringBuffer();
                    ArrayList tokens = this.genericUtility.getTokenList(to, ",");
                    BaseLogger.log((String)"3", null, null, (Object)("tokens " + tokens));
                    int i = 0;
                    while (i < tokens.size()) {
                        String currToken = (String)tokens.get(i);
                        String argType = "";
                        if (currToken.indexOf("{") != -1) {
                            BaseLogger.log((String)"3", null, null, (Object)("To with '{' :[" + currToken + "]"));
                            if (currToken.charAt(1) == '(') {
                                argType = currToken.substring(currToken.indexOf("(") + 1, currToken.indexOf(")"));
                                this.entityType = argType.length() == 1 ? argType : argType.substring(0, 1);
                            }
                            toAddrBuff.append(this.getSMSToAddr(argType, currToken.substring(currToken.indexOf(")") + 1, currToken.length() - 1))).append(",");
                        } else if (currToken.indexOf("<") != -1) {
                            BaseLogger.log((String)"3", null, null, (Object)("To with '<' :[" + currToken + "]"));
                            toAddrBuff.append(this.customizeDataStr(currToken, this.xmlString)).append(",");
                        } else if (currToken.indexOf("[") != -1) {
                            BaseLogger.log((String)"3", null, null, (Object)("To with '[' :[" + currToken + "]"));
                            if (currToken.charAt(1) == '(') {
                                this.entityType = argType.length() == 1 ? argType : argType.substring(0, 1);
                                currToken = currToken.substring(currToken.indexOf(")") + 1, currToken.length() - 1);
                            } else {
                                currToken = currToken.substring(1, currToken.length() - 1);
                            }
                            if (currToken.equals("ROLE_CODE")) {
                                toAddrBuff.append(this.getRoleCodeSMSToAddr(this.entityType)).append(",");
                            } else {
                                toAddrBuff.append(this.getSMSToAddr(this.entityType, currToken)).append(",");
                            }
                        } else {
                            toAddrBuff.append(currToken).append(",");
                        }
                        ++i;
                    }
                    sendTo = sendTo != null && !sendTo.equalsIgnoreCase("null") && sendTo.trim().length() > 0 ? String.valueOf(sendTo) + "," + toAddrBuff.toString() : toAddrBuff.toString();
                    BaseLogger.log((String)"3", null, null, (Object)("sendTo " + sendTo.toString()));
                    if (sendTo.endsWith(",")) {
                        sendTo = sendTo.substring(0, sendTo.length() - 1);
                    }
                    this.smsParamMap.put(this.toParamName, sendTo == null ? "" : sendTo);
                }
                if ((String)smsDetailList.get(5) != null && this.smsTextType == null) {
                    this.smsParamMap.put(this.templateKeyName, (String)smsDetailList.get(5));
                }
                if (this.smsTextType != null && "T".equalsIgnoreCase(this.smsTextType)) {
                    if ((String)smsDetailList.get(2) != null) {
                        smsBody = (String)smsDetailList.get(2);
                        BaseLogger.log((String)"3", null, null, (Object)("smsBody : " + smsBody.toString()));
                        templateId = smsBody;
                        if (this.smsType == SMSType.TRANSACTIONAL) {
                            if (smsBody.contains("<MOBILE_NO>")) {
                                smsBody = smsBody.replace("<MOBILE_NO>", sendTo);
                            }
                            String originalString = this.customizeDataStr(smsBody, this.xmlString);
                            BaseLogger.log((String)"3", null, null, (Object)("\nFinal originalString : " + originalString));
                            this.smsParamMap.put(this.inputVariable, originalString);
                        }
                    }
                    this.smsParamMap.put(this.templateIdName, templateId);
                } else {
                    if ((String)smsDetailList.get(1) != null && (smsHeader = (String)smsDetailList.get(1)).indexOf("<") != -1) {
                        smsHeader = this.customizeDataStr(smsHeader, this.xmlString);
                    }
                    if ((String)smsDetailList.get(2) != null && (smsBody = (String)smsDetailList.get(2)).indexOf("<") != -1) {
                        smsBody = this.customizeDataStr(smsBody, this.xmlString);
                    }
                    if ((String)smsDetailList.get(3) != null && (smsFooter = (String)smsDetailList.get(3)).indexOf("<") != -1) {
                        smsFooter = this.customizeDataStr(smsFooter, this.xmlString);
                    }
                    if (smsHeader != null && smsHeader.trim().length() > 0) {
                        smsText = String.valueOf(smsText) + smsHeader;
                    }
                    if (smsBody != null && smsBody.trim().length() > 0) {
                        smsText = smsText != null && smsText.trim().length() > 0 ? String.valueOf(smsText) + "\n" + smsBody : String.valueOf(smsText) + smsBody;
                    }
                    if (smsFooter != null && smsFooter.trim().length() > 0) {
                        smsText = smsText != null && smsText.trim().length() > 0 ? String.valueOf(smsText) + "\n" + smsFooter : String.valueOf(smsText) + smsFooter;
                    }
                    BaseLogger.log((String)"3", null, null, (Object)("smsText ::" + smsText));
                    if (this.smsType == SMSType.OTP) {
                        if (E12GenericUtility.checkNull((String)this.appHashCode).length() > 0) {
                            smsText = "<#> " + smsText + "\n" + this.appHashCode;
                        }
                        System.out.println("E12SMSComp :: setSMSDetails() : SMSLength : " + smsText.getBytes().length);
                        if (smsText != null && smsText.getBytes().length > 140) {
                            System.err.printf("OTP message length is %s bytes, which is greater than standard size (i.e. %s)", smsText.getBytes().length, 140);
                        }
                    }
                    this.smsParamMap.put(this.textParamName, smsText == null ? "" : smsText);
                }
            }
            dbAccess = null;
            BaseLogger.log((String)"3", null, null, (Object)("sms parameter map::" + this.smsParamMap));
        }
        catch (Exception e) {
            BaseLogger.log((String)"0", null, null, (Object)("Exception :ITMSMSInfo :email :==>\n" + e.getMessage()));
            throw new ITMException(e);
        }
    }

    private String getSMSToAddr(String argType, String argName) throws ITMException {
        BaseLogger.log((String)"2", null, null, (Object)("[getSMSToAddr]argType :" + argType + ": argName :" + argName + ":"));
        String retSmsMobNo = "";
        String transDB = "";
        try {
            String masterTable = null;
            String whereFieldName = null;
            String selFieldName = "MOBILE_NO";
            String responsibleFor = "";
            String entityType = "";
            String whereCondition = "";
            if (this.userInfoBean != null) {
                transDB = this.userInfoBean.getTransDB();
            }
            Document dom = this.genericUtility.parseString(this.xmlString);
            if (argType != null && argType.trim().length() > 0) {
                entityType = argType.substring(0, 1);
            }
            if (argType != null && argType.trim().length() > 1) {
                responsibleFor = argType.substring(1, 2);
            }
            this.entityCode = this.getValueOfField(dom, argName.toLowerCase());
            if (entityType.equalsIgnoreCase("C")) {
                masterTable = "CUSTOMER";
                if (responsibleFor == null || responsibleFor.trim().length() == 0) {
                    whereFieldName = "CUST_CODE";
                    selFieldName = "TELE3";
                }
            } else if (entityType.equalsIgnoreCase("S")) {
                masterTable = "SUPPLIER";
                if (responsibleFor == null || responsibleFor.trim().length() == 0) {
                    whereFieldName = "SUPP_CODE";
                    selFieldName = "TELE3";
                }
            } else if (entityType.equalsIgnoreCase("E")) {
                masterTable = "EMPLOYEE";
                if (responsibleFor == null || responsibleFor.trim().length() == 0) {
                    whereFieldName = "EMP_CODE";
                    selFieldName = "MOBILE_NO";
                }
            } else if (entityType.equalsIgnoreCase("P")) {
                masterTable = "SALES_PERS";
                if (responsibleFor == null || responsibleFor.trim().length() == 0) {
                    whereFieldName = "SALES_PERS";
                    selFieldName = "TELE3";
                }
            } else if (argType.equalsIgnoreCase("T")) {
                masterTable = "TRANSPORTER";
                if (responsibleFor == null || responsibleFor.trim().length() == 0) {
                    whereFieldName = "TRAN_CODE";
                    selFieldName = "TELE3";
                }
            } else if (argType.equalsIgnoreCase("U")) {
                masterTable = "USERS";
                transDB = "Driver";
                if (responsibleFor == null || responsibleFor.trim().length() == 0) {
                    whereFieldName = "CODE";
                    selFieldName = "MOBILE_NO";
                }
            } else if (argType.equalsIgnoreCase("G")) {
                masterTable = "STRG_CUSTOMER";
                if (responsibleFor == null || responsibleFor.trim().length() == 0) {
                    whereFieldName = "SC_CODE";
                    selFieldName = "MOBILE_NO";
                }
            }
            if (responsibleFor != null && responsibleFor.trim().length() > 0) {
                retSmsMobNo = this.getMobileNo(entityType, this.entityCode, responsibleFor);
            } else {
                DBAccessEJB dbAccess = new DBAccessEJB();
                String whereFieldValue = this.getValueOfField(dom, argName.toLowerCase());
                whereCondition = String.valueOf(whereFieldName) + " = '" + whereFieldValue + "'";
                retSmsMobNo = dbAccess.getDBColumnValue(masterTable, selFieldName, whereCondition, transDB);
                dbAccess = null;
            }
        }
        catch (Exception e) {
            BaseLogger.log((String)"0", null, null, (Object)("Exception :E12SMSComp :getSMS :==>\n" + e.getMessage()));
            throw new ITMException(e);
        }
        return retSmsMobNo;
    }

    private String getRoleCodeSMSToAddr(String argType) throws ITMException {
        BaseLogger.log((String)"2", null, null, (Object)("[ITMSMSInfo] argType getRoleCodeSMSAddr :" + argType + ":"));
        String retSmsAddr = "";
        try {
            String masterTable = null;
            String whereFieldName = null;
            String selFieldName = null;
            if (argType.equalsIgnoreCase("C")) {
                masterTable = "CUSTOMER";
                whereFieldName = "CUST_CODE";
                selFieldName = "TELE3";
            } else if (argType.equalsIgnoreCase("S")) {
                masterTable = "SUPPLIER";
                whereFieldName = "SUPP_CODE";
                selFieldName = "TELE3";
            } else if (argType.equalsIgnoreCase("E")) {
                masterTable = "EMPLOYEE";
                whereFieldName = "EMP_CODE";
                selFieldName = "MOBILE_NO";
            } else if (argType.equalsIgnoreCase("P")) {
                masterTable = "SALES_PERS";
                whereFieldName = "SALES_PERS";
                selFieldName = "TELE3";
            }
            DBAccessEJB dbAccess = new DBAccessEJB();
            retSmsAddr = dbAccess.getMobileNo(selFieldName, masterTable, whereFieldName, this.entityCode);
            dbAccess = null;
        }
        catch (Exception e) {
            BaseLogger.log((String)"0", null, null, (Object)("Exception :ITMSMSInfo :getEmailAddr :==>\n" + e.getMessage()));
            throw new ITMException(e);
        }
        return retSmsAddr;
    }

    private String getValueOfField(Document dom, String fieldName) throws ITMException {
        BaseLogger.log((String)"2", null, null, (Object)("Getting value of [" + fieldName + "]"));
        String fieldValue = null;
        try {
            Node currField = dom.getElementsByTagName(fieldName).item(0);
            if (currField != null) {
                BaseLogger.log((String)"3", null, null, (Object)("[" + fieldName + "] found "));
                if (currField.getFirstChild() != null) {
                    fieldValue = currField.getFirstChild().getNodeType() == 1 ? new E12GenericUtility().serializeDom(currField, true) : currField.getFirstChild().getNodeValue();
                }
            } else {
                BaseLogger.log((String)"3", null, null, (Object)("Node [" + fieldName + "] not found "));
            }
        }
        catch (Exception e) {
            BaseLogger.log((String)"0", null, null, (Object)("Exception :ITMSMSInfo :getValueOfField() :==>\n" + e.getMessage()));
            throw new ITMException(e);
        }
        return fieldValue;
    }

    private String getValueOfFieldFromStr(String domStr, String fieldName) throws ITMException {
        String fieldValue = "";
        try {
            if (domStr.indexOf(fieldName) != -1) {
                String startTag = "<" + fieldName + ">";
                String endTag = "</" + fieldName + ">";
                fieldValue = domStr.substring(domStr.indexOf(startTag) + startTag.length(), domStr.indexOf(endTag));
            }
        }
        catch (Exception e) {
            BaseLogger.log((String)"0", null, null, (Object)("Exception :ITMSMSInfo :getValueOfField() :==>\n" + e.getMessage()));
            throw new ITMException(e);
        }
        return fieldValue.trim();
    }

    private String customizeDataStr(String fieldName, String domString) throws Exception {
        String fieldValue = "";
        String replacedFieldValue = "";
        String currMsgstr = "";
        StringBuffer msgBuff = new StringBuffer();
        try {
            if (fieldName.indexOf("<") != -1) {
                StringTokenizer msgToken = new StringTokenizer(fieldName, ">");
                while (msgToken.hasMoreTokens()) {
                    currMsgstr = msgToken.nextToken();
                    if (currMsgstr.indexOf("<") == -1) continue;
                    int startBracket = currMsgstr.indexOf("<");
                    msgBuff.append(currMsgstr.substring(0, startBracket));
                    fieldValue = currMsgstr.substring(startBracket + 1, currMsgstr.length());
                    replacedFieldValue = this.getValueOfFieldFromDom(domString, fieldValue);
                    msgBuff.append(replacedFieldValue);
                }
                if (!fieldName.endsWith(">")) {
                    String tempStr = fieldName.substring(fieldName.lastIndexOf(">") + 1, fieldName.length());
                    msgBuff.append(tempStr);
                }
            } else {
                msgBuff.append(fieldName);
            }
            BaseLogger.log((String)"3", null, null, (Object)(" msg buff [" + msgBuff.toString()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return msgBuff.toString();
    }

    private String getValueOfFieldFromDom(String domStr, String fieldRequired) throws Exception {
        Object parentNode = null;
        Document dom = null;
        String childNodeName = null;
        Object childNodeName1 = null;
        String fieldValue = null;
        String fromNode = null;
        ArrayList taskList = new ArrayList();
        dom = this.genericUtility.parseString(domStr);
        if (fieldRequired.indexOf(".") != -1) {
            fromNode = fieldRequired.substring(0, fieldRequired.indexOf("."));
            fieldRequired = fieldRequired.substring(fieldRequired.indexOf(".") + 1, fieldRequired.length());
        } else {
            fromNode = fromNode == null ? "Detail1" : fromNode;
        }
        NodeList detailList = dom.getElementsByTagName(fromNode);
        int detListLength = detailList.getLength();
        int ctr = 0;
        while (ctr < detListLength) {
            Node currDetailNode = detailList.item(ctr);
            NodeList childList = currDetailNode.getChildNodes();
            int childCtr = childList.getLength();
            int chCnt = 0;
            while (chCnt < childCtr) {
                Node childNode = childList.item(chCnt);
                childNodeName = childNode.getNodeName();
                if (childNodeName.equalsIgnoreCase(fieldRequired) && childNode.getFirstChild() != null) {
                    fieldValue = childNode.getFirstChild().getNodeValue().trim();
                    if ("OTP".equalsIgnoreCase(fieldRequired)) {
                        this.smsParamMap.put("otp", fieldValue);
                    }
                    BaseLogger.log((String)"3", null, null, (Object)("fieldRequired [" + fieldRequired + "] fieldValue  [" + fieldValue + "]"));
                }
                ++chCnt;
            }
            ++ctr;
        }
        fieldValue = fieldValue == null ? "" : fieldValue;
        return fieldValue;
    }

    private void generateLog(String responseStr, String xtraParams, UserInfoBean userInfo) throws RemoteException, ITMException {
        ConnDriver mConnDriver = null;
        Connection mConnection = null;
        Statement pStmt = null;
        ResultSet mRs = null;
        String transDB = "";
        String status = "";
        String mobileNo = "";
        String smsText = "";
        try {
            try {
                mConnDriver = new ConnDriver();
                transDB = userInfo.getTransDB();
                mConnection = mConnDriver.getConnectDB(transDB);
                String tranID = this.generateTranID(mConnection, xtraParams);
                if (tranID != null && tranID.trim().length() > 0) {
                    if (this.smsParamMap != null && !"".equals(this.smsParamMap)) {
                        mobileNo = (String)this.smsParamMap.get(this.toParamName);
                        smsText = (String)this.smsParamMap.get(this.textParamName);
                    }
                    String insertSql = "INSERT INTO SMS_LOG (TRAN_ID, OBJ_NAME, SMS_SEND_DATE, SEND_TO, SENDER_ID, STATUS, SMS_MSG, CHG_DATE,CHG_USER,CHG_TERM) VALUES(?,?,?,?,?,?,?,?,?,?)";
                    pStmt = mConnection.prepareStatement(insertSql);
                    pStmt.setString(1, tranID);
                    pStmt.setString(2, this.objName);
                    pStmt.setTimestamp(3, new Timestamp(System.currentTimeMillis()));
                    pStmt.setString(4, mobileNo);
                    pStmt.setString(5, this.senderID);
                    pStmt.setString(6, responseStr);
                    pStmt.setString(7, smsText);
                    pStmt.setTimestamp(8, new Timestamp(System.currentTimeMillis()));
                    pStmt.setString(9, this.getValueFromXTRA_PARAMS(xtraParams, "loginCode"));
                    pStmt.setString(10, this.getValueFromXTRA_PARAMS(xtraParams, "termId"));
                    int insCnt = pStmt.executeUpdate();
                    if (insCnt > 0) {
                        mConnection.commit();
                    }
                } else {
                    BaseLogger.log((String)"3", null, null, (Object)"Transaction id is null.......");
                }
            }
            catch (ITMException itme) {
                System.err.println("ITMException :generateLog :\n");
                throw itme;
            }
            catch (Exception e) {
                System.err.println("Exception :generateLog :\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (mConnection != null) {
                    if (mRs != null) {
                        mRs.close();
                        mRs = null;
                    }
                    if (pStmt != null) {
                        pStmt.close();
                        pStmt = null;
                    }
                    mConnection.close();
                    mConnection = null;
                }
            }
            catch (Exception e) {
                System.err.println("Exception :generateLog :\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
    }

    private String getObjNameFromDom(Document dom, String attribute) throws RemoteException, ITMException {
        NodeList detailList = null;
        Node currDetail = null;
        String objName = "";
        int detailListLength = 0;
        try {
            detailList = dom.getElementsByTagName("Detail1");
            detailListLength = detailList.getLength();
            int ctr = 0;
            while (ctr < detailListLength) {
                currDetail = detailList.item(ctr);
                objName = currDetail.getAttributes().getNamedItem(attribute).getNodeValue();
                ++ctr;
            }
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        BaseLogger.log((String)"2", null, null, (Object)("objName =[" + objName + "]"));
        return objName;
    }

    private String generateTranID(Connection conn, String xtraParams) {
        String sprsTravelTranID = "";
        PreparedStatement pStmt = null;
        ResultSet rSet = null;
        String refSer = "";
        String tranIdCol = "";
        String keyString = "";
        E12GenericUtility genericUtility = new E12GenericUtility();
        try {
            try {
                String transSql = "SELECT REF_SER,TRAN_ID_COL,KEY_STRING FROM TRANSETUP WHERE TRAN_WINDOW  = 'w_sms_log'";
                pStmt = conn.prepareStatement(transSql);
                rSet = pStmt.executeQuery();
                if (rSet.next()) {
                    refSer = rSet.getString("REF_SER") == null ? "" : rSet.getString("REF_SER").trim();
                    tranIdCol = rSet.getString("TRAN_ID_COL") == null ? "" : rSet.getString("TRAN_ID_COL").trim();
                    keyString = rSet.getString("KEY_STRING") == null ? "" : rSet.getString("KEY_STRING").trim();
                }
                BaseLogger.log((String)"3", null, null, (Object)("refSer[" + refSer + "]tranIdCol[" + tranIdCol + "]keyString[" + keyString + "]"));
                TransIDGenerator tranIDGenerator = new TransIDGenerator("<Root></Root>", this.getValueFromXTRA_PARAMS(xtraParams, "loginCode"), CommonConstants.DB_NAME);
                sprsTravelTranID = tranIDGenerator.generateTranSeqID(refSer, tranIdCol, keyString, conn);
            }
            catch (Exception exp) {
                BaseLogger.log((String)"2", null, null, (Object)"Exception In generateTranID......");
                exp.printStackTrace();
                try {
                    if (rSet != null) {
                        rSet.close();
                        rSet.close();
                    }
                    if (pStmt != null) {
                        pStmt.close();
                        pStmt.close();
                    }
                }
                catch (Exception expRsc) {
                    expRsc.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (rSet != null) {
                    rSet.close();
                    rSet.close();
                }
                if (pStmt != null) {
                    pStmt.close();
                    pStmt.close();
                }
            }
            catch (Exception expRsc) {
                expRsc.printStackTrace();
            }
        }
        return sprsTravelTranID;
    }

    private boolean evaluateExpression(UserInfoBean userInfoBean) throws ITMException {
        BaseLogger.log((String)"2", (UserInfoBean)userInfoBean, null, (Object)"evaluateExpression is called....");
        boolean isEvaluation = false;
        String exprStr = "";
        String tableName = "SMS_FORMAT";
        String columnName = "SMS_EXPR";
        String condition = "";
        try {
            DBAccessEJB dbAccess = new DBAccessEJB();
            condition = " FORMAT_CODE ='" + this.formatCode + "'";
            exprStr = dbAccess.getDBColumnValue(tableName, columnName, condition, userInfoBean.getTransDB());
            if (exprStr != null && exprStr.trim().length() > 0) {
                E12EvaluateExpression e12EvalExpr = new E12EvaluateExpression();
                isEvaluation = e12EvalExpr.evaluateExpression(exprStr, this.xmlString);
            } else {
                isEvaluation = true;
            }
            dbAccess = null;
        }
        catch (Exception e) {
            BaseLogger.log((String)"2", (UserInfoBean)userInfoBean, null, (Object)("Exception :E12SMSComp :evaluateExpression :==>\n" + e.getMessage()));
            throw new ITMException(e);
        }
        return isEvaluation;
    }

    private String getMobileNo(String entityType, String entityCode, String responsibleFor) throws ITMException {
        String mobileNo = "";
        Connection conn = null;
        ConnDriver connDriver = null;
        Statement pstmtMob = null;
        ResultSet rsMob = null;
        try {
            try {
                int count = 1;
                connDriver = new ConnDriver();
                conn = connDriver.getConnectDB(this.userInfoBean.getTransDB());
                String mobileNoSql = "SELECT MOBILE_NO FROM ENTITY_CONTACT WHERE ENTITY_TYPE = ? AND ENTITY_CODE = ? AND RESPONSIBLE_FOR = ? ";
                pstmtMob = conn.prepareStatement(mobileNoSql);
                pstmtMob.setString(1, entityType);
                pstmtMob.setString(2, entityCode);
                pstmtMob.setString(3, responsibleFor);
                rsMob = pstmtMob.executeQuery();
                while (rsMob.next()) {
                    mobileNo = count == 1 ? (rsMob.getString("MOBILE_NO") == null ? "" : rsMob.getString("MOBILE_NO").trim()) : String.valueOf(mobileNo) + "," + (rsMob.getString("MOBILE_NO") == null ? "" : rsMob.getString("MOBILE_NO").trim());
                    ++count;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (conn != null) {
                    if (rsMob != null) {
                        rsMob.close();
                        rsMob = null;
                    }
                    if (pstmtMob != null) {
                        pstmtMob.close();
                        pstmtMob = null;
                    }
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception exception) {}
        }
        BaseLogger.log((String)"3", null, null, (Object)("mobileNo = [" + mobileNo + "]"));
        return mobileNo;
    }

    private String fillPlaceHolders(String smsUrl) {
        try {
            for (Object key : this.smsParamMap.keySet()) {
                String value = E12GenericUtility.checkNull((String)((String)this.smsParamMap.get(key)));
                String placeHolder = "{" + key + "}";
                smsUrl = smsUrl.replace(placeHolder, value);
            }
        }
        catch (Exception ex) {
            BaseLogger.log((String)"0", null, null, (Object)("#### Exception in E12SMSComp :: getNewSmsUrl : [" + ex + "]"));
        }
        return smsUrl;
    }

    private String checkNull(String nullStr) {
        return E12GenericUtility.checkNull((String)nullStr);
    }

    public static enum SMSType {
        PROMOTIONAL,
        TRANSACTIONAL,
        OTP;

    }
}

