package ibase.webitm.servlet.wsfa;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.json.JSONObject;

import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.wsfa.masters.SellsStock;

public class SalesPerformanceServlet extends HttpServlet 
{
	private static final long serialVersionUID = 1L;

	public void doGet(HttpServletRequest request,HttpServletResponse response) throws IOException, ServletException
	{
		BaseLogger.log( "2", null, null, "Inside doGet....SalesPerformanceServlet" );
		doPost(request, response);
	}

	public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException
	{
		BaseLogger.log( "2", null, null, "In SalesPerformanceServlet" );
		String responseStr = "";
		try
		{
			HttpSession session = request.getSession();
			
			UserInfoBean userInfo = (UserInfoBean) session.getAttribute( "USER_INFO" );
			if( userInfo != null )
			{
				String prdCode = checkNull( request.getParameter("PRD_CODE"));
				BaseLogger.log( "3", userInfo, null, "USER_INFO : ["+ userInfo +"], prd_code : ["+ prdCode +"]" );

				JSONObject data = new JSONObject();
				data.put("prd_code", prdCode);
				data.put("pos_code", "");
				data.put("stan_code", "");

				SellsStock stock = new SellsStock();
				responseStr = stock.getSellPerformance( data.toString(), userInfo );
				BaseLogger.log( "3", userInfo, null, "resultStr ["+ responseStr +"]" );
			}
		}
		catch (Exception e)
		{
			BaseLogger.log( "0", null, null, "Exception :: SalesPerformanceServlet : ["+ responseStr +"]" );
			e.printStackTrace();
		}
		response.getWriter().write( responseStr );
	}

	private String checkNull( String nullStr )
	{
		return E12GenericUtility.checkNull(nullStr);
	}
}