/*
 * Decompiled with CFR 0.152.
 */
package ibase.bi.ejb.session;

import ibase.bi.ejb.session.PopUpDataAccessEJB;
import ibase.bi.ejb.session.PopUpLocal;
import ibase.bi.ejb.session.PopUpProperties;
import ibase.bi.ejb.session.PopUpRemote;
import ibase.bi.utility.BIException;
import ibase.system.config.AppConnectParm;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.RandomAccessFile;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.Stateless;
import javax.naming.InitialContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Stateless(name="BIPopUpEJB")
public class PopUpEJB
implements PopUpRemote,
PopUpLocal {
    static HashMap allPopUpList;

    @PostConstruct
    public void postConstructCallback() {
        BaseLogger.log("2", null, null, "PopUpEJB PostConstruct -  ");
    }

    @PreDestroy
    public void preDestroyCallback() {
        BaseLogger.log("2", null, null, "PopUpEJB  PreDestory -   ");
    }

    @Override
    public void createPopUpList(String databaseParam) throws RemoteException, Exception {
        BaseLogger.log("1", null, null, "createPopUpList databaseParam :" + databaseParam);
        try {
            BaseLogger.log("1", null, null, "createPopUpList databaseParam allPopUpList:" + allPopUpList);
            if (allPopUpList == null) {
                BaseLogger.log("1", null, null, "createPopUpList databaseParam allPopUpList if");
                allPopUpList = new HashMap();
            }
            if (allPopUpList.containsKey(databaseParam)) {
                BaseLogger.log("1", null, null, "createPopUpList databaseParam !allPopUpList else");
                return;
            }
            BaseLogger.log("1", null, null, "createPopUpList databaseParam !allPopUpList if");
            AppConnectParm appConnect = new AppConnectParm("bi");
            Properties props = appConnect.getProperty();
            InitialContext ctx = new InitialContext(props);
            PopUpDataAccessEJB popUpDataAccess = new PopUpDataAccessEJB();
            String popUpString = popUpDataAccess.getAllPopUpString(databaseParam);
            allPopUpList.put(databaseParam, this.getPopUpList(popUpString));
        }
        catch (Exception e) {
            BaseLogger.log("1", null, null, "createPopUpList databaseParam !exception " + e);
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    private HashMap getPopUpList(String popUpString) throws Exception {
        String modName = "BI";
        boolean pgContext = false;
        HashMap<String, PopUpProperties> popUpList = new HashMap<String, PopUpProperties>();
        try {
            if (popUpString != null && popUpString.length() > 0) {
                DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                ByteArrayInputStream bais = new ByteArrayInputStream(popUpString.getBytes());
                Document doc = docBuilder.parse(bais);
                NodeList popUpTags = doc.getElementsByTagName("POPUP");
                int ctr = 0;
                while (ctr < popUpTags.getLength()) {
                    Node eachPopUp = popUpTags.item(ctr);
                    PopUpProperties popUpProperties = this.createPopUpProperties(eachPopUp);
                    popUpList.put(popUpProperties.getID(), popUpProperties);
                    ++ctr;
                }
            } else {
                popUpList = null;
            }
            return popUpList;
        }
        catch (Exception e) {
            popUpList = null;
            throw e;
        }
    }

    private PopUpProperties createPopUpProperties(Node popUpTag) throws Exception {
        PopUpProperties popUpProperties = new PopUpProperties();
        NamedNodeMap attributeMap = popUpTag.getAttributes();
        int ctr = 0;
        while (ctr < attributeMap.getLength()) {
            Node eachAttribute = attributeMap.item(ctr);
            String attributeName = eachAttribute.getNodeName().trim();
            String attributeValue = eachAttribute.getNodeValue().trim();
            if (attributeName.equalsIgnoreCase("ID")) {
                popUpProperties.setID(attributeValue);
            } else if (attributeName.equalsIgnoreCase("SQL_STR")) {
                popUpProperties.setSQL_STR(attributeValue);
            } else if (attributeName.equalsIgnoreCase("DW_OBJECT")) {
                popUpProperties.setDW_OBJECT(attributeValue);
            } else if (attributeName.equalsIgnoreCase("MSG_TITLE")) {
                popUpProperties.setMSG_TITLE(attributeValue);
            } else if (attributeName.equalsIgnoreCase("WIDTH")) {
                popUpProperties.setWIDTH(attributeValue);
            } else if (attributeName.equalsIgnoreCase("HEIGHT")) {
                popUpProperties.setHEIGHT(attributeValue);
            } else if (attributeName.equalsIgnoreCase("CHG_DATE")) {
                popUpProperties.setCHG_DATE(attributeValue);
            } else if (attributeName.equalsIgnoreCase("CHG_USER")) {
                popUpProperties.setCHG_USER(attributeValue);
            } else if (attributeName.equalsIgnoreCase("CHG_TERM")) {
                popUpProperties.setCHG_TERM(attributeValue);
            } else if (attributeName.equalsIgnoreCase("DIST_OPT")) {
                popUpProperties.setDIST_OPT(attributeValue);
            } else if (attributeName.equalsIgnoreCase("FILTER_STRING")) {
                popUpProperties.setFILTER_STRING(attributeValue);
            } else if (attributeName.equalsIgnoreCase("SQL_INPUT")) {
                popUpProperties.setSQL_INPUT(attributeValue);
            } else if (attributeName.equalsIgnoreCase("DEFAULT_COL")) {
                popUpProperties.setDEFAULT_COL(attributeValue);
            } else if (attributeName.equalsIgnoreCase("POP_ALIGN")) {
                popUpProperties.setPOP_ALIGN(attributeValue);
            } else if (attributeName.equalsIgnoreCase("QUERY_MODE")) {
                popUpProperties.setQUERY_MODE(attributeValue);
            } else if (attributeName.equalsIgnoreCase("MULTI_OPT")) {
                popUpProperties.setMultiOptionPopUp(attributeValue);
            }
            ++ctr;
        }
        return popUpProperties;
    }

    @Override
    public void getHelpString(String[] fieldNames, String modName, int pgContext) throws RemoteException, Exception {
    }

    @Override
    public String getCurrentPopUpInfo(String[] fieldNames, String databaseParam) throws RemoteException, Exception {
        try {
            String retString = "";
            StringBuffer popUpInfoBuffer = new StringBuffer();
            String modName = "BI";
            int pgContext = 0;
            HashMap popUpList = (HashMap)allPopUpList.get(databaseParam);
            int ctr = 0;
            while (ctr < fieldNames.length) {
                BaseLogger.log("3", null, null, " fieldNames[ctr].trim() :" + fieldNames[ctr].trim());
                boolean isPresent = false;
                String key = String.valueOf(fieldNames[ctr].trim()) + "~" + modName + "~" + pgContext;
                if (popUpList.containsKey(key)) {
                    isPresent = true;
                } else {
                    key = String.valueOf(fieldNames[ctr].trim()) + "~" + "X" + "~" + pgContext;
                    if (popUpList.containsKey(key)) {
                        isPresent = true;
                    }
                }
                BaseLogger.log("3", null, null, "isPresent :" + isPresent);
                BaseLogger.log("3", null, null, "key :" + key);
                if (isPresent) {
                    PopUpProperties popUpProperties = (PopUpProperties)popUpList.get(key);
                    String colName = key.substring(0, key.indexOf("~"));
                    if (popUpProperties.getSQL_INPUT() != null) {
                        popUpInfoBuffer.append("<" + colName + " dataSensitive='YES'" + " width='" + popUpProperties.getWIDTH() + "' height='" + popUpProperties.getHEIGHT() + "'>");
                        popUpInfoBuffer.append(popUpProperties.getSQL_INPUT());
                        popUpInfoBuffer.append("</" + colName + ">");
                    } else {
                        popUpInfoBuffer.append("<" + colName + " dataSensitive='NO'" + " width='" + popUpProperties.getWIDTH() + "' height='" + popUpProperties.getHEIGHT() + "'/>");
                    }
                }
                ++ctr;
            }
            retString = popUpInfoBuffer.length() > 0 ? "<DOCUMENTROOT><POPUPINFO>" + popUpInfoBuffer.toString() + "</POPUPINFO>" + "</DOCUMENTROOT>" : null;
            return retString;
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public String getCurrentPopUpInfo(String[] fieldNames, String databaseParam, String modName) throws RemoteException, Exception {
        try {
            BaseLogger.log("3", null, null, "PopUPEHB getCurrentPopUpInfo [" + modName + "] ");
            String retString = "";
            StringBuffer popUpInfoBuffer = new StringBuffer();
            if (modName == null) {
                modName = "BI";
            }
            int pgContext = 0;
            HashMap popUpList = (HashMap)allPopUpList.get(databaseParam);
            int ctr = 0;
            while (ctr < fieldNames.length) {
                BaseLogger.log("3", null, null, " fieldNames[ctr].trim() :" + fieldNames[ctr].trim());
                boolean isPresent = false;
                if (fieldNames[ctr].contains("__")) {
                    fieldNames[ctr] = fieldNames[ctr].trim();
                }
                BaseLogger.log("3", null, null, "fieldName [" + fieldNames[ctr] + "]");
                String key = String.valueOf(fieldNames[ctr].trim()) + "~" + modName + "~" + pgContext;
                if (popUpList.containsKey(key)) {
                    isPresent = true;
                } else {
                    key = String.valueOf(fieldNames[ctr].trim()) + "~" + "BI" + "~" + pgContext;
                    if (popUpList.containsKey(key)) {
                        isPresent = true;
                    } else {
                        key = String.valueOf(fieldNames[ctr].trim()) + "~" + "X" + "~" + pgContext;
                        if (popUpList.containsKey(key)) {
                            isPresent = true;
                        }
                    }
                }
                BaseLogger.log("3", null, null, "isPresent :" + isPresent);
                BaseLogger.log("3", null, null, "key :" + key);
                if (isPresent) {
                    PopUpProperties popUpProperties = (PopUpProperties)popUpList.get(key);
                    String colName = key.substring(0, key.indexOf("~"));
                    if (popUpProperties.getSQL_INPUT() != null) {
                        popUpInfoBuffer.append("<" + colName + " dataSensitive='YES'" + " width='" + popUpProperties.getWIDTH() + "' height='" + popUpProperties.getHEIGHT() + "'>");
                        popUpInfoBuffer.append(popUpProperties.getSQL_INPUT());
                        popUpInfoBuffer.append("</" + colName + ">");
                    } else {
                        popUpInfoBuffer.append("<" + colName + " dataSensitive='NO'" + " width='" + popUpProperties.getWIDTH() + "' height='" + popUpProperties.getHEIGHT() + "'/>");
                    }
                }
                ++ctr;
            }
            retString = popUpInfoBuffer.length() > 0 ? "<DOCUMENTROOT><POPUPINFO>" + popUpInfoBuffer.toString() + "</POPUPINFO>" + "</DOCUMENTROOT>" : null;
            BaseLogger.log("3", null, null, "PopUpEJB getCurrentPopUpInfo  [" + retString + "]");
            return retString;
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public String getPopUpValues(String fieldName, String fieldType, String[] parameters, String databaseParam, String userInfoStr) throws RemoteException, Exception {
        try {
            String retString = "";
            String data = "";
            String modName = "BI";
            int pgContext = 0;
            String key = String.valueOf(fieldName) + "~" + modName + "~" + pgContext;
            HashMap popUpList = (HashMap)allPopUpList.get(databaseParam);
            if (!popUpList.containsKey(key)) {
                key = String.valueOf(fieldName) + "~" + "X" + "~" + pgContext;
            }
            BaseLogger.log("3", null, null, "key :" + key);
            String dataQuery = "";
            PopUpProperties popUpProperties = (PopUpProperties)popUpList.get(key);
            popUpProperties.setFIELD_TYPE(fieldType);
            String distOption = popUpProperties.getDIST_OPT();
            String filterString = popUpProperties.getFILTER_STRING();
            if (distOption == "") {
                dataQuery = popUpProperties.getSQL_STR();
                retString = data = this.getFilteredData(filterString, dataQuery, parameters, null, popUpProperties, databaseParam, userInfoStr);
            } else if (distOption == "1") {
                retString = null;
            } else if (distOption == "2") {
                retString = null;
            } else if (distOption == "3") {
                String fileName = String.valueOf(fieldName) + "_" + modName + "_" + pgContext;
                File file = new File(String.valueOf(CommonConstants.BIHOME) + File.separator + "popupxml" + File.separator + fileName + ".xml");
                if (file.exists()) {
                    retString = data = this.getFilteredData(filterString, file);
                } else {
                    dataQuery = popUpProperties.getSQL_STR();
                    retString = data = this.getFilteredData(filterString, dataQuery, parameters, fileName, popUpProperties, databaseParam, userInfoStr);
                }
            }
            return retString;
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public String getPopUpValues(String fieldName, String fieldType, String[] parameters, String databaseParam, String userInfoStr, String modName) throws RemoteException, Exception {
        try {
            BaseLogger.log("3", null, null, "PopupEJB   getPopUpValues  modName [" + modName + "]");
            String retString = "";
            String data = "";
            if (modName == null) {
                modName = "BI";
            }
            int pgContext = 0;
            String key = String.valueOf(fieldName) + "~" + modName + "~" + pgContext;
            HashMap popUpList = (HashMap)allPopUpList.get(databaseParam);
            if (!popUpList.containsKey(key) && !popUpList.containsKey(key = String.valueOf(fieldName) + "~" + "BI" + "~" + pgContext)) {
                key = String.valueOf(fieldName) + "~" + "X" + "~" + pgContext;
            }
            BaseLogger.log("3", null, null, "key :" + key);
            String dataQuery = "";
            PopUpProperties popUpProperties = (PopUpProperties)popUpList.get(key);
            popUpProperties.setFIELD_TYPE(fieldType);
            int distOption = Integer.parseInt(popUpProperties.getDIST_OPT());
            String filterString = popUpProperties.getFILTER_STRING();
            if (distOption == 0) {
                dataQuery = popUpProperties.getSQL_STR();
                retString = data = this.getFilteredData(filterString, dataQuery, parameters, null, popUpProperties, databaseParam, userInfoStr);
            } else if (distOption == 1) {
                retString = null;
            } else if (distOption == 2) {
                retString = null;
            } else if (distOption == 3) {
                String fileName = String.valueOf(fieldName) + "_" + modName + "_" + pgContext;
                File file = new File(String.valueOf(CommonConstants.BIHOME) + File.separator + "popupxml" + File.separator + fileName + ".xml");
                if (file.exists()) {
                    retString = data = this.getFilteredData(filterString, file);
                } else {
                    dataQuery = popUpProperties.getSQL_STR();
                    retString = data = this.getFilteredData(filterString, dataQuery, parameters, fileName, popUpProperties, databaseParam, userInfoStr);
                }
            }
            return retString;
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    private String getFilteredData(String filterString, File file) throws Exception {
        String retString = "";
        try {
            RandomAccessFile raf = new RandomAccessFile(file, "r");
            byte[] xmlBytes = new byte[new Long(raf.length()).intValue()];
            raf.readFully(xmlBytes);
            String allData = new String(xmlBytes);
            raf.close();
            retString = this.applyFilter(filterString, allData);
        }
        catch (Exception e) {
            retString = null;
            throw e;
        }
        return retString;
    }

    private String getFilteredData(String filterString, String query, String[] parameters, String fileName, PopUpProperties popUpProperties, String databaseParam, String userInfoStr) throws Exception {
        String retString = "";
        try {
            AppConnectParm appConnect = new AppConnectParm("bi");
            Properties props = appConnect.getProperty();
            InitialContext ctx = new InitialContext(props);
            PopUpDataAccessEJB popUpDataAccess = new PopUpDataAccessEJB();
            String allData = popUpDataAccess.getPopUpData(query, parameters, databaseParam, userInfoStr, popUpProperties.getSQL_INPUT());
            String data = "<DOCUMENTROOT><DESCRIPTION></DESCRIPTION>" + this.getMetaData(popUpProperties) + "<GROUP0>" + "<DESCRIPTION></DESCRIPTION>" + "<HEADER0>" + "<DESCRIPTION></DESCRIPTION>" + allData + "</HEADER0>" + "</GROUP0>" + "</DOCUMENTROOT>";
            retString = this.applyFilter(filterString, data);
            if (fileName != null) {
                this.savePopUp(fileName, data);
            }
        }
        catch (Exception e) {
            retString = null;
            throw e;
        }
        return retString;
    }

    private String applyFilter(String filterString, String data) throws Exception {
        return data;
    }

    private void savePopUp(String fileName, String content) throws Exception {
        File file = new File(String.valueOf(CommonConstants.BIHOME) + File.separator + "popupxml" + File.separator + fileName + ".xml");
        FileOutputStream fos = new FileOutputStream(file);
        fos.write(content.getBytes());
        fos.close();
    }

    private String getMetaData(PopUpProperties popUpProperties) throws Exception {
        StringBuffer metaDataBuffer = new StringBuffer();
        metaDataBuffer.append("<METADATA><FIELD_NAME><![CDATA[" + popUpProperties.getFIELD_NAME() + "]]>" + "</FIELD_NAME>" + "<FIELD_TYPE>" + "<![CDATA[" + popUpProperties.getFIELD_TYPE() + "]]>" + "</FIELD_TYPE>" + "<MOD_NAME>" + "<![CDATA[" + popUpProperties.getMOD_NAME() + "]]>" + "</MOD_NAME>" + "<SQL_STR>" + "<![CDATA[" + popUpProperties.getSQL_STR() + "]]>" + "</SQL_STR>" + "<DW_OBJECT>" + "<![CDATA[" + popUpProperties.getDW_OBJECT() + "]]>" + "</DW_OBJECT>" + "<MSG_TITLE>" + "<![CDATA[" + popUpProperties.getMSG_TITLE() + "]]>" + "</MSG_TITLE>" + "<WIDTH>" + "<![CDATA[" + popUpProperties.getWIDTH() + "]]>" + "</WIDTH>" + "<HEIGHT>" + "<![CDATA[" + popUpProperties.getHEIGHT() + "]]>" + "</HEIGHT>" + "<CHG_DATE>" + "<![CDATA[" + popUpProperties.getCHG_DATE() + "]]>" + "</CHG_DATE>" + "<CHG_USER>" + "<![CDATA[" + popUpProperties.getCHG_USER() + "]]>" + "</CHG_USER>" + "<CHG_TERM>" + "<![CDATA[" + popUpProperties.getCHG_TERM() + "]]>" + "</CHG_TERM>" + "<DIST_OPT>" + "<![CDATA[" + popUpProperties.getDIST_OPT() + "]]>" + "</DIST_OPT>" + "<FILTER_STRING>" + "<![CDATA[" + popUpProperties.getFILTER_STRING() + "]]>" + "</FILTER_STRING>" + "<SQL_INPUT>" + "<![CDATA[" + popUpProperties.getSQL_INPUT() + "]]>" + "</SQL_INPUT>" + "<DEFAULT_COL>" + "<![CDATA[" + popUpProperties.getDEFAULT_COL() + "]]>" + "</DEFAULT_COL>" + "<POP_ALIGN>" + "<![CDATA[" + popUpProperties.getPOP_ALIGN() + "]]>" + "</POP_ALIGN>" + "<QUERY_MODE>" + "<![CDATA[" + popUpProperties.getQUERY_MODE() + "]]>" + "</QUERY_MODE>" + "<PAGE_CONTEXT>" + "<![CDATA[" + popUpProperties.getPAGE_CONTEXT() + "]]>" + "</PAGE_CONTEXT>" + "<MULTIPLE_OPT>" + "<![CDATA[" + popUpProperties.getMultiOptionPopUp() + "]]>" + "</MULTIPLE_OPT>" + "</METADATA>");
        return metaDataBuffer.toString();
    }
}

