/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.servlet;

import ibase.system.config.AppConnectParm;
import ibase.utility.BaseException;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.ejb.TransactionLinksEJB;
import ibase.webitm.utility.DB2XMLGenerator;
import ibase.webitm.utility.DWFactory;
import ibase.webitm.utility.DWObject;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeMap;
import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class TransLinkDataServlet
extends HttpServlet {
    private HashMap<String, String> objFormInfoMap = null;
    private String OBJ_INFO_SEPARATOR = ";";

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.doPost(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        BaseLogger.log("2", null, null, "****** TransLinkDataServlet Called******");
        E12GenericUtility genericUtility = new E12GenericUtility();
        String refSer = this.checkNull(request.getParameter("REFSER"));
        String refID = this.checkNull(request.getParameter("REFID"));
        String objName = this.checkNull(request.getParameter("OBJNAME"));
        String action = this.checkNull(request.getParameter("ACTION"));
        UserInfoBean userInfo = (UserInfoBean)request.getSession().getAttribute("USER_INFO");
        BaseLogger.log("2", null, null, "RefSer [" + refSer + "] RefID[" + refID + "] objName[" + objName + "]");
        try {
            if (userInfo == null) {
                request.getSession().invalidate();
                throw new BaseException(new Exception("SESSION_EXPIRED"));
            }
            TransactionLinksEJB tle = new TransactionLinksEJB();
            if (refSer.length() == 0) {
                BaseLogger.log("3", null, null, "refSer is blank getting from objName");
                refSer = tle.getRefSerFromObjName(objName, userInfo);
            }
            if ("GET_XML_HDR_DATA".equals(action)) {
                String pkFieldValue = "";
                String responseStr = "";
                String tempRespStr = "";
                String objNameStr = this.checkNull(request.getParameter("OBJNAME_STR"));
                String pkFieldValueStr = this.checkNull(request.getParameter("PK_FLD_VALUE"));
                if (objNameStr.length() > 0) {
                    AppConnectParm appConnect = new AppConnectParm();
                    InitialContext ctx = new InitialContext(appConnect.getProperty());
                    String[] objNameArry = objNameStr.split("~~");
                    String[] pkFieldValueArry = pkFieldValueStr.split("~~");
                    int cnt = 0;
                    while (cnt < objNameArry.length) {
                        objName = objNameArry[cnt];
                        if (objName.length() > 0) {
                            pkFieldValue = pkFieldValueArry[cnt];
                            if (pkFieldValue.indexOf(",") != -1 || pkFieldValue.indexOf(":") != -1) {
                                if (pkFieldValue.endsWith(",")) {
                                    String[] pkFieldValArry;
                                    String[] stringArray = pkFieldValArry = pkFieldValue.split(",");
                                    int n = pkFieldValArry.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        String eachPkFieldVal = stringArray[n2];
                                        pkFieldValue = eachPkFieldVal.indexOf(":") != -1 ? eachPkFieldVal.replace(":", "") : eachPkFieldVal;
                                        ++n2;
                                    }
                                } else if (pkFieldValue.endsWith(":")) {
                                    pkFieldValue = pkFieldValue.indexOf(":") != -1 ? pkFieldValue.replace(":", "") : pkFieldValue;
                                }
                            }
                            DBAccessEJB dbAccess = new DBAccessEJB();
                            ArrayList objFormsDetailList = dbAccess.getObjFormsDetailList(objName, userInfo);
                            this.setObjFormInfoMap(objFormsDetailList);
                            BaseLogger.log("3", null, null, "\n\nTransLinkDataServlet : GET_XML_HDR_DATA : Request Parameters : ---------- \n OBJ_NAME : [" + objName + "] \n PK_FLD_VAL : [" + pkFieldValue + "]\n\n------------ END ---------");
                            String metaDataFileName = String.valueOf(objName) + "2" + this.getFormName("1");
                            DWFactory dws = new DWFactory(userInfo);
                            DWObject dwObject = dws.getDataWindow(metaDataFileName);
                            ArrayList primaryKeyLogNameList = dwObject.getPrimaryKeyLogNameList();
                            ArrayList primaryKeyDataTypeList = dwObject.getPrimaryKeyDataTypeList();
                            StringBuffer headerPKFieldNamesBuff = new StringBuffer();
                            StringBuffer headerPKFieldDataTypesBuff = new StringBuffer();
                            int i = 0;
                            while (i < primaryKeyLogNameList.size()) {
                                headerPKFieldNamesBuff.append((String)primaryKeyLogNameList.get(i)).append(":");
                                headerPKFieldDataTypesBuff.append((String)primaryKeyDataTypeList.get(i)).append(":");
                                ++i;
                            }
                            if (headerPKFieldNamesBuff.length() > 0) {
                                headerPKFieldNamesBuff.deleteCharAt(headerPKFieldNamesBuff.length() - 1);
                            }
                            String headerPKFieldDataTypes = headerPKFieldDataTypesBuff.toString();
                            DB2XMLGenerator db2xmlgen = new DB2XMLGenerator(objName);
                            db2xmlgen.setObjFormsDetailList(objFormsDetailList);
                            TreeMap headerXMLTreeMap = db2xmlgen.createDataMap(objName, "1", "2", pkFieldValue, headerPKFieldDataTypes, "", "Detail", userInfo.toString());
                            String tempStr = (String)headerXMLTreeMap.get(pkFieldValue);
                            tempRespStr = String.valueOf(tempRespStr) + tempStr;
                            dbAccess = null;
                        }
                        ++cnt;
                    }
                }
                responseStr = String.valueOf(responseStr) + "<?xml version='1.0' encoding='" + CommonConstants.ENCODING + "'?><root>" + tempRespStr + "</root>";
                BaseLogger.log("3", null, null, "\n\nTransLinkDataServlet : GET_XML_HDR_DATA : ResponseStr : --------\n\n " + responseStr + "\n\n------------ END ---------");
                if (!responseStr.contains("Detail1")) {
                    responseStr = "Failure";
                }
                BaseLogger.log("3", null, null, "responseStr for action [ " + action + " ] is [ " + responseStr + " ]");
                response.setContentType("text/xml; charset=" + CommonConstants.ENCODING);
                response.getWriter().write(responseStr);
            } else {
                String transDataStr = tle.getTransactionLinksData(refSer, refID, userInfo);
                response.setContentType("text/xml; charset=" + CommonConstants.ENCODING);
                response.setHeader("Cache-Control", "no-cache");
                response.getWriter().write(transDataStr);
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception occurs " + e.getMessage());
            try {
                e.printStackTrace();
                PrintWriter writer = response.getWriter();
                String errMsg = "";
                if (request.getSession().getAttribute("ERR_MSG") == null) {
                    response.setContentType("text/xml; charset=" + CommonConstants.ENCODING);
                    errMsg = genericUtility.createErrorString(e);
                } else {
                    String sessMsg = (String)request.getSession().getAttribute("ERR_MSG");
                    response.setContentType("text/html; charset=" + CommonConstants.ENCODING);
                    errMsg = "ERR_MSG :" + sessMsg;
                }
                response.setContentLength(errMsg.length());
                writer.println(errMsg);
                writer.flush();
                writer.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private String checkNull(String value) {
        if (value == null || "null".equalsIgnoreCase(value) || value.trim().length() == 0) {
            value = "";
        }
        return value;
    }

    private void setObjFormInfoMap(ArrayList dbValues) {
        try {
            this.objFormInfoMap = new HashMap();
            int i = 0;
            while (i < dbValues.size()) {
                ArrayList currForm = (ArrayList)dbValues.get(i);
                String title = (String)currForm.get(0);
                String objContext = (String)currForm.get(14);
                String scrType = currForm.get(15) == null ? "" : currForm.get(15);
                String dbFormType = currForm.get(16) == null ? "" : currForm.get(16);
                String formName = currForm.get(32) == null ? "" : currForm.get(32);
                String parentKeyCol = currForm.get(18) == null ? "" : currForm.get(18);
                BaseLogger.log("3", null, null, "objContext =[" + objContext + "], formName =[" + formName + "]");
                this.objFormInfoMap.put(objContext, String.valueOf(dbFormType) + this.OBJ_INFO_SEPARATOR + parentKeyCol + this.OBJ_INFO_SEPARATOR + scrType + this.OBJ_INFO_SEPARATOR + formName);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        BaseLogger.log("2", null, null, "MasterStateful >> setObjFormInfoMap >> this.objFromInfoMap ::" + this.objFormInfoMap);
    }

    private String getObjPropValue(String formNo, String objPropName) {
        String value;
        block11: {
            value = "";
            if (this.objFormInfoMap != null) break block11;
            BaseLogger.log("3", null, null, String.valueOf(objPropName) + "= []");
            return "";
        }
        try {
            String objFromInfo = this.objFormInfoMap.get(formNo);
            if (objFromInfo != null) {
                String[] strArr = objFromInfo.split(this.OBJ_INFO_SEPARATOR);
                if ("FORM_TYPE".equalsIgnoreCase(objPropName)) {
                    value = strArr != null && strArr.length > 0 ? strArr[0] : "";
                } else if ("PARENT_KEY_COL".equalsIgnoreCase(objPropName)) {
                    value = strArr != null && strArr.length > 1 ? strArr[1] : "";
                } else if ("SCR_FLAG".equalsIgnoreCase(objPropName)) {
                    value = strArr != null && strArr.length > 2 ? strArr[2] : "";
                } else if ("FORM_NAME".equalsIgnoreCase(objPropName)) {
                    value = strArr != null && strArr.length > 3 ? strArr[3] : "";
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        BaseLogger.log("2", null, null, String.valueOf(objPropName) + "= [" + value + "]");
        return value;
    }

    private String getFormName(String formNo) {
        String formName = this.getObjPropValue(formNo, "FORM_NAME");
        if (formName == null || formName.length() == 0) {
            formName = formNo;
        }
        return formName;
    }
}

