package ibase.webitm.utility.wsfa;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;

import javax.naming.InitialContext;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.FilterRegistration.Dynamic;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRegistration;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.SessionCookieConfig;
import javax.servlet.SessionTrackingMode;
import javax.servlet.descriptor.JspConfigDescriptor;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.Part;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import com.google.gwt.libideas.validation.client.Validator;

import ibase.ejb.CommonDBAccessEJB;
import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.ActionHandlerEJB;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.ejb.MasterStatefulLocal;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.ejb.dis.DistCommon;
import ibase.webitm.ejb.fin.FinCommon;
import ibase.webitm.ejb.sys.UtilMethods;
import ibase.webitm.utility.E12ExtServiceUtility;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.VisionEDIUtility;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;



public class SalesOrderApi extends ValidatorEJB
{
	private E12GenericUtility e12GenericUtility = new E12GenericUtility();

	public String callSorderJsonData(String dcrID,String xtraParam,Connection conn) throws ITMException
	{
		System.out.println("inside SalesSFAToSAPService callTheJsonCaseWise");
		PreparedStatement pstmt=null;
		PreparedStatement pstmt1=null;
		ResultSet rs1=null;
		boolean isLocalConn = false;
		ResultSet rs=null;
		UserInfoBean userInfo = null;

		//JSONObject obj = new JSONObject();
		String returnValue="<ROOT><STATUS><![CDATA[1]]></STATUS><RESULT><![CDATA[ SUCCESS ]]></RESULT></ROOT>";
		try
		{

			String userId = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParam,"loginCode");
			if ( getUserInfo() == null )
			{
				CommonDBAccessEJB commonDBAccessEJB = new CommonDBAccessEJB();
				setUserInfo( commonDBAccessEJB.createUserInfo( userId ) );
			}
			if ( conn == null )
			{
				String transDB = getUserInfo().getTransDB();

				ConnDriver connDriver = new ConnDriver();
				conn = connDriver.getConnectDB(transDB);
				connDriver = null;

				isLocalConn = true;
				System.out.println("Connection created...");
			}
			CommonMethods commonMethods = new CommonMethods(userId);

			String enterprise = "";
            String EntSql = "SELECT ENTERPRISE FROM USERS WHERE CODE=?";
            pstmt = conn.prepareStatement(EntSql);
            pstmt.setString(1, userId);
            rs = pstmt.executeQuery();
            if(rs.next())
            {
                enterprise = E12GenericUtility.checkNull(rs.getString("ENTERPRISE"));
                System.out.println("(enterprise:::"+enterprise);
            }
            if(pstmt != null)
            {
                pstmt.close();
                pstmt = null;
            }
            if(rs != null)
            {
                rs.close();
                rs = null;
            }
			String appId="SORDER";
			String tokenID="";
			 String tokenSQL = "SELECT TOKEN_ID FROM USER_ACC_CHANNEL WHERE APP_ID = ? ";
	            pstmt = conn.prepareStatement(tokenSQL);
	            pstmt.setString(1, appId);
	            rs = pstmt.executeQuery();
	            if(rs.next())
	            {
	            	tokenID = E12GenericUtility.checkNull(rs.getString("TOKEN_ID"));
	                System.out.println("(tokenID:::"+tokenID);
	            }
	            if(pstmt != null)
	            {
	                pstmt.close();
	                pstmt = null;
	            }
	            if(rs != null)
	            {
	                rs.close();
	                rs = null;
	            }

			String scCode="";
			AppConnectParm appConnect = new AppConnectParm();
			InitialContext initialContext = new InitialContext(appConnect.getProperty());
		
			/*String sql="SELECT distinct(SM.STRG_CODE) FROM STRG_MEET SM , STRG_MEET_ORDER SMO " + 
					"WHERE SM.DCR_ID=SMO.DCR_ID AND SM.STRG_CODE=SMO.STRG_CODE AND SM.DCR_ID = ? ";*/
			String sql="SELECT distinct(stockist_code) FROM STRG_MEET_ORDER WHERE DCR_ID = ? AND stockist_code IS NOT NULL ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, dcrID);
			rs = pstmt.executeQuery();
			while( rs.next())
			{	
				scCode=checkNull(rs.getString("stockist_code"));
				//scCode=checkNull(rs.getString("stockist_code"));
				String inputData="";
				String inputData1="";
				userInfo = getUserInfo();
				JSONObject salesInvSplitJSONobj = new JSONObject();
				//salesInvSplitJSONobj = getSordrData(dcrID,scCode,conn);
				inputData1 = getSorderXmlData(dcrID,scCode,conn);
				
				
				String XmlString = inputData1.toString();
				System.out.println("returnString:::::FOR XmlString"+XmlString);
				
				String objName="sorder";
				
				String formattedXML = commonMethods.getFormattedXML(XmlString,objName);
				System.out.println("formattedXML string output="+formattedXML);	
				BaseLogger.log("3", null, null, "formattedXML string output="+formattedXML);
				
				String jsonData = commonMethods.getSortedJson(formattedXML,objName);
				BaseLogger.log( "3", null, null, "Inside sendJSONData2UNS jsonData ["+ jsonData +"]" );
				
				JSONObject originalObject = new JSONObject(jsonData);
		        JSONObject extractedObject = new JSONObject();

		        JSONArray detail1Array = originalObject.getJSONObject("Root").getJSONArray("Detail1");
		        JSONArray detail2Array = originalObject.getJSONObject("Root").getJSONArray("Detail2");

		        JSONArray detail1ExtractedArray = new JSONArray();
		        for (int i = 0; i < detail1Array.length(); i++) {
		            JSONObject detail1Object = new JSONObject();
		            Map<String, Object> properties = new LinkedHashMap<>();
		            properties.put("cust_code", detail1Array.getJSONObject(i).optString("cust_code"));
		            properties.put("item_ser", detail1Array.getJSONObject(i).optString("item_ser"));
		            properties.put("site_code", detail1Array.getJSONObject(i).optString("site_code"));
		           // properties.put("site_code__ship", detail1Array.getJSONObject(i).optString("site_code__ship"));
		            for (Map.Entry<String, Object> entry : properties.entrySet()) {
		                detail1Object.put(entry.getKey(), entry.getValue());
		            }
		            detail1ExtractedArray.put(detail1Object);
		        }

		        JSONArray detail2ExtractedArray = new JSONArray();
		        for (int i = 0; i < detail2Array.length(); i++) {
		            JSONObject detail2Object = new JSONObject();
		            Map<String, Object> properties = new LinkedHashMap<>();
		            properties.put("item_code__ord", detail2Array.getJSONObject(i).optString("item_code__ord"));
		            properties.put("quantity", detail2Array.getJSONObject(i).optString("quantity"));
		            
		            //pun specific_instr field in map by Sanket D. 
		            properties.put("specific_instr", detail2Array.getJSONObject(i).optString("specific_instr"));
		           
		            for (Map.Entry<String, Object> entry : properties.entrySet()) {
		                detail2Object.put(entry.getKey(), entry.getValue());
		            }
		            detail2ExtractedArray.put(detail2Object);
		        }

		        JSONObject rootObject = new JSONObject();
		        rootObject.put("Detail1", detail1ExtractedArray);
		        rootObject.put("Detail2", detail2ExtractedArray);
		        extractedObject.put("Root", rootObject);
		        
		        

				System.out.println("Formated JSON gsb" + extractedObject.toString());
				//String jsonData = commonMethods.getSortedJson(formattedXML,objName);
				
				int detailCount=commonMethods.jsonDetailCount(extractedObject.toString());
				
				inputData=commonMethods.jsonFormatter(extractedObject.toString(),detailCount);
								
				//inputData=extractedObject.toString();
				
				System.out.println("Formated JSON inputData " + inputData);
				
				/*MasterStatefulLocal masterStateful = (MasterStatefulLocal)initialContext.lookup("ibase/MasterStatefulEJB/local");
				String reString = masterStateful.processRequest( getUserInfo(), inputData, false, conn);
				System.out.println("returnString:::::FOR DUMY"+reString);*/
				
				
				
				
				
				

				//System.out.println("salesInvSplitJSONobj...["+salesInvSplitJSONobj+"]");
				//System.out.println("inputData...["+inputData+"]");
				if(inputData != null)
				{
					//inputData=salesInvSplitJSONobj.toString();
					

					HttpServletRequest request=new HttpServletRequest() {
						
						public void setCharacterEncoding(String arg0) throws UnsupportedEncodingException {
							// TODO Auto-generated method stub
							
						}
						
						public void setAttribute(String arg0, Object arg1) {
							// TODO Auto-generated method stub
							
						}
						
						public void removeAttribute(String arg0) {
							// TODO Auto-generated method stub
							
						}
						
						public boolean isSecure() {
							// TODO Auto-generated method stub
							return false;
						}
						
						public int getServerPort() {
							// TODO Auto-generated method stub
							return 0;
						}
						
						public String getServerName() {
							// TODO Auto-generated method stub
							return null;
						}
						
						public String getScheme() {
							// TODO Auto-generated method stub
							return null;
						}
						
						public RequestDispatcher getRequestDispatcher(String arg0) {
							// TODO Auto-generated method stub
							return null;
						}
						
						public String getRemoteHost() {
							// TODO Auto-generated method stub
							return null;
						}
						
						public String getRemoteAddr() {
							// TODO Auto-generated method stub
							return null;
						}
						
						public String getRealPath(String arg0) {
							// TODO Auto-generated method stub
							return null;
						}
						
						public BufferedReader getReader() throws IOException {
							// TODO Auto-generated method stub
							return null;
						}
						
						@Override
						public String getProtocol() {
							// TODO Auto-generated method stub
							return null;
						}
						
						public String[] getParameterValues(String arg0) {
							// TODO Auto-generated method stub
							return null;
						}
						
						public Enumeration getParameterNames() {
							// TODO Auto-generated method stub
							return null;
						}
						
						public Map getParameterMap() {
							// TODO Auto-generated method stub
							return null;
						}
						
						public String getParameter(String arg0) {
							// TODO Auto-generated method stub
							return null;
						}
						
						public Enumeration getLocales() {
							// TODO Auto-generated method stub
							return null;
						}
						
						public Locale getLocale() {
							// TODO Auto-generated method stub
							return null;
						}
						
						public ServletInputStream getInputStream() throws IOException {
							// TODO Auto-generated method stub
							return null;
						}
						
						public String getContentType() {
							// TODO Auto-generated method stub
							return null;
						}
						
						public int getContentLength() {
							// TODO Auto-generated method stub
							return 0;
						}
						
						public String getCharacterEncoding() {
							// TODO Auto-generated method stub
							return null;
						}
						
						public Enumeration getAttributeNames() {
							// TODO Auto-generated method stub
							return null;
						}
						
						public Object getAttribute(String arg0) {
							// TODO Auto-generated method stub
							return null;
						}
						
						public boolean isUserInRole(String arg0) {
							// TODO Auto-generated method stub
							return false;
						}
						
						public boolean isRequestedSessionIdValid() {
							// TODO Auto-generated method stub
							return false;
						}
						
						public boolean isRequestedSessionIdFromUrl() {
							// TODO Auto-generated method stub
							return false;
						}
						
						public boolean isRequestedSessionIdFromURL() {
							// TODO Auto-generated method stub
							return false;
						}
						
						public boolean isRequestedSessionIdFromCookie() {
							// TODO Auto-generated method stub
							return false;
						}
						
						public Principal getUserPrincipal() {
							// TODO Auto-generated method stub
							return null;
						}
						
						public HttpSession getSession(boolean arg0) {
							// TODO Auto-generated method stub
							return null;
						}
						
						public HttpSession getSession() {
							// TODO Auto-generated method stub
							return null;
						}
						
						public String getServletPath() {
							// TODO Auto-generated method stub
							return null;
						}
						
						public String getRequestedSessionId() {
							// TODO Auto-generated method stub
							return null;
						}
						
						@Override
						public StringBuffer getRequestURL() {
							// TODO Auto-generated method stub
							return null;
						}
						
						public String getRequestURI() {
							// TODO Auto-generated method stub
							return null;
						}
						
						public String getRemoteUser() {
							// TODO Auto-generated method stub
							return null;
						}
						
						public String getQueryString() {
							// TODO Auto-generated method stub
							return null;
						}
						
						public String getPathTranslated() {
							// TODO Auto-generated method stub
							return null;
						}
						
						public String getPathInfo() {
							// TODO Auto-generated method stub
							return null;
						}
						
						public String getMethod() {
							// TODO Auto-generated method stub
							return null;
						}
						
						public int getIntHeader(String arg0) {
							// TODO Auto-generated method stub
							return 0;
						}
						
						public Enumeration getHeaders(String arg0) {
							// TODO Auto-generated method stub
							return null;
						}
						
						public Enumeration getHeaderNames() {
							// TODO Auto-generated method stub
							return null;
						}
						
						public String getHeader(String arg0) {
							// TODO Auto-generated method stub
							return null;
						}
						
						public long getDateHeader(String arg0) {
							// TODO Auto-generated method stub
							return 0;
						}
						
						public Cookie[] getCookies() {
							// TODO Auto-generated method stub
							return null;
						}
						
						public String getContextPath() {
							// TODO Auto-generated method stub
							return null;
						}
						
						public String getAuthType() {
							// TODO Auto-generated method stub
							return null;
						}

						public AsyncContext getAsyncContext() {
							// TODO Auto-generated method stub
							return null;
						}

						public DispatcherType getDispatcherType() {
							// TODO Auto-generated method stub
							return null;
						}

						public String getLocalAddr() {
							// TODO Auto-generated method stub
							return null;
						}

						public String getLocalName() {
							// TODO Auto-generated method stub
							return null;
						}

						public int getLocalPort() {
							// TODO Auto-generated method stub
							return 0;
						}

						public int getRemotePort() {
							// TODO Auto-generated method stub
							return 0;
						}

						public ServletContext getServletContext() {
							// TODO Auto-generated method stub
							return null;
						}

						public boolean isAsyncStarted() {
							// TODO Auto-generated method stub
							return false;
						}

						public boolean isAsyncSupported() {
							// TODO Auto-generated method stub
							return false;
						}

						public AsyncContext startAsync() throws IllegalStateException {
							// TODO Auto-generated method stub
							return null;
						}

						public AsyncContext startAsync(ServletRequest arg0, ServletResponse arg1)
								throws IllegalStateException {
							// TODO Auto-generated method stub
							return null;
						}

						public boolean authenticate(HttpServletResponse arg0) throws IOException, ServletException {
							// TODO Auto-generated method stub
							return false;
						}

						public Part getPart(String arg0) throws IOException, ServletException {
							// TODO Auto-generated method stub
							return null;
						}

						public Collection<Part> getParts() throws IOException, ServletException {
							// TODO Auto-generated method stub
							return null;
						}

						public void login(String arg0, String arg1) throws ServletException {
							// TODO Auto-generated method stub
							
						}

						public void logout() throws ServletException {
							// TODO Auto-generated method stub
							
						}
					} ;

					ServletContext context=new ServletContext() {

						public Dynamic addFilter(String arg0, String arg1) {
							// TODO Auto-generated method stub
							return null;
						}

						public Dynamic addFilter(String arg0, Filter arg1) {
							// TODO Auto-generated method stub
							return null;
						}

						public Dynamic addFilter(String arg0, Class<? extends Filter> arg1) {
							// TODO Auto-generated method stub
							return null;
						}

						public void addListener(String arg0) {
							// TODO Auto-generated method stub
							
						}

						public <T extends EventListener> void addListener(T arg0) {
							// TODO Auto-generated method stub
							
						}

						public void addListener(Class<? extends EventListener> arg0) {
							// TODO Auto-generated method stub
							
						}

						public javax.servlet.ServletRegistration.Dynamic addServlet(String arg0, String arg1) {
							// TODO Auto-generated method stub
							return null;
						}

						public javax.servlet.ServletRegistration.Dynamic addServlet(String arg0, Servlet arg1) {
							// TODO Auto-generated method stub
							return null;
						}

						public javax.servlet.ServletRegistration.Dynamic addServlet(String arg0,
								Class<? extends Servlet> arg1) {
							// TODO Auto-generated method stub
							return null;
						}

						public <T extends Filter> T createFilter(Class<T> arg0) throws ServletException {
							// TODO Auto-generated method stub
							return null;
						}

						public <T extends EventListener> T createListener(Class<T> arg0) throws ServletException {
							// TODO Auto-generated method stub
							return null;
						}

						public <T extends Servlet> T createServlet(Class<T> arg0) throws ServletException {
							// TODO Auto-generated method stub
							return null;
						}

						public void declareRoles(String... arg0) {
							// TODO Auto-generated method stub
							
						}

						public Object getAttribute(String arg0) {
							// TODO Auto-generated method stub
							return null;
						}

						public Enumeration<String> getAttributeNames() {
							// TODO Auto-generated method stub
							return null;
						}

						public ClassLoader getClassLoader() {
							// TODO Auto-generated method stub
							return null;
						}

						public ServletContext getContext(String arg0) {
							// TODO Auto-generated method stub
							return null;
						}

						public String getContextPath() {
							// TODO Auto-generated method stub
							return null;
						}

						public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
							// TODO Auto-generated method stub
							return null;
						}

						public int getEffectiveMajorVersion() {
							// TODO Auto-generated method stub
							return 0;
						}

						public int getEffectiveMinorVersion() {
							// TODO Auto-generated method stub
							return 0;
						}

						public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
							// TODO Auto-generated method stub
							return null;
						}

						public FilterRegistration getFilterRegistration(String arg0) {
							// TODO Auto-generated method stub
							return null;
						}

						public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
							// TODO Auto-generated method stub
							return null;
						}

						public String getInitParameter(String arg0) {
							// TODO Auto-generated method stub
							return null;
						}

						public Enumeration<String> getInitParameterNames() {
							// TODO Auto-generated method stub
							return null;
						}

						public JspConfigDescriptor getJspConfigDescriptor() {
							// TODO Auto-generated method stub
							return null;
						}

						public int getMajorVersion() {
							// TODO Auto-generated method stub
							return 0;
						}

						public String getMimeType(String arg0) {
							// TODO Auto-generated method stub
							return null;
						}

						public int getMinorVersion() {
							// TODO Auto-generated method stub
							return 0;
						}

						public RequestDispatcher getNamedDispatcher(String arg0) {
							// TODO Auto-generated method stub
							return null;
						}

						public String getRealPath(String arg0) {
							// TODO Auto-generated method stub
							return null;
						}

						public RequestDispatcher getRequestDispatcher(String arg0) {
							// TODO Auto-generated method stub
							return null;
						}

						public URL getResource(String arg0) throws MalformedURLException {
							// TODO Auto-generated method stub
							return null;
						}

						public InputStream getResourceAsStream(String arg0) {
							// TODO Auto-generated method stub
							return null;
						}

						public Set<String> getResourcePaths(String arg0) {
							// TODO Auto-generated method stub
							return null;
						}

						public String getServerInfo() {
							// TODO Auto-generated method stub
							return null;
						}

						public Servlet getServlet(String arg0) throws ServletException {
							// TODO Auto-generated method stub
							return null;
						}

						public String getServletContextName() {
							// TODO Auto-generated method stub
							return null;
						}

						public Enumeration<String> getServletNames() {
							// TODO Auto-generated method stub
							return null;
						}

						public ServletRegistration getServletRegistration(String arg0) {
							// TODO Auto-generated method stub
							return null;
						}

						public Map<String, ? extends ServletRegistration> getServletRegistrations() {
							// TODO Auto-generated method stub
							return null;
						}

						public Enumeration<Servlet> getServlets() {
							// TODO Auto-generated method stub
							return null;
						}

						public SessionCookieConfig getSessionCookieConfig() {
							// TODO Auto-generated method stub
							return null;
						}

						public void log(String arg0) {
							// TODO Auto-generated method stub
							
						}

						public void log(Exception arg0, String arg1) {
							// TODO Auto-generated method stub
							
						}

						public void log(String arg0, Throwable arg1) {
							// TODO Auto-generated method stub
							
						}

						public void removeAttribute(String arg0) {
							// TODO Auto-generated method stub
							
						}

						public void setAttribute(String arg0, Object arg1) {
							// TODO Auto-generated method stub
							
						}

						public boolean setInitParameter(String arg0, String arg1) {
							// TODO Auto-generated method stub
							return false;
						}

						public void setSessionTrackingModes(Set<SessionTrackingMode> arg0) {
							// TODO Auto-generated method stub
							
						}} ;
					System.out.println("Before visionediutility");

					VisionEDIUtility visionediutility = new VisionEDIUtility();
					E12ExtServiceUtility E12ExtServiceUtility = new E12ExtServiceUtility();
					System.out.println("after visionediutility");
					System.out.println("enterprise :-["+enterprise+"]");
					System.out.println("appId :-["+appId+"]");
					System.out.println("inputData :-["+inputData+"]");
					System.out.println("tokenID :-["+tokenID+"]");
					System.out.println("request :-["+request+"]");

					String  result= visionediutility.handleRequest( "sorder", enterprise, appId, inputData, "writefilesavetrans",tokenID, request );
					//String result = E12ExtServiceUtility.callSystemAction("A",  "sorder", inputData, tokenID, "XML", appId, request, context);
					
					BaseLogger.log( "2", null, null, "In VisionEDIService :: result : ["+ result +"]" );

					if(result.indexOf("errorCode")!=-1)
					{
						JSONObject obj = new JSONObject(result);

						String errorCode=obj.getString("errorCode");
						if("000".equalsIgnoreCase(errorCode))
						{
							returnValue="<ROOT><STATUS><![CDATA[1]]></STATUS><RESULT><![CDATA[ SUCCESS ]]></RESULT></ROOT>";

						}
						else
						{
							String errorMessage=obj.getString("errorMessage");
							returnValue=getErrorString(errorMessage);
						}


					}
					else if(result.indexOf("error")!=-1)
					{
						JSONObject obj = new JSONObject(result);
						JSONObject error = obj.getJSONObject("error");
						JSONObject message = error.getJSONObject("message");
						String value=message.getString("value");
						System.out.println("apiCallResponseJsonStr value in case of split invoice =["+value+"]");
						returnValue=getErrorString(value);

					}
							

				}
			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
		}
		catch (Exception e) 
		{
			throw new ITMException(e);
		}
		finally 
		{
			try 
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if( rs1 !=null )
				{
					rs1.close();
					rs1 = null;
				}
				if( pstmt1 !=null )
				{
					pstmt1.close();
					pstmt1 = null;
				}
				if( conn != null && isLocalConn )
				{
					conn.close();
					conn = null;
				}
			}
			catch (SQLException e) 
			{
				e.printStackTrace();
			}
		}
		return returnValue;
	}
	public JSONObject getSordrData(String dcrId,String scCode, Connection conn) throws ITMException
	{
		System.out.println("getSordrData method");
		JSONObject mainJsonData = new JSONObject();
		JSONObject mainJsonData1 = new JSONObject();
		JSONObject mainJsonData2 = new JSONObject();
		PreparedStatement pstmt=null;
		PreparedStatement pstmt1=null;
		ResultSet rs1=null;
		ResultSet rs=null;
		String sql="";
		String empCode="",siteCode="";

		String  mDlvsite = "", mOrdSite = "", mStatus = "",mCurrency = "", mTaxOpt = "", mSingleSer = "";
		double mExcRate = 0.00;
		String lsDeptcode="";
		String itemSer="";
		JSONObject customerAndItemJsonObj = new JSONObject();
		LinkedHashMap map=new LinkedHashMap();
		HashMap jsonMap=new HashMap();
		try
		{

			JSONObject customerJsonObj = new JSONObject();
			JSONArray customerJsonArray = new JSONArray();

			String empSql="SELECT SALES_PERS FROM SPRS_ACT_TRAN WHERE DCR_ID = ? ";
			pstmt = conn.prepareStatement(empSql);
			pstmt.setString(1, dcrId);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				empCode = checkNull(rs.getString("SALES_PERS"));
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}

			sql = "select dept_code,emp_Site from employee where emp_code  = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, empCode);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				lsDeptcode = checkNull(rs.getString("dept_code"));
				siteCode = checkNull(rs.getString("emp_Site"));
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}

			sql = "select ITEM_SER from SALES_PERS where SALES_PERS  = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, empCode);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				itemSer = checkNull(rs.getString("ITEM_SER"));
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}


			customerJsonObj.put("dept_code",lsDeptcode);
			customerJsonObj.put("site_code",siteCode);
			customerJsonObj.put("site_code__ship",siteCode);
			customerJsonObj.put("emp_code__ord",empCode);


			sql = "Select site_code__dlv, site_code__ord, status, curr_code__purc,tax_opt, single_ser from Purcctrl";
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			if (rs.next()) 
			{
				mDlvsite = checkNull(rs.getString("site_code__dlv"));
				mOrdSite = checkNull(rs.getString("site_code__ord"));
				mStatus = checkNull(rs.getString("status"));
				mCurrency = checkNull(rs.getString("curr_code__purc"));
				mTaxOpt = checkNull(rs.getString("tax_opt"));
				mSingleSer = checkNull(rs.getString("single_ser"));
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}

			customerJsonObj.put("curr_code",mCurrency);

			sql = "Select std_exrt from currency where curr_code = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, mCurrency);
			rs = pstmt.executeQuery();
			if (rs.next()) 
			{
				mExcRate = rs.getDouble("std_exrt");
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}

			customerJsonObj.put("exch_rate",mExcRate);
			customerJsonObj.put("comm_perc_on_1","A");
			customerJsonObj.put("comm_perc_on_2","A");

			String eventDate="";
			String customerSql="SELECT TRAN_ID,EVENT_DATE,STRG_CODE,STRG_NAME,STRG_TYPE,SALES_PERS FROM STRG_MEET WHERE DCR_ID = ? ";
			pstmt = conn.prepareStatement(customerSql);
			pstmt.setString(1, dcrId);
			//pstmt.setString(2, scCode);
			rs = pstmt.executeQuery();
			if(rs.next()) 
			{

				eventDate=checkNull(rs.getString("EVENT_DATE"));
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			String fromDt = e12GenericUtility.getValidDateString(eventDate.toString(),e12GenericUtility.getDBDateFormat(), e12GenericUtility.getApplDateFormat());
			System.out.println("fromDt ====="+fromDt);

			customerJsonObj.put("sale_order","");
			customerJsonObj.put("cust_code", scCode);
			customerJsonObj.put("item_ser", itemSer);

			//customerJsonObj.put("order_type", "DS");
			//customerJsonObj.put("cr_term", "CD021");
			customerJsonObj.put("tax_date",fromDt);
			customerJsonObj.put("status_date",fromDt);
			customerJsonObj.put("order_date",fromDt);
			customerJsonObj.put("due_date",fromDt);

			customerJsonArray.put(customerJsonObj);				


			String orderSql="SELECT DCR_ID,LINE_NO,ITEM_CODE,QUANTITY,RATE FROM STRG_MEET_ORDER WHERE DCR_ID = ? and stockist_code = ? ";
			pstmt1 = conn.prepareStatement(orderSql);
			pstmt1.setString(1, dcrId);
			pstmt1.setString(2, scCode);
			rs1 = pstmt1.executeQuery();
			JSONArray itemJsonDataArray = new JSONArray();
			while(rs1.next()) 
			{

				String itemCode=checkNull(rs1.getString("ITEM_CODE"));
				int quantity=rs1.getInt("QUANTITY");
				double rate=rs1.getDouble("RATE");

				JSONObject itemJsonData = new JSONObject();

				itemJsonData.put("sale_order", "");

				itemJsonData.put("item_code__ord",itemCode);
				itemJsonData.put("item_code",itemCode);
				itemJsonData.put("item_ser",itemSer);
				itemJsonData.put("item_flg", "I");
				itemJsonData.put("quantity", quantity);
				itemJsonData.put("site_code", siteCode);
				itemJsonData.put("rate", rate);

				itemJsonData.put("cust_code", scCode);
				itemJsonData.put("cust_code__bil", scCode);
				//itemJsonData.put("order_type", "R");
				itemJsonData.put("dsp_date", fromDt);


				itemJsonDataArray.put(itemJsonData);
			}
			if(rs1 != null)
			{
				rs1.close();
				rs1 = null;
			}
			if(pstmt1 != null)
			{
				pstmt1.close();
				pstmt1 = null;
			}
			map.put("Detail1", customerJsonArray);
			map.put("Detail2", itemJsonDataArray);

			jsonMap.put("Detail1", customerJsonArray);
			jsonMap.put("Detail2", itemJsonDataArray);

			System.out.println("map ==== :"+map);
			System.out.println("jsonMap ==== :"+jsonMap);

			customerAndItemJsonObj.put("Detail1", customerJsonArray);
			customerAndItemJsonObj.put("Detail2", itemJsonDataArray);


			mainJsonData.put("Root",customerAndItemJsonObj);
			mainJsonData1.put("Root", map);
			mainJsonData2.put("Root", jsonMap);

			System.out.println("mainJsonData1 ==== :"+mainJsonData1);
			System.out.println("mainJsonData ==== :"+mainJsonData);
			System.out.println("mainJsonData2 ==== :"+mainJsonData2);
		}
		catch(Exception e)
		{
			System.out.println("Exception on json data getSordrData method");
			e.printStackTrace();
		}
		return 	mainJsonData2;

	}		



	public String checkNull(String input)
	{
		if (input == null || "null".equalsIgnoreCase(input))
		{
			input= "";
		}
		return input.trim();
	}
	private JSONObject getOrderedJSONObject(String json) 
	{
		JSONObject argumentJson = new JSONObject();
		try 
		{
			argumentJson = new JSONObject(json) {
                /**
                 * changes the value of JSONObject.map to a LinkedHashMap in order to maintain
                 * order of keys.
                 */
                @Override
                public JSONObject put(String key, Object value) throws JSONException {
                    try {
                        Field map = JSONObject.class.getDeclaredField("map");
                        map.setAccessible(true);
                        Object mapValue = map.get(this);
                        if (!(mapValue instanceof LinkedHashMap)) {
                            map.set(this, new LinkedHashMap<>());
                        }
                    } catch (NoSuchFieldException | IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                    return super.put(key, value);
                }
            };

		}
		catch (Exception e)
		{
			 e.printStackTrace();
		}
		return null;

	}
	public String getErrorString(String message)
	{
		StringBuffer valueXmlErrorString = new StringBuffer( "<?xmlversion=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<Errors>\r\n" );

		try
		{
			valueXmlErrorString.append("<error id=\"INVDATA\" type=\"E\" column_name=\"\">");
			valueXmlErrorString.append("<message><![CDATA[").append(message).append("]]></message>\r\n");
			valueXmlErrorString.append("<description><![CDATA[").append(message).append("]]></description>\r\n");
			valueXmlErrorString.append("<type>E</type>\r\n");
			valueXmlErrorString.append("<trace>Error : NO DATA</trace>\r\n");
			valueXmlErrorString.append("<redirect>1</redirect>\r\n");
			valueXmlErrorString.append("</error>\r\n");
			valueXmlErrorString.append("</Errors>\r\n");
			valueXmlErrorString.append("</Header>\r\n");
			valueXmlErrorString.append( "</Root>\r\n" );
			System.out.println( "\n****valueXmlErrorString :" + valueXmlErrorString.toString() + ":********" );


		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		return valueXmlErrorString.toString();
	}

	public String getSorderXmlData(String dcrId,String scCode, Connection conn) throws ITMException
	{
		System.out.println("getSorderXmlData method");

		PreparedStatement pstmt=null;
		PreparedStatement pstmt1=null;
		ResultSet rs1=null;
		ResultSet rs=null;
		String sql="";
		String empCode="",siteCode="";

		String  mDlvsite = "", mOrdSite = "", mStatus = "",mCurrency = "", mTaxOpt = "", mSingleSer = "";
		double mExcRate = 0.00;
		String lsDeptcode="";
		String itemSer="";
		StringBuffer valueXmlString = new StringBuffer();
		try
		{
			JSONObject customerJsonObj = new JSONObject();
			JSONArray customerJsonArray = new JSONArray();

			String empSql="SELECT SALES_PERS FROM SPRS_ACT_TRAN WHERE DCR_ID = ? ";
			pstmt = conn.prepareStatement(empSql);
			pstmt.setString(1, dcrId);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				empCode = checkNull(rs.getString("SALES_PERS"));
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}

			sql = "select dept_code,emp_Site from employee where emp_code  = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, empCode);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				lsDeptcode = checkNull(rs.getString("dept_code"));
				siteCode = checkNull(rs.getString("emp_Site"));
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}

			sql = "select ITEM_SER from SALES_PERS where SALES_PERS  = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, empCode);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				itemSer = checkNull(rs.getString("ITEM_SER"));
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}

			sql = "Select site_code__dlv, site_code__ord, status, curr_code__purc,tax_opt, single_ser from Purcctrl";
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			if (rs.next()) 
			{
				mDlvsite = checkNull(rs.getString("site_code__dlv"));
				mOrdSite = checkNull(rs.getString("site_code__ord"));
				mStatus = checkNull(rs.getString("status"));
				mCurrency = checkNull(rs.getString("curr_code__purc"));
				mTaxOpt = checkNull(rs.getString("tax_opt"));
				mSingleSer = checkNull(rs.getString("single_ser"));
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}

			sql = "Select std_exrt from currency where curr_code = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, mCurrency);
			rs = pstmt.executeQuery();
			if (rs.next()) 
			{
				mExcRate = rs.getDouble("std_exrt");
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}

			String eventDate="";
			String customerSql="SELECT TRAN_ID,EVENT_DATE,STRG_CODE,STRG_NAME,STRG_TYPE,SALES_PERS FROM STRG_MEET WHERE DCR_ID = ? ";
			pstmt = conn.prepareStatement(customerSql);
			pstmt.setString(1, dcrId);
			//pstmt.setString(2, scCode);
			rs = pstmt.executeQuery();
			if(rs.next()) 
			{

				eventDate=checkNull(rs.getString("EVENT_DATE"));
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			String fromDt = e12GenericUtility.getValidDateString(eventDate.toString(),e12GenericUtility.getDBDateFormat(), e12GenericUtility.getApplDateFormat());
			System.out.println("fromDt ====="+fromDt);
			String objContext="1";
			String objContext2="2";
			
			valueXmlString.append("<DocumentRoot><description>Datawindow Root</description><group0>");
			valueXmlString.append("<description>Group0 description</description><Header0><description>Header0 members</description>");
			valueXmlString.append("<objName><![CDATA[sorder]]></objName>");
			valueXmlString.append("<pageContext><![CDATA[1]]></pageContext>");
			//valueXmlString.append("<objContext><![CDATA[1]]></objContext>");
			valueXmlString.append("<editFlag><![CDATA[A]]></editFlag>");
			valueXmlString.append("<focusedColumn><![CDATA[]]></focusedColumn>");
			valueXmlString.append("<action><![CDATA[SAVE]]></action>");
			valueXmlString.append("<elementName><![CDATA[]]></elementName>");
			valueXmlString.append("<keyValue><![CDATA[1]]></keyValue>");
			valueXmlString.append("<taxKeyValue><![CDATA[]]></taxKeyValue>");
			valueXmlString.append("<saveLevel><![CDATA[1]]></saveLevel>");
			valueXmlString.append("<forcedSave><![CDATA[false]]></forcedSave>");
			valueXmlString.append("<taxInFocus><![CDATA[false]]></taxInFocus>");
			
			/*valueXmlString.append("<DocumentRoot>\r\n");
			valueXmlString.append("<description>Datawindow Root</description>\r\n");
			valueXmlString.append("<group0>\r\n");
			valueXmlString.append("<description>Group0 description</description>\r\n");
			valueXmlString.append("<Header0><description>Header0 members</description>\r\n");*/
			
			/*valueXmlString.append("<Detail1 dbID=\"\" domID=\"1\" formName=\"\" id=\"1:1:\" objContext=\"1\" objName=\"sorder\" taxcalcstat=\"0\" valdatastat=\"0\">\r\n");
			valueXmlString.append("<attribute IS_CHANGE=\"Y\" pkNames=\"\" selected=\"N\" status=\"N\" updateFlag=\"A\"/>\r\n");
			valueXmlString.append("<objContext>1</objContext><objName>sorder</objName><action>save</action>\r\n");*/
			
			valueXmlString.append("<Detail1 dbID='' domID='1'  objContext='"+objContext+"'  objName='sorder'>");
			valueXmlString.append("<attribute IS_CHANGE='Y' pkNames='' selected='N' status='N' updateFlag='A'/>");
			valueXmlString.append("<objContext><![CDATA[1]]></objContext>");
							
			valueXmlString.append("<sale_order><![CDATA[").append("").append("]]></sale_order>\r\n");
			valueXmlString.append("<cust_code><![CDATA[").append(scCode).append("]]></cust_code>\r\n");
			valueXmlString.append("<item_ser><![CDATA[").append(itemSer).append("]]></item_ser>\r\n");
			valueXmlString.append("<tax_date><![CDATA[").append(fromDt).append("]]></tax_date>\r\n");
			valueXmlString.append("<status_date><![CDATA[").append(fromDt).append("]]></status_date>\r\n");
			valueXmlString.append("<order_date><![CDATA[").append(fromDt).append("]]></order_date>\r\n");
			valueXmlString.append("<due_date><![CDATA[").append(fromDt).append("]]></due_date>\r\n");
			
			valueXmlString.append("<exch_rate><![CDATA[").append(mExcRate).append("]]></exch_rate>\r\n");
			valueXmlString.append("<comm_perc_on_1><![CDATA[").append("A").append("]]></comm_perc_on_1>\r\n");
			valueXmlString.append("<comm_perc_on_2><![CDATA[").append("A").append("]]></comm_perc_on_2>\r\n");
			valueXmlString.append("<curr_code><![CDATA[").append(mCurrency).append("]]></curr_code>\r\n");

			valueXmlString.append("<dept_code><![CDATA[").append(lsDeptcode).append("]]></dept_code>\r\n");
			valueXmlString.append("<site_code><![CDATA[").append(siteCode).append("]]></site_code>\r\n");
			valueXmlString.append("<site_code__ship><![CDATA[").append(siteCode).append("]]></site_code__ship>\r\n");
			valueXmlString.append("<emp_code__ord><![CDATA[").append(empCode).append("]]></emp_code__ord>\r\n");

			valueXmlString.append("</Detail1>\r\n");
			
			//Added changes in sql by sanket d. to get specific_instr and append in xml. on 13-jul-23
			String orderSql="SELECT DCR_ID,LINE_NO,ITEM_CODE,QUANTITY,RATE,specific_instr FROM STRG_MEET_ORDER WHERE DCR_ID = ? and stockist_code = ? ";
			pstmt1 = conn.prepareStatement(orderSql);
			pstmt1.setString(1, dcrId);
			pstmt1.setString(2, scCode);
			rs1 = pstmt1.executeQuery();
			int lineNo=1;
			while(rs1.next()) 
			{
				/*valueXmlString.append("<Detail2 dbID=\"\" domID="+lineNo+" formName=\"\" id=\"2:"+lineNo+":\" objContext=\"2\" objName=\"sorder\" taxcalcstat=\"0\" valdatastat=\"0\">\r\n");
				valueXmlString.append("<attribute IS_CHANGE=\"Y\" pkNames=\"\" selected=\"Y\" status=\"N\" updateFlag=\"A\"/>\r\n");
				valueXmlString.append("<objContext>1</objContext><objName>sorder</objName><action>save</action>\r\n");*/
		
				
				
				String itemCode=checkNull(rs1.getString("ITEM_CODE"));
				int quantity=rs1.getInt("QUANTITY");
				double rate=rs1.getDouble("RATE");
				String specificInstr=rs1.getString("specific_instr");
				
				valueXmlString.append("<Detail2 dbID='' domID='"+lineNo+"'  objContext='"+objContext2+"'  objName='sorder'>");
				valueXmlString.append("<attribute IS_CHANGE='Y' pkNames='' selected='N' status='N' updateFlag='A'/>");
				

				valueXmlString.append("<objContext><![CDATA[2]]></objContext>");
				valueXmlString.append("<sale_order><![CDATA[").append("").append("]]></sale_order>\r\n");
				valueXmlString.append("<line_no><![CDATA[").append(lineNo).append("]]></line_no>\r\n");
				valueXmlString.append("<item_code__ord><![CDATA[").append(itemCode).append("]]></item_code__ord>\r\n");
				valueXmlString.append("<item_code><![CDATA[").append(itemCode).append("]]></item_code>\r\n");
				valueXmlString.append("<item_ser><![CDATA[").append(itemSer).append("]]></item_ser>\r\n");
				valueXmlString.append("<item_flg><![CDATA[").append("I").append("]]></item_flg>\r\n");
				valueXmlString.append("<quantity><![CDATA[").append(quantity).append("]]></quantity>\r\n");
				valueXmlString.append("<site_code><![CDATA[").append(siteCode).append("]]></site_code>\r\n");
				valueXmlString.append("<rate><![CDATA[").append(rate).append("]]></rate>\r\n");
				
				valueXmlString.append("<cust_code><![CDATA[").append(scCode).append("]]></cust_code>\r\n");
				valueXmlString.append("<cust_code__bil><![CDATA[").append(scCode).append("]]></cust_code__bil>\r\n");
				valueXmlString.append("<dsp_date><![CDATA[").append(fromDt).append("]]></dsp_date>\r\n");
				
				//append specific_instr feild inn xml by Sanket d.
				valueXmlString.append("<specific_instr><![CDATA[").append(specificInstr).append("]]></specific_instr>\r\n");
				lineNo++;
				valueXmlString.append("</Detail2>\r\n");
			}
			if(rs1 != null)
			{
				rs1.close();
				rs1 = null;
			}
			if(pstmt1 != null)
			{
				pstmt1.close();
				pstmt1 = null;
			}
		
			/*valueXmlString.append("</Header0></group0>\r\n");	
			valueXmlString.append("</DocumentRoot>\r\n");*/
		
			valueXmlString.append("</Header0></group0></DocumentRoot>");
		
		}
		catch(Exception e)
		{
			System.out.println("Exception on json data getSordrData method");
			e.printStackTrace();
		}
		finally 
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if ( rs1 != null )
				{
					rs1.close();
					rs1 = null;
				}
				if ( pstmt1 != null )
				{
					pstmt1.close();
					pstmt1 = null;
				}
			}
			catch(Exception e)
			{
				throw new ITMException(e);
			}
		}
		System.out.println("\n****ValueXmlString :" + valueXmlString + ":********");
		return valueXmlString.toString();


	}	
}