package ibase.webitm.ejb.wsfa.transactions;

import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.sql.Timestamp;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.w3c.dom.Node;
import java.util.Date;
import javax.ejb.Stateless;
import javax.ejb.CreateException;

import ibase.utility.E12GenericUtility;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.GenericUtility;
import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ValidatorEJB;

//@Stateless				commented by Sagar M [22 Nov 2018].
public class TrfSprsRouteIc extends ValidatorEJB implements TrfSprsRouteIcLocal,TrfSprsRouteIcRemote
{
	E12GenericUtility genericUtility = new E12GenericUtility();

	public String wfValData() throws RemoteException,ITMException
	{
		return "";
	}

	public String itemChanged() throws RemoteException,ITMException
	{
		return "";
	}
	public String wfValData(String xmlString, String xmlString1,String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String  errString = null;
		Connection conn = null;
		System.out.println("Validation Start..........");
		try
		{
			System.out.println("xmlString:::"+xmlString);
			dom = parseString(xmlString);
			dom1 = parseString(xmlString1);
			if (xmlString2.trim().length() > 0 )
			{
				dom2 = parseString(xmlString2);
			}
			//ConnDriver connDriver = new ConnDriver();//Commented by vinayak on [11/07/2016]
			//conn = connDriver.getConnectDB("DriverITM");//Commented by vinayak on [11/07/2016]
			conn = getConnection();//Added by vinayak on [11/07/2016] to get connection.
			errString = wfValData( dom, dom1, dom2, objContext, editFlag, xtraParams, conn );
		}
		catch(Exception e)
		{
			System.out.println("Exception : TrfSprsRouteIc : wfValData(String xmlString) : ==>\n"+e.getMessage());
		}
		finally
		{
			try
			{
				if ( conn != null )
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception e1){}
		}
		return (errString);
	}
	public String wfValData( Document dom, Document dom1, Document dom2, String objContext, String editFlag, String xtraParams ) throws RemoteException,ITMException
	{
		String  errString = null;
		Connection conn = null;
		System.out.println("Validation Start..........");
		try
		{
			//Commented by vinayak on [11/07/2016] [start]
			/*ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");*/
			//Commented by vinayak on [11/07/2016] [end]
			conn = getConnection();//Added by vinayak on [11/07/2016] to get connection.
			errString = wfValData( dom, dom1, dom2, objContext, editFlag, xtraParams, conn );
		}
		catch(Exception e)
		{
			System.out.println("Exception : TrfSprsRouteIc : wfValData(String xmlString) : ==>\n"+e.getMessage());
		}
		finally
		{
			try
			{
				if ( conn != null )
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception e1){}
		}
		return (errString);
	}
	public String wfValData(Document dom, Document dom1,Document dom2, String objContext, String editFlag, String xtraParams, Connection conn ) throws RemoteException,ITMException
	{
		//Statement stmt = null;
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		String selectSql = "";
		String errString = "";
		String errCode = "";
		String childNodeName = null;
		String userId = "";
		String loginEmpCode = "";
		String empCodeMGR = "";
		String relieveDt = "";
		String userType = "";

		int ctr,currentFormNo=0;
		int childNodeListLength;
		int spCount = 0;
		int count = 0;

		java.sql.Date currDate = null;
		java.sql.Date joinDateDb = null;

		boolean localConn = false;

		try
		{
			if ( conn == null )
			{
				//Commented by vinayak on [11/07/2016] [start]
				/*ConnDriver connDriver = new ConnDriver();
				conn = connDriver.getConnectDB("DriverITM");*/
				//Commented by vinayak on [11/07/2016] [end]
				conn = getConnection();//Added by vinayak on [11/07/2016] to get connection.
				localConn = true;
			}

			//stmt = conn.createStatement();
			//E12GenericUtility genericUtility = new E12GenericUtility(); //Commented by vinayak on [29/04/2016] as object has been declared on class level
			userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"userId");
			loginEmpCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode");

			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getDBDateFormat());
			currDate = java.sql.Date.valueOf(sdf.format(new java.util.Date()));


			//empCodeMGR = getMGREmployee( loginEmpCode, conn );
			userType = checkNull(genericUtility.getColumnValue("user_type__login",dom));

			//Modified by Ganesh on [24/11/2012][To check Manager does not have right for copy data][Start]
			String procOpt = "";
			procOpt = genericUtility.getColumnValue("proc_opt",dom);
			//Modified by Ganesh on [24/11/2012][To check Manager does not have right for copy data][End]


			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			switch(currentFormNo)
			{
				case 1:
					parentNodeList = dom.getElementsByTagName("Detail1");
					parentNode = parentNodeList.item(0);
					childNodeList = parentNode.getChildNodes();
					childNodeListLength = childNodeList.getLength();
					//Modified by Ganesh on [24/11/2012][To check user does not have right for copy data ][Start]
					if ( (userType == null || !userType.trim().equalsIgnoreCase("H")) && procOpt.equalsIgnoreCase("C") )
					{
							errCode = "VPINVTFUSR";
							errString = getErrorString("proc_opt",errCode,userId);
							break;
					}
					//Modified by Ganesh on [24/11/2012][To check user does not have right for copy data][End]

					for(ctr = 0; ctr < childNodeListLength; ctr++)
					{
						int cnt;
						childNode = childNodeList.item(ctr);
						childNodeName = childNode.getNodeName();

						if (childNodeName.equals("sales_pers__from"))
						{
							if ( childNode.getFirstChild() == null )
							{
								errCode = "VMSALESPER";
								errString = getErrorString("sales_pers__from",errCode,userId);
								break;
							}
							else
							{
								String salesPersFrom = checkNull(genericUtility.getColumnValue("sales_pers__from",dom));

								selectSql = "SELECT COUNT(*) AS SPCNTR FROM SALES_PERS WHERE SALES_PERS = '"+ salesPersFrom +"' ";
								//Added by Bhagyashri To clear dirty connection[]11/01/22][start]
								pstmt = conn.prepareStatement(selectSql);
								rs = pstmt.executeQuery();
								//Added by Bhagyashri To clear dirty connection[]11/01/22][end]
								if(rs.next())
								{
									spCount = rs.getInt("SPCNTR");
								}
								//Added by Bhagyashri To clear dirty connection[]11/01/22][start]
								/*rs.close();
								rs = null;*/
								if (rs!= null)
								{
									rs.close();
									rs = null;
								}
								if(pstmt!=null)
								{
									pstmt.close();
									pstmt = null;
								}
								//Added by Bhagyashri To clear dirty connection[]11/01/22][end]
								if (spCount == 0)
								{
									errCode = "VSALPER";
									errString = getErrorString("sales_pers__from",errCode,userId);
									break;
								}

								selectSql = "SELECT DATE_JOIN FROM EMPLOYEE WHERE EMP_CODE = '"+salesPersFrom+"'";
								//rs = stmt.executeQuery(selectSql);
								//Added by Bhagyashri To clear dirty connection[]11/01/22][start]
								pstmt = conn.prepareStatement(selectSql);
								rs = pstmt.executeQuery();
								//Added by Bhagyashri To clear dirty connection[]11/01/22][end]
								if ( rs.next() )
								{
									joinDateDb = rs.getDate("DATE_JOIN");
								}
								//Added by Bhagyashri To clear dirty connection[]11/01/22][start]
								if (rs!= null)
								{
									rs.close();
									rs = null;
								}
								if(pstmt!=null)
								{
									pstmt.close();
									pstmt = null;
								}
								/*rs.close();
								rs = null;*/
								//Added by Bhagyashri To clear dirty connection[]11/01/22][end]
								if ( joinDateDb != null && currDate != null && currDate.before(joinDateDb) )
								{
									errCode = "VSALESPER1";
									errString = getErrorString("sales_pers__from",errCode,userId);
									break;
								}
								if ( userType != null && !userType.trim().equalsIgnoreCase("H") )
								{
									selectSql = "SELECT COUNT(*) AS COUNT FROM SALES_PERS WHERE SALES_PERS = '"+salesPersFrom+"' AND "+
												"SALES_PERS IN( SELECT EMP_CODE FROM EMPLOYEE START WITH EMP_CODE = '"+loginEmpCode+"' "+
												"CONNECT BY PRIOR EMP_CODE = REPORT_TO )";
									//rs = stmt.executeQuery(selectSql);
									//Added by Bhagyashri To clear dirty connection[]11/01/22][start]
									pstmt = conn.prepareStatement(selectSql);
									rs = pstmt.executeQuery();
									//Added by Bhagyashri To clear dirty connection[]11/01/22][end]
									if ( rs.next() )
									{
										spCount = rs.getInt("COUNT");
									}
									//Added by Bhagyashri To clear dirty connection[]11/01/22][start]
									/*rs.close();
									rs = null;*/
									if (rs!= null)
									{
										rs.close();
										rs = null;
									}
									if(pstmt!=null)
									{
										pstmt.close();
										pstmt = null;
									}
									//Added by Bhagyashri To clear dirty connection[]11/01/22][end]
									if ( spCount == 0 )
									{
										errCode = "VSALESPER2";
										errString = getErrorString("sales_pers__from",errCode,userId);
										break;
									}
								}
								//Start Added Gulzar - 31/05/10[WS90SUN018]
								selectSql = "SELECT COUNT(*) AS COUNT FROM SPRS_ROUTE WHERE SPRS_CODE = '"+ salesPersFrom +"' AND STATUS = 'Y' ";
								//rs = stmt.executeQuery(selectSql);
								//Added by Bhagyashri To clear dirty connection[]11/01/22][start]
								pstmt = conn.prepareStatement(selectSql);
								rs = pstmt.executeQuery();
								//Added by Bhagyashri To clear dirty connection[]11/01/22][end]
								if ( rs.next() )
								{
									count = rs.getInt("COUNT");
								}
								//Added by Bhagyashri To clear dirty connection[]11/01/22][start]
								/*rs.close();
								rs = null;*/
								if (rs!= null)
								{
									rs.close();
									rs = null;
								}
								if(pstmt!=null)
								{
									pstmt.close();
									pstmt = null;
								}
								//Added by Bhagyashri To clear dirty connection[]11/01/22][end]
								if ( count == 0 )
								{
									//Modified by Ramchandra on [12/07/2012] [To change message ]
									//errString = getErrorString("sales_pers__from","NOROUTEEXT",userId);
									errString = getErrorString("sales_pers__from","VPDTROUTE2",userId);
									break;
								}
								//End Added Gulzar - 31/05/10[WS90SUN018]
							}
						}
						else if (childNodeName.equals("sales_pers__to"))
						{
							if ( childNode.getFirstChild() == null ) //Condition Added By Gulzar - 25/08/08 Req ID: SY89SUN001
							{
								errCode = "VMSALESPER";
								errString = getErrorString("sales_pers__to",errCode,userId);
								break;
							}
							else
							{
								String salesPersTo = checkNull(genericUtility.getColumnValue("sales_pers__to",dom));

								selectSql = "SELECT COUNT(*) AS SPCNTR FROM SALES_PERS WHERE SALES_PERS = '"+ salesPersTo +"' ";
								//rs = stmt.executeQuery(selectSql);
								//Added by Bhagyashri To clear dirty connection[]11/01/22][start]
								pstmt = conn.prepareStatement(selectSql);
								rs = pstmt.executeQuery();
								//Added by Bhagyashri To clear dirty connection[]11/01/22][end]
								if(rs.next())
								{
									spCount = rs.getInt("SPCNTR");
								}
								//Added by Bhagyashri To clear dirty connection[]11/01/22][start]
								/*rs.close();
								rs = null;*/
								if (rs!= null)
								{
									rs.close();
									rs = null;
								}
								if(pstmt!=null)
								{
									pstmt.close();
									pstmt = null;
								}
								//Added by Bhagyashri To clear dirty connection[]11/01/22][end]
								if (spCount == 0)
								{
									errCode = "VSALPER";
									errString = getErrorString("sales_pers__from",errCode,userId);
									break;
								}

								selectSql = "SELECT DATE_JOIN, RELIEVE_DATE FROM EMPLOYEE WHERE EMP_CODE = '"+salesPersTo+"'";
								//rs = stmt.executeQuery(selectSql);
								//Added by Bhagyashri To clear dirty connection[]11/01/22][start]
								pstmt = conn.prepareStatement(selectSql);
								rs = pstmt.executeQuery();
								//Added by Bhagyashri To clear dirty connection[]11/01/22][end]
								if( rs.next() )
								{
									joinDateDb = rs.getDate("DATE_JOIN");
									relieveDt = rs.getString("RELIEVE_DATE");
								}
								//Added by Bhagyashri To clear dirty connection[]11/01/22][start]
								/*rs.close();
								rs = null;*/
								if (rs!= null)
								{
									rs.close();
									rs = null;
								}
								if(pstmt!=null)
								{
									pstmt.close();
									pstmt = null;
								}
								//Added by Bhagyashri To clear dirty connection[]11/01/22][end]
								if ( relieveDt != null && relieveDt.trim().length() > 0 )//Employee has been relieved
								{
									errCode = "RESIGNEMP";
									errString = getErrorString("sales_pers__to",errCode,userId);
									break;
								}
								if ( joinDateDb == null )
								{
									errCode = "NULLJOINDT";
									errString = getErrorString("sales_pers__to",errCode,userId);
									break;
								}
								else if ( joinDateDb != null && currDate != null && currDate.before(joinDateDb) )
								{
									errCode = "VSALESPER1";
									errString = getErrorString("sales_pers__to",errCode,userId);
									break;
								}
								if ( userType != null && !userType.trim().equalsIgnoreCase("H") )
								{
									selectSql = "SELECT COUNT(*) AS COUNT FROM SALES_PERS WHERE SALES_PERS = '"+salesPersTo+"' AND "+
												"SALES_PERS IN( SELECT EMP_CODE FROM EMPLOYEE START WITH EMP_CODE = '"+loginEmpCode+"' "+
												"CONNECT BY PRIOR EMP_CODE = REPORT_TO )";
									//rs = stmt.executeQuery(selectSql);
									//Added by Bhagyashri To clear dirty connection[]11/01/22][start]
									pstmt = conn.prepareStatement(selectSql);
									rs = pstmt.executeQuery();
									//Added by Bhagyashri To clear dirty connection[]11/01/22][end]
									if ( rs.next() )
									{
										spCount = rs.getInt("COUNT");
									}
									//Added by Bhagyashri To clear dirty connection[]11/01/22][start]
									/*rs.close();
									rs = null;*/
									if (rs!= null)
									{
										rs.close();
										rs = null;
									}
									if(pstmt!=null)
									{
										pstmt.close();
										pstmt = null;
									}
									//Added by Bhagyashri To clear dirty connection[]11/01/22][end]
									if ( spCount == 0 )
									{
										errCode = "VSALESPER2";
										errString = getErrorString("sales_pers__to",errCode,userId);
										break;
									}
									//Modified by Ganesh on [21/12/2012][As per mail received from Mandar on 21-12-2012 system should not allow to transfer doctor in case of manager login for target sales person available in SPRS_ROUTE ][Start]

									selectSql = "SELECT COUNT(*) AS COUNT FROM SPRS_ROUTE WHERE SPRS_CODE = '"+ salesPersTo +"'";
									//rs = stmt.executeQuery(selectSql);
									//Added by Bhagyashri To clear dirty connection[]11/01/22][start]
									pstmt = conn.prepareStatement(selectSql);
									rs = pstmt.executeQuery();
									//Added by Bhagyashri To clear dirty connection[]11/01/22][end]
									if ( rs.next() )
									{
										count = rs.getInt("COUNT");
									}
									//Added by Bhagyashri To clear dirty connection[]11/01/22][start]
									if (rs!= null)
									{
										rs.close();
										rs = null;
									}
									if(pstmt!=null)
									{
										pstmt.close();
										pstmt = null;
									}
									//Added by Bhagyashri To clear dirty connection[]11/01/22][end]
									if ( count > 0 )
									{
										errString = getErrorString("sales_pers__to","VPDTROUTE1",userId);
										break;
									}

									//Modified by Ganesh on [21/12/2012][As per mail received from Mandar on 21-12-2012 system should not allow to transfer doctor in case of manager login for target sales person available in SPRS_ROUTE][End]
								}

								//Modified by Rupesh on [05/10/2012][Stop to check routs for sales person in SPRS_ROUTE][Start]

								/*
								//Start Added Gulzar - 31/05/10[]
								selectSql = "SELECT COUNT(*) AS COUNT FROM SPRS_ROUTE WHERE SPRS_CODE = '"+ salesPersTo +"'";
								rs = stmt.executeQuery(selectSql);
								if ( rs.next() )
								{
									count = rs.getInt("COUNT");
								}
								rs.close();
								rs = null;
								if ( count > 0 )
								{

									//Modified by Ramchandra on [12/07/2012] [To change message ]
									//errString = getErrorString("sales_pers__to","VTROUTE",userId);
									errString = getErrorString("sales_pers__to","VPDTROUTE1",userId);
									break;
								}
								//End Added Gulzar - 31/05/10[]
								*/
								//Modified by Rupesh on [05/10/2012] [Stop to check routs for sales person in SPRS_ROUTE][End]

								//Modified by Ganesh on [24/11/2012][To check user does not have right for copy data][Start]
								/*
								//Modified by Rupesh on [05/10/2012] [Allow global copy only for HO user] [Start]


								String empCdHO = "";
								empCdHO = getHOEmployee(loginEmpCode, conn );
								System.out.println("empCdHO ===>>"+empCdHO);
								if (empCdHO == null || empCdHO.trim().length() == 0)
								{
									System.out.println("Invalid user for Global copy"+empCdHO);
									errString = getErrorString("sales_pers__to","VPINVTFUSR",userId);
									break;
								}
								//Modified by Rupesh on [05/10/2012] [Allow global copy only for HO user] [End]
								*/
								//Modified by Ganesh on [24/11/2012][To check user does not have right for copy data][End]
							}
						}
					}//END FOR
					break;
			}//END SWITCH
		}//END TRY
		catch(Exception e)
		{
			System.out.println("Exception ::"+e);
			e.printStackTrace();
		}
		finally
		{
			try
			{
				//Added by Bhagyashri To clear dirty connection[]11/01/22][start]
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				//Added by Bhagyashri To clear dirty connection[]11/01/22][start]
				if ( conn != null )
				{
					if ( localConn )
					{
						conn.close();
						conn = null;
					}
				}
			}catch(Exception d){}
		}
		System.out.println("ErrString ::"+ errString);
		return errString;
	}//END OF VALIDATION

	public String itemChanged(String xmlString, String xmlString1,String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String valueXmlString = null;
		try
		{
			dom = parseString(xmlString);
			System.out.println("xmlString" + xmlString);
			dom1 = parseString(xmlString1);
			if (xmlString2.trim().length() > 0 )
			{
				dom2 = parseString(xmlString2);
			}
			valueXmlString = itemChanged(dom,dom1,dom2,objContext,currentColumn,editFlag,xtraParams);
		}
		catch(Exception e)
		{
			System.out.println("Exception : [TrfSprsRouteIc][itemChanged(String,String)] :==>\n"+e.getMessage());
		}
        return valueXmlString;
	}

	public String itemChanged(Document dom, Document dom1,Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		Connection conn = null;
		//ConnDriver connDriver = new ConnDriver();//Commented by vinayak on [11/07/2016]
		Statement stmt = null;
		ResultSet rs = null;
		NodeList parentNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		NodeList childNodeList = null;
		String childNodeName = "";
		StringBuffer valueXmlString = new StringBuffer();
		String columnValue = "";
		String selectSql = "";
		String userId = "";
		String empCodeMGR = "";
		String empCodeHO = "";
		String relieveDt = "";

		int ctr = 0;
		int currentFormNo = 0;
		int spCount = 0;

		java.sql.Date currDate = null;
		java.sql.Date joinDateDb = null;

		Exception exc = new Exception("Editing is not allowed......");
		//E12GenericUtility genericUtility = new E12GenericUtility(); //Commented by vinayak on [29/04/2016] as object has been declared on class level
		try
		{
			//conn = connDriver.getConnectDB("DriverITM");//Commented by vinayak on [11/07/2016]
			conn = getConnection();//Added by vinayak on [11/07/2016] to get connection.
			conn.setAutoCommit(false);
			stmt = conn.createStatement();
			userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"userId");
			String loginEmpCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode");//Gulzar - 14/04/10

			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getDBDateFormat());
			currDate = java.sql.Date.valueOf(sdf.format(new java.util.Date()));
			empCodeMGR = getMGREmployee( loginEmpCode, conn );
			empCodeHO = getHOEmployee( loginEmpCode, conn );

			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			System.out.println("[TrfSprsRouteIc] [itemChanged] :currentFormNo ....." +currentFormNo);
			// Modified by Prashant on [13/05/2013][Request Id : ][To set values in cdata of xml and added encoding attribute]
			/*valueXmlString = new StringBuffer("<?xml version=\"1.0\"?><Root><header><editFlag>");
			valueXmlString.append(editFlag).append("</editFlag></header>"); */
			valueXmlString = new StringBuffer("<?xml version=\"1.0\" encoding='utf-8'?><Root><header><editFlag><![CDATA[");
			valueXmlString.append(editFlag).append("]]></editFlag></header>");
			valueXmlString.append("<Detail>");
			System.out.println("Current Form No ["+currentFormNo+"]");
			switch (currentFormNo)
			{
				case 1:
					parentNodeList = dom.getElementsByTagName("Detail1");
					parentNode = parentNodeList.item(0);
					childNodeList = parentNode.getChildNodes();
					ctr = 0;
					int childNodeListLength = childNodeList.getLength();
					do
					{
						childNode = childNodeList.item(ctr);
						childNodeName = childNode.getNodeName();
						if(childNodeName.equals(currentColumn))
						{
							if (childNode.getFirstChild() != null)
							{
								columnValue=childNode.getFirstChild().getNodeValue().trim();
							}
						}
						ctr++;
					}while(ctr < childNodeListLength  && !childNodeName.equals(currentColumn));
					if (currentColumn.trim().equals("itm_default"))
					{
						// Modified by Prashant on [13/05/2013][Request Id : ][To set values in cdata of xml]
						//valueXmlString.append("<entity_code__login>").append(loginEmpCode).append("</entity_code__login>\r\n");
						valueXmlString.append("<entity_code__login><![CDATA[").append(loginEmpCode).append("]]></entity_code__login>\r\n");
						if ( empCodeMGR != null && empCodeMGR.trim().length() > 0 )
						{
							// Modified by Prashant on [13/05/2013][Request Id : ][To set values in cdata of xml]
							//valueXmlString.append("<user_type__login>").append("M").append("</user_type__login>\r\n");
							valueXmlString.append("<user_type__login><![CDATA[").append("M").append("]]></user_type__login>\r\n");
						}
						else if ( empCodeHO != null && empCodeHO.trim().length() > 0 )
						{
							// Modified by Prashant on [13/05/2013][Request Id : ][To set values in cdata of xml]
							//valueXmlString.append("<user_type__login>").append("H").append("</user_type__login>\r\n");
							valueXmlString.append("<user_type__login><![CDATA[").append("H").append("]]></user_type__login>\r\n");
						}
						else
						{
							// Modified by Prashant on [13/05/2013][Request Id : ][To set values in cdata of xml]
							//valueXmlString.append("<user_type__login>").append("").append("</user_type__login>\r\n");
							valueXmlString.append("<user_type__login><![CDATA[").append("").append("]]></user_type__login>\r\n");
						}
						valueXmlString.append("<proc_opt><![CDATA[").append("T").append("]]></proc_opt>\r\n");

					}
					else if (currentColumn.trim().equals("sales_pers__from"))
					{
						String salesPersFrom = genericUtility.getColumnValue("sales_pers__from",dom);
						String spName = "";

						if (salesPersFrom != null && salesPersFrom.trim().length() > 0)
						{
							selectSql = "SELECT SP_NAME FROM SALES_PERS WHERE SALES_PERS = '"+ salesPersFrom +"' ";
							System.out.println("SQL for sp_name from sales_pers :: "+selectSql);
							rs = stmt.executeQuery(selectSql);
							if( rs.next() )
							{
								spName = checkNull(rs.getString("SP_NAME"));
							}
							rs.close();
							rs = null;

							selectSql = "SELECT DATE_JOIN FROM EMPLOYEE WHERE EMP_CODE = '"+salesPersFrom+"'";
							rs = stmt.executeQuery(selectSql);
							if ( rs.next() )
							{
								joinDateDb = rs.getDate("DATE_JOIN");
							}
							rs.close();
							rs = null;

							System.out.println("currDate...::"+currDate);
							System.out.println("joinDateDb...::"+joinDateDb);

							if ( joinDateDb != null && currDate != null && currDate.before(joinDateDb) )
							{
								// Modified by Prashant on [13/05/2013][Request Id : ][To set values in cdata of xml]
								//valueXmlString.append("<name_from>").append("").append("</name_from>\r\n");
								valueXmlString.append("<name_from><![CDATA[").append("").append("]]></name_from>\r\n");
							}
							else if ( empCodeHO == null || empCodeHO.trim().length() == 0 )
							{
								selectSql = "SELECT COUNT(*) AS COUNT FROM SALES_PERS WHERE SALES_PERS = '"+salesPersFrom+"' AND "+
											"SALES_PERS IN( SELECT EMP_CODE FROM EMPLOYEE START WITH EMP_CODE = '"+loginEmpCode+"' "+
											"CONNECT BY PRIOR EMP_CODE = REPORT_TO )";
								rs = stmt.executeQuery(selectSql);
								if ( rs.next() )
								{
									spCount = rs.getInt("COUNT");
								}
								rs.close();
								rs = null;
								if ( spCount == 0 )
								{
									// Modified by Prashant on [13/05/2013][Request Id : ][To set values in cdata of xml]
									//valueXmlString.append("<name_from>").append("").append("</name_from>\r\n");
									valueXmlString.append("<name_from><![CDATA[").append("").append("]]></name_from>\r\n");
								}
								else
								{
									// Modified by Prashant on [13/05/2013][Request Id : ][To set values in cdata of xml]
									//valueXmlString.append("<name_from>").append(spName).append("</name_from>\r\n");
									valueXmlString.append("<name_from><![CDATA[").append(spName).append("]]></name_from>\r\n");
								}
							}
							else
							{
								// Modified by Prashant on [13/05/2013][Request Id : ][To set values in cdata of xml]
								//valueXmlString.append("<name_from>").append(spName).append("</name_from>\r\n");
								valueXmlString.append("<name_from><![CDATA[").append(spName).append("]]></name_from>\r\n");
							}
						}
						else
						{
							// Modified by Prashant on [13/05/2013][Request Id : ][To set values in cdata of xml]
							//valueXmlString.append("<name_from>").append("").append("</name_from>\r\n");
							valueXmlString.append("<name_from><![CDATA[").append("").append("]]></name_from>\r\n");
						}
					}
					else if (currentColumn.trim().equals("sales_pers__to"))
					{
						String salesPersTo = checkNull(genericUtility.getColumnValue("sales_pers__to",dom));
						System.out.println("Sales Pers to ===========================> "+salesPersTo);
						String spName = "";
						if (salesPersTo != null && salesPersTo.trim().length() > 0)
						{
							selectSql = "SELECT SP_NAME FROM SALES_PERS WHERE SALES_PERS = '"+ salesPersTo +"' ";
							System.out.println("SQL for sp_name from sales_pers :: "+selectSql);
							rs = stmt.executeQuery(selectSql);
							if(rs.next())
							{
								spName = checkNull(rs.getString("SP_NAME"));
							}
							rs.close();
							rs = null;

							selectSql = "SELECT DATE_JOIN, RELIEVE_DATE FROM EMPLOYEE WHERE EMP_CODE = '"+salesPersTo+"'";
							rs = stmt.executeQuery(selectSql);
							if( rs.next() )
							{
								joinDateDb = rs.getDate("DATE_JOIN");
								relieveDt = rs.getString("RELIEVE_DATE");
							}
							rs.close();
							rs = null;
							if ( (joinDateDb != null && currDate != null && currDate.before(joinDateDb)) || (relieveDt != null && relieveDt.trim().length() > 0 ) )
							{
								// Modified by Prashant on [13/05/2013][Request Id : ][To set values in cdata of xml]
								//valueXmlString.append("<name_to>").append("").append("</name_to>\r\n");
								valueXmlString.append("<name_to><![CDATA[").append("").append("]]></name_to>\r\n");
							}
							else if ( empCodeHO == null || empCodeHO.trim().length() == 0 )
							{
								selectSql = "SELECT COUNT(*) AS COUNT FROM SALES_PERS WHERE SALES_PERS = '"+salesPersTo+"' AND "+
											"SALES_PERS IN( SELECT EMP_CODE FROM EMPLOYEE START WITH EMP_CODE = '"+loginEmpCode+"' "+
											"CONNECT BY PRIOR EMP_CODE = REPORT_TO )";
								rs = stmt.executeQuery(selectSql);
								if ( rs.next() )
								{
									spCount = rs.getInt("COUNT");
								}
								rs.close();
								rs = null;
								if ( spCount == 0 )
								{
									// Modified by Prashant on [13/05/2013][Request Id : ][To set values in cdata of xml]
									//valueXmlString.append("<name_to>").append("").append("</name_to>\r\n");
									valueXmlString.append("<name_to><![CDATA[").append("").append("]]></name_to>\r\n");
								}
								else
								{
									// Modified by Prashant on [13/05/2013][Request Id : ][To set values in cdata of xml]
									//valueXmlString.append("<name_to>").append(spName).append("</name_to>\r\n");
									valueXmlString.append("<name_to><![CDATA[").append(spName).append("]]></name_to>\r\n");
								}
							}
							else
							{
								// Modified by Prashant on [13/05/2013][Request Id : ][To set values in cdata of xml]
								//valueXmlString.append("<name_to>").append(spName).append("</name_to>\r\n");
								valueXmlString.append("<name_to><![CDATA[").append(spName).append("]]></name_to>\r\n");
							}
						}
						else
						{
							// Modified by Prashant on [13/05/2013][Request Id : ][To set values in cdata of xml]
							//valueXmlString.append("<name_to>").append("").append("</name_to>\r\n");
							valueXmlString.append("<name_to><![CDATA[").append("").append("]]></name_to>\r\n");
						}

					}
					valueXmlString.append("</Detail>");
					break;
			}//END OF SWITCH
		}//END OF TRY
		catch(Exception e)
		{
			System.out.println("Exception ::"+ e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if ( stmt != null )
				{
					stmt.close();
					stmt = null;
				}
				if ( conn != null )
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				System.out.println("Exception ::"+e);
				e.printStackTrace();
			}
		}
		valueXmlString.append("</Root>");
		return valueXmlString.toString();
	}//END OF ITEMCHANGE
	//Added - Gulzar - 14/04/10
	private String getHOEmployee( String empCode, Connection conn ) throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String empCodeHO = "";
		String selectSql = "";
		try
		{
			selectSql = "SELECT EMP_CODE FROM USERS A, USER_RIGHTS B " +
				  "WHERE A.EMP_CODE = ? " +
				  "AND A.PROFILE_ID = B.PROFILE_ID " +
				  "AND B.APPLICATION = 'MRO' " +
				  "AND B.MENU_ROW = 1 " +
				  "AND B.MENU_COL = 1 " +
				  "AND B.MENU_SUBCOL = 1 " +
				  "AND B.LEVEL_4 = 1 " +
				  "AND B.LEVEL_5 = 1 " +
				  "AND B.MENU_NAME = 'MR Online Application' ";

			pstmt = conn.prepareStatement(selectSql);
			pstmt.setString( 1, empCode );
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				empCodeHO = checkNull(rs.getString("EMP_CODE"));
			}
			rs.close();
		}
		catch ( Exception e )
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e1){}
		}
		return empCodeHO;
	}
	private String getMGREmployee( String empCode, Connection conn ) throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String empCodeMGR = "";
		String selectSql = "";
		try
		{
			selectSql = "SELECT A.EMP_CODE AS EMP_CODE FROM EMPLOYEE A, GRADE B " +
				  "WHERE A.EMP_CODE = ? " +
				  "AND A.GRADE = B.GRADE_CODE " +
				  "AND B.GRADE_TYPE = 'M' ";

			pstmt = conn.prepareStatement(selectSql);
			pstmt.setString( 1, empCode );
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				empCodeMGR = checkNull(rs.getString("EMP_CODE"));
			}
			rs.close();
		}
		catch ( Exception e )
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e1){}
		}
		return empCodeMGR;
	}
	private String checkNull( String input )
	{
		if (input == null)
		{
			input = "";
		}
		return input;
	}
	//End Added - Gulzar - 14/04/10
}
