//package ibase.webitm.ejb.wsfa.masters;
package ibase.webitm.ejb.wsfa.masters;

import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;

import javax.ejb.Stateless;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

//Created by sachin satre on [3-may-18] for request id : W18BSUN008

//@Stateless		commented by Sagar M [22 Nov 2018].
public class StanTypeMST extends ValidatorEJB implements StanTypeMSTLocal,StanTypeMSTRemote
{
	E12GenericUtility genericUtility = new E12GenericUtility();
	protected static String database = CommonConstants.DB_NAME;

	public String wfValData() throws RemoteException, ITMException
	{
		return "";
	}
	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = null;
		boolean isLocalConn = false;
		Connection connectionObject=null;
		System.out.println("xmlString["+xmlString+"]");
		System.out.println("xmlString1["+xmlString1+"]");
		System.out.println("xmlString2["+xmlString2+"]");
		try
		{

			if (connectionObject == null)
			{
				System.out.println("inside connectionObject null>>>>>>>>>>>>>>");
				connectionObject = getConnection();
				isLocalConn = true;
				connectionObject.setAutoCommit(false);
			}

			if(xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString);
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1);
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2);
			}
			errString = wfValData(connectionObject,dom, dom1, dom2, objContext, editFlag, xtraParams);
			System.out.println("ErrString: " + errString);
		}
		catch(Exception e)
		{
			System.out.println("Exception: StanTypeMST: wfValData(String xmlString): " + e.getMessage() + ":");
			errString = genericUtility.createErrorString(e);
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if (isLocalConn)
				{
					if ( connectionObject != null )
					{
						connectionObject.close();
						connectionObject = null;
					}
				}

			}
			catch(Exception e){}
		}
		System.out.println("Returning from StanTypeMST wfValData");
		return (errString);
	}

	public String wfValData(Connection connectionObject,Document dom, Document dom1, Document dom2, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		System.out.println("Entering in wfvaldata StanTypeMST::editFlag:: "+editFlag);
		String columnName = "";
		String columnValue = "";
		String userId,loginSite = "";
		String errString = "";
		//Connection connectionObject = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		boolean isLocalConn = false;

		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;
		String childNodeName = null;

		int intDtRet = 0;
		int ctr = 0;
		int noOfChilds = 0;
		int currentFormNo = 0;
		String totalBusiness = "";
		String sql="";
		try
		{
			if (connectionObject == null)
			{
				System.out.println("connection is null in StanTypeMST add");
				connectionObject = getConnection();
				isLocalConn = true;
				connectionObject.setAutoCommit(false);
			}
			userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			loginSite = getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode");
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String sysDate = sdf.format(new java.util.Date());

			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			parentList = dom.getElementsByTagName("Detail" + currentFormNo);
			parentNode = parentList.item(0);
			childList = parentNode.getChildNodes();
			noOfChilds = childList.getLength();
			for(ctr = 0; ctr < noOfChilds; ctr++)
			{
				/*if( childNode.getNodeType() != Node.ELEMENT_NODE )
				{
					continue;
				}*/
				childNode = childList.item(ctr);
				childNodeName = childNode.getNodeName();
				if ( childNode != null && childNode.getFirstChild() != null )
				{
					columnValue = childNode.getFirstChild().getNodeValue();
				}
				System.out.println("childNodeName>>>["+childNodeName+"]");
				String activeYN = checkNull(genericUtility.getColumnValue("active_yn",dom));
				String enterprise = checkNull(genericUtility.getColumnValue("enterprise",dom));
				String localityType = checkNull(genericUtility.getColumnValue("locality_type",dom));
				String locSubType = checkNull(genericUtility.getColumnValue("locality_sub_type",dom));
				System.out.println("activeYN["+activeYN+"],enterprise::["+enterprise+"],localityType::["+localityType+"],locSubType::["+locSubType+"]currentFormNo::"+currentFormNo);
				switch(currentFormNo)
				{
				case 1:
				{
					System.out.println("Before if of StanTypeMST");
					//if("Y".equals(applVisit))
					if(childNodeName.equalsIgnoreCase("enterprise"))
					{
						System.out.println("inside enterprise>>>>>>>>>>>"+childNodeName);
						enterprise = checkNull(genericUtility.getColumnValue("enterprise",dom));
						//salesPers = checkNull(genericUtility.getColumnValue("sales_pers",dom));
						if ( childNode.getFirstChild() == null )
						{
							errString = getErrorString("enterprise","NULENTRPRS",userId,errString);
							break;
						}
						else if(enterprise!= null && enterprise.trim().length() > 0)
						{
							
							int entrLen = enterprise.trim().length();
							System.out.println("entrLen:s:["+entrLen+"]");
							int SitCdCount = 0;
							int grdCdCount = 0;
							
							int enterpriseCnt = checkEnterpriseExist(userId,enterprise,connectionObject);
							
							if(enterpriseCnt <= 0)
							{
								if(entrLen >= 5)
								{
									String siteCode = enterprise.substring(0, (5) );
									System.out.println("enterPriese::["+enterprise+"]");

									String gradeCode = enterprise.substring(5, (enterprise.trim().length()) );
									System.out.println("siteCode::["+siteCode+"]:::gradeCode::["+gradeCode+"]");

									sql="SELECT COUNT(*) AS COUNT FROM SITE WHERE SITE_CODE = ? ";
									pstmt = connectionObject.prepareStatement(sql);
									pstmt.setString(1, siteCode);
									rs = pstmt.executeQuery();
									if (rs.next())
									{
										SitCdCount = rs.getInt("COUNT");
									}
									if(rs != null)
									{
										rs.close();
										rs = null;
									}
									if(pstmt != null)
									{
										pstmt.close();
										pstmt = null;
									}

									sql="SELECT COUNT(*) AS COUNT FROM GRADE WHERE GRADE_CODE = ? ";
									pstmt = connectionObject.prepareStatement(sql);
									pstmt.setString(1, gradeCode);
									rs = pstmt.executeQuery();
									if (rs.next())
									{
										grdCdCount = rs.getInt("COUNT");
									}
									if(rs != null)
									{
										rs.close();
										rs = null;
									}
									if(pstmt != null)
									{
										pstmt.close();
										pstmt = null;
									}
									System.out.println("SitCdCount::::::::["+SitCdCount+"]::grdCdCount::["+grdCdCount+"]");
									
									if((SitCdCount == 0 || grdCdCount == 0) && enterpriseCnt == 0)
									{
										errString = getErrorString("enterprise","INVENTPRIS",userId);
										break;
									}
								}
								else
								{
									errString = getErrorString("enterprise","INVENTPRIS",userId);
									break;
								}
							}	
						}
					}
					else if(childNodeName.equalsIgnoreCase("locality_type"))
					{
						localityType = checkNull(genericUtility.getColumnValue("locality_type",dom));
						System.out.println("inside level_no>>>>>>>>>>>");
						if ( childNode.getFirstChild() == null )
						{
							errString = getErrorString("locality_type","NULLOCTYPE",userId,errString);
							break;
						}
						else if(localityType!= null && localityType.trim().length() > 0)
						{
							int locTypCnt = 0;
							sql="SELECT COUNT(*) AS COUNT FROM GENCODES WHERE MOD_NAME ='W_STAN_TYPE_MST' AND FLD_NAME ='LOCALITY_TYPE'  AND FLD_VALUE = ? AND ACTIVE = 'Y' ";
							pstmt = connectionObject.prepareStatement(sql);
							pstmt.setString(1, localityType);
							rs = pstmt.executeQuery();
							if (rs.next())
							{
								locTypCnt = rs.getInt("COUNT");
							}
							if(rs != null)
							{
								rs.close();
								rs = null;
							}
							if(pstmt != null)
							{
								pstmt.close();
								pstmt = null;
							}
							System.out.println("locTypCnt::::::::"+locTypCnt);
							if(locTypCnt == 0)
							{
								errString = getErrorString("locality_type","INVLOCTYPE",userId);
								break;
							}
						}
					}
					else if(childNodeName.equalsIgnoreCase("locality_sub_type"))
					{
						System.out.println("inside sales_pers>>>>>>>>>>>");
						locSubType = checkNull(genericUtility.getColumnValue("locality_sub_type",dom));
						//levelNo = checkNull(genericUtility.getColumnValue("level_no",dom));
						if ( childNode.getFirstChild() == null )
						{
							errString = getErrorString("locality_sub_type","NULSUBTYPE",userId,errString);
							break;
						}
						else if(locSubType!= null && locSubType.trim().length() > 0)
						{
							int locSubTypeCount = 0;

							sql="SELECT COUNT(*) AS COUNT FROM GENCODES WHERE MOD_NAME ='W_STAN_TYPE_MST' AND FLD_NAME ='LOCALITY_SUB_TYPE'  AND FLD_VALUE = ? AND ACTIVE = 'Y'  ";
							pstmt = connectionObject.prepareStatement(sql);
							pstmt.setString(1, locSubType);
							rs = pstmt.executeQuery();
							if (rs.next())
							{
								locSubTypeCount = rs.getInt("COUNT");
							}
							if(rs != null)
							{
								rs.close();
								rs = null;
							}
							if(pstmt != null)
							{
								pstmt.close();
								pstmt = null;
							}
							System.out.println("locSubTypeCount::::::::"+locSubTypeCount);
							if(locSubTypeCount == 0)
							{
								errString = getErrorString("locality_sub_type","INVSUBTYPE",userId);
								break;
							}
						}
					}
					else if(childNodeName.equalsIgnoreCase("route_type"))
					{
						System.out.println("Inside route_type>>>>");
						String routeType = checkNull(genericUtility.getColumnValue("route_type",dom));
						if ( childNode.getFirstChild() == null )
						{
							errString = getErrorString("route_type","NULROUTYPE",userId,errString);
							break;
						}
						else if(routeType!= null && routeType.trim().length() > 0)
						{
							int routeTypeCount = 0;

							sql="SELECT COUNT(*) AS COUNT FROM GENCODES WHERE MOD_NAME ='W_STAN_TYPE_MST' AND FLD_NAME ='ROUTE_TYPE'  AND FLD_VALUE = ?  AND ACTIVE = 'Y' ";
							pstmt = connectionObject.prepareStatement(sql);
							pstmt.setString(1, routeType);
							rs = pstmt.executeQuery();
							if (rs.next())
							{
								routeTypeCount = rs.getInt("COUNT");
							}
							if(rs != null)
							{
								rs.close();
								rs = null;
							}
							if(pstmt != null)
							{
								pstmt.close();
								pstmt = null;
							}
							System.out.println("routeTypeCount::::::::"+routeTypeCount);
							if(routeTypeCount == 0)
							{
								errString = getErrorString("locality_sub_type","INVROUTYPE",userId);
								break;
							}
						}
					}
					else if(childNodeName.equalsIgnoreCase("stan_type"))
					{
						System.out.println("Inside valid_upto>>>>");
						String stanType = checkNull(genericUtility.getColumnValue( "stan_type", dom ));
						System.out.println("stanType["+stanType+"],validUpto>>["+stanType+"]");

						if ( childNode.getFirstChild() == null )
						{
							errString = getErrorString("stan_type","NULSTNTYPE",userId,errString);
							break;
						}
						else if(stanType!= null && stanType.trim().length() > 0)
						{
							int stanTypeCount = 0;

							sql="SELECT COUNT(*) AS COUNT FROM STANTYPE WHERE STAN_TYPE = ? ";
							pstmt = connectionObject.prepareStatement(sql);
							pstmt.setString(1, stanType);
							rs = pstmt.executeQuery();
							if (rs.next())
							{
								stanTypeCount = rs.getInt("COUNT");
							}
							if(rs != null)
							{
								rs.close();
								rs = null;
							}
							if(pstmt != null)
							{
								pstmt.close();
								pstmt = null;
							}
							System.out.println("stanTypeCount::::::::"+stanTypeCount);
							if(stanTypeCount == 0)
							{
								errString = getErrorString("stan_type","INVSTNTYPE",userId);
								break;
							}
						}
					}
					else if(childNodeName.equalsIgnoreCase("active_yn"))
					{
						System.out.println("Inside route_type>>>>");
						activeYN = checkNull(genericUtility.getColumnValue("active_yn",dom));

						enterprise = checkNull(genericUtility.getColumnValue("enterprise",dom));
						localityType = checkNull(genericUtility.getColumnValue("locality_type",dom));
						locSubType = checkNull(genericUtility.getColumnValue("locality_sub_type",dom));
						String routeType = checkNull(genericUtility.getColumnValue("route_type",dom));
						String stanType = checkNull(genericUtility.getColumnValue( "stan_type", dom ));

						if( childNode.getFirstChild() == null )
						{
							errString = getErrorString("active_yn","NULROUTSTS",userId,errString);
							break;
						}
						else
						{
							System.out.println("inside status not null :::["+activeYN+"]::editFlag:::["+editFlag+"]");
							int recExtsCnt = 0 ;
							if(editFlag != null && editFlag.equalsIgnoreCase("A"))
							{
								String stanMSTSql = "SELECT COUNT(*) AS COUNT FROM STAN_TYPE_MST WHERE ENTERPRISE = ? AND LOCALITY_TYPE = ? "
										+ " AND LOCALITY_SUB_TYPE = ?  AND ROUTE_TYPE = ? ";

								System.out.println("stanMSTSql SQL"+stanMSTSql);
								pstmt = connectionObject.prepareStatement(stanMSTSql);
								pstmt.setString( 1, enterprise );
								pstmt.setString( 2, localityType.trim() );
								pstmt.setString( 3, locSubType.trim() );
								pstmt.setString( 4, routeType.trim() );
								rs = pstmt.executeQuery();
								if (rs.next())
								{
									recExtsCnt = rs.getInt("COUNT");
								}
								if(rs != null)
								{
									rs.close();
									rs = null;
								}
								if(pstmt != null)
								{
									pstmt.close();
									pstmt = null;
								}
								System.out.println("recExtsCnt::::::::"+recExtsCnt);
								if(recExtsCnt > 0)
								{
									errString = getErrorString("stan_type","VMPMKY",userId);
									break;
								}
							}
						}

					}
					System.out.println("END OF WALDATA");
				}
				}
				if (errString != null && errString.trim().length()>0)
				{
					break;
				}
			}
		}
		catch(SQLException se)
		{
			System.out.println("Exception: StanTypeMST: wfValData(Document dom): " + se.getMessage() + ":");
			errString = genericUtility.createErrorString(se);
		}
		catch(Exception e)
		{
			System.out.println("Exception: StanTypeMST: wfValData(Document dom): " + e.getMessage() + ":");
			errString = genericUtility.createErrorString(e);
		}

		finally
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}

				if (isLocalConn)
				{
					if ( connectionObject != null )
					{
						connectionObject.close();
						connectionObject = null;
					}
				}

			}
			catch(Exception e){}
		}
		return (errString);
	}

	public String itemChanged() throws RemoteException, ITMException
	{
		return "";
	}

	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = null;
		GenericUtility genericUtility = GenericUtility.getInstance();
		System.out.println("xmlString ["+xmlString+"]");
		System.out.println("xmlString1 ["+xmlString1+"]");
		System.out.println("xmlString2 ["+xmlString2+"]");
		try
		{
			if (xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString);
			}
			if (xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1);
			}
			if (xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2);
			}
			errString = itemChanged( dom, dom1, dom2, objContext, currentColumn, editFlag, xtraParams );
			System.out.println ( "ErrString :" + errString);
		}
		catch (Exception e)
		{
			System.out.println ( "Exception :StanTypeMST:itemChanged(String,String):" + e.getMessage() + ":" );
			errString = genericUtility.createErrorString(e);
		}
		System.out.println ( "returning from StanTypeMST:itemChanged" );
		return errString;
	}

	public String itemChanged(Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		System.out.println("StanTypeMST ITEMCHANGEss");
		String sql = "";
		Connection connectionObject = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		StringBuffer valueXmlString = new StringBuffer();

		int currentFormNo = 0;
		try
		{
			connectionObject = getConnection();

			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String chgDate = sdf.format(new java.util.Date());
			String chgUser = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			String chgTerm = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"termId");
			valueXmlString = new StringBuffer("<?xml version=\"1.0\" encoding='UTF-8'?>\r\n<Root>\r\n<Header>\r\n<editFlag>");
			valueXmlString.append(editFlag).append("</editFlag>\r\n</Header>\r\n");
			switch (currentFormNo)
			{
			case 1:
				valueXmlString.append("<Detail1 domId =\"1\">\r\n");
				if(currentColumn.equalsIgnoreCase("itm_default"))
				{
					System.out.println("*******************xtraParams["+xtraParams+"]");
					valueXmlString.append("<active_yn>").append("<![CDATA["+'Y'+"]]>").append("</active_yn>");

					valueXmlString.append("<chg_date protect=\"1\"><![CDATA[").append(checkNull(chgDate)).append("]]></chg_date>\r\n");
					valueXmlString.append("<chg_user protect=\"1\"><![CDATA[").append(checkNull(chgUser)).append("]]></chg_user>\r\n");
					valueXmlString.append("<chg_term protect=\"1\"><![CDATA[").append(checkNull(chgTerm)).append("]]></chg_term>\r\n");
					valueXmlString.append("<add_date protect=\"1\"><![CDATA[").append(checkNull(chgDate)).append("]]></add_date>\r\n");
					valueXmlString.append("<add_user protect=\"1\"><![CDATA[").append(checkNull(chgUser)).append("]]></add_user>\r\n");
					valueXmlString.append("<add_term protect=\"1\"><![CDATA[").append(checkNull(chgTerm)).append("]]></add_term>\r\n");
				}
				else if(currentColumn.equalsIgnoreCase("itm_defaultedit"))
				{
					System.out.println("*******************xtraParams["+xtraParams+"]");
					String activeYN = checkNull(genericUtility.getColumnValue("active_yn",dom));

					String enterprise = checkNull(genericUtility.getColumnValue("enterprise",dom));
					String localityType = checkNull(genericUtility.getColumnValue("locality_type",dom));
					String locSubType = checkNull(genericUtility.getColumnValue("locality_sub_type",dom));
					String routeType = checkNull(genericUtility.getColumnValue("route_type",dom));
					String stanType = checkNull(genericUtility.getColumnValue( "stan_type", dom ));


					valueXmlString.append("<ent_type protect='1' >").append("<![CDATA["+enterprise+"]]>").append("</ent_type>"); // Changed by Hariom for Sun migration - 22-nov-19
					//valueXmlString.append("<enterprise protect='1' >").append("<![CDATA["+enterprise+"]]>").append("</enterprise>"); // Changed by Hariom for Sun migration - 22-nov-19
					valueXmlString.append("<locality_type protect='1' >").append("<![CDATA["+localityType+"]]>").append("</locality_type>");
					valueXmlString.append("<locality_sub_type protect='1' >").append("<![CDATA["+locSubType+"]]>").append("</locality_sub_type>");
					valueXmlString.append("<route_type protect='1'>").append("<![CDATA["+routeType+"]]>").append("</route_type>");
					valueXmlString.append("<stan_type protect='0'>").append("<![CDATA["+stanType+"]]>").append("</stan_type>");

					valueXmlString.append("<chg_date protect=\"1\"><![CDATA[").append(checkNull(chgDate)).append("]]></chg_date>\r\n");
					valueXmlString.append("<chg_user protect=\"1\"><![CDATA[").append(checkNull(chgUser)).append("]]></chg_user>\r\n");
					valueXmlString.append("<chg_term protect=\"1\"><![CDATA[").append(checkNull(chgTerm)).append("]]></chg_term>\r\n");
				}
				// Changed by Hariom for Sun migration - 22-nov-19 [Start]
				else if(currentColumn.equalsIgnoreCase("ent_type"))
				{
					String entType = checkNull(genericUtility.getColumnValue( "ent_type", dom ));

					valueXmlString.append("<enterprise>").append("<![CDATA["+entType+"]]>").append("</enterprise>");

				}
				// Changed by Hariom for Sun migration - 22-nov-19 [End]
				else if(currentColumn.equalsIgnoreCase("stan_type"))
				{
					String stanTypeeDescr = "";
					String stanType = checkNull(genericUtility.getColumnValue("stan_type", dom));
					sql = "SELECT DESCR FROM STANTYPE WHERE STAN_TYPE = ? ";
					pstmt = connectionObject.prepareStatement(sql);
					pstmt.setString(1, stanType);
					rs = pstmt.executeQuery();
					if (rs.next())
					{
						stanTypeeDescr = checkNull(rs.getString("DESCR"));
					}
					if (rs != null)
					{
						rs.close();
						rs = null;
					}
					if (pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					valueXmlString.append("<stantype_descr>").append("<![CDATA["+stanTypeeDescr+"]]>").append("</stantype_descr>");
				}
				valueXmlString.append("</Detail1>\r\n");
				break;
			}
		}
		catch(SQLException se)
		{
			System.out.println("Exception: StanTypeMST: itemChanged(Document,String): " + se.getMessage() + ":");
			valueXmlString = valueXmlString.append(genericUtility.createErrorString(se));
		}
		catch(Exception e)
		{
			System.out.println("Exception :StanTypeMST:itemChanged[" + e.getMessage() + "]");
			valueXmlString = valueXmlString.append(genericUtility.createErrorString(e));
		}
		finally
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if ( connectionObject != null )
				{
					connectionObject.close();
				}
			}
			catch(Exception e){}
		}
		valueXmlString.append("</Root>\r\n");
		System.out.println("\n****ValueXmlString :" + valueXmlString + ":********");
		return valueXmlString.toString();

	}
	private String checkNull(String input)
	{
		if (input==null)
		{
			input="";
		}
		else
		{
			input = input.trim();
		}
		return input;
	}
	
	private int checkEnterpriseExist(String userId,String enterprise,Connection conn) throws ITMException
	{
			PreparedStatement pstmt = null;
			ResultSet rs = null;
			boolean isLocalConn =false;
			String sql = "";
			int entCnt = 0;
			try
			{
				if(conn == null)
				{
					conn = getConnection();
					isLocalConn =true;
				}
				sql = "SELECT COUNT(*) AS COUNT FROM USERS WHERE CODE = ? AND ENTERPRISE = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, userId);
				pstmt.setString(2,enterprise);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					entCnt = rs.getInt("COUNT");
				}
				if( rs != null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				throw new ITMException(e);
			}
			finally
			{
				try
				{
					if( rs != null )
					{
						rs.close();
						rs = null;
					}
					if( pstmt != null )
					{
						pstmt.close();
						pstmt = null;
					}
					if(isLocalConn && conn != null && ! conn.isClosed())
					{
						conn.close();
						conn=null;
					}
				}
				catch(Exception e)
				{
					e.getMessage();
				}
			}
			return entCnt;
	}
}
