package ibase.webitm.bean.wsfa;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map.Entry;

import javax.naming.InitialContext;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import ibase.webitm.ejb.ValidatorEJB;

import org.json.JSONArray;
import org.json.JSONObject;
import org.w3c.dom.Document;
//import ibase.webitm.utility.GenericUtility;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.wsfa.transactions.CallReportStatusEJB;
import ibase.webitm.ejb.wsfa.transactions.DCRSummaryEJB;
import ibase.webitm.utility.ITMException;
import ibase.webitm.bean.wsfa.OrgStructure;

public class DCRSummaryBean 
{
	private String salesPerson = "";
	private String eventDate   = "";
	private String objName   = "";
	private String activityCode = "";
	private String user_lang ="en"; 
	private String user_country = "US";
	private UserInfoBean userInfo = null;
	private String tranID   = "";
	public String getSalesPerson()
	{
		return salesPerson;
	}
	public void setSalesPerson(String salesPerson) 
	{
		this.salesPerson = salesPerson;
	}
	
	public String getEventDate() 
	{
		return eventDate;
	}
	public void setEventDate(String eventDate) 
	{
		this.eventDate = eventDate;
	}
	public String getObjName() 
	{
		return objName;
	}
	public void setObjName(String objName) 
	{
		this.objName = objName;
	}
	public String getActivityCode() {
		return activityCode;
	}
	
	public void setActivityCode(String activityCode) {
		this.activityCode = activityCode;
		//System.out.println("activityCode in bean set method....."+ this.activityCode);
	}
	//added by prathamesh jangam on 11 jul 17
	public void setTranID(String tranID) 
	{
		this.tranID = tranID;
	}
	//Added bys sachin satre on [14-nov-16] start
	public UserInfoBean getUserInfo()
	{
		return this.userInfo;
	}
	public void setUserInfo(UserInfoBean userInfo) 
	{
		
		this.userInfo = userInfo;
		System.out.println("getUserInfo::>>"+userInfo);
	}
	//Added bys sachin satre on [14-nov-16] end
	public String getHTMLData()throws ITMException
	{
		String retString = null;
		InitialContext ctx = null;
		String xslString = "";
	
		ByteArrayOutputStream bos = null;
		Connection connectionObject =null;
		try
		{
			//changed by Rahul Barve on 6-sep-2014
			//GenericUtility genericUtility = GenericUtility.getInstance();
			//added by sachin satre on [14-nov-16] [start]
			connectionObject =getConnection();
			System.out.println("connectionObject"+connectionObject);
			//added by sachin satre on [14-nov-16] [end]
			String data = "";
			 E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
			AppConnectParm appConnect = new AppConnectParm();
			ctx = new InitialContext(appConnect.getProperty());
			//Commented and modified by kailash on 20-07-18 as per gulzar sir[Start]
			//DCRSummaryEJBLocal dcrSummaryEJBLocal  = (DCRSummaryEJBLocal) ctx.lookup("ibase/DCRSummaryEJB/local");
			DCRSummaryEJB dcrSummaryEJBLocal = new DCRSummaryEJB();
			//Commented and modified by kailash on 20-07-18 as per gulzar sir[End]
			System.out.println("objName......:"+objName);
			if(objName == "wsfa_mitoch_dsr_wiz" || objName.equalsIgnoreCase("wsfa_mitoch_dsr_wiz"))
			{
				System.out.println(" objName if........");
				data = dcrSummaryEJBLocal.getSalesPersDCR(this.salesPerson, this.eventDate,connectionObject);//Chnaged by sachin satre on 14-nov-16
			}
			//Added By poonam for Zuvius Reporting :Start
			else if(objName == "wsfa_zuvius_dsr_wiz" || objName.equalsIgnoreCase("wsfa_zuvius_dsr_wiz"))
			{
				System.out.println(" objName if zuvius mr........");
				data = dcrSummaryEJBLocal.getSalesPersDCR(this.salesPerson, this.eventDate,connectionObject);//Chnaged by sachin satre on 14-nov-16
			}
			
			else if(objName == "wsfa_zuvius_mgr_dsr_wiz" || objName.equalsIgnoreCase("wsfa_zuvius_mgr_dsr_wiz"))
			{
				System.out.println(" objName if zuvius mgr........");
				data = dcrSummaryEJBLocal.getSalesPersMGRDCR(this.salesPerson, this.eventDate,connectionObject);//Chnaged by sachin satre on 14-nov-16
			}
			//Added By poonam for Zuvius Reporting :End
			else if(objName == "wsfa_jnj_dsr_wiz" || objName.equalsIgnoreCase("wsfa_jnj_dsr_wiz"))
			{
				System.out.println(" objName else if........");
				data = dcrSummaryEJBLocal.getSalesPersDCR(this.salesPerson, this.eventDate, this.activityCode, this.objName);
			}
			else if(objName == "sprs_survey_otc_wiz" || objName.equalsIgnoreCase("sprs_survey_otc_wiz"))
			{
				System.out.println(" objName else if 2........");
				data = dcrSummaryEJBLocal.getSalesPersDCR(this.salesPerson, this.eventDate,connectionObject);//Chnaged by sachin satre on 14-nov-16
			}
			else if(objName == "strg_meet_dcr_wiz" || objName.equalsIgnoreCase("strg_meet_dcr_wiz"))
			{
				System.out.println(" objName else if standard........");
				data = dcrSummaryEJBLocal.getSalesPersDCR(this.salesPerson, this.eventDate,connectionObject);//Chnaged by prathamesh jangam on 11/7/17
			}
			//String data = dcrSummaryEJBLocal.getSalesPersDCR(this.salesPerson, this.eventDate);
			Document dom = genericUtility.parseString( data );
			dcrSummaryEJBLocal = null;
			String XSL_FILE_NAME = objName +"_dcr_summ_en_US.xsl";
			String theme = CommonConstants.THEME == null ? "Standard" : CommonConstants.THEME ;
			System.out.println("XS File is [" + CommonConstants.APPLICATION_CONTEXT + "webitm" + File.separator + "xsl" + File.separator + theme + File.separator +"WIZARD" + File.separator + XSL_FILE_NAME +"]");
			xslString = genericUtility.readFile( CommonConstants.APPLICATION_CONTEXT + "webitm" + File.separator + "xsl" + File.separator + theme + File.separator +"WIZARD" + File.separator + XSL_FILE_NAME );
			
			if (xslString != null && xslString.length() > 0)
			{				
				System.setProperty("javax.xml.transformer.TransformerFactory","org.apache.xalan.processor.TransformerFactoryImpl");
				TransformerFactory tFactory = TransformerFactory.newInstance();
				Transformer transformer = tFactory.newTransformer(new StreamSource(new ByteArrayInputStream(xslString.getBytes())));
				bos = new ByteArrayOutputStream();
				transformer.transform(new DOMSource(dom), new StreamResult(bos));
				retString = bos.toString();
			}
			else
			{
				System.out.println(" [DCRSummaryBean] System defined xsl file not found -- returning the same dom as xml string ......");
				retString = genericUtility.serializeDom(dom);
			}
		}
		catch(Exception e )
		{
			System.out.println("Exception : DCRSummaryBean :getHTMLData :==>\n"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		//Changed by Shravan on 21/05/2007 to close file io streams.
		finally
		{
			try
			{
				if( bos != null )
				{
					bos.close();
					bos = null;
				}
				//added by shraddha to close connection [24-dec-2019] start
				if( connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
				}
				//added by shraddha to close connection [24-dec-2019] end
			}
			catch ( Exception e )
			{
				System.out.println( "Exception in releasing file resource :" );
				e.printStackTrace();
			}
		}
		System.out.println("Returning Transformed String of length :["+retString.length()+"]");
		return retString;
	}
	public String deleteSalesPersDCR(String salesPerson, String eventDate) throws RemoteException, ITMException
	{
		String retString = null;
		InitialContext ctx = null;
		Connection connectionObject =null;
		try
		{
			//added by sachin satre on [14-nov-16] [start]
			connectionObject =getConnection();
			System.out.println("connectionObject"+connectionObject);
			//added by sachin satre on [14-nov-16] [end]
			AppConnectParm appConnect = new AppConnectParm();
			ctx = new InitialContext(appConnect.getProperty());
			//Commented and modified by kailash on 20-07-18 as per gulzar sir[Start]
			//DCRSummaryEJBLocal dcrSummaryEJBLocal  = (DCRSummaryEJBLocal) ctx.lookup("ibase/DCRSummaryEJB/local");
			DCRSummaryEJB dcrSummaryEJBLocal = new DCRSummaryEJB();
			//Commented and modified by kailash on 20-07-18 as per gulzar sir[End]
			retString = dcrSummaryEJBLocal.deleteSalesPersDCR(salesPerson, eventDate,connectionObject);//Chnaged by sachin satre on 14-nov-16
			dcrSummaryEJBLocal = null;
		}
		catch(Exception e )
		{
			e.printStackTrace();
			System.out.println("Exception : DCRSummaryBean :deletSalesPersDCR() :==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		//Chnaged by sachin satre on 14-nov-16
		finally
		{
			try
			{
				if( connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :DCRSummaryBean :deletSalesPersDCR() :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		//Chnaged by sachin satre on 14-nov-16
		System.out.println("Returning From DCRSummaryBean :: deletSalesPersDCR() :["+retString+"]");
		return retString;
	}
	public String  confirmSalesPersDCR(String salesPerson, String eventDate) throws RemoteException, ITMException
	{
		String retString = "";
		InitialContext ctx = null;
		Connection connectionObject=null;
		try
		{
			//added by sachin satre on [14-nov-16] [start]
			connectionObject =getConnection();
			System.out.println("connectionObject"+connectionObject);
			//added by sachin satre on [14-nov-16] [end]
			AppConnectParm appConnect = new AppConnectParm();
			ctx = new InitialContext(appConnect.getProperty());
			//Commented and modified by kailash on 20-07-18 as per gulzar sir[Start]
			//DCRSummaryEJBLocal dcrSummaryEJBLocal  = (DCRSummaryEJBLocal) ctx.lookup("ibase/DCRSummaryEJB/local");
			DCRSummaryEJB dcrSummaryEJBLocal = new DCRSummaryEJB();
			//Commented and modified by kailash on 20-07-18 as per gulzar sir[End]
			retString = dcrSummaryEJBLocal.confirmSalesPersDCR(salesPerson, eventDate,connectionObject);//Chnaged by sachin satre on 14-nov-16
			dcrSummaryEJBLocal = null;
		}
		catch(Exception e )
		{
			System.out.println("Exception : DCRSummaryBean :confirmSalesPersDCR() :==>\n"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :ITMWizardStatefulEJB :getSalesPersItemList(String) :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		System.out.println("Returning From DCRSummaryBean :: confirmSalesPersDCR() :["+retString+"]");
		return retString;
	}
	//Added By Poonam on 11-06-15 for Mitoch Mobile Reporting
	public String  viewReports(String salesPerson, String eventDate, String actionFlag) throws RemoteException, ITMException
	{
		String summHtmlData = "";
		InitialContext ctx = null;
		try
		{
			
			String summaryData = getSummaryDetail( salesPerson, eventDate, actionFlag );
			String xslFileName = getXSLFileName( "wsfa_zuvius_dsr_conf_mob_wiz_" + this.user_lang + "_" + this.user_country + ".xsl" );
			
			System.out.println("xslFileName ::"+xslFileName);

			summHtmlData = ( new ibase.webitm.utility.GenericUtility() ).transformToString( xslFileName, summaryData, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );

		}
		catch(Exception e )
		{
			System.out.println("Exception : DCRSummaryBean :confirmSalesPersDCR() :==>\n"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		System.out.println("Returning From DCRSummaryBean :: confirmSalesPersDCR() :["+summHtmlData+"]");
		return summHtmlData;
	}
	//Added By Poonam on 11-06-15 for Mitoch Mobile Reporting
	//Added by vinayak for perkinElmer
	//TODO
	public String  viewReportsDcrMob(String salesPerson, String eventDate, String actionFlag) throws RemoteException, ITMException
	{
		String summHtmlData = "";
		InitialContext ctx = null;
		try
		{
			
			String summaryData = getSummaryDetailDcrMob( salesPerson, eventDate, actionFlag );
			String xslFileName = getXSLFileName( "wsfa_dsr_mob_conf_wiz_" + this.user_lang + "_" + this.user_country + ".xsl" );
			
			System.out.println("xslFileName ::"+xslFileName);

			summHtmlData = ( new ibase.webitm.utility.GenericUtility() ).transformToString( xslFileName, summaryData, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );

		}
		catch(Exception e )
		{
			System.out.println("Exception : DCRSummaryBean :confirmSalesPersDCR() :==>\n"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		System.out.println("Returning From DCRSummaryBean :: confirmSalesPersDCR() :["+summHtmlData+"]");
		return summHtmlData;
	}
	
	//Added by Jay to take Summary from Enterprise folder (if exists in it) of user 19-JAN-23 [start]
	private String getXSLFileName( String xslFileName,String enterprise )throws ITMException
	{   
		String retFileName = null;
		try
		{
			String defaultPath = null;
			if( CommonConstants.APPLICATION_CONTEXT != null )
			{
				defaultPath = CommonConstants.APPLICATION_CONTEXT + CommonConstants.ITM_CONTEXT + File.separator;
			}
			else
			{
				defaultPath = ".." + File.separator + "webapps" + File.separator + "ibase" + File.separator + CommonConstants.ITM_CONTEXT + File.separator;
			}
			File xslPath = new File( defaultPath + File.separator  + "xsl" + File.separator + CommonConstants.THEME + File.separator + "WIZARD");
			File xslPathStandard = new File( defaultPath + File.separator  + "xsl" + File.separator + CommonConstants.THEME + File.separator + "WIZARD" + File.separator + enterprise);

			if ( !xslPath.exists() )
			{
				xslPath.mkdir();
			}
			System.out.println( " xslPath [" + xslPath +"] xslFileName ["+xslFileName +"]");
			File xslFile = new File(xslPath , xslFileName);
			File xslFileStandard = new File (xslPathStandard,xslFileName );
			
			if (xslFileStandard.exists())
			{
				retFileName = xslFileStandard.getAbsolutePath();
				System.out.println( " File Path is: "+retFileName);
			}
			else if( xslFile.exists() )
			{
				retFileName = xslFile.getAbsolutePath();
				System.out.println( " File Path is: "+retFileName);
			}
			else
			{
				throw new ITMException( new Exception( retFileName + " Wizard XSL file Not Found") );	
			}
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		return retFileName;
	}
	//Added by Jay to take Summary from Enterprise folder (if exists in it) of user 19-JAN-23 [End]

	private String getXSLFileName( String xslFileName )throws ITMException
	{   
		String retFileName = null;
		try
		{
			String defaultPath = null;
			if( CommonConstants.APPLICATION_CONTEXT != null )
			{
				defaultPath = CommonConstants.APPLICATION_CONTEXT + CommonConstants.ITM_CONTEXT + File.separator;
			}
			else
			{
				defaultPath = ".." + File.separator + "webapps" + File.separator + "ibase" + File.separator + CommonConstants.ITM_CONTEXT + File.separator;
			}
			File xslPath = new File( defaultPath + File.separator  + "xsl" + File.separator + CommonConstants.THEME + File.separator + "WIZARD");
			if ( !xslPath.exists() )
			{
				xslPath.mkdir();
			}
			System.out.println( " xslPath [" + xslPath +"] xslFileName ["+xslFileName +"]");
			File xslFile = new File(xslPath , xslFileName);
			if( xslFile.exists() )
			{
				retFileName = xslFile.getAbsolutePath();
			}
			else
			{
				throw new ITMException( new Exception( retFileName + " Wizard XSL file Not Found") );	
			}
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		return retFileName;
	}
	//Added By Poonam on 11-06-15 for Mitoch Mobile Reporting
	public String checkNull(String input)
	{
		if (input == null || "null".equalsIgnoreCase(input))
		{
			input= "";
		}
		return input.trim();
	}
	//Added By Poonam on 11-06-15 for Mitoch Mobile Reporting
	public String getSummaryDetail(String salesPers, String eventDate, String actionFlag)throws ITMException
	{
		PreparedStatement pstmt = null;
		
		int domID = 1;
		
		ConnDriver connDriver = new ConnDriver();
		Connection conn = null ; 
		
		StringBuffer valueXmlString = new StringBuffer( "<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<editFlag>" );
		valueXmlString.append( "E" ).append( "</editFlag>\r\n</Header>\r\n<Errors>\r\n</Errors>\r\n" );
		try
		{
			int unconfCnt = 0;
			 E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
			/*conn = connDriver.getConnectDB( "DriverValidator" );*/
			//added by sachin satre on [14-nov-16] [start]
			conn =getConnection();
			System.out.println("connectionObject"+conn);
			//added by sachin satre on [14-nov-16] [end]
			
			String eventDateDBFmt = genericUtility.getValidDateTimeString( eventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat());
			
			String countSql = "SELECT COUNT(*) AS COUNT FROM SPRS_ACT_TRAN WHERE SALES_PERS = ? AND EVENT_DATE = ? AND (CASE WHEN SPRS_ACT_TRAN.CONFIRMED IS NULL THEN 'N' ELSE SPRS_ACT_TRAN.CONFIRMED END) ='N' ";
			PreparedStatement pstmtCount = conn.prepareStatement(countSql);
			pstmtCount.setString(1, salesPers);
			pstmtCount.setTimestamp( 2, java.sql.Timestamp.valueOf( eventDateDBFmt ) );
			
			ResultSet rsCount = pstmtCount.executeQuery();
			if(rsCount.next())
			{
				unconfCnt = rsCount.getInt("COUNT");
			}
			rsCount.close(); rsCount = null;
			pstmtCount.close(); pstmtCount = null;
			
			System.out.println("unconfCnt =["+unconfCnt+"]");
			
			valueXmlString.append("<Detail2>");
			valueXmlString.append( "<HeaderData domID='"+domID+"' selected = 'Y'>\r\n" );
			valueXmlString.append( "<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\"/>\r\n");
			valueXmlString.append( "<confirm_or_delete><![CDATA[" ).append(actionFlag).append( "]]></confirm_or_delete>\r\n");
			valueXmlString.append( "<event_date><![CDATA[" ).append(eventDate).append( "]]></event_date>\r\n");
			valueXmlString.append( "<unconf_cnt><![CDATA[" ).append(unconfCnt).append( "]]></unconf_cnt>\r\n");
			valueXmlString.append( "</HeaderData>");
			
			//Commented and changes done by Gaurav Singh on 23-Jun-2015 [Start]
			/*String sqlEdit  ="SELECT STRG_MEET.*,LOCALITY.DESCR LOC_DESCR,FIELDACTIVITY.ACTIVITY_TYPE ACT_TYPE,"+    
					 	" LOWER(STRG_CUSTOMER.FIRST_NAME)||' '||LOWER(STRG_CUSTOMER.LAST_NAME) AS SC_NAME,"+ 
						" STRG_CUSTOMER.ADDR1,STRG_CUSTOMER.ADDR2,STRG_CUSTOMER.ADDR3, STRG_MEET.STRG_TYPE AS CUST_TYPE, "+ 
						" (CASE WHEN STRG_MEET.STRG_TYPE = 'D' THEN 1  WHEN STRG_MEET.STRG_TYPE='R' THEN 2  WHEN STRG_MEET.STRG_TYPE='M' THEN 3 ELSE 4 END) AS CUST_TYPE_SEQ "+
						" FROM FIELDACTIVITY,STRG_MEET LEFT OUTER JOIN STRG_CUSTOMER ON STRG_MEET.STRG_CODE = STRG_CUSTOMER.SC_CODE "+
						" LEFT OUTER JOIN LOCALITY ON STRG_MEET.LOCALITY_CODE = LOCALITY.LOCALITY_CODE " +
						" LEFT OUTER JOIN SPRS_ACT_TRAN ON STRG_MEET.DCR_ID = SPRS_ACT_TRAN.DCR_ID  "+
						" WHERE STRG_MEET.EVENT_TYPE =FIELDACTIVITY.ACTIVITY_CODE"+
						" AND STRG_MEET.SALES_PERS = ? "+
						" AND STRG_MEET.EVENT_DATE = ? "+
						" AND STRG_CUSTOMER.CUST_TYPE in ('D','R','M') " + 
						" AND (CASE WHEN SPRS_ACT_TRAN.CONFIRMED IS NULL THEN 'N' ELSE SPRS_ACT_TRAN.CONFIRMED END) ='N' "+
						" ORDER BY CUST_TYPE_SEQ, STRG_MEET.SHORT_ID ";
			 */
			
			/*String sqlEdit  ="SELECT STRG_MEET.*,LOCALITY.DESCR LOC_DESCR,FIELDACTIVITY.ACTIVITY_TYPE ACT_TYPE,"+    
				 	" LOWER(STRG_CUSTOMER.FIRST_NAME)||' '||LOWER(STRG_CUSTOMER.LAST_NAME) AS SC_NAME,"+ 
					" STRG_CUSTOMER.ADDR1,STRG_CUSTOMER.ADDR2,STRG_CUSTOMER.ADDR3, STRG_MEET.STRG_TYPE AS CUST_TYPE, "+ 
					" (CASE WHEN STRG_MEET.STRG_TYPE = 'D' THEN 1  WHEN STRG_MEET.STRG_TYPE='R' THEN 2  WHEN STRG_MEET.STRG_TYPE='M' THEN 3 ELSE 4 END) AS CUST_TYPE_SEQ "+
					" FROM FIELDACTIVITY,STRG_MEET LEFT OUTER JOIN STRG_CUSTOMER ON STRG_MEET.STRG_CODE = STRG_CUSTOMER.SC_CODE "+
					" LEFT OUTER JOIN LOCALITY ON STRG_MEET.LOCALITY_CODE = LOCALITY.LOCALITY_CODE " +
					" LEFT OUTER JOIN SPRS_ACT_TRAN ON STRG_MEET.DCR_ID = SPRS_ACT_TRAN.DCR_ID  "+
					" WHERE STRG_MEET.EVENT_TYPE =FIELDACTIVITY.ACTIVITY_CODE"+
					" AND STRG_MEET.SALES_PERS = ? "+
					" AND STRG_MEET.EVENT_DATE = ? "+
					" AND STRG_CUSTOMER.CUST_TYPE in ('D','C','S') " + 
					" AND (CASE WHEN SPRS_ACT_TRAN.CONFIRMED IS NULL THEN 'N' ELSE SPRS_ACT_TRAN.CONFIRMED END) ='N' "+
					" ORDER BY CUST_TYPE_SEQ, STRG_MEET.SHORT_ID ";*/
			//Commented and changes done by Gaurav Singh on 23-Jun-2015 [End]
			
			//chnged by sachin satre on 5-dec-16 [start]
			String sqlEdit  ="SELECT STRG_MEET.*,LOCALITY.DESCR LOC_DESCR,FIELDACTIVITY.ACTIVITY_TYPE ACT_TYPE,"+    
				 	" LOWER(STRG_CUSTOMER.FIRST_NAME)||' '||LOWER(STRG_CUSTOMER.LAST_NAME) AS SC_NAME,"+ 
					" STRG_CUSTOMER.ADDR1,STRG_CUSTOMER.ADDR2,STRG_CUSTOMER.ADDR3, STRG_MEET.STRG_TYPE AS CUST_TYPE, "+ 
					" (CASE WHEN STRG_MEET.STRG_TYPE = 'D' THEN 1  WHEN STRG_MEET.STRG_TYPE='R' THEN 2  WHEN STRG_MEET.STRG_TYPE='M' THEN 3 ELSE 4 END) AS CUST_TYPE_SEQ "+
					" FROM FIELDACTIVITY,STRG_MEET LEFT OUTER JOIN STRG_CUSTOMER ON STRG_MEET.STRG_CODE = STRG_CUSTOMER.SC_CODE "+
					" LEFT OUTER JOIN LOCALITY ON STRG_MEET.LOCALITY_CODE = LOCALITY.LOCALITY_CODE " +
					" LEFT OUTER JOIN SPRS_ACT_TRAN ON STRG_MEET.DCR_ID = SPRS_ACT_TRAN.DCR_ID  "+
					" WHERE STRG_MEET.EVENT_TYPE =FIELDACTIVITY.ACTIVITY_CODE"+
					" AND STRG_MEET.SALES_PERS = ? "+
					" AND STRG_MEET.EVENT_DATE = ? "+
					" AND STRG_CUSTOMER.CUST_TYPE  NOT in ('C','S') " + 
					" AND (CASE WHEN SPRS_ACT_TRAN.CONFIRMED IS NULL THEN 'N' ELSE SPRS_ACT_TRAN.CONFIRMED END) ='N' "+
					" ORDER BY CUST_TYPE_SEQ, STRG_MEET.SHORT_ID ";
			
			//chnged by sachin satre on 5-dec-16 [end] 
			
			 boolean leaveFlg=false;

			pstmt =  conn.prepareStatement( sqlEdit );
			pstmt.setString(1, salesPers);
			pstmt.setTimestamp( 2, java.sql.Timestamp.valueOf( eventDateDBFmt ) );
			
			ResultSet rs = pstmt.executeQuery();					

			while(rs.next())
			{
				leaveFlg= true;

				String actypeDB = checkNull(rs.getString("ACT_TYPE"));						
				String strgCode = checkNull(rs.getString("STRG_CODE"));
				String custType = rs.getString("CUST_TYPE") == null ?"":rs.getString("CUST_TYPE");
				
				if("D".equalsIgnoreCase(custType) && !"PR".equalsIgnoreCase(actypeDB))
				{
					valueXmlString.append( "<DoctorData domID='"+domID+"' selected = 'Y'>\r\n" );
					valueXmlString.append( "<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\"/>\r\n");
					valueXmlString.append( "<strg_code><![CDATA[" ).append( checkNull(rs.getString("STRG_CODE")).trim()).append( "]]></strg_code>\r\n");							
					valueXmlString.append( "<cust_name><![CDATA[" ).append( checkNull(rs.getString("SC_NAME")).trim()).append( "]]></cust_name>\r\n");														
					valueXmlString.append( "<sales_pers><![CDATA[" ).append(checkNull(salesPers)).append( "]]></sales_pers>\r\n" );
					valueXmlString.append( "<event_date><![CDATA[" ).append(eventDate).append( "]]></event_date>\r\n" );				
					valueXmlString.append( "<no_of_outlet><![CDATA[" ).append(checkNull(rs.getString("NO_OF_OUTLET"))).append( "]]></no_of_outlet>\r\n" );
					valueXmlString.append("<cust_type><![CDATA["+custType+"]]></cust_type>\r\n");				
					
					
					valueXmlString.append( "</DoctorData>\r\n" );
				}
				else if("PR".equalsIgnoreCase(actypeDB) && "D".equalsIgnoreCase(custType))
				{
					valueXmlString.append( "<DoctorDataPR domID='"+domID+"' selected = 'Y'>\r\n" );
					valueXmlString.append( "<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\"/>\r\n");
					valueXmlString.append( "<strg_code><![CDATA[" ).append( checkNull(rs.getString("STRG_CODE")).trim()).append( "]]></strg_code>\r\n");							
					valueXmlString.append( "<cust_name><![CDATA[" ).append( checkNull(rs.getString("SC_NAME")).trim()).append( "]]></cust_name>\r\n");														
					valueXmlString.append( "<sales_pers><![CDATA[" ).append(checkNull(salesPers)).append( "]]></sales_pers>\r\n" );
					valueXmlString.append( "<event_date><![CDATA[" ).append(eventDate).append( "]]></event_date>\r\n" );				
					valueXmlString.append( "<no_of_outlet><![CDATA[" ).append(checkNull(rs.getString("NO_OF_OUTLET"))).append( "]]></no_of_outlet>\r\n" );
					valueXmlString.append("<cust_type><![CDATA["+custType+"]]></cust_type>\r\n");
					valueXmlString.append("<act_type><![CDATA[" ).append(actypeDB ).append( "]]></act_type>\r\n");
					
					valueXmlString.append( "</DoctorDataPR>\r\n" );
				}
				//else if("R".equalsIgnoreCase(custType))
				else if("C".equalsIgnoreCase(custType))
				{
					//valueXmlString.append( "<RetailData domID='"+domID+"' selected = 'Y'>\r\n" );
					valueXmlString.append( "<ChemData domID='"+domID+"' selected = 'Y'>\r\n" );
					valueXmlString.append( "<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\"/>\r\n");
					valueXmlString.append( "<strg_code><![CDATA[" ).append( checkNull(rs.getString("STRG_CODE")).trim()).append( "]]></strg_code>\r\n");							
					valueXmlString.append( "<cust_name><![CDATA[" ).append( checkNull(rs.getString("SC_NAME")).trim()).append( "]]></cust_name>\r\n");														
					valueXmlString.append( "<sales_pers><![CDATA[" ).append(checkNull(salesPers)).append( "]]></sales_pers>\r\n" );
					valueXmlString.append( "<event_date><![CDATA[" ).append(eventDate).append( "]]></event_date>\r\n" );				
					valueXmlString.append( "<no_of_outlet><![CDATA[" ).append(checkNull(rs.getString("NO_OF_OUTLET"))).append( "]]></no_of_outlet>\r\n" );
					valueXmlString.append("<cust_type><![CDATA["+custType+"]]></cust_type>\r\n");														
					
					//valueXmlString.append( "</RetailData>\r\n" );
					valueXmlString.append( "</ChemData>\r\n" );
				}
				//else if("M".equalsIgnoreCase(custType))
				else if("S".equalsIgnoreCase(custType))
				{
					//valueXmlString.append( "<MerchData domID='"+domID+"' selected = 'Y'>\r\n" );
					valueXmlString.append( "<StockData domID='"+domID+"' selected = 'Y'>\r\n" );
					valueXmlString.append( "<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\"/>\r\n");
					valueXmlString.append( "<strg_code><![CDATA[" ).append( checkNull(rs.getString("STRG_CODE")).trim()).append( "]]></strg_code>\r\n");							
					valueXmlString.append( "<cust_name><![CDATA[" ).append( checkNull(rs.getString("SC_NAME")).trim()).append( "]]></cust_name>\r\n");														
					valueXmlString.append( "<sales_pers><![CDATA[" ).append(checkNull(salesPers)).append( "]]></sales_pers>\r\n" );
					valueXmlString.append( "<event_date><![CDATA[" ).append(eventDate).append( "]]></event_date>\r\n" );				
					valueXmlString.append( "<no_of_outlet><![CDATA[" ).append(checkNull(rs.getString("NO_OF_OUTLET"))).append( "]]></no_of_outlet>\r\n" );
					valueXmlString.append("<cust_type><![CDATA["+custType+"]]></cust_type>\r\n");														
					
					//valueXmlString.append( "</MerchData>\r\n" );
					valueXmlString.append( "</StockData>\r\n" );
				}
				
				else if(!"S".equalsIgnoreCase(custType) || !"C".equalsIgnoreCase(custType) || !"D".equalsIgnoreCase(custType))
				{
					//valueXmlString.append( "<MerchData domID='"+domID+"' selected = 'Y'>\r\n" );
					valueXmlString.append( "<NCWData domID='"+domID+"' selected = 'Y'>\r\n" );
					valueXmlString.append( "<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\"/>\r\n");
					valueXmlString.append( "<strg_code><![CDATA[" ).append( checkNull(rs.getString("STRG_CODE")).trim()).append( "]]></strg_code>\r\n");							
					valueXmlString.append( "<cust_name><![CDATA[" ).append( checkNull(rs.getString("SC_NAME")).trim()).append( "]]></cust_name>\r\n");														
					valueXmlString.append( "<sales_pers><![CDATA[" ).append(checkNull(salesPers)).append( "]]></sales_pers>\r\n" );
					valueXmlString.append( "<event_date><![CDATA[" ).append(eventDate).append( "]]></event_date>\r\n" );				
					valueXmlString.append( "<no_of_outlet><![CDATA[" ).append(checkNull(rs.getString("NO_OF_OUTLET"))).append( "]]></no_of_outlet>\r\n" );
					valueXmlString.append("<cust_type><![CDATA["+custType+"]]></cust_type>\r\n");														
					
					//valueXmlString.append( "</MerchData>\r\n" );
					valueXmlString.append( "</NCWData>\r\n" );
				}
				domID++;
			}
			if(!leaveFlg)
			{
				
				String activityDesc = "";
				String activityType = "";
				String leaveSql="select  ft.descr as descr, ft.ACTIVITY_TYPE ACT_TYPE  from  SPRS_ACT_TRAN SP , fieldactivity  ft " +
								"where sp.activity_code=ft.activity_code and  ft.status='Y'"+
								"and sp.sales_pers= ? and "+
								"sp.event_date= ? ";
				
				PreparedStatement pstmtLeave =  conn.prepareStatement(leaveSql);
				 
				pstmtLeave.setString(1, salesPers);
				pstmtLeave.setTimestamp( 2, java.sql.Timestamp.valueOf( eventDateDBFmt ) );
					
				ResultSet rsLeave= pstmtLeave.executeQuery();
				
				if(rsLeave.next())
				{
					activityDesc = rsLeave.getString("descr") == null ? "" :rsLeave.getString("descr");
					activityType = rsLeave.getString("ACT_TYPE") == null ? "" :rsLeave.getString("ACT_TYPE");
	
				}
		
				if (rsLeave!= null)
				{
					rsLeave.close();
					rsLeave = null;
				}
				if(pstmtLeave!=null)
				{
					pstmtLeave.close();
					pstmtLeave = null;
				}
								
				valueXmlString.append("<DoctorData domID='"+domID+"' selected = 'Y'>\r\n" );
				valueXmlString.append("<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\"/>\r\n");
				valueXmlString.append("<cust_type><![CDATA[OTH]]></cust_type>\r\n");
				valueXmlString.append("<cust_name><![CDATA[" ).append(activityDesc ).append( "]]></cust_name>\r\n");
				valueXmlString.append("<act_type><![CDATA[" ).append(activityType ).append( "]]></act_type>\r\n");
				valueXmlString.append("</DoctorData>\r\n" );
			}
			
			valueXmlString.append( "</Detail2>\r\n" );
			valueXmlString.append( "</Root>\r\n" );	
			
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}	

					
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( conn != null && ! conn.isClosed() )
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :WsfaDSRMobileWizardEJB :getCustomerDetail :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		System.out.println("valueXmlString.toString() ::"+valueXmlString.toString());
		return valueXmlString.toString();
	}
	//Added By Poonam on 11-06-15 for Mitoch Mobile Reporting
	public ArrayList getUnconfirmedDates(String salesPers)throws ITMException
	{
		ArrayList dateList = new ArrayList();
		Connection conn = null ; 
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try
		{
			 E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
			 SimpleDateFormat sdfFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());
			/*ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB( "DriverValidator" );*/
			//added by sachin satre on [14-nov-16] [start]
			conn =getConnection();
			System.out.println("connectionObject"+conn);
			//added by sachin satre on [14-nov-16] [end]
			
			//String sql = "SELECT distinct TO_CHAR(EVENT_DATE,'DD/MM/YY') AS EVENT_DATE_STR, EVENT_DATE FROM SPRS_ACT_TRAN WHERE SALES_PERS = ? AND (CASE WHEN CONFIRMED IS NULL THEN 'N' ELSE CONFIRMED END) ='N' ORDER BY EVENT_DATE";//Chnged by sachin satre for hard coded date format [5-dec-16]
			String sql = "SELECT distinct EVENT_DATE AS EVENT_DATE_STR, EVENT_DATE FROM SPRS_ACT_TRAN WHERE SALES_PERS = ? AND (CASE WHEN CONFIRMED IS NULL THEN 'N' ELSE CONFIRMED END) ='N' "+
					     "AND ACTIVITY_CODE NOT IN (SELECT ACTIVITY_CODE FROM FIELDACTIVITY WHERE ACTIVITY_TYPE = 'PR') ORDER BY EVENT_DATE"; // added by condition rupali on 14/03/17 for separate pr menu
			pstmt = conn.prepareStatement(sql);
			
			pstmt.setString(1, salesPers);
			
			rs = pstmt.executeQuery();
			
			while(rs.next())
			{
				//dateList.add(rs.getString("EVENT_DATE_STR"));//Chnged by sachin satre for hard coded date format [5-dec-16]
				java.util.Date str=rs.getDate("EVENT_DATE_STR");
				String evdDate =sdfFormat.format(str);
				dateList.add(evdDate);
			}
			
			System.out.println("dateList ::"+dateList);
			
		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if( conn != null && ! conn.isClosed() )
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :WsfaDSRMobileWizardEJB :getCustomerDetail :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		
		return dateList;
	}
	//Added by sachin satre on [14-nov-16] [start] 
	public Connection getConnection()throws RemoteException,ITMException
	{
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		try
		{
			System.out.println(" In OtvWizardBean :: getConnection() :: ["+this.userInfo+"]");
			//System.out.println(" In StrgMeetwizardBean :: getConnection() :: ["+this.userInfoBean+"]");
			if(this.userInfo != null)
			{
				String transDB = this.userInfo.getTransDB();
				System.out.println(" OtvWizardBean getConnection :: transDB :: ["+transDB+"]");
				
				if( transDB != null && transDB.trim().length() > 0 && !"null".equalsIgnoreCase(transDB))
				{
					conn = connDriver.getConnectDB(transDB);
					connDriver = null;
					System.out.println(" OtvWizardBean getConnection :: transDB :: on if condition :["+transDB+"]");
				}
				else
				{
					System.out.println(" OtvWizardBean :: transDB is null :: So that creating connection using DriverITM....");					
					conn = connDriver.getConnectDB("DriverITM");
					connDriver = null;
				}
			}
			else
			{
				System.out.println(" OtvWizardBean :: UserInfo is null :: So that creating connection using DriverITM....");
				conn = connDriver.getConnectDB("DriverITM");
				connDriver = null;
			}
		}
		catch(Exception e)
		{
			System.out.println("Exception : [OtvWizardBean][getConnection] :==>\n"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		return conn;
	}
	//Added by sachin satre on [14-nov-16] [start] 
	public String getSummaryDetailDcrMob(String salesPers, String eventDate, String actionFlag)throws ITMException
	{
		PreparedStatement pstmt = null;
		
		int domID = 1;
		
		ConnDriver connDriver = new ConnDriver();
		Connection conn = null ; 
		
		StringBuffer valueXmlString = new StringBuffer( "<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<editFlag>" );
		valueXmlString.append( "E" ).append( "</editFlag>\r\n</Header>\r\n<Errors>\r\n</Errors>\r\n" );
		try
		{
			int unconfCnt = 0;
			 E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
			/*conn = connDriver.getConnectDB( "DriverValidator" );*/
			//added by sachin satre on [14-nov-16] [start]
			conn =getConnection();
			System.out.println("connectionObject"+conn);
			//added by sachin satre on [14-nov-16] [end]
			
			String eventDateDBFmt = genericUtility.getValidDateTimeString( eventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat());
			
			String countSql = "SELECT COUNT(*) AS COUNT FROM SPRS_ACT_TRAN WHERE SALES_PERS = ? AND EVENT_DATE = ? AND (CASE WHEN SPRS_ACT_TRAN.CONFIRMED IS NULL THEN 'N' ELSE SPRS_ACT_TRAN.CONFIRMED END) ='N' ";
			PreparedStatement pstmtCount = conn.prepareStatement(countSql);
			pstmtCount.setString(1, salesPers);
			pstmtCount.setTimestamp( 2, java.sql.Timestamp.valueOf( eventDateDBFmt ) );
			
			ResultSet rsCount = pstmtCount.executeQuery();
			if(rsCount.next())
			{
				unconfCnt = rsCount.getInt("COUNT");
			}
			rsCount.close(); rsCount = null;
			pstmtCount.close(); pstmtCount = null;
			
			System.out.println("unconfCnt =["+unconfCnt+"]");
			
			valueXmlString.append("<Detail2>");
			valueXmlString.append( "<HeaderData domID='"+domID+"' selected = 'Y'>\r\n" );
			valueXmlString.append( "<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\"/>\r\n");
			valueXmlString.append( "<confirm_or_delete><![CDATA[" ).append(actionFlag).append( "]]></confirm_or_delete>\r\n");
			valueXmlString.append( "<event_date><![CDATA[" ).append(eventDate).append( "]]></event_date>\r\n");
			valueXmlString.append( "<unconf_cnt><![CDATA[" ).append(unconfCnt).append( "]]></unconf_cnt>\r\n");
			valueXmlString.append( "</HeaderData>");
			String sqlEdit  ="SELECT STRG_MEET.*,LOCALITY.DESCR LOC_DESCR,FIELDACTIVITY.ACTIVITY_TYPE ACT_TYPE,"+    
				 	" LOWER(STRG_CUSTOMER.FIRST_NAME)||' '||LOWER(STRG_CUSTOMER.LAST_NAME) AS SC_NAME,"+ 
					" STRG_CUSTOMER.ADDR1,STRG_CUSTOMER.ADDR2,STRG_CUSTOMER.ADDR3, STRG_MEET.STRG_TYPE AS CUST_TYPE, "+ 
					" (CASE WHEN STRG_MEET.STRG_TYPE = 'D' THEN 1  WHEN STRG_MEET.STRG_TYPE='R' THEN 2  WHEN STRG_MEET.STRG_TYPE='M' THEN 3 ELSE 4 END) AS CUST_TYPE_SEQ "+
					" FROM FIELDACTIVITY,STRG_MEET LEFT OUTER JOIN STRG_CUSTOMER ON STRG_MEET.STRG_CODE = STRG_CUSTOMER.SC_CODE "+
					" LEFT OUTER JOIN LOCALITY ON STRG_MEET.LOCALITY_CODE = LOCALITY.LOCALITY_CODE " +
					" LEFT OUTER JOIN SPRS_ACT_TRAN ON STRG_MEET.DCR_ID = SPRS_ACT_TRAN.DCR_ID  "+
					" WHERE STRG_MEET.EVENT_TYPE =FIELDACTIVITY.ACTIVITY_CODE"+
					" AND STRG_MEET.SALES_PERS = ? "+
					" AND STRG_MEET.EVENT_DATE = ? "+
					" AND STRG_CUSTOMER.CUST_TYPE  NOT in ('C','S') " + 
					" AND (CASE WHEN SPRS_ACT_TRAN.CONFIRMED IS NULL THEN 'N' ELSE SPRS_ACT_TRAN.CONFIRMED END) ='N' "+
					" ORDER BY CUST_TYPE_SEQ, STRG_MEET.SHORT_ID ";
			
			//chnged by sachin satre on 5-dec-16 [end] 
			
			 boolean leaveFlg=false;
			 String dcrId = "";
			pstmt =  conn.prepareStatement( sqlEdit );
			pstmt.setString(1, salesPers);
			pstmt.setTimestamp( 2, java.sql.Timestamp.valueOf( eventDateDBFmt ) );
			
			ResultSet rs = pstmt.executeQuery();					

			while(rs.next())
			{
				leaveFlg= true;

				String actypeDB = checkNull(rs.getString("ACT_TYPE"));						
				String strgCode = checkNull(rs.getString("STRG_CODE"));
				dcrId = checkNull(rs.getString("DCR_ID"));
				String custType = rs.getString("CUST_TYPE") == null ?"":rs.getString("CUST_TYPE");
				
				if("D".equalsIgnoreCase(custType) && !"PR".equalsIgnoreCase(actypeDB))
				{
					valueXmlString.append( "<DoctorData domID='"+domID+"' selected = 'Y'>\r\n" );
					valueXmlString.append( "<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\"/>\r\n");
					valueXmlString.append( "<strg_code><![CDATA[" ).append( checkNull(rs.getString("STRG_CODE")).trim()).append( "]]></strg_code>\r\n");							
					valueXmlString.append( "<cust_name><![CDATA[" ).append( checkNull(rs.getString("SC_NAME")).trim()).append( "]]></cust_name>\r\n");														
					valueXmlString.append( "<sales_pers><![CDATA[" ).append(checkNull(salesPers)).append( "]]></sales_pers>\r\n" );
					valueXmlString.append( "<event_date><![CDATA[" ).append(eventDate).append( "]]></event_date>\r\n" );				
					valueXmlString.append( "<no_of_outlet><![CDATA[" ).append(checkNull(rs.getString("NO_OF_OUTLET"))).append( "]]></no_of_outlet>\r\n" );
					valueXmlString.append("<cust_type><![CDATA["+custType+"]]></cust_type>\r\n");														
					valueXmlString.append( "<loc_descr><![CDATA[" ).append( checkNull(rs.getString("LOC_DESCR")).trim()).append( "]]></loc_descr>\r\n");
					valueXmlString.append( "</DoctorData>\r\n" );
					
					//for getting all form data
					String sqlEdit1="select it.item_code ,it.descr ITEMDESCR from strg_meet_order sm, item it where sm.item_code=it.item_code and sm.strg_code= ? and sm.dcr_id = ?";
					PreparedStatement pstmt1 = null;
					pstmt1 =  conn.prepareStatement( sqlEdit1 );
					pstmt1.setString(1, checkNull(rs.getString("STRG_CODE")));
					pstmt1.setString( 2, checkNull(rs.getString("DCR_ID")) );
					
					ResultSet rs1 = pstmt1.executeQuery();					

					valueXmlString.append( "<ItemData>" );
					while(rs1.next())
					{
						valueXmlString.append( "<item><![CDATA[" ).append(checkNull(rs1.getString("ITEMDESCR"))).append( "]]></item>\r\n" );
						valueXmlString.append( "<strg_code><![CDATA[" ).append(checkNull(rs.getString("STRG_CODE"))).append( "]]></strg_code>\r\n" );
					}
					if (rs1 != null)
					{
						rs1.close();
						rs1 = null;
					}
					if(pstmt1 !=null)
					{
						pstmt1.close();
						pstmt1 = null;
					}
					valueXmlString.append( "</ItemData>\r\n" );
				}
				else if("PR".equalsIgnoreCase(actypeDB) && "D".equalsIgnoreCase(custType))
				{
					valueXmlString.append( "<DoctorDataPR domID='"+domID+"' selected = 'Y'>\r\n" );
					valueXmlString.append( "<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\"/>\r\n");
					valueXmlString.append( "<strg_code><![CDATA[" ).append( checkNull(rs.getString("STRG_CODE")).trim()).append( "]]></strg_code>\r\n");							
					valueXmlString.append( "<cust_name><![CDATA[" ).append( checkNull(rs.getString("SC_NAME")).trim()).append( "]]></cust_name>\r\n");														
					valueXmlString.append( "<sales_pers><![CDATA[" ).append(checkNull(salesPers)).append( "]]></sales_pers>\r\n" );
					valueXmlString.append( "<event_date><![CDATA[" ).append(eventDate).append( "]]></event_date>\r\n" );				
					valueXmlString.append( "<no_of_outlet><![CDATA[" ).append(checkNull(rs.getString("NO_OF_OUTLET"))).append( "]]></no_of_outlet>\r\n" );
					valueXmlString.append("<cust_type><![CDATA["+custType+"]]></cust_type>\r\n");
					valueXmlString.append("<act_type><![CDATA[" ).append(actypeDB ).append( "]]></act_type>\r\n");
					valueXmlString.append( "<loc_descr><![CDATA[" ).append( checkNull(rs.getString("LOC_DESCR")).trim()).append( "]]></loc_descr>\r\n");
					valueXmlString.append( "</DoctorDataPR>\r\n" );
					String sqlEdit1="select it.item_code ,it.descr ITEMDESCR from strg_meet_order sm, item it where sm.item_code=it.item_code and sm.strg_code= ? and sm.dcr_id = ?";
					PreparedStatement pstmt1 = null;
					pstmt1 =  conn.prepareStatement( sqlEdit1 );
					pstmt1.setString(1, checkNull(rs.getString("STRG_CODE")));
					pstmt1.setString( 2, checkNull(rs.getString("DCR_ID")) );
					
					ResultSet rs1 = pstmt1.executeQuery();					

					valueXmlString.append( "<ItemData>" );
					while(rs1.next())
					{
						valueXmlString.append( "<item><![CDATA[" ).append(checkNull(rs1.getString("ITEMDESCR"))).append( "]]></item>\r\n" );
						valueXmlString.append( "<strg_code><![CDATA[" ).append(checkNull(rs.getString("STRG_CODE"))).append( "]]></strg_code>\r\n" );
					}
					if (rs1 != null)
					{
						rs1.close();
						rs1 = null;
					}
					if(pstmt1 !=null)
					{
						pstmt1.close();
						pstmt1 = null;
					}
					valueXmlString.append( "</ItemData>\r\n" );
				}
				//else if("R".equalsIgnoreCase(custType))
				else if("C".equalsIgnoreCase(custType))
				{
					//valueXmlString.append( "<RetailData domID='"+domID+"' selected = 'Y'>\r\n" );
					valueXmlString.append( "<ChemData domID='"+domID+"' selected = 'Y'>\r\n" );
					valueXmlString.append( "<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\"/>\r\n");
					valueXmlString.append( "<strg_code><![CDATA[" ).append( checkNull(rs.getString("STRG_CODE")).trim()).append( "]]></strg_code>\r\n");							
					valueXmlString.append( "<cust_name><![CDATA[" ).append( checkNull(rs.getString("SC_NAME")).trim()).append( "]]></cust_name>\r\n");														
					valueXmlString.append( "<sales_pers><![CDATA[" ).append(checkNull(salesPers)).append( "]]></sales_pers>\r\n" );
					valueXmlString.append( "<event_date><![CDATA[" ).append(eventDate).append( "]]></event_date>\r\n" );				
					valueXmlString.append( "<no_of_outlet><![CDATA[" ).append(checkNull(rs.getString("NO_OF_OUTLET"))).append( "]]></no_of_outlet>\r\n" );
					valueXmlString.append("<cust_type><![CDATA["+custType+"]]></cust_type>\r\n");														
					
					//valueXmlString.append( "</RetailData>\r\n" );
					valueXmlString.append( "</ChemData>\r\n" );
				}
				//else if("M".equalsIgnoreCase(custType))
				else if("S".equalsIgnoreCase(custType))
				{
					//valueXmlString.append( "<MerchData domID='"+domID+"' selected = 'Y'>\r\n" );
					valueXmlString.append( "<StockData domID='"+domID+"' selected = 'Y'>\r\n" );
					valueXmlString.append( "<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\"/>\r\n");
					valueXmlString.append( "<strg_code><![CDATA[" ).append( checkNull(rs.getString("STRG_CODE")).trim()).append( "]]></strg_code>\r\n");							
					valueXmlString.append( "<cust_name><![CDATA[" ).append( checkNull(rs.getString("SC_NAME")).trim()).append( "]]></cust_name>\r\n");														
					valueXmlString.append( "<sales_pers><![CDATA[" ).append(checkNull(salesPers)).append( "]]></sales_pers>\r\n" );
					valueXmlString.append( "<event_date><![CDATA[" ).append(eventDate).append( "]]></event_date>\r\n" );				
					valueXmlString.append( "<no_of_outlet><![CDATA[" ).append(checkNull(rs.getString("NO_OF_OUTLET"))).append( "]]></no_of_outlet>\r\n" );
					valueXmlString.append("<cust_type><![CDATA["+custType+"]]></cust_type>\r\n");														
					
					//valueXmlString.append( "</MerchData>\r\n" );
					valueXmlString.append( "</StockData>\r\n" );
					String sqlEdit1="select it.item_code ,it.descr ITEMDESCR from strg_meet_order sm, item it where sm.item_code=it.item_code and sm.strg_code= ? and sm.dcr_id = ?";
					PreparedStatement pstmt1 = null;
					pstmt1 =  conn.prepareStatement( sqlEdit1 );
					pstmt1.setString(1, checkNull(rs.getString("STRG_CODE")));
					pstmt1.setString( 2, checkNull(rs.getString("DCR_ID")) );
					
					ResultSet rs1 = pstmt1.executeQuery();					

					valueXmlString.append( "<ItemData>" );
					while(rs1.next())
					{
						valueXmlString.append( "<item><![CDATA[" ).append(checkNull(rs1.getString("ITEMDESCR"))).append( "]]></item>\r\n" );
						valueXmlString.append( "<strg_code><![CDATA[" ).append(checkNull(rs.getString("STRG_CODE"))).append( "]]></strg_code>\r\n" );
					}
					if (rs1 != null)
					{
						rs1.close();
						rs1 = null;
					}
					if(pstmt1 !=null)
					{
						pstmt1.close();
						pstmt1 = null;
					}
					valueXmlString.append( "</ItemData>\r\n" );
				}
				
				else if(!"S".equalsIgnoreCase(custType) || !"C".equalsIgnoreCase(custType) || !"D".equalsIgnoreCase(custType))
				{
					//valueXmlString.append( "<MerchData domID='"+domID+"' selected = 'Y'>\r\n" );
					valueXmlString.append( "<NCWData domID='"+domID+"' selected = 'Y'>\r\n" );
					valueXmlString.append( "<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\"/>\r\n");
					valueXmlString.append( "<strg_code><![CDATA[" ).append( checkNull(rs.getString("STRG_CODE")).trim()).append( "]]></strg_code>\r\n");							
					valueXmlString.append( "<cust_name><![CDATA[" ).append( checkNull(rs.getString("SC_NAME")).trim()).append( "]]></cust_name>\r\n");														
					valueXmlString.append( "<sales_pers><![CDATA[" ).append(checkNull(salesPers)).append( "]]></sales_pers>\r\n" );
					valueXmlString.append( "<event_date><![CDATA[" ).append(eventDate).append( "]]></event_date>\r\n" );				
					valueXmlString.append( "<no_of_outlet><![CDATA[" ).append(checkNull(rs.getString("NO_OF_OUTLET"))).append( "]]></no_of_outlet>\r\n" );
					valueXmlString.append("<cust_type><![CDATA["+custType+"]]></cust_type>\r\n");														
					valueXmlString.append( "<loc_descr><![CDATA[" ).append( checkNull(rs.getString("LOC_DESCR")).trim()).append( "]]></loc_descr>\r\n");
					//valueXmlString.append( "</MerchData>\r\n" );
					valueXmlString.append( "</NCWData>\r\n" );
					String sqlEdit1="select it.item_code ,it.descr ITEMDESCR from strg_meet_order sm, item it where sm.item_code=it.item_code and sm.strg_code= ? and sm.dcr_id = ?";
					PreparedStatement pstmt1 = null;
					pstmt1 =  conn.prepareStatement( sqlEdit1 );
					pstmt1.setString(1, checkNull(rs.getString("STRG_CODE")));
					pstmt1.setString( 2, checkNull(rs.getString("DCR_ID")) );
					
					ResultSet rs1 = pstmt1.executeQuery();					

					valueXmlString.append( "<ItemData>" );
					while(rs1.next())
					{
						valueXmlString.append( "<item><![CDATA[" ).append(checkNull(rs1.getString("ITEMDESCR"))).append( "]]></item>\r\n" );
						valueXmlString.append( "<strg_code><![CDATA[" ).append(checkNull(rs.getString("STRG_CODE"))).append( "]]></strg_code>\r\n" );
					}
					if (rs1 != null)
					{
						rs1.close();
						rs1 = null;
					}
					if(pstmt1 !=null)
					{
						pstmt1.close();
						pstmt1 = null;
					}
					valueXmlString.append( "</ItemData>\r\n" );
				}
				domID++;
			}
			boolean isDetailExist = false;
			String sql= " SELECT ROWNUM,CUST_NAME,QUANTITY,DESCR,POB FROM "+
					" (SELECT SMI.QUANTITY QUANTITY,ITEM.SH_DESCR DESCR,SMI.VALUE AS POB, "+
					" SC.FIRST_NAME||' '||SC.LAST_NAME AS CUST_NAME FROM STRG_MEET_ORDER SMI "+
					" JOIN ITEM ITEM ON SMI.ITEM_CODE = ITEM.ITEM_CODE "+
					" JOIN STRG_CUSTOMER SC  ON SMI.STRG_CODE=SC.SC_CODE "+
					" WHERE SMI.DCR_ID= ?)";
			    
		    pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, dcrId);
			rs = pstmt.executeQuery();
			while(rs.next())
			{

				isDetailExist = true;
				valueXmlString.append("<Detail10>\r\n");
				valueXmlString.append("<item_rowNum>").append("<![CDATA[").append(rs.getString("ROWNUM") == null ? "" : rs.getString("ROWNUM")).append("]]>").append("</item_rowNum>\r\n ");
				valueXmlString.append("<cust_name>").append("<![CDATA[").append(rs.getString("CUST_NAME") == null ? "" : rs.getString("CUST_NAME")).append("]]>").append("</cust_name>\r\n ");
				valueXmlString.append("<item_quantity>").append("<![CDATA[").append(rs.getString("QUANTITY") == null ? "" : rs.getString("QUANTITY")).append("]]>").append("</item_quantity>\r\n ");
				valueXmlString.append("<item_descr>").append("<![CDATA[").append(rs.getString("DESCR") == null ? "" : rs.getString("DESCR")).append("]]>").append("</item_descr>\r\n ");
				valueXmlString.append("<item_pob>").append("<![CDATA[").append(rs.getString("POB") == null ? "" : rs.getString("POB")).append("]]>").append("</item_pob>\r\n ");
				
				valueXmlString.append("</Detail10>\r\n");
				
				}
				if(! isDetailExist)
				{
					valueXmlString.append("<Detail10>\r\n");
					valueXmlString.append("</Detail10>\r\n");
				}
				isDetailExist = false;
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
				
				{
					boolean isActDetailExist = false;
					String activityDesc = "";
					String activityType = "";
					String leaveSql="select  ft.descr as descr, ft.ACTIVITY_TYPE ACT_TYPE  from  SPRS_ACT_TRAN SP , fieldactivity  ft " +
									"where sp.activity_code=ft.activity_code and  ft.status='Y'"+
									"and sp.sales_pers= ? and "+
									"sp.event_date= ? ";
					
					PreparedStatement pstmtLeave =  conn.prepareStatement(leaveSql);
					 
					pstmtLeave.setString(1, salesPers);
					pstmtLeave.setTimestamp( 2, java.sql.Timestamp.valueOf( eventDateDBFmt ) );
						
					ResultSet rsLeave= pstmtLeave.executeQuery();
					
					if(rsLeave.next())
					{
						isActDetailExist = true;
						activityDesc = rsLeave.getString("descr") == null ? "" :rsLeave.getString("descr");
						activityType = rsLeave.getString("ACT_TYPE") == null ? "" :rsLeave.getString("ACT_TYPE");
						valueXmlString.append("<ActivityData>\r\n" );
						valueXmlString.append("<descr><![CDATA[" ).append(activityDesc ).append( "]]></descr>\r\n");
						valueXmlString.append("<act_type><![CDATA[" ).append(activityType ).append( "]]></act_type>\r\n");
						valueXmlString.append("</ActivityData>\r\n" );
					}
					if(! isActDetailExist)
					{
						valueXmlString.append("<ActivityData>\r\n");
						valueXmlString.append("</ActivityData>\r\n");
					}
					if (rsLeave!= null)
					{
						rsLeave.close();
						rsLeave = null;
					}
					if(pstmtLeave!=null)
					{
						pstmtLeave.close();
						pstmtLeave = null;
					}
									
					valueXmlString.append("<DoctorData domID='"+domID+"' selected = 'Y'>\r\n" );
					valueXmlString.append("<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\"/>\r\n");
					valueXmlString.append("<cust_type><![CDATA[OTH]]></cust_type>\r\n");
					valueXmlString.append("<cust_name><![CDATA[" ).append(activityDesc ).append( "]]></cust_name>\r\n");
					valueXmlString.append("<act_type><![CDATA[" ).append(activityType ).append( "]]></act_type>\r\n");
					valueXmlString.append("</DoctorData>\r\n" );
				}
				
				valueXmlString.append( "</Detail2>\r\n" );
				valueXmlString.append( "</Root>\r\n" );	
				
					

		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( conn != null && ! conn.isClosed() )
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :WsfaDSRMobileWizardEJB :getCustomerDetail :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		System.out.println("valueXmlString.toString() ::"+valueXmlString.toString());
		return valueXmlString.toString();
	}
	public String  viewReportsDcrMeet(String salesPerson, String eventDate, String actionFlag, String callReport,String reportId,String deviceType,String profileId) throws RemoteException, ITMException
	{
		String summHtmlData = "";
		InitialContext ctx = null;
		Connection connection = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		//Added by Jay to take enterprise of user 19-JAN-23 [start]
		String enterprise = "";

		try
		{
			ConnDriver connDriver = new ConnDriver();
			connection = connDriver.getConnectDB("Driver");
			
			//Added by Jay to take enterprise of user 19-JAN-23 [in process]
			//String sql = "SELECT ENTERPRISE FROM USERS WHERE CODE=?";
			String sql = "SELECT ENTERPRISE FROM USERS WHERE EMP_CODE = ?";// Changes by Hariom S for enterprise data should take from users table. -- 20-Sep-2023
			pstmt = connection.prepareStatement(sql);
			pstmt.setString(1, salesPerson);
			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				enterprise = rs.getString("ENTERPRISE");
				System.out.println("Enterprise is:"+enterprise);

			}
			if( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			if( rs != null )
			{
				rs.close();
				rs = null;
			}
			if( connection != null )
			{
				connection.close();
				connection = null;
			}
			
			//Added by Jay to take enterprise of user 19-JAN-23 [End]

			
			if(profileId!=null && profileId.trim().length()>0)
			{
				profileId=profileId.trim();
			}
			
			System.out.println("Inside viewReportsDcrMeet eventDate:["+eventDate+"] salesPerson::["+salesPerson+"] salesPerson::["+salesPerson+"] callReport::["+callReport+"] profileId::["+profileId+"]");
			String summaryData = getSummaryDetailDcrMeet( salesPerson, eventDate, actionFlag ,callReport,reportId,deviceType,profileId);
			System.out.println("Device Type is:"+deviceType);
			String xslFileName ="";
			if(deviceType!=null && "Browser".equalsIgnoreCase(deviceType))
			{
				xslFileName = getXSLFileName( "strg_meet_dcr_conf_wiz_" + this.user_lang + "_" + this.user_country + ".xsl",enterprise );
			}
			else
			{
				//System.out.println("Device Type is in else is:"+deviceType);
				xslFileName = getXSLFileNameMob( "strg_meet_dcr_conf_wiz_MOBILE_" + this.user_lang + "_" + this.user_country + ".xsl" ,"strg_meet_dcr_conf_wiz_" + this.user_lang + "_" + this.user_country + ".xsl",enterprise);
			}
			System.out.println("xslFileName ::"+xslFileName);
			E12GenericUtility genericUtility = new E12GenericUtility();
			
			Document errorStrDom = genericUtility.parseString( summaryData );
			NodeList errorStrNodeList =  errorStrDom.getElementsByTagName("Detail1");
			int length = errorStrNodeList.getLength();
			
			System.out.println("length : ["+ length +"]");
			
			if(length == 0)
			{
				return summHtmlData;
			}
			else
			{
				summHtmlData = genericUtility.transformToString( xslFileName, summaryData, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );
			}
		}
		catch(Exception e )
		{
			System.out.println("Exception : DCRSummaryBean :viewReportsDcrMeet() :==>\n"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		return summHtmlData;
	}
	//Added by Hariom S for Expense DCR view links -- 16-Nov-2021 [Start]
	public String  viewReportsDcrMeetExpense(String salesPerson, String eventDate, String actionFlag, String callReport,String reportId,String deviceType,String profileId) throws RemoteException, ITMException
	{
		String summHtmlData = "";
		InitialContext ctx = null;
		
		try
		{
			
			if(profileId!=null && profileId.trim().length()>0)
			{
				profileId=profileId.trim();
			}
			
			System.out.println("Inside viewReportsDcrMeet eventDate:["+eventDate+"] salesPerson::["+salesPerson+"] salesPerson::["+salesPerson+"] callReport::["+callReport+"] profileId::["+profileId+"]");
			String summaryData = getSummaryDetailDcrMeet( salesPerson, eventDate, actionFlag ,callReport,reportId,deviceType,profileId);
			System.out.println("Device Type is:"+deviceType);
			String xslFileName ="";
			//if(deviceType!=null && "Browser".equalsIgnoreCase(deviceType))
			//{
				xslFileName = getXSLFileName( "expense_strg_meet_dcr_conf_wiz_" + this.user_lang + "_" + this.user_country + ".xsl" );
			//}
			/*else
			{
				//System.out.println("Device Type is in else is:"+deviceType);
				xslFileName = getXSLFileNameMob( "expense_strg_meet_dcr_conf_wiz_MOBILE_" + this.user_lang + "_" + this.user_country + ".xsl" ,"expense_strg_meet_dcr_conf_wiz_" + this.user_lang + "_" + this.user_country + ".xsl");
			}*/
			System.out.println("xslFileName ::"+xslFileName);
			E12GenericUtility genericUtility = new E12GenericUtility();
			
			Document errorStrDom = genericUtility.parseString( summaryData );
			NodeList errorStrNodeList =  errorStrDom.getElementsByTagName("Detail1");
			int length = errorStrNodeList.getLength();
			
			System.out.println("length : ["+ length +"]");
			
			if(length == 0)
			{
				return summHtmlData;
			}
			else
			{
				summHtmlData = genericUtility.transformToString( xslFileName, summaryData, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );
			}
		}
		catch(Exception e )
		{
			System.out.println("Exception : DCRSummaryBean :viewReportsDcrMeetExpense() :==>\n"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		return summHtmlData;
	}
	//Added by Hariom S for Expense DCR view links -- 16-Nov-2021 [End]
	public String getSummaryDetailDcrMeet(String salesPers, String eventDate, String actionFlag ,String callReport,String reportId,String deviceType, String profileId)throws ITMException
	{
		PreparedStatement pstmt = null;
		PreparedStatement pstmtNoOfVis = null ;
		HashMap<String, String> itemUsageMap = new HashMap<String, String>();
		DARCommonBean dcb = new DARCommonBean();
		int domID = 1;
		
		ConnDriver connDriver = new ConnDriver();
		Connection conn = null ; 
		StringBuffer missedDateBuffer;
		
		StringBuffer valueXmlString = new StringBuffer( "<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<editFlag>" );
		valueXmlString.append( "E" ).append( "</editFlag>\r\n</Header>\r\n<Errors>\r\n</Errors>\r\n" );
		try
		{
			String eventDateDBFmt = "";
			System.out.println("Inside getSummaryDetailDcrMeet eventDate:["+eventDate+"] salesPers::["+salesPers+"] callReport::["+callReport+"] profileId:["+profileId+"]actionFlag"+actionFlag);
			int unconfCnt = 0;
			E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
			/*conn = connDriver.getConnectDB( "DriverValidator" );*/
			//added by sachin satre on [14-nov-16] [start]
			conn =getConnection();
			//System.out.println("connectionObject"+conn);
			//added by sachin satre on [14-nov-16] [end]
			String oldData=checkNull(getSfaParmValue(salesPers, "OLD_METIS_DAR_DATA", conn));
			String isFortuneAct=checkNull(getSfaParmValue(salesPers,"IS_FORTUNE_ACTIVITY",conn));//Added By Mrunalini Sinkar For Fortune Server 20-May-2020
			//changes by shraddha M for unparsable date exception[14/10/2020]Start
			if(eventDate != null && eventDate.length() > 0) 
			{
				eventDateDBFmt = genericUtility.getValidDateTimeString( eventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat());
			}
			//String eventDateDBFmt = genericUtility.getValidDateTimeString( eventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat());
			//changes by shraddha M for unparsable date exception[14/10/2020]End
			//added by Mrunalini Sinkar on 29/01/18 for adding the is_confirm_req condition(start)
			String mgrCode = getMGREmployee(salesPers, conn); //Added By Mrunalini Sinkar on 26-sep-2018 To Reove Profile Id Condition(start)
			String confirmReq=null;
			String isConfirmReq="",isDeleteReq="";
			//Commented & Added By Mrunalini Sinkar on 26-sep-2018 To Reove Profile Id Condition(start)
			/*if(profileId.equalsIgnoreCase("MR") || profileId.equalsIgnoreCase("SFA") || profileId.equalsIgnoreCase("FLM") || profileId.equalsIgnoreCase("CHM"))
			{
				if(profileId.equalsIgnoreCase("MR") || profileId.equalsIgnoreCase("SFA"))
				{
					confirmReq="select a.is_confirmation_req as confirm,b.is_confirmation_req as del from obj_actions a,obj_actions b where a.obj_name='strg_meet_dcr_wiz' and b.obj_name='strg_meet_dcr_wiz' and  a.service_code='pre_confirm' and b.service_code='pre_cancle'";
				}
				else if(profileId.equalsIgnoreCase("FLM"))
				{
					confirmReq="select a.is_confirmation_req as confirm,b.is_confirmation_req as del from obj_actions a,obj_actions b where a.obj_name='strg_meet_mgr_dcr_wiz' and b.obj_name='strg_meet_mgr_dcr_wiz' and  a.service_code='pre_confirm' and b.service_code='pre_cancle'";
				}
				else if(profileId.equalsIgnoreCase("CHM"))
				{
					confirmReq="select a.is_confirmation_req as confirm,b.is_confirmation_req as del from obj_actions a,obj_actions b where a.obj_name='strg_meet_chk_dcr_wiz' and b.obj_name='strg_meet_chk_dcr_wiz' and  a.service_code='pre_confirm' and b.service_code='pre_cancle'";
				}
				PreparedStatement pstmtConfirmReq = conn.prepareStatement(confirmReq);
				ResultSet rsConfirmReq = pstmtConfirmReq.executeQuery();
				if(rsConfirmReq.next())
				{
					isConfirmReq=checkNull(rsConfirmReq.getString("confirm"));
					isDeleteReq=checkNull(rsConfirmReq.getString("del"));
				}
				if (rsConfirmReq != null)
				{
					rsConfirmReq.close();
					rsConfirmReq = null;
				}
				if(pstmtConfirmReq !=null)
				{
					pstmtConfirmReq.close();
					pstmtConfirmReq = null;
				}
				System.out.println("isConfirmReq is["+isConfirmReq+"] isDeleteReq is["+isDeleteReq+"]");
			}*/
			if(mgrCode.trim().length()!= 0)
			{
				confirmReq="select a.is_confirmation_req as confirm,b.is_confirmation_req as del from obj_actions a,obj_actions b where a.obj_name='strg_meet_mgr_dcr_wiz' and b.obj_name='strg_meet_mgr_dcr_wiz' and  a.service_code='pre_confirm' and b.service_code='pre_cancle'";
				
			}
			else
			{
				confirmReq="select a.is_confirmation_req as confirm,b.is_confirmation_req as del from obj_actions a,obj_actions b where a.obj_name='strg_meet_dcr_wiz' and b.obj_name='strg_meet_dcr_wiz' and  a.service_code='pre_confirm' and b.service_code='pre_cancle'";
			}
			PreparedStatement pstmtConfirmReq = conn.prepareStatement(confirmReq);
			ResultSet rsConfirmReq = pstmtConfirmReq.executeQuery();
			if(rsConfirmReq.next())
			{
				isConfirmReq=checkNull(rsConfirmReq.getString("confirm"));
				isDeleteReq=checkNull(rsConfirmReq.getString("del"));
			}
			if (rsConfirmReq != null)
			{
				rsConfirmReq.close();
				rsConfirmReq = null;
			}
			if(pstmtConfirmReq !=null)
			{
				pstmtConfirmReq.close();
				pstmtConfirmReq = null;
			}
			System.out.println("isConfirmReq is["+isConfirmReq+"] isDeleteReq is["+isDeleteReq+"]");
			//Commented & Added By Mrunalini Sinkar on 26-sep-2018 To Reove Profile Id Condition(end)
			int newCnt=0;
			boolean darOldData=false;
			String newCntSql="SELECT COUNT(*) AS COUNT FROM SPRS_ACT_TRAN WHERE SALES_PERS = ? AND EVENT_DATE = ?";
			PreparedStatement pstmtCnt=conn.prepareStatement(newCntSql);
			pstmtCnt.setString(1, salesPers);
			pstmtCnt.setTimestamp( 2, java.sql.Timestamp.valueOf( eventDateDBFmt ) );
			ResultSet rsCnt = pstmtCnt.executeQuery();
			if(rsCnt.next())
			{
				newCnt = rsCnt.getInt("COUNT");
			}
			rsCnt.close(); rsCnt = null;
			pstmtCnt.close(); pstmtCnt = null;
			String countSql="";
			if("Y".equalsIgnoreCase(oldData) && newCnt==0)
			{
				darOldData=true;
				countSql="SELECT COUNT(*) AS COUNT FROM DR_MAIN WHERE SALES_PERS = ? AND WORK_DATE = ? AND (CASE WHEN DR_MAIN.CONFIRMATION_FLAG IS NULL THEN 'N' ELSE DR_MAIN.CONFIRMATION_FLAG END) ='N'"; 
						
			}
			else
			{
				countSql = "SELECT COUNT(*) AS COUNT FROM SPRS_ACT_TRAN WHERE SALES_PERS = ? AND EVENT_DATE = ? AND (CASE WHEN SPRS_ACT_TRAN.CONFIRMED IS NULL THEN 'N' ELSE SPRS_ACT_TRAN.CONFIRMED END) ='N' ";
			}
			PreparedStatement pstmtCount = conn.prepareStatement(countSql);
			pstmtCount.setString(1, salesPers);
			pstmtCount.setTimestamp( 2, java.sql.Timestamp.valueOf( eventDateDBFmt ) );
			
			ResultSet rsCount = pstmtCount.executeQuery();
			if(rsCount.next())
			{
				unconfCnt = rsCount.getInt("COUNT");
			}
			rsCount.close(); rsCount = null;
			pstmtCount.close(); pstmtCount = null;
			
			System.out.println("unconfCnt =["+unconfCnt+"]");
			String missedData = "";
			String sfaParmData  = getSfaParmValue(salesPers,"IS_PLAN_COMPULSORY",conn);
			if(sfaParmData.equalsIgnoreCase("Y"))
			{
				missedDateBuffer = new StringBuffer();
				String []missedDataArr = new String [2]; 
				missedDataArr = getMissedData(salesPers,eventDateDBFmt, conn);
				missedDateBuffer.append(eventDate +"@"+missedDataArr[0]+"@"+missedDataArr[1]+"|");
				missedData = missedDateBuffer.toString();
			}
			System.out.println("missedData::"+missedData);
			
			valueXmlString.append("<DARDetails>");
			
			//valueXmlString.append("<HeaderData>");
			valueXmlString.append( "<HeaderData domID='"+domID+"' selected = 'Y'>\r\n" );
			valueXmlString.append( "<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\"/>\r\n");
			valueXmlString.append( "<confirm_or_delete><![CDATA[" ).append(actionFlag).append( "]]></confirm_or_delete>\r\n");
			valueXmlString.append( "<callReport><![CDATA[" ).append(callReport).append( "]]></callReport>\r\n");//added by prathamesh jangam on 11/7/17 for call report in db2
			valueXmlString.append( "<event_date><![CDATA[" ).append(eventDate).append( "]]></event_date>\r\n");
			valueXmlString.append( "<unconf_cnt><![CDATA[" ).append(unconfCnt).append( "]]></unconf_cnt>\r\n");
			valueXmlString.append( "<isConfirmReq><![CDATA[" ).append(isConfirmReq).append( "]]></isConfirmReq>\r\n");//added by Mrunalini Sinkar on 29/01/18 for adding the is_confirm_req condition
			valueXmlString.append( "<isDeleteReq><![CDATA[" ).append(isDeleteReq).append( "]]></isDeleteReq>\r\n");//added by Mrunalini Sinkar on 29/01/18 for adding the is_confirm_req condition
			valueXmlString.append( "<missed_data><![CDATA[" ).append(missedData).append( "]]></missed_data>\r\n" );
			valueXmlString.append( "<report_id><![CDATA[" ).append(reportId).append( "]]></report_id>\r\n" );
			valueXmlString.append( "<device_type><![CDATA[" ).append(deviceType).append( "]]></device_type>\r\n" );
			valueXmlString.append( "<old_data><![CDATA[" ).append(darOldData).append( "]]></old_data>\r\n" );
			valueXmlString.append( "<is_fortune_act><![CDATA[" ).append(isFortuneAct).append( "]]></is_fortune_act>\r\n" );

			valueXmlString.append( "</HeaderData>\r\n");
			String stanCodeFrom  = getStanCodeFrom( conn,salesPers,eventDateDBFmt);
			
			System.out.println("eventDateDBFmt =["+eventDateDBFmt+"]");
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getDBDateFormat());
			Calendar cal = Calendar.getInstance();
			cal.setTime( sdf.parse(eventDateDBFmt) );
			cal.add(Calendar.DATE,-1);
			sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			//String lastDcrDt = sdf.format(cal.getTime());
			//System.out.println("lastDcrDt =["+lastDcrDt+"]");
			
			//added by mrunalini sinkar for getting last dcr_date on 12-04-2019(start)
			Date lastDcrDt =null;
			String lastSql="";
			if("Y".equalsIgnoreCase(oldData) && newCnt==0)
			{
				lastSql="SELECT MAX(WORK_DATE) LAST_DCR_DATE FROM DR_MAIN WHERE WORK_DATE < ? AND SALES_PERS = ? "
						+ "AND ACTIVITY_CODE IN (SELECT ACTIVITY_CODE FROM FIELDACTIVITY WHERE ACTIVITY_TYPE !='PR')";
			}
			else
			{
				lastSql = "SELECT MAX(EVENT_DATE) LAST_DCR_DATE FROM SPRS_ACT_TRAN WHERE EVENT_DATE < ? AND SALES_PERS = ? "+
						  "AND ACTIVITY_CODE IN (SELECT ACTIVITY_CODE FROM FIELDACTIVITY WHERE ACTIVITY_TYPE !='PR')";
			}
			 
				pstmt =  conn.prepareStatement(lastSql);
				pstmt.setTimestamp( 1, java.sql.Timestamp.valueOf( eventDateDBFmt ) );
				pstmt.setString(2, salesPers);
				ResultSet lastRs = pstmt.executeQuery();
				if(lastRs.next())
				{
					lastDcrDt = lastRs.getDate("LAST_DCR_DATE");
				}
				if (lastRs!= null)
				{
					lastRs.close();
					lastRs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
			String lastDcrDate="";
			if(lastDcrDt!=null )
			{
				lastDcrDate = sdf.format(lastDcrDt);

			}
			else
			{
				lastDcrDate = eventDate;

			}
			
			//added by mrunalini sinkar for getting last dcr_date on 12-04-2019(end)
			
			//Added by mrunalini sinkar to showing headquarter in summary page (start) 
			String stanCodeHQ="",headQaurter="";
			String hqSql="SELECT EMP.STAN_CODE__HQ AS STAN_CODE__HQ,ST.DESCR AS HEADQAURTER FROM EMPLOYEE EMP,STATION ST WHERE EMP.EMP_CODE=? AND EMP.STAN_CODE__HQ=ST.STAN_CODE";
			pstmt =  conn.prepareStatement(hqSql);
			pstmt.setString(1, salesPers);
			ResultSet rsSet = pstmt.executeQuery();
			rsSet = pstmt.executeQuery();
			if(rsSet.next())
			{
				stanCodeHQ = checkNull(rsSet.getString("STAN_CODE__HQ"));
				headQaurter = checkNull(rsSet.getString("HEADQAURTER"));
			}
			if (rsSet!= null)
			{
				rsSet.close();
				rsSet = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			
			//Added by mrunalini sinkar to showing headquarter in summary page (end)
			//Added by Bhagyashri T for showing Load_no and Vehicle no on summary page (start)
			
			//Added by mrunalini sinkar for Load Number changes28 Feb 2023 :Start
			String maxDaySummDate="";

			String daySummMaxSQL="SELECT MAX(EVENT_DATE) AS MAX_DAY_SUMM_DATE FROM SPRS_DAY_SUMM WHERE SALES_PERS=? AND EVENT_DATE<=? ";
			pstmt =  conn.prepareStatement(daySummMaxSQL);
			pstmt.setString(1, salesPers);
			pstmt.setTimestamp(2, java.sql.Timestamp.valueOf(eventDateDBFmt));
			rsSet = pstmt.executeQuery();
			if(rsSet.next())
			{
				maxDaySummDate=checkNull(rsSet.getString("MAX_DAY_SUMM_DATE"));
			}
			if (rsSet!= null)
			{
				rsSet.close();
				rsSet = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			//Added by mrunalini sinkar for Load Number changes28 Feb 2023 :End

			String loadNo="",vehicleNo="";
			if(maxDaySummDate != null && maxDaySummDate.trim().length() > 0) 
			{

				String daySummSql="SELECT SDA.LOAD_NO AS LOAD_NO,SDA.VEH_NO AS VEHICLE_NO FROM SPRS_DAY_SUMM SDA WHERE TRIM(SDA.SALES_PERS)=TRIM(?) AND SDA.EVENT_DATE=?";
				pstmt =  conn.prepareStatement(daySummSql);
				pstmt.setString(1, salesPers);
				pstmt.setTimestamp(2,java.sql.Timestamp.valueOf(maxDaySummDate));
				rsSet = pstmt.executeQuery();
				if(rsSet.next())
				{
					loadNo = checkNull(rsSet.getString("LOAD_NO"));
					vehicleNo = checkNull(rsSet.getString("VEHICLE_NO"));
				}
				if (rsSet!= null)
				{
					rsSet.close();
					rsSet = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}

			}
			
			
			
			


			//Added by Bhagyashri T for showing Load_no and Vehicle no on summary page (end)
			String placeRequired="";
			String dcrID = "",subDispDate="";
			String custDcrId="";
			String activitySql="";
			if("Y".equalsIgnoreCase(oldData) && newCnt==0)
			{
				activitySql = "SELECT '' DCR_ID,SA.SALES_PERS,SA.WORK_DATE EVENT_CODE,SP.SP_NAME SP_NAME,SA.ACTIVITY_CODE,FA.DESCR ACTIVITY_DESCR,FA.ACTIVITY_TYPE,FA.PLACE_REQUIRED,SA.REMARK    AS REMARK, " + 
				"TO_CHAR(SA.SUBMISSION_DATE, 'DD-MM-YYYY HH12:MI A.M.') AS SUBMISSION_DATE, " + 
				"(CASE WHEN SA.CONFIRMATION_FLAG IS NULL THEN 'N' ELSE SA.CONFIRMATION_FLAG END) AS CONFIRMED, " + 
				"(CASE WHEN CONFIRMATION_FLAG='Y' THEN TO_CHAR(SA.LAST_UPDATE, 'DD-MM-YYYY HH12:MI A.M.')  ELSE '' END)AS CONF_DATE " + 
				"FROM DR_MAIN SA,SALES_PERS SP,FIELDACTIVITY FA " + 
				"WHERE SA.ACTIVITY_CODE = FA.ACTIVITY_CODE " + 
				"AND SA.SALES_PERS =SP.SALES_PERS " + 
				"AND SA.SALES_PERS   = ? " + 
				"AND SA.WORK_DATE   = ? " + 
				"AND SA.ACTIVITY_CODE  <> 'PR'"; 
				
			}
			else
			{
				activitySql = "SELECT SA.DCR_ID DCR_ID,SA.SALES_PERS, SA.EVENT_DATE EVENT_CODE,SP.SP_NAME SP_NAME,SA.ACTIVITY_CODE,FA.DESCR ACTIVITY_DESCR,FA.ACTIVITY_TYPE,FA.PLACE_REQUIRED, "
						+ "SA.REMARK AS REMARK,TO_CHAR(SA.SUBMISSION_DATE, 'DD-MM-YYYY HH12:MI A.M.') AS SUBMISSION_DATE,(CASE WHEN SA.CONFIRMED IS NULL THEN 'N' ELSE SA.CONFIRMED END) AS CONFIRMED,TO_CHAR(SA.CONF_DATE, 'DD-MM-YYYY HH12:MI A.M.') AS CONF_DATE FROM " +
						"SPRS_ACT_TRAN SA, SALES_PERS SP,FIELDACTIVITY FA WHERE SA.ACTIVITY_CODE = FA.ACTIVITY_CODE AND SA.SALES_PERS=SP.SALES_PERS " +
						"AND SA.SALES_PERS = ? and SA.EVENT_DATE = ? AND SA.ACTIVITY_CODE <> 'PR'";
			}
			
			PreparedStatement pstmtAct = null;
			pstmtAct = conn.prepareStatement(activitySql);
			pstmtAct.setString(1, salesPers);
			pstmtAct.setTimestamp( 2, java.sql.Timestamp.valueOf( eventDateDBFmt ) );
			ResultSet rsAct = pstmtAct.executeQuery();
			if(rsAct.next())
			{
				dcrID = checkNull(rsAct.getString("DCR_ID"));
				custDcrId=dcrID;
				placeRequired= checkNull(rsAct.getString("PLACE_REQUIRED"));
				subDispDate= checkNull(rsAct.getString("SUBMISSION_DATE"));
				
				valueXmlString.append( "<Detail1 domID='"+domID+"' selected = 'Y'>\r\n" );
				if(subDispDate!=null && subDispDate.trim().length()>0)
				{
					valueXmlString.append( "<submit_show_date><![CDATA[" ).append(subDispDate).append( "]]></submit_show_date>\r\n" );//Added by Mrunalini Sinkar
				}
				else
				{
					String drDispDate=checkNull(getSubmissionDate(salesPers,eventDateDBFmt,conn));
					valueXmlString.append( "<submit_show_date><![CDATA[" ).append(drDispDate).append( "]]></submit_show_date>\r\n" );//Added by Mrunalini Sinkar
				}
				valueXmlString.append( "<event_date><![CDATA[" ).append(eventDate).append( "]]></event_date>\r\n");					
				valueXmlString.append( "<activity_descr><![CDATA[" ).append( checkNull(rsAct.getString("ACTIVITY_DESCR")).trim()).append( "]]></activity_descr>\r\n");							
				valueXmlString.append( "<sales_pers_sp_name><![CDATA[" ).append( checkNull(rsAct.getString("SP_NAME")).trim()).append( "]]></sales_pers_sp_name>\r\n");							
				valueXmlString.append( "<sprs_route_descr><![CDATA[" ).append( checkNull(stanCodeFrom).trim()).append( "]]></sprs_route_descr>\r\n");
				valueXmlString.append( "<last_dcr_date><![CDATA[" ).append(lastDcrDate).append( "]]></last_dcr_date>\r\n");	
				valueXmlString.append( "<activity_type><![CDATA[" ).append( checkNull(rsAct.getString("ACTIVITY_TYPE")).trim()).append( "]]></activity_type>\r\n"); // added by Mrunalini sinkar on 27/06/18 for showing Activity type
				valueXmlString.append( "<remark><![CDATA[" ).append( checkNull(rsAct.getString("REMARK")).trim()).append( "]]></remark>\r\n"); // added by rupali on 10/11/17 for showing remark on confirm and delete report
				valueXmlString.append( "<is_mgr><![CDATA[" ).append(mgrCode).append( "]]></is_mgr>\r\n");//added by Mrunalini Sinkar on 29/01/18 for adding the is_confirm_req condition
				valueXmlString.append( "<place_required><![CDATA[" ).append(checkNull(rsAct.getString("PLACE_REQUIRED"))).append( "]]></place_required>\r\n");
				//added by mrunalini sinkar for redesing xsl
				valueXmlString.append("<host_url><![CDATA[" ).append(CommonConstants.TOMCAT_HOME).append( "]]></host_url>\r\n" );
				valueXmlString.append("<sales_pers><![CDATA[" ).append( checkNull(rsAct.getString("SALES_PERS")).trim()).append( "]]></sales_pers>\r\n");							
				valueXmlString.append("<activity_code><![CDATA[" ).append( checkNull(rsAct.getString("ACTIVITY_CODE")).trim()).append( "]]></activity_code>\r\n");							
				valueXmlString.append( "<stan_code__hq><![CDATA[" ).append(stanCodeHQ).append( "]]></stan_code__hq>\r\n" );//Added by mrunalini sinkar to showing headquarter in summary page
				valueXmlString.append( "<headquarter><![CDATA[" ).append(headQaurter).append( "]]></headquarter>\r\n" );//Added by mrunalini sinkar to showing headquarter in summary page
				valueXmlString.append( "<confirmed><![CDATA[" ).append(checkNull(rsAct.getString("CONFIRMED"))).append( "]]></confirmed>\r\n");
				valueXmlString.append( "<conf_date><![CDATA[" ).append(checkNull(rsAct.getString("CONF_DATE"))).append( "]]></conf_date>\r\n");
				//Added by Bhagyashri T for details showing on summary
				valueXmlString.append( "<load_no><![CDATA[" ).append(loadNo).append( "]]></load_no>\r\n" );
				valueXmlString.append( "<vehicle_no><![CDATA[" ).append(vehicleNo).append( "]]></vehicle_no>\r\n" );
				valueXmlString.append( "</Detail1>\r\n" );
			}
			rsAct.close();
			rsAct = null;
			pstmtAct.close();
			pstmtAct = null;
			
			String actTypeNew = "";
			//commented & added by mrunalini sinkar fro showing the locality_code from and locality_code to as per the route ID on 25-04-2019(start)
			//added by mrunalini sinkar on 27-june-2018 to shown locality_code & locality_code_from on confirm delete report(starstartt)
			//String locSql = "SELECT LO.DESCR LOCALITY, ST.ORDER_OF_VISIT ORDEROFVISIT FROM SPRS_TRAVEL ST,LOCALITY LO WHERE ST.LOCALITY_CODE = LO.LOCALITY_CODE AND DCR_ID = ?";
			/*String locSql = "SELECT LO.DESCR LOCALITY,LOFRM.DESCR AS LOCALITY_FROM, ST.ORDER_OF_VISIT ORDEROFVISIT FROM SPRS_TRAVEL ST,LOCALITY LO ,LOCALITY LOFRM WHERE ST.LOCALITY_CODE = LO.LOCALITY_CODE AND ST.LOCALITY_CODE_FROM=LOFRM.LOCALITY_CODE AND DCR_ID = ? ORDER BY ST.ORDER_OF_VISIT ";
			//added by mrunalini sinkar on 27-june-2018 to shown locality_code & locality_code_from on confirm delete report(end)
			PreparedStatement pstmtLoc = null;
			pstmtLoc = conn.prepareStatement(locSql);
			pstmtLoc.setString(1, dcrID);
			ResultSet rsLoc = pstmtLoc.executeQuery();
			while(rsLoc.next())
			{
				//dcrID = checkNull(rsAct.getString("DCR_ID"));
				valueXmlString.append( "<Detail2 domID='"+domID+"' selected = 'Y'>\r\n" );
				valueXmlString.append( "<sprs_route_descr><![CDATA[" ).append( checkNull(rsLoc.getString("LOCALITY"))).append( "]]></sprs_route_descr>\r\n");
				valueXmlString.append( "<sprs_route_frm_descr><![CDATA[" ).append( checkNull(rsLoc.getString("LOCALITY_FROM"))).append( "]]></sprs_route_frm_descr>\r\n");	// added by Mrunalini sinkar on 27/06/18 for showing locality From
				valueXmlString.append( "<order_of_visit><![CDATA[" ).append( checkNull(rsLoc.getString("ORDEROFVISIT"))).append( "]]></order_of_visit>\r\n");	
				valueXmlString.append( "</Detail2>\r\n" );
			}
			rsLoc.close();
			rsLoc = null;
			pstmtLoc.close();
			pstmtLoc = null;*/
			
			String isFortune  = checkNull(getSfaParmValue(salesPers,"IS_FORTUNE_ACTIVITY",conn));
			// Added by Hariom S for Activity form changes in fortune server --18-May-2021 [Start]
			String activityCode = "";
			String activityDesc = "";
			String timeFrom = "";
			String TimeTo = "";
			if("Y".equalsIgnoreCase(isFortune))
			{
			String activityDataSql = "SELECT A.ACTIVITY_CODE AS ACTIVITY_CODE, A.DESCR AS DESCR,A.ACTIVITY_TYPE AS ACTIVITY_TYPE ,B.VISIT_TIME_FR AS VISIT_TIME_FR, B.VISIT_TIME_TO AS VISIT_TIME_TO , B.REMARK AS REMARK , B.dcr_id as dcr_id ,B.sales_pers as  sales_pers , B.event_date as event_date " +
					"FROM FIELDACTIVITY A, SPRS_ACTIVITY B, SALES_PERS S " +
					"WHERE A.ACTIVITY_CODE = B.ACTIVITY_CODE AND S.SALES_PERS = B.SALES_PERS  " +
					"AND B.SALES_PERS= ? " +
					"AND B.event_date= ? AND A.STATUS = 'Y' ORDER BY A.DESCR";
			
			PreparedStatement pstmtActivity =  conn.prepareStatement(activityDataSql);
			 
			pstmtActivity.setString(1, salesPers);
			pstmtActivity.setTimestamp( 2, java.sql.Timestamp.valueOf( eventDateDBFmt ) );
				
			ResultSet rsActivity= pstmtActivity.executeQuery();
			
			while(rsActivity.next())
			{
				activityCode =checkNull(rsActivity.getString("ACTIVITY_CODE"));
				activityDesc =checkNull(rsActivity.getString("DESCR"));
				timeFrom =checkNull(rsActivity.getString("VISIT_TIME_FR"));
				TimeTo =checkNull(rsActivity.getString("VISIT_TIME_TO"));
				
				
				valueXmlString.append("<ActivityData domID='"+domID+"' selected = 'Y'>\r\n" );
				valueXmlString.append("<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\"/>\r\n");
				valueXmlString.append("<activity_code><![CDATA[" ).append(activityCode ).append( "]]></activity_code>\r\n");
				valueXmlString.append("<activity_descr><![CDATA[" ).append(activityDesc ).append( "]]></activity_descr>\r\n");
				valueXmlString.append("<visit_time_fr><![CDATA[" ).append(timeFrom ).append( "]]></visit_time_fr>\r\n");
				valueXmlString.append("<visit_time_to><![CDATA[" ).append(TimeTo ).append( "]]></visit_time_to>\r\n");
				valueXmlString.append("</ActivityData>\r\n" );
				
			}
	
			if (rsActivity!= null)
			{
				rsActivity.close();
				rsActivity = null;
			}
			if(pstmtActivity!=null)
			{
				pstmtActivity.close();
				pstmtActivity = null;
			}
			}
			// Added by Harion S for Activity form changes in fortune server --18-May-2021 [End]
			if("Y".equalsIgnoreCase(placeRequired))
			{
				if(mgrCode.trim().length()!= 0)
				{

					if("Y".equalsIgnoreCase(oldData) && newCnt==0)
					{
						
						String mgrTravelDet="SELECT DR.FROM_ROUTE_DESCR,DR.WRK_ROUTE_DESCR,DR.SALES_PERS_MGR,SP.SP_NAME,A.DESCR AS WORK_STAN_DESCR,B.DESCR FROM_STAN_DESCR,TMM.TRAVEL_MODE_DESCR,DR.LINE_NO FROM  " + 
								"DR_TRAVEL_DETAILS DR LEFT OUTER JOIN TRAVEL_MODE_MASTER TMM ON DR.TRAVEL_MODE_ID=TMM.TRAVEL_MODE_ID,SALES_PERS SP,STATION A,STATION B WHERE DR.SALES_PERS=? AND DR.WORK_DATE=? AND DR.SALES_PERS_MGR=SP.SALES_PERS AND DR.FROM_STAN_CODE=B.STAN_CODE " + 
								"AND DR.WORK_STAN_CODE=A.STAN_CODE ORDER BY DR.LINE_NO";
						PreparedStatement pstmtMgrTrvl=conn.prepareStatement(mgrTravelDet);;
						pstmtMgrTrvl.setString(1, salesPers);
						pstmtMgrTrvl.setTimestamp( 2, java.sql.Timestamp.valueOf( eventDateDBFmt ) );
						ResultSet rsMgrTrvl = pstmtMgrTrvl.executeQuery();
						while(rsMgrTrvl.next())
						{
							valueXmlString.append( "<Detail2 domID='"+domID+"' selected = 'Y'>\r\n" );
							valueXmlString.append( "<sprs_route_descr><![CDATA[" ).append( checkNull(rsMgrTrvl.getString("WRK_ROUTE_DESCR"))).append( "]]></sprs_route_descr>\r\n");
							valueXmlString.append( "<sprs_route_frm_descr><![CDATA[" ).append( checkNull(rsMgrTrvl.getString("FROM_ROUTE_DESCR"))).append( "]]></sprs_route_frm_descr>\r\n");	// added by Mrunalini sinkar on 27/06/18 for showing locality From
							valueXmlString.append( "<order_of_visit><![CDATA[" ).append(checkNull(rsMgrTrvl.getString("LINE_NO"))).append( "]]></order_of_visit>\r\n");	
							valueXmlString.append( "<station_frm_descr><![CDATA[" ).append( checkNull(rsMgrTrvl.getString("FROM_STAN_DESCR"))).append( "]]></station_frm_descr>\r\n");
							valueXmlString.append( "<station_to_descr><![CDATA[" ).append( checkNull(rsMgrTrvl.getString("TRAVEL_MODE_DESCR"))).append( "]]></station_to_descr>\r\n");	
							valueXmlString.append( "<travel_mode><![CDATA[" ).append( checkNull(rsMgrTrvl.getString("TRAVEL_MODE_DESCR"))).append( "]]></travel_mode>\r\n");
							valueXmlString.append( "<sprs_ww__name><![CDATA[" ).append( checkNull(rsMgrTrvl.getString("SP_NAME"))).append( "]]></sprs_ww__name>\r\n");	
							valueXmlString.append( "</Detail2>\r\n" );
						}
						rsMgrTrvl.close();
						rsMgrTrvl = null;
						pstmtMgrTrvl.close();
						pstmtMgrTrvl = null;
					}
					else
					{

						PreparedStatement pstmtMgrTrvl=null;
						ResultSet rsMgrTrvl=null;
						String locFromDescr="";
						String maxTravelSql="SELECT ROUTE_DESCR__START FROM SPRS_ACT_TRAN  WHERE DCR_ID=?";
						pstmtMgrTrvl =conn.prepareStatement(maxTravelSql);
						pstmtMgrTrvl.setString(1, dcrID);
						rsMgrTrvl = pstmtMgrTrvl.executeQuery();
						if(rsMgrTrvl.next())
						{
							locFromDescr=checkNull(rsMgrTrvl.getString("ROUTE_DESCR__START"));
						}
						rsMgrTrvl.close();
						rsMgrTrvl = null;
						pstmtMgrTrvl.close();
						pstmtMgrTrvl = null;
						
						
						int minOrderOfVisit=0;
						String minOrderOfVisitSql="SELECT MIN(ORDER_OF_VISIT) AS ORDER_OF_VISIT FROM SPRS_TRAVEL  WHERE DCR_ID=?";
						pstmtMgrTrvl =conn.prepareStatement(minOrderOfVisitSql);
						pstmtMgrTrvl.setString(1, dcrID);
						rsMgrTrvl = pstmtMgrTrvl.executeQuery();
						if(rsMgrTrvl.next())
						{
							minOrderOfVisit=rsMgrTrvl.getInt("ORDER_OF_VISIT");
						}
						rsMgrTrvl.close();
						rsMgrTrvl = null;
						pstmtMgrTrvl.close();
						pstmtMgrTrvl = null;
						

						LinkedHashMap<String, String> travelMap=new LinkedHashMap<String, String>();
						String locToDescr="",orderOfVisit="",stationTo="",travelMode="",sprsCodeName="",stationFrm="";
						String firstVistData="SELECT (CASE WHEN ROUTETO.ROUTE_DESCR IS NOT NULL THEN ROUTETO.ROUTE_DESCR ELSE ROUTETO.DESCR END ) LOCALITY, "+
								 "STATIONTO.DESCR AS STATIONTO_DESCR,  " + 
								" ST.ORDER_OF_VISIT ORDEROFVISIT,TMM.TRAVEL_MODE_DESCR,SP.SP_NAME ||' (' ||TRIM(ROUTETO.SPRS_CODE)||')' AS SPRS_CODE__NAME "+
								"FROM SPRS_TRAVEL ST LEFT OUTER JOIN TRAVEL_MODE_MASTER TMM ON ST.TRAVEL_MODE=TMM.TRAVEL_MODE_ID,SPRS_ROUTE ROUTETO ,STATION STATIONTO, SALES_PERS SP " + 
								"  WHERE ST.ROUTE_ID = ROUTETO.ROUTE_ID AND ST.SPRS_CODE__WW=ROUTETO.SPRS_CODE " + 
								"  AND SP.SALES_PERS=ROUTETO.SPRS_CODE AND DCR_ID = ? AND ST.ORDER_OF_VISIT=? AND ROUTETO.STAN_CODE=STATIONTO.STAN_CODE  ORDER BY ST.ORDER_OF_VISIT " ; 

						pstmtMgrTrvl =conn.prepareStatement(firstVistData);
						
						pstmtMgrTrvl.setString(1, dcrID);
						pstmtMgrTrvl.setInt(2, minOrderOfVisit);

						
						rsMgrTrvl = pstmtMgrTrvl.executeQuery();
						if(rsMgrTrvl.next())
						{
							locToDescr=checkNull(rsMgrTrvl.getString("LOCALITY"));
							orderOfVisit=checkNull(rsMgrTrvl.getString("ORDEROFVISIT"));
							stationTo=checkNull(rsMgrTrvl.getString("STATIONTO_DESCR"));
							travelMode=checkNull(rsMgrTrvl.getString("TRAVEL_MODE_DESCR"));
							sprsCodeName=checkNull(rsMgrTrvl.getString("SPRS_CODE__NAME"));

							travelMap.put(orderOfVisit, locFromDescr+"@"+locToDescr+"@"+stationTo+'@'+stationTo+'@'+travelMode+'@'+sprsCodeName);
						}
						rsMgrTrvl.close();
						rsMgrTrvl = null;
						pstmtMgrTrvl.close();
						pstmtMgrTrvl = null;
						

						String anotherData="SELECT (CASE WHEN ROUTETO.ROUTE_DESCR IS NOT NULL THEN ROUTETO.ROUTE_DESCR ELSE ROUTETO.DESCR END ) LOCALITY,STATIONTO.DESCR AS STATIONTO_DESCR, " + 
								" (CASE WHEN ROUTEFROM.ROUTE_DESCR IS NOT NULL THEN ROUTEFROM.ROUTE_DESCR ELSE ROUTEFROM.DESCR END )LOCALITY_FROM,STATIONFROM.DESCR AS STATIONFROM_DESCR, " + 
								" ST.ORDER_OF_VISIT ORDEROFVISIT,TMM.TRAVEL_MODE_DESCR,SP.SP_NAME ||' (' ||TRIM(ROUTETO.SPRS_CODE)||')' AS SPRS_CODE__NAME  FROM SPRS_TRAVEL ST LEFT OUTER JOIN TRAVEL_MODE_MASTER TMM ON ST.TRAVEL_MODE=TMM.TRAVEL_MODE_ID,SPRS_ROUTE ROUTETO ,SPRS_ROUTE ROUTEFROM ,STATION STATIONTO, STATION STATIONFROM,SALES_PERS SP WHERE ST.ROUTE_ID   = ROUTETO.ROUTE_ID " + 
								" AND ST.ROUTE_ID_FROM=ROUTEFROM.ROUTE_ID AND ST.SPRS_CODE__WW=ROUTETO.SPRS_CODE " + 
								" AND ROUTEFROM.SPRS_CODE = " + 
								" (SELECT SPRS_CODE__WW FROM SPRS_TRAVEL WHERE DCR_ID=? AND " + 
								" ORDER_OF_VISIT= (SELECT MAX(ORDER_OF_VISIT) FROM SPRS_TRAVEL WHERE DCR_ID = ? AND ORDER_OF_VISIT<ST.ORDER_OF_VISIT ))  " + 
								" AND SP.SALES_PERS=ROUTETO.SPRS_CODE AND DCR_ID = ? and  ST.ORDER_OF_VISIT<>?  AND ROUTETO.STAN_CODE=STATIONTO.STAN_CODE AND ROUTEFROM.STAN_CODE=STATIONFROM.STAN_CODE ORDER BY ST.ORDER_OF_VISIT ";
								
						pstmtMgrTrvl =conn.prepareStatement(anotherData);
						
						pstmtMgrTrvl.setString(1, dcrID);
						pstmtMgrTrvl.setString(2, dcrID);
						pstmtMgrTrvl.setString(3, dcrID);
						pstmtMgrTrvl.setInt(4, minOrderOfVisit);
						rsMgrTrvl = pstmtMgrTrvl.executeQuery();
						while(rsMgrTrvl.next())
						{
							locToDescr=checkNull(rsMgrTrvl.getString("LOCALITY"));
							locFromDescr=checkNull(rsMgrTrvl.getString("LOCALITY_FROM"));
							orderOfVisit=checkNull(rsMgrTrvl.getString("ORDEROFVISIT"));
							stationFrm=checkNull(rsMgrTrvl.getString("STATIONFROM_DESCR"));
							stationTo=checkNull(rsMgrTrvl.getString("STATIONTO_DESCR"));
							travelMode=checkNull(rsMgrTrvl.getString("TRAVEL_MODE_DESCR"));
							sprsCodeName=checkNull(rsMgrTrvl.getString("SPRS_CODE__NAME"));


							travelMap.put(orderOfVisit, locFromDescr+"@"+locToDescr+"@"+stationFrm+'@'+stationTo+'@'+travelMode+'@'+sprsCodeName);
						}
						rsMgrTrvl.close();
						rsMgrTrvl = null;
						pstmtMgrTrvl.close();
						pstmtMgrTrvl = null;
						
						  if(!travelMap.isEmpty())
			              {				

			            	  for (Entry<String, String> entry: travelMap.entrySet())
			            	  {
									String orderofVisit= entry.getKey();
									String value = entry.getValue();
									String locArray[]=value.split("@");
									System.out.println("travelMap["+travelMap+"]");
									String localityFrom =checkNull(locArray[0]);
									String localityTo =checkNull(locArray[1]);
									String stationFrmDescr =checkNull(locArray[2]);
									String stationToDescr =checkNull(locArray[3]);
									String travelModeDescr =checkNull(locArray[4]);

									String sprsCodeWWNAme =checkNull(locArray[5]);


									valueXmlString.append( "<Detail2 domID='"+domID+"' selected = 'Y'>\r\n" );
									valueXmlString.append( "<sprs_route_descr><![CDATA[" ).append( checkNull(localityTo)).append( "]]></sprs_route_descr>\r\n");
									valueXmlString.append( "<sprs_route_frm_descr><![CDATA[" ).append( checkNull(localityFrom)).append( "]]></sprs_route_frm_descr>\r\n");	// added by Mrunalini sinkar on 27/06/18 for showing locality From
									valueXmlString.append( "<order_of_visit><![CDATA[" ).append(checkNull(orderofVisit)).append( "]]></order_of_visit>\r\n");	
									valueXmlString.append( "<station_frm_descr><![CDATA[" ).append( checkNull(stationFrmDescr)).append( "]]></station_frm_descr>\r\n");
									valueXmlString.append( "<station_to_descr><![CDATA[" ).append( checkNull(stationToDescr)).append( "]]></station_to_descr>\r\n");	
									valueXmlString.append( "<travel_mode><![CDATA[" ).append( checkNull(travelModeDescr)).append( "]]></travel_mode>\r\n");
									valueXmlString.append( "<sprs_ww__name><![CDATA[" ).append( checkNull(sprsCodeWWNAme)).append( "]]></sprs_ww__name>\r\n");	

									valueXmlString.append( "</Detail2>\r\n" );

			            	  }
			              }
					
					}
					
				}
				else
				{
					String locSql="";
					PreparedStatement pstmtLoc = null;

					if("Y".equalsIgnoreCase(oldData) && newCnt==0)
					{
						locSql="SELECT DR.FROM_ROUTE_DESCR LOCALITY_FROM ,DR.WRK_ROUTE_DESCR LOCALITY,A.DESCR AS STATIONTO_DESCR,B.DESCR STATIONFROM_DESCR,TMM.TRAVEL_MODE_DESCR TRAVEL_MODE_DESCR,DR.LINE_NO ORDEROFVISIT FROM  " + 
								" DR_TRAVEL_DETAILS DR LEFT OUTER JOIN TRAVEL_MODE_MASTER TMM ON DR.TRAVEL_MODE_ID=TMM.TRAVEL_MODE_ID,STATION A,STATION B WHERE DR.SALES_PERS=? AND DR.WORK_DATE=? AND  DR.FROM_STAN_CODE=B.STAN_CODE " + 
								" AND DR.WORK_STAN_CODE=A.STAN_CODE  ORDER BY DR.LINE_NO";
						pstmtLoc = conn.prepareStatement(locSql);
						pstmtLoc.setString(1, salesPers);
						pstmtLoc.setTimestamp( 2, java.sql.Timestamp.valueOf( eventDateDBFmt ) );
					}
					else
					{
						locSql = "SELECT (CASE WHEN ROUTETO.ROUTE_DESCR IS NOT NULL THEN ROUTETO.ROUTE_DESCR ELSE ROUTETO.DESCR END ) LOCALITY,STATIONTO.DESCR AS STATIONTO_DESCR, " + 
								" (CASE WHEN ROUTEFROM.ROUTE_DESCR IS NOT NULL THEN ROUTEFROM.ROUTE_DESCR ELSE ROUTEFROM.DESCR END )LOCALITY_FROM,STATIONFROM.DESCR AS STATIONFROM_DESCR, " + 
								" ST.ORDER_OF_VISIT ORDEROFVISIT,TMM.TRAVEL_MODE_DESCR FROM SPRS_TRAVEL ST LEFT OUTER JOIN TRAVEL_MODE_MASTER TMM ON ST.TRAVEL_MODE=TMM.TRAVEL_MODE_ID ,SPRS_ROUTE ROUTETO ,SPRS_ROUTE ROUTEFROM,STATION STATIONTO,STATION STATIONFROM  WHERE ST.ROUTE_ID   = ROUTETO.ROUTE_ID " + 
						" AND ST.ROUTE_ID_FROM=ROUTEFROM.ROUTE_ID AND ST.SALES_PERS=ROUTETO.SPRS_CODE AND ST.SALES_PERS=ROUTEFROM.SPRS_CODE AND ROUTETO.STAN_CODE=STATIONTO.STAN_CODE AND ROUTEFROM.STAN_CODE=STATIONFROM.STAN_CODE " + 
						"AND DCR_ID = ? ORDER BY ST.ORDER_OF_VISIT " ;
						pstmtLoc = conn.prepareStatement(locSql);
						pstmtLoc.setString(1, dcrID);
							
					}

					ResultSet rsLoc = pstmtLoc.executeQuery();
					while(rsLoc.next())
					{
						//dcrID = checkNull(rsAct.getString("DCR_ID"));
						valueXmlString.append( "<Detail2 domID='"+domID+"' selected = 'Y'>\r\n" );
						valueXmlString.append( "<sprs_route_descr><![CDATA[" ).append( checkNull(rsLoc.getString("LOCALITY"))).append( "]]></sprs_route_descr>\r\n");
						valueXmlString.append( "<sprs_route_frm_descr><![CDATA[" ).append( checkNull(rsLoc.getString("LOCALITY_FROM"))).append( "]]></sprs_route_frm_descr>\r\n");	// added by Mrunalini sinkar on 27/06/18 for showing locality From
						valueXmlString.append( "<order_of_visit><![CDATA[" ).append( checkNull(rsLoc.getString("ORDEROFVISIT"))).append( "]]></order_of_visit>\r\n");	
						valueXmlString.append( "<station_frm_descr><![CDATA[" ).append( checkNull(rsLoc.getString("STATIONFROM_DESCR"))).append( "]]></station_frm_descr>\r\n");
						valueXmlString.append( "<station_to_descr><![CDATA[" ).append( checkNull(rsLoc.getString("STATIONTO_DESCR"))).append( "]]></station_to_descr>\r\n");	
						valueXmlString.append( "<travel_mode><![CDATA[" ).append( checkNull(rsLoc.getString("TRAVEL_MODE_DESCR"))).append( "]]></travel_mode>\r\n");	

						valueXmlString.append( "</Detail2>\r\n" );
					}
					rsLoc.close();
					rsLoc = null;
					pstmtLoc.close();
					pstmtLoc = null;
				
				}
			}
			
			//added by mrunalini sinkar on 27-june-2018 to shown locality_code & locality_code_from on confirm delete report(end)
			//commented & added by mrunalini sinkar fro showing the locality_code from and locality_code to as per the route ID on 25-04-2019(end)

			/*String sqlEdit  ="SELECT STRG_MEET.*,LOCALITY.DESCR LOC_DESCR,FIELDACTIVITY.ACTIVITY_TYPE ACT_TYPE,"+    
				 	" UPPER(STRG_CUSTOMER.FIRST_NAME)||' '||UPPER(STRG_CUSTOMER.LAST_NAME) AS SC_NAME,"+ 
					" STRG_CUSTOMER.ADDR1,STRG_CUSTOMER.ADDR2,STRG_CUSTOMER.ADDR3, STRG_MEET.STRG_TYPE AS CUST_TYPE, "+ 
					" (CASE WHEN STRG_MEET.STRG_TYPE = 'D' THEN 1  WHEN STRG_MEET.STRG_TYPE='R' THEN 2  WHEN STRG_MEET.STRG_TYPE='M' THEN 3 ELSE 4 END) AS CUST_TYPE_SEQ "+
					" FROM FIELDACTIVITY,STRG_MEET LEFT OUTER JOIN STRG_CUSTOMER ON STRG_MEET.STRG_CODE = STRG_CUSTOMER.SC_CODE "+
					" LEFT OUTER JOIN LOCALITY ON STRG_MEET.LOCALITY_CODE = LOCALITY.LOCALITY_CODE " +
					" LEFT OUTER JOIN SPRS_ACT_TRAN ON STRG_MEET.DCR_ID = SPRS_ACT_TRAN.DCR_ID  "+
					" WHERE STRG_MEET.EVENT_TYPE =FIELDACTIVITY.ACTIVITY_CODE"+
					" AND STRG_MEET.SALES_PERS = ? "+
					" AND STRG_MEET.EVENT_DATE = ? "+
					" AND STRG_CUSTOMER.CUST_TYPE  IN ('C','D','S','O') " + 
					" AND (CASE WHEN SPRS_ACT_TRAN.CONFIRMED IS NULL THEN 'N' ELSE SPRS_ACT_TRAN.CONFIRMED END) ='N' "+
					" ORDER BY CUST_TYPE_SEQ, STRG_MEET.SHORT_ID ";*/
			String stockistTable = getSfaParmValue(salesPers,"GET_STOCKIST_DETAILS",conn);
			String isMemberPresnt = checkNull(getSfaParmValue(salesPers,"HIDE_UNLIST_DET",conn));
			String divison = checkNull(getItemSer(salesPers, conn));
			DARCommonBean darCommonBean= new DARCommonBean();
			HashMap<String, String> employeeDesignationMap=darCommonBean.getEmployeeDesignationMap(divison,conn);
			System.out.println("employeeDesignationMap is["+employeeDesignationMap+"]");
			
			String sqlEdit = "";
			String dcrId = "";
			ResultSet rs=null;

			
			boolean leaveFlg=false;
			if("Y".equalsIgnoreCase(oldData) && newCnt==0)
			{
				String docSqlEdit="SELECT DDV.SC_CODE,UPPER(SC.FIRST_NAME)||' '||UPPER(SC.LAST_NAME) AS SC_NAME ,DDV.SC_TYPE AS CUST_TYPE,DDV.REMARK AS REMARKS,SC.CLASS_CODE,DDV.DOCTOR_VISIT_TIME,DDV.DR_LAST_VISIT_TIME, " + 
						"DDV.DOCTOR_POB,'LISTED' AS CUSTOMER_TYPE,DDV.SALES_PERS_MGR,L.DESCR LOC_DESCR ,SP.ITEM_SER,SS.NO_VISIT,DDV.NOOF_DOCT, " + 
						"(SELECT EMP_FNAME||' '||EMP_LNAME||'(PSR),' FROM EMPLOYEE WHERE EMP_CODE = DDV.SALES_PERS_MGR) AS VISITED_WITH_PSR_NAME,  " + 
						"(SELECT EMP_FNAME||' '||EMP_LNAME||'(FSM),' FROM EMPLOYEE WHERE EMP_CODE = DDV.VISITED_WITH_FSM) AS VISITED_WITH_FSM,   " + 
						"(SELECT EMP_FNAME||' '||EMP_LNAME||'(RSM),' FROM EMPLOYEE WHERE EMP_CODE = DDV.VISITED_WITH_RSM) AS VISITED_WITH_RSM,  " + 
						"(SELECT EMP_FNAME||' '||EMP_LNAME||'(SM)' FROM EMPLOYEE WHERE EMP_CODE = DDV.VISITED_WITH_SM) AS VISITED_WITH_SM,SS.SPL_CODE " + 
						"FROM DR_DOCTOR_VISIT DDV ,STRG_CUSTOMER SC ,LOCALITY L,SALES_PERS SP,STRG_SERIES SS " + 
						"WHERE DDV.SALES_PERS=? AND DDV.WORK_DATE=? AND SC.SC_CODE=DDV.SC_CODE AND L.LOCALITY_CODE=DDV.WORK_LOCALITY_CODE AND SP.SALES_PERS=DDV.SALES_PERS_MGR " + 
						"AND SS.SC_CODE=DDV.SC_CODE AND SS.SC_CODE=SC.SC_CODE AND SS.SALES_PERS=SP.SALES_PERS " + 
						"UNION " + 
						"SELECT DDV.SC_CODE,'UNLISTED DOCTOR MET' AS SC_NAME ,DDV.SC_TYPE AS CUST_TYPE,DDV.REMARK AS REMARKS,'' CLASS_CODE,DDV.DOCTOR_VISIT_TIME,DDV.DR_LAST_VISIT_TIME," + 
						"DDV.DOCTOR_POB,'UNLISTED' AS CUSTOMER_TYPE,DDV.SALES_PERS_MGR,L.DESCR LOC_DESCR,'' ITEM_SER,0 AS NO_VISIT,DDV.NOOF_DOCT, " + 
						"(SELECT EMP_FNAME||' '||EMP_LNAME||'(PSR),' FROM EMPLOYEE WHERE EMP_CODE = DDV.SALES_PERS_MGR) AS VISITED_WITH_PSR_NAME,  " + 
						"(SELECT EMP_FNAME||' '||EMP_LNAME||'(FSM),' FROM EMPLOYEE WHERE EMP_CODE = DDV.VISITED_WITH_FSM) AS VISITED_WITH_FSM,   " + 
						"(SELECT EMP_FNAME||' '||EMP_LNAME||'(RSM),' FROM EMPLOYEE WHERE EMP_CODE = DDV.VISITED_WITH_RSM) AS VISITED_WITH_RSM, " + 
						"(SELECT EMP_FNAME||' '||EMP_LNAME||'(SM)' FROM EMPLOYEE WHERE EMP_CODE = DDV.VISITED_WITH_SM) AS VISITED_WITH_SM,'' SPL_CODE " + 
						"FROM DR_DOCTOR_VISIT DDV  ,LOCALITY L " + 
						"WHERE DDV.SALES_PERS=? AND DDV.WORK_DATE=? AND L.LOCALITY_CODE=DDV.WORK_LOCALITY_CODE AND DDV.SC_CODE='0000000000'";
				pstmt=conn.prepareStatement(docSqlEdit);
				pstmt.setString(1, salesPers);
				pstmt.setTimestamp( 2, java.sql.Timestamp.valueOf( eventDateDBFmt ) );
				pstmt.setString(3, salesPers);
				pstmt.setTimestamp( 4, java.sql.Timestamp.valueOf( eventDateDBFmt ) );
				rs = pstmt.executeQuery();
				while (rs.next())
				{
					String teamDetails="";
					String strgCode =checkNull(rs.getString("SC_CODE"));
					String splCode=checkNull(rs.getString("SPL_CODE"));
					String classCode=checkNull(rs.getString("CLASS_CODE"));
					String itemSer=checkNull(rs.getString("ITEM_SER"));
					String psrData=checkNull(rs.getString("VISITED_WITH_PSR_NAME"));
					String fsmData=checkNull(rs.getString("VISITED_WITH_FSM"));
					String rsmData=checkNull(rs.getString("VISITED_WITH_RSM"));
					String smData=checkNull(rs.getString("VISITED_WITH_SM"));

					if(mgrCode.trim().length()!=0)
					{
						teamDetails=psrData+fsmData+rsmData+smData;
					}
					else
					{
						teamDetails=fsmData+rsmData+smData;
					}
					


					valueXmlString.append( "<doctor domID='"+domID+"' selected = 'Y'>\r\n" );
					valueXmlString.append( "<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\"/>\r\n");
					valueXmlString.append( "<strg_code><![CDATA[" ).append( checkNull(rs.getString("SC_CODE")).trim()).append( "]]></strg_code>\r\n");							
					valueXmlString.append( "<cust_name><![CDATA[" ).append( checkNull(rs.getString("SC_NAME"))).append( "]]></cust_name>\r\n");
					valueXmlString.append( "<sales_pers><![CDATA[" ).append(checkNull(salesPers)).append( "]]></sales_pers>\r\n" );
					valueXmlString.append( "<event_date><![CDATA[" ).append(eventDate).append( "]]></event_date>\r\n" );				
					valueXmlString.append( "<cust_type><![CDATA[" ).append("D").append( "]]></cust_type>\r\n");							
					valueXmlString.append( "<remarks><![CDATA[" ).append(checkNull(rs.getString("REMARKS"))).append( "]]></remarks>\r\n" );

					valueXmlString.append( "<strg_class_code><![CDATA[" ).append(checkNull(rs.getString("CLASS_CODE"))).append( "]]></strg_class_code>\r\n" );
					//Added by kailsh on 23-feb-18 [End]
					//Added by mrunalini to showing speciality no_visit on summary page(start)
					valueXmlString.append( "<event_time_start><![CDATA[" ).append(checkNull(rs.getString("DOCTOR_VISIT_TIME"))).append( "]]></event_time_start>\r\n" );
					valueXmlString.append( "<event_time_end><![CDATA[" ).append(checkNull(rs.getString("DR_LAST_VISIT_TIME"))).append( "]]></event_time_end>\r\n" );
					valueXmlString.append( "<pob_val><![CDATA[" ).append(checkNull(rs.getString("DOCTOR_POB"))).append( "]]></pob_val>\r\n" );
					valueXmlString.append( "<customer_type><![CDATA[" ).append(checkNull(rs.getString("CUSTOMER_TYPE"))).append( "]]></customer_type>\r\n" );
					if(!"0000000000".equalsIgnoreCase(strgCode))
					{
						String splDescr="";
						String splSql="SELECT DESCR AS SPECIALITY FROM SPECIALITY WHERE SPL_CODE = ?";
						PreparedStatement splPstmt=conn.prepareStatement(splSql);
						splPstmt.setString(1, splCode);

						ResultSet splRS=splPstmt.executeQuery();
						if(splRS.next())
						{
							splDescr=checkNull(splRS.getString("SPECIALITY"));
						}
						splRS.close();
						splRS = null;
						splPstmt.close();
						splPstmt = null;
						
						String classDescr="";
						String classSql="SELECT DESCR AS CLASS_CODE_DESCR FROM STRG_SER_CLASS WHERE CLASS_CODE = ? AND ITEM_SER=?";
						PreparedStatement classPstmt=conn.prepareStatement(classSql);
						classPstmt.setString(1, classCode);
						classPstmt.setString(2, itemSer);
						ResultSet classRS=classPstmt.executeQuery();
						if(classRS.next())
						{
							classDescr=checkNull(classRS.getString("CLASS_CODE_DESCR"));
						}
						classRS.close();
						classRS = null;
						classPstmt.close();
						classPstmt = null;

						valueXmlString.append("<class_code_descr><![CDATA[" ).append(classDescr).append( "]]></class_code_descr>\r\n" );
						valueXmlString.append("<spl_descr><![CDATA[" ).append(splDescr).append( "]]></spl_descr>\r\n" );
						valueXmlString.append("<no_visit><![CDATA[" ).append(checkNull(rs.getString("NO_VISIT"))).append( "]]></no_visit>\r\n" );

					}
					valueXmlString.append("<locality_descr><![CDATA[" ).append( checkNull(rs.getString("LOC_DESCR")).trim()).append( "]]></locality_descr>\r\n");
					valueXmlString.append("<team_details><![CDATA[" ).append( teamDetails ).append( "]]></team_details>\r\n" );
					//Added by Pooja S. on [30-DEC-2019] to show the coaching details  Start
					valueXmlString.append("<host_url><![CDATA[" ).append(CommonConstants.TOMCAT_HOME).append( "]]></host_url>\r\n" );
					valueXmlString.append( "<member_present><![CDATA[" ).append(checkNull(rs.getString("NOOF_DOCT"))).append( "]]></member_present>\r\n" );

					valueXmlString.append("<collection_form_no><![CDATA[" ).append("collection").append( "]]></collection_form_no>\r\n" );
					valueXmlString.append("<item_form_no><![CDATA[" ).append("doctorsampleitem").append( "]]></item_form_no>\r\n" );
					valueXmlString.append("<brand_form_no><![CDATA[" ).append("brand").append( "]]></brand_form_no>\r\n" );
					valueXmlString.append("<display_form_no><![CDATA[" ).append("display").append( "]]></display_form_no>\r\n" );
					valueXmlString.append("<survey_form_no><![CDATA[" ).append("survey").append( "]]></survey_form_no>\r\n" );
					valueXmlString.append("<prescription_form_no><![CDATA[" ).append("surveybrand").append( "]]></prescription_form_no>\r\n" );
					valueXmlString.append( "</doctor>\r\n" );
					//Added by mrunalini to showing speciality no_visit on summary page(end)

					}

				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
					
				String chemSqlEdit="SELECT NOOF_CHEMIST,CHEMIST_NAME,CHEMIST_VISIT_TIME,CHEM_LAST_VISIT_TIME,ORDER_BOOKED, " + 
						" (SELECT EMP_FNAME||' '||EMP_LNAME||'(PSR),' FROM EMPLOYEE WHERE EMP_CODE = DCV.SALES_PERS_MGR) AS VISITED_WITH_PSR_NAME, " + 
						" (SELECT EMP_FNAME||' '||EMP_LNAME||'(FSM),' FROM EMPLOYEE WHERE EMP_CODE = DCV.VISITED_WITH_FSM) AS VISITED_WITH_FSM, " + 
						" (SELECT EMP_FNAME||' '||EMP_LNAME||'(RSM),' FROM EMPLOYEE WHERE EMP_CODE = DCV.VISITED_WITH_RSM) AS VISITED_WITH_RSM, "+
						"(SELECT EMP_FNAME||' '||EMP_LNAME||'(SM)' FROM EMPLOYEE WHERE EMP_CODE = DCV.VISITED_WITH_SM) AS VISITED_WITH_SM, " + 
						" DCV.REMARK, DCV.VISITED_WITH_OTHER_NAME,SR.DESCR LOC_DESCR FROM DR_CHEMIST_VISIT DCV ,SPRS_ROUTE SR " + 
						" WHERE WORK_DATE = ? AND SALES_PERS = ? AND DCV.WORK_ROUTE_ID=SR.ROUTE_ID AND DCV.SALES_PERS_MGR=SR.SPRS_CODE";	
				pstmt=conn.prepareStatement(chemSqlEdit);
				pstmt.setTimestamp( 1, java.sql.Timestamp.valueOf( eventDateDBFmt ) );
				pstmt.setString(2, salesPers);
				rs = pstmt.executeQuery();
				while (rs.next())
				{
					String psrData=checkNull(rs.getString("VISITED_WITH_PSR_NAME"));
					String fsmData=checkNull(rs.getString("VISITED_WITH_FSM"));
					String rsmData=checkNull(rs.getString("VISITED_WITH_RSM"));
					String smData=checkNull(rs.getString("VISITED_WITH_SM"));

					String teamDetails="";
					if(mgrCode.trim().length()!=0)
					{
						teamDetails=psrData+fsmData+rsmData+smData;
					}
					else
					{
						teamDetails=fsmData+rsmData+smData;
					}
					valueXmlString.append( "<retailer domID='"+domID+"' selected = 'Y'>\r\n" );
					valueXmlString.append( "<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\"/>\r\n");
					valueXmlString.append( "<strg_code><![CDATA[" ).append("UR00000000").append( "]]></strg_code>\r\n");							
					valueXmlString.append( "<cust_name><![CDATA[" ).append("No of Chemists").append( "]]></cust_name>\r\n");
					valueXmlString.append( "<sales_pers><![CDATA[" ).append(checkNull(salesPers)).append( "]]></sales_pers>\r\n" );
					valueXmlString.append( "<event_date><![CDATA[" ).append(eventDate).append( "]]></event_date>\r\n" );				
					valueXmlString.append( "<cust_type><![CDATA[" ).append("C").append( "]]></cust_type>\r\n" );				
					valueXmlString.append( "<locality_descr><![CDATA[" ).append( checkNull(rs.getString("LOC_DESCR")).trim()).append( "]]></locality_descr>\r\n");

					valueXmlString.append( "<sku_value><![CDATA[" ).append( checkNull(rs.getString("ORDER_BOOKED")).trim()).append( "]]></sku_value>\r\n");
					valueXmlString.append( "<event_time_start><![CDATA[" ).append(rs.getString("CHEMIST_VISIT_TIME")).append( "]]></event_time_start>\r\n" );
					valueXmlString.append( "<event_time_end><![CDATA[" ).append(rs.getString("CHEM_LAST_VISIT_TIME")).append( "]]></event_time_end>\r\n" );
					valueXmlString.append( "<pob_val><![CDATA[" ).append(checkNull(rs.getString("ORDER_BOOKED"))).append( "]]></pob_val>\r\n" );
					valueXmlString.append( "<customer_type><![CDATA[" ).append("UNLISTED").append( "]]></customer_type>\r\n" );
					valueXmlString.append( "<member_present><![CDATA[" ).append(checkNull(rs.getString("NOOF_CHEMIST"))).append( "]]></member_present>\r\n" );
					valueXmlString.append( "<remarks><![CDATA[" ).append(checkNull(rs.getString("REMARK"))).append( "]]></remarks>\r\n" );

					valueXmlString.append("<collection_form_no><![CDATA[" ).append("retailercollection").append( "]]></collection_form_no>\r\n" ); //27-12-2022
					valueXmlString.append("<item_form_no><![CDATA[" ).append("retailersampleitem").append( "]]></item_form_no>\r\n" );
					valueXmlString.append("<brand_form_no><![CDATA[" ).append("retailerbrand").append( "]]></brand_form_no>\r\n" );
					valueXmlString.append("<display_form_no><![CDATA[" ).append("retailerdisplay").append( "]]></display_form_no>\r\n" );
					valueXmlString.append("<survey_form_no><![CDATA[" ).append("retailersurvey").append( "]]></survey_form_no>\r\n" );
					valueXmlString.append( "<team_details><![CDATA[" ).append( teamDetails ).append( "]]></team_details>\r\n" );
					valueXmlString.append("<host_url><![CDATA[" ).append(CommonConstants.TOMCAT_HOME).append( "]]></host_url>\r\n" );
					valueXmlString.append( "</retailer>\r\n" );
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
				
				String stockEditSql="SELECT DDV.CUST_CODE AS SC_CODE,CUST.CUST_NAME AS SC_NAME ,DDV.REMARK AS REMARKS,DDV.STOCKIST_VISIT_TIME, " + 
						"DDV.ORDER_BOOKED,'LISTED' AS CUSTOMER_TYPE,DDV.SALES_PERS_MGR,L.DESCR LOC_DESCR, " + 
						"(SELECT EMP_FNAME||' '||EMP_LNAME||'(PSR)' FROM EMPLOYEE WHERE EMP_CODE = DDV.SALES_PERS_MGR) AS VISITED_WITH_PSR_NAME " + 
						"FROM DR_STOCKIST_VISIT DDV ,LOCALITY L,CUSTOMER CUST " + 
						"WHERE DDV.SALES_PERS=? AND DDV.WORK_DATE=? AND L.LOCALITY_CODE=DDV.WORK_LOCALITY_CODE  AND DDV.CUST_CODE=CUST.CUST_CODE";
				pstmt=conn.prepareStatement(stockEditSql);
				pstmt.setString(1, salesPers);
				pstmt.setTimestamp( 2, java.sql.Timestamp.valueOf( eventDateDBFmt ) );
				rs = pstmt.executeQuery();
				
				while (rs.next())
				{
					String psrData=checkNull(rs.getString("VISITED_WITH_PSR_NAME"));
					valueXmlString.append( "<StockData domID='"+domID+"' selected = 'Y'>\r\n" );
					valueXmlString.append( "<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\"/>\r\n");
					valueXmlString.append( "<strg_code><![CDATA[" ).append( checkNull(rs.getString("SC_CODE")).trim()).append( "]]></strg_code>\r\n");							
					valueXmlString.append( "<cust_name><![CDATA[" ).append( checkNull(rs.getString("SC_NAME"))).append( "]]></cust_name>\r\n");
					valueXmlString.append( "<sales_pers><![CDATA[" ).append(checkNull(salesPers)).append( "]]></sales_pers>\r\n" );
					valueXmlString.append( "<event_date><![CDATA[" ).append(eventDate).append( "]]></event_date>\r\n" );				
					valueXmlString.append( "<locality_descr><![CDATA[" ).append( checkNull(rs.getString("LOC_DESCR")).trim()).append( "]]></locality_descr>\r\n");
					valueXmlString.append( "<cust_type><![CDATA[" ).append("S").append( "]]></cust_type>\r\n" );				
					valueXmlString.append( "<event_time_start><![CDATA[" ).append(rs.getString("STOCKIST_VISIT_TIME")).append( "]]></event_time_start>\r\n" );
					valueXmlString.append( "<event_time_end><![CDATA[" ).append(rs.getString("STOCKIST_VISIT_TIME")).append( "]]></event_time_end>\r\n" );
					valueXmlString.append( "<pob_val><![CDATA[" ).append(checkNull(rs.getString("ORDER_BOOKED"))).append( "]]></pob_val>\r\n" );
					valueXmlString.append( "<customer_type><![CDATA[" ).append("LISTED").append( "]]></customer_type>\r\n" );
					valueXmlString.append( "<remarks><![CDATA[" ).append(checkNull(rs.getString("REMARKS"))).append( "]]></remarks>\r\n" );
					valueXmlString.append("<collection_form_no><![CDATA[" ).append("stockistcollection").append( "]]></collection_form_no>\r\n" ); //27-12-2022
					valueXmlString.append("<item_form_no><![CDATA[" ).append("stockistsampleitem").append( "]]></item_form_no>\r\n" );
					valueXmlString.append("<brand_form_no><![CDATA[" ).append("Stockistbrand").append( "]]></brand_form_no>\r\n" );
					valueXmlString.append("<display_form_no><![CDATA[" ).append("StockistDisplay").append( "]]></display_form_no>\r\n" );
					valueXmlString.append("<survey_form_no><![CDATA[" ).append("stockistsurvey").append( "]]></survey_form_no>\r\n" );
					//valueXmlString.append( "</MerchData>\r\n" );
					if(mgrCode.trim().length()!=0)
					{
						valueXmlString.append( "<team_details><![CDATA[" ).append( psrData ).append( "]]></team_details>\r\n" );

					}
					valueXmlString.append("<host_url><![CDATA[" ).append(CommonConstants.TOMCAT_HOME).append( "]]></host_url>\r\n" );
					valueXmlString.append( "</StockData>\r\n" );
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
			}
			else
			{
				String UnlistedCode=getUnlistedCustomerList(conn,custDcrId);
				if(mgrCode.trim().length()!= 0)
				{
					if (stockistTable.equalsIgnoreCase("SPRS_STOCKIST"))
					{
						// CHanges by Harion for Doctor not showing in summary when changed locality -- 04-Feb-2021   [Start]
						/*sqlEdit = "SELECT STRG_MEET.*,LOCALITY.DESCR LOC_DESCR,FIELDACTIVITY.ACTIVITY_TYPE ACT_TYPE, SCC.CLASS_CODE_DESCR, UPPER(STRG_CUSTOMER.FIRST_NAME)||' '||UPPER(STRG_CUSTOMER.MIDDLE_NAME)||' '||UPPER(STRG_CUSTOMER.LAST_NAME) AS SC_NAME, "+
								"STRG_MEET.STRG_TYPE AS CUST_TYPE, (CASE WHEN STRG_MEET.STRG_TYPE = 'D' THEN 1  WHEN STRG_MEET.STRG_TYPE='R' THEN 2  WHEN STRG_MEET.STRG_TYPE='M' THEN 3 ELSE 4 END) "+
								"AS CUST_TYPE_SEQ, SCT.DCR_GROUP AS DCR_GROUP, SS.NO_VISIT,SPL.DESCR AS SPL_DSCR,'LISTED' AS CUSTOMER_TYPE  "+
								"FROM SALES_PERS SAP,STRG_CUSTOMER ,STRG_SERIES SS LEFT OUTER JOIN SPECIALITY SPL ON SS.SPL_CODE=SPL.SPL_CODE, FIELDACTIVITY, STRG_MEET LEFT OUTER JOIN LOCALITY ON STRG_MEET.LOCALITY_CODE = LOCALITY.LOCALITY_CODE "+
								"LEFT OUTER JOIN SPRS_ACT_TRAN ON STRG_MEET.DCR_ID = SPRS_ACT_TRAN.DCR_ID LEFT OUTER JOIN STRG_CUST_CLASS SCC ON STRG_MEET.STRG_CLASS_CODE = SCC.CLASS_CODE "+
								"AND SCC.CUST_TYPE = STRG_MEET.STRG_TYPE LEFT OUTER JOIN STRG_CUST_TYPE SCT ON STRG_MEET.STRG_TYPE = SCT.TYPE  "+
								"WHERE STRG_MEET.EVENT_TYPE = FIELDACTIVITY.ACTIVITY_CODE AND STRG_MEET.STRG_CODE = STRG_CUSTOMER.SC_CODE AND SS.SALES_PERS = STRG_MEET.SPRS_CODE__WW "+
								"AND SS.SC_CODE=STRG_MEET.STRG_CODE AND SS.ROUTE_ID = STRG_MEET.ROUTE_ID AND STRG_MEET.SALES_PERS = ? AND STRG_MEET.EVENT_DATE = ? AND SCT.DCR_GROUP IN ('C','D','O') AND SAP.SALES_PERS=SS.SALES_PERS AND SAP.ITEM_SER=SS.ITEM_SER "+
								"UNION "+
								"SELECT STRG_MEET.*,LOCALITY.DESCR LOC_DESCR,FIELDACTIVITY.ACTIVITY_TYPE ACT_TYPE,SCC.CLASS_CODE_DESCR, STRG_MEET.STRG_NAME AS SC_NAME, "+
								"STRG_MEET.STRG_TYPE AS CUST_TYPE, (CASE WHEN STRG_MEET.STRG_TYPE = 'D' THEN 1  WHEN STRG_MEET.STRG_TYPE='R' THEN 2  WHEN STRG_MEET.STRG_TYPE='M' "+
								"THEN 3 ELSE 4 END) AS CUST_TYPE_SEQ, SCT.DCR_GROUP AS DCR_GROUP, 0 AS NO_VISIT,SPL.DESCR AS SPL_DSCR,'UNLISTED' AS CUSTOMER_TYPE  "+
								"FROM FIELDACTIVITY,STRG_MEET "+
								"LEFT OUTER JOIN LOCALITY ON STRG_MEET.LOCALITY_CODE = LOCALITY.LOCALITY_CODE LEFT OUTER JOIN SPRS_ACT_TRAN ON STRG_MEET.DCR_ID = SPRS_ACT_TRAN.DCR_ID "+
								"LEFT OUTER JOIN STRG_CUST_CLASS SCC ON STRG_MEET.STRG_CLASS_CODE = SCC.CLASS_CODE AND SCC.CUST_TYPE = STRG_MEET.STRG_TYPE "+
								"LEFT OUTER JOIN SPECIALITY SPL ON STRG_MEET.SPL_CODE = SPL.SPL_CODE LEFT OUTER JOIN STRG_CUST_TYPE SCT ON STRG_MEET.STRG_TYPE = SCT.TYPE "+
								"WHERE STRG_MEET.EVENT_TYPE = FIELDACTIVITY.ACTIVITY_CODE AND STRG_MEET.EVENT_DATE = ? AND STRG_MEET.SALES_PERS = ? "+
								"AND STRG_MEET.STRG_CODE NOT IN(SELECT SC_CODE FROM STRG_CUSTOMER) AND SCT.DCR_GROUP IN ('C','D','S','O') AND STRG_MEET.STRG_CODE NOT IN (SELECT CUST_CODE FROM CUSTOMER) "+
								"UNION "+
								"SELECT STRG_MEET.*,LOCALITY.DESCR LOC_DESCR, FIELDACTIVITY.ACTIVITY_TYPE ACT_TYPE, SCC.CLASS_CODE_DESCR, UPPER(CUST_NAME) AS SC_NAME, "+
								"STRG_MEET.STRG_TYPE AS CUST_TYPE, (CASE WHEN STRG_MEET.STRG_TYPE = 'D' THEN 1  WHEN STRG_MEET.STRG_TYPE = 'R' THEN 2  WHEN STRG_MEET.STRG_TYPE = 'M' "+
								"THEN 3 ELSE 4 END) AS CUST_TYPE_SEQ, SCT.DCR_GROUP AS DCR_GROUP, 0 AS NO_VISIT, SPL.DESCR AS SPL_DSCR,'LISTED' AS CUSTOMER_TYPE  "+
								"FROM CUSTOMER , SPRS_STOCKIST SS, FIELDACTIVITY, STRG_MEET  LEFT OUTER JOIN LOCALITY ON STRG_MEET.LOCALITY_CODE = LOCALITY.LOCALITY_CODE "+
								"LEFT OUTER JOIN SPRS_ACT_TRAN ON STRG_MEET.DCR_ID = SPRS_ACT_TRAN.DCR_ID LEFT OUTER JOIN STRG_CUST_CLASS SCC ON STRG_MEET.STRG_CLASS_CODE = SCC.CLASS_CODE "+
								"AND SCC.CUST_TYPE = STRG_MEET.STRG_TYPE "+
								"LEFT OUTER JOIN SPECIALITY SPL ON STRG_MEET.SPL_CODE = SPL.SPL_CODE "+
								"LEFT OUTER JOIN STRG_CUST_TYPE SCT ON STRG_MEET.STRG_TYPE = SCT.TYPE  WHERE STRG_MEET.EVENT_TYPE = FIELDACTIVITY.ACTIVITY_CODE "+
								"AND STRG_MEET.STRG_CODE = CUSTOMER.CUST_CODE AND  SS.SPRS_CODE = STRG_MEET.SPRS_CODE__WW AND SS.CUST_CODE = STRG_MEET.STRG_CODE "+
								"AND SS.ROUTE_ID = STRG_MEET.ROUTE_ID AND STRG_MEET.SALES_PERS = ? AND STRG_MEET.EVENT_DATE = ? "+
								"AND SCT.DCR_GROUP IN ('S') ORDER BY CUST_TYPE_SEQ";*/
						
						
						 sqlEdit="SELECT STRG_MEET.TRAN_ID,STRG_MEET.STRG_CODE,STRG_MEET.STRG_CLASS_CODE,STRG_MEET.DCR_ID,STRG_MEET.ROUTE_ID,STRG_MEET.SPRS_CODE__WW,STRG_MEET.OTH_PARTICIPANT,STRG_MEET.CONTACT_PERS,STRG_MEET.CONTACT_PERS_NAME,STRG_MEET.REG_NO,STRG_MEET.EVENT_TYPE,STRG_MEET.PLAN_CHG_REAS,STRG_MEET.CALL_OUTCOME,STRG_MEET.MEET_SUMM,STRG_MEET.REMARKS,STRG_MEET.EVENT_TIME_START,STRG_MEET.EVENT_TIME_END,STRG_MEET.SKU_VALUE,STRG_MEET.AMOUNT,STRG_MEET.NET_AMT,STRG_MEET.TAX_AMOUNT,STRG_MEET.ADDRESS_AS,STRG_MEET.MEMBER_PRESENT, "+
						 		" LOCALITY.DESCR LOC_DESCR,FIELDACTIVITY.ACTIVITY_TYPE ACT_TYPE, SCC.CLASS_CODE_DESCR, STRG_CUSTOMER.FIRST_NAME||' '||STRG_CUSTOMER.MIDDLE_NAME||' '||STRG_CUSTOMER.LAST_NAME AS SC_NAME, " + 
								" STRG_MEET.STRG_TYPE AS CUST_TYPE,STRG_MEET.ADDR1,STRG_MEET.ADDR2,STRG_MEET.ADDR3,STRG_MEET.SALES_TYPE, " + 
								" SCT.DCR_GROUP AS DCR_GROUP,SPL.DESCR AS SPL_DSCR,'LISTED' AS CUSTOMER_TYPE,SCT.DESCR  AS CUST_TYPE_DESCR  " + 
								" FROM STRG_CUSTOMER , FIELDACTIVITY, LOCALITY,SPRS_ACT_TRAN,STRG_MEET LEFT OUTER JOIN SPECIALITY SPL ON STRG_MEET.SPL_CODE = SPL.SPL_CODE " + 
								"  LEFT OUTER JOIN STRG_CUST_CLASS SCC ON STRG_MEET.STRG_CLASS_CODE = SCC.CLASS_CODE " + 
								" AND SCC.CUST_TYPE = STRG_MEET.STRG_TYPE LEFT OUTER JOIN STRG_CUST_TYPE SCT ON STRG_MEET.STRG_TYPE = SCT.TYPE  " + 
								" WHERE STRG_MEET.EVENT_TYPE = FIELDACTIVITY.ACTIVITY_CODE AND STRG_MEET.LOCALITY_CODE = LOCALITY.LOCALITY_CODE  AND STRG_MEET.STRG_CODE = STRG_CUSTOMER.SC_CODE " + 
								" AND STRG_MEET.DCR_ID = SPRS_ACT_TRAN.DCR_ID AND STRG_MEET.SALES_PERS = ? AND STRG_MEET.EVENT_DATE = ? AND SCT.DCR_GROUP IN ('C','D','O') " + 
								" UNION " + 
								" SELECT STRG_MEET.TRAN_ID,STRG_MEET.STRG_CODE,STRG_MEET.STRG_CLASS_CODE,STRG_MEET.DCR_ID,STRG_MEET.ROUTE_ID,STRG_MEET.SPRS_CODE__WW,STRG_MEET.OTH_PARTICIPANT,STRG_MEET.CONTACT_PERS,STRG_MEET.CONTACT_PERS_NAME,STRG_MEET.REG_NO,STRG_MEET.EVENT_TYPE,STRG_MEET.PLAN_CHG_REAS,STRG_MEET.CALL_OUTCOME,STRG_MEET.MEET_SUMM,STRG_MEET.REMARKS,STRG_MEET.EVENT_TIME_START,STRG_MEET.EVENT_TIME_END,STRG_MEET.SKU_VALUE,STRG_MEET.AMOUNT,STRG_MEET.NET_AMT,STRG_MEET.TAX_AMOUNT,STRG_MEET.ADDRESS_AS,STRG_MEET.MEMBER_PRESENT, "+
								" LOCALITY.DESCR LOC_DESCR,FIELDACTIVITY.ACTIVITY_TYPE ACT_TYPE,SCC.CLASS_CODE_DESCR, STRG_MEET.STRG_NAME AS SC_NAME, " + 
								" STRG_MEET.STRG_TYPE AS CUST_TYPE,STRG_MEET.ADDR1,STRG_MEET.ADDR2,STRG_MEET.ADDR3,STRG_MEET.SALES_TYPE, " + 
								" SCT.DCR_GROUP AS DCR_GROUP, SPL.DESCR AS SPL_DSCR,'UNLISTED' AS CUSTOMER_TYPE,SCT.DESCR  AS CUST_TYPE_DESCR  " + 
								" FROM FIELDACTIVITY,LOCALITY,SPRS_ACT_TRAN,STRG_MEET " + 
								" LEFT OUTER JOIN STRG_CUST_CLASS SCC ON STRG_MEET.STRG_CLASS_CODE = SCC.CLASS_CODE AND SCC.CUST_TYPE = STRG_MEET.STRG_TYPE " + 
								" LEFT OUTER JOIN SPECIALITY SPL ON STRG_MEET.SPL_CODE = SPL.SPL_CODE LEFT OUTER JOIN STRG_CUST_TYPE SCT ON STRG_MEET.STRG_TYPE = SCT.TYPE " + 
								" WHERE STRG_MEET.EVENT_TYPE = FIELDACTIVITY.ACTIVITY_CODE AND STRG_MEET.EVENT_DATE = ? AND STRG_MEET.LOCALITY_CODE = LOCALITY.LOCALITY_CODE "+
								" AND STRG_MEET.DCR_ID = SPRS_ACT_TRAN.DCR_ID AND STRG_MEET.SALES_PERS = ? " + 
								" AND STRG_MEET.STRG_CODE IN("+UnlistedCode+") AND SCT.DCR_GROUP IN ('C','D','S','O')  " + 
								" UNION " + 
								" SELECT STRG_MEET.TRAN_ID,STRG_MEET.STRG_CODE,STRG_MEET.STRG_CLASS_CODE,STRG_MEET.DCR_ID,STRG_MEET.ROUTE_ID,STRG_MEET.SPRS_CODE__WW,STRG_MEET.OTH_PARTICIPANT,STRG_MEET.CONTACT_PERS,STRG_MEET.CONTACT_PERS_NAME,STRG_MEET.REG_NO,STRG_MEET.EVENT_TYPE,STRG_MEET.PLAN_CHG_REAS,STRG_MEET.CALL_OUTCOME,STRG_MEET.MEET_SUMM,STRG_MEET.REMARKS,STRG_MEET.EVENT_TIME_START,STRG_MEET.EVENT_TIME_END,STRG_MEET.SKU_VALUE,STRG_MEET.AMOUNT,STRG_MEET.NET_AMT,STRG_MEET.TAX_AMOUNT,STRG_MEET.ADDRESS_AS,STRG_MEET.MEMBER_PRESENT, "+
								" LOCALITY.DESCR LOC_DESCR, FIELDACTIVITY.ACTIVITY_TYPE ACT_TYPE, SCC.CLASS_CODE_DESCR, CUST_NAME AS SC_NAME, " + 
								" STRG_MEET.STRG_TYPE AS CUST_TYPE,STRG_MEET.ADDR1,STRG_MEET.ADDR2,STRG_MEET.ADDR3,STRG_MEET.SALES_TYPE,  " + 
								" SCT.DCR_GROUP AS DCR_GROUP,  SPL.DESCR AS SPL_DSCR,'LISTED' AS CUSTOMER_TYPE,SCT.DESCR  AS CUST_TYPE_DESCR  " + 
								" FROM CUSTOMER ,LOCALITY,SPRS_ACT_TRAN, SPRS_STOCKIST SS, FIELDACTIVITY, STRG_MEET   " + 
								" LEFT OUTER JOIN STRG_CUST_CLASS SCC ON STRG_MEET.STRG_CLASS_CODE = SCC.CLASS_CODE " + 
								" AND SCC.CUST_TYPE = STRG_MEET.STRG_TYPE " + 
								" LEFT OUTER JOIN SPECIALITY SPL ON STRG_MEET.SPL_CODE = SPL.SPL_CODE " + 
								" LEFT OUTER JOIN STRG_CUST_TYPE SCT ON STRG_MEET.STRG_TYPE = SCT.TYPE  WHERE STRG_MEET.EVENT_TYPE = FIELDACTIVITY.ACTIVITY_CODE " + 
								" AND STRG_MEET.STRG_CODE = CUSTOMER.CUST_CODE AND  SS.SPRS_CODE = STRG_MEET.SPRS_CODE__WW AND SS.CUST_CODE = STRG_MEET.STRG_CODE AND STRG_MEET.LOCALITY_CODE = LOCALITY.LOCALITY_CODE " + 
								" AND SS.ROUTE_ID = STRG_MEET.ROUTE_ID AND STRG_MEET.DCR_ID = SPRS_ACT_TRAN.DCR_ID AND  STRG_MEET.SALES_PERS = ? AND STRG_MEET.EVENT_DATE = ? " + 
								" AND SCT.DCR_GROUP IN ('S')";
						// CHanges by Harion for Doctor not showing in summary when changed locality -- 04-Feb-2021   [End]
						
						
						
						pstmt =  conn.prepareStatement( sqlEdit );
						pstmt.setString(5, salesPers);
						pstmt.setTimestamp( 6, java.sql.Timestamp.valueOf( eventDateDBFmt ) );
						
					}
					else
					{
						// CHanges by Harion for Doctor not showing in summary when changed locality -- 04-Feb-2021   [Start]
						/*sqlEdit  ="SELECT STRG_MEET.*,LOCALITY.DESCR LOC_DESCR,FIELDACTIVITY.ACTIVITY_TYPE ACT_TYPE, SCC.CLASS_CODE_DESCR, "+    // Added by kailash 
							 	" UPPER(STRG_CUSTOMER.FIRST_NAME)||' '||UPPER(STRG_CUSTOMER.MIDDLE_NAME)||' '||UPPER(STRG_CUSTOMER.LAST_NAME) AS SC_NAME,"+ 
								" STRG_MEET.STRG_TYPE AS CUST_TYPE, "+ 
								" (CASE WHEN STRG_MEET.STRG_TYPE = 'D' THEN 1  WHEN STRG_MEET.STRG_TYPE='R' THEN 2  WHEN STRG_MEET.STRG_TYPE='M' THEN 3 ELSE 4 END) AS CUST_TYPE_SEQ, "+
								" SCT.DCR_GROUP AS DCR_GROUP,"// added by rupali on 21/12/18 for dcr_group related changes
								+ "SS.NO_VISIT,SPL.DESCR AS SPL_DSCR,'LISTED' AS CUSTOMER_TYPE "+ //Added by mrunalini to showing speciality no_visit on summary page
								" FROM SALES_PERS SAP,STRG_CUSTOMER ,STRG_SERIES SS LEFT OUTER JOIN SPECIALITY SPL ON SS.SPL_CODE=SPL.SPL_CODE,FIELDACTIVITY,STRG_MEET  "+
								" LEFT OUTER JOIN LOCALITY ON STRG_MEET.LOCALITY_CODE = LOCALITY.LOCALITY_CODE " +
								" LEFT OUTER JOIN SPRS_ACT_TRAN ON STRG_MEET.DCR_ID = SPRS_ACT_TRAN.DCR_ID  "+
								" LEFT OUTER JOIN STRG_CUST_CLASS SCC ON STRG_MEET.STRG_CLASS_CODE = SCC.CLASS_CODE"+ //Added by kailash
								" AND SCC.CUST_TYPE = STRG_MEET.STRG_TYPE  LEFT OUTER JOIN STRG_CUST_TYPE SCT ON STRG_MEET.STRG_TYPE = SCT.TYPE "+ // added by rupali on 21/12/18 for dcr_group related changes
								" WHERE STRG_MEET.EVENT_TYPE =FIELDACTIVITY.ACTIVITY_CODE "
								+ " AND STRG_MEET.STRG_CODE = STRG_CUSTOMER.SC_CODE "
								//+ " AND SS.SALES_PERS=STRG_MEET.SALES_PERS AND SS.SC_CODE=STRG_MEET.STRG_CODE AND SS.ROUTE_ID=STRG_MEET.ROUTE_ID "+
								+ " AND SS.SALES_PERS = STRG_MEET.SPRS_CODE__WW AND SS.SC_CODE=STRG_MEET.STRG_CODE AND SS.ROUTE_ID=STRG_MEET.ROUTE_ID "+
								" AND STRG_MEET.SALES_PERS = ? "+
								" AND STRG_MEET.EVENT_DATE = ? "+
								//" AND STRG_CUSTOMER.CUST_TYPE  IN ('C','D','S','O') " + // commentted by rupali on 21/12/18 for dcr_group related changes
								" AND SCT.DCR_GROUP IN ('C','D','S','O')  AND SAP.SALES_PERS=SS.SALES_PERS AND SAP.ITEM_SER=SS.ITEM_SER " + // added by rupali on 21/12/18 for dcr_group related changes
								//" AND (CASE WHEN SPRS_ACT_TRAN.CONFIRMED IS NULL THEN 'N' ELSE SPRS_ACT_TRAN.CONFIRMED END) ='N' "+ commented by mrunalini sinkar for DCR View Lik in claim expense
								//" AND SCC.CUST_TYPE = STRG_MEET.STRG_TYPE"+ //Added by kailash // commentted by rupali on 21/12/18 for dcr_group related changes
								" UNION "+
								" SELECT STRG_MEET.*,LOCALITY.DESCR LOC_DESCR,FIELDACTIVITY.ACTIVITY_TYPE ACT_TYPE,SCC.CLASS_CODE_DESCR, STRG_MEET.STRG_NAME AS SC_NAME, "+ //Added class code descr by kailash
								" STRG_MEET.STRG_TYPE AS CUST_TYPE, "+
								" (CASE WHEN STRG_MEET.STRG_TYPE = 'D' THEN 1  WHEN STRG_MEET.STRG_TYPE='R' THEN 2  WHEN STRG_MEET.STRG_TYPE='M' THEN 3 ELSE 4 END) AS CUST_TYPE_SEQ, "+
								" SCT.DCR_GROUP AS DCR_GROUP, "// added by rupali on 21/12/18 for dcr_group related changes
								+ " 0 AS NO_VISIT,SPL.DESCR AS SPL_DSCR,'UNLISTED' AS CUSTOMER_TYPE "+ //Added by mrunalini to showing speciality no_visit on summary page 
								" FROM FIELDACTIVITY,STRG_MEET "+
								" LEFT OUTER JOIN LOCALITY ON STRG_MEET.LOCALITY_CODE = LOCALITY.LOCALITY_CODE "+
								" LEFT OUTER JOIN SPRS_ACT_TRAN ON STRG_MEET.DCR_ID = SPRS_ACT_TRAN.DCR_ID "+
								" LEFT OUTER JOIN STRG_CUST_CLASS SCC ON STRG_MEET.STRG_CLASS_CODE = SCC.CLASS_CODE"+ //Added by kailash
								" AND SCC.CUST_TYPE = STRG_MEET.STRG_TYPE LEFT OUTER JOIN SPECIALITY SPL ON STRG_MEET.SPL_CODE=SPL.SPL_CODE  LEFT OUTER JOIN STRG_CUST_TYPE SCT ON STRG_MEET.STRG_TYPE = SCT.TYPE "+ // added by rupali on 21/12/18 for dcr_group related changes
								" WHERE STRG_MEET.EVENT_TYPE =FIELDACTIVITY.ACTIVITY_CODE "+
								" AND STRG_MEET.EVENT_DATE = ? "+
								" AND STRG_MEET.SALES_PERS = ? "+
								" AND  STRG_MEET.STRG_CODE NOT IN(SELECT SC_CODE FROM STRG_CUSTOMER) "+
								//" AND STRG_MEET.STRG_TYPE  IN ('C','D','S','O') "+ // commentted by rupali on 21/12/18 for dcr_group related changes
								" AND SCT.DCR_GROUP IN ('C','D','S','O') " + // added by rupali on 21/12/18 for dcr_group related changes
								//" AND SCC.CUST_TYPE = STRG_MEET.STRG_TYPE"+ // Added by kailash // commentted by rupali on 21/12/18 for dcr_group related changes
								" ORDER BY CUST_TYPE_SEQ ";*/
						
						 sqlEdit="SELECT STRG_MEET.TRAN_ID,STRG_MEET.STRG_CODE,STRG_MEET.STRG_CLASS_CODE,STRG_MEET.DCR_ID,STRG_MEET.ROUTE_ID,STRG_MEET.SPRS_CODE__WW,STRG_MEET.OTH_PARTICIPANT,STRG_MEET.CONTACT_PERS,STRG_MEET.CONTACT_PERS_NAME,STRG_MEET.REG_NO,STRG_MEET.EVENT_TYPE,STRG_MEET.PLAN_CHG_REAS,STRG_MEET.CALL_OUTCOME,STRG_MEET.MEET_SUMM,STRG_MEET.REMARKS,STRG_MEET.EVENT_TIME_START,STRG_MEET.EVENT_TIME_END,STRG_MEET.SKU_VALUE,STRG_MEET.AMOUNT,STRG_MEET.NET_AMT,STRG_MEET.TAX_AMOUNT,STRG_MEET.ADDRESS_AS,STRG_MEET.MEMBER_PRESENT, "+
						 		" LOCALITY.DESCR LOC_DESCR,FIELDACTIVITY.ACTIVITY_TYPE ACT_TYPE, SCC.CLASS_CODE_DESCR, " + 
								" STRG_CUSTOMER.FIRST_NAME||' '||STRG_CUSTOMER.MIDDLE_NAME||' '||STRG_CUSTOMER.LAST_NAME AS SC_NAME," + 
								" STRG_MEET.STRG_TYPE AS CUST_TYPE,STRG_MEET.ADDR1,STRG_MEET.ADDR2,STRG_MEET.ADDR3,STRG_MEET.SALES_TYPE, " + 
								" SCT.DCR_GROUP AS DCR_GROUP, " + 
								" SPL.DESCR AS SPL_DSCR,'LISTED' AS CUSTOMER_TYPE , STRG_MEET.ROUTE_ID AS ROUTE_ID , STRG_MEET.SPRS_CODE__WW AS SPRS_CODE__WW,SCT.DESCR  AS CUST_TYPE_DESCR " + 
								" FROM LOCALITY,SPRS_ACT_TRAN,STRG_CUSTOMER ,FIELDACTIVITY,STRG_MEET LEFT OUTER JOIN SPECIALITY SPL ON STRG_MEET.SPL_CODE=SPL.SPL_CODE " + 
								" LEFT OUTER JOIN STRG_CUST_CLASS SCC ON STRG_MEET.STRG_CLASS_CODE = SCC.CLASS_CODE " + 
								" AND SCC.CUST_TYPE = STRG_MEET.STRG_TYPE  LEFT OUTER JOIN STRG_CUST_TYPE SCT ON STRG_MEET.STRG_TYPE = SCT.TYPE " + 
								" WHERE STRG_MEET.EVENT_TYPE =FIELDACTIVITY.ACTIVITY_CODE AND STRG_MEET.LOCALITY_CODE = LOCALITY.LOCALITY_CODE " + 
								" AND STRG_MEET.DCR_ID = SPRS_ACT_TRAN.DCR_ID AND STRG_MEET.STRG_CODE = STRG_CUSTOMER.SC_CODE " + 
								" AND STRG_MEET.SALES_PERS = ? " + 
								" AND STRG_MEET.EVENT_DATE = ? " + 
								" AND SCT.DCR_GROUP IN ('C','D','S','O')  " + 
								" UNION " + 
								" SELECT STRG_MEET.TRAN_ID,STRG_MEET.STRG_CODE,STRG_MEET.STRG_CLASS_CODE,STRG_MEET.DCR_ID,STRG_MEET.ROUTE_ID,STRG_MEET.SPRS_CODE__WW,STRG_MEET.OTH_PARTICIPANT,STRG_MEET.CONTACT_PERS,STRG_MEET.CONTACT_PERS_NAME,STRG_MEET.REG_NO,STRG_MEET.EVENT_TYPE,STRG_MEET.PLAN_CHG_REAS,STRG_MEET.CALL_OUTCOME,STRG_MEET.MEET_SUMM,STRG_MEET.REMARKS,STRG_MEET.EVENT_TIME_START,STRG_MEET.EVENT_TIME_END,STRG_MEET.SKU_VALUE,STRG_MEET.AMOUNT,STRG_MEET.NET_AMT,STRG_MEET.TAX_AMOUNT,STRG_MEET.ADDRESS_AS,STRG_MEET.MEMBER_PRESENT, "+
								" LOCALITY.DESCR LOC_DESCR,FIELDACTIVITY.ACTIVITY_TYPE ACT_TYPE,SCC.CLASS_CODE_DESCR, STRG_MEET.STRG_NAME AS SC_NAME, " + 
								" STRG_MEET.STRG_TYPE AS CUST_TYPE,STRG_MEET.ADDR1,STRG_MEET.ADDR2,STRG_MEET.ADDR3,STRG_MEET.SALES_TYPE, " + 
								" SCT.DCR_GROUP AS DCR_GROUP, " + 
								" SPL.DESCR AS SPL_DSCR,'UNLISTED' AS CUSTOMER_TYPE , STRG_MEET.ROUTE_ID AS ROUTE_ID, STRG_MEET.SPRS_CODE__WW AS SPRS_CODE__WW,SCT.DESCR  AS CUST_TYPE_DESCR " + 
								" FROM FIELDACTIVITY,LOCALITY,SPRS_ACT_TRAN,STRG_MEET " + 
								" LEFT OUTER JOIN STRG_CUST_CLASS SCC ON STRG_MEET.STRG_CLASS_CODE = SCC.CLASS_CODE " + 
								" AND SCC.CUST_TYPE = STRG_MEET.STRG_TYPE LEFT OUTER JOIN SPECIALITY SPL ON STRG_MEET.SPL_CODE=SPL.SPL_CODE  LEFT OUTER JOIN STRG_CUST_TYPE SCT ON STRG_MEET.STRG_TYPE = SCT.TYPE " + 
								" WHERE STRG_MEET.EVENT_TYPE =FIELDACTIVITY.ACTIVITY_CODE AND STRG_MEET.LOCALITY_CODE = LOCALITY.LOCALITY_CODE " + 
								" AND STRG_MEET.DCR_ID = SPRS_ACT_TRAN.DCR_ID AND STRG_MEET.EVENT_DATE = ? " + 
								" AND STRG_MEET.SALES_PERS = ? " + 
								" AND  STRG_MEET.STRG_CODE IN("+UnlistedCode+") " + 
								" AND SCT.DCR_GROUP IN ('C','D','S','O') " ; 
						
						
						
						pstmt =  conn.prepareStatement( sqlEdit );
					
						}
				}
				else
				{
					if (stockistTable.equalsIgnoreCase("SPRS_STOCKIST"))
					{
						// CHanges by Harion for Doctor not showing in summary when changed locality -- 04-Feb-2021   [Start]
						/*sqlEdit = "SELECT STRG_MEET.*,LOCALITY.DESCR LOC_DESCR,FIELDACTIVITY.ACTIVITY_TYPE ACT_TYPE, SCC.CLASS_CODE_DESCR, UPPER(STRG_CUSTOMER.FIRST_NAME)||' '||UPPER(STRG_CUSTOMER.MIDDLE_NAME)||' '||UPPER(STRG_CUSTOMER.LAST_NAME) AS SC_NAME, "+
								"STRG_MEET.STRG_TYPE AS CUST_TYPE, (CASE WHEN STRG_MEET.STRG_TYPE = 'D' THEN 1  WHEN STRG_MEET.STRG_TYPE='R' THEN 2  WHEN STRG_MEET.STRG_TYPE='M' THEN 3 ELSE 4 END) "+
								"AS CUST_TYPE_SEQ, SCT.DCR_GROUP AS DCR_GROUP, SS.NO_VISIT,SPL.DESCR AS SPL_DSCR,'LISTED' AS CUSTOMER_TYPE  "+
								"FROM SALES_PERS SAP,STRG_CUSTOMER ,STRG_SERIES SS LEFT OUTER JOIN SPECIALITY SPL ON SS.SPL_CODE=SPL.SPL_CODE, FIELDACTIVITY, STRG_MEET LEFT OUTER JOIN LOCALITY ON STRG_MEET.LOCALITY_CODE = LOCALITY.LOCALITY_CODE "+
								"LEFT OUTER JOIN SPRS_ACT_TRAN ON STRG_MEET.DCR_ID = SPRS_ACT_TRAN.DCR_ID LEFT OUTER JOIN STRG_CUST_CLASS SCC ON STRG_MEET.STRG_CLASS_CODE = SCC.CLASS_CODE "+
								"AND SCC.CUST_TYPE = STRG_MEET.STRG_TYPE LEFT OUTER JOIN STRG_CUST_TYPE SCT ON STRG_MEET.STRG_TYPE = SCT.TYPE  "+
								"WHERE STRG_MEET.EVENT_TYPE = FIELDACTIVITY.ACTIVITY_CODE AND STRG_MEET.STRG_CODE = STRG_CUSTOMER.SC_CODE AND SS.SALES_PERS = STRG_MEET.SALES_PERS  "+
								"AND SS.SC_CODE=STRG_MEET.STRG_CODE AND SS.ROUTE_ID = STRG_MEET.ROUTE_ID AND STRG_MEET.SALES_PERS = ? AND STRG_MEET.EVENT_DATE = ? AND SCT.DCR_GROUP IN ('C','D','O')  AND SAP.SALES_PERS=SS.SALES_PERS AND SAP.ITEM_SER=SS.ITEM_SER "+
								"UNION "+
								"SELECT STRG_MEET.*,LOCALITY.DESCR LOC_DESCR,FIELDACTIVITY.ACTIVITY_TYPE ACT_TYPE,SCC.CLASS_CODE_DESCR, STRG_MEET.STRG_NAME AS SC_NAME, "+
								"STRG_MEET.STRG_TYPE AS CUST_TYPE, (CASE WHEN STRG_MEET.STRG_TYPE = 'D' THEN 1  WHEN STRG_MEET.STRG_TYPE='R' THEN 2  WHEN STRG_MEET.STRG_TYPE='M' "+
								"THEN 3 ELSE 4 END) AS CUST_TYPE_SEQ, SCT.DCR_GROUP AS DCR_GROUP, 0 AS NO_VISIT,SPL.DESCR AS SPL_DSCR,'UNLISTED' AS CUSTOMER_TYPE  "+
								"FROM FIELDACTIVITY,STRG_MEET "+
								"LEFT OUTER JOIN LOCALITY ON STRG_MEET.LOCALITY_CODE = LOCALITY.LOCALITY_CODE LEFT OUTER JOIN SPRS_ACT_TRAN ON STRG_MEET.DCR_ID = SPRS_ACT_TRAN.DCR_ID "+
								"LEFT OUTER JOIN STRG_CUST_CLASS SCC ON STRG_MEET.STRG_CLASS_CODE = SCC.CLASS_CODE AND SCC.CUST_TYPE = STRG_MEET.STRG_TYPE "+
								"LEFT OUTER JOIN SPECIALITY SPL ON STRG_MEET.SPL_CODE = SPL.SPL_CODE LEFT OUTER JOIN STRG_CUST_TYPE SCT ON STRG_MEET.STRG_TYPE = SCT.TYPE "+
								"WHERE STRG_MEET.EVENT_TYPE = FIELDACTIVITY.ACTIVITY_CODE AND STRG_MEET.EVENT_DATE = ? AND STRG_MEET.SALES_PERS = ? "+
								"AND STRG_MEET.STRG_CODE NOT IN(SELECT SC_CODE FROM STRG_CUSTOMER) AND SCT.DCR_GROUP IN ('C','D','S','O') AND STRG_MEET.STRG_CODE NOT IN (SELECT CUST_CODE FROM CUSTOMER) "+
								"UNION "+
								"SELECT STRG_MEET.*,LOCALITY.DESCR LOC_DESCR, FIELDACTIVITY.ACTIVITY_TYPE ACT_TYPE, SCC.CLASS_CODE_DESCR, UPPER(CUST_NAME) AS SC_NAME, "+
								"STRG_MEET.STRG_TYPE AS CUST_TYPE, (CASE WHEN STRG_MEET.STRG_TYPE = 'D' THEN 1  WHEN STRG_MEET.STRG_TYPE = 'R' THEN 2  WHEN STRG_MEET.STRG_TYPE = 'M' "+
								"THEN 3 ELSE 4 END) AS CUST_TYPE_SEQ, SCT.DCR_GROUP AS DCR_GROUP, 0 AS NO_VISIT, SPL.DESCR AS SPL_DSCR,'LISTED' AS CUSTOMER_TYPE  "+
								"FROM CUSTOMER , SPRS_STOCKIST SS, FIELDACTIVITY, STRG_MEET  LEFT OUTER JOIN LOCALITY ON STRG_MEET.LOCALITY_CODE = LOCALITY.LOCALITY_CODE "+
								"LEFT OUTER JOIN SPRS_ACT_TRAN ON STRG_MEET.DCR_ID = SPRS_ACT_TRAN.DCR_ID LEFT OUTER JOIN STRG_CUST_CLASS SCC ON STRG_MEET.STRG_CLASS_CODE = SCC.CLASS_CODE "+
								"AND SCC.CUST_TYPE = STRG_MEET.STRG_TYPE "+
								"LEFT OUTER JOIN SPECIALITY SPL ON STRG_MEET.SPL_CODE = SPL.SPL_CODE "+
								"LEFT OUTER JOIN STRG_CUST_TYPE SCT ON STRG_MEET.STRG_TYPE = SCT.TYPE  WHERE STRG_MEET.EVENT_TYPE = FIELDACTIVITY.ACTIVITY_CODE "+
								"AND STRG_MEET.STRG_CODE = CUSTOMER.CUST_CODE AND SS.SPRS_CODE = STRG_MEET.SALES_PERS  AND SS.CUST_CODE = STRG_MEET.STRG_CODE "+
								"AND SS.ROUTE_ID = STRG_MEET.ROUTE_ID AND STRG_MEET.SALES_PERS = ? AND STRG_MEET.EVENT_DATE = ? "+
								"AND SCT.DCR_GROUP IN ('S') ORDER BY CUST_TYPE_SEQ";*/
									
						 sqlEdit="SELECT STRG_MEET.TRAN_ID,STRG_MEET.STRG_CODE,STRG_MEET.STRG_CLASS_CODE,STRG_MEET.DCR_ID,STRG_MEET.ROUTE_ID,STRG_MEET.SPRS_CODE__WW,STRG_MEET.OTH_PARTICIPANT,STRG_MEET.CONTACT_PERS,STRG_MEET.CONTACT_PERS_NAME,STRG_MEET.REG_NO,STRG_MEET.EVENT_TYPE,STRG_MEET.PLAN_CHG_REAS,STRG_MEET.CALL_OUTCOME,STRG_MEET.MEET_SUMM,STRG_MEET.REMARKS,STRG_MEET.EVENT_TIME_START,STRG_MEET.EVENT_TIME_END,STRG_MEET.SKU_VALUE,STRG_MEET.AMOUNT,STRG_MEET.NET_AMT,STRG_MEET.TAX_AMOUNT,STRG_MEET.ADDRESS_AS,STRG_MEET.MEMBER_PRESENT, " + 
						 		" LOCALITY.DESCR LOC_DESCR,FIELDACTIVITY.ACTIVITY_TYPE ACT_TYPE, SCC.CLASS_CODE_DESCR, STRG_CUSTOMER.FIRST_NAME||' '||STRG_CUSTOMER.MIDDLE_NAME||' '||STRG_CUSTOMER.LAST_NAME AS SC_NAME, " + 
								" STRG_MEET.STRG_TYPE AS CUST_TYPE,STRG_MEET.ADDR1,STRG_MEET.ADDR2,STRG_MEET.ADDR3,STRG_MEET.SALES_TYPE, " + 
								" SCT.DCR_GROUP AS DCR_GROUP, SPL.DESCR AS SPL_DSCR,'LISTED' AS CUSTOMER_TYPE , STRG_MEET.ROUTE_ID AS ROUTE_ID,SCT.DESCR  AS CUST_TYPE_DESCR " + 
								" FROM LOCALITY,SPRS_ACT_TRAN,STRG_CUSTOMER ,FIELDACTIVITY, STRG_MEET LEFT OUTER JOIN SPECIALITY SPL  ON  STRG_MEET.SPL_CODE = SPL.SPL_CODE " + 
								" LEFT OUTER JOIN STRG_CUST_CLASS SCC ON STRG_MEET.STRG_CLASS_CODE = SCC.CLASS_CODE " + 
								" AND SCC.CUST_TYPE = STRG_MEET.STRG_TYPE LEFT OUTER JOIN STRG_CUST_TYPE SCT ON STRG_MEET.STRG_TYPE = SCT.TYPE  " + 
								" WHERE STRG_MEET.EVENT_TYPE = FIELDACTIVITY.ACTIVITY_CODE  AND STRG_MEET.DCR_ID = SPRS_ACT_TRAN.DCR_ID AND STRG_MEET.STRG_CODE = STRG_CUSTOMER.SC_CODE  AND STRG_MEET.LOCALITY_CODE = LOCALITY.LOCALITY_CODE" + 
								" AND STRG_MEET.SALES_PERS = ? AND STRG_MEET.EVENT_DATE = ? AND SCT.DCR_GROUP IN ('C','D','O') " + 
								" UNION " + 
								" SELECT STRG_MEET.TRAN_ID,STRG_MEET.STRG_CODE,STRG_MEET.STRG_CLASS_CODE,STRG_MEET.DCR_ID,STRG_MEET.ROUTE_ID,STRG_MEET.SPRS_CODE__WW,STRG_MEET.OTH_PARTICIPANT,STRG_MEET.CONTACT_PERS,STRG_MEET.CONTACT_PERS_NAME,STRG_MEET.REG_NO,STRG_MEET.EVENT_TYPE,STRG_MEET.PLAN_CHG_REAS,STRG_MEET.CALL_OUTCOME,STRG_MEET.MEET_SUMM,STRG_MEET.REMARKS,STRG_MEET.EVENT_TIME_START,STRG_MEET.EVENT_TIME_END,STRG_MEET.SKU_VALUE,STRG_MEET.AMOUNT,STRG_MEET.NET_AMT,STRG_MEET.TAX_AMOUNT,STRG_MEET.ADDRESS_AS,STRG_MEET.MEMBER_PRESENT, " +
								" LOCALITY.DESCR LOC_DESCR,FIELDACTIVITY.ACTIVITY_TYPE ACT_TYPE,SCC.CLASS_CODE_DESCR, STRG_MEET.STRG_NAME AS SC_NAME, " + 
								" STRG_MEET.STRG_TYPE AS CUST_TYPE,STRG_MEET.ADDR1,STRG_MEET.ADDR2,STRG_MEET.ADDR3,STRG_MEET.SALES_TYPE,SCT.DCR_GROUP AS DCR_GROUP, SPL.DESCR AS SPL_DSCR,'UNLISTED' AS CUSTOMER_TYPE , STRG_MEET.ROUTE_ID AS ROUTE_ID,SCT.DESCR  AS CUST_TYPE_DESCR " + 
								" FROM FIELDACTIVITY,LOCALITY,SPRS_ACT_TRAN,STRG_MEET " + 
								" LEFT OUTER JOIN STRG_CUST_CLASS SCC ON STRG_MEET.STRG_CLASS_CODE = SCC.CLASS_CODE AND SCC.CUST_TYPE = STRG_MEET.STRG_TYPE " + 
								" LEFT OUTER JOIN SPECIALITY SPL ON STRG_MEET.SPL_CODE = SPL.SPL_CODE LEFT OUTER JOIN STRG_CUST_TYPE SCT ON STRG_MEET.STRG_TYPE = SCT.TYPE " + 
								" WHERE STRG_MEET.EVENT_TYPE = FIELDACTIVITY.ACTIVITY_CODE AND STRG_MEET.DCR_ID = SPRS_ACT_TRAN.DCR_ID  AND STRG_MEET.LOCALITY_CODE = LOCALITY.LOCALITY_CODE AND STRG_MEET.EVENT_DATE = ? AND STRG_MEET.SALES_PERS = ? " + 
								" AND  STRG_MEET.STRG_CODE IN("+UnlistedCode+") " + 
								" AND SCT.DCR_GROUP IN ('C','D','S','O') " + 
								" UNION " + 
								" SELECT STRG_MEET.TRAN_ID,STRG_MEET.STRG_CODE,STRG_MEET.STRG_CLASS_CODE,STRG_MEET.DCR_ID,STRG_MEET.ROUTE_ID,STRG_MEET.SPRS_CODE__WW,STRG_MEET.OTH_PARTICIPANT,STRG_MEET.CONTACT_PERS,STRG_MEET.CONTACT_PERS_NAME,STRG_MEET.REG_NO,STRG_MEET.EVENT_TYPE,STRG_MEET.PLAN_CHG_REAS,STRG_MEET.CALL_OUTCOME,STRG_MEET.MEET_SUMM,STRG_MEET.REMARKS,STRG_MEET.EVENT_TIME_START,STRG_MEET.EVENT_TIME_END,STRG_MEET.SKU_VALUE,STRG_MEET.AMOUNT,STRG_MEET.NET_AMT,STRG_MEET.TAX_AMOUNT,STRG_MEET.ADDRESS_AS,STRG_MEET.MEMBER_PRESENT, " +
								" LOCALITY.DESCR LOC_DESCR, FIELDACTIVITY.ACTIVITY_TYPE ACT_TYPE, SCC.CLASS_CODE_DESCR, CUST_NAME AS SC_NAME, " + 
								" STRG_MEET.STRG_TYPE AS CUST_TYPE,STRG_MEET.ADDR1,STRG_MEET.ADDR2,STRG_MEET.ADDR3,STRG_MEET.SALES_TYPE,SCT.DCR_GROUP AS DCR_GROUP,  SPL.DESCR AS SPL_DSCR,'LISTED' AS CUSTOMER_TYPE , STRG_MEET.ROUTE_ID AS ROUTE_ID,SCT.DESCR  AS CUST_TYPE_DESCR " + 
								" FROM CUSTOMER , LOCALITY,SPRS_ACT_TRAN,SPRS_STOCKIST SS, FIELDACTIVITY, STRG_MEET LEFT OUTER JOIN STRG_CUST_CLASS SCC ON STRG_MEET.STRG_CLASS_CODE = SCC.CLASS_CODE " + 
								" AND SCC.CUST_TYPE = STRG_MEET.STRG_TYPE " + 
								" LEFT OUTER JOIN SPECIALITY SPL ON STRG_MEET.SPL_CODE = SPL.SPL_CODE " + 
								" LEFT OUTER JOIN STRG_CUST_TYPE SCT ON STRG_MEET.STRG_TYPE = SCT.TYPE  WHERE STRG_MEET.EVENT_TYPE = FIELDACTIVITY.ACTIVITY_CODE " + 
								" AND STRG_MEET.STRG_CODE = CUSTOMER.CUST_CODE AND SS.SPRS_CODE = STRG_MEET.SALES_PERS  AND SS.CUST_CODE = STRG_MEET.STRG_CODE " + 
								" AND SS.ROUTE_ID = STRG_MEET.ROUTE_ID AND STRG_MEET.DCR_ID = SPRS_ACT_TRAN.DCR_ID  AND STRG_MEET.LOCALITY_CODE = LOCALITY.LOCALITY_CODE AND STRG_MEET.SALES_PERS = ? AND STRG_MEET.EVENT_DATE = ? " + 
								" AND SCT.DCR_GROUP IN ('S')";
																			
						pstmt =  conn.prepareStatement( sqlEdit );
						pstmt.setString(5, salesPers);
						pstmt.setTimestamp( 6, java.sql.Timestamp.valueOf( eventDateDBFmt ) );
								
						
					}
					else
					{
						// CHanges by Harion for Doctor not showing in summary when changed locality -- 04-Feb-2021   [Start]
						/*sqlEdit  ="SELECT STRG_MEET.*,LOCALITY.DESCR LOC_DESCR,FIELDACTIVITY.ACTIVITY_TYPE ACT_TYPE, SCC.CLASS_CODE_DESCR, "+    // Added by kailash 
							 	" UPPER(STRG_CUSTOMER.FIRST_NAME)||' '||UPPER(STRG_CUSTOMER.MIDDLE_NAME)||' '||UPPER(STRG_CUSTOMER.LAST_NAME) AS SC_NAME,"+ 
								" STRG_MEET.STRG_TYPE AS CUST_TYPE, "+ 
								" (CASE WHEN STRG_MEET.STRG_TYPE = 'D' THEN 1  WHEN STRG_MEET.STRG_TYPE='R' THEN 2  WHEN STRG_MEET.STRG_TYPE='M' THEN 3 ELSE 4 END) AS CUST_TYPE_SEQ, "+
								" SCT.DCR_GROUP AS DCR_GROUP,"// added by rupali on 21/12/18 for dcr_group related changes
								+ "SS.NO_VISIT,SPL.DESCR AS SPL_DSCR,'LISTED' AS CUSTOMER_TYPE "+ //Added by mrunalini to showing speciality no_visit on summary page
								" FROM SALES_PERS SAP,STRG_CUSTOMER ,STRG_SERIES SS LEFT OUTER JOIN SPECIALITY SPL ON SS.SPL_CODE=SPL.SPL_CODE,FIELDACTIVITY,STRG_MEET  "+
								" LEFT OUTER JOIN LOCALITY ON STRG_MEET.LOCALITY_CODE = LOCALITY.LOCALITY_CODE " +
								" LEFT OUTER JOIN SPRS_ACT_TRAN ON STRG_MEET.DCR_ID = SPRS_ACT_TRAN.DCR_ID  "+
								" LEFT OUTER JOIN STRG_CUST_CLASS SCC ON STRG_MEET.STRG_CLASS_CODE = SCC.CLASS_CODE"+ //Added by kailash
								" AND SCC.CUST_TYPE = STRG_MEET.STRG_TYPE  LEFT OUTER JOIN STRG_CUST_TYPE SCT ON STRG_MEET.STRG_TYPE = SCT.TYPE "+ // added by rupali on 21/12/18 for dcr_group related changes
								" WHERE STRG_MEET.EVENT_TYPE =FIELDACTIVITY.ACTIVITY_CODE "
								+ " AND STRG_MEET.STRG_CODE = STRG_CUSTOMER.SC_CODE "
								//+ " AND SS.SALES_PERS=STRG_MEET.SALES_PERS AND SS.SC_CODE=STRG_MEET.STRG_CODE AND SS.ROUTE_ID=STRG_MEET.ROUTE_ID "+
								+ " AND (SS.SALES_PERS = STRG_MEET.SALES_PERS OR SS.SALES_PERS = STRG_MEET.SPRS_CODE__WW) AND SS.SC_CODE=STRG_MEET.STRG_CODE AND SS.ROUTE_ID=STRG_MEET.ROUTE_ID "+
								" AND STRG_MEET.SALES_PERS = ? "+
								" AND STRG_MEET.EVENT_DATE = ? "+
								//" AND STRG_CUSTOMER.CUST_TYPE  IN ('C','D','S','O') " + // commentted by rupali on 21/12/18 for dcr_group related changes
								" AND SCT.DCR_GROUP IN ('C','D','S','O')  AND SAP.SALES_PERS=SS.SALES_PERS AND SAP.ITEM_SER=SS.ITEM_SER " + // added by rupali on 21/12/18 for dcr_group related changes
								//" AND (CASE WHEN SPRS_ACT_TRAN.CONFIRMED IS NULL THEN 'N' ELSE SPRS_ACT_TRAN.CONFIRMED END) ='N' "+ commented by mrunalini sinkar for DCR View Lik in claim expense
								//" AND SCC.CUST_TYPE = STRG_MEET.STRG_TYPE"+ //Added by kailash // commentted by rupali on 21/12/18 for dcr_group related changes
								" UNION "+
								" SELECT STRG_MEET.*,LOCALITY.DESCR LOC_DESCR,FIELDACTIVITY.ACTIVITY_TYPE ACT_TYPE,SCC.CLASS_CODE_DESCR, STRG_MEET.STRG_NAME AS SC_NAME, "+ //Added class code descr by kailash
								" STRG_MEET.STRG_TYPE AS CUST_TYPE, "+
								" (CASE WHEN STRG_MEET.STRG_TYPE = 'D' THEN 1  WHEN STRG_MEET.STRG_TYPE='R' THEN 2  WHEN STRG_MEET.STRG_TYPE='M' THEN 3 ELSE 4 END) AS CUST_TYPE_SEQ, "+
								" SCT.DCR_GROUP AS DCR_GROUP, "// added by rupali on 21/12/18 for dcr_group related changes
								+ " 0 AS NO_VISIT,SPL.DESCR AS SPL_DSCR,'UNLISTED' AS CUSTOMER_TYPE "+ //Added by mrunalini to showing speciality no_visit on summary page 
								" FROM FIELDACTIVITY,STRG_MEET "+
								" LEFT OUTER JOIN LOCALITY ON STRG_MEET.LOCALITY_CODE = LOCALITY.LOCALITY_CODE "+
								" LEFT OUTER JOIN SPRS_ACT_TRAN ON STRG_MEET.DCR_ID = SPRS_ACT_TRAN.DCR_ID "+
								" LEFT OUTER JOIN STRG_CUST_CLASS SCC ON STRG_MEET.STRG_CLASS_CODE = SCC.CLASS_CODE"+ //Added by kailash
								" AND SCC.CUST_TYPE = STRG_MEET.STRG_TYPE LEFT OUTER JOIN SPECIALITY SPL ON STRG_MEET.SPL_CODE=SPL.SPL_CODE  LEFT OUTER JOIN STRG_CUST_TYPE SCT ON STRG_MEET.STRG_TYPE = SCT.TYPE "+ // added by rupali on 21/12/18 for dcr_group related changes
								" WHERE STRG_MEET.EVENT_TYPE =FIELDACTIVITY.ACTIVITY_CODE "+
								" AND STRG_MEET.EVENT_DATE = ? "+
								" AND STRG_MEET.SALES_PERS = ? "+
								" AND  STRG_MEET.STRG_CODE NOT IN(SELECT SC_CODE FROM STRG_CUSTOMER) "+
								//" AND STRG_MEET.STRG_TYPE  IN ('C','D','S','O') "+ // commentted by rupali on 21/12/18 for dcr_group related changes
								" AND SCT.DCR_GROUP IN ('C','D','S','O') " + // added by rupali on 21/12/18 for dcr_group related changes
								//" AND SCC.CUST_TYPE = STRG_MEET.STRG_TYPE"+ // Added by kailash // commentted by rupali on 21/12/18 for dcr_group related changes
								" ORDER BY CUST_TYPE_SEQ ";*/
					
						
						 sqlEdit="SELECT STRG_MEET.TRAN_ID,STRG_MEET.STRG_CODE,STRG_MEET.STRG_CLASS_CODE,STRG_MEET.DCR_ID,STRG_MEET.ROUTE_ID,STRG_MEET.SPRS_CODE__WW,STRG_MEET.OTH_PARTICIPANT,STRG_MEET.CONTACT_PERS,STRG_MEET.CONTACT_PERS_NAME,STRG_MEET.REG_NO,STRG_MEET.EVENT_TYPE,STRG_MEET.PLAN_CHG_REAS,STRG_MEET.CALL_OUTCOME,STRG_MEET.MEET_SUMM,STRG_MEET.REMARKS,STRG_MEET.EVENT_TIME_START,STRG_MEET.EVENT_TIME_END,STRG_MEET.SKU_VALUE,STRG_MEET.AMOUNT,STRG_MEET.NET_AMT,STRG_MEET.TAX_AMOUNT,STRG_MEET.ADDRESS_AS,STRG_MEET.MEMBER_PRESENT, "+
						 		" LOCALITY.DESCR LOC_DESCR,FIELDACTIVITY.ACTIVITY_TYPE ACT_TYPE, SCC.CLASS_CODE_DESCR, " + 
								" STRG_CUSTOMER.FIRST_NAME||' '||STRG_CUSTOMER.LAST_NAME AS SC_NAME, " + 
								" STRG_MEET.STRG_TYPE AS CUST_TYPE,STRG_MEET.ADDR1,STRG_MEET.ADDR2,STRG_MEET.ADDR3,STRG_MEET.SALES_TYPE,  " + 
								" SCT.DCR_GROUP AS DCR_GROUP, " + 
								" SPL.DESCR AS SPL_DSCR, " + 
								" 'LISTED' AS CUSTOMER_TYPE , STRG_MEET.ROUTE_ID AS ROUTE_ID,SCT.DESCR  AS CUST_TYPE_DESCR " + 
								" FROM STRG_CUSTOMER ,LOCALITY,SPRS_ACT_TRAN,FIELDACTIVITY, " + 
								" STRG_MEET LEFT OUTER JOIN SPECIALITY SPL  ON STRG_MEET.SPL_CODE=SPL.SPL_CODE " + 
								" LEFT OUTER JOIN STRG_CUST_CLASS SCC ON STRG_MEET.STRG_CLASS_CODE = SCC.CLASS_CODE " + 
								" AND SCC.CUST_TYPE = STRG_MEET.STRG_TYPE  LEFT OUTER JOIN STRG_CUST_TYPE SCT ON STRG_MEET.STRG_TYPE = SCT.TYPE " + 
								" WHERE STRG_MEET.EVENT_TYPE =FIELDACTIVITY.ACTIVITY_CODE " + 
								" AND STRG_MEET.STRG_CODE = STRG_CUSTOMER.SC_CODE "+
								" AND STRG_MEET.LOCALITY_CODE = LOCALITY.LOCALITY_CODE " +
								" AND STRG_MEET.DCR_ID = SPRS_ACT_TRAN.DCR_ID "+
								" AND STRG_MEET.SALES_PERS = ? " + 
								" AND STRG_MEET.EVENT_DATE = ? " + 
								" AND SCT.DCR_GROUP IN ('C','D','S','O')  " + 
								" UNION " + 
								" SELECT STRG_MEET.TRAN_ID,STRG_MEET.STRG_CODE,STRG_MEET.STRG_CLASS_CODE,STRG_MEET.DCR_ID,STRG_MEET.ROUTE_ID,STRG_MEET.SPRS_CODE__WW,STRG_MEET.OTH_PARTICIPANT,STRG_MEET.CONTACT_PERS,STRG_MEET.CONTACT_PERS_NAME,STRG_MEET.REG_NO,STRG_MEET.EVENT_TYPE,STRG_MEET.PLAN_CHG_REAS,STRG_MEET.CALL_OUTCOME,STRG_MEET.MEET_SUMM,STRG_MEET.REMARKS,STRG_MEET.EVENT_TIME_START,STRG_MEET.EVENT_TIME_END,STRG_MEET.SKU_VALUE,STRG_MEET.AMOUNT,STRG_MEET.NET_AMT,STRG_MEET.TAX_AMOUNT,STRG_MEET.ADDRESS_AS,STRG_MEET.MEMBER_PRESENT, "+
								" LOCALITY.DESCR LOC_DESCR,FIELDACTIVITY.ACTIVITY_TYPE ACT_TYPE,SCC.CLASS_CODE_DESCR, STRG_MEET.STRG_NAME AS SC_NAME, " + 
								" STRG_MEET.STRG_TYPE AS CUST_TYPE,STRG_MEET.ADDR1,STRG_MEET.ADDR2,STRG_MEET.ADDR3,STRG_MEET.SALES_TYPE, " + 
								" SCT.DCR_GROUP AS DCR_GROUP, " + 
								" SPL.DESCR AS SPL_DSCR,'UNLISTED' AS CUSTOMER_TYPE , STRG_MEET.ROUTE_ID AS ROUTE_ID,SCT.DESCR  AS CUST_TYPE_DESCR " + 
								" FROM FIELDACTIVITY,LOCALITY,SPRS_ACT_TRAN,STRG_MEET " + 
								" LEFT OUTER JOIN STRG_CUST_CLASS SCC ON STRG_MEET.STRG_CLASS_CODE = SCC.CLASS_CODE " + 
								" AND SCC.CUST_TYPE = STRG_MEET.STRG_TYPE LEFT OUTER JOIN SPECIALITY SPL ON STRG_MEET.SPL_CODE=SPL.SPL_CODE " + 
								" LEFT OUTER JOIN STRG_CUST_TYPE SCT ON STRG_MEET.STRG_TYPE = SCT.TYPE " + 
								" WHERE STRG_MEET.EVENT_TYPE =FIELDACTIVITY.ACTIVITY_CODE " + 
								" AND STRG_MEET.LOCALITY_CODE = LOCALITY.LOCALITY_CODE " +
								" AND STRG_MEET.DCR_ID = SPRS_ACT_TRAN.DCR_ID "+
								" AND STRG_MEET.EVENT_DATE = ? " + 
								" AND STRG_MEET.SALES_PERS = ? " + 
								" AND  STRG_MEET.STRG_CODE IN("+UnlistedCode+") " + 
								" AND SCT.DCR_GROUP IN ('C','D','S','O')  " ;
				
						
						pstmt =  conn.prepareStatement( sqlEdit );
						
					}
				}
				
	
				
				String custWiseTeamSql = "SELECT EMP.EMP_CODE,UPPER(EMP.EMP_FNAME)||' '||UPPER(EMP.EMP_MNAME)||' '||UPPER(EMP.EMP_LNAME)||'('||TRIM(SMT.DESIGN_CODE)||')' AS EMP_NAME, " +
						" (CASE WHEN g.level_no NOT IN('4','3','2','1') THEN 'NSM' ELSE '' END) AS DESIGN_ID,TRIM(SMT.DESIGN_CODE) AS DESIGNATION " + 
						" FROM STRG_MEET_TEAM SMT, STRG_MEET, EMPLOYEE EMP,GRADE G " +
						" WHERE STRG_MEET.STRG_CODE=SMT.STRG_CODE AND EMP.GRADE=G.GRADE_CODE " +
						" AND SMT.SALES_PERS = EMP.EMP_CODE " +
						" AND SMT.DCR_ID = ? "+ 
						" AND STRG_MEET.EVENT_DATE= ? "+
						" AND STRG_MEET.SALES_PERS = ? "+
						" AND STRG_MEET.STRG_CODE = ? "+
						"AND SMT.DESIGN_CODE IS NOT NULL " +
						"UNION "+
						"SELECT '' AS EMP_CODE,UPPER(TRIM(SMT.MEMBER_NAME)) AS EMP_NAME, " +
						"'' AS DESIGN_ID,TRIM(SMT.DESIGN_CODE) AS DESIGNATION " + 
						" FROM STRG_MEET_TEAM SMT, STRG_MEET, EMPLOYEE EMP,GRADE G " +
						" WHERE STRG_MEET.STRG_CODE=SMT.STRG_CODE " +
						" AND SMT.DCR_ID = ? "+ 
						" AND STRG_MEET.EVENT_DATE= ? "+
						" AND STRG_MEET.SALES_PERS = ? "+
						" AND STRG_MEET.STRG_CODE = ? "+
						"AND SMT.DESIGN_CODE IS NULL ";  //Added by Bhagyashri T fr Lifscan Team subform[W21KJOH015]
				PreparedStatement pstmtTeam = conn.prepareStatement(custWiseTeamSql);
				//Added by Pooja S. on [30-DEC-2019] to show the coaching details  Start
				String custWiseCoachingSql = "SELECT LISTAGG( (SCM.DESCR || ' - ' || ( CASE WHEN SC.RESULT = 'Y' THEN 'Yes' WHEN SC.RESULT = 'N' THEN 'No' ELSE 'NA' END ) ), ', ' ) WITHIN GROUP (ORDER BY SC.RESULT DESC) COACHING_DET"
						+ " FROM SPRS_COACHING SC, STRG_MEET SM, SURVEY_MASTER SCM "
						+ "WHERE SM.STRG_CODE = SC.STRG_CODE AND SC.DCR_ID= SM.DCR_ID AND SC.SURVEY_CODE = SCM.SURVEY_CODE "
						+ "AND SC.DCR_ID = ? "
						+ "AND SM.EVENT_DATE= ?"
						+ "AND SM.SALES_PERS = ?"
						+ "AND SC.STRG_CODE = ?"
						+ "AND SCM.RESULT_TYPE <> 'A'ORDER BY SC.DCR_ID, SC.LINE_NO";

				PreparedStatement pstmtCoaching = conn.prepareStatement(custWiseCoachingSql);
				//Added by Pooja S. on [30-DEC-2019] to show the coaching details  End
				
				//pstmt =  conn.prepareStatement( sqlEdit );
				//Added by Bhgayashri t for Summary of Call reporting status[start]
				DecimalFormat dFormatter = new DecimalFormat("#.##");
				//Added by Bhgayashri t for Summary of Call reporting status[end]
				pstmt.setString(1, salesPers);
				pstmt.setTimestamp( 2, java.sql.Timestamp.valueOf( eventDateDBFmt ) );
				pstmt.setTimestamp( 3, java.sql.Timestamp.valueOf( eventDateDBFmt ) );
				pstmt.setString(4, salesPers);
				
				rs = pstmt.executeQuery();					
				ResultSet rsNoVis = null ;
				while(rs.next())
				{
						String genDescr = "";
					String tranId= "";
					String SPRS_CODE__WW="";
					String othParticipant="";
					//Added by bhagyashri t for Fotune for Contact pers changes[W21KFOR006]
					String contactPers="";
					String contactPersName="";
					String regNo="";
					leaveFlg= true;
					int noOfVis = 0;
					String actypeDB = checkNull(rs.getString("ACT_TYPE"));						
					String strgCode = checkNull(rs.getString("STRG_CODE"));
					String customerType = checkNull(rs.getString("CUSTOMER_TYPE"));
					String classCode=checkNull(rs.getString("STRG_CLASS_CODE"));
					String strgName=checkNull(rs.getString("SC_NAME")).toUpperCase();
					dcrId = checkNull(rs.getString("DCR_ID"));
					String custType = rs.getString("CUST_TYPE") == null ?"":rs.getString("CUST_TYPE");
					actTypeNew = actypeDB;
					String dcrGroup = checkNull(rs.getString("DCR_GROUP")); // added by rupali on 21/12/18 for dcr_group related changes
					String classCodeDescr=checkNull(rs.getString("CLASS_CODE_DESCR"));
					// CHanges by Harion for Doctor not showing in summary when changed locality -- 04-Feb-2021   [Start]
					String workRouteId=checkNull(rs.getString("ROUTE_ID"));
					SPRS_CODE__WW=checkNull(rs.getString("SPRS_CODE__WW"));
					othParticipant=checkNull(rs.getString("OTH_PARTICIPANT"));
					//Added By Bhagyashri T for Fortun changes [W21KFOR006]   
					contactPers=checkNull(rs.getString("CONTACT_PERS"));
					contactPersName=checkNull(rs.getString("CONTACT_PERS_NAME"));
					regNo=checkNull(rs.getString("REG_NO"));
					String custTypeDescr=checkNull(rs.getString("CUST_TYPE_DESCR"));
					String eventType=checkNull(rs.getString("EVENT_TYPE"));
			        String eventTypeDescr = checkNull(getActivityDescr(eventType, conn));
			        String addr1=checkNull(rs.getString("ADDR1"));
			        String addr2=checkNull(rs.getString("ADDR2"));
			        String addr3=checkNull(rs.getString("ADDR3"));
			        String salesType=checkNull(rs.getString("SALES_TYPE"));
			        tranId=checkNull(rs.getString("TRAN_ID"));
					//System.out.println("salesType ===="+salesType);
					//System.out.println("addr1 AS ===="+addr1);
	                    String genFldValue = this.checkNull(rs.getString("PLAN_CHG_REAS"));
	                    if (genFldValue != null && genFldValue.trim().length() > 0) {
	                        genDescr = checkNull(getDescrFromGenCodes("W_STRG_MEET_DCR_REALTIME_WIZ", "BEAT_CHG_REASON", genFldValue, conn));
	                    }
                   //Added by Bhgayashri t for Summary of Call reporting status[start]
	                String  strgState="";
	                String strgGstNo="";
                    String strgCdsql = "SELECT ST.DESCR AS STRG_STATE,SC.GST_NO AS STRG_GST_NO FROM STRG_CUSTOMER SC,STATE ST WHERE TRIM(SC.SC_CODE)=TRIM(?) AND SC.STATE_CODE=ST.STATE_CODE";
        			PreparedStatement pstmtSprs = conn.prepareStatement(strgCdsql);
        			pstmtSprs.setString(1, strgCode);
        			ResultSet rSet = pstmtSprs.executeQuery();
        			if(rSet.next())
        			{
        				strgState = checkNull(rSet.getString("STRG_STATE"));
        				strgGstNo = checkNull(rSet.getString("STRG_GST_NO"));
        			}
        			if(rSet!=null)
        			{
        				rSet.close();
        				rSet=null;
        			}
        			if(pstmtSprs!=null)
        			{
        				pstmtSprs.close();
        				pstmtSprs = null;

        			}
        			//Added by Bhgayashri t for Summary of Call reporting status[end]
					String noVisSql="SELECT no_visit FROM STRG_SERIES WHERE SALES_PERS= ? AND SC_CODE= ? AND ROUTE_ID= ?";
					pstmtNoOfVis = conn.prepareStatement(noVisSql);		

					if(SPRS_CODE__WW != null && SPRS_CODE__WW.trim().length() != 0)
					{
						pstmtNoOfVis.setString(1,SPRS_CODE__WW);
					}
					else
					{
						pstmtNoOfVis.setString(1,salesPers);
					}	
					pstmtNoOfVis.setString(2,strgCode);

					pstmtNoOfVis.setString(3,workRouteId);
					rsNoVis = pstmtNoOfVis.executeQuery();
					if (rsNoVis.next())
					{
						noOfVis = rsNoVis.getInt("NO_VISIT");
					}
					if ( rsNoVis != null )
					{
						rsNoVis.close();
						rsNoVis = null;
					}
					if ( pstmtNoOfVis != null )
					{
						pstmtNoOfVis.close();
						pstmtNoOfVis = null;
					}
					// CHanges by Harion for Doctor not showing in summary when changed locality -- 04-Feb-2021   [End]
					if(classCodeDescr==null || classCodeDescr.trim().length()==0)
					{
						classCodeDescr = getClassCodeDesc(classCode,custType,salesPers,conn);

					}
					System.out.println("noOfVis ===="+noOfVis);
					String teamDetails = "";
					pstmtTeam.setString(1, dcrId);
					pstmtTeam.setTimestamp( 2, java.sql.Timestamp.valueOf( eventDateDBFmt ) );
					pstmtTeam.setString(3, salesPers);
					pstmtTeam.setString(4, strgCode);
					pstmtTeam.setString(5, dcrId);
					pstmtTeam.setTimestamp( 6, java.sql.Timestamp.valueOf( eventDateDBFmt ) );
					pstmtTeam.setString(7, salesPers);
					pstmtTeam.setString(8, strgCode);
					ResultSet rsTeam = pstmtTeam.executeQuery();
					while(rsTeam.next())
					{
						String teamData = checkNull(rsTeam.getString("EMP_NAME"));
						String designId = checkNull(rsTeam.getString("DESIGN_ID"));
						String empCode = checkNull(rsTeam.getString("EMP_CODE"));
						String designCode = checkNull(rsTeam.getString("DESIGNATION"));
						System.out.println("designCode For Newly added member type :["+designCode+"]");
						//Added by Bhagyashri T fr Lifscan Team subform[W21KJOH015][start]
						if(designCode == null || designCode.trim().length() == 0 || "null".equalsIgnoreCase(designCode))
						{
							teamData = checkNull(rsTeam.getString("EMP_NAME"));
							System.out.println("teamData For Newly added member type :["+teamData+"]");
						}
						else
						{
							if("NSM".equalsIgnoreCase(designId) && !employeeDesignationMap.isEmpty())
							{
								if(employeeDesignationMap.containsKey(empCode))
								{
									String designation=employeeDesignationMap.get(empCode);
	
									teamData=teamData.substring(0, teamData.lastIndexOf("("));
									System.out.println("teamData before add designation : - "+teamData);
									teamData=teamData +"("+designation+")";
	
								}
								else
								{
									teamData = checkNull(rsTeam.getString("EMP_NAME"));
								}
							}
							else
							{
								teamData = checkNull(rsTeam.getString("EMP_NAME"));			
								
							}	
						}
						//Added by Bhagyashri T fr Lifscan Team subform[W21KJOH015][end]
						System.out.println("teamData after add designation :["+teamData+"]");
						if (teamDetails.trim().length() == 0)
						{
							teamDetails = teamData;
						}
						else
						{
							teamDetails = teamDetails +","+ teamData;
						}
					}
					pstmtTeam.clearParameters();
					if(rsTeam != null )
					{
						rsTeam.close();
						rsTeam = null;
					}
					//Added by Pooja S. on [30-DEC-2019] to show the coaching details  Start
					String coachingDetails = "";
					pstmtCoaching.setString(1, dcrId);
					pstmtCoaching.setTimestamp( 2, java.sql.Timestamp.valueOf( eventDateDBFmt ) );
					pstmtCoaching.setString(3, salesPers);
					pstmtCoaching.setString(4, strgCode);
					ResultSet rsCoaching = pstmtCoaching.executeQuery();
					while(rsCoaching.next())
					{
						String coachingData = checkNull(rsCoaching.getString("COACHING_DET"));
						if (coachingDetails.trim().length() == 0)
						{
							coachingDetails = coachingData;
						}
						else
						{
							coachingDetails = coachingDetails +","+ coachingData;
						}
					}

					pstmtCoaching.clearParameters();
					if(rsCoaching != null )
					{
						rsCoaching.close();
						rsCoaching = null;
					}
					System.out.println("coachingDetails :::: "+coachingDetails);
					//Added by Pooja S. on [30-DEC-2019] to show the coaching details  End
					// modified by rupali on 21/12/18 for dcr_group related changes
					//if("D".equalsIgnoreCase(custType) && !"PR".equalsIgnoreCase(actypeDB))
					if("D".equalsIgnoreCase(dcrGroup) && !"PR".equalsIgnoreCase(actypeDB))
					{
						valueXmlString.append( "<doctor domID='"+domID+"' selected = 'Y'>\r\n" );
						valueXmlString.append( "<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\"/>\r\n");
						valueXmlString.append( "<tran_id><![CDATA[" ).append(tranId).append( "]]></tran_id>\r\n");							
						valueXmlString.append( "<strg_code><![CDATA[" ).append( checkNull(rs.getString("STRG_CODE")).trim()).append( "]]></strg_code>\r\n");							
						if(strgName!=null && strgName.trim().length()>0)
						{
							valueXmlString.append( "<cust_name><![CDATA[" ).append( checkNull(rs.getString("SC_NAME"))).append( "]]></cust_name>\r\n");
						}
						else
						{
							valueXmlString.append( "<cust_name><![CDATA[" ).append("Unlisted Doctor Met").append( "]]></cust_name>\r\n");
							customerType="UNLISTED-DOCTOR";
						}
						valueXmlString.append( "<sales_pers><![CDATA[" ).append(checkNull(salesPers)).append( "]]></sales_pers>\r\n" );
						valueXmlString.append( "<event_date><![CDATA[" ).append(eventDate).append( "]]></event_date>\r\n" );				
						valueXmlString.append("<cust_type><![CDATA["+custType+"]]></cust_type>\r\n");														
						String callOutCome = checkNull(rs.getString("CALL_OUTCOME"));
						valueXmlString.append( "<call_outcome><![CDATA[" ).append(checkNull(callOutCome)).append( "]]></call_outcome>\r\n" );
						//Added By Mrunalini Sinkar For Fortune Server 20-May-2020(Start)
						if("Y".equalsIgnoreCase(isFortuneAct))
						{
							String meetingStatus="";
							String mettingSql="SELECT CALL_OUTCOME_DESCR FROM CALL_OUTCOME WHERE CALL_OUTCOME = ? AND ACTIVITY_CODE=? ";
							PreparedStatement meetPstmt =conn.prepareStatement(mettingSql);
							meetPstmt.setString(1, callOutCome);
							meetPstmt.setString(2, eventType);
							ResultSet meetRs=meetPstmt.executeQuery();
							if(meetRs.next())
							{
								meetingStatus=checkNull(meetRs.getString("CALL_OUTCOME_DESCR"));
							}
							if (meetRs!= null)
							{
								meetRs.close();
								meetRs = null;
							}
							if(meetPstmt!=null)
							{
								meetPstmt.close();
								meetPstmt = null;
							}
							valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append(meetingStatus).append( "]]></calloutcome_descr>\r\n" );

						}
						else
						{
							if(callOutCome.equalsIgnoreCase("4"))
							{
								valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Very Positive").append( "]]></calloutcome_descr>\r\n" );
							}
							else if(callOutCome.equalsIgnoreCase("3"))
							{
								valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Average").append( "]]></calloutcome_descr>\r\n" );
							}
							else if(callOutCome.equalsIgnoreCase("2"))
							{
								valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Below Average").append( "]]></calloutcome_descr>\r\n" );
							}
							else if(callOutCome.equalsIgnoreCase("1"))
							{
								valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Negative").append( "]]></calloutcome_descr>\r\n" );
							}
							else if(callOutCome.equalsIgnoreCase("0"))
							{
								valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Refused").append( "]]></calloutcome_descr>\r\n" );
							}
							else if(callOutCome.equalsIgnoreCase("5"))
							{
								valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Supporter").append( "]]></calloutcome_descr>\r\n" );
							}
							else if(callOutCome.equalsIgnoreCase("6"))
							{
								valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Believer").append( "]]></calloutcome_descr>\r\n" );
							}
							else if(callOutCome.equalsIgnoreCase("7"))
							{
								valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Non Believer").append( "]]></calloutcome_descr>\r\n" );
							}
							// added by rupali on 03/05/18 for display call outcame data in confirm and delete report [start]
							else if(callOutCome.equalsIgnoreCase("8"))
							{
								valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Obj. Not Met").append( "]]></calloutcome_descr>\r\n" );
							}
							else if(callOutCome.equalsIgnoreCase("9"))
							{
								valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Obj. Met").append( "]]></calloutcome_descr>\r\n" );
							}

						}
						//Added By Mrunalini Sinkar For Fortune Server 20-May-2020(End)

						// added by rupali on 03/05/18 for display call outcame data in confirm and delete report [end]
						//Added by kailsh on 23-feb-18 [Start] 
						valueXmlString.append( "<meet_summ><![CDATA[" ).append(rs.getString("MEET_SUMM")).append( "]]></meet_summ>\r\n" );
						valueXmlString.append( "<remarks><![CDATA[" ).append(checkNull(rs.getString("REMARKS"))).append( "]]></remarks>\r\n" );

						valueXmlString.append( "<strg_class_code><![CDATA[" ).append(checkNull(rs.getString("STRG_CLASS_CODE"))).append( "]]></strg_class_code>\r\n" );
						//Added by kailsh on 23-feb-18 [End]
						//Added by mrunalini to showing speciality no_visit on summary page(start)
						valueXmlString.append( "<event_time_start><![CDATA[" ).append(checkNull(rs.getString("EVENT_TIME_START"))).append( "]]></event_time_start>\r\n" );
						valueXmlString.append( "<event_time_end><![CDATA[" ).append(checkNull(rs.getString("EVENT_TIME_END"))).append( "]]></event_time_end>\r\n" );
						valueXmlString.append( "<pob_val><![CDATA[" ).append(checkNull(rs.getString("SKU_VALUE"))).append( "]]></pob_val>\r\n" );
						valueXmlString.append( "<customer_type><![CDATA[" ).append(customerType).append( "]]></customer_type>\r\n" );

						if("LISTED".equalsIgnoreCase(customerType))	
						{
							valueXmlString.append("<class_code_descr><![CDATA[" ).append(classCodeDescr).append( "]]></class_code_descr>\r\n" );
							valueXmlString.append("<spl_descr><![CDATA[" ).append(checkNull(rs.getString("SPL_DSCR"))).append( "]]></spl_descr>\r\n" );
							// CHanges by Harion for Doctor not showing in summary when changed locality -- 04-Feb-2021   [Start]
							//valueXmlString.append("<no_visit><![CDATA[" ).append(checkNull(rs.getString("NO_VISIT"))).append( "]]></no_visit>\r\n" );
							valueXmlString.append("<no_visit><![CDATA[" ).append(noOfVis).append( "]]></no_visit>\r\n" );
							// CHanges by Harion for Doctor not showing in summary when changed locality -- 04-Feb-2021   [End]
							valueXmlString.append("<locality_descr><![CDATA[" ).append( checkNull(rs.getString("LOC_DESCR")).trim()).append( "]]></locality_descr>\r\n");
						}
						else if(!"LISTED".equalsIgnoreCase(customerType) && !"Y".equalsIgnoreCase(isMemberPresnt))
						{
							valueXmlString.append("<locality_descr><![CDATA[" ).append( checkNull(rs.getString("LOC_DESCR")).trim()).append( "]]></locality_descr>\r\n");
						}
						//Added by mrunalini to showing speciality no_visit on summary page(end)
						valueXmlString.append("<team_details><![CDATA[" ).append( teamDetails ).append( "]]></team_details>\r\n" );
						//Added by Pooja S. on [30-DEC-2019] to show the coaching details  Start
						valueXmlString.append("<coaching_details><![CDATA[" ).append( coachingDetails ).append( "]]></coaching_details>\r\n" );
						valueXmlString.append("<host_url><![CDATA[" ).append(CommonConstants.TOMCAT_HOME).append( "]]></host_url>\r\n" );
						valueXmlString.append( "<member_present><![CDATA[" ).append(checkNull(rs.getString("MEMBER_PRESENT"))).append( "]]></member_present>\r\n" );
						valueXmlString.append("<collection_form_no><![CDATA[" ).append("collection").append( "]]></collection_form_no>\r\n" );
						valueXmlString.append("<item_form_no><![CDATA[" ).append("doctorsampleitem").append( "]]></item_form_no>\r\n" );
						valueXmlString.append("<brand_form_no><![CDATA[" ).append("brand").append( "]]></brand_form_no>\r\n" );
						valueXmlString.append("<display_form_no><![CDATA[" ).append("display").append( "]]></display_form_no>\r\n" );
						valueXmlString.append("<survey_form_no><![CDATA[" ).append("survey").append( "]]></survey_form_no>\r\n" );
						valueXmlString.append("<prescription_form_no><![CDATA[" ).append("surveybrand").append( "]]></prescription_form_no>\r\n" );
						valueXmlString.append("<hide_unlisted><![CDATA[" ).append(isMemberPresnt).append( "]]></hide_unlisted>\r\n" );
						valueXmlString.append("<oth_participant><![CDATA[" ).append(othParticipant).append( "]]></oth_participant>\r\n" );
						valueXmlString.append("<contact_pers><![CDATA[" ).append(contactPers).append( "]]></contact_pers>\r\n" );//Added by Bhagyashri To Add EUIN no and conatact_pers_name[23/02/22]
						valueXmlString.append("<contact_pers_name><![CDATA[" ).append(contactPersName).append( "]]></contact_pers_name>\r\n" );//Added by Bhagyashri To Add EUIN no and conatact_pers_name[23/02/22]
						valueXmlString.append("<reg_no><![CDATA[" ).append(regNo).append( "]]></reg_no>\r\n" );
						valueXmlString.append("<cust_type_descr><![CDATA[" ).append(custTypeDescr).append( "]]></cust_type_descr>\r\n" );
						valueXmlString.append("<event_type_descr><![CDATA[" ).append(eventTypeDescr).append( "]]></event_type_descr>\r\n" );
						valueXmlString.append("<dcr_group><![CDATA[" ).append(dcrGroup).append( "]]></dcr_group>\r\n" );
	                    valueXmlString.append("<plan_chg_reason_descr><![CDATA[").append(genDescr).append("]]></plan_chg_reason_descr>\r\n");
	                    String totalamount =  checkNull(rs.getString("AMOUNT")) ;
						//System.out.println("inside the summary sql totalamount::::::["+totalamount+"]");
						String taxAmount =  checkNull(rs.getString("TAX_AMOUNT")) ;
						//System.out.println("inside the summary sql taxAmount::::::["+taxAmount+"]");
						String netAmount =  checkNull(rs.getString("NET_AMT")) ;
						//System.out.println("inside the summary sql netAmount::::::["+netAmount+"]");
						String addrAs =  checkNull(rs.getString("ADDRESS_AS")) ;
						//System.out.println("inside the summary sql addrAs::::::["+addrAs+"]");
						double amt =0d;
						double totamt =0d;
						double invamt =0d;
						double invoiceAmount =0d;
						double rndOff =0d;
						String invoicAmount ="";
						String roundOff ="";
						double sgstamt =0d;
						double sgstAmt =0d;
						String sgstAmount ="",amtInWord="";
						String cgstAmount ="";
						if(totalamount!=null && totalamount.trim().length()>0)
						{
						  amt=Double.parseDouble(totalamount);
						  invoiceAmount=Math.round(amt);
						  invoicAmount=Double.toString(invoiceAmount);
						  invoicAmount=invoicAmount.replaceAll("\\.\\d+$", "");
						}
						//System.out.println("inside the summary sql invoicAmount::::::["+invoicAmount+"]");
						//System.out.println("inside the summary sql totalamount::::::["+totalamount+"]");
						if(invoicAmount!=null && invoicAmount.trim().length()>0 && totalamount!=null && totalamount.trim().length()>0)
						{
						  totamt=Double.parseDouble(totalamount);
						  invamt=Double.parseDouble(invoicAmount);
						  //System.out.println("inside the summary sql totamt::::::["+totamt+"]");
							//System.out.println("inside the summary sql invamt::::::["+invamt+"]");
						  rndOff=(invamt-totamt);
						  //System.out.println("inside the summary sql rndOff11::::::["+rndOff+"]");
						  roundOff=dFormatter.format(rndOff);
						 // System.out.println("inside the summary sql after Format an ::::::["+roundOff+"]");
						  invoicAmount.replaceAll("\\.\\d+$", "");
						  //System.out.println("inside the summary sql rounded in an::::::["+invoicAmount+"]");
						  long lngAmt=Long.parseLong(invoicAmount);
						  //System.out.println("inside the summary sql lngAmt::::::["+lngAmt+"]");
						  amtInWord = dcb.convert(lngAmt);
						  //System.out.println("inside the summary After Convert string to long and string AMT::::::["+amtInWord+"]");
						}
						if(taxAmount!=null && taxAmount.trim().length()>0)
						{
							sgstamt=Double.parseDouble(taxAmount);
							sgstAmt=(sgstamt/2);
							sgstAmount=Double.toString(sgstAmt);
							cgstAmount =sgstAmount;
						}
						valueXmlString.append( "<net_amt><![CDATA[" ).append(netAmount).append( "]]></net_amt>\r\n" );//Added by bhagayshri to set total on edit mode
						valueXmlString.append( "<tax_amount><![CDATA[" ).append(taxAmount ).append( "]]></tax_amount>\r\n" );//Added by bhagayshri to set total on edit mode
						valueXmlString.append( "<amount><![CDATA[" ).append(totalamount ).append( "]]></amount>\r\n" );//Added by bhagayshri to set total on edit mode
						valueXmlString.append( "<invoice_amount><![CDATA[" ).append(invoicAmount).append( "]]></invoice_amount>\r\n" ); 
						valueXmlString.append( "<total_sgst_amt><![CDATA[" ).append( sgstAmount).append( "]]></total_sgst_amt>\r\n" ); 
						valueXmlString.append( "<total_cgst_amt><![CDATA[" ).append( cgstAmount).append( "]]></total_cgst_amt>\r\n" ); 
						valueXmlString.append( "<strg_gst_no><![CDATA[" ).append(strgGstNo ).append( "]]></strg_gst_no>\r\n" ); 
						valueXmlString.append( "<strg_state><![CDATA[" ).append(strgState ).append( "]]></strg_state>\r\n" );
						valueXmlString.append( "<address_as><![CDATA[" ).append( addrAs).append( "]]></address_as>\r\n" );
						valueXmlString.append( "<addr1><![CDATA[" ).append( addr1).append( "]]></addr1>\r\n" ); 
						valueXmlString.append( "<addr2><![CDATA[" ).append( addr2).append( "]]></addr2>\r\n" ); 
						valueXmlString.append( "<addr3><![CDATA[" ).append( addr3).append( "]]></addr3>\r\n" );
						valueXmlString.append( "<sales_type><![CDATA[" ).append( salesType).append( "]]></sales_type>\r\n" );
						valueXmlString.append( "<round_off><![CDATA[" ).append( roundOff).append( "]]></round_off>\r\n" );
						valueXmlString.append( "<amount_in_word><![CDATA[" ).append( amtInWord).append( "]]></amount_in_word>\r\n" );
						valueXmlString.append( "</doctor>\r\n" );


					}
					// modified by rupali on 21/12/18 for dcr_group related changes
					//else if("C".equalsIgnoreCase(custType) && !"PR".equalsIgnoreCase(actypeDB))
					else if("C".equalsIgnoreCase(dcrGroup) && !"PR".equalsIgnoreCase(actypeDB))
					{
						//valueXmlString.append( "<RetailData domID='"+domID+"' selected = 'Y'>\r\n" );
						valueXmlString.append( "<retailer domID='"+domID+"' selected = 'Y'>\r\n" );
						valueXmlString.append( "<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\"/>\r\n");
						valueXmlString.append( "<tran_id><![CDATA[" ).append(tranId).append( "]]></tran_id>\r\n");
						valueXmlString.append( "<strg_code><![CDATA[" ).append( checkNull(rs.getString("STRG_CODE")).trim()).append( "]]></strg_code>\r\n");							

						if(strgName!=null && strgName.trim().length()>0)
						{
							valueXmlString.append( "<cust_name><![CDATA[" ).append( checkNull(rs.getString("SC_NAME"))).append( "]]></cust_name>\r\n");
						}
						else
						{
							valueXmlString.append( "<cust_name><![CDATA[" ).append("No of Chemists").append( "]]></cust_name>\r\n");
							customerType="UNLISTED-CHEMIST";

						}
						valueXmlString.append( "<sales_pers><![CDATA[" ).append(checkNull(salesPers)).append( "]]></sales_pers>\r\n" );
						valueXmlString.append( "<event_date><![CDATA[" ).append(eventDate).append( "]]></event_date>\r\n" );				
						valueXmlString.append( "<cust_type><![CDATA["+custType+"]]></cust_type>\r\n");														
						if("LISTED".equalsIgnoreCase(customerType))	
						{
							valueXmlString.append("<locality_descr><![CDATA[" ).append( checkNull(rs.getString("LOC_DESCR")).trim()).append( "]]></locality_descr>\r\n");
						}
						else if(!"LISTED".equalsIgnoreCase(customerType) && !"Y".equalsIgnoreCase(isMemberPresnt))
						{
							valueXmlString.append( "<locality_descr><![CDATA[" ).append( checkNull(rs.getString("LOC_DESCR")).trim()).append( "]]></locality_descr>\r\n");
						}
						valueXmlString.append( "<sku_value><![CDATA[" ).append( checkNull(rs.getString("SKU_VALUE")).trim()).append( "]]></sku_value>\r\n");


						String callOutCome = checkNull(rs.getString("CALL_OUTCOME"));
						valueXmlString.append( "<call_outcome><![CDATA[" ).append(checkNull(callOutCome)).append( "]]></call_outcome>\r\n" );
						//Added By Mrunalini Sinkar For Fortune Server 20-May-2020(Start)
						if("Y".equalsIgnoreCase(isFortuneAct))
						{
							String meetingStatus="";
							String mettingSql="SELECT CALL_OUTCOME_DESCR FROM CALL_OUTCOME WHERE CALL_OUTCOME = ? AND ACTIVITY_CODE=? ";
							PreparedStatement meetPstmt =conn.prepareStatement(mettingSql);
							meetPstmt.setString(1, callOutCome);
							meetPstmt.setString(2, eventType);
							ResultSet meetRs=meetPstmt.executeQuery();
							if(meetRs.next())
							{
								meetingStatus=checkNull(meetRs.getString("CALL_OUTCOME_DESCR"));
							}
							if (meetRs!= null)
							{
								meetRs.close();
								meetRs = null;
							}
							if(meetPstmt!=null)
							{
								meetPstmt.close();
								meetPstmt = null;
							}
							valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append(meetingStatus).append( "]]></calloutcome_descr>\r\n" );

						}
						else
						{
							if(callOutCome.equalsIgnoreCase("4"))
							{
								valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Very Positive").append( "]]></calloutcome_descr>\r\n" );
							}
							else if(callOutCome.equalsIgnoreCase("3"))
							{
								valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Average").append( "]]></calloutcome_descr>\r\n" );
							}
							else if(callOutCome.equalsIgnoreCase("2"))
							{
								valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Below Average").append( "]]></calloutcome_descr>\r\n" );
							}
							else if(callOutCome.equalsIgnoreCase("1"))
							{
								valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Negative").append( "]]></calloutcome_descr>\r\n" );
							}
							else if(callOutCome.equalsIgnoreCase("0"))
							{
								valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Refused").append( "]]></calloutcome_descr>\r\n" );
							}
							else if(callOutCome.equalsIgnoreCase("5"))
							{
								valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Supporter").append( "]]></calloutcome_descr>\r\n" );
							}
							else if(callOutCome.equalsIgnoreCase("6"))
							{
								valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Believer").append( "]]></calloutcome_descr>\r\n" );
							}
							else if(callOutCome.equalsIgnoreCase("7"))
							{
								valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Non Believer").append( "]]></calloutcome_descr>\r\n" );
							}
							// added by rupali on 03/05/18 for display call outcame data in confirm and delete report [start]
							else if(callOutCome.equalsIgnoreCase("8"))
							{
								valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Obj. Not Met").append( "]]></calloutcome_descr>\r\n" );
							}
							else if(callOutCome.equalsIgnoreCase("9"))
							{
								valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Obj. Met").append( "]]></calloutcome_descr>\r\n" );
							}

						}
						//Added By Mrunalini Sinkar For Fortune Server 20-May-2020(End)
						//Added by kailsh on 23-feb-18 [Start]
						valueXmlString.append( "<meet_summ><![CDATA[" ).append(rs.getString("MEET_SUMM")).append( "]]></meet_summ>\r\n" );
						valueXmlString.append( "<strg_class_code><![CDATA[" ).append(checkNull(rs.getString("STRG_CLASS_CODE"))).append( "]]></strg_class_code>\r\n" );
						valueXmlString.append( "<class_code_descr><![CDATA[" ).append(classCodeDescr).append( "]]></class_code_descr>\r\n" );
						valueXmlString.append("<spl_descr><![CDATA[" ).append(checkNull(rs.getString("SPL_DSCR"))).append( "]]></spl_descr>\r\n" );//Added by mrunalini sinkar for showing speciality
						valueXmlString.append( "<event_time_start><![CDATA[" ).append(rs.getString("EVENT_TIME_START")).append( "]]></event_time_start>\r\n" );
						valueXmlString.append( "<event_time_end><![CDATA[" ).append(rs.getString("EVENT_TIME_END")).append( "]]></event_time_end>\r\n" );
						valueXmlString.append( "<pob_val><![CDATA[" ).append(checkNull(rs.getString("SKU_VALUE"))).append( "]]></pob_val>\r\n" );
						valueXmlString.append( "<customer_type><![CDATA[" ).append(customerType).append( "]]></customer_type>\r\n" );
						valueXmlString.append( "<member_present><![CDATA[" ).append(checkNull(rs.getString("MEMBER_PRESENT"))).append( "]]></member_present>\r\n" );
						valueXmlString.append( "<remarks><![CDATA[" ).append(checkNull(rs.getString("REMARKS"))).append( "]]></remarks>\r\n" );

						valueXmlString.append("<collection_form_no><![CDATA[" ).append("retailercollection").append( "]]></collection_form_no>\r\n" );
						valueXmlString.append("<item_form_no><![CDATA[" ).append("retailersampleitem").append( "]]></item_form_no>\r\n" );
						valueXmlString.append("<brand_form_no><![CDATA[" ).append("retailerbrand").append( "]]></brand_form_no>\r\n" );
						valueXmlString.append("<display_form_no><![CDATA[" ).append("retailerdisplay").append( "]]></display_form_no>\r\n" );
						valueXmlString.append("<survey_form_no><![CDATA[" ).append("retailersurvey").append( "]]></survey_form_no>\r\n" );
						//Added by kailsh on 23-feb-18 [End]
						//valueXmlString.append( "</RetailData>\r\n" );
						valueXmlString.append( "<team_details><![CDATA[" ).append( teamDetails ).append( "]]></team_details>\r\n" );
						//Added by Pooja S. on [30-DEC-2019] to show the coaching details  Start
						valueXmlString.append("<coaching_details><![CDATA[" ).append( coachingDetails ).append( "]]></coaching_details>\r\n" );
						valueXmlString.append("<host_url><![CDATA[" ).append(CommonConstants.TOMCAT_HOME).append( "]]></host_url>\r\n" );
						valueXmlString.append("<hide_unlisted><![CDATA[" ).append(isMemberPresnt).append( "]]></hide_unlisted>\r\n" );
						valueXmlString.append("<oth_participant><![CDATA[" ).append(othParticipant).append( "]]></oth_participant>\r\n" );
						valueXmlString.append("<contact_pers><![CDATA[" ).append(contactPers).append( "]]></contact_pers>\r\n" );//Added by Bhagyashri To Add EUIN no and conatact_pers_name[23/02/22]
						valueXmlString.append("<contact_pers_name><![CDATA[" ).append(contactPersName).append( "]]></contact_pers_name>\r\n" );//Added by Bhagyashri To Add EUIN no and conatact_pers_name[23/02/22]
						valueXmlString.append("<reg_no><![CDATA[" ).append(regNo).append( "]]></reg_no>\r\n" );							
						valueXmlString.append("<cust_type_descr><![CDATA[" ).append(custTypeDescr).append( "]]></cust_type_descr>\r\n" );
						valueXmlString.append( "<event_type_descr><![CDATA[" ).append(eventTypeDescr).append( "]]></event_type_descr>\r\n" );
						valueXmlString.append("<dcr_group><![CDATA[" ).append(dcrGroup).append( "]]></dcr_group>\r\n" );
	                     valueXmlString.append("<plan_chg_reason_descr><![CDATA[").append(genDescr).append("]]></plan_chg_reason_descr>\r\n");
	                     String totalamount =  checkNull(rs.getString("AMOUNT")) ;
							//System.out.println("inside the summary sql totalamount::::::["+totalamount+"]");
							String taxAmount =  checkNull(rs.getString("TAX_AMOUNT")) ;
							//System.out.println("inside the summary sql taxAmount::::::["+taxAmount+"]");
							String netAmount =  checkNull(rs.getString("NET_AMT")) ;
							//System.out.println("inside the summary sql netAmount::::::["+netAmount+"]");
							String addrAs =  checkNull(rs.getString("ADDRESS_AS")) ;
							//System.out.println("inside the summary sql addrAs::::::["+addrAs+"]");
							double amt =0d;
							double totamt =0d;
							double invamt =0d;
							double invoiceAmount =0d;
							double rndOff =0d;
							String invoicAmount ="";
							String roundOff ="";
							double sgstamt =0d;
							double sgstAmt =0d;
							String sgstAmount ="",amtInWord="";
							String cgstAmount ="";
							if(totalamount!=null && totalamount.trim().length()>0)
							{
							  amt=Double.parseDouble(totalamount);
							  invoiceAmount=Math.round(amt);
							  invoicAmount=Double.toString(invoiceAmount);
							  invoicAmount=invoicAmount.replaceAll("\\.\\d+$", "");
							}
							//System.out.println("inside the summary sql invoicAmount::::::["+invoicAmount+"]");
							//System.out.println("inside the summary sql totalamount::::::["+totalamount+"]");
							if(invoicAmount!=null && invoicAmount.trim().length()>0 && totalamount!=null && totalamount.trim().length()>0)
							{
							  totamt=Double.parseDouble(totalamount);
							  invamt=Double.parseDouble(invoicAmount);
							  //System.out.println("inside the summary sql totamt::::::["+totamt+"]");
								//System.out.println("inside the summary sql invamt::::::["+invamt+"]");
							  rndOff=(invamt-totamt);
							  //System.out.println("inside the summary sql rndOff11::::::["+rndOff+"]");
							  roundOff=dFormatter.format(rndOff);
							 // System.out.println("inside the summary sql after Format an ::::::["+roundOff+"]");
							  invoicAmount.replaceAll("\\.\\d+$", "");
							  //System.out.println("inside the summary sql rounded in an::::::["+invoicAmount+"]");
							  long lngAmt=Long.parseLong(invoicAmount);
							  //System.out.println("inside the summary sql lngAmt::::::["+lngAmt+"]");
							  amtInWord = dcb.convert(lngAmt);
							  //System.out.println("inside the summary After Convert string to long and string AMT::::::["+amtInWord+"]");
							}
							if(taxAmount!=null && taxAmount.trim().length()>0)
							{
								sgstamt=Double.parseDouble(taxAmount);
								sgstAmt=(sgstamt/2);
								sgstAmount=Double.toString(sgstAmt);
								cgstAmount =sgstAmount;
							}
							valueXmlString.append( "<net_amt><![CDATA[" ).append(netAmount).append( "]]></net_amt>\r\n" );//Added by bhagayshri to set total on edit mode
							valueXmlString.append( "<tax_amount><![CDATA[" ).append(taxAmount ).append( "]]></tax_amount>\r\n" );//Added by bhagayshri to set total on edit mode
							valueXmlString.append( "<amount><![CDATA[" ).append(totalamount ).append( "]]></amount>\r\n" );//Added by bhagayshri to set total on edit mode
							valueXmlString.append( "<invoice_amount><![CDATA[" ).append(invoicAmount).append( "]]></invoice_amount>\r\n" ); 
							valueXmlString.append( "<total_sgst_amt><![CDATA[" ).append( sgstAmount).append( "]]></total_sgst_amt>\r\n" ); 
							valueXmlString.append( "<total_cgst_amt><![CDATA[" ).append( cgstAmount).append( "]]></total_cgst_amt>\r\n" ); 
							valueXmlString.append( "<strg_gst_no><![CDATA[" ).append(strgGstNo ).append( "]]></strg_gst_no>\r\n" ); 
							valueXmlString.append( "<strg_state><![CDATA[" ).append(strgState ).append( "]]></strg_state>\r\n" );
							valueXmlString.append( "<address_as><![CDATA[" ).append( addrAs).append( "]]></address_as>\r\n" );
							valueXmlString.append( "<addr1><![CDATA[" ).append( addr1).append( "]]></addr1>\r\n" ); 
							valueXmlString.append( "<addr2><![CDATA[" ).append( addr2).append( "]]></addr2>\r\n" ); 
							valueXmlString.append( "<addr3><![CDATA[" ).append( addr3).append( "]]></addr3>\r\n" );
							valueXmlString.append( "<sales_type><![CDATA[" ).append( salesType).append( "]]></sales_type>\r\n" );
							valueXmlString.append( "<round_off><![CDATA[" ).append( roundOff).append( "]]></round_off>\r\n" );
							valueXmlString.append( "<amount_in_word><![CDATA[" ).append( amtInWord).append( "]]></amount_in_word>\r\n" );
						valueXmlString.append( "</retailer>\r\n" );
					}
					//else if("M".equalsIgnoreCase(custType))
					// modified by rupali on 21/12/18 for dcr_group related changes
					//else if("S".equalsIgnoreCase(custType) && !"PR".equalsIgnoreCase(actypeDB))
					else if("S".equalsIgnoreCase(dcrGroup) && !"PR".equalsIgnoreCase(actypeDB))
					{
						//valueXmlString.append( "<MerchData domID='"+domID+"' selected = 'Y'>\r\n" );
						valueXmlString.append( "<StockData domID='"+domID+"' selected = 'Y'>\r\n" );
						valueXmlString.append( "<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\"/>\r\n");
						valueXmlString.append( "<tran_id><![CDATA[" ).append(tranId).append( "]]></tran_id>\r\n");
						valueXmlString.append( "<strg_code><![CDATA[" ).append( checkNull(rs.getString("STRG_CODE")).trim()).append( "]]></strg_code>\r\n");							
						if(strgName!=null && strgName.trim().length()>0)
						{
							valueXmlString.append( "<cust_name><![CDATA[" ).append( checkNull(rs.getString("SC_NAME"))).append( "]]></cust_name>\r\n");
						}
						else
						{
							valueXmlString.append( "<cust_name><![CDATA[" ).append("Stockist Details").append( "]]></cust_name>\r\n");
							customerType="UNLISTED-STOCKIST";
						}														
						valueXmlString.append( "<sales_pers><![CDATA[" ).append(checkNull(salesPers)).append( "]]></sales_pers>\r\n" );
						valueXmlString.append( "<event_date><![CDATA[" ).append(eventDate).append( "]]></event_date>\r\n" );				
						valueXmlString.append( "<locality_descr><![CDATA[" ).append( checkNull(rs.getString("LOC_DESCR")).trim()).append( "]]></locality_descr>\r\n");
						valueXmlString.append("<cust_type><![CDATA["+custType+"]]></cust_type>\r\n");
						//added by Mrunalini Sinkar on 2-may-2017 to show call outcome details of stockist(strat)
						String callOutCome = checkNull(rs.getString("CALL_OUTCOME"));
						valueXmlString.append( "<call_outcome><![CDATA[" ).append(checkNull(callOutCome)).append( "]]></call_outcome>\r\n" );
						//Added By Mrunalini Sinkar For Fortune Server 20-May-2020(Start)
						if("Y".equalsIgnoreCase(isFortuneAct))
						{
							String meetingStatus="";
							String mettingSql="SELECT CALL_OUTCOME_DESCR FROM CALL_OUTCOME WHERE CALL_OUTCOME = ? AND ACTIVITY_CODE=? ";
							PreparedStatement meetPstmt =conn.prepareStatement(mettingSql);
							meetPstmt.setString(1, callOutCome);
							meetPstmt.setString(2, eventType);
							ResultSet meetRs=meetPstmt.executeQuery();
							if(meetRs.next())
							{
								meetingStatus=checkNull(meetRs.getString("CALL_OUTCOME_DESCR"));
							}
							if (meetRs!= null)
							{
								meetRs.close();
								meetRs = null;
							}
							if(meetPstmt!=null)
							{
								meetPstmt.close();
								meetPstmt = null;
							}
							valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append(meetingStatus).append( "]]></calloutcome_descr>\r\n" );

						}
						else
						{
							if(callOutCome.equalsIgnoreCase("4"))
							{
								valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Very Positive").append( "]]></calloutcome_descr>\r\n" );
							}
							else if(callOutCome.equalsIgnoreCase("3"))
							{
								valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Average").append( "]]></calloutcome_descr>\r\n" );
							}
							else if(callOutCome.equalsIgnoreCase("2"))
							{
								valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Below Average").append( "]]></calloutcome_descr>\r\n" );
							}
							else if(callOutCome.equalsIgnoreCase("1"))
							{
								valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Negative").append( "]]></calloutcome_descr>\r\n" );
							}
							else if(callOutCome.equalsIgnoreCase("0"))
							{
								valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Refused").append( "]]></calloutcome_descr>\r\n" );
							}
							else if(callOutCome.equalsIgnoreCase("5"))
							{
								valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Supporter").append( "]]></calloutcome_descr>\r\n" );
							}
							else if(callOutCome.equalsIgnoreCase("6"))
							{
								valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Believer").append( "]]></calloutcome_descr>\r\n" );
							}
							else if(callOutCome.equalsIgnoreCase("7"))
							{
								valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Non Believer").append( "]]></calloutcome_descr>\r\n" );
							}
							// added by rupali on 03/05/18 for display call outcame data in confirm and delete report [start]
							else if(callOutCome.equalsIgnoreCase("8"))
							{
								valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Obj. Not Met").append( "]]></calloutcome_descr>\r\n" );
							}
							else if(callOutCome.equalsIgnoreCase("9"))
							{
								valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Obj. Met").append( "]]></calloutcome_descr>\r\n" );
							}

						}
						//Added By Mrunalini Sinkar For Fortune Server 20-May-2020(End)
						//Added by kailsh on 23-feb-18 [Start]
						valueXmlString.append( "<meet_summ><![CDATA[" ).append(rs.getString("MEET_SUMM")).append( "]]></meet_summ>\r\n" );
						valueXmlString.append( "<event_time_start><![CDATA[" ).append(rs.getString("EVENT_TIME_START")).append( "]]></event_time_start>\r\n" );
						valueXmlString.append( "<event_time_end><![CDATA[" ).append(rs.getString("EVENT_TIME_END")).append( "]]></event_time_end>\r\n" );
						valueXmlString.append( "<pob_val><![CDATA[" ).append(checkNull(rs.getString("SKU_VALUE"))).append( "]]></pob_val>\r\n" );
						valueXmlString.append( "<customer_type><![CDATA[" ).append(customerType).append( "]]></customer_type>\r\n" );
						valueXmlString.append( "<remarks><![CDATA[" ).append(checkNull(rs.getString("REMARKS"))).append( "]]></remarks>\r\n" );

						valueXmlString.append( "<strg_class_code><![CDATA[" ).append(checkNull(rs.getString("STRG_CLASS_CODE"))).append( "]]></strg_class_code>\r\n" );
						valueXmlString.append( "<class_code_descr><![CDATA[" ).append(classCodeDescr).append( "]]></class_code_descr>\r\n" );
						valueXmlString.append("<spl_descr><![CDATA[" ).append(checkNull(rs.getString("SPL_DSCR"))).append( "]]></spl_descr>\r\n" );//Added by mrunalini sinkar for showing speciality

						//Added by kailsh on 23-feb-18 [End]
						//added by Mrunalini Sinkar on 2-may-2017 to show call outcome details of stockist(end)
						valueXmlString.append("<collection_form_no><![CDATA[" ).append("stockistcollection").append( "]]></collection_form_no>\r\n" );
						valueXmlString.append("<item_form_no><![CDATA[" ).append("stockistsampleitem").append( "]]></item_form_no>\r\n" );
						valueXmlString.append("<brand_form_no><![CDATA[" ).append("Stockistbrand").append( "]]></brand_form_no>\r\n" );
						valueXmlString.append("<display_form_no><![CDATA[" ).append("StockistDisplay").append( "]]></display_form_no>\r\n" );
						valueXmlString.append("<survey_form_no><![CDATA[" ).append("stockistsurvey").append( "]]></survey_form_no>\r\n" );
						//valueXmlString.append( "</MerchData>\r\n" );
						valueXmlString.append( "<team_details><![CDATA[" ).append( teamDetails ).append( "]]></team_details>\r\n" );
						//Added by Pooja S. on [30-DEC-2019] to show the coaching details  Start
						valueXmlString.append("<coaching_details><![CDATA[" ).append( coachingDetails ).append( "]]></coaching_details>\r\n" );
						valueXmlString.append("<host_url><![CDATA[" ).append(CommonConstants.TOMCAT_HOME).append( "]]></host_url>\r\n" );
						valueXmlString.append( "<member_present><![CDATA[" ).append(checkNull(rs.getString("MEMBER_PRESENT"))).append( "]]></member_present>\r\n" );
						valueXmlString.append("<hide_unlisted><![CDATA[" ).append(isMemberPresnt).append( "]]></hide_unlisted>\r\n" );
						valueXmlString.append("<oth_participant><![CDATA[" ).append(othParticipant).append( "]]></oth_participant>\r\n" );
						valueXmlString.append("<contact_pers><![CDATA[" ).append(contactPers).append( "]]></contact_pers>\r\n" );//Added by Bhagyashri To Add EUIN no and conatact_pers_name[23/02/22]
						valueXmlString.append("<contact_pers_name><![CDATA[" ).append(contactPersName).append( "]]></contact_pers_name>\r\n" );//Added by Bhagyashri To Add EUIN no and conatact_pers_name[23/02/22]
						valueXmlString.append("<reg_no><![CDATA[" ).append(regNo).append( "]]></reg_no>\r\n" );
						valueXmlString.append("<cust_type_descr><![CDATA[" ).append(custTypeDescr).append( "]]></cust_type_descr>\r\n" );
						valueXmlString.append( "<event_type_descr><![CDATA[" ).append(eventTypeDescr).append( "]]></event_type_descr>\r\n" );
						valueXmlString.append("<dcr_group><![CDATA[" ).append(dcrGroup).append( "]]></dcr_group>\r\n" );
	                     valueXmlString.append("<plan_chg_reason_descr><![CDATA[").append(genDescr).append("]]></plan_chg_reason_descr>\r\n");
	                     String totalamount =  checkNull(rs.getString("AMOUNT")) ;
							//System.out.println("inside the summary sql totalamount::::::["+totalamount+"]");
							String taxAmount =  checkNull(rs.getString("TAX_AMOUNT")) ;
							//System.out.println("inside the summary sql taxAmount::::::["+taxAmount+"]");
							String netAmount =  checkNull(rs.getString("NET_AMT")) ;
							//System.out.println("inside the summary sql netAmount::::::["+netAmount+"]");
							String addrAs =  checkNull(rs.getString("ADDRESS_AS")) ;
							//System.out.println("inside the summary sql addrAs::::::["+addrAs+"]");
							double amt =0d;
							double totamt =0d;
							double invamt =0d;
							double invoiceAmount =0d;
							double rndOff =0d;
							String invoicAmount ="";
							String roundOff ="";
							double sgstamt =0d;
							double sgstAmt =0d;
							String sgstAmount ="",amtInWord="";
							String cgstAmount ="";
							if(totalamount!=null && totalamount.trim().length()>0)
							{
							  amt=Double.parseDouble(totalamount);
							  invoiceAmount=Math.round(amt);
							  invoicAmount=Double.toString(invoiceAmount);
							  invoicAmount=invoicAmount.replaceAll("\\.\\d+$", "");
							}
							//System.out.println("inside the summary sql invoicAmount::::::["+invoicAmount+"]");
							//System.out.println("inside the summary sql totalamount::::::["+totalamount+"]");
							if(invoicAmount!=null && invoicAmount.trim().length()>0 && totalamount!=null && totalamount.trim().length()>0)
							{
							  totamt=Double.parseDouble(totalamount);
							  invamt=Double.parseDouble(invoicAmount);
							  //System.out.println("inside the summary sql totamt::::::["+totamt+"]");
								//System.out.println("inside the summary sql invamt::::::["+invamt+"]");
							  rndOff=(invamt-totamt);
							  //System.out.println("inside the summary sql rndOff11::::::["+rndOff+"]");
							  roundOff=dFormatter.format(rndOff);
							 // System.out.println("inside the summary sql after Format an ::::::["+roundOff+"]");
							  invoicAmount.replaceAll("\\.\\d+$", "");
							  //System.out.println("inside the summary sql rounded in an::::::["+invoicAmount+"]");
							  long lngAmt=Long.parseLong(invoicAmount);
							  //System.out.println("inside the summary sql lngAmt::::::["+lngAmt+"]");
							  amtInWord = dcb.convert(lngAmt);
							  //System.out.println("inside the summary After Convert string to long and string AMT::::::["+amtInWord+"]");
							}
							if(taxAmount!=null && taxAmount.trim().length()>0)
							{
								sgstamt=Double.parseDouble(taxAmount);
								sgstAmt=(sgstamt/2);
								sgstAmount=Double.toString(sgstAmt);
								cgstAmount =sgstAmount;
							}
							valueXmlString.append( "<net_amt><![CDATA[" ).append(netAmount).append( "]]></net_amt>\r\n" );//Added by bhagayshri to set total on edit mode
							valueXmlString.append( "<tax_amount><![CDATA[" ).append(taxAmount ).append( "]]></tax_amount>\r\n" );//Added by bhagayshri to set total on edit mode
							valueXmlString.append( "<amount><![CDATA[" ).append(totalamount ).append( "]]></amount>\r\n" );//Added by bhagayshri to set total on edit mode
							valueXmlString.append( "<invoice_amount><![CDATA[" ).append(invoicAmount).append( "]]></invoice_amount>\r\n" ); 
							valueXmlString.append( "<total_sgst_amt><![CDATA[" ).append( sgstAmount).append( "]]></total_sgst_amt>\r\n" ); 
							valueXmlString.append( "<total_cgst_amt><![CDATA[" ).append( cgstAmount).append( "]]></total_cgst_amt>\r\n" ); 
							valueXmlString.append( "<strg_gst_no><![CDATA[" ).append(strgGstNo ).append( "]]></strg_gst_no>\r\n" ); 
							valueXmlString.append( "<strg_state><![CDATA[" ).append(strgState ).append( "]]></strg_state>\r\n" );
							valueXmlString.append( "<address_as><![CDATA[" ).append( addrAs).append( "]]></address_as>\r\n" );
							valueXmlString.append( "<addr1><![CDATA[" ).append( addr1).append( "]]></addr1>\r\n" ); 
							valueXmlString.append( "<addr2><![CDATA[" ).append( addr2).append( "]]></addr2>\r\n" ); 
							valueXmlString.append( "<addr3><![CDATA[" ).append( addr3).append( "]]></addr3>\r\n" );
							valueXmlString.append( "<sales_type><![CDATA[" ).append( salesType).append( "]]></sales_type>\r\n" );
							valueXmlString.append( "<round_off><![CDATA[" ).append( roundOff).append( "]]></round_off>\r\n" );
							valueXmlString.append( "<amount_in_word><![CDATA[" ).append( amtInWord).append( "]]></amount_in_word>\r\n" );
						valueXmlString.append( "</StockData>\r\n" );
						String sqlEdit1="select it.item_code ,it.descr ITEMDESCR from strg_meet_order sm, item it where sm.item_code=it.item_code and sm.strg_code= ? and sm.dcr_id = ?";
						PreparedStatement pstmt1 = null;
						pstmt1 =  conn.prepareStatement( sqlEdit1 );
						pstmt1.setString(1, checkNull(rs.getString("STRG_CODE")));
						pstmt1.setString( 2, checkNull(rs.getString("DCR_ID")) );

						ResultSet rs1 = pstmt1.executeQuery();					

						//valueXmlString.append( "<ItemData>" );
						while(rs1.next())
						{
							//valueXmlString.append( "<item><![CDATA[" ).append(checkNull(rs1.getString("ITEMDESCR"))).append( "]]></item>\r\n" );
							//valueXmlString.append( "<strg_code><![CDATA[" ).append(checkNull(rs.getString("STRG_CODE"))).append( "]]></strg_code>\r\n" );
						}
						if (rs1 != null)
						{
							rs1.close();
							rs1 = null;
						}
						if(pstmt1 !=null)
						{
							pstmt1.close();
							pstmt1 = null;
						}
						//valueXmlString.append( "</ItemData>\r\n" );
					}
					// modified by rupali on 21/12/18 for dcr_group related changes
					//else if("O".equalsIgnoreCase(custType) && !"PR".equalsIgnoreCase(actypeDB))
					else if("O".equalsIgnoreCase(dcrGroup) && !"PR".equalsIgnoreCase(actypeDB))
					{
						//valueXmlString.append( "<MerchData domID='"+domID+"' selected = 'Y'>\r\n" );
						valueXmlString.append( "<NCWData domID='"+domID+"' selected = 'Y'>\r\n" );
						valueXmlString.append( "<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\"/>\r\n");
						valueXmlString.append( "<tran_id><![CDATA[" ).append(tranId).append( "]]></tran_id>\r\n");
						valueXmlString.append( "<strg_code><![CDATA[" ).append( checkNull(rs.getString("STRG_CODE")).trim()).append( "]]></strg_code>\r\n");							
						if(strgName!=null && strgName.trim().length()>0)
						{
							valueXmlString.append( "<cust_name><![CDATA[" ).append( checkNull(rs.getString("SC_NAME"))).append( "]]></cust_name>\r\n");
						}
						else
						{
							valueXmlString.append( "<cust_name><![CDATA[" ).append("Other Detail's").append( "]]></cust_name>\r\n");
						}
						valueXmlString.append( "<sales_pers><![CDATA[" ).append(checkNull(salesPers)).append( "]]></sales_pers>\r\n" );
						valueXmlString.append( "<event_date><![CDATA[" ).append(eventDate).append( "]]></event_date>\r\n" );				
						valueXmlString.append("<cust_type><![CDATA["+custType+"]]></cust_type>\r\n");														
						valueXmlString.append( "<locality_descr><![CDATA[" ).append( checkNull(rs.getString("LOC_DESCR")).trim()).append( "]]></locality_descr>\r\n");
						//valueXmlString.append( "<loc_descr><![CDATA[" ).append( checkNull(rs.getString("LOC_DESCR")).trim()).append( "]]></loc_descr>\r\n");
						//added by Mrunalini Sinkar on 2-may-2017 to show call outcome details of ncw(strat)
						String callOutCome = checkNull(rs.getString("CALL_OUTCOME"));
						valueXmlString.append( "<call_outcome><![CDATA[" ).append(checkNull(callOutCome)).append( "]]></call_outcome>\r\n" );
						//Added By Mrunalini Sinkar For Fortune Server 20-May-2020(Start)
						if("Y".equalsIgnoreCase(isFortuneAct))
						{
							String meetingStatus="";
							String mettingSql="SELECT CALL_OUTCOME_DESCR FROM CALL_OUTCOME WHERE CALL_OUTCOME = ? AND ACTIVITY_CODE=? ";
							PreparedStatement meetPstmt =conn.prepareStatement(mettingSql);
							meetPstmt.setString(1, callOutCome);
							meetPstmt.setString(2, eventType);
							ResultSet meetRs=meetPstmt.executeQuery();
							if(meetRs.next())
							{
								meetingStatus=checkNull(meetRs.getString("CALL_OUTCOME_DESCR"));
							}
							if (meetRs!= null)
							{
								meetRs.close();
								meetRs = null;
							}
							if(meetPstmt!=null)
							{
								meetPstmt.close();
								meetPstmt = null;
							}
							valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append(meetingStatus).append( "]]></calloutcome_descr>\r\n" );

						}
						else
						{
							if(callOutCome.equalsIgnoreCase("4"))
							{
								valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Very Positive").append( "]]></calloutcome_descr>\r\n" );
							}
							else if(callOutCome.equalsIgnoreCase("3"))
							{
								valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Average").append( "]]></calloutcome_descr>\r\n" );
							}
							else if(callOutCome.equalsIgnoreCase("2"))
							{
								valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Below Average").append( "]]></calloutcome_descr>\r\n" );
							}
							else if(callOutCome.equalsIgnoreCase("1"))
							{
								valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Negative").append( "]]></calloutcome_descr>\r\n" );
							}
							else if(callOutCome.equalsIgnoreCase("0"))
							{
								valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Refused").append( "]]></calloutcome_descr>\r\n" );
							}
							else if(callOutCome.equalsIgnoreCase("5"))
							{
								valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Supporter").append( "]]></calloutcome_descr>\r\n" );
							}
							else if(callOutCome.equalsIgnoreCase("6"))
							{
								valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Believer").append( "]]></calloutcome_descr>\r\n" );
							}
							else if(callOutCome.equalsIgnoreCase("7"))
							{
								valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Non Believer").append( "]]></calloutcome_descr>\r\n" );
							}
							// added by rupali on 03/05/18 for display call outcame data in confirm and delete report [start]
							else if(callOutCome.equalsIgnoreCase("8"))
							{
								valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Obj. Not Met").append( "]]></calloutcome_descr>\r\n" );
							}
							else if(callOutCome.equalsIgnoreCase("9"))
							{
								valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Obj. Met").append( "]]></calloutcome_descr>\r\n" );
							}

						}
						//Added By Mrunalini Sinkar For Fortune Server 20-May-2020(End)
						//Added by kailsh on 23-feb-18 [Start]
						valueXmlString.append( "<meet_summ><![CDATA[" ).append(rs.getString("MEET_SUMM")).append( "]]></meet_summ>\r\n" );
						valueXmlString.append( "<event_time_start><![CDATA[" ).append(rs.getString("EVENT_TIME_START")).append( "]]></event_time_start>\r\n" );
						valueXmlString.append( "<event_time_end><![CDATA[" ).append(rs.getString("EVENT_TIME_END")).append( "]]></event_time_end>\r\n" );
						valueXmlString.append( "<pob_val><![CDATA[" ).append(checkNull(rs.getString("SKU_VALUE"))).append( "]]></pob_val>\r\n" );
						valueXmlString.append( "<remarks><![CDATA[" ).append(checkNull(rs.getString("REMARKS"))).append( "]]></remarks>\r\n" );

						valueXmlString.append( "<strg_class_code><![CDATA[" ).append(rs.getString("STRG_CLASS_CODE")).append( "]]></strg_class_code>\r\n" );
						valueXmlString.append( "<class_code_descr><![CDATA[" ).append(classCodeDescr).append( "]]></class_code_descr>\r\n" );
						valueXmlString.append("<spl_descr><![CDATA[" ).append(checkNull(rs.getString("SPL_DSCR"))).append( "]]></spl_descr>\r\n" );//Added by mrunalini sinkar for showing speciality
						valueXmlString.append( "<customer_type><![CDATA[" ).append(customerType).append( "]]></customer_type>\r\n" );

						//Added by kailsh on 23-feb-18 [End]
						//added by Mrunalini Sinkar on 2-may-2017 to show call outcome details of ncw(end)
						valueXmlString.append("<collection_form_no><![CDATA[" ).append("NCWcollection").append( "]]></collection_form_no>\r\n" );
						valueXmlString.append("<item_form_no><![CDATA[" ).append("NCWsampleitem").append( "]]></item_form_no>\r\n" );
						valueXmlString.append("<brand_form_no><![CDATA[" ).append("Ncwbrand").append( "]]></brand_form_no>\r\n" );
						valueXmlString.append("<display_form_no><![CDATA[" ).append("NcwDisplay").append( "]]></display_form_no>\r\n" );
						valueXmlString.append("<survey_form_no><![CDATA[" ).append("ncwsurvey").append( "]]></survey_form_no>\r\n" );
						//valueXmlString.append( "</MerchData>\r\n" );
						valueXmlString.append( "<team_details><![CDATA[" ).append( teamDetails ).append( "]]></team_details>\r\n" );
						//Added by Pooja S. on [30-DEC-2019] to show the coaching details  Start
						valueXmlString.append("<coaching_details><![CDATA[" ).append( coachingDetails ).append( "]]></coaching_details>\r\n" );
						valueXmlString.append("<host_url><![CDATA[" ).append(CommonConstants.TOMCAT_HOME).append( "]]></host_url>\r\n" );
						valueXmlString.append( "<member_present><![CDATA[" ).append(checkNull(rs.getString("MEMBER_PRESENT"))).append( "]]></member_present>\r\n" );
						valueXmlString.append("<hide_unlisted><![CDATA[" ).append(isMemberPresnt).append( "]]></hide_unlisted>\r\n" );
						valueXmlString.append("<oth_participant><![CDATA[" ).append(othParticipant).append( "]]></oth_participant>\r\n" );
						valueXmlString.append("<contact_pers><![CDATA[" ).append(contactPers).append( "]]></contact_pers>\r\n" );//Added by Bhagyashri To Add EUIN no and conatact_pers_name[23/02/22]
						valueXmlString.append("<contact_pers_name><![CDATA[" ).append(contactPersName).append( "]]></contact_pers_name>\r\n" );//Added by Bhagyashri To Add EUIN no and conatact_pers_name[23/02/22]
						valueXmlString.append("<reg_no><![CDATA[" ).append(regNo).append( "]]></reg_no>\r\n" );
						valueXmlString.append("<cust_type_descr><![CDATA[" ).append(custTypeDescr).append( "]]></cust_type_descr>\r\n" );
						valueXmlString.append( "<event_type_descr><![CDATA[" ).append(eventTypeDescr).append( "]]></event_type_descr>\r\n" );
						valueXmlString.append("<dcr_group><![CDATA[" ).append(dcrGroup).append( "]]></dcr_group>\r\n" );
	                     valueXmlString.append("<plan_chg_reason_descr><![CDATA[").append(genDescr).append("]]></plan_chg_reason_descr>\r\n");
	                     String totalamount =  checkNull(rs.getString("AMOUNT")) ;
							//System.out.println("inside the summary sql totalamount::::::["+totalamount+"]");
							String taxAmount =  checkNull(rs.getString("TAX_AMOUNT")) ;
							//System.out.println("inside the summary sql taxAmount::::::["+taxAmount+"]");
							String netAmount =  checkNull(rs.getString("NET_AMT")) ;
							//System.out.println("inside the summary sql netAmount::::::["+netAmount+"]");
							String addrAs =  checkNull(rs.getString("ADDRESS_AS")) ;
							//System.out.println("inside the summary sql addrAs::::::["+addrAs+"]");
							double amt =0d;
							double totamt =0d;
							double invamt =0d;
							double invoiceAmount =0d;
							double rndOff =0d;
							String invoicAmount ="";
							String roundOff ="";
							double sgstamt =0d;
							double sgstAmt =0d;
							String sgstAmount ="",amtInWord="";
							String cgstAmount ="";
							if(totalamount!=null && totalamount.trim().length()>0)
							{
							  amt=Double.parseDouble(totalamount);
							  invoiceAmount=Math.round(amt);
							  invoicAmount=Double.toString(invoiceAmount);
							  invoicAmount=invoicAmount.replaceAll("\\.\\d+$", "");
							}
							//System.out.println("inside the summary sql invoicAmount::::::["+invoicAmount+"]");
							//System.out.println("inside the summary sql totalamount::::::["+totalamount+"]");
							if(invoicAmount!=null && invoicAmount.trim().length()>0 && totalamount!=null && totalamount.trim().length()>0)
							{
							  totamt=Double.parseDouble(totalamount);
							  invamt=Double.parseDouble(invoicAmount);
							  //System.out.println("inside the summary sql totamt::::::["+totamt+"]");
								//System.out.println("inside the summary sql invamt::::::["+invamt+"]");
							  rndOff=(invamt-totamt);
							  //System.out.println("inside the summary sql rndOff11::::::["+rndOff+"]");
							  roundOff=dFormatter.format(rndOff);
							 // System.out.println("inside the summary sql after Format an ::::::["+roundOff+"]");
							  invoicAmount.replaceAll("\\.\\d+$", "");
							  //System.out.println("inside the summary sql rounded in an::::::["+invoicAmount+"]");
							  long lngAmt=Long.parseLong(invoicAmount);
							  //System.out.println("inside the summary sql lngAmt::::::["+lngAmt+"]");
							  amtInWord = dcb.convert(lngAmt);
							  //System.out.println("inside the summary After Convert string to long and string AMT::::::["+amtInWord+"]");
							}
							if(taxAmount!=null && taxAmount.trim().length()>0)
							{
								sgstamt=Double.parseDouble(taxAmount);
								sgstAmt=(sgstamt/2);
								sgstAmount=Double.toString(sgstAmt);
								cgstAmount =sgstAmount;
							}
							valueXmlString.append( "<net_amt><![CDATA[" ).append(netAmount).append( "]]></net_amt>\r\n" );//Added by bhagayshri to set total on edit mode
							valueXmlString.append( "<tax_amount><![CDATA[" ).append(taxAmount ).append( "]]></tax_amount>\r\n" );//Added by bhagayshri to set total on edit mode
							valueXmlString.append( "<amount><![CDATA[" ).append(totalamount ).append( "]]></amount>\r\n" );//Added by bhagayshri to set total on edit mode
							valueXmlString.append( "<invoice_amount><![CDATA[" ).append(invoicAmount).append( "]]></invoice_amount>\r\n" ); 
							valueXmlString.append( "<total_sgst_amt><![CDATA[" ).append( sgstAmount).append( "]]></total_sgst_amt>\r\n" ); 
							valueXmlString.append( "<total_cgst_amt><![CDATA[" ).append( cgstAmount).append( "]]></total_cgst_amt>\r\n" ); 
							valueXmlString.append( "<strg_gst_no><![CDATA[" ).append(strgGstNo ).append( "]]></strg_gst_no>\r\n" ); 
							valueXmlString.append( "<strg_state><![CDATA[" ).append(strgState ).append( "]]></strg_state>\r\n" );
							valueXmlString.append( "<address_as><![CDATA[" ).append( addrAs).append( "]]></address_as>\r\n" );
							valueXmlString.append( "<addr1><![CDATA[" ).append( addr1).append( "]]></addr1>\r\n" ); 
							valueXmlString.append( "<addr2><![CDATA[" ).append( addr2).append( "]]></addr2>\r\n" ); 
							valueXmlString.append( "<addr3><![CDATA[" ).append( addr3).append( "]]></addr3>\r\n" );
							valueXmlString.append( "<sales_type><![CDATA[" ).append( salesType).append( "]]></sales_type>\r\n" );
							valueXmlString.append( "<round_off><![CDATA[" ).append( roundOff).append( "]]></round_off>\r\n" );
							valueXmlString.append( "<amount_in_word><![CDATA[" ).append( amtInWord).append( "]]></amount_in_word>\r\n" );
						valueXmlString.append( "</NCWData>\r\n" );
						/*String sqlEdit1="select it.item_code ,it.descr ITEMDESCR from strg_meet_order sm, item it where sm.item_code=it.item_code and sm.strg_code= ? and sm.dcr_id = ?";
						PreparedStatement pstmt1 = null;
						pstmt1 =  conn.prepareStatement( sqlEdit1 );
						pstmt1.setString(1, checkNull(rs.getString("STRG_CODE")));
						pstmt1.setString( 2, checkNull(rs.getString("DCR_ID")) );

						ResultSet rs1 = pstmt1.executeQuery();					

						valueXmlString.append( "<ItemData>" );
						while(rs1.next())
						{
							valueXmlString.append( "<item><![CDATA[" ).append(checkNull(rs1.getString("ITEMDESCR"))).append( "]]></item>\r\n" );
							valueXmlString.append( "<strg_code><![CDATA[" ).append(checkNull(rs.getString("STRG_CODE"))).append( "]]></strg_code>\r\n" );
						}
						if (rs1 != null)
						{
							rs1.close();
							rs1 = null;
						}
						if(pstmt1 !=null)
						{
							pstmt1.close();
							pstmt1 = null;
						}
						valueXmlString.append( "</ItemData>\r\n" );*/
					}
					domID++;
				}
				
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				//Added by Pooja S. on [30-DEC-2019] to show the coaching details  Start
				if( pstmtTeam != null)
				{
					pstmtTeam.close();
					pstmtTeam = null;
				}
				if( pstmtCoaching != null)
				{
					pstmtCoaching.close();
					pstmtCoaching = null;
				}
			}
			//Added by Pooja S. on [30-DEC-2019] to show the coaching details  End
		//added by mrunalini sinkar on 17-april-2017 to show order details on confirm and delete form(start) 
			boolean isDetailExist = false;
			
			/*String sampleOrderSql = "SELECT ROWNUM,CUST_NAME,QUANTITY,VALUE ,DESCR , CUST_TYPE ,STRG_CODE " +
					"FROM  (SELECT SMI.QUANTITY QUANTITY,ITEM.DESCR DESCR ,  SC.FIRST_NAME||' '||SC.LAST_NAME AS CUST_NAME ,  SC.CUST_TYPE  , " +
					"SMI.value , SMI.STRG_CODE " +
					"FROM STRG_MEET_ORDER SMI  JOIN ITEM ITEM ON SMI.ITEM_CODE = ITEM.ITEM_CODE  " +
					"JOIN STRG_CUSTOMER SC  ON SMI.STRG_CODE=SC.SC_CODE   " +
					"WHERE SMI.DCR_ID=  ? )";*/
			//Added By Prathmesh Jangam on 07-07-2017 for DB2 changes(start) 
			String sampleOrderSql = "";
			if("ORACLE".equalsIgnoreCase(CommonConstants.DB_NAME))
			{
					/*sampleOrderSql = "SELECT ROWNUM,QUANTITY,VALUE ,DESCR ,STRG_CODE ,STRG_TYPE, DCR_GROUP, DESCRIPTION " +
						" FROM  (SELECT SMI.QUANTITY QUANTITY,ITEM.DESCR DESCR ," +
						" SMI.VALUE , SMI.STRG_CODE,STRG_MEET.STRG_TYPE, DCR_GROUP, BOM.DESCR AS DESCRIPTION " +
						" FROM STRG_MEET,STRG_MEET_ORDER SMI  JOIN ITEM ITEM ON SMI.ITEM_CODE = ITEM.ITEM_CODE " +
						" LEFT OUTER JOIN BOM ON BOM.BOM_CODE = SMI.PROMO_CODE, STRG_CUST_TYPE SCT " +
						" WHERE SMI.DCR_ID=  ? "+
						" AND STRG_MEET.EVENT_DATE = ? "+
						" AND STRG_MEET.SALES_PERS = ? "+
							" AND STRG_MEET.STRG_CODE=SMI.STRG_CODE AND STRG_MEET.DCR_ID=SMI.DCR_ID AND STRG_MEET.STRG_TYPE = SCT.TYPE )";*/
					
	                sampleOrderSql = "SELECT ROWNUM,QUANTITY,VALUE ,DESCR ,STRG_CODE ,STRG_TYPE, DCR_GROUP, DESCRIPTION, "
	                		+ "REMARKS_ORD,FOCUS_DEVI_REAS  FROM  (SELECT SMI.QUANTITY QUANTITY,ITEM.DESCR DESCR , SMI.VALUE , SMI.STRG_CODE, "
	                		+ "STRG_MEET.STRG_TYPE, DCR_GROUP, BOM.DESCR AS DESCRIPTION,SMI.REMARKS_ORD,SMI.FOCUS_DEVI_REAS "
	                		+ "FROM STRG_MEET,STRG_MEET_ORDER SMI  JOIN ITEM ITEM ON SMI.ITEM_CODE = ITEM.ITEM_CODE  "
	                		+ "LEFT OUTER JOIN BOM ON BOM.BOM_CODE = SMI.PROMO_CODE, STRG_CUST_TYPE SCT  WHERE SMI.DCR_ID=  ?  "
	                		+ "AND STRG_MEET.EVENT_DATE = ?  AND STRG_MEET.SALES_PERS = ?  AND STRG_MEET.STRG_CODE=SMI.STRG_CODE "
	                		+ "AND STRG_MEET.DCR_ID=SMI.DCR_ID AND STRG_MEET.STRG_TYPE = SCT.TYPE )";

			}
			else if("DB2".equalsIgnoreCase(CommonConstants.DB_NAME))
			{
/*					sampleOrderSql = "SELECT SMI.QUANTITY QUANTITY,ITEM.DESCR DESCR ," +
						" SMI.VALUE , SMI.STRG_CODE,STRG_MEET.STRG_TYPE, ROW_NUMBER() OVER () ROWNUM, SCT.DCR_GROUP, BOM.DESCR AS DESCRIPTION " +
						" FROM STRG_MEET,STRG_MEET_ORDER SMI  JOIN ITEM ITEM ON SMI.ITEM_CODE = ITEM.ITEM_CODE " +
						" LEFT OUTER JOIN BOM ON BOM.BOM_CODE = SMI.PROMO_CODE, STRG_CUST_TYPE SCT " +
						" WHERE SMI.DCR_ID=  ? "+
						" AND STRG_MEET.EVENT_DATE = ? "+
						" AND STRG_MEET.SALES_PERS = ? "+
							" AND STRG_MEET.STRG_CODE=SMI.STRG_CODE AND STRG_MEET.DCR_ID=SMI.DCR_ID  AND STRG_MEET.STRG_TYPE = SCT.TYPE";*/
					
	                sampleOrderSql = "SELECT SMI.QUANTITY QUANTITY,ITEM.DESCR DESCR , SMI.VALUE , SMI.STRG_CODE,STRG_MEET.STRG_TYPE, "
	                		+ "ROW_NUMBER() OVER () ROWNUM, SCT.DCR_GROUP, BOM.DESCR AS DESCRIPTION,SMI.REMARKS_ORD,SMI.FOCUS_DEVI_REAS  "
	                		+ "FROM STRG_MEET,STRG_MEET_ORDER SMI  JOIN ITEM ITEM ON SMI.ITEM_CODE = ITEM.ITEM_CODE  "
	                		+ "LEFT OUTER JOIN BOM ON BOM.BOM_CODE = SMI.PROMO_CODE, STRG_CUST_TYPE SCT  WHERE SMI.DCR_ID=  ?  "
	                		+ "AND STRG_MEET.EVENT_DATE = ?  AND STRG_MEET.SALES_PERS = ?  AND STRG_MEET.STRG_CODE=SMI.STRG_CODE "
	                		+ "AND STRG_MEET.DCR_ID=SMI.DCR_ID  AND STRG_MEET.STRG_TYPE = SCT.TYPE";

			}
			//Added By Prathmesh Jangam on 07-07-2017 for DB2 changes(end) 

		    pstmt = conn.prepareStatement(sampleOrderSql);
			pstmt.setString(1, dcrId);
			pstmt.setTimestamp( 2, java.sql.Timestamp.valueOf( eventDateDBFmt ) );
			pstmt.setString(3, salesPers);
			rs = pstmt.executeQuery();
			while(rs.next())
			{

					String genDescr2="";
				isDetailExist = true;
				String custType = checkNull(rs.getString("STRG_TYPE"));
				String dcrGroup = checkNull(rs.getString("DCR_GROUP")); // modified by rupali on 21/12/18 for dcr_group related changes
				// modified by rupali on 21/12/18 for dcr_group related changes
				//if("D".equalsIgnoreCase(custType) && !"PR".equalsIgnoreCase(actTypeNew))
	                String remarksORD=checkNull(rs.getString("REMARKS_ORD"));
					String genFldValue2 = checkNull(rs.getString("FOCUS_DEVI_REAS"));
	                if (genFldValue2 != null && genFldValue2.trim().length() > 0) {
	                    genDescr2 = checkNull(getDescrFromGenCodes("W_STRG_MEET_DCR_REALTIME_WIZ", "ORDER_REMARK", genFldValue2, conn));
	                }

					
				if("D".equalsIgnoreCase(dcrGroup) && !"PR".equalsIgnoreCase(actTypeNew))
				{
					valueXmlString.append("<sampleorder>\r\n");
					valueXmlString.append("<item_rowNum>").append("<![CDATA[").append(rs.getString("ROWNUM") == null ? "" : rs.getString("ROWNUM")).append("]]>").append("</item_rowNum>\r\n ");
					valueXmlString.append("<cust_name>").append("<![CDATA[").append(rs.getString("STRG_TYPE") == null ? "" : rs.getString("STRG_TYPE")).append("]]>").append("</cust_name>\r\n ");
					valueXmlString.append("<quantity>").append("<![CDATA[").append(rs.getString("QUANTITY") == null ? "" : rs.getString("QUANTITY")).append("]]>").append("</quantity>\r\n ");
					valueXmlString.append("<item_descr>").append("<![CDATA[").append(rs.getString("DESCR") == null ? "" : rs.getString("DESCR")).append("]]>").append("</item_descr>\r\n ");
					valueXmlString.append("<value>").append("<![CDATA[").append(rs.getString("VALUE") == null ? "" : rs.getString("VALUE")).append("]]>").append("</value>\r\n ");
					valueXmlString.append("<strg_code>").append("<![CDATA[").append(rs.getString("STRG_CODE") == null ? "" : rs.getString("STRG_CODE")).append("]]>").append("</strg_code>\r\n ");
					valueXmlString.append("<description>").append("<![CDATA[").append(rs.getString("DESCRIPTION") == null ? "" : rs.getString("DESCRIPTION")).append("]]>").append("</description>\r\n ");
	                valueXmlString.append("<remark_descr><![CDATA[").append(genDescr2).append("]]></remark_descr>\r\n");
	                    valueXmlString.append("<remarks><![CDATA[").append(remarksORD).append("]]></remarks>\r\n");

					valueXmlString.append("</sampleorder>\r\n");
				}
				// modified by rupali on 21/12/18 for dcr_group related changes
				//else if ("C".equalsIgnoreCase(custType))
				else if ("C".equalsIgnoreCase(dcrGroup))
				{
					valueXmlString.append("<retailersampleorder>\r\n");
					valueXmlString.append("<item_rowNum>").append("<![CDATA[").append(rs.getString("ROWNUM") == null ? "" : rs.getString("ROWNUM")).append("]]>").append("</item_rowNum>\r\n ");
					valueXmlString.append("<cust_name>").append("<![CDATA[").append(rs.getString("STRG_TYPE") == null ? "" : rs.getString("STRG_TYPE")).append("]]>").append("</cust_name>\r\n ");
					valueXmlString.append("<quantity>").append("<![CDATA[").append(rs.getString("QUANTITY") == null ? "" : rs.getString("QUANTITY")).append("]]>").append("</quantity>\r\n ");
					valueXmlString.append("<item_descr>").append("<![CDATA[").append(rs.getString("DESCR") == null ? "" : rs.getString("DESCR")).append("]]>").append("</item_descr>\r\n ");
					valueXmlString.append("<value>").append("<![CDATA[").append(rs.getString("VALUE") == null ? "" : rs.getString("VALUE")).append("]]>").append("</value>\r\n ");
					valueXmlString.append("<strg_code>").append("<![CDATA[").append(rs.getString("STRG_CODE") == null ? "" : rs.getString("STRG_CODE")).append("]]>").append("</strg_code>\r\n ");
					valueXmlString.append("<description>").append("<![CDATA[").append(rs.getString("DESCRIPTION") == null ? "" : rs.getString("DESCRIPTION")).append("]]>").append("</description>\r\n ");
	                valueXmlString.append("<remark_descr><![CDATA[").append(genDescr2).append("]]></remark_descr>\r\n");
	                valueXmlString.append("<remarks><![CDATA[").append(remarksORD).append("]]></remarks>\r\n");
					valueXmlString.append("</retailersampleorder>\r\n");

				}
				//added by mrunalini sinkar to show the stockist and ncw order on confirm and delete report on 2-may-2017 (start)
				// modified by rupali on 21/12/18 for dcr_group related changes 
				//else if ("S".equalsIgnoreCase(custType))
				else if ("S".equalsIgnoreCase(dcrGroup))
				{
					valueXmlString.append("<StockOrder>\r\n");
					valueXmlString.append("<item_rowNum>").append("<![CDATA[").append(rs.getString("ROWNUM") == null ? "" : rs.getString("ROWNUM")).append("]]>").append("</item_rowNum>\r\n ");
					valueXmlString.append("<cust_name>").append("<![CDATA[").append(rs.getString("STRG_TYPE") == null ? "" : rs.getString("STRG_TYPE")).append("]]>").append("</cust_name>\r\n ");
					valueXmlString.append("<quantity>").append("<![CDATA[").append(rs.getString("QUANTITY") == null ? "" : rs.getString("QUANTITY")).append("]]>").append("</quantity>\r\n ");
					valueXmlString.append("<item_descr>").append("<![CDATA[").append(rs.getString("DESCR") == null ? "" : rs.getString("DESCR")).append("]]>").append("</item_descr>\r\n ");
					valueXmlString.append("<value>").append("<![CDATA[").append(rs.getString("VALUE") == null ? "" : rs.getString("VALUE")).append("]]>").append("</value>\r\n ");
					valueXmlString.append("<strg_code>").append("<![CDATA[").append(rs.getString("STRG_CODE") == null ? "" : rs.getString("STRG_CODE")).append("]]>").append("</strg_code>\r\n ");
					valueXmlString.append("<description>").append("<![CDATA[").append(rs.getString("DESCRIPTION") == null ? "" : rs.getString("DESCRIPTION")).append("]]>").append("</description>\r\n ");
	                valueXmlString.append("<remark_descr><![CDATA[").append(genDescr2).append("]]></remark_descr>\r\n");
	                valueXmlString.append("<remarks><![CDATA[").append(remarksORD).append("]]></remarks>\r\n");
					valueXmlString.append("</StockOrder>\r\n");

				}
				// modified by rupali on 21/12/18 for dcr_group related changes
				//else if ("O".equalsIgnoreCase(custType))
				else if ("O".equalsIgnoreCase(dcrGroup))
				{
					valueXmlString.append("<NcwOrder>\r\n");
					valueXmlString.append("<item_rowNum>").append("<![CDATA[").append(rs.getString("ROWNUM") == null ? "" : rs.getString("ROWNUM")).append("]]>").append("</item_rowNum>\r\n ");
					valueXmlString.append("<cust_name>").append("<![CDATA[").append(rs.getString("STRG_TYPE") == null ? "" : rs.getString("STRG_TYPE")).append("]]>").append("</cust_name>\r\n ");
					valueXmlString.append("<quantity>").append("<![CDATA[").append(rs.getString("QUANTITY") == null ? "" : rs.getString("QUANTITY")).append("]]>").append("</quantity>\r\n ");
					valueXmlString.append("<item_descr>").append("<![CDATA[").append(rs.getString("DESCR") == null ? "" : rs.getString("DESCR")).append("]]>").append("</item_descr>\r\n ");
					valueXmlString.append("<value>").append("<![CDATA[").append(rs.getString("VALUE") == null ? "" : rs.getString("VALUE")).append("]]>").append("</value>\r\n ");
					valueXmlString.append("<strg_code>").append("<![CDATA[").append(rs.getString("STRG_CODE") == null ? "" : rs.getString("STRG_CODE")).append("]]>").append("</strg_code>\r\n ");
					valueXmlString.append("<description>").append("<![CDATA[").append(rs.getString("DESCRIPTION") == null ? "" : rs.getString("DESCRIPTION")).append("]]>").append("</description>\r\n ");
	                valueXmlString.append("<remark_descr><![CDATA[").append(genDescr2).append("]]></remark_descr>\r\n");
	                 valueXmlString.append("<remarks><![CDATA[").append(remarksORD).append("]]></remarks>\r\n");
					valueXmlString.append("</NcwOrder>\r\n");

				}
			//added by mrunalini sinkar to show the stockist and ncw order on confirm and delete report on 2-may-2017 (start) 

			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			//added by mrunalini sinkar on 17-april-2017 to show order details on confirm and delete form(end) 

			
			/*String sql= " SELECT ROWNUM,CUST_NAME,QUANTITY,DESCR , CUST_TYPE FROM "+
					" (SELECT SMI.QUANTITY QUANTITY,ITEM.DESCR DESCR , "+
					" SC.FIRST_NAME||' '||SC.LAST_NAME AS CUST_NAME ,  SC.CUST_TYPE  " +
					" FROM STRG_MEET_ITEMS SMI "+
					" JOIN ITEM ITEM ON SMI.ITEM_CODE = ITEM.ITEM_CODE "+
					" JOIN STRG_CUSTOMER SC  ON SMI.STRG_CODE=SC.SC_CODE "+
					" WHERE SMI.DCR_ID= ?)";*/
			
			String sql= "";
			
			if("Y".equalsIgnoreCase(oldData) && newCnt==0)
			{
				/*
				sql="SELECT ROWNUM,'D' DCR_GROUP,'D' STRG_TYPE,ITEM_QTY QUANTITY,SC_CODE STRG_CODE,(CASE WHEN ITEM_USAGE ='G' THEN 'GIFT' WHEN ITEM_USAGE ='S' THEN 'SAMPLE' WHEN ITEM_USAGE ='SPK' THEN 'SAMPLE' END) AS ITEM_USAGE,DSD.ITEM_CODE,I.DESCR DESCR " + 
						"FROM DR_SAMPLE_DISTRIBUTED DSD,ITEM I,SALES_PERS SP WHERE DSD.ITEM_CODE=I.ITEM_CODE AND DSD.SALES_PERS=SP.SALES_PERS AND SP.ITEM_SER=I.ITEM_SER AND DSD.SALES_PERS=? AND DSD.WORK_DATE=? ";
			    */
				//BY PRACHI ON 13JUNE2022 ID:W22CSUN019
				sql="SELECT ROWNUM,'D' DCR_GROUP,'D' STRG_TYPE,ITEM_QTY QUANTITY,SC_CODE STRG_CODE,ITEM_USAGE AS ITEM_USAGE,DSD.ITEM_CODE,I.DESCR DESCR " + 
						"FROM DR_SAMPLE_DISTRIBUTED DSD,ITEM I,SALES_PERS SP WHERE DSD.ITEM_CODE=I.ITEM_CODE AND DSD.SALES_PERS=SP.SALES_PERS AND SP.ITEM_SER=I.ITEM_SER AND DSD.SALES_PERS=? AND DSD.WORK_DATE=? ";
			    
				
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, salesPers);
				pstmt.setTimestamp( 2, java.sql.Timestamp.valueOf( eventDateDBFmt ) );
				
			}
			else
			{
				if("ORACLE".equalsIgnoreCase(CommonConstants.DB_NAME))
				{
					/*
					sql= "SELECT ROWNUM,QUANTITY,DESCR ,STRG_TYPE,DCR_GROUP,(CASE WHEN ITEM_USAGE ='G' THEN 'GIFT' WHEN ITEM_USAGE ='S' THEN 'SAMPLE' WHEN ITEM_USAGE ='SPK' THEN 'SAMPLE' END)ITEM_USAGE,STRG_CODE FROM "+
							" (SELECT SMI.QUANTITY QUANTITY,ITEM.DESCR DESCR ,STRG_MEET.STRG_TYPE, SCT.DCR_GROUP,ITEM.ITEM_USAGE,STRG_MEET.STRG_CODE "+
							" FROM STRG_MEET,STRG_MEET_ITEMS SMI "+
							" JOIN ITEM ITEM ON SMI.ITEM_CODE = ITEM.ITEM_CODE,STRG_CUST_TYPE SCT "+
							" WHERE SMI.DCR_ID= ? "+
							" AND STRG_MEET.EVENT_DATE = ? "+
							" AND STRG_MEET.SALES_PERS = ? "+
							" AND STRG_MEET.STRG_CODE=SMI.STRG_CODE AND STRG_MEET.DCR_ID=SMI.DCR_ID  AND STRG_MEET.STRG_TYPE = SCT.TYPE)";
						*/
					//BY PRACHI ON 13JUNE2022 ID:W22CSUN019
					sql= "SELECT ROWNUM,QUANTITY,DESCR ,STRG_TYPE,DCR_GROUP,ITEM_USAGE AS ITEM_USAGE,STRG_CODE FROM "+
							" (SELECT SMI.QUANTITY QUANTITY,ITEM.DESCR DESCR ,STRG_MEET.STRG_TYPE, SCT.DCR_GROUP,ITEM.ITEM_USAGE,STRG_MEET.STRG_CODE "+
							" FROM STRG_MEET,STRG_MEET_ITEMS SMI "+
							" JOIN ITEM ITEM ON SMI.ITEM_CODE = ITEM.ITEM_CODE,STRG_CUST_TYPE SCT "+
							" WHERE SMI.DCR_ID= ? "+
							" AND STRG_MEET.EVENT_DATE = ? "+
							" AND STRG_MEET.SALES_PERS = ? "+
							" AND STRG_MEET.STRG_CODE=SMI.STRG_CODE AND STRG_MEET.DCR_ID=SMI.DCR_ID  AND STRG_MEET.STRG_TYPE = SCT.TYPE)";
				}
				else if("DB2".equalsIgnoreCase(CommonConstants.DB_NAME))
				{
					sql= "SELECT SMI.QUANTITY QUANTITY,ITEM.DESCR DESCR ,STRG_MEET.STRG_TYPE, ROW_NUMBER() OVER () ROWNUM, SCT.DCR_GROUP,ITEM.ITEM_USAGE,STRG_MEET.STRG_CODE "+
							" FROM STRG_MEET,STRG_MEET_ITEMS SMI "+
							" JOIN ITEM ITEM ON SMI.ITEM_CODE = ITEM.ITEM_CODE,STRG_CUST_TYPE SCT "+
							" WHERE SMI.DCR_ID= ? "+
							" AND STRG_MEET.EVENT_DATE = ? "+
							" AND STRG_MEET.SALES_PERS = ? "+
							" AND STRG_MEET.STRG_CODE=SMI.STRG_CODE AND STRG_MEET.DCR_ID=SMI.DCR_ID AND STRG_MEET.STRG_TYPE = SCT.TYPE";
				}
			    pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, dcrId);
				pstmt.setTimestamp( 2, java.sql.Timestamp.valueOf( eventDateDBFmt ) );
				pstmt.setString(3, salesPers);
			}
			itemUsageMap = dcb.getItemUsageData(conn);//BY PRACHI ON 13JUNE2022 ID:W22CSUN019
			rs = pstmt.executeQuery();
			while(rs.next())
			{

				isDetailExist = true;
				String custType = checkNull(rs.getString("STRG_TYPE"));
				String dcrGroup = checkNull(rs.getString("DCR_GROUP")); // modified by rupali on 21/12/18 for dcr_group related changes
				// modified by rupali on 21/12/18 for dcr_group related changes
				//if("D".equalsIgnoreCase(custType))
               
				//BY PRACHI ON 13JUNE2022 ID:W22CSUN019
				String descr="";
				if ( itemUsageMap.get( (rs.getString("ITEM_USAGE")).trim()) != null )
				{
					descr=itemUsageMap.get((rs.getString("ITEM_USAGE")).trim());
					System.out.println("descr is::["+descr+"]");
				}
				//end
				if("D".equalsIgnoreCase(dcrGroup))
				{
					valueXmlString.append("<doctorsampleitem>\r\n");
					valueXmlString.append("<item_rowNum>").append("<![CDATA[").append(rs.getString("ROWNUM") == null ? "" : rs.getString("ROWNUM")).append("]]>").append("</item_rowNum>\r\n ");
					valueXmlString.append("<cust_name>").append("<![CDATA[").append(rs.getString("STRG_TYPE") == null ? "" : rs.getString("STRG_TYPE")).append("]]>").append("</cust_name>\r\n ");
					valueXmlString.append("<quantity>").append("<![CDATA[").append(rs.getString("QUANTITY") == null ? "" : rs.getString("QUANTITY")).append("]]>").append("</quantity>\r\n ");
					valueXmlString.append("<item_descr>").append("<![CDATA[").append(rs.getString("DESCR") == null ? "" : rs.getString("DESCR")).append("]]>").append("</item_descr>\r\n ");
					//valueXmlString.append("<item_usage>").append("<![CDATA[").append(rs.getString("ITEM_USAGE") == null ? "" : rs.getString("ITEM_USAGE")).append("]]>").append("</item_usage>\r\n ");
					//BY PRACHI ON 13JUNE2022 ID:W22CSUN019
					valueXmlString.append("<item_usage>").append("<![CDATA[").append(descr).append("]]>").append("</item_usage>\r\n ");
					
					
					valueXmlString.append("<strg_code>").append("<![CDATA[").append(checkNull(rs.getString("STRG_CODE"))).append("]]>").append("</strg_code>\r\n ");//Added by mrunalini sinkar
					//valueXmlString.append("<item_pob>").append("<![CDATA[").append(rs.getString("POB") == null ? "" : rs.getString("POB")).append("]]>").append("</item_pob>\r\n ");
					valueXmlString.append("</doctorsampleitem>\r\n");
				}
				// modified by rupali on 21/12/18 for dcr_group related changes
				//else if ("C".equalsIgnoreCase(custType))
				else if ("C".equalsIgnoreCase(dcrGroup))
				{
					valueXmlString.append("<retailersampleitem>\r\n");
					valueXmlString.append("<item_rowNum>").append("<![CDATA[").append(rs.getString("ROWNUM") == null ? "" : rs.getString("ROWNUM")).append("]]>").append("</item_rowNum>\r\n ");
					valueXmlString.append("<cust_name>").append("<![CDATA[").append(rs.getString("STRG_TYPE") == null ? "" : rs.getString("STRG_TYPE")).append("]]>").append("</cust_name>\r\n ");
					valueXmlString.append("<quantity>").append("<![CDATA[").append(rs.getString("QUANTITY") == null ? "" : rs.getString("QUANTITY")).append("]]>").append("</quantity>\r\n ");
					valueXmlString.append("<item_descr>").append("<![CDATA[").append(rs.getString("DESCR") == null ? "" : rs.getString("DESCR")).append("]]>").append("</item_descr>\r\n ");
					//valueXmlString.append("<item_usage>").append("<![CDATA[").append(rs.getString("ITEM_USAGE") == null ? "" : rs.getString("ITEM_USAGE")).append("]]>").append("</item_usage>\r\n ");
					//BY PRACHI ON 13JUNE2022 ID:W22CSUN019
					valueXmlString.append("<item_usage>").append("<![CDATA[").append(descr).append("]]>").append("</item_usage>\r\n ");
					
					valueXmlString.append("<strg_code>").append("<![CDATA[").append(checkNull(rs.getString("STRG_CODE"))).append("]]>").append("</strg_code>\r\n ");//Added by mrunalini sinkar

					//valueXmlString.append("<item_pob>").append("<![CDATA[").append(rs.getString("POB") == null ? "" : rs.getString("POB")).append("]]>").append("</item_pob>\r\n ");
					valueXmlString.append("</retailersampleitem>\r\n");

				}
				// modified by rupali on 21/12/18 for dcr_group related changes
				//else if ("S".equalsIgnoreCase(custType))
				else if ("S".equalsIgnoreCase(dcrGroup))
				{
					valueXmlString.append("<stockistsampleitem>\r\n");
					valueXmlString.append("<item_rowNum>").append("<![CDATA[").append(rs.getString("ROWNUM") == null ? "" : rs.getString("ROWNUM")).append("]]>").append("</item_rowNum>\r\n ");
					valueXmlString.append("<cust_name>").append("<![CDATA[").append(rs.getString("STRG_TYPE") == null ? "" : rs.getString("STRG_TYPE")).append("]]>").append("</cust_name>\r\n ");
					valueXmlString.append("<quantity>").append("<![CDATA[").append(rs.getString("QUANTITY") == null ? "" : rs.getString("QUANTITY")).append("]]>").append("</quantity>\r\n ");
					valueXmlString.append("<item_descr>").append("<![CDATA[").append(rs.getString("DESCR") == null ? "" : rs.getString("DESCR")).append("]]>").append("</item_descr>\r\n ");
					//valueXmlString.append("<item_usage>").append("<![CDATA[").append(rs.getString("ITEM_USAGE") == null ? "" : rs.getString("ITEM_USAGE")).append("]]>").append("</item_usage>\r\n ");
					
					//BY PRACHI ON 13JUNE2022 ID:W22CSUN019
					valueXmlString.append("<item_usage>").append("<![CDATA[").append(descr).append("]]>").append("</item_usage>\r\n ");
					
					valueXmlString.append("<strg_code>").append("<![CDATA[").append(checkNull(rs.getString("STRG_CODE"))).append("]]>").append("</strg_code>\r\n ");//Added by mrunalini sinkar
					valueXmlString.append("</stockistsampleitem>\r\n");

				}
				// modified by rupali on 21/12/18 for dcr_group related changes
				//else if ("O".equalsIgnoreCase(custType))
				else if ("O".equalsIgnoreCase(dcrGroup))
				{
					valueXmlString.append("<NCWsampleitem>\r\n");
					valueXmlString.append("<item_rowNum>").append("<![CDATA[").append(rs.getString("ROWNUM") == null ? "" : rs.getString("ROWNUM")).append("]]>").append("</item_rowNum>\r\n ");
					valueXmlString.append("<cust_name>").append("<![CDATA[").append(rs.getString("STRG_TYPE") == null ? "" : rs.getString("STRG_TYPE")).append("]]>").append("</cust_name>\r\n ");
					valueXmlString.append("<quantity>").append("<![CDATA[").append(rs.getString("QUANTITY") == null ? "" : rs.getString("QUANTITY")).append("]]>").append("</quantity>\r\n ");
					valueXmlString.append("<item_descr>").append("<![CDATA[").append(rs.getString("DESCR") == null ? "" : rs.getString("DESCR")).append("]]>").append("</item_descr>\r\n ");
					//valueXmlString.append("<item_usage>").append("<![CDATA[").append(rs.getString("ITEM_USAGE") == null ? "" : rs.getString("ITEM_USAGE")).append("]]>").append("</item_usage>\r\n ");
					
					//BY PRACHI ON 13JUNE2022 ID:W22CSUN019
					valueXmlString.append("<item_usage>").append("<![CDATA[").append(descr).append("]]>").append("</item_usage>\r\n ");
					
					valueXmlString.append("<strg_code>").append("<![CDATA[").append(checkNull(rs.getString("STRG_CODE"))).append("]]>").append("</strg_code>\r\n ");//Added by mrunalini sinkar
					valueXmlString.append("</NCWsampleitem>\r\n");
				}
				
			}
			
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			// modified by rupali on 21/12/18 for dcr_group related changes
			/*String brandSql = "SELECT DISTINCT SBP.SC_CODE, SC.FIRST_NAME||' '||SC.LAST_NAME AS CUST_NAME, SC.CUST_TYPE, SBP.BRAND_DESCR, SBP.BRAND_CODE , " +
					"SBP.PITCH_SEQUENCE , BR.PITCH_PRIORITY " +
					"FROM STRG_BRAND_PITCH SBP , STRG_CUSTOMER SC,  BRAND BR   " +
					"WHERE  SBP.SC_CODE = SC.SC_CODE AND SBP.BRAND_CODE = BR.BRAND_CODE " +
					"AND SBP.DCR_ID= ? ";*/
			//Added By Mrunalini Sinkar For Fortune Server 20-May-2020(Stat)
			/*				String brandSql = "SELECT DISTINCT STRG_MEET.STRG_NAME AS CUST_NAME,STRG_MEET.STRG_TYPE AS CUST_TYPE,SBP.BRAND_DESCR, SBP.BRAND_CODE, "+
					"SBP.PITCH_SEQUENCE , BR.PITCH_PRIORITY, SCT.DCR_GROUP,STRG_MEET.STRG_CODE "+
					"FROM STRG_BRAND_PITCH SBP , STRG_MEET ,  BRAND BR, STRG_CUST_TYPE SCT "+    
					"WHERE  SBP.SC_CODE = STRG_MEET.STRG_CODE AND SBP.DCR_ID = STRG_MEET.DCR_ID AND SBP.BRAND_CODE = BR.BRAND_CODE "+
					"AND SBP.DCR_ID= ? AND STRG_MEET.SALES_PERS=? AND STRG_MEET.EVENT_DATE=? AND STRG_MEET.STRG_TYPE = SCT.TYPE ";*/
			String brandSql = "SELECT DISTINCT STRG_MEET.STRG_NAME AS CUST_NAME,STRG_MEET.STRG_TYPE AS CUST_TYPE,SBP.BRAND_DESCR, SBP.BRAND_CODE, "+
					"SBP.PITCH_SEQUENCE , BR.PITCH_PRIORITY, SCT.DCR_GROUP,STRG_MEET.STRG_CODE,SBP.PITCH_DETAIL "+
					"FROM STRG_BRAND_PITCH SBP , STRG_MEET ,  BRAND BR, STRG_CUST_TYPE SCT "+    
					"WHERE  SBP.SC_CODE = STRG_MEET.STRG_CODE AND SBP.DCR_ID = STRG_MEET.DCR_ID AND SBP.BRAND_CODE = BR.BRAND_CODE "+
					"AND SBP.DCR_ID= ? AND STRG_MEET.SALES_PERS=? AND STRG_MEET.EVENT_DATE=? AND STRG_MEET.STRG_TYPE = SCT.TYPE ";
			//Added By Mrunalini Sinkar For Fortune Server 20-May-2020(End)
			
			pstmt = conn.prepareStatement(brandSql);
			pstmt.setString(1, dcrId);
			pstmt.setString(2, salesPers);
			pstmt.setTimestamp( 3, java.sql.Timestamp.valueOf( eventDateDBFmt ) );
			rs = pstmt.executeQuery();
			while(rs.next())
			{

				String pithdetailDescr="";
				isDetailExist = true;
				String custType = checkNull(rs.getString("CUST_TYPE"));
				String dcrGroup = checkNull(rs.getString("DCR_GROUP")); // modified by rupali on 21/12/18 for dcr_group related changes
				// modified by rupali on 21/12/18 for dcr_group related changes
				//if("D".equalsIgnoreCase(custType))
				//Added By Mrunalini Sinkar For Fortune Server 20-May-2020(Start)
				String pitchDetail=checkNull(rs.getString("PITCH_DETAIL"));

				sql = "SELECT FLD_VALUE AS PITCH_DETAIL, DESCR AS PITCH_DETAIL_DESCR FROM GENCODES WHERE FLD_NAME = 'PITCH_DETAIL' AND MOD_NAME = 'W_WSFA_FORTUNE' "
						+ "AND ACTIVE = 'Y' AND  FLD_VALUE=?";
				PreparedStatement pstmt1 = conn.prepareStatement(sql);
				pstmt1.setString(1,pitchDetail);
				ResultSet rs1 = pstmt1.executeQuery();
				if(rs1.next())
				{
					pithdetailDescr = checkNull(rs1.getString("PITCH_DETAIL_DESCR"));

				}
				if (rs1 != null)
				{
					rs1.close();
					rs1 = null;
				}
				if (pstmt1 != null)
				{
					pstmt1.close();
					pstmt1 = null;
				}

				//Added By Mrunalini Sinkar For Fortune Server 20-May-2020(End)
				if("D".equalsIgnoreCase(dcrGroup))
				{
					valueXmlString.append("<brand>\r\n");
					valueXmlString.append("<brand_descr>").append("<![CDATA[").append(rs.getString("BRAND_DESCR") == null ? "" : rs.getString("BRAND_DESCR")).append("]]>").append("</brand_descr>\r\n ");
					valueXmlString.append("<cust_name>").append("<![CDATA[").append(rs.getString("CUST_NAME") == null ? "" : rs.getString("CUST_NAME")).append("]]>").append("</cust_name>\r\n ");
					valueXmlString.append("<pitch_priority>").append("<![CDATA[").append(rs.getString("PITCH_PRIORITY") == null ? "" : rs.getString("PITCH_PRIORITY")).append("]]>").append("</pitch_priority>\r\n ");
					valueXmlString.append("<pitch_sequence>").append("<![CDATA[").append(rs.getString("PITCH_SEQUENCE") == null ? "" : rs.getString("PITCH_SEQUENCE")).append("]]>").append("</pitch_sequence>\r\n ");
					valueXmlString.append("<brand_code>").append("<![CDATA[").append(rs.getString("BRAND_CODE") == null ? "" : rs.getString("BRAND_CODE")).append("]]>").append("</brand_code>\r\n ");
					valueXmlString.append("<strg_code>").append("<![CDATA[").append(checkNull(rs.getString("STRG_CODE"))).append("]]>").append("</strg_code>\r\n ");//Added by mrunalini sinkar
					valueXmlString.append("<pitch_detail_descr>").append("<![CDATA[").append(pithdetailDescr).append("]]>").append("</pitch_detail_descr>\r\n ");
					valueXmlString.append("</brand>\r\n");
				}
				// modified by rupali on 21/12/18 for dcr_group related changes
				//else if ("C".equalsIgnoreCase(custType))
				else if ("C".equalsIgnoreCase(dcrGroup))
				{
					valueXmlString.append("<retailerbrand>\r\n");
					valueXmlString.append("<brand_descr>").append("<![CDATA[").append(rs.getString("BRAND_DESCR") == null ? "" : rs.getString("BRAND_DESCR")).append("]]>").append("</brand_descr>\r\n ");
					valueXmlString.append("<cust_name>").append("<![CDATA[").append(rs.getString("CUST_NAME") == null ? "" : rs.getString("CUST_NAME")).append("]]>").append("</cust_name>\r\n ");
					valueXmlString.append("<pitch_priority>").append("<![CDATA[").append(rs.getString("PITCH_PRIORITY") == null ? "" : rs.getString("PITCH_PRIORITY")).append("]]>").append("</pitch_priority>\r\n ");
					valueXmlString.append("<pitch_sequence>").append("<![CDATA[").append(rs.getString("PITCH_SEQUENCE") == null ? "" : rs.getString("PITCH_SEQUENCE")).append("]]>").append("</pitch_sequence>\r\n ");
					valueXmlString.append("<brand_code>").append("<![CDATA[").append(rs.getString("BRAND_CODE") == null ? "" : rs.getString("BRAND_CODE")).append("]]>").append("</brand_code>\r\n ");
					valueXmlString.append("<strg_code>").append("<![CDATA[").append(checkNull(rs.getString("STRG_CODE"))).append("]]>").append("</strg_code>\r\n ");//Added by mrunalini sinkar
					valueXmlString.append("<pitch_detail_descr>").append("<![CDATA[").append(pithdetailDescr).append("]]>").append("</pitch_detail_descr>\r\n ");
					valueXmlString.append("</retailerbrand>\r\n");

				}
				// modified by rupali on 21/12/18 for dcr_group related changes
				//else if("S".equalsIgnoreCase(custType))
				else if("S".equalsIgnoreCase(dcrGroup))
				{
					valueXmlString.append("<Stockistbrand>\r\n");
					valueXmlString.append("<brand_descr>").append("<![CDATA[").append(rs.getString("BRAND_DESCR") == null ? "" : rs.getString("BRAND_DESCR")).append("]]>").append("</brand_descr>\r\n ");
					valueXmlString.append("<cust_name>").append("<![CDATA[").append(rs.getString("CUST_NAME") == null ? "" : rs.getString("CUST_NAME")).append("]]>").append("</cust_name>\r\n ");
					valueXmlString.append("<pitch_priority>").append("<![CDATA[").append(rs.getString("PITCH_PRIORITY") == null ? "" : rs.getString("PITCH_PRIORITY")).append("]]>").append("</pitch_priority>\r\n ");
					valueXmlString.append("<pitch_sequence>").append("<![CDATA[").append(rs.getString("PITCH_SEQUENCE") == null ? "" : rs.getString("PITCH_SEQUENCE")).append("]]>").append("</pitch_sequence>\r\n ");
					valueXmlString.append("<brand_code>").append("<![CDATA[").append(rs.getString("BRAND_CODE") == null ? "" : rs.getString("BRAND_CODE")).append("]]>").append("</brand_code>\r\n ");
					valueXmlString.append("<strg_code>").append("<![CDATA[").append(checkNull(rs.getString("STRG_CODE"))).append("]]>").append("</strg_code>\r\n ");//Added by mrunalini sinkar
					valueXmlString.append("<pitch_detail_descr>").append("<![CDATA[").append(pithdetailDescr).append("]]>").append("</pitch_detail_descr>\r\n ");
					valueXmlString.append("</Stockistbrand>\r\n");
				}
				// modified by rupali on 21/12/18 for dcr_group related changes
				//else if ("O".equalsIgnoreCase(custType))
				else if ("O".equalsIgnoreCase(dcrGroup))
				{
					valueXmlString.append("<Ncwbrand>\r\n");
					valueXmlString.append("<brand_descr>").append("<![CDATA[").append(rs.getString("BRAND_DESCR") == null ? "" : rs.getString("BRAND_DESCR")).append("]]>").append("</brand_descr>\r\n ");
					valueXmlString.append("<cust_name>").append("<![CDATA[").append(rs.getString("CUST_NAME") == null ? "" : rs.getString("CUST_NAME")).append("]]>").append("</cust_name>\r\n ");
					valueXmlString.append("<pitch_priority>").append("<![CDATA[").append(rs.getString("PITCH_PRIORITY") == null ? "" : rs.getString("PITCH_PRIORITY")).append("]]>").append("</pitch_priority>\r\n ");
					valueXmlString.append("<pitch_sequence>").append("<![CDATA[").append(rs.getString("PITCH_SEQUENCE") == null ? "" : rs.getString("PITCH_SEQUENCE")).append("]]>").append("</pitch_sequence>\r\n ");
					valueXmlString.append("<brand_code>").append("<![CDATA[").append(rs.getString("BRAND_CODE") == null ? "" : rs.getString("BRAND_CODE")).append("]]>").append("</brand_code>\r\n ");
					valueXmlString.append("<strg_code>").append("<![CDATA[").append(checkNull(rs.getString("STRG_CODE"))).append("]]>").append("</strg_code>\r\n ");//Added by mrunalini sinkar
					valueXmlString.append("<pitch_detail_descr>").append("<![CDATA[").append(pithdetailDescr).append("]]>").append("</pitch_detail_descr>\r\n ");
					valueXmlString.append("</Ncwbrand>\r\n");
				}
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			
			/*String displaySql = "SELECT SC.SC_CODE, SC.FIRST_NAME||' '||SC.LAST_NAME AS CUST_NAME, SC.CUST_TYPE,  SD.DISPLAY_AREA, SD.DOC_ID " +
					"FROM STRG_ITEM_DISPLAY SD, STRG_CUSTOMER SC " +
					"WHERE  SD.STRG_CODE = SC.SC_CODE and SD.DCR_ID =  ? ";*/
			String displaySql = "SELECT SD.DISPLAY_AREA, SD.DOC_ID ,STRG_MEET.STRG_TYPE,SCT.DCR_GROUP,STRG_MEET.STRG_CODE " +
					" FROM STRG_ITEM_DISPLAY SD ,STRG_MEET, STRG_CUST_TYPE SCT " +
					" WHERE SD.DCR_ID =  ? "+
					" AND STRG_MEET.EVENT_DATE = ? "+
					" AND STRG_MEET.SALES_PERS = ? "+
					" AND STRG_MEET.STRG_CODE = SD.STRG_CODE AND STRG_MEET.DCR_ID = SD.DCR_ID AND STRG_MEET.STRG_TYPE = SCT.TYPE";
			pstmt = conn.prepareStatement(displaySql);
			pstmt.setString(1, dcrId);
			pstmt.setTimestamp( 2, java.sql.Timestamp.valueOf( eventDateDBFmt ) );
			pstmt.setString(3, salesPers);
			rs = pstmt.executeQuery();
			
			while(rs.next())
			{

				isDetailExist = true;
				String custType = checkNull(rs.getString("STRG_TYPE"));
				String dcrGroup = checkNull(rs.getString("DCR_GROUP")); // modified by rupali on 21/12/18 for dcr_group related changes
				// modified by rupali on 21/12/18 for dcr_group related changes
				//if("D".equalsIgnoreCase(custType))
				if("D".equalsIgnoreCase(dcrGroup))
				{
					valueXmlString.append("<display>\r\n");
					valueXmlString.append("<display_area>").append("<![CDATA[").append(rs.getString("DISPLAY_AREA") == null ? "" : rs.getString("DISPLAY_AREA")).append("]]>").append("</display_area>\r\n ");
					valueXmlString.append("<cust_name>").append("<![CDATA[").append(rs.getString("STRG_TYPE") == null ? "" : rs.getString("STRG_TYPE")).append("]]>").append("</cust_name>\r\n ");
					valueXmlString.append("<doc_id>").append("<![CDATA[").append(rs.getString("DOC_ID") == null ? "" : rs.getString("DOC_ID")).append("]]>").append("</doc_id>\r\n ");
					valueXmlString.append("<strg_code>").append("<![CDATA[").append(checkNull(rs.getString("STRG_CODE"))).append("]]>").append("</strg_code>\r\n ");//Added by mrunalini sinkar
					valueXmlString.append("</display>\r\n");
				}
				// modified by rupali on 21/12/18 for dcr_group related changes
				//else if ("C".equalsIgnoreCase(custType))
				else if ("C".equalsIgnoreCase(dcrGroup))
				{
					valueXmlString.append("<retailerdisplay>\r\n");
					valueXmlString.append("<display_area>").append("<![CDATA[").append(rs.getString("DISPLAY_AREA") == null ? "" : rs.getString("DISPLAY_AREA")).append("]]>").append("</display_area>\r\n ");
					valueXmlString.append("<cust_name>").append("<![CDATA[").append(rs.getString("STRG_TYPE") == null ? "" : rs.getString("STRG_TYPE")).append("]]>").append("</cust_name>\r\n ");
					valueXmlString.append("<doc_id>").append("<![CDATA[").append(rs.getString("DOC_ID") == null ? "" : rs.getString("DOC_ID")).append("]]>").append("</doc_id>\r\n ");
					valueXmlString.append("<strg_code>").append("<![CDATA[").append(checkNull(rs.getString("STRG_CODE"))).append("]]>").append("</strg_code>\r\n ");//Added by mrunalini sinkar

					valueXmlString.append("</retailerdisplay>\r\n");

				}
				// modified by rupali on 21/12/18 for dcr_group related changes
				//else if("S".equalsIgnoreCase(custType))
				else if("S".equalsIgnoreCase(dcrGroup))
				{
					valueXmlString.append("<StockistDisplay>\r\n");
					valueXmlString.append("<display_area>").append("<![CDATA[").append(rs.getString("DISPLAY_AREA") == null ? "" : rs.getString("DISPLAY_AREA")).append("]]>").append("</display_area>\r\n ");
					valueXmlString.append("<cust_name>").append("<![CDATA[").append(rs.getString("STRG_TYPE") == null ? "" : rs.getString("STRG_TYPE")).append("]]>").append("</cust_name>\r\n ");
					valueXmlString.append("<doc_id>").append("<![CDATA[").append(rs.getString("DOC_ID") == null ? "" : rs.getString("DOC_ID")).append("]]>").append("</doc_id>\r\n ");
					valueXmlString.append("<strg_code>").append("<![CDATA[").append(checkNull(rs.getString("STRG_CODE"))).append("]]>").append("</strg_code>\r\n ");//Added by mrunalini sinkar

					valueXmlString.append("</StockistDisplay>\r\n");
				}
				// modified by rupali on 21/12/18 for dcr_group related changes
				//else if("O".equalsIgnoreCase(custType))
				else if("O".equalsIgnoreCase(dcrGroup))
				{
					valueXmlString.append("<NcwDisplay>\r\n");
					valueXmlString.append("<display_area>").append("<![CDATA[").append(rs.getString("DISPLAY_AREA") == null ? "" : rs.getString("DISPLAY_AREA")).append("]]>").append("</display_area>\r\n ");
					valueXmlString.append("<cust_name>").append("<![CDATA[").append(rs.getString("STRG_TYPE") == null ? "" : rs.getString("STRG_TYPE")).append("]]>").append("</cust_name>\r\n ");
					valueXmlString.append("<doc_id>").append("<![CDATA[").append(rs.getString("DOC_ID") == null ? "" : rs.getString("DOC_ID")).append("]]>").append("</doc_id>\r\n ");
					valueXmlString.append("<strg_code>").append("<![CDATA[").append(checkNull(rs.getString("STRG_CODE"))).append("]]>").append("</strg_code>\r\n ");//Added by mrunalini sinkar

					valueXmlString.append("</NcwDisplay>\r\n");
				}
			
			}
			
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			//Added By Prathmesh Jangam on 07-07-2017 for DB2 changes(start) 

			String teamSql = "SELECT DISTINCT SMT.STRG_CODE STRG_CODE, SMT.DCR_ID DCR_ID,STRG_MEET.STRG_TYPE, " +
					"D.DESIGNATION DESIGNATION, SP.SP_NAME SP_NAME , SMT.SALES_PERS SALES_PERS , SMT.DESIGN_CODE DESIGN_CODE , SCT.DCR_GROUP  " +
					" FROM STRG_MEET_TEAM SMT, DESIGNATION D, SALES_PERS SP , STRG_MEET , STRG_CUST_TYPE SCT " +
					" WHERE SMT.DESIGN_CODE = D.DESIGN_CODE   AND SP.SALES_PERS = SMT.SALES_PERS  " +
					" AND SMT.DCR_ID = ? "+ 
					" AND STRG_MEET.EVENT_DATE= ? "+
					" AND STRG_MEET.SALES_PERS = ?"+
					" AND STRG_MEET.STRG_CODE=SMT.STRG_CODE AND STRG_MEET.DCR_ID=SMT.DCR_ID AND STRG_MEET.STRG_TYPE = SCT.TYPE";
			//Added By Prathmesh Jangam on 07-07-2017 for DB2 changes(end) 

			pstmt = conn.prepareStatement(teamSql);
			pstmt.setString(1, dcrId);
			pstmt.setTimestamp( 2, java.sql.Timestamp.valueOf( eventDateDBFmt ) );
			pstmt.setString(3, salesPers);
			rs = pstmt.executeQuery();
			while(rs.next())
			{

				isDetailExist = true;
				String custType = checkNull(rs.getString("STRG_TYPE"));
				// modified by rupali on 21/12/18 for dcr_group related changes
				String dcrGroup = checkNull(rs.getString("DCR_GROUP"));
				//if("D".equalsIgnoreCase(custType))
				if("D".equalsIgnoreCase(dcrGroup))
				{
					valueXmlString.append("<team>\r\n");
					valueXmlString.append("<sales_pers>").append("<![CDATA[").append(rs.getString("SALES_PERS") == null ? "" : rs.getString("SALES_PERS")).append("]]>").append("</sales_pers>\r\n ");
					valueXmlString.append("<cust_name>").append("<![CDATA[").append(rs.getString("STRG_TYPE") == null ? "" : rs.getString("STRG_TYPE")).append("]]>").append("</cust_name>\r\n ");
					valueXmlString.append("<sp_name>").append("<![CDATA[").append(rs.getString("SP_NAME") == null ? "" : rs.getString("SP_NAME")).append("]]>").append("</sp_name>\r\n ");
					valueXmlString.append("<designation>").append("<![CDATA[").append(rs.getString("DESIGNATION") == null ? "" : rs.getString("DESIGNATION")).append("]]>").append("</designation>\r\n ");
					valueXmlString.append("<design_code>").append("<![CDATA[").append(rs.getString("DESIGN_CODE") == null ? "" : rs.getString("DESIGN_CODE")).append("]]>").append("</design_code>\r\n ");
					valueXmlString.append("</team>\r\n");
				}
				// modified by rupali on 21/12/18 for dcr_group related changes
				//else if ("C".equalsIgnoreCase(custType))
				else if ("C".equalsIgnoreCase(dcrGroup))
				{
					valueXmlString.append("<retailerteam>\r\n");
					valueXmlString.append("<sales_pers>").append("<![CDATA[").append(rs.getString("SALES_PERS") == null ? "" : rs.getString("SALES_PERS")).append("]]>").append("</sales_pers>\r\n ");
					valueXmlString.append("<cust_name>").append("<![CDATA[").append(rs.getString("STRG_TYPE") == null ? "" : rs.getString("STRG_TYPE")).append("]]>").append("</cust_name>\r\n ");
					valueXmlString.append("<sp_name>").append("<![CDATA[").append(rs.getString("SP_NAME") == null ? "" : rs.getString("SP_NAME")).append("]]>").append("</sp_name>\r\n ");
					valueXmlString.append("<designation>").append("<![CDATA[").append(rs.getString("DESIGNATION") == null ? "" : rs.getString("DESIGNATION")).append("]]>").append("</designation>\r\n ");
					valueXmlString.append("<design_code>").append("<![CDATA[").append(rs.getString("DESIGN_CODE") == null ? "" : rs.getString("DESIGN_CODE")).append("]]>").append("</design_code>\r\n ");
					valueXmlString.append("</retailerteam>\r\n");

				}
				//added by mrunalini sinkar on 02-may-2017 to show ncw and stockist team data on confirm and delete report (start)
				// modified by rupali on 21/12/18 for dcr_group related changes
				//else if ("S".equalsIgnoreCase(custType))
				else if ("S".equalsIgnoreCase(dcrGroup))
				{
					valueXmlString.append("<StockistTeam>\r\n");
					valueXmlString.append("<sales_pers>").append("<![CDATA[").append(rs.getString("SALES_PERS") == null ? "" : rs.getString("SALES_PERS")).append("]]>").append("</sales_pers>\r\n ");
					valueXmlString.append("<cust_name>").append("<![CDATA[").append(rs.getString("STRG_TYPE") == null ? "" : rs.getString("STRG_TYPE")).append("]]>").append("</cust_name>\r\n ");
					valueXmlString.append("<sp_name>").append("<![CDATA[").append(rs.getString("SP_NAME") == null ? "" : rs.getString("SP_NAME")).append("]]>").append("</sp_name>\r\n ");
					valueXmlString.append("<designation>").append("<![CDATA[").append(rs.getString("DESIGNATION") == null ? "" : rs.getString("DESIGNATION")).append("]]>").append("</designation>\r\n ");
					valueXmlString.append("<design_code>").append("<![CDATA[").append(rs.getString("DESIGN_CODE") == null ? "" : rs.getString("DESIGN_CODE")).append("]]>").append("</design_code>\r\n ");
					valueXmlString.append("</StockistTeam>\r\n");

				}
				// modified by rupali on 21/12/18 for dcr_group related changes
				//else if ("O".equalsIgnoreCase(custType))
				else if ("O".equalsIgnoreCase(dcrGroup))
				{
					valueXmlString.append("<NcwTeam>\r\n");
					valueXmlString.append("<sales_pers>").append("<![CDATA[").append(rs.getString("SALES_PERS") == null ? "" : rs.getString("SALES_PERS")).append("]]>").append("</sales_pers>\r\n ");
					valueXmlString.append("<cust_name>").append("<![CDATA[").append(rs.getString("STRG_TYPE") == null ? "" : rs.getString("STRG_TYPE")).append("]]>").append("</cust_name>\r\n ");
					valueXmlString.append("<sp_name>").append("<![CDATA[").append(rs.getString("SP_NAME") == null ? "" : rs.getString("SP_NAME")).append("]]>").append("</sp_name>\r\n ");
					valueXmlString.append("<designation>").append("<![CDATA[").append(rs.getString("DESIGNATION") == null ? "" : rs.getString("DESIGNATION")).append("]]>").append("</designation>\r\n ");
					valueXmlString.append("<design_code>").append("<![CDATA[").append(rs.getString("DESIGN_CODE") == null ? "" : rs.getString("DESIGN_CODE")).append("]]>").append("</design_code>\r\n ");
					valueXmlString.append("</NcwTeam>\r\n");

				}
				//added by mrunalini sinkar on 02-may-2017 to show ncw team data on confirm and delete report (end)

			}
			
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;	
			
			// added by rupali on 11/09117 for survey form [start]
			// commented and added by rupali on 17/10/17 for making DB2 compatible [start]
			/*String surveySql= "SELECT ROWNUM,DESCR, STRG_TYPE FROM "+
					" (SELECT SB.ITEM_CODE ITEM_CODE,ITEM.DESCR DESCR, STRG_MEET.STRG_TYPE "+
					" FROM STRG_MEET,STRG_BRAND_SURVEY SB "+
					" JOIN ITEM ITEM ON SB.ITEM_CODE = ITEM.ITEM_CODE "+
					" WHERE SB.DCR_ID= ? "+
					" AND STRG_MEET.EVENT_DATE = ? "+
					" AND STRG_MEET.SALES_PERS = ? "+
					" AND STRG_MEET.STRG_CODE=SB.STRG_CODE) ";*/
			String surveySql = "";
			if("ORACLE".equalsIgnoreCase(CommonConstants.DB_NAME))
			{
				surveySql= "SELECT ROWNUM,DESCR, STRG_TYPE, DCR_GROUP,STRG_CODE FROM "+
					" (SELECT SB.ITEM_CODE ITEM_CODE,ITEM.DESCR DESCR, STRG_MEET.STRG_TYPE, SCT.DCR_GROUP,STRG_MEET.STRG_CODE "+
					" FROM STRG_MEET,STRG_BRAND_SURVEY SB "+
					" JOIN ITEM ITEM ON SB.ITEM_CODE = ITEM.ITEM_CODE, STRG_CUST_TYPE SCT "+
					" WHERE SB.DCR_ID= ? "+
					" AND STRG_MEET.EVENT_DATE = ? "+
					" AND STRG_MEET.SALES_PERS = ? "+
					" AND STRG_MEET.STRG_CODE=SB.STRG_CODE AND STRG_MEET.DCR_ID=SB.DCR_ID AND STRG_MEET.STRG_TYPE = SCT.TYPE) ";
			}
			else if("DB2".equalsIgnoreCase(CommonConstants.DB_NAME))
			{
				surveySql= "SELECT SB.ITEM_CODE ITEM_CODE,ITEM.DESCR DESCR, STRG_MEET.STRG_TYPE, ROW_NUMBER() OVER () ROWNUM, SCT.DCR_GROUP,STRG_MEET.STRG_CODE "+
						" FROM STRG_MEET,STRG_BRAND_SURVEY SB "+
						" JOIN ITEM ITEM ON SB.ITEM_CODE = ITEM.ITEM_CODE, STRG_CUST_TYPE SCT "+
						" WHERE SB.DCR_ID= ? "+
						" AND STRG_MEET.EVENT_DATE = ? "+
						" AND STRG_MEET.SALES_PERS = ? "+
						" AND STRG_MEET.STRG_CODE=SB.STRG_CODE AND STRG_MEET.DCR_ID=SB.DCR_ID AND STRG_MEET.STRG_TYPE = SCT.TYPE ";
			}
			// commented and added by rupali on 17/10/17 for making DB2 compatible [end]    
		    pstmt = conn.prepareStatement(surveySql);
			pstmt.setString(1, dcrId);
			pstmt.setTimestamp( 2, java.sql.Timestamp.valueOf( eventDateDBFmt ) );
			pstmt.setString(3, salesPers);
			rs = pstmt.executeQuery();
			while(rs.next())
			{

				isDetailExist = true;
				String custType = checkNull(rs.getString("STRG_TYPE"));
				String dcrGroup = checkNull(rs.getString("DCR_GROUP")); // modified by rupali on 21/12/18 for dcr_group related changes
				// modified by rupali on 21/12/18 for dcr_group related changes
				//if("D".equalsIgnoreCase(custType))
				if("D".equalsIgnoreCase(dcrGroup))
				{
					valueXmlString.append("<surveybrand>\r\n");
					valueXmlString.append("<item_rowNum>").append("<![CDATA[").append(rs.getString("ROWNUM") == null ? "" : rs.getString("ROWNUM")).append("]]>").append("</item_rowNum>\r\n ");
					valueXmlString.append("<cust_name>").append("<![CDATA[").append(rs.getString("STRG_TYPE") == null ? "" : rs.getString("STRG_TYPE")).append("]]>").append("</cust_name>\r\n ");
					valueXmlString.append("<item_descr>").append("<![CDATA[").append(rs.getString("DESCR") == null ? "" : rs.getString("DESCR")).append("]]>").append("</item_descr>\r\n ");
					//valueXmlString.append("<item_pob>").append("<![CDATA[").append(rs.getString("POB") == null ? "" : rs.getString("POB")).append("]]>").append("</item_pob>\r\n ");
					valueXmlString.append("<strg_code>").append("<![CDATA[").append(checkNull(rs.getString("STRG_CODE"))).append("]]>").append("</strg_code>\r\n ");//Added by mrunalini sinkar

					valueXmlString.append("</surveybrand>\r\n");
				}
				
			}
			
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			// added by rupali on 11/09117 for survey form [end]

			// added by rupali on 21/09/18 for survey form [start]
			String surveyFormSql = "";
			if("ORACLE".equalsIgnoreCase(CommonConstants.DB_NAME))
			{
				surveyFormSql= "SELECT ROWNUM,DESCR, STRG_TYPE, RESULT, RESULT_TYPE, DCR_GROUP,STRG_CODE FROM (SELECT SR.SURVEY_CODE SURVEY_CODE, " +
							   "SM.DESCR DESCR, STRG_MEET.STRG_TYPE, SR.RESULT, SM.RESULT_TYPE, SCT.DCR_GROUP,STRG_MEET.STRG_CODE "+
							   "FROM STRG_MEET,STRG_SURV_RES SR JOIN SURVEY_MASTER SM ON SR.SURVEY_CODE = SM.SURVEY_CODE, STRG_CUST_TYPE SCT  "+
							   "WHERE SR.DCR_ID= ? "+
							   "AND STRG_MEET.EVENT_DATE = ? "+
							   "AND STRG_MEET.SALES_PERS = ? "+
							   "AND STRG_MEET.STRG_CODE=SR.STRG_CODE AND STRG_MEET.DCR_ID=SR.DCR_ID AND STRG_MEET.STRG_TYPE = SCT.TYPE)";
			}
			else if("DB2".equalsIgnoreCase(CommonConstants.DB_NAME))
			{
				surveyFormSql= "SELECT SR.SURVEY_CODE SURVEY_CODE, SM.DESCR DESCR, STRG_MEET.STRG_TYPE, SM.RESULT, " +
						"SM.RESULT_TYPE, ROW_NUMBER() OVER () ROWNUM, SCT.DCR_GROUP,STRG_MEET.STRG_CODE "+
						" FROM STRG_MEET,STRG_SURV_RES SR "+
						" JOIN SURVEY_MASTER SM ON SR.SURVEY_CODE = SM.SURVEY_CODE, STRG_CUST_TYPE SCT "+
						" WHERE SR.DCR_ID= ? "+
						" AND STRG_MEET.EVENT_DATE = ? "+
						" AND STRG_MEET.SALES_PERS = ? "+
						" AND STRG_MEET.STRG_CODE=SR.STRG_CODE AND STRG_MEET.DCR_ID=SR.DCR_ID AND STRG_MEET.STRG_TYPE = SCT.TYPE ";
			}
		    pstmt = conn.prepareStatement(surveyFormSql);
			pstmt.setString(1, dcrId);
			pstmt.setTimestamp( 2, java.sql.Timestamp.valueOf( eventDateDBFmt ) );
			pstmt.setString(3, salesPers);
			rs = pstmt.executeQuery();
			while(rs.next())
			{

				isDetailExist = true;
				String custType = checkNull(rs.getString("STRG_TYPE"));
				String resultType = checkNull(rs.getString("RESULT_TYPE"));
				String result = checkNull(rs.getString("RESULT"));
				String dcrGroup = checkNull(rs.getString("DCR_GROUP")); // modified by rupali on 21/12/18 for dcr_group related changes

				if("D".equalsIgnoreCase(resultType) || "L".equalsIgnoreCase(resultType))
				{
					if("Y".equalsIgnoreCase(result))
					{
						result = "Yes";
					}
					else
					{
						result = "No";
					}
				}
				// modified by rupali on 21/12/18 for dcr_group related changes
				//if("D".equalsIgnoreCase(custType))
				if("D".equalsIgnoreCase(dcrGroup))
				{
					valueXmlString.append("<survey>\r\n");
					valueXmlString.append("<survey_rownum>").append("<![CDATA[").append(rs.getString("ROWNUM") == null ? "" : rs.getString("ROWNUM")).append("]]>").append("</survey_rownum>\r\n ");
					valueXmlString.append("<cust_name>").append("<![CDATA[").append(rs.getString("STRG_TYPE") == null ? "" : rs.getString("STRG_TYPE")).append("]]>").append("</cust_name>\r\n ");
					valueXmlString.append("<survey_descr>").append("<![CDATA[").append(rs.getString("DESCR") == null ? "" : rs.getString("DESCR")).append("]]>").append("</survey_descr>\r\n ");
					valueXmlString.append("<survey_result>").append("<![CDATA[").append(result).append("]]>").append("</survey_result>\r\n ");
					valueXmlString.append("<strg_code>").append("<![CDATA[").append(checkNull(rs.getString("STRG_CODE"))).append("]]>").append("</strg_code>\r\n ");//Added by mrunalini sinkar

					valueXmlString.append("</survey>\r\n");
				}
				// modified by rupali on 21/12/18 for dcr_group related changes
				//else if ("C".equalsIgnoreCase(custType))
				else if ("C".equalsIgnoreCase(dcrGroup))
				{
					valueXmlString.append("<retailersurvey>\r\n");
					valueXmlString.append("<survey_rownum>").append("<![CDATA[").append(rs.getString("ROWNUM") == null ? "" : rs.getString("ROWNUM")).append("]]>").append("</survey_rownum>\r\n ");
					valueXmlString.append("<cust_name>").append("<![CDATA[").append(rs.getString("STRG_TYPE") == null ? "" : rs.getString("STRG_TYPE")).append("]]>").append("</cust_name>\r\n ");
					valueXmlString.append("<survey_descr>").append("<![CDATA[").append(rs.getString("DESCR") == null ? "" : rs.getString("DESCR")).append("]]>").append("</survey_descr>\r\n ");
					valueXmlString.append("<survey_result>").append("<![CDATA[").append(result).append("]]>").append("</survey_result>\r\n ");
					valueXmlString.append("<strg_code>").append("<![CDATA[").append(checkNull(rs.getString("STRG_CODE"))).append("]]>").append("</strg_code>\r\n ");//Added by mrunalini sinkar

					valueXmlString.append("</retailersurvey>\r\n");

				}
				// modified by rupali on 21/12/18 for dcr_group related changes
				//else if ("S".equalsIgnoreCase(custType))
				else if ("S".equalsIgnoreCase(dcrGroup))
				{
					valueXmlString.append("<stockistsurvey>\r\n");
					valueXmlString.append("<survey_rownum>").append("<![CDATA[").append(rs.getString("ROWNUM") == null ? "" : rs.getString("ROWNUM")).append("]]>").append("</survey_rownum>\r\n ");
					valueXmlString.append("<cust_name>").append("<![CDATA[").append(rs.getString("STRG_TYPE") == null ? "" : rs.getString("STRG_TYPE")).append("]]>").append("</cust_name>\r\n ");
					valueXmlString.append("<survey_descr>").append("<![CDATA[").append(rs.getString("DESCR") == null ? "" : rs.getString("DESCR")).append("]]>").append("</survey_descr>\r\n ");
					valueXmlString.append("<survey_result>").append("<![CDATA[").append(result).append("]]>").append("</survey_result>\r\n ");
					valueXmlString.append("<strg_code>").append("<![CDATA[").append(checkNull(rs.getString("STRG_CODE"))).append("]]>").append("</strg_code>\r\n ");//Added by mrunalini sinkar

					valueXmlString.append("</stockistsurvey>\r\n");

				}
				// modified by rupali on 21/12/18 for dcr_group related changes
				//else if ("O".equalsIgnoreCase(custType))
				else if ("O".equalsIgnoreCase(dcrGroup))
				{
					valueXmlString.append("<ncwsurvey>\r\n");
					valueXmlString.append("<survey_rownum>").append("<![CDATA[").append(rs.getString("ROWNUM") == null ? "" : rs.getString("ROWNUM")).append("]]>").append("</survey_rownum>\r\n ");
					valueXmlString.append("<cust_name>").append("<![CDATA[").append(rs.getString("STRG_TYPE") == null ? "" : rs.getString("STRG_TYPE")).append("]]>").append("</cust_name>\r\n ");
					valueXmlString.append("<survey_descr>").append("<![CDATA[").append(rs.getString("DESCR") == null ? "" : rs.getString("DESCR")).append("]]>").append("</survey_descr>\r\n ");
					valueXmlString.append("<survey_result>").append("<![CDATA[").append(result).append("]]>").append("</survey_result>\r\n ");
					valueXmlString.append("<strg_code>").append("<![CDATA[").append(checkNull(rs.getString("STRG_CODE"))).append("]]>").append("</strg_code>\r\n ");//Added by mrunalini sinkar

					valueXmlString.append("</ncwsurvey>\r\n");

				}
			}
			
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			// added by rupali on 21/09/18 for survey form [end]
			//Addedy by Bhagyashri Tfor Invoice Form no[start]
			DecimalFormat df = new DecimalFormat("###.##");
			String invoiceSql = "SELECT SMIN.TRAN_ID,SMIN.QUANTITY QUANTITY,ITEM.DESCR DESCR,ITEM.HSN_NO ,SMIN.STRG_CODE,STRG_MEET.STRG_TYPE, "
            		+ "SCT.DCR_GROUP,SMIN.RATE,SMIN.TAX_AMT_INV  "
            		+ "FROM STRG_MEET,STRG_MEET_INVOICE SMIN  JOIN ITEM ITEM ON SMIN.ITEM_CODE = ITEM.ITEM_CODE,  "
            		+ "STRG_CUST_TYPE SCT  WHERE SMIN.DCR_ID=  ?  "
            		+ "AND STRG_MEET.EVENT_DATE = ?  AND STRG_MEET.SALES_PERS = ?  AND STRG_MEET.STRG_CODE=SMIN.STRG_CODE "
            		+ "AND STRG_MEET.DCR_ID=SMIN.DCR_ID  AND STRG_MEET.STRG_TYPE = SCT.TYPE AND STRG_MEET.TRAN_ID = SMIN.TRAN_ID";
 

		    pstmt = conn.prepareStatement(invoiceSql);
			pstmt.setString(1, dcrId);
			pstmt.setTimestamp( 2, java.sql.Timestamp.valueOf( eventDateDBFmt ) );
			pstmt.setString(3, salesPers);
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				isDetailExist = true;
				String invoiceTranId = "";
				String custType = checkNull(rs.getString("STRG_TYPE"));
				String dcrGroup = checkNull(rs.getString("DCR_GROUP"));
				String quantity = checkNull(rs.getString("QUANTITY"));
				String rate = checkNull(rs.getString("RATE"));
				String taxAmount = checkNull(rs.getString("TAX_AMT_INV"));
				invoiceTranId = checkNull(rs.getString("TRAN_ID"));
				double tempQuantity = 0d;
				double tempTaxAmt= 0d;
				double tempTotalGst= 0d;
				double selSgstAmt=0d;
				double selCgstAmt=0d;
				double selValueTotal=0d;
				double temprate =0d;
				if( rate.trim().length()>0 && quantity.trim().length()>0 && taxAmount.trim().length()>0 && quantity != null )
				{
					
					try
					{
						tempQuantity =Double.parseDouble(quantity);
						temprate =Double.parseDouble(rate);
						tempTaxAmt =Double.parseDouble(taxAmount);
						tempTotalGst=(temprate * tempQuantity);
						selSgstAmt=(temprate * tempQuantity * (tempTaxAmt/200));
						selCgstAmt = selSgstAmt;
						selValueTotal = (tempTotalGst + selCgstAmt + selSgstAmt );
						
					}
					catch(NumberFormatException e)
					{
						
					}
				}
				if("D".equalsIgnoreCase(dcrGroup) && !"PR".equalsIgnoreCase(actTypeNew))
				{
					valueXmlString.append("<invoice>\r\n");
					valueXmlString.append("<tran_id><![CDATA[").append(invoiceTranId).append("]]></tran_id>\r\n");
					//valueXmlString.append("<item_rowNum>").append("<![CDATA[").append(rs.getString("ROWNUM") == null ? "" : rs.getString("ROWNUM")).append("]]>").append("</item_rowNum>\r\n ");
					valueXmlString.append("<cust_name>").append("<![CDATA[").append(rs.getString("STRG_TYPE") == null ? "" : rs.getString("STRG_TYPE")).append("]]>").append("</cust_name>\r\n ");
					valueXmlString.append("<quantity>").append("<![CDATA[").append(rs.getString("QUANTITY") == null ? "" : rs.getString("QUANTITY")).append("]]>").append("</quantity>\r\n ");
					valueXmlString.append("<rate>").append("<![CDATA[").append(rs.getString("RATE") == null ? "" : rs.getString("RATE")).append("]]>").append("</rate>\r\n ");
					valueXmlString.append("<hsn_number>").append("<![CDATA[").append(rs.getString("HSN_NO") == null ? "" : rs.getString("HSN_NO")).append("]]>").append("</hsn_number>\r\n ");
					valueXmlString.append("<item_descr>").append("<![CDATA[").append(rs.getString("DESCR") == null ? "" : rs.getString("DESCR")).append("]]>").append("</item_descr>\r\n ");
					//valueXmlString.append("<value>").append("<![CDATA[").append(rs.getString("VALUE") == null ? "" : rs.getString("VALUE")).append("]]>").append("</value>\r\n ");
					valueXmlString.append("<strg_code>").append("<![CDATA[").append(rs.getString("STRG_CODE") == null ? "" : rs.getString("STRG_CODE")).append("]]>").append("</strg_code>\r\n ");
					valueXmlString.append("<value>").append(df.format(tempTotalGst)).append("</value>\n");
					valueXmlString.append("<total_sgst_amount><![CDATA[" ).append(df.format(selSgstAmt)).append( "]]></total_sgst_amount>\r\n" );
					valueXmlString.append("<total_cgst_amount><![CDATA[" ).append(df.format(selCgstAmt)).append( "]]></total_cgst_amount>\r\n" );
					valueXmlString.append("<total_amount><![CDATA[" ).append(df.format(selValueTotal)).append( "]]></total_amount>\r\n" );
					valueXmlString.append("</invoice>\r\n");
				}
				else if ("C".equalsIgnoreCase(dcrGroup))
				{
					valueXmlString.append("<retailerinvoice>\r\n");
					valueXmlString.append("<tran_id><![CDATA[").append(invoiceTranId).append("]]></tran_id>\r\n");
					valueXmlString.append("<cust_name>").append("<![CDATA[").append(rs.getString("STRG_TYPE") == null ? "" : rs.getString("STRG_TYPE")).append("]]>").append("</cust_name>\r\n ");
					valueXmlString.append("<quantity>").append("<![CDATA[").append(rs.getString("QUANTITY") == null ? "" : rs.getString("QUANTITY")).append("]]>").append("</quantity>\r\n ");
					valueXmlString.append("<rate>").append("<![CDATA[").append(rs.getString("RATE") == null ? "" : rs.getString("RATE")).append("]]>").append("</rate>\r\n ");
					valueXmlString.append("<hsn_number>").append("<![CDATA[").append(rs.getString("HSN_NO") == null ? "" : rs.getString("HSN_NO")).append("]]>").append("</hsn_number>\r\n ");
					valueXmlString.append("<item_descr>").append("<![CDATA[").append(rs.getString("DESCR") == null ? "" : rs.getString("DESCR")).append("]]>").append("</item_descr>\r\n ");
					//valueXmlString.append("<value>").append("<![CDATA[").append(rs.getString("VALUE") == null ? "" : rs.getString("VALUE")).append("]]>").append("</value>\r\n ");
					valueXmlString.append("<strg_code>").append("<![CDATA[").append(rs.getString("STRG_CODE") == null ? "" : rs.getString("STRG_CODE")).append("]]>").append("</strg_code>\r\n ");
					valueXmlString.append("<value>").append(df.format(tempTotalGst)).append("</value>\n");
					valueXmlString.append("<total_sgst_amount><![CDATA[" ).append(df.format(selSgstAmt)).append( "]]></total_sgst_amount>\r\n" );
					valueXmlString.append("<total_cgst_amount><![CDATA[" ).append(df.format(selCgstAmt)).append( "]]></total_cgst_amount>\r\n" );
					valueXmlString.append("<total_amount><![CDATA[" ).append(df.format(selValueTotal)).append( "]]></total_amount>\r\n" );
					valueXmlString.append("</retailerinvoice>\r\n");
		
				}
				else if ("S".equalsIgnoreCase(dcrGroup))
				{
					valueXmlString.append("<Stockinvoice>\r\n");
					valueXmlString.append("<tran_id><![CDATA[").append(invoiceTranId).append("]]></tran_id>\r\n");
					valueXmlString.append("<cust_name>").append("<![CDATA[").append(rs.getString("STRG_TYPE") == null ? "" : rs.getString("STRG_TYPE")).append("]]>").append("</cust_name>\r\n ");
					valueXmlString.append("<quantity>").append("<![CDATA[").append(rs.getString("QUANTITY") == null ? "" : rs.getString("QUANTITY")).append("]]>").append("</quantity>\r\n ");
					valueXmlString.append("<rate>").append("<![CDATA[").append(rs.getString("RATE") == null ? "" : rs.getString("RATE")).append("]]>").append("</rate>\r\n ");
					valueXmlString.append("<hsn_number>").append("<![CDATA[").append(rs.getString("HSN_NO") == null ? "" : rs.getString("HSN_NO")).append("]]>").append("</hsn_number>\r\n ");
					valueXmlString.append("<item_descr>").append("<![CDATA[").append(rs.getString("DESCR") == null ? "" : rs.getString("DESCR")).append("]]>").append("</item_descr>\r\n ");
					//valueXmlString.append("<value>").append("<![CDATA[").append(rs.getString("VALUE") == null ? "" : rs.getString("VALUE")).append("]]>").append("</value>\r\n ");
					valueXmlString.append("<strg_code>").append("<![CDATA[").append(rs.getString("STRG_CODE") == null ? "" : rs.getString("STRG_CODE")).append("]]>").append("</strg_code>\r\n ");
					valueXmlString.append("<value>").append(df.format(tempTotalGst)).append("</value>\n");
					valueXmlString.append("<total_sgst_amount><![CDATA[" ).append(df.format(selSgstAmt)).append( "]]></total_sgst_amount>\r\n" );
					valueXmlString.append("<total_cgst_amount><![CDATA[" ).append(df.format(selCgstAmt)).append( "]]></total_cgst_amount>\r\n" );
					valueXmlString.append("<total_amount><![CDATA[" ).append(df.format(selValueTotal)).append( "]]></total_amount>\r\n" );
					valueXmlString.append("</Stockinvoice>\r\n");
		
				}
				else if ("O".equalsIgnoreCase(dcrGroup))
				{
					valueXmlString.append("<Ncwinvoice>\r\n");
					valueXmlString.append("<tran_id><![CDATA[").append(invoiceTranId).append("]]></tran_id>\r\n");
					valueXmlString.append("<cust_name>").append("<![CDATA[").append(rs.getString("STRG_TYPE") == null ? "" : rs.getString("STRG_TYPE")).append("]]>").append("</cust_name>\r\n ");
					valueXmlString.append("<quantity>").append("<![CDATA[").append(rs.getString("QUANTITY") == null ? "" : rs.getString("QUANTITY")).append("]]>").append("</quantity>\r\n ");
					valueXmlString.append("<rate>").append("<![CDATA[").append(rs.getString("RATE") == null ? "" : rs.getString("RATE")).append("]]>").append("</rate>\r\n ");
					valueXmlString.append("<hsn_number>").append("<![CDATA[").append(rs.getString("HSN_NO") == null ? "" : rs.getString("HSN_NO")).append("]]>").append("</hsn_number>\r\n ");
					valueXmlString.append("<item_descr>").append("<![CDATA[").append(rs.getString("DESCR") == null ? "" : rs.getString("DESCR")).append("]]>").append("</item_descr>\r\n ");
					//valueXmlString.append("<value>").append("<![CDATA[").append(rs.getString("VALUE") == null ? "" : rs.getString("VALUE")).append("]]>").append("</value>\r\n ");
					valueXmlString.append("<strg_code>").append("<![CDATA[").append(rs.getString("STRG_CODE") == null ? "" : rs.getString("STRG_CODE")).append("]]>").append("</strg_code>\r\n ");
					valueXmlString.append("<value>").append(df.format(tempTotalGst)).append("</value>\n");
					valueXmlString.append("<total_sgst_amount><![CDATA[" ).append(df.format(selSgstAmt)).append( "]]></total_sgst_amount>\r\n" );
					valueXmlString.append("<total_cgst_amount><![CDATA[" ).append(df.format(selCgstAmt)).append( "]]></total_cgst_amount>\r\n" );
					valueXmlString.append("<total_amount><![CDATA[" ).append(df.format(selValueTotal)).append( "]]></total_amount>\r\n" );
					valueXmlString.append("</Ncwinvoice>\r\n");
		
				}
		
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			//Addedy by Bhagyashri T for Invoice Form no[end]
			//Addedy by Bhagyashri T for Collection Form no[start]
			String collectionSql = "SELECT SMC.BILL_DATE,SMC.REF_DATE,SMC.PAY_MODE ,SMC.LINE_NO,SMC.STRG_CODE, "
            		+ "SMC.TRAN_ID,SMC.DCR_ID,SMC.REF_NO,SMC.REF_BANK,SCT.DCR_GROUP  "
            		+ "FROM STRG_MEET,STRG_MEET_COLLECT SMC,STRG_CUST_TYPE SCT WHERE SMC.DCR_ID=  ?  "
            		+ "AND STRG_MEET.EVENT_DATE = ?  AND STRG_MEET.SALES_PERS = ?  AND STRG_MEET.STRG_CODE=SMC.STRG_CODE "
            		+ "AND STRG_MEET.DCR_ID=SMC.DCR_ID  AND STRG_MEET.STRG_TYPE = SCT.TYPE AND STRG_MEET.TRAN_ID = SMC.TRAN_ID";
 

		    pstmt = conn.prepareStatement(collectionSql);
			pstmt.setString(1, dcrId);
			pstmt.setTimestamp( 2, java.sql.Timestamp.valueOf( eventDateDBFmt ) );
			pstmt.setString(3, salesPers);
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				isDetailExist = true;
				String collectionTranId = "";
				String dcrGroup = checkNull(rs.getString("DCR_GROUP"));
				collectionTranId = checkNull(rs.getString("TRAN_ID"));
				if("D".equalsIgnoreCase(dcrGroup) && !"PR".equalsIgnoreCase(actTypeNew))
				{
					valueXmlString.append("<collection>\r\n");
					valueXmlString.append("<tran_id><![CDATA[").append(collectionTranId).append("]]></tran_id>\r\n");
					valueXmlString.append("<strg_code><![CDATA[").append( checkNull(rs.getString("STRG_CODE")) ).append("]]></strg_code>\r\n");
					valueXmlString.append("<pay_mode><![CDATA[").append( checkNull(rs.getString("PAY_MODE")) ).append("]]></pay_mode>\r\n");
					valueXmlString.append("</collection>\r\n");
				}
				else if ("C".equalsIgnoreCase(dcrGroup))
				{
					valueXmlString.append("<retailercollection>\r\n");
					valueXmlString.append("<tran_id><![CDATA[").append(collectionTranId).append("]]></tran_id>\r\n");
					valueXmlString.append("<strg_code><![CDATA[").append( checkNull(rs.getString("STRG_CODE")) ).append("]]></strg_code>\r\n");
					valueXmlString.append("<pay_mode><![CDATA[").append( checkNull(rs.getString("PAY_MODE")) ).append("]]></pay_mode>\r\n");
					valueXmlString.append("</retailercollection>\r\n");
		
				}
				else if ("S".equalsIgnoreCase(dcrGroup))
				{
					valueXmlString.append("<Stockcollection>\r\n");
					valueXmlString.append("<tran_id><![CDATA[").append(collectionTranId).append("]]></tran_id>\r\n");
					valueXmlString.append("<strg_code><![CDATA[").append( checkNull(rs.getString("STRG_CODE")) ).append("]]></strg_code>\r\n");
					valueXmlString.append("<pay_mode><![CDATA[").append( checkNull(rs.getString("PAY_MODE")) ).append("]]></pay_mode>\r\n");
					valueXmlString.append("</Stockcollection>\r\n");
		
				}
				else if ("O".equalsIgnoreCase(dcrGroup))
				{
					valueXmlString.append("<Ncwcollection>\r\n");
					valueXmlString.append("<tran_id><![CDATA[").append(collectionTranId).append("]]></tran_id>\r\n");
					valueXmlString.append("<strg_code><![CDATA[").append( checkNull(rs.getString("STRG_CODE")) ).append("]]></strg_code>\r\n");
					valueXmlString.append("<pay_mode><![CDATA[").append( checkNull(rs.getString("PAY_MODE")) ).append("]]></pay_mode>\r\n");
					valueXmlString.append("</Ncwcollection>\r\n");
		
				}
		
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			//Addedy by Bhagyashri T for Collection Form no[End]
			//Getting subordinate details : START
			String workWtithSQL = "SELECT DISTINCT ST.SPRS_CODE__WW,SP.SP_NAME FROM SPRS_TRAVEL ST, SALES_PERS SP WHERE ST.SPRS_CODE__WW = SP.SALES_PERS AND ST.SALES_PERS = ? AND ST.TRAVEL_DATE= ?";
			PreparedStatement pstmtWorkWith = conn.prepareStatement(workWtithSQL);
			pstmtWorkWith.setString(1, salesPers);
			pstmtWorkWith.setTimestamp( 2, java.sql.Timestamp.valueOf( eventDateDBFmt ) );
			
			ResultSet rsWorkWith = pstmtWorkWith.executeQuery();
			while(rsWorkWith.next())
			{
				valueXmlString.append("<workwith>\r\n");
				valueXmlString.append("<sales_pers>").append("<![CDATA[").append(rsWorkWith.getString("SPRS_CODE__WW") == null ? "" : rsWorkWith.getString("SPRS_CODE__WW")).append("]]>").append("</sales_pers>\r\n ");
				valueXmlString.append("<sp_name>").append("<![CDATA[").append(rsWorkWith.getString("SP_NAME") == null ? "" : rsWorkWith.getString("SP_NAME")).append("]]>").append("</sp_name>\r\n ");
				valueXmlString.append("</workwith>\r\n");
			}
			
			if(rsWorkWith != null)
			{
				rsWorkWith.close();
				rsWorkWith = null;
			}
			if(pstmtWorkWith != null)
			{
				pstmtWorkWith.close();
				pstmtWorkWith = null;
			}
			//Getting subordinate details : END
			valueXmlString.append("</DARDetails>");
			
			valueXmlString.append("<PrDetails>");
			
			System.out.println("In side Prescription DCR......");
			String sqlEditPr  ="SELECT STRG_MEET.*,LOCALITY.DESCR LOC_DESCR,FIELDACTIVITY.ACTIVITY_TYPE ACT_TYPE,"+    
				 	" UPPER(STRG_CUSTOMER.FIRST_NAME)||' '||UPPER(STRG_CUSTOMER.LAST_NAME) AS SC_NAME,"+ 
					" STRG_CUSTOMER.ADDR1,STRG_CUSTOMER.ADDR2,STRG_CUSTOMER.ADDR3, STRG_MEET.STRG_TYPE AS CUST_TYPE, "+ 
					" (CASE WHEN STRG_MEET.STRG_TYPE = 'D' THEN 1  WHEN STRG_MEET.STRG_TYPE='R' THEN 2  WHEN STRG_MEET.STRG_TYPE='M' THEN 3 ELSE 4 END) AS CUST_TYPE_SEQ "+
					" FROM FIELDACTIVITY,STRG_MEET LEFT OUTER JOIN STRG_CUSTOMER ON STRG_MEET.STRG_CODE = STRG_CUSTOMER.SC_CODE "+
					" LEFT OUTER JOIN LOCALITY ON STRG_MEET.LOCALITY_CODE = LOCALITY.LOCALITY_CODE " +
					" LEFT OUTER JOIN SPRS_ACT_TRAN ON STRG_MEET.DCR_ID = SPRS_ACT_TRAN.DCR_ID  "+
					" WHERE STRG_MEET.EVENT_TYPE =FIELDACTIVITY.ACTIVITY_CODE"+
					" AND STRG_MEET.SALES_PERS = ? "+
					" AND STRG_MEET.EVENT_DATE = ? "+
					" AND STRG_CUSTOMER.CUST_TYPE  IN ('D') " + 
					" AND STRG_MEET.EVENT_TYPE  IN ('PR') " + 
					" AND (CASE WHEN SPRS_ACT_TRAN.CONFIRMED IS NULL THEN 'N' ELSE SPRS_ACT_TRAN.CONFIRMED END) ='N' "+
					" ORDER BY CUST_TYPE_SEQ, STRG_MEET.SHORT_ID ";
			
			
			//boolean leaveFlg=false;
			String prDcrId = "";
			pstmt =  conn.prepareStatement( sqlEditPr );
			pstmt.setString(1, salesPers);
			pstmt.setTimestamp( 2, java.sql.Timestamp.valueOf( eventDateDBFmt ) );
			
			rs = pstmt.executeQuery();
			
			while(rs.next())
			{
				leaveFlg= true;

				String actypeDB = checkNull(rs.getString("ACT_TYPE"));						
				String strgCode = checkNull(rs.getString("STRG_CODE"));
				prDcrId = checkNull(rs.getString("DCR_ID"));
				String custType = rs.getString("CUST_TYPE") == null ?"":rs.getString("CUST_TYPE");
				
				if("D".equalsIgnoreCase(custType) && "PR".equalsIgnoreCase(actypeDB))
				{
					valueXmlString.append( "<Detail13 domID='"+domID+"' selected = 'Y'>\r\n" );
					valueXmlString.append( "<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\"/>\r\n");
					valueXmlString.append( "<strg_code><![CDATA[" ).append( checkNull(rs.getString("STRG_CODE")).trim()).append( "]]></strg_code>\r\n");							
					valueXmlString.append( "<cust_name><![CDATA[" ).append( checkNull(rs.getString("SC_NAME")).trim()).append( "]]></cust_name>\r\n");														
					valueXmlString.append( "<sales_pers><![CDATA[" ).append(checkNull(salesPers)).append( "]]></sales_pers>\r\n" );
					valueXmlString.append( "<event_date><![CDATA[" ).append(eventDate).append( "]]></event_date>\r\n" );				
					valueXmlString.append( "<no_of_outlet><![CDATA[" ).append(checkNull(rs.getString("NO_OF_OUTLET"))).append( "]]></no_of_outlet>\r\n" );
					valueXmlString.append( "<cust_type><![CDATA["+custType+"]]></cust_type>\r\n");														
					valueXmlString.append( "<locality_descr><![CDATA[" ).append( checkNull(rs.getString("LOC_DESCR")).trim()).append( "]]></locality_descr>\r\n");
					
					valueXmlString.append( "<sku_value><![CDATA[" ).append( checkNull(rs.getString("SKU_VALUE")).trim()).append( "]]></sku_value>\r\n");
					
					String callOutCome = checkNull(rs.getString("CALL_OUTCOME"));
					valueXmlString.append( "<call_outcome><![CDATA[" ).append(checkNull(callOutCome)).append( "]]></call_outcome>\r\n" );
					if(callOutCome.equalsIgnoreCase("4"))
					{
						valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Very Positive").append( "]]></calloutcome_descr>\r\n" );
					}
					else if(callOutCome.equalsIgnoreCase("3"))
					{
						valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Average").append( "]]></calloutcome_descr>\r\n" );
					}
					else if(callOutCome.equalsIgnoreCase("2"))
					{
						valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Below Average").append( "]]></calloutcome_descr>\r\n" );
					}
					else if(callOutCome.equalsIgnoreCase("1"))
					{
						valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Negative").append( "]]></calloutcome_descr>\r\n" );
					}
					else if(callOutCome.equalsIgnoreCase("0"))
					{
						valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Refused").append( "]]></calloutcome_descr>\r\n" );
					}
					else if(callOutCome.equalsIgnoreCase("5"))
					{
						valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Supporter").append( "]]></calloutcome_descr>\r\n" );
					}
					else if(callOutCome.equalsIgnoreCase("6"))
					{
						valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Believer").append( "]]></calloutcome_descr>\r\n" );
					}
					else if(callOutCome.equalsIgnoreCase("7"))
					{
						valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Non Believer").append( "]]></calloutcome_descr>\r\n" );
					}
					// added by rupali on 03/05/18 for display call outcame data in confirm and delete report [start]
					else if(callOutCome.equalsIgnoreCase("8"))
					{
						valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Obj. Not Met").append( "]]></calloutcome_descr>\r\n" );
					}
					else if(callOutCome.equalsIgnoreCase("9"))
					{
						valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Obj. Met").append( "]]></calloutcome_descr>\r\n" );
					}
					// added by rupali on 03/05/18 for display call outcame data in confirm and delete report [end]
					
					valueXmlString.append( "</Detail13>\r\n" );
			
			
				}
			}
			
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			
			
			System.out.println("prDcrId::["+prDcrId+"]");
			//Added By Prathmesh Jangam on 07-07-2017 for DB2 changes(start) 

			String orderSql= "";
			if("ORACLE".equalsIgnoreCase(CommonConstants.DB_NAME))
			{
				orderSql = "SELECT ROWNUM,CUST_NAME,QUANTITY,VALUE ,DESCR , CUST_TYPE ,STRG_CODE " +
					"FROM  (SELECT SMI.QUANTITY QUANTITY,ITEM.DESCR DESCR ,  SC.FIRST_NAME||' '||SC.LAST_NAME AS CUST_NAME ,  SC.CUST_TYPE  , " +
					"SMI.value , SMI.STRG_CODE " +
					"FROM STRG_MEET_ORDER SMI  JOIN ITEM ITEM ON SMI.ITEM_CODE = ITEM.ITEM_CODE  " +
					"JOIN STRG_CUSTOMER SC  ON SMI.STRG_CODE=SC.SC_CODE   " +
					"WHERE SMI.DCR_ID=  ? )";
			}
			else if("DB2".equalsIgnoreCase(CommonConstants.DB_NAME))
			{
				orderSql = "SELECT SMI.QUANTITY QUANTITY,ITEM.DESCR DESCR ,  SC.FIRST_NAME||' '||SC.LAST_NAME AS CUST_NAME ,  SC.CUST_TYPE  , " +
					"SMI.value , SMI.STRG_CODE, ROW_NUMBER() OVER () ROWNUM  " +
					"FROM STRG_MEET_ORDER SMI  JOIN ITEM ITEM ON SMI.ITEM_CODE = ITEM.ITEM_CODE  " +
					"JOIN STRG_CUSTOMER SC  ON SMI.STRG_CODE=SC.SC_CODE   " +
					"WHERE SMI.DCR_ID=  ? ";
			}
			//Added By Prathmesh Jangam on 07-07-2017 for DB2 changes(end) 

		    pstmt = conn.prepareStatement(orderSql);
			pstmt.setString(1, prDcrId);
			rs = pstmt.executeQuery();
			while(rs.next())
			{

				isDetailExist = true;
				String custType = checkNull(rs.getString("CUST_TYPE"));
				
				if("D".equalsIgnoreCase(custType))
				{
					valueXmlString.append("<Detail14>\r\n");
					valueXmlString.append("<item_rowNum>").append("<![CDATA[").append(rs.getString("ROWNUM") == null ? "" : rs.getString("ROWNUM")).append("]]>").append("</item_rowNum>\r\n ");
					valueXmlString.append("<cust_name>").append("<![CDATA[").append(rs.getString("CUST_NAME") == null ? "" : rs.getString("CUST_NAME")).append("]]>").append("</cust_name>\r\n ");
					valueXmlString.append("<quantity>").append("<![CDATA[").append(rs.getString("QUANTITY") == null ? "" : rs.getString("QUANTITY")).append("]]>").append("</quantity>\r\n ");
					valueXmlString.append("<item_descr>").append("<![CDATA[").append(rs.getString("DESCR") == null ? "" : rs.getString("DESCR")).append("]]>").append("</item_descr>\r\n ");
					valueXmlString.append("<value>").append("<![CDATA[").append(rs.getString("VALUE") == null ? "" : rs.getString("VALUE")).append("]]>").append("</value>\r\n ");
					valueXmlString.append("</Detail14>\r\n");
				}
				
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			//added by Mrunalini sinkar on 17-april-2017 to show the display details of prescription report(start)
			String prDisplaySql = "SELECT SC.SC_CODE, SC.FIRST_NAME||' '||SC.LAST_NAME AS CUST_NAME, SC.CUST_TYPE,  SD.DISPLAY_AREA, SD.DOC_ID " +
					"FROM STRG_ITEM_DISPLAY SD, STRG_CUSTOMER SC " +
					"WHERE  SD.STRG_CODE = SC.SC_CODE and SD.DCR_ID =  ? ";
			pstmt = conn.prepareStatement(prDisplaySql);
			pstmt.setString(1, prDcrId);
			rs = pstmt.executeQuery();
			
			while(rs.next())
			{

				isDetailExist = true;
				String custType = checkNull(rs.getString("CUST_TYPE"));
				
				if("D".equalsIgnoreCase(custType))
				{
					valueXmlString.append("<Detail15>\r\n");
					valueXmlString.append("<display_area>").append("<![CDATA[").append(rs.getString("DISPLAY_AREA") == null ? "" : rs.getString("DISPLAY_AREA")).append("]]>").append("</display_area>\r\n ");
					valueXmlString.append("<cust_name>").append("<![CDATA[").append(rs.getString("CUST_NAME") == null ? "" : rs.getString("CUST_NAME")).append("]]>").append("</cust_name>\r\n ");
					valueXmlString.append("<doc_id>").append("<![CDATA[").append(rs.getString("DOC_ID") == null ? "" : rs.getString("DOC_ID")).append("]]>").append("</doc_id>\r\n ");
					valueXmlString.append("</Detail15>\r\n");
				}
				
			}
			
			
			
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			//added by Mrunalini sinkar on 17-april-2017 to show the display details of prescription report(end)

			
			valueXmlString.append("</PrDetails>");
				
			//Added By Nilesh for Daily Dashboard Changes Start :21-09-2021	
			valueXmlString.append("<DailyDashboard>");
			
			//String appendSqlStr = " And SM.Sales_Pers In ( Select Emp_Code From Employee Start With Emp_code = (Select Emp_Code From Users Where Code = "+salesPers+") Connect By Prior Emp_Code =Report_To )" ;
                      
			
			StringBuilder builder = new StringBuilder("SELECT DDF_GET_EMP_DET(ACT_DET.SALES_PERS) as EMP_DETAIL, ACT_DET.PEOPLE, ACT_DET.SALES_PERS as sales_pers, SUM(ACT_DET.TC) TC, SUM(ACT_DET.CALL_BAL) CALLBAL, SUM(ACT_DET.PC) PC,");
            builder.append("SUM(ACT_DET.tlsd) TLSD,");
			builder.append("SUM(ACT_DET.ORD_VAL) ORDVAL , ");
//				builder.append("NVL((FN_GET_NONECO_CNT(ACT_DET.SALES_PERS, ?, 'N')),0) AS NON_ECO, ");
			builder.append("NVL((SELECT COUNT(DISTINCT STRG_CODE) FROM STRG_MEET WHERE EVENT_DATE = ? AND SALES_PERS =ACT_DET.SALES_PERS), 0) AS UNI_OUTLET,");
//				builder.append("NVL((select COUNT(distinct SCE.SC_CODE) from STRG_CUST_EXCEPTION SCE ");
//		        builder.append("left outer join strg_meet SM on SM.STRG_CODE = SCE.SC_CODE and SM.EVENT_DATE = SCE.PRC_DATE ");
//		        builder.append("left outer join strg_series SS on SCE.SC_CODE = SS.SC_CODE and SM.SALES_PERS = SS.SALES_PERS ");
//		        builder.append("where SM.sales_pers = ACT_DET.SALES_PERS  and SS.STATUS = 'Y' AND SCE.EXCEP_FLAG = 0 AND SCE.PRC_DATE = ?),0) AS CONV_ECO,");
//				builder.append("NVL((select COUNT(DISTINCT(SCA.STRG_CODE)) from strg_cust_add SCA, strg_meet SM where SCA.sales_pers = SM.sales_pers ");
//		        builder.append("and SCA.STRG_CODE = SM.STRG_CODE and SM.SALES_PERS = ACT_DET.SALES_PERS and SM.EVENT_DATE = ?),0) AS UN_OUTLET,");
            builder.append("NVL( ( select count ( distinct ss.sc_code) from strg_series ss ,strg_meet sm where sm.event_date = ? and ss.SALES_PERS = ? and sm.SALES_PERS = ?  and sm.route_id = ss.route_id and ss.status ='Y'),0) AS ROUTE_OUTLET ");
			builder.append("FROM (SELECT COUNT(DISTINCT(SM.SALES_PERS)) PEOPLE,SM.SALES_PERS,");
			builder.append("NVL(COUNT((SM.STRG_CODE)),0) AS TC ,NVL(FN_GET_CALL_BAL(SM.SALES_PERS, ?, 'N'),0) AS CALL_BAL,");
			builder.append("NVL((SELECT COUNT(DISTINCT STRG_CODE) FROM STRG_MEET_ORDER SMO  WHERE SMO.DCR_ID=SM.DCR_ID AND SMO.QUANTITY > 0),0) AS PC ,");
			builder.append("NVL((SELECT COUNT(*) FROM STRG_MEET_ORDER SMO  WHERE SMO.DCR_ID=SM.DCR_ID AND SMO.QUANTITY > 0),0) AS TLSD ,");
			builder.append("NVL((SELECT SUM(VALUE) FROM STRG_MEET_ORDER SMO  WHERE SMO.DCR_ID=SM.DCR_ID AND SMO.QUANTITY > 0),0) AS ORD_VAL ");
//				builder.append("NVL((SELECT COUNT(DISTINCT STRG_CODE) FROM STRG_ITEM_DISPLAY SID  WHERE SID.DCR_ID=SM.DCR_ID),0) AS DISPLAY,");
//				builder.append("NVL(COUNT(DISTINCT (CASE WHEN FA.ACTIVITY_TYPE = 'FW' THEN (SM.DCR_ID) END)),0) AS TOT_FW_DAYS,");
//				builder.append("NVL((select count(distinct SMO.strg_code) from strg_cust_add SCA, Strg_meet_order SMO, STRG_MEET SM where SMO.STRG_CODE = SCA.STRG_CODE ");
//	            builder.append("AND SM.sales_pers = SCA.sales_pers and sm.event_date = sca.event_date and SMO.DCR_ID = SM.DCR_ID and quantity > 0  ),0) UN_PC ");
            builder.append("FROM STRG_MEET SM ,SALES_PERS SP,FIELDACTIVITY FA ");
			builder.append("WHERE SM.SALES_PERS = SP.SALES_PERS  AND SM.EVENT_DATE = ? ");
            builder.append("AND FA.ACTIVITY_CODE = SM.EVENT_TYPE  AND FA.ACTIVITY_TYPE = ? ");
            builder.append( " And SM.Sales_Pers = ? ");
			builder.append(" GROUP BY SM.SALES_PERS,SM.DCR_ID,SM.EVENT_DATE");
            builder.append(") ACT_DET GROUP BY ACT_DET.PEOPLE, ACT_DET.SALES_PERS");
            
            sql = builder.toString();

            System.out.println("00 In getCurrentDayWorkSummary==>> sql ["+sql+"]" );
             //Changed  By Pravin k on 30-JULY-21 END
			pstmt = conn.prepareStatement(sql);
			pstmt.setTimestamp(1, java.sql.Timestamp.valueOf(eventDateDBFmt));
			pstmt.setTimestamp(2, java.sql.Timestamp.valueOf(eventDateDBFmt));
			pstmt.setString(3, salesPers);
			pstmt.setString(4, salesPers);
			pstmt.setTimestamp(5, java.sql.Timestamp.valueOf(eventDateDBFmt));
			pstmt.setTimestamp(6, java.sql.Timestamp.valueOf(eventDateDBFmt));
            pstmt.setString(7, "FW");
            pstmt.setString(8, salesPers);
            
            System.out.println(" Summary Activity Dashboard ,.....l ["+sql+"]" );
			rs = pstmt.executeQuery();
            String empDet = "";
            String dummySp = "";
			
			while (rs.next())
			{
//	                dummySp = checkNull(rs.getString("sales_pers")).trim();
//	                empDet = checkNull(rs.getString("EMP_DETAIL")).trim();
                
                valueXmlString.append("<Detail16>\r\n");
                
				valueXmlString.append( "<actual_value_route_outlet><![CDATA[" ).append(checkNull(rs.getString("ROUTE_OUTLET"))).append( "]]></actual_value_route_outlet>\r\n" );
                
                valueXmlString.append( "<actual_value_uni_outlet><![CDATA[" ).append(checkNull(rs.getString("UNI_OUTLET"))).append( "]]></actual_value_uni_outlet>\r\n" );
                               
                valueXmlString.append( "<actual_value_tc><![CDATA[" ).append(checkNull(rs.getString("TC"))).append( "]]></actual_value_tc>\r\n" );
                                
                valueXmlString.append( "<actual_value_pc><![CDATA[" ).append(checkNull(rs.getString("PC"))).append( "]]></actual_value_pc>\r\n" );
               	              
                valueXmlString.append( "<actual_value_tlsd><![CDATA[" ).append(checkNull(rs.getString("TLSD"))).append( "]]></actual_value_tlsd>\r\n" );
                
                valueXmlString.append( "<actual_value_ordval><![CDATA[" ).append(checkNull(rs.getString("ORDVAL"))).append( "]]></actual_value_ordval>\r\n" );
                
                valueXmlString.append("</Detail16>\r\n");

                

			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
            
            valueXmlString.append("</DailyDashboard>");
          //Added By Nilesh for Daily Dashboard Changes Start :21-09-2021
	            
			//Added By Nilesh Start for confirm button enable or disable according to user_right Start :: 22-04-19
			CallReportStatusEJB callReportEjb=new CallReportStatusEJB();
			String userRight=callReportEjb.getUserRightsString(salesPers, profileId , conn ,"callFromView");
			
			System.out.println( "userRight():==>\n"+userRight);
			
			valueXmlString.append( "<cofirmEnable><![CDATA[" ).append(userRight).append( "]]></cofirmEnable>\r\n" );
			//Added By Nilesh Start for confirm button enable or disable according to user_right End :: 22-04-19
			//valueXmlString.append( "</Detail2>\r\n" );
			valueXmlString.append( "</Root>\r\n" );	
				

		}
		catch(Exception e)
		{
			System.out.println( "Exception :getSummaryDetailDcrMeet():==>\n"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( conn != null && ! conn.isClosed() )
				{
					conn.close();
					conn = null;
				}
				//Added by Bhagyashri T to dirty connection close[02/06/2022][start]
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				//Added by Bhagyashri T to dirty connection close[02/06/2022][end]
			}
			catch(Exception e)
			{
				System.out.println( "Exception :getSummaryDetailDcrMeet():==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		System.out.println("getSummaryDetailDcrMeet valueXmlString.toString() ::"+valueXmlString.toString());
		return valueXmlString.toString();
	}
	public String getStanCodeFrom( Connection con, String userId, String eventDateDBFmt) throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String localityCodeFrom = "";
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		boolean isLocalConn=false; 
		String locDescr= "";
		try
		{
			if(con == null)
			{
				con =getConnection();
				isLocalConn=true;
			}
			//Changed by kailash on 04-03-19 [start]
			String travelDate = "";
			String maxTravelDt = "SELECT MAX(TRAVEL_DATE) AS TRAVEL_DATE FROM SPRS_TRAVEL WHERE SALES_PERS = ? AND TRAVEL_DATE < ?";
			pstmt =  con.prepareStatement(maxTravelDt);
			pstmt.setString(1, userId );
			pstmt.setTimestamp(2, java.sql.Timestamp.valueOf( eventDateDBFmt ));
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				travelDate = checkNull(rs.getString("TRAVEL_DATE"));
			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			/*String stanCodeSql = "SELECT ST.LOCALITY_CODE FROM  SPRS_TRAVEL ST, LOCALITY LOC "+
								" WHERE ORDER_OF_VISIT = ( SELECT MAX( ORDER_OF_VISIT) "+ 
								" FROM SPRS_TRAVEL WHERE SALES_PERS= ? AND TRAVEL_DATE =(SELECT MAX(TRAVEL_DATE) FROM SPRS_TRAVEL WHERE SALES_PERS=?) ) "+
								" AND LOC.LOCALITY_CODE = ST.LOCALITY_CODE "+
								" AND ST.SALES_PERS= ? AND ST.TRAVEL_DATE  =(SELECT MAX(TRAVEL_DATE) FROM SPRS_TRAVEL WHERE SALES_PERS=?) ";
			pstmt =  con.prepareStatement(stanCodeSql);
			pstmt.setString(1, userId );
			pstmt.setString(2, userId );
			pstmt.setString(3, userId );
			pstmt.setString(4, userId );*/
			if(travelDate.trim().length() == 0)
			{
				travelDate = eventDateDBFmt;
			}
			String stanCodeSql = "SELECT ST.LOCALITY_CODE FROM  SPRS_TRAVEL ST, LOCALITY LOC "+
					" WHERE ORDER_OF_VISIT = ( SELECT MAX( ORDER_OF_VISIT) "+ 
					" FROM SPRS_TRAVEL WHERE SALES_PERS= ? AND TRAVEL_DATE = ? ) "+
					" AND LOC.LOCALITY_CODE = ST.LOCALITY_CODE "+
					" AND ST.SALES_PERS= ? AND ST.TRAVEL_DATE  = ? ";
			pstmt =  con.prepareStatement(stanCodeSql);
			pstmt.setString(1, userId );
			pstmt.setTimestamp(2, java.sql.Timestamp.valueOf(travelDate) );
			pstmt.setString(3, userId );
			pstmt.setTimestamp(4, java.sql.Timestamp.valueOf(travelDate) );
			//Changed by kailash on 04-03-19 [end]
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				localityCodeFrom = rs.getString(1);
			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			System.out.println("locCodeFrom >> "+localityCodeFrom);
			String sql = "SELECT DESCR FROM LOCALITY WHERE LOCALITY_CODE = ?";
			pstmt =  con.prepareStatement(sql);
			pstmt.setString(1, localityCodeFrom);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				locDescr = rs.getString("DESCR");

			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			System.out.println("locDescr >>"+locDescr);
		}
		catch ( Exception e )
		{
			System.out.println( "Exception :WsfaZuviusDsrWizardEJB :defaultDataWiz :==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( isLocalConn && con != null && ! con.isClosed() )
				{
					con.close();
					con = null;
				}
				//Added by Bhagyashri T to dirty connection close[02/06/2022][start]
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				//Added by Bhagyashri T to dirty connection close[02/06/2022][end]
			}
			catch(Exception e)
			{
				System.out.println( "Exception :WsfaZuviusDsrWizardEJB :defaultDataWiz :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		return locDescr;
	}
	//Added by sachin satre on [14-nov-16] [start]
	public String getCallReportDetails( String salesPers, String eventDate ,String profId) throws ITMException
	{
		String itemData = "";
		Connection connectionObject =null;
		InitialContext ctx = null;
		try
		{
			//connectionObject =getConnection();
			ConnDriver connDriver = new ConnDriver();
			//connectionObject = connDriver.getConnectDB( "DriverValidator" );
			connectionObject=getConnection();
			System.out.println("connectionObject["+connectionObject+"] getCallReportDetailseventDate ["+eventDate+"]");
			itemData = new CallReportStatusEJB().getCallReportDetails( salesPers, eventDate,profId,connectionObject );
			String xslFileName = getXSLFileName( "call_report_status_wiz_" + this.user_lang + "_" + this.user_country + ".xsl" );
			itemData = ( new ibase.utility.E12GenericUtility() ).transformToString( xslFileName, itemData, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if ( connectionObject != null && !connectionObject.isClosed()) 
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{
				
			}
		}
		return itemData;
	}
	//Added by sachin satre on [14-nov-16] [end]	
	
	  //Added By Mrunalini Sinkar To Check the whether the selected Sales Person is manager (start) 
    public String getMGREmployee(String empCode,Connection con) throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String empCodeMGR = "";
		String selectSql = "";
		try
		{
			selectSql = "SELECT A.EMP_CODE AS EMP_CODE FROM EMPLOYEE A, GRADE B " + "WHERE A.EMP_CODE = ? " + "AND A.GRADE = B.GRADE_CODE " + "AND B.GRADE_TYPE = 'M' ";

			pstmt = con.prepareStatement(selectSql);
			pstmt.setString(1, empCode);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				empCodeMGR = checkNull(rs.getString("EMP_CODE"));
			}
			//rs.close();
			//Added by Bhagyashri T to dirty connection close[02/06/2022][start]
			if (rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			//Added by Bhagyashri T to dirty connection close[02/06/2022][end]
		} catch (Exception e)
		{
			throw new ITMException(e);
		} finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}


			} 
			catch (Exception e1){}

		}
		return empCodeMGR;
	}
 // Added by mrunalini sinkar to close the statment properly Start[07-JaN-2021]
    /* public String getSfaParmValue(String userId,String paramName,Connection connectionObject) throws ITMException//Chnaged by sachin satre on 11-nov-16
 	{
 		PreparedStatement pstmt = null;
 		ResultSet rs = null;
 		PreparedStatement pstmt1 = null;
 		ResultSet rs1 = null;
 		String empSite="";
 		String itemSer="";
 		String paramValue="";
 		PreparedStatement allPstmt = null;
 		ResultSet allRs = null;
 		boolean isLocalConn =false;
 		try
 		{
 			if(connectionObject == null)
 			{
 				connectionObject = getConnection();
 				isLocalConn =true;
 			}
 			String sql = "SELECT SITE_CODE__DEF FROM USERS WHERE CODE = ? ";
 			pstmt = connectionObject.prepareStatement(sql);
 			pstmt.setString(1, userId);

 			rs = pstmt.executeQuery();
 			if( rs.next() )
 			{
 				empSite  = checkNull(rs.getString("SITE_CODE__DEF"));
 			}
 			if ( rs != null )
 			{
 				rs.close();
 				rs = null;
 			}
 			if ( pstmt != null )
 			{
 				pstmt.close();
 				pstmt = null;
 			}

 			String getSalesPerData = " SELECT SALES_PERS.ITEM_SER,ITEMSER.DESCR FROM ITEMSER LEFT OUTER JOIN SALES_PERS ON ITEMSER.ITEM_SER = SALES_PERS.ITEM_SER "+
 					" WHERE  SALES_PERS.SALES_PERS = ? ";

 			pstmt = connectionObject.prepareStatement(getSalesPerData);
 			pstmt.setString(1, userId);

 			rs = pstmt.executeQuery();
 			if( rs.next() )
 			{
 				itemSer  = checkNull(rs.getString("ITEM_SER"));
 			}
 			if ( rs != null )
 			{
 				rs.close();
 				rs = null;
 			}
 			if ( pstmt != null )
 			{
 				pstmt.close();
 				pstmt = null;
 			}

 			sql=" SELECT PARM_VALUE  "+
 					" FROM SFAPARM  "+
 					" WHERE ORG_UNIT =?  "+
 					" AND ACTIVE='Y'  "+
 					" AND PARM_NAME= ? ";

 			pstmt = connectionObject.prepareStatement(sql);
 			pstmt.setString(1, empSite+"_"+itemSer);
 			pstmt.setString(2, paramName);
 			rs = pstmt.executeQuery();
 			if(rs.next())
 			{
 				paramValue  = checkNull(rs.getString(1));
 			}
 			else
 			{
 				pstmt1 = connectionObject.prepareStatement(sql);
 				pstmt1.setString(1, itemSer);
 				pstmt1.setString(2, paramName);
 				rs1 = pstmt1.executeQuery();
 				if(rs1.next())
 				{
 					paramValue  = checkNull(rs1.getString(1));
 				}
 				else
 				{
 					allPstmt = connectionObject.prepareStatement(sql);
 					allPstmt.setString(1, "ALL");
 					allPstmt.setString(2, paramName);
 					allRs = allPstmt.executeQuery();
 					if(allRs.next())
 					{
 						paramValue  = checkNull(allRs.getString(1));
 					}
 				}
 				if ( allRs != null )
 				{
 					allRs.close();
 					allRs = null;
 				}
 				if ( allPstmt != null )
 				{
 					allPstmt.close();
 					allPstmt = null;
 				}
 				if ( rs1 != null )
 				{
 					rs1.close();
 					rs1 = null;
 				}
 				if ( pstmt1 != null )
 				{
 					pstmt1.close();
 					pstmt1 = null;
 				}
 			}
 			if ( rs != null )
 			{
 				rs.close();
 				rs = null;
 			}
 			if ( pstmt != null )
 			{
 				pstmt.close();
 				pstmt = null;
 			}
 		}
 		catch(Exception e)
 		{
 			e.printStackTrace();
 			throw new ITMException(e);

 		}
 		finally
 		{
 			try
 			{
 				if ( rs != null )
 				{
 					rs.close();
 					rs = null;
 				}
 				if ( pstmt != null )
 				{
 					pstmt.close();
 					pstmt = null;
 				}
 				if( isLocalConn && connectionObject != null && ! connectionObject.isClosed() )
 				{
 					connectionObject.close();
 					connectionObject = null;
 				}
 			}
 			catch (SQLException e) {
 				e.printStackTrace();
 			}
 		}
 		return paramValue;
 	}*/
     public String getSfaParmValue(String userId,String paramName,Connection connectionObject) throws ITMException//Chnaged by sachin satre on 11-nov-16
 	{
 		PreparedStatement pstmt = null;
 		ResultSet rs = null;
 		PreparedStatement pstmt1 = null;
 		ResultSet rs1 = null;
 		String empSite="";
 		String itemSer="";
 		String paramValue="";
 		PreparedStatement allPstmt = null;
 		ResultSet allRs = null;
 		boolean isLocalConn =false;
 		try
 		{
 			if(connectionObject == null)
 			{
 				connectionObject = getConnection();
 				isLocalConn =true;
 			}
 			String sql = "SELECT SITE_CODE__DEF FROM USERS WHERE CODE = ? ";
 			pstmt = connectionObject.prepareStatement(sql);
 			pstmt.setString(1, userId);

 			rs = pstmt.executeQuery();
 			if( rs.next() )
 			{
 				empSite  = checkNull(rs.getString("SITE_CODE__DEF"));
 			}
 			if ( rs != null )
 			{
 				rs.close();
 				rs = null;
 			}
 			if ( pstmt != null )
 			{
 				pstmt.close();
 				pstmt = null;
 			}

 			String getSalesPerData = " SELECT SALES_PERS.ITEM_SER,ITEMSER.DESCR FROM ITEMSER LEFT OUTER JOIN SALES_PERS ON ITEMSER.ITEM_SER = SALES_PERS.ITEM_SER "+
 					" WHERE  SALES_PERS.SALES_PERS = ? ";

 			pstmt = connectionObject.prepareStatement(getSalesPerData);
 			pstmt.setString(1, userId);

 			rs = pstmt.executeQuery();
 			if( rs.next() )
 			{
 				itemSer  = checkNull(rs.getString("ITEM_SER"));
 			}
 			if ( rs != null )
 			{
 				rs.close();
 				rs = null;
 			}
 			if ( pstmt != null )
 			{
 				pstmt.close();
 				pstmt = null;
 			}
 			boolean isSiteMatch=false;
 			boolean isItemser=false;

 			sql=" SELECT PARM_VALUE  "+
 					" FROM SFAPARM  "+
 					" WHERE ORG_UNIT =?  "+
 					" AND ACTIVE='Y'  "+
 					" AND PARM_NAME= ? ";

 			pstmt = connectionObject.prepareStatement(sql);
 			pstmt.setString(1, empSite+"_"+itemSer);
 			pstmt.setString(2, paramName);
 			rs = pstmt.executeQuery();
 			if(rs.next())
 			{
 				paramValue  = checkNull(rs.getString(1));
 				isSiteMatch=true;
 				System.out.println("Inside EMPSITE_ITEMSER");
 			}
 			if ( rs != null )
 			{
 				rs.close();
 				rs = null;
 			}
 			if ( pstmt != null )
 			{
 				pstmt.close();
 				pstmt = null;
 			}
 			if(paramValue==null || paramValue.trim().length()==0)
 			{
 				System.out.println("Inside ITEMSER PARMVALUE 2");
 				if(isSiteMatch==false)
 				{
 					pstmt1 = connectionObject.prepareStatement(sql);
 					pstmt1.setString(1, itemSer);
 					pstmt1.setString(2, paramName);
 					rs1 = pstmt1.executeQuery();
 					if(rs1.next())
 					{
 						paramValue  = checkNull(rs1.getString(1));
 						isItemser=true;
 						System.out.println("Inside ITEMSER SFAPARM");
 					}
 					if ( rs1 != null )
 					{
 						rs1.close();
 						rs1 = null;
 					}
 					if ( pstmt1 != null )
 					{
 						pstmt1.close();
 						pstmt1 = null;
 					}
 				}

 			}
 			if(paramValue==null || paramValue.trim().length()==0)
 			{
 				System.out.println("Inside ALL PARMVALUE 3");
 				if(isSiteMatch==false && isItemser==false)
 				{
 					allPstmt = connectionObject.prepareStatement(sql);
 					allPstmt.setString(1, "ALL");
 					allPstmt.setString(2, paramName);
 					allRs = allPstmt.executeQuery();
 					if(allRs.next())
 					{
 						paramValue  = checkNull(allRs.getString(1));
 						System.out.println("Inside ALL SFAPARM");
 					}
 					if ( allRs != null )
 					{
 						allRs.close();
 						allRs = null;
 					}
 					if ( allPstmt != null )
 					{
 						allPstmt.close();
 						allPstmt = null;
 					}
 				}

 			}
 				
 				/*if ( rs1 != null )
 				{
 					rs1.close();
 					rs1 = null;
 				}
 				if ( pstmt1 != null )
 				{
 					pstmt1.close();
 					pstmt1 = null;
 				}*/
 			//}
 			/*if ( rs != null )
 			{
 				rs.close();
 				rs = null;
 			}
 			if ( pstmt != null )
 			{
 				pstmt.close();
 				pstmt = null;
 			}*/
 		}
 		catch(Exception e)
 		{
 			e.printStackTrace();
 			throw new ITMException(e);

 		}
 		finally
 		{
 			try
 			{
 				if ( rs != null )
 				{
 					rs.close();
 					rs = null;
 				}
 				if ( pstmt != null )
 				{
 					pstmt.close();
 					pstmt = null;
 				}
 				//Added by Bhagyashri T to dirty connection close[02/06/2022][start]
				if (pstmt1 != null)
				{
					pstmt1.close();
					pstmt1 = null;
				}
				//Added by Bhagyashri T to dirty connection close[02/06/2022][start]
 				if( isLocalConn && connectionObject != null && ! connectionObject.isClosed() )
 				{
 					connectionObject.close();
 					connectionObject = null;
 				}
 			}
 			catch (SQLException e) {
 				e.printStackTrace();
 			}
 		}
 		return paramValue;
 	}
  // Added by mrunalini sinkar to close the statment properly END[07-JaN-2021] 
    public String getSubmissionDate(String salesPers,String eventDate,Connection connectionObject) 
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String subDispDate = "";
		try
		{
			String sql="SELECT TO_CHAR(SUBMISSION_DATE, 'DD-MM-YYYY HH12:MI A.M.') AS SUBMISSION_DATE FROM DR_MAIN WHERE WORK_DATE=? AND SALES_PERS=?";
			pstmt =  connectionObject.prepareStatement(sql);
			pstmt.setTimestamp( 1, java.sql.Timestamp.valueOf( eventDate ) );
			pstmt.setString(2, salesPers);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				subDispDate = checkNull(rs.getString("SUBMISSION_DATE"));
				System.out.println("subDispDate =["+subDispDate+"]");
			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();

		}
		return subDispDate;
	}
    public String [] getMissedData(String empCode, String eventDate, Connection conn) throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String placeSql = "", custSql = "";
		String []missedDataArr = new String[2];
		SimpleDateFormat sdf  = null;
		E12GenericUtility genericUtility = null;
		String placeData = "", custData = "";
		try
		{
			genericUtility = new E12GenericUtility();
			sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			/*placeSql = "SELECT COUNT(*) AS PLACE_COUNT FROM( "+
					"(SELECT SPP.LOCALITY_CODE, L.DESCR AS LOCALITY FROM SALES_PERS SP INNER JOIN SPRS_PLAN_HDR SPH ON SP.SALES_PERS = SPH.SPRS_CODE__PLAN "+ 
					" INNER JOIN SPRS_PLAN_PLACE SPP ON SPH.PLAN_ID = SPP.PLAN_ID INNER JOIN LOCALITY L ON L.LOCALITY_CODE = SPP.LOCALITY_CODE INNER JOIN SPRS_ROUTE SR ON SR.LOCALITY_CODE = SPP.LOCALITY_CODE "+ 
					" AND SR.ROUTE_ID = SPP.ROUTE_ID AND SR.SPRS_CODE  = SP.SALES_PERS WHERE SPH.CONFIRM = 'Y' AND SPH.PLAN_DATE = ? AND SP.SALES_PERS = ?) "+ 
					" MINUS "+
					" (SELECT ST.LOCALITY_CODE, L.DESCR AS LOCALITY FROM SALES_PERS SP INNER JOIN SPRS_TRAVEL ST ON SP.SALES_PERS = ST.SALES_PERS INNER JOIN LOCALITY L ON L.LOCALITY_CODE = ST.LOCALITY_CODE"+ 
					" INNER JOIN SPRS_ROUTE SR ON SR.LOCALITY_CODE = ST.LOCALITY_CODE AND SR.ROUTE_ID = ST.ROUTE_ID AND SR.SPRS_CODE  = SP.SALES_PERS "+
					" WHERE ST.TRAVEL_DATE = ? AND SP.SALES_PERS = ?)) ";*/
			
			placeSql = "(SELECT SPP.LOCALITY_CODE, (CASE WHEN SR.ROUTE_DESCR IS NOT NULL THEN SR.ROUTE_DESCR ELSE SR.DESCR END ) AS LOCALITY FROM SALES_PERS SP INNER JOIN SPRS_PLAN_HDR SPH ON SP.SALES_PERS = SPH.SPRS_CODE__PLAN "+ 
					" INNER JOIN SPRS_PLAN_PLACE SPP ON SPH.PLAN_ID = SPP.PLAN_ID INNER JOIN LOCALITY L ON L.LOCALITY_CODE = SPP.LOCALITY_CODE INNER JOIN SPRS_ROUTE SR ON SR.LOCALITY_CODE = SPP.LOCALITY_CODE "+ 
					" AND SR.ROUTE_ID = SPP.ROUTE_ID AND SR.SPRS_CODE  = SP.SALES_PERS WHERE SPH.CONFIRM = 'Y' AND SPH.PLAN_DATE = ? AND SP.SALES_PERS = ?) "+ 
					" MINUS "+
					" (SELECT ST.LOCALITY_CODE, (CASE WHEN SR.ROUTE_DESCR IS NOT NULL THEN SR.ROUTE_DESCR ELSE SR.DESCR END ) AS LOCALITY FROM SALES_PERS SP INNER JOIN SPRS_TRAVEL ST ON SP.SALES_PERS = ST.SALES_PERS INNER JOIN LOCALITY L ON L.LOCALITY_CODE = ST.LOCALITY_CODE"+ 
					" INNER JOIN SPRS_ROUTE SR ON SR.LOCALITY_CODE = ST.LOCALITY_CODE AND SR.ROUTE_ID = ST.ROUTE_ID AND SR.SPRS_CODE  = SP.SALES_PERS "+
					" WHERE ST.TRAVEL_DATE = ? AND SP.SALES_PERS = ?) ORDER BY LOCALITY ";

			pstmt = conn.prepareStatement(placeSql);
			pstmt.setTimestamp(1, java.sql.Timestamp.valueOf( eventDate ));
			pstmt.setString(2, empCode);
			pstmt.setTimestamp(3, java.sql.Timestamp.valueOf( eventDate ));
			pstmt.setString(4, empCode);
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				//missedDataArr[0] = rs.getInt("PLACE_COUNT");
				if(placeData.length() == 0)
				{
					placeData = checkNull(rs.getString("LOCALITY"));
				}
				else
				{
					placeData = placeData + ", " + checkNull(rs.getString("LOCALITY"));
				}
			}
			if (rs != null)
			{
				rs.close();
				rs = null;
			}
			if (pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			missedDataArr[0] = placeData;
			
			/*custSql = "SELECT COUNT(*) AS CUST_COUNT FROM( "+
					" (SELECT SPC.SC_CODE FROM SALES_PERS SP INNER JOIN SPRS_PLAN_HDR SPH ON SP.SALES_PERS = SPH.SPRS_CODE__PLAN "+ 
					" INNER JOIN SPRS_PLAN_CUST SPC ON SPH.PLAN_ID = SPC.PLAN_ID INNER JOIN STRG_SERIES SS ON SS.SC_CODE = SPC.SC_CODE "+
					" WHERE SPH.CONFIRM = 'Y' AND SPH.PLAN_DATE = ? AND SP.SALES_PERS= ?) "+
					" MINUS "+
					" (SELECT SM.STRG_CODE FROM SALES_PERS SP INNER JOIN STRG_MEET SM ON SP.SALES_PERS = SM.SALES_PERS "+ 
					" INNER JOIN STRG_SERIES SS ON SS.SC_CODE = SM.STRG_CODE WHERE SM.EVENT_DATE = ? AND SP.SALES_PERS = ?)) ";*/
			
			String stockistTable = getSfaParmValue(empCode,"GET_STOCKIST_DETAILS",conn);
			
			if (stockistTable.equalsIgnoreCase("SPRS_STOCKIST"))
			{
				custSql = "(SELECT SPC.SC_CODE AS SC_CODE, INITCAP(SC.FIRST_NAME||' '||SC.MIDDLE_NAME||' '||SC.LAST_NAME )AS CUST_NAME FROM SALES_PERS SP INNER JOIN SPRS_PLAN_HDR SPH ON SP.SALES_PERS = SPH.SPRS_CODE__PLAN "+
						" INNER JOIN SPRS_PLAN_CUST SPC ON SPH.PLAN_ID = SPC.PLAN_ID INNER JOIN STRG_SERIES SS ON SS.SC_CODE = SPC.SC_CODE INNER JOIN STRG_CUSTOMER SC ON SC.SC_CODE=SPC.SC_CODE "+
						" WHERE SPH.CONFIRM = 'Y' AND SPH.PLAN_DATE = ? AND SP.SALES_PERS= ? AND SC.CUST_TYPE NOT IN (SELECT TYPE FROM STRG_CUST_TYPE WHERE DCR_GROUP = 'S')) "+
						" MINUS  (SELECT SM.STRG_CODE AS SC_CODE, INITCAP(SC.FIRST_NAME||' '||SC.MIDDLE_NAME||' '||SC.LAST_NAME )AS CUST_NAME FROM SALES_PERS SP INNER JOIN STRG_MEET SM ON SP.SALES_PERS = SM.SALES_PERS "+
						" INNER JOIN STRG_SERIES SS ON SS.SC_CODE = SM.STRG_CODE INNER JOIN STRG_CUSTOMER SC ON SC.SC_CODE=SM.STRG_CODE "+
						" WHERE SM.EVENT_DATE = ? AND SP.SALES_PERS = ? AND SC.CUST_TYPE NOT IN (SELECT TYPE FROM STRG_CUST_TYPE WHERE DCR_GROUP = 'S')) "+
						" UNION "+
						" (SELECT SPC.SC_CODE AS SC_CODE , INITCAP(CUST.CUST_NAME)AS CUST_NAME FROM SALES_PERS SP INNER JOIN SPRS_PLAN_HDR SPH ON SP.SALES_PERS = SPH.SPRS_CODE__PLAN "+  
						" INNER JOIN SPRS_PLAN_CUST SPC ON SPH.PLAN_ID = SPC.PLAN_ID INNER JOIN SPRS_STOCKIST SS ON SS.CUST_CODE = SPC.SC_CODE "+
						" INNER JOIN CUSTOMER CUST ON CUST.CUST_CODE = SPC.SC_CODE WHERE SPH.CONFIRM = 'Y' AND SPH.PLAN_DATE = ? AND SP.SALES_PERS= ? "+ 
						" AND CUST.CUST_TYPE IN (SELECT TYPE FROM STRG_CUST_TYPE WHERE DCR_GROUP = 'S')) "+
						" MINUS (SELECT SM.STRG_CODE AS SC_CODE, INITCAP(CUST.CUST_NAME)AS CUST_NAME FROM SALES_PERS SP INNER JOIN STRG_MEET SM ON SP.SALES_PERS = SM.SALES_PERS "+ 
						" INNER JOIN SPRS_STOCKIST SS ON SS.CUST_CODE = SM.STRG_CODE INNER JOIN CUSTOMER CUST ON CUST.CUST_CODE=SM.STRG_CODE "+
						" WHERE SM.EVENT_DATE = ? AND SP.SALES_PERS = ? AND CUST.CUST_TYPE IN (SELECT TYPE FROM STRG_CUST_TYPE WHERE DCR_GROUP = 'S')) ORDER BY CUST_NAME ";
				
				pstmt = conn.prepareStatement(custSql);
				pstmt.setTimestamp(1, java.sql.Timestamp.valueOf( eventDate ));
				pstmt.setString(2, empCode);
				pstmt.setTimestamp(3, java.sql.Timestamp.valueOf( eventDate ));
				pstmt.setString(4, empCode);
				pstmt.setTimestamp(5, java.sql.Timestamp.valueOf( eventDate ));
				pstmt.setString(6, empCode);
				pstmt.setTimestamp(7, java.sql.Timestamp.valueOf( eventDate ));
				pstmt.setString(8, empCode);
			}
			else
			{
				custSql = "(SELECT SPC.SC_CODE AS SC_CODE, INITCAP(SC.FIRST_NAME||' '||SC.MIDDLE_NAME||' '||SC.LAST_NAME )AS CUST_NAME FROM SALES_PERS SP INNER JOIN SPRS_PLAN_HDR SPH ON SP.SALES_PERS = SPH.SPRS_CODE__PLAN "+  
						" INNER JOIN SPRS_PLAN_CUST SPC ON SPH.PLAN_ID = SPC.PLAN_ID INNER JOIN STRG_SERIES SS ON SS.SC_CODE = SPC.SC_CODE AND SS.SALES_PERS = SPH.SPRS_CODE__PLAN INNER JOIN STRG_CUSTOMER SC ON SC.SC_CODE=SPC.SC_CODE "+  
						" WHERE SPH.CONFIRM = 'Y' AND SPH.PLAN_DATE = ? AND SP.SALES_PERS= ?) "+
						" MINUS "+
						" (SELECT SM.STRG_CODE AS SC_CODE, INITCAP(SC.FIRST_NAME||' '||SC.MIDDLE_NAME||' '||SC.LAST_NAME )AS CUST_NAME FROM SALES_PERS SP INNER JOIN STRG_MEET SM ON SP.SALES_PERS = SM.SALES_PERS "+ 
						" INNER JOIN STRG_SERIES SS ON SS.SC_CODE = SM.STRG_CODE AND SS.SALES_PERS = SM.SALES_PERS INNER JOIN STRG_CUSTOMER SC ON SC.SC_CODE=SM.STRG_CODE "+
						" WHERE SM.EVENT_DATE = ? AND SP.SALES_PERS = ?) ORDER BY CUST_NAME ";

				pstmt = conn.prepareStatement(custSql);
				pstmt.setTimestamp(1, java.sql.Timestamp.valueOf( eventDate ) );
				pstmt.setString(2, empCode);
				pstmt.setTimestamp(3, java.sql.Timestamp.valueOf( eventDate ) );
				pstmt.setString(4, empCode);
			}
			
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				//missedDataArr[1] = rs.getInt("CUST_COUNT");
				if(custData.length() == 0)
				{
					custData = checkNull(rs.getString("CUST_NAME"));
				}
				else
				{
					custData = custData + ", " + checkNull(rs.getString("CUST_NAME"));
				}
			}
			if (rs != null)
			{
				rs.close();
				rs = null;
			}
			if (pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			missedDataArr[1] = custData;
		} 
		catch (Exception e)
		{
			throw new ITMException(e);
		} 
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch (Exception e1){}
		}
		return missedDataArr;
	}
    
    public String getClassCodeDesc(String classCode,String cusType,String userId,Connection connectionObject) throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String classDescr = "";
		String sql = "";
		try
		{
			String itemSer = checkNull(getItemSer(userId, connectionObject));
			
				sql =" SELECT CS.DESCR AS CLASS_CODE_DESCR FROM STRG_CLASS C , STRG_SER_CLASS CS  " +
						" WHERE  C.CLASS_CODE= CS.CLASS_CODE AND C.CLASS_CODE = ? AND C.ACTIVE_YN='Y'  AND CS.ITEM_SER = ?   ";
			
			

			//commented & added  by mrunalini sinkar for class code changes(end)
			pstmt = connectionObject.prepareStatement(sql);
			pstmt.setString(1, classCode);
			//commented & added  by mrunalini sinkar for class code changes(end)
			//pstmt.setString(2, cusType);
				pstmt.setString(2, itemSer);
			//commented & added  by mrunalini sinkar for class code changes(end)

			rs = pstmt.executeQuery();
			if(rs.next())
			{
				classDescr = checkNull(rs.getString("CLASS_CODE_DESCR"));
			}
			if( rs !=null )
			{
				rs.close();
				rs = null;
			}
			if( pstmt !=null )
			{
				pstmt.close();
				pstmt = null;
			}

		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		finally
		{
			try
			{
				if( rs !=null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt !=null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		//System.out.println("classDescr val:- "+classDescr);
		return classDescr;
	}
    
    public String getItemSer(String salesPers,Connection conn)
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String itemSer="";
		try
		{
			String sql="SELECT ITEM_SER FROM SALES_PERS WHERE SALES_PERS=?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, salesPers);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				itemSer = checkNull(rs.getString("ITEM_SER"));
			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}

		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{

			try
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}

		}
		return itemSer;
	}
    public String getActivityDescr( String actCode, Connection connectionObject )throws ITMException
	{
		String sql = "";
		String actDescr = "";
		//Connection connectionObject = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null ;

		//changed by Rahul Barve on 10-Apr-2015
		//GenericUtility genericUtility = GenericUtility.getInstance();
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

		try
		{
			//ConnDriver connDriver = new ConnDriver();
			//connectionObject = connDriver.getConnectDB( "DriverValidator" );

			sql = "SELECT DESCR FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ?";
			pstmt = connectionObject.prepareStatement(sql);
			pstmt.setString(1, actCode);
			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				actDescr = checkNull(rs.getString("DESCR"));
			}
			//added by mrnunalini sinkar on 11-04-2018(start)
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			//added by mrnunalini sinkar on 11-04-2018(end)

		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		finally
		{
			try
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				/*
				if (connectionObject != null)
				{
					connectionObject.close();
					connectionObject=null;
				}*/
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}

		return actDescr;
	}
	
    //Added by Prasad on 11/08/2021 [to display non-visited customers] START
    public String getNonVisitedRoute( String salesPers, String eventDate, UserInfoBean userInfoBean )
	{
		Connection conn = null;
		PreparedStatement pstmt = null;
        ResultSet rs = null;
        JSONArray pophelpJSONObj = new JSONArray();
        
		try
		{
			System.out.println( "In getNonVisitedRoute :: salesPers : ["+ salesPers +"], eventDate : ["+ eventDate +"]");
			
            System.out.println( "In getNonVisitedRoute loginCode::"+ userInfoBean.getLoginCode() +"]" );
            String empCode = userInfoBean.getEmpCode();
            System.out.println( "In getNonVisitedRoute empCode:: ["+ empCode +"]");
            salesPers = checkNull( salesPers );
            if ( salesPers.length() == 0 )
            {
            	salesPers = empCode;
            }
            System.out.println( "In getNonVisitedRoute salesPers :: ["+ salesPers +"]");
            
            E12GenericUtility genericUtility = new E12GenericUtility();
			String transDB = E12GenericUtility.checkNull(userInfoBean.getTransDB());
			
			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB( transDB );
			connDriver = null;
            
			/*String sql = "SELECT SR.DESCR, SR.ROUTE_ID AS ROUTE_ID, ST.DCR_GROUP AS DCR_GROUP,COUNT(*) AS COUNT "
					+ " FROM STRG_CUSTOMER SC LEFT OUTER JOIN STRG_VISIT_HOURS SVH ON SC.SC_CODE=SVH.SC_CODE, SPRS_ROUTE SR, LOCALITY L, STRG_CUST_TYPE ST, "
					+ " STRG_SERIES SS LEFT OUTER JOIN SPECIALITY SP ON SP.SPL_CODE = SS.SPL_CODE "
					+ " WHERE SS.SC_CODE = SC.SC_CODE "
					+ " AND SS.SALES_PERS=SR.SPRS_CODE AND SS.ROUTE_ID=SR.ROUTE_ID "
					+ " AND L.LOCALITY_CODE=SR.LOCALITY_CODE "
					+ " AND (SC.LOCALITY_CODE = SR.LOCALITY_CODE OR SC.RES_LOCALITY_CODE = SR.LOCALITY_CODE OR SR.LOCALITY_CODE=SVH.LOCALITY_CODE) "
					+ " AND SS.SALES_PERS = '"+ salesPers +"'  AND SS.STATUS IN('Y','A') "
					+ " AND SC.CUST_TYPE = ST.TYPE AND SR.STATUS = 'Y' "
					+ " AND SC.CUST_TYPE NOT IN (SELECT TYPE FROM STRG_CUST_TYPE WHERE DCR_GROUP = 'S') "
					+ " GROUP BY SR.ROUTE_ID,ST.DCR_GROUP, SR.DESCR "
					+ " UNION ALL "
					+ " SELECT SR.DESCR, SR.ROUTE_ID,ST.DCR_GROUP AS DCR_GROUP, COUNT(*) AS COUNT "
					+ " FROM CUSTOMER CUST LEFT OUTER JOIN STRG_VISIT_HOURS SVH ON CUST.CUST_CODE = SVH.SC_CODE, SPRS_ROUTE SR, LOCALITY L, STRG_CUST_TYPE ST, SPRS_STOCKIST SS "
					+ " WHERE SS.CUST_CODE = CUST.CUST_CODE "
					+ " AND SS.SPRS_CODE = SR.SPRS_CODE AND SS.ROUTE_ID = SR.ROUTE_ID "
					+ " AND L.LOCALITY_CODE = SR.LOCALITY_CODE "
					+ " AND (CUST.LOCALITY_CODE = SR.LOCALITY_CODE OR SR.LOCALITY_CODE = SVH.LOCALITY_CODE) "
					+ " AND SS.SPRS_CODE = '"+ salesPers +"' AND SS.STATUS IN('Y','A') AND CUST.CUST_TYPE = ST.TYPE AND SR.STATUS='Y' "
					+ " AND CUST.BLACK_LISTED <> 'Y' AND CUST.CUST_TYPE IN (SELECT TYPE FROM STRG_CUST_TYPE WHERE DCR_GROUP = 'S') "
					+ " GROUP BY SR.DESCR,SR.ROUTE_ID,ST.DCR_GROUP";*/
			
			String eventDateDBFmt = genericUtility.getValidDateTimeString( eventDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat() );
			
			String sql = "SELECT PE.STRG_CODE AS STRG_CODE, PE.STRG_NAME, PE.STRG_TYPE, PE.SPL_CODE, PE.SPECIALITY_DESCR, PE.STRG_CLASS_CODE, PE.CLASS_CODE_DESCR, " + 
					" PE.LOCALITY_CODE AS LOCALITY_CODE, PE.LOCALITY_DESCR, PE.ROUTE_ID AS ROUTE_ID, PE.NON_ECO_DET " + 
					" FROM TABLE(STRGCODEPOPHELP.GETSTRGCODEPOPHELPDATA(?)) PE " + 
					" WHERE PE.ROUTE_ID IN ( SELECT SM.ROUTE_ID FROM STRG_MEET SM WHERE SM.SALES_PERS = ? AND SM.EVENT_DATE = ? ) " + 
					" AND PE.STRG_CODE NOT IN ( SELECT SM.STRG_CODE FROM STRG_MEET SM WHERE SM.SALES_PERS = ? AND SM.EVENT_DATE = ? ) " + 
					" ORDER BY PE.LOCALITY_DESCR, PE.STRG_NAME, PE.STRG_CODE";
            
			pstmt = conn.prepareStatement(sql);
			pstmt.setString( 1, salesPers );
			pstmt.setString( 2, salesPers );
			pstmt.setTimestamp( 3, java.sql.Timestamp.valueOf( eventDateDBFmt ) );
			pstmt.setString( 4, salesPers );
			pstmt.setTimestamp( 5, java.sql.Timestamp.valueOf( eventDateDBFmt ) );
			
            rs = pstmt.executeQuery();
            ResultSetMetaData rsmd = rs.getMetaData();
			int colCount = rsmd.getColumnCount();
			
            while( rs.next() )
            {
            	JSONObject detailObj = new JSONObject();
				for(int colNo = 1; colNo <= colCount; colNo++)
				{
					String colName = rsmd.getColumnName(colNo);
					String colValue = rs.getString(colNo);
					String timeValue = "00:00:00";
					if ( colValue != null && rsmd.getColumnTypeName(colNo).toUpperCase().indexOf("DATE") != -1 )
					{
						try
						{
							colValue = colValue.length() > 0 ?genericUtility.getValidDateString( colValue, genericUtility.getDBDateFormat(), genericUtility.getDispDateFormat() ) : colValue;
						}
						catch (Exception e)
						{

						}
					}
					else if( rsmd.getColumnTypeName(colNo).toUpperCase().indexOf("DATETIME") != -1 )
					{
						java.sql.Timestamp currDate = rs.getTimestamp(colNo);
						if (currDate != null)
						{
							colValue = genericUtility.getValidDateTimeString( currDate.toString(), genericUtility.getDBDateTimeFormat(), genericUtility.getDispDateTimeFormat() );

							if( colValue.contains(timeValue))
							{
								colValue = colValue.substring(0, colValue.lastIndexOf("-")+3);
							}
						}
					}
					else if (rsmd.getColumnTypeName(colNo).toUpperCase().indexOf("TIMESTAMP") != -1 )
					{
						java.sql.Timestamp currDate = rs.getTimestamp(colNo);
						if (currDate != null)
						{
							colValue = genericUtility.getValidDateTimeString(currDate.toString(), genericUtility.getDBDateFormat(), genericUtility.getDispDateTimeFormat() );
							if( colValue.contains(timeValue))
							{
								colValue = colValue.substring(0, colValue.lastIndexOf("-")+3);
							}
						}
					}
					else if ( rsmd.getColumnTypeName(colNo).toUpperCase().indexOf("TIME") != -1 )
					{
						java.sql.Timestamp currDate = rs.getTimestamp(colNo);
						if (currDate != null)
						{
							colValue = genericUtility.getValidDateTimeString(currDate,genericUtility.getDisplayTimeFormat() );
						}
					}
					colName = colName.toLowerCase();
					detailObj.put(colName, colValue);
				}
				pophelpJSONObj.put(detailObj);
            }

            if( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			if( rs != null )
			{
				rs.close();
				rs = null;
			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if( rs != null )
				{
					rs.close();
					rs = null;
				}
				if( conn != null )
				{
					conn.close();
					conn = null;
				}
			}
			catch( Exception e )
			{
				System.out.println( "Exception :: getNonVisitedRoute : ["+ e.getMessage() +"]" );
				e.printStackTrace();
			}
		}
		System.out.println( "In getNonVisitedRoute : pophelpJSONObj : ["+ pophelpJSONObj +"]");
		return pophelpJSONObj.toString();
	}
  //Added by Prasad on 11/08/2021 [to display non-visited customers] END
	    public String getDescrFromGenCodes(String modName, String fldName, String fldValue, Connection conn) {
	        PreparedStatement pstmt = null;
	        ResultSet rs = null;
	        String genDescr = "";
	        try 
	        {
	            String sql = "SELECT DESCR FROM GENCODES where MOD_NAME=? AND FLD_NAME=? AND FLD_VALUE=? ";
	            pstmt = conn.prepareStatement(sql);
	            pstmt.setString(1, modName);
	            pstmt.setString(2, fldName);
	            pstmt.setString(3, fldValue);
	            rs = pstmt.executeQuery();
	            if (rs.next()) 
	            {
	                genDescr = checkNull(rs.getString("DESCR"));
	            }
	            if (rs != null) 
	            {
	                rs.close();
	                rs = null;
	            }
	            if (pstmt != null) 
	            {
	                pstmt.close();
	                pstmt = null;
	            }
	        }
	        catch (Exception e) 
	        {
	            e.printStackTrace();
	        }
	        finally {
				try
				{
					if( pstmt != null )
					{
						pstmt.close();
						pstmt = null;
					}
					if( rs != null )
					{
						rs.close();
						rs = null;
					}
					
				}
				catch( Exception e )
				{
					System.out.println( "Exception :: getNonVisitedRoute : ["+ e.getMessage() +"]" );
					e.printStackTrace();
				}
			}
	        
	        return genDescr;
	    }
		//Added by Jay to take Summary from Enterprise folder (if exists in it) of user 19-JAN-23 [start]
	    private String getXSLFileNameMob(String xslFileName, String xslFileName1, String enterprise) throws ITMException 
	    {
			String retFileName1 = null;
			System.out.println("Inside getXSLFileNameMob");
			try
			{
				String defaultPath = null;
				if (CommonConstants.APPLICATION_CONTEXT != null) 
				{
					defaultPath = CommonConstants.APPLICATION_CONTEXT + CommonConstants.ITM_CONTEXT + File.separator;
				} 
				else 
				{
					defaultPath = ".." + File.separator + "webapps" + File.separator + "ibase" + File.separator
							+ CommonConstants.ITM_CONTEXT + File.separator;
				}
				File xslPath = new File(defaultPath + File.separator + "xsl" + File.separator + CommonConstants.THEME
						+ File.separator + "WIZARD");
				File xslPathStandard = new File(defaultPath + File.separator + "xsl" + File.separator + CommonConstants.THEME
						+ File.separator + "WIZARD"+ File.separator + enterprise);
				
				if (!xslPath.exists()) 
				{
					xslPath.mkdir();
				}
				File xslFile = new File(xslPath, xslFileName);
				File xslFileStandard = new File(xslPathStandard, xslFileName);
				
				if(xslFileStandard.exists())
				{
					retFileName1 = xslFileStandard.getAbsolutePath();
					System.out.println("File Path is: "+retFileName1);
				}
				else if (xslFile.exists())
				{
					retFileName1 = xslFile.getAbsolutePath();
					System.out.println("File Path is: "+retFileName1);
				} 
				else 
				{
					File xslFile1 = new File(xslPath, xslFileName1);
					retFileName1 = xslFile1.getAbsolutePath();
					if (!xslFile1.exists()) 
					{
						//System.out.println("Inside getXSLFileNameMob wizard file not found");
						throw new ITMException(
								new Exception("Wizard XSL file Not Found" + " at Location [" + retFileName1 + "]"));
					}
				}
			} catch (Exception e) {
				throw new ITMException(e);
			}
			return retFileName1;
		}
		//Added by Jay to take Summary from Enterprise folder (if exists in it) of user 19-JAN-23 [End]

	    private String getXSLFileNameMob(String xslFileName, String xslFileName1) throws ITMException 
	    {
			String retFileName1 = null;
			System.out.println("Inside getXSLFileNameMob");
			try
			{
				String defaultPath = null;
				if (CommonConstants.APPLICATION_CONTEXT != null) 
				{
					defaultPath = CommonConstants.APPLICATION_CONTEXT + CommonConstants.ITM_CONTEXT + File.separator;
				} 
				else 
				{
					defaultPath = ".." + File.separator + "webapps" + File.separator + "ibase" + File.separator
							+ CommonConstants.ITM_CONTEXT + File.separator;
				}
				File xslPath = new File(defaultPath + File.separator + "xsl" + File.separator + CommonConstants.THEME
						+ File.separator + "WIZARD");
				if (!xslPath.exists()) 
				{
					xslPath.mkdir();
				}
				File xslFile = new File(xslPath, xslFileName);
				if (xslFile.exists())
				{
					//System.out.println("Inside getXSLFileNameMob xslFile.exists()");
					retFileName1 = xslFile.getAbsolutePath();
				} 
				else 
				{
					File xslFile1 = new File(xslPath, xslFileName1);
					retFileName1 = xslFile1.getAbsolutePath();
					//System.out.println("Inside getXSLFileNameMob xslFile1.exists()");
					if (!xslFile1.exists()) 
					{
						//System.out.println("Inside getXSLFileNameMob wizard file not found");
						throw new ITMException(
								new Exception("Wizard XSL file Not Found" + " at Location [" + retFileName1 + "]"));
					}
				}
			} catch (Exception e) {
				throw new ITMException(e);
			}
			return retFileName1;
		}
	    public String getUnlistedCustomerList(Connection connectionObject, String dcrId) throws ITMException
		{


			PreparedStatement pstmt = null;
			ResultSet rs = null ;
			ArrayList temp = new ArrayList();
			String sql = "";
			String scCode = "";
			String unlistCodeList="";
			try
			{
				//sql= "SELECT STRG_CODE FROM STRG_MEET WHERE DCR_ID = ? AND STRG_CODE NOT IN (SELECT SC.SC_CODE FROM STRG_CUSTOMER SC)";

				sql= "SELECT STRG_CODE FROM STRG_MEET WHERE DCR_ID = ? AND STRG_CODE NOT IN (SELECT SC.SC_CODE FROM STRG_CUSTOMER SC) AND STRG_CODE NOT IN (SELECT CUST.CUST_CODE FROM CUSTOMER CUST)";

				pstmt = connectionObject.prepareStatement(sql);
				pstmt.setString(1,dcrId);
				rs = pstmt.executeQuery();
				while(rs.next())
				{
					scCode= rs.getString("STRG_CODE");
					temp.add(scCode.trim());
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(!temp.isEmpty()) 
				{
					OrgStructure orgStructure = new OrgStructure();
					unlistCodeList=orgStructure.getFormattedList(temp);
				}
				if(unlistCodeList==null || unlistCodeList.trim().length()==0)
				{
					unlistCodeList="'X'";
				}
				

			}
			catch(Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);

			}
			//Added by bhagyashri T for dirty Connection issue [25/07/2022] 
			finally {
				try
				{
					if( pstmt != null )
					{
						pstmt.close();
						pstmt = null;
					}
					if( rs != null )
					{
						rs.close();
						rs = null;
					}
					
				}
				catch( Exception e )
				{
					System.out.println( "Exception :: getUnlistedCustomerList : ["+ e.getMessage() +"]" );
					e.printStackTrace();
				}
			}
			//Added by bhagyashri T for dirty Connection issue [25/07/2022]
			return unlistCodeList;

		}
	    
	  //Added By Mrunalini Sinkar for multiple sales person and dates24-FEB-2022(Start)
		public String  viewReportsMultipleDcrMeet(String salesPerson, String fromEventDate,String toEventDate, String actionFlag, String callReport,String reportId,String deviceType,String profileId) throws RemoteException, ITMException
		{
			String summHtmlData = "";
			InitialContext ctx = null;
			String xslFileName ="";
			PreparedStatement pstmt=null;
			ResultSet rs=null;
			Connection conn = null ; 

			try
			{
				conn =getConnection();
				E12GenericUtility genericUtility = new E12GenericUtility();
				SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());


				String fromDate="";
				String toDate="";
				System.out.println("Inside viewReportsMultipleDcrMeet fromEventDate:["+fromEventDate+"] salesPers::["+salesPerson+"] toEventDate::["+toEventDate+"] callReport::["+callReport+"] profileId::["+profileId+"]");

				if(profileId!=null && profileId.trim().length()>0)
				{
					profileId=profileId.trim();
				}
				if(fromEventDate != null && fromEventDate.length() > 0) 
				{
					fromDate = genericUtility.getValidDateTimeString( fromEventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat());
				}
				if(toEventDate != null && toEventDate.length() > 0) 
				{
					toDate = genericUtility.getValidDateTimeString( toEventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat());
				}
				String [] parmTemp = salesPerson.split(",");
				ArrayList<String> salesPersonList = new ArrayList<String>();
				for(int i = 0 ;i < parmTemp.length;i++)
				{
					if(!salesPersonList.contains(parmTemp[i]) )
					{
						salesPersonList.add(parmTemp[i]);
					}
				}

				String summaryDataAll="";
				for(int i = 0 ;i < salesPersonList.size();i++)
				{
					java.util.Date evdDate=null;

					String salesPers=checkNull(salesPersonList.get(i));
					System.out.println("salesPers is::::::["+salesPers+"]");
					String sql="SELECT DISTINCT EVENT_DATE FROM SPRS_ACT_TRAN WHERE SALES_PERS=? AND EVENT_DATE BETWEEN ? AND ? ORDER BY EVENT_DATE";
					pstmt = conn.prepareStatement(sql);					
					pstmt.setString(1, salesPers);
					pstmt.setTimestamp( 2, java.sql.Timestamp.valueOf( fromDate ) );
					pstmt.setTimestamp( 3, java.sql.Timestamp.valueOf( toDate ) );

					rs = pstmt.executeQuery();
					while(rs.next())
					{
						evdDate=rs.getDate("EVENT_DATE");
						String eventDate =sdf.format(evdDate);
						String summaryData = getMultipleSummaryDetailDcrMeet( salesPers, eventDate, actionFlag ,callReport,reportId,deviceType,profileId);
						System.out.println("Device Type is:"+deviceType);
						if(deviceType!=null && "Browser".equalsIgnoreCase(deviceType))
						{
							xslFileName = getXSLFileName( "strg_analysis_view_wiz_" + this.user_lang + "_" + this.user_country + ".xsl" );
						}
						else
						{
							//System.out.println("Device Type is in else is:"+deviceType);
							xslFileName = getXSLFileNameMob( "strg_analysis_view_wiz_MOBILE_" + this.user_lang + "_" + this.user_country + ".xsl" ,"strg_meet_dcr_conf_wiz_" + this.user_lang + "_" + this.user_country + ".xsl");
						}
						System.out.println("xslFileName ::"+xslFileName);
						

						if(summaryDataAll==null || summaryDataAll.trim().length()==0)
						{
							summaryDataAll=summaryData;
						}
						else
						{
							summaryDataAll=summaryDataAll+summaryData;
						}
					}
					if (rs != null)
					{
						rs.close();
						rs = null;
					}
					if(pstmt !=null)
					{
						pstmt.close();
						pstmt = null;
					}
					
					

					
				}
				System.out.println("summaryDataAll is change:["+summaryDataAll+"]");



				
			
                if(summaryDataAll!=null && summaryDataAll.trim().length()>0)
				{
					StringBuffer valueXmlString = new StringBuffer();
					valueXmlString.append( "<Root>\r\n" );
					valueXmlString.append(summaryDataAll);
					valueXmlString.append( "</Root>\r\n" );	
					String summaryMain=valueXmlString.toString();
					System.out.println("summaryMain iss test:["+summaryMain+"]");
					summHtmlData = genericUtility.transformToString( xslFileName, summaryMain, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );

				}
				else
				{
				    return summHtmlData;
				}


			}
			catch(Exception e )
			{
				System.out.println("Exception : DCRSummaryBean :viewReportsDcrMeet() :==>\n"+e.getMessage());
				e.printStackTrace();
				throw new ITMException(e);
			}
			finally
			{
				try
				{
					if( conn != null && ! conn.isClosed() )
					{
						conn.close();
						conn = null;
					}
				}
				catch(Exception e)
				{
					System.out.println( "Exception :getSummaryDetailDcrMeet():==>\n"+e.getMessage());
					throw new ITMException(e);
				}
			}
			System.out.println("summHtmlData sisisi : ["+ summHtmlData +"]");

			return summHtmlData;
		}
		public String getMultipleSummaryDetailDcrMeet(String salesPers, String eventDate, String actionFlag ,String callReport,String reportId,String deviceType, String profileId)throws ITMException
		{
			PreparedStatement pstmt = null;
			PreparedStatement pstmtNoOfVis = null ;
			
			int domID = 1;
			
			ConnDriver connDriver = new ConnDriver();
			Connection conn = null ; 
			StringBuffer missedDateBuffer;
			
			//added by prachi
			HashMap<String, String> itemUsageMap = new HashMap<String, String>();
			DARCommonBean dcb = new DARCommonBean();
			
			StringBuffer valueXmlString = new StringBuffer();

			try
			{
				String eventDateDBFmt = "";
				System.out.println("Inside getSummaryDetailDcrMeet eventDate:["+eventDate+"] salesPers::["+salesPers+"] callReport::["+callReport+"] profileId:["+profileId+"]actionFlag"+actionFlag);
				String darDatesAna = eventDate.replaceAll("[^a-zA-Z0-9]", "");
				System.out.println("darDatesAna::::["+darDatesAna+"]");
				int unconfCnt = 0;
				E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
				/*conn = connDriver.getConnectDB( "DriverValidator" );*/
				//added by sachin satre on [14-nov-16] [start]
				conn =getConnection();
				//System.out.println("connectionObject"+conn);
				//added by sachin satre on [14-nov-16] [end]
				String oldData=checkNull(getSfaParmValue(salesPers, "OLD_METIS_DAR_DATA", conn));
				String isFortuneAct=checkNull(getSfaParmValue(salesPers,"IS_FORTUNE_ACTIVITY",conn));//Added By Mrunalini Sinkar For Fortune Server 20-May-2020
				//changes by shraddha M for unparsable date exception[14/10/2020]Start
				if(eventDate != null && eventDate.length() > 0) 
				{
					eventDateDBFmt = genericUtility.getValidDateTimeString( eventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat());
				}
				//String eventDateDBFmt = genericUtility.getValidDateTimeString( eventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat());
				//changes by shraddha M for unparsable date exception[14/10/2020]End
				//added by Mrunalini Sinkar on 29/01/18 for adding the is_confirm_req condition(start)
				String mgrCode = getMGREmployee(salesPers, conn); //Added By Mrunalini Sinkar on 26-sep-2018 To Reove Profile Id Condition(start)
				String confirmReq=null;
				String isConfirmReq="",isDeleteReq="";
				//Commented & Added By Mrunalini Sinkar on 26-sep-2018 To Reove Profile Id Condition(start)
				/*if(profileId.equalsIgnoreCase("MR") || profileId.equalsIgnoreCase("SFA") || profileId.equalsIgnoreCase("FLM") || profileId.equalsIgnoreCase("CHM"))
				{
					if(profileId.equalsIgnoreCase("MR") || profileId.equalsIgnoreCase("SFA"))
					{
						confirmReq="select a.is_confirmation_req as confirm,b.is_confirmation_req as del from obj_actions a,obj_actions b where a.obj_name='strg_meet_dcr_wiz' and b.obj_name='strg_meet_dcr_wiz' and  a.service_code='pre_confirm' and b.service_code='pre_cancle'";
					}
					else if(profileId.equalsIgnoreCase("FLM"))
					{
						confirmReq="select a.is_confirmation_req as confirm,b.is_confirmation_req as del from obj_actions a,obj_actions b where a.obj_name='strg_meet_mgr_dcr_wiz' and b.obj_name='strg_meet_mgr_dcr_wiz' and  a.service_code='pre_confirm' and b.service_code='pre_cancle'";
					}
					else if(profileId.equalsIgnoreCase("CHM"))
					{
						confirmReq="select a.is_confirmation_req as confirm,b.is_confirmation_req as del from obj_actions a,obj_actions b where a.obj_name='strg_meet_chk_dcr_wiz' and b.obj_name='strg_meet_chk_dcr_wiz' and  a.service_code='pre_confirm' and b.service_code='pre_cancle'";
					}
					PreparedStatement pstmtConfirmReq = conn.prepareStatement(confirmReq);
					ResultSet rsConfirmReq = pstmtConfirmReq.executeQuery();
					if(rsConfirmReq.next())
					{
						isConfirmReq=checkNull(rsConfirmReq.getString("confirm"));
						isDeleteReq=checkNull(rsConfirmReq.getString("del"));
					}
					if (rsConfirmReq != null)
					{
						rsConfirmReq.close();
						rsConfirmReq = null;
					}
					if(pstmtConfirmReq !=null)
					{
						pstmtConfirmReq.close();
						pstmtConfirmReq = null;
					}
					System.out.println("isConfirmReq is["+isConfirmReq+"] isDeleteReq is["+isDeleteReq+"]");
				}*/
				if(mgrCode.trim().length()!= 0)
				{
					confirmReq="select a.is_confirmation_req as confirm,b.is_confirmation_req as del from obj_actions a,obj_actions b where a.obj_name='strg_meet_mgr_dcr_wiz' and b.obj_name='strg_meet_mgr_dcr_wiz' and  a.service_code='pre_confirm' and b.service_code='pre_cancle'";
					
				}
				else
				{
					confirmReq="select a.is_confirmation_req as confirm,b.is_confirmation_req as del from obj_actions a,obj_actions b where a.obj_name='strg_meet_dcr_wiz' and b.obj_name='strg_meet_dcr_wiz' and  a.service_code='pre_confirm' and b.service_code='pre_cancle'";
				}
				PreparedStatement pstmtConfirmReq = conn.prepareStatement(confirmReq);
				ResultSet rsConfirmReq = pstmtConfirmReq.executeQuery();
				if(rsConfirmReq.next())
				{
					isConfirmReq=checkNull(rsConfirmReq.getString("confirm"));
					isDeleteReq=checkNull(rsConfirmReq.getString("del"));
				}
				if (rsConfirmReq != null)
				{
					rsConfirmReq.close();
					rsConfirmReq = null;
				}
				if(pstmtConfirmReq !=null)
				{
					pstmtConfirmReq.close();
					pstmtConfirmReq = null;
				}
				System.out.println("isConfirmReq is["+isConfirmReq+"] isDeleteReq is["+isDeleteReq+"]");
				//Commented & Added By Mrunalini Sinkar on 26-sep-2018 To Reove Profile Id Condition(end)
				int newCnt=0;
				boolean darOldData=false;
				String newCntSql="SELECT COUNT(*) AS COUNT FROM SPRS_ACT_TRAN WHERE SALES_PERS = ? AND EVENT_DATE = ?";
				PreparedStatement pstmtCnt=conn.prepareStatement(newCntSql);
				pstmtCnt.setString(1, salesPers);
				pstmtCnt.setTimestamp( 2, java.sql.Timestamp.valueOf( eventDateDBFmt ) );
				ResultSet rsCnt = pstmtCnt.executeQuery();
				if(rsCnt.next())
				{
					newCnt = rsCnt.getInt("COUNT");
				}
				rsCnt.close(); rsCnt = null;
				pstmtCnt.close(); pstmtCnt = null;
				String countSql="";
				if("Y".equalsIgnoreCase(oldData) && newCnt==0)
				{
					darOldData=true;
					countSql="SELECT COUNT(*) AS COUNT FROM DR_MAIN WHERE SALES_PERS = ? AND WORK_DATE = ? AND (CASE WHEN DR_MAIN.CONFIRMATION_FLAG IS NULL THEN 'N' ELSE DR_MAIN.CONFIRMATION_FLAG END) ='N'"; 
							
				}
				else
				{
					countSql = "SELECT COUNT(*) AS COUNT FROM SPRS_ACT_TRAN WHERE SALES_PERS = ? AND EVENT_DATE = ? AND (CASE WHEN SPRS_ACT_TRAN.CONFIRMED IS NULL THEN 'N' ELSE SPRS_ACT_TRAN.CONFIRMED END) ='N' ";
				}
				PreparedStatement pstmtCount = conn.prepareStatement(countSql);
				pstmtCount.setString(1, salesPers);
				pstmtCount.setTimestamp( 2, java.sql.Timestamp.valueOf( eventDateDBFmt ) );
				
				ResultSet rsCount = pstmtCount.executeQuery();
				if(rsCount.next())
				{
					unconfCnt = rsCount.getInt("COUNT");
				}
				rsCount.close(); rsCount = null;
				pstmtCount.close(); pstmtCount = null;
				
				System.out.println("unconfCnt =["+unconfCnt+"]");
				String missedData = "";
				String sfaParmData  = getSfaParmValue(salesPers,"IS_PLAN_COMPULSORY",conn);
				if(sfaParmData.equalsIgnoreCase("Y"))
				{
					missedDateBuffer = new StringBuffer();
					String []missedDataArr = new String [2]; 
					missedDataArr = getMissedData(salesPers,eventDateDBFmt, conn);
					missedDateBuffer.append(eventDate +"@"+missedDataArr[0]+"@"+missedDataArr[1]+"|");
					missedData = missedDateBuffer.toString();
				}
				System.out.println("missedData::"+missedData);
				String analysisID=salesPers+darDatesAna;
				System.out.println("analysisID is::"+analysisID);

				valueXmlString.append("<DARDetails>");
				valueXmlString.append( "<sales_pers><![CDATA[" ).append(salesPers).append( "]]></sales_pers>\r\n");
				valueXmlString.append( "<event_date_dar><![CDATA[" ).append(eventDate).append( "]]></event_date_dar>\r\n");
				valueXmlString.append( "<details_id><![CDATA[" ).append(analysisID).append( "]]></details_id>\r\n");

				//valueXmlString.append("<HeaderData>");
				valueXmlString.append( "<HeaderData domID='"+domID+"' selected = 'Y'>\r\n" );
				valueXmlString.append( "<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\"/>\r\n");
				valueXmlString.append( "<confirm_or_delete><![CDATA[" ).append(actionFlag).append( "]]></confirm_or_delete>\r\n");
				valueXmlString.append( "<callReport><![CDATA[" ).append(callReport).append( "]]></callReport>\r\n");//added by prathamesh jangam on 11/7/17 for call report in db2
				valueXmlString.append( "<event_date><![CDATA[" ).append(eventDate).append( "]]></event_date>\r\n");
				valueXmlString.append( "<unconf_cnt><![CDATA[" ).append(unconfCnt).append( "]]></unconf_cnt>\r\n");
				valueXmlString.append( "<isConfirmReq><![CDATA[" ).append(isConfirmReq).append( "]]></isConfirmReq>\r\n");//added by Mrunalini Sinkar on 29/01/18 for adding the is_confirm_req condition
				valueXmlString.append( "<isDeleteReq><![CDATA[" ).append(isDeleteReq).append( "]]></isDeleteReq>\r\n");//added by Mrunalini Sinkar on 29/01/18 for adding the is_confirm_req condition
				valueXmlString.append( "<missed_data><![CDATA[" ).append(missedData).append( "]]></missed_data>\r\n" );
				valueXmlString.append( "<report_id><![CDATA[" ).append(reportId).append( "]]></report_id>\r\n" );
				valueXmlString.append( "<device_type><![CDATA[" ).append(deviceType).append( "]]></device_type>\r\n" );
				valueXmlString.append( "<old_data><![CDATA[" ).append(darOldData).append( "]]></old_data>\r\n" );
				valueXmlString.append( "<sales_pers_header><![CDATA[" ).append(salesPers).append( "]]></sales_pers_header>\r\n");
				valueXmlString.append( "</HeaderData>\r\n");
				String stanCodeFrom  = getStanCodeFrom( conn,salesPers,eventDateDBFmt);
				
				System.out.println("eventDateDBFmt =["+eventDateDBFmt+"]");
				SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getDBDateFormat());
				Calendar cal = Calendar.getInstance();
				cal.setTime( sdf.parse(eventDateDBFmt) );
				cal.add(Calendar.DATE,-1);
				sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
				//String lastDcrDt = sdf.format(cal.getTime());
				//System.out.println("lastDcrDt =["+lastDcrDt+"]");
				
				//added by mrunalini sinkar for getting last dcr_date on 12-04-2019(start)
				Date lastDcrDt =null;
				String lastSql="";
				if("Y".equalsIgnoreCase(oldData) && newCnt==0)
				{
					lastSql="SELECT MAX(WORK_DATE) LAST_DCR_DATE FROM DR_MAIN WHERE WORK_DATE < ? AND SALES_PERS = ? "
							+ "AND ACTIVITY_CODE IN (SELECT ACTIVITY_CODE FROM FIELDACTIVITY WHERE ACTIVITY_TYPE !='PR')";
				}
				else
				{
					lastSql = "SELECT MAX(EVENT_DATE) LAST_DCR_DATE FROM SPRS_ACT_TRAN WHERE EVENT_DATE < ? AND SALES_PERS = ? "+
							  "AND ACTIVITY_CODE IN (SELECT ACTIVITY_CODE FROM FIELDACTIVITY WHERE ACTIVITY_TYPE !='PR')";
				}
				 
					pstmt =  conn.prepareStatement(lastSql);
					pstmt.setTimestamp( 1, java.sql.Timestamp.valueOf( eventDateDBFmt ) );
					pstmt.setString(2, salesPers);
					ResultSet lastRs = pstmt.executeQuery();
					if(lastRs.next())
					{
						lastDcrDt = lastRs.getDate("LAST_DCR_DATE");
					}
					if (lastRs!= null)
					{
						lastRs.close();
						lastRs = null;
					}
					if(pstmt!=null)
					{
						pstmt.close();
						pstmt = null;
					}
				String lastDcrDate="";
				if(lastDcrDt!=null )
				{
					lastDcrDate = sdf.format(lastDcrDt);

				}
				else
				{
					lastDcrDate = eventDate;

				}
				
				//added by mrunalini sinkar for getting last dcr_date on 12-04-2019(end)
				
				//Added by mrunalini sinkar to showing headquarter in summary page (start) 
				String stanCodeHQ="",headQaurter="";
				String hqSql="SELECT EMP.STAN_CODE__HQ AS STAN_CODE__HQ,ST.DESCR AS HEADQAURTER FROM EMPLOYEE EMP,STATION ST WHERE EMP.EMP_CODE=? AND EMP.STAN_CODE__HQ=ST.STAN_CODE";
				pstmt =  conn.prepareStatement(hqSql);
				pstmt.setString(1, salesPers);
				ResultSet rsSet = pstmt.executeQuery();
				rsSet = pstmt.executeQuery();
				if(rsSet.next())
				{
					stanCodeHQ = checkNull(rsSet.getString("STAN_CODE__HQ"));
					headQaurter = checkNull(rsSet.getString("HEADQAURTER"));
				}
				if (rsSet!= null)
				{
					rsSet.close();
					rsSet = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				
				//Added by mrunalini sinkar to showing headquarter in summary page (end)
				
				String placeRequired="";
				String dcrID = "",subDispDate="";
				String custDcrId="";
				String activitySql="";
				if("Y".equalsIgnoreCase(oldData) && newCnt==0)
				{
					activitySql = "SELECT '' DCR_ID,SA.SALES_PERS,SA.WORK_DATE EVENT_CODE,SP.SP_NAME SP_NAME,SA.ACTIVITY_CODE,FA.DESCR ACTIVITY_DESCR,FA.ACTIVITY_TYPE,FA.PLACE_REQUIRED,SA.REMARK    AS REMARK, " + 
					"TO_CHAR(SA.SUBMISSION_DATE, 'DD-MM-YYYY HH12:MI A.M.') AS SUBMISSION_DATE, " + 
					"(CASE WHEN SA.CONFIRMATION_FLAG IS NULL THEN 'N' ELSE SA.CONFIRMATION_FLAG END) AS CONFIRMED, " + 
					"(CASE WHEN CONFIRMATION_FLAG='Y' THEN TO_CHAR(SA.LAST_UPDATE, 'DD-MM-YYYY HH12:MI A.M.')  ELSE '' END)AS CONF_DATE " + 
					"FROM DR_MAIN SA,SALES_PERS SP,FIELDACTIVITY FA " + 
					"WHERE SA.ACTIVITY_CODE = FA.ACTIVITY_CODE " + 
					"AND SA.SALES_PERS =SP.SALES_PERS " + 
					"AND SA.SALES_PERS   = ? " + 
					"AND SA.WORK_DATE   = ? " + 
					"AND SA.ACTIVITY_CODE  <> 'PR'"; 
					
				}
				else
				{
					activitySql = "SELECT SA.DCR_ID DCR_ID,SA.SALES_PERS, SA.EVENT_DATE EVENT_CODE,SP.SP_NAME SP_NAME,SA.ACTIVITY_CODE,FA.DESCR ACTIVITY_DESCR,FA.ACTIVITY_TYPE,FA.PLACE_REQUIRED, "
							+ "SA.REMARK AS REMARK,TO_CHAR(SA.SUBMISSION_DATE, 'DD-MM-YYYY HH12:MI A.M.') AS SUBMISSION_DATE,(CASE WHEN SA.CONFIRMED IS NULL THEN 'N' ELSE SA.CONFIRMED END) AS CONFIRMED,TO_CHAR(SA.CONF_DATE, 'DD-MM-YYYY HH12:MI A.M.') AS CONF_DATE FROM " +
							"SPRS_ACT_TRAN SA, SALES_PERS SP,FIELDACTIVITY FA WHERE SA.ACTIVITY_CODE = FA.ACTIVITY_CODE AND SA.SALES_PERS=SP.SALES_PERS " +
							"AND SA.SALES_PERS = ? and SA.EVENT_DATE = ? AND SA.ACTIVITY_CODE <> 'PR'";
				}
				
				PreparedStatement pstmtAct = null;
				pstmtAct = conn.prepareStatement(activitySql);
				pstmtAct.setString(1, salesPers);
				pstmtAct.setTimestamp( 2, java.sql.Timestamp.valueOf( eventDateDBFmt ) );
				ResultSet rsAct = pstmtAct.executeQuery();
				if(rsAct.next())
				{
					dcrID = checkNull(rsAct.getString("DCR_ID"));
					custDcrId=dcrID;
					placeRequired= checkNull(rsAct.getString("PLACE_REQUIRED"));
					subDispDate= checkNull(rsAct.getString("SUBMISSION_DATE"));
					
					valueXmlString.append("<Detail1"+analysisID+" domID='"+domID+"' selected = 'Y'>\r\n" );
					if(subDispDate!=null && subDispDate.trim().length()>0)
					{
						valueXmlString.append("<submit_show_date><![CDATA[" ).append(subDispDate).append( "]]></submit_show_date>\r\n" );//Added by Mrunalini Sinkar
					}
					else
					{
						String drDispDate=checkNull(getSubmissionDate(salesPers,eventDateDBFmt,conn));
						valueXmlString.append("<submit_show_date><![CDATA[" ).append(drDispDate).append( "]]></submit_show_date>\r\n" );//Added by Mrunalini Sinkar
					}
					valueXmlString.append("<event_date><![CDATA[" ).append(eventDate).append( "]]></event_date>\r\n");					
					valueXmlString.append("<activity_descr><![CDATA[" ).append( checkNull(rsAct.getString("ACTIVITY_DESCR")).trim()).append( "]]></activity_descr>\r\n");							
					valueXmlString.append("<sales_pers_sp_name><![CDATA[" ).append( checkNull(rsAct.getString("SP_NAME")).trim()).append( "]]></sales_pers_sp_name>\r\n");							
					valueXmlString.append("<sprs_route_descr><![CDATA[" ).append( checkNull(stanCodeFrom).trim()).append( "]]></sprs_route_descr>\r\n");
					valueXmlString.append("<last_dcr_date><![CDATA[" ).append(lastDcrDate).append( "]]></last_dcr_date>\r\n");	
					valueXmlString.append("<activity_type><![CDATA[" ).append( checkNull(rsAct.getString("ACTIVITY_TYPE")).trim()).append( "]]></activity_type>\r\n"); // added by Mrunalini sinkar on 27/06/18 for showing Activity type
					valueXmlString.append("<remark><![CDATA[" ).append( checkNull(rsAct.getString("REMARK")).trim()).append( "]]></remark>\r\n"); // added by rupali on 10/11/17 for showing remark on confirm and delete report
					valueXmlString.append("<is_mgr><![CDATA[" ).append(mgrCode).append( "]]></is_mgr>\r\n");//added by Mrunalini Sinkar on 29/01/18 for adding the is_confirm_req condition
					valueXmlString.append("<place_required><![CDATA[" ).append(checkNull(rsAct.getString("PLACE_REQUIRED"))).append( "]]></place_required>\r\n");
					//added by mrunalini sinkar for redesing xsl
					valueXmlString.append("<host_url><![CDATA[" ).append(CommonConstants.TOMCAT_HOME).append( "]]></host_url>\r\n" );
					valueXmlString.append("<sales_pers><![CDATA[" ).append( checkNull(rsAct.getString("SALES_PERS")).trim()).append( "]]></sales_pers>\r\n");							
					valueXmlString.append("<activity_code><![CDATA[" ).append( checkNull(rsAct.getString("ACTIVITY_CODE")).trim()).append( "]]></activity_code>\r\n");							
					valueXmlString.append("<stan_code__hq><![CDATA[" ).append(stanCodeHQ).append( "]]></stan_code__hq>\r\n" );//Added by mrunalini sinkar to showing headquarter in summary page
					valueXmlString.append("<headquarter><![CDATA[" ).append(headQaurter).append( "]]></headquarter>\r\n" );//Added by mrunalini sinkar to showing headquarter in summary page
					valueXmlString.append("<confirmed><![CDATA[" ).append(checkNull(rsAct.getString("CONFIRMED"))).append( "]]></confirmed>\r\n");
					valueXmlString.append("<conf_date><![CDATA[" ).append(checkNull(rsAct.getString("CONF_DATE"))).append( "]]></conf_date>\r\n");
					valueXmlString.append( "<sales_pers_detail><![CDATA[" ).append(salesPers).append( "]]></sales_pers_detail>\r\n");
					valueXmlString.append("</Detail1"+analysisID+">\r\n" );
				}
				rsAct.close();
				rsAct = null;
				pstmtAct.close();
				pstmtAct = null;
				
				String actTypeNew = "";
				//commented & added by mrunalini sinkar fro showing the locality_code from and locality_code to as per the route ID on 25-04-2019(start)
				//added by mrunalini sinkar on 27-june-2018 to shown locality_code & locality_code_from on confirm delete report(starstartt)
				//String locSql = "SELECT LO.DESCR LOCALITY, ST.ORDER_OF_VISIT ORDEROFVISIT FROM SPRS_TRAVEL ST,LOCALITY LO WHERE ST.LOCALITY_CODE = LO.LOCALITY_CODE AND DCR_ID = ?";
				/*String locSql = "SELECT LO.DESCR LOCALITY,LOFRM.DESCR AS LOCALITY_FROM, ST.ORDER_OF_VISIT ORDEROFVISIT FROM SPRS_TRAVEL ST,LOCALITY LO ,LOCALITY LOFRM WHERE ST.LOCALITY_CODE = LO.LOCALITY_CODE AND ST.LOCALITY_CODE_FROM=LOFRM.LOCALITY_CODE AND DCR_ID = ? ORDER BY ST.ORDER_OF_VISIT ";
				//added by mrunalini sinkar on 27-june-2018 to shown locality_code & locality_code_from on confirm delete report(end)
				PreparedStatement pstmtLoc = null;
				pstmtLoc = conn.prepareStatement(locSql);
				pstmtLoc.setString(1, dcrID);
				ResultSet rsLoc = pstmtLoc.executeQuery();
				while(rsLoc.next())
				{
					//dcrID = checkNull(rsAct.getString("DCR_ID"));
					valueXmlString.append( "<Detail2 domID='"+domID+"' selected = 'Y'>\r\n" );
					valueXmlString.append( "<sprs_route_descr><![CDATA[" ).append( checkNull(rsLoc.getString("LOCALITY"))).append( "]]></sprs_route_descr>\r\n");
					valueXmlString.append( "<sprs_route_frm_descr><![CDATA[" ).append( checkNull(rsLoc.getString("LOCALITY_FROM"))).append( "]]></sprs_route_frm_descr>\r\n");	// added by Mrunalini sinkar on 27/06/18 for showing locality From
					valueXmlString.append( "<order_of_visit><![CDATA[" ).append( checkNull(rsLoc.getString("ORDEROFVISIT"))).append( "]]></order_of_visit>\r\n");	
					valueXmlString.append( "</Detail2>\r\n" );
				}
				rsLoc.close();
				rsLoc = null;
				pstmtLoc.close();
				pstmtLoc = null;*/
				
				String isFortune  = checkNull(getSfaParmValue(salesPers,"IS_FORTUNE_ACTIVITY",conn));
				// Added by Hariom S for Activity form changes in fortune server --18-May-2021 [Start]
				String activityCode = "";
				String activityDesc = "";
				String timeFrom = "";
				String TimeTo = "";
				if("Y".equalsIgnoreCase(isFortune))
				{
				String activityDataSql = "SELECT A.ACTIVITY_CODE AS ACTIVITY_CODE, A.DESCR AS DESCR,A.ACTIVITY_TYPE AS ACTIVITY_TYPE ,B.VISIT_TIME_FR AS VISIT_TIME_FR, B.VISIT_TIME_TO AS VISIT_TIME_TO , B.REMARK AS REMARK , B.dcr_id as dcr_id ,B.sales_pers as  sales_pers , B.event_date as event_date " +
						"FROM FIELDACTIVITY A, SPRS_ACTIVITY B, SALES_PERS S " +
						"WHERE A.ACTIVITY_CODE = B.ACTIVITY_CODE AND S.SALES_PERS = B.SALES_PERS  " +
						"AND B.SALES_PERS= ? " +
						"AND B.event_date= ? AND A.STATUS = 'Y' ORDER BY A.DESCR";
				
				PreparedStatement pstmtActivity =  conn.prepareStatement(activityDataSql);
				 
				pstmtActivity.setString(1, salesPers);
				pstmtActivity.setTimestamp( 2, java.sql.Timestamp.valueOf( eventDateDBFmt ) );
					
				ResultSet rsActivity= pstmtActivity.executeQuery();
				
				while(rsActivity.next())
				{
					activityCode =checkNull(rsActivity.getString("ACTIVITY_CODE"));
					activityDesc =checkNull(rsActivity.getString("DESCR"));
					timeFrom =checkNull(rsActivity.getString("VISIT_TIME_FR"));
					TimeTo =checkNull(rsActivity.getString("VISIT_TIME_TO"));
					
					
					valueXmlString.append("<ActivityData"+analysisID+" domID='"+domID+"' selected = 'Y'>\r\n" );
					valueXmlString.append("<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\"/>\r\n");
					valueXmlString.append("<activity_code><![CDATA[" ).append(activityCode ).append( "]]></activity_code>\r\n");
					valueXmlString.append("<activity_descr><![CDATA[" ).append(activityDesc ).append( "]]></activity_descr>\r\n");
					valueXmlString.append("<visit_time_fr><![CDATA[" ).append(timeFrom ).append( "]]></visit_time_fr>\r\n");
					valueXmlString.append("<visit_time_to><![CDATA[" ).append(TimeTo ).append( "]]></visit_time_to>\r\n");
					valueXmlString.append("<sales_pers_activity><![CDATA[" ).append(salesPers).append( "]]></sales_pers_activity>\r\n");
					valueXmlString.append("</ActivityData"+analysisID+">\r\n" );
					
				}
		
				if (rsActivity!= null)
				{
					rsActivity.close();
					rsActivity = null;
				}
				if(pstmtActivity!=null)
				{
					pstmtActivity.close();
					pstmtActivity = null;
				}
				}
				// Added by Harion S for Activity form changes in fortune server --18-May-2021 [End]
				if("Y".equalsIgnoreCase(placeRequired))
				{
					if(mgrCode.trim().length()!= 0)
					{

						if("Y".equalsIgnoreCase(oldData) && newCnt==0)
						{
							
							String mgrTravelDet="SELECT DR.FROM_ROUTE_DESCR,DR.WRK_ROUTE_DESCR,DR.SALES_PERS_MGR,SP.SP_NAME,A.DESCR AS WORK_STAN_DESCR,B.DESCR FROM_STAN_DESCR,TMM.TRAVEL_MODE_DESCR,DR.LINE_NO FROM  " + 
									"DR_TRAVEL_DETAILS DR LEFT OUTER JOIN TRAVEL_MODE_MASTER TMM ON DR.TRAVEL_MODE_ID=TMM.TRAVEL_MODE_ID,SALES_PERS SP,STATION A,STATION B WHERE DR.SALES_PERS=? AND DR.WORK_DATE=? AND DR.SALES_PERS_MGR=SP.SALES_PERS AND DR.FROM_STAN_CODE=B.STAN_CODE " + 
									"AND DR.WORK_STAN_CODE=A.STAN_CODE ORDER BY DR.LINE_NO";
							PreparedStatement pstmtMgrTrvl=conn.prepareStatement(mgrTravelDet);;
							pstmtMgrTrvl.setString(1, salesPers);
							pstmtMgrTrvl.setTimestamp( 2, java.sql.Timestamp.valueOf( eventDateDBFmt ) );
							ResultSet rsMgrTrvl = pstmtMgrTrvl.executeQuery();
							while(rsMgrTrvl.next())
							{
								valueXmlString.append("<Detail2"+analysisID+" domID='"+domID+"' selected = 'Y'>\r\n" );
								valueXmlString.append("<sprs_route_descr><![CDATA[" ).append( checkNull(rsMgrTrvl.getString("WRK_ROUTE_DESCR"))).append( "]]></sprs_route_descr>\r\n");
								valueXmlString.append("<sprs_route_frm_descr><![CDATA[" ).append( checkNull(rsMgrTrvl.getString("FROM_ROUTE_DESCR"))).append( "]]></sprs_route_frm_descr>\r\n");	// added by Mrunalini sinkar on 27/06/18 for showing locality From
								valueXmlString.append("<order_of_visit><![CDATA[" ).append(checkNull(rsMgrTrvl.getString("LINE_NO"))).append( "]]></order_of_visit>\r\n");	
								valueXmlString.append("<station_frm_descr><![CDATA[" ).append( checkNull(rsMgrTrvl.getString("FROM_STAN_DESCR"))).append( "]]></station_frm_descr>\r\n");
								valueXmlString.append("<station_to_descr><![CDATA[" ).append( checkNull(rsMgrTrvl.getString("TRAVEL_MODE_DESCR"))).append( "]]></station_to_descr>\r\n");	
								valueXmlString.append("<travel_mode><![CDATA[" ).append( checkNull(rsMgrTrvl.getString("TRAVEL_MODE_DESCR"))).append( "]]></travel_mode>\r\n");
								valueXmlString.append("<sprs_ww__name><![CDATA[" ).append( checkNull(rsMgrTrvl.getString("SP_NAME"))).append( "]]></sprs_ww__name>\r\n");	
								valueXmlString.append("<sales_pers_place><![CDATA[" ).append(salesPers).append( "]]></sales_pers_place>\r\n");
								valueXmlString.append( "</Detail2"+analysisID+">\r\n" );
							}
							rsMgrTrvl.close();
							rsMgrTrvl = null;
							pstmtMgrTrvl.close();
							pstmtMgrTrvl = null;
						}
						else
						{

							PreparedStatement pstmtMgrTrvl=null;
							ResultSet rsMgrTrvl=null;
							String locFromDescr="";
							String maxTravelSql="SELECT ROUTE_DESCR__START FROM SPRS_ACT_TRAN  WHERE DCR_ID=?";
							pstmtMgrTrvl =conn.prepareStatement(maxTravelSql);
							pstmtMgrTrvl.setString(1, dcrID);
							rsMgrTrvl = pstmtMgrTrvl.executeQuery();
							if(rsMgrTrvl.next())
							{
								locFromDescr=checkNull(rsMgrTrvl.getString("ROUTE_DESCR__START"));
							}
							rsMgrTrvl.close();
							rsMgrTrvl = null;
							pstmtMgrTrvl.close();
							pstmtMgrTrvl = null;
							

							LinkedHashMap<String, String> travelMap=new LinkedHashMap<String, String>();
							String locToDescr="",orderOfVisit="",stationTo="",travelMode="",sprsCodeName="",stationFrm="";
							String firstVistData="SELECT (CASE WHEN ROUTETO.ROUTE_DESCR IS NOT NULL THEN ROUTETO.ROUTE_DESCR ELSE ROUTETO.DESCR END ) LOCALITY, "+
									 "STATIONTO.DESCR AS STATIONTO_DESCR,  " + 
									" ST.ORDER_OF_VISIT ORDEROFVISIT,TMM.TRAVEL_MODE_DESCR,SP.SP_NAME ||' (' ||TRIM(ROUTETO.SPRS_CODE)||')' AS SPRS_CODE__NAME "+
									"FROM SPRS_TRAVEL ST LEFT OUTER JOIN TRAVEL_MODE_MASTER TMM ON ST.TRAVEL_MODE=TMM.TRAVEL_MODE_ID,SPRS_ROUTE ROUTETO ,STATION STATIONTO, SALES_PERS SP " + 
									"  WHERE ST.ROUTE_ID = ROUTETO.ROUTE_ID AND ST.SPRS_CODE__WW=ROUTETO.SPRS_CODE " + 
									"  AND SP.SALES_PERS=ROUTETO.SPRS_CODE AND DCR_ID = ? AND ST.ORDER_OF_VISIT='1' AND ROUTETO.STAN_CODE=STATIONTO.STAN_CODE  ORDER BY ST.ORDER_OF_VISIT " ; 

							pstmtMgrTrvl =conn.prepareStatement(firstVistData);
							
							pstmtMgrTrvl.setString(1, dcrID);

							
							rsMgrTrvl = pstmtMgrTrvl.executeQuery();
							if(rsMgrTrvl.next())
							{
								locToDescr=checkNull(rsMgrTrvl.getString("LOCALITY"));
								orderOfVisit=checkNull(rsMgrTrvl.getString("ORDEROFVISIT"));
								stationTo=checkNull(rsMgrTrvl.getString("STATIONTO_DESCR"));
								travelMode=checkNull(rsMgrTrvl.getString("TRAVEL_MODE_DESCR"));
								sprsCodeName=checkNull(rsMgrTrvl.getString("SPRS_CODE__NAME"));

								travelMap.put(orderOfVisit, locFromDescr+"@"+locToDescr+"@"+stationTo+'@'+stationTo+'@'+travelMode+'@'+sprsCodeName);
							}
							rsMgrTrvl.close();
							rsMgrTrvl = null;
							pstmtMgrTrvl.close();
							pstmtMgrTrvl = null;
							

							String anotherData="SELECT (CASE WHEN ROUTETO.ROUTE_DESCR IS NOT NULL THEN ROUTETO.ROUTE_DESCR ELSE ROUTETO.DESCR END ) LOCALITY,STATIONTO.DESCR AS STATIONTO_DESCR, " + 
									" (CASE WHEN ROUTEFROM.ROUTE_DESCR IS NOT NULL THEN ROUTEFROM.ROUTE_DESCR ELSE ROUTEFROM.DESCR END )LOCALITY_FROM,STATIONFROM.DESCR AS STATIONFROM_DESCR, " + 
									" ST.ORDER_OF_VISIT ORDEROFVISIT,TMM.TRAVEL_MODE_DESCR,SP.SP_NAME ||' (' ||TRIM(ROUTETO.SPRS_CODE)||')' AS SPRS_CODE__NAME  FROM SPRS_TRAVEL ST LEFT OUTER JOIN TRAVEL_MODE_MASTER TMM ON ST.TRAVEL_MODE=TMM.TRAVEL_MODE_ID,SPRS_ROUTE ROUTETO ,SPRS_ROUTE ROUTEFROM ,STATION STATIONTO, STATION STATIONFROM,SALES_PERS SP WHERE ST.ROUTE_ID   = ROUTETO.ROUTE_ID " + 
									" AND ST.ROUTE_ID_FROM=ROUTEFROM.ROUTE_ID AND ST.SPRS_CODE__WW=ROUTETO.SPRS_CODE " + 
									" AND ROUTEFROM.SPRS_CODE = " + 
									" (SELECT SPRS_CODE__WW FROM SPRS_TRAVEL WHERE DCR_ID=? AND " + 
									" ORDER_OF_VISIT= (SELECT MAX(ORDER_OF_VISIT) FROM SPRS_TRAVEL WHERE DCR_ID = ? AND ORDER_OF_VISIT<ST.ORDER_OF_VISIT ))  " + 
									" AND SP.SALES_PERS=ROUTETO.SPRS_CODE AND DCR_ID = ? and  ST.ORDER_OF_VISIT<>'1' AND ROUTETO.STAN_CODE=STATIONTO.STAN_CODE AND ROUTEFROM.STAN_CODE=STATIONFROM.STAN_CODE ORDER BY ST.ORDER_OF_VISIT ";
									
							pstmtMgrTrvl =conn.prepareStatement(anotherData);
							
							pstmtMgrTrvl.setString(1, dcrID);
							pstmtMgrTrvl.setString(2, dcrID);
							pstmtMgrTrvl.setString(3, dcrID);
							rsMgrTrvl = pstmtMgrTrvl.executeQuery();
							while(rsMgrTrvl.next())
							{
								locToDescr=checkNull(rsMgrTrvl.getString("LOCALITY"));
								locFromDescr=checkNull(rsMgrTrvl.getString("LOCALITY_FROM"));
								orderOfVisit=checkNull(rsMgrTrvl.getString("ORDEROFVISIT"));
								stationFrm=checkNull(rsMgrTrvl.getString("STATIONFROM_DESCR"));
								stationTo=checkNull(rsMgrTrvl.getString("STATIONTO_DESCR"));
								travelMode=checkNull(rsMgrTrvl.getString("TRAVEL_MODE_DESCR"));
								sprsCodeName=checkNull(rsMgrTrvl.getString("SPRS_CODE__NAME"));


								travelMap.put(orderOfVisit, locFromDescr+"@"+locToDescr+"@"+stationFrm+'@'+stationTo+'@'+travelMode+'@'+sprsCodeName);
							}
							rsMgrTrvl.close();
							rsMgrTrvl = null;
							pstmtMgrTrvl.close();
							pstmtMgrTrvl = null;
							
							  if(!travelMap.isEmpty())
				              {				

				            	  for (Entry<String, String> entry: travelMap.entrySet())
				            	  {
										String orderofVisit= entry.getKey();
										String value = entry.getValue();
										String locArray[]=value.split("@");
										System.out.println("travelMap["+travelMap+"]");
										String localityFrom =checkNull(locArray[0]);
										String localityTo =checkNull(locArray[1]);
										String stationFrmDescr =checkNull(locArray[2]);
										String stationToDescr =checkNull(locArray[3]);
										String travelModeDescr =checkNull(locArray[4]);

										String sprsCodeWWNAme =checkNull(locArray[5]);


										valueXmlString.append( "<Detail2"+analysisID+" domID='"+domID+"' selected = 'Y'>\r\n" );
										valueXmlString.append( "<sprs_route_descr><![CDATA[" ).append( checkNull(localityTo)).append( "]]></sprs_route_descr>\r\n");
										valueXmlString.append( "<sprs_route_frm_descr><![CDATA[" ).append( checkNull(localityFrom)).append( "]]></sprs_route_frm_descr>\r\n");	// added by Mrunalini sinkar on 27/06/18 for showing locality From
										valueXmlString.append( "<order_of_visit><![CDATA[" ).append(checkNull(orderofVisit)).append( "]]></order_of_visit>\r\n");	
										valueXmlString.append( "<station_frm_descr><![CDATA[" ).append( checkNull(stationFrmDescr)).append( "]]></station_frm_descr>\r\n");
										valueXmlString.append( "<station_to_descr><![CDATA[" ).append( checkNull(stationToDescr)).append( "]]></station_to_descr>\r\n");	
										valueXmlString.append( "<travel_mode><![CDATA[" ).append( checkNull(travelModeDescr)).append( "]]></travel_mode>\r\n");
										valueXmlString.append( "<sprs_ww__name><![CDATA[" ).append( checkNull(sprsCodeWWNAme)).append( "]]></sprs_ww__name>\r\n");	
										valueXmlString.append("<sales_pers_place><![CDATA[" ).append(salesPers).append( "]]></sales_pers_place>\r\n");
										valueXmlString.append( "</Detail2"+analysisID+">\r\n" );

				            	  }
				              }
						
						}
						
					}
					else
					{
						String locSql="";
						PreparedStatement pstmtLoc = null;

						if("Y".equalsIgnoreCase(oldData) && newCnt==0)
						{
							locSql="SELECT DR.FROM_ROUTE_DESCR LOCALITY_FROM ,DR.WRK_ROUTE_DESCR LOCALITY,A.DESCR AS STATIONTO_DESCR,B.DESCR STATIONFROM_DESCR,TMM.TRAVEL_MODE_DESCR TRAVEL_MODE_DESCR,DR.LINE_NO ORDEROFVISIT FROM  " + 
									" DR_TRAVEL_DETAILS DR LEFT OUTER JOIN TRAVEL_MODE_MASTER TMM ON DR.TRAVEL_MODE_ID=TMM.TRAVEL_MODE_ID,STATION A,STATION B WHERE DR.SALES_PERS=? AND DR.WORK_DATE=? AND  DR.FROM_STAN_CODE=B.STAN_CODE " + 
									" AND DR.WORK_STAN_CODE=A.STAN_CODE  ORDER BY DR.LINE_NO";
							pstmtLoc = conn.prepareStatement(locSql);
							pstmtLoc.setString(1, salesPers);
							pstmtLoc.setTimestamp( 2, java.sql.Timestamp.valueOf( eventDateDBFmt ) );
						}
						else
						{
							locSql = "SELECT (CASE WHEN ROUTETO.ROUTE_DESCR IS NOT NULL THEN ROUTETO.ROUTE_DESCR ELSE ROUTETO.DESCR END ) LOCALITY,STATIONTO.DESCR AS STATIONTO_DESCR, " + 
									" (CASE WHEN ROUTEFROM.ROUTE_DESCR IS NOT NULL THEN ROUTEFROM.ROUTE_DESCR ELSE ROUTEFROM.DESCR END )LOCALITY_FROM,STATIONFROM.DESCR AS STATIONFROM_DESCR, " + 
									" ST.ORDER_OF_VISIT ORDEROFVISIT,TMM.TRAVEL_MODE_DESCR FROM SPRS_TRAVEL ST LEFT OUTER JOIN TRAVEL_MODE_MASTER TMM ON ST.TRAVEL_MODE=TMM.TRAVEL_MODE_ID ,SPRS_ROUTE ROUTETO ,SPRS_ROUTE ROUTEFROM,STATION STATIONTO,STATION STATIONFROM  WHERE ST.ROUTE_ID   = ROUTETO.ROUTE_ID " + 
							" AND ST.ROUTE_ID_FROM=ROUTEFROM.ROUTE_ID AND ST.SALES_PERS=ROUTETO.SPRS_CODE AND ST.SALES_PERS=ROUTEFROM.SPRS_CODE AND ROUTETO.STAN_CODE=STATIONTO.STAN_CODE AND ROUTEFROM.STAN_CODE=STATIONFROM.STAN_CODE " + 
							"AND DCR_ID = ? ORDER BY ST.ORDER_OF_VISIT " ;
							pstmtLoc = conn.prepareStatement(locSql);
							pstmtLoc.setString(1, dcrID);
								
						}

						ResultSet rsLoc = pstmtLoc.executeQuery();
						while(rsLoc.next())
						{
							//dcrID = checkNull(rsAct.getString("DCR_ID"));
							valueXmlString.append( "<Detail2"+analysisID+" domID='"+domID+"' selected = 'Y'>\r\n" );
							valueXmlString.append( "<sprs_route_descr><![CDATA[" ).append( checkNull(rsLoc.getString("LOCALITY"))).append( "]]></sprs_route_descr>\r\n");
							valueXmlString.append( "<sprs_route_frm_descr><![CDATA[" ).append( checkNull(rsLoc.getString("LOCALITY_FROM"))).append( "]]></sprs_route_frm_descr>\r\n");	// added by Mrunalini sinkar on 27/06/18 for showing locality From
							valueXmlString.append( "<order_of_visit><![CDATA[" ).append( checkNull(rsLoc.getString("ORDEROFVISIT"))).append( "]]></order_of_visit>\r\n");	
							valueXmlString.append( "<station_frm_descr><![CDATA[" ).append( checkNull(rsLoc.getString("STATIONFROM_DESCR"))).append( "]]></station_frm_descr>\r\n");
							valueXmlString.append( "<station_to_descr><![CDATA[" ).append( checkNull(rsLoc.getString("STATIONTO_DESCR"))).append( "]]></station_to_descr>\r\n");	
							valueXmlString.append( "<travel_mode><![CDATA[" ).append( checkNull(rsLoc.getString("TRAVEL_MODE_DESCR"))).append( "]]></travel_mode>\r\n");	
							valueXmlString.append("<sales_pers_place><![CDATA[" ).append(salesPers).append( "]]></sales_pers_place>\r\n");
							valueXmlString.append( "</Detail2"+analysisID+">\r\n" );
						}
						rsLoc.close();
						rsLoc = null;
						pstmtLoc.close();
						pstmtLoc = null;
					
					}
				}
				
				//added by mrunalini sinkar on 27-june-2018 to shown locality_code & locality_code_from on confirm delete report(end)
				//commented & added by mrunalini sinkar fro showing the locality_code from and locality_code to as per the route ID on 25-04-2019(end)

				/*String sqlEdit  ="SELECT STRG_MEET.*,LOCALITY.DESCR LOC_DESCR,FIELDACTIVITY.ACTIVITY_TYPE ACT_TYPE,"+    
					 	" UPPER(STRG_CUSTOMER.FIRST_NAME)||' '||UPPER(STRG_CUSTOMER.LAST_NAME) AS SC_NAME,"+ 
						" STRG_CUSTOMER.ADDR1,STRG_CUSTOMER.ADDR2,STRG_CUSTOMER.ADDR3, STRG_MEET.STRG_TYPE AS CUST_TYPE, "+ 
						" (CASE WHEN STRG_MEET.STRG_TYPE = 'D' THEN 1  WHEN STRG_MEET.STRG_TYPE='R' THEN 2  WHEN STRG_MEET.STRG_TYPE='M' THEN 3 ELSE 4 END) AS CUST_TYPE_SEQ "+
						" FROM FIELDACTIVITY,STRG_MEET LEFT OUTER JOIN STRG_CUSTOMER ON STRG_MEET.STRG_CODE = STRG_CUSTOMER.SC_CODE "+
						" LEFT OUTER JOIN LOCALITY ON STRG_MEET.LOCALITY_CODE = LOCALITY.LOCALITY_CODE " +
						" LEFT OUTER JOIN SPRS_ACT_TRAN ON STRG_MEET.DCR_ID = SPRS_ACT_TRAN.DCR_ID  "+
						" WHERE STRG_MEET.EVENT_TYPE =FIELDACTIVITY.ACTIVITY_CODE"+
						" AND STRG_MEET.SALES_PERS = ? "+
						" AND STRG_MEET.EVENT_DATE = ? "+
						" AND STRG_CUSTOMER.CUST_TYPE  IN ('C','D','S','O') " + 
						" AND (CASE WHEN SPRS_ACT_TRAN.CONFIRMED IS NULL THEN 'N' ELSE SPRS_ACT_TRAN.CONFIRMED END) ='N' "+
						" ORDER BY CUST_TYPE_SEQ, STRG_MEET.SHORT_ID ";*/
				String stockistTable = getSfaParmValue(salesPers,"GET_STOCKIST_DETAILS",conn);
				String isMemberPresnt = checkNull(getSfaParmValue(salesPers,"HIDE_UNLIST_DET",conn));
				String divison = checkNull(getItemSer(salesPers, conn));
				DARCommonBean darCommonBean= new DARCommonBean();
				HashMap<String, String> employeeDesignationMap=darCommonBean.getEmployeeDesignationMap(divison,conn);
				System.out.println("employeeDesignationMap is["+employeeDesignationMap+"]");
				
				String sqlEdit = "";
				String dcrId = "";
				ResultSet rs=null;

				
				boolean leaveFlg=false;
				if("Y".equalsIgnoreCase(oldData) && newCnt==0)
				{
					String docSqlEdit="SELECT DDV.SC_CODE,UPPER(SC.FIRST_NAME)||' '||UPPER(SC.LAST_NAME) AS SC_NAME ,DDV.SC_TYPE AS CUST_TYPE,DDV.REMARK AS REMARKS,SC.CLASS_CODE,DDV.DOCTOR_VISIT_TIME,DDV.DR_LAST_VISIT_TIME, " + 
							"DDV.DOCTOR_POB,'LISTED' AS CUSTOMER_TYPE,DDV.SALES_PERS_MGR,L.DESCR LOC_DESCR ,SP.ITEM_SER,SS.NO_VISIT,DDV.NOOF_DOCT, " + 
							"(SELECT EMP_FNAME||' '||EMP_LNAME||'(PSR),' FROM EMPLOYEE WHERE EMP_CODE = DDV.SALES_PERS_MGR) AS VISITED_WITH_PSR_NAME,  " + 
							"(SELECT EMP_FNAME||' '||EMP_LNAME||'(FSM),' FROM EMPLOYEE WHERE EMP_CODE = DDV.VISITED_WITH_FSM) AS VISITED_WITH_FSM,   " + 
							"(SELECT EMP_FNAME||' '||EMP_LNAME||'(RSM),' FROM EMPLOYEE WHERE EMP_CODE = DDV.VISITED_WITH_RSM) AS VISITED_WITH_RSM,  " + 
							"(SELECT EMP_FNAME||' '||EMP_LNAME||'(SM)' FROM EMPLOYEE WHERE EMP_CODE = DDV.VISITED_WITH_SM) AS VISITED_WITH_SM,SS.SPL_CODE " + 
							"FROM DR_DOCTOR_VISIT DDV ,STRG_CUSTOMER SC ,LOCALITY L,SALES_PERS SP,STRG_SERIES SS " + 
							"WHERE DDV.SALES_PERS=? AND DDV.WORK_DATE=? AND SC.SC_CODE=DDV.SC_CODE AND L.LOCALITY_CODE=DDV.WORK_LOCALITY_CODE AND SP.SALES_PERS=DDV.SALES_PERS_MGR " + 
							"AND SS.SC_CODE=DDV.SC_CODE AND SS.SC_CODE=SC.SC_CODE AND SS.SALES_PERS=SP.SALES_PERS " + 
							"UNION " + 
							"SELECT DDV.SC_CODE,'UNLISTED DOCTOR MET' AS SC_NAME ,DDV.SC_TYPE AS CUST_TYPE,DDV.REMARK AS REMARKS,'' CLASS_CODE,DDV.DOCTOR_VISIT_TIME,DDV.DR_LAST_VISIT_TIME," + 
							"DDV.DOCTOR_POB,'UNLISTED' AS CUSTOMER_TYPE,DDV.SALES_PERS_MGR,L.DESCR LOC_DESCR,'' ITEM_SER,0 AS NO_VISIT,DDV.NOOF_DOCT, " + 
							"(SELECT EMP_FNAME||' '||EMP_LNAME||'(PSR),' FROM EMPLOYEE WHERE EMP_CODE = DDV.SALES_PERS_MGR) AS VISITED_WITH_PSR_NAME,  " + 
							"(SELECT EMP_FNAME||' '||EMP_LNAME||'(FSM),' FROM EMPLOYEE WHERE EMP_CODE = DDV.VISITED_WITH_FSM) AS VISITED_WITH_FSM,   " + 
							"(SELECT EMP_FNAME||' '||EMP_LNAME||'(RSM),' FROM EMPLOYEE WHERE EMP_CODE = DDV.VISITED_WITH_RSM) AS VISITED_WITH_RSM, " + 
							"(SELECT EMP_FNAME||' '||EMP_LNAME||'(SM)' FROM EMPLOYEE WHERE EMP_CODE = DDV.VISITED_WITH_SM) AS VISITED_WITH_SM,'' SPL_CODE " + 
							"FROM DR_DOCTOR_VISIT DDV  ,LOCALITY L " + 
							"WHERE DDV.SALES_PERS=? AND DDV.WORK_DATE=? AND L.LOCALITY_CODE=DDV.WORK_LOCALITY_CODE AND DDV.SC_CODE='0000000000'";
					pstmt=conn.prepareStatement(docSqlEdit);
					pstmt.setString(1, salesPers);
					pstmt.setTimestamp( 2, java.sql.Timestamp.valueOf( eventDateDBFmt ) );
					pstmt.setString(3, salesPers);
					pstmt.setTimestamp( 4, java.sql.Timestamp.valueOf( eventDateDBFmt ) );
					rs = pstmt.executeQuery();
					while (rs.next())
					{
						String teamDetails="";
						String strgCode =checkNull(rs.getString("SC_CODE"));
						String splCode=checkNull(rs.getString("SPL_CODE"));
						String classCode=checkNull(rs.getString("CLASS_CODE"));
						String itemSer=checkNull(rs.getString("ITEM_SER"));
						String psrData=checkNull(rs.getString("VISITED_WITH_PSR_NAME"));
						String fsmData=checkNull(rs.getString("VISITED_WITH_FSM"));
						String rsmData=checkNull(rs.getString("VISITED_WITH_RSM"));
						String smData=checkNull(rs.getString("VISITED_WITH_SM"));

						if(mgrCode.trim().length()!=0)
						{
							teamDetails=psrData+fsmData+rsmData+smData;
						}
						else
						{
							teamDetails=fsmData+rsmData+smData;
						}
						


						valueXmlString.append( "<doctor"+analysisID+" domID='"+domID+"' selected = 'Y'>\r\n" );
						valueXmlString.append( "<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\"/>\r\n");
						valueXmlString.append( "<strg_code><![CDATA[" ).append( checkNull(rs.getString("SC_CODE")).trim()).append( "]]></strg_code>\r\n");							
						valueXmlString.append( "<cust_name><![CDATA[" ).append( checkNull(rs.getString("SC_NAME"))).append( "]]></cust_name>\r\n");
						valueXmlString.append( "<sales_pers><![CDATA[" ).append(checkNull(salesPers)).append( "]]></sales_pers>\r\n" );
						valueXmlString.append( "<event_date><![CDATA[" ).append(eventDate).append( "]]></event_date>\r\n" );				
						valueXmlString.append( "<cust_type><![CDATA[" ).append("D").append( "]]></cust_type>\r\n");							
						valueXmlString.append( "<remarks><![CDATA[" ).append(checkNull(rs.getString("REMARKS"))).append( "]]></remarks>\r\n" );

						valueXmlString.append( "<strg_class_code><![CDATA[" ).append(checkNull(rs.getString("CLASS_CODE"))).append( "]]></strg_class_code>\r\n" );
						//Added by kailsh on 23-feb-18 [End]
						//Added by mrunalini to showing speciality no_visit on summary page(start)
						valueXmlString.append( "<event_time_start><![CDATA[" ).append(checkNull(rs.getString("DOCTOR_VISIT_TIME"))).append( "]]></event_time_start>\r\n" );
						valueXmlString.append( "<event_time_end><![CDATA[" ).append(checkNull(rs.getString("DR_LAST_VISIT_TIME"))).append( "]]></event_time_end>\r\n" );
						valueXmlString.append( "<pob_val><![CDATA[" ).append(checkNull(rs.getString("DOCTOR_POB"))).append( "]]></pob_val>\r\n" );
						valueXmlString.append( "<customer_type><![CDATA[" ).append(checkNull(rs.getString("CUSTOMER_TYPE"))).append( "]]></customer_type>\r\n" );
						if(!"0000000000".equalsIgnoreCase(strgCode))
						{
							String splDescr="";
							String splSql="SELECT DESCR AS SPECIALITY FROM SPECIALITY WHERE SPL_CODE = ?";
							PreparedStatement splPstmt=conn.prepareStatement(splSql);
							splPstmt.setString(1, splCode);

							ResultSet splRS=splPstmt.executeQuery();
							if(splRS.next())
							{
								splDescr=checkNull(splRS.getString("SPECIALITY"));
							}
							splRS.close();
							splRS = null;
							splPstmt.close();
							splPstmt = null;
							
							String classDescr="";
							String classSql="SELECT DESCR AS CLASS_CODE_DESCR FROM STRG_SER_CLASS WHERE CLASS_CODE = ? AND ITEM_SER=?";
							PreparedStatement classPstmt=conn.prepareStatement(classSql);
							classPstmt.setString(1, classCode);
							classPstmt.setString(2, itemSer);
							ResultSet classRS=classPstmt.executeQuery();
							if(classRS.next())
							{
								classDescr=checkNull(classRS.getString("CLASS_CODE_DESCR"));
							}
							classRS.close();
							classRS = null;
							classPstmt.close();
							classPstmt = null;

							valueXmlString.append("<class_code_descr><![CDATA[" ).append(classDescr).append( "]]></class_code_descr>\r\n" );
							valueXmlString.append("<spl_descr><![CDATA[" ).append(splDescr).append( "]]></spl_descr>\r\n" );
							valueXmlString.append("<no_visit><![CDATA[" ).append(checkNull(rs.getString("NO_VISIT"))).append( "]]></no_visit>\r\n" );

						}
						valueXmlString.append("<locality_descr><![CDATA[" ).append( checkNull(rs.getString("LOC_DESCR")).trim()).append( "]]></locality_descr>\r\n");
						valueXmlString.append("<team_details><![CDATA[" ).append( teamDetails ).append( "]]></team_details>\r\n" );
						//Added by Pooja S. on [30-DEC-2019] to show the coaching details  Start
						valueXmlString.append("<host_url><![CDATA[" ).append(CommonConstants.TOMCAT_HOME).append( "]]></host_url>\r\n" );
						valueXmlString.append( "<member_present><![CDATA[" ).append(checkNull(rs.getString("NOOF_DOCT"))).append( "]]></member_present>\r\n" );

						valueXmlString.append("<collection_form_no><![CDATA[" ).append("collection").append( "]]></collection_form_no>\r\n" );
						valueXmlString.append("<item_form_no><![CDATA[" ).append("doctorsampleitem").append( "]]></item_form_no>\r\n" );
						valueXmlString.append("<brand_form_no><![CDATA[" ).append("brand").append( "]]></brand_form_no>\r\n" );
						valueXmlString.append("<display_form_no><![CDATA[" ).append("display").append( "]]></display_form_no>\r\n" );
						valueXmlString.append("<survey_form_no><![CDATA[" ).append("survey").append( "]]></survey_form_no>\r\n" );
						valueXmlString.append("<prescription_form_no><![CDATA[" ).append("surveybrand").append( "]]></prescription_form_no>\r\n" );
						valueXmlString.append( "</doctor"+analysisID+">\r\n" );
						//Added by mrunalini to showing speciality no_visit on summary page(end)

						}

					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
						
					String chemSqlEdit="SELECT NOOF_CHEMIST,CHEMIST_NAME,CHEMIST_VISIT_TIME,CHEM_LAST_VISIT_TIME,ORDER_BOOKED, " + 
							" (SELECT EMP_FNAME||' '||EMP_LNAME||'(PSR),' FROM EMPLOYEE WHERE EMP_CODE = DCV.SALES_PERS_MGR) AS VISITED_WITH_PSR_NAME, " + 
							" (SELECT EMP_FNAME||' '||EMP_LNAME||'(FSM),' FROM EMPLOYEE WHERE EMP_CODE = DCV.VISITED_WITH_FSM) AS VISITED_WITH_FSM, " + 
							" (SELECT EMP_FNAME||' '||EMP_LNAME||'(RSM),' FROM EMPLOYEE WHERE EMP_CODE = DCV.VISITED_WITH_RSM) AS VISITED_WITH_RSM, "+
							"(SELECT EMP_FNAME||' '||EMP_LNAME||'(SM)' FROM EMPLOYEE WHERE EMP_CODE = DCV.VISITED_WITH_SM) AS VISITED_WITH_SM, " + 
							" DCV.REMARK, DCV.VISITED_WITH_OTHER_NAME,SR.DESCR LOC_DESCR FROM DR_CHEMIST_VISIT DCV ,SPRS_ROUTE SR " + 
							" WHERE WORK_DATE = ? AND SALES_PERS = ? AND DCV.WORK_ROUTE_ID=SR.ROUTE_ID AND DCV.SALES_PERS_MGR=SR.SPRS_CODE";	
					pstmt=conn.prepareStatement(chemSqlEdit);
					pstmt.setTimestamp( 1, java.sql.Timestamp.valueOf( eventDateDBFmt ) );
					pstmt.setString(2, salesPers);
					rs = pstmt.executeQuery();
					while (rs.next())
					{
						String psrData=checkNull(rs.getString("VISITED_WITH_PSR_NAME"));
						String fsmData=checkNull(rs.getString("VISITED_WITH_FSM"));
						String rsmData=checkNull(rs.getString("VISITED_WITH_RSM"));
						String smData=checkNull(rs.getString("VISITED_WITH_SM"));

						String teamDetails="";
						if(mgrCode.trim().length()!=0)
						{
							teamDetails=psrData+fsmData+rsmData+smData;
						}
						else
						{
							teamDetails=fsmData+rsmData+smData;
						}
						valueXmlString.append( "<retailer"+analysisID+" domID='"+domID+"' selected = 'Y'>\r\n" );
						valueXmlString.append( "<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\"/>\r\n");
						valueXmlString.append( "<strg_code><![CDATA[" ).append("UR00000000").append( "]]></strg_code>\r\n");							
						valueXmlString.append( "<cust_name><![CDATA[" ).append("No of Chemists").append( "]]></cust_name>\r\n");
						valueXmlString.append( "<sales_pers><![CDATA[" ).append(checkNull(salesPers)).append( "]]></sales_pers>\r\n" );
						valueXmlString.append( "<event_date><![CDATA[" ).append(eventDate).append( "]]></event_date>\r\n" );				
						valueXmlString.append( "<cust_type><![CDATA[" ).append("C").append( "]]></cust_type>\r\n" );				
						valueXmlString.append( "<locality_descr><![CDATA[" ).append( checkNull(rs.getString("LOC_DESCR")).trim()).append( "]]></locality_descr>\r\n");

						valueXmlString.append( "<sku_value><![CDATA[" ).append( checkNull(rs.getString("ORDER_BOOKED")).trim()).append( "]]></sku_value>\r\n");
						valueXmlString.append( "<event_time_start><![CDATA[" ).append(rs.getString("CHEMIST_VISIT_TIME")).append( "]]></event_time_start>\r\n" );
						valueXmlString.append( "<event_time_end><![CDATA[" ).append(rs.getString("CHEM_LAST_VISIT_TIME")).append( "]]></event_time_end>\r\n" );
						valueXmlString.append( "<pob_val><![CDATA[" ).append(checkNull(rs.getString("ORDER_BOOKED"))).append( "]]></pob_val>\r\n" );
						valueXmlString.append( "<customer_type><![CDATA[" ).append("UNLISTED").append( "]]></customer_type>\r\n" );
						valueXmlString.append( "<member_present><![CDATA[" ).append(checkNull(rs.getString("NOOF_CHEMIST"))).append( "]]></member_present>\r\n" );
						valueXmlString.append( "<remarks><![CDATA[" ).append(checkNull(rs.getString("REMARK"))).append( "]]></remarks>\r\n" );

						valueXmlString.append("<item_form_no><![CDATA[" ).append("retailersampleitem").append( "]]></item_form_no>\r\n" );
						valueXmlString.append("<brand_form_no><![CDATA[" ).append("retailerbrand").append( "]]></brand_form_no>\r\n" );
						valueXmlString.append("<display_form_no><![CDATA[" ).append("retailerdisplay").append( "]]></display_form_no>\r\n" );
						valueXmlString.append("<survey_form_no><![CDATA[" ).append("retailersurvey").append( "]]></survey_form_no>\r\n" );
						valueXmlString.append( "<team_details><![CDATA[" ).append( teamDetails ).append( "]]></team_details>\r\n" );
						valueXmlString.append("<host_url><![CDATA[" ).append(CommonConstants.TOMCAT_HOME).append( "]]></host_url>\r\n" );
						valueXmlString.append( "</retailer"+analysisID+">\r\n" );
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					
					String stockEditSql="SELECT DDV.CUST_CODE AS SC_CODE,CUST.CUST_NAME AS SC_NAME ,DDV.REMARK AS REMARKS,DDV.STOCKIST_VISIT_TIME, " + 
							"DDV.ORDER_BOOKED,'LISTED' AS CUSTOMER_TYPE,DDV.SALES_PERS_MGR,L.DESCR LOC_DESCR, " + 
							"(SELECT EMP_FNAME||' '||EMP_LNAME||'(PSR)' FROM EMPLOYEE WHERE EMP_CODE = DDV.SALES_PERS_MGR) AS VISITED_WITH_PSR_NAME " + 
							"FROM DR_STOCKIST_VISIT DDV ,LOCALITY L,CUSTOMER CUST " + 
							"WHERE DDV.SALES_PERS=? AND DDV.WORK_DATE=? AND L.LOCALITY_CODE=DDV.WORK_LOCALITY_CODE  AND DDV.CUST_CODE=CUST.CUST_CODE";
					pstmt=conn.prepareStatement(stockEditSql);
					pstmt.setString(1, salesPers);
					pstmt.setTimestamp( 2, java.sql.Timestamp.valueOf( eventDateDBFmt ) );
					rs = pstmt.executeQuery();
					
					while (rs.next())
					{
						String psrData=checkNull(rs.getString("VISITED_WITH_PSR_NAME"));
						valueXmlString.append( "<StockData"+analysisID+" domID='"+domID+"' selected = 'Y'>\r\n" );
						valueXmlString.append( "<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\"/>\r\n");
						valueXmlString.append( "<strg_code><![CDATA[" ).append( checkNull(rs.getString("SC_CODE")).trim()).append( "]]></strg_code>\r\n");							
						valueXmlString.append( "<cust_name><![CDATA[" ).append( checkNull(rs.getString("SC_NAME"))).append( "]]></cust_name>\r\n");
						valueXmlString.append( "<sales_pers><![CDATA[" ).append(checkNull(salesPers)).append( "]]></sales_pers>\r\n" );
						valueXmlString.append( "<event_date><![CDATA[" ).append(eventDate).append( "]]></event_date>\r\n" );				
						valueXmlString.append( "<locality_descr><![CDATA[" ).append( checkNull(rs.getString("LOC_DESCR")).trim()).append( "]]></locality_descr>\r\n");
						valueXmlString.append( "<cust_type><![CDATA[" ).append("S").append( "]]></cust_type>\r\n" );				
						valueXmlString.append( "<event_time_start><![CDATA[" ).append(rs.getString("STOCKIST_VISIT_TIME")).append( "]]></event_time_start>\r\n" );
						valueXmlString.append( "<event_time_end><![CDATA[" ).append(rs.getString("STOCKIST_VISIT_TIME")).append( "]]></event_time_end>\r\n" );
						valueXmlString.append( "<pob_val><![CDATA[" ).append(checkNull(rs.getString("ORDER_BOOKED"))).append( "]]></pob_val>\r\n" );
						valueXmlString.append( "<customer_type><![CDATA[" ).append("LISTED").append( "]]></customer_type>\r\n" );
						valueXmlString.append( "<remarks><![CDATA[" ).append(checkNull(rs.getString("REMARKS"))).append( "]]></remarks>\r\n" );
						valueXmlString.append("<item_form_no><![CDATA[" ).append("stockistsampleitem").append( "]]></item_form_no>\r\n" );
						valueXmlString.append("<brand_form_no><![CDATA[" ).append("Stockistbrand").append( "]]></brand_form_no>\r\n" );
						valueXmlString.append("<display_form_no><![CDATA[" ).append("StockistDisplay").append( "]]></display_form_no>\r\n" );
						valueXmlString.append("<survey_form_no><![CDATA[" ).append("stockistsurvey").append( "]]></survey_form_no>\r\n" );
						//valueXmlString.append( "</MerchData>\r\n" );
						if(mgrCode.trim().length()!=0)
						{
							valueXmlString.append( "<team_details><![CDATA[" ).append( psrData ).append( "]]></team_details>\r\n" );

						}
						valueXmlString.append("<host_url><![CDATA[" ).append(CommonConstants.TOMCAT_HOME).append( "]]></host_url>\r\n" );
						valueXmlString.append( "</StockData"+analysisID+">\r\n" );
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
				}
				else
				{
					String UnlistedCode=getUnlistedCustomerList(conn,custDcrId);
					if(mgrCode.trim().length()!= 0)
					{
						if (stockistTable.equalsIgnoreCase("SPRS_STOCKIST"))
						{
							// CHanges by Harion for Doctor not showing in summary when changed locality -- 04-Feb-2021   [Start]
							/*sqlEdit = "SELECT STRG_MEET.*,LOCALITY.DESCR LOC_DESCR,FIELDACTIVITY.ACTIVITY_TYPE ACT_TYPE, SCC.CLASS_CODE_DESCR, UPPER(STRG_CUSTOMER.FIRST_NAME)||' '||UPPER(STRG_CUSTOMER.MIDDLE_NAME)||' '||UPPER(STRG_CUSTOMER.LAST_NAME) AS SC_NAME, "+
									"STRG_MEET.STRG_TYPE AS CUST_TYPE, (CASE WHEN STRG_MEET.STRG_TYPE = 'D' THEN 1  WHEN STRG_MEET.STRG_TYPE='R' THEN 2  WHEN STRG_MEET.STRG_TYPE='M' THEN 3 ELSE 4 END) "+
									"AS CUST_TYPE_SEQ, SCT.DCR_GROUP AS DCR_GROUP, SS.NO_VISIT,SPL.DESCR AS SPL_DSCR,'LISTED' AS CUSTOMER_TYPE  "+
									"FROM SALES_PERS SAP,STRG_CUSTOMER ,STRG_SERIES SS LEFT OUTER JOIN SPECIALITY SPL ON SS.SPL_CODE=SPL.SPL_CODE, FIELDACTIVITY, STRG_MEET LEFT OUTER JOIN LOCALITY ON STRG_MEET.LOCALITY_CODE = LOCALITY.LOCALITY_CODE "+
									"LEFT OUTER JOIN SPRS_ACT_TRAN ON STRG_MEET.DCR_ID = SPRS_ACT_TRAN.DCR_ID LEFT OUTER JOIN STRG_CUST_CLASS SCC ON STRG_MEET.STRG_CLASS_CODE = SCC.CLASS_CODE "+
									"AND SCC.CUST_TYPE = STRG_MEET.STRG_TYPE LEFT OUTER JOIN STRG_CUST_TYPE SCT ON STRG_MEET.STRG_TYPE = SCT.TYPE  "+
									"WHERE STRG_MEET.EVENT_TYPE = FIELDACTIVITY.ACTIVITY_CODE AND STRG_MEET.STRG_CODE = STRG_CUSTOMER.SC_CODE AND SS.SALES_PERS = STRG_MEET.SPRS_CODE__WW "+
									"AND SS.SC_CODE=STRG_MEET.STRG_CODE AND SS.ROUTE_ID = STRG_MEET.ROUTE_ID AND STRG_MEET.SALES_PERS = ? AND STRG_MEET.EVENT_DATE = ? AND SCT.DCR_GROUP IN ('C','D','O') AND SAP.SALES_PERS=SS.SALES_PERS AND SAP.ITEM_SER=SS.ITEM_SER "+
									"UNION "+
									"SELECT STRG_MEET.*,LOCALITY.DESCR LOC_DESCR,FIELDACTIVITY.ACTIVITY_TYPE ACT_TYPE,SCC.CLASS_CODE_DESCR, STRG_MEET.STRG_NAME AS SC_NAME, "+
									"STRG_MEET.STRG_TYPE AS CUST_TYPE, (CASE WHEN STRG_MEET.STRG_TYPE = 'D' THEN 1  WHEN STRG_MEET.STRG_TYPE='R' THEN 2  WHEN STRG_MEET.STRG_TYPE='M' "+
									"THEN 3 ELSE 4 END) AS CUST_TYPE_SEQ, SCT.DCR_GROUP AS DCR_GROUP, 0 AS NO_VISIT,SPL.DESCR AS SPL_DSCR,'UNLISTED' AS CUSTOMER_TYPE  "+
									"FROM FIELDACTIVITY,STRG_MEET "+
									"LEFT OUTER JOIN LOCALITY ON STRG_MEET.LOCALITY_CODE = LOCALITY.LOCALITY_CODE LEFT OUTER JOIN SPRS_ACT_TRAN ON STRG_MEET.DCR_ID = SPRS_ACT_TRAN.DCR_ID "+
									"LEFT OUTER JOIN STRG_CUST_CLASS SCC ON STRG_MEET.STRG_CLASS_CODE = SCC.CLASS_CODE AND SCC.CUST_TYPE = STRG_MEET.STRG_TYPE "+
									"LEFT OUTER JOIN SPECIALITY SPL ON STRG_MEET.SPL_CODE = SPL.SPL_CODE LEFT OUTER JOIN STRG_CUST_TYPE SCT ON STRG_MEET.STRG_TYPE = SCT.TYPE "+
									"WHERE STRG_MEET.EVENT_TYPE = FIELDACTIVITY.ACTIVITY_CODE AND STRG_MEET.EVENT_DATE = ? AND STRG_MEET.SALES_PERS = ? "+
									"AND STRG_MEET.STRG_CODE NOT IN(SELECT SC_CODE FROM STRG_CUSTOMER) AND SCT.DCR_GROUP IN ('C','D','S','O') AND STRG_MEET.STRG_CODE NOT IN (SELECT CUST_CODE FROM CUSTOMER) "+
									"UNION "+
									"SELECT STRG_MEET.*,LOCALITY.DESCR LOC_DESCR, FIELDACTIVITY.ACTIVITY_TYPE ACT_TYPE, SCC.CLASS_CODE_DESCR, UPPER(CUST_NAME) AS SC_NAME, "+
									"STRG_MEET.STRG_TYPE AS CUST_TYPE, (CASE WHEN STRG_MEET.STRG_TYPE = 'D' THEN 1  WHEN STRG_MEET.STRG_TYPE = 'R' THEN 2  WHEN STRG_MEET.STRG_TYPE = 'M' "+
									"THEN 3 ELSE 4 END) AS CUST_TYPE_SEQ, SCT.DCR_GROUP AS DCR_GROUP, 0 AS NO_VISIT, SPL.DESCR AS SPL_DSCR,'LISTED' AS CUSTOMER_TYPE  "+
									"FROM CUSTOMER , SPRS_STOCKIST SS, FIELDACTIVITY, STRG_MEET  LEFT OUTER JOIN LOCALITY ON STRG_MEET.LOCALITY_CODE = LOCALITY.LOCALITY_CODE "+
									"LEFT OUTER JOIN SPRS_ACT_TRAN ON STRG_MEET.DCR_ID = SPRS_ACT_TRAN.DCR_ID LEFT OUTER JOIN STRG_CUST_CLASS SCC ON STRG_MEET.STRG_CLASS_CODE = SCC.CLASS_CODE "+
									"AND SCC.CUST_TYPE = STRG_MEET.STRG_TYPE "+
									"LEFT OUTER JOIN SPECIALITY SPL ON STRG_MEET.SPL_CODE = SPL.SPL_CODE "+
									"LEFT OUTER JOIN STRG_CUST_TYPE SCT ON STRG_MEET.STRG_TYPE = SCT.TYPE  WHERE STRG_MEET.EVENT_TYPE = FIELDACTIVITY.ACTIVITY_CODE "+
									"AND STRG_MEET.STRG_CODE = CUSTOMER.CUST_CODE AND  SS.SPRS_CODE = STRG_MEET.SPRS_CODE__WW AND SS.CUST_CODE = STRG_MEET.STRG_CODE "+
									"AND SS.ROUTE_ID = STRG_MEET.ROUTE_ID AND STRG_MEET.SALES_PERS = ? AND STRG_MEET.EVENT_DATE = ? "+
									"AND SCT.DCR_GROUP IN ('S') ORDER BY CUST_TYPE_SEQ";*/
							
							
							 sqlEdit="SELECT STRG_MEET.STRG_CODE,STRG_MEET.STRG_CLASS_CODE,STRG_MEET.DCR_ID,STRG_MEET.ROUTE_ID,STRG_MEET.SPRS_CODE__WW,STRG_MEET.OTH_PARTICIPANT,STRG_MEET.REG_NO,STRG_MEET.EVENT_TYPE,STRG_MEET.PLAN_CHG_REAS,STRG_MEET.CALL_OUTCOME,STRG_MEET.MEET_SUMM,STRG_MEET.REMARKS,STRG_MEET.EVENT_TIME_START,STRG_MEET.EVENT_TIME_END,STRG_MEET.SKU_VALUE,STRG_MEET.AMOUNT,STRG_MEET.NET_AMT,STRG_MEET.TAX_AMOUNT,STRG_MEET.ADDRESS_AS,STRG_MEET.MEMBER_PRESENT, "+
							 		" LOCALITY.DESCR LOC_DESCR,FIELDACTIVITY.ACTIVITY_TYPE ACT_TYPE, SCC.CLASS_CODE_DESCR, STRG_CUSTOMER.FIRST_NAME||' '||STRG_CUSTOMER.MIDDLE_NAME||' '||STRG_CUSTOMER.LAST_NAME AS SC_NAME, " + 
									" STRG_MEET.STRG_TYPE AS CUST_TYPE, " + 
									" SCT.DCR_GROUP AS DCR_GROUP,SPL.DESCR AS SPL_DSCR,'LISTED' AS CUSTOMER_TYPE,SCT.DESCR  AS CUST_TYPE_DESCR  " + 
									" FROM STRG_CUSTOMER , FIELDACTIVITY, LOCALITY,SPRS_ACT_TRAN,STRG_MEET LEFT OUTER JOIN SPECIALITY SPL ON STRG_MEET.SPL_CODE = SPL.SPL_CODE " + 
									"  LEFT OUTER JOIN STRG_CUST_CLASS SCC ON STRG_MEET.STRG_CLASS_CODE = SCC.CLASS_CODE " + 
									" AND SCC.CUST_TYPE = STRG_MEET.STRG_TYPE LEFT OUTER JOIN STRG_CUST_TYPE SCT ON STRG_MEET.STRG_TYPE = SCT.TYPE  " + 
									" WHERE STRG_MEET.EVENT_TYPE = FIELDACTIVITY.ACTIVITY_CODE AND STRG_MEET.LOCALITY_CODE = LOCALITY.LOCALITY_CODE  AND STRG_MEET.STRG_CODE = STRG_CUSTOMER.SC_CODE " + 
									" AND STRG_MEET.DCR_ID = SPRS_ACT_TRAN.DCR_ID AND STRG_MEET.SALES_PERS = ? AND STRG_MEET.EVENT_DATE = ? AND SCT.DCR_GROUP IN ('C','D','O') " + 
									" UNION " + 
									" SELECT STRG_MEET.STRG_CODE,STRG_MEET.STRG_CLASS_CODE,STRG_MEET.DCR_ID,STRG_MEET.ROUTE_ID,STRG_MEET.SPRS_CODE__WW,STRG_MEET.OTH_PARTICIPANT,STRG_MEET.REG_NO,STRG_MEET.EVENT_TYPE,STRG_MEET.PLAN_CHG_REAS,STRG_MEET.CALL_OUTCOME,STRG_MEET.MEET_SUMM,STRG_MEET.REMARKS,STRG_MEET.EVENT_TIME_START,STRG_MEET.EVENT_TIME_END,STRG_MEET.SKU_VALUE,STRG_MEET.AMOUNT,STRG_MEET.NET_AMT,STRG_MEET.TAX_AMOUNT,STRG_MEET.ADDRESS_AS,STRG_MEET.MEMBER_PRESENT, "+
									" LOCALITY.DESCR LOC_DESCR,FIELDACTIVITY.ACTIVITY_TYPE ACT_TYPE,SCC.CLASS_CODE_DESCR, STRG_MEET.STRG_NAME AS SC_NAME, " + 
									" STRG_MEET.STRG_TYPE AS CUST_TYPE, " + 
									" SCT.DCR_GROUP AS DCR_GROUP, SPL.DESCR AS SPL_DSCR,'UNLISTED' AS CUSTOMER_TYPE,SCT.DESCR  AS CUST_TYPE_DESCR  " + 
									" FROM FIELDACTIVITY,LOCALITY,SPRS_ACT_TRAN,STRG_MEET " + 
									" LEFT OUTER JOIN STRG_CUST_CLASS SCC ON STRG_MEET.STRG_CLASS_CODE = SCC.CLASS_CODE AND SCC.CUST_TYPE = STRG_MEET.STRG_TYPE " + 
									" LEFT OUTER JOIN SPECIALITY SPL ON STRG_MEET.SPL_CODE = SPL.SPL_CODE LEFT OUTER JOIN STRG_CUST_TYPE SCT ON STRG_MEET.STRG_TYPE = SCT.TYPE " + 
									" WHERE STRG_MEET.EVENT_TYPE = FIELDACTIVITY.ACTIVITY_CODE AND STRG_MEET.EVENT_DATE = ? AND STRG_MEET.LOCALITY_CODE = LOCALITY.LOCALITY_CODE "+
									" AND STRG_MEET.DCR_ID = SPRS_ACT_TRAN.DCR_ID AND STRG_MEET.SALES_PERS = ? " + 
									" AND STRG_MEET.STRG_CODE IN("+UnlistedCode+") AND SCT.DCR_GROUP IN ('C','D','S','O')  " + 
									" UNION " + 
									" SELECT STRG_MEET.STRG_CODE,STRG_MEET.STRG_CLASS_CODE,STRG_MEET.DCR_ID,STRG_MEET.ROUTE_ID,STRG_MEET.SPRS_CODE__WW,STRG_MEET.OTH_PARTICIPANT,STRG_MEET.REG_NO,STRG_MEET.EVENT_TYPE,STRG_MEET.PLAN_CHG_REAS,STRG_MEET.CALL_OUTCOME,STRG_MEET.MEET_SUMM,STRG_MEET.REMARKS,STRG_MEET.EVENT_TIME_START,STRG_MEET.EVENT_TIME_END,STRG_MEET.SKU_VALUE,STRG_MEET.AMOUNT,STRG_MEET.NET_AMT,STRG_MEET.TAX_AMOUNT,STRG_MEET.ADDRESS_AS,STRG_MEET.MEMBER_PRESENT, "+
									" LOCALITY.DESCR LOC_DESCR, FIELDACTIVITY.ACTIVITY_TYPE ACT_TYPE, SCC.CLASS_CODE_DESCR, CUST_NAME AS SC_NAME, " + 
									" STRG_MEET.STRG_TYPE AS CUST_TYPE,  " + 
									" SCT.DCR_GROUP AS DCR_GROUP,  SPL.DESCR AS SPL_DSCR,'LISTED' AS CUSTOMER_TYPE,SCT.DESCR  AS CUST_TYPE_DESCR  " + 
									" FROM CUSTOMER ,LOCALITY,SPRS_ACT_TRAN, SPRS_STOCKIST SS, FIELDACTIVITY, STRG_MEET   " + 
									" LEFT OUTER JOIN STRG_CUST_CLASS SCC ON STRG_MEET.STRG_CLASS_CODE = SCC.CLASS_CODE " + 
									" AND SCC.CUST_TYPE = STRG_MEET.STRG_TYPE " + 
									" LEFT OUTER JOIN SPECIALITY SPL ON STRG_MEET.SPL_CODE = SPL.SPL_CODE " + 
									" LEFT OUTER JOIN STRG_CUST_TYPE SCT ON STRG_MEET.STRG_TYPE = SCT.TYPE  WHERE STRG_MEET.EVENT_TYPE = FIELDACTIVITY.ACTIVITY_CODE " + 
									" AND STRG_MEET.STRG_CODE = CUSTOMER.CUST_CODE AND  SS.SPRS_CODE = STRG_MEET.SPRS_CODE__WW AND SS.CUST_CODE = STRG_MEET.STRG_CODE AND STRG_MEET.LOCALITY_CODE = LOCALITY.LOCALITY_CODE " + 
									" AND SS.ROUTE_ID = STRG_MEET.ROUTE_ID AND STRG_MEET.DCR_ID = SPRS_ACT_TRAN.DCR_ID AND  STRG_MEET.SALES_PERS = ? AND STRG_MEET.EVENT_DATE = ? " + 
									" AND SCT.DCR_GROUP IN ('S')";
							// CHanges by Harion for Doctor not showing in summary when changed locality -- 04-Feb-2021   [End]
							
							
							
							pstmt =  conn.prepareStatement( sqlEdit );
							pstmt.setString(5, salesPers);
							pstmt.setTimestamp( 6, java.sql.Timestamp.valueOf( eventDateDBFmt ) );
							
						}
						else
						{
							// CHanges by Harion for Doctor not showing in summary when changed locality -- 04-Feb-2021   [Start]
							/*sqlEdit  ="SELECT STRG_MEET.*,LOCALITY.DESCR LOC_DESCR,FIELDACTIVITY.ACTIVITY_TYPE ACT_TYPE, SCC.CLASS_CODE_DESCR, "+    // Added by kailash 
								 	" UPPER(STRG_CUSTOMER.FIRST_NAME)||' '||UPPER(STRG_CUSTOMER.MIDDLE_NAME)||' '||UPPER(STRG_CUSTOMER.LAST_NAME) AS SC_NAME,"+ 
									" STRG_MEET.STRG_TYPE AS CUST_TYPE, "+ 
									" (CASE WHEN STRG_MEET.STRG_TYPE = 'D' THEN 1  WHEN STRG_MEET.STRG_TYPE='R' THEN 2  WHEN STRG_MEET.STRG_TYPE='M' THEN 3 ELSE 4 END) AS CUST_TYPE_SEQ, "+
									" SCT.DCR_GROUP AS DCR_GROUP,"// added by rupali on 21/12/18 for dcr_group related changes
									+ "SS.NO_VISIT,SPL.DESCR AS SPL_DSCR,'LISTED' AS CUSTOMER_TYPE "+ //Added by mrunalini to showing speciality no_visit on summary page
									" FROM SALES_PERS SAP,STRG_CUSTOMER ,STRG_SERIES SS LEFT OUTER JOIN SPECIALITY SPL ON SS.SPL_CODE=SPL.SPL_CODE,FIELDACTIVITY,STRG_MEET  "+
									" LEFT OUTER JOIN LOCALITY ON STRG_MEET.LOCALITY_CODE = LOCALITY.LOCALITY_CODE " +
									" LEFT OUTER JOIN SPRS_ACT_TRAN ON STRG_MEET.DCR_ID = SPRS_ACT_TRAN.DCR_ID  "+
									" LEFT OUTER JOIN STRG_CUST_CLASS SCC ON STRG_MEET.STRG_CLASS_CODE = SCC.CLASS_CODE"+ //Added by kailash
									" AND SCC.CUST_TYPE = STRG_MEET.STRG_TYPE  LEFT OUTER JOIN STRG_CUST_TYPE SCT ON STRG_MEET.STRG_TYPE = SCT.TYPE "+ // added by rupali on 21/12/18 for dcr_group related changes
									" WHERE STRG_MEET.EVENT_TYPE =FIELDACTIVITY.ACTIVITY_CODE "
									+ " AND STRG_MEET.STRG_CODE = STRG_CUSTOMER.SC_CODE "
									//+ " AND SS.SALES_PERS=STRG_MEET.SALES_PERS AND SS.SC_CODE=STRG_MEET.STRG_CODE AND SS.ROUTE_ID=STRG_MEET.ROUTE_ID "+
									+ " AND SS.SALES_PERS = STRG_MEET.SPRS_CODE__WW AND SS.SC_CODE=STRG_MEET.STRG_CODE AND SS.ROUTE_ID=STRG_MEET.ROUTE_ID "+
									" AND STRG_MEET.SALES_PERS = ? "+
									" AND STRG_MEET.EVENT_DATE = ? "+
									//" AND STRG_CUSTOMER.CUST_TYPE  IN ('C','D','S','O') " + // commentted by rupali on 21/12/18 for dcr_group related changes
									" AND SCT.DCR_GROUP IN ('C','D','S','O')  AND SAP.SALES_PERS=SS.SALES_PERS AND SAP.ITEM_SER=SS.ITEM_SER " + // added by rupali on 21/12/18 for dcr_group related changes
									//" AND (CASE WHEN SPRS_ACT_TRAN.CONFIRMED IS NULL THEN 'N' ELSE SPRS_ACT_TRAN.CONFIRMED END) ='N' "+ commented by mrunalini sinkar for DCR View Lik in claim expense
									//" AND SCC.CUST_TYPE = STRG_MEET.STRG_TYPE"+ //Added by kailash // commentted by rupali on 21/12/18 for dcr_group related changes
									" UNION "+
									" SELECT STRG_MEET.*,LOCALITY.DESCR LOC_DESCR,FIELDACTIVITY.ACTIVITY_TYPE ACT_TYPE,SCC.CLASS_CODE_DESCR, STRG_MEET.STRG_NAME AS SC_NAME, "+ //Added class code descr by kailash
									" STRG_MEET.STRG_TYPE AS CUST_TYPE, "+
									" (CASE WHEN STRG_MEET.STRG_TYPE = 'D' THEN 1  WHEN STRG_MEET.STRG_TYPE='R' THEN 2  WHEN STRG_MEET.STRG_TYPE='M' THEN 3 ELSE 4 END) AS CUST_TYPE_SEQ, "+
									" SCT.DCR_GROUP AS DCR_GROUP, "// added by rupali on 21/12/18 for dcr_group related changes
									+ " 0 AS NO_VISIT,SPL.DESCR AS SPL_DSCR,'UNLISTED' AS CUSTOMER_TYPE "+ //Added by mrunalini to showing speciality no_visit on summary page 
									" FROM FIELDACTIVITY,STRG_MEET "+
									" LEFT OUTER JOIN LOCALITY ON STRG_MEET.LOCALITY_CODE = LOCALITY.LOCALITY_CODE "+
									" LEFT OUTER JOIN SPRS_ACT_TRAN ON STRG_MEET.DCR_ID = SPRS_ACT_TRAN.DCR_ID "+
									" LEFT OUTER JOIN STRG_CUST_CLASS SCC ON STRG_MEET.STRG_CLASS_CODE = SCC.CLASS_CODE"+ //Added by kailash
									" AND SCC.CUST_TYPE = STRG_MEET.STRG_TYPE LEFT OUTER JOIN SPECIALITY SPL ON STRG_MEET.SPL_CODE=SPL.SPL_CODE  LEFT OUTER JOIN STRG_CUST_TYPE SCT ON STRG_MEET.STRG_TYPE = SCT.TYPE "+ // added by rupali on 21/12/18 for dcr_group related changes
									" WHERE STRG_MEET.EVENT_TYPE =FIELDACTIVITY.ACTIVITY_CODE "+
									" AND STRG_MEET.EVENT_DATE = ? "+
									" AND STRG_MEET.SALES_PERS = ? "+
									" AND  STRG_MEET.STRG_CODE NOT IN(SELECT SC_CODE FROM STRG_CUSTOMER) "+
									//" AND STRG_MEET.STRG_TYPE  IN ('C','D','S','O') "+ // commentted by rupali on 21/12/18 for dcr_group related changes
									" AND SCT.DCR_GROUP IN ('C','D','S','O') " + // added by rupali on 21/12/18 for dcr_group related changes
									//" AND SCC.CUST_TYPE = STRG_MEET.STRG_TYPE"+ // Added by kailash // commentted by rupali on 21/12/18 for dcr_group related changes
									" ORDER BY CUST_TYPE_SEQ ";*/
							
							 sqlEdit="SELECT STRG_MEET.STRG_CODE,STRG_MEET.STRG_CLASS_CODE,STRG_MEET.DCR_ID,STRG_MEET.ROUTE_ID,STRG_MEET.SPRS_CODE__WW,STRG_MEET.OTH_PARTICIPANT,STRG_MEET.REG_NO,STRG_MEET.EVENT_TYPE,STRG_MEET.PLAN_CHG_REAS,STRG_MEET.CALL_OUTCOME,STRG_MEET.MEET_SUMM,STRG_MEET.REMARKS,STRG_MEET.EVENT_TIME_START,STRG_MEET.EVENT_TIME_END,STRG_MEET.SKU_VALUE,STRG_MEET.AMOUNT,STRG_MEET.NET_AMT,STRG_MEET.TAX_AMOUNT,STRG_MEET.ADDRESS_AS,STRG_MEET.MEMBER_PRESENT, "+
							 		" LOCALITY.DESCR LOC_DESCR,FIELDACTIVITY.ACTIVITY_TYPE ACT_TYPE, SCC.CLASS_CODE_DESCR, " + 
									" STRG_CUSTOMER.FIRST_NAME||' '||STRG_CUSTOMER.MIDDLE_NAME||' '||STRG_CUSTOMER.LAST_NAME AS SC_NAME," + 
									" STRG_MEET.STRG_TYPE AS CUST_TYPE, " + 
									" SCT.DCR_GROUP AS DCR_GROUP, " + 
									" SPL.DESCR AS SPL_DSCR,'LISTED' AS CUSTOMER_TYPE , STRG_MEET.ROUTE_ID AS ROUTE_ID , STRG_MEET.SPRS_CODE__WW AS SPRS_CODE__WW,SCT.DESCR  AS CUST_TYPE_DESCR " + 
									" FROM LOCALITY,SPRS_ACT_TRAN,STRG_CUSTOMER ,FIELDACTIVITY,STRG_MEET LEFT OUTER JOIN SPECIALITY SPL ON STRG_MEET.SPL_CODE=SPL.SPL_CODE " + 
									" LEFT OUTER JOIN STRG_CUST_CLASS SCC ON STRG_MEET.STRG_CLASS_CODE = SCC.CLASS_CODE " + 
									" AND SCC.CUST_TYPE = STRG_MEET.STRG_TYPE  LEFT OUTER JOIN STRG_CUST_TYPE SCT ON STRG_MEET.STRG_TYPE = SCT.TYPE " + 
									" WHERE STRG_MEET.EVENT_TYPE =FIELDACTIVITY.ACTIVITY_CODE AND STRG_MEET.LOCALITY_CODE = LOCALITY.LOCALITY_CODE " + 
									" AND STRG_MEET.DCR_ID = SPRS_ACT_TRAN.DCR_ID AND STRG_MEET.STRG_CODE = STRG_CUSTOMER.SC_CODE " + 
									" AND STRG_MEET.SALES_PERS = ? " + 
									" AND STRG_MEET.EVENT_DATE = ? " + 
									" AND SCT.DCR_GROUP IN ('C','D','S','O')  " + 
									" UNION " + 
									" SELECT STRG_MEET.STRG_CODE,STRG_MEET.STRG_CLASS_CODE,STRG_MEET.DCR_ID,STRG_MEET.ROUTE_ID,STRG_MEET.SPRS_CODE__WW,STRG_MEET.OTH_PARTICIPANT,STRG_MEET.REG_NO,STRG_MEET.EVENT_TYPE,STRG_MEET.PLAN_CHG_REAS,STRG_MEET.CALL_OUTCOME,STRG_MEET.MEET_SUMM,STRG_MEET.REMARKS,STRG_MEET.EVENT_TIME_START,STRG_MEET.EVENT_TIME_END,STRG_MEET.SKU_VALUE,STRG_MEET.AMOUNT,STRG_MEET.NET_AMT,STRG_MEET.TAX_AMOUNT,STRG_MEET.ADDRESS_AS,STRG_MEET.MEMBER_PRESENT, "+
									" LOCALITY.DESCR LOC_DESCR,FIELDACTIVITY.ACTIVITY_TYPE ACT_TYPE,SCC.CLASS_CODE_DESCR, STRG_MEET.STRG_NAME AS SC_NAME, " + 
									" STRG_MEET.STRG_TYPE AS CUST_TYPE, " + 
									" SCT.DCR_GROUP AS DCR_GROUP, " + 
									" SPL.DESCR AS SPL_DSCR,'UNLISTED' AS CUSTOMER_TYPE , STRG_MEET.ROUTE_ID AS ROUTE_ID, STRG_MEET.SPRS_CODE__WW AS SPRS_CODE__WW,SCT.DESCR  AS CUST_TYPE_DESCR " + 
									" FROM FIELDACTIVITY,LOCALITY,SPRS_ACT_TRAN,STRG_MEET " + 
									" LEFT OUTER JOIN STRG_CUST_CLASS SCC ON STRG_MEET.STRG_CLASS_CODE = SCC.CLASS_CODE " + 
									" AND SCC.CUST_TYPE = STRG_MEET.STRG_TYPE LEFT OUTER JOIN SPECIALITY SPL ON STRG_MEET.SPL_CODE=SPL.SPL_CODE  LEFT OUTER JOIN STRG_CUST_TYPE SCT ON STRG_MEET.STRG_TYPE = SCT.TYPE " + 
									" WHERE STRG_MEET.EVENT_TYPE =FIELDACTIVITY.ACTIVITY_CODE AND STRG_MEET.LOCALITY_CODE = LOCALITY.LOCALITY_CODE " + 
									" AND STRG_MEET.DCR_ID = SPRS_ACT_TRAN.DCR_ID AND STRG_MEET.EVENT_DATE = ? " + 
									" AND STRG_MEET.SALES_PERS = ? " + 
									" AND  STRG_MEET.STRG_CODE IN("+UnlistedCode+") " + 
									" AND SCT.DCR_GROUP IN ('C','D','S','O') " ; 
							
							
							
							pstmt =  conn.prepareStatement( sqlEdit );
						
							}
					}
					else
					{
						if (stockistTable.equalsIgnoreCase("SPRS_STOCKIST"))
						{
							// CHanges by Harion for Doctor not showing in summary when changed locality -- 04-Feb-2021   [Start]
							/*sqlEdit = "SELECT STRG_MEET.*,LOCALITY.DESCR LOC_DESCR,FIELDACTIVITY.ACTIVITY_TYPE ACT_TYPE, SCC.CLASS_CODE_DESCR, UPPER(STRG_CUSTOMER.FIRST_NAME)||' '||UPPER(STRG_CUSTOMER.MIDDLE_NAME)||' '||UPPER(STRG_CUSTOMER.LAST_NAME) AS SC_NAME, "+
									"STRG_MEET.STRG_TYPE AS CUST_TYPE, (CASE WHEN STRG_MEET.STRG_TYPE = 'D' THEN 1  WHEN STRG_MEET.STRG_TYPE='R' THEN 2  WHEN STRG_MEET.STRG_TYPE='M' THEN 3 ELSE 4 END) "+
									"AS CUST_TYPE_SEQ, SCT.DCR_GROUP AS DCR_GROUP, SS.NO_VISIT,SPL.DESCR AS SPL_DSCR,'LISTED' AS CUSTOMER_TYPE  "+
									"FROM SALES_PERS SAP,STRG_CUSTOMER ,STRG_SERIES SS LEFT OUTER JOIN SPECIALITY SPL ON SS.SPL_CODE=SPL.SPL_CODE, FIELDACTIVITY, STRG_MEET LEFT OUTER JOIN LOCALITY ON STRG_MEET.LOCALITY_CODE = LOCALITY.LOCALITY_CODE "+
									"LEFT OUTER JOIN SPRS_ACT_TRAN ON STRG_MEET.DCR_ID = SPRS_ACT_TRAN.DCR_ID LEFT OUTER JOIN STRG_CUST_CLASS SCC ON STRG_MEET.STRG_CLASS_CODE = SCC.CLASS_CODE "+
									"AND SCC.CUST_TYPE = STRG_MEET.STRG_TYPE LEFT OUTER JOIN STRG_CUST_TYPE SCT ON STRG_MEET.STRG_TYPE = SCT.TYPE  "+
									"WHERE STRG_MEET.EVENT_TYPE = FIELDACTIVITY.ACTIVITY_CODE AND STRG_MEET.STRG_CODE = STRG_CUSTOMER.SC_CODE AND SS.SALES_PERS = STRG_MEET.SALES_PERS  "+
									"AND SS.SC_CODE=STRG_MEET.STRG_CODE AND SS.ROUTE_ID = STRG_MEET.ROUTE_ID AND STRG_MEET.SALES_PERS = ? AND STRG_MEET.EVENT_DATE = ? AND SCT.DCR_GROUP IN ('C','D','O')  AND SAP.SALES_PERS=SS.SALES_PERS AND SAP.ITEM_SER=SS.ITEM_SER "+
									"UNION "+
									"SELECT STRG_MEET.*,LOCALITY.DESCR LOC_DESCR,FIELDACTIVITY.ACTIVITY_TYPE ACT_TYPE,SCC.CLASS_CODE_DESCR, STRG_MEET.STRG_NAME AS SC_NAME, "+
									"STRG_MEET.STRG_TYPE AS CUST_TYPE, (CASE WHEN STRG_MEET.STRG_TYPE = 'D' THEN 1  WHEN STRG_MEET.STRG_TYPE='R' THEN 2  WHEN STRG_MEET.STRG_TYPE='M' "+
									"THEN 3 ELSE 4 END) AS CUST_TYPE_SEQ, SCT.DCR_GROUP AS DCR_GROUP, 0 AS NO_VISIT,SPL.DESCR AS SPL_DSCR,'UNLISTED' AS CUSTOMER_TYPE  "+
									"FROM FIELDACTIVITY,STRG_MEET "+
									"LEFT OUTER JOIN LOCALITY ON STRG_MEET.LOCALITY_CODE = LOCALITY.LOCALITY_CODE LEFT OUTER JOIN SPRS_ACT_TRAN ON STRG_MEET.DCR_ID = SPRS_ACT_TRAN.DCR_ID "+
									"LEFT OUTER JOIN STRG_CUST_CLASS SCC ON STRG_MEET.STRG_CLASS_CODE = SCC.CLASS_CODE AND SCC.CUST_TYPE = STRG_MEET.STRG_TYPE "+
									"LEFT OUTER JOIN SPECIALITY SPL ON STRG_MEET.SPL_CODE = SPL.SPL_CODE LEFT OUTER JOIN STRG_CUST_TYPE SCT ON STRG_MEET.STRG_TYPE = SCT.TYPE "+
									"WHERE STRG_MEET.EVENT_TYPE = FIELDACTIVITY.ACTIVITY_CODE AND STRG_MEET.EVENT_DATE = ? AND STRG_MEET.SALES_PERS = ? "+
									"AND STRG_MEET.STRG_CODE NOT IN(SELECT SC_CODE FROM STRG_CUSTOMER) AND SCT.DCR_GROUP IN ('C','D','S','O') AND STRG_MEET.STRG_CODE NOT IN (SELECT CUST_CODE FROM CUSTOMER) "+
									"UNION "+
									"SELECT STRG_MEET.*,LOCALITY.DESCR LOC_DESCR, FIELDACTIVITY.ACTIVITY_TYPE ACT_TYPE, SCC.CLASS_CODE_DESCR, UPPER(CUST_NAME) AS SC_NAME, "+
									"STRG_MEET.STRG_TYPE AS CUST_TYPE, (CASE WHEN STRG_MEET.STRG_TYPE = 'D' THEN 1  WHEN STRG_MEET.STRG_TYPE = 'R' THEN 2  WHEN STRG_MEET.STRG_TYPE = 'M' "+
									"THEN 3 ELSE 4 END) AS CUST_TYPE_SEQ, SCT.DCR_GROUP AS DCR_GROUP, 0 AS NO_VISIT, SPL.DESCR AS SPL_DSCR,'LISTED' AS CUSTOMER_TYPE  "+
									"FROM CUSTOMER , SPRS_STOCKIST SS, FIELDACTIVITY, STRG_MEET  LEFT OUTER JOIN LOCALITY ON STRG_MEET.LOCALITY_CODE = LOCALITY.LOCALITY_CODE "+
									"LEFT OUTER JOIN SPRS_ACT_TRAN ON STRG_MEET.DCR_ID = SPRS_ACT_TRAN.DCR_ID LEFT OUTER JOIN STRG_CUST_CLASS SCC ON STRG_MEET.STRG_CLASS_CODE = SCC.CLASS_CODE "+
									"AND SCC.CUST_TYPE = STRG_MEET.STRG_TYPE "+
									"LEFT OUTER JOIN SPECIALITY SPL ON STRG_MEET.SPL_CODE = SPL.SPL_CODE "+
									"LEFT OUTER JOIN STRG_CUST_TYPE SCT ON STRG_MEET.STRG_TYPE = SCT.TYPE  WHERE STRG_MEET.EVENT_TYPE = FIELDACTIVITY.ACTIVITY_CODE "+
									"AND STRG_MEET.STRG_CODE = CUSTOMER.CUST_CODE AND SS.SPRS_CODE = STRG_MEET.SALES_PERS  AND SS.CUST_CODE = STRG_MEET.STRG_CODE "+
									"AND SS.ROUTE_ID = STRG_MEET.ROUTE_ID AND STRG_MEET.SALES_PERS = ? AND STRG_MEET.EVENT_DATE = ? "+
									"AND SCT.DCR_GROUP IN ('S') ORDER BY CUST_TYPE_SEQ";*/
										
							 sqlEdit="SELECT STRG_MEET.STRG_CODE,STRG_MEET.STRG_CLASS_CODE,STRG_MEET.DCR_ID,STRG_MEET.ROUTE_ID,STRG_MEET.SPRS_CODE__WW,STRG_MEET.OTH_PARTICIPANT,STRG_MEET.REG_NO,STRG_MEET.EVENT_TYPE,STRG_MEET.PLAN_CHG_REAS,STRG_MEET.CALL_OUTCOME,STRG_MEET.MEET_SUMM,STRG_MEET.REMARKS,STRG_MEET.EVENT_TIME_START,STRG_MEET.EVENT_TIME_END,STRG_MEET.SKU_VALUE,STRG_MEET.AMOUNT,STRG_MEET.NET_AMT,STRG_MEET.TAX_AMOUNT,STRG_MEET.ADDRESS_AS,STRG_MEET.MEMBER_PRESENT, " + 
							 		" LOCALITY.DESCR LOC_DESCR,FIELDACTIVITY.ACTIVITY_TYPE ACT_TYPE, SCC.CLASS_CODE_DESCR, STRG_CUSTOMER.FIRST_NAME||' '||STRG_CUSTOMER.MIDDLE_NAME||' '||STRG_CUSTOMER.LAST_NAME AS SC_NAME, " + 
									" STRG_MEET.STRG_TYPE AS CUST_TYPE, " + 
									" SCT.DCR_GROUP AS DCR_GROUP, SPL.DESCR AS SPL_DSCR,'LISTED' AS CUSTOMER_TYPE , STRG_MEET.ROUTE_ID AS ROUTE_ID,SCT.DESCR  AS CUST_TYPE_DESCR " + 
									" FROM LOCALITY,SPRS_ACT_TRAN,STRG_CUSTOMER ,FIELDACTIVITY, STRG_MEET LEFT OUTER JOIN SPECIALITY SPL  ON  STRG_MEET.SPL_CODE = SPL.SPL_CODE " + 
									" LEFT OUTER JOIN STRG_CUST_CLASS SCC ON STRG_MEET.STRG_CLASS_CODE = SCC.CLASS_CODE " + 
									" AND SCC.CUST_TYPE = STRG_MEET.STRG_TYPE LEFT OUTER JOIN STRG_CUST_TYPE SCT ON STRG_MEET.STRG_TYPE = SCT.TYPE  " + 
									" WHERE STRG_MEET.EVENT_TYPE = FIELDACTIVITY.ACTIVITY_CODE  AND STRG_MEET.DCR_ID = SPRS_ACT_TRAN.DCR_ID AND STRG_MEET.STRG_CODE = STRG_CUSTOMER.SC_CODE  AND STRG_MEET.LOCALITY_CODE = LOCALITY.LOCALITY_CODE" + 
									" AND STRG_MEET.SALES_PERS = ? AND STRG_MEET.EVENT_DATE = ? AND SCT.DCR_GROUP IN ('C','D','O') " + 
									" UNION " + 
									" SELECT STRG_MEET.STRG_CODE,STRG_MEET.STRG_CLASS_CODE,STRG_MEET.DCR_ID,STRG_MEET.ROUTE_ID,STRG_MEET.SPRS_CODE__WW,STRG_MEET.OTH_PARTICIPANT,STRG_MEET.REG_NO,STRG_MEET.EVENT_TYPE,STRG_MEET.PLAN_CHG_REAS,STRG_MEET.CALL_OUTCOME,STRG_MEET.MEET_SUMM,STRG_MEET.REMARKS,STRG_MEET.EVENT_TIME_START,STRG_MEET.EVENT_TIME_END,STRG_MEET.SKU_VALUE,STRG_MEET.AMOUNT,STRG_MEET.NET_AMT,STRG_MEET.TAX_AMOUNT,STRG_MEET.ADDRESS_AS,STRG_MEET.MEMBER_PRESENT, " +
									" LOCALITY.DESCR LOC_DESCR,FIELDACTIVITY.ACTIVITY_TYPE ACT_TYPE,SCC.CLASS_CODE_DESCR, STRG_MEET.STRG_NAME AS SC_NAME, " + 
									" STRG_MEET.STRG_TYPE AS CUST_TYPE,SCT.DCR_GROUP AS DCR_GROUP, SPL.DESCR AS SPL_DSCR,'UNLISTED' AS CUSTOMER_TYPE , STRG_MEET.ROUTE_ID AS ROUTE_ID,SCT.DESCR  AS CUST_TYPE_DESCR " + 
									" FROM FIELDACTIVITY,LOCALITY,SPRS_ACT_TRAN,STRG_MEET " + 
									" LEFT OUTER JOIN STRG_CUST_CLASS SCC ON STRG_MEET.STRG_CLASS_CODE = SCC.CLASS_CODE AND SCC.CUST_TYPE = STRG_MEET.STRG_TYPE " + 
									" LEFT OUTER JOIN SPECIALITY SPL ON STRG_MEET.SPL_CODE = SPL.SPL_CODE LEFT OUTER JOIN STRG_CUST_TYPE SCT ON STRG_MEET.STRG_TYPE = SCT.TYPE " + 
									" WHERE STRG_MEET.EVENT_TYPE = FIELDACTIVITY.ACTIVITY_CODE AND STRG_MEET.DCR_ID = SPRS_ACT_TRAN.DCR_ID  AND STRG_MEET.LOCALITY_CODE = LOCALITY.LOCALITY_CODE AND STRG_MEET.EVENT_DATE = ? AND STRG_MEET.SALES_PERS = ? " + 
									" AND  STRG_MEET.STRG_CODE IN("+UnlistedCode+") " + 
									" AND SCT.DCR_GROUP IN ('C','D','S','O') " + 
									" UNION " + 
									" SELECT STRG_MEET.STRG_CODE,STRG_MEET.STRG_CLASS_CODE,STRG_MEET.DCR_ID,STRG_MEET.ROUTE_ID,STRG_MEET.SPRS_CODE__WW,STRG_MEET.OTH_PARTICIPANT,STRG_MEET.REG_NO,STRG_MEET.EVENT_TYPE,STRG_MEET.PLAN_CHG_REAS,STRG_MEET.CALL_OUTCOME,STRG_MEET.MEET_SUMM,STRG_MEET.REMARKS,STRG_MEET.EVENT_TIME_START,STRG_MEET.EVENT_TIME_END,STRG_MEET.SKU_VALUE,STRG_MEET.AMOUNT,STRG_MEET.NET_AMT,STRG_MEET.TAX_AMOUNT,STRG_MEET.ADDRESS_AS,STRG_MEET.MEMBER_PRESENT, " +
									" LOCALITY.DESCR LOC_DESCR, FIELDACTIVITY.ACTIVITY_TYPE ACT_TYPE, SCC.CLASS_CODE_DESCR, CUST_NAME AS SC_NAME, " + 
									" STRG_MEET.STRG_TYPE AS CUST_TYPE,SCT.DCR_GROUP AS DCR_GROUP,  SPL.DESCR AS SPL_DSCR,'LISTED' AS CUSTOMER_TYPE , STRG_MEET.ROUTE_ID AS ROUTE_ID,SCT.DESCR  AS CUST_TYPE_DESCR " + 
									" FROM CUSTOMER , LOCALITY,SPRS_ACT_TRAN,SPRS_STOCKIST SS, FIELDACTIVITY, STRG_MEET LEFT OUTER JOIN STRG_CUST_CLASS SCC ON STRG_MEET.STRG_CLASS_CODE = SCC.CLASS_CODE " + 
									" AND SCC.CUST_TYPE = STRG_MEET.STRG_TYPE " + 
									" LEFT OUTER JOIN SPECIALITY SPL ON STRG_MEET.SPL_CODE = SPL.SPL_CODE " + 
									" LEFT OUTER JOIN STRG_CUST_TYPE SCT ON STRG_MEET.STRG_TYPE = SCT.TYPE  WHERE STRG_MEET.EVENT_TYPE = FIELDACTIVITY.ACTIVITY_CODE " + 
									" AND STRG_MEET.STRG_CODE = CUSTOMER.CUST_CODE AND SS.SPRS_CODE = STRG_MEET.SALES_PERS  AND SS.CUST_CODE = STRG_MEET.STRG_CODE " + 
									" AND SS.ROUTE_ID = STRG_MEET.ROUTE_ID AND STRG_MEET.DCR_ID = SPRS_ACT_TRAN.DCR_ID  AND STRG_MEET.LOCALITY_CODE = LOCALITY.LOCALITY_CODE AND STRG_MEET.SALES_PERS = ? AND STRG_MEET.EVENT_DATE = ? " + 
									" AND SCT.DCR_GROUP IN ('S')";
																				
							pstmt =  conn.prepareStatement( sqlEdit );
							pstmt.setString(5, salesPers);
							pstmt.setTimestamp( 6, java.sql.Timestamp.valueOf( eventDateDBFmt ) );
									
							
						}
						else
						{
							// CHanges by Harion for Doctor not showing in summary when changed locality -- 04-Feb-2021   [Start]
							/*sqlEdit  ="SELECT STRG_MEET.*,LOCALITY.DESCR LOC_DESCR,FIELDACTIVITY.ACTIVITY_TYPE ACT_TYPE, SCC.CLASS_CODE_DESCR, "+    // Added by kailash 
								 	" UPPER(STRG_CUSTOMER.FIRST_NAME)||' '||UPPER(STRG_CUSTOMER.MIDDLE_NAME)||' '||UPPER(STRG_CUSTOMER.LAST_NAME) AS SC_NAME,"+ 
									" STRG_MEET.STRG_TYPE AS CUST_TYPE, "+ 
									" (CASE WHEN STRG_MEET.STRG_TYPE = 'D' THEN 1  WHEN STRG_MEET.STRG_TYPE='R' THEN 2  WHEN STRG_MEET.STRG_TYPE='M' THEN 3 ELSE 4 END) AS CUST_TYPE_SEQ, "+
									" SCT.DCR_GROUP AS DCR_GROUP,"// added by rupali on 21/12/18 for dcr_group related changes
									+ "SS.NO_VISIT,SPL.DESCR AS SPL_DSCR,'LISTED' AS CUSTOMER_TYPE "+ //Added by mrunalini to showing speciality no_visit on summary page
									" FROM SALES_PERS SAP,STRG_CUSTOMER ,STRG_SERIES SS LEFT OUTER JOIN SPECIALITY SPL ON SS.SPL_CODE=SPL.SPL_CODE,FIELDACTIVITY,STRG_MEET  "+
									" LEFT OUTER JOIN LOCALITY ON STRG_MEET.LOCALITY_CODE = LOCALITY.LOCALITY_CODE " +
									" LEFT OUTER JOIN SPRS_ACT_TRAN ON STRG_MEET.DCR_ID = SPRS_ACT_TRAN.DCR_ID  "+
									" LEFT OUTER JOIN STRG_CUST_CLASS SCC ON STRG_MEET.STRG_CLASS_CODE = SCC.CLASS_CODE"+ //Added by kailash
									" AND SCC.CUST_TYPE = STRG_MEET.STRG_TYPE  LEFT OUTER JOIN STRG_CUST_TYPE SCT ON STRG_MEET.STRG_TYPE = SCT.TYPE "+ // added by rupali on 21/12/18 for dcr_group related changes
									" WHERE STRG_MEET.EVENT_TYPE =FIELDACTIVITY.ACTIVITY_CODE "
									+ " AND STRG_MEET.STRG_CODE = STRG_CUSTOMER.SC_CODE "
									//+ " AND SS.SALES_PERS=STRG_MEET.SALES_PERS AND SS.SC_CODE=STRG_MEET.STRG_CODE AND SS.ROUTE_ID=STRG_MEET.ROUTE_ID "+
									+ " AND (SS.SALES_PERS = STRG_MEET.SALES_PERS OR SS.SALES_PERS = STRG_MEET.SPRS_CODE__WW) AND SS.SC_CODE=STRG_MEET.STRG_CODE AND SS.ROUTE_ID=STRG_MEET.ROUTE_ID "+
									" AND STRG_MEET.SALES_PERS = ? "+
									" AND STRG_MEET.EVENT_DATE = ? "+
									//" AND STRG_CUSTOMER.CUST_TYPE  IN ('C','D','S','O') " + // commentted by rupali on 21/12/18 for dcr_group related changes
									" AND SCT.DCR_GROUP IN ('C','D','S','O')  AND SAP.SALES_PERS=SS.SALES_PERS AND SAP.ITEM_SER=SS.ITEM_SER " + // added by rupali on 21/12/18 for dcr_group related changes
									//" AND (CASE WHEN SPRS_ACT_TRAN.CONFIRMED IS NULL THEN 'N' ELSE SPRS_ACT_TRAN.CONFIRMED END) ='N' "+ commented by mrunalini sinkar for DCR View Lik in claim expense
									//" AND SCC.CUST_TYPE = STRG_MEET.STRG_TYPE"+ //Added by kailash // commentted by rupali on 21/12/18 for dcr_group related changes
									" UNION "+
									" SELECT STRG_MEET.*,LOCALITY.DESCR LOC_DESCR,FIELDACTIVITY.ACTIVITY_TYPE ACT_TYPE,SCC.CLASS_CODE_DESCR, STRG_MEET.STRG_NAME AS SC_NAME, "+ //Added class code descr by kailash
									" STRG_MEET.STRG_TYPE AS CUST_TYPE, "+
									" (CASE WHEN STRG_MEET.STRG_TYPE = 'D' THEN 1  WHEN STRG_MEET.STRG_TYPE='R' THEN 2  WHEN STRG_MEET.STRG_TYPE='M' THEN 3 ELSE 4 END) AS CUST_TYPE_SEQ, "+
									" SCT.DCR_GROUP AS DCR_GROUP, "// added by rupali on 21/12/18 for dcr_group related changes
									+ " 0 AS NO_VISIT,SPL.DESCR AS SPL_DSCR,'UNLISTED' AS CUSTOMER_TYPE "+ //Added by mrunalini to showing speciality no_visit on summary page 
									" FROM FIELDACTIVITY,STRG_MEET "+
									" LEFT OUTER JOIN LOCALITY ON STRG_MEET.LOCALITY_CODE = LOCALITY.LOCALITY_CODE "+
									" LEFT OUTER JOIN SPRS_ACT_TRAN ON STRG_MEET.DCR_ID = SPRS_ACT_TRAN.DCR_ID "+
									" LEFT OUTER JOIN STRG_CUST_CLASS SCC ON STRG_MEET.STRG_CLASS_CODE = SCC.CLASS_CODE"+ //Added by kailash
									" AND SCC.CUST_TYPE = STRG_MEET.STRG_TYPE LEFT OUTER JOIN SPECIALITY SPL ON STRG_MEET.SPL_CODE=SPL.SPL_CODE  LEFT OUTER JOIN STRG_CUST_TYPE SCT ON STRG_MEET.STRG_TYPE = SCT.TYPE "+ // added by rupali on 21/12/18 for dcr_group related changes
									" WHERE STRG_MEET.EVENT_TYPE =FIELDACTIVITY.ACTIVITY_CODE "+
									" AND STRG_MEET.EVENT_DATE = ? "+
									" AND STRG_MEET.SALES_PERS = ? "+
									" AND  STRG_MEET.STRG_CODE NOT IN(SELECT SC_CODE FROM STRG_CUSTOMER) "+
									//" AND STRG_MEET.STRG_TYPE  IN ('C','D','S','O') "+ // commentted by rupali on 21/12/18 for dcr_group related changes
									" AND SCT.DCR_GROUP IN ('C','D','S','O') " + // added by rupali on 21/12/18 for dcr_group related changes
									//" AND SCC.CUST_TYPE = STRG_MEET.STRG_TYPE"+ // Added by kailash // commentted by rupali on 21/12/18 for dcr_group related changes
									" ORDER BY CUST_TYPE_SEQ ";*/
						
							
							 sqlEdit="SELECT STRG_MEET.STRG_CODE,STRG_MEET.STRG_CLASS_CODE,STRG_MEET.DCR_ID,STRG_MEET.ROUTE_ID,STRG_MEET.SPRS_CODE__WW,STRG_MEET.OTH_PARTICIPANT,STRG_MEET.REG_NO,STRG_MEET.EVENT_TYPE,STRG_MEET.PLAN_CHG_REAS,STRG_MEET.CALL_OUTCOME,STRG_MEET.MEET_SUMM,STRG_MEET.REMARKS,STRG_MEET.EVENT_TIME_START,STRG_MEET.EVENT_TIME_END,STRG_MEET.SKU_VALUE,STRG_MEET.AMOUNT,STRG_MEET.NET_AMT,STRG_MEET.TAX_AMOUNT,STRG_MEET.ADDRESS_AS,STRG_MEET.MEMBER_PRESENT, "+
							 		" LOCALITY.DESCR LOC_DESCR,FIELDACTIVITY.ACTIVITY_TYPE ACT_TYPE, SCC.CLASS_CODE_DESCR, " + 
									" STRG_CUSTOMER.FIRST_NAME||' '||STRG_CUSTOMER.LAST_NAME AS SC_NAME, " + 
									" STRG_MEET.STRG_TYPE AS CUST_TYPE,  " + 
									" SCT.DCR_GROUP AS DCR_GROUP, " + 
									" SPL.DESCR AS SPL_DSCR, " + 
									" 'LISTED' AS CUSTOMER_TYPE , STRG_MEET.ROUTE_ID AS ROUTE_ID,SCT.DESCR  AS CUST_TYPE_DESCR " + 
									" FROM STRG_CUSTOMER ,LOCALITY,SPRS_ACT_TRAN,FIELDACTIVITY, " + 
									" STRG_MEET LEFT OUTER JOIN SPECIALITY SPL  ON STRG_MEET.SPL_CODE=SPL.SPL_CODE " + 
									" LEFT OUTER JOIN STRG_CUST_CLASS SCC ON STRG_MEET.STRG_CLASS_CODE = SCC.CLASS_CODE " + 
									" AND SCC.CUST_TYPE = STRG_MEET.STRG_TYPE  LEFT OUTER JOIN STRG_CUST_TYPE SCT ON STRG_MEET.STRG_TYPE = SCT.TYPE " + 
									" WHERE STRG_MEET.EVENT_TYPE =FIELDACTIVITY.ACTIVITY_CODE " + 
									" AND STRG_MEET.STRG_CODE = STRG_CUSTOMER.SC_CODE "+
									" AND STRG_MEET.LOCALITY_CODE = LOCALITY.LOCALITY_CODE " +
									" AND STRG_MEET.DCR_ID = SPRS_ACT_TRAN.DCR_ID "+
									" AND STRG_MEET.SALES_PERS = ? " + 
									" AND STRG_MEET.EVENT_DATE = ? " + 
									" AND SCT.DCR_GROUP IN ('C','D','S','O')  " + 
									" UNION " + 
									" SELECT STRG_MEET.STRG_CODE,STRG_MEET.STRG_CLASS_CODE,STRG_MEET.DCR_ID,STRG_MEET.ROUTE_ID,STRG_MEET.SPRS_CODE__WW,STRG_MEET.OTH_PARTICIPANT,STRG_MEET.REG_NO,STRG_MEET.EVENT_TYPE,STRG_MEET.PLAN_CHG_REAS,STRG_MEET.CALL_OUTCOME,STRG_MEET.MEET_SUMM,STRG_MEET.REMARKS,STRG_MEET.EVENT_TIME_START,STRG_MEET.EVENT_TIME_END,STRG_MEET.SKU_VALUE,STRG_MEET.AMOUNT,STRG_MEET.NET_AMT,STRG_MEET.TAX_AMOUNT,STRG_MEET.ADDRESS_AS,STRG_MEET.MEMBER_PRESENT, "+
									" LOCALITY.DESCR LOC_DESCR,FIELDACTIVITY.ACTIVITY_TYPE ACT_TYPE,SCC.CLASS_CODE_DESCR, STRG_MEET.STRG_NAME AS SC_NAME, " + 
									" STRG_MEET.STRG_TYPE AS CUST_TYPE, " + 
									" SCT.DCR_GROUP AS DCR_GROUP, " + 
									" SPL.DESCR AS SPL_DSCR,'UNLISTED' AS CUSTOMER_TYPE , STRG_MEET.ROUTE_ID AS ROUTE_ID,SCT.DESCR  AS CUST_TYPE_DESCR " + 
									" FROM FIELDACTIVITY,LOCALITY,SPRS_ACT_TRAN,STRG_MEET " + 
									" LEFT OUTER JOIN STRG_CUST_CLASS SCC ON STRG_MEET.STRG_CLASS_CODE = SCC.CLASS_CODE " + 
									" AND SCC.CUST_TYPE = STRG_MEET.STRG_TYPE LEFT OUTER JOIN SPECIALITY SPL ON STRG_MEET.SPL_CODE=SPL.SPL_CODE " + 
									" LEFT OUTER JOIN STRG_CUST_TYPE SCT ON STRG_MEET.STRG_TYPE = SCT.TYPE " + 
									" WHERE STRG_MEET.EVENT_TYPE =FIELDACTIVITY.ACTIVITY_CODE " + 
									" AND STRG_MEET.LOCALITY_CODE = LOCALITY.LOCALITY_CODE " +
									" AND STRG_MEET.DCR_ID = SPRS_ACT_TRAN.DCR_ID "+
									" AND STRG_MEET.EVENT_DATE = ? " + 
									" AND STRG_MEET.SALES_PERS = ? " + 
									" AND  STRG_MEET.STRG_CODE IN("+UnlistedCode+") " + 
									" AND SCT.DCR_GROUP IN ('C','D','S','O')  " ;
					
							
							pstmt =  conn.prepareStatement( sqlEdit );
							
						}
					}
					
		
					
					String custWiseTeamSql = "SELECT EMP.EMP_CODE,UPPER(EMP.EMP_FNAME)||' '||UPPER(EMP.EMP_MNAME)||' '||UPPER(EMP.EMP_LNAME)||'('||TRIM(SMT.DESIGN_CODE)||')' AS EMP_NAME, " +
							" (CASE WHEN g.level_no NOT IN('4','3','2','1') THEN 'NSM' ELSE '' END) AS DESIGN_ID " + 
							" FROM STRG_MEET_TEAM SMT, STRG_MEET, EMPLOYEE EMP,GRADE G " +
							" WHERE STRG_MEET.STRG_CODE=SMT.STRG_CODE AND EMP.GRADE=G.GRADE_CODE " +
							" AND SMT.SALES_PERS = EMP.EMP_CODE " +
							" AND SMT.DCR_ID = ? "+ 
							" AND STRG_MEET.EVENT_DATE= ? "+
							" AND STRG_MEET.SALES_PERS = ? "+
							" AND STRG_MEET.STRG_CODE = ?";

					PreparedStatement pstmtTeam = conn.prepareStatement(custWiseTeamSql);
					//Added by Pooja S. on [30-DEC-2019] to show the coaching details  Start
					String custWiseCoachingSql = "SELECT LISTAGG( (SCM.DESCR || ' - ' || ( CASE WHEN SC.RESULT = 'Y' THEN 'Yes' WHEN SC.RESULT = 'N' THEN 'No' ELSE 'NA' END ) ), ', ' ) WITHIN GROUP (ORDER BY SC.RESULT DESC) COACHING_DET"
							+ " FROM SPRS_COACHING SC, STRG_MEET SM, SURVEY_MASTER SCM "
							+ "WHERE SM.STRG_CODE = SC.STRG_CODE AND SC.DCR_ID= SM.DCR_ID AND SC.SURVEY_CODE = SCM.SURVEY_CODE "
							+ "AND SC.DCR_ID = ? "
							+ "AND SM.EVENT_DATE= ?"
							+ "AND SM.SALES_PERS = ?"
							+ "AND SC.STRG_CODE = ?"
							+ "AND SCM.RESULT_TYPE <> 'A'ORDER BY SC.DCR_ID, SC.LINE_NO";

					PreparedStatement pstmtCoaching = conn.prepareStatement(custWiseCoachingSql);
					//Added by Pooja S. on [30-DEC-2019] to show the coaching details  End
					
					//pstmt =  conn.prepareStatement( sqlEdit );
					pstmt.setString(1, salesPers);
					pstmt.setTimestamp( 2, java.sql.Timestamp.valueOf( eventDateDBFmt ) );
					pstmt.setTimestamp( 3, java.sql.Timestamp.valueOf( eventDateDBFmt ) );
					pstmt.setString(4, salesPers);
					
					rs = pstmt.executeQuery();					
					ResultSet rsNoVis = null ;
					while(rs.next())
					{
							String genDescr = "";

						String SPRS_CODE__WW="";
						String othParticipant="";
						String regNo="";
						leaveFlg= true;
						int noOfVis = 0;
						String actypeDB = checkNull(rs.getString("ACT_TYPE"));						
						String strgCode = checkNull(rs.getString("STRG_CODE"));
						String customerType = checkNull(rs.getString("CUSTOMER_TYPE"));
						String classCode=checkNull(rs.getString("STRG_CLASS_CODE"));
						String strgName=checkNull(rs.getString("SC_NAME")).toUpperCase();
						dcrId = checkNull(rs.getString("DCR_ID"));
						String custType = rs.getString("CUST_TYPE") == null ?"":rs.getString("CUST_TYPE");
						actTypeNew = actypeDB;
						String dcrGroup = checkNull(rs.getString("DCR_GROUP")); // added by rupali on 21/12/18 for dcr_group related changes
						String classCodeDescr=checkNull(rs.getString("CLASS_CODE_DESCR"));
						// CHanges by Harion for Doctor not showing in summary when changed locality -- 04-Feb-2021   [Start]
						String workRouteId=checkNull(rs.getString("ROUTE_ID"));
						SPRS_CODE__WW=checkNull(rs.getString("SPRS_CODE__WW"));
						othParticipant=checkNull(rs.getString("OTH_PARTICIPANT"));
						regNo=checkNull(rs.getString("REG_NO"));
						String custTypeDescr=checkNull(rs.getString("CUST_TYPE_DESCR"));
						String eventType=checkNull(rs.getString("EVENT_TYPE"));
				        String eventTypeDescr = checkNull(getActivityDescr(eventType, conn));

						//System.out.println("strgCode ===="+strgCode);
						//System.out.println("SPRS_CODE__WW ===="+SPRS_CODE__WW);
		                    String genFldValue = this.checkNull(rs.getString("PLAN_CHG_REAS"));
		                    if (genFldValue != null && genFldValue.trim().length() > 0) {
		                        genDescr = checkNull(getDescrFromGenCodes("W_STRG_MEET_DCR_REALTIME_WIZ", "BEAT_CHG_REASON", genFldValue, conn));
		                    }

						String noVisSql="SELECT no_visit FROM STRG_SERIES WHERE SALES_PERS= ? AND SC_CODE= ? AND ROUTE_ID= ?";
						pstmtNoOfVis = conn.prepareStatement(noVisSql);		

						if(SPRS_CODE__WW != null && SPRS_CODE__WW.trim().length() != 0)
						{
							pstmtNoOfVis.setString(1,SPRS_CODE__WW);
						}
						else
						{
							pstmtNoOfVis.setString(1,salesPers);
						}	
						pstmtNoOfVis.setString(2,strgCode);

						pstmtNoOfVis.setString(3,workRouteId);
						rsNoVis = pstmtNoOfVis.executeQuery();
						if (rsNoVis.next())
						{
							noOfVis = rsNoVis.getInt("NO_VISIT");
						}
						if ( rsNoVis != null )
						{
							rsNoVis.close();
							rsNoVis = null;
						}
						if ( pstmtNoOfVis != null )
						{
							pstmtNoOfVis.close();
							pstmtNoOfVis = null;
						}
						// CHanges by Harion for Doctor not showing in summary when changed locality -- 04-Feb-2021   [End]
						if(classCodeDescr==null || classCodeDescr.trim().length()==0)
						{
							classCodeDescr = getClassCodeDesc(classCode,custType,salesPers,conn);

						}
						System.out.println("noOfVis ===="+noOfVis);
						String teamDetails = "";
						pstmtTeam.setString(1, dcrId);
						pstmtTeam.setTimestamp( 2, java.sql.Timestamp.valueOf( eventDateDBFmt ) );
						pstmtTeam.setString(3, salesPers);
						pstmtTeam.setString(4, strgCode);
						ResultSet rsTeam = pstmtTeam.executeQuery();
						while(rsTeam.next())
						{
							String teamData = checkNull(rsTeam.getString("EMP_NAME"));
							String designId = checkNull(rsTeam.getString("DESIGN_ID"));
							String empCode = checkNull(rsTeam.getString("EMP_CODE"));

							if("NSM".equalsIgnoreCase(designId) && !employeeDesignationMap.isEmpty())
							{
								if(employeeDesignationMap.containsKey(empCode))
								{
									String designation=employeeDesignationMap.get(empCode);

									teamData=teamData.substring(0, teamData.lastIndexOf("("));
									System.out.println("teamData before add designation : - "+teamData);
									teamData=teamData +"("+designation+")";

								}
								else
								{
									teamData = checkNull(rsTeam.getString("EMP_NAME"));
								}
							}
							else
							{
								teamData = checkNull(rsTeam.getString("EMP_NAME"));			
								
							}						
							System.out.println("teamData after add designation :["+teamData+"]");
							if (teamDetails.trim().length() == 0)
							{
								teamDetails = teamData;
							}
							else
							{
								teamDetails = teamDetails +","+ teamData;
							}
						}
						pstmtTeam.clearParameters();
						if(rsTeam != null )
						{
							rsTeam.close();
							rsTeam = null;
						}
						//Added by Pooja S. on [30-DEC-2019] to show the coaching details  Start
						String coachingDetails = "";
						pstmtCoaching.setString(1, dcrId);
						pstmtCoaching.setTimestamp( 2, java.sql.Timestamp.valueOf( eventDateDBFmt ) );
						pstmtCoaching.setString(3, salesPers);
						pstmtCoaching.setString(4, strgCode);
						ResultSet rsCoaching = pstmtCoaching.executeQuery();
						while(rsCoaching.next())
						{
							String coachingData = checkNull(rsCoaching.getString("COACHING_DET"));
							if (coachingDetails.trim().length() == 0)
							{
								coachingDetails = coachingData;
							}
							else
							{
								coachingDetails = coachingDetails +","+ coachingData;
							}
						}

						pstmtCoaching.clearParameters();
						if(rsCoaching != null )
						{
							rsCoaching.close();
							rsCoaching = null;
						}
						System.out.println("coachingDetails :::: "+coachingDetails);
						//Added by Pooja S. on [30-DEC-2019] to show the coaching details  End
						// modified by rupali on 21/12/18 for dcr_group related changes
						//if("D".equalsIgnoreCase(custType) && !"PR".equalsIgnoreCase(actypeDB))
						if("D".equalsIgnoreCase(dcrGroup) && !"PR".equalsIgnoreCase(actypeDB))
						{
							valueXmlString.append( "<doctor"+analysisID+" domID='"+domID+"' selected = 'Y'>\r\n" );
							valueXmlString.append( "<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\"/>\r\n");
							valueXmlString.append( "<strg_code><![CDATA[" ).append( checkNull(rs.getString("STRG_CODE")).trim()).append( "]]></strg_code>\r\n");							
							if(strgName!=null && strgName.trim().length()>0)
							{
								valueXmlString.append( "<cust_name><![CDATA[" ).append( checkNull(rs.getString("SC_NAME"))).append( "]]></cust_name>\r\n");
							}
							else
							{
								valueXmlString.append( "<cust_name><![CDATA[" ).append("Unlisted Doctor Met").append( "]]></cust_name>\r\n");
								customerType="UNLISTED-DOCTOR";
							}
							valueXmlString.append( "<sales_pers><![CDATA[" ).append(checkNull(salesPers)).append( "]]></sales_pers>\r\n" );
							valueXmlString.append( "<event_date><![CDATA[" ).append(eventDate).append( "]]></event_date>\r\n" );				
							valueXmlString.append("<cust_type><![CDATA["+custType+"]]></cust_type>\r\n");														
							String callOutCome = checkNull(rs.getString("CALL_OUTCOME"));
							valueXmlString.append( "<call_outcome><![CDATA[" ).append(checkNull(callOutCome)).append( "]]></call_outcome>\r\n" );
							//Added By Mrunalini Sinkar For Fortune Server 20-May-2020(Start)
							if("Y".equalsIgnoreCase(isFortuneAct))
							{
								String meetingStatus="";
								String mettingSql="SELECT CALL_OUTCOME_DESCR FROM CALL_OUTCOME WHERE CALL_OUTCOME = ? AND ACTIVITY_CODE=? ";
								PreparedStatement meetPstmt =conn.prepareStatement(mettingSql);
								meetPstmt.setString(1, callOutCome);
								meetPstmt.setString(2, eventType);
								ResultSet meetRs=meetPstmt.executeQuery();
								if(meetRs.next())
								{
									meetingStatus=checkNull(meetRs.getString("CALL_OUTCOME_DESCR"));
								}
								if (meetRs!= null)
								{
									meetRs.close();
									meetRs = null;
								}
								if(meetPstmt!=null)
								{
									meetPstmt.close();
									meetPstmt = null;
								}
								valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append(meetingStatus).append( "]]></calloutcome_descr>\r\n" );

							}
							else
							{
								if(callOutCome.equalsIgnoreCase("4"))
								{
									valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Very Positive").append( "]]></calloutcome_descr>\r\n" );
								}
								else if(callOutCome.equalsIgnoreCase("3"))
								{
									valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Average").append( "]]></calloutcome_descr>\r\n" );
								}
								else if(callOutCome.equalsIgnoreCase("2"))
								{
									valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Below Average").append( "]]></calloutcome_descr>\r\n" );
								}
								else if(callOutCome.equalsIgnoreCase("1"))
								{
									valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Negative").append( "]]></calloutcome_descr>\r\n" );
								}
								else if(callOutCome.equalsIgnoreCase("0"))
								{
									valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Refused").append( "]]></calloutcome_descr>\r\n" );
								}
								else if(callOutCome.equalsIgnoreCase("5"))
								{
									valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Supporter").append( "]]></calloutcome_descr>\r\n" );
								}
								else if(callOutCome.equalsIgnoreCase("6"))
								{
									valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Believer").append( "]]></calloutcome_descr>\r\n" );
								}
								else if(callOutCome.equalsIgnoreCase("7"))
								{
									valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Non Believer").append( "]]></calloutcome_descr>\r\n" );
								}
								// added by rupali on 03/05/18 for display call outcame data in confirm and delete report [start]
								else if(callOutCome.equalsIgnoreCase("8"))
								{
									valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Obj. Not Met").append( "]]></calloutcome_descr>\r\n" );
								}
								else if(callOutCome.equalsIgnoreCase("9"))
								{
									valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Obj. Met").append( "]]></calloutcome_descr>\r\n" );
								}

							}
							//Added By Mrunalini Sinkar For Fortune Server 20-May-2020(End)

							// added by rupali on 03/05/18 for display call outcame data in confirm and delete report [end]
							//Added by kailsh on 23-feb-18 [Start] 
							valueXmlString.append( "<meet_summ><![CDATA[" ).append(rs.getString("MEET_SUMM")).append( "]]></meet_summ>\r\n" );
							valueXmlString.append( "<remarks><![CDATA[" ).append(checkNull(rs.getString("REMARKS"))).append( "]]></remarks>\r\n" );

							valueXmlString.append( "<strg_class_code><![CDATA[" ).append(checkNull(rs.getString("STRG_CLASS_CODE"))).append( "]]></strg_class_code>\r\n" );
							//Added by kailsh on 23-feb-18 [End]
							//Added by mrunalini to showing speciality no_visit on summary page(start)
							valueXmlString.append( "<event_time_start><![CDATA[" ).append(checkNull(rs.getString("EVENT_TIME_START"))).append( "]]></event_time_start>\r\n" );
							valueXmlString.append( "<event_time_end><![CDATA[" ).append(checkNull(rs.getString("EVENT_TIME_END"))).append( "]]></event_time_end>\r\n" );
							valueXmlString.append( "<pob_val><![CDATA[" ).append(checkNull(rs.getString("SKU_VALUE"))).append( "]]></pob_val>\r\n" );
							valueXmlString.append( "<customer_type><![CDATA[" ).append(customerType).append( "]]></customer_type>\r\n" );

							if("LISTED".equalsIgnoreCase(customerType))	
							{
								valueXmlString.append("<class_code_descr><![CDATA[" ).append(classCodeDescr).append( "]]></class_code_descr>\r\n" );
								valueXmlString.append("<spl_descr><![CDATA[" ).append(checkNull(rs.getString("SPL_DSCR"))).append( "]]></spl_descr>\r\n" );
								// CHanges by Harion for Doctor not showing in summary when changed locality -- 04-Feb-2021   [Start]
								//valueXmlString.append("<no_visit><![CDATA[" ).append(checkNull(rs.getString("NO_VISIT"))).append( "]]></no_visit>\r\n" );
								valueXmlString.append("<no_visit><![CDATA[" ).append(noOfVis).append( "]]></no_visit>\r\n" );
								// CHanges by Harion for Doctor not showing in summary when changed locality -- 04-Feb-2021   [End]
								valueXmlString.append("<locality_descr><![CDATA[" ).append( checkNull(rs.getString("LOC_DESCR")).trim()).append( "]]></locality_descr>\r\n");
							}
							else if(!"LISTED".equalsIgnoreCase(customerType) && !"Y".equalsIgnoreCase(isMemberPresnt))
							{
								valueXmlString.append("<locality_descr><![CDATA[" ).append( checkNull(rs.getString("LOC_DESCR")).trim()).append( "]]></locality_descr>\r\n");
							}
							//Added by mrunalini to showing speciality no_visit on summary page(end)
							valueXmlString.append("<team_details><![CDATA[" ).append( teamDetails ).append( "]]></team_details>\r\n" );
							//Added by Pooja S. on [30-DEC-2019] to show the coaching details  Start
							valueXmlString.append("<coaching_details><![CDATA[" ).append( coachingDetails ).append( "]]></coaching_details>\r\n" );
							valueXmlString.append("<host_url><![CDATA[" ).append(CommonConstants.TOMCAT_HOME).append( "]]></host_url>\r\n" );
							valueXmlString.append( "<member_present><![CDATA[" ).append(checkNull(rs.getString("MEMBER_PRESENT"))).append( "]]></member_present>\r\n" );

							valueXmlString.append("<collection_form_no><![CDATA[" ).append("collection").append( "]]></collection_form_no>\r\n" );
							valueXmlString.append("<item_form_no><![CDATA[" ).append("doctorsampleitem").append( "]]></item_form_no>\r\n" );
							valueXmlString.append("<brand_form_no><![CDATA[" ).append("brand").append( "]]></brand_form_no>\r\n" );
							valueXmlString.append("<display_form_no><![CDATA[" ).append("display").append( "]]></display_form_no>\r\n" );
							valueXmlString.append("<survey_form_no><![CDATA[" ).append("survey").append( "]]></survey_form_no>\r\n" );
							valueXmlString.append("<prescription_form_no><![CDATA[" ).append("surveybrand").append( "]]></prescription_form_no>\r\n" );
							valueXmlString.append("<hide_unlisted><![CDATA[" ).append(isMemberPresnt).append( "]]></hide_unlisted>\r\n" );
							valueXmlString.append("<oth_participant><![CDATA[" ).append(othParticipant).append( "]]></oth_participant>\r\n" );
							valueXmlString.append("<reg_no><![CDATA[" ).append(regNo).append( "]]></reg_no>\r\n" );
							valueXmlString.append("<cust_type_descr><![CDATA[" ).append(custTypeDescr).append( "]]></cust_type_descr>\r\n" );
							valueXmlString.append("<event_type_descr><![CDATA[" ).append(eventTypeDescr).append( "]]></event_type_descr>\r\n" );
							valueXmlString.append("<dcr_group><![CDATA[" ).append(dcrGroup).append( "]]></dcr_group>\r\n" );
		                    valueXmlString.append("<plan_chg_reason_descr><![CDATA[").append(genDescr).append("]]></plan_chg_reason_descr>\r\n");
							valueXmlString.append("<sales_pers_doctor><![CDATA[" ).append(salesPers).append( "]]></sales_pers_doctor>\r\n");

							valueXmlString.append( "</doctor"+analysisID+">\r\n" );


						}
						// modified by rupali on 21/12/18 for dcr_group related changes
						//else if("C".equalsIgnoreCase(custType) && !"PR".equalsIgnoreCase(actypeDB))
						else if("C".equalsIgnoreCase(dcrGroup) && !"PR".equalsIgnoreCase(actypeDB))
						{
							//valueXmlString.append( "<RetailData domID='"+domID+"' selected = 'Y'>\r\n" );
							valueXmlString.append( "<retailer"+analysisID+" domID='"+domID+"' selected = 'Y'>\r\n" );
							valueXmlString.append( "<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\"/>\r\n");
							valueXmlString.append( "<strg_code><![CDATA[" ).append( checkNull(rs.getString("STRG_CODE")).trim()).append( "]]></strg_code>\r\n");							

							if(strgName!=null && strgName.trim().length()>0)
							{
								valueXmlString.append( "<cust_name><![CDATA[" ).append( checkNull(rs.getString("SC_NAME"))).append( "]]></cust_name>\r\n");
							}
							else
							{
								valueXmlString.append( "<cust_name><![CDATA[" ).append("No of Chemists").append( "]]></cust_name>\r\n");
								customerType="UNLISTED-CHEMIST";

							}
							valueXmlString.append( "<sales_pers><![CDATA[" ).append(checkNull(salesPers)).append( "]]></sales_pers>\r\n" );
							valueXmlString.append( "<event_date><![CDATA[" ).append(eventDate).append( "]]></event_date>\r\n" );				
							valueXmlString.append( "<cust_type><![CDATA["+custType+"]]></cust_type>\r\n");														
							if("LISTED".equalsIgnoreCase(customerType))	
							{
								valueXmlString.append("<locality_descr><![CDATA[" ).append( checkNull(rs.getString("LOC_DESCR")).trim()).append( "]]></locality_descr>\r\n");
							}
							else if(!"LISTED".equalsIgnoreCase(customerType) && !"Y".equalsIgnoreCase(isMemberPresnt))
							{
								valueXmlString.append( "<locality_descr><![CDATA[" ).append( checkNull(rs.getString("LOC_DESCR")).trim()).append( "]]></locality_descr>\r\n");
							}
							valueXmlString.append( "<sku_value><![CDATA[" ).append( checkNull(rs.getString("SKU_VALUE")).trim()).append( "]]></sku_value>\r\n");


							String callOutCome = checkNull(rs.getString("CALL_OUTCOME"));
							valueXmlString.append( "<call_outcome><![CDATA[" ).append(checkNull(callOutCome)).append( "]]></call_outcome>\r\n" );
							//Added By Mrunalini Sinkar For Fortune Server 20-May-2020(Start)
							if("Y".equalsIgnoreCase(isFortuneAct))
							{
								String meetingStatus="";
								String mettingSql="SELECT CALL_OUTCOME_DESCR FROM CALL_OUTCOME WHERE CALL_OUTCOME = ? AND ACTIVITY_CODE=? ";
								PreparedStatement meetPstmt =conn.prepareStatement(mettingSql);
								meetPstmt.setString(1, callOutCome);
								meetPstmt.setString(2, eventType);
								ResultSet meetRs=meetPstmt.executeQuery();
								if(meetRs.next())
								{
									meetingStatus=checkNull(meetRs.getString("CALL_OUTCOME_DESCR"));
								}
								if (meetRs!= null)
								{
									meetRs.close();
									meetRs = null;
								}
								if(meetPstmt!=null)
								{
									meetPstmt.close();
									meetPstmt = null;
								}
								valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append(meetingStatus).append( "]]></calloutcome_descr>\r\n" );

							}
							else
							{
								if(callOutCome.equalsIgnoreCase("4"))
								{
									valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Very Positive").append( "]]></calloutcome_descr>\r\n" );
								}
								else if(callOutCome.equalsIgnoreCase("3"))
								{
									valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Average").append( "]]></calloutcome_descr>\r\n" );
								}
								else if(callOutCome.equalsIgnoreCase("2"))
								{
									valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Below Average").append( "]]></calloutcome_descr>\r\n" );
								}
								else if(callOutCome.equalsIgnoreCase("1"))
								{
									valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Negative").append( "]]></calloutcome_descr>\r\n" );
								}
								else if(callOutCome.equalsIgnoreCase("0"))
								{
									valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Refused").append( "]]></calloutcome_descr>\r\n" );
								}
								else if(callOutCome.equalsIgnoreCase("5"))
								{
									valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Supporter").append( "]]></calloutcome_descr>\r\n" );
								}
								else if(callOutCome.equalsIgnoreCase("6"))
								{
									valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Believer").append( "]]></calloutcome_descr>\r\n" );
								}
								else if(callOutCome.equalsIgnoreCase("7"))
								{
									valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Non Believer").append( "]]></calloutcome_descr>\r\n" );
								}
								// added by rupali on 03/05/18 for display call outcame data in confirm and delete report [start]
								else if(callOutCome.equalsIgnoreCase("8"))
								{
									valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Obj. Not Met").append( "]]></calloutcome_descr>\r\n" );
								}
								else if(callOutCome.equalsIgnoreCase("9"))
								{
									valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Obj. Met").append( "]]></calloutcome_descr>\r\n" );
								}

							}
							//Added By Mrunalini Sinkar For Fortune Server 20-May-2020(End)
							//Added by kailsh on 23-feb-18 [Start]
							valueXmlString.append( "<meet_summ><![CDATA[" ).append(rs.getString("MEET_SUMM")).append( "]]></meet_summ>\r\n" );
							valueXmlString.append( "<strg_class_code><![CDATA[" ).append(checkNull(rs.getString("STRG_CLASS_CODE"))).append( "]]></strg_class_code>\r\n" );
							valueXmlString.append( "<class_code_descr><![CDATA[" ).append(classCodeDescr).append( "]]></class_code_descr>\r\n" );
							valueXmlString.append("<spl_descr><![CDATA[" ).append(checkNull(rs.getString("SPL_DSCR"))).append( "]]></spl_descr>\r\n" );//Added by mrunalini sinkar for showing speciality
							valueXmlString.append( "<event_time_start><![CDATA[" ).append(rs.getString("EVENT_TIME_START")).append( "]]></event_time_start>\r\n" );
							valueXmlString.append( "<event_time_end><![CDATA[" ).append(rs.getString("EVENT_TIME_END")).append( "]]></event_time_end>\r\n" );
							valueXmlString.append( "<pob_val><![CDATA[" ).append(checkNull(rs.getString("SKU_VALUE"))).append( "]]></pob_val>\r\n" );
							valueXmlString.append( "<customer_type><![CDATA[" ).append(customerType).append( "]]></customer_type>\r\n" );
							valueXmlString.append( "<member_present><![CDATA[" ).append(checkNull(rs.getString("MEMBER_PRESENT"))).append( "]]></member_present>\r\n" );
							valueXmlString.append( "<remarks><![CDATA[" ).append(checkNull(rs.getString("REMARKS"))).append( "]]></remarks>\r\n" );

							valueXmlString.append("<item_form_no><![CDATA[" ).append("retailersampleitem").append( "]]></item_form_no>\r\n" );
							valueXmlString.append("<brand_form_no><![CDATA[" ).append("retailerbrand").append( "]]></brand_form_no>\r\n" );
							valueXmlString.append("<display_form_no><![CDATA[" ).append("retailerdisplay").append( "]]></display_form_no>\r\n" );
							valueXmlString.append("<survey_form_no><![CDATA[" ).append("retailersurvey").append( "]]></survey_form_no>\r\n" );
							//Added by kailsh on 23-feb-18 [End]
							//valueXmlString.append( "</RetailData>\r\n" );
							valueXmlString.append( "<team_details><![CDATA[" ).append( teamDetails ).append( "]]></team_details>\r\n" );
							//Added by Pooja S. on [30-DEC-2019] to show the coaching details  Start
							valueXmlString.append("<coaching_details><![CDATA[" ).append( coachingDetails ).append( "]]></coaching_details>\r\n" );
							valueXmlString.append("<host_url><![CDATA[" ).append(CommonConstants.TOMCAT_HOME).append( "]]></host_url>\r\n" );
							valueXmlString.append("<hide_unlisted><![CDATA[" ).append(isMemberPresnt).append( "]]></hide_unlisted>\r\n" );
							valueXmlString.append("<oth_participant><![CDATA[" ).append(othParticipant).append( "]]></oth_participant>\r\n" );
							valueXmlString.append("<reg_no><![CDATA[" ).append(regNo).append( "]]></reg_no>\r\n" );							
							valueXmlString.append("<cust_type_descr><![CDATA[" ).append(custTypeDescr).append( "]]></cust_type_descr>\r\n" );
							valueXmlString.append( "<event_type_descr><![CDATA[" ).append(eventTypeDescr).append( "]]></event_type_descr>\r\n" );
							valueXmlString.append("<dcr_group><![CDATA[" ).append(dcrGroup).append( "]]></dcr_group>\r\n" );
		                     valueXmlString.append("<plan_chg_reason_descr><![CDATA[").append(genDescr).append("]]></plan_chg_reason_descr>\r\n");
							valueXmlString.append("<sales_pers_doctor><![CDATA[" ).append(salesPers).append( "]]></sales_pers_doctor>\r\n");
							valueXmlString.append( "</retailer"+analysisID+">\r\n" );
						}
						//else if("M".equalsIgnoreCase(custType))
						// modified by rupali on 21/12/18 for dcr_group related changes
						//else if("S".equalsIgnoreCase(custType) && !"PR".equalsIgnoreCase(actypeDB))
						else if("S".equalsIgnoreCase(dcrGroup) && !"PR".equalsIgnoreCase(actypeDB))
						{
							//valueXmlString.append( "<MerchData domID='"+domID+"' selected = 'Y'>\r\n" );
							valueXmlString.append( "<StockData"+analysisID+" domID='"+domID+"' selected = 'Y'>\r\n" );
							valueXmlString.append( "<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\"/>\r\n");
							valueXmlString.append( "<strg_code><![CDATA[" ).append( checkNull(rs.getString("STRG_CODE")).trim()).append( "]]></strg_code>\r\n");							
							if(strgName!=null && strgName.trim().length()>0)
							{
								valueXmlString.append( "<cust_name><![CDATA[" ).append( checkNull(rs.getString("SC_NAME"))).append( "]]></cust_name>\r\n");
							}
							else
							{
								valueXmlString.append( "<cust_name><![CDATA[" ).append("Stockist Details").append( "]]></cust_name>\r\n");
								customerType="UNLISTED-STOCKIST";
							}														
							valueXmlString.append( "<sales_pers><![CDATA[" ).append(checkNull(salesPers)).append( "]]></sales_pers>\r\n" );
							valueXmlString.append( "<event_date><![CDATA[" ).append(eventDate).append( "]]></event_date>\r\n" );				
							valueXmlString.append( "<locality_descr><![CDATA[" ).append( checkNull(rs.getString("LOC_DESCR")).trim()).append( "]]></locality_descr>\r\n");
							valueXmlString.append("<cust_type><![CDATA["+custType+"]]></cust_type>\r\n");
							//added by Mrunalini Sinkar on 2-may-2017 to show call outcome details of stockist(strat)
							String callOutCome = checkNull(rs.getString("CALL_OUTCOME"));
							valueXmlString.append( "<call_outcome><![CDATA[" ).append(checkNull(callOutCome)).append( "]]></call_outcome>\r\n" );
							//Added By Mrunalini Sinkar For Fortune Server 20-May-2020(Start)
							if("Y".equalsIgnoreCase(isFortuneAct))
							{
								String meetingStatus="";
								String mettingSql="SELECT CALL_OUTCOME_DESCR FROM CALL_OUTCOME WHERE CALL_OUTCOME = ? AND ACTIVITY_CODE=? ";
								PreparedStatement meetPstmt =conn.prepareStatement(mettingSql);
								meetPstmt.setString(1, callOutCome);
								meetPstmt.setString(2, eventType);
								ResultSet meetRs=meetPstmt.executeQuery();
								if(meetRs.next())
								{
									meetingStatus=checkNull(meetRs.getString("CALL_OUTCOME_DESCR"));
								}
								if (meetRs!= null)
								{
									meetRs.close();
									meetRs = null;
								}
								if(meetPstmt!=null)
								{
									meetPstmt.close();
									meetPstmt = null;
								}
								valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append(meetingStatus).append( "]]></calloutcome_descr>\r\n" );

							}
							else
							{
								if(callOutCome.equalsIgnoreCase("4"))
								{
									valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Very Positive").append( "]]></calloutcome_descr>\r\n" );
								}
								else if(callOutCome.equalsIgnoreCase("3"))
								{
									valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Average").append( "]]></calloutcome_descr>\r\n" );
								}
								else if(callOutCome.equalsIgnoreCase("2"))
								{
									valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Below Average").append( "]]></calloutcome_descr>\r\n" );
								}
								else if(callOutCome.equalsIgnoreCase("1"))
								{
									valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Negative").append( "]]></calloutcome_descr>\r\n" );
								}
								else if(callOutCome.equalsIgnoreCase("0"))
								{
									valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Refused").append( "]]></calloutcome_descr>\r\n" );
								}
								else if(callOutCome.equalsIgnoreCase("5"))
								{
									valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Supporter").append( "]]></calloutcome_descr>\r\n" );
								}
								else if(callOutCome.equalsIgnoreCase("6"))
								{
									valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Believer").append( "]]></calloutcome_descr>\r\n" );
								}
								else if(callOutCome.equalsIgnoreCase("7"))
								{
									valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Non Believer").append( "]]></calloutcome_descr>\r\n" );
								}
								// added by rupali on 03/05/18 for display call outcame data in confirm and delete report [start]
								else if(callOutCome.equalsIgnoreCase("8"))
								{
									valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Obj. Not Met").append( "]]></calloutcome_descr>\r\n" );
								}
								else if(callOutCome.equalsIgnoreCase("9"))
								{
									valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Obj. Met").append( "]]></calloutcome_descr>\r\n" );
								}

							}
							//Added By Mrunalini Sinkar For Fortune Server 20-May-2020(End)
							//Added by kailsh on 23-feb-18 [Start]
							valueXmlString.append( "<meet_summ><![CDATA[" ).append(rs.getString("MEET_SUMM")).append( "]]></meet_summ>\r\n" );
							valueXmlString.append( "<event_time_start><![CDATA[" ).append(rs.getString("EVENT_TIME_START")).append( "]]></event_time_start>\r\n" );
							valueXmlString.append( "<event_time_end><![CDATA[" ).append(rs.getString("EVENT_TIME_END")).append( "]]></event_time_end>\r\n" );
							valueXmlString.append( "<pob_val><![CDATA[" ).append(checkNull(rs.getString("SKU_VALUE"))).append( "]]></pob_val>\r\n" );
							valueXmlString.append( "<customer_type><![CDATA[" ).append(customerType).append( "]]></customer_type>\r\n" );
							valueXmlString.append( "<remarks><![CDATA[" ).append(checkNull(rs.getString("REMARKS"))).append( "]]></remarks>\r\n" );

							valueXmlString.append( "<strg_class_code><![CDATA[" ).append(checkNull(rs.getString("STRG_CLASS_CODE"))).append( "]]></strg_class_code>\r\n" );
							valueXmlString.append( "<class_code_descr><![CDATA[" ).append(classCodeDescr).append( "]]></class_code_descr>\r\n" );
							valueXmlString.append("<spl_descr><![CDATA[" ).append(checkNull(rs.getString("SPL_DSCR"))).append( "]]></spl_descr>\r\n" );//Added by mrunalini sinkar for showing speciality

							//Added by kailsh on 23-feb-18 [End]
							//added by Mrunalini Sinkar on 2-may-2017 to show call outcome details of stockist(end)
							valueXmlString.append("<item_form_no><![CDATA[" ).append("stockistsampleitem").append( "]]></item_form_no>\r\n" );
							valueXmlString.append("<brand_form_no><![CDATA[" ).append("Stockistbrand").append( "]]></brand_form_no>\r\n" );
							valueXmlString.append("<display_form_no><![CDATA[" ).append("StockistDisplay").append( "]]></display_form_no>\r\n" );
							valueXmlString.append("<survey_form_no><![CDATA[" ).append("stockistsurvey").append( "]]></survey_form_no>\r\n" );
							//valueXmlString.append( "</MerchData>\r\n" );
							valueXmlString.append( "<team_details><![CDATA[" ).append( teamDetails ).append( "]]></team_details>\r\n" );
							//Added by Pooja S. on [30-DEC-2019] to show the coaching details  Start
							valueXmlString.append("<coaching_details><![CDATA[" ).append( coachingDetails ).append( "]]></coaching_details>\r\n" );
							valueXmlString.append("<host_url><![CDATA[" ).append(CommonConstants.TOMCAT_HOME).append( "]]></host_url>\r\n" );
							valueXmlString.append( "<member_present><![CDATA[" ).append(checkNull(rs.getString("MEMBER_PRESENT"))).append( "]]></member_present>\r\n" );
							valueXmlString.append("<hide_unlisted><![CDATA[" ).append(isMemberPresnt).append( "]]></hide_unlisted>\r\n" );
							valueXmlString.append("<oth_participant><![CDATA[" ).append(othParticipant).append( "]]></oth_participant>\r\n" );
							valueXmlString.append("<reg_no><![CDATA[" ).append(regNo).append( "]]></reg_no>\r\n" );
							valueXmlString.append("<cust_type_descr><![CDATA[" ).append(custTypeDescr).append( "]]></cust_type_descr>\r\n" );
							valueXmlString.append( "<event_type_descr><![CDATA[" ).append(eventTypeDescr).append( "]]></event_type_descr>\r\n" );
							valueXmlString.append("<dcr_group><![CDATA[" ).append(dcrGroup).append( "]]></dcr_group>\r\n" );
		                     valueXmlString.append("<plan_chg_reason_descr><![CDATA[").append(genDescr).append("]]></plan_chg_reason_descr>\r\n");
							valueXmlString.append("<sales_pers_doctor><![CDATA[" ).append(salesPers).append( "]]></sales_pers_doctor>\r\n");
							valueXmlString.append( "</StockData"+analysisID+">\r\n" );
							String sqlEdit1="select it.item_code ,it.descr ITEMDESCR from strg_meet_order sm, item it where sm.item_code=it.item_code and sm.strg_code= ? and sm.dcr_id = ?";
							PreparedStatement pstmt1 = null;
							pstmt1 =  conn.prepareStatement( sqlEdit1 );
							pstmt1.setString(1, checkNull(rs.getString("STRG_CODE")));
							pstmt1.setString( 2, checkNull(rs.getString("DCR_ID")) );

							ResultSet rs1 = pstmt1.executeQuery();					

							//valueXmlString.append( "<ItemData>" );
							while(rs1.next())
							{
								//valueXmlString.append( "<item><![CDATA[" ).append(checkNull(rs1.getString("ITEMDESCR"))).append( "]]></item>\r\n" );
								//valueXmlString.append( "<strg_code><![CDATA[" ).append(checkNull(rs.getString("STRG_CODE"))).append( "]]></strg_code>\r\n" );
							}
							if (rs1 != null)
							{
								rs1.close();
								rs1 = null;
							}
							if(pstmt1 !=null)
							{
								pstmt1.close();
								pstmt1 = null;
							}
							//valueXmlString.append( "</ItemData>\r\n" );
						}
						// modified by rupali on 21/12/18 for dcr_group related changes
						//else if("O".equalsIgnoreCase(custType) && !"PR".equalsIgnoreCase(actypeDB))
						else if("O".equalsIgnoreCase(dcrGroup) && !"PR".equalsIgnoreCase(actypeDB))
						{
							//valueXmlString.append( "<MerchData domID='"+domID+"' selected = 'Y'>\r\n" );
							valueXmlString.append( "<NCWData"+analysisID+" domID='"+domID+"' selected = 'Y'>\r\n" );
							valueXmlString.append( "<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\"/>\r\n");
							valueXmlString.append( "<strg_code><![CDATA[" ).append( checkNull(rs.getString("STRG_CODE")).trim()).append( "]]></strg_code>\r\n");							
							if(strgName!=null && strgName.trim().length()>0)
							{
								valueXmlString.append( "<cust_name><![CDATA[" ).append( checkNull(rs.getString("SC_NAME"))).append( "]]></cust_name>\r\n");
							}
							else
							{
								valueXmlString.append( "<cust_name><![CDATA[" ).append("Other Detail's").append( "]]></cust_name>\r\n");
							}
							valueXmlString.append( "<sales_pers><![CDATA[" ).append(checkNull(salesPers)).append( "]]></sales_pers>\r\n" );
							valueXmlString.append( "<event_date><![CDATA[" ).append(eventDate).append( "]]></event_date>\r\n" );				
							valueXmlString.append("<cust_type><![CDATA["+custType+"]]></cust_type>\r\n");														
							valueXmlString.append( "<locality_descr><![CDATA[" ).append( checkNull(rs.getString("LOC_DESCR")).trim()).append( "]]></locality_descr>\r\n");
							//valueXmlString.append( "<loc_descr><![CDATA[" ).append( checkNull(rs.getString("LOC_DESCR")).trim()).append( "]]></loc_descr>\r\n");
							//added by Mrunalini Sinkar on 2-may-2017 to show call outcome details of ncw(strat)
							String callOutCome = checkNull(rs.getString("CALL_OUTCOME"));
							valueXmlString.append( "<call_outcome><![CDATA[" ).append(checkNull(callOutCome)).append( "]]></call_outcome>\r\n" );
							//Added By Mrunalini Sinkar For Fortune Server 20-May-2020(Start)
							if("Y".equalsIgnoreCase(isFortuneAct))
							{
								String meetingStatus="";
								String mettingSql="SELECT CALL_OUTCOME_DESCR FROM CALL_OUTCOME WHERE CALL_OUTCOME = ? AND ACTIVITY_CODE=? ";
								PreparedStatement meetPstmt =conn.prepareStatement(mettingSql);
								meetPstmt.setString(1, callOutCome);
								meetPstmt.setString(2, eventType);
								ResultSet meetRs=meetPstmt.executeQuery();
								if(meetRs.next())
								{
									meetingStatus=checkNull(meetRs.getString("CALL_OUTCOME_DESCR"));
								}
								if (meetRs!= null)
								{
									meetRs.close();
									meetRs = null;
								}
								if(meetPstmt!=null)
								{
									meetPstmt.close();
									meetPstmt = null;
								}
								valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append(meetingStatus).append( "]]></calloutcome_descr>\r\n" );

							}
							else
							{
								if(callOutCome.equalsIgnoreCase("4"))
								{
									valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Very Positive").append( "]]></calloutcome_descr>\r\n" );
								}
								else if(callOutCome.equalsIgnoreCase("3"))
								{
									valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Average").append( "]]></calloutcome_descr>\r\n" );
								}
								else if(callOutCome.equalsIgnoreCase("2"))
								{
									valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Below Average").append( "]]></calloutcome_descr>\r\n" );
								}
								else if(callOutCome.equalsIgnoreCase("1"))
								{
									valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Negative").append( "]]></calloutcome_descr>\r\n" );
								}
								else if(callOutCome.equalsIgnoreCase("0"))
								{
									valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Refused").append( "]]></calloutcome_descr>\r\n" );
								}
								else if(callOutCome.equalsIgnoreCase("5"))
								{
									valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Supporter").append( "]]></calloutcome_descr>\r\n" );
								}
								else if(callOutCome.equalsIgnoreCase("6"))
								{
									valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Believer").append( "]]></calloutcome_descr>\r\n" );
								}
								else if(callOutCome.equalsIgnoreCase("7"))
								{
									valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Non Believer").append( "]]></calloutcome_descr>\r\n" );
								}
								// added by rupali on 03/05/18 for display call outcame data in confirm and delete report [start]
								else if(callOutCome.equalsIgnoreCase("8"))
								{
									valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Obj. Not Met").append( "]]></calloutcome_descr>\r\n" );
								}
								else if(callOutCome.equalsIgnoreCase("9"))
								{
									valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Obj. Met").append( "]]></calloutcome_descr>\r\n" );
								}

							}
							//Added By Mrunalini Sinkar For Fortune Server 20-May-2020(End)
							//Added by kailsh on 23-feb-18 [Start]
							valueXmlString.append( "<meet_summ><![CDATA[" ).append(rs.getString("MEET_SUMM")).append( "]]></meet_summ>\r\n" );
							valueXmlString.append( "<event_time_start><![CDATA[" ).append(rs.getString("EVENT_TIME_START")).append( "]]></event_time_start>\r\n" );
							valueXmlString.append( "<event_time_end><![CDATA[" ).append(rs.getString("EVENT_TIME_END")).append( "]]></event_time_end>\r\n" );
							valueXmlString.append( "<pob_val><![CDATA[" ).append(checkNull(rs.getString("SKU_VALUE"))).append( "]]></pob_val>\r\n" );
							valueXmlString.append( "<remarks><![CDATA[" ).append(checkNull(rs.getString("REMARKS"))).append( "]]></remarks>\r\n" );

							valueXmlString.append( "<strg_class_code><![CDATA[" ).append(rs.getString("STRG_CLASS_CODE")).append( "]]></strg_class_code>\r\n" );
							valueXmlString.append( "<class_code_descr><![CDATA[" ).append(classCodeDescr).append( "]]></class_code_descr>\r\n" );
							valueXmlString.append("<spl_descr><![CDATA[" ).append(checkNull(rs.getString("SPL_DSCR"))).append( "]]></spl_descr>\r\n" );//Added by mrunalini sinkar for showing speciality
							valueXmlString.append( "<customer_type><![CDATA[" ).append(customerType).append( "]]></customer_type>\r\n" );

							//Added by kailsh on 23-feb-18 [End]
							//added by Mrunalini Sinkar on 2-may-2017 to show call outcome details of ncw(end)
							valueXmlString.append("<item_form_no><![CDATA[" ).append("NCWsampleitem").append( "]]></item_form_no>\r\n" );
							valueXmlString.append("<brand_form_no><![CDATA[" ).append("Ncwbrand").append( "]]></brand_form_no>\r\n" );
							valueXmlString.append("<display_form_no><![CDATA[" ).append("NcwDisplay").append( "]]></display_form_no>\r\n" );
							valueXmlString.append("<survey_form_no><![CDATA[" ).append("ncwsurvey").append( "]]></survey_form_no>\r\n" );
							//valueXmlString.append( "</MerchData>\r\n" );
							valueXmlString.append( "<team_details><![CDATA[" ).append( teamDetails ).append( "]]></team_details>\r\n" );
							//Added by Pooja S. on [30-DEC-2019] to show the coaching details  Start
							valueXmlString.append("<coaching_details><![CDATA[" ).append( coachingDetails ).append( "]]></coaching_details>\r\n" );
							valueXmlString.append("<host_url><![CDATA[" ).append(CommonConstants.TOMCAT_HOME).append( "]]></host_url>\r\n" );
							valueXmlString.append( "<member_present><![CDATA[" ).append(checkNull(rs.getString("MEMBER_PRESENT"))).append( "]]></member_present>\r\n" );
							valueXmlString.append("<hide_unlisted><![CDATA[" ).append(isMemberPresnt).append( "]]></hide_unlisted>\r\n" );
							valueXmlString.append("<oth_participant><![CDATA[" ).append(othParticipant).append( "]]></oth_participant>\r\n" );
							valueXmlString.append("<reg_no><![CDATA[" ).append(regNo).append( "]]></reg_no>\r\n" );
							valueXmlString.append("<cust_type_descr><![CDATA[" ).append(custTypeDescr).append( "]]></cust_type_descr>\r\n" );
							valueXmlString.append( "<event_type_descr><![CDATA[" ).append(eventTypeDescr).append( "]]></event_type_descr>\r\n" );
							valueXmlString.append("<dcr_group><![CDATA[" ).append(dcrGroup).append( "]]></dcr_group>\r\n" );
		                     valueXmlString.append("<plan_chg_reason_descr><![CDATA[").append(genDescr).append("]]></plan_chg_reason_descr>\r\n");
								valueXmlString.append("<sales_pers_doctor><![CDATA[" ).append(salesPers).append( "]]></sales_pers_doctor>\r\n");
							valueXmlString.append( "</NCWData"+analysisID+">\r\n" );
							/*String sqlEdit1="select it.item_code ,it.descr ITEMDESCR from strg_meet_order sm, item it where sm.item_code=it.item_code and sm.strg_code= ? and sm.dcr_id = ?";
							PreparedStatement pstmt1 = null;
							pstmt1 =  conn.prepareStatement( sqlEdit1 );
							pstmt1.setString(1, checkNull(rs.getString("STRG_CODE")));
							pstmt1.setString( 2, checkNull(rs.getString("DCR_ID")) );

							ResultSet rs1 = pstmt1.executeQuery();					

							valueXmlString.append( "<ItemData>" );
							while(rs1.next())
							{
								valueXmlString.append( "<item><![CDATA[" ).append(checkNull(rs1.getString("ITEMDESCR"))).append( "]]></item>\r\n" );
								valueXmlString.append( "<strg_code><![CDATA[" ).append(checkNull(rs.getString("STRG_CODE"))).append( "]]></strg_code>\r\n" );
							}
							if (rs1 != null)
							{
								rs1.close();
								rs1 = null;
							}
							if(pstmt1 !=null)
							{
								pstmt1.close();
								pstmt1 = null;
							}
							valueXmlString.append( "</ItemData>\r\n" );*/
						}
						domID++;
					}
					
					if ( rs != null )
					{
						rs.close();
						rs = null;
					}
					if ( pstmt != null )
					{
						pstmt.close();
						pstmt = null;
					}
					//Added by Pooja S. on [30-DEC-2019] to show the coaching details  Start
					if( pstmtTeam != null)
					{
						pstmtTeam.close();
						pstmtTeam = null;
					}
					if( pstmtCoaching != null)
					{
						pstmtCoaching.close();
						pstmtCoaching = null;
					}
				}
				//Added by Pooja S. on [30-DEC-2019] to show the coaching details  End
			//added by mrunalini sinkar on 17-april-2017 to show order details on confirm and delete form(start) 
				boolean isDetailExist = false;
				
				/*String sampleOrderSql = "SELECT ROWNUM,CUST_NAME,QUANTITY,VALUE ,DESCR , CUST_TYPE ,STRG_CODE " +
						"FROM  (SELECT SMI.QUANTITY QUANTITY,ITEM.DESCR DESCR ,  SC.FIRST_NAME||' '||SC.LAST_NAME AS CUST_NAME ,  SC.CUST_TYPE  , " +
						"SMI.value , SMI.STRG_CODE " +
						"FROM STRG_MEET_ORDER SMI  JOIN ITEM ITEM ON SMI.ITEM_CODE = ITEM.ITEM_CODE  " +
						"JOIN STRG_CUSTOMER SC  ON SMI.STRG_CODE=SC.SC_CODE   " +
						"WHERE SMI.DCR_ID=  ? )";*/
				//Added By Prathmesh Jangam on 07-07-2017 for DB2 changes(start) 
				String sampleOrderSql = "";
				if("ORACLE".equalsIgnoreCase(CommonConstants.DB_NAME))
				{
						/*sampleOrderSql = "SELECT ROWNUM,QUANTITY,VALUE ,DESCR ,STRG_CODE ,STRG_TYPE, DCR_GROUP, DESCRIPTION " +
							" FROM  (SELECT SMI.QUANTITY QUANTITY,ITEM.DESCR DESCR ," +
							" SMI.VALUE , SMI.STRG_CODE,STRG_MEET.STRG_TYPE, DCR_GROUP, BOM.DESCR AS DESCRIPTION " +
							" FROM STRG_MEET,STRG_MEET_ORDER SMI  JOIN ITEM ITEM ON SMI.ITEM_CODE = ITEM.ITEM_CODE " +
							" LEFT OUTER JOIN BOM ON BOM.BOM_CODE = SMI.PROMO_CODE, STRG_CUST_TYPE SCT " +
							" WHERE SMI.DCR_ID=  ? "+
							" AND STRG_MEET.EVENT_DATE = ? "+
							" AND STRG_MEET.SALES_PERS = ? "+
								" AND STRG_MEET.STRG_CODE=SMI.STRG_CODE AND STRG_MEET.DCR_ID=SMI.DCR_ID AND STRG_MEET.STRG_TYPE = SCT.TYPE )";*/
						
		                sampleOrderSql = "SELECT ROWNUM,QUANTITY,VALUE ,DESCR ,STRG_CODE ,STRG_TYPE, DCR_GROUP, DESCRIPTION, "
		                		+ "REMARKS_ORD,FOCUS_DEVI_REAS  FROM  (SELECT SMI.QUANTITY QUANTITY,ITEM.DESCR DESCR , SMI.VALUE , SMI.STRG_CODE, "
		                		+ "STRG_MEET.STRG_TYPE, DCR_GROUP, BOM.DESCR AS DESCRIPTION,SMI.REMARKS_ORD,SMI.FOCUS_DEVI_REAS "
		                		+ "FROM STRG_MEET,STRG_MEET_ORDER SMI  JOIN ITEM ITEM ON SMI.ITEM_CODE = ITEM.ITEM_CODE  "
		                		+ "LEFT OUTER JOIN BOM ON BOM.BOM_CODE = SMI.PROMO_CODE, STRG_CUST_TYPE SCT  WHERE SMI.DCR_ID=  ?  "
		                		+ "AND STRG_MEET.EVENT_DATE = ?  AND STRG_MEET.SALES_PERS = ?  AND STRG_MEET.STRG_CODE=SMI.STRG_CODE "
		                		+ "AND STRG_MEET.DCR_ID=SMI.DCR_ID AND STRG_MEET.STRG_TYPE = SCT.TYPE )";

				}
				else if("DB2".equalsIgnoreCase(CommonConstants.DB_NAME))
				{
	/*					sampleOrderSql = "SELECT SMI.QUANTITY QUANTITY,ITEM.DESCR DESCR ," +
							" SMI.VALUE , SMI.STRG_CODE,STRG_MEET.STRG_TYPE, ROW_NUMBER() OVER () ROWNUM, SCT.DCR_GROUP, BOM.DESCR AS DESCRIPTION " +
							" FROM STRG_MEET,STRG_MEET_ORDER SMI  JOIN ITEM ITEM ON SMI.ITEM_CODE = ITEM.ITEM_CODE " +
							" LEFT OUTER JOIN BOM ON BOM.BOM_CODE = SMI.PROMO_CODE, STRG_CUST_TYPE SCT " +
							" WHERE SMI.DCR_ID=  ? "+
							" AND STRG_MEET.EVENT_DATE = ? "+
							" AND STRG_MEET.SALES_PERS = ? "+
								" AND STRG_MEET.STRG_CODE=SMI.STRG_CODE AND STRG_MEET.DCR_ID=SMI.DCR_ID  AND STRG_MEET.STRG_TYPE = SCT.TYPE";*/
						
		                sampleOrderSql = "SELECT SMI.QUANTITY QUANTITY,ITEM.DESCR DESCR , SMI.VALUE , SMI.STRG_CODE,STRG_MEET.STRG_TYPE, "
		                		+ "ROW_NUMBER() OVER () ROWNUM, SCT.DCR_GROUP, BOM.DESCR AS DESCRIPTION,SMI.REMARKS_ORD,SMI.FOCUS_DEVI_REAS  "
		                		+ "FROM STRG_MEET,STRG_MEET_ORDER SMI  JOIN ITEM ITEM ON SMI.ITEM_CODE = ITEM.ITEM_CODE  "
		                		+ "LEFT OUTER JOIN BOM ON BOM.BOM_CODE = SMI.PROMO_CODE, STRG_CUST_TYPE SCT  WHERE SMI.DCR_ID=  ?  "
		                		+ "AND STRG_MEET.EVENT_DATE = ?  AND STRG_MEET.SALES_PERS = ?  AND STRG_MEET.STRG_CODE=SMI.STRG_CODE "
		                		+ "AND STRG_MEET.DCR_ID=SMI.DCR_ID  AND STRG_MEET.STRG_TYPE = SCT.TYPE";

				}
				//Added By Prathmesh Jangam on 07-07-2017 for DB2 changes(end) 

			    pstmt = conn.prepareStatement(sampleOrderSql);
				pstmt.setString(1, dcrId);
				pstmt.setTimestamp( 2, java.sql.Timestamp.valueOf( eventDateDBFmt ) );
				pstmt.setString(3, salesPers);
				rs = pstmt.executeQuery();
				while(rs.next())
				{

						String genDescr2="";
					isDetailExist = true;
					String custType = checkNull(rs.getString("STRG_TYPE"));
					String dcrGroup = checkNull(rs.getString("DCR_GROUP")); // modified by rupali on 21/12/18 for dcr_group related changes
					// modified by rupali on 21/12/18 for dcr_group related changes
					//if("D".equalsIgnoreCase(custType) && !"PR".equalsIgnoreCase(actTypeNew))
		                String remarksORD=checkNull(rs.getString("REMARKS_ORD"));
						String genFldValue2 = checkNull(rs.getString("FOCUS_DEVI_REAS"));
		                if (genFldValue2 != null && genFldValue2.trim().length() > 0) {
		                    genDescr2 = checkNull(getDescrFromGenCodes("W_STRG_MEET_DCR_REALTIME_WIZ", "ORDER_REMARK", genFldValue2, conn));
		                }

						
					if("D".equalsIgnoreCase(dcrGroup) && !"PR".equalsIgnoreCase(actTypeNew))
					{
						valueXmlString.append("<sampleorder"+analysisID+">\r\n");
						valueXmlString.append("<item_rowNum>").append("<![CDATA[").append(rs.getString("ROWNUM") == null ? "" : rs.getString("ROWNUM")).append("]]>").append("</item_rowNum>\r\n ");
						valueXmlString.append("<cust_name>").append("<![CDATA[").append(rs.getString("STRG_TYPE") == null ? "" : rs.getString("STRG_TYPE")).append("]]>").append("</cust_name>\r\n ");
						valueXmlString.append("<quantity>").append("<![CDATA[").append(rs.getString("QUANTITY") == null ? "" : rs.getString("QUANTITY")).append("]]>").append("</quantity>\r\n ");
						valueXmlString.append("<item_descr>").append("<![CDATA[").append(rs.getString("DESCR") == null ? "" : rs.getString("DESCR")).append("]]>").append("</item_descr>\r\n ");
						valueXmlString.append("<value>").append("<![CDATA[").append(rs.getString("VALUE") == null ? "" : rs.getString("VALUE")).append("]]>").append("</value>\r\n ");
						valueXmlString.append("<strg_code>").append("<![CDATA[").append(rs.getString("STRG_CODE") == null ? "" : rs.getString("STRG_CODE")).append("]]>").append("</strg_code>\r\n ");
						valueXmlString.append("<description>").append("<![CDATA[").append(rs.getString("DESCRIPTION") == null ? "" : rs.getString("DESCRIPTION")).append("]]>").append("</description>\r\n ");
		                valueXmlString.append("<remark_descr><![CDATA[").append(genDescr2).append("]]></remark_descr>\r\n");
		                valueXmlString.append("<remarks><![CDATA[").append(remarksORD).append("]]></remarks>\r\n");
		                valueXmlString.append("<sales_pers_sampleorder><![CDATA[" ).append(salesPers).append( "]]></sales_pers_sampleorder>\r\n");
						valueXmlString.append("</sampleorder"+analysisID+">\r\n");
					}
					// modified by rupali on 21/12/18 for dcr_group related changes
					//else if ("C".equalsIgnoreCase(custType))
					else if ("C".equalsIgnoreCase(dcrGroup))
					{
						valueXmlString.append("<retailersampleorder"+analysisID+">\r\n");
						valueXmlString.append("<item_rowNum>").append("<![CDATA[").append(rs.getString("ROWNUM") == null ? "" : rs.getString("ROWNUM")).append("]]>").append("</item_rowNum>\r\n ");
						valueXmlString.append("<cust_name>").append("<![CDATA[").append(rs.getString("STRG_TYPE") == null ? "" : rs.getString("STRG_TYPE")).append("]]>").append("</cust_name>\r\n ");
						valueXmlString.append("<quantity>").append("<![CDATA[").append(rs.getString("QUANTITY") == null ? "" : rs.getString("QUANTITY")).append("]]>").append("</quantity>\r\n ");
						valueXmlString.append("<item_descr>").append("<![CDATA[").append(rs.getString("DESCR") == null ? "" : rs.getString("DESCR")).append("]]>").append("</item_descr>\r\n ");
						valueXmlString.append("<value>").append("<![CDATA[").append(rs.getString("VALUE") == null ? "" : rs.getString("VALUE")).append("]]>").append("</value>\r\n ");
						valueXmlString.append("<strg_code>").append("<![CDATA[").append(rs.getString("STRG_CODE") == null ? "" : rs.getString("STRG_CODE")).append("]]>").append("</strg_code>\r\n ");
						valueXmlString.append("<description>").append("<![CDATA[").append(rs.getString("DESCRIPTION") == null ? "" : rs.getString("DESCRIPTION")).append("]]>").append("</description>\r\n ");
		                valueXmlString.append("<remark_descr><![CDATA[").append(genDescr2).append("]]></remark_descr>\r\n");
		                valueXmlString.append("<remarks><![CDATA[").append(remarksORD).append("]]></remarks>\r\n");
		                valueXmlString.append("<sales_pers_sampleorder><![CDATA[" ).append(salesPers).append( "]]></sales_pers_sampleorder>\r\n");
		                valueXmlString.append("</retailersampleorder"+analysisID+">\r\n");

					}
					//added by mrunalini sinkar to show the stockist and ncw order on confirm and delete report on 2-may-2017 (start)
					// modified by rupali on 21/12/18 for dcr_group related changes 
					//else if ("S".equalsIgnoreCase(custType))
					else if ("S".equalsIgnoreCase(dcrGroup))
					{
						valueXmlString.append("<StockOrder"+analysisID+">\r\n");
						valueXmlString.append("<item_rowNum>").append("<![CDATA[").append(rs.getString("ROWNUM") == null ? "" : rs.getString("ROWNUM")).append("]]>").append("</item_rowNum>\r\n ");
						valueXmlString.append("<cust_name>").append("<![CDATA[").append(rs.getString("STRG_TYPE") == null ? "" : rs.getString("STRG_TYPE")).append("]]>").append("</cust_name>\r\n ");
						valueXmlString.append("<quantity>").append("<![CDATA[").append(rs.getString("QUANTITY") == null ? "" : rs.getString("QUANTITY")).append("]]>").append("</quantity>\r\n ");
						valueXmlString.append("<item_descr>").append("<![CDATA[").append(rs.getString("DESCR") == null ? "" : rs.getString("DESCR")).append("]]>").append("</item_descr>\r\n ");
						valueXmlString.append("<value>").append("<![CDATA[").append(rs.getString("VALUE") == null ? "" : rs.getString("VALUE")).append("]]>").append("</value>\r\n ");
						valueXmlString.append("<strg_code>").append("<![CDATA[").append(rs.getString("STRG_CODE") == null ? "" : rs.getString("STRG_CODE")).append("]]>").append("</strg_code>\r\n ");
						valueXmlString.append("<description>").append("<![CDATA[").append(rs.getString("DESCRIPTION") == null ? "" : rs.getString("DESCRIPTION")).append("]]>").append("</description>\r\n ");
		                valueXmlString.append("<remark_descr><![CDATA[").append(genDescr2).append("]]></remark_descr>\r\n");
		                valueXmlString.append("<remarks><![CDATA[").append(remarksORD).append("]]></remarks>\r\n");
		                valueXmlString.append("<sales_pers_sampleorder><![CDATA[" ).append(salesPers).append( "]]></sales_pers_sampleorder>\r\n");
		                valueXmlString.append("</StockOrder"+analysisID+">\r\n");

					}
					// modified by rupali on 21/12/18 for dcr_group related changes
					//else if ("O".equalsIgnoreCase(custType))
					else if ("O".equalsIgnoreCase(dcrGroup))
					{
						valueXmlString.append("<NcwOrder"+analysisID+">\r\n");
						valueXmlString.append("<item_rowNum>").append("<![CDATA[").append(rs.getString("ROWNUM") == null ? "" : rs.getString("ROWNUM")).append("]]>").append("</item_rowNum>\r\n ");
						valueXmlString.append("<cust_name>").append("<![CDATA[").append(rs.getString("STRG_TYPE") == null ? "" : rs.getString("STRG_TYPE")).append("]]>").append("</cust_name>\r\n ");
						valueXmlString.append("<quantity>").append("<![CDATA[").append(rs.getString("QUANTITY") == null ? "" : rs.getString("QUANTITY")).append("]]>").append("</quantity>\r\n ");
						valueXmlString.append("<item_descr>").append("<![CDATA[").append(rs.getString("DESCR") == null ? "" : rs.getString("DESCR")).append("]]>").append("</item_descr>\r\n ");
						valueXmlString.append("<value>").append("<![CDATA[").append(rs.getString("VALUE") == null ? "" : rs.getString("VALUE")).append("]]>").append("</value>\r\n ");
						valueXmlString.append("<strg_code>").append("<![CDATA[").append(rs.getString("STRG_CODE") == null ? "" : rs.getString("STRG_CODE")).append("]]>").append("</strg_code>\r\n ");
						valueXmlString.append("<description>").append("<![CDATA[").append(rs.getString("DESCRIPTION") == null ? "" : rs.getString("DESCRIPTION")).append("]]>").append("</description>\r\n ");
		                valueXmlString.append("<remark_descr><![CDATA[").append(genDescr2).append("]]></remark_descr>\r\n");
		                valueXmlString.append("<remarks><![CDATA[").append(remarksORD).append("]]></remarks>\r\n");
		                valueXmlString.append("<sales_pers_sampleorder><![CDATA[" ).append(salesPers).append( "]]></sales_pers_sampleorder>\r\n");
		                valueXmlString.append("</NcwOrder"+analysisID+">\r\n");

					}
				//added by mrunalini sinkar to show the stockist and ncw order on confirm and delete report on 2-may-2017 (start) 

				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
				//added by mrunalini sinkar on 17-april-2017 to show order details on confirm and delete form(end) 

				
				/*String sql= " SELECT ROWNUM,CUST_NAME,QUANTITY,DESCR , CUST_TYPE FROM "+
						" (SELECT SMI.QUANTITY QUANTITY,ITEM.DESCR DESCR , "+
						" SC.FIRST_NAME||' '||SC.LAST_NAME AS CUST_NAME ,  SC.CUST_TYPE  " +
						" FROM STRG_MEET_ITEMS SMI "+
						" JOIN ITEM ITEM ON SMI.ITEM_CODE = ITEM.ITEM_CODE "+
						" JOIN STRG_CUSTOMER SC  ON SMI.STRG_CODE=SC.SC_CODE "+
						" WHERE SMI.DCR_ID= ?)";*/
				
				String sql= "";
				
				if("Y".equalsIgnoreCase(oldData) && newCnt==0)
				{
					/*
					sql="SELECT ROWNUM,'D' DCR_GROUP,'D' STRG_TYPE,ITEM_QTY QUANTITY,SC_CODE STRG_CODE,(CASE WHEN ITEM_USAGE ='G' THEN 'GIFT' WHEN ITEM_USAGE ='S' THEN 'SAMPLE' WHEN ITEM_USAGE ='SPK' THEN 'SAMPLE' END) AS ITEM_USAGE,DSD.ITEM_CODE,I.DESCR DESCR " + 
							"FROM DR_SAMPLE_DISTRIBUTED DSD,ITEM I,SALES_PERS SP WHERE DSD.ITEM_CODE=I.ITEM_CODE AND DSD.SALES_PERS=SP.SALES_PERS AND SP.ITEM_SER=I.ITEM_SER AND DSD.SALES_PERS=? AND DSD.WORK_DATE=? ";
				    */
					//BY PRACHI ON 13JUNE2022 ID:W22CSUN019
					sql="SELECT ROWNUM,'D' DCR_GROUP,'D' STRG_TYPE,ITEM_QTY QUANTITY,SC_CODE STRG_CODE,ITEM_USAGE AS ITEM_USAGE,DSD.ITEM_CODE,I.DESCR DESCR " + 
							"FROM DR_SAMPLE_DISTRIBUTED DSD,ITEM I,SALES_PERS SP WHERE DSD.ITEM_CODE=I.ITEM_CODE AND DSD.SALES_PERS=SP.SALES_PERS AND SP.ITEM_SER=I.ITEM_SER AND DSD.SALES_PERS=? AND DSD.WORK_DATE=? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, salesPers);
					pstmt.setTimestamp( 2, java.sql.Timestamp.valueOf( eventDateDBFmt ) );
					
				}
				else
				{
					if("ORACLE".equalsIgnoreCase(CommonConstants.DB_NAME))
					{
						/*
						sql= "SELECT ROWNUM,QUANTITY,DESCR ,STRG_TYPE,DCR_GROUP,(CASE WHEN ITEM_USAGE ='G' THEN 'GIFT' WHEN ITEM_USAGE ='S' THEN 'SAMPLE' WHEN ITEM_USAGE ='SPK' THEN 'SAMPLE' END)ITEM_USAGE,STRG_CODE FROM "+
								" (SELECT SMI.QUANTITY QUANTITY,ITEM.DESCR DESCR ,STRG_MEET.STRG_TYPE, SCT.DCR_GROUP,ITEM.ITEM_USAGE,STRG_MEET.STRG_CODE "+
								" FROM STRG_MEET,STRG_MEET_ITEMS SMI "+
								" JOIN ITEM ITEM ON SMI.ITEM_CODE = ITEM.ITEM_CODE,STRG_CUST_TYPE SCT "+
								" WHERE SMI.DCR_ID= ? "+
								" AND STRG_MEET.EVENT_DATE = ? "+
								" AND STRG_MEET.SALES_PERS = ? "+
								" AND STRG_MEET.STRG_CODE=SMI.STRG_CODE AND STRG_MEET.DCR_ID=SMI.DCR_ID  AND STRG_MEET.STRG_TYPE = SCT.TYPE)";
					    */
						//BY PRACHI ON 13JUNE2022 ID:W22CSUN019
						sql= "SELECT ROWNUM,QUANTITY,DESCR ,STRG_TYPE,DCR_GROUP,ITEM_USAGE AS ITEM_USAGE,STRG_CODE FROM "+
								" (SELECT SMI.QUANTITY QUANTITY,ITEM.DESCR DESCR ,STRG_MEET.STRG_TYPE, SCT.DCR_GROUP,ITEM.ITEM_USAGE,STRG_MEET.STRG_CODE "+
								" FROM STRG_MEET,STRG_MEET_ITEMS SMI "+
								" JOIN ITEM ITEM ON SMI.ITEM_CODE = ITEM.ITEM_CODE,STRG_CUST_TYPE SCT "+
								" WHERE SMI.DCR_ID= ? "+
								" AND STRG_MEET.EVENT_DATE = ? "+
								" AND STRG_MEET.SALES_PERS = ? "+
								" AND STRG_MEET.STRG_CODE=SMI.STRG_CODE AND STRG_MEET.DCR_ID=SMI.DCR_ID  AND STRG_MEET.STRG_TYPE = SCT.TYPE)";
					
					
					}
					else if("DB2".equalsIgnoreCase(CommonConstants.DB_NAME))
					{
						sql= "SELECT SMI.QUANTITY QUANTITY,ITEM.DESCR DESCR ,STRG_MEET.STRG_TYPE, ROW_NUMBER() OVER () ROWNUM, SCT.DCR_GROUP,ITEM.ITEM_USAGE,STRG_MEET.STRG_CODE "+
								" FROM STRG_MEET,STRG_MEET_ITEMS SMI "+
								" JOIN ITEM ITEM ON SMI.ITEM_CODE = ITEM.ITEM_CODE,STRG_CUST_TYPE SCT "+
								" WHERE SMI.DCR_ID= ? "+
								" AND STRG_MEET.EVENT_DATE = ? "+
								" AND STRG_MEET.SALES_PERS = ? "+
								" AND STRG_MEET.STRG_CODE=SMI.STRG_CODE AND STRG_MEET.DCR_ID=SMI.DCR_ID AND STRG_MEET.STRG_TYPE = SCT.TYPE";
					}
				    pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, dcrId);
					pstmt.setTimestamp( 2, java.sql.Timestamp.valueOf( eventDateDBFmt ) );
					pstmt.setString(3, salesPers);
				}
				itemUsageMap = dcb.getItemUsageData(conn);
				rs = pstmt.executeQuery();
				while(rs.next())
				{

					isDetailExist = true;
					String custType = checkNull(rs.getString("STRG_TYPE"));
					String dcrGroup = checkNull(rs.getString("DCR_GROUP")); // modified by rupali on 21/12/18 for dcr_group related changes
					// modified by rupali on 21/12/18 for dcr_group related changes
					//if("D".equalsIgnoreCase(custType))
					
					//BY PRACHI ON 13JUNE2022 ID:W22CSUN019
					String descr="";
					if ( itemUsageMap.get( (rs.getString("ITEM_USAGE")).trim()) != null )
					{
						descr=itemUsageMap.get((rs.getString("ITEM_USAGE")).trim());
						System.out.println("descr is::["+descr+"]");
					}
					//end
					
					if("D".equalsIgnoreCase(dcrGroup))
					{
						valueXmlString.append("<doctorsampleitem"+analysisID+">\r\n");
						valueXmlString.append("<item_rowNum>").append("<![CDATA[").append(rs.getString("ROWNUM") == null ? "" : rs.getString("ROWNUM")).append("]]>").append("</item_rowNum>\r\n ");
						valueXmlString.append("<cust_name>").append("<![CDATA[").append(rs.getString("STRG_TYPE") == null ? "" : rs.getString("STRG_TYPE")).append("]]>").append("</cust_name>\r\n ");
						valueXmlString.append("<quantity>").append("<![CDATA[").append(rs.getString("QUANTITY") == null ? "" : rs.getString("QUANTITY")).append("]]>").append("</quantity>\r\n ");
						valueXmlString.append("<item_descr>").append("<![CDATA[").append(rs.getString("DESCR") == null ? "" : rs.getString("DESCR")).append("]]>").append("</item_descr>\r\n ");
						valueXmlString.append("<item_usage>").append("<![CDATA[").append(descr).append("]]>").append("</item_usage>\r\n ");
						valueXmlString.append("<strg_code>").append("<![CDATA[").append(checkNull(rs.getString("STRG_CODE"))).append("]]>").append("</strg_code>\r\n ");//Added by mrunalini sinkar
						//valueXmlString.append("<item_pob>").append("<![CDATA[").append(rs.getString("POB") == null ? "" : rs.getString("POB")).append("]]>").append("</item_pob>\r\n ");
			            valueXmlString.append("<sales_pers_docitem><![CDATA[" ).append(salesPers).append( "]]></sales_pers_docitem>\r\n");
						valueXmlString.append("</doctorsampleitem"+analysisID+">\r\n");
					}
					// modified by rupali on 21/12/18 for dcr_group related changes
					//else if ("C".equalsIgnoreCase(custType))
					else if ("C".equalsIgnoreCase(dcrGroup))
					{
						valueXmlString.append("<retailersampleitem"+analysisID+">\r\n");
						valueXmlString.append("<item_rowNum>").append("<![CDATA[").append(rs.getString("ROWNUM") == null ? "" : rs.getString("ROWNUM")).append("]]>").append("</item_rowNum>\r\n ");
						valueXmlString.append("<cust_name>").append("<![CDATA[").append(rs.getString("STRG_TYPE") == null ? "" : rs.getString("STRG_TYPE")).append("]]>").append("</cust_name>\r\n ");
						valueXmlString.append("<quantity>").append("<![CDATA[").append(rs.getString("QUANTITY") == null ? "" : rs.getString("QUANTITY")).append("]]>").append("</quantity>\r\n ");
						valueXmlString.append("<item_descr>").append("<![CDATA[").append(rs.getString("DESCR") == null ? "" : rs.getString("DESCR")).append("]]>").append("</item_descr>\r\n ");
						valueXmlString.append("<item_usage>").append("<![CDATA[").append(descr).append("]]>").append("</item_usage>\r\n ");
						valueXmlString.append("<strg_code>").append("<![CDATA[").append(checkNull(rs.getString("STRG_CODE"))).append("]]>").append("</strg_code>\r\n ");//Added by mrunalini sinkar
			            valueXmlString.append("<sales_pers_docitem><![CDATA[" ).append(salesPers).append( "]]></sales_pers_docitem>\r\n");

						//valueXmlString.append("<item_pob>").append("<![CDATA[").append(rs.getString("POB") == null ? "" : rs.getString("POB")).append("]]>").append("</item_pob>\r\n ");
						valueXmlString.append("</retailersampleitem"+analysisID+">\r\n");

					}
					// modified by rupali on 21/12/18 for dcr_group related changes
					//else if ("S".equalsIgnoreCase(custType))
					else if ("S".equalsIgnoreCase(dcrGroup))
					{
						valueXmlString.append("<stockistsampleitem"+analysisID+">\r\n");
						valueXmlString.append("<item_rowNum>").append("<![CDATA[").append(rs.getString("ROWNUM") == null ? "" : rs.getString("ROWNUM")).append("]]>").append("</item_rowNum>\r\n ");
						valueXmlString.append("<cust_name>").append("<![CDATA[").append(rs.getString("STRG_TYPE") == null ? "" : rs.getString("STRG_TYPE")).append("]]>").append("</cust_name>\r\n ");
						valueXmlString.append("<quantity>").append("<![CDATA[").append(rs.getString("QUANTITY") == null ? "" : rs.getString("QUANTITY")).append("]]>").append("</quantity>\r\n ");
						valueXmlString.append("<item_descr>").append("<![CDATA[").append(rs.getString("DESCR") == null ? "" : rs.getString("DESCR")).append("]]>").append("</item_descr>\r\n ");
						valueXmlString.append("<item_usage>").append("<![CDATA[").append(descr).append("]]>").append("</item_usage>\r\n ");
						valueXmlString.append("<strg_code>").append("<![CDATA[").append(checkNull(rs.getString("STRG_CODE"))).append("]]>").append("</strg_code>\r\n ");//Added by mrunalini sinkar
			            valueXmlString.append("<sales_pers_docitem><![CDATA[" ).append(salesPers).append( "]]></sales_pers_docitem>\r\n");

						valueXmlString.append("</stockistsampleitem"+analysisID+">\r\n");

					}
					// modified by rupali on 21/12/18 for dcr_group related changes
					//else if ("O".equalsIgnoreCase(custType))
					else if ("O".equalsIgnoreCase(dcrGroup))
					{
						valueXmlString.append("<NCWsampleitem"+analysisID+">\r\n");
						valueXmlString.append("<item_rowNum>").append("<![CDATA[").append(rs.getString("ROWNUM") == null ? "" : rs.getString("ROWNUM")).append("]]>").append("</item_rowNum>\r\n ");
						valueXmlString.append("<cust_name>").append("<![CDATA[").append(rs.getString("STRG_TYPE") == null ? "" : rs.getString("STRG_TYPE")).append("]]>").append("</cust_name>\r\n ");
						valueXmlString.append("<quantity>").append("<![CDATA[").append(rs.getString("QUANTITY") == null ? "" : rs.getString("QUANTITY")).append("]]>").append("</quantity>\r\n ");
						valueXmlString.append("<item_descr>").append("<![CDATA[").append(rs.getString("DESCR") == null ? "" : rs.getString("DESCR")).append("]]>").append("</item_descr>\r\n ");
						valueXmlString.append("<item_usage>").append("<![CDATA[").append(descr).append("]]>").append("</item_usage>\r\n ");
						valueXmlString.append("<strg_code>").append("<![CDATA[").append(checkNull(rs.getString("STRG_CODE"))).append("]]>").append("</strg_code>\r\n ");//Added by mrunalini sinkar
			            valueXmlString.append("<sales_pers_docitem><![CDATA[" ).append(salesPers).append( "]]></sales_pers_docitem>\r\n");

						valueXmlString.append("</NCWsampleitem"+analysisID+">\r\n");
					}
					
				}
				
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
				// modified by rupali on 21/12/18 for dcr_group related changes
				/*String brandSql = "SELECT DISTINCT SBP.SC_CODE, SC.FIRST_NAME||' '||SC.LAST_NAME AS CUST_NAME, SC.CUST_TYPE, SBP.BRAND_DESCR, SBP.BRAND_CODE , " +
						"SBP.PITCH_SEQUENCE , BR.PITCH_PRIORITY " +
						"FROM STRG_BRAND_PITCH SBP , STRG_CUSTOMER SC,  BRAND BR   " +
						"WHERE  SBP.SC_CODE = SC.SC_CODE AND SBP.BRAND_CODE = BR.BRAND_CODE " +
						"AND SBP.DCR_ID= ? ";*/
				//Added By Mrunalini Sinkar For Fortune Server 20-May-2020(Stat)
				/*				String brandSql = "SELECT DISTINCT STRG_MEET.STRG_NAME AS CUST_NAME,STRG_MEET.STRG_TYPE AS CUST_TYPE,SBP.BRAND_DESCR, SBP.BRAND_CODE, "+
						"SBP.PITCH_SEQUENCE , BR.PITCH_PRIORITY, SCT.DCR_GROUP,STRG_MEET.STRG_CODE "+
						"FROM STRG_BRAND_PITCH SBP , STRG_MEET ,  BRAND BR, STRG_CUST_TYPE SCT "+    
						"WHERE  SBP.SC_CODE = STRG_MEET.STRG_CODE AND SBP.DCR_ID = STRG_MEET.DCR_ID AND SBP.BRAND_CODE = BR.BRAND_CODE "+
						"AND SBP.DCR_ID= ? AND STRG_MEET.SALES_PERS=? AND STRG_MEET.EVENT_DATE=? AND STRG_MEET.STRG_TYPE = SCT.TYPE ";*/
				String brandSql = "SELECT DISTINCT STRG_MEET.STRG_NAME AS CUST_NAME,STRG_MEET.STRG_TYPE AS CUST_TYPE,SBP.BRAND_DESCR, SBP.BRAND_CODE, "+
						"SBP.PITCH_SEQUENCE , BR.PITCH_PRIORITY, SCT.DCR_GROUP,STRG_MEET.STRG_CODE,SBP.PITCH_DETAIL "+
						"FROM STRG_BRAND_PITCH SBP , STRG_MEET ,  BRAND BR, STRG_CUST_TYPE SCT "+    
						"WHERE  SBP.SC_CODE = STRG_MEET.STRG_CODE AND SBP.DCR_ID = STRG_MEET.DCR_ID AND SBP.BRAND_CODE = BR.BRAND_CODE "+
						"AND SBP.DCR_ID= ? AND STRG_MEET.SALES_PERS=? AND STRG_MEET.EVENT_DATE=? AND STRG_MEET.STRG_TYPE = SCT.TYPE ";
				//Added By Mrunalini Sinkar For Fortune Server 20-May-2020(End)
				
				pstmt = conn.prepareStatement(brandSql);
				pstmt.setString(1, dcrId);
				pstmt.setString(2, salesPers);
				pstmt.setTimestamp( 3, java.sql.Timestamp.valueOf( eventDateDBFmt ) );
				rs = pstmt.executeQuery();
				while(rs.next())
				{

					String pithdetailDescr="";
					isDetailExist = true;
					String custType = checkNull(rs.getString("CUST_TYPE"));
					String dcrGroup = checkNull(rs.getString("DCR_GROUP")); // modified by rupali on 21/12/18 for dcr_group related changes
					// modified by rupali on 21/12/18 for dcr_group related changes
					//if("D".equalsIgnoreCase(custType))
					//Added By Mrunalini Sinkar For Fortune Server 20-May-2020(Start)
					String pitchDetail=checkNull(rs.getString("PITCH_DETAIL"));

					sql = "SELECT FLD_VALUE AS PITCH_DETAIL, DESCR AS PITCH_DETAIL_DESCR FROM GENCODES WHERE FLD_NAME = 'PITCH_DETAIL' AND MOD_NAME = 'W_WSFA_FORTUNE' "
							+ "AND ACTIVE = 'Y' AND  FLD_VALUE=?";
					PreparedStatement pstmt1 = conn.prepareStatement(sql);
					pstmt1.setString(1,pitchDetail);
					ResultSet rs1 = pstmt1.executeQuery();
					if(rs1.next())
					{
						pithdetailDescr = checkNull(rs1.getString("PITCH_DETAIL_DESCR"));

					}
					if (rs1 != null)
					{
						rs1.close();
						rs1 = null;
					}
					if (pstmt1 != null)
					{
						pstmt1.close();
						pstmt1 = null;
					}

					//Added By Mrunalini Sinkar For Fortune Server 20-May-2020(End)
					if("D".equalsIgnoreCase(dcrGroup))
					{
						valueXmlString.append("<brand"+analysisID+">\r\n");
						valueXmlString.append("<brand_descr>").append("<![CDATA[").append(rs.getString("BRAND_DESCR") == null ? "" : rs.getString("BRAND_DESCR")).append("]]>").append("</brand_descr>\r\n ");
						valueXmlString.append("<cust_name>").append("<![CDATA[").append(rs.getString("CUST_NAME") == null ? "" : rs.getString("CUST_NAME")).append("]]>").append("</cust_name>\r\n ");
						valueXmlString.append("<pitch_priority>").append("<![CDATA[").append(rs.getString("PITCH_PRIORITY") == null ? "" : rs.getString("PITCH_PRIORITY")).append("]]>").append("</pitch_priority>\r\n ");
						valueXmlString.append("<pitch_sequence>").append("<![CDATA[").append(rs.getString("PITCH_SEQUENCE") == null ? "" : rs.getString("PITCH_SEQUENCE")).append("]]>").append("</pitch_sequence>\r\n ");
						valueXmlString.append("<brand_code>").append("<![CDATA[").append(rs.getString("BRAND_CODE") == null ? "" : rs.getString("BRAND_CODE")).append("]]>").append("</brand_code>\r\n ");
						valueXmlString.append("<strg_code>").append("<![CDATA[").append(checkNull(rs.getString("STRG_CODE"))).append("]]>").append("</strg_code>\r\n ");//Added by mrunalini sinkar
						valueXmlString.append("<pitch_detail_descr>").append("<![CDATA[").append(pithdetailDescr).append("]]>").append("</pitch_detail_descr>\r\n ");
			            valueXmlString.append("<sales_pers_brand><![CDATA[" ).append(salesPers).append( "]]></sales_pers_brand>\r\n");

						valueXmlString.append("</brand"+analysisID+">\r\n");
					}
					// modified by rupali on 21/12/18 for dcr_group related changes
					//else if ("C".equalsIgnoreCase(custType))
					else if ("C".equalsIgnoreCase(dcrGroup))
					{
						valueXmlString.append("<retailerbrand"+analysisID+">\r\n");
						valueXmlString.append("<brand_descr>").append("<![CDATA[").append(rs.getString("BRAND_DESCR") == null ? "" : rs.getString("BRAND_DESCR")).append("]]>").append("</brand_descr>\r\n ");
						valueXmlString.append("<cust_name>").append("<![CDATA[").append(rs.getString("CUST_NAME") == null ? "" : rs.getString("CUST_NAME")).append("]]>").append("</cust_name>\r\n ");
						valueXmlString.append("<pitch_priority>").append("<![CDATA[").append(rs.getString("PITCH_PRIORITY") == null ? "" : rs.getString("PITCH_PRIORITY")).append("]]>").append("</pitch_priority>\r\n ");
						valueXmlString.append("<pitch_sequence>").append("<![CDATA[").append(rs.getString("PITCH_SEQUENCE") == null ? "" : rs.getString("PITCH_SEQUENCE")).append("]]>").append("</pitch_sequence>\r\n ");
						valueXmlString.append("<brand_code>").append("<![CDATA[").append(rs.getString("BRAND_CODE") == null ? "" : rs.getString("BRAND_CODE")).append("]]>").append("</brand_code>\r\n ");
						valueXmlString.append("<strg_code>").append("<![CDATA[").append(checkNull(rs.getString("STRG_CODE"))).append("]]>").append("</strg_code>\r\n ");//Added by mrunalini sinkar
						valueXmlString.append("<pitch_detail_descr>").append("<![CDATA[").append(pithdetailDescr).append("]]>").append("</pitch_detail_descr>\r\n ");
			            valueXmlString.append("<sales_pers_brand><![CDATA[" ).append(salesPers).append( "]]></sales_pers_brand>\r\n");

						valueXmlString.append("</retailerbrand"+analysisID+">\r\n");

					}
					// modified by rupali on 21/12/18 for dcr_group related changes
					//else if("S".equalsIgnoreCase(custType))
					else if("S".equalsIgnoreCase(dcrGroup))
					{
						valueXmlString.append("<Stockistbrand"+analysisID+">\r\n");
						valueXmlString.append("<brand_descr>").append("<![CDATA[").append(rs.getString("BRAND_DESCR") == null ? "" : rs.getString("BRAND_DESCR")).append("]]>").append("</brand_descr>\r\n ");
						valueXmlString.append("<cust_name>").append("<![CDATA[").append(rs.getString("CUST_NAME") == null ? "" : rs.getString("CUST_NAME")).append("]]>").append("</cust_name>\r\n ");
						valueXmlString.append("<pitch_priority>").append("<![CDATA[").append(rs.getString("PITCH_PRIORITY") == null ? "" : rs.getString("PITCH_PRIORITY")).append("]]>").append("</pitch_priority>\r\n ");
						valueXmlString.append("<pitch_sequence>").append("<![CDATA[").append(rs.getString("PITCH_SEQUENCE") == null ? "" : rs.getString("PITCH_SEQUENCE")).append("]]>").append("</pitch_sequence>\r\n ");
						valueXmlString.append("<brand_code>").append("<![CDATA[").append(rs.getString("BRAND_CODE") == null ? "" : rs.getString("BRAND_CODE")).append("]]>").append("</brand_code>\r\n ");
						valueXmlString.append("<strg_code>").append("<![CDATA[").append(checkNull(rs.getString("STRG_CODE"))).append("]]>").append("</strg_code>\r\n ");//Added by mrunalini sinkar
						valueXmlString.append("<pitch_detail_descr>").append("<![CDATA[").append(pithdetailDescr).append("]]>").append("</pitch_detail_descr>\r\n ");
			            valueXmlString.append("<sales_pers_brand><![CDATA[" ).append(salesPers).append( "]]></sales_pers_brand>\r\n");

						valueXmlString.append("</Stockistbrand"+analysisID+">\r\n");
					}
					// modified by rupali on 21/12/18 for dcr_group related changes
					//else if ("O".equalsIgnoreCase(custType))
					else if ("O".equalsIgnoreCase(dcrGroup))
					{
						valueXmlString.append("<Ncwbrand"+analysisID+">\r\n");
						valueXmlString.append("<brand_descr>").append("<![CDATA[").append(rs.getString("BRAND_DESCR") == null ? "" : rs.getString("BRAND_DESCR")).append("]]>").append("</brand_descr>\r\n ");
						valueXmlString.append("<cust_name>").append("<![CDATA[").append(rs.getString("CUST_NAME") == null ? "" : rs.getString("CUST_NAME")).append("]]>").append("</cust_name>\r\n ");
						valueXmlString.append("<pitch_priority>").append("<![CDATA[").append(rs.getString("PITCH_PRIORITY") == null ? "" : rs.getString("PITCH_PRIORITY")).append("]]>").append("</pitch_priority>\r\n ");
						valueXmlString.append("<pitch_sequence>").append("<![CDATA[").append(rs.getString("PITCH_SEQUENCE") == null ? "" : rs.getString("PITCH_SEQUENCE")).append("]]>").append("</pitch_sequence>\r\n ");
						valueXmlString.append("<brand_code>").append("<![CDATA[").append(rs.getString("BRAND_CODE") == null ? "" : rs.getString("BRAND_CODE")).append("]]>").append("</brand_code>\r\n ");
						valueXmlString.append("<strg_code>").append("<![CDATA[").append(checkNull(rs.getString("STRG_CODE"))).append("]]>").append("</strg_code>\r\n ");//Added by mrunalini sinkar
						valueXmlString.append("<pitch_detail_descr>").append("<![CDATA[").append(pithdetailDescr).append("]]>").append("</pitch_detail_descr>\r\n ");
			            valueXmlString.append("<sales_pers_brand><![CDATA[" ).append(salesPers).append( "]]></sales_pers_brand>\r\n");

						valueXmlString.append("</Ncwbrand"+analysisID+">\r\n");
					}
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
				
				/*String displaySql = "SELECT SC.SC_CODE, SC.FIRST_NAME||' '||SC.LAST_NAME AS CUST_NAME, SC.CUST_TYPE,  SD.DISPLAY_AREA, SD.DOC_ID " +
						"FROM STRG_ITEM_DISPLAY SD, STRG_CUSTOMER SC " +
						"WHERE  SD.STRG_CODE = SC.SC_CODE and SD.DCR_ID =  ? ";*/
				String displaySql = "SELECT SD.DISPLAY_AREA, SD.DOC_ID ,STRG_MEET.STRG_TYPE,SCT.DCR_GROUP,STRG_MEET.STRG_CODE " +
						" FROM STRG_ITEM_DISPLAY SD ,STRG_MEET, STRG_CUST_TYPE SCT " +
						" WHERE SD.DCR_ID =  ? "+
						" AND STRG_MEET.EVENT_DATE = ? "+
						" AND STRG_MEET.SALES_PERS = ? "+
						" AND STRG_MEET.STRG_CODE = SD.STRG_CODE AND STRG_MEET.DCR_ID = SD.DCR_ID AND STRG_MEET.STRG_TYPE = SCT.TYPE";
				pstmt = conn.prepareStatement(displaySql);
				pstmt.setString(1, dcrId);
				pstmt.setTimestamp( 2, java.sql.Timestamp.valueOf( eventDateDBFmt ) );
				pstmt.setString(3, salesPers);
				rs = pstmt.executeQuery();
				
				while(rs.next())
				{

					isDetailExist = true;
					String custType = checkNull(rs.getString("STRG_TYPE"));
					String dcrGroup = checkNull(rs.getString("DCR_GROUP")); // modified by rupali on 21/12/18 for dcr_group related changes
					// modified by rupali on 21/12/18 for dcr_group related changes
					//if("D".equalsIgnoreCase(custType))
					if("D".equalsIgnoreCase(dcrGroup))
					{
						valueXmlString.append("<display"+analysisID+">\r\n");
						valueXmlString.append("<display_area>").append("<![CDATA[").append(rs.getString("DISPLAY_AREA") == null ? "" : rs.getString("DISPLAY_AREA")).append("]]>").append("</display_area>\r\n ");
						valueXmlString.append("<cust_name>").append("<![CDATA[").append(rs.getString("STRG_TYPE") == null ? "" : rs.getString("STRG_TYPE")).append("]]>").append("</cust_name>\r\n ");
						valueXmlString.append("<doc_id>").append("<![CDATA[").append(rs.getString("DOC_ID") == null ? "" : rs.getString("DOC_ID")).append("]]>").append("</doc_id>\r\n ");
						valueXmlString.append("<strg_code>").append("<![CDATA[").append(checkNull(rs.getString("STRG_CODE"))).append("]]>").append("</strg_code>\r\n ");//Added by mrunalini sinkar
			            valueXmlString.append("<sales_pers_display><![CDATA[" ).append(salesPers).append( "]]></sales_pers_display>\r\n");

						valueXmlString.append("</display"+analysisID+">\r\n");
					}
					// modified by rupali on 21/12/18 for dcr_group related changes
					//else if ("C".equalsIgnoreCase(custType))
					else if ("C".equalsIgnoreCase(dcrGroup))
					{
						valueXmlString.append("<retailerdisplay"+analysisID+">\r\n");
						valueXmlString.append("<display_area>").append("<![CDATA[").append(rs.getString("DISPLAY_AREA") == null ? "" : rs.getString("DISPLAY_AREA")).append("]]>").append("</display_area>\r\n ");
						valueXmlString.append("<cust_name>").append("<![CDATA[").append(rs.getString("STRG_TYPE") == null ? "" : rs.getString("STRG_TYPE")).append("]]>").append("</cust_name>\r\n ");
						valueXmlString.append("<doc_id>").append("<![CDATA[").append(rs.getString("DOC_ID") == null ? "" : rs.getString("DOC_ID")).append("]]>").append("</doc_id>\r\n ");
						valueXmlString.append("<strg_code>").append("<![CDATA[").append(checkNull(rs.getString("STRG_CODE"))).append("]]>").append("</strg_code>\r\n ");//Added by mrunalini sinkar
			            valueXmlString.append("<sales_pers_display><![CDATA[" ).append(salesPers).append( "]]></sales_pers_display>\r\n");

						valueXmlString.append("</retailerdisplay"+analysisID+">\r\n");

					}
					// modified by rupali on 21/12/18 for dcr_group related changes
					//else if("S".equalsIgnoreCase(custType))
					else if("S".equalsIgnoreCase(dcrGroup))
					{
						valueXmlString.append("<StockistDisplay"+analysisID+">\r\n");
						valueXmlString.append("<display_area>").append("<![CDATA[").append(rs.getString("DISPLAY_AREA") == null ? "" : rs.getString("DISPLAY_AREA")).append("]]>").append("</display_area>\r\n ");
						valueXmlString.append("<cust_name>").append("<![CDATA[").append(rs.getString("STRG_TYPE") == null ? "" : rs.getString("STRG_TYPE")).append("]]>").append("</cust_name>\r\n ");
						valueXmlString.append("<doc_id>").append("<![CDATA[").append(rs.getString("DOC_ID") == null ? "" : rs.getString("DOC_ID")).append("]]>").append("</doc_id>\r\n ");
						valueXmlString.append("<strg_code>").append("<![CDATA[").append(checkNull(rs.getString("STRG_CODE"))).append("]]>").append("</strg_code>\r\n ");//Added by mrunalini sinkar
			            valueXmlString.append("<sales_pers_display><![CDATA[" ).append(salesPers).append( "]]></sales_pers_display>\r\n");

						valueXmlString.append("</StockistDisplay"+analysisID+">\r\n");
					}
					// modified by rupali on 21/12/18 for dcr_group related changes
					//else if("O".equalsIgnoreCase(custType))
					else if("O".equalsIgnoreCase(dcrGroup))
					{
						valueXmlString.append("<NcwDisplay"+analysisID+">\r\n");
						valueXmlString.append("<display_area>").append("<![CDATA[").append(rs.getString("DISPLAY_AREA") == null ? "" : rs.getString("DISPLAY_AREA")).append("]]>").append("</display_area>\r\n ");
						valueXmlString.append("<cust_name>").append("<![CDATA[").append(rs.getString("STRG_TYPE") == null ? "" : rs.getString("STRG_TYPE")).append("]]>").append("</cust_name>\r\n ");
						valueXmlString.append("<doc_id>").append("<![CDATA[").append(rs.getString("DOC_ID") == null ? "" : rs.getString("DOC_ID")).append("]]>").append("</doc_id>\r\n ");
						valueXmlString.append("<strg_code>").append("<![CDATA[").append(checkNull(rs.getString("STRG_CODE"))).append("]]>").append("</strg_code>\r\n ");//Added by mrunalini sinkar
			            valueXmlString.append("<sales_pers_display><![CDATA[" ).append(salesPers).append( "]]></sales_pers_display>\r\n");
						valueXmlString.append("</NcwDisplay"+analysisID+">\r\n");
					}
				
				}
				
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
				//Added By Prathmesh Jangam on 07-07-2017 for DB2 changes(start) 

				String teamSql = "SELECT DISTINCT SMT.STRG_CODE STRG_CODE, SMT.DCR_ID DCR_ID,STRG_MEET.STRG_TYPE, " +
						"D.DESIGNATION DESIGNATION, SP.SP_NAME SP_NAME , SMT.SALES_PERS SALES_PERS , SMT.DESIGN_CODE DESIGN_CODE , SCT.DCR_GROUP  " +
						" FROM STRG_MEET_TEAM SMT, DESIGNATION D, SALES_PERS SP , STRG_MEET , STRG_CUST_TYPE SCT " +
						" WHERE SMT.DESIGN_CODE = D.DESIGN_CODE   AND SP.SALES_PERS = SMT.SALES_PERS  " +
						" AND SMT.DCR_ID = ? "+ 
						" AND STRG_MEET.EVENT_DATE= ? "+
						" AND STRG_MEET.SALES_PERS = ?"+
						" AND STRG_MEET.STRG_CODE=SMT.STRG_CODE AND STRG_MEET.DCR_ID=SMT.DCR_ID AND STRG_MEET.STRG_TYPE = SCT.TYPE";
				//Added By Prathmesh Jangam on 07-07-2017 for DB2 changes(end) 

				pstmt = conn.prepareStatement(teamSql);
				pstmt.setString(1, dcrId);
				pstmt.setTimestamp( 2, java.sql.Timestamp.valueOf( eventDateDBFmt ) );
				pstmt.setString(3, salesPers);
				rs = pstmt.executeQuery();
				while(rs.next())
				{

					isDetailExist = true;
					String custType = checkNull(rs.getString("STRG_TYPE"));
					// modified by rupali on 21/12/18 for dcr_group related changes
					String dcrGroup = checkNull(rs.getString("DCR_GROUP"));
					//if("D".equalsIgnoreCase(custType))
					if("D".equalsIgnoreCase(dcrGroup))
					{
						valueXmlString.append("<team"+analysisID+">\r\n");
						valueXmlString.append("<sales_pers>").append("<![CDATA[").append(rs.getString("SALES_PERS") == null ? "" : rs.getString("SALES_PERS")).append("]]>").append("</sales_pers>\r\n ");
						valueXmlString.append("<cust_name>").append("<![CDATA[").append(rs.getString("STRG_TYPE") == null ? "" : rs.getString("STRG_TYPE")).append("]]>").append("</cust_name>\r\n ");
						valueXmlString.append("<sp_name>").append("<![CDATA[").append(rs.getString("SP_NAME") == null ? "" : rs.getString("SP_NAME")).append("]]>").append("</sp_name>\r\n ");
						valueXmlString.append("<designation>").append("<![CDATA[").append(rs.getString("DESIGNATION") == null ? "" : rs.getString("DESIGNATION")).append("]]>").append("</designation>\r\n ");
						valueXmlString.append("<design_code>").append("<![CDATA[").append(rs.getString("DESIGN_CODE") == null ? "" : rs.getString("DESIGN_CODE")).append("]]>").append("</design_code>\r\n ");
			            valueXmlString.append("<sales_pers_team><![CDATA[" ).append(salesPers).append( "]]></sales_pers_team>\r\n");
						valueXmlString.append("</team"+analysisID+">\r\n");
					}
					// modified by rupali on 21/12/18 for dcr_group related changes
					//else if ("C".equalsIgnoreCase(custType))
					else if ("C".equalsIgnoreCase(dcrGroup))
					{
						valueXmlString.append("<retailerteam"+analysisID+">\r\n");
						valueXmlString.append("<sales_pers>").append("<![CDATA[").append(rs.getString("SALES_PERS") == null ? "" : rs.getString("SALES_PERS")).append("]]>").append("</sales_pers>\r\n ");
						valueXmlString.append("<cust_name>").append("<![CDATA[").append(rs.getString("STRG_TYPE") == null ? "" : rs.getString("STRG_TYPE")).append("]]>").append("</cust_name>\r\n ");
						valueXmlString.append("<sp_name>").append("<![CDATA[").append(rs.getString("SP_NAME") == null ? "" : rs.getString("SP_NAME")).append("]]>").append("</sp_name>\r\n ");
						valueXmlString.append("<designation>").append("<![CDATA[").append(rs.getString("DESIGNATION") == null ? "" : rs.getString("DESIGNATION")).append("]]>").append("</designation>\r\n ");
						valueXmlString.append("<design_code>").append("<![CDATA[").append(rs.getString("DESIGN_CODE") == null ? "" : rs.getString("DESIGN_CODE")).append("]]>").append("</design_code>\r\n ");
			            valueXmlString.append("<sales_pers_team><![CDATA[" ).append(salesPers).append( "]]></sales_pers_team>\r\n");
						valueXmlString.append("</retailerteam"+analysisID+">\r\n");

					}
					//added by mrunalini sinkar on 02-may-2017 to show ncw and stockist team data on confirm and delete report (start)
					// modified by rupali on 21/12/18 for dcr_group related changes
					//else if ("S".equalsIgnoreCase(custType))
					else if ("S".equalsIgnoreCase(dcrGroup))
					{
						valueXmlString.append("<StockistTeam"+analysisID+">\r\n");
						valueXmlString.append("<sales_pers>").append("<![CDATA[").append(rs.getString("SALES_PERS") == null ? "" : rs.getString("SALES_PERS")).append("]]>").append("</sales_pers>\r\n ");
						valueXmlString.append("<cust_name>").append("<![CDATA[").append(rs.getString("STRG_TYPE") == null ? "" : rs.getString("STRG_TYPE")).append("]]>").append("</cust_name>\r\n ");
						valueXmlString.append("<sp_name>").append("<![CDATA[").append(rs.getString("SP_NAME") == null ? "" : rs.getString("SP_NAME")).append("]]>").append("</sp_name>\r\n ");
						valueXmlString.append("<designation>").append("<![CDATA[").append(rs.getString("DESIGNATION") == null ? "" : rs.getString("DESIGNATION")).append("]]>").append("</designation>\r\n ");
						valueXmlString.append("<design_code>").append("<![CDATA[").append(rs.getString("DESIGN_CODE") == null ? "" : rs.getString("DESIGN_CODE")).append("]]>").append("</design_code>\r\n ");
			            valueXmlString.append("<sales_pers_team><![CDATA[" ).append(salesPers).append( "]]></sales_pers_team>\r\n");
						valueXmlString.append("</StockistTeam"+analysisID+">\r\n");

					}
					// modified by rupali on 21/12/18 for dcr_group related changes
					//else if ("O".equalsIgnoreCase(custType))
					else if ("O".equalsIgnoreCase(dcrGroup))
					{
						valueXmlString.append("<NcwTeam"+analysisID+">\r\n");
						valueXmlString.append("<sales_pers>").append("<![CDATA[").append(rs.getString("SALES_PERS") == null ? "" : rs.getString("SALES_PERS")).append("]]>").append("</sales_pers>\r\n ");
						valueXmlString.append("<cust_name>").append("<![CDATA[").append(rs.getString("STRG_TYPE") == null ? "" : rs.getString("STRG_TYPE")).append("]]>").append("</cust_name>\r\n ");
						valueXmlString.append("<sp_name>").append("<![CDATA[").append(rs.getString("SP_NAME") == null ? "" : rs.getString("SP_NAME")).append("]]>").append("</sp_name>\r\n ");
						valueXmlString.append("<designation>").append("<![CDATA[").append(rs.getString("DESIGNATION") == null ? "" : rs.getString("DESIGNATION")).append("]]>").append("</designation>\r\n ");
						valueXmlString.append("<design_code>").append("<![CDATA[").append(rs.getString("DESIGN_CODE") == null ? "" : rs.getString("DESIGN_CODE")).append("]]>").append("</design_code>\r\n ");
			            valueXmlString.append("<sales_pers_team><![CDATA[" ).append(salesPers).append( "]]></sales_pers_team>\r\n");
						valueXmlString.append("</NcwTeam"+analysisID+">\r\n");

					}
					//added by mrunalini sinkar on 02-may-2017 to show ncw team data on confirm and delete report (end)

				}
				
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;	
				
				// added by rupali on 11/09117 for survey form [start]
				// commented and added by rupali on 17/10/17 for making DB2 compatible [start]
				/*String surveySql= "SELECT ROWNUM,DESCR, STRG_TYPE FROM "+
						" (SELECT SB.ITEM_CODE ITEM_CODE,ITEM.DESCR DESCR, STRG_MEET.STRG_TYPE "+
						" FROM STRG_MEET,STRG_BRAND_SURVEY SB "+
						" JOIN ITEM ITEM ON SB.ITEM_CODE = ITEM.ITEM_CODE "+
						" WHERE SB.DCR_ID= ? "+
						" AND STRG_MEET.EVENT_DATE = ? "+
						" AND STRG_MEET.SALES_PERS = ? "+
						" AND STRG_MEET.STRG_CODE=SB.STRG_CODE) ";*/
				String surveySql = "";
				if("ORACLE".equalsIgnoreCase(CommonConstants.DB_NAME))
				{
					surveySql= "SELECT ROWNUM,DESCR, STRG_TYPE, DCR_GROUP,STRG_CODE FROM "+
						" (SELECT SB.ITEM_CODE ITEM_CODE,ITEM.DESCR DESCR, STRG_MEET.STRG_TYPE, SCT.DCR_GROUP,STRG_MEET.STRG_CODE "+
						" FROM STRG_MEET,STRG_BRAND_SURVEY SB "+
						" JOIN ITEM ITEM ON SB.ITEM_CODE = ITEM.ITEM_CODE, STRG_CUST_TYPE SCT "+
						" WHERE SB.DCR_ID= ? "+
						" AND STRG_MEET.EVENT_DATE = ? "+
						" AND STRG_MEET.SALES_PERS = ? "+
						" AND STRG_MEET.STRG_CODE=SB.STRG_CODE AND STRG_MEET.DCR_ID=SB.DCR_ID AND STRG_MEET.STRG_TYPE = SCT.TYPE) ";
				}
				else if("DB2".equalsIgnoreCase(CommonConstants.DB_NAME))
				{
					surveySql= "SELECT SB.ITEM_CODE ITEM_CODE,ITEM.DESCR DESCR, STRG_MEET.STRG_TYPE, ROW_NUMBER() OVER () ROWNUM, SCT.DCR_GROUP,STRG_MEET.STRG_CODE "+
							" FROM STRG_MEET,STRG_BRAND_SURVEY SB "+
							" JOIN ITEM ITEM ON SB.ITEM_CODE = ITEM.ITEM_CODE, STRG_CUST_TYPE SCT "+
							" WHERE SB.DCR_ID= ? "+
							" AND STRG_MEET.EVENT_DATE = ? "+
							" AND STRG_MEET.SALES_PERS = ? "+
							" AND STRG_MEET.STRG_CODE=SB.STRG_CODE AND STRG_MEET.DCR_ID=SB.DCR_ID AND STRG_MEET.STRG_TYPE = SCT.TYPE ";
				}
				// commented and added by rupali on 17/10/17 for making DB2 compatible [end]    
			    pstmt = conn.prepareStatement(surveySql);
				pstmt.setString(1, dcrId);
				pstmt.setTimestamp( 2, java.sql.Timestamp.valueOf( eventDateDBFmt ) );
				pstmt.setString(3, salesPers);
				rs = pstmt.executeQuery();
				while(rs.next())
				{

					isDetailExist = true;
					String custType = checkNull(rs.getString("STRG_TYPE"));
					String dcrGroup = checkNull(rs.getString("DCR_GROUP")); // modified by rupali on 21/12/18 for dcr_group related changes
					// modified by rupali on 21/12/18 for dcr_group related changes
					//if("D".equalsIgnoreCase(custType))
					if("D".equalsIgnoreCase(dcrGroup))
					{
						valueXmlString.append("<surveybrand"+analysisID+">\r\n");
						valueXmlString.append("<item_rowNum>").append("<![CDATA[").append(rs.getString("ROWNUM") == null ? "" : rs.getString("ROWNUM")).append("]]>").append("</item_rowNum>\r\n ");
						valueXmlString.append("<cust_name>").append("<![CDATA[").append(rs.getString("STRG_TYPE") == null ? "" : rs.getString("STRG_TYPE")).append("]]>").append("</cust_name>\r\n ");
						valueXmlString.append("<item_descr>").append("<![CDATA[").append(rs.getString("DESCR") == null ? "" : rs.getString("DESCR")).append("]]>").append("</item_descr>\r\n ");
						//valueXmlString.append("<item_pob>").append("<![CDATA[").append(rs.getString("POB") == null ? "" : rs.getString("POB")).append("]]>").append("</item_pob>\r\n ");
						valueXmlString.append("<strg_code>").append("<![CDATA[").append(checkNull(rs.getString("STRG_CODE"))).append("]]>").append("</strg_code>\r\n ");//Added by mrunalini sinkar
			            valueXmlString.append("<sales_pers_surveybrand><![CDATA[" ).append(salesPers).append( "]]></sales_pers_surveybrand>\r\n");
						valueXmlString.append("</surveybrand"+analysisID+">\r\n");
					}
					
				}
				
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
				// added by rupali on 11/09117 for survey form [end]

				// added by rupali on 21/09/18 for survey form [start]
				String surveyFormSql = "";
				if("ORACLE".equalsIgnoreCase(CommonConstants.DB_NAME))
				{
					surveyFormSql= "SELECT ROWNUM,DESCR, STRG_TYPE, RESULT, RESULT_TYPE, DCR_GROUP,STRG_CODE FROM (SELECT SR.SURVEY_CODE SURVEY_CODE, " +
								   "SM.DESCR DESCR, STRG_MEET.STRG_TYPE, SR.RESULT, SM.RESULT_TYPE, SCT.DCR_GROUP,STRG_MEET.STRG_CODE "+
								   "FROM STRG_MEET,STRG_SURV_RES SR JOIN SURVEY_MASTER SM ON SR.SURVEY_CODE = SM.SURVEY_CODE, STRG_CUST_TYPE SCT  "+
								   "WHERE SR.DCR_ID= ? "+
								   "AND STRG_MEET.EVENT_DATE = ? "+
								   "AND STRG_MEET.SALES_PERS = ? "+
								   "AND STRG_MEET.STRG_CODE=SR.STRG_CODE AND STRG_MEET.DCR_ID=SR.DCR_ID AND STRG_MEET.STRG_TYPE = SCT.TYPE)";
				}
				else if("DB2".equalsIgnoreCase(CommonConstants.DB_NAME))
				{
					surveyFormSql= "SELECT SR.SURVEY_CODE SURVEY_CODE, SM.DESCR DESCR, STRG_MEET.STRG_TYPE, SM.RESULT, " +
							"SM.RESULT_TYPE, ROW_NUMBER() OVER () ROWNUM, SCT.DCR_GROUP,STRG_MEET.STRG_CODE "+
							" FROM STRG_MEET,STRG_SURV_RES SR "+
							" JOIN SURVEY_MASTER SM ON SR.SURVEY_CODE = SM.SURVEY_CODE, STRG_CUST_TYPE SCT "+
							" WHERE SR.DCR_ID= ? "+
							" AND STRG_MEET.EVENT_DATE = ? "+
							" AND STRG_MEET.SALES_PERS = ? "+
							" AND STRG_MEET.STRG_CODE=SR.STRG_CODE AND STRG_MEET.DCR_ID=SR.DCR_ID AND STRG_MEET.STRG_TYPE = SCT.TYPE ";
				}
			    pstmt = conn.prepareStatement(surveyFormSql);
				pstmt.setString(1, dcrId);
				pstmt.setTimestamp( 2, java.sql.Timestamp.valueOf( eventDateDBFmt ) );
				pstmt.setString(3, salesPers);
				rs = pstmt.executeQuery();
				while(rs.next())
				{

					isDetailExist = true;
					String custType = checkNull(rs.getString("STRG_TYPE"));
					String resultType = checkNull(rs.getString("RESULT_TYPE"));
					String result = checkNull(rs.getString("RESULT"));
					String dcrGroup = checkNull(rs.getString("DCR_GROUP")); // modified by rupali on 21/12/18 for dcr_group related changes

					if("D".equalsIgnoreCase(resultType) || "L".equalsIgnoreCase(resultType))
					{
						if("Y".equalsIgnoreCase(result))
						{
							result = "Yes";
						}
						else
						{
							result = "No";
						}
					}
					// modified by rupali on 21/12/18 for dcr_group related changes
					//if("D".equalsIgnoreCase(custType))
					if("D".equalsIgnoreCase(dcrGroup))
					{
						valueXmlString.append("<survey"+analysisID+">\r\n");
						valueXmlString.append("<survey_rownum>").append("<![CDATA[").append(rs.getString("ROWNUM") == null ? "" : rs.getString("ROWNUM")).append("]]>").append("</survey_rownum>\r\n ");
						valueXmlString.append("<cust_name>").append("<![CDATA[").append(rs.getString("STRG_TYPE") == null ? "" : rs.getString("STRG_TYPE")).append("]]>").append("</cust_name>\r\n ");
						valueXmlString.append("<survey_descr>").append("<![CDATA[").append(rs.getString("DESCR") == null ? "" : rs.getString("DESCR")).append("]]>").append("</survey_descr>\r\n ");
						valueXmlString.append("<survey_result>").append("<![CDATA[").append(result).append("]]>").append("</survey_result>\r\n ");
						valueXmlString.append("<strg_code>").append("<![CDATA[").append(checkNull(rs.getString("STRG_CODE"))).append("]]>").append("</strg_code>\r\n ");//Added by mrunalini sinkar
			            valueXmlString.append("<sales_pers_survey><![CDATA[" ).append(salesPers).append( "]]></sales_pers_survey>\r\n");
						valueXmlString.append("</survey"+analysisID+">\r\n");
					}
					// modified by rupali on 21/12/18 for dcr_group related changes
					//else if ("C".equalsIgnoreCase(custType))
					else if ("C".equalsIgnoreCase(dcrGroup))
					{
						valueXmlString.append("<retailersurvey"+analysisID+">\r\n");
						valueXmlString.append("<survey_rownum>").append("<![CDATA[").append(rs.getString("ROWNUM") == null ? "" : rs.getString("ROWNUM")).append("]]>").append("</survey_rownum>\r\n ");
						valueXmlString.append("<cust_name>").append("<![CDATA[").append(rs.getString("STRG_TYPE") == null ? "" : rs.getString("STRG_TYPE")).append("]]>").append("</cust_name>\r\n ");
						valueXmlString.append("<survey_descr>").append("<![CDATA[").append(rs.getString("DESCR") == null ? "" : rs.getString("DESCR")).append("]]>").append("</survey_descr>\r\n ");
						valueXmlString.append("<survey_result>").append("<![CDATA[").append(result).append("]]>").append("</survey_result>\r\n ");
						valueXmlString.append("<strg_code>").append("<![CDATA[").append(checkNull(rs.getString("STRG_CODE"))).append("]]>").append("</strg_code>\r\n ");//Added by mrunalini sinkar
			            valueXmlString.append("<sales_pers_survey><![CDATA[" ).append(salesPers).append( "]]></sales_pers_survey>\r\n");
						valueXmlString.append("</retailersurvey"+analysisID+">\r\n");

					}
					// modified by rupali on 21/12/18 for dcr_group related changes
					//else if ("S".equalsIgnoreCase(custType))
					else if ("S".equalsIgnoreCase(dcrGroup))
					{
						valueXmlString.append("<stockistsurvey"+analysisID+">\r\n");
						valueXmlString.append("<survey_rownum>").append("<![CDATA[").append(rs.getString("ROWNUM") == null ? "" : rs.getString("ROWNUM")).append("]]>").append("</survey_rownum>\r\n ");
						valueXmlString.append("<cust_name>").append("<![CDATA[").append(rs.getString("STRG_TYPE") == null ? "" : rs.getString("STRG_TYPE")).append("]]>").append("</cust_name>\r\n ");
						valueXmlString.append("<survey_descr>").append("<![CDATA[").append(rs.getString("DESCR") == null ? "" : rs.getString("DESCR")).append("]]>").append("</survey_descr>\r\n ");
						valueXmlString.append("<survey_result>").append("<![CDATA[").append(result).append("]]>").append("</survey_result>\r\n ");
						valueXmlString.append("<strg_code>").append("<![CDATA[").append(checkNull(rs.getString("STRG_CODE"))).append("]]>").append("</strg_code>\r\n ");//Added by mrunalini sinkar
			            valueXmlString.append("<sales_pers_survey><![CDATA[" ).append(salesPers).append( "]]></sales_pers_survey>\r\n");
						valueXmlString.append("</stockistsurvey"+analysisID+">\r\n");

					}
					// modified by rupali on 21/12/18 for dcr_group related changes
					//else if ("O".equalsIgnoreCase(custType))
					else if ("O".equalsIgnoreCase(dcrGroup))
					{
						valueXmlString.append("<ncwsurvey"+analysisID+">\r\n");
						valueXmlString.append("<survey_rownum>").append("<![CDATA[").append(rs.getString("ROWNUM") == null ? "" : rs.getString("ROWNUM")).append("]]>").append("</survey_rownum>\r\n ");
						valueXmlString.append("<cust_name>").append("<![CDATA[").append(rs.getString("STRG_TYPE") == null ? "" : rs.getString("STRG_TYPE")).append("]]>").append("</cust_name>\r\n ");
						valueXmlString.append("<survey_descr>").append("<![CDATA[").append(rs.getString("DESCR") == null ? "" : rs.getString("DESCR")).append("]]>").append("</survey_descr>\r\n ");
						valueXmlString.append("<survey_result>").append("<![CDATA[").append(result).append("]]>").append("</survey_result>\r\n ");
						valueXmlString.append("<strg_code>").append("<![CDATA[").append(checkNull(rs.getString("STRG_CODE"))).append("]]>").append("</strg_code>\r\n ");//Added by mrunalini sinkar
			            valueXmlString.append("<sales_pers_survey><![CDATA[" ).append(salesPers).append( "]]></sales_pers_survey>\r\n");
						valueXmlString.append("</ncwsurvey"+analysisID+">\r\n");

					}
				}
				
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
				// added by rupali on 21/09/18 for survey form [end]
				
				//Getting subordinate details : START
				String workWtithSQL = "SELECT DISTINCT ST.SPRS_CODE__WW,SP.SP_NAME FROM SPRS_TRAVEL ST, SALES_PERS SP WHERE ST.SPRS_CODE__WW = SP.SALES_PERS AND ST.SALES_PERS = ? AND ST.TRAVEL_DATE= ?";
				PreparedStatement pstmtWorkWith = conn.prepareStatement(workWtithSQL);
				pstmtWorkWith.setString(1, salesPers);
				pstmtWorkWith.setTimestamp( 2, java.sql.Timestamp.valueOf( eventDateDBFmt ) );
				
				ResultSet rsWorkWith = pstmtWorkWith.executeQuery();
				while(rsWorkWith.next())
				{
					valueXmlString.append("<workwith>\r\n");
					valueXmlString.append("<sales_pers>").append("<![CDATA[").append(rsWorkWith.getString("SPRS_CODE__WW") == null ? "" : rsWorkWith.getString("SPRS_CODE__WW")).append("]]>").append("</sales_pers>\r\n ");
					valueXmlString.append("<sp_name>").append("<![CDATA[").append(rsWorkWith.getString("SP_NAME") == null ? "" : rsWorkWith.getString("SP_NAME")).append("]]>").append("</sp_name>\r\n ");
		            valueXmlString.append("<sales_pers_workwith><![CDATA[" ).append(salesPers).append( "]]></sales_pers_workwith>\r\n");

					valueXmlString.append("</workwith>\r\n");
				}
				
				if(rsWorkWith != null)
				{
					rsWorkWith.close();
					rsWorkWith = null;
				}
				if(pstmtWorkWith != null)
				{
					pstmtWorkWith.close();
					pstmtWorkWith = null;
				}
				//Getting subordinate details : END
				valueXmlString.append("</DARDetails>");
				
				
	          //Added By Nilesh for Daily Dashboard Changes Start :21-09-2021
		            
				//Added By Nilesh Start for confirm button enable or disable according to user_right Start :: 22-04-19
				CallReportStatusEJB callReportEjb=new CallReportStatusEJB();
				String userRight=callReportEjb.getUserRightsString(salesPers, profileId , conn ,"callFromView");
				
				System.out.println( "userRight():==>\n"+userRight);
				
				//Added By Nilesh Start for confirm button enable or disable according to user_right End :: 22-04-19
				//valueXmlString.append( "</Detail2>\r\n" );
					

			}
			catch(Exception e)
			{
				System.out.println( "Exception :getSummaryDetailDcrMeet():==>\n"+e.getMessage());
				e.printStackTrace();
				throw new ITMException(e);
			}
			finally
			{
				try
				{
					if( conn != null && ! conn.isClosed() )
					{
						conn.close();
						conn = null;
					}
				}
				catch(Exception e)
				{
					System.out.println( "Exception :getSummaryDetailDcrMeet():==>\n"+e.getMessage());
					throw new ITMException(e);
				}
			}
			System.out.println("getSummaryDetailDcrMeet valueXmlString.toString() ::"+valueXmlString.toString());
			return valueXmlString.toString();
		}
		//Added By Mrunalini Sinkar for multiple sales person and dates24-FEB-2022(End)

}