/*
 * Decompiled with CFR 0.152.
 */
package ibase.system.config.resource;

import ibase.planner.utility.ITMException;
import ibase.system.config.StatementMonitor;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.StringTokenizer;
import oracle.jdbc.OraclePreparedStatement;
import org.jboss.resource.adapter.jdbc.WrappedPreparedStatement;

public class BasePreparedStatement
implements PreparedStatement {
    private ArrayList parameterValues;
    private String sqlTemplate;
    private PreparedStatement wrappedStatement;
    CommonConstants commonConstants = new CommonConstants();
    private Connection wrappedConnection = null;

    public BasePreparedStatement(Connection connection, String sql, boolean isPool) throws SQLException, ITMException {
        try {
            this.wrappedConnection = connection;
            this.wrappedStatement = CommonConstants.DB_NAME.equalsIgnoreCase("oracle") ? (!isPool ? (OraclePreparedStatement)connection.prepareStatement(sql) : (PreparedStatement)((WrappedPreparedStatement)connection.prepareStatement(sql)).getUnderlyingStatement()) : connection.prepareStatement(sql);
            this.sqlTemplate = sql;
            this.parameterValues = new ArrayList();
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception In : BasePreparedStatement2 :" + e);
            e.printStackTrace();
            throw new ITMException(e);
        }
    }

    public BasePreparedStatement(Connection connection, String sql, int resultSetType, int resultSetConcurrency, boolean isPool) throws SQLException, ITMException {
        try {
            this.wrappedConnection = connection;
            this.wrappedStatement = CommonConstants.DB_NAME.equalsIgnoreCase("oracle") ? (!isPool ? (OraclePreparedStatement)connection.prepareStatement(sql, resultSetType, resultSetConcurrency) : (PreparedStatement)((WrappedPreparedStatement)connection.prepareStatement(sql, resultSetType, resultSetConcurrency)).getUnderlyingStatement()) : connection.prepareStatement(sql, resultSetType, resultSetConcurrency);
            this.sqlTemplate = sql;
            this.parameterValues = new ArrayList();
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception In : BasePreparedStatement5 :" + e);
            e.printStackTrace();
            throw new ITMException(e);
        }
    }

    public BasePreparedStatement(Connection connection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability, boolean isPool) throws SQLException, ITMException {
        try {
            this.wrappedConnection = connection;
            this.wrappedStatement = CommonConstants.DB_NAME.equalsIgnoreCase("oracle") ? (!isPool ? (OraclePreparedStatement)connection.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability) : (PreparedStatement)((WrappedPreparedStatement)connection.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability)).getUnderlyingStatement()) : connection.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
            this.sqlTemplate = sql;
            this.parameterValues = new ArrayList();
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception In : BasePreparedStatement6 :" + e);
            e.printStackTrace();
            throw new ITMException(e);
        }
    }

    public BasePreparedStatement(Connection connection, String sql, int autoGeneratedKeys, boolean isPool) throws SQLException, ITMException {
        try {
            this.wrappedConnection = connection;
            this.wrappedStatement = CommonConstants.DB_NAME.equalsIgnoreCase("oracle") ? (!isPool ? (OraclePreparedStatement)connection.prepareStatement(sql, autoGeneratedKeys) : (PreparedStatement)((WrappedPreparedStatement)connection.prepareStatement(sql, autoGeneratedKeys)).getUnderlyingStatement()) : connection.prepareStatement(sql, autoGeneratedKeys);
            this.sqlTemplate = sql;
            this.parameterValues = new ArrayList();
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception In : BasePreparedStatement4 :" + e);
            e.printStackTrace();
            throw new ITMException(e);
        }
    }

    public BasePreparedStatement(Connection connection, String sql, int[] columnIndexes, boolean isPool) throws SQLException, ITMException {
        try {
            this.wrappedConnection = connection;
            this.wrappedStatement = CommonConstants.DB_NAME.equalsIgnoreCase("oracle") ? (!isPool ? (OraclePreparedStatement)connection.prepareStatement(sql, columnIndexes) : (PreparedStatement)((WrappedPreparedStatement)connection.prepareStatement(sql, columnIndexes)).getUnderlyingStatement()) : connection.prepareStatement(sql, columnIndexes);
            this.sqlTemplate = sql;
            this.parameterValues = new ArrayList();
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception In : BasePreparedStatement4 :" + e);
            e.printStackTrace();
            throw new ITMException(e);
        }
    }

    public BasePreparedStatement(Connection connection, String sql, String[] columnNames, boolean isPool) throws SQLException, ITMException {
        try {
            this.wrappedConnection = connection;
            this.wrappedStatement = CommonConstants.DB_NAME.equalsIgnoreCase("oracle") ? (!isPool ? (OraclePreparedStatement)connection.prepareStatement(sql, columnNames) : (PreparedStatement)((WrappedPreparedStatement)connection.prepareStatement(sql, columnNames)).getUnderlyingStatement()) : connection.prepareStatement(sql, columnNames);
            this.sqlTemplate = sql;
            this.parameterValues = new ArrayList();
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception In : BasePreparedStatement4 :" + e);
            e.printStackTrace();
            throw new ITMException(e);
        }
    }

    @Override
    public void addBatch() throws SQLException {
        try {
            this.wrappedStatement.addBatch();
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception In : addBatch :" + e);
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        try {
            this.wrappedStatement.addBatch(sql);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception In : addBatch1 :" + e);
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public void cancel() throws SQLException {
        try {
            this.wrappedStatement.cancel();
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception In : cancel :" + e);
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        try {
            this.wrappedStatement.clearBatch();
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception In : clearBatch :" + e);
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public void clearParameters() throws SQLException {
        try {
            this.wrappedStatement.clearParameters();
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception In : clearParameters :" + e);
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        try {
            this.wrappedStatement.clearWarnings();
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception In : clearWarnings :" + e);
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public void close() throws SQLException {
        try {
            this.wrappedStatement.close();
            StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
            this.updateStatementDetails(stackTraceElements, "clean", "");
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception In : close :" + e);
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public boolean execute() throws SQLException {
        boolean isResultset;
        try {
            if (!CommonConstants.DEBUG_LEVEL.equals("0")) {
                this.DBLogGenerator("execute()");
                BaseLogger.log("0", null, null, "BasePreparedStatement Sql resource1 [" + this.getQueryString() + "]");
            }
            StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
            this.updateStatementDetails(stackTraceElements, "dirty", this.getQueryString());
            this.wrappedStatement.setQueryTimeout(CommonConstants.SET_QUERY_TIMEOUT);
            isResultset = this.wrappedStatement.execute();
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception In : execute :" + e);
            e.printStackTrace();
            String stackTrace = this.getStackTrace(e);
            if (stackTrace.indexOf("ORA-01013") != -1 || stackTrace.indexOf("java.sql.SQLTimeoutException") != -1) {
                BaseLogger.log("0", null, null, "TimeoutException");
                String errorString = new E12GenericUtility().getErrorString("", CommonConstants.SQL_QUERRY_TIMEOUT_MESSAGE, "", "SQLTIMEOUT", this.getQueryString());
                BaseLogger.log("0", null, null, "TimeoutException errorString:[" + errorString + "]");
                throw new SQLException(new Exception(errorString));
            }
            BaseLogger.log("0", null, null, "Exception");
            throw e;
        }
        return isResultset;
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        boolean isResultset;
        try {
            if (!CommonConstants.DEBUG_LEVEL.equals("0")) {
                this.DBLogGenerator("execute(String sql)");
                BaseLogger.log("3", null, null, "BasePreparedStatement Sql resource1 [" + this.getQueryString() + "]");
            }
            StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
            this.updateStatementDetails(stackTraceElements, "dirty", sql);
            this.wrappedStatement.setQueryTimeout(CommonConstants.SET_QUERY_TIMEOUT);
            isResultset = this.wrappedStatement.execute(sql);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception In : execute1 :" + e);
            e.printStackTrace();
            String stackTrace = this.getStackTrace(e);
            if (stackTrace.indexOf("ORA-01013") != -1 || stackTrace.indexOf("java.sql.SQLTimeoutException") != -1) {
                BaseLogger.log("0", null, null, "TimeoutException");
                String errorString = new E12GenericUtility().getErrorString("", CommonConstants.SQL_QUERRY_TIMEOUT_MESSAGE, "", "SQLTIMEOUT", sql);
                BaseLogger.log("0", null, null, "TimeoutException errorString:[" + errorString + "]");
                throw new SQLException(new Exception(errorString));
            }
            BaseLogger.log("0", null, null, "Exception");
            throw e;
        }
        return isResultset;
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        boolean isResultset;
        try {
            if (!CommonConstants.DEBUG_LEVEL.equals("0")) {
                this.DBLogGenerator("execute(String ,int)");
                BaseLogger.log("3", null, null, "BasePreparedStatement Sql [" + this.getQueryString() + "]");
            }
            StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
            this.updateStatementDetails(stackTraceElements, "dirty", sql);
            this.wrappedStatement.setQueryTimeout(CommonConstants.SET_QUERY_TIMEOUT);
            isResultset = this.wrappedStatement.execute(sql, autoGeneratedKeys);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception In : execute2 :" + e);
            e.printStackTrace();
            String stackTrace = this.getStackTrace(e);
            if (stackTrace.indexOf("ORA-01013") != -1 || stackTrace.indexOf("java.sql.SQLTimeoutException") != -1) {
                BaseLogger.log("0", null, null, "TimeoutException");
                String errorString = new E12GenericUtility().getErrorString("", CommonConstants.SQL_QUERRY_TIMEOUT_MESSAGE, "", "SQLTIMEOUT", sql);
                BaseLogger.log("0", null, null, "TimeoutException errorString:[" + errorString + "]");
                throw new SQLException(new Exception(errorString));
            }
            BaseLogger.log("0", null, null, "Exception");
            throw e;
        }
        return isResultset;
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        boolean isResultset;
        try {
            if (!CommonConstants.DEBUG_LEVEL.equals("0")) {
                this.DBLogGenerator("execute(String,int[])");
                BaseLogger.log("3", null, null, "BasePreparedStatement Sql [" + this.getQueryString() + "]");
            }
            StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
            this.updateStatementDetails(stackTraceElements, "dirty", sql);
            this.wrappedStatement.setQueryTimeout(CommonConstants.SET_QUERY_TIMEOUT);
            isResultset = this.wrappedStatement.execute(sql, columnIndexes);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception In : execute2 :" + e);
            e.printStackTrace();
            String stackTrace = this.getStackTrace(e);
            if (stackTrace.indexOf("ORA-01013") != -1 || stackTrace.indexOf("java.sql.SQLTimeoutException") != -1) {
                BaseLogger.log("0", null, null, "TimeoutException");
                String errorString = new E12GenericUtility().getErrorString("", CommonConstants.SQL_QUERRY_TIMEOUT_MESSAGE, "", "SQLTIMEOUT", sql);
                BaseLogger.log("0", null, null, "TimeoutException errorString:[" + errorString + "]");
                throw new SQLException(new Exception(errorString));
            }
            BaseLogger.log("0", null, null, "Exception");
            throw e;
        }
        return isResultset;
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        boolean isResultset;
        try {
            if (!CommonConstants.DEBUG_LEVEL.equals("0")) {
                this.DBLogGenerator("execute(String,String[])");
                BaseLogger.log("3", null, null, "BasePreparedStatement Sql [" + this.getQueryString() + "]");
            }
            StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
            this.updateStatementDetails(stackTraceElements, "dirty", sql);
            this.wrappedStatement.setQueryTimeout(CommonConstants.SET_QUERY_TIMEOUT);
            isResultset = this.wrappedStatement.execute(sql, columnNames);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception In : execute2StrArr :" + e);
            e.printStackTrace();
            String stackTrace = this.getStackTrace(e);
            if (stackTrace.indexOf("ORA-01013") != -1 || stackTrace.indexOf("java.sql.SQLTimeoutException") != -1) {
                BaseLogger.log("0", null, null, "TimeoutException");
                String errorString = new E12GenericUtility().getErrorString("", CommonConstants.SQL_QUERRY_TIMEOUT_MESSAGE, "", "SQLTIMEOUT", sql);
                BaseLogger.log("0", null, null, "TimeoutException errorString:[" + errorString + "]");
                throw new SQLException(new Exception(errorString));
            }
            BaseLogger.log("0", null, null, "Exception");
            throw e;
        }
        return isResultset;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        try {
            return this.wrappedStatement.getResultSetHoldability();
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception In : getResultSetHoldability :" + e);
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public void setURL(int index, URL url) throws SQLException {
        try {
            this.wrappedStatement.setURL(index, url);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception In : setURL :" + e);
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        try {
            return this.wrappedStatement.getParameterMetaData();
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception In : getParameterMetadata :" + e);
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        int[] batchCmdArr;
        try {
            if (!CommonConstants.DEBUG_LEVEL.equals("0")) {
                BaseLogger.log("3", null, null, "BasePreparedStatement Sql [" + this.getQueryString() + "]");
            }
            StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
            this.updateStatementDetails(stackTraceElements, "dirty", this.getQueryString());
            batchCmdArr = this.wrappedStatement.executeBatch();
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception In : executeBatch :" + e);
            e.printStackTrace();
            BaseLogger.log("0", null, null, "Exception");
            throw e;
        }
        return batchCmdArr;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        ResultSet rs;
        try {
            if (!CommonConstants.DEBUG_LEVEL.equals("0")) {
                this.DBLogGenerator("executeQuery()");
                BaseLogger.log("3", null, null, "BasePreparedStatement Sql [" + this.getQueryString() + "]");
            }
            StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
            this.updateStatementDetails(stackTraceElements, "dirty", this.getQueryString());
            this.wrappedStatement.setQueryTimeout(CommonConstants.SET_QUERY_TIMEOUT);
            rs = this.wrappedStatement.executeQuery();
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception In : executeQuery @@:[" + e.toString() + "]");
            e.printStackTrace();
            String stackTrace = this.getStackTrace(e);
            if (stackTrace.indexOf("ORA-01013") != -1 || stackTrace.indexOf("java.sql.SQLTimeoutException") != -1) {
                BaseLogger.log("0", null, null, "TimeoutException");
                String errorString = new E12GenericUtility().getErrorString("", CommonConstants.SQL_QUERRY_TIMEOUT_MESSAGE, "", "SQLTIMEOUT", this.getQueryString());
                BaseLogger.log("0", null, null, "TimeoutException errorString:[" + errorString + "]");
                throw new SQLException(new Exception(errorString));
            }
            BaseLogger.log("0", null, null, "Exception");
            throw e;
        }
        return rs;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        try {
            return this.wrappedStatement.getGeneratedKeys();
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception In : getGeneratedKeys :" + e);
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        int updatedRows;
        try {
            this.DBLogGenerator("executeUpdate(String,autoGenerateKeys)");
            StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
            this.updateStatementDetails(stackTraceElements, "dirty", sql);
            this.wrappedStatement.setQueryTimeout(CommonConstants.SET_QUERY_TIMEOUT);
            updatedRows = this.wrappedStatement.executeUpdate(sql, autoGeneratedKeys);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception In : executeUpdate2 :" + e);
            e.printStackTrace();
            String stackTrace = this.getStackTrace(e);
            if (stackTrace.indexOf("ORA-01013") != -1 || stackTrace.indexOf("java.sql.SQLTimeoutException") != -1) {
                BaseLogger.log("0", null, null, "TimeoutException");
                String errorString = new E12GenericUtility().getErrorString("", CommonConstants.SQL_QUERRY_TIMEOUT_MESSAGE, "", "SQLTIMEOUT", sql);
                BaseLogger.log("0", null, null, "TimeoutException errorString:[" + errorString + "]");
                throw new SQLException(new Exception(errorString));
            }
            BaseLogger.log("0", null, null, "Exception");
            throw e;
        }
        return updatedRows;
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        int updatedRows;
        try {
            this.DBLogGenerator("executeUpdate(sql,columnNames)");
            StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
            this.updateStatementDetails(stackTraceElements, "dirty", sql);
            this.wrappedStatement.setQueryTimeout(CommonConstants.SET_QUERY_TIMEOUT);
            updatedRows = this.wrappedStatement.executeUpdate(sql, columnNames);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception In : executeUpdate2StrArr :" + e);
            e.printStackTrace();
            String stackTrace = this.getStackTrace(e);
            if (stackTrace.indexOf("ORA-01013") != -1 || stackTrace.indexOf("java.sql.SQLTimeoutException") != -1) {
                BaseLogger.log("0", null, null, "TimeoutException");
                String errorString = new E12GenericUtility().getErrorString("", CommonConstants.SQL_QUERRY_TIMEOUT_MESSAGE, "", "SQLTIMEOUT", sql);
                BaseLogger.log("0", null, null, "TimeoutException errorString:[" + errorString + "]");
                throw new SQLException(new Exception(errorString));
            }
            BaseLogger.log("0", null, null, "Exception");
            throw e;
        }
        return updatedRows;
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        int updatedRows;
        try {
            this.DBLogGenerator("executeUpdate(sql,columnIndexs)");
            StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
            this.updateStatementDetails(stackTraceElements, "dirty", sql);
            this.wrappedStatement.setQueryTimeout(CommonConstants.SET_QUERY_TIMEOUT);
            updatedRows = this.wrappedStatement.executeUpdate(sql, columnIndexes);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception In : executeUpdate2 :" + e);
            e.printStackTrace();
            String stackTrace = this.getStackTrace(e);
            if (stackTrace.indexOf("ORA-01013") != -1 || stackTrace.indexOf("java.sql.SQLTimeoutException") != -1) {
                BaseLogger.log("0", null, null, "TimeoutException");
                String errorString = new E12GenericUtility().getErrorString("", CommonConstants.SQL_QUERRY_TIMEOUT_MESSAGE, "", "SQLTIMEOUT", sql);
                BaseLogger.log("0", null, null, "TimeoutException errorString:[" + errorString + "]");
                throw new SQLException(new Exception(errorString));
            }
            BaseLogger.log("0", null, null, "Exception");
            throw e;
        }
        return updatedRows;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        ResultSet rs;
        try {
            this.DBLogGenerator("executeUpdate(sql)");
            StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
            this.updateStatementDetails(stackTraceElements, "dirty", sql);
            this.wrappedStatement.setQueryTimeout(CommonConstants.SET_QUERY_TIMEOUT);
            rs = this.wrappedStatement.executeQuery(sql);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception In : executeQuery1 :" + e);
            e.printStackTrace();
            String stackTrace = this.getStackTrace(e);
            if (stackTrace.indexOf("ORA-01013") != -1 || stackTrace.indexOf("java.sql.SQLTimeoutException") != -1) {
                BaseLogger.log("0", null, null, "TimeoutException");
                String errorString = new E12GenericUtility().getErrorString("", CommonConstants.SQL_QUERRY_TIMEOUT_MESSAGE, "", "SQLTIMEOUT", sql);
                BaseLogger.log("0", null, null, "TimeoutException errorString:[" + errorString + "]");
                throw new SQLException(new Exception(errorString));
            }
            BaseLogger.log("0", null, null, "Exception");
            throw e;
        }
        return rs;
    }

    @Override
    public int executeUpdate() throws SQLException {
        int upadtedRows;
        try {
            if (!CommonConstants.DEBUG_LEVEL.equals("0")) {
                this.DBLogGenerator("executeUpdate()");
                BaseLogger.log("3", null, null, "BasePreparedStatement Sql [" + this.getQueryString() + "]");
            }
            StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
            this.updateStatementDetails(stackTraceElements, "dirty", this.getQueryString());
            this.wrappedStatement.setQueryTimeout(CommonConstants.SET_QUERY_TIMEOUT);
            upadtedRows = this.wrappedStatement.executeUpdate();
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception In : executeUpdate :" + e);
            e.printStackTrace();
            String stackTrace = this.getStackTrace(e);
            if (stackTrace.indexOf("ORA-01013") != -1 || stackTrace.indexOf("java.sql.SQLTimeoutException") != -1) {
                BaseLogger.log("0", null, null, "TimeoutException");
                String errorString = new E12GenericUtility().getErrorString("", CommonConstants.SQL_QUERRY_TIMEOUT_MESSAGE, "", "SQLTIMEOUT", this.getQueryString());
                BaseLogger.log("0", null, null, "TimeoutException errorString:[" + errorString + "]");
                throw new SQLException(new Exception(errorString));
            }
            BaseLogger.log("0", null, null, "Exception");
            throw e;
        }
        return upadtedRows;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        int updatedRows;
        try {
            this.DBLogGenerator("executeUpdate(sql)");
            StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
            this.updateStatementDetails(stackTraceElements, "dirty", sql);
            this.wrappedStatement.setQueryTimeout(CommonConstants.SET_QUERY_TIMEOUT);
            updatedRows = this.wrappedStatement.executeUpdate(sql);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception In : executeUpdate1 :" + e);
            e.printStackTrace();
            String stackTrace = this.getStackTrace(e);
            if (stackTrace.indexOf("ORA-01013") != -1 || stackTrace.indexOf("java.sql.SQLTimeoutException") != -1) {
                BaseLogger.log("0", null, null, "TimeoutException");
                String errorString = new E12GenericUtility().getErrorString("", CommonConstants.SQL_QUERRY_TIMEOUT_MESSAGE, "", "SQLTIMEOUT", sql);
                BaseLogger.log("0", null, null, "TimeoutException errorString:[" + errorString + "]");
                throw new SQLException(new Exception(errorString));
            }
            BaseLogger.log("0", null, null, "Exception");
            throw e;
        }
        return updatedRows;
    }

    @Override
    public Connection getConnection() throws SQLException {
        try {
            return this.wrappedStatement.getConnection();
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception In : getConnection :" + e);
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        try {
            return this.wrappedStatement.getFetchDirection();
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception In : getFetchDirection :" + e);
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        try {
            return this.wrappedStatement.getFetchSize();
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception In : getFetchSize :" + e);
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        try {
            return this.wrappedStatement.getMaxFieldSize();
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception In : getMaxFieldSize :" + e);
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public int getMaxRows() throws SQLException {
        try {
            return this.wrappedStatement.getMaxRows();
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception In : getMaxRows :" + e);
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        try {
            return this.wrappedStatement.getMetaData();
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception In : getMetadata :" + e);
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        try {
            return this.wrappedStatement.getMoreResults();
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception In : getMoreResults :" + e);
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        try {
            return this.wrappedStatement.getMoreResults(current);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception In : getMoreResults :" + e);
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        try {
            return this.wrappedStatement.getQueryTimeout();
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception In : getQueryTimeout :" + e);
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        try {
            return this.wrappedStatement.getResultSet();
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception In : getResultSet :" + e);
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        try {
            return this.wrappedStatement.getResultSetConcurrency();
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception In : getResultSetConcurrency :" + e);
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public int getResultSetType() throws SQLException {
        try {
            return this.wrappedStatement.getResultSetType();
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception In : getResultSetType :" + e);
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public int getUpdateCount() throws SQLException {
        try {
            return this.wrappedStatement.getUpdateCount();
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception In : getUpdateCount :" + e);
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        try {
            return this.wrappedStatement.getWarnings();
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception In : getWarnings :" + e);
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public void setArray(int i, Array x) throws SQLException {
        try {
            this.wrappedStatement.setArray(i, x);
            this.saveQueryParamValue(i, x);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception In : setArray :" + e);
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        try {
            this.wrappedStatement.setAsciiStream(parameterIndex, x, length);
            this.saveQueryParamValue(parameterIndex, x);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception In : setAsciiStream :" + e);
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        try {
            this.wrappedStatement.setBigDecimal(parameterIndex, x);
            this.saveQueryParamValue(parameterIndex, x);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception In : setBigDecimal :" + e);
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        try {
            this.wrappedStatement.setBinaryStream(parameterIndex, x, length);
            this.saveQueryParamValue(parameterIndex, x);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception In : setBinaryStream :" + e);
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public void setBlob(int i, Blob x) throws SQLException {
        try {
            this.wrappedStatement.setBlob(i, x);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception In : setBlob :" + e);
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        try {
            this.wrappedStatement.setBoolean(parameterIndex, x);
            this.saveQueryParamValue(parameterIndex, new Boolean(x));
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception In : setBoolean :" + e);
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        try {
            this.wrappedStatement.setByte(parameterIndex, x);
            this.saveQueryParamValue(parameterIndex, new Integer(x));
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception In : setByte :" + e);
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        try {
            this.wrappedStatement.setBytes(parameterIndex, x);
            this.saveQueryParamValue(parameterIndex, x);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception In : setBytes :" + e);
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        try {
            this.wrappedStatement.setCharacterStream(parameterIndex, reader, length);
            this.saveQueryParamValue(parameterIndex, reader);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception In : setCharacteStream :" + e);
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public void setClob(int i, Clob x) throws SQLException {
        try {
            this.wrappedStatement.setClob(i, x);
            this.saveQueryParamValue(i, x);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception In : setClob :" + e);
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        try {
            this.wrappedStatement.setCursorName(name);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception In : setCursorName :" + e);
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        try {
            this.wrappedStatement.setDate(parameterIndex, x);
            this.saveQueryParamValue(parameterIndex, x);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception In : setDate :" + e);
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        try {
            this.wrappedStatement.setDate(parameterIndex, x, cal);
            this.saveQueryParamValue(parameterIndex, x);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception In : setDate :" + e);
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        try {
            this.wrappedStatement.setDouble(parameterIndex, x);
            this.saveQueryParamValue(parameterIndex, new Double(x));
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception In : setDouble :" + e);
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        try {
            this.wrappedStatement.setEscapeProcessing(enable);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception In : setEscaoeProcessing :" + e);
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        try {
            this.wrappedStatement.setFetchDirection(direction);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception In : setFetchDirection :" + e);
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        try {
            this.wrappedStatement.setFetchSize(rows);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception In : setFetchSize :" + e);
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        try {
            this.wrappedStatement.setFloat(parameterIndex, x);
            this.saveQueryParamValue(parameterIndex, new Float(x));
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception In : setFloat :" + e);
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        try {
            this.wrappedStatement.setInt(parameterIndex, x);
            this.saveQueryParamValue(parameterIndex, new Integer(x));
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception In : setInt :" + e);
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        try {
            this.wrappedStatement.setLong(parameterIndex, x);
            this.saveQueryParamValue(parameterIndex, new Long(x));
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception In : setLong :" + e);
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        try {
            this.wrappedStatement.setMaxFieldSize(max);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception In : setMaxFieldSize :" + e);
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        try {
            this.wrappedStatement.setMaxRows(max);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception In : setMaxRows :" + e);
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        try {
            this.wrappedStatement.setNull(parameterIndex, sqlType);
            this.saveQueryParamValue(parameterIndex, null);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception In : setNull :" + e);
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
        try {
            this.wrappedStatement.setNull(paramIndex, sqlType, typeName);
            this.saveQueryParamValue(paramIndex, null);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception In : setNull :" + e);
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        boolean fixedChar = false;
        try {
            if (x instanceof String) {
                if (CommonConstants.DB_NAME.equalsIgnoreCase("oracle")) {
                    if (!CommonConstants.DEBUG_LEVEL.equals("0")) {
                        if (this.getQueryString().toUpperCase().indexOf("INSERT ") == -1) {
                            fixedChar = true;
                        }
                    } else if (this.sqlTemplate != null && this.sqlTemplate.toUpperCase().indexOf("INSERT ") == -1) {
                        fixedChar = true;
                    }
                }
                if (fixedChar) {
                    ((OraclePreparedStatement)this.wrappedStatement).setFixedCHAR(parameterIndex, (String)x);
                } else {
                    this.wrappedStatement.setObject(parameterIndex, x);
                }
            } else {
                this.wrappedStatement.setObject(parameterIndex, x);
            }
            this.saveQueryParamValue(parameterIndex, x);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception In : setObject :" + e);
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        try {
            this.wrappedStatement.setObject(parameterIndex, x, targetSqlType);
            this.saveQueryParamValue(parameterIndex, x);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception In : setObject :" + e);
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        try {
            this.wrappedStatement.setObject(parameterIndex, x, targetSqlType, scale);
            this.saveQueryParamValue(parameterIndex, x);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception In : setObject :" + e);
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        try {
            this.wrappedStatement.setQueryTimeout(seconds);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception In : setQueryTimeout :" + e);
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public void setRef(int i, Ref x) throws SQLException {
        try {
            this.wrappedStatement.setRef(i, x);
            this.saveQueryParamValue(i, x);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception In : setRef :" + e);
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        try {
            this.wrappedStatement.setShort(parameterIndex, x);
            this.saveQueryParamValue(parameterIndex, new Integer(x));
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception In : setShort :" + e);
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        try {
            boolean fixedChar = false;
            if (CommonConstants.DB_NAME.trim().equalsIgnoreCase("oracle")) {
                if (!CommonConstants.DEBUG_LEVEL.equals("0")) {
                    if (this.getQueryString().toUpperCase().indexOf("INSERT ") == -1) {
                        fixedChar = true;
                    }
                } else if (this.sqlTemplate != null && this.sqlTemplate.toUpperCase().indexOf("INSERT ") == -1) {
                    fixedChar = true;
                }
            }
            if (fixedChar) {
                ((OraclePreparedStatement)this.wrappedStatement).setFixedCHAR(parameterIndex, x);
            } else {
                this.wrappedStatement.setString(parameterIndex, x);
            }
            this.saveQueryParamValue(parameterIndex, x);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception In : setString :" + e);
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        try {
            this.wrappedStatement.setTime(parameterIndex, x);
            this.saveQueryParamValue(parameterIndex, x);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception In : setTime :" + e);
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        try {
            this.wrappedStatement.setTime(parameterIndex, x, cal);
            this.saveQueryParamValue(parameterIndex, x);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception In : setTime :" + e);
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        try {
            this.wrappedStatement.setTimestamp(parameterIndex, x);
            this.saveQueryParamValue(parameterIndex, x);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception In : setTimeStamp :" + e);
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        try {
            this.wrappedStatement.setTimestamp(parameterIndex, x, cal);
            this.saveQueryParamValue(parameterIndex, x);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception In : setTimeStamp :" + e);
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        try {
            this.wrappedStatement.setUnicodeStream(parameterIndex, x, length);
            this.saveQueryParamValue(parameterIndex, x);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception In : setUniCodeStream :" + e);
            e.printStackTrace();
            throw e;
        }
    }

    public String getQueryString() {
        StringBuffer buf = new StringBuffer();
        try {
            int qMarkCount = 0;
            ArrayList chunks = new ArrayList();
            StringTokenizer tok = new StringTokenizer(String.valueOf(this.sqlTemplate) + " ", "?");
            while (tok.hasMoreTokens()) {
                String oneChunk = tok.nextToken();
                buf.append(oneChunk);
                try {
                    String value = this.parameterValues.size() > 1 + qMarkCount ? this.parameterValues.get(1 + qMarkCount++) : (tok.hasMoreTokens() ? null : "");
                    buf.append(value);
                }
                catch (Throwable e) {
                    buf.append("ERROR WHEN PRODUCING QUERY STRING FOR LOG." + e.toString());
                }
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception In : getQuerystring :" + e);
            e.printStackTrace();
            throw e;
        }
        return buf.toString().trim();
    }

    private void saveQueryParamValue(int position, Object obj) {
        try {
            String strValue = obj instanceof String || obj instanceof java.util.Date ? "'" + obj + "'" : (obj == null ? "null" : obj.toString());
            while (position >= this.parameterValues.size()) {
                this.parameterValues.add(null);
            }
            this.parameterValues.set(position, strValue);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception In : saveQueyParamValue :" + e);
            e.printStackTrace();
            throw e;
        }
    }

    private void DBLogGenerator(String method) {
        if (CommonConstants.J2EE_VERSION.equals("2")) {
            BaseLogger.info(this.getQueryString());
        }
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
    }

    @Override
    public boolean isClosed() throws SQLException {
        return false;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return false;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return false;
    }

    private void updateStatementDetails(StackTraceElement[] stackTraceElements, String status, String sql) {
        String className = "";
        String methodName = "";
        int lineNo = 0;
        try {
            String stackTrace = this.getStackTrace(stackTraceElements);
            if (stackTraceElements != null && stackTraceElements.length >= 2) {
                className = stackTraceElements[2].getFileName();
                methodName = stackTraceElements[2].getMethodName();
                lineNo = stackTraceElements[2].getLineNumber();
            }
            StatementMonitor statementMonitor = new StatementMonitor("" + this.wrappedConnection.hashCode(), "" + this.wrappedStatement.hashCode(), "PrepareStatement", sql, status, new java.util.Date(), new java.util.Date(), className, methodName, lineNo, stackTrace);
            statementMonitor.updateStatementMonitorDetails();
            statementMonitor = null;
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception in updateStatementDetails of BasePrepareStatement:[" + e.getMessage() + "]");
            e.printStackTrace();
            throw e;
        }
    }

    private String getStackTrace(StackTraceElement[] stackTraceElements) {
        StringBuilder sb = new StringBuilder();
        try {
            if (stackTraceElements != null && stackTraceElements.length >= 4) {
                int i = 1;
                while (i < 4) {
                    sb.append("\n " + stackTraceElements[i]);
                    ++i;
                }
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception in getStackTrace BasePrepareStatement:[" + e.getMessage() + "]");
            e.printStackTrace();
            throw e;
        }
        return sb.toString();
    }

    private String getStackTrace(Exception ex) {
        StringBuilder sb = new StringBuilder();
        StackTraceElement[] elements = ex.getStackTrace();
        sb.append(String.valueOf(ex.getClass().getSimpleName()) + " : " + ex.getMessage() + "\n");
        StackTraceElement[] stackTraceElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement element = stackTraceElementArray[n2];
            sb.append("\tat " + element.toString());
            ++n2;
        }
        return sb.toString();
    }
}

