/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.utility;

import ibase.utility.BaseLogger;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class ExtractZipFiles {
    String _srcFile;
    String _destFile;
    int htmlFilesCount = 0;

    public ExtractZipFiles(String srcFile, String destFile) {
        this._srcFile = srcFile;
        this._destFile = destFile;
        File file = new File(srcFile);
        if (file.exists()) {
            this.unZipFiles(srcFile, destFile);
        } else {
            BaseLogger.log("1", null, null, "zip file not exists.. for extraction..." + srcFile);
        }
    }

    private void unZipFiles(String srcFile2, String destFile2) {
        int BUFFER_SIZE = 0xA00000;
        try {
            BaseLogger.log("3", null, null, "srcFile2 : " + srcFile2 + " & destFile2 : " + destFile2);
            File inputZipFile = new File(srcFile2);
            ArrayList<String> fileNameList = new ArrayList<String>();
            String zipFileName = inputZipFile.getName();
            ZipFile zipFile = new ZipFile(inputZipFile, 1);
            ZipEntry ze = null;
            Enumeration<? extends ZipEntry> zipFileEntries = zipFile.entries();
            while (zipFileEntries.hasMoreElements()) {
                int size;
                ze = zipFileEntries.nextElement();
                if (ze.isDirectory()) {
                    this._dirChecker(ze.getName());
                    continue;
                }
                BufferedInputStream bis = new BufferedInputStream(zipFile.getInputStream(ze));
                byte[] bufferData = new byte[BUFFER_SIZE];
                String fileName = ze.getName();
                File newFile = new File(String.valueOf(destFile2) + File.separator + fileName);
                new File(newFile.getParent()).mkdirs();
                FileOutputStream fout = new FileOutputStream(newFile);
                BufferedOutputStream bufferOutStream = new BufferedOutputStream(fout, BUFFER_SIZE);
                while ((size = bis.read(bufferData, 0, BUFFER_SIZE)) != -1) {
                    bufferOutStream.write(bufferData, 0, size);
                }
                bufferOutStream.flush();
                bufferOutStream.close();
                bis.close();
                if (!fileName.endsWith("index.html")) continue;
                fileNameList.add(newFile.getCanonicalPath());
            }
            zipFile.close();
            BaseLogger.log("3", null, null, "finished extracting!");
            BaseLogger.log("3", null, null, "zipFileName[" + zipFileName + "] fileNameList[" + fileNameList.size() + "]");
            this.createHTMLFilesList(zipFileName, destFile2, fileNameList);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private void _dirChecker(String dirName) {
        BaseLogger.log("2", null, null, "inside _dirChecker.. " + dirName + " & destFile : " + this._destFile);
        File f = new File(String.valueOf(this._destFile) + dirName);
        if (!f.isDirectory()) {
            if (f.exists()) {
                f.delete();
                BaseLogger.log("3", null, null, "file deleted...");
            }
            f.mkdirs();
        }
    }

    private void createHTMLFilesList(String outputFileName, String destFile, ArrayList<String> fileNameList) {
        try {
            JSONArray fileArray = new JSONArray();
            for (String fileName : fileNameList) {
                BaseLogger.log("3", null, null, "Inside createHTMLFilesList " + fileName);
                JSONObject fileObject = new JSONObject();
                File htmlFile = new File(fileName);
                File htmlParentFile = htmlFile.getParentFile();
                String parentPath = htmlFile.getParent();
                String locationURL = htmlFile.getParent();
                String deviceLocalURL = "/base/cache/downloads/files/" + htmlParentFile.getName();
                if (locationURL.indexOf("\\") > 0) {
                    locationURL = locationURL.replaceAll("\\", "/");
                }
                locationURL = "/ibase" + locationURL.substring(locationURL.indexOf("/extractedFiles"));
                Document doc = Jsoup.parse((File)htmlFile, (String)"UTF-8");
                BaseLogger.log("3", null, null, "\n\n" + fileName);
                Elements anchorTags = doc.getElementsByTag("a");
                JSONArray anchorTagArray = new JSONArray();
                for (Element anchorTag : anchorTags) {
                    String hrefLink = anchorTag.attr("href");
                    String anchorText = anchorTag.text();
                    if ("#".equalsIgnoreCase(hrefLink) || hrefLink.startsWith("http:") || anchorText.trim().length() <= 0) continue;
                    BaseLogger.log("3", null, null, "anchorText[" + anchorText + "] href [" + hrefLink + "]");
                    JSONObject anchorTagObject = new JSONObject();
                    File hrefLinkFile = new File(String.valueOf(parentPath) + hrefLink);
                    if (hrefLinkFile != null && hrefLinkFile.exists()) {
                        Document hrefLinkDoc = Jsoup.parse((File)hrefLinkFile, (String)"UTF-8");
                        BaseLogger.log("3", null, null, "\n\n" + fileName);
                        Elements hrefLinkTags = hrefLinkDoc.getElementsByTag("a");
                        BaseLogger.log("3", null, null, "hrefLinkTags Size[" + hrefLinkTags.size() + "]");
                        anchorTagObject.put("totalLinks", hrefLinkTags.size());
                    }
                    anchorTagObject.put("linkText", (Object)anchorText);
                    anchorTagObject.put("fileUrl", (Object)(String.valueOf(locationURL) + "/" + hrefLink));
                    anchorTagObject.put("fileName", (Object)hrefLink);
                    anchorTagArray.put((Object)anchorTagObject);
                }
                fileObject.put("filename", (Object)htmlFile.getName());
                fileObject.put("title", (Object)doc.title());
                fileObject.put("locationURL", (Object)locationURL);
                fileObject.put("localURL", (Object)deviceLocalURL);
                fileObject.put("pages", (Object)anchorTagArray);
                fileArray.put((Object)fileObject);
                this.htmlFilesCount = anchorTagArray.length();
            }
            outputFileName = outputFileName.replaceAll("zip", "json");
            File jsonFile = new File(String.valueOf(destFile) + File.separator + outputFileName);
            FileUtils.writeStringToFile((File)jsonFile, (String)fileArray.toString());
            BaseLogger.log("3", null, null, "finished HTMLFilesList creation!" + fileArray.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public int getFilesCount() {
        return this.htmlFilesCount;
    }
}

