package ibase.ejb;

import java.io.File;
import java.io.PrintStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.rmi.RemoteException;
import java.security.MessageDigest;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.sql.Types;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.SessionContext;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.apache.commons.io.FileUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.w3c.dom.Document;
//Changed by Gayatri Yadav on 16-Sept-2010 [ WI01SUN006 ] [ To implement SHA-256 while login ]
//import ibase.webitm.utility.GenericUtility;
//commented by gayatri on 23-02-2012 [to access the Messages class of ibase.ejb package]
//import ibase.webitm.servlet.Messages;
//Changed by Gayatri Yadav on 16-Sept-2010 [ WI01SUN006 ] [ To implement SHA-256 while login ]
//import ibase.webitm.utility.GenericUtility;
//commented by gayatri on 23-02-2012 [to access the Messages class of ibase.ejb package]
//import ibase.webitm.servlet.Messages;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

import ibase.bean.ExtAuthAppAPIBean;
import ibase.bean.ExtAuthApplicationBean;
import ibase.bean.ExtAuthRespBean;
import ibase.ejb.E12SMSComp.SMSType;
import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseException;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.EMail;
//import ibase.utility.GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.ejb.InfinispanLocal;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.InfinispanLogger;

@javax.ejb.Stateless
public class CommonDBAccessEJB implements CommonDBAccessRemote,CommonDBAccessLocal //implements SessionBean 
{
	//SessionContext cSessionContext;
	@PostConstruct
  	public void postConstruct()
	{
		try
		{
			setLogger();
		}
		catch (Exception e)
		{
			BaseLogger.log("0",null,null,"BaseException :AuthenticateServlet :writeMessage() :==>\n"+e.getMessage()); //$NON-NLS-1$
		}
	}
	/*
	public void ejbRemove()
	{
	}

	public void ejbActivate() 
	{
	}

	public void ejbPassivate() 
	{
	}
	*/

	/*public void setSessionContext(SessionContext mSessionContext) 
	{
		this.cSessionContext = mSessionContext;
	}*/
	
	//Added By Pankaj T on 12/09/17 for creating infinispan object on class level - Start
	static InfinispanLocal infinispanLocalObj = null;
	static Hashtable jndiProperties = null;
	static InitialContext ctx = null;
	
	static
	{
		try 
		{
			//Added Pankaj T on 18-10-17 [for CACHE_OPT define in ibase.xml 0 = NO Cache, 1 = Internal Cache, 2 = External Cache]
			if( CommonConstants.CACHE_OPT != 0 )
			{
				jndiProperties = new Hashtable();
				jndiProperties.put(Context.URL_PKG_PREFIXES,"org.jboss.ejb.client.naming");	   
				ctx=new InitialContext(jndiProperties);
				infinispanLocalObj = ((InfinispanLocal)ctx.lookup("ibase/InfinispanEJB/local"));
				BaseLogger.log("1",null,null,"CommonDBAccessEJB infinispanLocalObj created.....");
			}
		}
		catch (Exception e) 
		{
			BaseLogger.log("0",null,null,"Exception in CommonDBAccessEJB static block:["+e.getMessage()+"]");
			e.printStackTrace();
		}
	}
	//Added By Pankaj T on 12/09/17 for creating infinispan object on class level - End
		
	private @Resource SessionContext cSessionContext;
	//Added by Pankaj T on 19-12-17 [for multitenancy Added new varaiable trasDB] - Start
	private String transDB = "";
	
	@Override
	public String getTransDB() 
	{
		return transDB;
	}
	
	@Override
	public void setTransDB(String transDB) 
	{
		this.transDB = transDB;
	}
	//Added by Pankaj T on 19-12-17 [for multitenancy Added new varaiable trasDB] - End

	public String encrypt(String as_passwd)
	{
		BaseLogger.log("1",null,null,"CommonDBAccessEJB..................encrypt..............."); //$NON-NLS-1$
		String ls_return = ""; //$NON-NLS-1$
		try
		{
			BaseLogger.log("3",null,null, "Encrypting Password....." ); //$NON-NLS-1$
			int li_len, li_count, li_Seed, li_passAsc;
			li_len = as_passwd.length();
			for(li_count = 0; li_count < li_len;li_count++)
			{
				Random li_Seed_r = new Random();
				li_Seed = li_Seed_r.nextInt(10);
				li_passAsc  =(int) as_passwd.charAt(li_count);
				li_passAsc = li_passAsc + li_Seed + li_count;
				ls_return +=""+(char)(li_passAsc) +""+ (char)(li_Seed + li_count); //$NON-NLS-1$ //$NON-NLS-2$
			}
		}
		catch(Exception e)
		{
			BaseLogger.log("0",null,null,"Exception: CommonDBAccessEJB: encrypt:==>\n"+e.getMessage()); //$NON-NLS-1$
			//throw e;
		}
		BaseLogger.log("2",null,null,"CommonDBAccessEJB..................encrypt.......["+ls_return+"]...."); //$NON-NLS-1$ //$NON-NLS-2$
		return ls_return;
	}

	public String decrypt( String as_passwd )
	{
		String ls_return = ""; //$NON-NLS-1$
		try
		{
			BaseLogger.log("3",null,null, "Decrypting Password....." ); //$NON-NLS-1$
			int li_len, li_count, li_Seed, li_passAsc, li_seedcount;
			li_len = as_passwd.length();
			li_seedcount = 1;
			for(li_count = 0; li_count<li_len; li_count+=2)
			{
				li_Seed = ( ( int )as_passwd.charAt( li_count + 1 ) )  - li_seedcount ;
				li_passAsc = ( ( int )as_passwd.charAt( li_count ) ) - li_seedcount ;
				li_passAsc = li_passAsc - li_Seed;
				ls_return += ( char )( li_passAsc );
				li_seedcount++;
			}
		}
		catch(Exception e)
		{
			BaseLogger.log("0",null,null,"Exception: CommonDBAccessEJB: decrypt:==>\n"+e.getMessage()); //$NON-NLS-1$
			//throw e;
		}
		return ls_return;
	}

	//Changed By Danish on 29/08/2006 reason [to accommodate validation for siteCode]
	//public String authenticate(String mUserID,String mPassword) throws RemoteException, Exception
	/*
	Authentication Status XML format.
	<AUTH_INFO>
		<STATUS>true/false</STATUS>
		<STATUS_CODE>
			(false / RESIGNED)							Alert
			(false / LOCKED)							Alert
			(false / INVALID_USR)						Alert
			(false / INVALID_PWD)						Alert
			(true	  /	 PASS_EXP_GRACE)				Option(ChangePassword.jsp/Welcome.jsp(via AuthenticateServlet)/Welcome.jsp
			(true   / PASS_EXP_NOGRACE)					Prompt/ChangePassword.jsp/Welcome.jsp
			(true   / FIRST_LOGIN)						Prompt/ChangePassword.jsp/Welcome.jsp
			(true   / VALID)							Welcome.jsp
		</STATUS_CODE>
		<STATUS_DETAIL></STATUS_DETAIL>
	</AUTH_INFO>
	*/
	//Changed by Swapnil Shirke on 27-Sept-2010 [ WI01SUN006 ] [ To implement SHA-256 while login ] starts
	//Added By Pankaj T. on 18-11--2020 for removing weak account lock vulnerability - if user wrongly enter password more than 5 times then lock the account and send new password on email/mobile and unlock account using new password
	public String authenticate(String mUserID, String mPassword, String siteCode, String authMode, HttpServletRequest request) throws RemoteException, BaseException
	{
		//Added By Pankaj T. on 18-11--2020 for removing weak account lock vulnerability - if user wrongly enter password more than 5 times then lock the account and send new password on email/mobile and unlock account using new password
		return authenticate(mUserID, mPassword, siteCode, authMode, "false", request); //$NON-NLS-1$
	}
	//Changed by Swapnil Shirke on 27-Sept-2010 [ WI01SUN006 ] [ To implement SHA-256 while login ] ends
	//Changed by Gayatri Yadav on 18-Aug-2011 [CR1DPOL001] [To add mac address in users table] starts
	//Added By Pankaj T. on 18-11--2020 for removing weak account lock vulnerability - if user wrongly enter password more than 5 times then lock the account and send new password on email/mobile and unlock account using new password
	public String authenticate(String mUserID, String mPassword, String siteCode, String authMode, String isSHA256Appld, HttpServletRequest request ) throws RemoteException, BaseException
	{
		//Added By Pankaj T. on 18-11--2020 for removing weak account lock vulnerability - if user wrongly enter password more than 5 times then lock the account and send new password on email/mobile and unlock account using new password
		return authenticate(mUserID, mPassword, siteCode, authMode, isSHA256Appld, null, "", request );
	}
	//Changed by Gayatri Yadav on 18-Aug-2011 [CR1DPOL001] [To add mac address in users table] end
	//Changed by Gayatri Yadav on 16-Sept-2010 [ WI01SUN006 ] [ To implement SHA-256 while login ]
	//public String authenticate(String mUserID, String mPassword, String siteCode, String authMode) throws RemoteException, BaseException
	//public String authenticate(String mUserID, String mPassword, String siteCode, String authMode, String isSHA256Appld) throws RemoteException, BaseException]
	//Changed by Gayatri Yadav on 18-Aug-2011 [CR1DPOL001] [To add mac address in users table] start
	//public String authenticate(String mUserID, String mPassword, String siteCode, String authMode, String isSHA256Appld, String[] macIds) throws RemoteException, BaseException
	//Added By Pankaj T. on 18-11--2020 for removing weak account lock vulnerability - if user wrongly enter password more than 5 times then lock the account and send new password on email/mobile and unlock account using new password
	public String authenticate(String mUserID, String mPassword, String siteCode, String authMode, String isSHA256Appld, String[] macIds, String action, HttpServletRequest request ) throws RemoteException, BaseException		//Added action parameter by Sagar B. on[13-May-19]
	//Changed by Gayatri Yadav on 18-Aug-2011 [CR1DPOL001] [To add mac address in users table] end
	{
		BaseLogger.log("2",null,null,"Authenticating........."); //$NON-NLS-1$
		//Changed by Kunjal on 05/04/2007 Commented.
		//mUserID = mUserID.toUpperCase();

		StringBuffer authInfoBuf = new StringBuffer();
		StringBuffer statusBuf = new StringBuffer();
		StringBuffer statusDetailBuf = new StringBuffer();
	
		String dbpwd = null;
		//String decpwd = null;
		//Added by Nilesh on 25-Mar-2011 [SY01SUN038][Validate password from PASS_WD_SHA]
		String dbpwdsha = null;
		//Added By Shahu Mali on 08-10-13 []
		String transDB = null;
		boolean isValid = false;
		//boolean isValidCase = true;
		//vikrant 14/09/2006
		boolean isIdValid = false;
		boolean isPasswdValid = false;
		Connection mConnection = null;
		Connection transDBConnection = null;
		Statement mStatement = null;
		ResultSet mResultSet = null;
		PreparedStatement mpStatement = null;
		//changed by gayatri on 09-03-2011 [MF01SUN034] start
		boolean isAttFound = false;
		//Changed by gayatri on  18-08-2011 [CR1DPOL001]  [To add Mac-address in security feature] start
		boolean isValidMacId = false;
		
		//Changed by Gulzar on 02/08/13 :START
		String userProfileID = "";
		//End changes by Gulzar on 02/08/13 : End

		//Added by Prajyot 18MAR2014[Theme Implementation.]
		String userTheme = "";
		String uxInterface ="";//Added by Vishal Pathare on 16-AUG-2016 for[getting <UX_INTERFACE> for applying themes]
		//Added by Dnyaneshwar Chavan on 30-Jul-15 [ Implement Geo fencing functionality  ] Start
		String userGeoFence = null;
		//Added by Dnyaneshwar Chavan on 30-Jul-15 [ Implement Geo fencing functionality  ] End
		String enterprise = ""; // Added by Pankaj R on 23-Oct-17 
		String enterpriseDescr = "";	//Added by Sagar B. to show descr in slide menu panel[18-Sep-18]
		
		//Added by pankaj T. on 10-04-2020 for  Configure SMTP mail server against ENTERPRISE - start
		String smtpHost = "";
		String smtpPort = "";
		String smtpUser = "";
		String smtpPassWD = "";
		String smtpProtocolType = "";
		String smtpMailFrom = "";
        String adminEmailId = "";
        String sessTimeoutInSecs = "0";//Added by Jatin M on 24-Jun-2022 [To set prior session timeout in UserInfoBean]
        String socialOpt = ""; // Added by Jay on 13/Apr/2023 [To set social_opt from enterprise]
		//Added by pankaj T. on 10-04-2020 for  Configure SMTP mail server against ENTERPRISE - end
		
		try 
		{
			//Added by Dnyaneshwar Chavan on 26-SEP-14 [Russian character not work when retrivew parameter in jsp ] Start
			// Changed by Sandesh Shinde on 17-MAY-2017 [ Authentication API: SQL Injection] Start
			String userLang = "";
			
			PreparedStatement sqlpst = null;
			ResultSet resultSet = null;
			Connection conn = null;
		
			try
			{
				ConnDriver connDriver = new ConnDriver();
				conn = connDriver.getConnectDB( "Driver" );
				String sql	= "SELECT USER_LANG FROM USERS WHERE CODE = ?";
				sqlpst = conn.prepareStatement( sql );
				
				sqlpst.setString(1, mUserID);
				resultSet = sqlpst.executeQuery();
				
				if( resultSet.next() )
				{
					userLang = resultSet.getString( 1 );
				}
				
			}
			catch( Exception exp )
			{
				BaseLogger.log("0",null,null,"Excepton in CommonDBAccessEJB authenticate() -- >"+exp.getMessage());
				exp.printStackTrace();
			}
			finally
			{
				try
				{
					if(resultSet!=null)
					{
						resultSet.close();
						resultSet = null;
					}
					if(sqlpst != null)
					{
						sqlpst.close();
						sqlpst = null;
					}
					if(conn !=null)
					{
						conn.close();
						conn = null;
					}
				}
				catch(SQLException se)
				{
					se.printStackTrace();
					throw new ITMException(se);
				}
			}
			// Changed by Sandesh Shinde on 17-MAY-2017 [ Authentication API: SQL Injection] End
			userLang = userLang == null ? "" : userLang;
			BaseLogger.log("3",null,null, " userLang ["+userLang+"]" );
			//Added by Dnyaneshwar Chavan on 26-SEP-14 [Russian character not work when retrivew parameter in jsp ] End
			//ConnDriver mConnDriver = new ConnDriver();
 
			//Changed by Nilesh on 25-Mar-2011 [SY01SUN038][Validate password from PASS_WD_SHA]
			//String selectPassWdQuery = "SELECT PASS_WD FROM USERS WHERE CODE='"+ mUserID +"'";
			//Commented And add TRANS_DB in select query and get the value By Shahu Mali on 08-10-13[]
			//String selectPassWdQuery = "SELECT PASS_WD, PASS_WD_SHA FROM USERS WHERE CODE='"+ mUserID +"'"; //$NON-NLS-1$ //$NON-NLS-2$

			//Changes by Prajyot 18MAR2014[Theme Implementation.]
			//Changed by Dnyaneshwar Chavan on 30-Jul-15 [ Implement Geo fencing functionality  ]
			//String selectPassWdQuery = "SELECT PASS_WD, PASS_WD_SHA,TRANS_DB, USER_THEME FROM USERS WHERE CODE='"+ mUserID +"'";
			// String selectPassWdQuery = "SELECT PASS_WD, PASS_WD_SHA,TRANS_DB, USER_THEME, GEO_FENCE FROM USERS WHERE CODE='"+ mUserID +"'";

			// Commented and Change by Abhishek on 10.03.2016 [For Authentication changes] START
            //String selectPassWdQuery = "SELECT PASS_WD, PASS_WD_SHA,TRANS_DB, USER_THEME, GEO_FENCE FROM USERS WHERE CODE='"+ mUserID +"'";
            //Added by Pankaj T on 14-09-2020 for The user icon which shows detail information about user should also show Login using User id/Mobile/email and user_id/mobile/email value
            String authenticatedUsing = getAuthenticatedUsing( mUserID );
			String[] columns = {"CODE", "MOBILE_NO", "EMAIL_ID", "USER_ID"};
			String entryType = "K",
				   entryId = mUserID;
			String selectPassWdQuery = null;
			// Changed by Sandesh Shinde on 17-MAY-2017 [ Authentication API: SQL Injection] Start
			PreparedStatement sqlpstmt = null;
			ConnDriver connDriver = new ConnDriver();
			//Added by Pankaj T on 12-01-18 [changes for try-with-resource]
			try(Connection connctn = connDriver.getConnectDB( "Driver" );)
			{
				for (int i = 0; i < columns.length; i++) {
					//Added By Pankaj T. on 12-01-2021 as per suggested by Danish Sir validate active users at the time of login
					selectPassWdQuery = "SELECT CODE, PASS_WD, PASS_WD_SHA,TRANS_DB, USER_THEME, UX_INTERFACE, GEO_FENCE, ENTERPRISE FROM USERS WHERE " + 
										 columns[i] + " = ? and ( STATUS = 'A' or STATUS IS NULL )";
					
					sqlpstmt = connctn.prepareStatement( selectPassWdQuery );
					sqlpstmt.setString(1, mUserID);
					mResultSet = sqlpstmt.executeQuery();
					// Changed by Sandesh Shinde on 17-MAY-2017 [ Authentication API: SQL Injection] End	
					if (mResultSet.next()) {
						entryType = ((i == 0) ? "C" :
									 (i == 1) ? "M" :
									 (i == 2) ? "E" : "U");
						mUserID = !("C".equals(entryType)) ? mResultSet.getString("CODE") : mUserID;
						
						dbpwd = mResultSet.getString("PASS_WD"); //$NON-NLS-1$
						//Added by Nilesh on 25-Mar-2011 [SY01SUN038][Validate password from PASS_WD_SHA]
						dbpwdsha = mResultSet.getString("PASS_WD_SHA"); //$NON-NLS-1$
						transDB= mResultSet.getString("TRANS_DB");
						userTheme= mResultSet.getString("USER_THEME");
						uxInterface=mResultSet.getString("UX_INTERFACE");//Added by Vishal Pathare on 4-AUG-2016 for[getting <client_interfce> for applying themes]
						userGeoFence = mResultSet.getString("GEO_FENCE");  //Added by Dnyaneshwar Chavan on 30-Jul-15 [ Implement Geo fencing functionality  ]
						enterprise = mResultSet.getString("ENTERPRISE");
						//
						isIdValid = true;
						
						break;
					}
					
					if(mResultSet != null)
					{
						mResultSet.close();
						mResultSet = null;
					}
					
					if(sqlpstmt != null)
					{
						sqlpstmt.close();
						sqlpstmt = null;
					}
				}
				
				BaseLogger.log("3",null,null,"CommonDBAccessEJB :: authenticate() : entryType[" + entryType + "]" + 
				"  entryID[" + entryId + "] mUserID[" + mUserID + "] enterprise["+enterprise+"]");	
			}
			catch (Exception e) 
			{
				e.printStackTrace();
			}
			//BaseLogger.log("9",null,null,"Select Password :"+selectPassWdQuery);
			/*mResultSet = mStatement.executeQuery(selectPassWdQuery);
			while(mResultSet.next())
			{
				dbpwd = mResultSet.getString("PASS_WD"); //$NON-NLS-1$
				//Added by Nilesh on 25-Mar-2011 [SY01SUN038][Validate password from PASS_WD_SHA]
				dbpwdsha = mResultSet.getString("PASS_WD_SHA"); //$NON-NLS-1$
				transDB= mResultSet.getString("TRANS_DB");
				userTheme= mResultSet.getString("USER_THEME");
				userGeoFence = mResultSet.getString("GEO_FENCE");  //Added by Dnyaneshwar Chavan on 30-Jul-15 [ Implement Geo fencing functionality  ]
				isIdValid = true;
			}*/
			// Commented and Change by Abhishek on 10.03.2016 [For Authentication changes] END
			
			// Changed by Sandesh Shinde on 17-MAY-2017 [ Authentication API: SQL Injection] Start
			if(mResultSet != null)
			{
				mResultSet.close();
				mResultSet = null;
			}
			
			if(sqlpstmt != null)
			{
				sqlpstmt.close();
				sqlpstmt = null;
			}
			/*connctn.close();
			connctn = null;*/
			// Changed by Sandesh Shinde on 17-MAY-2017 [ Authentication API: SQL Injection] End
			//vishal
			ConnDriver mConnDriver = new ConnDriver();
			mConnection = mConnDriver.getConnectDB("Driver"); 
			//Added by Sagar B. to track GPS configuration on user level on [11-JAN-18]START
			String geoPosOption = "";
			String networkOption = "1";		//Added by Sagar B. to set network configuration[07-Feb-19]
			//Added by Sagar B. to set offline edit/delete configuration enterprise-wise[13-Mar-19]START
			String isAllowOfflineEdit = "Y";
			String isAllowOfflineDelete = "Y";
			//Added by Sagar B. to set offline edit configuration enterprise-wise[13-Mar-19]END
			try
			{
				if( enterprise != null || "null".equalsIgnoreCase(enterprise) )
				{
					String filename ="/" + "IBASEHOME" + File.separator + enterprise.trim() +".xml";
					BaseLogger.log("3",null,null,"AuthenticatServlet 2513 Enterprise filename::["+filename+"]");
					File fileObj = new File( filename );
					if( fileObj.exists() )
					{
						DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
						Document entDoc = documentBuilder.parse(filename);
						if( entDoc.getElementsByTagName("GEO_POS_OPTION").item(0) != null && entDoc.getElementsByTagName("GEO_POS_OPTION").item(0).getFirstChild() != null )
						{
							geoPosOption = entDoc.getElementsByTagName("GEO_POS_OPTION").item(0).getFirstChild().getNodeValue();
							BaseLogger.log("3",null,null,"CommonDBAccessEJB authenticate() 393 GEO_POS_OPTION::["+geoPosOption+"]");
						}
						if( !"0".equalsIgnoreCase( geoPosOption ) && entDoc.getElementsByTagName("GEO_FENCE_OPTION").item(0) != null && entDoc.getElementsByTagName("GEO_FENCE_OPTION").item(0).getFirstChild() != null )
						{
							//Added by Dnyaneshwar Chavan on 30-Jul-15 [ Implement Geo fencing functionality  ] Start
							BaseLogger.log("3",null,null,"userGeoFence Before: "+userGeoFence+"\n Enterprise XML GEO_FENCE_OPTION: "+entDoc.getElementsByTagName("GEO_FENCE_OPTION").item(0).getFirstChild().getNodeValue());
							//userGeoFence = ( userGeoFence == null || "null".equalsIgnoreCase(userGeoFence) ) ? CommonConstants.GEO_FENCE_ENABLED : userGeoFence;
							userGeoFence = ( userGeoFence == null || "null".equalsIgnoreCase(userGeoFence) ) ? entDoc.getElementsByTagName("GEO_FENCE_OPTION").item(0).getFirstChild().getNodeValue() : userGeoFence;
							BaseLogger.log("3",null,null,"userGeoFence After: "+userGeoFence);
							//Added by Dnyaneshwar Chavan on 30-Jul-15 [ Implement Geo fencing functionality  ] Start
						}
						//Added by Sagar B. to set network configuration[07-Feb-19]START
						if( entDoc.getElementsByTagName("NETWORK_OPTION").item(0) != null && entDoc.getElementsByTagName("NETWORK_OPTION").item(0).getFirstChild() != null )
						{
							networkOption = entDoc.getElementsByTagName("NETWORK_OPTION").item(0).getFirstChild().getNodeValue();
							BaseLogger.log("3",null,null,"CommonDBAccessEJB authenticate() 393 NETWORK_OPTION::["+networkOption+"]");
						}
						//Added by Sagar B. to set network configuration[07-Feb-19]END
						//Added by Sagar B. to set offline edit/delete configuration enterprise-wise[13-Mar-19]START
						if( entDoc.getElementsByTagName("IS_ALLOW_OFFLINE_EDIT").item(0) != null && entDoc.getElementsByTagName("IS_ALLOW_OFFLINE_EDIT").item(0).getFirstChild() != null )
						{
							isAllowOfflineEdit = entDoc.getElementsByTagName("IS_ALLOW_OFFLINE_EDIT").item(0).getFirstChild().getNodeValue();
							BaseLogger.log("3",null,null,"CommonDBAccessEJB authenticate() 485 IS_ALLOW_OFFLINE_EDIT::["+isAllowOfflineEdit+"]");
						}
						if( entDoc.getElementsByTagName("IS_ALLOW_OFFLINE_DELETE").item(0) != null && entDoc.getElementsByTagName("IS_ALLOW_OFFLINE_DELETE").item(0).getFirstChild() != null )
						{
							isAllowOfflineDelete = entDoc.getElementsByTagName("IS_ALLOW_OFFLINE_DELETE").item(0).getFirstChild().getNodeValue();
							BaseLogger.log("3",null,null,"CommonDBAccessEJB authenticate() 494 IS_ALLOW_OFFLINE_DELETE::["+isAllowOfflineDelete+"]");
						}
						//Added by Sagar B. to set offline edit/delete configuration enterprise-wise[13-Mar-19]END
					}
				}
			}
			catch( Exception e )
			{
				BaseLogger.log("3",null,null,"Exception while reading the <enterprise> XML");
			}
			//Added by Sagar B. to track GPS configuration on user level on [11-JAN-18]END
			
			//Added by Nilesh on 25-Mar-2011 [SY01SUN038][Validate password from PASS_WD_SHA]Start
			if( "true".equals( isSHA256Appld ) && dbpwdsha !=null ) //$NON-NLS-1$
			{
				//BaseLogger.log("9",null,null,"mPassword["+mPassword+"]");
				//BaseLogger.log("9",null,null,"dbpwdsha["+dbpwdsha+"]");
				if( mPassword.equals( dbpwdsha ) )
				{
					isValid = true;
					isPasswdValid = true;
				}
			}
			//Added by Nilesh on 25-Mar-2011 [SY01SUN038][Validate password from PASS_WD_SHA]End
			//Commented by Nilesh on 25-Mar-2011 [SY01SUN038][Validate password from PASS_WD_SHA]
			//if( dbpwd !=null )//&& ! mPassword.equals( dbpwd ) )
			else if( dbpwd !=null )
			{
				//Added by Dnyaneshwar Chavan on 26-SEP-14 [Russian character not work when retrivew parameter in jsp ] Start
				String decpwd = "";
				if( "ru".equalsIgnoreCase(userLang) )
				{
					decpwd = dbpwd;
				}
				else
				{
					decpwd = decrypt( dbpwd );
				}
				//Added by Dnyaneshwar Chavan on 26-SEP-14 [Russian character not work when retrivew parameter in jsp ] End
				//Comment by Nilesh on 26-Mar-2011 [SY01SUN038][Validate password from PASS_WD_SHA]
//				BaseLogger.log("9",null,null,"decpwd before sha= "+decpwd);
				//Changed by Gayatri Yadav on 16-Sept-2010 [ WI01SUN006 ] [ To implement SHA-256 while login ] starts
//				if("true".equalsIgnoreCase(isSHA256Appld))
//				{
//					decpwd =convertIntoSHA256(decpwd);
//					
//				}
				//BaseLogger.log("9",null,null,"Before decrypt["+dbpwd+"]");
				//Comment by Nilesh on 26-Mar-2011 [SY01SUN038][Validate password from PASS_WD_SHA]End
				//BaseLogger.log("9",null,null,"decpwd["+decpwd+"]");
				//BaseLogger.log("9",null,null,"mPassword["+mPassword+"]");
				//Changed by Gayatri Yadav on 16-Sept-2010 [ WI01SUN006 ] [ To implement SHA-256 while login ] ends
				//Change by Nilesh on 26-Mar-2011 [SY01SUN038][Validate password from PASS_WD_SHA]
				//if( mPassword.equals( decpwd ) )
				if( mPassword.equals( decpwd ) || mPassword.equals( convertIntoSHA256(decpwd) ) )
				{
					isValid = true;
					isPasswdValid = true;
					//Added by Nilesh on 25-Mar-2011 [SY01SUN038][Validate password from PASS_WD_SHA]
					updatePassWdSha( mUserID, decpwd );
				}
				//Changed by Gayatri Yadav on 30-Sept-2010 [ WI01SUN006 ] [ To implement SHA-256 while login ] 
				//else if( mPassword.equals( dbpwd ) )
				else if( mPassword.equals( dbpwd ) || mPassword.equals( convertIntoSHA256(dbpwd )))
				{
					isValid = true;
					isPasswdValid  = true;
					//Added by Nilesh on 25-Mar-2011 [SY01SUN038][Validate password from PASS_WD_SHA]
					updatePassWdSha( mUserID, dbpwd );
					//Changed by Dhruv on 02/05/2007 to forcibly encrypting password for case where password not encrypted.
					if( CommonConstants.ENCRYPT_PWD )
					{
						// Changed by Sandesh Shinde on 17-MAY-2017 [ Authentication API: SQL Injection]
						String sqlQuery = "UPDATE USERS SET PASS_WD = ? WHERE CODE = ?"; //$NON-NLS-1$ //$NON-NLS-2$
						PreparedStatement pstmt = mConnection.prepareStatement( sqlQuery );
						//Changed by Gayatri Yadav on 30-Sept-2010 [ WI01SUN006 ] [ To implement SHA-256 while login ] 
						//pstmt.setString( 1, encrypt( mPassword ) );
						//Added by Dnyaneshwar Chavan on 26-SEP-14 [Russian character not work when retrivew parameter in jsp ] Start
						//pstmt.setString( 1,  encrypt( dbpwd )  );
						if( "ru".equalsIgnoreCase(userLang) )
						{
							pstmt.setString( 1, dbpwd );
						}
						else
						{
							pstmt.setString( 1,  encrypt( dbpwd )  );
						}
						// Changed by Sandesh Shinde on 17-MAY-2017 [ Authentication API: SQL Injection]
						pstmt.setString( 2, mUserID );
						//Added by Dnyaneshwar Chavan on 26-SEP-14 [Russian character not work when retrivew parameter in jsp ] End
						int rowCnt = pstmt.executeUpdate();
						pstmt.close();
						pstmt = null;
						mConnection.commit();
					}
				}
				//Changed by Gayatri on 12-March-2012[WI1LBAS001][Password verification]start
				else if(dbpwdsha != null && convertIntoSHA256(mPassword).equals(dbpwdsha))
				{
					isValid = true;
					isPasswdValid = true;
					if( CommonConstants.ENCRYPT_PWD )
					{
						// Changed by Sandesh Shinde on 17-MAY-2017 [ Authentication API: SQL Injection]
						String sqlQuery = "UPDATE USERS SET PASS_WD = ? WHERE CODE = ?"; //$NON-NLS-1$ //$NON-NLS-2$
						PreparedStatement pstmt = mConnection.prepareStatement( sqlQuery );
						//Added by Dnyaneshwar Chavan on 26-SEP-14 [Russian character not work when retrivew parameter in jsp ] Start
						//pstmt.setString( 1, encrypt( mPassword ) );
						if( "ru".equalsIgnoreCase(userLang) )
						{
							pstmt.setString( 1, dbpwd );
						}
						else
						{
							pstmt.setString( 1,  encrypt( dbpwd )  );
						}
						// Changed by Sandesh Shinde on 17-MAY-2017 [ Authentication API: SQL Injection]
						pstmt.setString( 2, mUserID );
						//Added by Dnyaneshwar Chavan on 26-SEP-14 [Russian character not work when retrivew parameter in jsp ] End
						int rowCnt = pstmt.executeUpdate();
						pstmt.close();
						pstmt = null;
						mConnection.commit();
					}
					
				}
				else if (mPassword.equals(dbpwd))
				{
					isValid = true;
					isPasswdValid = true;
					updatePassWdSha( mUserID, dbpwd );
					if( CommonConstants.ENCRYPT_PWD )
					{
						// Changed by Sandesh Shinde on 17-MAY-2017 [ Authentication API: SQL Injection]
						String sqlQuery = "UPDATE USERS SET PASS_WD = ? WHERE CODE = ?"; //$NON-NLS-1$ //$NON-NLS-2$
						PreparedStatement pstmt = mConnection.prepareStatement( sqlQuery );
						//Added by Dnyaneshwar Chavan on 26-SEP-14 [Russian character not work when retrivew parameter in jsp ] Start
						//pstmt.setString( 1, encrypt( dbpwd ) );
						if( "ru".equalsIgnoreCase(userLang) )
						{
							pstmt.setString( 1, dbpwd );
						}
						else
						{
							pstmt.setString( 1,  encrypt( dbpwd )  );
						}
						// Changed by Sandesh Shinde on 17-MAY-2017 [ Authentication API: SQL Injection]
						pstmt.setString( 2, mUserID );
						//Added by Dnyaneshwar Chavan on 26-SEP-14 [Russian character not work when retrivew parameter in jsp ] End
						int rowCnt = pstmt.executeUpdate();
						pstmt.close();
						pstmt = null;
						mConnection.commit();
					}
				}
				else 
				{
					BaseLogger.log("3",null,null,"password not matched");
				}
				//Changed by Gayatri on 12-March-2012[WI1LBAS001][Password verification]end
				
			}
			/*if (!isValid)
			{
				if (mPassword!=null && dbpwd!=null)
				{
					if(mPassword.toUpperCase().equals(dbpwd.toUpperCase()))  
					{
						isValidCase = false;
					}
					else if(dbpwd!=null && !mPassword.equals(dbpwd))
					{
						String decpwd = decrypt(dbpwd);
						if(mPassword.toUpperCase().equals(decpwd.toUpperCase()))
						{
							isValidCase = false;
						}
					}
				}
			}*/

			authInfoBuf.append("<AUTH_INFO>"); //$NON-NLS-1$
			statusDetailBuf.append("<STATUS_DETAIL>"); //$NON-NLS-1$
			//Changed by gayatri on 04-03-2011 [MF01SUN034] start
			BaseLogger.log("3",null,null,"isValid TEST= "+isValid); //$NON-NLS-1$
			//Added by Pankaj T on 19-12-17 [for multitenancy Added new trasDBConnection] - Start
			if(isValid)
			{
				BaseLogger.log("3",null,null,"transDB if valid login =[ "+transDB+" ]");
				ConnDriver transDBConnDriver = new ConnDriver();
				transDBConnection = transDBConnDriver.getConnectDB(transDB);
			}
			//Added by Pankaj T on 19-12-17 [for multitenancy Added new trasDBConnection] - End
			if(isValid)
			{
				// Changed by Sandesh Shinde on 17-MAY-2017 [ Authentication API: SQL Injection] Start
				PreparedStatement getAtDnStmt = null;
				ResultSet getAtDnRs = null;
				String getAtDnSql ="SELECT EMP_CODE, ASCERTAIN_ATTENDANCE FROM USERS WHERE CODE = ?"; //$NON-NLS-1$ //$NON-NLS-2$
			//	BaseLogger.log("9",null,null,"getAtDnSql = "+getAtDnSql);
				getAtDnStmt = mConnection.prepareStatement( getAtDnSql );
				getAtDnStmt.setString(1, mUserID);
				getAtDnRs = getAtDnStmt.executeQuery();
				// Changed by Sandesh Shinde on 17-MAY-2017 [ Authentication API: SQL Injection] End
				if (getAtDnRs.next())
				{
					String isCheckAttendance = getAtDnRs.getString("ASCERTAIN_ATTENDANCE"); //$NON-NLS-1$
					BaseLogger.log("3",null,null,"isCheckAttendance = "+isCheckAttendance); //$NON-NLS-1$
					if(isCheckAttendance != null && isCheckAttendance.equalsIgnoreCase("Y")) //$NON-NLS-1$
					{
						Calendar now = Calendar.getInstance();
						SimpleDateFormat formatter = new SimpleDateFormat("dd-MMM-yyyy"); //$NON-NLS-1$
						String currentDate = formatter.format(now.getTime());
						BaseLogger.log("3",null,null,"date = " + currentDate); //$NON-NLS-1$
						
						Statement getAtDnEryStmt = null;
						ResultSet getAtDnEryRs = null;
						String empCode = getAtDnRs.getString("EMP_CODE"); //$NON-NLS-1$
						
						//Commented and changed by Bhushan on 19-JAN-15 :Start
						//If for current date does not exist then it will check for previous day where out_time is null and in_time >='18:00'
						Calendar calObj = Calendar.getInstance();
					    calObj.add(Calendar.DATE, -1);
					    String prevDate = formatter.format(calObj.getTime());
					    BaseLogger.log("3",null,null,"prevDate = " + prevDate);
					    
						//String getAtDnErySql = "SELECT COUNT(*) FROM ATTENDANCE_DAY WHERE EMP_CODE = '"+empCode+"' AND ATTD_DATE = '"+currentDate+"'"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
					    //Removed the out_time is null from query by bhushan on 21/01/15 : START
						//String getAtDnErySql = "SELECT COUNT(*) FROM ATTENDANCE_DAY WHERE EMP_CODE = '"+empCode+"' AND (ATTD_DATE = '"+currentDate+"' OR (ATTD_DATE = '"+prevDate+"' AND OUT_TIME IS NULL AND IN_TIME >='18:00'))";
					    //Commented and changed by Bhushan on 01-JUL-15 :Start[Changes in_time 18.00 to 15.00 asper requirement ]
					    //String getAtDnErySql = "SELECT COUNT(*) FROM ATTENDANCE_DAY WHERE EMP_CODE = '"+empCode+"' AND (ATTD_DATE = '"+currentDate+"' OR (ATTD_DATE = '"+prevDate+"' AND IN_TIME >='18:00'))";
					    String getAtDnErySql = "SELECT COUNT(*) FROM ATTENDANCE_DAY WHERE EMP_CODE = '"+empCode+"' AND (ATTD_DATE = '"+currentDate+"' OR (ATTD_DATE = '"+prevDate+"' AND IN_TIME >='15:00'))";
					    //Commented and changed by Bhushan on 01-JUL-15 :END
					    //Removed the out_time is null from query by bhushan on 21/01/15 : END
						//Commented and changed by Bhushan on 19-JAN-15 :End
						
						//BaseLogger.log("9",null,null,"getAtDnErySql = "+getAtDnErySql);
						//Added by Pankaj T on 19-12-17 [for multitenancy Added new trasDBConnection]
						getAtDnEryStmt = transDBConnection.createStatement();
						//getAtDnEryStmt = mConnection.createStatement();
						getAtDnEryRs = getAtDnEryStmt.executeQuery(getAtDnErySql);
						if(getAtDnEryRs.next())
						{
							if (getAtDnEryRs.getInt(1)>0)
							{
								isValid = true;
								isAttFound = true;
							}
							else
							{
								isValid = false;
								isAttFound = false;
							}
						}
						getAtDnEryRs.close();
						getAtDnEryRs = null;
						getAtDnEryStmt.close();
						getAtDnEryStmt = null;
					}
					else
					{
						isValid = true;
						//Changed by gayatri on  18-08-2011 [CR1DPOL001]  [To Mac-address in users table]
						isAttFound = true;
					}				
				}
				getAtDnRs.close();
				getAtDnRs = null;
				getAtDnStmt.close();
				getAtDnStmt= null;
				BaseLogger.log("3",null,null,"isValid is here= "+isValid); //$NON-NLS-1$
			}
			//Changed by gayatri on 04-03-2011 [MF01SUN034] end
			//Changed by gayatri on  18-08-2011 [CR1DPOL001]  [To add Mac-address in security feature] start
			if(isValid)
			{
				PreparedStatement pstmt = null;
				ResultSet rs = null;
				try
				{
					String addnlSec = ""; //$NON-NLS-1$
					String device_id = ""; //$NON-NLS-1$
					String getAddnlSecVal = "SELECT ADDNL_SECURITY, DEVICE_ID FROM USERS WHERE CODE = ?";  //$NON-NLS-1$
					pstmt = mConnection.prepareStatement(getAddnlSecVal);
					pstmt.setString(1, mUserID);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						addnlSec = rs.getString(1);
						device_id = rs.getString(2);
					}
					//added by rakesh kumar 17/12/12
					if(rs !=null)
					{
						rs.close();
						rs =null;
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					//added by rakesh kumar 17/12/12
					
					//BaseLogger.log("9",null,null,"addnlSec ["+addnlSec+"]");
					//BaseLogger.log("9",null,null,"device_id ["+device_id+"]");
					
					if(addnlSec != null && addnlSec.length()>0 && addnlSec != "0" && macIds != null && macIds.length > 1) //$NON-NLS-1$
					{
						String macAddress = macIds[0];
						String macAddressAddnl = macIds[1]; 
						
						if("1".equals(addnlSec)) //$NON-NLS-1$
						{
							PreparedStatement pst = null;
							ResultSet rst = null;
							try
							{
								String getAllowedDevice = "SELECT DEVICE_ID FROM DEVICE_AUTH WHERE DEVICE_ID IN('"+macAddress.toUpperCase()+"','"+macAddressAddnl.toUpperCase()+"','"+macAddressAddnl.toLowerCase()+"','"+macAddressAddnl.toLowerCase()+"')"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$
								//BaseLogger.log("9",null,null,"getAllowedDevice ["+getAllowedDevice+"]"); 
								//Added by Pankaj T on 19-12-17 [for multitenancy Added new trasDBConnection]
								pst = transDBConnection.prepareStatement(getAllowedDevice);
								//pst = mConnection.prepareStatement(getAllowedDevice);
								rst = pst.executeQuery();
								if(rst.next())
								{
									isValid = true;
									isValidMacId = true;
								}
								else
								{
									isValid = false;
									isValidMacId = false;
								}
								//added by rakesh kumar 17/12/12
								if(rst !=null)
								{
									rst.close();
									rst =null;
								}
								if(pst != null)
								{
									pst.close();
									pst = null;
								}
								// ended by rakesh kumar 17/12/12 	
							}
							catch(Exception e)
							{
								e.printStackTrace();
								if(pst != null)
								{
									pst.close();
									pst = null;
								}
								if(rst !=null)
								{
									rst.close();
									rst =null;
								}
							}
						}
						else if("2".equals(addnlSec)) //$NON-NLS-1$
						{
							//BaseLogger.log("9",null,null,"macAddress ["+macAddress+"]");
							//BaseLogger.log("9",null,null,"macAddressAddnl ["+macAddressAddnl+"]");
							if(device_id != null)
							{
								if(!device_id.equalsIgnoreCase(macAddress) && !device_id.equalsIgnoreCase(macAddressAddnl))
								{
									  isValid = false;
									  isValidMacId = false;
								}
								else
								{
									isValid = true;
									isValidMacId = true;
								}
							}
							else
							{
								BaseLogger.log("3",null,null,"device_id is ["+device_id+"]"); //$NON-NLS-1$ //$NON-NLS-2$
								isValid = false;
								isValidMacId = false;
							}
						}
						else if("0".equals(addnlSec)) //$NON-NLS-1$
						{
							BaseLogger.log("3",null,null,"addnlSec ["+addnlSec+"]"); //$NON-NLS-1$ //$NON-NLS-2$
							isValid = true;
							isValidMacId = true;
						}	 
						
					}
					else
					{
						BaseLogger.log("3",null,null,"addnlSec is ["+addnlSec+"]"); //$NON-NLS-1$ //$NON-NLS-2$
						isValid = true;
						isValidMacId = true;
					}
					
				}
				catch(Exception e)
				{
					e.printStackTrace();
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					if(rs !=null)
					{
						rs.close();
						rs =null;
					}
				}
				
			}
			//Changed by gayatri on 18-08-2011 [CR1DPOL001]  [To add Mac-address in security feature]  start
			
			if ( isValid )
			{
				//Changed by Pragyan on 11/08/07 to add profile_id_res.
				//String mQuery = "SELECT USR_LEV, RCP_CACHE_STATUS,PROFILE_ID,PASSWD_FREQ,LAST_PWD_CHGDATE,ACCT_LOCK,LOGIN_FIRST,GRACE_LOGIN_CNT, SITE_CODE__DEF, VALID_UPTO FROM  USERS WHERE CODE = '"+mUserID+"'" ;
				//Changed by Rupali Hande on 26-08-2008 [to add the RIA_CACHE_STATUS in authenticate status xml]Request ID:-[BI89SUN007]
				//String mQuery = "SELECT NAME,USR_LEV, RCP_CACHE_STATUS,PROFILE_ID,PASSWD_FREQ,LAST_PWD_CHGDATE,ACCT_LOCK,LOGIN_FIRST,GRACE_LOGIN_CNT, SITE_CODE__DEF, VALID_UPTO,PROFILE_ID__RES FROM  USERS WHERE CODE = '"+mUserID+"'";
				
				//Changes by Gulzar on 02/08/13 to get the profile_id from user_site table and if not found then get from user table: START
				String userSiteSql = "SELECT PROFILE_ID FROM USER_SITE WHERE USER_ID= ? AND SITE_CODE = ?";
				//Added by Pankaj T on 19-12-17 [for multitenancy Added new trasDBConnection]
				//PreparedStatement pstmtUserSite = transDBConnection.prepareStatement(userSiteSql);
				//Changed By Pankaj T on 18-01-18 add try with resource for creating PrepareStatement - start
				try(PreparedStatement pstmtUserSite = transDBConnection.prepareStatement(userSiteSql);) 
				{
					//PreparedStatement pstmtUserSite = mConnection.prepareStatement(userSiteSql);
					pstmtUserSite.setString(1, mUserID);
					pstmtUserSite.setString(2, siteCode);
					try(ResultSet rsUserSite = pstmtUserSite.executeQuery();)
					{
						//ResultSet rsUserSite = pstmtUserSite.executeQuery();
						if(rsUserSite.next())
						{
							userProfileID = (rsUserSite.getString("PROFILE_ID") == null)?"":rsUserSite.getString("PROFILE_ID").trim();
						}
					}
				} 
				catch (Exception e) 
				{
					e.printStackTrace();
				}
				//Changed By Pankaj T on 18-01-18 add try with resource for creating PrepareStatement - end
				 
				//rsUserSite.close(); rsUserSite = null;
				//pstmtUserSite.close(); pstmtUserSite = null;
				//End changes by Gulzar on 02/08/13
				
				// Changed by Sandesh Shinde on 17-MAY-2017 [ Authentication API: SQL Injection] Start
				//Changed By Pankaj T. on 21-10-19 set USER_CODE, MOBILE_NO, EMAIL_ID of user in userInfo
				String mQuery = "SELECT NAME,USR_LEV, RCP_CACHE_STATUS,PROFILE_ID,PASSWD_FREQ,LAST_PWD_CHGDATE,ACCT_LOCK,LOGIN_FIRST,GRACE_LOGIN_CNT, SITE_CODE__DEF, VALID_UPTO,PROFILE_ID__RES,RIA_CACHE_STATUS,EXT_RELVE_DATE_ACC,USER_ID,MOBILE_NO,EMAIL_ID FROM  USERS WHERE CODE = ?"; //$NON-NLS-1$ //$NON-NLS-2$
                BaseLogger.log("3",null,null," CommonDBAcessEJB :: authenticate : mQuery["+mQuery+"]");//Added By Umakanta on 23/AUG/14 For Invalid site code.
                mpStatement = mConnection.prepareStatement(mQuery);
                mpStatement.setString(1, mUserID);
				mResultSet=	mpStatement.executeQuery();
				// Changed by Sandesh Shinde on 17-MAY-2017 [ Authentication API: SQL Injection] End
				while (mResultSet.next())
				{
					//Changes made by Gulzar on 02/08/13 get the profile id from user_site table first and if not found then take from user table : START
					if(userProfileID == null || userProfileID.trim().length() == 0)
					{
						userProfileID = (mResultSet.getString("PROFILE_ID") == null)?"":mResultSet.getString("PROFILE_ID").trim();
					}
					//Changes by Gulzar on 02/08/13 : END
					BaseLogger.log("3",null,null," CommonDBAcessEJB :: authenticate : Before retrieve siteCode from user table["+siteCode+"]");//Added By Umakanta on 23/AUG/14 For Invalid site code.
					if ( siteCode == null || ( siteCode != null && siteCode.trim().length() == 0 ) )
					{
						siteCode = mResultSet.getString("SITE_CODE__DEF"); //$NON-NLS-1$
						BaseLogger.log("3",null,null," CommonDBAcessEJB :: authenticate : After retrieve siteCode from user table["+siteCode+"]");//Added By Umakanta on 23/AUG/14 For Invalid site code.
					}
					
					//Changed by Manish on 06/10/2006 to solve the bug of INVALID_SITE. Start
					/*if ( ! isValidSite(mUserID, siteCode) )
					{
						 statusDetailBuf.append("<SITE_CODE><![CDATA[INVALIDSITE]]></SITE_CODE>");
					}
					else
					{
						statusDetailBuf.append("<SITE_CODE><![CDATA["+siteCode+"]]></SITE_CODE>");
					}*/
					
					// Added by Abhishek on 10.03.2016 [Req Id : S15LBAS004 Authentication changes] START
					statusDetailBuf.append("<USER_CODE><![CDATA[" + mUserID + "]]></USER_CODE>");
					statusDetailBuf.append("<ENTRY_ID><![CDATA[" + entryId + "]]></ENTRY_ID>");
					statusDetailBuf.append("<ENTRY_TYPE><![CDATA[" + entryType + "]]></ENTRY_TYPE>");
					// Added by Abhishek on 10.03.2016 [Req Id : S15LBAS004 Authentication changes] END
					//Changed By Pankaj T. on 21-10-19 set USER_CODE, MOBILE_NO, EMAIL_ID of user in userInfo - start
					statusDetailBuf.append("<USER_ID><![CDATA["+mResultSet.getString("USER_ID")+"]]></USER_ID>");
					statusDetailBuf.append("<MOBILE_NO><![CDATA["+mResultSet.getString("MOBILE_NO")+"]]></MOBILE_NO>");
					statusDetailBuf.append("<EMAIL_ID><![CDATA["+mResultSet.getString("EMAIL_ID")+"]]></EMAIL_ID>");
					//Changed By Pankaj T. on 21-10-19 set USER_CODE, MOBILE_NO, EMAIL_ID of user in userInfo - end
					// Added by Sandeshs 09-Feb-2016 [Req:S15JBAS002 Social Post] START
					statusDetailBuf.append("<USER_NAME><![CDATA["+mResultSet.getString("NAME")+"]]></USER_NAME>");
					// Added by Sandeshs 09-Feb-2016 [Req:S15JBAS002 Social Post] END
					//Added by Pankaj T on 19-12-17 [for multitenancy Added new trasDBConnection]
					siteCode = getSiteAccessStatus( transDBConnection, mUserID, siteCode, mResultSet.getString("USR_LEV") ); //$NON-NLS-1$
					//siteCode = getSiteAccessStatus( mConnection, mUserID, siteCode, mResultSet.getString("USR_LEV") ); //$NON-NLS-1$
					//BaseLogger.log("9",null,null," Dnyaneshwar **** siteCode["+siteCode+"]");
					if ( "INVALID_SITE".equalsIgnoreCase( siteCode ) || "INACCESSIBLE_SITE".equalsIgnoreCase( siteCode ) ) //Added by Dnyaneshwar Chavan on 7-MAY-14 [ User should not be login when site value are 'INVALID_SITE' and 'INACCESSIBLE_SITE'  ]
					{
						statusBuf.append("<STATUS><![CDATA[true]]></STATUS>"); //$NON-NLS-1$
						statusBuf.append("<STATUS_CODE><![CDATA[VALID]]></STATUS_CODE>");
					}
					statusDetailBuf.append("<SITE_CODE><![CDATA["+siteCode+"]]></SITE_CODE>"); //$NON-NLS-1$ //$NON-NLS-2$
					//Changed by Manish on 06/10/2006 to solve the bug of INVALID_SITE. End

					boolean isResigned = false;
					
					boolean dtJoin = false; //Added By Nilesh for DateofJoin
					// Changed by Sandesh Shinde on 17-MAY-2017 [ Authentication API: SQL Injection] Start

					//added By Nilesh Start :: 06-02-18 RELIEVE_DATE vaidation
					//String mQuery1 = "SELECT EMP_CODE, EMP_FNAME, EMP_MNAME, EMP_LNAME,STATUS FROM EMPLOYEE WHERE EMP_CODE = (SELECT EMP_CODE FROM USERS WHERE CODE = ?)" ; //$NON-NLS-1$ //$NON-NLS-2$
					String mQuery1 = "SELECT EMP_CODE, EMP_FNAME, EMP_MNAME, EMP_LNAME,STATUS,RELIEVE_DATE,DATE_JOIN FROM EMPLOYEE WHERE EMP_CODE = (SELECT EMP_CODE FROM USERS WHERE CODE = ?)" ; //$NON-NLS-1$ //$NON-NLS-2$

					//Added by Pankaj T on 19-12-17 [for multitenancy Added new trasDBConnection]
					PreparedStatement mStatement1 = transDBConnection.prepareStatement(mQuery1);
					//PreparedStatement mStatement1 = mConnection.prepareStatement(mQuery1);
					mStatement1.setString(1, mUserID);
					ResultSet mResultSet1 = mStatement1.executeQuery();
					// Changed by Sandesh Shinde on 17-MAY-2017 [ Authentication API: SQL Injection] End
					if (mResultSet1.next())
					{
						String status = mResultSet1.getString("STATUS"); //$NON-NLS-1$
						
						//added By Nilesh Start :: 06-02-18 RELIEVE_DATE vaidation
						java.util.Date relivDate=null;
						int relDate=0;
						E12GenericUtility genericUtility = new E12GenericUtility();
						ValidatorEJB  validatorEjb=new ValidatorEJB();
						
						//Get the Calendar date Start:: 07-02-18  
						Calendar now = Calendar.getInstance();
						SimpleDateFormat formatter = new SimpleDateFormat(CommonConstants.DB_DATETIME_FORMAT); //$NON-NLS-1$
						String currentDate = formatter.format(now.getTime());
						BaseLogger.log("3",null,null,"currentDate = " + currentDate); //$NON-NLS-1$
						
						//Get the Calendar date End:: 07-02-18 
						
						//convert current date  getDBDateTimeFormat to  getApplDateFormat 
						String curDate = genericUtility.getValidDateString( currentDate , genericUtility.getDBDateTimeFormat() , genericUtility.getApplDateFormat());
						BaseLogger.log("3",null,null,"curDate = " + curDate);
						java.util.Date currDate = validatorEjb.getDateObject( curDate );
						BaseLogger.log("3",null,null,"currDate = " + currDate); //$NON-NLS-1$
						//convert current date  getDBDateTimeFormat to  getApplDateFormat 
						
						//get the RELIEVE_DATE
						String reliveDate = mResultSet1.getString("RELIEVE_DATE");
						String dateJoin = E12GenericUtility.checkNull(mResultSet1.getString("DATE_JOIN"));
						BaseLogger.log("3",null,null,"relieveDate::"+reliveDate);
						BaseLogger.log("3",null,null,"dateJoin::"+dateJoin);
						//Added By Nilesh if datejoin is null then not able to login End :: 09-01-2020
						if ( dateJoin.trim().length() == 0) //$NON-NLS-1$
						{
							 statusBuf.append("<STATUS><![CDATA[false]]></STATUS>"); //$NON-NLS-1$
							 statusBuf.append("<STATUS_CODE><![CDATA[JOINDATE]]></STATUS_CODE>"); //$NON-NLS-1$
							 dtJoin = true;
						}
						//Added By Nilesh if datejoin is null then not able to login End :: 09-01-2020
						if(reliveDate!=null && reliveDate.length() > 0)
						{
							
						reliveDate = genericUtility.getValidDateString( reliveDate , genericUtility.getDBDateTimeFormat() , genericUtility.getApplDateFormat());
						relivDate = validatorEjb.getDateObject( reliveDate );
						BaseLogger.log("3",null,null,"relivDate"+relivDate);
						BaseLogger.log("3",null,null,"currDate.compareTo( relivDate )"+currDate.compareTo( relivDate ));
						relDate=currDate.compareTo( relivDate );
						BaseLogger.log("3",null,null,"relDate::"+relDate);
						
						}
						
						
						if (status != null && ("S").equalsIgnoreCase(status)) //$NON-NLS-1$
						{
							 statusBuf.append("<STATUS><![CDATA[false]]></STATUS>"); //$NON-NLS-1$
							 statusBuf.append("<STATUS_CODE><![CDATA[RESIGNED]]></STATUS_CODE>"); //$NON-NLS-1$
							 isResigned = true;
						}
						else if (relDate > 0 ) //$NON-NLS-1$
						{
							//Added by Sagar B. to login user even after release date till valid upto date[07-May-19]START
							boolean empReleased = true;
							/*java.sql.Date validUpto = mResultSet.getDate("VALID_UPTO"); //$NON-NLS-1$
							if( validUpto != null )
							{
								Calendar calendar = Calendar.getInstance();
								calendar.setTime( validUpto );
								calendar.add( Calendar.DATE, 1 );
								java.util.Date validUptoNext = calendar.getTime();
								java.sql.Date currTime =new java.sql.Date(System.currentTimeMillis());
								BaseLogger.log("3",null,null,"currTime validUpto::"+currTime);
								BaseLogger.log("3",null,null,"validUptoNext validUpto::"+validUptoNext);
								if( currTime.before( validUptoNext ) )
								{
									empReleased = false;
								}
							}*/
							//Added by Sagar B. to login user even after release date till valid upto date[07-May-19]END
							
							//Added by Nilesh Gunjal. to login user even after release date till release date + EXT_RELVE_DATE_ACC Days Start
							java.sql.Date relieveDate = mResultSet1.getDate("RELIEVE_DATE"); //$NON-NLS-1$
							int extRelveDate = mResultSet.getInt("EXT_RELVE_DATE_ACC");
							BaseLogger.log("3",null,null,"relieveDate::"+relieveDate);
							BaseLogger.log("3",null,null,"extRelveDate::"+extRelveDate);
							if( relieveDate != null )
							{
								Calendar calendar = Calendar.getInstance();
								calendar.setTime( relieveDate );
								calendar.add( Calendar.DATE, extRelveDate +1 );
								java.util.Date validUptoNext = calendar.getTime();
								java.sql.Date currTime =new java.sql.Date(System.currentTimeMillis());
								BaseLogger.log("3",null,null,"currTime::"+currTime);
								BaseLogger.log("3",null,null,"validUptoNext::"+validUptoNext);
								if( currTime.before( validUptoNext ) )
								{
									BaseLogger.log("3",null,null,"validation Not occur::"+validUptoNext);
									empReleased = false;
								}
							}
							
							//Added by Nilesh Gunjal. to login user even after release date till release date + EXT_RELVE_DATE_ACC Days End
							if( empReleased )
							{
								//added By Nilesh End :: 06-02-18 RELIEVE_DATE vaidation
								 statusBuf.append("<STATUS><![CDATA[false]]></STATUS>"); //$NON-NLS-1$
								 statusBuf.append("<STATUS_CODE><![CDATA[RELEASE]]></STATUS_CODE>"); //$NON-NLS-1$
								 isResigned = true;
							}
						}
						else
						{	
							if ("I".equalsIgnoreCase(authMode)) //$NON-NLS-1$
							{
								statusDetailBuf.append("<EMP_CODE><![CDATA["+mResultSet1.getString("EMP_CODE")+"]]></EMP_CODE>"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
								statusDetailBuf.append("<EMP_FNAME><![CDATA["+mResultSet1.getString("EMP_FNAME")+"]]></EMP_FNAME>"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
								statusDetailBuf.append("<EMP_MNAME><![CDATA["+mResultSet1.getString("EMP_MNAME")+"]]></EMP_MNAME>"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
								statusDetailBuf.append("<EMP_LNAME><![CDATA["+mResultSet1.getString("EMP_LNAME")+"]]></EMP_LNAME>"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
							}
						}
					}//if (mResultSet1.next())
					mResultSet1.close();
					mResultSet1 = null;
					mStatement1.close();
					mStatement1 = null;
					//Added By Nilesh if datejoin is null then not able to login End :: 09-01-2020
					//if ( !isResigned && !"INVALID_SITE".equalsIgnoreCase( siteCode ) && !"INACCESSIBLE_SITE".equalsIgnoreCase( siteCode ) ) //Added by Dnyaneshwar Chavan on 7-MAY-14 [ User should not be login when site value are 'INVALID_SITE' and 'INACCESSIBLE_SITE'  ]
					if ( ! dtJoin && !isResigned && !"INVALID_SITE".equalsIgnoreCase( siteCode ) && !"INACCESSIBLE_SITE".equalsIgnoreCase( siteCode ) ) //Added by Dnyaneshwar Chavan on 7-MAY-14 [ User should not be login when site value are 'INVALID_SITE' and 'INACCESSIBLE_SITE'  ]
					{
						String accLock = mResultSet.getString("ACCT_LOCK"); //$NON-NLS-1$
						//Changed By Pankaj T. on 13-07-2020 for removing vulnerability of weak account lock policy - start
						String firstLogin = mResultSet.getString("LOGIN_FIRST");
						BaseLogger.log("3",null,null,"CommonDBAccessEJB.authenticate() acctLock :["+accLock+"]");
						BaseLogger.log("3",null,null,"CommonDBAccessEJB.authenticate() firstLogin :["+firstLogin+"]");
						//if( accLock != null && ( "Y" ).equalsIgnoreCase( accLock.trim() ) ) //$NON-NLS-1$
						if( accLock != null && ( "Y" ).equalsIgnoreCase( accLock.trim() ) && ( !((("Y").equalsIgnoreCase(E12GenericUtility.checkNull(firstLogin)) || ("1").equalsIgnoreCase(E12GenericUtility.checkNull(firstLogin)))) ) ) //$NON-NLS-1$
						//Changed By Pankaj T. on 13-07-2020 for removing vulnerability of weak account lock policy - end
						{
							statusBuf.append("<STATUS><![CDATA[false]]></STATUS>"); //$NON-NLS-1$
							statusBuf.append("<STATUS_CODE><![CDATA[LOCKED]]></STATUS_CODE>"); //$NON-NLS-1$
						}
						else
						{
							boolean validAccount = true;
							if(accLock != null && ("N").equalsIgnoreCase(accLock.trim())) //$NON-NLS-1$
							{
								java.sql.Date validUpto = mResultSet.getDate("VALID_UPTO"); //$NON-NLS-1$
								java.sql.Date currTime =new java.sql.Date(System.currentTimeMillis());
								if( validUpto != null && currTime.after(validUpto) )
								{
									validAccount = false;
									statusBuf.append("<STATUS><![CDATA[false]]></STATUS>"); //$NON-NLS-1$
									statusBuf.append("<STATUS_CODE><![CDATA[LOCKED]]></STATUS_CODE>"); //$NON-NLS-1$
								}
							}
							if( ! validAccount )
							{
								lockAccount(mUserID);
							}
							else
							{
								boolean isFirstLogin = false;
								boolean isPassExpired = false;
								//String firstLogin = mResultSet.getString("LOGIN_FIRST"); //$NON-NLS-1$
								//BaseLogger.log("9",null,null,"firstLogin :"+firstLogin);
								//Changed By Hatim 26/07/07 Synchronize between ITM and Common Web Login. (First Login Y=1,N=0)
								//if (firstLogin != null && ("Y").equalsIgnoreCase(firstLogin.trim()))
								if ((firstLogin != null && (("Y").equalsIgnoreCase(firstLogin.trim()) || ("1").equalsIgnoreCase(firstLogin.trim()))))								 //$NON-NLS-1$ //$NON-NLS-2$
								{
									isFirstLogin = true;
								}
								else
								{
									String passFreqStr = mResultSet.getString("PASSWD_FREQ"); //$NON-NLS-1$
									//BaseLogger.log("9",null,null,"passFreq :"+passFreqStr); 
									if (passFreqStr != null)
									{
										int passFreq = Integer.parseInt(passFreqStr);
										Date lastPassChgDate = mResultSet.getDate("LAST_PWD_CHGDATE"); //$NON-NLS-1$
										BaseLogger.log("3",null,null,"lastPassChgDate :"+lastPassChgDate);							 //$NON-NLS-1$
										if (lastPassChgDate != null)
										{
										  long millsPerDay = 1000 * 60 * 60 * 24;
										  long diffInDays = (System.currentTimeMillis()-lastPassChgDate.getTime())/millsPerDay;
										  BaseLogger.log("3",null,null,"diffInDays :"+diffInDays);	 //$NON-NLS-1$
										  if (diffInDays > passFreq)
										  {
											isPassExpired = true;
										  }
										}
									}
								}
								if (isFirstLogin)
								{
									//Added by Sagar B. for first login condition in mobile[13-May-19]START
									if( "MELOGIN".equalsIgnoreCase(action) )
									{
										statusBuf.append("<STATUS><![CDATA[false]]></STATUS>"); //$NON-NLS-1$
									}
									//Added by Sagar B. for first login condition in mobile[13-May-19]END
									else
									{
										statusBuf.append("<STATUS><![CDATA[true]]></STATUS>"); //$NON-NLS-1$
									}
									statusBuf.append("<STATUS_CODE><![CDATA[FIRST_LOGIN]]></STATUS_CODE>"); //$NON-NLS-1$
									if ("I".equalsIgnoreCase(authMode)) //$NON-NLS-1$
									{
										//Changed by Hatim on 06/04/2007 to not pick up MIN_PWD_LENGTH at this stage, instead only when needed in case of change password.
										//mQuery1 = "SELECT MIN_PWD_LENGTH,ITM_VER FROM PARAMETER";
										mQuery1 = "SELECT ITM_VER FROM PARAMETER"; //$NON-NLS-1$

										//Added by Pankaj T on 19-12-17 [for multitenancy Added new trasDBConnection]
										Statement mStatement2 = transDBConnection.createStatement();
										//Statement mStatement2 = mConnection.createStatement();  	
										ResultSet mResultSet2 = mStatement2.executeQuery(mQuery1);
										while (mResultSet2.next())
										{
											//Changed by Hatim on 06/04/2007 to not pick up MIN_PWD_LENGTH at this stage, instead only when needed in case of change password.
											//statusDetailBuf.append("<MIN_PWD_LENGTH><![CDATA["+mResultSet2.getInt("MIN_PWD_LENGTH")+"]]></MIN_PWD_LENGTH>");
											statusDetailBuf.append("<ITM_VER><![CDATA["+mResultSet2.getString("ITM_VER")+"]]></ITM_VER>"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
										}
										mStatement2.close();
										mStatement2 = null;	
									}
								}
								else if (isPassExpired)
								{
									if ("I".equalsIgnoreCase(authMode)) //$NON-NLS-1$
									{
										int currGraceCnt = mResultSet.getInt("GRACE_LOGIN_CNT"); //$NON-NLS-1$
										int graceAllowedCnt = 0;
										//MANISH 20/09/2006
										//Changed by Hatim on 06/04/2007 to not pick up MIN_PWD_LENGTH at this stage, instead only when needed in case of change password.
										//mQuery1 = "SELECT MIN_PWD_LENGTH,GRACE_LOGIN,ITM_VER FROM PARAMETER";
										mQuery1 = "SELECT GRACE_LOGIN,ITM_VER FROM PARAMETER"; //$NON-NLS-1$

										//Added by Pankaj T on 19-12-17 [for multitenancy Added new trasDBConnection]
										Statement mStatement2 = transDBConnection.createStatement();
										//Statement mStatement2 = mConnection.createStatement();
										//BaseLogger.log("9",null,null,"Get Parameters :"+mQuery1);
										ResultSet mResultSet2 = mStatement2.executeQuery(mQuery1);
										while (mResultSet2.next())
										{
											//Changed by Hatim on 06/04/2007 to not pick up MIN_PWD_LENGTH at this stage, instead only when needed in case of change password.
											//statusDetailBuf.append("<MIN_PWD_LENGTH><![CDATA["+mResultSet2.getInt("MIN_PWD_LENGTH")+"]]></MIN_PWD_LENGTH>");
											
											//MANISH 20/09/2006
											statusDetailBuf.append("<ITM_VER><![CDATA["+mResultSet2.getString("ITM_VER")+"]]></ITM_VER>"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
											graceAllowedCnt = mResultSet2.getInt("GRACE_LOGIN"); //$NON-NLS-1$
										}
										mResultSet2.close();
										mResultSet2 = null;
										mStatement2.close();
										mStatement2 = null;	
										if (currGraceCnt < graceAllowedCnt)
										{
											statusBuf.append("<STATUS><![CDATA[true]]></STATUS>"); //$NON-NLS-1$
											statusBuf.append("<STATUS_CODE><![CDATA[PASS_EXP_GRACE]]></STATUS_CODE>"); //$NON-NLS-1$
										}
										else
										{
											statusBuf.append("<STATUS><![CDATA[true]]></STATUS>"); //$NON-NLS-1$
											statusBuf.append("<STATUS_CODE><![CDATA[PASS_EXP_NOGRACE]]></STATUS_CODE>"); //$NON-NLS-1$
										}								
									}//if ("I".equalsIgnoreCase(authMode))
									else
									{
										statusBuf.append("<STATUS><![CDATA[true]]></STATUS>"); //$NON-NLS-1$
										statusBuf.append("<STATUS_CODE><![CDATA[PASS_EXPIRED]]></STATUS_CODE>"); //$NON-NLS-1$
									}
								}
								else
								{
									if ("I".equalsIgnoreCase(authMode)) //$NON-NLS-1$
									{
										mQuery1 = "SELECT ITM_VER FROM PARAMETER"; //$NON-NLS-1$
										//Added by Pankaj T on 19-12-17 [for multitenancy Added new trasDBConnection]
										Statement mStatement2 = transDBConnection.createStatement();
										//Statement mStatement2 = mConnection.createStatement();  	
										ResultSet mResultSet2 = mStatement2.executeQuery(mQuery1);
										while (mResultSet2.next())
										{
											statusDetailBuf.append("<ITM_VER><![CDATA["+mResultSet2.getString("ITM_VER")+"]]></ITM_VER>"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
										}
										mResultSet2.close();
										mResultSet2 = null;
										mStatement2.close();
										mStatement2 = null;	
									}
									statusBuf.append("<STATUS><![CDATA[true]]></STATUS>"); //$NON-NLS-1$
									statusBuf.append("<STATUS_CODE><![CDATA[VALID]]></STATUS_CODE>"); //$NON-NLS-1$
								}				
								statusDetailBuf.append("<USR_LEV><![CDATA["+mResultSet.getInt("USR_LEV")+"]]></USR_LEV>"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
								String rcpCacheStatus = mResultSet.getString("RCP_CACHE_STATUS"); //$NON-NLS-1$
								statusDetailBuf.append("<RCP_CACHE_STATUS><![CDATA[" + ( rcpCacheStatus == null || ( rcpCacheStatus != null && rcpCacheStatus.length() == 0 ) ? "1" : rcpCacheStatus )+ "]]></RCP_CACHE_STATUS>"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
								statusDetailBuf.append("<DATE_FORMAT><![CDATA["+new E12GenericUtility().getDispDateFormat()+"]]></DATE_FORMAT>"); //$NON-NLS-1$ //$NON-NLS-2$
								//Changed by Madhup on 27/06/2007 accomodating DateTime Format.
								statusDetailBuf.append("<DATETIME_FORMAT><![CDATA["+new E12GenericUtility().getDispDateTimeFormat()+"]]></DATETIME_FORMAT>"); //$NON-NLS-1$ //$NON-NLS-2$
								
								//Commented and Changes made by Gulzar on 02/08/13 get the profile id from user_site table first and if not found then take from user table : START
								//statusDetailBuf.append("<PROFILE_ID><![CDATA["+mResultSet.getString("PROFILE_ID").trim()+"]]></PROFILE_ID>"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
								statusDetailBuf.append("<PROFILE_ID><![CDATA["+userProfileID+"]]></PROFILE_ID>"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
								//End changed by Gulzar on 02/08/13 : END
								
								//Changed by Shravan on 21/05/2007 added to support Maximum no of editors to be opened.
								statusDetailBuf.append("<MAX_EDIT_NO><![CDATA["+CommonConstants.MAX_EDIT_NO+"]]></MAX_EDIT_NO>"); //$NON-NLS-1$ //$NON-NLS-2$
								//Changed by Pragyan on 14/08/07 to add profile_id_res.
								String profileIdRes = mResultSet.getString( "PROFILE_ID__RES" );  //$NON-NLS-1$
								statusDetailBuf.append( "<PROFILE_ID__RES><![CDATA[" + ( profileIdRes == null || ( profileIdRes != null && profileIdRes.length() == 0 ) ? "" : profileIdRes ) + "]]></PROFILE_ID__RES>" ); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
								//Changed by Rupali Hande on 20-10-2008 [Add ther RIA_CACHE_STATUS in authenticate return string for RIA ].RequestID [BI89SUN008] 
								String riaCacheStatus = mResultSet.getString("RIA_CACHE_STATUS"); //$NON-NLS-1$
								statusDetailBuf.append( "<RIA_CACHE_STATUS><![CDATA[" + ( riaCacheStatus == null || ( riaCacheStatus != null && riaCacheStatus.length() == 0 ) ? "0" : riaCacheStatus ) + "]]></RIA_CACHE_STATUS>" ); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
								
							}
						}
					}
				}
				//Danish ON 2/24/2010(mm/DD/yyyy) [ WI90BAS003 - password issue.]
				//Added by Pankaj T on 19-12-17 [for multitenancy pass transDB]
				statusDetailBuf.append("<MIN_PWD_LENGTH><![CDATA["+getMinPwdLength(transDB)+"]]></MIN_PWD_LENGTH>"); //$NON-NLS-1$ //$NON-NLS-2$
				statusDetailBuf.append("<IS_PASSWORD_STORE><![CDATA["+CommonConstants.IS_PASSWORD_STORE+"]]></IS_PASSWORD_STORE>"); //$NON-NLS-1$ //$NON-NLS-2$
				// Added by Sandeshs 21-Jun-2016 [Req:W15BSUN011] START
				statusDetailBuf.append("<DEFAULT_MENU><![CDATA["+CommonConstants.DEFAULT_MENU+"]]></DEFAULT_MENU>");
				// Added by Sandeshs 21-Jun-2016 [Req:W15BSUN011] END
				//Added by Suraj on 20-March-2017 [To configure slide menu panel footer ]Start
				statusDetailBuf.append("<FEATURES><![CDATA["+CommonConstants.FEATURES+"]]></FEATURES>");
				//Added by Suraj on 20-March-2017 [To configure slide menu panel footer ]End
				if(mResultSet != null)
				{
					mResultSet.close();
					mResultSet = null;
				}
				// Changed by Sandesh Shinde on 17-MAY-2017 [ Authentication API: SQL Injection]
				if(mpStatement != null)
				{
					mpStatement.close();
					mpStatement = null;
				}
				statusDetailBuf.append("<IS_BI_USER><![CDATA["+isBiUser(mUserID)+"]]></IS_BI_USER>"); //$NON-NLS-1$ //$NON-NLS-2$
				//Added By Shahu Mali on 08-10-13
				statusDetailBuf.append("<TRANS_DB><![CDATA["+transDB+"]]></TRANS_DB>"); //$NON-NLS-1$ //$NON-NLS-2$
				statusDetailBuf.append("<USER_THEME><![CDATA["+userTheme+"]]></USER_THEME>"); //$NON-NLS-1$ //$NON-NLS-2$
				//Added by Vishal Pathare on 16-AUG-2016 for[getting <UX_INTERFACE> for applying themes]
				statusDetailBuf.append("<UX_INTERFACE><![CDATA["+uxInterface+"]]></UX_INTERFACE>"); //$NON-NLS-1$ //$NON-NLS-2$
				//Changed samadhan to check null value.
				//statusDetailBuf.append("<ENTERPRISE><![CDATA["+enterprise+"]]></ENTERPRISE>"); //$NON-NLS-1$ //$NON-NLS-2$
				enterprise =(enterprise == null || ( enterprise != null && enterprise.length() == 0 ) ? "" : enterprise );
				//statusDetailBuf.append("<ENTERPRISE><![CDATA["+( enterprise == null || ( enterprise != null && enterprise.length() == 0 ) ? "" : enterprise )+"]]></ENTERPRISE>");
				//added by vishal pathare on 13.4.18 for[site wise enterprise image related changes]start
				if(!"INVALID_SITE".equalsIgnoreCase( siteCode ) && !"INACCESSIBLE_SITE".equalsIgnoreCase( siteCode ))
				{
					String sqlString = "select enterprise from site where site_code=?"; //$NON-NLS-1$
					BaseLogger.log("3",null,null,"siteCode["+siteCode+"]");
					//Changed By Pankaj T. on 11-12-18 [As per suggested by KB Sir & Danish Sir if users table enterprise column value is null or blank then set site table enterprise column value] - start
					if( "".equals(E12GenericUtility.checkNull(enterprise)) )
					{
						PreparedStatement pstmt = transDBConnection.prepareStatement(sqlString);
						pstmt.setString(1,siteCode);
						ResultSet rs = pstmt.executeQuery();
						while (rs.next())
						{
							enterprise = rs.getString("enterprise");
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;	
					}
					//Changed By Pankaj T. on 11-12-18 [As per suggested by KB Sir & Danish Sir if users table enterprise column value is null or blank then set site table enterprise column value] - end
					//Added by Sagar B. to show descr in slide menu panel[18-Sep-18]START
					if( enterprise != null && enterprise.trim().length() > 0 )
					{
						//Added by pankaj T. on 10-04-2020 for  Configure SMTP mail server against ENTERPRISE - start
						sqlString = "SELECT ENTERPRISE_DESCR, SMTP_HOST, SMTP_PORT, SMTP_USER, SMTP_PASS_WD, SMTP_PROTOCOL_TYPE, SMTP_MAILFROM, EMAIL_ID, SESS_TIMEOUT_SEC, SOCIAL_OPT FROM ENTERPRISE WHERE ENTERPRISE = ?"; //$NON-NLS-1$
						BaseLogger.log("3",null,null,"enterprise["+enterprise.trim()+"]");
						PreparedStatement preStmt = transDBConnection.prepareStatement(sqlString);
						preStmt.setString(1,enterprise.trim());
						ResultSet rs2 = preStmt.executeQuery();
						while (rs2.next())
						{
							enterpriseDescr = rs2.getString("ENTERPRISE_DESCR");
							//Added by pankaj T. on 10-04-2020 for  Configure SMTP mail server against ENTERPRISE - start
							smtpHost = rs2.getString("SMTP_HOST");
							smtpPort = rs2.getString("SMTP_PORT");
							smtpUser = rs2.getString("SMTP_USER");
							smtpPassWD = rs2.getString("SMTP_PASS_WD");
							smtpProtocolType = rs2.getString("SMTP_PROTOCOL_TYPE");
							smtpMailFrom = rs2.getString("SMTP_MAILFROM");
                            adminEmailId = rs2.getString("EMAIL_ID");
                            sessTimeoutInSecs = rs2.getString("SESS_TIMEOUT_SEC"); //Added by Jatin M on 24-Jun-2022 [To set prior session timeout in UserInfoBean]
                            socialOpt = rs2.getString("SOCIAL_OPT"); // Added by Jay on 13/APR/2023 [To set social_opt from enterprise]
							//Added by pankaj T. on 10-04-2020 for  Configure SMTP mail server against ENTERPRISE - end
						}
						rs2.close();
						rs2 = null;
						preStmt.close();
						preStmt = null;
					}
					//Added by Sagar B. to show descr in slide menu panel[18-Sep-18]END
				}
				statusDetailBuf.append("<ENTERPRISE><![CDATA["+enterprise+"]]></ENTERPRISE>");
				//added by vishal pathare on 13.4.18 for[site wise enterprise image related changes]End
				
				//Added by Jay [To add social_opt in statusDetailBuf]- Start
				statusDetailBuf.append("<SOCIAL_OPT><![CDATA["+socialOpt+"]]></SOCIAL_OPT>");
				//Added by Jay [To add social_opt in statusDetailBuf]- End

				statusDetailBuf.append("<ENTERPRISE_DESCR><![CDATA["+enterpriseDescr+"]]></ENTERPRISE_DESCR>");	//Added by Sagar B. to show descr in slide menu panel[18-Sep-18]
				//Added by Dnyaneshwar Chavan on 30-Jul-15 [ Implement Geo fencing functionality  ] Start
				
				//Added by pankaj T. on 10-04-2020 for  Configure SMTP mail server against ENTERPRISE - start
				statusDetailBuf.append("<SMTP_HOST><![CDATA["+smtpHost+"]]></SMTP_HOST>");
				statusDetailBuf.append("<SMTP_PORT><![CDATA["+smtpPort+"]]></SMTP_PORT>");
				statusDetailBuf.append("<SMTP_USER><![CDATA["+smtpUser+"]]></SMTP_USER>");
				statusDetailBuf.append("<SMTP_PASS_WD><![CDATA["+smtpPassWD+"]]></SMTP_PASS_WD>");
				statusDetailBuf.append("<SMTP_PROTOCOL_TYPE><![CDATA["+smtpProtocolType+"]]></SMTP_PROTOCOL_TYPE>");
				statusDetailBuf.append("<SMTP_MAILFROM><![CDATA["+smtpMailFrom+"]]></SMTP_MAILFROM>");
				statusDetailBuf.append("<ADMIN_EMAIL_ID><![CDATA["+adminEmailId+"]]></ADMIN_EMAIL_ID>");
				//Added by pankaj T. on 10-04-2020 for  Configure SMTP mail server against ENTERPRISE - end
				//Added by Jatin M on 24-Jun-2022 [To set prior session timeout in UserInfoBean] - START
                statusDetailBuf.append("<SESS_TIMEOUT_SEC><![CDATA["+sessTimeoutInSecs+"]]></SESS_TIMEOUT_SEC>");
              //Added by Jatin M on 24-Jun-2022 [To set prior session timeout in UserInfoBean] - END
				statusDetailBuf.append("<USER_GEO_FENCE_ENABLED><![CDATA["+userGeoFence+"]]></USER_GEO_FENCE_ENABLED>"); //$NON-NLS-1$ //$NON-NLS-2$
				//Added by Dnyaneshwar Chavan on 30-Jul-15 [ Implement Geo fencing functionality  ] End
				//Added by Sagar B. to track GPS configuration on user level on [11-JAN-18]START
				statusDetailBuf.append("<USER_GEO_POS_OPTION><![CDATA["+geoPosOption+"]]></USER_GEO_POS_OPTION>"); //$NON-NLS-1$ //$NON-NLS-2$
				//Added by Sagar B. to track GPS configuration on user level on [11-JAN-18]END
				//Added by Sagar B. to set network configuration[07-Feb-19]START
				statusDetailBuf.append("<NETWORK_OPTION><![CDATA["+networkOption+"]]></NETWORK_OPTION>"); //$NON-NLS-1$ //$NON-NLS-2$
				//Added by Sagar B. to set network configuration[07-Feb-19]END
				//Added by Sagar B. to set offline edit/delete configuration enterprise-wise[13-Mar-19]START
				statusDetailBuf.append("<IS_ALLOW_OFFLINE_EDIT><![CDATA["+isAllowOfflineEdit+"]]></IS_ALLOW_OFFLINE_EDIT>"); //$NON-NLS-1$ //$NON-NLS-2$
				statusDetailBuf.append("<IS_ALLOW_OFFLINE_DELETE><![CDATA["+isAllowOfflineDelete+"]]></IS_ALLOW_OFFLINE_DELETE>"); //$NON-NLS-1$ //$NON-NLS-2$
				//Added by Sagar B. to set offline edit/delete configuration enterprise-wise[13-Mar-19]END
				
			}//if (isValid)
			else
			{
				statusBuf.append("<STATUS><![CDATA[false]]></STATUS>"); //$NON-NLS-1$
				if (!isIdValid)
				{					
					statusBuf.append("<STATUS_CODE><![CDATA[INVALID_USR]]></STATUS_CODE>"); //$NON-NLS-1$
				}
				else if (!isPasswdValid)
				{
					//statusBuf.append("<STATUS_CODE><![CDATA[INVALID_PWD]]></STATUS_CODE>"); //$NON-NLS-1$
					//Added By Pankaj T. on 18-11--2020 for removing weak account lock vulnerability - if user wrongly enter password more than 5 times then lock the account and send new password on email/mobile and unlock account using new password - start
					int wrongLoginCount = CommonConstants.WRONG_LOGIN_COUNT;
					String acctLock = getDBColumnValue("USERS", "ACCT_LOCK", "WHERE CODE='"+mUserID+"'");
					BaseLogger.log("3",null,null,"acctLock......"+acctLock);
					if( E12GenericUtility.checkNull(acctLock).length() > 0 && "Y".equalsIgnoreCase(acctLock) )
					{
						statusBuf.append("<STATUS_CODE><![CDATA[ACCOUNT_LOCKED]]></STATUS_CODE>");
					}
					else
					{
						String deviceId=request.getParameter("MAC_ADDRESS");
						if( deviceId == null || deviceId.trim().length() == 0 )
						{
							deviceId = request.getParameter("DEVICEID");
						}
						//Changed By Pankaj T. on 21-05-2021 for getting actual client ip in case of load balancer - start
						String chgIP = request.getHeader("X-Forwarded-For");
						if(chgIP == null) 
						{  
							chgIP = request.getRemoteAddr();
						}
						//Changed By Pankaj T. on 21-05-2021 for getting actual client ip in case of load balancer - end
						BaseLogger.log("3",null,null,"wrongLoginCount....."+wrongLoginCount+".....userId......"+mUserID+"......chgIP....."+chgIP+"deviceId......"+deviceId);
						boolean resetPassword = isResetPassword(wrongLoginCount,mUserID,chgIP);
						BaseLogger.log("3",null,null,"resetPassword......"+resetPassword);
						if(resetPassword)
						{
							secureAccount( mUserID, "0", createUserInfo(mUserID, "code", false),chgIP, deviceId);
							lockAccount(mUserID);
							statusBuf.append("<STATUS_CODE><![CDATA[WRONG_LOGIN_COUNT_EXCEED]]></STATUS_CODE>");
						}
						else
						{
							statusBuf.append("<STATUS_CODE><![CDATA[INVALID_PWD]]></STATUS_CODE>");
						}
					}
					//Added By Pankaj T. on 18-11--2020 for removing weak account lock vulnerability - if user wrongly enter password more than 5 times then lock the account and send new password on email/mobile and unlock account using new password - end
				}
				//changed by gayatri on 09-03-2011 [MF01SUN034]
				else if(!isAttFound)
				{
					statusBuf.append("<STATUS_CODE><![CDATA[ATTENDANCE_MISSING]]></STATUS_CODE>"); //$NON-NLS-1$
				}
				//changed by gayatri on 09-03-2011 [MF01SUN034]
				//Changed by gayatri on  18-08-2011 [CR1DPOL001]  [To add Mac-address in security feature] start
				else if(!isValidMacId)
				{
					statusBuf.append("<STATUS_CODE><![CDATA[INVALID_MACID]]></STATUS_CODE>"); //$NON-NLS-1$
				}
				//Changed by gayatri on  18-08-2011 [CR1DPOL001]  [To add Mac-address in security feature] start
				
				
				if ("I".equalsIgnoreCase(authMode)) //$NON-NLS-1$
				{
					//usrXmlInfo.append("<IS_VALID_CASE><![CDATA["+isValidCase+"]]></IS_VALID_CASE>");
					//Changed By Danish on 15/09/2006 reason [Added the EMPLOYEE in email_id_off to avoid "column ambiguously defined" error]
					//String mQuery = "SELECT USR_LEV, RES_TYPE, EMAIL_ID_OFF FROM  USERS, EMPLOYEE WHERE CODE = '"+mUserID+"' AND USERS.EMP_CODE = EMPLOYEE.EMP_CODE";
					//Changed by Rupali Hande on 26-08-2008 [to add the logger_status in userInfo]Request ID:-[BI89SUN007]
					//String mQuery = "SELECT USR_LEV, RCP_CACHE_STATUS, RES_TYPE, EMPLOYEE.EMAIL_ID_OFF FROM USERS, EMPLOYEE WHERE CODE = '"+mUserID+"' AND 	USERS.EMP_CODE = EMPLOYEE.EMP_CODE";
					// Changed by Sandesh Shinde on 17-MAY-2017 [ Authentication API: SQL Injection] Start
					String mQuery = "SELECT USR_LEV, RCP_CACHE_STATUS, RES_TYPE, LOGGER_TYPE, EMAIL_ID, WRONG_LOGIN_CNT FROM USERS WHERE CODE = ? "; //$NON-NLS-1$ //$NON-NLS-2$
					PreparedStatement pmStatement = mConnection.prepareStatement(mQuery);
					//BaseLogger.log("9",null,null,"Get User Info :"+mQuery);
					pmStatement.setString(1, mUserID);
					mResultSet = pmStatement.executeQuery();
					// Changed by Sandesh Shinde on 17-MAY-2017 [ Authentication API: SQL Injection] End
					while (mResultSet.next())
					{
						statusDetailBuf.append("<USR_LEV><![CDATA["+mResultSet.getInt("USR_LEV")+"]]></USR_LEV>"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
						String rcpCacheStatus = mResultSet.getString("RCP_CACHE_STATUS"); //$NON-NLS-1$
						statusDetailBuf.append("<RCP_CACHE_STATUS><![CDATA[" + ( rcpCacheStatus == null || ( rcpCacheStatus != null && rcpCacheStatus.length() == 0 ) ? "1" : rcpCacheStatus )+ "]]></RCP_CACHE_STATUS>"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
						statusDetailBuf.append("<RES_TYPE><![CDATA["+mResultSet.getInt("RES_TYPE")+"]]></RES_TYPE>"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
						//statusDetailBuf.append("<EMAIL_ID_OFF><![CDATA["+mResultSet.getString("EMAIL_ID")+"]]></EMAIL_ID_OFF>"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
						statusDetailBuf.append("<EMAIL_ID><![CDATA["+mResultSet.getString("EMAIL_ID")+"]]></EMAIL_ID>"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
						//Changed by Rupali Hande on 26-08-2008 [to add the logger_status in userInfo]Request ID:-[BI89SUN007]
						statusDetailBuf.append("<LOGGER_TYPE><![CDATA["+mResultSet.getString("LOGGER_TYPE")+"]]></LOGGER_TYPE>"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
						statusDetailBuf.append("<WRONG_LOGIN_CNT><![CDATA["+mResultSet.getString("WRONG_LOGIN_CNT")+"]]></WRONG_LOGIN_CNT>"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
						
					}		
					mResultSet.close();
					mResultSet = null;
					// Changed by Sandesh Shinde on 17-MAY-2017 [ Authentication API: SQL Injection]
					pmStatement.close();
					pmStatement = null;
					BaseLogger.log("3",null,null, "Invalid password" ); //$NON-NLS-1$
				}
			}
			statusDetailBuf.append("</STATUS_DETAIL>"); //$NON-NLS-1$
			authInfoBuf.append(statusBuf.toString());
            authInfoBuf.append(statusDetailBuf.toString());
            authInfoBuf.append("<AUTHENTICATED_USING><![CDATA["+authenticatedUsing+"]]></AUTHENTICATED_USING>");
			authInfoBuf.append("</AUTH_INFO>"); //$NON-NLS-1$
			
		}
		catch(SQLException sqlExp)
		{
			BaseLogger.log("0",null,null,"Exception: CommonDBAccessEJB: authenticate:==>\n"+sqlExp.getMessage()); //$NON-NLS-1$
			sqlExp.printStackTrace();
			throw new BaseException( sqlExp );
		}
		catch( BaseException be )
		{
			BaseLogger.log("0",null,null,"Exception: CommonDBAccessEJB:==>\n"+be); //$NON-NLS-1$
			throw be;
		}
		catch(Exception e)
		{
			BaseLogger.log("0",null,null,"Exception: CommonDBAccessEJB: authenticate:==>"); //$NON-NLS-1$
			throw new BaseException( e );
		}
		finally
		{
			try
			{
				if(mResultSet != null){
					mResultSet.close();
					mResultSet = null;
				}				
				
				if(mpStatement != null)
				{
					mpStatement.close();
					mpStatement = null;
				}
				if(mConnection != null)
				{	
					if (mStatement != null)
					{
						mStatement.close();
						mStatement = null;
					}
					mConnection.close();
					mConnection = null;
				}
				if(transDBConnection != null)
				{	
					if (mStatement != null)
					{
						mStatement.close();
						mStatement = null;
					}
					transDBConnection.close();
					transDBConnection = null;
				}
			}			
			catch(Exception e)
			{
				BaseLogger.log("0",null,null,"Exception: CommonDBAccessEJB: authenticate:==>"); //$NON-NLS-1$
				try
				{
					mConnection.rollback();
					transDBConnection.rollback();
				}
				catch (Exception sqle )
				{
					throw new BaseException( sqle );
				}				
				throw new BaseException( e );
			}
		}
		return authInfoBuf.toString();
	}
	
	public void lockAccount(String user) throws RemoteException, BaseException
	{
		Connection mConnection = null;
		// Changed by Sandesh Shinde on 17-MAY-2017 [ Authentication API: SQL Injection]
		PreparedStatement mStatement = null;
		
		try
		{
			ConnDriver mConnDriver = new ConnDriver();
			mConnection = mConnDriver.getConnectDB("Driver");			 //$NON-NLS-1$
			// Changed by Sandesh Shinde on 17-MAY-2017 [ Authentication API: SQL Injection] Start
			String sqlQuery = "UPDATE USERS SET ACCT_LOCK = 'Y' WHERE CODE = ?"; //$NON-NLS-1$ //$NON-NLS-2$
			mStatement = mConnection.prepareStatement(sqlQuery);
			mStatement.setString(1, user);
			int rowCnt = mStatement.executeUpdate();
			// Changed by Sandesh Shinde on 17-MAY-2017 [ Authentication API: SQL Injection] End
			BaseLogger.log("3",null,null,"Locked User Account Updated :"+rowCnt); //$NON-NLS-1$
			mStatement.close();
			mStatement = null;
			mConnection.commit();
		}
		catch( BaseException be )
		{
			BaseLogger.log("0",null,null,"Exception: lockAccount:==>\n"+be); //$NON-NLS-1$
			try
			{
				mConnection.rollback();
			}
			catch (Exception sqle )
			{
				throw new BaseException( sqle );
			}			
			throw be;
		}
		catch(Exception e)
		{
			BaseLogger.log("0",null,null,"Exception :CommonDBAccessEJB :lockAccount :==>\n"+e);	 //$NON-NLS-1$
			try
			{
				mConnection.rollback();
			}
			catch (Exception sqle )
			{
				throw new BaseException( sqle );
			}		
			throw new BaseException( e );
		}
		finally
		{
			try
			{
				if (mConnection != null)
				{
					if(mStatement != null)
					{
						mStatement.close();
						mStatement = null;
					}
					mConnection.close();
					mConnection = null;
				}	
			}
			catch (Exception e)
			{
				throw new BaseException( e );
			}
		}
	}

	//Changed By Pankaj T. on 13-07-2020 for removing vulnerability of weak account lock policy - start
	public void unlockAccount(String user) throws RemoteException, BaseException
	{
		Connection mConnection = null;
		// Changed by Sandesh Shinde on 17-MAY-2017 [ Authentication API: SQL Injection]
		PreparedStatement mStatement = null;
		
		try
		{
			ConnDriver mConnDriver = new ConnDriver();
			mConnection = mConnDriver.getConnectDB("Driver");			 //$NON-NLS-1$
			// Changed by Sandesh Shinde on 17-MAY-2017 [ Authentication API: SQL Injection] Start
			String sqlQuery = "UPDATE USERS SET ACCT_LOCK = 'N' WHERE CODE = ?"; //$NON-NLS-1$ //$NON-NLS-2$
			mStatement = mConnection.prepareStatement(sqlQuery);
			mStatement.setString(1, user);
			int rowCnt = mStatement.executeUpdate();
			// Changed by Sandesh Shinde on 17-MAY-2017 [ Authentication API: SQL Injection] End
			BaseLogger.log("3",null,null,"UnLocked User Account Updated :"+rowCnt); //$NON-NLS-1$
			mStatement.close();
			mStatement = null;
			mConnection.commit();
		}
		catch( BaseException be )
		{
			BaseLogger.log("0",null,null,"Exception: unlockAccount:==>\n"+be); //$NON-NLS-1$
			try
			{
				mConnection.rollback();
			}
			catch (Exception sqle )
			{
				throw new BaseException( sqle );
			}			
			throw be;
		}
		catch(Exception e)
		{
			BaseLogger.log("0",null,null,"Exception :CommonDBAccessEJB :unlockAccount :==>\n"+e);	 //$NON-NLS-1$
			try
			{
				mConnection.rollback();
			}
			catch (Exception sqle )
			{
				throw new BaseException( sqle );
			}		
			throw new BaseException( e );
		}
		finally
		{
			try
			{
				if (mConnection != null)
				{
					if(mStatement != null)
					{
						mStatement.close();
						mStatement = null;
					}
					mConnection.close();
					mConnection = null;
				}	
			}
			catch (Exception e)
			{
				throw new BaseException( e );
			}
		}
	}
	//Changed By Pankaj T. on 13-07-2020 for removing vulnerability of weak account lock policy - end
	
	public void updateGraceCount(String user) throws RemoteException, BaseException
	{
		Connection mConnection = null;
		Statement mStatement = null;
		try
		{
			ConnDriver mConnDriver = new ConnDriver();
			mConnection = mConnDriver.getConnectDB("Driver");			 //$NON-NLS-1$
			mStatement = mConnection.createStatement();
			String sqlQuery = "UPDATE USERS SET GRACE_LOGIN_CNT = ((CASE WHEN GRACE_LOGIN_CNT IS NULL THEN 0 ELSE GRACE_LOGIN_CNT END)+1) WHERE CODE = '"+user+"'"; //$NON-NLS-1$ //$NON-NLS-2$
			int rowCnt = mStatement.executeUpdate(sqlQuery);
			BaseLogger.log("3",null,null,"Grace Count Updated :"+rowCnt); //$NON-NLS-1$
			mStatement.close();
			mStatement = null;
			mConnection.commit();
		}
		catch( BaseException be )
		{
			BaseLogger.log("0",null,null,"Exception: updateGraceCount:==>\n"+be); //$NON-NLS-1$
			try
			{
				mConnection.rollback();
			}
			catch (Exception sqle )
			{
				throw new BaseException( sqle );
			}	
			throw be;
		}
		catch(Exception e)
		{
			BaseLogger.log("0",null,null,"Exception :CommonDBAccessEJB :updateGraceCount :==>\n"+e); //$NON-NLS-1$
			try
			{
				mConnection.rollback();
			}
			catch (Exception sqle )
			{
				throw new BaseException( sqle );
			}	
			throw new BaseException( e );
		}
		finally
		{
			try
			{
				if (mConnection != null)
				{
					if(mStatement != null)
					{
						mStatement.close();
						mStatement = null;
					}
					mConnection.close();
					mConnection = null;
				}	
			}
			catch (Exception e)
			{
				throw new BaseException( e );
			}
		}
	}

	public boolean checkPassHistory(String user, String newPwd, UserInfoBean userInfo) throws RemoteException, BaseException
	{
		boolean pwdExist = false;
		Connection mConnection = null;
		Statement mStatement = null;
		ResultSet mResultSet1 =null;
		try
		{
			ConnDriver mConnDriver = new ConnDriver();
			// Changed by Abhishek T on 26-Sep-18 ["USR_PASS_HIS" table is AUTVIS schema] START
			mConnection = mConnDriver.getConnectDB("Driver");			 //$NON-NLS-1$
			// Changed by Abhishek T on 26-Sep-18 ["USR_PASS_HIS" table is AUTVIS schema] END
			mStatement = mConnection.createStatement();
			String sqlQuery = "SELECT PASS_WD_1,PASS_WD_2,PASS_WD_3,PASS_WD_4,PASS_WD_5 FROM USR_PASS_HIS WHERE CODE = '"+user+"'"; //$NON-NLS-1$ //$NON-NLS-2$
			mResultSet1 = mStatement.executeQuery(sqlQuery);
			int colCount = (mResultSet1.getMetaData()).getColumnCount();
			while (mResultSet1.next())
			{
				for (int i=1; i<=colCount-1; i++)
				{
					String passWd = mResultSet1.getString(i);
					if (passWd != null)
					{
						if (newPwd.equals(passWd) || newPwd.equals(decrypt(passWd)))
						{
							pwdExist = true;
							break;
						}
					}
				}
			}
			mResultSet1.close();
			mResultSet1 = null;
			mStatement.close();
			mStatement = null;
		}
		catch( BaseException be )
		{
			BaseLogger.log("0",userInfo,null,"Exception: updateGraceCount:==>\n"+be); //$NON-NLS-1$
			throw be;
		}
		catch(Exception e)
		{
			BaseLogger.log("0",userInfo,null,"Exception :CommonDBAccessEJB :checkPassHistory :==>\n"+e); //$NON-NLS-1$
			throw new BaseException( e );
		}
		finally
		{
			try
			{
				if(mResultSet1 !=null){
					mResultSet1.close();
					mResultSet1 =null;
				}
				if (mConnection != null)
				{
					if(mStatement != null)
					{
						mStatement.close();
						mStatement = null;
					}
					mConnection.close();
					mConnection = null;
				}	
			}
			catch (Exception e)
			{
				throw new BaseException( e );
			}
		}
		return pwdExist;
	}
	//two new arguement added by sadique 25-6-2019 for change password
	public void updatePassword(String user,String newPwd, UserInfoBean userInfo,String clientIP,String deviceUuId ) throws RemoteException, BaseException
	{
		//Changed By sanket J on 02/03/16 for[Login_first after forgot password]
		//updatePassword( user, newPwd, "", "" );
		//Two new arguement added by sadique 25-6-2019 for change password
		updatePassword( user, newPwd, "", "","1", userInfo ,clientIP , deviceUuId);
	}
	
	//Changed By sanket J on 02/03/16 for[Login_first after forgot password]
	//public void updatePassword( String user,String newPwd, String newPwdSHA256, String userLang, String loginFirst )
	//Two new arguement added by sadique 25-6-2019 for change password
	public void updatePassword( String user,String newPwd, String newPwdSHA256, String userLang, String loginFirst, UserInfoBean userInfo , String chgIP,String deviveID) throws RemoteException, BaseException
	{
		//Connection mConnection = null;
		Connection usrsConnection = null;
		//Statement mStatement = null;
		PreparedStatement pstmt = null;
		PreparedStatement pstmtUserHis = null;
		PreparedStatement pstmtUser = null;
		PreparedStatement pstmtInsUpd = null;
		ResultSet mResultSet = null;
		ResultSet rsUser = null;
		//new variable added by sadique 25-6-2019 for change password
		String deviceId ="";
		
		boolean isError = false;
		try
		{
			ConnDriver mConnDriver = new ConnDriver();
			/*Commented by Sagar B. on 23 Jan 18
			String transDB = userInfo.getTransDB();
			mConnection = mConnDriver.getConnectDB(transDB);	*/		 //$NON-NLS-1$
			//get old Password
			
			usrsConnection = mConnDriver.getConnectDB("Driver");
			String sqlQuery = "SELECT PASS_WD FROM USERS WHERE CODE = '"+user+"'"; //$NON-NLS-1$ //$NON-NLS-2$
			pstmtUser = usrsConnection.prepareStatement(sqlQuery);
			mResultSet = pstmtUser.executeQuery();
			String oldPwd = null;
			if (mResultSet.next())
			{
				oldPwd = mResultSet.getString(1);
			}
			if(mResultSet != null)
			{
				mResultSet.close();
				mResultSet = null;
			}
			if(pstmtUser != null)
			{
				pstmtUser.close();
				pstmtUser = null;
			}
			//If condition to get device Id added by sadique 25-6-2019 for change password
			//change by shrutika on 19-12-2020 for Exception in application
			//if( deviveID.trim().length() == 0 )
			if( deviveID != null && deviveID.trim().length() == 0 )
			{
				deviceId = userInfo.getDeviceID();
			}
			else
			{
				deviceId = deviveID+"_"+chgIP+"_";
			}
			//UPDATE users table
			//Changed and Commented by rahul on 25-apr-2016 [Request ID : W15LSUN010 for updatind date as well as time in LAST_PWD_CHGDATE column in users table] 
			//java.sql.Date currDate =new java.sql.Date(System.currentTimeMillis());
			java.sql.Timestamp currDate =new java.sql.Timestamp(System.currentTimeMillis());
			//Change by Nilesh on 25-Mar-2011 [SY01SUN038][Validate password from PASS_WD_SHA]
			//sqlQuery = "UPDATE USERS SET PASS_WD = ?, LAST_PWD_CHGDATE=?, LOGIN_FIRST=?, GRACE_LOGIN_CNT=? WHERE CODE = '"+user+"'";
			//Added By Pankaj T. on 18-11--2020 for removing weak account lock vulnerability - if user wrongly enter password more than 5 times then lock the account and send new password on email/mobile and unlock account using new password
			sqlQuery = "UPDATE USERS SET PASS_WD = ?, LAST_PWD_CHGDATE=?, LOGIN_FIRST=?, GRACE_LOGIN_CNT=?, PASS_WD_SHA=?, ACCT_LOCK = 'N' WHERE CODE = '"+user+"'"; //$NON-NLS-1$ //$NON-NLS-2$
			pstmt = usrsConnection.prepareStatement(sqlQuery);
			//Added by Nilesh on 25-Mar-2011 [SY01SUN038][Validate password from PASS_WD_SHA]
			//Commented and Added by Dnyaneshwar Chavan on 25-SEP-14 [ SHA256 password converted on client site  ] Start
			//Below code added to get time by sadique 25-6-2019 for change password
			E12GenericUtility genericUtility =new E12GenericUtility();

			Calendar currentDate = Calendar.getInstance();
			SimpleDateFormat simpleDateFormatObj = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String sysdate = simpleDateFormatObj.format(currentDate.getTime());

			String newEncrptPass = newPwd;
			if( CommonConstants.ENCRYPT_PWD )
			{
				newEncrptPass = encrypt( newPwd );
			}
			
			if( "ru".equalsIgnoreCase( userLang ) )
			{
				pstmt.setString( 1, newPwd );
			}
			else
			{
				pstmt.setString( 1, newEncrptPass );
			}
			
			if( newPwdSHA256.length() == 0  )
			{
				pstmt.setString( 5, convertIntoSHA256( newPwd ) );
			}
			else
			{
				pstmt.setString( 5, newPwdSHA256 );
			}
			//Commented and Added by Dnyaneshwar Chavan on 25-SEP-14 [ SHA256 password converted on client site  ] End
			//Changed and Commented by rahul on 25-apr-2016 [Request ID : W15LSUN010 for updatind date as well as time in LAST_PWD_CHGDATE column in users table]
			//pstmt.setDate(2,currDate);
			pstmt.setTimestamp(2,currDate);
			//Changed By Hatim 26/07/07 Synchronize between ITM and Common Web Login. (First Login Y=1,N=0)
			//pstmt.setString(3,"N");
			//Changed by sanket J on 02/03/16 for [loginfirst  after updatepassword]
			//pstmt.setString(3,"0");
			pstmt.setString(3,loginFirst); //$NON-NLS-1$
			pstmt.setInt(4,0);
			//Added by Nilesh on 25-Mar-2011 [SY01SUN038][Validate password from PASS_WD_SHA]
			//Commented and Added by Dnyaneshwar Chavan on 04-SEP-14 [ Never converting into SHA256 bcz converted on client side as per Danish sir  ] Start
			//pstmt.setString( 5, convertIntoSHA256( newPwd ) );
			//pstmt.setString( 5, newPwd );
			//Commented and Added by Dnyaneshwar Chavan on 04-SEP-14 [ Never converting into SHA256 bcz converted on client side as per Danish sir  ] End
			int rowCnt = pstmt.executeUpdate();
			BaseLogger.log("3",userInfo,null,"In commondbaccess rowCnt:::["+rowCnt+"]");
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			//mConnection.commit();
			//BaseLogger.log("9",null,null,"Updating users table :"+sqlQuery);
			//BaseLogger.log("9",null,null,"Password Updated :"+rowCnt);
			//update usr_pass_his table using FIFO technique			
			ArrayList<String> newPwdList = new ArrayList<String>();
			//Below array list added by sadique 25-6-2019 for change password
			ArrayList<String> newChgDateList = new ArrayList<String>();
			ArrayList<String> newDeviceIdList = new ArrayList<String>();
			ArrayList<String> newIpList = new ArrayList<String>();
			
			newPwdList.add(oldPwd);
			//Below code added by sadique 25-6-2019 for change password
			newChgDateList.add(sysdate);
			newDeviceIdList.add(deviceId);
			newIpList.add(chgIP);
			sqlQuery = "SELECT PASS_WD_1,PASS_WD_2,PASS_WD_3,PASS_WD_4,PASS_WD_5,PASS_CHG_DATE1,PASS_CHG_DATE2,PASS_CHG_DATE3,PASS_CHG_DATE4,PASS_CHG_DATE5,DEVICE_ID1,DEVICE_ID2,DEVICE_ID3,DEVICE_ID4,DEVICE_ID5,CHG_IP1,CHG_IP2,CHG_IP3,CHG_IP4,CHG_IP5 FROM USR_PASS_HIS WHERE CODE = '"+user+"'"; //$NON-NLS-1$ //$NON-NLS-2$
			pstmtUserHis = usrsConnection.prepareStatement(sqlQuery);
			//Changes by Prajyot - MSSQL throws error for executeQuery
			//rsUser = pstmtUserHis.executeQuery(sqlQuery);
			rsUser = pstmtUserHis.executeQuery();
			int colCount = (rsUser.getMetaData()).getColumnCount();
			boolean rowExist = false;
			while (rsUser.next())
			{
				//Two new arguement added by sadique 25-6-2019 for change password
				//Below variable added by sadique 25-6-2019 for change password
				
				for ( int i = 1; i <= 4; i++ )
				{
					
					//Below code added by sadique 25-6-2019 for change password
					String passChgDate = "";
					String passWd = rsUser.getString(i);
					String chgDate = rsUser.getString("PASS_CHG_DATE"+i);
					String devID = rsUser.getString("DEVICE_ID"+i);
					String chgIp = rsUser.getString("CHG_IP"+i);

					if(chgDate!=null && chgDate.trim().length()!=0)
					{
						passChgDate = genericUtility.getValidDateString( E12GenericUtility.checkNull(rsUser.getDate("PASS_CHG_DATE"+i).toString()), genericUtility.getDBDateFormat(), genericUtility.getApplDateFormat());
					}
					
					newPwdList.add(passWd);
					newChgDateList.add(passChgDate);
					newDeviceIdList.add(devID);
					newIpList.add(chgIp);
					//end 
				}
				rowExist = true;
			}
			if(rsUser != null)
			{
				rsUser.close();
				rsUser = null;
			}
			if(pstmtUserHis != null)
			{
				pstmtUserHis.close();
				pstmtUserHis = null;
			}
			if (!rowExist)
			{
				String chgDateDb = genericUtility.getValidDateString( E12GenericUtility.checkNull(newChgDateList.get(0)), genericUtility.getApplDateFormat(), "dd-MMM-yyyy");
				//Changed by Prasad on 04/09/2020 [use setString insteadOf passing in sql string] START
				//sqlQuery = "INSERT INTO USR_PASS_HIS(CODE,PASS_WD_1,PASS_CHG_DATE1,DEVICE_ID1,CHG_IP1) VALUES('"+user+"','"+(String)newPwdList.get(0)+"','"+chgDateDb+"','"+(String)newDeviceIdList.get(0)+"','"+(String)newIpList.get(0)+"')"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$\
				sqlQuery = "INSERT INTO USR_PASS_HIS(CODE,PASS_WD_1,PASS_CHG_DATE1,DEVICE_ID1,CHG_IP1) VALUES(?,?,?,?,?)";
				
				pstmtInsUpd = usrsConnection.prepareStatement(sqlQuery);
				pstmtInsUpd.setString( 1, user );
				pstmtInsUpd.setString( 2, (String)newPwdList.get(0) );
				pstmtInsUpd.setString( 3, chgDateDb );
				pstmtInsUpd.setString( 4, (String)newDeviceIdList.get(0) );
				pstmtInsUpd.setString( 5, (String)newIpList.get(0) );
				//Changed by Prasad on 04/09/2020 [use setString insteadOf passing in sql string] END
			}
			else
			{
				//Changed by Prasad on 04/09/2020 [use setString insteadOf passing in sql string] START
				/*sqlQuery = "UPDATE USR_PASS_HIS SET"; //$NON-NLS-1$
				for (int i=0; i<newPwdList.size(); i++)
				{
					if (newPwdList.get(i) != null)
					{
						String chgDateDb = E12GenericUtility.checkNull( newChgDateList.get(i) );
						if ( chgDateDb.length() > 0 )
						{
							chgDateDb = genericUtility.getValidDateString( chgDateDb, genericUtility.getApplDateFormat(), "dd-MMM-yyyy");
						}
						//String added by sadique 25-6-2019 for change password
						sqlQuery += " PASS_WD_"+(i+1)+" = '"+newPwdList.get(i)+"',"
								+ "PASS_CHG_DATE"+(i+1)+" = '"+chgDateDb+"',"
								+ "DEVICE_ID"+(i+1)+" = '"+newDeviceIdList.get(i)+"',"
								+ "CHG_IP"+(i+1)+" = '"+newIpList.get(i)+"',";				 //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
					}				
				}
				sqlQuery = sqlQuery.substring(0,sqlQuery.length()-1);
				sqlQuery += " WHERE CODE = '"+user+"'";*/ //$NON-NLS-1$ //$NON-NLS-2$
				StringBuffer sqlQueryBuilder = new StringBuffer( "UPDATE USR_PASS_HIS SET " );
				for ( int i = 0; i < newPwdList.size(); i++ )
				{
					if ( newPwdList.get(i) != null )
					{
						sqlQueryBuilder.append( " PASS_WD_" ).append( i+1 ).append( " = ?," );
						sqlQueryBuilder.append( " PASS_CHG_DATE" ).append( i+1 ).append( " = ?," );
						sqlQueryBuilder.append( " DEVICE_ID" ).append( i+1 ).append( " = ?," );
						sqlQueryBuilder.append( " CHG_IP" ).append( i+1 ).append( " = ?," );
					}
				}
				if( sqlQueryBuilder.length() > 0 && sqlQueryBuilder.toString().endsWith( "," ) )
				{
					sqlQueryBuilder.deleteCharAt( sqlQueryBuilder.length() - 1 );
				}
				sqlQueryBuilder.append( " WHERE CODE = ? " );
				
				pstmtInsUpd = usrsConnection.prepareStatement( sqlQueryBuilder.toString() );
				int ctr = 1;
				for ( int i = 0; i < newPwdList.size(); i++ )
				{
					if ( newPwdList.get( i ) != null )
					{
						String chgDateDb = E12GenericUtility.checkNull( newChgDateList.get( i ) );
						if ( chgDateDb.length() > 0 )
						{
							chgDateDb = genericUtility.getValidDateString( chgDateDb, genericUtility.getApplDateFormat(), "dd-MMM-yyyy");
						}
						
						pstmtInsUpd.setString( ctr++, (String)newPwdList.get( i ) );
						pstmtInsUpd.setString( ctr++, chgDateDb );
						pstmtInsUpd.setString( ctr++, (String)newDeviceIdList.get( i ) );
						pstmtInsUpd.setString( ctr++, (String)newIpList.get( i ) );
					}
				}
				pstmtInsUpd.setString( ctr++, user );
				//Changed by Prasad on 04/09/2020 [use setString insteadOf passing in sql string] END
			}
			//BaseLogger.log("9",null,null,"Updating USR_PASS_HIS table"+sqlQuery);
			//Changed by Prasad on 04/09/2020 [use setString insteadOf passing in sql string]
			//pstmtInsUpd = usrsConnection.prepareStatement(sqlQuery);
			rowCnt = pstmtInsUpd.executeUpdate();
			BaseLogger.log("3",userInfo,null,"Password History Updated :"+rowCnt); //$NON-NLS-1$
			/*mStatement.close();
			mStatement = null;
			mConnection.commit();*/
		}
		catch( BaseException be )
		{
			isError = true;
			BaseLogger.log("0",userInfo,null,"Exception: updatePassword:==>\n"+be); //$NON-NLS-1$
			try
			{
				usrsConnection.rollback();
			}
			catch (Exception sqle )
			{
				throw new BaseException( sqle );
			}	
			throw be;
		}
		catch(Exception e)
		{
			isError = true;
			BaseLogger.log("0",userInfo,null,"Exception :CommonDBAccessEJB :updatePassword :==>\n"+e); //$NON-NLS-1$
			try
			{
				usrsConnection.rollback();
			}
			catch (Exception sqle )
			{
				throw new BaseException( sqle );
			}	
			throw new BaseException( e );
		}
		finally
		{
			try
			{
				if(mResultSet != null)
				{
					mResultSet.close();
					mResultSet = null;
				}
				if(pstmtUser != null)
				{
					pstmtUser.close();
					pstmtUser = null;
				}
				if(rsUser != null)
				{
					rsUser.close();
					rsUser = null;
				}
				if(pstmtUserHis != null)
				{
					pstmtUserHis.close();
					pstmtUserHis = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(pstmtInsUpd != null)
				{
					pstmtInsUpd.close();
					pstmtInsUpd = null;
				}
				
				if (usrsConnection != null)
				{
					if( !isError )
					{
						usrsConnection.commit();
					}
					else
					{
						usrsConnection.rollback();
					}
					usrsConnection.close();
					usrsConnection = null;
				}
			}
			catch (Exception e)
			{
				throw new BaseException( e );
			}
		}
	}
	//Two new arguement added by sadique 25-6-2019 for change password
	public void secureAccount(String user, String resTypeStr, UserInfoBean userInfo ,String clientIP, String deviceUuId ) throws RemoteException, BaseException
	{
		Connection mConnection = null;
		PreparedStatement pStatement = null;
		ResultSet mResultSet = null;
		try
		{
			int resType = Integer.parseInt( resTypeStr );
			//BaseLogger.log("9",null,null,"USER ["+user+"], RES_TYPE["+resType+"]");
			ConnDriver mConnDriver = new ConnDriver();
			mConnection = mConnDriver.getConnectDB("Driver");								 
			if (resType == 0)
			{
				String newPwd = getNewPwd(user);
				//Two new arguement added by sadique 25-6-2019 for change password
				updatePassword(user,newPwd, userInfo,clientIP,deviceUuId );
				
				/*changed by Pankaj Tajane on 20/05/2016 for selecting preffered communication way EMAIL/SMS [S16ASER002] :Start*/
				E12SMSComp e12smsComp = new E12SMSComp();	
				//Changed by Santosh on 27-10-2017 to read SEC_COMM_MODE from profile master to send verification code to mobile/Email
				//String sqlQuerry = "SELECT MOBILE_NO,EMAIL_ID FROM USERS WHERE CODE = ?";
				//Changed by Santosh om 31-10-2017 to read sec_comm_mode from profile master
				//String sqlQuerry = "SELECT U.MOBILE_NO,U.EMAIL_ID,P.SEC_COMM_MODE,U.USER_TYPE,U.ENTITY_CODE FROM USERS U, PROFILE P WHERE U.PROFILE_ID=P.PROFILE_ID AND CODE = ?";
				String sqlQuerry = "SELECT MOBILE_NO, EMAIL_ID, USER_TYPE, ENTITY_CODE FROM USERS U WHERE CODE = ?";
				pStatement = mConnection.prepareStatement(sqlQuerry);
				pStatement.setString(1, user);
				mResultSet = pStatement.executeQuery();
				if(mResultSet.next())
				{
					String mobileNo = E12GenericUtility.checkNull(mResultSet.getString(1));
					String toAdd = E12GenericUtility.checkNull(mResultSet.getString(2));
					//Added by Santosh on 27-10-2017 to read SEC_COMM_MODE from profile master to send verification code to mobile/Email
					//Changed by Santosh om 31-10-2017
					//String secCommMode = E12GenericUtility.checkNull(mResultSet.getString(3));
					String secCommMode = getSecurityCommMode(user);
					BaseLogger.log("3",userInfo,null,"secCommMode["+secCommMode+"]");
					String userType = E12GenericUtility.checkNull(mResultSet.getString(3));
					String entityCode = E12GenericUtility.checkNull(mResultSet.getString(4));
					//Added by Pankaj T on 12-01-18 [changes for multitenancy]
					List<String> sendToMobNoEmailList = getMobileEmailDetails(userType, entityCode, userInfo);
					String entityMobileNo = "", entityEmailId = "";
					if(sendToMobNoEmailList!=null)
					{
						entityMobileNo = sendToMobNoEmailList.get(0);
						//entityEmailId = sendToMobNoEmailList.get(1);
					}
					BaseLogger.log("3",userInfo,null,"entityMobileNo["+entityMobileNo+"] entityEmailId["+entityEmailId+"]");
					//Changed by Santosh on 27-10-2017 to read SEC_COMM_MODE from profile master to send verification code to mobile/Email [Start]
					if(!"".equalsIgnoreCase(secCommMode))
					{
						if("0".equalsIgnoreCase(secCommMode) || "1".equalsIgnoreCase(secCommMode))
						{
							if(("".equals(entityMobileNo)) || (!"".equals(entityMobileNo)) )
							{
								String formatCode = "USERS_FORMAT";
								String xtraParams = "loginCode="+user+"~~loginEmpCode"+user;
								StringBuffer valueXmlString = new StringBuffer( "<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header></Header>\r\n<Errors></Errors>\r\n" );
								valueXmlString.append( "<Detail1 objName = 'user_authenticate'>\r\n" );
								//Changed by Santosh on 27-10-2017 to lookup mobile number from entityCode
								//valueXmlString.append( "<code><![CDATA[" ).append(user).append( "]]></code>\r\n" );
								valueXmlString.append( "<code><![CDATA[" ).append(entityCode).append( "]]></code>\r\n" );
								valueXmlString.append( "<password><![CDATA[" ).append(newPwd).append( "]]></password>\r\n" );
								valueXmlString.append( "</Detail1>\r\n" );
								valueXmlString.append( "</Root>\r\n" );
								String smsresp = e12smsComp.sendSMS(valueXmlString.toString(), formatCode, xtraParams, userInfo);
								BaseLogger.log("3",userInfo,null,"sms response::::"+smsresp);
							}
							else
							{		
								BaseLogger.log("3",userInfo,null,"Warning: Mobile no is null For User :"+user+": !!!");
								//EMail emailObj = new EMail();
								//StringBuffer mailInfoXml = new StringBuffer("<MAILINFO>");
								if (!("".equals(toAdd)))
								{
									// Added and Commented by Pankaj R on 16-Sep-20 to show the mail dynamically from mail_format [START]
									String formatCode = "VERIFY_PASSWORD";
									/*mailInfoXml.append("<TO_ADD><![CDATA["+toAdd+"]]></TO_ADD>"); 
									String sub =Messages.getString("CommonDBAccessEJB_newPasswordForUserID")+user;
									mailInfoXml.append("<SUBJECT><![CDATA["+sub+"]]></SUBJECT>");
									String msg = Messages.getString("CommonDBAccessEJB_newPasswordForITM")+newPwd; 
									mailInfoXml.append("<MESSAGE><![CDATA["+msg+"]]></MESSAGE>"); 
									mailInfoXml.append("</MAILINFO>");
									//Added by Pankaj T on 12-01-18 [changes for multitenancy]
									emailObj.sendMail(mailInfoXml.toString(),null, userInfo);*/
	                                sendPasswdVerificationMail(newPwd, toAdd, formatCode, userInfo);
	                                // Added and Commented by Pankaj R on 16-Sep-20 to show the mail dynamically from mail_format [END]
								}
								else
								{
									BaseLogger.log("3",userInfo,null,"Warning: Email Id is null For User ["+user+"] !!!");
								}										
							}
						}
						
						if("0".equalsIgnoreCase(secCommMode) || "2".equalsIgnoreCase(secCommMode))
						{
							//EMail emailObj = new EMail();
							//StringBuffer mailInfoXml = new StringBuffer("<MAILINFO>");
							if (!("".equals(toAdd))) 
							{  
								//Changes done by Sanket J on 20/02/17 [for Calling Message subject and body from Mail_Format]-start
								String forgotPass = "VERIFY_PASSWORD";
								// Added and Commented by Pankaj R on 16-Sep-20 to show the mail dynamically from mail_format [START]
								// String condition = " WHERE FORMAT_CODE ='"+forgotPass+"'";
								//Added by Pankaj T on 12-01-18 [changes for multitenancy]
								//Changed by Pankaj T. on 09-01-2019 pass user specific transDB - start
								// String subject = getDBColumnValue("MAIL_FORMAT", "SUBJECT", condition, userInfo.getTransDB());
								//Change by shrurtika on 04-08-2020 [Start] for forgot password functionality no working properly when BODY_TEXT as blank(it append null string before verification code and new password)
								//String bodyText = getDBColumnValue("MAIL_FORMAT", "BODY_TEXT", condition, userInfo.getTransDB());
								// String bodyText = E12GenericUtility.checkNull(getDBColumnValue("MAIL_FORMAT", "BODY_TEXT", condition, userInfo.getTransDB()));
								//Changed by Pankaj T. on 09-01-2019 pass user specific transDB - end
								// mailInfoXml.append("<TO_ADD><![CDATA["+toAdd+"]]></TO_ADD>"); 
								//String sub = Messages.getString("CommonDBAccessEJB_newPasswordForUserID")+user; //added by sanket
								/*mailInfoXml.append("<SUBJECT><![CDATA["+sub+"]]></SUBJECT>"); 
								mailInfoXml.append("<SUBJECT><![CDATA["+subject+"]]></SUBJECT>"); */
								//String msg = Messages.getString("CommonDBAccessEJB_newPasswordForITM")+newPwd; 
								/*mailInfoXml.append("<MESSAGE><![CDATA["+msg+"]]></MESSAGE>");*/
								/*mailInfoXml.append("<MESSAGE><![CDATA["+(bodyText+newPwd)+"]]></MESSAGE>");
								mailInfoXml.append("</MAILINFO>");*/
								//Added by Pankaj T on 12-01-18 [changes for multitenancy] 
								// emailObj.sendMail(mailInfoXml.toString(),null, userInfo);
                                //Changes done by Sanket J on 20/02/17 [for Calling Message subject and body from Mail_Format]-End
                                sendPasswdVerificationMail(newPwd, toAdd, forgotPass, userInfo);
                                // Added and Commented by Pankaj R on 16-Sep-20 to show the mail dynamically from mail_format [END]
							}
							else
							{
								BaseLogger.log("3",userInfo,null,"Warning: Email ID is null For User :"+user+": !!!!!");
								if(("".equals(entityMobileNo)) || (!"".equals(entityMobileNo)) )
								{
									String formatCode="USERS_FORMAT";
									String xtraParams = "loginCode="+user+"~~loginEmpCode"+user;
									StringBuffer valueXmlString = new StringBuffer( "<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header></Header>\r\n<Errors></Errors>\r\n" );
									valueXmlString.append( "<Detail1 objName = 'user_authenticate'>\r\n" );
									//Changed by Santosh on 27-10-2017 to lookup mobile number from entityCode
									//valueXmlString.append( "<code><![CDATA[" ).append(user).append( "]]></code>\r\n" );
									valueXmlString.append( "<code><![CDATA[" ).append(entityCode).append( "]]></code>\r\n" );
									valueXmlString.append( "<password><![CDATA[" ).append(newPwd).append( "]]></password>\r\n" );
									valueXmlString.append( "</Detail1>\r\n" );
									valueXmlString.append( "</Root>\r\n" );
									String smsresp = e12smsComp.sendSMS(valueXmlString.toString(), formatCode, xtraParams, userInfo);
									BaseLogger.log("3",userInfo,null,"sms response::::"+smsresp);
								}
								else
								{
									BaseLogger.log("3",userInfo,null,"Warning: Mobile no is null For User :"+user+": !!!!!");
								}
							}										
						}
					}
					else
					{
						if("SMS".equalsIgnoreCase(CommonConstants.PREFFERED_COMM))
						{
							BaseLogger.log("3",userInfo,null,"CommonConstants.PREFFERED_COMM IN SMS::"+CommonConstants.PREFFERED_COMM);
							//if(!("".equals(entityMobileNo)))
							if(!("".equals(mobileNo)))//Added by sunny soni for getting new password to specified mobile number.
							{
								String formatCode = "USERS_FORMAT";
								String xtraParams = "loginCode="+user+"~~loginEmpCode"+user;
								StringBuffer valueXmlString = new StringBuffer( "<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header></Header>\r\n<Errors></Errors>\r\n" );
								valueXmlString.append( "<Detail1 objName = 'user_authenticate'>\r\n" );
								//Changed by Santosh on 27-10-2017 to lookup mobile number from entityCode
								//valueXmlString.append( "<code><![CDATA[" ).append(user).append( "]]></code>\r\n" );
								valueXmlString.append( "<code><![CDATA[" ).append(entityCode).append( "]]></code>\r\n" );
								valueXmlString.append( "<password><![CDATA[" ).append(newPwd).append( "]]></password>\r\n" );
								valueXmlString.append( "</Detail1>\r\n" );
								valueXmlString.append( "</Root>\r\n" );
								String smsresp = e12smsComp.sendSMS(valueXmlString.toString(), formatCode, xtraParams, userInfo);
								BaseLogger.log("3",userInfo,null,"sms response::::"+smsresp);
							}
							else
							{		
								BaseLogger.log("3",userInfo,null,"Warning: Mobile no is null For User :"+user+": !!!");
								//EMail emailObj = new EMail();
								//StringBuffer mailInfoXml = new StringBuffer("<MAILINFO>");
								if (!("".equals(toAdd)))
								{
									// Added and Commented by Pankaj R on 16-Sep-20 to show the mail dynamically from mail_format [START]
									String formatCode = "VERIFY_PASSWORD";
									/*mailInfoXml.append("<TO_ADD><![CDATA["+toAdd+"]]></TO_ADD>"); 
									String sub =Messages.getString("CommonDBAccessEJB_newPasswordForUserID")+user;
									mailInfoXml.append("<SUBJECT><![CDATA["+sub+"]]></SUBJECT>");
									String msg = Messages.getString("CommonDBAccessEJB_newPasswordForITM")+newPwd; 
									mailInfoXml.append("<MESSAGE><![CDATA["+msg+"]]></MESSAGE>"); 
									mailInfoXml.append("</MAILINFO>");
									//Added by Pankaj T on 12-01-18 [changes for multitenancy]
									emailObj.sendMail(mailInfoXml.toString(),null, userInfo);*/
	                                sendPasswdVerificationMail(newPwd, toAdd, formatCode, userInfo);
	                                // Added and Commented by Pankaj R on 16-Sep-20 to show the mail dynamically from mail_format [END]
								}
								else
								{
									BaseLogger.log("3",userInfo,null,"Warning: Email Id is null For User ["+user+"] !!!");
								}										
							}
						}
						else if("EMAIL".equalsIgnoreCase(CommonConstants.PREFFERED_COMM))
						{
							BaseLogger.log("3",userInfo,null,"CommonConstants.PREFFERED_COMM IN EMAIL:: "+CommonConstants.PREFFERED_COMM);
							//EMail emailObj = new EMail();
							//StringBuffer mailInfoXml = new StringBuffer("<MAILINFO>");
							if (!("".equals(toAdd))) 
							{  
								//Changes done by Sanket J on 20/02/17 [for Calling Message subject and body from Mail_Format]-start
								String forgotPass = "VERIFY_PASSWORD";
								// Added and Commented by Pankaj R on 16-Sep-20 to show the mail dynamically from mail_format [START]
								//String condition = " WHERE FORMAT_CODE ='"+forgotPass+"'";
								//Added by Pankaj T on 12-01-18 [changes for multitenancy]
								//Changed by Pankaj T. on 09-01-2019 pass user specific transDB - start
								//String subject = getDBColumnValue("MAIL_FORMAT", "SUBJECT", condition, userInfo.getTransDB());
								//Change by shrurtika on 04-08-2020 [Start] for forgot password functionality no working properly when BODY_TEXT as blank(it append null string before verification code and new password)
								//String bodyText = getDBColumnValue("MAIL_FORMAT", "BODY_TEXT", condition, userInfo.getTransDB());
								//String bodyText = E12GenericUtility.checkNull(getDBColumnValue("MAIL_FORMAT", "BODY_TEXT", condition, userInfo.getTransDB()));
								//Changed by Pankaj T. on 09-01-2019 pass user specific transDB - end
								//mailInfoXml.append("<TO_ADD><![CDATA["+toAdd+"]]></TO_ADD>"); 
								//String sub = Messages.getString("CommonDBAccessEJB_newPasswordForUserID")+user; //added by sanket
								/*mailInfoXml.append("<SUBJECT><![CDATA["+sub+"]]></SUBJECT>");
								mailInfoXml.append("<SUBJECT><![CDATA["+subject+"]]></SUBJECT>"); */
								//String msg = Messages.getString("CommonDBAccessEJB_newPasswordForITM")+newPwd; 
								/*mailInfoXml.append("<MESSAGE><![CDATA["+msg+"]]></MESSAGE>");*/
								/*mailInfoXml.append("<MESSAGE><![CDATA["+(bodyText+newPwd)+"]]></MESSAGE>");
								  mailInfoXml.append("</MAILINFO>");*/
								//Added by Pankaj T on 12-01-18 [changes for multitenancy] 
								//emailObj.sendMail(mailInfoXml.toString(),null, userInfo);
                                //Changes done by Sanket J on 20/02/17 [for Calling Message subject and body from Mail_Format]-End
                                sendPasswdVerificationMail(newPwd, toAdd, forgotPass, userInfo);
                                // Added and Commented by Pankaj R on 16-Sep-20 to show the mail dynamically from mail_format [END]
							}
							else
							{
								BaseLogger.log("3",userInfo,null,"Warning: Email ID is null For User :"+user+": !!!!!");
								if(("".equals(entityMobileNo)) || (!"".equals(entityMobileNo)) )
								{
									String formatCode="USERS_FORMAT";
									String xtraParams = "loginCode="+user+"~~loginEmpCode"+user;
									StringBuffer valueXmlString = new StringBuffer( "<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header></Header>\r\n<Errors></Errors>\r\n" );
									valueXmlString.append( "<Detail1 objName = 'user_authenticate'>\r\n" );
									//Changed by Santosh on 27-10-2017 to lookup mobile number from entityCode
									//valueXmlString.append( "<code><![CDATA[" ).append(user).append( "]]></code>\r\n" );
									valueXmlString.append( "<code><![CDATA[" ).append(entityCode).append( "]]></code>\r\n" );
									valueXmlString.append( "<password><![CDATA[" ).append(newPwd).append( "]]></password>\r\n" );
									valueXmlString.append( "</Detail1>\r\n" );
									valueXmlString.append( "</Root>\r\n" );
									String smsresp = e12smsComp.sendSMS(valueXmlString.toString(), formatCode, xtraParams, userInfo);
									BaseLogger.log("3",userInfo,null,"sms response::::"+smsresp);
								}
								else
								{
									BaseLogger.log("3",userInfo,null,"Warning: Mobile no is null For User :"+user+": !!!!!");
								}
							}										
						}
					}
					//Changed by Santosh on 27-10-2017 to read SEC_COMM_MODE from profile master to send verification code to mobile/Email [End]
				}
				else
				{
					BaseLogger.log("3",userInfo,null,"Warning:"+user+"This User Not Found !!!!!");
				}
				pStatement.close();
				pStatement = null;
				mResultSet.close();
				mResultSet = null;
				/*changed by Pankaj Tajane on 20/05/2016 for selecting preffered communication way EMAIL/SMS [S16ASER002] :End*/
			}
			else if (resType == 1)
			{
				//Lock Account
				String sqlQuery = "UPDATE USERS SET ACCT_LOCK = 'Y' WHERE CODE = '"+user+"'"; //$NON-NLS-1$ //$NON-NLS-2$
				//BaseLogger.log("9",null,null,"Locking Account :"+sqlQuery);
				//mStatement = mConnection.createStatement();
				pStatement = mConnection.prepareStatement(sqlQuery);
				int rowCnt = pStatement.executeUpdate();
				BaseLogger.log("3",userInfo,null,"User Account Locked :"+rowCnt); //$NON-NLS-1$
				pStatement.close();
				pStatement = null;
			}
			mConnection.commit();
		}
		catch( BaseException be )
		{
			BaseLogger.log("0",userInfo,null,"Exception: secureAccount:==>\n"+be); //$NON-NLS-1$
			try
			{
				mConnection.rollback();
			}
			catch (Exception sqle )
			{
				throw new BaseException( sqle );
			}	
			throw be;
		}
		catch(Exception e)
		{
			BaseLogger.log("0",userInfo,null,"Exception :CommonDBAccessEJB :secureAccount :==>\n"+e); //$NON-NLS-1$
			try
			{
				mConnection.rollback();
			}
			catch (Exception sqle )
			{
				throw new BaseException( sqle );
			}	
			throw new BaseException( e );
		}
		finally
		{
			try
			{
				if (mConnection != null)
				{
					if(pStatement != null)
					{
						pStatement.close();
						pStatement = null;
					}
					mConnection.close();
					mConnection = null;
				}	
			}
			catch (Exception e)
			{
				throw new BaseException( e );
			}
		}
	}

	private String getNewPwd(String user) throws BaseException
	{
		String newPwd = new String();
		try
		{
            user = user.trim(); // Added and Commented by Pankaj R on 16-Sep-20 to get the verification without space
			//Changed by Gulzar on 09/06/16 : START
			//If PASSWORDCOMPLEXITY == 1 then 4 digit randaom will be generate.
			//this changes is made to support in mobile device.
			//Changed By Pankaj T. on 18-09-19 for getting PASSWORD_COMPLEXITY against user defined ENTERPRISE instead of ibase.xml - start
			//String passWdComplexity = CommonConstants.PASSWORDCOMPLEXITY;
			String passWdComplexity = "";
			BaseLogger.log("3", null, null, "In getNewPwd CODE:["+user+"]");
			
			String transDB = getDBColumnValue("USERS", "TRANS_DB", "WHERE CODE = '"+user+"'");
			BaseLogger.log("3", null, null, "In getNewPwd TRANS_DB:["+transDB+"]");
			
			String enterprise = getDBColumnValue("USERS", "ENTERPRISE", "WHERE CODE = '"+user+"'");
			BaseLogger.log("3", null, null, "In getNewPwd ENTERPRISE against CODE:["+enterprise+"]");
			
			if( "".equals(E12GenericUtility.checkNull(enterprise)) )
			{
				String siteCode = getDBColumnValue("USERS", "SITE_CODE__DEF", "WHERE CODE = '"+user+"'");
				BaseLogger.log("3", null, null, "In getNewPwd SITE_CODE against CODE:["+siteCode+"]");
				
				enterprise = getDBColumnValue("SITE", "ENTERPRISE", "WHERE SITE_CODE = '"+siteCode+"'", transDB);
				BaseLogger.log("3", null, null, "In getNewPwd ENTERPRISE against SITE_CODE:["+enterprise+"]");
			}
			
			passWdComplexity = getDBColumnValue("ENTERPRISE", "PASSWORD_COMPLEXITY", "WHERE ENTERPRISE = '"+enterprise+"'", transDB);
			BaseLogger.log("3",null,null,"In getNewPwd PASSWORD_COMPLEXITY against  ENTERPRISE:["+passWdComplexity+"]");
			//Changed By Pankaj T. on 18-09-19 for getting PASSWORD_COMPLEXITY against user defined ENTERPRISE instead of ibase.xml - end
			if("1".equals(passWdComplexity))
			{
				newPwd = ""+(new Random().nextInt(9000)+1000);
			}
			else
			{
				newPwd  = user.substring((user.length()/2)).toUpperCase();
				newPwd  += user.substring(0,(user.length()/2)).toLowerCase();
				newPwd  += Math.random();
			}
			BaseLogger.log("3",null,null,"newPwd =["+newPwd+"]");
			//Changed by Gulzar on 09/06/16 : END
			if (newPwd.length() > 16)
			{
				newPwd = newPwd.substring(0, 15);
			}
		}
		catch(Exception e)
		{
			BaseLogger.log("0",null,null,"Exception :CommonDBAccessEJB :getNewPwd :==>\n"+e); //$NON-NLS-1$
			throw new BaseException( e );
		}
		return newPwd;
	}	
	
	public ArrayList getAllProfiles() throws RemoteException, BaseException
	{
		ArrayList profileIdList = new ArrayList();
		Connection mConnection = null;
		Statement mStatement = null;		
		try
		{
			ConnDriver mConnDriver = new ConnDriver();
			mConnection = mConnDriver.getConnectDB("Driver");			 //$NON-NLS-1$
			mStatement = mConnection.createStatement();			
			//Changed by Amrapali Ahire [BI1CSUN003][In publish option, list of profile id should be ordered alphabetically]
			//String selectPassWdQuery = "SELECT DISTINCT(PROFILE_ID) FROM USERS";
			String selectPassWdQuery = "SELECT DISTINCT PROFILE_ID FROM USERS ORDER BY PROFILE_ID"; //$NON-NLS-1$
			ResultSet mResultSet = mStatement.executeQuery(selectPassWdQuery);
			while(mResultSet.next())
			{
				String profileId = mResultSet.getString(1); 
				if (profileId != null)
				{
					profileIdList.add(profileId);
				}				
			}			
			mStatement.close();
			mStatement = null;
		}
		catch( BaseException be )
		{
			BaseLogger.log("0",null,null,"Exception: getNewPwd:==>\n"+be); //$NON-NLS-1$
			throw be;
		}
		catch(Exception e)
		{
			BaseLogger.log("0",null,null,"Exception :CommonDBAccessEJB :getAllProfiles :==>\n"+e); //$NON-NLS-1$
			throw new BaseException( e );
		}
		finally
		{
			try
			{
				if (mConnection != null)
				{
					if(mStatement != null)
					{
						mStatement.close();
						mStatement = null;
					}
					mConnection.close();
					mConnection = null;
				}	
			}
			catch (Exception e)
			{
				throw new BaseException( e );
			}
		}
		return profileIdList;
	}
	//Changed By Pragyan 13/12/2010 Request Id [MO01SUN014] To Update Mobile Client Information.start
	/*public void insertSessionTrace(String user, String sessionId, boolean isValidLogin) throws RemoteException, BaseException
	{
		Connection mConnection = null;
		PreparedStatement mStatement = null;		
		try
		{
			ConnDriver mConnDriver = new ConnDriver();
			mConnection = mConnDriver.getConnectDB("Driver");		
			BaseLogger.log("9",null,null,"getAutoCommit::[" + mConnection.getAutoCommit() +"]");
			java.sql.Timestamp currTime =new java.sql.Timestamp(System.currentTimeMillis());
			String query = "INSERT INTO LOGINTRACE(USERID, LOGINTIME, SESSIONID, LOGIN_STATUS) VALUES(?,?,?,?)";
			mStatement = mConnection.prepareStatement(query);						
			mStatement.setString(1,user);
			mStatement.setTimestamp(2,currTime);
			mStatement.setString(3,sessionId);
			String isValidUser = ( ( isValidLogin ) ? "T" :"F");//Manish 03/10
			mStatement.setString( 4 ,isValidUser );
			int rowCnt = mStatement.executeUpdate();
			BaseLogger.log("9",null,null,"LOGIN TRACE UPDATED :"+rowCnt);
			mConnection.commit();
			mStatement.close();
			mStatement = null;
			if( isValidLogin )
			{
				PreparedStatement mStatement1 = null;	
				query = "UPDATE USERS SET RCP_CACHE_STATUS='1' WHERE CODE='"+user+"'";
				mStatement1 = mConnection.prepareStatement(query);						
				rowCnt = mStatement1.executeUpdate();
				BaseLogger.log("9",null,null,"USERS.RCP_CACHE_STATUS UPDATED :"+rowCnt);
				mConnection.commit();
				mStatement1.close();
				mStatement1 = null;
			}
			
		}
		catch( BaseException be )
		{
			BaseLogger.log("9",null,null,"Exception: insertSessionTrace:==>\n"+be);
			try
			{
				mConnection.rollback();
			}
			catch (Exception sqle )
			{
				throw new BaseException( sqle );
			}	
			throw be;
		}
		catch(Exception e)
		{
			BaseLogger.log("9",null,null,"Exception :CommonDBAccessEJB :insertSessionTrace :==>\n"+e);
			try
			{
				mConnection.rollback();
			}
			catch (Exception sqle )
			{
				throw new BaseException( sqle );
			}	
			throw new BaseException( e );
		}
		finally
		{
			try
			{
				if (mStatement != null)
				{					
					mStatement.close();
					mStatement = null;
				}	
				if (mConnection != null)
				{					
					mConnection.close();
					mConnection = null;
				}	
			}
			catch (Exception e)
			{
				throw new BaseException( e );
			}
		}
	}*/
	
	//Added by Dnyaneshwar Chavan on 15-JAN-15  [ Host name & IP store in LoginTrace table ] START
	/***Total 6 params*/
	public void insertSessionTrace(String user, String sessionId, boolean isValidLogin, String chgIP, String chgTerm, String transDB) throws RemoteException, BaseException
	{
		// Change by Abhishek on 10.03.2016 [For Authentication chages]
		//This method call to 10 params method
		insertSessionTrace(user, sessionId, isValidLogin, chgIP, chgTerm, "", "", "", "", transDB, "", "", "", "", "");
	}
	
	/***Total 11 params*/
	// Change by Abhishek on 10.03.2016 [For authenticaion changes]
	public void insertSessionTrace(String user, String sessionId, boolean isValidLogin, String chgIP, String chgTerm, String hostName, String hostIP, String entryId, String entryType, String transDB, String batteryStatus,
			String osName, String osVersion, String clientApp, String clientAppVersion) 
			throws RemoteException, BaseException
	{
		//This method call to 12 params method
		insertSessionTrace(user, sessionId, isValidLogin, chgIP, chgTerm, "", "", hostName, hostIP, entryId, entryType, /* Dummy Parameter */'@', transDB, "", osName, osVersion, clientApp, clientAppVersion);
	}
	/***Total 8 params*/
	public void insertSessionTrace(String user, String sessionId, boolean isValidLogin, String chgIP, String chgTerm, String deviceUuId, String deviceType, String transDB ) throws RemoteException, BaseException
	{
		//This method call to 9 params method
		insertSessionTrace(user, sessionId, isValidLogin, chgIP, chgTerm, deviceUuId, deviceType, "", "", null, null, /* Dummy Parameter */ '@', transDB,"", "", "","","");
	}
	/***Total 9 params*/
	// Changed 13 from 9
	public void insertSessionTrace(String user, String sessionId, boolean isValidLogin, String chgIP, String chgTerm, String deviceUuId,
								   String deviceType, String hostName, String hostIP, String entryId, String entryType, char dummy, String transDB, 
								   String batteryStatus, String osName, String osVersion, String clientApp, String clientAppVersion) 
			throws RemoteException, BaseException
	{
		if( "".equalsIgnoreCase( deviceType ) )
		{
			//This method call to 16 params method
			// insertSessionTrace(user,sessionId,isValidLogin,null,null,null,null,null,null,chgIP,chgTerm, hostName, hostIP);
			insertSessionTrace(user, sessionId, isValidLogin, null, null, null, null, null, null, chgIP, chgTerm, "", hostName, hostIP, entryId, entryType, transDB, batteryStatus, osName, osVersion, clientApp, clientAppVersion);
		}
		else
		{
			//This method call to 16 params method
			insertSessionTrace( user, sessionId, isValidLogin, deviceUuId, null, null, null, null, null, chgIP, chgTerm, deviceType, hostName, hostIP, entryId, entryType, transDB, batteryStatus, osName, osVersion, clientApp, clientAppVersion);
		}
	}
	/***Total 11 params*/
	public void insertSessionTrace(String user, String sessionId, boolean isValidLogin, String cellID,String lac,String imei,String imsi,String mnc,String mcc, String chgIP, String chgTerm, String transDB ) throws RemoteException, BaseException
	{
		//This method call to 13 params method
		insertSessionTrace(user, sessionId, isValidLogin, cellID, lac, imei, imsi, mnc, mcc, chgIP, chgTerm, "","", transDB );
	}
	/***Total 14 params*/
	public void insertSessionTrace(String user, String sessionId, boolean isValidLogin, String cellID,String lac,String imei,String imsi,String mnc,String mcc, String chgIP, String chgTerm,String hostName, String hostIP, String transDB ) throws RemoteException, BaseException
	{
		//This method call to 16 params method
		insertSessionTrace(user, sessionId, isValidLogin, cellID, lac, imei, imsi, mnc, mcc, chgIP, chgTerm, "", hostName, hostIP, null, null, transDB, "", "", "", "", "");
	}
	/***Total 13 params*/
	public void insertSessionTrace(String user, String sessionId, boolean isValidLogin, String cellID,String lac,String imei,String imsi,String mnc,String mcc, String chgIP, String chgTerm, String deviceType, String transDB ) throws RemoteException, BaseException
	{
		//This method call to 16 params method
		insertSessionTrace(user, sessionId, isValidLogin, cellID, lac, imei, imsi, mnc, mcc, chgIP, chgTerm, deviceType, "", "", null, null, transDB, "", "", "", "", "");
	}
	
	/** Total 16*/
	// Change by Abhishek on 11.03.2016 [For authentication changes]
	public void insertSessionTrace(
		String user, String sessionId, boolean isValidLogin, String cellID,String lac,
		String imei,String imsi,String mnc,String mcc, String chgIP, String chgTerm, 
		String deviceType, String hostName, String hostIP, String entryId, String entryType, String transDB, String batteryStatus,
		String osName, String osVersion, String clientApp, String clientAppVersion)
	 throws RemoteException, BaseException
	{
		Connection mConnection = null;
		PreparedStatement mStatement = null;		
		try
		{
			ConnDriver mConnDriver = new ConnDriver();
			mConnection = mConnDriver.getConnectDB("Driver");
			//BaseLogger.log("9",null,null,"getAutoCommit::[" + mConnection.getAutoCommit() +"]");
			java.sql.Timestamp currTime =new java.sql.Timestamp(System.currentTimeMillis());
			//Change by Nilesh on 18-Mar-2011 [MF01SUN037][To add clientIP & ChgTerm ]
			//String query = "INSERT INTO LOGINTRACE(USERID, LOGINTIME, SESSIONID, LOGIN_STATUS,CELL_ID,LAC,IMEI,IMSI,MNC,MCC) VALUES(?,?,?,?,?,?,?,?,?,?)";
			
			//Added by Dnyaneshwar Chavan on 02-OCT-13 [WS3GSUN002] [ Device ID & type store in LoginTrace table ] START
			boolean isNullDeviceType = ( deviceType == null || "".equalsIgnoreCase( deviceType ) ) ? true : false;
			// Added by Pankaj R on 20-JAN-18
			boolean isNullBatteryStatus = ( batteryStatus == null || "".equalsIgnoreCase( batteryStatus ) ) ? true : false;
			String query = "";
			if( !isNullBatteryStatus )
			{
				query = "INSERT INTO LOGINTRACE(USERID, LOGINTIME, SESSIONID, LOGIN_STATUS,CELL_ID,LAC,IMEI,IMSI,MNC,MCC,CHG_IP,CHG_TERM, DEVICE_TYPE,HOST_NAME,HOST_IP, ENTRY_ID, ENTRY_TYPE, OS_NAME, OS_VERSION, CLIENT_APP, CLIENT_APP_VER, LOGIN_BATTERY_STAT) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)"; //$NON-NLS-1$
				// Change by Abhishek on 13.03.2016 [Req Id:S15LBAS004 Authentication changes]
			}
			else
			{
				// Change by Abhishek on 13.03.2016 [Req Id:S15LBAS004 Authentication changes]
				query = "INSERT INTO LOGINTRACE(USERID, LOGINTIME, SESSIONID, LOGIN_STATUS,CELL_ID,LAC,IMEI,IMSI,MNC,MCC,CHG_IP,CHG_TERM, DEVICE_TYPE,HOST_NAME,HOST_IP, ENTRY_ID, ENTRY_TYPE, OS_NAME, OS_VERSION, CLIENT_APP, CLIENT_APP_VER) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)"; //$NON-NLS-1$
			}
			// Added by Pankaj R on 20-JAN-18
			//Added by Dnyaneshwar Chavan on 02-OCT-13 [WS3GSUN002] [ Device ID & type store in LoginTrace table ] END
			mStatement = mConnection.prepareStatement(query);
			mStatement.setString(1, user.trim());
			mStatement.setTimestamp(2,currTime);
			mStatement.setString(3,sessionId);
			String isValidUser = ( ( isValidLogin ) ? "T" :"F");//Manish 03/10 //$NON-NLS-1$ //$NON-NLS-2$
			mStatement.setString( 4 ,isValidUser );
			mStatement.setString( 5 ,cellID );
			mStatement.setString( 6 ,lac );
			mStatement.setString( 7 ,imei );
			mStatement.setString( 8 ,imsi );
			mStatement.setString( 9 ,mnc );
			mStatement.setString( 10 ,mcc );
			//Change By Nilesh on 21-Mar-2011 [MF01SUN037][To add clientIP & chgTerm into logintrace]Start
			mStatement.setString( 11, chgIP );
			mStatement.setString( 12, chgTerm );
			//Added by Dnyaneshwar Chavan on 02-OCT-13 [WS3GSUN002] [ Device ID & type store in LoginTrace table ] START
			//Added by Dnyaneshwar Chavan on 15-JAN-15  [ Host name & IP are store in LoginTrace table ] START
			// Added by Pankaj R on 20-JAN-18
			mStatement.setString( 13, deviceType );
			mStatement.setString( 14, hostName );
			mStatement.setString( 15, hostIP );
			
			// Change by Abhishek on 13.03.2016 [Req Id:S15LBAS004 Authentication changes] START
			mStatement.setString(16, entryId);
			mStatement.setString(17, entryType);
			mStatement.setString(18, osName);
			mStatement.setString(19, osVersion);
			mStatement.setString(20, clientApp);
			mStatement.setString(21, clientAppVersion);
			if( ! isNullBatteryStatus )
			{
//				mStatement.setString( 14, hostName );
//				mStatement.setString( 15, hostIP );
//				// Change by Abhishek on 13.03.2016 [Req Id:S15LBAS004 For authentication changes] START
//				mStatement.setString(16, entryId);
//				mStatement.setString(17, entryType);
				// Change by Abhishek on 13.03.2016 [Req Id:S15LBAS004 For authentication changes] END
				mStatement.setInt(22, Integer.parseInt(batteryStatus));
			}
			/*else
			{
//				mStatement.setString( 14, hostName );
//				mStatement.setString( 15, hostIP );
//				
//				// Change by Abhishek on 13.03.2016 [Req Id:S15LBAS004 Authentication changes] START
//				mStatement.setString(16, entryId);
//				mStatement.setString(17, entryType);
				// Change by Abhishek on 13.03.2016 [Req Id:S15LBAS004 For authentication changes] END
			}*/
			//Added by Dnyaneshwar Chavan on 15-JAN-15  [ Host name & IP are store in LoginTrace table ] END
			//Added by Dnyaneshwar Chavan on 02-OCT-13 [WS3GSUN002] [ Device ID & type store in LoginTrace table ] END
			
			//Change by Nilesh on 21-Mar-2011 [MF01SUN037][To add clientIP & chgTerm into logintrace]End
			int rowCnt = mStatement.executeUpdate();
			BaseLogger.log("3",null,null,"LOGIN TRACE UPDATED :"+rowCnt); //$NON-NLS-1$
			mConnection.commit();
			mStatement.close();
			mStatement = null;

			if( isValidLogin )
			{
				PreparedStatement mStatement1 = null;	
				query = "UPDATE USERS SET RCP_CACHE_STATUS='1' WHERE CODE='"+user+"'"; //$NON-NLS-1$ //$NON-NLS-2$
				mStatement1 = mConnection.prepareStatement(query);						
				rowCnt = mStatement1.executeUpdate();
				BaseLogger.log("3",null,null,"USERS.RCP_CACHE_STATUS UPDATED :"+rowCnt); //$NON-NLS-1$
				mConnection.commit();
				mStatement1.close();
				mStatement1 = null;
			}
			
		}
		catch( BaseException be )
		{
			BaseLogger.log("0",null,null,"Exception: insertSessionTrace:==>\n"+be); //$NON-NLS-1$
			try
			{
				mConnection.rollback();
			}
			catch (Exception sqle )
			{
				throw new BaseException( sqle );
			}	
			throw be;
		}
		catch(Exception e)
		{
			BaseLogger.log("0",null,null,"Exception :CommonDBAccessEJB :insertSessionTrace :==>\n"+e); //$NON-NLS-1$
			try
			{
				mConnection.rollback();
			}
			catch (Exception sqle )
			{
				throw new BaseException( sqle );
			}	
			throw new BaseException( e );
		}
		finally
		{
			try
			{
				//Added by shrutika on 16-01-18 [Start] for statement not close.
				if (mStatement != null)
				{					
					mStatement.close();
					mStatement = null;
				}
				//Added by shrutika on 16-01-18 [End] for statement not close.
				if (mConnection != null)
				{					
					mConnection.close();
					mConnection = null;
				}	
			}
			catch (Exception e)
			{
				throw new BaseException( e );
			}
		}
	}
	//Added by Dnyaneshwar Chavan on 15-JAN-15  [ Host name & IP store in LoginTrace table ] End
	//Change By Nilesh on 18-Mar-2011 [MF01SUN037][To add client ip & chgTerm ]
//Changed By Pragyan 13/12/2010 Request Id [MO01SUN014] To Update Mobile Client Information.end
	public void updateSessionTrace(String user,String sessionId) throws RemoteException, BaseException
	{
		Connection mConnection = null;
		PreparedStatement mStatement = null;		
		try
		{
			//Changed By Pankaj T. on 24-07-19 for unable to update record when userId contains blank space 
			user = E12GenericUtility.checkNull(getUserCode(user));
			ConnDriver mConnDriver = new ConnDriver();
			mConnection = mConnDriver.getConnectDB("Driver");	 //$NON-NLS-1$
			//BaseLogger.log("9",null,null,"getAutoCommit::[" + mConnection.getAutoCommit() +"]");
			java.sql.Timestamp currTime =new java.sql.Timestamp(System.currentTimeMillis());
            //String query = "UPDATE LOGINTRACE SET LOGOUTTIME = ? WHERE USERID=? AND SESSIONID = ?"; //$NON-NLS-1$
            String query = "UPDATE LOGINTRACE SET LOGOUT_MODE='L', LOGOUTTIME = ? WHERE USERID=? AND SESSIONID = ?"; //$NON-NLS-1$
			mStatement = mConnection.prepareStatement(query);						
			mStatement.setTimestamp(1,currTime);
			mStatement.setString(2,user);
			mStatement.setString(3,sessionId);
			int rowCnt = mStatement.executeUpdate();
			BaseLogger.log("3",null,null, "LOGIN TRACE UPDATED :"+rowCnt ); //$NON-NLS-1$
			mStatement.close();
			mStatement = null;
			mConnection.commit();
		}
		catch( BaseException be )
		{
			BaseLogger.log("0",null,null, "Exception: updateSessionTrace:==>\n"+be ); //$NON-NLS-1$
			try
			{
				mConnection.rollback();
			}
			catch (Exception sqle )
			{
				throw new BaseException( sqle );
			}	
			throw be;
		}
		catch(Exception e)
		{
			BaseLogger.log("0",null,null,"Exception :CommonDBAccessEJB :updateSessionTrace :==>\n"+e); //$NON-NLS-1$
			try
			{
				mConnection.rollback();
			}
			catch (Exception sqle )
			{
				throw new BaseException( sqle );
			}	
			throw new BaseException( e );
		}
		finally
		{
			try
			{
				if(mStatement != null)
				{
					mStatement.close();
					mStatement = null;
				}
				if (mConnection != null)
				{					
					mConnection.close();
					mConnection = null;
				}	
			}
			catch (Exception e)
			{
				throw new BaseException( e );
			}
		}
	}

	//Changed By Danish on 29/08/2006 reason [to validate the existance of site in userSite]
	public boolean isValidSite( String user, String siteCode )throws RemoteException, BaseException
	{
		boolean valid = false;
		Statement stmt = null;
		Connection con	= null;
		try
		{
			UserInfoBean userInfoBean = createUserInfo(user);
			String transDB = userInfoBean.getTransDB();
			ConnDriver mConnDriver = new ConnDriver();
			con = mConnDriver.getConnectDB(transDB);
			
			//Commented and changes below by Gulzar on 18/10/13 : START
			//Commented and changes below by Gulzar on 18/10/13 : START
			
			stmt = con.createStatement();
			String query = "SELECT COUNT(1) CNT FROM USER_SITE WHERE USER_ID='"+user+"' AND SITE_CODE='"+siteCode+"' "; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			//BaseLogger.log("9",null,null,"Selecting Existance ["+query+"]");
			ResultSet rs = stmt.executeQuery(query);
			if(rs.next())
			{
				if( rs.getInt("CNT") > 0 ) //$NON-NLS-1$
				{
					valid = true;
				}
			}
			rs.close();
			rs = null;
			stmt.close();
			stmt = null;
		}
		catch( BaseException be )
		{
			BaseLogger.log("0",null,null, "Exception: isValidSite:==>\n"+be ); //$NON-NLS-1$
			throw be;
		}
		catch (Exception e)
		{
			throw new BaseException( e );
		}
		finally
		{
			try
			{
				if(con != null)
				{
					if(stmt != null)
					{
						stmt.close();
						stmt = null;
					}
				}
			}
			catch (Exception e)
			{
				throw new BaseException( e );
			}
		}
		BaseLogger.log("2",null,null,"isValidSite ["+valid+"]"); //$NON-NLS-1$ //$NON-NLS-2$
		return valid;
	}
	
	private boolean isBiUser(String user) 
	{
		boolean isUser = false;
		Connection mConnection = null;
		Statement mStatement = null;		
		try
		{
			ConnDriver mConnDriver = new ConnDriver();
			mConnection = mConnDriver.getConnectDB("DriverBI");			 //$NON-NLS-1$
			mStatement = mConnection.createStatement();			
			String selectPassWdQuery = "SELECT COUNT(BA_ID) FROM BI_USERS WHERE CODE = '"+user+"'"; //$NON-NLS-1$ //$NON-NLS-2$
			ResultSet mResultSet = mStatement.executeQuery(selectPassWdQuery);
			if(mResultSet.next())
			{
				int recCount = mResultSet.getInt(1); 
				if (recCount > 0)
				{
					isUser = true;
				}
			}			
			mResultSet.close();
			mResultSet = null;
			mStatement.close();
			mStatement = null;
		}
		catch( BaseException be )
		{
			BaseLogger.log("0",null,null, "Exception: isBiUser:==>\n"+be ); //$NON-NLS-1$
//			throw be;
		}
		catch(Exception e)
		{
			BaseLogger.log("0",null,null,"Exception :CommonDBAccessEJB :isBiUser :==>\n"+e); //$NON-NLS-1$
			//throw new BaseException( e );
		}
		finally
		{
			try
			{
				if (mConnection != null)
				{
					if(mStatement != null)
					{
						mStatement.close();
						mStatement = null;
					}
					mConnection.close();
					mConnection = null;
				}	
			}
			catch (Exception e)
			{
				BaseLogger.log("0",null,null,"Exception :CommonDBAccessEJB :isBiUser :==>\n"+e); //$NON-NLS-1$
				//throw new BaseException( e );
			}
		}
		return isUser;
	}

	//Kunjal 02-Sep-06.
	private void setLogger() throws BaseException
	{
		try
		{
			
			//Changes done by Gaurav Singh on 13-JUL-2016 [ setIBASEHOME only when TOMCAT_HOME is null | Start ]
			//CommonConstants.setIBASEHOME();
			//CommonConstants.setBIHOME();
			if(CommonConstants.TOMCAT_HOME == null || CommonConstants.TOMCAT_HOME.trim().length() == 0)
			{
				CommonConstants.setIBASEHOME();
				CommonConstants.setBIHOME();
			}
			//Changes done by Gaurav Singh on 13-JUL-2016 [ setIBASEHOME only when TOMCAT_HOME is null | End ]			
			PrintStream outVal = System.out;
			/*if( CommonConstants.LOGGER_TYPE.equalsIgnoreCase("F") || ( CommonConstants.LOGGER_TYPE.equalsIgnoreCase("C") && CommonConstants.DEBUG_LEVEL.equals("0")) ) //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			{
				String fileName = CommonConstants.LOG_PATH + File.separator + "temp.txt"; //$NON-NLS-1$
				File file = new File(fileName);
				PrintStream printStream = new BasePrintStream(new FileOutputStream(file));
				System.setOut(printStream);
			}*/
		}
		catch( BaseException be )
		{
			BaseLogger.log("0",null,null, "Exception: setLogger:==>\n"+be ); //$NON-NLS-1$
			throw be;
		}
		catch (Exception itme)
		{
			BaseLogger.log("0",null,null,"Exception ::setLogger() :==>\n"+itme.getMessage()); //$NON-NLS-1$
			throw new BaseException( itme );
		}
	}

	//Changed by Manish on 06/10/2006 to solve the bug of INVALID_SITE. Start
	private String getSiteAccessStatus( Connection mConnection, String mUserID, String siteCode, String userLevel ) throws BaseException
	{
		//BaseLogger.log("9",null,null, "Checking site access status for User ID :[" + mUserID + "] Site Code :[" + siteCode + "] User Level :[" + userLevel + "]" );
		String siteAccessStatus = "INVALID_SITE"; //$NON-NLS-1$
		// Changed by Sandesh Shinde on 17-MAY-2017 [ Authentication API: SQL Injection]
		PreparedStatement stmt = null;
		ResultSet rs = null;
		try
		{
			int siteStatusInt = -1;
			// Changed by Sandesh Shinde on 17-MAY-2017 [ Authentication API: SQL Injection] Start
			String selectQuery = "SELECT COUNT( SITE_CODE ) FROM SITE WHERE SITE_CODE= ?"; //$NON-NLS-1$ //$NON-NLS-2$
			
			stmt = mConnection.prepareStatement(selectQuery);
			stmt.setString(1, siteCode);
			BaseLogger.log("3",null,null," CommonDBAcessEJB :: authenticate : selectQuery["+selectQuery+"]");//Added By Umakanta on 23/AUG/14 For Invalid site code.
			rs = stmt.executeQuery();
			// Changed by Sandesh Shinde on 17-MAY-2017 [ Authentication API: SQL Injection] End
			if (rs.next())
			{
				siteStatusInt = rs.getInt( 1 );
				BaseLogger.log("3",null,null, "Count from SITE :["+siteStatusInt+"]" ); //$NON-NLS-1$ //$NON-NLS-2$
			}
			rs.close();
			rs = null;
			stmt.close();
			stmt = null;
			if( siteStatusInt == 1 )
			{
				if( userLevel != null && userLevel.length() > 0 )
				{
					int userLevelInt = Integer.parseInt( userLevel );
					if( userLevelInt > 1 )
					{
						// Changed by Sandesh Shinde on 17-MAY-2017 [ Authentication API: SQL Injection] Start
						selectQuery = "SELECT COUNT( SITE_CODE ) FROM USER_SITE WHERE USER_ID=? AND SITE_CODE=?"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
						stmt = mConnection.prepareStatement(selectQuery);
						stmt.setString(1, mUserID);
						stmt.setString(2, siteCode);
						BaseLogger.log("3",null,null," CommonDBAcessEJB :: authenticate : selectQuery["+selectQuery+"]");//Added By Umakanta on 23/AUG/14 For Invalid site code.
						rs = stmt.executeQuery();
						// Changed by Sandesh Shinde on 17-MAY-2017 [ Authentication API: SQL Injection] End
						if (rs.next())
						{
							siteStatusInt = rs.getInt( 1 );
							BaseLogger.log("3",null,null, "Count from USER_SITE :["+siteStatusInt+"]" ); //$NON-NLS-1$ //$NON-NLS-2$
						}
						stmt.close();
						stmt = null;
						if( siteStatusInt == 0 )
						{
							siteAccessStatus = "INACCESSIBLE_SITE"; //$NON-NLS-1$
						}
						else
						{
							siteAccessStatus = siteCode;
						}
					}//if( userLevelInt > 1 )
					else
					{
						siteAccessStatus = siteCode;
					}
				}//if( userLevel != null && userLevel.length() > 0 )
			}//if( siteStatusInt == 1 )
			
		}
		
		catch (Exception e)
		{
			BaseLogger.log("0",null,null,"Exception :CommonDBAccessEJB :checkSiteAccessStatus :==>"); //$NON-NLS-1$
			throw new BaseException(e);
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if(stmt !=null){
					stmt.close();
					stmt = null;
				}
			}
			catch (Exception e)
			{
				BaseLogger.log("0",null,null,"Exception :CommonDBAccessEJB :getMinPwdLength :finally :==>\n"+e); //$NON-NLS-1$
			}
		}
		
		BaseLogger.log("2",null,null,"[CommonDBAccessEJB]Returning checkSiteAccessStatus :"+siteAccessStatus); //$NON-NLS-1$
		return siteAccessStatus;
	}

	public int getMinPwdLength(String transDB) throws BaseException
	{
		int minPwdLength = -1;
		Connection mConnection = null;
		try
		{
			ConnDriver mConnDriver = new ConnDriver();
			if(transDB!=null && (transDB.trim().length() >0 ))
			{
				mConnection = mConnDriver.getConnectDB(transDB);
			}
			
			Statement mStatement = mConnection.createStatement();
			ResultSet mResultSet = mStatement.executeQuery( "SELECT MIN_PWD_LENGTH FROM PARAMETER" ); //$NON-NLS-1$
			if ( mResultSet.next() )
			{
				minPwdLength = mResultSet.getInt( 1 );
			}
			mResultSet.close();
			mResultSet = null;
			mStatement.close();
			mStatement = null;
		}
		catch (Exception e)
		{
			//BaseLogger.log("9",null,null,"Exception :CommonDBAccessEJB :getMinPwdLength :==>");
			throw new BaseException(e);
		}
		finally
		{
			try
			{
				if (mConnection != null)
				{
					mConnection.close();
					mConnection = null;
				}	
			}
			catch (Exception e)
			{
				BaseLogger.log("0",null,null,"Exception :CommonDBAccessEJB :getMinPwdLength :finally :==>\n"+e); //$NON-NLS-1$
			}
		}
		return minPwdLength;
	}
//	Changed By Rupali Hande on 24/03/08 [Remove dependacy of AuthenticateServlet from webitem] Request ID[BI78SUN047].Start
	public String [] getEmpInfo(String mUserID, String site, String transDB) throws RemoteException,BaseException
	{
		//Changed By Rupali on 27/03/2008.[To add the Email ID in UserInfo].Request ID:-[BI78SUN047]
		//String [] arr= new String[12];
		//Changed by Rupali Hande on 26-08-2008 [to add the logger_status in userInfo]Request ID:-[BI89SUN007]
		//String [] arr= new String[13];
		//Changed by Swapnil Shirke on 01-Jul-2010 [to add stan_code__hq, designation, date of join, division in userInfo][WS90SUN043] starts
		//String [] arr= new String[14];
		//Change by Nilesh on 21-Mar-2011[WS01SUN062][Add language & country into userinfo]
		//String [] arr= new String[18];
		//Changes Done By Shahu Mali on 08-10-13
		//String [] arr= new String[20];

		//Changes by Prajyot [Add theme into userinfo]
		//String [] arr= new String[24];
		//Change by Shrutika on 14-02-18 [Start] for set fin_entity value when login (increase the size of array).
		//String [] arr= new String[25];
		//Changes made by Pratheek on 29-01-19[ increase the size of array for getting facility_code values. ]-Start
		//String [] arr= new String[26];
		String [] arr= new String[27];
		//Changes made by Pratheek on 29-01-19[ increase the size of array for getting facility_code values. ]-End
		Connection mConnection = null;
		Connection usrsConnection = null;
		ConnDriver mConnDriver = null;
		String mQuery = null;
		String mQuery1 = null;
		String mQuery2 = null;
		Statement mStmt = null;
		ResultSet mRs = null;
		try
		{
			if(site != null)
			{
				site = site.trim();
			}
			if(mUserID != null)
			{
				mUserID = mUserID.trim();
			}
			mConnDriver = new ConnDriver();
			mConnection = mConnDriver.getConnectDB(transDB); //$NON-NLS-1$
			usrsConnection = mConnDriver.getConnectDB("Driver");
			arr[0]="";//EMP_NO //$NON-NLS-1$
			arr[1]="";//FNAME.MNAME.LNAME //$NON-NLS-1$
			arr[2]="";//REPORT_TO //$NON-NLS-1$
			arr[3]="";//DCODE //$NON-NLS-1$
			arr[4]= "";//DEPT //$NON-NLS-1$
			arr[5]="";//SITE_CODE //$NON-NLS-1$
			arr[6]= "";//SITE_DESCR //$NON-NLS-1$
			arr[7]= "";//USER_LEVEL //$NON-NLS-1$
			arr[8]= "";//USER_TYPE //$NON-NLS-1$
			arr[9]= "";//ENTITY_CODE //$NON-NLS-1$
			arr[10]= "";//PROFILE_ID //$NON-NLS-1$
			arr[11]= "";//ITEM_SER //$NON-NLS-1$
			//Changed By Rupali on 27/03/2008.[To add the Email ID in UserInfo].Request ID:-[BI78SUN047] 
			arr[12] = ""; //Email-ID //$NON-NLS-1$
			//Example
			//Changed by Rupali Hande on 26-08-2008 [to add the logger_status in userInfo]Request ID:-[BI89SUN007].Start
			arr[13] = ""; //Logger status //$NON-NLS-1$
			//Changed by Rupali Hande on 26-08-2008 [to add the logger_status in userInfo]Request ID:-[BI89SUN007].End
			//Changed by Swapnil Shirke on 01-Jul-2010 [to add stan_code__hq, designation, dateOfJoining, division in userInfo][WS90SUN043] starts
			arr[14] = ""; //STAN_CODE__HQ //$NON-NLS-1$
			arr[15] = ""; //DESIGNATION //$NON-NLS-1$
			arr[16] = ""; //DATE_JOIN //$NON-NLS-1$
			arr[17] = ""; //DIVISION //$NON-NLS-1$
			//Changed by Swapnil Shirke on 01-Jul-2010 [to add stan_code__hq, designation, dateOfJoining, division in userInfo][WS90SUN043] ends
			//Change by Nilesh on 21-Mar-2011[WS01SUN062][set lang & country from users]Start
			arr[18] = "";//LANGUAGE //$NON-NLS-1$
			arr[19] = "";//COUNTRY //$NON-NLS-1$
			//Added Done By Shahu Mali On 08-10-13
			arr[20] = "";// TRANS_DB //$NON-NLS-1$

			//Added by Prajyot 18MAR2014[Theme Implementation]
			arr[21] = "";// USER_THEME //$NON-NLS-1$
			
			//Change by Nilesh on 21-Mar-2011[WS01SUN062][set lang & country from users]End
			//BaseLogger.log("9",null,null,"User: "+mUserID);
			//BaseLogger.log("9",null,null,"Site: "+site);
			BaseLogger.log("3",null,null,"Retrieving EmployeeInformation.....");			 //$NON-NLS-1$
			//changed by gayatri[ SY01SUN013 || To allocate different set of rights to the same user for different sites based on different profile id]start
			String profileId=""; //$NON-NLS-1$
			if ( ( mUserID != null ) && ! ( site.equals( "" ) ) ) //$NON-NLS-1$
			{
				//changed by gayatri[ SY01SUN013 || To allocate different set of rights to the same user for different sites based on different profile id]start
				mStmt = mConnection.createStatement();
				String getSiteCodeWiseMenu="SELECT PROFILE_ID FROM USER_SITE WHERE USER_ID='" +mUserID+ "' AND SITE_CODE='" +site+ "'"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
				//BaseLogger.log("9",null,null,"CommonDBAccessEJB:getEmpInfo:getSiteCodeWiseMenu="+getSiteCodeWiseMenu);
				mRs = mStmt.executeQuery(getSiteCodeWiseMenu);
						
				if ( mRs.next() )
				{
					profileId=mRs.getString("PROFILE_ID"); //$NON-NLS-1$
				}
				//BaseLogger.log("9",null,null,"CommonDBAccessEJB:getEmpInfo:Profile Id from USER_SITE :["+profileId+"]");
				if ( mRs != null )
				{
					mRs.close();
					mRs = null;
				}
				if ( mStmt != null )
				{
					mStmt.close();
					mStmt = null;
				}			
				//changed by gayatri [ SY01SUN013 || To allocate different set of rights to the same user for different sites based on different profile id]end

				//Changed By Rupali on 20/05/2008.[Remove the email column from the user table].Request ID:-[BI78SUN047].Start 
				//Changed By Rupali on 27/03/2008.[To add the Email ID in UserInfo].Request ID:-[BI78SUN047] 
				//mQuery1 = "SELECT USR_LEV,USER_TYPE,ENTITY_CODE,PROFILE_ID FROM USERS WHERE CODE ='" + mUserID + "'"; 
				//mQuery1 = "SELECT USR_LEV,USER_TYPE,ENTITY_CODE,PROFILE_ID,EMAIL_ID FROM USERS WHERE CODE ='" + mUserID + "'";
				//Changed by Rupali Hande on 26-08-2008 [to add the logger_status in userInfo]Request ID:-[BI89SUN007]
				//Change by Nilesh on 21-Mar-2011 [WS01SUN062][set lang & country from users]
				//mQuery1 = "SELECT USR_LEV,USER_TYPE,ENTITY_CODE,PROFILE_ID,LOGGER_TYPE FROM USERS WHERE CODE ='" + mUserID + "'";
				
				//Commented and add TRANS_DB column in select query Done By Shahu Mali On 08-10-13
				//mQuery1 = "SELECT USR_LEV,USER_TYPE,ENTITY_CODE,PROFILE_ID,LOGGER_TYPE,USER_LANG,USER_COUNTRY FROM USERS WHERE CODE ='" + mUserID + "'"; //$NON-NLS-1$ //$NON-NLS-2$
				mQuery1 = "SELECT USR_LEV,USER_TYPE,ENTITY_CODE,PROFILE_ID,LOGGER_TYPE,USER_LANG,USER_COUNTRY,TRANS_DB, USER_THEME, UX_INTERFACE, ENTERPRISE FROM USERS WHERE CODE ='" + mUserID + "'"; //$NON-NLS-1$ //$NON-NLS-2$
				//Changed By Rupali on 20/05/2008.[Remove the email column from the user table].Request ID:-[BI78SUN047].End
				mStmt = usrsConnection.createStatement();
				mRs = mStmt.executeQuery(mQuery1);
				int level = 0;
				BaseLogger.log("3",null,null,"Selecting User Level, User Type, Entity Code, Profile Id........."); //$NON-NLS-1$
				if(mRs.next())
				{
					level = mRs.getInt("USR_LEV"); //$NON-NLS-1$
					arr[7] = new Integer(level).toString();
					//BaseLogger.log("9",null,null,"User Level :["+level+"]");
					arr[8] = mRs.getString("USER_TYPE"); //$NON-NLS-1$
					///BaseLogger.log("9",null,null,"User Type :["+arr[8]+"]");
					arr[9] = mRs.getString("ENTITY_CODE"); //$NON-NLS-1$
					//BaseLogger.log("9",null,null,"Entity Code :["+arr[9]+"]");
					//Added by Nilesh on 21-Mar-2011 [WS01SUN062][to set lang & country from users table]Start
					arr[18] = mRs.getString("USER_LANG"); //$NON-NLS-1$
					//BaseLogger.log("9",null,null,"USER LANG :["+arr[18]+"]");
					arr[19] = mRs.getString("USER_COUNTRY"); //$NON-NLS-1$
					//BaseLogger.log("9",null,null,"USER COUNTRY :["+arr[19]+"]");
					//Added by Nilesh on 21-Mar-2011 [WS01SUN062][to set lang & country from users table]End
					//changed by gayatri[ SY01SUN013 || To allocate different set of rights to the same user for different sites based on different profile id]start
					//arr[10] = mRs.getString("PROFILE_ID");					
					//if( profileId.length()!=0 )
					
					//Get the value of trans_db and put in the array : Shahu :
					arr[20] = mRs.getString("TRANS_DB"); //$NON-NLS-1$
					BaseLogger.log("3",null,null,"USER TRANS_DB :["+arr[20]+"]");
					
					//Get the value of userTheme and put in the array
					arr[21] = mRs.getString("USER_THEME"); //$NON-NLS-1$
					BaseLogger.log("3",null,null,"USER_THEME :["+arr[21]+"]");
					//Added by Vishal Pathare on 16-AUG-2016 for[getting <UX_INTERFACE> for applying themes]
					arr[22] = mRs.getString("UX_INTERFACE"); //$NON-NLS-1$
					BaseLogger.log("3",null,null,"UX_INTERFACE :["+arr[22]+"]");
					arr[23] = mRs.getString("ENTERPRISE"); //$NON-NLS-1$
					BaseLogger.log("3",null,null,"ENTERPRISE :["+arr[23]+"]");

					if(profileId != null && profileId.length()!= 0 )//changed by gayatri on 04-02-2011[ SY01SUN013] [to remove null pointer exception]
					{
						arr[10] = profileId;
					}
					else
					{
						arr[10] = mRs.getString("PROFILE_ID"); //$NON-NLS-1$
					}
					//changed by gayatri[ SY01SUN013 || To allocate different set of rights to the same user for different sites based on different profile id]end
					//BaseLogger.log("9",null,null,"CommonDBAccessEJB:getEmpInfo:Profile Id After setting:["+arr[10]+"]");
					//Changed by Rupali Hande on 26-08-2008 [to add the logger_status in userInfo]Request ID:-[BI89SUN007]
					arr[13] = mRs.getString("LOGGER_TYPE"); //$NON-NLS-1$
					BaseLogger.log("3",null,null,"logger_type :["+arr[13]+"]"); //$NON-NLS-1$ //$NON-NLS-2$
					//Commented By Rupali on 20/05/2008.[Remove the email column from the user table].Request ID:-[BI78SUN047].Start
					//Changed By Rupali on 27/03/2008.[To add the Email ID in UserInfo].Request ID:-[BI78SUN047].Start
					//arr[12] = mRs.getString("EMAIL_ID");
					//BaseLogger.log("9",null,null,"Email_Id :["+arr[12]+"]");
					//Changed By Rupali on 27/03/2008.[To add the Email ID in UserInfo].Request ID:-[BI78SUN047].End
					//Commented By Rupali on 20/05/2008.[Remove the email column from the user table].Request ID:-[BI78SUN047].End
				}
				mRs.close();
				mRs = null;
				BaseLogger.log("3",null,null, "Employee Information if not printed above then not set........." ); //$NON-NLS-1$
				//Commented by Manish on 06/10/2006 as teh same work is done from COmmonDBAccessEJB
				//arr[5] = getSiteAccessStatus( mConnection, mUserID, site, arr[7] );
				
				arr[8] = (arr[8] == null || "null".equalsIgnoreCase(arr[8])) ? "E" : arr[8]; //$NON-NLS-1$ //$NON-NLS-2$
				mStmt.close();
				mStmt = null;
				//BaseLogger.log("9",null,null,"Selecting Employee Details from  EMPLOYEE, DEPARTMENT");
				//Swapnil on 01-JUL-2010 [WS90SUN043] [Adding stan_code__hq in select query] starts
				/*
				mQuery = "SELECT EMP_CODE ENO , EMP_SITE,EMP_FNAME FNAME, EMP_MNAME MNAME,EMP_LNAME LNAME," +
							 "REPORT_TO, B.DEPT_CODE DCODE, B.DESCR DEPT FROM EMPLOYEE A, DEPARTMENT B " +
							 "WHERE A.DEPT_CODE=B.DEPT_CODE AND EMP_CODE " +
							 " = ( SELECT  EMP_CODE  FROM USERS WHERE " +
							 "CODE='" + mUserID + "')";
				*/
				/*mQuery = "SELECT EMP_CODE ENO , EMP_SITE,EMP_FNAME FNAME, EMP_MNAME MNAME,EMP_LNAME LNAME," +
							 "REPORT_TO, B.DEPT_CODE DCODE, B.DESCR DEPT, C.DESCR AS STAN_CD__HQ_DESCR, " +
							 "A.DESIGNATION AS DESIGNATION, A.DATE_JOIN AS DATE_JOIN " +
							 "FROM EMPLOYEE A, DEPARTMENT B , STATION C " +
							 "WHERE A.DEPT_CODE=B.DEPT_CODE AND " +
							 "A.STAN_CODE__HQ=C.STAN_CODE(+) AND " +
							 "EMP_CODE " +
							 " = ( SELECT  EMP_CODE  FROM USERS WHERE " +
							 "CODE='" + mUserID + "')";*/
				//Added by Pankaj T on 19-01-18 [changes for multitenancy]
				String empCode = "";
				String qry = "SELECT  EMP_CODE  FROM USERS WHERE CODE='" + mUserID + "'";
				try(PreparedStatement pstmt = usrsConnection.prepareStatement(qry);
					ResultSet resultSet = pstmt.executeQuery();)
				{
					if(resultSet.next())
					{
						empCode = resultSet.getString("EMP_CODE");
					}
				}
				catch (Exception e) 
				{
					e.printStackTrace();
				}
				//Added by Pankaj T on 19-01-18 [changes for multitenancy]
				/*mQuery = "SELECT EMP_CODE ENO , EMP_SITE,EMP_FNAME FNAME, EMP_MNAME MNAME,EMP_LNAME LNAME," + //$NON-NLS-1$
							 "REPORT_TO, B.DEPT_CODE DCODE, B.DESCR DEPT, C.DESCR AS STAN_CD__HQ_DESCR, " + //$NON-NLS-1$
							 "A.DESIGNATION AS DESIGNATION, A.DATE_JOIN AS DATE_JOIN " + //$NON-NLS-1$
							 "FROM EMPLOYEE A LEFT OUTER JOIN STATION C ON A.STAN_CODE__HQ=C.STAN_CODE, DEPARTMENT B  " + //$NON-NLS-1$
							 "WHERE A.DEPT_CODE=B.DEPT_CODE AND " +							 //$NON-NLS-1$
							 "EMP_CODE = '" +empCode +"'"; //$NON-NLS-1$
				 */
				
				//Added By Pankaj T. on 02-02-2023 changed sql to set data of employee if department or station not matched with employee - start 
				mQuery= "SELECT EMP_CODE ENO, EMP_SITE, EMP_FNAME FNAME, EMP_MNAME MNAME, EMP_LNAME LNAME," +
						"REPORT_TO, B.DEPT_CODE DCODE, B.DESCR DEPT, C.DESCR AS STAN_CD__HQ_DESCR, " +
						"A.DESIGNATION AS DESIGNATION, A.DATE_JOIN AS DATE_JOIN " +
						"FROM EMPLOYEE A " + 
						"LEFT OUTER JOIN STATION C ON A.STAN_CODE__HQ=C.STAN_CODE " +
						"LEFT OUTER JOIN DEPARTMENT B ON A.DEPT_CODE=B.DEPT_CODE " +
						"WHERE EMP_CODE ='" + empCode +"'";
				//Added By Pankaj T. on 02-02-2023 changed sql to set data of employee if department or station not matched with employee - end
				
				//			 " = ( SELECT  EMP_CODE  FROM USERS WHERE " + //$NON-NLS-1$
				//			 "CODE='" + mUserID + "')"; //$NON-NLS-1$ //$NON-NLS-2$
				//Swapnil on 01-JUL-2010 [WS90SUN043] ends
				//arr[5] = site;
				//Change by shrutika on 14-02-18 for getting fin_entity when login.
				//Change by shrutika on 10-12-18 for getting city when login.
				//mQuery2= "SELECT DESCR,FIN_ENTITY FROM SITE WHERE SITE_CODE='" + site + "'"; //$NON-NLS-1$ //$NON-NLS-2$
				//Changes made by Pratheek on 29-01-19[ to get the facility code from site table ]-Start
				//mQuery2= "SELECT DESCR,FIN_ENTITY,CITY FROM SITE WHERE SITE_CODE='" + site + "'"; //$NON-NLS-1$ //$NON-NLS-2$
				mQuery2= "SELECT DESCR,FIN_ENTITY,CITY,FACILITY_CODE FROM SITE WHERE SITE_CODE='" + site + "'";
				mStmt = mConnection.createStatement();
				mRs = mStmt.executeQuery(mQuery2);
				if(mRs.next())
				{
					arr[6] = mRs.getString("DESCR"); // SITE NAME //$NON-NLS-1$
					//BaseLogger.log("9",null,null,"Site Descr :["+arr[6]+"]");

					//Added by Shrutika on 14-02-18 [Start] for set fin_entity value when login.
					arr[24] = mRs.getString("FIN_ENTITY"); 
					BaseLogger.log("3",null,null,"Site FIN_ENTITY :["+arr[24]+"]");
					//Added by Shrutika on 14-02-18 [End] for set fin_entity value when login.
					//Added by Shrutika on 10-12-18 [Start] for set city value when login.
					arr[25] = mRs.getString("CITY");
					//Added by Shrutika on 10-12-18 [End] for set city value when login.
					//Changes made by Pratheek on 29-01-19[ to store the facility code value when login]-Start
					arr[26] = mRs.getString("FACILITY_CODE");
					//Changes made by Pratheek on 29-01-19[ to store the facility code value when login ]-End
				}
				mRs.close();
				mRs = null;
				mStmt.close();
				mStmt = null;
				mStmt = mConnection.createStatement();
				mRs = mStmt.executeQuery(mQuery);
				while (mRs.next())
				{
					arr[0] = mRs.getString("ENO"); //EMP_NO //$NON-NLS-1$
					//BaseLogger.log("9",null,null,"Emp No. :["+arr[0]+"]");
					
					//Changed by Gulzar/Rahul on 04/09/14 to replace the (.) with space( )  and checking the null :START
					//arr[1] = mRs.getString("FNAME") +"." + mRs.getString("MNAME") + "." + mRs.getString("LNAME"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$
					String fName = mRs.getString("FNAME");
					String mName = mRs.getString("MNAME");
					String lName = mRs.getString("LNAME");
					arr[1] = ((fName == null || fName.trim().length() == 0)?"": fName) + ((mName == null || mName.trim().length() == 0)?"": " " + mName) + ((lName == null || lName.trim().length() == 0)?"": " " + lName);
					//Changed by Gulzar/Rahul on 04/09/14 to replace the (.) with space( )  and checking the null :END

					//BaseLogger.log("9",null,null,"Emp Name :["+arr[1]+"]");
					arr[2] = mRs.getString("REPORT_TO");//REPORT //$NON-NLS-1$
					//BaseLogger.log("9",null,null,"Report To :[" + arr[2] + "]");
					arr[3]=mRs.getString("DCODE"); //DEPT_CODE //$NON-NLS-1$
					//BaseLogger.log("9",null,null,"Dept Code :[" + arr[3] + "]");
					arr[4]=mRs.getString("DEPT");  // DEPT NAME //$NON-NLS-1$
					//BaseLogger.log("9",null,null,"Dept Name :[" + arr[4] + "]");
					//Changed by Swapnil Shirke on 01-Jul-2010 [to add stan_code__hq, designation, dateOfJoining, division in userInfo][WS90SUN043] starts
					arr[14] = mRs.getString("STAN_CD__HQ_DESCR"); // HQ DESCRIPTION //$NON-NLS-1$
					//BaseLogger.log("9",null,null,"Dept Descr :["+arr[14]+"]");
					arr[15] = mRs.getString("DESIGNATION"); // DESIGNATION DESCRIPTION //$NON-NLS-1$
					//BaseLogger.log("9",null,null,"Designation :["+arr[15]+"]");
					//To convert the SQL server date to the System date format
					E12GenericUtility genericUtility = new E12GenericUtility();
					//Changed by Swapnil Shirke on 09-Oct-2010 [to remove null pointer]
					if((mRs.getString("DATE_JOIN") != null) && mRs.getString("DATE_JOIN").length() > 0) //$NON-NLS-1$ //$NON-NLS-2$
					{
						arr[16] = genericUtility.getValidDateString(mRs.getString("DATE_JOIN"), genericUtility.getDBDateFormat(), "dd-MMM-yyyy"); //$NON-NLS-1$ //$NON-NLS-2$
					}
					//arr[16] = mRs.getString("DATE_JOIN"); // DATE_JOIN DESCRIPTION
					//BaseLogger.log("9",null,null,"Date Of Join :["+arr[16]+"]");
					//Changed by Swapnil Shirke on 01-Jul-2010 [to add stan_code__hq, designation, dateOfJoining, division in userInfo][WS90SUN043] ends
				}
				mRs.close();
				mRs = null;
				if(arr[8].equalsIgnoreCase("P")) //$NON-NLS-1$
				{
					//Added by Pankaj T on 12-01-18 [changes for multitenancy]
					arr[11] = getItemSer(arr[9], transDB);
				//	BaseLogger.log("9",null,null,"Item Ser. :[" + arr[11] + "]");
					//Changed by Swapnil Shirke on 01-Jul-2010 [to add stan_code__hq, designation, dateOfJoining, division in userInfo][WS90SUN043] starts
					//Added by Pankaj T on 12-01-18 [changes for multitenancy]
					arr[17] = getDivision(arr[11], transDB);
					//BaseLogger.log("9",null,null,"Division :[" + arr[17] + "]");
					//Changed by Swapnil Shirke on 01-Jul-2010 [to add stan_code__hq, designation, dateOfJoining, division in userInfo][WS90SUN043] ends
				}
				//Changed By Rupali on 20/05/2008.[Remove the email column from the user table].Request ID:-[BI78SUN047].Start
				//Changed By Rupali on 27/03/2008.[To add the Email ID in UserInfo].Request ID:-[BI78SUN047].Start
				/*if( (arr[12]== null) || ((arr[12] != null) && (arr[12].trim()).length() == 0))
				{
					arr[12] = getEmailId(arr[8],mUserID);
				}
				else
				{
					BaseLogger.log("9",null,null,"Email Address taken from the USER table ");
				}*/
				//Changed By Rupali on 27/03/2008.[To add the Email ID in UserInfo].Request ID:-[BI78SUN047].End
				arr[12] = getEmailId(arr[8],mUserID, transDB);
				//Changed By Rupali on 20/05/2008.[Remove the email column from the user table].Request ID:-[BI78SUN047].End
				mStmt.close();
				mStmt = null;
			}
			else 
			{
				BaseLogger.log("3",null,null,"(CommonDBAccessEJB:getEmpInfo)UserID: NULL  or SiteCode: Doesn't Exist");  //$NON-NLS-1$
			}
		}
		catch(BaseException basee)
		{
			BaseLogger.log("0",null,null,"BaseException: CommonDBAccess: getEmpInfo: ==>EmployeeInformation: Not Returned(Generic Exception)\n"); //$NON-NLS-1$
			throw basee;
		}
		catch(SQLException sqlExp)
		{
   			BaseLogger.log("0",null,null,"Exception: CommonDBAccess: getEmpInfo: ==>EmployeeInformation: Not Returned(SQLException)\n" + sqlExp); //$NON-NLS-1$
			sqlExp.printStackTrace();
			throw new BaseException(sqlExp);	
		}	
		catch(Exception e)
		{
			BaseLogger.log("0",null,null,"Exception: CommonDBAccess: getEmpInfo: ==>EmployeeInformation: Not Returned(Generic Exception)\n" +e); //$NON-NLS-1$
			e.printStackTrace();
			throw new BaseException(e);
		}
		finally
		{
			try
			{
				if(mConnection != null)
				{
					if(mStmt != null)
					{
						mStmt.close();
						mStmt = null;
					}
					if(mRs != null){
						mRs.close();
						mRs = null;
					}
					mConnection.close();
					mConnection = null;
				}
				if(usrsConnection != null)
				{
					usrsConnection.close();
					usrsConnection = null;
				}
			}
			catch(SQLException sqlExp1)
			{ 
				BaseLogger.log("0",null,null,"Exception: CommonDBAccess: getEmpInfo: ==>EmployeeInformation: Not Returned(SQLException) F\n"+sqlExp1); //$NON-NLS-1$
				sqlExp1.printStackTrace();
				throw new BaseException(sqlExp1);	
			}
		}
		BaseLogger.log("2",null,null,"Employee Information: Returning........"); //$NON-NLS-1$
		return arr;
	}
	//Added by Pankaj T on 12-01-18 [changes for multitenancy]
	private String getItemSer(String entityCode, String transDB) throws RemoteException, BaseException
	{
		//BaseLogger.log("9",null,null,"Getting item series for entityCode :"+entityCode+":");
		String itemSer = ""; //$NON-NLS-1$
		ConnDriver connDriver = null;
		Connection conn = null;
		Statement stmt = null;
		ResultSet rs = null;
		String query = null;
			
		try
		{	
			connDriver = new ConnDriver();
			//Added by Pankaj T on 12-01-18 [changes for multitenancy]
			conn = connDriver.getConnectDB(transDB); //$NON-NLS-1$
			query = "SELECT ITEM_SER FROM SALES_PERS WHERE SALES_PERS = '"+entityCode+"'"; //$NON-NLS-1$ //$NON-NLS-2$
			stmt = conn.createStatement();
			BaseLogger.log("3",null,null,"[CommonDBAccessEJB]Getting division code, query :\n"+query); //$NON-NLS-1$
			rs = stmt.executeQuery(query);
			
			while(rs.next())
			{
				itemSer = rs.getString(1);
			}
			stmt.close();
			stmt = null;
		}
		catch (SQLException sqle)
		{ 
			BaseLogger.log("0",null,null,"SQLException :CommonDBAccessEJB :getItemSer :==>"); //$NON-NLS-1$
			sqle.printStackTrace();
			throw new ITMException(sqle);
		}
		catch (BaseException basee)
		{ 
			BaseLogger.log("0",null,null,"BaseException :CommonDBAccessEJB :getItemSer :==>"); //$NON-NLS-1$
			basee.printStackTrace();
			
		}
		catch (Exception e)
		{ 
			BaseLogger.log("0",null,null,"Exception :CommonDBAccessEJB :getItemSer :==>"+e); //$NON-NLS-1$
			e.printStackTrace();
			
		}
		finally
		{
			try
			{
				if(conn != null)
				{					
					if(stmt != null)
					{
						stmt.close();
					}
					conn.close();
					conn = null;
				}				
			}
			catch(Exception e)
			{
				BaseLogger.log("0",null,null,"Exception :CommonDBAccessEJB :getItemSer :==>"+e); //$NON-NLS-1$
				throw new BaseException(e);
			}
		}
		//BaseLogger.log("9",null,null,"[CommonDBAccessEJB]ItemSer :"+itemSer);
		return itemSer;
	}
	private String getEmailId(String userType , String userID, String transDB) throws RemoteException, BaseException
	{
		//BaseLogger.log("9",null,null,"Getting User Type for userType :"+userType+": userID :-["+userID+"]");
		String emailId = ""; //$NON-NLS-1$
		String tableName = ""; //$NON-NLS-1$
		String selectColName = ""; //$NON-NLS-1$
		String whereColName = ""; //$NON-NLS-1$
		ConnDriver connDriver = null;
		Connection conn = null;
		Statement stmt = null;
		ResultSet rs = null;
		String query = null;
			
		try
		{	
			if(userType.equalsIgnoreCase("P")) //$NON-NLS-1$
			{
				tableName = "sales_pers"; //$NON-NLS-1$
				selectColName = "email_addr"; //$NON-NLS-1$
				whereColName = "sales_pers"; //$NON-NLS-1$
				
			}
			//Changed by Pooja S on 21-August-2019 [To show the Developer Console option only to the userType of D(Developer) ]
			else if(userType.equalsIgnoreCase("E") || userType.equalsIgnoreCase("D")) //$NON-NLS-1$
			{
				tableName ="employee"; //$NON-NLS-1$
				selectColName = "email_id_off"; //$NON-NLS-1$
				whereColName = "emp_code"; //$NON-NLS-1$
			}
			
			else if(userType.equalsIgnoreCase("S")) //$NON-NLS-1$
			{
				tableName = "supplier"; //$NON-NLS-1$
				selectColName = "email_addr"; //$NON-NLS-1$
				whereColName = "supp_code"; //$NON-NLS-1$
			}
			else if(userType.equalsIgnoreCase("C")) //$NON-NLS-1$
			{
				tableName = "customer"; //$NON-NLS-1$
				selectColName = "email_addr"; //$NON-NLS-1$
				whereColName = "cust_code"; //$NON-NLS-1$
			}
			else
			{
				tableName = ""; //$NON-NLS-1$
				selectColName = ""; //$NON-NLS-1$
				whereColName = ""; //$NON-NLS-1$
			}
			connDriver = new ConnDriver();
			//Added by Pankaj T on 19-01-18 [changes for multitenancy]
			String entityCode = "";
			try (Connection usersConn = connDriver.getConnectDB("Driver");)
			{
				String qry = "SELECT  ENTITY_CODE  FROM USERS WHERE CODE='" + userID + "'";
				try(PreparedStatement pstmt = usersConn.prepareStatement(qry);
					ResultSet resultSet = pstmt.executeQuery();)
				{
					if(resultSet.next())
					{
						entityCode = resultSet.getString("ENTITY_CODE");
					}
				}
			}
			catch (Exception e) 
			{
				e.printStackTrace();
			}
			//Added by Pankaj T on 19-01-18 [changes for multitenancy]
			conn = connDriver.getConnectDB(transDB); //$NON-NLS-1$
			//query = "SELECT "+selectColName+" FROM "+ tableName +" WHERE "+whereColName+" = ( SELECT  ENTITY_CODE  FROM USERS WHERE CODE='" + userID + "')"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$
			query = "SELECT "+selectColName+" FROM "+ tableName +" WHERE "+whereColName+" = '"+entityCode+"'";
			stmt = conn.createStatement();
			//BaseLogger.log("9",null,null,"[CommonDBAccessEJB]Getting Email ID code, query :\n"+query);
			rs = stmt.executeQuery(query);
			while(rs.next())
			{
				emailId = rs.getString(1);
			}
			rs.close();
			rs = null;
			stmt.close();
			stmt = null;
		}
		catch (SQLException sqle)
		{ 
			BaseLogger.log("0",null,null,"SQLException :CommonDBAccessEJB :getEmailID :==>"); //$NON-NLS-1$
			sqle.printStackTrace();
			throw new ITMException(sqle);
		}
		catch (BaseException basee)
		{ 
			BaseLogger.log("0",null,null,"BaseException :CommonDBAccessEJB :getEmailID :==>"); //$NON-NLS-1$
		}
		catch (Exception e)
		{ 
			BaseLogger.log("0",null,null,"Exception :CommonDBAccessEJB :getEmailID :==>"+e); //$NON-NLS-1$
		}
		finally
		{
			try
			{
				if(rs != null){
					rs.close();
					rs = null;
				}
				if(conn != null)
				{					
					if(stmt != null)
					{
						stmt.close();
					}
					conn.close();
					conn = null;
				}				
			}
			catch(Exception e)
			{
				//BaseLogger.log("9",null,null,"Exception :CommonDBAccessEJB :Emailid :==>"+e);
				throw new BaseException(e);
			}
		}
		//BaseLogger.log("9",null,null,"[CommonDBAccessEJB]EmailID :"+emailId);
		return emailId;
	}
	//Changed by Rupali on 21/08/2008 to generate the menu tree for RIA.Request ID[BI89BAS010].Start
	public String getUserXMLTree(String userCode, String profileID) throws RemoteException,BaseException
	{		
		BaseLogger.log("2",null,null,"inside deprecated userxml tree");
		StringBuffer mXML = new StringBuffer("<APPLICATION>"); //$NON-NLS-1$
		Connection conn = null;
		Statement statOption = null;
		ResultSet rsOption = null;
		Statement statFolder = null;
		ResultSet rsFolder = null;
		try{
			String currLev2Descr = "";
			String currLev3Descr = "";
			String currLev4Descr = "";
			String currLev5Descr = "";
			String prevLev2Descr = "",prevLev3Descr = "",prevLev4Descr = "",prevLev5Descr = ""; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
			String iconPath = ""; //$NON-NLS-1$
			String currIconPath = ""; //$NON-NLS-1$
			String currMenuPath =""; //$NON-NLS-1$
			String objType = ""; //$NON-NLS-1$
			String appDescr,mpath,appln,level1,level2,level3,level4,level5;
			String path,path1,path2,qry,winName;
			boolean levelFlag2 = false;
			boolean levelFlag3 = false;
			boolean levelFlag4 = false;
			boolean levelFlag5 = false;
			String appName ="SFA"; //$NON-NLS-1$
			//Added By Ajinkya Gopalkar on 3-DEC-15 [for configuring fullscreen mode by DEFAULT_STATE column ]
			String defaultState = "0";
			
			//Commented By Prajyot On 21-JAN-2012 [As per Danish Sir] 
//			mXML.append("<OPTION id='DASH.0.1.0.0.0' icon='e12_logo'>"); //$NON-NLS-1$
//			mXML.append("<TITLE><![CDATA["+"My Dashboard"+"]]></TITLE>"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
//			mXML.append("<OBJNAME><![CDATA[dashboard]]></OBJNAME>"); //$NON-NLS-1$
//			mXML.append("<OBJTYPE>D</OBJTYPE>"); //$NON-NLS-1$
//			mXML.append("</OPTION>"); //$NON-NLS-1$
			//Commented By Prajyot On 21-JAN-2012 [As per Danish Sir]
			
			HashMap<String, String> menuMap = new HashMap<String, String>();
			
			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("Driver"); //$NON-NLS-1$
			String usrLevQry = "SELECT USR_LEV FROM USERS WHERE CODE ='" + userCode + "'"; //$NON-NLS-1$ //$NON-NLS-2$
			statOption = conn.createStatement();
			rsOption = statOption.executeQuery(usrLevQry);
			int level = 0;
			if(rsOption.next()){
				level = rsOption.getInt("USR_LEV"); //$NON-NLS-1$
			}
			statOption.close();
			statOption = null;
			String menuQry = null;
			//Change by shrutika on 02-03-2020 for If change site then menu display according to the user level,so that some menu not display after change site issue for userLevel 1
			//Chnaged By Pankaj T. on 05-03-2020 Changes reverted As suggested By SM Sir to get the profile_id from user_site table and if not found then get from users table
			if( level >= 1 ){
			//if( level > 1 ){
				menuQry="SELECT B.APPLICATION APP,B.WIN_NAME, B.MENU_PATH MPATH,B.DESCR,B.ICON_PATH,B.OBJ_TYPE,B.DEFAULT_STATE " +   //$NON-NLS-1$
						"FROM USER_RIGHTS A, ITM2MENU B " +  //$NON-NLS-1$
						//Changed by Sagar B. for multiple profile id related changes[11-Dec-17]
						//"WHERE A.PROFILE_ID ='"+profileID+"' "+ //$NON-NLS-1$ //$NON-NLS-2$
						"WHERE A.PROFILE_ID IN "+ E12GenericUtility.getFormattedProfileId(profileID) +" "+ //$NON-NLS-1$ //$NON-NLS-2$
						"AND A.APPLICATION='"+appName+"' AND A.APPLICATION=B.APPLICATION AND A.MENU_ROW=B.LEVEL_1 "+  //$NON-NLS-1$ //$NON-NLS-2$
						"AND A.MENU_COL=B.LEVEL_2 AND A.MENU_SUBCOL=B.LEVEL_3 " + //$NON-NLS-1$
						"AND A.LEVEL_4=B.LEVEL_4 AND A.LEVEL_5=B.LEVEL_5 "+  //$NON-NLS-1$
						"ORDER BY A.APPLICATION,A.MENU_ROW,A.MENU_COL,A.MENU_SUBCOL,A.LEVEL_4,A.LEVEL_5 "; //$NON-NLS-1$
			}
			else{
				menuQry = "SELECT APPLICATION APP,WIN_NAME,MENU_PATH MPATH,DESCR,ICON_PATH,OBJ_TYPE,DEFAULT_STATE FROM ITM2MENU WHERE WIN_NAME NOT IN ('-') AND APPLICATION = '"+appName+"' ORDER BY APPLICATION,LEVEL_1,LEVEL_2,LEVEL_3,LEVEL_4,LEVEL_5"; //$NON-NLS-1$ //$NON-NLS-2$
			}
			//BaseLogger.log("9",null,null,"getUserXMLTree : menu query :-["+menuQry+"]");
			statOption = conn.createStatement();
			rsOption = statOption.executeQuery(menuQry);
			while (rsOption.next()){
				appln = rsOption.getString("APP"); //$NON-NLS-1$
				winName = rsOption.getString("WIN_NAME"); //$NON-NLS-1$
				mpath = rsOption.getString("MPATH"); //$NON-NLS-1$
				//Added By Ajinkya Gopalkar on 3-DEC-15 [for configuring fullscreen mode by DEFAULT_STATE column ]
				defaultState = rsOption.getString("DEFAULT_STATE");
				int levelCnt = 1;
				BaseLogger.log("3",null,null,"-------------------------------------------:"+mpath); //$NON-NLS-1$
				if(mpath != null)
				{
					//Added by Sagar B. for multiple profile id related changes[07Dec17]START 
					if( winName != null )
					{
						if(menuMap != null && !menuMap.isEmpty() && menuMap.size() > 0 && menuMap.containsKey(mpath) )
						{
							if(((String)menuMap.get(mpath)).equalsIgnoreCase(winName))
							{
								continue;
							}
						}
						menuMap.put(mpath, winName);
					}
					//Added by Sagar B. for multiple profile id related changes[07Dec17]END
					path = mpath.substring( mpath.indexOf( '.' ) + 1 );
					path1 = path.substring( path.indexOf( '.' )+1, path.lastIndexOf( '.' )  );
					path2 = path1.substring(path1.indexOf('.'));
					level1 = path.substring(0,path.indexOf('.'));
					level2 = path1.substring(0,path1.indexOf('.'));
					level3 = path2.substring(path2.indexOf('.')+1,path2.lastIndexOf('.')  );
					level4 = path1.substring(path1.lastIndexOf('.')+1  );
					level5 = mpath.substring(mpath.lastIndexOf('.')+1  );
					appDescr = rsOption.getString("DESCR"); //$NON-NLS-1$
					iconPath = rsOption.getString("ICON_PATH"); //$NON-NLS-1$
					objType = rsOption.getString("OBJ_TYPE"); //$NON-NLS-1$
					if (!(level2.equals("0"))){ //$NON-NLS-1$
						levelCnt =levelCnt + 1;
						//if level 2 is defined then generates the child of level 1
						qry="SELECT DESCR,ICON_PATH,MENU_PATH FROM ITM2MENU WHERE APPLICATION='" + appln + "'" +  //$NON-NLS-1$ //$NON-NLS-2$
							"AND LEVEL_1= " + level1 + " AND LEVEL_2=0 AND LEVEL_3 = 0 AND LEVEL_4=0 AND LEVEL_5=0"; //$NON-NLS-1$ //$NON-NLS-2$
						statFolder = conn.createStatement();
						rsFolder = statFolder.executeQuery(qry);
						if(rsFolder.next()){
							currLev2Descr = E12GenericUtility.checkNull(rsFolder.getString("DESCR")); //$NON-NLS-1$
							currIconPath = rsFolder.getString("ICON_PATH"); //$NON-NLS-1$
							currMenuPath = rsFolder.getString("MENU_PATH"); //$NON-NLS-1$
						}
						//added By Nilesh For ressolving open cursor issue Start:01-06-2017
						if(rsFolder!=null)
						{
							rsFolder.close();
							rsFolder=null;
						}
						//added By Nilesh For ressolving open cursor issue End:01-06-2017
						if (!((prevLev2Descr.equals(currLev2Descr)))){
							if(levelFlag2){
								mXML.append("</FOLDER>"); //$NON-NLS-1$
								levelFlag2 = false;
							}
							if(levelFlag3){
								mXML.append("</FOLDER>"); //$NON-NLS-1$
								levelFlag3 = false;
							}
							if(levelFlag4){
								mXML.append("</FOLDER>"); //$NON-NLS-1$
								levelFlag4 = false;
							}
							if(levelFlag5){
								mXML.append("</FOLDER>"); //$NON-NLS-1$
								levelFlag5 = false;
							}
							prevLev2Descr=currLev2Descr;
							prevLev3Descr="";//Changed by Pramod on 27-01-11[WI90SUN008 || Improper tree gets generated for certain cases.] //$NON-NLS-1$
							mXML.append(addFolder(currMenuPath,currIconPath,currLev2Descr));
							levelFlag2 = true;
						}
						//added By Nilesh For ressolving open cursor issue Start:01-06-2017
						if(statFolder != null)
						{
							statFolder.close();
							statFolder = null;
						}
					}
					if (!(level3.equals("0"))){ //$NON-NLS-1$
						levelCnt =levelCnt + 1;
						qry="SELECT DESCR,ICON_PATH,MENU_PATH FROM ITM2MENU WHERE APPLICATION='" + appln + "'" +  //$NON-NLS-1$ //$NON-NLS-2$
							"AND LEVEL_1= " + level1+ " AND LEVEL_2= " + level2 + " AND LEVEL_3 = 0 AND LEVEL_4=0 AND LEVEL_5=0"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
						statFolder = conn.createStatement();
						rsFolder = statFolder.executeQuery(qry);
						if(rsFolder.next()){
							currLev3Descr = E12GenericUtility.checkNull(rsFolder.getString("DESCR")); //$NON-NLS-1$
							currIconPath = rsFolder.getString("ICON_PATH"); //$NON-NLS-1$
							currMenuPath = rsFolder.getString("MENU_PATH"); //$NON-NLS-1$
						}
						//added By Nilesh For ressolving open cursor issue Start:01-06-2017
						if(rsFolder!=null)
						{
							rsFolder.close();
							rsFolder=null;
						}
						//added By Nilesh For ressolving open cursor issue End:01-06-2017
						if (!((prevLev3Descr.equals(currLev3Descr)))){
							if(levelFlag4){
								mXML.append("</FOLDER>"); //$NON-NLS-1$
								levelFlag4 = false;
							}
							if(levelFlag3){
								mXML.append("</FOLDER>"); //$NON-NLS-1$
								levelFlag3 = false;
							}
							if(levelFlag5){
								mXML.append("</FOLDER>"); //$NON-NLS-1$
								levelFlag5 = false;
							}
							prevLev3Descr=currLev3Descr;
							prevLev4Descr="";//Changed by Pramod on 27-01-11[WI90SUN008 || Improper tree gets generated for certain cases.] //$NON-NLS-1$
							mXML.append(addFolder(currMenuPath,currIconPath,currLev3Descr));
							levelFlag3 = true;
						}
						//added By Nilesh For ressolving open cursor issue Start:01-06-2017
						if(statFolder != null)
						{
							statFolder.close();
							statFolder = null;
						}
					}//level3	
					if (!(level4.equals("0"))){ //$NON-NLS-1$
						levelCnt =levelCnt + 1;
						qry="SELECT DESCR,ICON_PATH,MENU_PATH  FROM ITM2MENU WHERE APPLICATION='" + appln + "'" +  //$NON-NLS-1$ //$NON-NLS-2$
							" AND LEVEL_1= " + level1 + " AND LEVEL_2="+ level2 +  //$NON-NLS-1$ //$NON-NLS-2$
							" AND LEVEL_3 = "+ level3 + " AND LEVEL_4=0 AND LEVEL_5=0"; //$NON-NLS-1$ //$NON-NLS-2$
					
						statFolder = conn.createStatement();
						rsFolder = statFolder.executeQuery(qry);
						if(rsFolder.next()){
							currLev4Descr = E12GenericUtility.checkNull(rsFolder.getString("DESCR")); //$NON-NLS-1$
							currIconPath =rsFolder.getString("ICON_PATH");	 //$NON-NLS-1$
							currMenuPath = rsFolder.getString("MENU_PATH"); //$NON-NLS-1$
						}
						//added By Nilesh For ressolving open cursor issue Start:01-06-2017
						if(rsFolder!=null)
						{
							rsFolder.close();
							rsFolder=null;
						}
						//added By Nilesh For ressolving open cursor issue End:01-06-2017
						
						if (!((prevLev4Descr.equals(currLev4Descr)))){
							if(levelFlag4){
								mXML.append("</FOLDER>"); //$NON-NLS-1$
								levelFlag4 = false;
							}
							if(levelFlag5){
								mXML.append("</FOLDER>"); //$NON-NLS-1$
								levelFlag5 = false;
							}
							prevLev4Descr = currLev4Descr;
							prevLev5Descr="";//Changed by Pramod on 27-01-11[WI90SUN008 || Improper tree gets generated for certain cases.] //$NON-NLS-1$
							mXML.append(addFolder(currMenuPath,currIconPath,currLev4Descr));
							levelFlag4 = true;
						}
						//added By Nilesh For ressolving open cursor issue Start:01-06-2017
						if(statFolder != null)
						{
							statFolder.close();
							statFolder = null;
						}
					}//level4
					if (!(level5.equals("0"))){ //$NON-NLS-1$
						levelCnt =levelCnt + 1;
						qry="SELECT DESCR,ICON_PATH,MENU_PATH  FROM ITM2MENU WHERE APPLICATION='" + appln + "'" +  //$NON-NLS-1$ //$NON-NLS-2$
							" AND LEVEL_1= " + level1 + " AND LEVEL_2="+ level2 +  //$NON-NLS-1$ //$NON-NLS-2$
							" AND LEVEL_3 = "+ level3 + " AND LEVEL_4=" + level4 + " AND LEVEL_5=0"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
						statFolder = conn.createStatement();
						rsFolder = statFolder.executeQuery(qry);
						if(rsFolder.next()){
							currLev5Descr = E12GenericUtility.checkNull(rsFolder.getString("DESCR")); //$NON-NLS-1$
							currIconPath =rsFolder.getString("ICON_PATH"); //$NON-NLS-1$
							currMenuPath = rsFolder.getString("MENU_PATH"); //$NON-NLS-1$
						}
						if (!((prevLev5Descr.equals(currLev5Descr)))){
							if(levelFlag5){
								mXML.append("</FOLDER>"); //$NON-NLS-1$
								levelFlag5 = false;
							}
							prevLev5Descr=currLev5Descr;
							mXML.append(addFolder(currMenuPath,currIconPath,currLev5Descr));
							levelFlag5 = true;
						}
						statFolder.close();
						statFolder = null;
					}//level5
				//	BaseLogger.log("9",null,null,"Level Cnt: - ["+levelCnt+"]");
					if(levelCnt == 4){
						if(levelFlag5){
							mXML.append("</FOLDER>"); //$NON-NLS-1$
							levelFlag5 = false;
						}
					}
					if(levelCnt == 3){
						if(levelFlag5){
							mXML.append("</FOLDER>"); //$NON-NLS-1$
							levelFlag5 = false;
						}
						if(levelFlag4){
							mXML.append("</FOLDER>"); //$NON-NLS-1$
							levelFlag4 = false;
						}
					}
					if(levelCnt == 2){
						if(levelFlag5){
							mXML.append("</FOLDER>"); //$NON-NLS-1$
							levelFlag5 = false;
						}
						if(levelFlag4){
							mXML.append("</FOLDER>"); //$NON-NLS-1$
							levelFlag4 = false;
						}
						if(levelFlag3){
							mXML.append("</FOLDER>"); //$NON-NLS-1$
							levelFlag3 = false;
						}
					}
					String tempWinName=winName;
					if(winName !=null){
						if(winName.indexOf("w_")!=-1 ){ //$NON-NLS-1$
							tempWinName = winName.substring(2);
						}
						
						if(winName.indexOf("&amp;") != -1){ //$NON-NLS-1$
							tempWinName = winName.replaceAll("&amp;","&"); //$NON-NLS-1$ //$NON-NLS-2$
						}
					}
					else{
						tempWinName = ""; //$NON-NLS-1$
					}
					if(iconPath != null ){
						if(iconPath.indexOf(".") !=-1){ //$NON-NLS-1$
						iconPath = iconPath.substring(0,iconPath.indexOf(".")); //$NON-NLS-1$
						}
					}
					else{
						iconPath = ""; //$NON-NLS-1$
					}
					mXML.append("<OPTION id='"+mpath+"' icon='"+iconPath+"'>"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
					mXML.append("<TITLE>"); //$NON-NLS-1$
					mXML.append("<![CDATA["+appDescr+"]]>"); //$NON-NLS-1$ //$NON-NLS-2$
					mXML.append("</TITLE>"); //$NON-NLS-1$
					mXML.append("<OBJNAME>"); //$NON-NLS-1$
					mXML.append("<![CDATA["+tempWinName+"]]>"); //$NON-NLS-1$ //$NON-NLS-2$
					mXML.append("</OBJNAME>"); //$NON-NLS-1$
					mXML.append("<OBJTYPE>"); //$NON-NLS-1$
					mXML.append(objType);
					mXML.append("</OBJTYPE>"); //$NON-NLS-1$
					mXML.append("<DEFAULT_STATE>");
					mXML.append(defaultState);
					mXML.append("</DEFAULT_STATE>");
					mXML.append("</OPTION>"); //$NON-NLS-1$
				
				}//if(mpath != null)
			}//rs
			if(levelFlag2){
				mXML.append("</FOLDER>"); //$NON-NLS-1$
				levelFlag2 = false;
			}
			if(levelFlag3){
				mXML.append("</FOLDER>"); //$NON-NLS-1$
				levelFlag3 = false;
			}
			if(levelFlag4){
				mXML.append("</FOLDER>"); //$NON-NLS-1$
				levelFlag4 = false;
			}
			mXML.append("</APPLICATION>");					 //$NON-NLS-1$
			statOption.close();
			statOption = null;
			BaseLogger.log("3",null,null,"(DBAccessEJB:getUserXML)UserXML: Built"); //$NON-NLS-1$
			
		}
		catch (BaseException basee){ 
			BaseLogger.log("0",null,null,"BaseException: DBAccess: getUserXMLTree: ==>UserXML: Not Built(Generic Exception)\n"); //$NON-NLS-1$
			throw basee;
		}
		catch(SQLException sqle){
			BaseLogger.log("0",null,null,"SQLException: DBAccess: getUserXMLTree: ==>UserXML: Not Built(SQLException)\n" + sqle); //$NON-NLS-1$
			sqle.printStackTrace();
			throw new BaseException(sqle);
		}
		catch (Exception e){ 
			BaseLogger.log("0",null,null,"Exception: DBAccess: getUserXMLTree: ==>UserXML: Not Built(Generic Exception)\n" + e); //$NON-NLS-1$
			throw new BaseException(e);
		}
		finally{
			try{
				if(conn != null){
					if(statOption != null)statOption.close();
					if(rsFolder != null)rsFolder.close();
					conn.close();
					conn = null;
				}
			}
			catch(Exception e){
				BaseLogger.log("0",null,null,"Exception: DBAccess: getUserXMLTree ==>UserXML: Not Built F\n" + e); //$NON-NLS-1$
				throw new BaseException(e);
			}
		}
		return mXML.toString();
	}
	
	//Overloaded method is added by Gulzar on 10/10/13 added userInfo parameter for multidb connection : START
	public String getUserXMLTree(String userCode, String profileID , String applName, boolean isMobile, UserInfoBean userInfo ) throws RemoteException,BaseException
	{		
		BaseLogger.log("2",userInfo,null,"3872 inside getUserXMLTree:: applName is: " + applName+" isMobile "+isMobile);
		
		//Changes By Prajyot[Issue of menu Tree Generation ] On 20MAR13
		//StringBuffer mXML = new StringBuffer("<APPLICATION>"); //$NON-NLS-1$
		StringBuffer mXMLTree = new StringBuffer(""); //$NON-NLS-1$
		
		Connection conn = null;
		Connection con1 = null;
		Statement statOption = null;
		ResultSet rsOption = null;
		Statement statFolder = null;
		ResultSet rsFolder = null;
		try
		{
			//Added By Suraj [For restrict menu]
			checkConditionDetails( userInfo );
			String currLev2Descr = "";
			String currLev3Descr = "";
			String currLev4Descr = "";
			String currLev5Descr = "";
			String prevLev2Descr = "",prevLev3Descr = "",prevLev4Descr = "",prevLev5Descr = ""; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
			String iconPath = ""; //$NON-NLS-1$
			String currIconPath = ""; //$NON-NLS-1$
			String currMenuPath =""; //$NON-NLS-1$
			String objType = ""; //$NON-NLS-1$
			String appDescr,mpath,appln,level1,level2,level3,level4,level5;
			String path,path1,path2,qry,winName;
			boolean levelFlag2 = false;
			boolean levelFlag3 = false;
			boolean levelFlag4 = false;
			boolean levelFlag5 = false;
			String appName = applName; //$NON-NLS-1$
			String tranDB = userInfo.getTransDB();
			//Added By Ajinkya Gopalkar on 3-DEC-15 [for configuring fullscreen mode by DEFAULT_STATE column ]
			String defaultState = "0";
			//Added By Sandesh Shinde on 10-AUG-16 [For default action for menu]
			String defaultAction = "";
			//Added by Pratheek on 11-06-18[to show menu based on ent_types column values of itm2menu and Enterprise table]-Start
			String entTypes ="";
			String tableName = "ENTERPRISE";
			String columnName = "ENT_TYPE";
			//Changes made by Pratheek on 26-06-18[to trim the data to check the condition properly]-Start
			String	condition = "WHERE ENTERPRISE='"+E12GenericUtility.checkNull(userInfo.getEnterprise())+"'";
			//Changes made by Pratheek on 26-06-18[to trim the data to check the condition properly]-End
			String enterpriseType = E12GenericUtility.checkNull( getDBColumnValue(tableName, columnName, condition, tranDB) );
			BaseLogger.log("3",userInfo,null,"enterpriseEntType 4007!!!!!!["+enterpriseType+"]");
			//Added by Pratheek on 11-06-18[to show menu based on ent_types column values of itm2menu and Enterprise table]-End
			
			//Added by Pankaj P on 29/03/2021 [DEVICE_ACC_CLASS related implementation, user device wise menu definition] START
			HashMap<String, String> userDeviceDtlMap = getUserDeviceDetails( userInfo );
			String userRightsDeviceAccClass = "";
			//Added by Pankaj P on 29/03/2021 [DEVICE_ACC_CLASS related implementation, user device wise menu definition] END
			
			//Commented By Prajyot On 21-JAN-2012 [As per Danish Sir] Starts
//				mXML.append("<OPTION id='DASH.0.1.0.0.0' icon='e12_logo'>"); //$NON-NLS-1$
//				mXML.append("<TITLE><![CDATA["+"My Dashboard"+"]]></TITLE>"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
//				mXML.append("<OBJNAME><![CDATA[dashboard]]></OBJNAME>"); //$NON-NLS-1$
//				mXML.append("<OBJTYPE>D</OBJTYPE>"); //$NON-NLS-1$
//				mXML.append("</OPTION>"); //$NON-NLS-1$
			//Commented By Prajyot On 21-JAN-2012 [As per Danish Sir] Ends
			
			HashMap<String, String> menuMap = new HashMap<String, String>();
			
			//Added by saiprasad on 15-03-19 to draw and rights based on rights in user_adhc_right table [START]
			HashMap<String,String> overrideRightsMap = new HashMap<>();
			//Added by saiprasad on 15-03-19 to draw and rights based on rights in user_adhc_right table[END]
			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB(tranDB); //$NON-NLS-1$
			String usrLevQry = "SELECT USR_LEV FROM USERS WHERE CODE ='" + userCode + "'"; //$NON-NLS-1$ //$NON-NLS-2$
			statOption = conn.createStatement();
			rsOption = statOption.executeQuery(usrLevQry);
			int level = 0;
			if(rsOption.next()){
				level = rsOption.getInt("USR_LEV"); //$NON-NLS-1$
			}
			statOption.close();
			statOption = null;
			rsOption.close();
			rsOption = null;
			//ConnDriver tranConnDriver = new ConnDriver();
			con1 = connDriver.getConnectDB(tranDB); //$NON-NLS-1$
			BaseLogger.log("3",userInfo,null,"tranDB Name : " + tranDB);
			BaseLogger.log("3",userInfo,null,"profileID:["+profileID+"]");
			BaseLogger.log("3",userInfo,null,"applName Name : " + applName);
			BaseLogger.log("3",userInfo,null,"isMobile : " + isMobile);
			BaseLogger.log("3",userInfo,null,"level : " + level);
			String menuQry = null;			
			if ( applName != null && applName.length() > 0)
			{
				appName = applName;
			}
			//Added By Pankaj T. on 18-04-18 for profileID wise menu caching - start
			BaseLogger.log("3",userInfo,null,"CACHE_OPT in getUserXMLTree:["+CommonConstants.CACHE_OPT+"]");
			InfinispanLogger.log("3",userInfo,null,"CACHE_OPT in getUserXMLTree:["+CommonConstants.CACHE_OPT+"]");
			if( CommonConstants.CACHE_OPT != 0 )
			{
				profileID = E12GenericUtility.checkNull(profileID);
				String[] profileIDArr = profileID.split(",");
				BaseLogger.log("3",userInfo,null,"profileIdArr.length:["+profileIDArr.length+"]");
				for( int i = 0; i < profileIDArr.length; i++ )
				{
					InfinispanLogger.log("2", userInfo, null,"In CommonDBAccessEJB.getUserXMLTree() userid     : ["+userInfo.getLoginCode()+"]");
					InfinispanLogger.log("2", userInfo, null,"In CommonDBAccessEJB.getUserXMLTree() profileid  : ["+profileIDArr[i]+"]");
					InfinispanLogger.log("2", userInfo, null,"In CommonDBAccessEJB.getUserXMLTree() transdb    : ["+userInfo.getTransDB()+"]");
					InfinispanLogger.log("2", userInfo, null,"In CommonDBAccessEJB.getUserXMLTree() enterprise : ["+userInfo.getEnterprise()+"]");
					InfinispanLogger.log("2", userInfo, null,"In CommonDBAccessEJB.getUserXMLTree() appname    : ["+appName+"]");
					InfinispanLogger.log("2", userInfo, null,"In CommonDBAccessEJB.getUserXMLTree() isMobile   : ["+isMobile+"]");
					InfinispanLogger.log("2", userInfo, null,"In CommonDBAccessEJB.getUserXMLTree() userlevel  : ["+level+"]");
					StringBuffer mXML = new StringBuffer("");
					String profileIDStorageKey = E12GenericUtility.checkNull(userInfo.getEnterprise())+"_"+profileIDArr[i]+"_"+appName+"_"+isMobile+"_"+level+"_"+userInfo.getTransDB();
					BaseLogger.log("3",userInfo,null,"profileIDStorageKey:["+profileIDStorageKey+"]");
					//Changed by Prasad on 23/11/2020 [check infinispanLocalObj not null]
					if( infinispanLocalObj != null && infinispanLocalObj.contains( profileIDStorageKey) && E12GenericUtility.checkNull(infinispanLocalObj.getFormData(profileIDStorageKey)).length() > 0 )
					{
						mXML.append(infinispanLocalObj.getFormData(profileIDStorageKey));
						mXMLTree.append(mXML.toString());
					}
					else
					{
						//Change by shrutika on 19-02-2020 for If change site then menu display according to the user level,so that some menu not display after change site issue for userLevel 1
						//Chnaged By Pankaj T. on 05-03-2020 Changes reverted As suggested By SM Sir to get the profile_id from user_site table and if not found then get from users table
						if( level >= 1 ){
						//if( level > 1 ){
							//Modified By Sandesh Shinde on 10-AUG-16 [For default action for menu]
							//Changes made by Pratheek on 12-06-18[to get the ent_type column value from itm2menu]-Start
//							menuQry="SELECT B.APPLICATION APP,B.WIN_NAME, B.MENU_PATH MPATH,B.DESCR,B.ICON_PATH,B.OBJ_TYPE,B.DEFAULT_STATE,B.DEF_ACTION " +   //$NON-NLS-1$
							menuQry = "SELECT B.APPLICATION APP,B.WIN_NAME, B.MENU_PATH MPATH,B.DESCR,B.ICON_PATH,B.OBJ_TYPE,B.DEFAULT_STATE,B.DEF_ACTION,B.ENT_TYPES, A.DEVICE_ACC_CLASS " +   //$NON-NLS-1$
									"FROM USER_RIGHTS A, ITM2MENU B " +  //$NON-NLS-1$
									//Changed by Sagar B. for multiple profile id related changes[11-Dec-17]
									//"WHERE A.PROFILE_ID ='"+profileID+"' "+ //$NON-NLS-1$ //$NON-NLS-2$
									//"WHERE A.PROFILE_ID IN "+ E12GenericUtility.getFormattedProfileId(profileID) +" "+ //$NON-NLS-1$ //$NON-NLS-2$
									"WHERE A.PROFILE_ID IN ('"+ profileIDArr[i] +"') "+ //$NON-NLS-1$ //$NON-NLS-2$
									"AND A.APPLICATION='"+appName+"' AND A.APPLICATION=B.APPLICATION AND A.MENU_ROW=B.LEVEL_1 "+  //$NON-NLS-1$ //$NON-NLS-2$
									"AND A.MENU_COL=B.LEVEL_2 AND A.MENU_SUBCOL=B.LEVEL_3 " + //$NON-NLS-1$
									"AND A.LEVEL_4=B.LEVEL_4 AND A.LEVEL_5=B.LEVEL_5 "+  //$NON-NLS-1$
									//""+(isMobile == true ? " AND B.MOB_DEPLOY = 'Y' " : " ")+   //Add by Dnyaneshwar on 6-Feb-2013 [ Add condition ] Start
									""+ (isMobile == true ? " AND ( B.MOB_DEPLOY = 'Y' OR B.MOB_DEPLOY = 'B' )" : "  AND ( B.MOB_DEPLOY != 'Y' OR B.MOB_DEPLOY is null ) ") + //Added by Nilesh Soor on 21-Aug-14 [ Mobile Specific Menus Should Not Get Displayed In Browser. ]
									"ORDER BY A.APPLICATION,A.MENU_ROW,A.MENU_COL,A.MENU_SUBCOL,A.LEVEL_4,A.LEVEL_5 "; //$NON-NLS-1$
						}
						else{
							//Modified By Sandesh Shinde on 10-AUG-16 [For default action for menu]
							//Changes made by Pratheek on 12-06-18[to get the ent_type column value from itm2menu]-Start
//							menuQry =	"SELECT APPLICATION APP,WIN_NAME,MENU_PATH MPATH,DESCR,ICON_PATH,OBJ_TYPE,DEFAULT_STATE,DEF_ACTION " +
							menuQry = "SELECT APPLICATION APP,WIN_NAME,MENU_PATH MPATH,DESCR,ICON_PATH,OBJ_TYPE,DEFAULT_STATE,DEF_ACTION,ENT_TYPES, '' AS DEVICE_ACC_CLASS " +
										"FROM ITM2MENU " +
										"WHERE WIN_NAME NOT IN ('-') " +
										"AND APPLICATION = '"+appName+"' " +
										//""+ (isMobile == true ? " AND MOB_DEPLOY = 'Y' " : " ") +//Add by Dnyaneshwar on 6-Feb-2013 [ Add condition ] Start
										""+ (isMobile == true ? " AND ( MOB_DEPLOY = 'Y' OR MOB_DEPLOY = 'B' )" : "  AND ( MOB_DEPLOY != 'Y' OR MOB_DEPLOY is null ) ") + //Added by Nilesh Soor on 21-Aug-14 [ Mobile Specific Menus Should Not Get Displayed In Browser. ]
										"ORDER BY APPLICATION,LEVEL_1,LEVEL_2,LEVEL_3,LEVEL_4,LEVEL_5"; //$NON-NLS-1$ //$NON-NLS-2$
						}
						InfinispanLogger.log("2", userInfo, null,"In CommonDBAccessEJB.getUserXMLTree() menuQry in if : ["+menuQry+"]");
						//BaseLogger.log("9",null,null,"getUserXMLTree : menu query :-["+menuQry+"]");
						//Added by saiprasad on 15-03-19 to draw and rights based on rights in user_adhc_right table[START]
						overrideRightsMap = getUserAdhocRights(profileID, userInfo);
						//Added by saiprasad on 15-03-19 to draw and rights based on rights in user_adhc_right table[END]
						statOption = con1.createStatement();
						rsOption = statOption.executeQuery(menuQry);
						while (rsOption.next()){
							appln = rsOption.getString("APP"); //$NON-NLS-1$
							winName = rsOption.getString("WIN_NAME"); //$NON-NLS-1$
							mpath = rsOption.getString("MPATH"); //$NON-NLS-1$
							//Added by Pratheek on 11-06-18[to show menu based on ent_types column values of itm2menu and Enterprise table]-Start
							entTypes = E12GenericUtility.checkNull(rsOption.getString("ENT_TYPES"));
							BaseLogger.log("3",userInfo,null,"ent_type 4019!!!!["+entTypes+"]");
							//Added by Pratheek on 11-06-18[to show menu based on ent_types column values of itm2menu and Enterprise table]-End
							//Added By Ajinkya Gopalkar on 3-DEC-15 [for configuring fullscreen mode by DEFAULT_STATE column ]
							defaultState = rsOption.getString("DEFAULT_STATE");
							//Added By Sandesh Shinde on 10-AUG-16 [For default action for menu] start
							defaultAction = rsOption.getString("DEF_ACTION");
							//Added By Sandesh Shinde on 10-AUG-16 [For default action for menu] end
							//Added by Pankaj P on 29/03/2021 [DEVICE_ACC_CLASS related implementation, user device wise menu definition]
							userRightsDeviceAccClass = E12GenericUtility.checkNull( rsOption.getString("DEVICE_ACC_CLASS") );
							BaseLogger.log( "3", userInfo, null, "userRightsDeviceAccClass : ["+ userRightsDeviceAccClass +"]" );
							
							int levelCnt = 1;
							BaseLogger.log("3",userInfo,null,"-------------------------------------------:"+mpath); //$NON-NLS-1$
							//Changes made by Pratheek on 12-06-18 [to show the menu based on ent_types values]-Start
							//Changes made by Pratheek on 26-06-18[to check if enty_type and ent_types column value]-Start
							if(entTypes.length() > 0 && enterpriseType.length() > 0 && entTypes.contains(enterpriseType))
							{
								if(mpath != null)
								{
									//Added by Sagar B. for multiple profile id related changes[07Dec17]START 
									if( winName != null )
									{
										if(menuMap != null && !menuMap.isEmpty() && menuMap.size() > 0 && menuMap.containsKey(mpath) )
										{
											if(((String)menuMap.get(mpath)).equalsIgnoreCase(winName))
											{
												continue;
											}
										}
										menuMap.put(mpath, winName);
									}
									//Added by Sagar B. for multiple profile id related changes[07Dec17]END
									path = mpath.substring( mpath.indexOf( '.' ) + 1 );
									path1 = path.substring( path.indexOf( '.' )+1, path.lastIndexOf( '.' )  );
									path2 = path1.substring(path1.indexOf('.'));
									level1 = path.substring(0,path.indexOf('.'));
									level2 = path1.substring(0,path1.indexOf('.'));
									level3 = path2.substring(path2.indexOf('.')+1,path2.lastIndexOf('.')  );
									level4 = path1.substring(path1.lastIndexOf('.')+1  );
									level5 = mpath.substring(mpath.lastIndexOf('.')+1  );
									appDescr = rsOption.getString("DESCR"); //$NON-NLS-1$
									iconPath = rsOption.getString("ICON_PATH"); //$NON-NLS-1$
									objType = rsOption.getString("OBJ_TYPE"); //$NON-NLS-1$
									BaseLogger.log("3",userInfo,null,"level1["+level1+"] level2["+level2+"] level3["+level3+"] level4["+level4+"] ");
									if (!(level2.equals("0"))){ //$NON-NLS-1$
										levelCnt =levelCnt + 1;
										//if level 2 is defined then generates the child of level 1
										qry="SELECT DESCR,ICON_PATH,MENU_PATH FROM ITM2MENU WHERE APPLICATION='" + appln + "'" +  //$NON-NLS-1$ //$NON-NLS-2$
												"AND LEVEL_1= " + level1 + " AND LEVEL_2=0 AND LEVEL_3 = 0 AND LEVEL_4=0 AND LEVEL_5=0"; //$NON-NLS-1$ //$NON-NLS-2$
										statFolder = con1.createStatement();
										rsFolder = statFolder.executeQuery(qry);
										if(rsFolder.next()){
											currLev2Descr = E12GenericUtility.checkNull(rsFolder.getString("DESCR")); //$NON-NLS-1$
											currIconPath = rsFolder.getString("ICON_PATH"); //$NON-NLS-1$
											currMenuPath = rsFolder.getString("MENU_PATH"); //$NON-NLS-1$
										}
										//added By Nilesh For ressolving open cursor issue Start:01-06-2017
										if(rsFolder!=null)
										{
											rsFolder.close();
											rsFolder=null;
										}
										//added By Nilesh For ressolving open cursor issue End:01-06-2017
										BaseLogger.log("3",userInfo,null,"Level 2 prevLev2Descr ["+prevLev2Descr+"] currLev2Descr ["+currLev2Descr+"]");
										if (!((prevLev2Descr.equals(currLev2Descr)))){
											if(levelFlag2){
												mXML.append("</FOLDER>"); //$NON-NLS-1$
												levelFlag2 = false;
											}
											if(levelFlag3){
												mXML.append("</FOLDER>"); //$NON-NLS-1$
												levelFlag3 = false;
											}
											if(levelFlag4){
												mXML.append("</FOLDER>"); //$NON-NLS-1$
												levelFlag4 = false;
											}
											if(levelFlag5){
												mXML.append("</FOLDER>"); //$NON-NLS-1$
												levelFlag5 = false;
											}
											prevLev2Descr=currLev2Descr;
											prevLev3Descr="";//Changed by Pramod on 27-01-11[WI90SUN008 || Improper tree gets generated for certain cases.] //$NON-NLS-1$
											mXML.append(addFolder(currMenuPath,currIconPath,currLev2Descr));
											levelFlag2 = true;
										}
										statFolder.close();
										statFolder = null;
									}
                                    // Added by Mahesh Saggam on 28-July-2020 [to show all menu in ESS application menu] Start
									if(level2.equals("0") && levelFlag2)
									{
										mXML.append("</FOLDER>");
										levelFlag2 = false;
									}
									// Added by Mahesh Saggam on 28-July-2020 [to show all menu in ESS application menu] false
									if (!(level3.equals("0"))){ //$NON-NLS-1$
										levelCnt =levelCnt + 1;
										qry="SELECT DESCR,ICON_PATH,MENU_PATH FROM ITM2MENU WHERE APPLICATION='" + appln + "'" +  //$NON-NLS-1$ //$NON-NLS-2$
												"AND LEVEL_1= " + level1+ " AND LEVEL_2= " + level2 + " AND LEVEL_3 = 0 AND LEVEL_4=0 AND LEVEL_5=0"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
										statFolder = con1.createStatement();
										rsFolder = statFolder.executeQuery(qry);
										if(rsFolder.next()){
											currLev3Descr = E12GenericUtility.checkNull(rsFolder.getString("DESCR")); //$NON-NLS-1$
											currIconPath = rsFolder.getString("ICON_PATH"); //$NON-NLS-1$
											currMenuPath = rsFolder.getString("MENU_PATH"); //$NON-NLS-1$
										}
										//added By Nilesh For ressolving open cursor issue Start:01-06-2017
										if(rsFolder!=null)
										{
											rsFolder.close();
											rsFolder=null;
										}
										//added By Nilesh For ressolving open cursor issue End:01-06-2017
										BaseLogger.log("3",userInfo,null,"Level 3 prevLev3Descr ["+prevLev3Descr+"] currLev3Descr ["+currLev3Descr+"]");
										if (!((prevLev3Descr.equals(currLev3Descr)))){
											if(levelFlag4){
												mXML.append("</FOLDER>"); //$NON-NLS-1$
												levelFlag4 = false;
											}
											if(levelFlag3){
												mXML.append("</FOLDER>"); //$NON-NLS-1$
												levelFlag3 = false;
											}
											if(levelFlag5){
												mXML.append("</FOLDER>"); //$NON-NLS-1$
												levelFlag5 = false;
											}
											prevLev3Descr=currLev3Descr;
											prevLev4Descr="";//Changed by Pramod ion 27-01-11[WI90SUN008 || Improper tree gets generated for certain cases.] //$NON-NLS-1$
											mXML.append(addFolder(currMenuPath,currIconPath,currLev3Descr));
											levelFlag3 = true;
										}
										//added By Nilesh For ressolving open cursor issue Start:01-06-2017
										if(statFolder != null)
										{
											statFolder.close();
											statFolder = null;
										}
									}//level3
									if (!(level4.equals("0"))){ //$NON-NLS-1$
										levelCnt =levelCnt + 1;
										qry="SELECT DESCR,ICON_PATH,MENU_PATH  FROM ITM2MENU WHERE APPLICATION='" + appln + "'" +  //$NON-NLS-1$ //$NON-NLS-2$
												" AND LEVEL_1= " + level1 + " AND LEVEL_2="+ level2 +  //$NON-NLS-1$ //$NON-NLS-2$
												" AND LEVEL_3 = "+ level3 + " AND LEVEL_4=0 AND LEVEL_5=0"; //$NON-NLS-1$ //$NON-NLS-2$

										statFolder = con1.createStatement();
										rsFolder = statFolder.executeQuery(qry);
										if(rsFolder.next()){
											currLev4Descr = E12GenericUtility.checkNull(rsFolder.getString("DESCR")); //$NON-NLS-1$
											currIconPath =rsFolder.getString("ICON_PATH");	 //$NON-NLS-1$
											currMenuPath = rsFolder.getString("MENU_PATH"); //$NON-NLS-1$
										}
										if (!((prevLev4Descr.equals(currLev4Descr)))){
											if(levelFlag4){
												mXML.append("</FOLDER>"); //$NON-NLS-1$
												levelFlag4 = false;
											}
											if(levelFlag5){
												mXML.append("</FOLDER>"); //$NON-NLS-1$
												levelFlag5 = false;
											}
											prevLev4Descr = currLev4Descr;
											prevLev5Descr="";//Changed by Pramod on 27-01-11[WI90SUN008 || Improper tree gets generated for certain cases.] //$NON-NLS-1$
											mXML.append(addFolder(currMenuPath,currIconPath,currLev4Descr));
											levelFlag4 = true;
										}
										statFolder.close();
										statFolder = null;
										if(rsFolder!=null)
										{
											rsFolder.close();
											rsFolder=null;
										}
									}//level4
									if (!(level5.equals("0"))){ //$NON-NLS-1$
										levelCnt =levelCnt + 1;
										qry="SELECT DESCR,ICON_PATH,MENU_PATH  FROM ITM2MENU WHERE APPLICATION='" + appln + "'" +  //$NON-NLS-1$ //$NON-NLS-2$
												" AND LEVEL_1= " + level1 + " AND LEVEL_2="+ level2 +  //$NON-NLS-1$ //$NON-NLS-2$
												" AND LEVEL_3 = "+ level3 + " AND LEVEL_4=" + level4 + " AND LEVEL_5=0"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
										statFolder = con1.createStatement();
										rsFolder = statFolder.executeQuery(qry);
										if(rsFolder.next()){
											currLev5Descr = E12GenericUtility.checkNull(rsFolder.getString("DESCR")); //$NON-NLS-1$
											currIconPath =rsFolder.getString("ICON_PATH"); //$NON-NLS-1$
											currMenuPath = rsFolder.getString("MENU_PATH"); //$NON-NLS-1$
										}
										//Added by Swapnil Shirke [To resolve NullPointerException]
										//BaseLogger.log("9",null,null,"qry["+qry+"]\nlevel1["+level1+"] level2["+level2+"] level3["+level3+"] level4["+level4+"] ");
										currLev5Descr = (currLev5Descr == null) ? "" : currLev5Descr; //$NON-NLS-1$
										//BaseLogger.log("9",null,null,"prevLev5Descr["+prevLev5Descr+"] currLev5Descr["+currLev5Descr+"]");
										if (!((prevLev5Descr.equals(currLev5Descr)))){
											if(levelFlag5){
												mXML.append("</FOLDER>"); //$NON-NLS-1$
												levelFlag5 = false;
											}
											prevLev5Descr=currLev5Descr;
											mXML.append(addFolder(currMenuPath,currIconPath,currLev5Descr));
											levelFlag5 = true;
										}
										statFolder.close();
										statFolder = null;
										if(rsFolder!=null)
										{
											rsFolder.close();
											rsFolder=null;
										}
									}//level5
									//	BaseLogger.log("9",null,null,"Level Cnt: - ["+levelCnt+"]");
									if(levelCnt == 4){
										if(levelFlag5){
											mXML.append("</FOLDER>"); //$NON-NLS-1$
											levelFlag5 = false;
										}
									}
									if(levelCnt == 3){
										if(levelFlag5){
											mXML.append("</FOLDER>"); //$NON-NLS-1$
											levelFlag5 = false;
										}
										if(levelFlag4){
											mXML.append("</FOLDER>"); //$NON-NLS-1$
											levelFlag4 = false;
										}
									}
									if(levelCnt == 2){
										if(levelFlag5){
											mXML.append("</FOLDER>"); //$NON-NLS-1$
											levelFlag5 = false;
										}
										if(levelFlag4){
											mXML.append("</FOLDER>"); //$NON-NLS-1$
											levelFlag4 = false;
										}
										if(levelFlag3){
											mXML.append("</FOLDER>"); //$NON-NLS-1$
											levelFlag3 = false;
										}
									}
									String tempWinName=winName;
									if(winName !=null){
										if(winName.indexOf("w_")!=-1 ){ //$NON-NLS-1$
											tempWinName = winName.substring(2);
										}

										if(winName.indexOf("&amp;") != -1){ //$NON-NLS-1$
											tempWinName = winName.replaceAll("&amp;","&"); //$NON-NLS-1$ //$NON-NLS-2$
										}
									}
									else{
										tempWinName = ""; //$NON-NLS-1$
									}
									if(iconPath != null ){
										if(iconPath.indexOf(".") !=-1){ //$NON-NLS-1$
											//iconPath = iconPath.substring(0,iconPath.indexOf(".")); //Commented by Dnyaneshwar Chavan on 23-JUN-14 [ The file extension not coming for display the menu level icon ] 
										}
									}
									else{
										iconPath = ""; //$NON-NLS-1$
									}
									boolean freez = false;
									String freezMsg = "";
									//Added and Changed by Pankaj P on 29/03/2021 [DEVICE_ACC_CLASS related implementation, user device wise menu definition] START
									//if ( userRightsDeviceAccClass.length() > 0 && userDeviceDtlMap != null && userDeviceDtlMap.size() > 0 )
									//Added by sunny soni for menu restricted related changes according to device acc class on 10-Feb-22 Start
									if ( userRightsDeviceAccClass.length() > 0 )
									{
										ArrayList<String> userRightsDeviceAccClassList = new ArrayList<String>( Arrays.asList( userRightsDeviceAccClass.split( "\\s*,\\s*" ) ) );
										for ( String deviceAccCls : userRightsDeviceAccClassList )
										{
											String deviceAccClsKey = E12GenericUtility.checkNull(deviceAccCls) + "~" +E12GenericUtility.checkNull( userInfo.getDeviceType() );
											deviceAccClsKey = E12GenericUtility.checkNull(deviceAccClsKey).trim().toLowerCase();
											BaseLogger.log( "3", null, null, "CommonDBAccessEJB :: deviceAccClsKey*** :["+ deviceAccClsKey +"]" );
											BaseLogger.log( "3", null, null, "CommonDBAccessEJB :: userDeviceDtlMap***:["+ userDeviceDtlMap +"]" );
											if (userDeviceDtlMap!=null && !userDeviceDtlMap.containsKey(deviceAccClsKey))
											{
												freez = true;
												freezMsg = getMessageDescr( "DEVMENURST", null, userInfo );
												break;
											}
											/*
											if ( userDeviceDtlMap.containsKey( deviceAccCls ) )
											{
												//Changed by Pankaj P on  06/10/2021 [check device_type instead of device_id] START
												String configuredDeviceType = E12GenericUtility.checkNull( userDeviceDtlMap.get( deviceAccCls ) );
												if ( configuredDeviceType.length() > 0 && ! userInfo.getDeviceType().equalsIgnoreCase( configuredDeviceType ) )
												//Changed by Pankaj P on  06/10/2021 [check device_type instead of device_id] END
												{
													freez = true;
													freezMsg = getMessageDescr( "DEVMENURST", null, userInfo );
													break;
												}
											}
											*/
										}
										//Added by sunny soni for menu restricted related changes according to device acc class on 10-Feb-22 End
									}
									if ( ! freez )
									{
										freez = checkObjPermission( tempWinName, objType );
										freezMsg = CommonConstants.menuRstMsg;
									}
									//Added and Changed by Pankaj P on 29/03/2021 [DEVICE_ACC_CLASS related implementation, user device wise menu definition] END
									mXML.append("<OPTION id='"+mpath+"' icon='"+iconPath+"'>"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
									mXML.append("<TITLE>"); //$NON-NLS-1$
									mXML.append("<![CDATA["+appDescr+"]]>"); //$NON-NLS-1$ //$NON-NLS-2$
									mXML.append("</TITLE>"); //$NON-NLS-1$
									mXML.append("<OBJNAME>"); //$NON-NLS-1$
									mXML.append("<![CDATA["+tempWinName+"]]>"); //$NON-NLS-1$ //$NON-NLS-2$
									mXML.append("</OBJNAME>"); //$NON-NLS-1$
									mXML.append("<OBJTYPE>"); //$NON-NLS-1$
									mXML.append(objType);
									mXML.append("</OBJTYPE>"); //$NON-NLS-1$
									//Added By Sandesh Shinde on 10-AUG-16 [For default action for menu] start
									mXML.append("<DEFAULT_ACTION>");
									mXML.append(defaultAction);
									mXML.append("</DEFAULT_ACTION>");
									//Added By Sandesh Shinde on 10-AUG-16 [For default action for menu] end
									mXML.append("<DEFAULT_STATE>");
									mXML.append(defaultState);
									mXML.append("</DEFAULT_STATE>");
									//Added By Suraj on 14-12-2016 [For menu freez]
									mXML.append("<FREEZ_MENU>");
									mXML.append(freez);
									mXML.append("</FREEZ_MENU>");
									if( freez )
									{
										mXML.append("<FREEZ_MESSAGE>");
										//Changed by Pankaj P on 29/03/2021 [DEVICE_ACC_CLASS related implementation, user device wise menu definition]
										//mXML.append( CommonConstants.menuRstMsg );
										mXML.append( freezMsg );
										mXML.append("</FREEZ_MESSAGE>");
									}
									else
									{
										mXML.append("<FREEZ_MESSAGE>");
										mXML.append("<![CDATA[]]>");
										mXML.append("</FREEZ_MESSAGE>");
									}
									//Added by Saiprasad G. for adding adhoc_rights tag in xml on 15-03-19 START
									String loginSiteCode = userInfo.getSiteCode();
			                        String adhocSiteCode = E12GenericUtility.checkNull(overrideRightsMap.get(tempWinName));
			                        BaseLogger.log("3", userInfo,null, "objNameSiteCodeMap:"+overrideRightsMap);
									if(loginSiteCode.equalsIgnoreCase(adhocSiteCode) || overrideRightsMap.containsKey(tempWinName))
									{
										mXML.append("<ADHOC_RIGHTS>");
										mXML.append("<![CDATA[Y]]>");
										mXML.append("</ADHOC_RIGHTS>");
									}
									else
									{
										mXML.append("<ADHOC_RIGHTS>");
										mXML.append("<![CDATA[N]]>");
										mXML.append("</ADHOC_RIGHTS>");
									}
									//Added by Saiprasad G. for adding adhoc_rights tag in xml on 15-03-19 END
									mXML.append("</OPTION>"); //$NON-NLS-1$

								}//if(mpath != null)
							}
							//Changes made by Pratheek on 12-06-18 [to show the menu based on ent_types values]-End
						}//rs
						if(levelFlag2){
							mXML.append("</FOLDER>"); //$NON-NLS-1$
							levelFlag2 = false;
						}
						if(levelFlag3){
							mXML.append("</FOLDER>"); //$NON-NLS-1$
							levelFlag3 = false;
						}
						if(levelFlag4){
							mXML.append("</FOLDER>"); //$NON-NLS-1$
							levelFlag4 = false;
						}
						if(levelFlag5){
							mXML.append("</FOLDER>"); //$NON-NLS-1$
							levelFlag5 = false;
						}
						
						//Changes By Prajyot[Issue of menu Tree Generation ] On 20MAR13
						//mXML.append("</APPLICATION>");					 //$NON-NLS-1$
						
						statOption.close();
						statOption = null;
						rsOption.close();
						rsOption = null;
						//Changed by Prasad on 23/11/2020 [check infinispanLocalObj not null]
						if ( infinispanLocalObj != null )
						{
							infinispanLocalObj.putFormData(profileIDStorageKey, mXML.toString());
						}
						mXMLTree.append(mXML.toString());
					}
				}
			}
			else
			{
				StringBuffer mXML = new StringBuffer();
				if( level >= 1 ){
					//Modified By Sandesh Shinde on 10-AUG-16 [For default action for menu]
					//Changes made by Pratheek on 12-06-18[to get the ent_type column value from itm2menu]-Start
//					menuQry="SELECT B.APPLICATION APP,B.WIN_NAME, B.MENU_PATH MPATH,B.DESCR,B.ICON_PATH,B.OBJ_TYPE,B.DEFAULT_STATE,B.DEF_ACTION " +   //$NON-NLS-1$
					menuQry="SELECT B.APPLICATION APP,B.WIN_NAME, B.MENU_PATH MPATH,B.DESCR,B.ICON_PATH,B.OBJ_TYPE,B.DEFAULT_STATE,B.DEF_ACTION,B.ENT_TYPES " +   //$NON-NLS-1$
							"FROM USER_RIGHTS A, ITM2MENU B " +  //$NON-NLS-1$
							//Changed by Sagar B. for multiple profile id related changes[11-Dec-17]
							//"WHERE A.PROFILE_ID ='"+profileID+"' "+ //$NON-NLS-1$ //$NON-NLS-2$
							"WHERE A.PROFILE_ID IN "+ E12GenericUtility.getFormattedProfileId(profileID) +" "+ //$NON-NLS-1$ //$NON-NLS-2$
							"AND A.APPLICATION='"+appName+"' AND A.APPLICATION=B.APPLICATION AND A.MENU_ROW=B.LEVEL_1 "+  //$NON-NLS-1$ //$NON-NLS-2$
							"AND A.MENU_COL=B.LEVEL_2 AND A.MENU_SUBCOL=B.LEVEL_3 " + //$NON-NLS-1$
							"AND A.LEVEL_4=B.LEVEL_4 AND A.LEVEL_5=B.LEVEL_5 "+  //$NON-NLS-1$
							//""+(isMobile == true ? " AND B.MOB_DEPLOY = 'Y' " : " ")+   //Add by Dnyaneshwar on 6-Feb-2013 [ Add condition ] Start
							""+ (isMobile == true ? " AND ( B.MOB_DEPLOY = 'Y' OR B.MOB_DEPLOY = 'B' )" : "  AND ( B.MOB_DEPLOY != 'Y' OR B.MOB_DEPLOY is null ) ") + //Added by Nilesh Soor on 21-Aug-14 [ Mobile Specific Menus Should Not Get Displayed In Browser. ]
							"ORDER BY A.APPLICATION,A.MENU_ROW,A.MENU_COL,A.MENU_SUBCOL,A.LEVEL_4,A.LEVEL_5 "; //$NON-NLS-1$
				}
				else{
					//Modified By Sandesh Shinde on 10-AUG-16 [For default action for menu]
					//Changes made by Pratheek on 12-06-18[to get the ent_type column value from itm2menu]-Start
//					menuQry =	"SELECT APPLICATION APP,WIN_NAME,MENU_PATH MPATH,DESCR,ICON_PATH,OBJ_TYPE,DEFAULT_STATE,DEF_ACTION " +
					menuQry =	"SELECT APPLICATION APP,WIN_NAME,MENU_PATH MPATH,DESCR,ICON_PATH,OBJ_TYPE,DEFAULT_STATE,DEF_ACTION,ENT_TYPES " +
								"FROM ITM2MENU " +
								"WHERE WIN_NAME NOT IN ('-') " +
								"AND APPLICATION = '"+appName+"' " +
								//""+ (isMobile == true ? " AND MOB_DEPLOY = 'Y' " : " ") +//Add by Dnyaneshwar on 6-Feb-2013 [ Add condition ] Start
								""+ (isMobile == true ? " AND ( MOB_DEPLOY = 'Y' OR MOB_DEPLOY = 'B' )" : "  AND ( MOB_DEPLOY != 'Y' OR MOB_DEPLOY is null ) ") + //Added by Nilesh Soor on 21-Aug-14 [ Mobile Specific Menus Should Not Get Displayed In Browser. ]
								"ORDER BY APPLICATION,LEVEL_1,LEVEL_2,LEVEL_3,LEVEL_4,LEVEL_5"; //$NON-NLS-1$ //$NON-NLS-2$
				}
				//BaseLogger.log("9",null,null,"getUserXMLTree : menu query :-["+menuQry+"]");
				overrideRightsMap = getUserAdhocRights(profileID, userInfo);
				statOption = con1.createStatement();
				rsOption = statOption.executeQuery(menuQry);
				
				while (rsOption.next()){
					appln = rsOption.getString("APP"); //$NON-NLS-1$
					winName = rsOption.getString("WIN_NAME"); //$NON-NLS-1$
					mpath = rsOption.getString("MPATH"); //$NON-NLS-1$
					//Added By Ajinkya Gopalkar on 3-DEC-15 [for configuring fullscreen mode by DEFAULT_STATE column ]
					defaultState = rsOption.getString("DEFAULT_STATE");
					//Added By Sandesh Shinde on 10-AUG-16 [For default action for menu] start
					defaultAction = rsOption.getString("DEF_ACTION");
					//Added By Sandesh Shinde on 10-AUG-16 [For default action for menu] end
					//Added by Pratheek on 11-06-18[to show menu based on ent_types column values of itm2menu and Enterprise table]-Start
					entTypes = E12GenericUtility.checkNull(rsOption.getString("ENT_TYPES"));
					//Added by Pratheek on 11-06-18[to show menu based on ent_types column values of itm2menu and Enterprise table]-End
					int levelCnt = 1;
					BaseLogger.log("9",null,null,"-------------------------------------------:"+mpath); //$NON-NLS-1$
					//Changes made by Pratheek on 12-06-18 [to sow the menu based on ent_types values]-Start
					//Changes made by Pratheek on 26-06-18[to check if enty_type and ent_types column value]-Start
					if(entTypes.length() > 0 && enterpriseType.length() > 0 && entTypes.contains(enterpriseType))
					{
						if(mpath != null)
						{
							//Added by Sagar B. for multiple profile id related changes[07Dec17]START 
							if( winName != null )
							{
								if(menuMap != null && !menuMap.isEmpty() && menuMap.size() > 0 && menuMap.containsKey(mpath) )
								{
									if(((String)menuMap.get(mpath)).equalsIgnoreCase(winName))
									{
										continue;
									}
								}
								menuMap.put(mpath, winName);
							}
							//Added by Sagar B. for multiple profile id related changes[07Dec17]END
							path = mpath.substring( mpath.indexOf( '.' ) + 1 );
							path1 = path.substring( path.indexOf( '.' )+1, path.lastIndexOf( '.' )  );
							path2 = path1.substring(path1.indexOf('.'));
							level1 = path.substring(0,path.indexOf('.'));
							level2 = path1.substring(0,path1.indexOf('.'));
							level3 = path2.substring(path2.indexOf('.')+1,path2.lastIndexOf('.')  );
							level4 = path1.substring(path1.lastIndexOf('.')+1  );
							level5 = mpath.substring(mpath.lastIndexOf('.')+1  );
							appDescr = rsOption.getString("DESCR"); //$NON-NLS-1$
							iconPath = rsOption.getString("ICON_PATH"); //$NON-NLS-1$
							objType = rsOption.getString("OBJ_TYPE"); //$NON-NLS-1$
							if (!(level2.equals("0"))){ //$NON-NLS-1$
								levelCnt =levelCnt + 1;
								//if level 2 is defined then generates the child of level 1
								qry="SELECT DESCR,ICON_PATH,MENU_PATH FROM ITM2MENU WHERE APPLICATION='" + appln + "'" +  //$NON-NLS-1$ //$NON-NLS-2$
										"AND LEVEL_1= " + level1 + " AND LEVEL_2=0 AND LEVEL_3 = 0 AND LEVEL_4=0 AND LEVEL_5=0"; //$NON-NLS-1$ //$NON-NLS-2$
								statFolder = con1.createStatement();
								rsFolder = statFolder.executeQuery(qry);
								if(rsFolder.next()){
									currLev2Descr = E12GenericUtility.checkNull(rsFolder.getString("DESCR")); //$NON-NLS-1$
									currIconPath = rsFolder.getString("ICON_PATH"); //$NON-NLS-1$
									currMenuPath = rsFolder.getString("MENU_PATH"); //$NON-NLS-1$
								}
								//added By Nilesh For ressolving open cursor issue Start:01-06-2017
								if(rsFolder!=null)
								{
									rsFolder.close();
									rsFolder=null;
								}
								//added By Nilesh For ressolving open cursor issue End:01-06-2017
								if (!((prevLev2Descr.equals(currLev2Descr)))){
									if(levelFlag2){
										mXML.append("</FOLDER>"); //$NON-NLS-1$
										levelFlag2 = false;
									}
									if(levelFlag3){
										mXML.append("</FOLDER>"); //$NON-NLS-1$
										levelFlag3 = false;
									}
									if(levelFlag4){
										mXML.append("</FOLDER>"); //$NON-NLS-1$
										levelFlag4 = false;
									}
									if(levelFlag5){
										mXML.append("</FOLDER>"); //$NON-NLS-1$
										levelFlag5 = false;
									}
									prevLev2Descr=currLev2Descr;
									prevLev3Descr="";//Changed by Pramod on 27-01-11[WI90SUN008 || Improper tree gets generated for certain cases.] //$NON-NLS-1$
									mXML.append(addFolder(currMenuPath,currIconPath,currLev2Descr));
									levelFlag2 = true;
								}
								statFolder.close();
								statFolder = null;
							}
							if (!(level3.equals("0"))){ //$NON-NLS-1$
								levelCnt =levelCnt + 1;
								qry="SELECT DESCR,ICON_PATH,MENU_PATH FROM ITM2MENU WHERE APPLICATION='" + appln + "'" +  //$NON-NLS-1$ //$NON-NLS-2$
										"AND LEVEL_1= " + level1+ " AND LEVEL_2= " + level2 + " AND LEVEL_3 = 0 AND LEVEL_4=0 AND LEVEL_5=0"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
								statFolder = con1.createStatement();
								rsFolder = statFolder.executeQuery(qry);
								if(rsFolder.next()){
									currLev3Descr = E12GenericUtility.checkNull(rsFolder.getString("DESCR")); //$NON-NLS-1$
									currIconPath = rsFolder.getString("ICON_PATH"); //$NON-NLS-1$
									currMenuPath = rsFolder.getString("MENU_PATH"); //$NON-NLS-1$
								}
								//added By Nilesh For ressolving open cursor issue Start:01-06-2017
								if(rsFolder!=null)
								{
									rsFolder.close();
									rsFolder=null;
								}
								//added By Nilesh For ressolving open cursor issue End:01-06-2017
								if (!((prevLev3Descr.equals(currLev3Descr)))){
									if(levelFlag4){
										mXML.append("</FOLDER>"); //$NON-NLS-1$
										levelFlag4 = false;
									}
									if(levelFlag3){
										mXML.append("</FOLDER>"); //$NON-NLS-1$
										levelFlag3 = false;
									}
									if(levelFlag5){
										mXML.append("</FOLDER>"); //$NON-NLS-1$
										levelFlag5 = false;
									}
									prevLev3Descr=currLev3Descr;
									prevLev4Descr="";//Changed by Pramod ion 27-01-11[WI90SUN008 || Improper tree gets generated for certain cases.] //$NON-NLS-1$
									mXML.append(addFolder(currMenuPath,currIconPath,currLev3Descr));
									levelFlag3 = true;
								}
								//added By Nilesh For ressolving open cursor issue Start:01-06-2017
								if(statFolder != null)
								{
									statFolder.close();
									statFolder = null;
								}
							}//level3
							if (!(level4.equals("0"))){ //$NON-NLS-1$
								levelCnt =levelCnt + 1;
								qry="SELECT DESCR,ICON_PATH,MENU_PATH  FROM ITM2MENU WHERE APPLICATION='" + appln + "'" +  //$NON-NLS-1$ //$NON-NLS-2$
										" AND LEVEL_1= " + level1 + " AND LEVEL_2="+ level2 +  //$NON-NLS-1$ //$NON-NLS-2$
										" AND LEVEL_3 = "+ level3 + " AND LEVEL_4=0 AND LEVEL_5=0"; //$NON-NLS-1$ //$NON-NLS-2$

								statFolder = con1.createStatement();
								rsFolder = statFolder.executeQuery(qry);
								if(rsFolder.next()){
									currLev4Descr = E12GenericUtility.checkNull(rsFolder.getString("DESCR")); //$NON-NLS-1$
									currIconPath =rsFolder.getString("ICON_PATH");	 //$NON-NLS-1$
									currMenuPath = rsFolder.getString("MENU_PATH"); //$NON-NLS-1$
								}
								if (!((prevLev4Descr.equals(currLev4Descr)))){
									if(levelFlag4){
										mXML.append("</FOLDER>"); //$NON-NLS-1$
										levelFlag4 = false;
									}
									if(levelFlag5){
										mXML.append("</FOLDER>"); //$NON-NLS-1$
										levelFlag5 = false;
									}
									prevLev4Descr = currLev4Descr;
									prevLev5Descr="";//Changed by Pramod on 27-01-11[WI90SUN008 || Improper tree gets generated for certain cases.] //$NON-NLS-1$
									mXML.append(addFolder(currMenuPath,currIconPath,currLev4Descr));
									levelFlag4 = true;
								}
								statFolder.close();
								statFolder = null;
								if(rsFolder!=null)
								{
									rsFolder.close();
									rsFolder=null;
								}
							}//level4
							if (!(level5.equals("0"))){ //$NON-NLS-1$
								levelCnt =levelCnt + 1;
								qry="SELECT DESCR,ICON_PATH,MENU_PATH  FROM ITM2MENU WHERE APPLICATION='" + appln + "'" +  //$NON-NLS-1$ //$NON-NLS-2$
										" AND LEVEL_1= " + level1 + " AND LEVEL_2="+ level2 +  //$NON-NLS-1$ //$NON-NLS-2$
										" AND LEVEL_3 = "+ level3 + " AND LEVEL_4=" + level4 + " AND LEVEL_5=0"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
								statFolder = con1.createStatement();
								rsFolder = statFolder.executeQuery(qry);
								if(rsFolder.next()){
									currLev5Descr = E12GenericUtility.checkNull(rsFolder.getString("DESCR")); //$NON-NLS-1$
									currIconPath =rsFolder.getString("ICON_PATH"); //$NON-NLS-1$
									currMenuPath = rsFolder.getString("MENU_PATH"); //$NON-NLS-1$
								}
								//Added by Swapnil Shirke [To resolve NullPointerException]
								//BaseLogger.log("9",null,null,"qry["+qry+"]\nlevel1["+level1+"] level2["+level2+"] level3["+level3+"] level4["+level4+"] ");
								currLev5Descr = (currLev5Descr == null) ? "" : currLev5Descr; //$NON-NLS-1$
								//BaseLogger.log("9",null,null,"prevLev5Descr["+prevLev5Descr+"] currLev5Descr["+currLev5Descr+"]");
								if (!((prevLev5Descr.equals(currLev5Descr)))){
									if(levelFlag5){
										mXML.append("</FOLDER>"); //$NON-NLS-1$
										levelFlag5 = false;
									}
									prevLev5Descr=currLev5Descr;
									mXML.append(addFolder(currMenuPath,currIconPath,currLev5Descr));
									levelFlag5 = true;
								}
								statFolder.close();
								statFolder = null;
								if(rsFolder!=null)
								{
									rsFolder.close();
									rsFolder=null;
								}
							}//level5
							//	BaseLogger.log("9",null,null,"Level Cnt: - ["+levelCnt+"]");
							if(levelCnt == 4){
								if(levelFlag5){
									mXML.append("</FOLDER>"); //$NON-NLS-1$
									levelFlag5 = false;
								}
							}
							if(levelCnt == 3){
								if(levelFlag5){
									mXML.append("</FOLDER>"); //$NON-NLS-1$
									levelFlag5 = false;
								}
								if(levelFlag4){
									mXML.append("</FOLDER>"); //$NON-NLS-1$
									levelFlag4 = false;
								}
							}
							if(levelCnt == 2){
								if(levelFlag5){
									mXML.append("</FOLDER>"); //$NON-NLS-1$
									levelFlag5 = false;
								}
								if(levelFlag4){
									mXML.append("</FOLDER>"); //$NON-NLS-1$
									levelFlag4 = false;
								}
								if(levelFlag3){
									mXML.append("</FOLDER>"); //$NON-NLS-1$
									levelFlag3 = false;
								}
							}
							String tempWinName=winName;
							if(winName !=null){
								if(winName.indexOf("w_")!=-1 ){ //$NON-NLS-1$
									tempWinName = winName.substring(2);
								}

								if(winName.indexOf("&amp;") != -1){ //$NON-NLS-1$
									tempWinName = winName.replaceAll("&amp;","&"); //$NON-NLS-1$ //$NON-NLS-2$
								}
							}
							else{
								tempWinName = ""; //$NON-NLS-1$
							}
							if(iconPath != null ){
								if(iconPath.indexOf(".") !=-1){ //$NON-NLS-1$
									//iconPath = iconPath.substring(0,iconPath.indexOf(".")); //Commented by Dnyaneshwar Chavan on 23-JUN-14 [ The file extension not coming for display the menu level icon ] 
								}
							}
							else{
								iconPath = ""; //$NON-NLS-1$
							}
							boolean freez = false;
							freez = checkObjPermission( tempWinName ,objType);

							mXML.append("<OPTION id='"+mpath+"' icon='"+iconPath+"'>"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
							mXML.append("<TITLE>"); //$NON-NLS-1$
							mXML.append("<![CDATA["+appDescr+"]]>"); //$NON-NLS-1$ //$NON-NLS-2$
							mXML.append("</TITLE>"); //$NON-NLS-1$
							mXML.append("<OBJNAME>"); //$NON-NLS-1$
							mXML.append("<![CDATA["+tempWinName+"]]>"); //$NON-NLS-1$ //$NON-NLS-2$
							mXML.append("</OBJNAME>"); //$NON-NLS-1$
							mXML.append("<OBJTYPE>"); //$NON-NLS-1$
							mXML.append(objType);
							mXML.append("</OBJTYPE>"); //$NON-NLS-1$
							//Added By Sandesh Shinde on 10-AUG-16 [For default action for menu] start
							mXML.append("<DEFAULT_ACTION>");
							mXML.append(defaultAction);
							mXML.append("</DEFAULT_ACTION>");
							//Added By Sandesh Shinde on 10-AUG-16 [For default action for menu] end
							mXML.append("<DEFAULT_STATE>");
							mXML.append(defaultState);
							mXML.append("</DEFAULT_STATE>");
							//Added By Suraj on 14-12-2016 [For menu freez]
							mXML.append("<FREEZ_MENU>");
							mXML.append(freez);
							mXML.append("</FREEZ_MENU>");
							if( freez )
							{
								mXML.append("<FREEZ_MESSAGE>");
								mXML.append( CommonConstants.menuRstMsg );
								mXML.append("</FREEZ_MESSAGE>");
							}
							else
							{
								mXML.append("<FREEZ_MESSAGE>");
								mXML.append("<![CDATA[]]>");
								mXML.append("</FREEZ_MESSAGE>");
							}

							//Added by Saiprasad G. for adding adhoc_rights tag in xml on 15-03-19 START
							String loginSiteCode = userInfo.getSiteCode();
							String adhocSiteCode = E12GenericUtility.checkNull(overrideRightsMap.get(tempWinName));
							BaseLogger.log("3", userInfo,null, "objNameSiteCodeMap:"+overrideRightsMap);
							if(loginSiteCode.equalsIgnoreCase(adhocSiteCode) || overrideRightsMap.containsKey(tempWinName))
							{
							mXML.append("<ADHOC_RIGHTS>");
							mXML.append("<![CDATA[Y]]>");
							mXML.append("</ADHOC_RIGHTS>");
							}
							else
							{
							mXML.append("<ADHOC_RIGHTS>");
							mXML.append("<![CDATA[N]]>");
							mXML.append("</ADHOC_RIGHTS>");
							}
							//Added by Saiprasad G. for adding adhoc_rights tag in xml on 15-03-19 END



							mXML.append("</OPTION>"); //$NON-NLS-1$

						}//if(mpath != null)
					}
					//Changes made by Pratheek on 12-06-18 [to show the menu based on ent_types values]-End
				}//rs
				if(levelFlag2){
					mXML.append("</FOLDER>"); //$NON-NLS-1$
					levelFlag2 = false;
				}
				if(levelFlag3){
					mXML.append("</FOLDER>"); //$NON-NLS-1$
					levelFlag3 = false;
				}
				if(levelFlag4){
					mXML.append("</FOLDER>"); //$NON-NLS-1$
					levelFlag4 = false;
				}
				
				//Changes By Prajyot[Issue of menu Tree Generation ] On 20MAR13
				//mXML.append("</APPLICATION>");					 //$NON-NLS-1$
				
				statOption.close();
				statOption = null;
				rsOption.close();
				rsOption = null;
				mXMLTree.append(mXML.toString());
			}
			//Added By Pankaj T. on 18-04-18 for profileID wise menu caching - end
			BaseLogger.log("3",userInfo,null,"(DBAccessEJB:getUserXML)UserXML: Built mXML:["+mXMLTree.toString().length()+"]"); //$NON-NLS-1$
		}
		catch (BaseException basee){ 
			BaseLogger.log("0",userInfo,null,"BaseException: DBAccess: getUserXMLTree: ==>UserXML: Not Built(Generic Exception)\n"); //$NON-NLS-1$
			throw basee;
		}
		catch(SQLException sqle){
			BaseLogger.log("0",userInfo,null,"SQLException: DBAccess: getUserXMLTree: ==>UserXML: Not Built(SQLException)\n" + sqle); //$NON-NLS-1$
			sqle.printStackTrace();
			throw new BaseException(sqle);
		}
		catch (Exception e){ 
			BaseLogger.log("0",userInfo,null,"Exception: DBAccess: getUserXMLTree: ==>UserXML: Not Built(Generic Exception)\n" + e); //$NON-NLS-1$
			throw new BaseException(e);
		}
		finally{
			try{
				if(conn != null){
					if(statOption != null)statOption.close();
					if(rsFolder != null)rsFolder.close();
					conn.close();
					conn = null;
				}
				if(con1 != null){
					if(statOption != null)statOption.close();
					if(rsFolder != null)rsFolder.close();
					con1.close();
					con1 = null;
				}
			}
			catch(Exception e){
				BaseLogger.log("0",userInfo,null,"Exception: DBAccess: getUserXMLTree ==>UserXML: Not Built F\n" + e); //$NON-NLS-1$
				throw new BaseException(e);
			}
		}
		clearPermissionList();
		return mXMLTree.toString();
	}
	//Overloaded method is added by Gulzar on 10/10/13 added userInfo parameter for multidb connection : END
	
	//Changed by Dayanand on 16/08/10[To generate menu application wise || MF01SUN001]start
	//Change by Harshada on 26th Oct 2012 [Create user connections on login] 
	//Add by Dnyaneshwar on 6-Feb-2013 [ Add isMobile param for Clubbing of Menus on the scanner ] Start
	//public String getUserXMLTree(String userCode, String profileID , String applName, ) throws RemoteException,BaseException
	/*public String getUserXMLTree(String userCode, String profileID , String applName, boolean isMobile ) throws RemoteException,BaseException
	{		
		BaseLogger.log("9",null,null,"3581 inside getUserXMLTree:: applName is: " + applName+" isMobile "+isMobile);
		
		//Changes By Prajyot[Issue of menu Tree Generation ] On 20MAR13
		//StringBuffer mXML = new StringBuffer("<APPLICATION>"); //$NON-NLS-1$
		StringBuffer mXML = new StringBuffer(""); //$NON-NLS-1$
		
		Connection conn = null;
		Statement statOption = null;
		ResultSet rsOption = null;
		Statement statFolder = null;
		ResultSet rsFolder = null;
		try{
			//Added By Suraj on 14-12-2016 [ For menu restriction based on condition ]
			//checkConditionDetails();
			
			String currLev2Descr = null;
			String currLev3Descr = null;
			String currLev4Descr = null;
			String currLev5Descr = null;
			String prevLev2Descr = "",prevLev3Descr = "",prevLev4Descr = "",prevLev5Descr = ""; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
			String iconPath = ""; //$NON-NLS-1$
			String currIconPath = ""; //$NON-NLS-1$
			String currMenuPath =""; //$NON-NLS-1$
			String objType = ""; //$NON-NLS-1$
			String appDescr,mpath,appln,level1,level2,level3,level4,level5;
			String path,path1,path2,qry,winName;
			boolean levelFlag2 = false;
			boolean levelFlag3 = false;
			boolean levelFlag4 = false;
			boolean levelFlag5 = false;
			String appName = applName; //$NON-NLS-1$
			//Added By Ajinkya Gopalkar on 3-DEC-15 [for configuring fullscreen mode by DEFAULT_STATE column ]
			String defaultState = "0";
			//Added By Sandesh Shinde on 10-AUG-16 [For default action for menu]
			String defaultAction = "";
			
			//Commented By Prajyot On 21-JAN-2012 [As per Danish Sir] Starts
//			mXML.append("<OPTION id='DASH.0.1.0.0.0' icon='e12_logo'>"); //$NON-NLS-1$
//			mXML.append("<TITLE><![CDATA["+"My Dashboard"+"]]></TITLE>"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
//			mXML.append("<OBJNAME><![CDATA[dashboard]]></OBJNAME>"); //$NON-NLS-1$
//			mXML.append("<OBJTYPE>D</OBJTYPE>"); //$NON-NLS-1$
//			mXML.append("</OPTION>"); //$NON-NLS-1$
			//Commented By Prajyot On 21-JAN-2012 [As per Danish Sir] Ends
			
			HashMap<String, String> menuMap = new HashMap<String, String>();
			
			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("Driver"); //$NON-NLS-1$
			String usrLevQry = "SELECT USR_LEV FROM USERS WHERE CODE ='" + userCode + "'"; //$NON-NLS-1$ //$NON-NLS-2$
			statOption = conn.createStatement();
			rsOption = statOption.executeQuery(usrLevQry);
			int level = 0;
			if(rsOption.next()){
				level = rsOption.getInt("USR_LEV"); //$NON-NLS-1$
			}
			statOption.close();
			statOption = null;
			String menuQry = null;			
			if ( applName != null && applName.length() > 0)
			{
				appName = applName;
			}
			if( level >= 1 ){
				//Modified By Sandesh Shinde on 10-AUG-16 [For default action for menu]
				menuQry="SELECT B.APPLICATION APP,B.WIN_NAME, B.MENU_PATH MPATH,B.DESCR,B.ICON_PATH,B.OBJ_TYPE,B.DEFAULT_STATE,B.DEF_ACTION " +   //$NON-NLS-1$
						"FROM USER_RIGHTS A, ITM2MENU B " +  //$NON-NLS-1$
						//Changed by Sagar B. for multiple profile id related changes[11-Dec-17]
						//"WHERE A.PROFILE_ID ='"+profileID+"' "+ //$NON-NLS-1$ //$NON-NLS-2$
						"WHERE A.PROFILE_ID IN "+ E12GenericUtility.getFormattedProfileId(profileID) +" "+ //$NON-NLS-1$ //$NON-NLS-2$
						"AND A.APPLICATION='"+appName+"' AND A.APPLICATION=B.APPLICATION AND A.MENU_ROW=B.LEVEL_1 "+  //$NON-NLS-1$ //$NON-NLS-2$
						"AND A.MENU_COL=B.LEVEL_2 AND A.MENU_SUBCOL=B.LEVEL_3 " + //$NON-NLS-1$
						"AND A.LEVEL_4=B.LEVEL_4 AND A.LEVEL_5=B.LEVEL_5 "+  //$NON-NLS-1$
						//""+(isMobile == true ? " AND B.MOB_DEPLOY = 'Y' " : " ")+   //Add by Dnyaneshwar on 6-Feb-2013 [ Add condition ] Start
						""+ (isMobile == true ? " AND ( B.MOB_DEPLOY = 'Y' OR B.MOB_DEPLOY = 'B' ) " : "  AND ( B.MOB_DEPLOY != 'Y' OR B.MOB_DEPLOY is null ) ") + //Added by Nilesh Soor on 21-Aug-14 [ Mobile Specific Menus Should Not Get Displayed In Browser. ]
						"ORDER BY A.APPLICATION,A.MENU_ROW,A.MENU_COL,A.MENU_SUBCOL,A.LEVEL_4,A.LEVEL_5 "; //$NON-NLS-1$
			}
			else{
				//Modified By Sandesh Shinde on 10-AUG-16 [For default action for menu]
				menuQry =	"SELECT APPLICATION APP,WIN_NAME,MENU_PATH MPATH,DESCR,ICON_PATH,OBJ_TYPE,DEFAULT_STATE,DEF_ACTION " +
							"FROM ITM2MENU " +
							"WHERE WIN_NAME NOT IN ('-') " +
							"AND APPLICATION = '"+appName+"' " +
							//""+ (isMobile == true ? " AND MOB_DEPLOY = 'Y' " : " ") +//Add by Dnyaneshwar on 6-Feb-2013 [ Add condition ] Start
							""+ (isMobile == true ? " AND ( MOB_DEPLOY = 'Y' OR MOB_DEPLOY = 'B' )" : "  AND ( MOB_DEPLOY != 'Y' OR MOB_DEPLOY is null ) ") + //Added by Nilesh Soor on 21-Aug-14 [ Mobile Specific Menus Should Not Get Displayed In Browser. ]
							"ORDER BY APPLICATION,LEVEL_1,LEVEL_2,LEVEL_3,LEVEL_4,LEVEL_5"; //$NON-NLS-1$ //$NON-NLS-2$
			}
			//BaseLogger.log("9",null,null,"getUserXMLTree : menu query :-["+menuQry+"]");
			statOption = conn.createStatement();
			rsOption = statOption.executeQuery(menuQry);
			while (rsOption.next()){
				appln = rsOption.getString("APP"); //$NON-NLS-1$
				winName = rsOption.getString("WIN_NAME"); //$NON-NLS-1$
				mpath = rsOption.getString("MPATH"); //$NON-NLS-1$
				//Added By Ajinkya Gopalkar on 3-DEC-15 [for configuring fullscreen mode by DEFAULT_STATE column ]
				defaultState = rsOption.getString("DEFAULT_STATE");
				//Added By Sandesh Shinde on 10-AUG-16 [For default action for menu] start
				defaultAction = rsOption.getString("DEF_ACTION");
				//Added By Sandesh Shinde on 10-AUG-16 [For default action for menu] end
				int levelCnt = 1;
				BaseLogger.log("9",null,null,"-------------------------------------------:"+mpath); //$NON-NLS-1$
				if(mpath != null)
				{
					//Added by Sagar B. for multiple profile id related changes[07Dec17]START 
					if( winName != null )
					{
						if(menuMap != null && !menuMap.isEmpty() && menuMap.size() > 0 && menuMap.containsKey(mpath) )
						{
							if(((String)menuMap.get(mpath)).equalsIgnoreCase(winName))
							{
								continue;
							}
						}
						menuMap.put(mpath, winName);
					}
					//Added by Sagar B. for multiple profile id related changes[07Dec17]END
					path = mpath.substring( mpath.indexOf( '.' ) + 1 );
					path1 = path.substring( path.indexOf( '.' )+1, path.lastIndexOf( '.' )  );
					path2 = path1.substring(path1.indexOf('.'));
					level1 = path.substring(0,path.indexOf('.'));
					level2 = path1.substring(0,path1.indexOf('.'));
					level3 = path2.substring(path2.indexOf('.')+1,path2.lastIndexOf('.')  );
					level4 = path1.substring(path1.lastIndexOf('.')+1  );
					level5 = mpath.substring(mpath.lastIndexOf('.')+1  );
					appDescr = rsOption.getString("DESCR"); //$NON-NLS-1$
					iconPath = rsOption.getString("ICON_PATH"); //$NON-NLS-1$
					objType = rsOption.getString("OBJ_TYPE"); //$NON-NLS-1$
					if (!(level2.equals("0"))){ //$NON-NLS-1$
						levelCnt =levelCnt + 1;
						//if level 2 is defined then generates the child of level 1
						qry="SELECT DESCR,ICON_PATH,MENU_PATH FROM ITM2MENU WHERE APPLICATION='" + appln + "'" +  //$NON-NLS-1$ //$NON-NLS-2$
							"AND LEVEL_1= " + level1 + " AND LEVEL_2=0 AND LEVEL_3 = 0 AND LEVEL_4=0 AND LEVEL_5=0"; //$NON-NLS-1$ //$NON-NLS-2$
						statFolder = conn.createStatement();
						rsFolder = statFolder.executeQuery(qry);
						if(rsFolder.next()){
							currLev2Descr = rsFolder.getString("DESCR"); //$NON-NLS-1$
							currIconPath = rsFolder.getString("ICON_PATH"); //$NON-NLS-1$
							currMenuPath = rsFolder.getString("MENU_PATH"); //$NON-NLS-1$
						}
						//added By Nilesh For ressolving open cursor issue Start:01-06-2017
						if(rsFolder!=null)
						{
							rsFolder.close();
							rsFolder=null;
						}
						//added By Nilesh For ressolving open cursor issue Start:01-06-2017
						if (!((prevLev2Descr.equals(currLev2Descr)))){
							if(levelFlag2){
								mXML.append("</FOLDER>"); //$NON-NLS-1$
								levelFlag2 = false;
							}
							if(levelFlag3){
								mXML.append("</FOLDER>"); //$NON-NLS-1$
								levelFlag3 = false;
							}
							if(levelFlag4){
								mXML.append("</FOLDER>"); //$NON-NLS-1$
								levelFlag4 = false;
							}
							if(levelFlag5){
								mXML.append("</FOLDER>"); //$NON-NLS-1$
								levelFlag5 = false;
							}
							prevLev2Descr=currLev2Descr;
							prevLev3Descr="";//Changed by Pramod on 27-01-11[WI90SUN008 || Improper tree gets generated for certain cases.] //$NON-NLS-1$
							mXML.append(addFolder(currMenuPath,currIconPath,currLev2Descr));
							levelFlag2 = true;
						}
						//added By Nilesh For ressolving open cursor issue Start:01-06-2017
						if(statFolder != null)
						{
							statFolder.close();
							statFolder = null;
						}
					}
					if (!(level3.equals("0"))){ //$NON-NLS-1$
						levelCnt =levelCnt + 1;
						qry="SELECT DESCR,ICON_PATH,MENU_PATH FROM ITM2MENU WHERE APPLICATION='" + appln + "'" +  //$NON-NLS-1$ //$NON-NLS-2$
							"AND LEVEL_1= " + level1+ " AND LEVEL_2= " + level2 + " AND LEVEL_3 = 0 AND LEVEL_4=0 AND LEVEL_5=0"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
						statFolder = conn.createStatement();
						rsFolder = statFolder.executeQuery(qry);
						if(rsFolder.next()){
							currLev3Descr = rsFolder.getString("DESCR"); //$NON-NLS-1$
							currIconPath = rsFolder.getString("ICON_PATH"); //$NON-NLS-1$
							currMenuPath = rsFolder.getString("MENU_PATH"); //$NON-NLS-1$
						}
						//added By Nilesh For ressolving open cursor issue Start:01-06-2017
						if(rsFolder!=null)
						{
							rsFolder.close();
							rsFolder=null;
						}
						//added By Nilesh For ressolving open cursor issue End:01-06-2017
						if (!((prevLev3Descr.equals(currLev3Descr)))){
							if(levelFlag4){
								mXML.append("</FOLDER>"); //$NON-NLS-1$
								levelFlag4 = false;
							}
							if(levelFlag3){
								mXML.append("</FOLDER>"); //$NON-NLS-1$
								levelFlag3 = false;
							}
							if(levelFlag5){
								mXML.append("</FOLDER>"); //$NON-NLS-1$
								levelFlag5 = false;
							}
							prevLev3Descr=currLev3Descr;
							prevLev4Descr="";//Changed by Pramod ion 27-01-11[WI90SUN008 || Improper tree gets generated for certain cases.] //$NON-NLS-1$
							mXML.append(addFolder(currMenuPath,currIconPath,currLev3Descr));
							levelFlag3 = true;
						}
						//added By Nilesh For ressolving open cursor issue Start:01-06-2017
						if(statFolder != null)
						{
							statFolder.close();
							statFolder = null;
						}
					}//level3
					if (!(level4.equals("0"))){ //$NON-NLS-1$
						levelCnt =levelCnt + 1;
						qry="SELECT DESCR,ICON_PATH,MENU_PATH  FROM ITM2MENU WHERE APPLICATION='" + appln + "'" +  //$NON-NLS-1$ //$NON-NLS-2$
							" AND LEVEL_1= " + level1 + " AND LEVEL_2="+ level2 +  //$NON-NLS-1$ //$NON-NLS-2$
							" AND LEVEL_3 = "+ level3 + " AND LEVEL_4=0 AND LEVEL_5=0"; //$NON-NLS-1$ //$NON-NLS-2$
					
						statFolder = conn.createStatement();
						rsFolder = statFolder.executeQuery(qry);
						if(rsFolder.next()){
							currLev4Descr =rsFolder.getString("DESCR"); //$NON-NLS-1$
							currIconPath =rsFolder.getString("ICON_PATH");	 //$NON-NLS-1$
							currMenuPath = rsFolder.getString("MENU_PATH"); //$NON-NLS-1$
						}
						if (!((prevLev4Descr.equals(currLev4Descr)))){
							if(levelFlag4){
								mXML.append("</FOLDER>"); //$NON-NLS-1$
								levelFlag4 = false;
							}
							if(levelFlag5){
								mXML.append("</FOLDER>"); //$NON-NLS-1$
								levelFlag5 = false;
							}
							prevLev4Descr = currLev4Descr;
							prevLev5Descr="";//Changed by Pramod on 27-01-11[WI90SUN008 || Improper tree gets generated for certain cases.] //$NON-NLS-1$
							mXML.append(addFolder(currMenuPath,currIconPath,currLev4Descr));
							levelFlag4 = true;
						}
						statFolder.close();
						statFolder = null;
					}//level4
					if (!(level5.equals("0"))){ //$NON-NLS-1$
						levelCnt =levelCnt + 1;
						qry="SELECT DESCR,ICON_PATH,MENU_PATH  FROM ITM2MENU WHERE APPLICATION='" + appln + "'" +  //$NON-NLS-1$ //$NON-NLS-2$
							" AND LEVEL_1= " + level1 + " AND LEVEL_2="+ level2 +  //$NON-NLS-1$ //$NON-NLS-2$
							" AND LEVEL_3 = "+ level3 + " AND LEVEL_4=" + level4 + " AND LEVEL_5=0"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
						statFolder = conn.createStatement();
						rsFolder = statFolder.executeQuery(qry);
						if(rsFolder.next()){
							currLev5Descr =rsFolder.getString("DESCR"); //$NON-NLS-1$
							currIconPath =rsFolder.getString("ICON_PATH"); //$NON-NLS-1$
							currMenuPath = rsFolder.getString("MENU_PATH"); //$NON-NLS-1$
						}
						//Added by Swapnil Shirke [To resolve NullPointerException]
						//BaseLogger.log("9",null,null,"qry["+qry+"]\nlevel1["+level1+"] level2["+level2+"] level3["+level3+"] level4["+level4+"] ");
						currLev5Descr = (currLev5Descr == null) ? "" : currLev5Descr; //$NON-NLS-1$
						//BaseLogger.log("9",null,null,"prevLev5Descr["+prevLev5Descr+"] currLev5Descr["+currLev5Descr+"]");
						if (!((prevLev5Descr.equals(currLev5Descr)))){
							if(levelFlag5){
								mXML.append("</FOLDER>"); //$NON-NLS-1$
								levelFlag5 = false;
							}
							prevLev5Descr=currLev5Descr;
							mXML.append(addFolder(currMenuPath,currIconPath,currLev5Descr));
							levelFlag5 = true;
						}
						statFolder.close();
						statFolder = null;
					}//level5
				//	BaseLogger.log("9",null,null,"Level Cnt: - ["+levelCnt+"]");
					if(levelCnt == 4){
						if(levelFlag5){
							mXML.append("</FOLDER>"); //$NON-NLS-1$
							levelFlag5 = false;
						}
					}
					if(levelCnt == 3){
						if(levelFlag5){
							mXML.append("</FOLDER>"); //$NON-NLS-1$
							levelFlag5 = false;
						}
						if(levelFlag4){
							mXML.append("</FOLDER>"); //$NON-NLS-1$
							levelFlag4 = false;
						}
					}
					if(levelCnt == 2){
						if(levelFlag5){
							mXML.append("</FOLDER>"); //$NON-NLS-1$
							levelFlag5 = false;
						}
						if(levelFlag4){
							mXML.append("</FOLDER>"); //$NON-NLS-1$
							levelFlag4 = false;
						}
						if(levelFlag3){
							mXML.append("</FOLDER>"); //$NON-NLS-1$
							levelFlag3 = false;
						}
					}
					String tempWinName=winName;
					if(winName !=null){
						if(winName.indexOf("w_")!=-1 ){ //$NON-NLS-1$
							tempWinName = winName.substring(2);
						}
						
						if(winName.indexOf("&amp;") != -1){ //$NON-NLS-1$
							tempWinName = winName.replaceAll("&amp;","&"); //$NON-NLS-1$ //$NON-NLS-2$
						}
					}
					else{
						tempWinName = ""; //$NON-NLS-1$
					}
					if(iconPath != null ){
						if(iconPath.indexOf(".") !=-1){ //$NON-NLS-1$
						//iconPath = iconPath.substring(0,iconPath.indexOf(".")); //Commented by Dnyaneshwar Chavan on 23-JUN-14 [ The file extension not coming for display the menu level icon ]
						}
					}
					else{
						iconPath = ""; //$NON-NLS-1$
					}
					boolean freez = false;
					//freez = checkObjPermission( tempWinName );
					mXML.append("<OPTION id='"+mpath+"' icon='"+iconPath+"'>"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
					mXML.append("<TITLE>"); //$NON-NLS-1$
					mXML.append("<![CDATA["+appDescr+"]]>"); //$NON-NLS-1$ //$NON-NLS-2$
					mXML.append("</TITLE>"); //$NON-NLS-1$
					mXML.append("<OBJNAME>"); //$NON-NLS-1$
					mXML.append("<![CDATA["+tempWinName+"]]>"); //$NON-NLS-1$ //$NON-NLS-2$
					mXML.append("</OBJNAME>"); //$NON-NLS-1$
					mXML.append("<OBJTYPE>"); //$NON-NLS-1$
					mXML.append(objType);
					mXML.append("</OBJTYPE>"); //$NON-NLS-1$
					//Added By Sandesh Shinde on 10-AUG-16 [For default action for menu] start
					mXML.append("<DEFAULT_ACTION>");
					mXML.append(defaultAction);
					mXML.append("</DEFAULT_ACTION>");
					//Added By Sandesh Shinde on 10-AUG-16 [For default action for menu] end
					mXML.append("<DEFAULT_STATE>");
					mXML.append(defaultState);
					mXML.append("</DEFAULT_STATE>");
					//Added By Suraj on 14-12-2016 [ For menu restriction based on condition ]Start
					mXML.append("<FREEZ_MENU>");
					mXML.append(freez);
					mXML.append("</FREEZ_MENU>");
					if( freez )
					{
						mXML.append("<FREEZ_MESSAGE>");
//						mXML.append( CommonConstants.menuRstMsg );
						mXML.append("<![CDATA[]]>");
						mXML.append("</FREEZ_MESSAGE>");
					}
					else
					{
						mXML.append("<FREEZ_MESSAGE>");
						mXML.append("<![CDATA[]]>");
						mXML.append("</FREEZ_MESSAGE>");
					}
					//Added By Suraj on 14-12-2016 [ For menu restriction based on condition ]End
					mXML.append("</OPTION>"); //$NON-NLS-1$
				
				}//if(mpath != null)
			}//rs
			if(levelFlag2){
				mXML.append("</FOLDER>"); //$NON-NLS-1$
				levelFlag2 = false;
			}
			if(levelFlag3){
				mXML.append("</FOLDER>"); //$NON-NLS-1$
				levelFlag3 = false;
			}
			if(levelFlag4){
				mXML.append("</FOLDER>"); //$NON-NLS-1$
				levelFlag4 = false;
			}
			
			//Changes By Prajyot[Issue of menu Tree Generation ] On 20MAR13
			//mXML.append("</APPLICATION>");					 //$NON-NLS-1$
			
			statOption.close();
			statOption = null;
			BaseLogger.log("9",null,null,"(DBAccessEJB:getUserXML)UserXML: Built"); //$NON-NLS-1$
		}
		catch (BaseException basee){ 
			BaseLogger.log("9",null,null,"BaseException: DBAccess: getUserXMLTree: ==>UserXML: Not Built(Generic Exception)\n"); //$NON-NLS-1$
			throw basee;
		}
		catch(SQLException sqle){
			BaseLogger.log("9",null,null,"SQLException: DBAccess: getUserXMLTree: ==>UserXML: Not Built(SQLException)\n" + sqle); //$NON-NLS-1$
			sqle.printStackTrace();
			throw new BaseException(sqle);
		}
		catch (Exception e){ 
			BaseLogger.log("9",null,null,"Exception: DBAccess: getUserXMLTree: ==>UserXML: Not Built(Generic Exception)\n" + e); //$NON-NLS-1$
			throw new BaseException(e);
		}
		finally{
			try{
				if(conn != null){
					if(statOption != null)statOption.close();
					if(rsFolder != null)rsFolder.close();
					conn.close();
					conn = null;
				}
			}
			catch(Exception e){
				BaseLogger.log("9",null,null,"Exception: DBAccess: getUserXMLTree ==>UserXML: Not Built F\n" + e); //$NON-NLS-1$
				throw new BaseException(e);
			}
		}
		clearPermissionList();
		return mXML.toString();
	}*/
	//Added By Suraj on 14-12-2016 [ To restrict menu according to condition ]Start
	private void checkConditionDetails( UserInfoBean userInfo )
	{
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rsCheckCON = null;
		Connection msgConn = null;
		try 
		{
			String isRestrict = "";
			String isAllow = "";
			
			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB(userInfo.getTransDB());
			String usrLevQry = "SELECT * FROM CONDN_ACC_DET ORDER BY SEQ_NO"; 
			pstmt = conn.prepareStatement( usrLevQry );
			rsCheckCON = pstmt.executeQuery( );
			msgConn = connDriver.getConnectDB("Driver");
			while( rsCheckCON.next() )
			{
				String sql_purpose = rsCheckCON.getString("SQL_PURPOSE");
				String condId = rsCheckCON.getString("CONDN_ID");
				int sqlNo = rsCheckCON.getInt("SEQ_NO");
				String condnSql = rsCheckCON.getString("CONDN_SQL");
				String qualRes  = rsCheckCON.getString("QUAL_RES"); // result to be matched
				String sqlInput = rsCheckCON.getString("SQL_INPUT"); //input to CONDN_SQL query
				String msgNo = rsCheckCON.getString("MSG_NO");
				String [] sqlInputArray = sqlInput.trim().split(":");
				 
				//Condition sql executed here
				ResultSet rs = null;
				//added By Nilesh for new prepareStatement Start :: 17-04-18 
				PreparedStatement pstmt1=null;
				//pstmt = conn.prepareStatement(condnSql);
				pstmt1 = conn.prepareStatement(condnSql);
				//added By Nilesh for new prepareStatement Start :: 17-04-18
				for( int i = 0; i< sqlInputArray.length; i++)
				{
					String value = userInfo.getPropValue( sqlInputArray[i] );
					BaseLogger.log("3",userInfo,null,"!!!**** value is ["+value+"]");
					//pstmt.setString(i+1, value );
					pstmt1.setString(i+1, value );
				}
				//rs = pstmt.executeQuery( );
				rs = pstmt1.executeQuery( );
				
				
				while( rs.next() )
				{
					String result = rs.getString(1);
					ResultSetMetaData rsmd = rs.getMetaData();
					String columnName = rsmd.getColumnName(1);
					BaseLogger.log("3",userInfo,null,"!!*** result ["+result+"] qualRes ["+qualRes+"] sqlNo ["+sqlNo+"] columnName ["+columnName+"]");
					
					if( "SEQ_NO".equals(columnName) )
					{
						String key = "SEQ-"+result.trim();
						result = CommonConstants.sequenceResultMap.get( key );
					}
					//If SQL purpose is C then go ahead (if I then stop )
					BaseLogger.log("3",userInfo,null,"!!** 11 purpose ["+sql_purpose+"]");
					
					if( "C".equalsIgnoreCase(sql_purpose.trim()))
					{
						//*************** Condition result match
						if( result.trim().equals( qualRes.trim() ) )
						{
							String sql = "SELECT * FROM CONDN_ACC WHERE CONDN_ID='"+condId.trim()+"'";
							ResultSet rs1 = null;
							//added By Nilesh for new prepareStatement Start :: 17-04-18
							//pstmt = conn.prepareStatement( sql );
							//rs1 = pstmt.executeQuery( ); 
							PreparedStatement pstmt2=null;
							pstmt2 = conn.prepareStatement( sql );
							rs1 = pstmt2.executeQuery( );
							//added By Nilesh for new prepareStatement Start :: 17-04-18 
							
							if( rs1.next() )
							{
								String descr = rs1.getString("DESCR");
								String startupView = rs1.getString("STARTUP_VIEW");
								String objAcc = rs1.getString("OBJ_ACC");
								String accType = rs1.getString("ACC_TYPE");
								String condnStatus = rs1.getString("CONDN_STATUS");
								
								//if( "R".equals(accType.trim()) && "A".equals(condnStatus.trim()) )
								if( "A".equals(condnStatus.trim()) )
								{
									//Changed by Pankaj P on 29/03/2021 [DEVICE_ACC_CLASS related implementation, user device wise menu definition] START
									/*String messageSql = "SELECT MSG_DESCR FROM MESSAGES WHERE MSG_NO='"+msgNo.trim()+"'";
									ResultSet messageRst = null;
									//added By Nilesh for new prepareStatement Start :: 17-04-18 
									PreparedStatement pstmt3=null;
									//pstmt = msgConn.prepareStatement( messageSql );
									//messageRst = pstmt.executeQuery( );
									pstmt3 = msgConn.prepareStatement( messageSql );
									messageRst = pstmt3.executeQuery( );
									//added By Nilesh for new prepareStatement Start :: 17-04-18 
									while( messageRst.next() )
									{
										String alertMsg = messageRst.getString(1);
										CommonConstants.menuRstMsg = alertMsg;
									}
									//Added By nilesh for result set close Start :: 06-04-18
									if(messageRst!=null)
									{
										messageRst.close();
										messageRst=null;
									}
									//Added By nilesh for result set close End :: 06-04-18
									//Added By nilesh for result set close Start :: 17-04-18
									if(pstmt3!=null)
									{
										pstmt3.close();
										pstmt3=null;
									}
									//Added By nilesh for result set close End :: 17-04-18
									*/
									
									String alertMsg = getMessageDescr( msgNo, msgConn, userInfo );
									CommonConstants.menuRstMsg = alertMsg;
									//Changed by Pankaj P on 29/03/2021 [DEVICE_ACC_CLASS related implementation, user device wise menu definition] END
								}
								
								if( "ALL".equals(objAcc.trim()) && "R".equals(accType.trim()))
								{
									CommonConstants.allDisable = "true";
								}
								else
								{
									CommonConstants.allDisable = "false";
								}
								
								//If condition is active then go ahead
								if( "A".equals(condnStatus.trim()))
								{
									if( "R".equals(accType.trim()) )
									{
										//for restrict
									    String [] restrictObjArray = objAcc.trim().split(":");
									    for( String restrtObj : restrictObjArray )
									    {
									    	CommonConstants.restrictObjList.add( restrtObj.trim() );
									    }
									}
									else
									{
										//For allow accType = A
										String [] allowObjArray = objAcc.trim().split(":");
									    for( String allowObj : allowObjArray )
									    {
									    	CommonConstants.allowedObjList.add( allowObj.trim() );
									    }
									}
								}
								else
								{
									//If Condition is InActive comes here
								}
							}
							//Added By nilesh for result set close Start :: 06-04-18
							if(rs1!=null)
							{
								rs1.close();
								rs1=null;
							}
							//Added By nilesh for result set close End :: 06-04-18
							//Added By nilesh for result set close Start :: 17-04-18
							if(pstmt2!=null)
							{
								pstmt2.close();
								pstmt2=null;
							}
							//Added By nilesh for result set close End :: 17-04-18
						}
						//*************** Condition result doesnot match
						else
						{
//							String key = "SEQ-"+sqlNo;
//							CommonConstants.sequenceResultMap.put( key, result);
						}
					}
					else
					{
						//*************** Input and condition match ( this will not happen in case of Input)
						if( result.trim().equals( qualRes.trim() ) )
						{
						}
						//*************** Input and condition does not match
						else
						{
							//result does not match put result in sequence map
							String key = "SEQ-"+sqlNo;
							CommonConstants.sequenceResultMap.put( key, result);
						}
					}
				}
				//Added By nilesh for result set close Start :: 06-04-18
				if(rs!=null)
				{
					rs.close();
					rs=null;
				}
				//Added By nilesh for result set close End :: 06-04-18
				//Added By nilesh for result set close Start :: 17-04-18
				if(pstmt1!=null)
				{
					pstmt1.close();
					pstmt1=null;
				}
				//Added By nilesh for result set close End :: 17-04-18
				
				
				
			}
			//Added By nilesh for result set close Start :: 06-04-18
			if(rsCheckCON!=null)
			{
				rsCheckCON.close();
				rsCheckCON=null;
			}
			//Added By nilesh for result set close End :: 06-04-18
			
			//Added By nilesh for result set close Start :: 06-04-18
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt=null;
			}
			//Added By nilesh for result set close End :: 06-04-18
		}
		catch (Exception e) 
		{
			BaseLogger.log("0",userInfo,null,"Exception while check condition details : "+e.getMessage());
		}
		finally
		{
			try
			{
				if(msgConn != null)
				{
					msgConn.close();
					msgConn = null;
				}
				if(conn != null)
				{
					if(pstmt != null)pstmt.close();
					if(rsCheckCON != null)rsCheckCON.close();
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				BaseLogger.log("9",null,null,"Exception while closing connection condition details :" + e.getMessage()); //$NON-NLS-1$
			}
		}
		BaseLogger.log("3",userInfo,null,"!!*** restrict list ["+CommonConstants.restrictObjList+"]");
		BaseLogger.log("3",userInfo,null,"!!*** allowed list ["+CommonConstants.allowedObjList+"]");
		BaseLogger.log("3",userInfo,null,"!!*** sequence result map ["+CommonConstants.sequenceResultMap+"]");
		BaseLogger.log("3",userInfo,null,"!!*** alert message ["+CommonConstants.menuRstMsg+"]");
	}
	
	private boolean checkObjPermission( String objName, String objType )
	{
		boolean isFreez = false;
		try 
		{
			String value = "";
			if( "I".equals(objType))
			{
				BaseLogger.log("3",null,null,"!!*** objName ["+objName+"]");
				String newStr = objName.substring(objName.indexOf("?")+1);
				if( !(newStr.indexOf("OBJ_NAME") == -1) )
				{
					String[] calData = newStr.split("&");
					for( String data : calData )
					{
						String name = data.substring(0, data.indexOf("="));
						if("OBJ_NAME".equalsIgnoreCase(name) )
						{
							value = data.substring(data.indexOf("=")+1);
							objName = value;
							//BaseLogger.log("9",null,null,"Value is ["+value+"]");
							break;
						}
					}
				}
			}
			
			int restrictSize = CommonConstants.restrictObjList.size();
			int allowedSize = CommonConstants.allowedObjList.size();
			
			if( restrictSize > allowedSize)
			{
				if( CommonConstants.restrictObjList.contains(objName) )
				{
					isFreez = true;
				}
			}
			else if( allowedSize > restrictSize )
			{
				if( CommonConstants.allowedObjList.contains(objName) )
				{
					isFreez = false;
				}
				else
				{
					isFreez = true;
				}
			}
			
//			if( CommonConstants.restrictObjList.contains(objName) )
//			{
//				isFreez = true;
//			}
			if( "true".equalsIgnoreCase( CommonConstants.allDisable ) )
			{
				isFreez = true;
			}
		} 
		catch (Exception e) 
		{
			BaseLogger.log("0",null,null,"Exception while check permission :"+e.getMessage());
		}
		
		return isFreez;
	}
	
	private void clearPermissionList()
	{
		CommonConstants.restrictObjList.clear();
		CommonConstants.allowedObjList.clear();
		CommonConstants.sequenceResultMap.clear();
		CommonConstants.allDisable = "false";
	}
	//Added By Suraj on 14-12-2016 [ To restrict menu according to condition ]End
	//Changed by Dayanand on 16/08/10[To generate menu application wise || MF01SUN001]end
	private String addFolder(String menuPath,String iconPath,String desc) throws RemoteException,BaseException{
		String folderStr=null;
		try{
			if(iconPath !=null && iconPath.indexOf(".") != -1){ //$NON-NLS-1$
				//iconPath = iconPath.substring(0,iconPath.indexOf(".")); //Commented by Dnyaneshwar Chavan on 23-JUN-14 [ The file extension not coming for display the menu level icon ] Start
			}
			else{
				iconPath=""; //$NON-NLS-1$
			}
			folderStr ="<FOLDER id='"+ menuPath +"' icon='"+ iconPath +"'><TITLE><![CDATA["+desc+"]]></TITLE>"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
		}
		catch(Exception e){
			BaseLogger.log("0",null,null,"Exception : CommonDBAccessEJB : addFolder "); //$NON-NLS-1$
			e.printStackTrace();
			throw new BaseException(e);
		}
	return folderStr;
	}
	
	public void updadateRIACacheStatus(String code,String riaFlag,String updateType) throws RemoteException,BaseException
	{
		Connection conn = null;
		PreparedStatement pstat = null;
		try
		{
			BaseLogger.log("3",null,null,"CommonDBAccess  : updadateRIACacheStatus ..........."); //$NON-NLS-1$
			ConnDriver mConnDriver = new ConnDriver();
			conn = mConnDriver.getConnectDB("Driver");			 //$NON-NLS-1$
			String sqlQuery = "UPDATE USERS SET RIA_CACHE_STATUS = ? WHERE CODE = '"+code+"'"; //$NON-NLS-1$
			if(updateType.equalsIgnoreCase("P")){ //$NON-NLS-1$
				//Changed by Sagar B. for multiple profile id related changes[11-Dec-17]
				//sqlQuery = "UPDATE USERS SET RIA_CACHE_STATUS = ? WHERE PROFILE_ID = ?"; //$NON-NLS-1$
				sqlQuery = "UPDATE USERS SET RIA_CACHE_STATUS = ? WHERE PROFILE_ID IN "+ E12GenericUtility.getFormattedProfileId(code); //$NON-NLS-1$
			}
			pstat = conn.prepareStatement(sqlQuery);
			pstat.setString(1, riaFlag);
			//pstat.setString(2,code);
			int rowCnt = pstat.executeUpdate();
			if(rowCnt !=0)
			{
				BaseLogger.log("3",null,null,"RIA_CAHCE_STATUS is updated successfully........."); //$NON-NLS-1$
			}
			else{
				BaseLogger.log("3",null,null,"RIA_CAHCE_STATUS NOT updated ........."); //$NON-NLS-1$
			}
			pstat.close();
			pstat= null;
			conn.commit();
		}
		catch( BaseException be )
		{
			BaseLogger.log("0",null,null,"Exception: updadateRIACacheStatus:==>\n"+be); //$NON-NLS-1$
			try
			{
				conn.rollback();
			}
			catch (Exception sqle )
			{
				throw new BaseException( sqle );
			}	
			throw be;
		}
		catch(Exception e)
		{
			BaseLogger.log("0",null,null,"Exception :CommonDBAccessEJB :updadateRIACacheStatus :==>\n"+e); //$NON-NLS-1$
			try
			{
				conn.rollback();
			}
			catch (Exception sqle )
			{
				throw new BaseException( sqle );
			}	
			throw new BaseException( e );
		}
		finally
		{
			try
			{
				if (conn != null)
				{
					if(pstat != null)
					{
						pstat.close();
						pstat = null;
					}
					conn.close();
					conn = null;
				}	
			}
			catch (Exception e)
			{
				throw new BaseException( e );
			}
		}
	}
	//Changed by Rupali on 21/08/2008 to generate the menu tree for RIA.Request ID[BI89BAS010].End
	//Changed By Rupali Hande on 24/03/08[Remove dependacy of AuthenticateServlet from webitem]. Request ID[BI78SUN047].End
	//Changed by Dayanand on 25/08/09[ WS89BAS029 || Update loginTrace]start
	public void updateLoginTrace( String loginCode , String sessionId)throws BaseException
	{
		Connection mConnection = null;
		PreparedStatement mStatement = null;
		try
		{
			ConnDriver mConnDriver = new ConnDriver();
			mConnection = mConnDriver.getConnectDB("Driver");	 //$NON-NLS-1$
			//Changed By Pankaj T. on 24-07-19 for unable to update record when userId contains blank space
			loginCode = E12GenericUtility.checkNull(getUserCode(loginCode));
			BaseLogger.log("3",null,null,"getAutoCommit::[" + mConnection.getAutoCommit() +"]"); //$NON-NLS-1$ //$NON-NLS-2$
			java.sql.Timestamp currTime =new java.sql.Timestamp(System.currentTimeMillis());
			String query = "UPDATE LOGINTRACE SET LOGOUTTIME = ? , SESSION_DESTROY = ? WHERE USERID=? AND SESSIONID = ? "; //$NON-NLS-1$
			mStatement = mConnection.prepareStatement(query);
			mStatement.setTimestamp(1,currTime);
			mStatement.setString(2,"Y"); //$NON-NLS-1$
			mStatement.setString(3,loginCode);
			mStatement.setString(4,sessionId);

			int rowCnt = mStatement.executeUpdate();				
			BaseLogger.log("3",null,null, "LOGIN TRACE UPDATED :"+rowCnt ); //$NON-NLS-1$

			mStatement.close();
			mStatement = null;
			mConnection.commit();
		}
		catch ( Exception e)
		{
			//Changes made by Gulzar on 06/06/13 to avoide deadlock : START
			try
			{
				mConnection.rollback();
			}
			catch(Exception r)
			{
				r.printStackTrace();
			}
			//Changes made by Gulzar on 06/06/13 to avoide deadlock : END
			throw new BaseException( e );
		}
		finally
		{
			try
			{
				if (mConnection != null)
				{
					if(mStatement != null)
					{
						mStatement.close();
						mStatement = null;
					}
					mConnection.close();
					mConnection = null;
				}	
			}
			catch (Exception e)
			{
				throw new BaseException( e );
			}
		}
	}
	//Changed by Dayanand on 25/08/09[ WS89BAS029 || Update loginTrace]End
	//Changed by Swapnil Shirke on 01-Jul-2010 [to add stan_code__hq, designation, dateOfJoining, division in userInfo][WS90SUN043] starts
	//Added by Pankaj T on 12-01-18 [changes for multitenancy]
	private String getDivision(String itemSer, String transDB) throws RemoteException, BaseException
	{
		//BaseLogger.log("9",null,null,"Getting item series for entityCode :"+itemSer+":");
		String division = ""; //$NON-NLS-1$
		ConnDriver connDriver = null;
		Connection conn = null;
		Statement stmt = null;
		ResultSet rs = null;
		String query = null;
			
		try
		{	
			connDriver = new ConnDriver();
			//Added by Pankaj T on 12-01-18 [changes for multitenancy]
			conn = connDriver.getConnectDB(transDB); //$NON-NLS-1$
			query = "SELECT DESCR AS DIVISION FROM ITEMSER WHERE ITEM_SER = '"+itemSer+"'"; //$NON-NLS-1$ //$NON-NLS-2$
			stmt = conn.createStatement();
			BaseLogger.log("3",null,null,"[CommonDBAccessEJB]Getting division code, query :\n"+query); //$NON-NLS-1$
			rs = stmt.executeQuery(query);
			
			while(rs.next())
			{
				division = rs.getString(1);
			}
			stmt.close();
			stmt = null;
		}
		catch (SQLException sqle)
		{ 
			BaseLogger.log("0",null,null,"SQLException :CommonDBAccessEJB :getDivision :==>"); //$NON-NLS-1$
			sqle.printStackTrace();
			throw new ITMException(sqle);
		}
		catch (BaseException basee)
		{ 
			BaseLogger.log("0",null,null,"BaseException :CommonDBAccessEJB :getDivision :==>"); //$NON-NLS-1$
			basee.printStackTrace();
			
		}
		catch (Exception e)
		{ 
			BaseLogger.log("0",null,null,"Exception :CommonDBAccessEJB :getDivision :==>"+e); //$NON-NLS-1$
			e.printStackTrace();
			
		}
		finally
		{
			try
			{
				if(conn != null)
				{					
					if(stmt != null)
					{
						stmt.close();
					}
					conn.close();
					conn = null;
				}				
			}
			catch(Exception e)
			{
				BaseLogger.log("0",null,null,"Exception :CommonDBAccessEJB :getDivision :==>"+e); //$NON-NLS-1$
				throw new BaseException(e);
			}
		}
		BaseLogger.log("2",null,null,"[CommonDBAccessEJB]Division :"+division); //$NON-NLS-1$
		return division;
	}
	//Changed by Swapnil Shirke on 01-Jul-2010 [to add stan_code__hq, designation, dateOfJoining, division in userInfo][WS90SUN043] ends
	
	//Changed by Gayatri Yadav on 16-Sept-2010 [ WI01SUN006 ] [ To implement SHA-256 while login ] starts
	private String convertIntoSHA256(String dpwd)
	{
		StringBuffer hexString = new StringBuffer();
		try
		{
			MessageDigest md = MessageDigest.getInstance("SHA-256"); //$NON-NLS-1$
	       	md.update(dpwd.getBytes(CommonConstants.ENCODING)); //$NON-NLS-1$
	   		byte byteData[] = md.digest();
	   		//convert the byte to hex format method 1
	   		for (int i=0;i<byteData.length;i++)
	   		{
	       		String hex=Integer.toHexString(0xff & byteData[i]);
	   	  		if(hex.length()==1) hexString.append('0');
	   	  		hexString.append(hex);
	    	}
			//BaseLogger.log("9",null,null,"Hex format : " + hexString.toString());
		}
		catch(Exception e)
		{
			BaseLogger.log("0",null,null,e);
		}
	    return hexString.toString();
	}
	//Changed by Gayatri Yadav on 16-Sept-2010 [ WI01SUN006 ] [ To implement SHA-256 while login ] ends
	//Change by Nilesh on 02-Feb-11 [SY90SUN016][To retrive password] Start
	public String checkEmpStatus( String user ) throws RemoteException, BaseException
	{
		Connection mConnection = null;
		Statement mStatement1 = null;
		ResultSet mResultSet1 = null;
		Statement mStatement2 = null;
		ResultSet mResultSet2 = null;
		int count = 0;
		String status = "N"; //$NON-NLS-1$
		try
		{
			//BaseLogger.log("9",null,null,"USER ["+user+"]");
			ConnDriver mConnDriver = new ConnDriver();
			mConnection = mConnDriver.getConnectDB("Driver"); //$NON-NLS-1$
			String sqlQuery = "SELECT COUNT(1) FROM USERS WHERE CODE = '"+ user +"'"; //$NON-NLS-1$ //$NON-NLS-2$
			mStatement1 = mConnection.createStatement();
			mResultSet1 = mStatement1.executeQuery(sqlQuery);
			if(mResultSet1.next())
			{
				count = Integer.parseInt( mResultSet1.getString(1) );
				if( count != 0 )
				{   
					//Changed By Yogesh on 06/05/11 [SY1BSUN004| Authentication happen from users table]
					//sqlQuery = "SELECT STATUS FROM EMPLOYEE WHERE EMP_CODE = (SELECT EMP_CODE FROM USERS WHERE CODE = '"+user+"')";
					sqlQuery = "SELECT STATUS FROM USERS WHERE CODE = '"+user+"'"; //$NON-NLS-1$ //$NON-NLS-2$
					mStatement2 = mConnection.createStatement();
					mResultSet2 = mStatement2.executeQuery(sqlQuery);
					if(mResultSet2.next())
					{ 
						//Changed By Yogesh on 06/05/11 [SY1BSUN004| Authentication happen from users table]
						//status = mResultSet2.getString(1) ;
						status = mResultSet2.getString(1) != null ? mResultSet2.getString(1) : "" ; //$NON-NLS-1$
					}
				}
			}
		}
		catch(Exception e)
		{
			BaseLogger.log("0",null,null,"Exception :CommonDBAccessEJB :secureAccount :==>\n"+e); //$NON-NLS-1$
		}
		finally
		{
			try
			{
				if( mResultSet2 != null )
				{
					mResultSet2.close();
					mResultSet2 = null;
				}
				if( mStatement2 != null )
				{
					mStatement2.close();
					mStatement2 = null;
				}
				if( mResultSet1 != null )
				{
					mResultSet1.close();
					mResultSet1 = null;
				}
				if( mStatement1 != null )
				{
					mStatement1.close();
					mStatement1 = null;
				}
				if( mConnection != null )
				{
					mConnection.close();
					mConnection = null;
				}
			}
			catch (Exception e)
			{
				throw new BaseException( e );
			}
		}
		return status.trim();
	}
	//Yogesh on 15-06-11 [SY1BSUN004 | to get deactivate_date of user from users master].start
	public java.util.Date checkEmpDeactDate( String user ) throws RemoteException, BaseException
	{
		Connection mConnection = null;
		Statement mStatement = null;
		ResultSet mResultSet = null;
		Statement mStatementDeact = null;
		ResultSet mResultSetDeact = null;
		int count = 0;
		java.util.Date retDeactDate = null;
		try
		{
			//BaseLogger.log("9",null,null,"checkEmpDeactDate : USER ["+user+"]");
			ConnDriver mConnDriver = new ConnDriver();
			mConnection = mConnDriver.getConnectDB("Driver"); //$NON-NLS-1$
			String sqlQuery1 = "SELECT COUNT(1) FROM USERS WHERE CODE = '"+ user +"'"; //$NON-NLS-1$ //$NON-NLS-2$
			mStatement = mConnection.createStatement();
			mResultSet = mStatement.executeQuery(sqlQuery1);
			if(mResultSet.next())
			{
				count = Integer.parseInt( mResultSet.getString(1) );
				if( count != 0 )
				{   					
					String sqlQueryDeact = "SELECT DEACTIVATE_DATE FROM USERS WHERE CODE = '"+user+"'"; //$NON-NLS-1$ //$NON-NLS-2$
					mStatementDeact = mConnection.createStatement();
					mResultSetDeact = mStatementDeact.executeQuery(sqlQueryDeact);
					if(mResultSetDeact.next())
					{ 						
						retDeactDate = mResultSetDeact.getDate(1) ;
					}
				}
			 }
			//BaseLogger.log("9",null,null,"checkEmpDeactDate : retDeactDate :["+retDeactDate+"]");
		}
		catch (Exception e )
		{
		   e.printStackTrace(); 
		}
		finally
		{

			try
			{
				if( mResultSetDeact != null )
				{
					mResultSetDeact.close();
					mResultSetDeact = null;
				}
				if( mStatementDeact != null )
				{
					mStatementDeact.close();
					mStatementDeact = null;
				}
				if( mResultSet != null )
				{
					mResultSet.close();
					mResultSet = null;
				}
				if( mStatement != null )
				{
					mStatement.close();
					mStatement = null;
				}
				if( mConnection != null )
				{
					mConnection.close();
					mConnection = null;
				}
			}
			catch (Exception e)
			{
				throw new BaseException( e );
			}
			
		}
		return retDeactDate;
	}
	//Yogesh on 15-06-11 [SY1BSUN004 | to get deactivate_date of user from users master].end
	
	public void updatePasswordChgLog( String userID, String chgTerm, String chgClientID ) throws RemoteException, BaseException
	{
		Connection mConnection = null;
		Statement mStatement = null;
		PreparedStatement pStatement = null;
		Statement mStatement1 = null;
		ResultSet mResultSet = null;
		try
		{
			String tranID = null;
			java.util.Date date = new  java.util.Date();
			//Changed By Yogesh on 06/05/11 [SY1BSUN004| Authentication happen from users table]
			//SimpleDateFormat formatter=  new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
			SimpleDateFormat formatter=  new SimpleDateFormat(CommonConstants.DB_DATETIME_FORMAT);
			String currentDate = formatter.format(date.getTime());
			java.sql.Timestamp requestDate = java.sql.Timestamp.valueOf(currentDate.trim());
			//BaseLogger.log("9",null,null,"USER ["+userID+"]");
			ConnDriver mConnDriver = new ConnDriver();
			mConnection = mConnDriver.getConnectDB("Driver");								 //$NON-NLS-1$
			String nextTranIDQuery = "select PWD_CHG_LOG_SEQ.NEXTVAL from dual"; //$NON-NLS-1$
			mStatement = mConnection.createStatement();
			mResultSet = mStatement.executeQuery(nextTranIDQuery);
			if(mResultSet.next())
			{
				tranID = mResultSet.getString(1);
			}
			String insertQuery = "INSERT INTO PWD_CHG_LOG (TRAN_ID , USER_ID , CHG_TERM , CHG_DATE , CHG_CLIENT_ID) VALUES( ?, ?, ?, ?, ?)"; //$NON-NLS-1$
			//BaseLogger.log("9",null,null,"Insert query ["+insertQuery+"]");
			pStatement = mConnection.prepareStatement( insertQuery );
			pStatement.setString(1, tranID);
			pStatement.setString(2, userID);
			pStatement.setString(3, chgTerm);
			pStatement.setTimestamp(4, requestDate);
			pStatement.setString(5, chgClientID);
			
			int result = pStatement.executeUpdate();
			if ( result > 0 && result != 0 )
			{
				BaseLogger.log("3",null,null,"Status Upadted"); //$NON-NLS-1$
			}
			//Changed By Yogesh on 06/05/11 [SY1BSUN004|Authentication happen from users table]
			//String updateQuery = "UPDATE USERS SET LOGIN_FIRST = '1' WHERE CODE='" + userID + "'";
			String updateQuery = "UPDATE USERS SET LOGIN_FIRST = '1', ACCT_LOCK = 'N' WHERE CODE='" + userID + "'"; //$NON-NLS-1$ //$NON-NLS-2$
			//BaseLogger.log("9",null,null,"Insert query ["+updateQuery+"]");
			mStatement1 = mConnection.createStatement();
			mStatement1.executeUpdate(updateQuery);
			mConnection.commit();
		}
		catch(Exception e)
		{
			BaseLogger.log("0",null,null,"Exception :CommonDBAccessEJB :secureAccount :==>\n"+e); //$NON-NLS-1$
		}
		finally
		{
			try
			{
				if( mStatement1 != null )
				{
					mStatement1.close();
					mStatement1 = null;
				}
				if( mResultSet != null )
				{
					mResultSet.close();
					mResultSet = null;
				}
				if( mStatement != null )
				{
					mStatement.close();
					mStatement = null;
				}
				if( mConnection != null )
				{
					mConnection.close();
					mConnection = null;
				}
			}
			catch (Exception e)
			{
				throw new BaseException( e );
			}
		}
	}
	//Change by Nilesh on 02-Feb-11 [SY90SUN016][To retrive password] End
	//Added by Nilesh on 25-Mar-2011 [SY01SUN038][Validate password from PASS_WD_SHA]Start
	private void updatePassWdSha( String mUserID, String pwd ) 
	{
		ConnDriver mConnDriver = null;
		Connection mConnection = null;
		PreparedStatement pstmt = null;
		try
		{
			mConnDriver = new ConnDriver();
			mConnection = mConnDriver.getConnectDB("Driver"); //$NON-NLS-1$
			// Changed by Sandesh Shinde on 17-MAY-2017 [ Authentication API: SQL Injection] Start
			String sqlQuery = "UPDATE USERS SET PASS_WD_SHA = ? WHERE CODE = ?"; //$NON-NLS-1$ //$NON-NLS-2$
			pstmt = mConnection.prepareStatement( sqlQuery );
			pstmt.setString( 1, convertIntoSHA256( pwd ) );
			pstmt.setString( 2, mUserID );
			// Changed by Sandesh Shinde on 17-MAY-2017 [ Authentication API: SQL Injection] End
			pstmt.executeUpdate();
			mConnection.commit();
		}
		catch (Exception e)
		{
			BaseLogger.log("0",null,null,"Exception :: "+ e.getMessage() ); //$NON-NLS-1$
		}
		finally
		{
			try
			{
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if( mConnection != null )
				{
					mConnection.close();
					mConnection = null;
				}
			}
			catch (Exception e)
			{
				BaseLogger.log("0",null,null,"Exception :: "+ e.getMessage() ); //$NON-NLS-1$
			}
		}
	}
	//Added by Nilesh on 25-Mar-2011 [SY01SUN038][Validate password from PASS_WD_SHA]End
	//Added by Nilesh on 29-Mar-2011[SY01SUN049][Varify user before chg password]Start
	//Added by Pravin K on 1-MAR-19 [for OTP appHash] START
	public String sendVarificationCode(String user) throws RemoteException, BaseException {
		return sendVarificationCode(user, null);
	}
	//Added by Pravin K on 1-MAR-19 [for OTP appHash] START

	public String sendVarificationCode(String user, String applicationHashCode) throws RemoteException, BaseException {
		return sendVarificationCode(user, applicationHashCode, false);
	}
	
	//Added By Pankaj T. on 19-07-2022 [Added new column ver_code in users table for maintain forgot password verification code to resend the same when next request trigger in predefined interval]
	public String sendVarificationCode(String user, String applicationHashCode, boolean resendUsersVerCode ) throws RemoteException, BaseException
	{
		Connection mConnection = null;
		PreparedStatement pStatement = null;
		ResultSet mResultSet = null;
		/*
		//changed by Gulzar on 09/06/16 : START
		//If PASSWORDCOMPLEXITY == 1 then 4 digit randaom will be generate.
		//this changes is made to support in mobile device.
		int number = 1;
		String passWdComplexity = CommonConstants.PASSWORDCOMPLEXITY;
		BaseLogger.log("2",null,null,"passWdComplexity =["+passWdComplexity+"]");
		if("1".equals(passWdComplexity))
		{
			number = new Random().nextInt(9000) + 1000;
		}
		else
		{
			number = new Random().nextInt();
		}
		BaseLogger.log("3",null,null,"OTP =["+number+"]");
		//changed by Gulzar on 09/06/16 : END
		
		if( number < 1 )
		{
			number = -number;
		}
		String varCode = Integer.toString( number ); 
		*/
		//Changed By Pankaj T. on 18-09-19 for getting PASSWORD_COMPLEXITY against user defined ENTERPRISE instead of ibase.xml
		
		//Added By Pankaj T. on 19-07-2022 [Added new column ver_code in users table for maintain forgot password verification code to resend the same when next request trigger in predefined interval]
		String varCode = "";
		if( resendUsersVerCode )
		{
			varCode = getDBColumnValue("USERS", "VER_CODE", " WHERE CODE = '"+user+"'");
		}
		else
		{
			varCode = generateOTP(user);
		}
		//Added By Pankaj T. on 19-07-2022 [Added new column ver_code in users table for maintain forgot password verification code to resend the same when next request trigger in predefined interval]
		try
		{
			//Added by Pankaj T on 12-01-18 [changes for multitenancy]
			//Changed by Pooja S on 6-NOV-2020 [passord should sent from common definition, not from enterprise]
			UserInfoBean userInfo = createUserInfo( user, "code", false );
			BaseLogger.log("3",null,null,"transDB in CommonDBAccessEJB sendVarificationCode["+userInfo.getTransDB()+"]");
			ConnDriver mConnDriver = new ConnDriver();
			mConnection = mConnDriver.getConnectDB("Driver"); 
			/*changed by Pankaj Tajane on 20/05/2016 for selecting preffered communication way EMAIL/SMS [S16ASER002] :Start*/
			E12SMSComp e12smsComp = new E12SMSComp();	
			//Changed by Santosh on 27-10-2017 to read SEC_COMM_MODE from profile master to send verification code to mobile/Email
			//String sqlQuerry = "SELECT MOBILE_NO,EMAIL_ID FROM USERS WHERE CODE = ?";
			//Changed by Santosh om 31-10-2017 to read sec_comm_mode from profile master
			//String sqlQuerry = "SELECT U.MOBILE_NO,U.EMAIL_ID,P.SEC_COMM_MODE,U.USER_TYPE,U.ENTITY_CODE FROM USERS U, PROFILE P WHERE U.PROFILE_ID=P.PROFILE_ID AND CODE = ?";
			String sqlQuerry = "SELECT MOBILE_NO, EMAIL_ID, USER_TYPE, ENTITY_CODE FROM USERS U WHERE CODE = ?";
			pStatement = mConnection.prepareStatement(sqlQuerry);
			pStatement.setString(1, user);
			mResultSet = pStatement.executeQuery();
			if(mResultSet.next())
			{
				String mobileNo = E12GenericUtility.checkNull(mResultSet.getString(1));
				String toAdd = E12GenericUtility.checkNull(mResultSet.getString(2));
				//Added by Santosh on 27-10-2017 to read SEC_COMM_MODE from profile master to send verification code to mobile/Email
				//Changes by Santosh on 31-10-2017
				//String secCommMode = E12GenericUtility.checkNull(mResultSet.getString(3));
				String secCommMode = getSecurityCommMode(user);
				BaseLogger.log("3",null,null,"secCommMode["+secCommMode+"]");
				String userType = E12GenericUtility.checkNull(mResultSet.getString(3));
				String entityCode = E12GenericUtility.checkNull(mResultSet.getString(4));
				//Added by Pankaj T on 12-01-18 [changes for multitenancy]
				List<String> sendToMobNoEmailList = getMobileEmailDetails(userType, entityCode, userInfo);
				String entityMobileNo = "", entityEmailId = "";
				if(sendToMobNoEmailList!=null)
				{
					entityMobileNo = sendToMobNoEmailList.get(0);
					//entityEmailId = sendToMobNoEmailList.get(1);
				}
				BaseLogger.log("3",null,null,"entityMobileNo["+entityMobileNo+"] entityEmailId["+entityEmailId+"]");
				//Changed by Santosh on 27-10-2017 to read SEC_COMM_MODE from profile master to send verification code to mobile/Email [Start]
				if(!"".equalsIgnoreCase(secCommMode))
				{
					if("0".equalsIgnoreCase(secCommMode) || "1".equalsIgnoreCase(secCommMode))
					{
						BaseLogger.log("3",null,null,"CommonConstants.PREFFERED_COMM IN SMS::"+CommonConstants.PREFFERED_COMM);
						if(("".equals(entityMobileNo)) || (!"".equals(entityMobileNo)) )
						{
							String formatCode="USER_FORMAT";
							String xtraParams = "loginCode="+user+"~~loginEmpCode"+user;
							StringBuffer valueXmlString = new StringBuffer( "<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header></Header>\r\n<Errors></Errors>\r\n" );
							valueXmlString.append( "<Detail1 objName = 'user_authenticate'>\r\n" );
							//Changed by Santosh on 27-10-2017 to lookup mobile number from entityCode
							//valueXmlString.append( "<code><![CDATA[" ).append(user).append( "]]></code>\r\n" );
							valueXmlString.append( "<code><![CDATA[" ).append(entityCode).append( "]]></code>\r\n" );
							valueXmlString.append( "<OTP><![CDATA[" ).append(varCode).append( "]]></OTP>\r\n" );
							valueXmlString.append( "<APP_HASH><![CDATA[" ).append(applicationHashCode).append( "]]></APP_HASH>\r\n" );//Added by Pravin K on 28-FEB-19 
							valueXmlString.append( "</Detail1>\r\n" );
							valueXmlString.append( "</Root>\r\n" );
							//Added by Pankaj T on 19-12-17 [for multitenancy pass userinfoBean object]
							String smsresp = e12smsComp.sendSMS(valueXmlString.toString(), formatCode, xtraParams,SMSType.OTP, userInfo);//PA
							//String smsresp = e12smsComp.sendSMS(valueXmlString.toString(), formatCode, xtraParams);
							BaseLogger.log("3",null,null,"sms response::"+smsresp);
						}
						else
						{		
							BaseLogger.log("9",null,null,"Warning: Mobile no is null For User :"+user+": !!!");
							//EMail emailObj = new EMail();
							//StringBuffer mailInfoXml = new StringBuffer("<MAILINFO>");
							if (!("".equals(toAdd)))
							{
								// Added and Commented by Pankaj R on 16-Sep-20 to show the mail dynamically from mail_format [START]
                                String formatCode = "FORGOT_PASSWORD";
								/*mailInfoXml.append("<TO_ADD><![CDATA["+toAdd+"]]></TO_ADD>"); 
								String sub =Messages.getString("CommonDBAccessEJB_yourVerificationCodeForUserID")+user; 
								mailInfoXml.append("<SUBJECT><![CDATA["+sub+"]]></SUBJECT>"); 
								String msg = Messages.getString("CommonDBAccessEJB_yourVerificationCode")+varCode; 
								mailInfoXml.append("<MESSAGE><![CDATA["+msg+"]]></MESSAGE>"); 
								mailInfoXml.append("</MAILINFO>");
								//Added by Pankaj T on 12-01-18 [changes for multitenancy] 
                                emailObj.sendMail(mailInfoXml.toString(),null, userInfo);*/
                                sendPasswdVerificationMail(varCode, toAdd, formatCode, userInfo);
                                // Added and Commented by Pankaj R on 16-Sep-20 to show the mail dynamically from mail_format [END] 
							}
							else
							{
								BaseLogger.log("3",null,null,"Warning: Email Id is null For User ["+user+"] !!!");
							}										
						}
					}
					
					if("0".equalsIgnoreCase(secCommMode) || "2".equalsIgnoreCase(secCommMode))
					{
						BaseLogger.log("3",null,null,"CommonConstants.PREFFERED_COMM IN EMAIL:: "+CommonConstants.PREFFERED_COMM);
						//EMail emailObj = new EMail();
                        // StringBuffer mailInfoXml = new StringBuffer("<MAILINFO>");
                        if (!("".equals(toAdd))) 
						{
							//Changes done by Sanket J on 20/02/17 [for Calling Message subject and body from Mail_Format]-start
							String forgotPass = "FORGOT_PASSWORD";
							// Added and Commented by Pankaj R on 16-Sep-20 to show the mail dynamically from mail_format [START]
							/*String condition = " WHERE FORMAT_CODE ='"+forgotPass+"'";
							//Added by Pankaj T on 12-01-18 [changes for multitenancy]
							//Changed by Pankaj T. on 09-01-2019 pass user specific transDB - start
							String subject = getDBColumnValue("MAIL_FORMAT", "SUBJECT", condition, userInfo.getTransDB());
							//Change by shrurtika on 04-08-2020 [Start] for forgot password functionality no working properly when BODY_TEXT as blank(it append null string before verification code and new password)
							//String bodyText = getDBColumnValue("MAIL_FORMAT", "BODY_TEXT", condition, userInfo.getTransDB());
							//String bodyText = E12GenericUtility.checkNull(getDBColumnValue("MAIL_FORMAT", "BODY_TEXT", condition, userInfo.getTransDB()));
							//Changed by Pankaj T. on 09-01-2019 pass user specific transDB - end
							//mailInfoXml.append("<TO_ADD><![CDATA["+toAdd+"]]></TO_ADD>"); 
							//String sub =Messages.getString("CommonDBAccessEJB_yourVerificationCodeForUserID")+user; 
							//mailInfoXml.append("<SUBJECT><![CDATA["+sub+"]]></SUBJECT>"); 
							// mailInfoXml.append("<SUBJECT><![CDATA["+subject+"]]></SUBJECT>"); 
							//String msg = Messages.getString("CommonDBAccessEJB_yourVerificationCode")+varCode; 
							//mailInfoXml.append("<MESSAGE><![CDATA["+(bodyText+varCode)+"]]></MESSAGE>"); 
							//mailInfoXml.append("<MESSAGE><![CDATA["+msg+"]]></MESSAGE>"); 
							//mailInfoXml.append("</MAILINFO>"); 
							//BaseLogger.log("3",null,null,"mailInfoXml IN EMAIL:: "+ mailInfoXml);
							//Added by Pankaj T on 12-01-18 [changes for multitenancy]
							//emailObj.sendMail(mailInfoXml.toString(),null, userInfo);*/
                            //Changes done by Sanket J on 20/02/17 [for Calling Message subject and body from Mail_Format]-End
                            sendPasswdVerificationMail(varCode, toAdd, forgotPass, userInfo);
                            // Added and Commented by Pankaj R on 16-Sep-20 to show the mail dynamically from mail_format [END]
						}
						else
						{
							BaseLogger.log("3",null,null,"Warning: Email ID is null For User :"+user+": !!!!!");
							if(("".equals(entityMobileNo)) || (!"".equals(entityMobileNo)) )
							{
								String formatCode="USER_FORMAT";
								String xtraParams = "loginCode="+user+"~~loginEmpCode"+user;
								StringBuffer valueXmlString = new StringBuffer( "<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header></Header>\r\n<Errors></Errors>\r\n" );
								valueXmlString.append( "<Detail1 objName = 'user_authenticate'>\r\n" );
								//Changed by Santosh on 27-10-2017 to lookup mobile number from entityCode
								//valueXmlString.append( "<code><![CDATA[" ).append(user).append( "]]></code>\r\n" );
								valueXmlString.append( "<code><![CDATA[" ).append(entityCode).append( "]]></code>\r\n" );
								valueXmlString.append( "<OTP><![CDATA[" ).append(varCode).append( "]]></OTP>\r\n" );
								valueXmlString.append( "<APP_HASH><![CDATA[" ).append(applicationHashCode).append( "]]></APP_HASH>\r\n" );
								valueXmlString.append( "</Detail1>\r\n" );
								valueXmlString.append( "</Root>\r\n" );
								String smsresp = e12smsComp.sendSMS(valueXmlString.toString(), formatCode, xtraParams, SMSType.OTP, userInfo);
								BaseLogger.log("3",null,null,"sms response::::"+smsresp);
							}
							else
							{
								BaseLogger.log("3",null,null,"Warning: Mobile no is null For User :"+user+": !!!!!");
							}
						}
					}
				}
				else
				{
					if("SMS".equalsIgnoreCase(CommonConstants.PREFFERED_COMM))
					{
						BaseLogger.log("3",null,null,"CommonConstants.PREFFERED_COMM IN SMS : "+CommonConstants.PREFFERED_COMM);//
						if(!("".equals(mobileNo)))
						{
							String formatCode="USER_FORMAT";
							String xtraParams = "loginCode="+user+"~~loginEmpCode"+user;
							StringBuffer valueXmlString = new StringBuffer( "<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header></Header>\r\n<Errors></Errors>\r\n" );
							valueXmlString.append( "<Detail1 objName = 'user_authenticate'>\r\n" );
							//Changed by Santosh on 27-10-2017 to lookup mobile number from entityCode
							//valueXmlString.append( "<code><![CDATA[" ).append(user).append( "]]></code>\r\n" );
							valueXmlString.append( "<code><![CDATA[" ).append(entityCode).append( "]]></code>\r\n" );
							valueXmlString.append( "<OTP><![CDATA[" ).append(varCode).append( "]]></OTP>\r\n" );
							valueXmlString.append( "<APP_HASH><![CDATA[" ).append(applicationHashCode).append( "]]></APP_HASH>\r\n" ); 
							valueXmlString.append( "</Detail1>\r\n" );
							valueXmlString.append( "</Root>\r\n" );
							BaseLogger.log("3",null,null,"sms valueXmlString ::: "+valueXmlString);
							String smsresp = e12smsComp.sendSMS(valueXmlString.toString(), formatCode, xtraParams,SMSType.OTP, userInfo);
							BaseLogger.log("3",null,null,"sms response:::"+smsresp);
						}
						else
						{		
							BaseLogger.log("3",null,null,"Warning: Mobile no is null For User :"+user+": !!!");
							//EMail emailObj = new EMail();
							//StringBuffer mailInfoXml = new StringBuffer("<MAILINFO>");
							if (!("".equals(toAdd)))
							{
								// Added and Commented by Pankaj R on 16-Sep-20 to show the mail dynamically from mail_format [START]
                                String formatCode = "FORGOT_PASSWORD";
								/*mailInfoXml.append("<TO_ADD><![CDATA["+toAdd+"]]></TO_ADD>"); 
								String sub =Messages.getString("CommonDBAccessEJB_yourVerificationCodeForUserID")+user; 
								mailInfoXml.append("<SUBJECT><![CDATA["+sub+"]]></SUBJECT>"); 
								String msg = Messages.getString("CommonDBAccessEJB_yourVerificationCode")+varCode; 
								mailInfoXml.append("<MESSAGE><![CDATA["+msg+"]]></MESSAGE>"); 
								mailInfoXml.append("</MAILINFO>");
								//Added by Pankaj T on 12-01-18 [changes for multitenancy] 
                                emailObj.sendMail(mailInfoXml.toString(),null, userInfo);*/
                                sendPasswdVerificationMail(varCode, toAdd, formatCode, userInfo);
                                // Added and Commented by Pankaj R on 16-Sep-20 to show the mail dynamically from mail_format [END]
							}
							else
							{
								BaseLogger.log("3",null,null,"Warning: Email Id is null For User ["+user+"] !!!");
							}										
						}
					}
					else if("EMAIL".equalsIgnoreCase(CommonConstants.PREFFERED_COMM))
					{
						BaseLogger.log("3",null,null,"CommonConstants.PREFFERED_COMM IN EMAIL:: "+CommonConstants.PREFFERED_COMM);
						//EMail emailObj = new EMail();
						//StringBuffer mailInfoXml = new StringBuffer("<MAILINFO>");
						if (!("".equals(toAdd))) 
						{
                            //Added by Pankaj R on 13-Sep-20 to send mail for forgot_password[START] 
							//Changes done by Sanket J on 20/02/17 [for Calling Message subject and body from Mail_Format]-start
							String forgotPass = "FORGOT_PASSWORD";
							// Added and Commented by Pankaj R on 16-Sep-20 to show the mail dynamically from mail_format [START]
							//String condition = " WHERE FORMAT_CODE ='"+forgotPass+"'";
							//Added by Pankaj T on 12-01-18 [changes for multitenancy]
							//Changed by Pankaj T. on 09-01-2019 pass user specific transDB - start
							//String subject = getDBColumnValue("MAIL_FORMAT", "SUBJECT", condition, userInfo.getTransDB());
                            //Change by shrurtika on 04-08-2020 [Start] for forgot password functionality no working properly when BODY_TEXT as blank(it append null string before verification code and new password)
							//String bodyText = getDBColumnValue("MAIL_FORMAT", "BODY_TEXT", condition, userInfo.getTransDB());
							//String bodyText = E12GenericUtility.checkNull(getDBColumnValue("MAIL_FORMAT", "BODY_TEXT", condition, userInfo.getTransDB()));							//Changed by Pankaj T. on 09-01-2019 pass user specific transDB - end
							//mailInfoXml.append("<TO_ADD><![CDATA["+toAdd+"]]></TO_ADD>"); 
							//String sub =Messages.getString("CommonDBAccessEJB_yourVerificationCodeForUserID")+user; 
							//mailInfoXml.append("<SUBJECT><![CDATA["+sub+"]]></SUBJECT>"); 
							//mailInfoXml.append("<SUBJECT><![CDATA["+subject+"]]></SUBJECT>"); 
							//String msg = Messages.getString("CommonDBAccessEJB_yourVerificationCode")+varCode; 
							//mailInfoXml.append("<MESSAGE><![CDATA["+(bodyText+varCode)+"]]></MESSAGE>"); 
							//mailInfoXml.append("<MESSAGE><![CDATA["+msg+"]]></MESSAGE>"); 
							//mailInfoXml.append("</MAILINFO>"); 
							//BaseLogger.log("3",null,null,"mailInfoXml IN EMAIL:: "+ mailInfoXml);
							//Added by Pankaj T on 12-01-18 [changes for multitenancy]
							//emailObj.sendMail(mailInfoXml.toString(),null, userInfo);
                            //Changes done by Sanket J on 20/02/17 [for Calling Message subject and body from Mail_Format]-End
                            sendPasswdVerificationMail(varCode, toAdd, forgotPass, userInfo);
                            // Added and Commented by Pankaj R on 16-Sep-20 to show the mail dynamically from mail_format [END] 
						}
						else
						{
							BaseLogger.log("3",null,null,"Warning: Email ID is null For User :"+user+": !!!!!");
							if(!("".equals(mobileNo)))
							{
								String formatCode="USER_FORMAT";
								String xtraParams = "loginCode="+user+"~~loginEmpCode"+user;
								StringBuffer valueXmlString = new StringBuffer( "<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header></Header>\r\n<Errors></Errors>\r\n" );
								valueXmlString.append( "<Detail1 objName = 'user_authenticate'>\r\n" );
								//Changed by Santosh on 27-10-2017 to lookup mobile number from entityCode
								//valueXmlString.append( "<code><![CDATA[" ).append(user).append( "]]></code>\r\n" );
								valueXmlString.append( "<code><![CDATA[" ).append(entityCode).append( "]]></code>\r\n" );
								valueXmlString.append( "<verfnCode><![CDATA[" ).append(varCode).append( "]]></verfnCode>\r\n" );
								valueXmlString.append( "</Detail1>\r\n" );
								valueXmlString.append( "</Root>\r\n" );
								String smsresp = e12smsComp.sendSMS(valueXmlString.toString(), formatCode, xtraParams, userInfo);
								BaseLogger.log("3",null,null,"sms response::::"+smsresp);
							}
							else
							{
								BaseLogger.log("3",null,null,"Warning: Mobile no is null For User :"+user+": !!!!!");
							}
						}										
					}
				}
				//Changed by Santosh on 27-10-2017 to read SEC_COMM_MODE from profile master to send verification code to mobile/Email [End]
			}
			else
			{
				BaseLogger.log("3",null,null,"Warning:"+user+"This User Not Found !!!!!");
			}
			pStatement.close();
			pStatement = null;
			mResultSet.close();
			mResultSet = null;
			/*changed by Pankaj Tajane on 20/05/2016 for selecting preffered communication way EMAIL/SMS [S16ASER002] :End*/
		}
		catch( ITMException be )
		{
			BaseLogger.log("0",null,null,"ITMException:CommonDBAccessEJB : sendVerificationCode:==>\n"+be); //$NON-NLS-1$
			be.printStackTrace();
			throw new BaseException(be);
		}
		catch( BaseException be )
		{
			BaseLogger.log("0",null,null,"BaseException:CommonDBAccessEJB : sendVerificationCode:==>\n"+be); //$NON-NLS-1$
			//Changed by Pankaj T. on 09-01-2019 throw BaseException for display to frontend
			be.printStackTrace();
			throw new BaseException(be);
		}
		catch(Exception e)
		{
			BaseLogger.log("0",null,null,"Exception :CommonDBAccessEJB :sendVerificationCode :==>\n"+e); //$NON-NLS-1$
			//Changed by Pankaj T. on 09-01-2019 throw BaseException for display to frontend
			e.printStackTrace();
			throw new BaseException(e);
		}
		finally
		{
			try
			{
				if(mResultSet != null)
				{
					mResultSet.close();
					mResultSet = null;
				}
				if(pStatement != null)
				{
					pStatement.close();
					pStatement = null;
				}
				if (mConnection != null)
				{
					mConnection.close();
					mConnection = null;
				}	
			}
			catch (Exception e)
			{
				throw new BaseException( e );
			}
		}
		return varCode;
	}
	//Added by Nilesh on 29-Mar-2011[SY01SUN049][Varify user before chg password]End
	//Changed by Pawan on 06-07-2011 [WS1CSUN001] [to get value from properties table].Start
	public String getMIDPVersion() throws RemoteException, BaseException
	{
		String midpVersion = ""; //$NON-NLS-1$
		Connection con = null;
		Statement stmt = null;
		ResultSet rs = null;
		
		try
		{
			ConnDriver mConnDriver = new ConnDriver();
			con = mConnDriver.getConnectDB("Driver"); //$NON-NLS-1$
			
			String sqlQuery = "SELECT PROP_VALUE FROM PROPERTIES WHERE PROP_NAME = 'MOBILE_SERVER_VERSION_NO' "; //$NON-NLS-1$
			stmt = con.createStatement();
			rs = stmt.executeQuery(sqlQuery);
			if(rs.next())
			{
				midpVersion = rs.getString("PROP_VALUE"); //$NON-NLS-1$
			}
		}
		catch( BaseException be )
		{
			BaseLogger.log("0",null,null,"Exception: CommonDBAccessEJB:==>\n"+be); //$NON-NLS-1$
		}
		catch(Exception e)
		{
			BaseLogger.log("0",null,null,"Exception :CommonDBAccessEJB ::==>\n"+e); //$NON-NLS-1$
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(stmt != null)
				{
					stmt.close();
					stmt = null;
				}
				if (con != null)
				{
					con.close();
					con = null;
				}	
			}
			catch (Exception e)
			{
				throw new BaseException( e );
			}
		}
		return midpVersion;
	}
	//Changed by Pawan on 06-07-2011 [WS1CSUN001] [to get value from properties table].End
	//Changed by Sumit Sarkar on 11/11/11 [ SY1GNOV001 ] get the property value from properties table Start.
	public String getProperties(String propName) throws RemoteException, BaseException
	{
		String sql = "";
		String propValue = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		Connection conn = null;
		
		try
		{
			
			ConnDriver connDriver = null;
			connDriver = new ConnDriver();
			//Commented and changed by Gulzar on 18/10/13 to use the 'Driver' instead of 'DriverValidator' : START
			//conn = connDriver.getConnectDB("DriverValidator");
			//Added by Pankaj T on 19-12-17 [for multitenancy use trasDB]

			conn = connDriver.getConnectDB(getTransDB());
			//Commented and changed by Gulzar on 18/10/13 to use the 'Driver' instead of 'DriverValidator' : END
			sql = "SELECT PROP_VALUE FROM PROPERTIES WHERE PROP_NAME = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, propName);
			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				propValue = rs.getString("PROP_VALUE");
			}
			
			if(rs !=null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		catch( Exception exp )
		{
			BaseLogger.log("0",null,null,"Excepton in getProperties -- >"+exp.getMessage());
			exp.printStackTrace();
		}
		finally
		{
			try
			{
				if(rs!=null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(conn !=null)
				{
					conn.close();
					conn = null;
				}
			}
			catch(SQLException se)
			{
				se.printStackTrace();
				throw new ITMException(se);
			}
		}
		
		return propValue;
		
	}
	//Changed by Sumit Sarkar on 11/11/11 [ SY1GNOV001 ] get the property value from properties table end.
	
	//Added by Dnyaneshwar on 6-Feb-2013 Start
	public String getDBColumnValue( String tableName, String columnName, String condition  ) throws ITMException
	{
		return getDBColumnValue( tableName, columnName, condition, null  );
	}
	
	public String getDBColumnValue( String tableName, String columnName, String condition, String transDB  ) throws ITMException
	{
		String sql = "";
		String returnValue = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		Connection conn = null;
		
		try
		{
			
			ConnDriver connDriver = new ConnDriver();
			if(transDB != null && !"null".equalsIgnoreCase(transDB.trim()) && transDB.trim().length() > 0)
			{
				conn = connDriver.getConnectDB( transDB );
			}
			else
			{
				conn = connDriver.getConnectDB( "Driver" );
			}
			sql = " SELECT " +  columnName + " FROM " + tableName + " " + condition ;
			pstmt = conn.prepareStatement( sql );
			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				//Gulzar on 21/08/15
				//It will not work if columnName is passed as count(1) so used rs.getString( 1 ).
				//returnValue = rs.getString( columnName );
				returnValue = rs.getString( 1 );
			}
			if( rs !=null )
			{
				rs.close();
				rs = null;
			}
			if( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
		}
		catch( Exception exp )
		{
			BaseLogger.log("0",null,null,"Excepton in getDBColumnValue -- >"+exp.getMessage());
			exp.printStackTrace();
			//Changed by Pankaj T. on 09-01-2019 throw ITMException
			throw new ITMException(exp);
		}
		finally
		{
			try
			{
				if(rs!=null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(conn !=null)
				{
					conn.close();
					conn = null;
				}
			}
			catch(SQLException se)
			{
				se.printStackTrace();
				throw new ITMException(se);
			}
		}
		return returnValue;
	}
	//Added by Dnyaneshwar on 6-Feb-2013 End

	//Added by Dnyaneshwar Chavan on 29-Apr-15 [Implement Push Notification in E12MOBILE] Start
	@Override
	// Changed and Added by Pankaj R on 20-JAN-18
	//Added By Pankaj T. on 18-06-18 for device security based on enterprise level [0-disabled, 1-strictly enforced, 2-OTP, 3-workflow invoked, 4-Intimation Mail]
	//public void insertUserDevice(String userId, String deviceId, String deviceOS, String deviceType, String active, String chgUser, String chgTerm, String deviceMaker, String macAddress )throws RemoteException, BaseException
	public String insertUserDevice(String userId, String deviceId, String deviceOS, String deviceType, String active, String chgUser, String chgTerm, String deviceMaker, String macAddress, boolean isDeviceVerified, String enterprise, String action, String fromCache, String currentGeoPos, String transDB, UserInfoBean userInfoBean, String osName, String osVersion, String appName, String appVersion )throws RemoteException, BaseException 
	{
		String status = "";
		Connection mConnection = null;
		PreparedStatement mStatement = null;		
		try
		{
			//Added By Pankaj T. on 18-06-18 for device security based on enterprise level [0-disabled, 1-strictly enforced, 2-OTP, 3-workflow invoked] - Start
			BaseLogger.log("3",userInfoBean,null,"Action in insertUserDevice:["+action+"]");
			BaseLogger.log("3",userInfoBean,null,"userId in insertUserDevice:["+userId+"]");
			BaseLogger.log("3",userInfoBean,null,"isDeviceVerified in insertUserDevice:["+isDeviceVerified+"]");
			String deviceSecurityStatus = "";
			if( "MELOGIN".equals(action) )
			{
				if( !isDeviceVerified )
				{
					deviceSecurityStatus = verifyDeviceSecurity(userId, deviceId, deviceOS, deviceType, active, chgUser, chgTerm, deviceMaker, macAddress, isDeviceVerified, enterprise, fromCache, currentGeoPos, action, transDB, userInfoBean);
					BaseLogger.log("3",userInfoBean,null,"Device Security Status for MOBILE:["+deviceSecurityStatus+"]");
					if( "INTIMATION_MAIL".equals(deviceSecurityStatus) )
					{
						deviceSecurityStatus = "true";
						osName = E12GenericUtility.checkNull(osName);
						osVersion = E12GenericUtility.checkNull(osVersion);
						appName = E12GenericUtility.checkNull(appName);
						appVersion = E12GenericUtility.checkNull(appVersion);
						String userName = E12GenericUtility.checkNull(userInfoBean.getUserName());
						BaseLogger.log("3",userInfoBean,null,"userName in insertUserDevice:["+userName+"]");
						BaseLogger.log("3",userInfoBean,null,"osName in insertUserDevice:["+osName+"]");
						BaseLogger.log("3",userInfoBean,null,"osVersion in insertUserDevice:["+osVersion+"]");
						BaseLogger.log("3",userInfoBean,null,"appName in insertUserDevice:["+appName+"]");
						BaseLogger.log("3",userInfoBean,null,"appVersion in insertUserDevice:["+appVersion+"]");
						EMail emailObj = new EMail();
						String userType = getDBColumnValue("USERS", "USER_TYPE", " WHERE CODE = '"+userId+"'");
						BaseLogger.log("3",userInfoBean,null,"userType:["+userType+"]");
						String emailID = getEmailId(userType, userId, transDB);
						BaseLogger.log("3",userInfoBean,null,"emailID:["+emailID+"]");
						String entityCode = getDBColumnValue("USERS", "ENTITY_CODE", " WHERE CODE = '"+userId+"'");
						if (emailID != null && emailID.trim().length()>0 && !emailID.trim().equalsIgnoreCase("null")) 
						{
							String formatCode = "DEVICE_SECURITY";
							StringBuffer mailInfoXml = new StringBuffer("");
							mailInfoXml.append("<?xml version=\"1.0\" ?><Root><Header></Header><Errors></Errors>");
							mailInfoXml.append("<FORMAT_CODE><![CDATA["+formatCode+"]]></FORMAT_CODE>");
							mailInfoXml.append("<ENTITY_CODE><![CDATA["+entityCode+"]]></ENTITY_CODE>");
							String xmlData =  "<Detail1>"
											+ "<userName>"+userName+"</userName>"
											+ "<email_id>"+emailID+"</email_id>"
											+ "<osName>"+osName+"</osName>"
											+ "<osVersion>"+osVersion+"</osVersion>"
											+ "<appName>"+appName+"</appName>"
											+ "<appVersion>"+appVersion+"</appVersion>"
											+ "<ip>"+chgTerm+"</ip>"
											+ "<deviceMaker>"+deviceMaker+"</deviceMaker>"
											+ "</Detail1>";
							mailInfoXml.append("<XML_DATA><![CDATA["+xmlData+"]]></XML_DATA>"); 
							mailInfoXml.append("</Root>");
							BaseLogger.log("3",userInfoBean,null,"CommonDBAccessEJB.insertUserDevice() sending Mail..........");
							emailObj.sendMail(mailInfoXml.toString(),"ITM", userInfoBean);
							BaseLogger.log("3",userInfoBean,null,"CommonDBAccessEJB.insertUserDevice() sendMail Successfully.");
						}
					}
				}
				else
				{
					deviceSecurityStatus = "true";
				}
			}
			else if( "BROWSERLOGIN".equals(action) )
			{
				if( !isDeviceVerified && !("true".equals(fromCache)) )
				{
					deviceSecurityStatus = verifyDeviceSecurity(userId, deviceId, deviceOS, deviceType, active, chgUser, chgTerm, deviceMaker, macAddress, isDeviceVerified, enterprise, fromCache, currentGeoPos, action, transDB, userInfoBean);
					BaseLogger.log("3",userInfoBean,null,"Device Security Status for BROWSER:["+deviceSecurityStatus+"]");
					if( "INTIMATION_MAIL".equals(deviceSecurityStatus) )
					{
						deviceSecurityStatus = "true";
						osName = E12GenericUtility.checkNull(osName);
						osVersion = E12GenericUtility.checkNull(osVersion);
						appName = E12GenericUtility.checkNull(appName);
						appVersion = E12GenericUtility.checkNull(appVersion);
						String userName = E12GenericUtility.checkNull(userInfoBean.getUserName());
						BaseLogger.log("3",userInfoBean,null,"userName in insertUserDevice:["+userName+"]");
						BaseLogger.log("3",userInfoBean,null,"osName in insertUserDevice:["+osName+"]");
						BaseLogger.log("3",userInfoBean,null,"osVersion in insertUserDevice:["+osVersion+"]");
						BaseLogger.log("3",userInfoBean,null,"appName in insertUserDevice:["+appName+"]");
						BaseLogger.log("3",userInfoBean,null,"appVersion in insertUserDevice:["+appVersion+"]");
						EMail emailObj = new EMail();
						String userType = getDBColumnValue("USERS", "USER_TYPE", " WHERE CODE = '"+userId+"'");
						BaseLogger.log("3",userInfoBean,null,"userType:["+userType+"]");
						String emailID = getEmailId(userType, userId, transDB);
						BaseLogger.log("3",userInfoBean,null,"emailID:["+emailID+"]");
						String entityCode = getDBColumnValue("USERS", "ENTITY_CODE", " WHERE CODE = '"+userId+"'");
						if (emailID != null && emailID.trim().length()>0 && !emailID.trim().equalsIgnoreCase("null")) 
						{
							String formatCode = "DEVICE_SECURITY";
							StringBuffer mailInfoXml = new StringBuffer("");
							mailInfoXml.append("<?xml version=\"1.0\" ?><Root><Header></Header><Errors></Errors>");
							mailInfoXml.append("<FORMAT_CODE><![CDATA["+formatCode+"]]></FORMAT_CODE>");
							mailInfoXml.append("<ENTITY_CODE><![CDATA["+entityCode+"]]></ENTITY_CODE>");
							String xmlData =  "<Detail1>"
											+ "<userName>"+userName+"</userName>"
											+ "<email_id>"+emailID+"</email_id>"
											+ "<osName>"+osName+"</osName>"
											+ "<osVersion>"+osVersion+"</osVersion>"
											+ "<appName>"+appName+"</appName>"
											+ "<appVersion>"+appVersion+"</appVersion>"
											+ "<ip>"+chgTerm+"</ip>"
											+ "<deviceMaker>"+deviceMaker+"</deviceMaker>"
											+ "</Detail1>";
							mailInfoXml.append("<XML_DATA><![CDATA["+xmlData+"]]></XML_DATA>"); 
							mailInfoXml.append("</Root>");
							BaseLogger.log("3",userInfoBean,null,"CommonDBAccessEJB.insertUserDevice() sending Mail..........");
							emailObj.sendMail(mailInfoXml.toString(),"ITM", userInfoBean);
							BaseLogger.log("3",userInfoBean,null,"CommonDBAccessEJB.insertUserDevice() sendMail Successfully.");
						}
					}
				}
				else if("true".equals(fromCache))
				{
					deviceSecurityStatus = "true";
				}
				else
				{
					deviceSecurityStatus = "true";
				}
			}

			if( "true".equals(deviceSecurityStatus) )
			{
				//Added By Pankaj T. on 14-04-20 to set unique id as a termId in userInfo & this termId in chg_term column
				String termId = "";
				if( userId != null && !"null".equalsIgnoreCase(userId) && userId.trim().length() != 0 
						&& deviceId != null && !"null".equalsIgnoreCase(deviceId) && deviceId.trim().length() != 0 )
				{
					// Added by Abhishek on 11.03.2016 [Req ID : S15LBAS004 Authentication changes] START
					chgUser = getBasicUserInfo(userId).getLoginCode();
					userId = chgUser;
					BaseLogger.log("3",userInfoBean,null,"CommonDBAccessEJB :: insertUserDevice() : userId[" + userId + "]");
					// Added by Abhishek on 11.03.2016 [Req ID : S15LBAS004 Authentication changes] END
					
					ConnDriver mConnDriver = new ConnDriver();
					mConnection = mConnDriver.getConnectDB("Driver");
					
					String query = "";
					String tableName = "USER_DEVICE";
					String columnName = "DEVICE_ID__PUSH";
					StringBuilder condition = new StringBuilder();
					condition.append( " WHERE USER_ID='" ).append( userId ).append( "' " );
					condition.append( " AND DEVICE_ID__PUSH='" ).append( deviceId ).append( "' ");
    //				condition.append( " AND DEVICE_TYPE='" ).append( deviceType ).append( "' ");
                    //Added by sunny soni for declaring device appid from DB on 04-FEB-21 [Start]
					String appId = "";
					//Added by sunny soni for declaring device appid from DB on 04-FEB-21 [End]
					String existDeviceId = getDBColumnValue( tableName, columnName, condition.toString() );
					if( existDeviceId == null || "null".equalsIgnoreCase(existDeviceId) || existDeviceId.length() <= 0 )
					{
						java.sql.Timestamp currTime =new java.sql.Timestamp(System.currentTimeMillis());
						//Added by sunny soni for resolving multiple notification issue [Start]
						String androidRegId = (deviceId.indexOf("SEPARATOR") != -1) ? deviceId.substring(deviceId.indexOf("SEPARATOR")+9) : deviceId;										 
						StringBuilder conditn = new StringBuilder();
						conditn.append( " WHERE USER_ID='" ).append( userId ).append( "' " );
						ArrayList<String> existAndroidRegId = getDeviceRegisteredId( tableName, columnName, conditn.toString(), androidRegId);										
						if( existAndroidRegId.size() != 1)
						{						
							//Added By Pankaj T. on 14-04-20 to set unique id as a termId in userInfo & this termId in chg_term column - start
							termId = generateSeq("user_dev_seq", 15, "Driver");
							query = "INSERT INTO USER_DEVICE(USER_ID, DEVICE_ID__PUSH, DEVICE_OS, DEVICE_TYPE, ACTIVE, CHG_USER, CHG_TERM, CHG_DATE, DEVICE_MAKE, DEVICE_MAC_ADDR, TRAN_ID) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
							//Added By Pankaj T. on 14-04-20 to set unique id as a termId in userInfo & this termId in chg_term column - end
							mStatement = mConnection.prepareStatement(query);						
							mStatement.setString(1,userId);
							mStatement.setString(2,deviceId);
							mStatement.setString(3,deviceOS);
							mStatement.setString(4,deviceType);
							mStatement.setString(5,active);
							mStatement.setString(6,chgUser);
							mStatement.setString(7,chgTerm);
							mStatement.setTimestamp(8,currTime);
							mStatement.setString(9, deviceMaker);
							mStatement.setString(10, macAddress);
							mStatement.setString(11, termId);	//Added By Pankaj T. on 14-04-20 to set unique id as a termId in userInfo & this termId in chg_term column
							// Changed and Added by Pankaj R on 20-JAN-18
						}
						else
						{
							//Added By Pankaj T. on 14-04-20 to set unique id as a termId in userInfo & this termId in chg_term column
							termId = getDBColumnValue("USER_DEVICE", "TRAN_ID", condition.toString());
                            conditn.append( " AND DEVICE_ID__PUSH='" ).append( existAndroidRegId.get(0) ).append( "' ");
                            //Added by sunny soni for getting device appid from DB on 04-FEB-21 [Start]
                            appId = getDBColumnValue("USER_DEVICE", "APP_ID", conditn.toString());
							//Added by sunny soni for getting device appid from DB on 04-FEB-21 [End]
							query = "UPDATE USER_DEVICE SET DEVICE_ID__PUSH = ?, ACTIVE = ? "+conditn.toString();
							mStatement = mConnection.prepareStatement(query);
							mStatement.setString(1, deviceId );
							mStatement.setString(2, active );
						}
						mStatement.executeUpdate();
						mStatement.close();
						mStatement = null;
						//Added by sunny soni for resolving multiple notification issue [End]
					}
					else
					{
						//Added By Pankaj T. on 14-04-20 to set unique id as a termId in userInfo & this termId in chg_term column
                        termId = getDBColumnValue("USER_DEVICE", "TRAN_ID", condition.toString());
                        //Added by sunny soni for getting device appid from DB on 04-FEB-21 [Start]
                        appId = getDBColumnValue("USER_DEVICE", "APP_ID", condition.toString());
						//Added by sunny soni for getting device appid from DB on 04-FEB-21 [End]
						query = "UPDATE USER_DEVICE SET DEVICE_ID__PUSH = ?, ACTIVE = ? "+condition.toString();
						mStatement = mConnection.prepareStatement(query);
						mStatement.setString(1, deviceId );
						mStatement.setString(2, active );
						mStatement.executeUpdate();
						mStatement.close();
						mStatement = null;
					}
					BaseLogger.log("3",userInfoBean,null,"fromCache:["+fromCache+"]");
                    BaseLogger.log("3",userInfoBean,null,"deviceType:["+deviceType+"]");
                    //Added by sunny soni for update and inserting device appid on 04-FEB-21 [Start]
                    String deviceAppID = CommonConstants.DEVICE_APP_ID;
                    deviceAppID = E12GenericUtility.checkNull(deviceAppID);
					BaseLogger.log("3",userInfoBean,null,"DeviceAppID::>["+deviceAppID+"]");
                    if (deviceAppID!=null && deviceAppID.trim().length() > 0) 
					{
						appId = E12GenericUtility.checkNull(appId);			 			
						if (appId.trim().length() == 0 || !deviceAppID.trim().equalsIgnoreCase(appId.trim()))
						{							
							String updateQuery = "UPDATE USER_DEVICE SET APP_ID = ? " + condition.toString();
							BaseLogger.log("3",userInfoBean,null,"updateQuery for device app id:::["+updateQuery+"]");
							mStatement = mConnection.prepareStatement(updateQuery);
                            mStatement.setString(1, deviceAppID.trim() );
                            int i = mStatement.executeUpdate();
                            BaseLogger.log("3",userInfoBean,null,"value of executeUpdate i:["+i+"]");
                            if (i > 0) {
                                BaseLogger.log("3",userInfoBean,null,"Device AppId Updated Successfully.");							
                            }						
                            mStatement.close();
                            mStatement = null;						
                        }
                        CommonConstants.DEVICE_APP_ID = "";
                        //commented by Trushant for updating app_id with different app_id against same device_id__push on 22-Sep-21 [Start]
						/*else if (!deviceAppID.trim().equalsIgnoreCase(appId.trim())) 
						{
							java.sql.Timestamp currTime =new java.sql.Timestamp(System.currentTimeMillis());
							termId = generateSeq("user_dev_seq", 15, "Driver");
							String insertQuery = "INSERT INTO USER_DEVICE(USER_ID, DEVICE_ID__PUSH, DEVICE_OS, DEVICE_TYPE, ACTIVE, "
									+ "CHG_USER, CHG_TERM, CHG_DATE, DEVICE_MAKE, DEVICE_MAC_ADDR, TRAN_ID, APP_ID)"
									+ " VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
							mStatement = mConnection.prepareStatement(insertQuery);					
							mStatement.setString(1,userId);
							mStatement.setString(2,deviceId);
							mStatement.setString(3,deviceOS);
							mStatement.setString(4,deviceType);
							mStatement.setString(5,active);
							mStatement.setString(6,chgUser);
							mStatement.setString(7,chgTerm);
							mStatement.setTimestamp(8,currTime);
							mStatement.setString(9, deviceMaker);
							mStatement.setString(10, macAddress);
							mStatement.setString(11, termId);
                            mStatement.setString(12, deviceAppID);
                            int i = mStatement.executeUpdate();
                            BaseLogger.log("3",userInfoBean,null,"value of executeUpdate i:["+i+"]");
                            if (i > 0) {
                                BaseLogger.log("3",userInfoBean,null,"Device AppId Inserted Successfully.");							
                            }						
                            mStatement.close();
                            mStatement = null;
                        }*/	
                        //commented by Trushant for updating app_id with different app_id against same device_id__push on 22-Sep-21 [End]		
					}
					//Added by sunny soni for update and inserting device appid on 04-FEB-21 [End]
					if( "Browser".equals(deviceType) && !("true".equals(fromCache)) )
					{
						BaseLogger.log("9",null,null,"chgTerm:["+chgTerm+"]");
						BaseLogger.log("9",null,null,"currentGeoPos:["+currentGeoPos+"]");
						if( userId.length() > 0 && chgTerm.length() >0 )
						{
							StringBuilder whereCondtion = new StringBuilder();
							whereCondtion.append( " WHERE USER_ID ='" ).append( userId ).append( "' " );
							whereCondtion.append( " AND IP ='" ).append( chgTerm ).append( "' "); 
							String ipExist = E12GenericUtility.checkNull(getDBColumnValue("USER_IP", "COUNT(*)", whereCondtion.toString()));
							int existIPCount = Integer.valueOf(ipExist);							
							BaseLogger.log("3",userInfoBean,null,"exist ip count:::["+existIPCount+"]");
							if( existIPCount == 0 )
							{
								String userIPQuery = "INSERT INTO USER_IP(USER_ID, IP) VALUES(?,?)";
								mStatement = mConnection.prepareStatement(userIPQuery);						
								mStatement.setString(1,userId);
								mStatement.setString(2,chgTerm);
								int count = mStatement.executeUpdate();
								BaseLogger.log("3",userInfoBean,null,"Insert ip count:["+count+"]");
								mStatement.close();
								mStatement = null;
							}
						}
						if( userId.length()>0 && currentGeoPos.length()>0 )
						{
							StringBuilder whereCondtion = new StringBuilder();
							whereCondtion.append( " WHERE USER_ID ='" ).append( userId ).append( "' " );
							whereCondtion.append( " AND GEOPOS ='" ).append( currentGeoPos ).append( "' "); 
							String geoposExist = E12GenericUtility.checkNull(getDBColumnValue("USER_GEOPOS", "COUNT(*)", whereCondtion.toString()));
							int existGeoPosCount = Integer.valueOf(geoposExist);
							BaseLogger.log("3",userInfoBean,null,"exist geopos count:::["+existGeoPosCount+"]");
							if( existGeoPosCount == 0 )
							{
								String userGEOPOSQuery = "INSERT INTO USER_GEOPOS(USER_ID, GEOPOS) VALUES(?,?)";
								mStatement = mConnection.prepareStatement(userGEOPOSQuery);						
								mStatement.setString(1,userId);
								mStatement.setString(2,currentGeoPos);
								int count = mStatement.executeUpdate();
								BaseLogger.log("3",userInfoBean,null,"Insert geopos count:["+count+"]");
								mStatement.close();
								mStatement = null;
							}
						}
					}
					mConnection.commit();
					mConnection.close();
					mConnection = null;
				}
				//Added By Pankaj T. on 14-04-20 to set unique id as a termId in userInfo & this termId in chg_term column
				status = "true~~"+termId;
			}
			else
			{
				status = deviceSecurityStatus;
			}
			//Added By Pankaj T. on 18-06-18 for device security based on enterprise level [0-disabled, 1-strictly enforced, 2-OTP, 3-workflow invoked] - End
		}
		catch( BaseException be )
		{
			BaseLogger.log("0",userInfoBean,null,"Exception: inserUserDevice:==>\n"+be); //$NON-NLS-1$
			try
			{
				if( mConnection != null )
				{
					mConnection.rollback();
					mConnection.close();
					mConnection = null;
				}
				if (mStatement != null)
				{					
					mStatement.close();
					mStatement = null;
				}
				
			}
			catch (Exception sqle )
			{
				throw new BaseException( sqle );
			}	
			throw be;
		}
		catch(Exception e)
		{
			BaseLogger.log("0",userInfoBean,null,"Exception :CommonDBAccessEJB :inserUserDevice :==>\n"+e); //$NON-NLS-1$
			try
			{
				if( mConnection != null )
				{
					mConnection.rollback();
					mConnection.close();
					mConnection = null;
				}
				if (mStatement != null)
				{					
					mStatement.close();
					mStatement = null;
				}
			}
			catch (Exception sqle )
			{
				throw new BaseException( sqle );
			}	
			throw new BaseException( e );
		}
		finally
		{
			try
			{
				
				if (mConnection != null)
				{					
					mConnection.close();
					mConnection = null;
				}
				if (mStatement != null)
				{					
					mStatement.close();
					mStatement = null;
				}
			}
			catch (Exception e)
			{
				throw new BaseException( e );
			}
		}
		return status;
	}

	@Override
	public ArrayList<String> getRegisteredIdList( String deviceOS ) throws RemoteException, BaseException 
	{
		ArrayList<String> registeredList =  new ArrayList<String>();
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		Connection conn = null;
		try
		{
			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB( "Driver" );
			String sql = " SELECT DEVICE_ID__PUSH FROM USER_DEVICE WHERE DEVICE_OS = ? AND ACTIVE='Y' " ;
			pstmt = conn.prepareStatement( sql );
			pstmt.setString(1, deviceOS);
			rs = pstmt.executeQuery();
			while( rs.next() )
			{
				BaseLogger.log("3",null,null,"DEVICE_ID__PUSH ["+rs.getString( "DEVICE_ID__PUSH" )+"]");
				registeredList.add( rs.getString( "DEVICE_ID__PUSH" ) );
			}
			if( rs !=null )
			{
				rs.close();
				rs = null;
			}
			if( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
		}
		catch( Exception exp )
		{
			BaseLogger.log("0",null,null,"Excepton in getRegisteredIdList -- >"+exp.getMessage());
			exp.printStackTrace();
		}
		finally
		{
			try
			{
				if(rs!=null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(conn !=null)
				{
					conn.close();
					conn = null;
				}
			}
			catch(SQLException se)
			{
				se.printStackTrace();
				throw new ITMException(se);
			}
		}
		return registeredList;
	}
	//Added by Dnyaneshwar Chavan on 29-Apr-15 [Implement Push Notification in E12MOBILE] End
	
	//Added by Sandeep Shelar on 18-Jan-16 [Implement Push Notification in E12MOBILE for IOS] Start
	@Override
	public Map<String,String> getRegisteredIdListForiOS( String deviceOS ) throws RemoteException, BaseException 
	{
		Map<String,String> registeredList =  new HashMap<String,String>();
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		Connection conn = null;
		try
		{
			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB( "Driver" );
			String sql = " SELECT USER_ID,DEVICE_ID__PUSH FROM USER_DEVICE WHERE DEVICE_OS = ? AND ACTIVE='Y' " ;
			pstmt = conn.prepareStatement( sql );
			pstmt.setString(1, deviceOS);
			rs = pstmt.executeQuery();
			while( rs.next() )
			{
				BaseLogger.log("3",null,null,"USER_ID ["+rs.getString( "USER_ID" )+"]");
				BaseLogger.log("3",null,null,"DEVICE_ID__PUSH ["+rs.getString( "DEVICE_ID__PUSH" )+"]");
				registeredList.put(rs.getString( "USER_ID" ), rs.getString( "DEVICE_ID__PUSH" ));
			}
			if( rs !=null )
			{
				rs.close();
				rs = null;
			}
			if( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
		}
		catch( Exception exp )
		{
			BaseLogger.log("0",null,null,"Excepton in getRegisteredIdList -- >"+exp.getMessage());
			exp.printStackTrace();
		}
		finally
		{
			try
			{
				if(rs!=null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(conn !=null)
				{
					conn.close();
					conn = null;
				}
			}
			catch(SQLException se)
			{
				se.printStackTrace();
				throw new ITMException(se);
			}
		}
		return registeredList;
	}
	//Added by Sandeep Shelar on 18-Jan-16 [Implement Push Notification in E12MOBILE for IOS] End
	
	//Added By Prajyot on 05-JUN-2015
	/**
	 * [Request ID : W15BMIT003 - Set Current Geo Position in Login trace]
	 * To update Current Geo Position - when user performs login / logout. 
	 */
	@Override
	public void updateCurrentGeoPos( String user, String sessionId, String currentGeoPos, String dataMode, String batteryStatus) throws RemoteException, BaseException
	{
		Connection mConnection = null;
		PreparedStatement mStatement = null;		
		try
		{			
			//Changed By Pankaj T. on 24-07-19 for unable to update record when userId contains blank space
			user = E12GenericUtility.checkNull(getUserCode(user));
			ConnDriver mConnDriver = new ConnDriver();
			mConnection = mConnDriver.getConnectDB("Driver");	 //$NON-NLS-1$
			String query ="";
			boolean isNullBatteryStatus = ( batteryStatus == null || "".equalsIgnoreCase( batteryStatus ) ) ? true : false;
			
			if( !isNullBatteryStatus )
			{
				query = "UPDATE LOGINTRACE SET CURRENT_GEO_POS = ?, DATA_MODE = ?, LOGOUT_BATTERY_STAT = ? WHERE USERID=? AND SESSIONID = ?"; //$NON-NLS-1$
			}
			else
			{
				query = "UPDATE LOGINTRACE SET CURRENT_GEO_POS = ?, DATA_MODE = ? WHERE USERID=? AND SESSIONID = ?"; //$NON-NLS-1$
			}
			mStatement = mConnection.prepareStatement(query);						
			mStatement.setString(1,currentGeoPos);
			mStatement.setString(2,dataMode);
			if( !isNullBatteryStatus )
			{
				mStatement.setInt(3, Integer.parseInt(batteryStatus));
				mStatement.setString(4,user);
				mStatement.setString(5,sessionId);
			}
			else
			{
				mStatement.setString(3,user);
				mStatement.setString(4,sessionId);
			}
			
			int rowCnt = mStatement.executeUpdate();
			BaseLogger.log("3",null,null, "updateCurrentGeoPos LOGOUT_BATTERY_STAT["+batteryStatus+"]currentGeoPos["+currentGeoPos+"] dataMode["+dataMode+"] LOGIN TRACE UPDATED :"+rowCnt ); //$NON-NLS-1$
			mStatement.close();
			mStatement = null;
			mConnection.commit();
		}
		//change by shrutika on 19-12-2020 for Exception in application ,as per suggested by prasad sir [start]
		/*catch( BaseException be )
		{
			BaseLogger.log("0",null,null, "Exception: updateCurrentGeoPos:==>\n"+be ); //$NON-NLS-1$
			try
			{
				mConnection.rollback();
			}
			catch (Exception sqle )
			{
				throw new BaseException( sqle );
			}	
			throw be;
		}*/
		//change by shrutika on 19-12-2020 for Exception in application ,as per suggested by prasad sir [end]
		catch(Exception e)
		{
			BaseLogger.log("0",null,null,"Exception :CommonDBAccessEJB :updateCurrentGeoPos :==>\n"+e); //$NON-NLS-1$
			try
			{
				mConnection.rollback();
			}
			catch (Exception sqle )
			{
				throw new BaseException( sqle );
			}	
			throw new BaseException( e );
		}
		finally
		{
			try
			{
				if(mStatement != null)
				{
					mStatement.close();
					mStatement = null;
				}
				if (mConnection != null)
				{					
					mConnection.close();
					mConnection = null;
				}	
			}
			catch (Exception e)
			{
				throw new BaseException( e );
			}
		}
	}
	
	
	/**
	 *  GeoPosition Logging in GEOPOS table 
	 *  Insert to TABLE GEOPOS 
	    TRAN_ID	      -- SEQUENTIAL NUMBER
	    DEVICE_ID     -- In case of MobileApp : Device ID and 
	    				 			WebAccess : CHG_TERM (IP Address)
	    DATETIME      -- Date and Time
	    GEOPOS        -- Captured Geo Location (lattitude, longitude, alttitude)
	    USER_ID	      -- Login User Code
	    UPDATE_SOURCE -- Updated from 1 : At Login and 
	    							  2 : From User Info  
	 */
	@Override
	public void insertGeoPosition( String userId, String deviceId, String dateTime, String geopos, String updateSrc, String dataMode, String geoPosName, String geoPosAccuracy )throws RemoteException, BaseException 
	{
		BaseLogger.log("2",null,null,"CommonDBAccessEJB :insertGeoPosition :==> userId["+ userId+"]deviceId["+ deviceId+"]dateTime["+ dateTime+"]geopos["+ geopos+"]updateSrc["+ updateSrc+"] dataMode["+dataMode+"] geoPosName["+geoPosName+"] geoPosAccuracy["+geoPosAccuracy+"]"); //$NON-NLS-1$
		boolean isException = false;
		Connection mConnection = null;
		PreparedStatement mStatement = null;	
		Statement stmt = null;
		ResultSet rs = null;
		try
		{			
			ConnDriver mConnDriver = new ConnDriver();
			mConnection = mConnDriver.getConnectDB("Driver");
			
			String nextseqQuery="";
			//String nextseqQuery = ("mysql".equalsIgnoreCase( CommonConstants.DB_NAME ) ) ? "SELECT GEOPOS_ID_FUNCTION()" :  "SELECT GEOPOS_ID_SEQ.NEXTVAL FROM DUAL" ;
			//added by mrunalini sinkar on 18-july-17(start)
			if("mysql".equalsIgnoreCase( CommonConstants.DB_NAME ) )
			{
				nextseqQuery="SELECT GEOPOS_ID_FUNCTION()";
			}
			else if("db2".equalsIgnoreCase(CommonConstants.DB_NAME))
			{
				nextseqQuery="SELECT NEXTVAL FOR GEOPOS_ID_SEQ  FROM DUAL";
			}
			else
			{
				nextseqQuery="SELECT GEOPOS_ID_SEQ.NEXTVAL FROM DUAL";
			}
			//added by mrunalini sinkar on 18-july-17(end)

			stmt = mConnection.createStatement();
			rs = stmt.executeQuery( nextseqQuery );
			String tranId = "";
			if( rs.next() )
			{
				tranId = rs.getString( 1 );
			}
			stmt.close();
			stmt = null;
			rs.close();
			rs = null;
			
			E12GenericUtility genUtility = new E12GenericUtility();
			java.sql.Timestamp currTime =new java.sql.Timestamp(System.currentTimeMillis());
			
			if( E12GenericUtility.checkNull(dateTime).length() > 0 )
			{
				dateTime = genUtility.getValidDateTimeString(dateTime, genUtility.getApplDateTimeFormat(), genUtility.getDBDateTimeFormat());
				currTime = java.sql.Timestamp.valueOf(dateTime);
				BaseLogger.log("3",null,null,"CommonDBAccessEJB :insertGeoPosition :==> currTime["+ currTime+"]"); //$NON-NLS-1$
			}

//			String query = "INSERT INTO GEOPOS(TRAN_ID, DEVICE_ID, DATETIME, GEOPOS, USER_ID, UPDATE_SOURCE, DATA_MODE, GEO_POS_NAME) " +
//					   "VALUES(?, ?, ?, ?, ?, ?, ?, ?)";
			String query = "INSERT INTO GEOPOS(TRAN_ID, DEVICE_ID, DATETIME, GEOPOS, USER_ID, UPDATE_SOURCE, DATA_MODE, GEO_POS_NAME, GEOPOS_ACCURACY) " +
						   "VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?)";
			mStatement = mConnection.prepareStatement(query);						
			mStatement.setString(1,tranId );
			mStatement.setString(2,deviceId);
			mStatement.setTimestamp(3,currTime);
			mStatement.setString(4,geopos);
			mStatement.setString(5,userId);
			mStatement.setString(6,updateSrc);
			mStatement.setString(7,dataMode);
			mStatement.setString(8,geoPosName);		//Added by Sagar B. to track address of current geopos and store in table[10-Apr-18]
			mStatement.setString(9,geoPosAccuracy);		//Added by Sagar B. to store accuracy of geo position[23-Jul-18]
			int rowCnt = mStatement.executeUpdate();
			BaseLogger.log("3",null,null,"CommonDBAccessEJB :insertGeoPosition :==> "+ rowCnt);
			mStatement.close();
			mStatement = null;
		}
		catch(Exception e)
		{
			isException = true;
			BaseLogger.log("0",null,null,"Exception :CommonDBAccessEJB :insertGeoPosition :==>\n"+e);
			throw new BaseException( e );
		}
		finally
		{
			try
			{
				if (mStatement != null)
				{
					mStatement.close();
					mStatement = null;
				}
				if (mConnection != null)
				{					
					if( isException )
					{
						mConnection.rollback();
					}
					else
					{
						mConnection.commit();
					}
					mConnection.close();
					mConnection = null;
				}	
			}
			catch (Exception e)
			{
				throw new BaseException( e );
			}
		}
	}

	@Override
	public String getGeoPosition(String userId, String updateSrc) throws RemoteException, BaseException 
	{
		String geoPosition = "";
		Connection mConnection = null;
		PreparedStatement mStatement = null;	
		ResultSet rs = null;
		try
		{
			ConnDriver mConnDriver = new ConnDriver();
			mConnection = mConnDriver.getConnectDB("Driver");
			String query = "SELECT * FROM GEOPOS " +
					       "WHERE USER_ID = ? AND UPDATE_SOURCE = ? ORDER BY TRAN_ID, USER_ID, DATETIME ";
			mStatement = mConnection.prepareStatement(query);						
			mStatement.setString( 1, userId );
			mStatement.setString( 2, updateSrc );
			rs = mStatement.executeQuery();
			while( rs.next() )
			{
				geoPosition = rs.getString("GEOPOS");
				BaseLogger.log("3",null,null,"DATETIME["+ rs.getString("DATETIME") + "]geoPosition["+ geoPosition + "]");
			}
			BaseLogger.log("3",null,null,"CommonDBAccessEJB :getGeoPosition :==>userId["+ userId + "]updateSrc["+ updateSrc + "]last visited geoPosition["+ geoPosition + "]");
			if( rs !=null )
			{
				rs.close();
				rs = null;
			}
			if (mStatement != null)
			{
				mStatement.close();
				mStatement = null;
			}
		}
		catch(Exception e)
		{
			BaseLogger.log("0",null,null,"Exception :CommonDBAccessEJB :getGeoPosition :==>\n"+e);
			throw new BaseException( e );
		}
		finally
		{
			try
			{
				if (mStatement != null)
				{
					mStatement.close();
					mStatement = null;
				}
				if (mConnection != null)
				{					
					mConnection.close();
					mConnection = null;
				}	
			}
			catch (Exception e)
			{
				throw new BaseException( e );
			}
		}
		return geoPosition;
	}
	//Added by Chetan Mahajan on 29-SEP-15 [Req id : F15FSUN008] [For delete download attachment when session out,Logout or close attachment window] Start
	/**
	 * For delete attachment when session out,Logout or close attachment window
	 * @param user
	 * @param sessionId
	 */
	public void deleteDownloadedAttachment( String user, String sessionId )
	{
		try 
		{
			BaseLogger.log("3",null,null,"------------ CommonDBAccessEJB :: deleteDownloadedAttachment ------------");
			String strDirectoy = CommonConstants.APPLICATION_CONTEXT + "temp";
			if ( sessionId != null && !sessionId.equalsIgnoreCase(""))
			{
				File file = new File(strDirectoy + File.separator + user + sessionId);
				strDirectoy = strDirectoy + File.separator + user+sessionId;
				BaseLogger.log("3",null,null,"deleting folder from path : "+strDirectoy);
				if ( file.exists() ) 
				{
					try 
					{
						FileUtils.deleteDirectory(new File(strDirectoy));
						BaseLogger.log("3",null,null,file.getName() + " is deleted!");
					} 
					catch (Exception e) 
					{
						e.printStackTrace();
					}
				}
				else
				{
					BaseLogger.log("3",null,null,"Folder does not exits--Delete operation is failed");
				}
			}
		}
		catch (Exception ex) 
		{
			ex.printStackTrace();
		}
	}
	//Added by Chetan Mahajan on 29-SEP-15 [Req id : F15FSUN008] [For delete download attachment when session out,Logout or close attachment window] Start End
	//Added by Prajyot[To Get Cacheable Objects] Start
	public String getCacheObjects(String userCode, String profileID , String applName, boolean isMobile, UserInfoBean userInfo ) throws RemoteException,BaseException
	{		
		BaseLogger.log("2",userInfo,null,"inside getUserXMLTree:: applName is: " + applName);
		
		//Changes By Prajyot[Issue of menu Tree Generation ] On 20MAR13
		StringBuffer mXML = new StringBuffer(""); 
		
		Connection conn = null;
		Connection usrsConn = null;
		Statement statOption = null;
		ResultSet rsOption = null;
		try
		{
			String appName = applName; 

			ConnDriver connDriver = new ConnDriver();
			String transDB = userInfo.getTransDB();
			conn = connDriver.getConnectDB(transDB);
			
			usrsConn = connDriver.getConnectDB("Driver");
			String usrLevQry = "SELECT USR_LEV FROM USERS WHERE CODE ='" + userCode + "'"; 
			statOption = usrsConn.createStatement();
			rsOption = statOption.executeQuery(usrLevQry);
			int level = 0;
			if(rsOption.next()){
				level = rsOption.getInt("USR_LEV"); 
			}
			//Commented by Gulzar on 28/06/17
			//statOption.close();
			//statOption = null;
			//Added by Pankaj T on 12-01-18 [changes for multitenancy]
			if(rsOption != null)rsOption.close(); rsOption = null;
			if(statOption != null)statOption.close(); statOption = null;

			String menuQry = null;			
			if ( applName != null && applName.length() > 0)
			{
				appName = applName;
			}
			if( level >= 1 )
			{
				menuQry="SELECT B.APPLICATION APP, B.WIN_NAME WIN_NAME, B.MENU_PATH MPATH, B.DESCR, B.ICON_PATH, B.OBJ_TYPE " +   
						"FROM USER_RIGHTS A, ITM2MENU B INNER JOIN  TRANSETUP C ON B.WIN_NAME = C.TRAN_WINDOW " +
						//Changed by Sagar B. for multiple profile id related changes[11-Dec-17]
						//"WHERE A.PROFILE_ID ='"+profileID+"' "+
						"WHERE A.PROFILE_ID IN "+ E12GenericUtility.getFormattedProfileId(profileID) +" "+
						"AND A.APPLICATION='"+appName+"' AND A.APPLICATION=B.APPLICATION AND A.MENU_ROW=B.LEVEL_1 "+  
						"AND A.MENU_COL=B.LEVEL_2 AND A.MENU_SUBCOL=B.LEVEL_3 " + 
						"AND A.LEVEL_4=B.LEVEL_4 AND A.LEVEL_5=B.LEVEL_5 "+  
						""+ (isMobile == true ? " AND ( B.MOB_DEPLOY = 'Y' OR B.MOB_DEPLOY = 'B' ) " : "  AND ( B.MOB_DEPLOY != 'Y' OR B.MOB_DEPLOY is null ) ") + //Added by Nilesh Soor on 21-Aug-14 [ Mobile Specific Menus Should Not Get Displayed In Browser. ]
						" AND C.CACHE_OPT = 2 " +
						" ORDER BY A.APPLICATION,A.MENU_ROW,A.MENU_COL,A.MENU_SUBCOL,A.LEVEL_4,A.LEVEL_5 "; 
			}
			else
			{
				menuQry ="SELECT A.APPLICATION APP, A.WIN_NAME WIN_NAME, A.MENU_PATH MPATH, A.DESCR, A.ICON_PATH, A.OBJ_TYPE " +
						"FROM ITM2MENU A INNER JOIN TRANSETUP B ON A.WIN_NAME=B.TRAN_WINDOW " +
						"WHERE A.WIN_NAME NOT IN ('-') " +
						"AND A.APPLICATION = '"+appName+"' " +
						""+ (isMobile == true ? " AND ( A.MOB_DEPLOY = 'Y' OR A.MOB_DEPLOY = 'B' )" : "  AND ( A.MOB_DEPLOY != 'Y' OR A.MOB_DEPLOY is null ) ") + //Added by Nilesh Soor on 21-Aug-14 [ Mobile Specific Menus Should Not Get Displayed In Browser. ]
						" AND B.CACHE_OPT = 2 " +
						" ORDER BY A.APPLICATION,A.LEVEL_1,A.LEVEL_2,A.LEVEL_3,A.LEVEL_4,A.LEVEL_5"; 
			}
			//Commented by Gulzar on 28/06/17
			statOption = conn.createStatement();
			rsOption = statOption.executeQuery(menuQry);
			while (rsOption.next())
			{
				String winName = rsOption.getString("WIN_NAME"); 
				BaseLogger.log("3",userInfo,null,"CACHE OPT = 2 ---  winName ---:"+winName); 
				if( winName != null && winName.startsWith("w_") )
				{
					winName = winName.replace("w_", "");
					mXML.append( winName + ",");
				}
			}//rs
			//Commented by Gulzar on 28/06/17
			//statOption.close();
			//statOption = null;
			if(rsOption != null)rsOption.close(); rsOption = null;
			if(statOption != null)statOption.close(); statOption = null;
			BaseLogger.log("3",userInfo,null,"(DBAccessEJB:getUserXML)UserXML: Built"); 
		}
		catch (BaseException basee)
		{ 
			BaseLogger.log("0",userInfo,null,"BaseException: DBAccess: getUserXMLTree: ==>UserXML: Not Built(Generic Exception)\n"); 
			throw basee;
		}
		catch(SQLException sqle)
		{
			BaseLogger.log("0",userInfo,null,"SQLException: DBAccess: getUserXMLTree: ==>UserXML: Not Built(SQLException)\n" + sqle); 
			sqle.printStackTrace();
			throw new BaseException(sqle);
		}
		catch (Exception e)
		{ 
			BaseLogger.log("0",userInfo,null,"Exception: DBAccess: getUserXMLTree: ==>UserXML: Not Built(Generic Exception)\n" + e); 
			throw new BaseException(e);
		}
		finally
		{
			try
			{
				if(conn != null)
				{
					if(rsOption != null)rsOption.close(); rsOption = null;
					if(statOption != null)statOption.close(); statOption = null;
					conn.close();
					conn = null;
				}
				
				if(usrsConn != null)
				{
					if(rsOption != null)rsOption.close(); rsOption = null;
					if(statOption != null)statOption.close(); statOption = null;
					usrsConn.close();
					usrsConn = null;
				}
			}
			catch(Exception e)
			{
				BaseLogger.log("0",userInfo,null,"Exception: DBAccess: getUserXMLTree ==>UserXML: Not Built F\n" + e); 
				throw new BaseException(e);
			}
		}
		return mXML.toString();
	}
	//Added by Prajyot[To Get Cacheable Objects] End

	//Added by Prasad on 11/03/16 [for checking old Password] START
	/**
	 * to check old Password
	 * 
	 * @param user
	 * @param oldPwd
	 * @return
	 * @throws RemoteException
	 * @throws BaseException
	 */
	@Override
	public boolean checkOldPassword(String user, String oldPwd, UserInfoBean userInfo) throws RemoteException, BaseException 
	{
		boolean pwdExist = false;
		Connection mConnection = null;
		Statement mStatement = null;
		ResultSet mResultSet1 =null;
		try
		{
			ConnDriver mConnDriver = new ConnDriver();
			String transDB = userInfo.getTransDB();
            //mConnection = mConnDriver.getConnectDB(transDB);
            mConnection = mConnDriver.getConnectDB("Driver");
			mStatement = mConnection.createStatement();
			String sqlQuery = "SELECT PASS_WD FROM USERS WHERE CODE = '"+user+"'";
			mResultSet1 = mStatement.executeQuery(sqlQuery);
			if (mResultSet1.next())
			{
				String passWd = mResultSet1.getString(1);
				if ( oldPwd.equals( passWd ) || oldPwd.equals( decrypt(passWd) ) )
				{
					pwdExist = true;
				}
			}
			mResultSet1.close();
			mResultSet1 = null;
			mStatement.close();
			mStatement = null;
		}
		catch( BaseException be )
		{
			BaseLogger.log("0",userInfo,null,"Exception: checkOldPassword:==>\n"+be); //$NON-NLS-1$
			throw be;
		}
		catch(Exception e)
		{
			BaseLogger.log("0",userInfo,null,"Exception :CommonDBAccessEJB :checkOldPassword :==>\n"+e); //$NON-NLS-1$
			throw new BaseException( e );
		}
		finally
		{
			try
			{
				if(mResultSet1 !=null)
				{
					mResultSet1.close();
					mResultSet1 =null;
				}
				if (mConnection != null)
				{
					if(mStatement != null)
					{
						mStatement.close();
						mStatement = null;
					}
					mConnection.close();
					mConnection = null;
				}	
			}
			catch (Exception e)
			{
				throw new BaseException( e );
			}
		}
		return pwdExist;
	}
	//Added by Prasad on 11/03/16 [for checking old Password] END
	
	//Changed  by rahul on 25-apr-2016 [Request ID : W15LSUN010 for updatind date as well as time in LAST_PWD_CHGDATE column in users table] START
	public int getWrongLoginCount(String userCode,String clientIP)
	{
		BaseLogger.log("2",null,null,"inside getWrongLoginCount......::::::");
		PreparedStatement pstmt = null;
		PreparedStatement logintracePstmt = null;
		E12GenericUtility genericUtility = new E12GenericUtility();
		PreparedStatement usersPstmt = null;
		ResultSet rs = null;
		ResultSet loginTraceRs = null;
		ResultSet usersRs = null;
		Connection conn = null;
		String logintrace = "";
		String users = "";
		int count = 0;
		try
		{
			ConnDriver mConnDriver = new ConnDriver();
			conn = mConnDriver.getConnectDB("Driver");

			//java.sql.Timestamp currTime =new java.sql.Timestamp(System.currentTimeMillis());
			java.sql.Timestamp currTime =new java.sql.Timestamp(System.currentTimeMillis() - 3600 * 1000);
			//Date currentDate = new Date(System.currentTimeMillis() - 3600 * 1000);
			BaseLogger.log("2",null,null,"currTime..."+currTime);
			String loginTraceSql ="SELECT MAX(A.LOGINTIME) AS LOGINTIME FROM LOGINTRACE A WHERE A.USERID= ? AND  A.LOGIN_STATUS='T' AND A.CHG_IP = ? ";
			logintracePstmt = conn.prepareStatement(loginTraceSql);
			logintracePstmt.setString(1,userCode);
			logintracePstmt.setString(2,clientIP);
			loginTraceRs = logintracePstmt.executeQuery();
			if(loginTraceRs.next())
			{
				logintrace=genericUtility.checkNull(loginTraceRs.getString("LOGINTIME"));
			}
			//added By Nilesh For ressolving open cursor issue Start:01-06-2017
			if (loginTraceRs != null)
			{
				loginTraceRs.close();
				loginTraceRs=null;
			}
			if (logintracePstmt != null)
			{
				logintracePstmt.close();
				logintracePstmt=null;
			}
			//added By Nilesh For ressolving open cursor End Start:01-06-2017
			if(!logintrace.equalsIgnoreCase("") && logintrace!= null)
			{
				logintrace = " AND LOGINTIME >=(SELECT MAX(A.LOGINTIME) FROM LOGINTRACE A WHERE A.USERID=LOGINTRACE.USERID AND  A.LOGIN_STATUS='T' AND A.CHG_IP = LOGINTRACE.CHG_IP )";
			}
			String usersSql ="SELECT LAST_PWD_CHGDATE FROM USERS WHERE CODE= ? ";
			usersPstmt = conn.prepareStatement(usersSql);
			usersPstmt.setString(1,userCode);
			usersRs = usersPstmt.executeQuery();
			if(usersRs.next())
			{
				users = " AND LOGINTIME >=(SELECT LAST_PWD_CHGDATE FROM USERS WHERE CODE= ? )";
			}
			if(usersRs != null)
			{
				usersRs.close();
				usersRs = null;
			}
			if(usersPstmt != null)
			{
				usersPstmt.close();
				usersPstmt = null;
			}

			String sql="SELECT COUNT(*) AS COUNT FROM LOGINTRACE WHERE USERID= ? AND CHG_IP= ? AND LOGIN_STATUS='F' AND LOGINTIME >= ? ";
			/*" AND LOGINTIME >=(SELECT MAX(A.LOGINTIME) " +
						" FROM LOGINTRACE A WHERE A.USERID=LOGINTRACE.USERID AND  A.LOGIN_STATUS=LOGINTRACE.LOGIN_STATUS) AND " +
						" LOGINTIME >=(SELECT LAST_PWD_CHGDATE FROM USERS WHERE CODE= ? )";*/
			if(!logintrace.equalsIgnoreCase("") && logintrace != null)
			{
				sql = sql+logintrace;
			}
			if(!users.equalsIgnoreCase("") && users != null)
			{
				sql = sql+users;
			}

			// String sql = "SELECT USERID,LOGINTIME,CHG_IP FROM LOGINTRACE WHERE USERID= ? AND CHG_IP= ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,userCode);
			pstmt.setString(2,clientIP);
			pstmt.setTimestamp(3,currTime);
			if(!users.equalsIgnoreCase("") && users != null)
			{
				pstmt.setString(4,userCode);
			}
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				count = rs.getInt("COUNT");
			}
			BaseLogger.log("3",null,null,"count...."+count);
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if(rs !=null)
				{
					rs.close();
					rs =null;
				}
				if (conn != null)
				{
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					conn.close();
					conn = null;
				}
			}
			catch (Exception e)
			{
				e.printStackTrace();
			}

		}
		return count;
	}
	//Changed by rahul on 25-apr-2016 [Request ID : W15LSUN010 for updatind date as well as time in LAST_PWD_CHGDATE column in users table] END

	// Added by Abhishek on 11.03.2016 [Req ID : S15LBAS004 For authentication chages] START
	@Override
	public UserInfoBean getBasicUserInfo (String user) 
			throws BaseException, Exception {

		UserInfoBean basicInfo = null;
		String[] colums = {"CODE", "MOBILE_NO", "EMAIL_ID", "USER_ID"};

		/**
		 * K = UNKNOWN,   C = CODE
		 * M = MOBILE_NO, E = EMAIL_ID, U = USER_ID
		 */
		String[] entryTypes = {"C", "M", "E", "U", "K"}; 
		ConnDriver connDriver = null;
		Connection connection = null;
		// Changed by Sandesh Shinde on 17-MAY-2017 [ Authentication API: SQL Injection]
		PreparedStatement pStatement = null;
		ResultSet resultSet = null;
		// Changed by Abhishek T on 20-Mar-18 [For OTP login functionality] START
		String userCode = null, entryType = "K", password = null, passwordSha = null;

		// Changed by Sandesh Shinde on 17-MAY-2017 [ Authentication API: SQL Injection]
		String sqlQuery = "SELECT CODE, PASS_WD, PASS_WD_SHA FROM USERS WHERE {CN} = ?";

		try {
			basicInfo = new UserInfoBean();
			basicInfo.setEntryId(user);
			connDriver = new ConnDriver();
			connection = connDriver.getConnectDB("Driver");

			for (int i = 0; i < colums.length; i++) {
				// Changed by Sandesh Shinde on 17-MAY-2017 [ Authentication API: SQL Injection] Start
				pStatement = connection.prepareStatement(sqlQuery.replace("{CN}", colums[i]));
				pStatement.setString(1, user);
				resultSet = pStatement.executeQuery();
				// Changed by Sandesh Shinde on 17-MAY-2017 [ Authentication API: SQL Injection] End
				if (resultSet.next()) {
					entryType = entryTypes[i];
					userCode = resultSet.getString(1);
					password = resultSet.getString(2);
					passwordSha = resultSet.getString(3);
					break;
				}
				if (resultSet != null)
				{
					resultSet.close();
					resultSet = null;
				}
				if (pStatement != null)
				{
					pStatement.close();
					pStatement = null;
				}
			}

			if (userCode == null)
				userCode = "NOTMATCHED";

			// Changed by Abhishek T on 18-April-18 [For trimming extra spaces] START
			basicInfo.setEntryType(E12GenericUtility.checkNull(entryType));
			basicInfo.setLoginCode(E12GenericUtility.checkNull(userCode));
			// Changed by Abhishek T on 18-April-18 [For trimming extra spaces] END
			
			if (passwordSha != null) {
				basicInfo.setLoginPwd(passwordSha);
				// Added by Abhishek T on 17-April-18 [For detecting password type (sha256 encrypted or plain)] START
				basicInfo.setIsPasswordStore("Y");
				// Added by Abhishek T on 17-April-18 [For detecting password type (sha256 encrypted or plain)] END
			} else {
				basicInfo.setLoginPwd(password);
			}
		// Changed by Abhishek T on 20-Mar-18 [For OTP login functionality] END
		} finally {
			if (resultSet != null) 
			{
				resultSet.close();
				resultSet = null;
			}
			// Changed by Sandesh Shinde on 17-MAY-2017 [ Authentication API: SQL Injection]
			if (pStatement != null)
			{
				pStatement.close();
				pStatement = null;
			}
			if (connection != null)
			{
				connection.close();
				connection = null;
			}
		}
		BaseLogger.log("2",null,null,"CommonDBAccessEJB :: getBasicUserInfo() : entryID[" + basicInfo.getEntryId() + "] entryType[" + entryType + "] userCode[" + userCode + "]");
		return basicInfo;
	}
	// Added by Abhishek on 11.03.2016 [Req ID : S15LBAS004 For authentication chages] END

	//Added by Sainath T.on 06-03-2020 [For gaction authentication] - Start
	/**
	 * 
	 *if find any match then store the respective user information in UserInfoBean object and returns that object.
	 *
	 * @param userId
	 *  
	 * @throws BaseException
	 * @throws Exception
	 */
	@Override
	public UserInfoBean createUserInfo(String userId) throws BaseException, Exception
	{
		return createUserInfo( userId, "code" );
	}
	//Added by Sainath T.on 06-03-2020 [For gaction authentication] - End
	
	//Changed by Pooja S on 6-NOV-2020 [//Changed by Pooja S on 6-NOV-2020 [passord should sent from common definition, not from enterprise]] start
	public UserInfoBean createUserInfo( String userId, String whereConditionColumn ) throws BaseException, Exception
	{
		return createUserInfo( userId, whereConditionColumn, true );
	}
	//Changed by Pooja S on 6-NOV-2020 [Vision mail not working] end
	
	//Added by Pankaj on 20-sep-2016 [S16FBAS008][//Changed by Pooja S on 6-NOV-2020 [passord should sent from common definition, not from enterprise]] Start
	/**
	 * 
	 *if find any match then store the respective user information in UserInfoBean object and returns that object.
	 *
	 * @param userId
	 * 
	 * @throws BaseException
	 * @throws Exception
	 */
	//@Override
	public UserInfoBean createUserInfo( String userId, String whereConditionColumn, boolean isMailConfReq ) throws BaseException, Exception
	{
		UserInfoBean userInfoBean = new UserInfoBean();
		ConnDriver connDriver = null;
		Connection connection = null;
		Statement statement = null;
		ResultSet resultSet = null;
		//Added by pankaj T. on 10-04-2020 for  Configure SMTP mail server against ENTERPRISE - start
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		//Added by pankaj T. on 10-04-2020 for  Configure SMTP mail server against ENTERPRISE - end
		//Added By Pankaj T. on 01-02-2021 to set chg_term of logintrace as a termid in userinfo - start
		PreparedStatement preparedStatement = null;
		ResultSet res = null;
		//Added By Pankaj T. on 01-02-2021 to set chg_term of logintrace as a termid in userinfo - end
		try 
		{
			BaseLogger.log("3",null,null,"userId in createUserInfo of CommonDBAccessEJB=["+userId+"]");
			//Added by Sainath T.on 17-07-2020 [For gaction authentication]
			//userInfoBean.setLoginCode(userId);
			connDriver = new ConnDriver();
			connection = connDriver.getConnectDB("Driver");
			statement = connection.createStatement();
			//Changed by Sagar B. for forgot password impl in APK[16/11/17]
			//String sql = "select EMP_CODE,ENTITY_CODE,PROFILE_ID,USER_TYPE,CHG_TERM,USER_THEME,USER_COUNTRY,USER_LANG,TRANS_DB,SITE_CODE__DEF,ENTERPRISE from users where code='"+userId+"'";
			//Changed By Pankaj T. on 21-10-19 set USER_CODE, MOBILE_NO, EMAIL_ID of user in userInfo
			//Added by Sainath T.on 17-07-2020 [For gaction authentication]
			String sql = "SELECT CODE,EMP_CODE,ENTITY_CODE,PROFILE_ID,USER_TYPE,CHG_TERM,USER_THEME,USER_COUNTRY,USER_LANG,TRANS_DB,SITE_CODE__DEF,ENTERPRISE,PASS_WD_SHA,NAME,USER_ID,MOBILE_NO,EMAIL_ID "
					+ " FROM USERS "
					+ " WHERE "+ whereConditionColumn + " = '"+ userId +"' ";
			resultSet = statement.executeQuery(sql);
			if(resultSet.next())
			{
				//Added by Sainath T.on 17-07-2020 [For gaction authentication]
				userInfoBean.setLoginCode(E12GenericUtility.checkNull(resultSet.getString("CODE")));
				userInfoBean.setEmpCode(E12GenericUtility.checkNull(resultSet.getString("EMP_CODE")));
				userInfoBean.setEntityCode(E12GenericUtility.checkNull(resultSet.getString("ENTITY_CODE")));
				userInfoBean.setProfileId(E12GenericUtility.checkNull(resultSet.getString("PROFILE_ID")));
				userInfoBean.setUserType(E12GenericUtility.checkNull(resultSet.getString("USER_TYPE")));
				userInfoBean.setRemoteHost(E12GenericUtility.checkNull(resultSet.getString("CHG_TERM")));
				userInfoBean.setUserTheme(E12GenericUtility.checkNull(resultSet.getString("USER_THEME")));
				userInfoBean.setUserCountry(E12GenericUtility.checkNull(resultSet.getString("USER_COUNTRY")));
				userInfoBean.setUserLanguage(E12GenericUtility.checkNull(resultSet.getString("USER_LANG")));
				userInfoBean.setTransDB(E12GenericUtility.checkNull(resultSet.getString("TRANS_DB")));
				userInfoBean.setSiteCode(E12GenericUtility.checkNull(resultSet.getString("SITE_CODE__DEF")));
				userInfoBean.setEnterprise(E12GenericUtility.checkNull(resultSet.getString("ENTERPRISE")));
				//Added by Sagar B. for forgot password impl in APK[16/11/17]START
				userInfoBean.setLoginPwd(E12GenericUtility.checkNull(resultSet.getString("PASS_WD_SHA")));
				userInfoBean.setUserName(E12GenericUtility.checkNull(resultSet.getString("NAME")));
				//Added by Sagar B. for forgot password impl in APK[16/11/17]END
				//Changed By Pankaj T. on 21-10-19 set USER_CODE, MOBILE_NO, EMAIL_ID of user in userInfo -start
				userInfoBean.setLoginUserId(E12GenericUtility.checkNull(resultSet.getString("USER_ID")));
				userInfoBean.setLoginMobileNo(E12GenericUtility.checkNull(resultSet.getString("MOBILE_NO")));
				userInfoBean.setLoginEmailId(E12GenericUtility.checkNull(resultSet.getString("EMAIL_ID")));
				//Changed By Pankaj T. on 21-10-19 set USER_CODE, MOBILE_NO, EMAIL_ID of user in userInfo - end
				
				//Added by pankaj T. on 10-04-2020 for  Configure SMTP mail server against ENTERPRISE - start
				if( E12GenericUtility.checkNull(userInfoBean.getTransDB()).length() > 0 )
				{
					conn = connDriver.getConnectDB(userInfoBean.getTransDB());
					if( "".equals(E12GenericUtility.checkNull(userInfoBean.getEnterprise())) )
					{
						String sqlString = "select ENTERPRISE from site where site_code=?";
						BaseLogger.log("3",null,null,"siteCode["+userInfoBean.getSiteCode()+"]");
						pstmt = conn.prepareStatement(sqlString);
						pstmt.setString(1,userInfoBean.getSiteCode());
						rs = pstmt.executeQuery();
						while (rs.next())
						{
							userInfoBean.setEnterprise(E12GenericUtility.checkNull(rs.getString("ENTERPRISE")));
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;	
					}
					// Added by Gagan B. to set DOC_SERVER_ID in userInfo on 22-07-2022 [START]
					if( E12GenericUtility.checkNull(userInfoBean.getEnterprise()).length() > 0 )
					{
						String sqlString = "SELECT DOC_SERVER_ID, SMTP_FALLBACK FROM ENTERPRISE WHERE ENTERPRISE = ?";
						BaseLogger.log("3",null,null,"enterprise["+userInfoBean.getEnterprise()+"]");
						pstmt = conn.prepareStatement(sqlString);
						pstmt.setString(1,userInfoBean.getEnterprise());
						rs = pstmt.executeQuery();
						while (rs.next())
						{
							userInfoBean.setDocServerID(rs.getString("DOC_SERVER_ID"));
							BaseLogger.log("3",null,null,"DOC_SERVER_ID FROM ["+rs.getString("DOC_SERVER_ID")+"]");
							userInfoBean.setSmtpFallback(rs.getString("SMTP_FALLBACK"));
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
					}
					// Added by Gagan B. to set DOC_SERVER_ID in userInfo on 22-07-2022 [END]
					
					//Changed by Pooja S on 6-NOV-2020 [//Changed by Pooja S on 6-NOV-2020 [passord should sent from common definition, not from enterprise]]
					if( E12GenericUtility.checkNull(userInfoBean.getEnterprise()).length() > 0 && isMailConfReq )
					{
						String sqlString = "SELECT ENTERPRISE_DESCR, SMTP_HOST, SMTP_PORT, SMTP_USER, SMTP_PASS_WD, SMTP_PROTOCOL_TYPE, SMTP_MAILFROM, EMAIL_ID, SESS_TIMEOUT_SEC FROM ENTERPRISE WHERE ENTERPRISE = ?";
						BaseLogger.log("3",null,null,"enterprise["+userInfoBean.getEnterprise()+"]");
						pstmt = conn.prepareStatement(sqlString);
						pstmt.setString(1,userInfoBean.getEnterprise());
						rs = pstmt.executeQuery();
						while (rs.next())
						{
							userInfoBean.setEnterpriseDescr(rs.getString("ENTERPRISE_DESCR"));
							userInfoBean.setSmtpHost(rs.getString("SMTP_HOST"));
							userInfoBean.setSmtpPort(rs.getString("SMTP_PORT"));
							userInfoBean.setSmtpUser(rs.getString("SMTP_USER"));
							userInfoBean.setSmtpPassWD(rs.getString("SMTP_PASS_WD"));
							userInfoBean.setSmtpProtocolType(rs.getString("SMTP_PROTOCOL_TYPE"));
							userInfoBean.setSmtpMailFrom(rs.getString("SMTP_MAILFROM"));
							userInfoBean.setAdminEmailId(rs.getString("EMAIL_ID"));
                            userInfoBean.setSessTimeoutInSec(rs.getString("SESS_TIMEOUT_SEC")); //Added by Jatin M on 24-Jun-2022 [To set prior session timeout in UserInfoBean]
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
					}
				}
				//Added by pankaj T. on 10-04-2020 for Configure SMTP mail server against ENTERPRISE - end
				//Added By Pankaj T. on 01-02-2021 to set chg_term of logintrace as a termid in userinfo - start
				String termIdSQL = "SELECT CHG_TERM FROM LOGINTRACE WHERE USERID = ? AND LOGINTIME = ( SELECT MAX(LOGINTIME) FROM LOGINTRACE WHERE USERID = ? AND LOGIN_STATUS = ? )";
				preparedStatement = connection.prepareStatement(termIdSQL);
				preparedStatement.setString(1, userId);
				preparedStatement.setString(2, userId);
				preparedStatement.setString(3, "T");
				res = preparedStatement.executeQuery();
				if( res.next() )
				{
					userInfoBean.setTermId( res.getString("CHG_TERM") );
				}
				preparedStatement.close();
				preparedStatement = null;
				res.close();
				res = null;
				//Added By Pankaj T. on 01-02-2021 to set chg_term of logintrace as a termid in userinfo - end
				BaseLogger.log("3",null,null,"CommonDBAccessEjb createUserInfo()::::::"+userInfoBean.toString());
				if( E12GenericUtility.checkNull(userInfoBean.getTransDB()).length() > 0 )
				{
                    System.out.println("Vikas Dremio ..  "+userInfoBean.getTransDB());
                    try
                    {
                        setUserInfoInMem(userInfoBean.getTransDB(), userInfoBean);                    
                    }
                    catch ( Exception e )
                    {
                        System.out.println("Exception Vikas "+e.getMessage());
                    }
	            }
			}
		} 
		catch (Exception e) 
		{
			BaseLogger.log("0",null,null,"Exception in CommonDBAccessEJB createUserInfo()........."+e);
		}
		finally 
		{
			if (resultSet != null) resultSet.close();
			if (statement != null) statement.close();
			if (connection != null) connection.close();
			//Added by pankaj T. on 10-04-2020 for Configure SMTP mail server against ENTERPRISE - start
			if( rs != null )
			{
				rs.close();
				rs =null;
			}
			if( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			if( conn != null )
			{
				conn.close();
				conn = null;
			}
			//Added by pankaj T. on 10-04-2020 for Configure SMTP mail server against ENTERPRISE - end
			//Added By Pankaj T. on 01-02-2021 to set chg_term of logintrace as a termid in userinfo - start
			if( preparedStatement != null )
			{
				preparedStatement.close();
				preparedStatement = null;
			}
			if( res != null )
			{
				res.close();
				res = null;
			}
			//Added By Pankaj T. on 01-02-2021 to set chg_term of logintrace as a termid in userinfo - end
		}			
		return userInfoBean;
	}
	//Added by Pankaj on 20-sep-2016 [S16FBAS008][for create userinfo object] End

	//Added by Sandesh on 18/11/2016 [For Authentication API] Start	
	/**
	 * This method is for checking user login attempts for last 10 attempts in 5 minutes. 
	 * 
	 */
	@Override
	public boolean checkLoginAttempts(String userId) throws BaseException, Exception {

		ConnDriver connDriver = null;
		Connection connection = null;
		PreparedStatement preparedStatement = null;
		ResultSet resultSet = null;
		boolean isAllow = true;
		java.sql.Timestamp fiveMinDuration = new java.sql.Timestamp(System.currentTimeMillis() - 5*60*1000 );

		try 
		{
			BaseLogger.log("3",null,null,"CommonDBAccessEJB :: checkLoginAttempts ");
			connDriver = new ConnDriver();
			connection = connDriver.getConnectDB("Driver");
			//Change by prathamesh jangam on 29jun17 for db2
			String dbName =CommonConstants.DB_NAME;
			if("DB2".equalsIgnoreCase(dbName))
			{
				String sqlQuery = "SELECT LOGIN_STATUS FROM LOGINTRACE WHERE USERID = ? "
						+ " AND LOGINTIME >= ? "
						+"ORDER BY LOGINTIME FETCH FIRST 10 ROWS ONLY";
				//+ " AND ROWNUM < 11 ORDER BY LOGINTIME DESC";
				preparedStatement = connection.prepareStatement( sqlQuery );
				preparedStatement.setString( 1, userId );
				//preparedStatement.setString(2, fiveMinDuration.toString().substring(0, 19));
				preparedStatement.setTimestamp(2,fiveMinDuration);	

			}
			//Changes by Prajyot on 28-Jun-18 [MSSQL - Change for TO_DATE and ROWNUM ] Start 
			else if("MSSQL".equalsIgnoreCase(dbName))
			{
				String sqlQuery = "SELECT TOP 10 LOGIN_STATUS FROM LOGINTRACE WHERE USERID = ? "
						+ " AND LOGINTIME >= CONVERT( datetime,  ? ) "
						+ " ORDER BY LOGINTIME DESC";
				preparedStatement = connection.prepareStatement( sqlQuery );
				preparedStatement.setString( 1, userId );
				//preparedStatement.setString(2, fiveMinDuration.toString().substring(0, 19));
				preparedStatement.setTimestamp(2,fiveMinDuration);	

			}
			//Changes by Prajyot on 28-Jun-18 [MSSQL - Change for TO_DATE and ROWNUM ] End
			//Added by sunny soni for running mysql to_date function run[Start]
			else if("MYSQL".equalsIgnoreCase(dbName)){

				String sqlQuery = "SELECT LOGIN_STATUS FROM LOGINTRACE WHERE USERID = ? "
						+ " AND LOGINTIME >= STR_TO_DATE( ?, '%Y-%m-%d %H:%i:%s') "
						+ " ORDER BY LOGINTIME DESC LIMIT 11";

				preparedStatement = connection.prepareStatement( sqlQuery );
				preparedStatement.setString( 1, userId );
				preparedStatement.setString(2, fiveMinDuration.toString().substring(0, 19));

			
			}
			//Added by sunny soni for running mysql to_date function run[End]
			else
			{
				String sqlQuery = "SELECT LOGIN_STATUS FROM LOGINTRACE WHERE USERID = ? "
						+ " AND LOGINTIME >= TO_DATE( ?, 'YYYY-MM-DD HH24:MI:SS') "
						+ " AND ROWNUM < 11 ORDER BY LOGINTIME DESC";

				preparedStatement = connection.prepareStatement( sqlQuery );
				preparedStatement.setString( 1, userId );
				preparedStatement.setString(2, fiveMinDuration.toString().substring(0, 19));

			}
			resultSet = preparedStatement.executeQuery();

			int size= 1;

			while(resultSet.next() && size < 11)
			{
				if (  E12GenericUtility.checkNull(resultSet.getString(1)).equals("T"))
				{
					isAllow = true;
					break;
				}
				else
				{
					isAllow = false;
				}
				size++;
			}

			BaseLogger.log("3",null,null,"CommonDBAccessEJB :: checkLoginAttempts: Last login attempt size: " + size);

			if (size <= 10)
			{
				isAllow = true;
			}

			BaseLogger.log("3",null,null,"CommonDBAccessEJB :: checkLoginAttempts : [" + isAllow +"]");
		} 
		catch (Exception e) 
		{
			BaseLogger.log("0",null,null,"Exception in CommonDBAccessEJB checkLoginAttempts()........." + e);
			throw new BaseException(e);
		}
		finally 
		{
			if (resultSet != null) resultSet.close();
			if (preparedStatement != null) preparedStatement.close();
			if (connection != null) connection.close();
		}			
		return isAllow;
	}

	/**
	 * 
	 * This method is for getting application information based on appId
	 * 
	 */
	@Override
	public ExtAuthApplicationBean getExtAuthApplicationInfo(String appId) throws BaseException, Exception {

		ConnDriver connDriver = null;
		Connection connection = null;
		PreparedStatement preparedStatement = null;
		ResultSet resultSet = null;
		ExtAuthApplicationBean applicationBean = new ExtAuthApplicationBean();
		applicationBean.setAppId(appId);
		try 
		{
			BaseLogger.log("3",null,null,"CommonDBAccessEJB :: getExtAuthApplicationInfo ");
			connDriver = new ConnDriver();
			connection = connDriver.getConnectDB("Driver");
			String sqlQuery = "SELECT APP_NAME, REDIRECT_URL, DESCR, EFF_FROM, ACTIVE, ENABLE_SECURITY, SHARED_KEY, TTL, WHITE_LIST_IP, ENCRYPT_MTH, SECRET_KEY "
					+ " FROM AUTH_APPS WHERE APP_ID=?";
			preparedStatement = connection.prepareStatement( sqlQuery );
			preparedStatement.setString( 1, appId );
			resultSet = preparedStatement.executeQuery();

			if(resultSet.next())
			{
				applicationBean.setAppName(E12GenericUtility.checkNull(resultSet.getString("APP_NAME")));
				applicationBean.setAppRedirectURL(E12GenericUtility.checkNull(resultSet.getString("REDIRECT_URL")));
				applicationBean.setDescr(E12GenericUtility.checkNull(resultSet.getString("DESCR")));
				applicationBean.setEffFrom(E12GenericUtility.checkNull(resultSet.getString("EFF_FROM")));
				applicationBean.setActive(E12GenericUtility.checkNull(resultSet.getString("ACTIVE")));
				applicationBean.setEnableSecurity(E12GenericUtility.checkNull(resultSet.getString("ENABLE_SECURITY")));
				applicationBean.setSharedKey(E12GenericUtility.checkNull(resultSet.getString("SHARED_KEY")));
				applicationBean.setTtl(resultSet.getLong("TTL"));
				//Added by Amey W. [ For validate WHITE_LIST_IP ] on 21-09-2020
				applicationBean.setWhiteListIp(E12GenericUtility.checkNull(resultSet.getString("WHITE_LIST_IP")));
				//Added By Ravindra C on 06-08-21 to decrypt the Edi Data - START
				applicationBean.setEncryptMth(E12GenericUtility.checkNull(resultSet.getString("ENCRYPT_MTH")));
				applicationBean.setSecretKey(E12GenericUtility.checkNull(resultSet.getString("SECRET_KEY")));
				//Added By Ravindra C on 06-08-21 to decrypt the Edi Data - END
			}
			else
			{
				BaseLogger.log("3",null,null,"CommonDBAccessEJB :: getExtAuthApplicationInfo : No application found");
			}
		} 
		catch (Exception e) 
		{
			BaseLogger.log("0",null,null,"Exception in CommonDBAccessEJB getExtAuthApplicationInfo()........." + e);
		}
		finally 
		{
			if (resultSet != null) resultSet.close();
			if (preparedStatement != null) preparedStatement.close();
			if (connection != null) connection.close();
		}	

		return applicationBean;
	}

	/**
	 * This method is for getting user information based on userId.
	 * 
	 * @param userId
	 * @return UserBean
	 * @throws BaseException
	 * @throws Exception
	 */
	public ExtAuthRespBean getExtAuthRespBean(String userId) throws BaseException, Exception
	{
		ExtAuthRespBean userBean = new ExtAuthRespBean();
		ConnDriver connDriver = null;
		Connection connection = null;
		PreparedStatement preparedStatement = null;
		ResultSet resultSet = null;
		try 
		{
			BaseLogger.log("3",null,null,"CommonDBAccessEJB :: getExtAuthRespBean");
			UserInfoBean userInfoBean = createUserInfo(userId);
			String transDB = userInfoBean.getTransDB();
			connDriver = new ConnDriver();
			connection = connDriver.getConnectDB(transDB);

			//Added by Prasad on 08/01/2021 [adding userinfo related columns for external authentication] START
			userBean.setUserId(userId);

			/*String sqlQuery = "SELECT E.EMP_FNAME, E.EMP_LNAME, E.EMP_MNAME, E.DESIGNATION, E.REPORT_TO, ST.DESCR, E.EMAIL_ID_OFF, S.ITEM_SER"
					+ " FROM EMPLOYEE E, USERS U, SALES_PERS S, STATION ST WHERE  E.EMP_CODE = U.EMP_CODE AND S.SALES_PERS = U.EMP_CODE"
					+ " AND ST.STAN_CODE = E.STAN_CODE__HQ AND U.CODE = ?";*/
			String sqlQuery = "SELECT E.EMP_FNAME, E.EMP_LNAME, E.EMP_MNAME, E.DESIGNATION, E.REPORT_TO, ST.DESCR, E.EMAIL_ID_OFF, S.ITEM_SER, U.USER_TYPE, U.ENTITY_CODE, U.ENTERPRISE, U.TRANS_DB, U.SITE_CODE__DEF " + 
					" FROM USERS U " + 
					" LEFT JOIN EMPLOYEE E ON U.EMP_CODE = E.EMP_CODE " + 
					" LEFT JOIN STATION ST ON ST.STAN_CODE = E.STAN_CODE__HQ " + 
					" LEFT JOIN SALES_PERS S ON U.EMP_CODE = S.SALES_PERS " + 
					" WHERE U.CODE = ?";
			//Added by Prasad on 08/01/2021 [adding userinfo related columns for external authentication] END
			preparedStatement = connection.prepareStatement( sqlQuery );
			preparedStatement.setString( 1, userId );
			resultSet = preparedStatement.executeQuery();

			if(resultSet.next())
			{
				userBean.setFirstName(E12GenericUtility.checkNull(resultSet.getString(1)));
				userBean.setLastName(E12GenericUtility.checkNull(resultSet.getString(2)));
				userBean.setMiddleName(E12GenericUtility.checkNull(resultSet.getString(3)));
				userBean.setDesignation(E12GenericUtility.checkNull(resultSet.getString(4)));
				userBean.setReportToCode(E12GenericUtility.checkNull(resultSet.getString(5)));
				userBean.setHq(E12GenericUtility.checkNull(resultSet.getString(6)));
				userBean.setEmail(E12GenericUtility.checkNull(resultSet.getString(7)));
				userBean.setDivision(E12GenericUtility.checkNull(resultSet.getString(8)));
				//Added by Prasad on 08/01/2021 [adding userinfo related columns for external authentication] START
				userBean.setEntityType(E12GenericUtility.checkNull(resultSet.getString(9)));
				userBean.setEntityCode(E12GenericUtility.checkNull(resultSet.getString(10)));
				userBean.setEnterprise(E12GenericUtility.checkNull(resultSet.getString(11)));
				userBean.setTransDb(E12GenericUtility.checkNull(resultSet.getString(12)));
				userBean.setLoginSite(E12GenericUtility.checkNull(resultSet.getString(13)));
				//Added by Prasad on 08/01/2021 [adding userinfo related columns for external authentication] END
				//Added by Prasad on 01/04/2021 [profile_id added]
				userBean.setProfileId( E12GenericUtility.checkNull(userInfoBean.getProfileId()) );
			}
			else
			{
				BaseLogger.log("3",userInfoBean,null,"CommonDBAccessEJB :: getExtAuthRespBean: No user info found");
			}
			userBean.setRegion(E12GenericUtility.checkNull(getUserRegion(userId)));
		} 
		catch (Exception e) 
		{
			BaseLogger.log("0",null,null,"Exception in CommonDBAccessEJB getExtAuthRespBean()........." + e);
		}
		finally 
		{
			if (resultSet != null) resultSet.close();
			if (preparedStatement != null) preparedStatement.close();
			if (connection != null) connection.close();
		}

		return userBean;
	}

	/**
	 * 
	 * This method is for getting Region of user based on userCode.
	 * 
	 * @param userCode
	 * @return String
	 * @throws BaseException
	 * @throws Exception
	 */
	public String getUserRegion (String userCode)throws BaseException, Exception
	{
		Connection mConnection = null;
		CallableStatement cStmt = null;		
		String region = "";

		try
		{
			BaseLogger.log("3",null,null,"CommonDBAccessEJB :: getUserRegion");
			ConnDriver mConnDriver = new ConnDriver();
			mConnection = mConnDriver.getConnectDB("Driver");

			cStmt = mConnection.prepareCall("{? = call DDF_GET_REGION(?)}");
			cStmt.setString(2, userCode);
			cStmt.registerOutParameter(1,Types.VARCHAR);
			cStmt.executeUpdate();
			region = cStmt.getString(1);
			cStmt.close();
			cStmt = null;
		}
		catch (Exception e)
		{
			BaseLogger.log("0",null,null,"Exception : CommonDBAccessEJB : getUserRegion : "+e.getMessage());
		}
		finally
		{
			if (cStmt != null) cStmt.close();
			if (mConnection != null) mConnection.close();
		}
		return region;
	}

	/**
	 * 
	 * This method is for getting log in status of user based on userId and sessionid.
	 * 
	 * @param userId
	 * @param sessionId
	 * @return String
	 * @throws BaseException
	 * @throws Exception
	 */
	public String getLoginStatus(String userId, String sessionId) throws BaseException, Exception
	{
		String logout = "";
		ConnDriver connDriver = null;
		Connection connection = null;
		PreparedStatement preparedStatement = null;
		ResultSet resultSet = null;
		try 
		{
			BaseLogger.log("3",null,null,"CommonDBAccessEJB :: getLoginStatus");
			connDriver = new ConnDriver();
			connection = connDriver.getConnectDB("Driver");
			String sqlQuery = "SELECT LOGOUTTIME FROM LOGINTRACE WHERE USERID= ? AND SESSIONID = ?";
			preparedStatement = connection.prepareStatement( sqlQuery );
			preparedStatement.setString( 1, userId );
			preparedStatement.setString( 2, sessionId );
			resultSet = preparedStatement.executeQuery();

			if(resultSet.next())
			{
				logout = resultSet.getString(1);
			}
			else
			{
				logout = "invalid";
			}

		} 
		catch (Exception e) 
		{
			BaseLogger.log("0",null,null,"Exception in CommonDBAccessEJB getLoginStatus()........." + e);
		}
		finally 
		{
			if (resultSet != null) resultSet.close();
			if (preparedStatement != null) preparedStatement.close();
			if (connection != null) connection.close();
		}

		return logout;
	}
	//Added by Sandesh on 18/11/2016 [For Authentication API] End

	// Added by Sandesh Shinde on 17-MAY-2017 [ Authentication API: Improper Error handling] Start
	/**
	 * Get message description from message table using msgNo
	 */
	public String getExceptionMsg(String msgNo, UserInfoBean userInfoBean) throws BaseException, Exception
	{
		//Added by Prasad on 29/03/2021 [user common method] START
		/*String excepMsg = "";
		ConnDriver connDriver = null;
		Connection connection = null;
		PreparedStatement preparedStatement = null;
		ResultSet resultSet = null;
		try 
		{
			BaseLogger.log("3",userInfoBean,null,"CommonDBAccessEJB :: getExceptionMsg");
			connDriver = new ConnDriver();
			//String transDB = userInfoBean.getTransDB();
			connection = connDriver.getConnectDB("Driver");
			//connection = connDriver.getConnectDB(transDB);
			String sqlQuery = "SELECT MSG_DESCR FROM MESSAGES WHERE MSG_NO = ?";
			preparedStatement = connection.prepareStatement( sqlQuery );
			preparedStatement.setString( 1, msgNo);
			resultSet = preparedStatement.executeQuery();

			if(resultSet.next())
			{
				excepMsg = resultSet.getString(1);
			}
			else
			{
				excepMsg = "";
			}

		} 
		catch (Exception e) 
		{
			BaseLogger.log("0",userInfoBean,null,"Exception in CommonDBAccessEJB getExceptionMsg()........." + e);
		}
		finally 
		{
			if (resultSet != null) resultSet.close();
			if (preparedStatement != null) preparedStatement.close();
			if (connection != null) connection.close();
		}

		return excepMsg;*/
		return getMessageDescr( msgNo, null, userInfoBean );
		//Added by Prasad on 29/03/2021 [user common method] END
	}

	// Added by Sandesh Shinde on 17-MAY-2017 [ Authentication API: Improper Error handling] End

	// Added by Ajinkya Darvesh on 04-AUG-2017 [for Employee Leave Calendar View] [START]
	public String getRegisterLeave(String empcode, String periodcode) throws BaseException, Exception
	{
		BaseLogger.log("2",null,null,"CommonDBAccessEJB :: getRegisterLeave method is called");
		ConnDriver connDriver = null;
		Connection connection = null;
		PreparedStatement preparedStatement = null;
		ResultSet resultSet = null;
		StringBuffer leavereportBuff=null;
		String prvEmpCode="";
		String empCode="";
		try 
		{
			E12GenericUtility genericUtility=new E12GenericUtility();
			BaseLogger.log("3",null,null,"CommonDBAccessEJB :: getRegisterLeave");
			connDriver = new ConnDriver();
			connection = connDriver.getConnectDB("Driver");
			String sqlQuery = "select A.EMP_CODE, A.EMP_NAME, A.USER_ID, A.DAYS, B.PRD_CODE, trim(B.LVE_CODE) LVE_CODE, B.LEAVES " +
					" from ( SELECT H.EMP_CODE,H.EMP_NAME,H.USER_ID,B.DAYS " +
					" FROM (select employee.emp_code, employee.emp_fname ||' '|| employee.emp_mname ||' '||employee.emp_lname as emp_name, " +
					" (SELECT NAME FROM USERS WHERE EMP_CODE = ? ) AS USER_ID " +
					" FROM EMPLOYEE start with employee.emp_code = ? connect by prior " +
					" employee.emp_code = employee.report_to) H, " +
					" (select to_date((select p.fr_date from period p where p.code= ? ),'dd-mm-yy')+level-1 as days " +
					" from dual connect by level <= TO_CHAR(to_date((select p.to_date from period p where p.code=?),'dd-mm-yy'),'DD')) B ) a " +
					" left outer join (SELECT P.*, to_date(row1.ab)+row1.bc as dates " +
					" FROM (SELECT A.EMP_CODE,B.LVE_CODE,B.LEAVES,B.LEAVE_TO,B.LEAVE_FROM, B.PRD_CODE " +
					" FROM ((SELECT EMP.EMP_CODE FROM EMPLOYEE EMP START WITH EMP.EMP_CODE= ? connect by prior emp.emp_code = emp.report_to)A " +
					" INNER JOIN (SELECT EMP_SUM.EMP_CODE, EMP_SUM.LVE_CODE, (CASE WHEN EMP_SUM.LVE_CODE IN ('PL','SL','LWP') THEN ' ' END) AS LEAVES, " +
					" EMP_SUM.LVE_DATE_FR AS LEAVE_FROM, EMP_SUM.LVE_DATE_TO AS LEAVE_TO, to_date(EMP_SUM.LVE_DATE_TO) - to_date(EMP_SUM.LVE_DATE_FR) as date_diff, " +
					" EMP_SUM.PRD_CODE FROM EMPLEAVE_SUMMARY EMP_SUM )B ON A.EMP_CODE=B.EMP_CODE))P, " +
					" TABLE(fn_recp_coupen(P.LEAVE_FROM,(to_date(P.LEAVE_TO) - to_date(P.LEAVE_FROM)))) row1 )b " +
					" ON A.EMP_CODE = B.EMP_CODE and a.days = b.dates order by A.EMP_CODE, A.DAYS ";
			preparedStatement = connection.prepareStatement( sqlQuery );
			preparedStatement.setString( 1, empcode );
			preparedStatement.setString( 2, empcode );
			preparedStatement.setString( 3, periodcode );
			preparedStatement.setString( 4, periodcode);
			preparedStatement.setString( 5, empcode );
			resultSet = preparedStatement.executeQuery();

			BaseLogger.log("3",null,null,"CommonDBAccessEJB :: getRegisterLeave query executed");

			leavereportBuff = new StringBuffer();
			leavereportBuff.append("<Root>");
			int empDetCount = 1;
			int leaveDetCount = 1;
			while( resultSet.next() )
			{
				String leaveDate = resultSet.getString("DAYS");
				String date = genericUtility.getValidDateString(leaveDate, genericUtility.getDBDateFormat(), "dd-MMM-yyyy");
				String day = date.substring(0, date.indexOf("-"));
				empCode = resultSet.getString("EMP_CODE");
				if( ! prvEmpCode.equalsIgnoreCase( empCode ) )
				{
					prvEmpCode=empCode;
					leavereportBuff.append("<EMP_DETAILS id=\""+ empDetCount +"\">\n");
					leavereportBuff.append("<EMP_CODE><![CDATA["+ empCode +"]]></EMP_CODE>\n");
					leavereportBuff.append("<EMP_NAME><![CDATA["+ resultSet.getString("EMP_NAME") +"]]></EMP_NAME>\n");
					leavereportBuff.append("<PRD_CODE><![CDATA["+ periodcode +"]]></PRD_CODE>\n");
					leavereportBuff.append("<USER_NAME><![CDATA["+ resultSet.getString("USER_ID") +"]]></USER_NAME>\n");
					leavereportBuff.append("</EMP_DETAILS>\n");

					empDetCount++;
				}
				leavereportBuff.append("<EMP_LEAVE_DETAILS id=\""+ leaveDetCount +"\">\n");
				leavereportBuff.append("<EMP_CODE><![CDATA["+ empCode +"]]></EMP_CODE>\n");
				leavereportBuff.append("<DATE><![CDATA["+ leaveDate +"]]></DATE>\n");
				leavereportBuff.append("<DAY><![CDATA["+ day +"]]></DAY>\n");
				leavereportBuff.append("<LVE_CODE><![CDATA["+ E12GenericUtility.checkNull(resultSet.getString("LVE_CODE")) +"]]></LVE_CODE>\n");
				leavereportBuff.append("<LEAVES><![CDATA["+ resultSet.getString("LEAVES") +"]]></LEAVES>\n");
				leavereportBuff.append("</EMP_LEAVE_DETAILS>\n");

				leaveDetCount++;
			}
			leavereportBuff.append("</Root>");

			BaseLogger.log("3",null,null,"CommonDBAccessEJB :: RegisterLeave xml executed");
		} 
		catch (Exception e) 
		{
			BaseLogger.log("0",null,null,"Exception in CommonDBAccessEJB getRegisterLeave()........." + e);
		}
		finally 
		{
			if (resultSet != null) resultSet.close();
			if (preparedStatement != null) preparedStatement.close();
			if (connection != null) connection.close();
		}
		return leavereportBuff.toString();
	}
	// Added by Ajinkya Darvesh on 04-AUG-2017 [for Employee Leave Calendar View] [END]
	//Added by sunny soni for resolving multiple push notification issue [Start]
	public ArrayList<String> getDeviceRegisteredId(String tableName, String columnName, String condition, String androidRegId) throws ITMException
	{
		ArrayList<String> deviceRegisteredId = new ArrayList<String>();
		String sql = "";		
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		Connection conn = null;
		try
		{			
			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB( "Driver" );
			sql = " SELECT " +  columnName + " FROM " + tableName + " " + condition ;
			pstmt = conn.prepareStatement( sql );
			rs = pstmt.executeQuery();
			while( rs.next() )
			{
				String existDeviceId = E12GenericUtility.checkNull(rs.getString(1));
				if( existDeviceId.indexOf(androidRegId) != -1 )
				{
					deviceRegisteredId.add(existDeviceId);
					break;
				}
			}
			if( rs !=null )
			{
				rs.close();
				rs = null;
			}
			if( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
		}
		catch( Exception exp )
		{
			BaseLogger.log("0",null,null,"Excepton in getDeviceRegisteredId -- >"+exp.getMessage());
			exp.printStackTrace();
		}
		finally
		{
			try
			{
				if(rs!=null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(conn !=null)
				{
					conn.close();
					conn = null;
				}
			}
			catch(SQLException se)
			{
				se.printStackTrace();
				throw new ITMException(se);
			}
		}
		BaseLogger.log("2",null,null,"deviceRegisteredId::: "+deviceRegisteredId);
		return deviceRegisteredId;
	}
	//Added by sunny soni for resolving multiple push notification issue [End]
	//Added by Santosh on 27-10-2017 to read SEC_COMM_MODE from profile master to send verification code to mobile/Email [Start]
	//Added by Pankaj T on 12-01-18 [changes for multitenancy]
	private List<String> getMobileEmailDetails(String userType, String entityCode, UserInfoBean userInfo) throws ITMException
	{
		List<String> retMobileNoEmailList = null;
		String masterTable = "", whereFieldName = "", selMobFieldName = "", selEmailFieldName = "",whereCondition = "";
		String retSmsMobNo = "", retEmailId = "";
		try
		{
			//Added by Pankaj T on 12-01-18 [changes for multitenancy]
			String transDB = userInfo.getTransDB();
			if(userType.length() > 0 && entityCode.length()>0)
			{
				if ("C".equalsIgnoreCase(userType))
				{
					masterTable = "CUSTOMER";
					whereFieldName = "CUST_CODE";
					selMobFieldName = "TELE3";
					selEmailFieldName = "EMAIL_ADDR";
				}
				else if ("S".equalsIgnoreCase(userType))
				{
					masterTable = "SUPPLIER";
					whereFieldName = "SUPP_CODE";
					selMobFieldName = "TELE3";
					selEmailFieldName = "EMAIL_ADDR";
				}
				else if ("E".equalsIgnoreCase(userType))
				{
					masterTable = "EMPLOYEE";
					whereFieldName = "EMP_CODE";
					selMobFieldName = "MOBILE_NO";
					selEmailFieldName = "EMAIL_ID_OFF";
				}
				else if ("P".equalsIgnoreCase(userType))
				{
					masterTable = "SALES_PERS";
					whereFieldName = "SALES_PERS";
					selMobFieldName = "TELE3";
					selEmailFieldName = "EMAIL_ADDR";
				}
				else if ("T".equalsIgnoreCase(userType))
				{
					masterTable = "TRANSPORTER";
					whereFieldName = "TRAN_CODE";
					selMobFieldName = "TELE3";
					selEmailFieldName = "EMAIL_ADDR";
				}
				
				AppConnectParm appConnect = new AppConnectParm();
				InitialContext ctx = new InitialContext(appConnect.getProperty());
				//DBAccessLocal dbAccess =(DBAccessLocal)ctx.lookup("ibase/DBAccessEJB/local");
				DBAccessEJB dbAccess = new DBAccessEJB();
				
				whereCondition = whereFieldName + " = '" + entityCode + "'";
				//Added by Pankaj T on 12-01-18 [changes for multitenancy]
				//retSmsMobNo = dbAccess.getDBColumnValue(masterTable, selMobFieldName, whereCondition, transDB);
				retEmailId = dbAccess.getDBColumnValue(masterTable, selEmailFieldName, whereCondition, transDB);
				
				retMobileNoEmailList = new ArrayList<String>();
				retMobileNoEmailList.add(retSmsMobNo);
				retMobileNoEmailList.add(retEmailId);
				dbAccess = null;
				BaseLogger.log("3",userInfo,null,"retMobileNoEmailList["+retMobileNoEmailList+"] with size ["+retMobileNoEmailList.size()+"]");
			}
			
		}
		catch(Exception e)
		{
			BaseLogger.log("2",userInfo,null,"CommonDBAccessEJB.getMobileNo()["+e.getMessage()+"]");
			e.printStackTrace();
			throw new ITMException(e);
		}
		
		return retMobileNoEmailList;
	}
	public String getSecurityCommMode( String userCode ) throws ITMException
	{
		String retSecCommMode = "", profileId = "";
		
		String sqlQuery = "";
		Connection mConnection = null;
		PreparedStatement pStatement = null;
		ResultSet mResultSet = null;
		
		try
		{
			ConnDriver mConnDriver = new ConnDriver();
			mConnection = mConnDriver.getConnectDB("Driver");
			
			sqlQuery = "SELECT PROFILE_ID FROM USERS WHERE CODE = ?";
			pStatement = mConnection.prepareStatement(sqlQuery);
			pStatement.setString(1, userCode);
			mResultSet = pStatement.executeQuery();
			
			if(mResultSet.next())
			{
				profileId = E12GenericUtility.checkNull(mResultSet.getString(1));
			}
			
			if(mResultSet!=null)
			{
				mResultSet.close();
				mResultSet = null;
			}
			if(pStatement!=null)
			{
				pStatement.close();
				pStatement=null;
			}
			//Changed by Sagar B. for multiple profile id related changes[11-Dec-17]
			//sqlQuery = "SELECT SEC_COMM_MODE FROM PROFILE WHERE PROFILE_ID = ?";
			sqlQuery = "SELECT SEC_COMM_MODE FROM PROFILE WHERE PROFILE_ID IN "+ E12GenericUtility.getFormattedProfileId(profileId);
			pStatement = mConnection.prepareStatement(sqlQuery);
			//pStatement.setString(1, profileId);
			mResultSet = pStatement.executeQuery();
			
			if(mResultSet.next())
			{
				retSecCommMode = E12GenericUtility.checkNull(mResultSet.getString(1));
			}
			
			if(mResultSet!=null)
			{
				mResultSet.close();
				mResultSet = null;
			}
			if(pStatement!=null)
			{
				pStatement.close();
				pStatement=null;
			}
		}
		catch(Exception e)
		{
			BaseLogger.log("0",null,null,"CommonDBAccessEJB.getSecurityCommMode()["+e.getMessage()+"]");
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(mResultSet!=null)
				{
					mResultSet.close();
					mResultSet = null;
				}
				if(pStatement!=null)
				{
					pStatement.close();
					pStatement=null;
				}
				if(mConnection!= null && !mConnection.isClosed())
				{
					mConnection.close();
					mConnection = null;
				}
			}
			catch(SQLException se)
			{
				BaseLogger.log("0",null,null,"CommonDBAccessEJB.getSecurityCommMode().finally["+se.getMessage()+"]");
				se.printStackTrace();
				throw new ITMException(se);
			}
		}
		
		return retSecCommMode;
	}
	//Added by Santosh on 27-10-2017 to read SEC_COMM_MODE from profile master to send verification code to mobile/Email [End]
	
	//Added by Sandeep S. on 02-NOV-2017 [To update status of user is active or not when delete the connection and To check the status of user is active or not when sending push notification] Start
	public String updateActiveStatus(String userId, String deviceId) throws BaseException
	{
		Connection mConnection = null;
		PreparedStatement mStatement = null;
		String responseStr = "";
		try 
		{
			UserInfoBean userInfoBean = createUserInfo(userId);
			String transDB = userInfoBean.getTransDB();
			ConnDriver mConnDriver = new ConnDriver();
			mConnection = mConnDriver.getConnectDB(transDB);

			String query = "";
			StringBuilder condition = new StringBuilder();
			condition.append( " WHERE USER_ID='" ).append( userId ).append( "' " );
			condition.append( " AND DEVICE_ID__PUSH='" ).append( deviceId ).append( "' ");
			query = "UPDATE USER_DEVICE SET ACTIVE = 'N' "+condition.toString();
			mStatement = mConnection.prepareStatement(query);
			int rowCnt = mStatement.executeUpdate();
			BaseLogger.log("3",null,null,"CommonDBAccessEJB :updateActiveStatus :==> "+ rowCnt);
			mConnection.commit();
			mStatement.close();
			mStatement = null;
			mConnection.close();
			mConnection = null;
			responseStr = "success";
		}
		catch (Exception e) 
		{
			responseStr = "failure";
			BaseLogger.log("0",null,null,"Exception :CommonDBAccessEJB :updateActiveStatus :==>\n"+e); //$NON-NLS-1$
			try
			{
				if( mConnection != null )
				{
					mConnection.rollback();
					mConnection.close();
					mConnection = null;
				}
				if (mStatement != null)
				{					
					mStatement.close();
					mStatement = null;
				}
			}
			catch (Exception sqle )
			{
				throw new BaseException( sqle );
			}	
			throw new BaseException( e );
		}
		finally
		{
			try
			{
				
				if (mConnection != null)
				{					
					mConnection.close();
					mConnection = null;
				}
				if (mStatement != null)
				{					
					mStatement.close();
					mStatement = null;
				}
			}
			catch (Exception e)
			{
				throw new BaseException( e );
			}
		}
		return responseStr;
	}
	//Added by Sandeep S. on 02-NOV-2017 [To update status of user is active or not when delete the connection and To check the status of user is active or not when sending push notification] End
	
	//Added by Pankaj T on 19-12-17 [for multitenancy Added new method for getting transDB when authenticate] - Start
	public void getTransDB(String loginID) throws ITMException
	{
		String[] columns = {"CODE", "MOBILE_NO", "EMAIL_ID", "USER_ID"};
		String entryType = "K";			   
		String selectQuery = null;
		PreparedStatement pStatement = null;
		ResultSet mResultSet = null; 
		Connection mConnection = null;
		try 
		{
			ConnDriver connDriver = new ConnDriver();
			mConnection = connDriver.getConnectDB( "Driver" );
			for (int i = 0; i < columns.length; i++) 
			{
				selectQuery = "SELECT CODE,TRANS_DB FROM USERS WHERE " + columns[i] + " = ?";
				pStatement = mConnection.prepareStatement( selectQuery );
				pStatement.setString(1, loginID);
				mResultSet = pStatement.executeQuery();
	
				if (mResultSet.next()) 
				{
					entryType = ((i == 0) ? "C" :
								 (i == 1) ? "M" :
								 (i == 2) ? "E" : "U");
					loginID = !("C".equals(entryType)) ? mResultSet.getString("CODE") : loginID;		
					
					this.transDB= mResultSet.getString("TRANS_DB");
					break;
				}
				if(pStatement!=null)
				{
					pStatement.close();
					pStatement=null;
				}
				if(mResultSet!=null)
				{
					mResultSet.close();
					mResultSet = null;
				}
			}
			BaseLogger.log("3",null,null,"UserCode getTransDB():["+loginID+"]");
			BaseLogger.log("3",null,null,"transDB getTransDB():["+this.transDB+"]");
		}
		catch (Exception e) 
		{
			BaseLogger.log("0",null,null,"Exception in CommonDBAccessEJB.getTransDB():["+e.getMessage()+"]");
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(pStatement!=null)
				{
					pStatement.close();
					pStatement=null;
				}
				if(mResultSet!=null)
				{
					mResultSet.close();
					mResultSet = null;
				}
				if(mConnection!= null && !mConnection.isClosed())
				{
					mConnection.close();
					mConnection = null;
				}
			}
			catch(SQLException se)
			{
				BaseLogger.log("0",null,null,"CommonDBAccessEJB.getTransDB().finally["+se.getMessage()+"]");
				se.printStackTrace();
				throw new ITMException(se);
			}			
		}
	}
	//Added by Pankaj T on 19-12-17 [for multitenancy Added new method for getting transDB when authenticate] - End
	
	//Added by Sandeep S. on 01-Feb-18 [To check session exist or not for same user in Mobile apk] Start
	public boolean checkLogInTraceEntry( String loginCode , String sessionId)throws BaseException
	{
		Connection mConnection = null;
		PreparedStatement mStatement = null;
		ResultSet mResultSet = null;
		String sessionDestroy = null;
		boolean sessionFlag = false;
		try
		{
			ConnDriver mConnDriver = new ConnDriver();
			mConnection = mConnDriver.getConnectDB("Driver");	 //$NON-NLS-1$

			String query = "SELECT SESSION_DESTROY FROM LOGINTRACE WHERE USERID=? AND SESSIONID = ? "; //$NON-NLS-1$
			mStatement = mConnection.prepareStatement(query);
			mStatement.setString(1,loginCode);
			mStatement.setString(2,sessionId);

			mResultSet = mStatement.executeQuery();
			
			if (mResultSet.next()) 
			{
				sessionDestroy = mResultSet.getString("SESSION_DESTROY");
				sessionDestroy = E12GenericUtility.checkNull(sessionDestroy);
			}				
			BaseLogger.log("3",null,null, "checkLogInTraceEntry sessionDestroy :"+sessionDestroy ); //$NON-NLS-1$
			if( sessionDestroy != null && "Y".equalsIgnoreCase(sessionDestroy) )
			{
				sessionFlag = false;
			}
			else if( sessionDestroy != null && "".equalsIgnoreCase(sessionDestroy) )
			{
				sessionFlag = true;
			}
			
			if(mStatement!=null)
			{
				mStatement.close();
				mStatement=null;
			}
			if(mResultSet!=null)
			{
				mResultSet.close();
				mResultSet = null;
			}
			if(mConnection!= null && !mConnection.isClosed())
			{
				mConnection.close();
				mConnection = null;
			}
		}
		catch ( Exception e)
		{
			BaseLogger.log("0",null,null,"Exception in CommonDBAccessEJB.checkLogInTraceEntry():["+e.getMessage()+"]");
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(mStatement!=null)
				{
					mStatement.close();
					mStatement=null;
				}
				if(mResultSet!=null)
				{
					mResultSet.close();
					mResultSet = null;
				}
				if(mConnection!= null && !mConnection.isClosed())
				{
					mConnection.close();
					mConnection = null;
				}
			}
			catch(SQLException se)
			{
				BaseLogger.log("0",null,null,"CommonDBAccessEJB.checkLogInTraceEntry.finally["+se.getMessage()+"]");
				se.printStackTrace();
				throw new ITMException(se);
			}
		}
		return sessionFlag;
	}
	//Added by Sandeep S. on 01-Feb-18 [To check session exist or not for same user in Mobile apk] End
	
	//Added By Pankaj T. on 18-06-18 for device security based on enterprise level [0-disabled, 1-strictly enforced, 2-OTP, 3-workflow invoked] - Start
	public String verifyDeviceSecurity(String userId, String deviceId, String deviceOS, String deviceType, String active, String chgUser, String chgTerm, String deviceMaker, String macAddress, boolean isDeviceVerified, String enterprise, String fromCache, String currentGeoPos, String action, String transDB, UserInfoBean userInfo )throws RemoteException, BaseException
	{
		String status = "";
		try
		{
			//Added By Pankaj T. on 26-03-2021 - to added new column "SECURITY_OPT" in users table to verify or bypass device security ( if SECURITY_OPT is B then bypass device security else verify device security - start 
			String securityOption = E12GenericUtility.checkNull( getDBColumnValue("USERS", "SECURITY_OPT", "WHERE CODE = '"+userId+"'", "Driver") );
			BaseLogger.log("2",userInfo,null,"CommonDBAccessEJB.verifyDeviceSecurity() securityOption::["+securityOption+"]");
			if( "B".equalsIgnoreCase(securityOption) )
			{
				return "true";
			}
			//Added By Pankaj T. on 26-03-2021 - to added new column "SECURITY_OPT" in users table to verify or bypass device security ( if SECURITY_OPT is B then bypass device security else verify device security - end
			
			//Added By Pankaj T. on 18-06-18 verify device security based on ip_security against enterprise [0 - Allow for any IP, 1 - STRICTLY_ENFORCED for WHITE_LIST_IP, 2 - Bypass device_security for WHITE_LIST_IP] - start
			boolean verifyDeviceSecurity = false;
			String ipSecurityStatus = E12GenericUtility.checkNull( verifyIPSecurity(userInfo, enterprise, chgTerm) );
			if( "".equals(ipSecurityStatus) || "VERIFY_DEVICE_SECURITY".equals(ipSecurityStatus) )
			{
				verifyDeviceSecurity = true;
			}
			else if( "STRICTLY_ENFORCED".equals(ipSecurityStatus) )
			{
				status = "STRICTLY_ENFORCED";
				verifyDeviceSecurity = false;
			}
			else if( "true".equals(ipSecurityStatus) )
			{
				status = "true";
				verifyDeviceSecurity = false;
			}
			BaseLogger.log("2",userInfo,null,"CommonDBAccessEJB.verifyDeviceSecurity() status::["+status+"]");
			BaseLogger.log("2",userInfo,null,"CommonDBAccessEJB.verifyDeviceSecurity() verifyDeviceSecurity::["+verifyDeviceSecurity+"]");
			//Added By Pankaj T. on 18-06-18 verify device security based on ip_security against enterprise [0 - Allow for any IP, 1 - STRICTLY_ENFORCED for WHITE_LIST_IP, 2 - Bypass device_security for WHITE_LIST_IP] - end
			if( verifyDeviceSecurity )
			{
				String deviceSecurity = E12GenericUtility.checkNull(getDBColumnValue("ENTERPRISE", "DEVICE_SECURITY", "WHERE ENTERPRISE = '"+enterprise+"'", transDB));
				BaseLogger.log("2",userInfo,null,"deviceSecurity:["+deviceSecurity+"]");
				BaseLogger.log("2",userInfo,null,"action:["+action+"]");
				BaseLogger.log("2",userInfo,null,"macAddress:["+macAddress+"]");
				BaseLogger.log("2",userInfo,null,"currentGeoPos:["+currentGeoPos+"]");
				BaseLogger.log("2",userInfo,null,"isDeviceVerified:["+isDeviceVerified+"]");
				if( "".equalsIgnoreCase(deviceSecurity) || "0".equalsIgnoreCase(deviceSecurity) )
				{
					status = "true";
				}
				else if( "1".equalsIgnoreCase(deviceSecurity) )
				{
					StringBuilder whereCondtion = new StringBuilder();
					BaseLogger.log("2",userInfo,null,"deviceOS is :["+deviceOS+"]");
					String device = "";
					if( "Browser".equalsIgnoreCase(deviceType) )
					{
						whereCondtion.append( " WHERE USER_ID ='" ).append( userId ).append( "' " );
						whereCondtion.append( " AND ACTIVE ='" ).append( "Y" ).append( "' ");
						whereCondtion.append( " AND DEVICE_TYPE ='" ).append( deviceType ).append( "' ");
						device = "Browser";
					}
					else if( deviceType.contains("iOS") || deviceType.contains("Android") )
					{
						whereCondtion.append( " WHERE USER_ID ='" ).append( userId ).append( "' " );
						whereCondtion.append( " AND ACTIVE ='" ).append( "Y" ).append( "' ");
						whereCondtion.append( " AND ( DEVICE_OS ='" ).append( "iOS" ).append( "' ");
						whereCondtion.append( " OR DEVICE_OS ='" ).append( "Android" ).append( "' )");
						device = "Mobile";
					}
					String isExists = E12GenericUtility.checkNull(getDBColumnValue("USER_DEVICE", "COUNT(*)", whereCondtion.toString()));
					int noOfRecCount = Integer.valueOf(isExists);
					BaseLogger.log("2",userInfo,null,"no of active record count against type "+device+" :::["+noOfRecCount+"]");
					
					StringBuilder condtion = new StringBuilder();
					condtion.append( " WHERE USER_ID ='" ).append( userId ).append( "' " );
					condtion.append( " AND ACTIVE ='" ).append( "Y" ).append( "' ");
					condtion.append( " AND DEVICE_MAC_ADDR ='" ).append( macAddress ).append( "' "); 
					String recExists = E12GenericUtility.checkNull(getDBColumnValue("USER_DEVICE", "COUNT(*)", condtion.toString()));
					int existRecCount = Integer.valueOf(recExists);
					BaseLogger.log("2",userInfo,null,"exist record count against macAddress:::["+existRecCount+"]");
					
					if( "MELOGIN".equals(action) )
					{
						if( noOfRecCount > 0 && existRecCount == 0 )
						{
							BaseLogger.log("2",userInfo,null,"user exist for "+deviceType);
							status = "STRICTLY_ENFORCED";
						}
						else
						{
							status = "true";
						}
					}
					else if( "BROWSERLOGIN".equals(action) )
					{
						whereCondtion = new StringBuilder();
						whereCondtion.append( " WHERE USER_ID ='" ).append( userId ).append( "' " );
						whereCondtion.append( " AND IP ='" ).append( chgTerm ).append( "' "); 
						String ipExist = E12GenericUtility.checkNull(getDBColumnValue("USER_IP", "COUNT(*)", whereCondtion.toString()));
						int existIPCount = Integer.valueOf(ipExist);
						BaseLogger.log("2",userInfo,null,"exist ip count:::["+existIPCount+"]");
						
						if( currentGeoPos.length() > 0 )
						{
							whereCondtion = new StringBuilder();
							whereCondtion.append( " WHERE USER_ID ='" ).append( userId ).append( "' " );
							whereCondtion.append( " AND GEOPOS ='" ).append( currentGeoPos ).append( "' "); 
							String geoposExist = E12GenericUtility.checkNull(getDBColumnValue("USER_GEOPOS", "COUNT(*)", whereCondtion.toString()));
							int existGeoPosCount = Integer.valueOf(geoposExist);
							BaseLogger.log("2",userInfo,null,"exist geopos count:::["+existGeoPosCount+"]");
							if( noOfRecCount == 0 )
							{
								status = "true";
							}
							else if( noOfRecCount > 0 && existRecCount == 0 )
							{
								BaseLogger.log("2",userInfo,null,"user exist for "+deviceType);
								status = "STRICTLY_ENFORCED";
							}
							else if( noOfRecCount > 0 && existRecCount > 0 && existIPCount > 0 && existGeoPosCount > 0 )
							{
								status = "true";						
							}
							else
							{
								BaseLogger.log("2",userInfo,null,"user exist for@@ "+deviceType);
								status = "STRICTLY_ENFORCED";
							}
						}
						else
						{
							if( noOfRecCount == 0 )
							{
								status = "true";
							}
							else if( noOfRecCount > 0 && existRecCount == 0 )
							{
								BaseLogger.log("2",userInfo,null,"user exist for "+deviceType);
								status = "STRICTLY_ENFORCED";
							}
							else if( noOfRecCount > 0 && existRecCount > 0 && existIPCount > 0 )
							{
								status = "true";
							}
							else
							{
								BaseLogger.log("2",userInfo,null,"user exist for@@ "+deviceType);
								status = "STRICTLY_ENFORCED";
							}
						}
					}
				}
				else if( "2".equalsIgnoreCase(deviceSecurity) )
				{
					StringBuilder whereCondtion = new StringBuilder();
					whereCondtion.append( " WHERE USER_ID ='" ).append( userId ).append( "' " );
					whereCondtion.append( " AND ACTIVE ='" ).append( "Y" ).append( "' ");
					whereCondtion.append( " AND DEVICE_MAC_ADDR ='" ).append( macAddress ).append( "' "); 
					String isExists = E12GenericUtility.checkNull(getDBColumnValue("USER_DEVICE", "COUNT(*)", whereCondtion.toString()));
					int existRecCount = Integer.valueOf(isExists);
					BaseLogger.log("2",userInfo,null,"exist record count against macAddress:::["+existRecCount+"]");
					
					if( "MELOGIN".equals(action) )
					{
						if( existRecCount == 0 && !(isDeviceVerified) )
						{
							BaseLogger.log("2",userInfo,null,"record exist");
							status = "VERIFY_USER_DEVICE";
						}
						else
						{
							status = "true";
						}
					}
					else if( "BROWSERLOGIN".equals(action) )
					{
						whereCondtion = new StringBuilder();
						whereCondtion.append( " WHERE USER_ID ='" ).append( userId ).append( "' " );
						whereCondtion.append( " AND IP ='" ).append( chgTerm ).append( "' "); 
						String ipExist = E12GenericUtility.checkNull(getDBColumnValue("USER_IP", "COUNT(*)", whereCondtion.toString()));
						int existIPCount = Integer.valueOf(ipExist);
						BaseLogger.log("2",userInfo,null,"exist ip count:::["+existIPCount+"]");
						
						if( currentGeoPos.length() > 0 )
						{
							whereCondtion = new StringBuilder();
							whereCondtion.append( " WHERE USER_ID ='" ).append( userId ).append( "' " );
							whereCondtion.append( " AND GEOPOS ='" ).append( currentGeoPos ).append( "' "); 
							String geoposExist = E12GenericUtility.checkNull(getDBColumnValue("USER_GEOPOS", "COUNT(*)", whereCondtion.toString()));
							int existGeoPosCount = Integer.valueOf(geoposExist);
							BaseLogger.log("2",userInfo,null,"exist geopos count:::["+existGeoPosCount+"]");
							
							if( existRecCount == 0 && !(isDeviceVerified) )
							{
								BaseLogger.log("2",userInfo,null,"user exist for "+deviceType);
								status = "VERIFY_USER_DEVICE";
							}
							else if( existRecCount == 0 && isDeviceVerified )
							{
								status = "true";
							}
							else if( existRecCount > 0 && !(isDeviceVerified)  && existIPCount > 0 && existGeoPosCount > 0 )
							{
								status = "true";						
							}
							else
							{
								BaseLogger.log("2",userInfo,null,"user exist for@@ "+deviceType);
								status = "VERIFY_USER_DEVICE";
							}
						}
						else
						{
							if(  existRecCount == 0 && !(isDeviceVerified) )
							{
								BaseLogger.log("2",userInfo,null,"user exist for "+deviceType);
								status = "VERIFY_USER_DEVICE";
							}
							else if( existRecCount == 0 && isDeviceVerified )
							{
								status = "true";
							}
							else if(  existRecCount > 0 && !(isDeviceVerified)  && existIPCount > 0 )
							{
								status = "true";
							}
							else
							{
								BaseLogger.log("2",userInfo,null,"user exist for@@ "+deviceType);
								status = "VERIFY_USER_DEVICE";
							}
						}
					}
				}
				else if( "3".equalsIgnoreCase(deviceSecurity) )
				{
					StringBuilder whereCondtion = new StringBuilder();
					whereCondtion.append( " WHERE USER_ID ='" ).append( userId ).append( "' " );
					whereCondtion.append( " AND ACTIVE ='" ).append( "Y" ).append( "' ");
					whereCondtion.append( " AND DEVICE_MAC_ADDR ='" ).append( macAddress ).append( "' "); 
					String isExists = E12GenericUtility.checkNull(getDBColumnValue("USER_DEVICE", "COUNT(*)", whereCondtion.toString()));
					int existRecCount = Integer.valueOf(isExists);
					BaseLogger.log("2",userInfo,null,"exist record count against macAddress:::["+existRecCount+"]");
					
					if( "MELOGIN".equals(action) )
					{
						if( existRecCount == 0 )
						{
							BaseLogger.log("2",userInfo,null,"record exist");
							status = "WORKFLOW_INVOKED";
						}
						else
						{
							status = "true";
						}
					}
					else if( "BROWSERLOGIN".equals(action) )
					{
						whereCondtion = new StringBuilder();
						whereCondtion.append( " WHERE USER_ID ='" ).append( userId ).append( "' " );
						whereCondtion.append( " AND IP ='" ).append( chgTerm ).append( "' "); 
						String ipExist = E12GenericUtility.checkNull(getDBColumnValue("USER_IP", "COUNT(*)", whereCondtion.toString()));
						int existIPCount = Integer.valueOf(ipExist);
						BaseLogger.log("2",userInfo,null,"exist ip count:::["+existIPCount+"]");
						
						if( currentGeoPos.length() > 0 )
						{
							whereCondtion = new StringBuilder();
							whereCondtion.append( " WHERE USER_ID ='" ).append( userId ).append( "' " );
							whereCondtion.append( " AND GEOPOS ='" ).append( currentGeoPos ).append( "' "); 
							String geoposExist = E12GenericUtility.checkNull(getDBColumnValue("USER_GEOPOS", "COUNT(*)", whereCondtion.toString()));
							int existGeoPosCount = Integer.valueOf(geoposExist);
							BaseLogger.log("2",userInfo,null,"exist geopos count:::["+existGeoPosCount+"]");
							
							if( existRecCount == 0 )
							{
								BaseLogger.log("9",null,null,"user exist for "+deviceType);
								status = "WORKFLOW_INVOKED";
							}
							else if( existRecCount > 0 && existIPCount > 0 && existGeoPosCount > 0 )
							{
								status = "true";						
							}
							else
							{
								BaseLogger.log("2",userInfo,null,"user exist for@@ "+deviceType);
								status = "WORKFLOW_INVOKED";
							}
						}
						else
						{
							if(  existRecCount == 0 )
							{
								BaseLogger.log("2",userInfo,null,"user exist for "+deviceType);
								status = "WORKFLOW_INVOKED";
							}
							else if(  existRecCount > 0 && existIPCount > 0 )
							{
								status = "true";
							}
							else
							{
								BaseLogger.log("2",userInfo,null,"user exist for@@ "+deviceType);
								status = "WORKFLOW_INVOKED";
							}
						}
					}
					//Added By Pankaj T. on 03-07-19 added new option in device security (3 - Admin Approval (More than one device tries to login then send approval to admin, if admin approves then only allow to login.) - start
					if( "WORKFLOW_INVOKED".equals(status) )
					{
						String userName = getDBColumnValue("USERS", "NAME", " WHERE CODE='"+userId+"'");
						userInfo.setUserLevel(userName);
						BaseLogger.log("2",userInfo,null,"In CommonDBAccessEJB.verifyDeviceSecurity() userName::["+userName+"]");
						
						StringBuilder whereCond = new StringBuilder();
						whereCond.append( " WHERE USER_ID ='" ).append( userId ).append( "' " );
						whereCond.append( " AND DEVICE_ID__PUSH ='" ).append( deviceId ).append( "' ");
						String recExists = E12GenericUtility.checkNull(getDBColumnValue("USER_DEVICE", "COUNT(*)", whereCond.toString()));
						int recExistRecCount = Integer.valueOf(recExists);
						BaseLogger.log("2",userInfo,null,"exist record count against user::["+recExistRecCount+"]");
						java.sql.Timestamp currTime =new java.sql.Timestamp(System.currentTimeMillis());
						
						StringBuffer xmlString = new StringBuffer("<?xml version = \"1.0\"?>"); 
						xmlString.append("<DocumentRoot>");
						xmlString.append("<description>").append("Datawindow Root").append("</description>");
						xmlString.append("<group0>");
						xmlString.append("<description>").append("Group0 description").append("</description>");
						xmlString.append("<Header0>");
						xmlString.append("<objName><![CDATA[").append("user_device").append("]]></objName>");
						xmlString.append("<pageContext><![CDATA[").append("1").append("]]></pageContext>");
						xmlString.append("<objContext><![CDATA[").append("1").append("]]></objContext>");
						xmlString.append("<editFlag><![CDATA[").append("A").append("]]></editFlag>");
						xmlString.append("<focusedColumn><![CDATA[").append("").append("]]></focusedColumn>");
						xmlString.append("<action><![CDATA[").append("SAVE").append("]]></action>");
						xmlString.append("<elementName><![CDATA[").append("").append("]]></elementName>");
						xmlString.append("<keyValue><![CDATA[").append("1").append("]]></keyValue>");
						xmlString.append("<taxKeyValue><![CDATA[").append("").append("]]></taxKeyValue>");
						xmlString.append("<saveLevel><![CDATA[").append("1").append("]]></saveLevel>");
						xmlString.append("<forcedSave><![CDATA[").append(true).append("]]></forcedSave>");
						xmlString.append("<taxInFocus><![CDATA[").append(false).append("]]></taxInFocus>");
						xmlString.append("<description>").append("Header0 members").append("</description>");
						xmlString.append("<Detail1 dbID='' domID='1' objContext='1' objName='user_device'>");
						xmlString.append("<attribute pkNames='tran_id:' selected='N' status='N' updateFlag='N' />");
						xmlString.append("<tran_id>").append("<![CDATA[null]]>").append("</tran_id>");
						xmlString.append("<user_id>").append("<![CDATA["+userId+"]]>").append("</user_id>");
						xmlString.append("<device_id__push>").append("<![CDATA["+deviceId+"]]>").append("</device_id__push>");
						xmlString.append("<device_os>").append("<![CDATA["+deviceOS+"]]>").append("</device_os>");
						xmlString.append("<device_type>").append("<![CDATA["+deviceType+"]]>").append("</device_type>");
						xmlString.append("<device_make>").append("<![CDATA["+deviceMaker+"]]>").append("</device_make>");
						xmlString.append("<device_mac_addr>").append("<![CDATA["+macAddress+"]]>").append("</device_mac_addr>");
						xmlString.append("<active>").append("<![CDATA[N]]>").append("</active>");
						if( "BROWSERLOGIN".equals(action) )
						{
							xmlString.append("<requested_ip>").append("<![CDATA["+chgTerm+"]]>").append("</requested_ip>");
						}
						xmlString.append("<name>").append("<![CDATA["+userName+"]]>").append("</name>");
						xmlString.append("<chg_user>").append("<![CDATA["+chgUser+"]]>").append("</chg_user>");
						xmlString.append("<chg_term>").append("<![CDATA["+chgTerm+"]]>").append("</chg_term>");
						xmlString.append("<chg_date>").append("<![CDATA["+currTime+"]]>").append("</chg_date>");
						xmlString.append("<add_user>").append("<![CDATA["+chgUser+"]]>").append("</add_user>");
						xmlString.append("<add_term>").append("<![CDATA["+chgTerm+"]]>").append("</add_term>");
						xmlString.append("<add_date>").append("<![CDATA["+currTime+"]]>").append("</add_date>");
						xmlString.append("</Detail1>");
						xmlString.append("</Header0>\r\n");
						xmlString.append("</group0>\r\n");
						xmlString.append("</DocumentRoot>\r\n");
						
						if( recExistRecCount == 0 )
						{
							status = status.concat("~~").concat("false~~").concat(xmlString.toString());								
						}
						else
						{
							status = status.concat("~~").concat("true~~").concat(xmlString.toString());
						}
					}
					//Added By Pankaj T. on 03-07-19 added new option in device security (3 - Admin Approval (More than one device tries to login then send approval to admin, if admin approves then only allow to login.) - end
				}
				else if( "4".equalsIgnoreCase(deviceSecurity) )
				{
					StringBuilder whereCondtion = new StringBuilder();
					whereCondtion.append( " WHERE USER_ID ='" ).append( userId ).append( "' " );
					whereCondtion.append( " AND ACTIVE ='" ).append( "Y" ).append( "' ");
					whereCondtion.append( " AND DEVICE_MAC_ADDR ='" ).append( macAddress ).append( "' "); 
					String isExists = E12GenericUtility.checkNull(getDBColumnValue("USER_DEVICE", "COUNT(*)", whereCondtion.toString()));
					int existRecCount = Integer.valueOf(isExists);
					BaseLogger.log("2",userInfo,null,"exist record count against macAddress:::["+existRecCount+"]");
					
					if( "MELOGIN".equals(action) )
					{
						if( existRecCount == 0 )
						{
							BaseLogger.log("9",null,null,"user exist for Mobile");
							status = "INTIMATION_MAIL";
						}
						else
						{
							status = "true";
						}
					}
					else if( "BROWSERLOGIN".equals(action) )
					{
						whereCondtion = new StringBuilder();
						whereCondtion.append( " WHERE USER_ID ='" ).append( userId ).append( "' " );
						whereCondtion.append( " AND IP ='" ).append( chgTerm ).append( "' "); 
						String ipExist = E12GenericUtility.checkNull(getDBColumnValue("USER_IP", "COUNT(*)", whereCondtion.toString()));
						int existIPCount = Integer.valueOf(ipExist);
						BaseLogger.log("2",userInfo,null,"exist ip count:::["+existIPCount+"]");
						
						if( currentGeoPos.length() > 0 )
						{
							whereCondtion = new StringBuilder();
							whereCondtion.append( " WHERE USER_ID ='" ).append( userId ).append( "' " );
							whereCondtion.append( " AND GEOPOS ='" ).append( currentGeoPos ).append( "' "); 
							String geoposExist = E12GenericUtility.checkNull(getDBColumnValue("USER_GEOPOS", "COUNT(*)", whereCondtion.toString()));
							int existGeoPosCount = Integer.valueOf(geoposExist);
							BaseLogger.log("2",userInfo,null,"exist geopos count:::["+existGeoPosCount+"]");
							
							if( existRecCount == 0 )
							{
								BaseLogger.log("2",userInfo,null,"user exist for "+deviceType);
								status = "INTIMATION_MAIL";
							}
							else if( existRecCount > 0 && existIPCount > 0 && existGeoPosCount > 0 )
							{
								status = "true";						
							}
							else
							{
								BaseLogger.log("2",userInfo,null,"user exist for@@ "+deviceType);
								status = "INTIMATION_MAIL";
							}
						}
						else
						{
							if(  existRecCount == 0 )
							{
								BaseLogger.log("2",userInfo,null,"user exist for "+deviceType);
								status = "INTIMATION_MAIL";
							}
							else if(  existRecCount > 0 && existIPCount > 0 )
							{
								status = "true";
							}
							else
							{
								BaseLogger.log("2",userInfo,null,"user exist for@@ "+deviceType);
								status = "INTIMATION_MAIL";
							}
						}
					}
				}
			}
		}
		catch(Exception e)
		{
			BaseLogger.log("0",userInfo,null,"Exception :CommonDBAccessEJB :verifyDeviceSecurity :==>\n"+e); //$NON-NLS-1$
			throw new BaseException( e );
		}
		BaseLogger.log("2",userInfo,null,"CommonDBAccessEJB.verifyDeviceSecurity() deviceSecurityStatus::["+status+"]");
		return status;
	}
	//Added By Pankaj T. on 18-06-18 for device security based on enterprise level [0-disabled, 1-strictly enforced, 2-OTP, 3-workflow invoked] - End
	
	//added by vishal pathare on 1.8.18[users licence related security]Start
	@Override
	public boolean checkUserLicence(String userCode) throws ITMException, UnsupportedEncodingException
	{
		//To get actual login code of login user.
		String loginCode = getUserCode(userCode);
		BaseLogger.log("2",null,null,"CommonDBAccessEJB.checkUserLicence Login With [" + userCode + "] Login Code [" + loginCode + "] ");
	    return getActivationCode( loginCode );
	}

	private boolean getActivationCode( String userCode ) throws ITMException 
	{
		String sqlQuery = "";
		Connection mConnection = null;
		PreparedStatement pStatement = null;
		ResultSet mResultSet = null;
		String activationCode ="";
		String userLicType ="";
		boolean isLicUser = false;
		
		try
		{
			ConnDriver mConnDriver = new ConnDriver();
			mConnection = mConnDriver.getConnectDB("Driver");
			
			sqlQuery = "SELECT ACTIVATION_CODE, USER_LIC_TYPE FROM USERS WHERE CODE=?";
			pStatement = mConnection.prepareStatement(sqlQuery);
			pStatement.setString(1, userCode);
			mResultSet = pStatement.executeQuery();
			
			if(mResultSet.next())
			{
				activationCode = mResultSet.getString(1);
				userLicType = mResultSet.getString(2);
			}
			if(mResultSet!=null)
			{
				mResultSet.close();
				mResultSet = null;
			}
			if(pStatement!=null)
			{
				pStatement.close();
				pStatement=null;
			}
			
			isLicUser = validateRequest( userCode, userLicType, activationCode );
		}
		catch(Exception e)
		{
			BaseLogger.log("0",null,null,"CommonDBAccessEJB.checkLicence()["+e.getMessage()+"]");
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(mResultSet!=null)
				{
					mResultSet.close();
					mResultSet = null;
				}
				if(pStatement!=null)
				{
					pStatement.close();
					pStatement=null;
				}
				if(mConnection!= null && !mConnection.isClosed())
				{
					mConnection.close();
					mConnection = null;
				}
			}
			catch(SQLException se)
			{
				BaseLogger.log("0",null,null,"CommonDBAccessEJB.getSecurityCommMode().finally["+se.getMessage()+"]");
				se.printStackTrace();
			}
		}
		return isLicUser;	
	}

	private boolean validateRequest(String userCode, String userLicType, String encodedData)
    {
		boolean isLicUser = false;
		BaseLogger.log("2",null,null,"userCode ["+userCode+"]userLicType["+userLicType+"]encodedData["+encodedData+"]");
		
		//Changes by Prajyot on 10AUG19[To remove extra space at one place] Start
		//Commented on 007-06-2022 [Commented for the issue of in encodeddata usercode with space, so after decrypting it not matched without sapce usercode]
		//userCode = E12GenericUtility.checkNull(userCode);
		//userLicType = E12GenericUtility.checkNull(userLicType);
		encodedData = E12GenericUtility.checkNull(encodedData);
		
		//if( E12GenericUtility.checkNull(userLicType).length()<=0 )
		//Commented on 007-06-2022 [Commented as per suggested by KB Sir not allow user to login unless he has a valid activation key] - start
		/*if( userLicType.length() <= 0 )
		{
			  isLicUser = true;
		}
		//else if( E12GenericUtility.checkNull(encodedData).length()>0 && E12GenericUtility.checkNull(userCode).length()>0 )
		else if( encodedData.length() > 0 && userCode.length() > 0 )*/
		//Commented on 007-06-2022 [Commented as per suggested by KB Sir not allow user to login unless he has a valid activation key] - end
		if( encodedData.length() > 0 && userCode.length() > 0 )
		{
			String decryptedData = decrypt( encodedData );
			BaseLogger.log("3",null,null,"decryptedData["+decryptedData+"]");
			if( decryptedData.contains( userCode+userLicType) )
			{
				isLicUser = true;
			}
		}
		//Changes by Prajyot on 10AUG19[To remove extra space at one place] End
		return isLicUser;
	}
	//added by vishal pathare on 1.8.18[users licence related security]End

	//Commented by Prajyot on 16-APR-19 [ As Server License validation is not required ] Start
	/*
	// Added By Saitej D [To check login user's license] START
	public boolean checkServerLicence(String loginId, String remoteHost) throws ITMException {

		BaseLogger.log("2", null, null, "Calling checkServerLicence.................");
		boolean returnValue = false;
		String userCode = getUserCode(loginId);
		String enterprise = getUserEnterprise(userCode);
		String licenseKey = remoteHost+"_"+userCode;
		String encLicenseKey = encrypt(licenseKey);
		
		try {
			String licenseHome = "http://proteusvision.com";
			String extWebServiceURI = "/ibase/rest/UserInvitationService/checkLicense"; 
			
			String serverHomeFolderPath = CommonConstants.JBOSSHOME+File.separator+"server"+File.separator+"default"+File.separator+"deploy"+File.separator+"ibase.ear"+File.separator+"ibase.war"+File.separator+"E12Registration";
			String serverHomeFilePath = serverHomeFolderPath + File.separator +"licensehome"+".json";
			
			File existingFolder = new File(serverHomeFolderPath);
			if(existingFolder.exists()) {
				File existingFile = new File(serverHomeFilePath);
				if(existingFile.exists()) {
					String fileString = FileUtils.readFileToString(existingFile);
					if(!fileString.trim().isEmpty()) {
						JSONObject licenseJson = new JSONObject(fileString);
						licenseHome =  licenseJson.optString("LICENSEHOME");
					}
				}
			}
									
			extWebServiceURI = licenseHome + extWebServiceURI;
			BaseLogger.log("2", null, null, "licenseHome :: ["+licenseHome+"] extWebServiceURI["+extWebServiceURI+"]");
			
			String APPLICATION_JSON = "application/json";
			HttpRequest extServiceReq = Unirest.get(extWebServiceURI).header("Content-Type", APPLICATION_JSON)
											.queryString("LICENSE_KEY", encLicenseKey)
											.queryString("ENTERPRISE", enterprise)
											.getHttpRequest();
			HttpResponse<String> extServiceResp = extServiceReq.asString();
			BaseLogger.log("3", null, null, "extServiceResp.getStatus()[" + extServiceResp.getStatus() + "]");
			BaseLogger.log("3", null, null, "extServiceResp.getBody()[" + extServiceResp.getBody() + "]");
			String extServiceObj = extServiceResp.getBody().toString();
			BaseLogger.log("3", null, null, "extServiceObj[" + extServiceObj + "]");

			String returnResponse = extServiceObj.toString();
			BaseLogger.log("2", null, null, "Response of checkServerLicence.....["+returnResponse+"]");
			JSONObject resultJson = new JSONObject(returnResponse);
			String status = resultJson.getString("status");
			
			if(status != null && status.equals("valid")) {
				returnValue = true;
			}			
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} finally {
			// debug( "callEXTWebService", null, returnValue, userName );
		}
		return returnValue;
	}
	// Added By Saitej D [To check login user's license] END
	*/
	//Commented by Prajyot on 16-APR-19 [ As Server License validation is not required ] End
	
	// Added By Saitej D on 17 Nov 2018 [To get usercode of login user] START
	public String getUserCode(String loginID) throws ITMException
	{
		String[] columns = {"CODE", "MOBILE_NO", "EMAIL_ID", "USER_ID"};
		String entryType = "K";			   
		String selectQuery = null;
		String userCode = "";
		PreparedStatement pStatement = null;
		ResultSet mResultSet = null; 
		Connection mConnection = null;
		try 
		{
			ConnDriver connDriver = new ConnDriver();
			mConnection = connDriver.getConnectDB( "Driver" );
			for (int i = 0; i < columns.length; i++) 
			{
				selectQuery = "SELECT CODE FROM USERS WHERE " + columns[i] + " = ?";
				pStatement = mConnection.prepareStatement( selectQuery );
				pStatement.setString(1, loginID);
				mResultSet = pStatement.executeQuery();
	
				if (mResultSet.next()) 
				{
					entryType = ((i == 0) ? "C" :
								 (i == 1) ? "M" :
								 (i == 2) ? "E" : "U");
					loginID = !("C".equals(entryType)) ? mResultSet.getString("CODE") : loginID;		
					
					userCode = mResultSet.getString("CODE");
					break;
				}
				if(pStatement!=null)
				{
					pStatement.close();
					pStatement=null;
				}
				if(mResultSet!=null)
				{
					mResultSet.close();
					mResultSet = null;
				}
			}
			BaseLogger.log("3",null,null,"UserCode getUserCode():["+loginID+"]");
			BaseLogger.log("3",null,null,"userCode getUserCode():["+userCode+"]");
		}
		catch (Exception e) 
		{
			BaseLogger.log("0",null,null,"Exception in CommonDBAccessEJB.getUserCode():["+e.getMessage()+"]");
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(pStatement!=null)
				{
					pStatement.close();
					pStatement=null;
				}
				if(mResultSet!=null)
				{
					mResultSet.close();
					mResultSet = null;
				}
				if(mConnection!= null && !mConnection.isClosed())
				{
					mConnection.close();
					mConnection = null;
				}
			}
			catch(SQLException se)
			{
				BaseLogger.log("0",null,null,"CommonDBAccessEJB.getTransDB().finally["+se.getMessage()+"]");
				se.printStackTrace();
				throw new ITMException(se);
			}			
		}
		
		return userCode;
	}
	// Added By Saitej D on 17 Nov 2018 [To get usercode of login user] END
	
	// Added By Saitej D [To get user enterprise of login user] START
	public String getUserEnterprise(String userCode) throws ITMException
	{
		String selectQuery = null;
		String enterprise = "";
		PreparedStatement pStatement = null;
		ResultSet mResultSet = null; 
		Connection mConnection = null;
		try 
		{
			ConnDriver connDriver = new ConnDriver();
			mConnection = connDriver.getConnectDB( "Driver" );
			selectQuery = "SELECT ENTERPRISE FROM USERS WHERE CODE = ?";
			pStatement = mConnection.prepareStatement( selectQuery );
			pStatement.setString(1, userCode);
			mResultSet = pStatement.executeQuery();

			if (mResultSet.next()) 
			{
				enterprise = mResultSet.getString("ENTERPRISE");
			}
			if(pStatement!=null)
			{
				pStatement.close();
				pStatement=null;
			}
			if(mResultSet!=null)
			{
				mResultSet.close();
				mResultSet = null;
			}
			BaseLogger.log("3",null,null,"userCode & enterprise in getUserEnterprise():["+userCode+"] enterprise["+enterprise+"]");
		}
		catch (Exception e) 
		{
			BaseLogger.log("0",null,null,"Exception in CommonDBAccessEJB.getUserEnterprise():["+e.getMessage()+"]");
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(pStatement!=null)
				{
					pStatement.close();
					pStatement=null;
				}
				if(mResultSet!=null)
				{
					mResultSet.close();
					mResultSet = null;
				}
				if(mConnection!= null && !mConnection.isClosed())
				{
					mConnection.close();
					mConnection = null;
				}
			}
			catch(SQLException se)
			{
				BaseLogger.log("0",null,null,"CommonDBAccessEJB.getUserEnterprise().finally["+se.getMessage()+"]");
				se.printStackTrace();
				throw new ITMException(se);
			}			
		}
		
		return enterprise;
	}
	// Added By Saitej D [To get user enterprise of login user] END

	// Added By Kamal P [To genearate OTP] START
	//Changed By Pankaj T. on 18-09-19 for getting PASSWORD_COMPLEXITY against user defined ENTERPRISE instead of ibase.xml
	public String generateOTP( String user) throws ITMException
	{
		//If PASSWORDCOMPLEXITY == 1 then 4 digit randaom will be generate.
		//this changes is made to support in mobile device.
		int number = 1;
		//Changed By Pankaj T. on 18-09-19 for getting PASSWORD_COMPLEXITY against user defined ENTERPRISE instead of ibase.xml - start
		//String passWdComplexity = CommonConstants.PASSWORDCOMPLEXITY;
		String passWdComplexity = "";
		BaseLogger.log("3", null, null, "In generateOTP CODE:["+user+"]");
		
		String transDB = getDBColumnValue("USERS", "TRANS_DB", "WHERE CODE = '"+user+"'");
		BaseLogger.log("3", null, null, "In generateOTP TRANS_DB:["+transDB+"]");
		
		String enterprise = getDBColumnValue("USERS", "ENTERPRISE", "WHERE CODE = '"+user+"'");
		BaseLogger.log("3", null, null, "In generateOTP ENTERPRISE against CODE:["+enterprise+"]");
		
		if( "".equals(E12GenericUtility.checkNull(enterprise)) )
		{
			String siteCode = getDBColumnValue("USERS", "SITE_CODE__DEF", "WHERE CODE = '"+user+"'");
			BaseLogger.log("3", null, null, "In generateOTP SITE_CODE against CODE:["+siteCode+"]");
			
			enterprise = getDBColumnValue("SITE", "ENTERPRISE", "WHERE SITE_CODE = '"+siteCode+"'", transDB);
			BaseLogger.log("3", null, null, "In generateOTP ENTERPRISE against SITE_CODE:["+enterprise+"]");
		}
		
		passWdComplexity = getDBColumnValue("ENTERPRISE", "PASSWORD_COMPLEXITY", "WHERE ENTERPRISE = '"+enterprise+"'", transDB);
		BaseLogger.log("3",null,null,"In generateOTP PASSWORD_COMPLEXITY against  ENTERPRISE:["+passWdComplexity+"]");
		//Changed By Pankaj T. on 18-09-19 for getting PASSWORD_COMPLEXITY against user defined ENTERPRISE instead of ibase.xml - end
		if("1".equals(passWdComplexity))
		{
			BaseLogger.log("2",null,null,"if passWdComplexity is "+passWdComplexity);	
			number = new Random().nextInt(9000) + 1000;
			BaseLogger.log("2",null,null," number in if "+number);
		}
		else
		{
			number = new Random().nextInt();
			BaseLogger.log("",null,null," number in else "+number);
		}
		BaseLogger.log("3",null,null,"OTP =["+number+"]");
		
		if( number < 1 )
		{
			number = -number;
		}
		String varCode = Integer.toString( number ); 
		BaseLogger.log("2",null,null," varCode for otp "+varCode);
		
		return varCode;
	}
	// Added By Kamal P [To genearate OTP] END


	//Added By Pankaj T. on 18-06-18 verify device security based on ip_security against enterprise [0 - Allow for any IP, 1 - STRICTLY_ENFORCED for WHITE_LIST_IP, 2 - Bypass device_security for WHITE_LIST_IP] - start
	private String verifyIPSecurity( UserInfoBean userInfo, String enterprise, String chgTerm ) throws ITMException
	{
		String status = null;
		try 
		{
			BaseLogger.log("2",userInfo,null,"CommonDBAccessEJB.verifyIPSecurity Enetrprise :::["+enterprise+"]");
			String ipSecurity = E12GenericUtility.checkNull(getDBColumnValue("ENTERPRISE", "IP_SECURITY", "WHERE ENTERPRISE = '"+enterprise+"'", userInfo.getTransDB()));
			BaseLogger.log("2",userInfo,null,"CommonDBAccessEJB.verifyIPSecurity IPSecurity :::["+ipSecurity+"]");
			String whiteListIP = E12GenericUtility.checkNull(getDBColumnValue("ENTERPRISE", "WHITE_LIST_IP", "WHERE ENTERPRISE = '"+enterprise+"'", userInfo.getTransDB()));
			BaseLogger.log("2",userInfo,null,"CommonDBAccessEJB.verifyIPSecurity WhiteListIP :::["+whiteListIP+"]");
			if( "".equals(ipSecurity) || "0".equals(ipSecurity) )
			{
				status = "VERIFY_DEVICE_SECURITY";
			}
			else if( "1".equals(ipSecurity) )
			{
				if( "".equals(whiteListIP) )
				{
					status = "STRICTLY_ENFORCED";
				}
				else
				{
					String whiteListIPArr[] = whiteListIP.split(",");
					for( int i = 0; i < whiteListIPArr.length; i++ )
					{
						String IP = E12GenericUtility.checkNull( whiteListIPArr[i] );
						if( !"".equals(IP) && chgTerm.equals(IP) )
						{
							status = "VERIFY_DEVICE_SECURITY";
							break;
						}
						else if( !"".equals(IP) && IP.endsWith("*") )
						{
							IP = IP.substring( 0, IP.length()-1 );
							if( chgTerm.startsWith(IP) )
							{
								status = "VERIFY_DEVICE_SECURITY";
								break;
							}
						}
						else
						{
							status = "STRICTLY_ENFORCED";
						}
					}
				}
			}
			else if( "2".equals(ipSecurity) )
			{
				if( "".equals(whiteListIP) )
				{
					status = "VERIFY_DEVICE_SECURITY";
				}
				else
				{
					String whiteListIPArr[] = whiteListIP.split(",");
					for( int i = 0; i < whiteListIPArr.length; i++ )
					{
						String IP = E12GenericUtility.checkNull( whiteListIPArr[i] );
						if( !"".equals(IP) && chgTerm.equals(IP) )
						{
							status = "true";
							break;
						}
						else if( !"".equals(IP) && IP.endsWith("*") )
						{
							IP = IP.substring( 0, IP.length()-1 );
							if( chgTerm.startsWith(IP) )
							{
								status = "true";
								break;
							}
						}
						else
						{
							status = "VERIFY_DEVICE_SECURITY";
						}
					}
				}
			}
		}
		catch (Exception e) 
		{
			BaseLogger.log("0", userInfo, null, "Exception in verifyIPSecurity:["+e+"]");
			throw new ITMException(e);
		}
		BaseLogger.log("2",userInfo,null,"CommonDBAccessEJB.verifyIPSecurity() IPSecurity status:["+status+"]");
		return status;
	}
	//Added By Pankaj T. on 18-06-18 verify device security based on ip_security against enterprise [0 - Allow for any IP, 1 - STRICTLY_ENFORCED for WHITE_LIST_IP, 2 - Bypass device_security for WHITE_LIST_IP] - end
	
    //Added by saiprasad on 15-03-19 to draw and rights based on rights in user_adhc_right table[START]
	public HashMap<String,String> getUserAdhocRights(String profileID,UserInfoBean userInfo)
	{
		BaseLogger.log("2", userInfo, null, "CommonDBAcessEJB.getUserAdhocRights()");
		ConnDriver connDriver = null;
		Connection conn = null;
		ResultSet rs = null;
		PreparedStatement pStmt = null;
		String rightsStr = "",rightType = "", objName = "", userId = "",loginSiteCode = "", adhocSiteCode = "";
		HashMap<String, String> rightAdhocMap = new HashMap<>();
		java.util.Date curr= new java.util.Date();
		Timestamp effFromUserAdhoc = null,validUptoAdhoc = null,currDateTs = null,currDateTsInsert = null;
		String tranDB = userInfo.getTransDB();
		E12GenericUtility genericUtility = new E12GenericUtility();
		try
		{
			connDriver = new ConnDriver();
			conn = connDriver.getConnectDB(tranDB);

			userId = userInfo.getLoginCode();
			loginSiteCode = userInfo.getSiteCode();

			SimpleDateFormat sdfAppl = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String currDateStr = sdfAppl.format(curr);
			currDateTs = Timestamp.valueOf(genericUtility.getValidDateString(currDateStr,genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat())
					+ " 00:00:00.0");
		    
			String query = "SELECT * FROM USER_RIGHTS_ADHOC WHERE USER_ID=? ";
			pStmt=conn.prepareStatement(query);
			pStmt.setString(1, userId);
			rs=pStmt.executeQuery();
			while(rs.next())
			{
				rightType = rs.getString("RIGHTS_TYPE");
				rightsStr = rs.getString( "RIGHTS" );
				objName = rs.getString( "OBJ_NAME" );
				effFromUserAdhoc = rs.getTimestamp("EFF_FROM");
				validUptoAdhoc = rs.getTimestamp("VALID_UPTO");
				adhocSiteCode = E12GenericUtility.checkNull(rs.getString("SITE_CODE__LOGIN"));
 
				if((!currDateTs.before(effFromUserAdhoc)) && (!currDateTs.after(validUptoAdhoc)))
				{
					if("O".equalsIgnoreCase(rightType))
					{
						if(loginSiteCode.equalsIgnoreCase(adhocSiteCode) || adhocSiteCode.length()==0)
						{
							rightAdhocMap.put(objName, adhocSiteCode);
						}
					}
					BaseLogger.log("3", null, null, "[CommonDBAccessEJB]Getting user rightAdhoc: "+rightAdhocMap );
				}
				else
				{
					BaseLogger.log("3", null, null, "[CommonDBAccessEJB]Getting user rightAdhoc is not O: "+rightAdhocMap ); 
				}
			}
			if(rs!=null)
			{
				rs.close();
				rs=null;
			}
			if(pStmt!=null)
			{
				pStmt.close();
				pStmt=null;
			}
		}
		catch(Exception e)
		{
			BaseLogger.log("0", userInfo, null, "CommonDBAcessEJB.overrideUserAdhocRight:Exception() "+e);
		}
		finally
		{
			try
			{	
				if(conn!=null)
				{
					if(pStmt!=null)
					{
						pStmt.close();
						pStmt = null;
					}
					if(rs!=null)
	                {
	                	rs.close();
	                	rs = null;
	                }
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				BaseLogger.log("0", userInfo, null, "Connection closing error:Exception() "+e);
			}
		}
		return rightAdhocMap;
	}
	//Added by Saiprasad on 15-03-19 overridding the rights END
	
	//Added by Priyanka B on 15-07-2019 Start
	public String updateClobColumn( String tableName, String columnName, String columnValue, String condition, String transDB  ) 
	{
		BaseLogger.log("3", null, null,"Inside update clobecolumn tableName "+  tableName+" columnName "+columnName+" columnValue "+ columnValue+" condition "+ condition+" transDB "+ transDB );

		Connection mConnection = null;
		PreparedStatement mStatement = null;
		String responseStr = "";
		try
		{
			ConnDriver mConnDriver = new ConnDriver();
			
			if(transDB != null && !"null".equalsIgnoreCase(transDB.trim()) && transDB.trim().length() > 0)
			{
				mConnection = mConnDriver.getConnectDB( transDB );
			}
			else
			{
				mConnection = mConnDriver.getConnectDB( "Driver" );
			}
			
			String sqlQuery = " UPDATE " +  tableName + " SET " + columnName + " =  ?  WHERE " +condition;
		 
			BaseLogger.log("3", null, null,"updateClobColumn sql "+sqlQuery);
			mStatement=mConnection.prepareStatement(sqlQuery);
		    mStatement.setString(1,columnValue);
		    mStatement.executeUpdate();
		    mConnection.commit();
		    mStatement.close();
		}
		catch (Exception e) 
		{
			responseStr = "failure";
			BaseLogger.log("0",null,null,"Exception :CommonDBAccessEJB :updateActiveStatus :==>\n"+e); //$NON-NLS-1$
			try
			{
				if( mConnection != null )
				{
					mConnection.rollback();
					mConnection.close();
					mConnection = null;
				}
				if (mStatement != null)
				{					
					mStatement.close();
					mStatement = null;
				}
			}
			catch (Exception sqle )
			{
				sqle.printStackTrace();
			}	
		}
		finally
		{
			try
			{
				
				if (mConnection != null)
				{					
					mConnection.close();
					mConnection = null;
				}
				if (mStatement != null)
				{					
					mStatement.close();
					mStatement = null;
				}
			}
			catch (Exception e)
			{
				e.printStackTrace();
			}
		}
		return responseStr;
	}
	//Added by Priyanka B on 15-07-2019 Start
	
	
	//Added by Prajyot R. on 30NOV19 [To get SQL result in JSON format ]Start
	public JSONArray getSQLResultJSONData(String sqlStr, String transDB)
	{
		int noOfRows = 0;
		int noOfColumns = 0;

		JSONArray dataArray = new JSONArray();

		Connection con = null;
		Statement stmt=null;;
		ResultSet rs = null;

		try
		{
			BaseLogger.log("3", null, null, "Inside CommonDBAccessEJB::getSQLResultJSONData transDB [" +transDB + "] SQL Execution done ! SQL => \n " + sqlStr);

			ConnDriver mConnDriver = new ConnDriver();
			con = mConnDriver.getConnectDB(transDB); 
			if( con == null ) {
				BaseLogger.log("3", null, null,"Unable to get connection for [" + transDB + "]");
				throw new Exception("Unable to get connection for [" + transDB + "]");
			}
			stmt = con.createStatement();
			rs = stmt.executeQuery(sqlStr);
			
			ResultSetMetaData rsmd = rs.getMetaData();
			while(rs.next())
			{
				if( noOfRows == 0 )
				{
					noOfColumns = rsmd.getColumnCount();
				}
				//System.out.println("Result iteration !");
				JSONObject rowData = new JSONObject();
				//System.out.println("Result noOfColumns !" + noOfColumns);
				for(int colIdx = 1; colIdx <= noOfColumns; colIdx++)
				{
					String colName = rsmd.getColumnName(colIdx);
					String colValue = rs.getString(colIdx);
					if( colValue == null || colValue.trim().length() == 0 )
					{
						colValue = " "; //setting blank value 
					}
					rowData.put( colName, colValue );
				}
				//System.out.println("Result rowData !" + rowData);
				dataArray.put(rowData);
				noOfRows++;
			}
			//System.out.println("Result dataArray !" + dataArray);
		}
		catch(Exception e)
		{
			dataArray = new JSONArray();
			BaseLogger.log("0", null, null,"Inside CommonDBAccessEJB::getSQLResultJSONData Exception : " + e.getMessage());
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if( stmt != null )
				{
					stmt.close();
					stmt = null;
				}
				if( con != null )
				{
					con.close();
					con = null;
				}
			}
			catch( Exception eI )
			{
				eI.printStackTrace();
			}
		}
		return dataArray;
	}
	//Added by Prajyot R. on 30NOV19 [To get SQL result in JSON format ]End
	
	//Added by Prajyot R. on 30NOV19 [To get SQL result in HashMap ]Start
	public HashMap getSQLResultMapData(String sqlStr, String transDB)
	{
		HashMap sqlDataMap = null;
		Connection con = null;
		Statement stmt=null;;
		ResultSet rs = null;
		try
		{
			BaseLogger.log("3", null, null,"Inside CommonDBAccessEJB::getSQLResultMapData transDB [" +transDB + "] SQL Execution done ! SQL => \n " + sqlStr);
			ConnDriver mConnDriver = new ConnDriver();
			con = mConnDriver.getConnectDB(transDB); 
			if( con == null ) {
				BaseLogger.log("3", null, null,"Unable to get connection for [" + transDB + "]");
				throw new Exception("Unable to get connection for [" + transDB + "]");
			}
			ArrayList<HashMap<String, String>> dataRows = new ArrayList<HashMap<String, String>>();
			HashMap<Integer, String> dataCols = new HashMap<Integer, String>();	
			sqlDataMap = new HashMap();
			int noOfRows = 0;
			int noOfColumns = 0;

			stmt = con.createStatement();
			rs = stmt.executeQuery(sqlStr);
			
			ResultSetMetaData rsmd = rs.getMetaData();
			while(rs.next())
			{
				//System.out.println("Result iteration !");
				HashMap<String, String> rowDataMap = new HashMap<String, String>();
				noOfColumns = rsmd.getColumnCount();
				//System.out.println("Result noOfColumns !" + noOfColumns);
				for(int ctr = 1; ctr <= noOfColumns; ctr++)
				{
					if( noOfRows == 0 )
					{
						dataCols.put(ctr, rsmd.getColumnName(ctr));
					}
					rowDataMap.put(rsmd.getColumnName(ctr), rs.getString(ctr));
				}
				//System.out.println("Result dataMap !" + dataMap);
				dataRows.add(rowDataMap);
				noOfRows++;
			}
			//System.out.println("Result dataArray !" + dataArray);
			sqlDataMap.put("COLS", dataCols);
			sqlDataMap.put("ROWS", dataRows);
		}
		catch(Exception e)
		{
			sqlDataMap = null;
			BaseLogger.log("0", null, null,"Inside CommonDBAccessEJB::getSQLResultMapData Exception : " + e.getMessage());
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if( stmt != null )
				{
					stmt.close();
					stmt = null;
				}
				if( con != null )
				{
					con.close();
					con = null;
				}
			}
			catch( Exception eI )
			{
				eI.printStackTrace();
			}
		}
		return sqlDataMap;
	}
	//Added by Prajyot R. on 30NOV19 [To get SQL result in HashMap ]End
	
	//Added by shrutika on 11-03-2020 [Start] for Add change terminal as IMEI_NO/MAC Address for all tables.
	public int getSQLColumnSize(String sqlStr, String transDB)
	{
		int columnsize = 0;
		Connection con = null;
		Statement stmt=null;;
		ResultSet rs = null;
		try
		{
			BaseLogger.log("3", null, null,"Inside CommonDBAccessEJB::getSQLColumnSize transDB [" +transDB + "] SQL Execution done ! SQL => \n " + sqlStr);
			ConnDriver mConnDriver = new ConnDriver();
			con = mConnDriver.getConnectDB(transDB); 
			if( con == null ) {
				BaseLogger.log("3", null, null,"Unable to get connection for getSQLColumnSize[" + transDB + "]");
				throw new Exception("Unable to get connection for getSQLColumnSize[" + transDB + "]");
			}
			stmt = con.createStatement();
			rs = stmt.executeQuery(sqlStr);
			ResultSetMetaData rsmd = rs.getMetaData();
			columnsize = rsmd.getColumnDisplaySize(1);
		}
		catch(Exception e)
		{
			BaseLogger.log("0", null, null,"Inside CommonDBAccessEJB::getSQLColumnSize Exception : " + e.getMessage());
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if( stmt != null )
				{
					stmt.close();
					stmt = null;
				}
				if( con != null )
				{
					con.close();
					con = null;
				}
			}
			catch( Exception ex )
			{
				ex.printStackTrace();
			}
		}
		BaseLogger.log("3", null, null,"Inside getSQLColumnSize..................columnsize[" + columnsize + "]");
		return columnsize;
	}
	//Added by shrutika on 11-03-2020 [End] for Add change terminal as IMEI_NO/MAC Address for all tables.
    
	//Added By Pankaj T. on 14-04-20 to set unique id as a termId in userInfo & this termId in chg_term column - start
	public String generateSeq( String seqName, int seqLen, String transDB ) throws ITMException
	{  
		String retstr = "";
		PreparedStatement pstmt = null;
		PreparedStatement pstm = null;
		ResultSet rs = null;
		Connection con = null;
		try
		{
			ConnDriver connDriver = new ConnDriver();
			con = connDriver.getConnectDB(transDB);
			long lastSeq = 0 ;
			String qry1 = "";
			//Added By Pankaj T. on 16-06-2021 to get dbName from connection url instead of Commonconstant
			String database = connDriver.getDBName();
			if(!"mysql".equalsIgnoreCase( database ) )
			{
				if ( "db2".equalsIgnoreCase( database ) )
				{
					qry1 = "SELECT NEXTVAL FOR "+seqName.trim()+" FROM DUAL" ;
				}
				else
				{		
					qry1 = "SELECT "+seqName.trim()+".NEXTVAL FROM DUAL" ;
				}
				pstmt = con.prepareStatement(qry1);
				rs = pstmt.executeQuery();
				while(rs.next())
				{
					lastSeq = rs.getLong(1);
				}
			}
			else
			{
				String maxValueStr = "";
				String getMaxValue = "";
				
				getMaxValue = "SELECT MAX(MAX_VALUE) FROM SEQUENCES WHERE SEQ_NAME = '"+seqName.trim()+"'";
				pstmt = con.prepareStatement(getMaxValue);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					lastSeq = rs.getInt(1);	
					if(lastSeq != 0)
					{
						maxValueStr = "UPDATE SEQUENCES SET  MAX_VALUE = ? WHERE SEQ_NAME = ?";
						pstm = con.prepareStatement(maxValueStr);
						pstm.setLong(1,lastSeq+1);
						pstm.setString(2,seqName.trim());
					}
					else
					{
						lastSeq = 1;
						maxValueStr = "INSERT INTO SEQUENCES ( MAX_VALUE ,SEQ_NAME) VALUES (?, ?) ";
						pstm = con.prepareStatement(maxValueStr);
						pstm.setLong(1,lastSeq);
						pstm.setString(2,seqName.trim());
					}
					pstm.executeUpdate();
				}
			}
			con.commit();
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			if( pstm != null )
			{
				pstm.close();
				pstm = null;
			}
			String tmp1  = "000000000000000000000000"+lastSeq;
			int tm_len = tmp1.length() - seqLen  ;
			retstr = tmp1.substring( tm_len ) ;
		}
		catch(Exception e)
		{
			BaseLogger.log( "3", null, null, "CommonDBAccessEJB.generateSeq( exception in catch:["+E12GenericUtility.getStackTrace(e));
			try 
			{
				if( con != null )
				{
					con.rollback();
				}
			}
			catch (SQLException e1)
			{
				e1.printStackTrace();
			}
			throw new ITMException(e );
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if( pstm != null )
				{
					pstm.close();
					pstm = null;
                }
                if( con != null )
                {
                    con.close();
                    con = null;
                }
			}
			catch (Exception e2)
			{
				BaseLogger.log( "3", null, null, "CommonDBAccessEJB.generateSeq( exception in finally:["+E12GenericUtility.getStackTrace(e2));
			}
		}
		return retstr ;
	}
	//Added By Pankaj T. on 14-04-20 to set unique id as a termId in userInfo & this termId in chg_term column - end
	
	//Added by shrutika on 13-04-2020 [Start] for display device information on image click on change detail field.
	public String getChgTermInfo( UserInfoBean userInfo, String loginId, String macAddr) throws ITMException
	{
		StringBuffer returStr = new StringBuffer();
		PreparedStatement pstmt = null;
		ResultSet rs=null;
		Connection conn = null;
		try
		{
			ConnDriver conDriver = new ConnDriver();
			conn = conDriver.getConnectDB( userInfo.getTransDB() );
			conDriver = null;
			
			BaseLogger.log( "3", null, null, "Inside getChgTermInfo["+ loginId +"]macAddr["+macAddr+"]" );
			String selectQry = "SELECT DEVICE_MAC_ADDR, DEVICE_OS, DEVICE_MAKE, DEVICE_TYPE  FROM USER_DEVICE WHERE USER_ID = ? AND ( DEVICE_MAC_ADDR = ? OR TRAN_ID = ?)";
			pstmt = conn.prepareStatement( selectQry );
			pstmt.setString( 1, loginId );
			pstmt.setString( 2, macAddr );
			pstmt.setString( 3, macAddr );
			rs = pstmt.executeQuery();
			
			returStr.append("<?xml version='1.0'?>");
			returStr.append("<Root>");
			returStr.append("<DeviceData>");
			returStr.append("<USER_ID><![CDATA["+loginId+"]]></USER_ID>");
			ResultSetMetaData rsmd = rs.getMetaData();
			while( rs.next() )
			{
				int noOfColumns = rsmd.getColumnCount();
				for(int ctr = 1; ctr <= noOfColumns; ctr++)
				{
					if( "mysql".equalsIgnoreCase( CommonConstants.DB_NAME ) )
					{
						
						String str = "<"+rsmd.getColumnName(ctr).toUpperCase()+"><![CDATA["+rs.getString(ctr)+"]]></"+rsmd.getColumnName(ctr).toUpperCase()+">";
						returStr.append(str);
					}
					else
					{
						String str = "<"+rsmd.getColumnName(ctr)+"><![CDATA["+rs.getString(ctr)+"]]></"+rsmd.getColumnName(ctr)+">";
						returStr.append(str);
					}
				}
			}
			returStr.append("</DeviceData>");
			returStr.append("</Root>");
		}
		catch (Exception e)
		{
			BaseLogger.log( "0", null, null, "Exception in getChgTermInfo ["+ e.getMessage() +"]" );
			//Added by shrutika on 15-07-2020 for display Exception in front end
			throw new ITMException(e );
		}
		finally
		{
			try
			{
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if( conn != null  )
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				
			}
		}
		BaseLogger.log( "3", null, null, "getChgTermInfo ["+ returStr.toString() +"]" );
		return returStr.toString();
	}
	//Added by shrutika on 13-04-2020 [End] for display device information on image click on change detail field.
	
	//Added By Pankaj T. on 04-06-2020 for sun vulnerabilities added server side validation of old & new password - start
	public boolean validatePassword(String password, UserInfoBean userInfo) throws ITMException
	{
		BaseLogger.log("3",userInfo,null,"CommonDBAccessEJB.validatePassword() usrInfo:["+userInfo.toString()+"]");
		boolean result = false;
		CommonDBAccessEJB commonDBAccessEJB = new CommonDBAccessEJB();
		try
		{
			password = E12GenericUtility.checkNull( password );
			BaseLogger.log("3",userInfo,null,"CommonDBAccessEJB.validatePassword() passsword length:["+password.length()+"]");
			String passWdComplexity = commonDBAccessEJB.getDBColumnValue("ENTERPRISE", "PASSWORD_COMPLEXITY", "WHERE ENTERPRISE = '"+userInfo.getEnterprise()+"'", userInfo.getTransDB());
			BaseLogger.log("3",userInfo,null,"CommonDBAccessEJB.validatePassword() PASSWORD_COMPLEXITY against  ENTERPRISE:["+passWdComplexity+"]");	
			if( "1".equals(passWdComplexity) )
			{
				if( E12GenericUtility.checkNull(password).length() >= 4 )
				{
					result = true;
				}
				else
				{
					result = false;
				}
			}
			else
			{
				String userType = userInfo.getUserType();
				String PASSWORD_PATTERN = "((?=.*\\d)(?=.*[a-z])(?=.*[A-Z])(?=.*[~`!@#$%^&*(){}=+-.,:;'\"\\/?|]).{6,60})";
				Pattern pattern = Pattern.compile(PASSWORD_PATTERN);
				Matcher matcher = pattern.matcher(password);

                // Added by Pankaj Pawar ( Regex Pattern Declaration for Meta-Charaters )
                String NOTALLOWED_PATTERN =  "(?:.*[$^*()\\[\\]{}+-.\\?|])";
                Pattern patern = Pattern.compile(NOTALLOWED_PATTERN);
                Matcher mattcher = patern.matcher(password);

                if(password != null && mattcher.matches())  //Check Enter Value Matches any Meta Character
                {
                    result = false;
                }
				// Added by Pankaj R on 17-JUN-20 (Commented toUpperCase() for password)
			    else if( password.length() >= 6 && !password.equalsIgnoreCase(userInfo.getLoginCode()) && !password.equalsIgnoreCase("PASSWORD") && matcher.matches() )
				{
					if( "E".equalsIgnoreCase(userType))
					{
						if( !password.equalsIgnoreCase(userInfo.getEmpCode()) && !password.equalsIgnoreCase(userInfo.getEmpFName()) && !password.equalsIgnoreCase(userInfo.getEmpMName()) && !password.equalsIgnoreCase(userInfo.getEmpLName()) )
						{
							result = true;
						}
						else
						{
							result = false;
						}
					}
					else
					{
						result = true;
					}
				}
				else
				{
					result = false;
				}
			}
		}
		catch (Exception e)
		{
            BaseLogger.log("3",userInfo,null,"CommonDBAccessEJB.validatePassword() Exception:["+E12GenericUtility.getStackTrace(e)+"]");
            throw new ITMException(e);
		}
		BaseLogger.log("3",userInfo,null,"CommonDBAccessEJB.validatePassword() result:["+result+"]");
		return result;
	}
	//Added By Pankaj T. on 04-06-2020 for sun vulnerabilities added server side validation of old & new password - end
	
	//Added By Pankaj T. on 02-07-2020 removed vulnerability of Email Flooding in forgot password (if difference between 2 request is less than predefined interval then not allowed to initiate again forgot password request)- start
	public boolean checkForgotPwdReqInterval( String userId ) throws ITMException
	{
		BaseLogger.log("2",null,null,"CommonDBAccessEJB.checkForgotPwdReqInterval() userId:["+userId+"]");
		boolean result = true;
		boolean updateReqDateTime = false;
		PreparedStatement psmt = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		Connection conn = null;
		
		try
		{
			String query = "SELECT FORGOT_PWD_REQ_DATETIME FROM USERS WHERE CODE = '"+userId+"'";
			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("Driver");
			psmt = conn.prepareStatement(query);
			rs = psmt.executeQuery();
			if(rs.next())
			{
				java.util.Date forgotPwdReqDateTime = rs.getDate("FORGOT_PWD_REQ_DATETIME");
				BaseLogger.log("3",null,null,"CommonDBAccessEJB.checkForgotPwdReqInterval() FORGOT_PWD_REQ_DATETIME:["+forgotPwdReqDateTime+"]");
				if( forgotPwdReqDateTime != null )
				{
					String format = "MM/dd/yyyy hh:mm a";
					SimpleDateFormat sdf = new SimpleDateFormat(format);
					BaseLogger.log("3",null,null,"CommonDBAccessEJB.checkForgotPwdReqInterval() FORGOT_PWD_REQ_DATETIME after format:["+sdf.format(forgotPwdReqDateTime)+"]");
					java.util.Date currDate = new java.util.Date();
					BaseLogger.log("3",null,null,"CommonDBAccessEJB.checkForgotPwdReqInterval() forgot password request currDateTime:["+sdf.format(currDate)+"]");
					
					long diff = currDate.getTime() - forgotPwdReqDateTime.getTime();
					Double reqDateTimeDiff = (double) (diff / (60 * 1000));
					BaseLogger.log("3",null,null,"CommonDBAccessEJB.checkForgotPwdReqInterval() forgot password reqDateTimeDiff:["+reqDateTimeDiff+"]");
					BaseLogger.log("3",null,null,"CommonDBAccessEJB.checkForgotPwdReqInterval() CommonConstants.FORGOT_PWD_REQ_INTERVAL:["+CommonConstants.FORGOT_PWD_REQ_INTERVAL+"]");
					
					if( CommonConstants.FORGOT_PWD_REQ_INTERVAL > reqDateTimeDiff )
					{
						result = false;
					}
					else
					{
						updateReqDateTime = true;
					}
				}
				else
				{
					updateReqDateTime = true;
				}
				
				if( updateReqDateTime )
				{
					result = true;
					updateForgotPwdReqDateTime( true, userId );
				}
			}
		}
		catch (Exception e)
		{
			BaseLogger.log("0",null,null,"CommonDBAccessEJB.checkForgotPwdReqInterval() Exception:["+E12GenericUtility.getStackTrace(e)+"]");
			throw new ITMException(e);
		}
		finally
		{
			try 
			{
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if( psmt != null )
				{
					psmt.close();
					psmt = null;
				}
				if( rs != null )
				{
					rs.close();
					rs = null;
				}
				if( conn != null )
				{
					conn.close();
					conn = null;
				}
			}
			catch (Exception e2) 
			{
				BaseLogger.log("0",null,null,"CommonDBAccessEJB.checkForgotPwdReqInterval() finally Exception:["+E12GenericUtility.getStackTrace(e2)+"]");
				throw new ITMException(e2);
			}
		}
		BaseLogger.log("2",null,null,"CommonDBAccessEJB.checkForgotPwdReqInterval() result:["+result+"]");
		return result;
	}
	
	public Double getForgotPwdReqIntervalDiff( String userId ) throws ITMException
	{
		BaseLogger.log("2",null,null,"CommonDBAccessEJB.getForgotPwdReqIntervalDiff() userId:["+userId+"]");
		PreparedStatement psmt = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		Connection conn = null;
		Double timeDiffinMin = 0.0;
		
		try
		{
			String query = "SELECT FORGOT_PWD_REQ_DATETIME FROM USERS WHERE CODE = '"+userId+"'";
			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("Driver");
			psmt = conn.prepareStatement(query);
			rs = psmt.executeQuery();
			if(rs.next())
			{
				java.util.Date forgotPwdReqDateTime = rs.getDate("FORGOT_PWD_REQ_DATETIME");
				BaseLogger.log("3",null,null,"CommonDBAccessEJB.getForgotPwdReqIntervalDiff() FORGOT_PWD_REQ_DATETIME:["+forgotPwdReqDateTime+"]");
				if( forgotPwdReqDateTime != null )
				{
					String format = "MM/dd/yyyy hh:mm a";
					SimpleDateFormat sdf = new SimpleDateFormat(format);
					BaseLogger.log("3",null,null,"CommonDBAccessEJB.getForgotPwdReqIntervalDiff() FORGOT_PWD_REQ_DATETIME after format:["+sdf.format(forgotPwdReqDateTime)+"]");
					java.util.Date currDate = new java.util.Date();
					BaseLogger.log("3",null,null,"CommonDBAccessEJB.getForgotPwdReqIntervalDiff() forgot password request currDateTime:["+sdf.format(currDate)+"]");
					
					long diff = currDate.getTime() - forgotPwdReqDateTime.getTime();
					Double reqDateTimeDiff = (double) (diff / (60 * 1000));
					BaseLogger.log("3",null,null,"CommonDBAccessEJB.getForgotPwdReqIntervalDiff() forgot password reqDateTimeDiff:["+reqDateTimeDiff+"]");
					BaseLogger.log("3",null,null,"CommonDBAccessEJB.getForgotPwdReqIntervalDiff() CommonConstants.FORGOT_PWD_REQ_INTERVAL:["+CommonConstants.FORGOT_PWD_REQ_INTERVAL+"]");
					
					if( CommonConstants.FORGOT_PWD_REQ_INTERVAL > reqDateTimeDiff )
					{
						timeDiffinMin = CommonConstants.FORGOT_PWD_REQ_INTERVAL - reqDateTimeDiff;
					}
				}
			}
		}
		catch (Exception e)
		{
			BaseLogger.log("0",null,null,"CommonDBAccessEJB.getForgotPwdReqIntervalDiff() Exception:["+E12GenericUtility.getStackTrace(e)+"]");
			throw new ITMException(e);
		}
		finally
		{
			try 
			{
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if( psmt != null )
				{
					psmt.close();
					psmt = null;
				}
				if( rs != null )
				{
					rs.close();
					rs = null;
				}
				if( conn != null )
				{
					conn.close();
					conn = null;
				}
			}
			catch (Exception e2) 
			{
				BaseLogger.log("0",null,null,"CommonDBAccessEJB.getForgotPwdReqIntervalDiff() finally Exception:["+E12GenericUtility.getStackTrace(e2)+"]");
				throw new ITMException(e2);
			}
		}
		BaseLogger.log("2",null,null,"CommonDBAccessEJB.getForgotPwdReqIntervalDiff() timeDiffinMin:["+timeDiffinMin+"]");
		return timeDiffinMin;
	}
		
	public void updateForgotPwdReqDateTime( boolean isUpdateCurrDate, String userId ) throws ITMException
	{
		PreparedStatement pstmt = null;
		Connection conn = null;
		try
		{
			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("Driver");
			String  updateQuery = "UPDATE USERS SET FORGOT_PWD_REQ_DATETIME=? WHERE CODE = '"+userId+"'";
			pstmt = conn.prepareStatement(updateQuery);
			if( isUpdateCurrDate )
			{
				pstmt.setTimestamp(1, new java.sql.Timestamp(System.currentTimeMillis()));
			}
			else
			{
				pstmt.setDate(1, null);
			}
			int updateCount = pstmt.executeUpdate();
			BaseLogger.log("3",null,null,"CommonDBAccessEJB.updateForgotPwdReqDateTime() update count:["+updateCount+"]");
			conn.commit();
		}
		catch (Exception e)
		{
			BaseLogger.log("0",null,null,"CommonDBAccessEJB.updateForgotPwdReqDateTime() Exception:["+E12GenericUtility.getStackTrace(e)+"]");
		}
		finally
		{
			try 
			{
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if( conn != null )
				{
					conn.close();
					conn = null;
				}
			}
			catch (Exception e2) 
			{
				BaseLogger.log("0",null,null,"CommonDBAccessEJB.updateForgotPwdReqDateTime() finally Exception:["+E12GenericUtility.getStackTrace(e2)+"]");
				throw new ITMException(e2);
			}
		}
	}
	//Added By Pankaj T. on 02-07-2020 removed vulnerability of Email Flooding in forgot password (if difference between 2 request is less than predefined interval then not allowed to initiate again forgot password request)- end
	
	//Added by Pooja S on 6-AUGUST-2020 [Enterprise wise train intent and entities] Start
	public void getEnterpriseNLPAccessToken()
	{
		Connection mConnection = null;
		Statement mStatement = null;
		ResultSet mResultSet =  null;
		try 
		{
			ConnDriver mConnDriver = new ConnDriver();
			mConnection = mConnDriver.getConnectDB( "DriverITM" );
			mConnDriver = null;

			String sql = "SELECT ENTERPRISE, NLP_APP_TOKEN FROM ENTERPRISE WHERE NLP_APP_TOKEN IS NOT NULL";
			mStatement = mConnection.createStatement();
			mResultSet = mStatement.executeQuery( sql );
			while( mResultSet.next() )
			{
				CommonConstants.ENTERPRISE_NLP_TOKENS.put( mResultSet.getString("ENTERPRISE"), mResultSet.getString("AGENT_SETTING") );
			}
			
			if ( mStatement != null )
			{
				mStatement.close();
				mStatement = null;
			}
			if ( mResultSet != null )
			{
				mResultSet.close();
				mResultSet = null;
			}
			if ( mConnection != null )
			{
				mConnection.close();
				mConnection = null;
			}
		}
		catch (SQLException e) 
		{
			e.printStackTrace();
		}
		catch (Exception e) 
		{
			e.printStackTrace();
		}
		finally 
		{
			try 
			{
				if ( mStatement != null )
				{
					mStatement.close();
					mStatement = null;
				}
				if ( mResultSet != null )
				{
					mResultSet.close();
					mResultSet = null;
				}
				if ( mConnection != null )
				{
					mConnection.close();
					mConnection = null;
				}
			}
			catch (SQLException e) 
			{
				e.printStackTrace();
			}
		}
	}
    //Added by Pooja S on 6-AUGUST-2020 [Enterprise wise train intent and entities ] End
    
     //Added by Pankajt T on 14-09-2020 for The user icon which shows detail information about user should also show Login using User id/Mobile/email and user_id/mobile/email value
    public String getAuthenticatedUsing(String loginID) throws ITMException
	{
        BaseLogger.log("3",null,null,"In CommonDBAccessEJB.getAuthenticatedUsing() loginID:["+loginID+"]");
		String[] columns = {"CODE", "MOBILE_NO", "EMAIL_ID", "USER_ID"};
		String entryType = "K";			   
		String selectQuery = null;
		String authenticatedUsing = "";
		PreparedStatement pStatement = null;
		ResultSet mResultSet = null; 
		Connection mConnection = null;
		try 
		{
			ConnDriver connDriver = new ConnDriver();
			mConnection = connDriver.getConnectDB( "Driver" );
			for (int i = 0; i < columns.length; i++) 
			{
				selectQuery = "SELECT " + columns[i] + " FROM USERS WHERE " + columns[i] + " = ?";
				pStatement = mConnection.prepareStatement( selectQuery );
				pStatement.setString(1, loginID);
				mResultSet = pStatement.executeQuery();
	
				if (mResultSet.next()) 
				{
					//entryType = ((i == 0) ? "C" :
							//	 (i == 1) ? "M" :
							//	 (i == 2) ? "E" : "U");
					//loginID = !("C".equals(entryType)) ? mResultSet.getString("CODE") : loginID;		
                    authenticatedUsing = mResultSet.getString( columns[i] );
                    authenticatedUsing = columns[i] + " : " + authenticatedUsing;
					break;
				}
				if(pStatement!=null)
				{
					pStatement.close();
					pStatement=null;
				}
				if(mResultSet!=null)
				{
					mResultSet.close();
					mResultSet = null;
				}
			}
			BaseLogger.log("3",null,null,"In CommonDBAccessEJB.getAuthenticatedUsing() authenticatedUsing : ["+authenticatedUsing+"]");
		}
		catch (Exception e) 
		{
			BaseLogger.log("0",null,null,"In CommonDBAccessEJB.getAuthenticatedUsing() Exception : ["+E12GenericUtility.getStackTrace(e)+"]");
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(pStatement!=null)
				{
					pStatement.close();
					pStatement=null;
				}
				if(mResultSet!=null)
				{
					mResultSet.close();
					mResultSet = null;
				}
				if(mConnection!= null && !mConnection.isClosed())
				{
					mConnection.close();
					mConnection = null;
				}
			}
			catch(SQLException se)
			{
				BaseLogger.log("0",null,null,"CommonDBAccessEJB.getTransDB().finally["+se.getMessage()+"]");
				se.printStackTrace();
				throw new ITMException(se);
			}			
		}
		return authenticatedUsing;
    }
     //Added by Pankajt T on 14-09-2020 for The user icon which shows detail information about user should also show Login using User id/Mobile/email and user_id/mobile/email value
    
   //Added by Shrutika on 15-09-2020 for The user icon which shows detail information about user should also show Login using User id/Mobile/email and user_id/mobile/email value
    public void updateLoginTrace (String sessionId, String Logout_detail , UserInfoBean userInfo ) throws Exception 
	{
    	BaseLogger.log("0",null,null," inside updateLoginTrace sessionId["+sessionId+"]Logout_detail["+Logout_detail+"]");
		Connection con = null;
		PreparedStatement stmt = null;
		ResultSet mResultSet = null;
		
		try 
		{
            ConnDriver mConnDriver = new ConnDriver();
            con = mConnDriver.getConnectDB("Driver");
            String sql = "UPDATE LOGINTRACE SET LOGOUT_MODE = ? , LOGOUT_DETAIL = ? WHERE USERID = ? and SESSIONID = ?";
            stmt = con.prepareStatement(sql);
            stmt.setString(1, "I");
            stmt.setString(2, Logout_detail);
            stmt.setString(3, userInfo.getLoginCode());
            stmt.setString(4, sessionId);
            mResultSet = stmt.executeQuery();
            mResultSet.close();
            mResultSet = null;
            stmt.close();
            stmt = null;
            con.commit();
            con.close();
            con = null;
		}
		catch (Exception e) 
		{
			try 
			{
				if (con != null) 
				{
					con.rollback();
					con.close();
					con = null;
				}
			}
			catch (Exception catche) 
			{
				e.printStackTrace();
				BaseLogger.log("0",null,null,"Exception inside updateLoginTrace["+catche.getMessage()+"]");
			}
		}
		finally 
		{
			if (con != null) 
			{
				if (mResultSet != null) 
				{
					mResultSet.close();
					mResultSet = null;
				}
				if (con != null) 
				{
					con.close();
					con = null;
				}
			}
		}
	}
  //Added by Shrutika on 15-09-2020 for The user icon which shows detail information about user should also show Login using User id/Mobile/email and user_id/mobile/email value

    // Added and Commented by Pankaj R on 16-Sep-20 to show the mail dynamically from mail_format [START]
    private void sendPasswdVerificationMail(String verificationCode, String toAddress, String formatCode, UserInfoBean userInfo) throws RemoteException, BaseException
    {
        EMail emailObj = new EMail();
        StringBuffer mailInfoXml = new StringBuffer("");
        try
        {
        	mailInfoXml.append("<ROOT><TRANS_INFO></TRANS_INFO><MAIL>");
            mailInfoXml.append("<FORMAT_CODE><![CDATA["+formatCode+"]]></FORMAT_CODE>");
            mailInfoXml.append("</MAIL>");
            mailInfoXml.append("<XML_DATA><Detail1>"); 
            mailInfoXml.append("<user_id><![CDATA["+userInfo.getLoginCode()+"]]></user_id>");
            mailInfoXml.append("<user_name><![CDATA["+userInfo.getUserName()+"]]></user_name>");
            mailInfoXml.append("<varCode><![CDATA["+verificationCode+"]]></varCode>");
            mailInfoXml.append("<toAdd><![CDATA["+toAddress+"]]></toAdd>");
            mailInfoXml.append("</Detail1></XML_DATA></ROOT>"); 
            
            BaseLogger.log("3",null,null,"sendPasswdVerificationMail mailInfoXml IN EMAIL:: "+ mailInfoXml);
            emailObj.sendMail( mailInfoXml.toString(), "ITM", userInfo );
        }
        catch(Exception e)
        {
            BaseLogger.log("0",null,null,"Exception :CommonDBAccessEJB.sendPasswdVerificationMail() :==>\n"+e); //$NON-NLS-1$
			e.printStackTrace();
			throw new BaseException(e);       
        }
    }
    // Added and Commented by Pankaj R on 16-Sep-20 to show the mail dynamically from mail_format [END]
    
    //Added by Amey W. [To implement client wise endpoints for API] on 22-09-2020 START
  	public boolean isExtAppEndpointAllowed( String endPoint, String appId )
  	{
  		BaseLogger.log( "0", null, null, "isExtAppEndpointAvailable :: endpoint : ["+ endPoint +"] appId : ["+ appId +"]" );
  		boolean isValidEndpoint = false;
  		Connection userConn = null;
  		PreparedStatement pstmt = null;
  		ResultSet rs = null;
  		try
  		{
  			ConnDriver connDriver = new ConnDriver();
  			userConn = connDriver.getConnectDB( "Driver" );
  			
  			//Changed by Ravindra on 07/09/20 [EDI webService related implementation] START
  			appId = E12GenericUtility.checkNull( appId );
  			endPoint = E12GenericUtility.checkNull( endPoint );
  			String appEndpointSql = "SELECT COUNT(1) FROM AUTH_APPS_API WHERE API_STATUS = 'Y' ";
  			if ( appId.length() > 0 )
  			{
  				appEndpointSql += "AND APP_ID = '"+ appId +"' ";
  			}
  			if ( endPoint.length() > 0 )
  			{
  				appEndpointSql += "AND LOWER(ENDPOINT) = '"+ endPoint.toLowerCase() +"'";
  			}
  			pstmt = userConn.prepareStatement( appEndpointSql );
  			//pstmt.setString( 1, appId );
  			//pstmt.setString( 2, endpoint.toLowerCase() );
  			//Changed by Ravindra on 07/09/20 [EDI webService related implementation] END
  			rs = pstmt.executeQuery();
  			if( rs.next() )
  			{
  				if ( rs.getInt( 1 ) > 0 )
  				{
  					isValidEndpoint = true;
  				}
  			}
  			BaseLogger.log( "0", null, null, "isValidEndpoint : ["+ isValidEndpoint +"]" );
  			
  			if( pstmt != null )
  			{
  				pstmt.close();
  				pstmt = null;
  			}
  			if( rs != null )
  			{
  				rs.close();
  				rs = null;
  			}
  		}
  		catch (Exception e) 
  		{
  			BaseLogger.log( "0", null, null, "Exception :: isExtAppEndpointAvailable : ["+ e.getMessage() +"]" );
  			e.printStackTrace();
  			isValidEndpoint = false;
  		}
  		finally
  		{
  			try 
  			{
  				if( pstmt != null )
  				{
  					pstmt.close();
  					pstmt = null;
  				}
  				if( rs != null )
  				{
  					rs.close();
  					rs = null;
  				}
  				if( userConn != null )
  				{
  					userConn.close();
  					userConn = null;
  				}
  			}
  			catch (SQLException e) 
  			{
				e.printStackTrace();
			}
  		}
  		
  		return isValidEndpoint;
  	}
    //Added by Amey W. [To implement client wise endpoints for API] on 22-09-2020 End
  	
  	//Added by Prasad on 17/10/2020 [to get json details] Start
  	public JSONObject getSQLResultJSONData( String sqlStr, String resultKey, String transDB )
	{
		JSONObject dataObj = new JSONObject();

		Connection con = null;
		Statement stmt = null;
		ResultSet rs = null;

		try
		{
			BaseLogger.log("3", null, null, "Inside CommonDBAccessEJB::getSQLResultJSONData transDB [" +transDB + "] SQL Execution done ! SQL => \n " + sqlStr);

			ConnDriver mConnDriver = new ConnDriver();
			con = mConnDriver.getConnectDB(transDB); 
			if( con == null ) 
			{
				BaseLogger.log("3", null, null,"Unable to get connection for [" + transDB + "]");
				throw new Exception("Unable to get connection for [" + transDB + "]");
			}
			stmt = con.createStatement();
			rs = stmt.executeQuery(sqlStr);
			
			ResultSetMetaData rsmd = rs.getMetaData();
			int noOfColumns = rsmd.getColumnCount();
			while(rs.next())
			{
				JSONObject rowData = new JSONObject();
				for( int colIdx = 1; colIdx <= noOfColumns; colIdx++ )
				{
					String colName = rsmd.getColumnName(colIdx);
					String colValue = rs.getString(colIdx);
					if( colValue == null || colValue.trim().length() == 0 )
					{
						colValue = " "; 
					}
					rowData.put( colName, colValue );
				}
				if ( resultKey != null )
				{
					String resultKeyValue = rs.getString( resultKey );
					dataObj.put( resultKeyValue, rowData );
				}
			}
		}
		catch(Exception e)
		{
			dataObj = new JSONObject();
			BaseLogger.log( "0", null, null,"Inside CommonDBAccessEJB::getSQLResultJSONData Exception : " + e.getMessage() );
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if( stmt != null )
				{
					stmt.close();
					stmt = null;
				}
				if( rs != null )
				{
					rs.close();
					rs = null;
				}
				if( con != null )
				{
					con.close();
					con = null;
				}
			}
			catch( Exception eI )
			{
				eI.printStackTrace();
			}
		}
		return dataObj;
	}
  //Added by Prasad on 17/10/2020 [to get json details] End
  	
  //Added By Vikas Lagad on 07-10-20[set IN_MEMORY credential in userInfo] Start
    public void setUserInfoInMem(String transDB,UserInfoBean userInfo)
    {
        BaseLogger.log("3", null, null,"Inside setUserInfoInMem   "+transDB);
        String filePath = "",fileContent = "";
        try 
        {
            filePath = CommonConstants.JBOSSHOME + File.separator + "server" + File.separator + "default" + File.separator + "deploy" + File.separator + "ibase.ear" + File.separator + "ibase.war" + File.separator + CommonConstants.SETTINGS;
            filePath = filePath +  File.separator + transDB +"_IN_MEM.xml";
            BaseLogger.log("3", null, null,"File Path  ::   "+filePath);
            File xmlFile = new File( filePath );
			if( xmlFile != null )
			{
                fileContent = FileUtils.readFileToString(xmlFile);
                BaseLogger.log("3", null, null,"fileContent   ::   "+fileContent);
            }
		
			DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();  
	        DocumentBuilder builder; 
	        builder = factory.newDocumentBuilder();  
            Document doc = builder.parse( new InputSource( new StringReader( fileContent )) ); 
            
            NodeList docRoot1 = doc.getElementsByTagName("DATABASE");
            for (int i = 0; i < docRoot1.getLength(); i++)
            {
                NodeList childList1 = docRoot1.item(i).getChildNodes();
                for (int j = 0; j < childList1.getLength(); j++) 
                {
                    Node childNode = childList1.item(j);
                    if("URL".equalsIgnoreCase(childNode.getNodeName())) 
                    {
                        String url = childNode.getFirstChild().getNodeValue();
                        userInfo.setInMemUrl(url);
                        BaseLogger.log("3", null, null,"dremio url["+url+"]");
                    }
                    else if("LOGID".equalsIgnoreCase(childNode.getNodeName())) 
                    {
                        String userName = childNode.getFirstChild().getNodeValue();
                        userInfo.setInMemUserName(userName);
                    	BaseLogger.log("3", null, null,"dremio userName["+userName+"]");
                    }
                    else if("LOGPASSWORD".equalsIgnoreCase(childNode.getNodeName())) 
                    {
                        String pass = childNode.getFirstChild().getNodeValue();
                        userInfo.setInMemPassword(pass);
                        BaseLogger.log("3", null, null,"dremio pass["+pass+"]");

                    }
                }
            }
        }
        catch ( Exception e )
        {
             BaseLogger.log("3", null, null,"Exception while set UserInfo In Memory .. "+e.getMessage());
        }
    }
    //Added By Vikas Lagad on 07-10-20[set IN_MEMORY credential in userInfo] 
  	
  //Added by Ravindra on 07/09/20 [EDI webService related implementation] START
  	public ExtAuthAppAPIBean getAuthAppAPIDetails( String endPoint, String appId ) throws ITMException 
  	{
  		BaseLogger.log( "3", null, null, "CommonDBAccessEJB :: getVisionEdiBean" );
  		Connection conn = null;
  		PreparedStatement pStmt = null;
  		ResultSet rs = null;
  		ExtAuthAppAPIBean authAppAPI = null;
  		try 
  		{
  			ConnDriver connDriver = new ConnDriver();
  			conn = connDriver.getConnectDB("Driver");
  			connDriver = null;

  			appId = E12GenericUtility.checkNull( appId );
  			endPoint = E12GenericUtility.checkNull( endPoint );

  			//Changed by Ravindra C on 12/02/2021 [added user_id in sql for authetication]
  			String sqlQuery = " SELECT APP_ID, ENDPOINT, API_STATUS, REQ_DATA_FORMAT, RESP_DATA_FORMAT, SERVICE_CLASS, SERVICE_SETTING, USER_ID " 
  					+ " FROM AUTH_APPS_API "
  					+ " WHERE API_STATUS = 'Y' ";
  			if ( appId.length() > 0 )
  			{
  				sqlQuery += "AND APP_ID = '"+ appId +"' ";
  			}
  			if ( endPoint.length() > 0 )
  			{
  				sqlQuery += "AND LOWER(ENDPOINT) = '"+ endPoint.toLowerCase() +"'";
  			}
  			pStmt = conn.prepareStatement( sqlQuery );
  			rs = pStmt.executeQuery();

  			if( rs.next() )
  			{
  				authAppAPI = new ExtAuthAppAPIBean();
  				authAppAPI.setAppId( E12GenericUtility.checkNull( rs.getString( "APP_ID" ) ) );
  				authAppAPI.setEndPoint( E12GenericUtility.checkNull( rs.getString( "ENDPOINT" ) ) );
  				authAppAPI.setApiStatus( E12GenericUtility.checkNull( rs.getString( "API_STATUS" ) ) );
  				authAppAPI.setReqDataFormat( E12GenericUtility.checkNull( rs.getString( "REQ_DATA_FORMAT" ) ) );
  				authAppAPI.setResDataFormat( E12GenericUtility.checkNull( rs.getString( "RESP_DATA_FORMAT" ) ) );
  				authAppAPI.setServiceClass( E12GenericUtility.checkNull( rs.getString( "SERVICE_CLASS" ) ) );
  				authAppAPI.setServiceSetting( E12GenericUtility.checkNull( rs.getString( "SERVICE_SETTING" ) ) );
  				//Added by Ravindra C on 12/02/2021 [added user_id in sql for authetication]
  				authAppAPI.setUserId( E12GenericUtility.checkNull( rs.getString( "USER_ID" ) ) );
  			}
  			else
  			{
  				BaseLogger.log( "3", null, null, "CommonDBAccessEJB :: getVisionEdiBean : No application found" );
  			}
  		} 
  		catch (Exception e) 
  		{
  			BaseLogger.log( "0", null, null, "Exception in CommonDBAccessEJB :: getVisionEdiBean : ["+ e.getMessage() +"]" );
  			e.printStackTrace();
  			throw new ITMException(e);
  		}
  		finally 
  		{
  			try 
  			{
  				if ( rs != null )
  				{
  					rs.close();
  					rs = null;
  				}
  				if ( pStmt != null )
  				{
  					pStmt.close();
  					pStmt = null;
  				}
  				if ( conn != null )
  				{
  					conn.close();
  					conn = null;
  				}
  			}
  			catch (SQLException e) 
  			{
  				e.printStackTrace();
  			}
  		}	
  		return authAppAPI;
  	}
  	//Added by Ravindra on 07/09/20 [EDI webService related implementation] END
  	
    //Added By Pankaj T. on 18-11--2020 for removing weak account lock vulnerability - if user wrongly enter password more than 5 times then lock the account and send new password on email/mobile and unlock account using new password - start
  	public boolean isResetPassword(int wrongLoginCount,String userId,String chgIP)
	{
		BaseLogger.log("2",null,null,"in isResetPassword().......");
		boolean resetValue = false;
		try
		{
			CommonDBAccessEJB dbAccess = new CommonDBAccessEJB();
			int wrongCount = dbAccess.getWrongLoginCount(userId,chgIP);
			BaseLogger.log("3",null,null,"wrongCount....."+wrongCount+".......CommonConstants.WRONG_LOGIN_COUNT"+CommonConstants.WRONG_LOGIN_COUNT);
			if(wrongCount >= CommonConstants.WRONG_LOGIN_COUNT)
			{
				resetValue = true;
			}
			BaseLogger.log("3",null,null,"resetValue...."+resetValue);
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		return resetValue;
	}
    //Added By Pankaj T. on 18-11--2020 for removing weak account lock vulnerability - if user wrongly enter password more than 5 times then lock the account and send new password on email/mobile and unlock account using new password - end
  	
  	//Added by Prasad on 18/01/2021 [insert into USER_ACC_CHANNEL if admin user] START
  	public void updateUserAccChannel( String channelId, String channelUUId, String enterprise, String channelEmailId, String channelUserName, String tokenId, String activeStatus, String userId, String chgTerm, String chgUserId )
	{
		Connection mConnection = null;
		PreparedStatement pStatement = null;
		ResultSet mResultSet = null;
		try
		{
			boolean isRecordExist = false;

			ConnDriver mConnDriver = new ConnDriver();
			mConnection = mConnDriver.getConnectDB( "Driver" );
			mConnDriver = null;
			
			mConnection.setAutoCommit( false );
			
			String nextTranIDQuery = "SELECT COUNT(1) FROM USER_ACC_CHANNEL WHERE ENTERPRISE = ? AND USER_ID = ?";
			pStatement = mConnection.prepareStatement( nextTranIDQuery );
			pStatement.setString( 1, enterprise );
			pStatement.setString( 2, userId );
			
			mResultSet = pStatement.executeQuery();
			if( mResultSet.next() )
			{
				if ( mResultSet.getInt( 1 ) > 0 )
				{
					isRecordExist = true;
				}
			}
			
			if( pStatement != null )
			{
				pStatement.close();
				pStatement = null;
			}
			if( mResultSet != null )
			{
				mResultSet.close();
				mResultSet = null;
			}
			BaseLogger.log( "3", null, null, "USER_ACC_CHANNEL :: isRecordExist : ["+ isRecordExist +"]" );
			
			java.util.Date date = new java.util.Date();
			SimpleDateFormat formatter = new SimpleDateFormat(CommonConstants.DB_DATETIME_FORMAT);
			String currentDate = formatter.format(date.getTime());
			java.sql.Timestamp requestDate = java.sql.Timestamp.valueOf(currentDate.trim());
			
			if ( ! isRecordExist )
			{
				String insertQuery = "INSERT INTO USER_ACC_CHANNEL(CHANNEL_ID, CHANNEL_UUID, USER_ID, ENTERPRISE, CHANNEL_EMAIL_ID, CHANNEL_UNAME, TOKEN_ID, ACTIVE_STAT, ADD_TERM, ADD_DATE, ADD_USER, CHG_TERM, CHG_DATE, CHG_USER) "
						+ "VALUES( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? )";
				
				pStatement = mConnection.prepareStatement( insertQuery );
				pStatement.setString( 1, channelId );
				pStatement.setString( 2, channelUUId );
				pStatement.setString( 3, userId );
				pStatement.setString( 4, enterprise );
				pStatement.setString( 5, channelEmailId );
				pStatement.setString( 6, channelUserName );
				pStatement.setString( 7, tokenId );
				pStatement.setString( 8, activeStatus );
				pStatement.setString( 9, chgTerm );
				pStatement.setTimestamp( 10, requestDate );
				pStatement.setString( 11, chgUserId );
				pStatement.setString( 12, chgTerm );
				pStatement.setTimestamp( 13, requestDate );
				pStatement.setString( 14, chgUserId );
				
				int result = pStatement.executeUpdate();
				BaseLogger.log( "3", null, null, "["+ result +"] record(s) inserted into USER_ACC_CHANNEL" );
			}
			else
			{
				String updateQuery = "UPDATE USER_ACC_CHANNEL SET TOKEN_ID = ?, CHG_TERM = ?, CHG_DATE = ?, CHG_USER = ? "
						+ " WHERE ENTERPRISE = ? AND USER_ID = ? ";
				
				pStatement = mConnection.prepareStatement( updateQuery );
				pStatement.setString( 1, tokenId );
				pStatement.setString( 2, chgTerm );
				pStatement.setTimestamp( 3, requestDate );
				pStatement.setString( 4, chgUserId );
				pStatement.setString( 5, enterprise );
				pStatement.setString( 6, userId );
				
				int result = pStatement.executeUpdate();
				BaseLogger.log( "3", null, null, "["+ result +"] record(s) updated in USER_ACC_CHANNEL" );
			}
			if( pStatement != null )
			{
				pStatement.close();
				pStatement = null;
			}
			
			if ( mConnection != null )
			{
				mConnection.commit();
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			BaseLogger.log( "0", null, null, "Exception :: CommonDBAccessEJB : updateUserAccChannel : ["+ e.getMessage() +"]" );
			try
			{
				if( mConnection != null )
				{
					mConnection.rollback();
				}
			}
			catch (SQLException se)
			{
				se.printStackTrace();
			}
		}
		finally
		{
			try
			{
				if( pStatement != null )
				{
					pStatement.close();
					pStatement = null;
				}
				if( mResultSet != null )
				{
					mResultSet.close();
					mResultSet = null;
				}
				if( mConnection != null )
				{
					mConnection.close();
					mConnection = null;
				}
			}
			catch (SQLException e)
			{
				e.printStackTrace();
			}
		}
	}
  	//Added by Prasad on 18/01/2021 [insert into USER_ACC_CHANNEL if admin user] END
  	
  	//Added by Prasad on 29/03/2021 [get user_device details] START
  	public HashMap<String, String> getUserDeviceDetails( UserInfoBean userInfo )
	{
  		HashMap<String, String> userDeviceDtlMap = new HashMap<String, String>();
		Connection mConnection = null;
		PreparedStatement pStatement = null;
		ResultSet mResultSet = null;
		try
		{
			ConnDriver mConnDriver = new ConnDriver();
			mConnection = mConnDriver.getConnectDB( "Driver" );
			mConnDriver = null;
			
			//Changed by Pankaj P on  06/10/2021 [check device_type instead of device_id] START
			String userDeviceDtlSql = "SELECT DEVICE_ACC_CLASS, DEVICE_TYPE FROM USER_DEVICE WHERE USER_ID = ? AND ACTIVE = 'Y' AND DEVICE_ACC_CLASS IS NOT NULL";
			pStatement = mConnection.prepareStatement( userDeviceDtlSql );
			pStatement.setString( 1, userInfo.getLoginCode() );
			//pStatement.setString( 2, userInfo.getDeviceType() );
			
			mResultSet = pStatement.executeQuery();
			//if( mResultSet.next() )
			//Added by sunny soni for menu restricted related changes according to device acc class on 10-Feb-22 Start 
			while( mResultSet.next() )
			{
				/*
				String deviceAccClsKey = E12GenericUtility.checkNull( mResultSet.getString( "DEVICE_ACC_CLASS" ) ) + "~" +E12GenericUtility.checkNull(mResultSet.getString( "DEVICE_TYPE" ));
				deviceAccClsKey = E12GenericUtility.checkNull(deviceAccClsKey).trim().toLowerCase();
				userDeviceDtlMap.put( deviceAccClsKey, E12GenericUtility.checkNull( mResultSet.getString( "DEVICE_TYPE" ) ) );
				*/
				//userDeviceDtlMap.put( mResultSet.getString( "DEVICE_ACC_CLASS" ), E12GenericUtility.checkNull( mResultSet.getString( "DEVICE_TYPE" ) ) );
			}
			//Added by sunny soni for menu restricted related changes according to device acc class on 10-Feb-22 End
			//Changed by Pankaj P on  06/10/2021 [check device_type instead of device_id] END
			if( pStatement != null )
			{
				pStatement.close();
				pStatement = null;
			}
			if( mResultSet != null )
			{
				mResultSet.close();
				mResultSet = null;
			}
			BaseLogger.log( "3", null, null, "CommonDBAccessEJB :: userDeviceDtlMap : ["+ userDeviceDtlMap +"]" );
		}
		catch(Exception e)
		{
			e.printStackTrace();
			BaseLogger.log( "0", null, null, "Exception :: CommonDBAccessEJB : getUserDeviceDetails : ["+ e.getMessage() +"]" );
		}
		finally
		{
			try
			{
				if( pStatement != null )
				{
					pStatement.close();
					pStatement = null;
				}
				if( mResultSet != null )
				{
					mResultSet.close();
					mResultSet = null;
				}
				if( mConnection != null )
				{
					mConnection.close();
					mConnection = null;
				}
			}
			catch (SQLException e)
			{
				e.printStackTrace();
			}
		}
		return userDeviceDtlMap;
	}
  	
  	public String getMessageDescr( String msgNo, Connection conn, UserInfoBean userInfo )
  	{
  		String msgDescr = "";
		PreparedStatement pStatement = null;
		ResultSet mResultSet = null;
		boolean isLocalConn = false;
		try
		{
			if ( conn == null )
			{
				ConnDriver mConnDriver = new ConnDriver();
				conn = mConnDriver.getConnectDB( "Driver" );
				mConnDriver = null;
				isLocalConn = true;
			}
			
			msgNo = E12GenericUtility.checkNull( msgNo );
			
			String messageSql = "SELECT MSG_DESCR FROM MESSAGES WHERE MSG_NO = ?";
			pStatement = conn.prepareStatement( messageSql );
			pStatement.setString( 1, msgNo );
			
			mResultSet = pStatement.executeQuery();
			if( mResultSet.next() )
			{
				msgDescr = mResultSet.getString( "MSG_DESCR" );
			}
			
			if( pStatement != null )
			{
				pStatement.close();
				pStatement = null;
			}
			if( mResultSet != null )
			{
				mResultSet.close();
				mResultSet = null;
			}
			BaseLogger.log( "3", null, null, "getMessageDescr() :: msgDescr : ["+ msgDescr +"]" );
		}
		catch(Exception e)
		{
			e.printStackTrace();
			BaseLogger.log( "0", null, null, "Exception :: CommonDBAccessEJB : getMessageDescr : ["+ e.getMessage() +"]" );
		}
		finally
		{
			try
			{
				if( pStatement != null )
				{
					pStatement.close();
					pStatement = null;
				}
				if( mResultSet != null )
				{
					mResultSet.close();
					mResultSet = null;
				}
				if( conn != null && isLocalConn )
				{
					conn.close();
					conn = null;
				}
			}
			catch (SQLException e)
			{
				e.printStackTrace();
			}
		}
		return msgDescr;
	}
  	//Added by Prasad on 29/03/2021 [get user_device details] END
    //Added by on 20-10-21 shrutika for insert ref id with all column value trim because issue occur for composit key in my call List Menu [Start]
	public String refIDWithTrimForAuditTrail( String refIDStr ) throws RemoteException, BaseException
  	{
  		try
  		{
  			BaseLogger.log( "0", null, null, "refIDWithTrimForAuditTrail.......12277 : ["+ refIDStr +"]" );
  	  		if( refIDStr.contains(":"))
  			{
  				String[] redIdArray = refIDStr.toString().split( ":" );
  				String newRefId = "";
  				for( int i=0; i<redIdArray.length; i++ )
  				{
  					newRefId = newRefId + redIdArray[i].trim() +":";
  	            }
  				if( newRefId.lastIndexOf(":") != -1 )
  				{
  					newRefId = newRefId.substring(0, (newRefId.length() - 1) );
  	                refIDStr = newRefId;
  				}
  	        }
  	        else
  	        {
  	           refIDStr = refIDStr.trim(); 
  	        }

  	  		BaseLogger.log( "0", null, null, "refIDWithTrimForAuditTrail.......12298 : ["+ refIDStr +"]" );
  		}
  		catch(Exception e)
        {
            BaseLogger.log("0",null,null,"Exception :refIDWithTrimForAuditTrail() :==>\n"+e); //$NON-NLS-1$
			e.printStackTrace();
			throw new BaseException(e);       
        }
  		return refIDStr;
  	}
	//Added by on 20-10-21 shrutika for insert ref id with all column value trim because issue occur for composit key in my call List Menu [End]
	
	//Added By Pankaj T. on 19-07-2022 [Added new column ver_code in users table for maintain forgot password verification code to resend the same when next request trigger in predefined interval]
	public void updateVerfCode( String verCode, String userId ) throws ITMException
	{
		PreparedStatement pstmt = null;
		Connection conn = null;
		try
		{
			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("Driver");
			String  updateQuery = "UPDATE USERS SET VER_CODE = ? WHERE CODE = '"+userId+"'";
			pstmt = conn.prepareStatement(updateQuery);
			pstmt.setString(1, verCode);
			int updateCount = pstmt.executeUpdate();
			BaseLogger.log("3",null,null,"CommonDBAccessEJB.updateVerfCode() update count:["+updateCount+"]");
			conn.commit();
		}
		catch (Exception e)
		{
			BaseLogger.log("0",null,null,"CommonDBAccessEJB.updateVerfCode() Exception:["+E12GenericUtility.getStackTrace(e)+"]");
		}
		finally
		{
			try 
			{
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if( conn != null )
				{
					conn.close();
					conn = null;
				}
			}
			catch (Exception e2) 
			{
				BaseLogger.log("0",null,null,"CommonDBAccessEJB.updateVerfCode() finally Exception:["+E12GenericUtility.getStackTrace(e2)+"]");
				throw new ITMException(e2);
			}
		}
	}
	//Added By Pankaj T. on 19-07-2022 [Added new column ver_code in users table for maintain forgot password verification code to resend the same when next request trigger in predefined interval]
}