package ibase.webitm.ejb.wsfa.transactions;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;

public class StrgProductEJB extends ValidatorEJB
{
	E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
	ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		System.out.println("....wfValData method called from StrgProductEJB....");
		System.out.println("xmlString : "+xmlString);
		System.out.println("xmlString1 : "+xmlString1);
		System.out.println("xmlString2 : "+xmlString2);
		System.out.println("editFlag : "+editFlag);
		System.out.println("xtraParams : "+xtraParams);
		String errString = "";
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		try
		{
			dom = genericUtility.parseString(xmlString);
			dom1 = genericUtility.parseString(xmlString1);
			if(xmlString2.trim().length() > 0 )
			{
				dom2 = genericUtility.parseString("<Root>" + xmlString2+ "</Root>");
			}
			errString = wfValData(dom, dom1, dom2, objContext, editFlag, xtraParams);
			System.out.println("errString : "+errString);
		}
		catch(Exception e)
		{
			System.out.println("Exception :[wfValData()] :==>\n" + e.getMessage());
			throw new ITMException(e);
		}

		return errString;
	}

	public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		String childNodeName = null;
		String errString = "" , errCode = "";
		String userId = "";
		String objName = "";
		String errorType = "";
		String columnValue ="";
		String totalBusiness = "";
		String businessToUS = "";
		Connection conn = null;
		int currentFormNo = 0;
		int childNodeListLength = 0;
		int parentNodeListLength = 0;
		int ctr = 0 , cnt = 0;
		ArrayList<String> errList = new ArrayList<String>();
		ArrayList<String> errFields = new ArrayList<String>();
        StringBuffer errStringXml = new StringBuffer("<?xml version = \"1.0\"?> \r\n <Root> <Errors>");
        String scCode = "", salesPers = "", itemSer = "", custType = "", firstNae = "", middleName = "", lastName = "", classCode = "", classCodeDescr = "",
                itemCode = "", itemCodeDescr = "", productCode = "", productDescr = "",
                brandCode = "", brandDescr = "", minQty = "";
        PreparedStatement pstmt = null;
        ResultSet rs = null;
		try
		{
			System.out.println("Inside try of wfValData : "+genericUtility.serializeDom(dom));
			conn = getConnection();
			userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			objName = checkNullAndTrim(getObjNameFromDom(dom, "objName", objContext ));
			System.out.println("objName: "+objName);
			if(objContext != null && objContext.trim().length() > 0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			System.out.println("currentFormNo: "+currentFormNo);
			switch(currentFormNo)
			{
			case 1: 
				parentNodeList = dom.getElementsByTagName("Detail"+ currentFormNo);
				parentNodeListLength = parentNodeList.getLength();
				System.out.println("parentNodeListLength: "+parentNodeListLength);
				for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
				{
					parentNode = parentNodeList.item(0);
					childNodeList = parentNode.getChildNodes();
					childNodeListLength = childNodeList.getLength();
					System.out.println("childNodeListLength: "+childNodeListLength);
					for(ctr = 0; ctr < childNodeListLength; ctr ++)
					{
						columnValue ="";
						childNode = childNodeList.item(ctr);
						System.out.println("childNode: "+childNode);
						if( childNode.getNodeType() != Node.ELEMENT_NODE )
						{
							continue;
						}
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							columnValue = childNode.getFirstChild().getNodeValue();
						}
						System.out.println("columnValue: "+columnValue);
						childNodeName = childNode.getNodeName();
						System.out.println("childNodeName: "+childNodeName);
						if(childNodeName.equalsIgnoreCase("sc_code"))
						{
							System.out.println("childNodeName: "+childNodeName);
							if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
									( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
							{
								System.out.println("sc_code cannot be null");
								errString = itmDBAccessEJB.getErrorString("sc_code","STPRDSCNLL",userId,"",conn);

								break;
                            }
                            else
                            {
                                int count = 0;
                                scCode = E12GenericUtility.checkNull(genericUtility.getColumnValue("sc_code",dom));
                                String sql = "select count(1) from strg_customer where sc_code = ? " ;
                                
                                pstmt =  conn.prepareStatement(sql);	
                                pstmt.setString(1, scCode);	
                                rs = pstmt.executeQuery();

                                if( rs.next() )
                                {
                                    count = rs.getInt(1);
                                }

                                if(count == 0)
                                {
                                    errString = getErrorString( "sc_code","VPINVCSCDM",userId );
                                    break;
                                }
                                
                                if(rs != null)
                                {
                                    rs.close();
                                    rs= null;
                                }
                                if(pstmt != null)
                                {
                                    pstmt.close();
                                    pstmt= null;
                                }

                            }
						}
						else if(childNodeName.equalsIgnoreCase("item_ser"))
						{
							System.out.println("childNodeName: "+childNodeName);
							if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
									( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
							{
								System.out.println("item_ser cannot be null");
								errString = itmDBAccessEJB.getErrorString("item_ser","SPITMSRNUL",userId,"",conn);

								break;
							}
                        }
                        else if(childNodeName.equalsIgnoreCase("min_qty"))
						{
							System.out.println("childNodeName: "+childNodeName);
							minQty = E12GenericUtility.checkNull(genericUtility.getColumnValue("min_qty", dom));
							System.out.println("min_qty:"+totalBusiness);
							try
							{
                                if(minQty.length() > 0)
                                {
                                    int minQtyInt = Integer.parseInt(minQty);
                                    if(minQtyInt < 0)
                                    {
                                        errString = itmDBAccessEJB.getErrorString("min_qty","INVMINQTY1",userId,"",conn);    
                                        break;
                                    }
                                }
                                else
                                {
                                    errString = itmDBAccessEJB.getErrorString("min_qty","INVMINQTY2",userId,"",conn);
                                    break;
                                }
							}
							catch(Exception e)
							{
								errString = itmDBAccessEJB.getErrorString("min_qty","INVMINQTY",userId,"",conn);

								break;
							}
						}

						/*else if(childNodeName.equalsIgnoreCase("item_code"))
						{
							System.out.println("childNodeName: "+childNodeName);
							if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
									( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
							{
								System.out.println("tran_id cannot be null");
								errString = itmDBAccessEJB.getErrorString("item_code","SPITMCDNUL",userId,"",conn);

								break;
							}
						}

						else if(childNodeName.equalsIgnoreCase("brand_code"))
						{
							System.out.println("childNodeName: "+childNodeName);
							if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
									( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
							{
								System.out.println("brand_code cannot be null");
								errString = itmDBAccessEJB.getErrorString("brand_code","STBRDCDNUL",userId,"",conn);

								break;
							}
						}
						else if(childNodeName.equalsIgnoreCase("valid_from"))
						{
							System.out.println("childNodeName: "+childNodeName);
							if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
									( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
							{
								System.out.println("valid_from cannot be null");
								errString = itmDBAccessEJB.getErrorString("valid_from","STVLFRMNUL",userId);

								break;
							}
						}
						else if(childNodeName.equalsIgnoreCase("valid_to"))
						{
							System.out.println("childNodeName: "+childNodeName);
							if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
									( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
							{
								System.out.println("valid_to cannot be null");
								errString = itmDBAccessEJB.getErrorString("valid_to","STVLTOMNUL",userId,"",conn);

								break;
							}
						}
						else if(childNodeName.equalsIgnoreCase("total_business"))
						{
							System.out.println("childNodeName: "+childNodeName);
							totalBusiness = checkNullAndTrim(genericUtility.getColumnValue("total_business", dom));
							System.out.println("total_business:"+totalBusiness);
							try
							{
								if(totalBusiness != null && (Double.parseDouble(totalBusiness) < 0 || totalBusiness.indexOf(".") == 1 ))
								{
									errString = itmDBAccessEJB.getErrorString("total_business","STINVTOTBS",userId,"",conn);

									break;
								}
							}
							catch(Exception e)
							{
								errString = itmDBAccessEJB.getErrorString("total_business","STINVTOTBS",userId,"",conn);

								break;
							}
						}
						else if(childNodeName.equalsIgnoreCase("business_to_us"))
						{
							System.out.println("childNodeName: "+childNodeName);
							businessToUS = checkNullAndTrim(genericUtility.getColumnValue("business_to_us", dom));
							System.out.println("business_to_us:"+businessToUS);

							try
							{
								if(businessToUS != null && (Double.parseDouble(businessToUS) < 0 || businessToUS.indexOf(".") == 1 ))
								{
									errString = itmDBAccessEJB.getErrorString("total_business","STINVBSTUS",userId,"",conn);

									break;
								}
							}
							catch(Exception e)
							{
								errString = itmDBAccessEJB.getErrorString("total_business","STINVBSTUS",userId,"",conn);

								break;
							}
						}*/
					}    
				}
				break;
			}
			int errListSize = errList.size();
			cnt = 0;
			String errFldName = null;
			if(errList != null && errListSize > 0)
			{
				for(cnt = 0; cnt < errListSize; cnt ++)
				{
					errCode = errList.get((int) cnt);
					errFldName = errFields.get((int) cnt);
					errString = getErrorString(errFldName, errCode, userId);
					errorType =  errorType(conn , errCode);
					if(errString.length() > 0)
					{
						String bifurErrString = errString.substring(errString.indexOf("<Errors>") + 8, errString.indexOf("<trace>"));
						bifurErrString = bifurErrString + errString.substring(errString.indexOf("</trace>") + 8, errString.indexOf("</Errors>"));
						errStringXml.append(bifurErrString);
						errString = "";
					}
					if(errorType.equalsIgnoreCase("E"))
					{
						break;
					}
				}
				errList.clear();
				errList = null;
				errFields.clear();
				errFields = null;
				errStringXml.append("</Errors> </Root> \r\n");
			}
			else
			{
				errStringXml = new StringBuffer("");
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			errString = e.getMessage();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(conn != null)
				{
					conn.close();
				}
				conn = null;
			}
			catch(Exception d)
			{
				d.printStackTrace();
				throw new ITMException(d);
			}
		}
		return errString;
	}

	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String valueXmlString = "";
		try
		{
			System.out.println("Inside itemChanged of StrgProductEJB : xmlString :"+xmlString);
			dom = genericUtility.parseString(xmlString);
			dom1 = genericUtility.parseString(xmlString1);
			dom2 = genericUtility.parseString(xmlString2);

			valueXmlString = itemChanged(dom, dom1, dom2, objContext, currentColumn, editFlag, xtraParams);
		}
		catch(Exception e)
		{
			System.out.println("Exception :[itemChanged()] :==>\n" + e.getMessage());
			throw new ITMException(e);
		}
		System.out.println("valueXmlString :" + valueXmlString);
		return valueXmlString;

	}
	public String itemChanged(Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		StringBuffer valueXmlString = new StringBuffer();
		
		String currDate = "";
		String userId = "";
		String chgTerm = "";
		Connection conn = null;
        int currentFormNo = 0;
        PreparedStatement pstmt = null;
        ResultSet rs = null;

        String scCode = "", salesPers = "", itemSer = "", custType = "", firstName = "", middleName = "", lastName = "", classCode = "", classCodeDescr = "",
                itemCode = "", itemDescr = "", productCode = "", productDescr = "",
                brandCode = "", brandDescr = "";
		try
		{
			conn = getConnection();

			DateFormat dtFormat = new SimpleDateFormat(getApplDateFormat());
			java.util.Date date = Calendar.getInstance().getTime();
			currDate = dtFormat.format( date );
			System.out.println("currDate:"+currDate);
			userId = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" );
			System.out.println("userId:"+userId);
			chgTerm = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"term_id");
			System.out.println("chgTerm:"+chgTerm);
			if(objContext != null && objContext.trim().length() > 0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			valueXmlString = new StringBuffer("<?xml version = \"1.0\"?><Root><header><editFlag>");
			valueXmlString.append(editFlag).append("</editFlag></header>");
			switch ( currentFormNo )
			{
			case 1:
			{
				valueXmlString.append("<Detail1>");
				if( currentColumn.trim().equalsIgnoreCase( "itm_default" ))
				{
                    valueXmlString.append( "<sales_pers><![CDATA[" ).append(userId).append( "]]></sales_pers>\r\n" );

                    salesPers = E12GenericUtility.checkNull(genericUtility.getColumnValue("sales_pers",dom));
                    String sql = "select item_ser from sales_pers where sales_pers = ? ";
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setString(1, userId);
					rs = pstmt.executeQuery();
					if( rs.next())
					{
						itemSer = E12GenericUtility.checkNull(rs.getString("item_ser"));
					}
					if ( rs != null )
					{
						rs.close();
						rs = null;
					}
					if ( pstmt != null )
					{
						pstmt.close();
						pstmt = null;
                    }
                    valueXmlString.append("<item_ser protect='1' ><![CDATA[").append(itemSer).append("]]></item_ser>\r\n");

					valueXmlString.append( "<chg_date><![CDATA[" ).append(currDate).append( "]]></chg_date>\r\n" );
					valueXmlString.append( "<chg_user><![CDATA[" ).append(userId).append( "]]></chg_user>\r\n" );
					valueXmlString.append( "<chg_term><![CDATA[" ).append(chgTerm).append( "]]></chg_term>\r\n" );
				}
				else if(currentColumn.trim().equalsIgnoreCase( "itm_defaultedit" ))
				{
					valueXmlString.append( "<chg_date><![CDATA[" ).append(currDate).append( "]]></chg_date>\r\n" );
					valueXmlString.append( "<chg_user><![CDATA[" ).append(userId).append( "]]></chg_user>\r\n" );
					valueXmlString.append( "<chg_term><![CDATA[" ).append(chgTerm).append( "]]></chg_term>\r\n" );
                }
                else if(currentColumn.trim().equalsIgnoreCase( "sales_pers" ))
                {
                    salesPers = E12GenericUtility.checkNull(genericUtility.getColumnValue("sales_pers",dom));
                    String sql = "select item_ser from sales_pers where sales_pers = ? ";
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setString(1, salesPers);
					rs = pstmt.executeQuery();
					if( rs.next())
					{
						itemSer = E12GenericUtility.checkNull(rs.getString("item_ser"));
					}
					if ( rs != null )
					{
						rs.close();
						rs = null;
					}
					if ( pstmt != null )
					{
						pstmt.close();
						pstmt = null;
                    }
                    valueXmlString.append("<item_ser protect='1'><![CDATA[").append(itemSer).append("]]></item_ser>\r\n");
                }
                else if(currentColumn.trim().equalsIgnoreCase( "sc_code" ))
                {
                    scCode = E12GenericUtility.checkNull(genericUtility.getColumnValue("sc_code",dom));
                    String sql = "select cust_type, first_name, middle_name, last_name, class_code,class_code_descr from strg_customer where sc_code= ? ";
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setString(1, scCode);
					rs = pstmt.executeQuery();
					if( rs.next())
					{
                        custType = E12GenericUtility.checkNull(rs.getString("cust_type"));
                        firstName = E12GenericUtility.checkNull(rs.getString("first_name"));
                        middleName = E12GenericUtility.checkNull(rs.getString("middle_name"));
                        lastName = E12GenericUtility.checkNull(rs.getString("last_name"));
                        classCode = E12GenericUtility.checkNull(rs.getString("class_code"));
                        classCodeDescr = E12GenericUtility.checkNull(rs.getString("class_code_descr"));
                        
					}
					if ( rs != null )
					{
						rs.close();
						rs = null;
					}
					if ( pstmt != null )
					{
						pstmt.close();
						pstmt = null;
                    }
                    valueXmlString.append("<cust_type protect='1'><![CDATA[").append(custType).append("]]></cust_type>\r\n");
                    valueXmlString.append("<first_name><![CDATA[").append(firstName).append("]]></first_name>\r\n");
                    valueXmlString.append("<middle_name><![CDATA[").append(middleName).append("]]></middle_name>\r\n");
                    valueXmlString.append("<last_name><![CDATA[").append(lastName).append("]]></last_name>\r\n");
                    valueXmlString.append("<class_code><![CDATA[").append(classCode).append("]]></class_code>\r\n");
                    valueXmlString.append("<class_code_descr protect='1'><![CDATA[").append(classCodeDescr).append("]]></class_code_descr>\r\n");
                }
                else if(currentColumn.trim().equalsIgnoreCase( "item_code" ))
                {
                    itemCode = E12GenericUtility.checkNull(genericUtility.getColumnValue("item_code",dom));
                    String sql = "select descr from item where item_code = ? ";
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setString(1, itemCode);
					rs = pstmt.executeQuery();
					if( rs.next())
					{
                        itemDescr = E12GenericUtility.checkNull(rs.getString("descr"));
                        
					}
					if ( rs != null )
					{
						rs.close();
						rs = null;
					}
					if ( pstmt != null )
					{
						pstmt.close();
						pstmt = null;
                    }
                    valueXmlString.append("<descr protect='1'><![CDATA[").append(itemDescr).append("]]></descr>\r\n");
                }
                else if(currentColumn.trim().equalsIgnoreCase( "product_code" ))
                {
                    productCode = E12GenericUtility.checkNull(genericUtility.getColumnValue("product_code",dom));
                    String sql = "select descr from product where product_code = ? ";
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setString(1, productCode);
					rs = pstmt.executeQuery();
					if( rs.next())
					{
                        productDescr = E12GenericUtility.checkNull(rs.getString("descr"));
                        
					}
					if ( rs != null )
					{
						rs.close();
						rs = null;
					}
					if ( pstmt != null )
					{
						pstmt.close();
						pstmt = null;
                    }
                    valueXmlString.append("<product_descr protect='1'><![CDATA[").append(productDescr).append("]]></product_descr>\r\n");
                }
                else if(currentColumn.trim().equalsIgnoreCase( "brand_code" ))
                {
                    brandCode = E12GenericUtility.checkNull(genericUtility.getColumnValue("brand_code",dom));
                    String sql = "select description from brand where brand_code = ? ";
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setString(1, brandCode);
					rs = pstmt.executeQuery();
					if( rs.next())
					{
                        brandDescr = E12GenericUtility.checkNull(rs.getString("description"));
                        
					}
					if ( rs != null )
					{
						rs.close();
						rs = null;
					}
					if ( pstmt != null )
					{
						pstmt.close();
						pstmt = null;
                    }
                    valueXmlString.append("<brand_description protect='1'><![CDATA[").append(brandDescr).append("]]></brand_description>\r\n");
                }
                
				valueXmlString.append("</Detail1>");	
			}
			break;
			}		
		}
		catch(Exception e)
		{
			e.printStackTrace();
			System.out.println("Exception ::"+ e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(conn != null && !conn.isClosed())
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception d)
			{
				d.printStackTrace();
				throw new ITMException(d);
			}
		}
		valueXmlString.append("</Root>");
		System.out.println("valueXmlString ::"+valueXmlString.toString());
		return valueXmlString.toString();
	}
	private String errorType(Connection conn , String errorCode)
	{
		String msgType = "";
		PreparedStatement pstmt = null ;
		ResultSet rs = null;
		try
		{
			String  sql = "SELECT MSG_TYPE FROM MESSAGES WHERE MSG_NO = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,errorCode);
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				msgType = rs.getString("MSG_TYPE");
			}
		}
		catch(Exception ex)
		{
			ex.printStackTrace();
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return msgType;
	}
	private String getObjNameFromDom( Document dom, String attribute, String objContext ) throws RemoteException,ITMException
	{
		NodeList detailList = null;
		Node currDetail = null;
		String objName = "";
		int	detailListLength = 0;

		try
		{
			detailList = dom.getElementsByTagName("Detail"+objContext);
			detailListLength = detailList.getLength();
			for (int ctr = 0; ctr < detailListLength; ctr++)
			{
				currDetail = detailList.item(ctr);
				objName = currDetail.getAttributes().getNamedItem(attribute).getNodeValue();
			}
		}
		catch ( Exception e )
		{
			throw new ITMException(e);
		}
		System.out.println("objName =["+objName+"]");
		return objName;
	}
	private String checkNullAndTrim(String input)
	{
		if (input==null)
		{
			input="";
		}
		return input.trim();
	}
}
