package ibase.webitm.ejb.wsfa.transactions;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import ibase.system.config.ConnDriver;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;

public class RetailSchemeClaimConfirmation extends ValidatorEJB
{
	private E12GenericUtility genericUtility = new E12GenericUtility();

	public String schemeClaimApprove( String xmlData ,String signBy ,String refSer,  String appoverCode ,String userInfoStr, String tranID  )throws RemoteException, ITMException
	{
		System.out.println("[SchemeClaimApprove] SchemeClaimApprove Method called...");

		System.out.println("[SchemeClaimApprove] xmlData = ["+ xmlData +"]");
		System.out.println("[SchemeClaimApprove] signBy = "+signBy);
		System.out.println("[SchemeClaimApprove] refSer = "+refSer);
		System.out.println("[SchemeClaimApprove] appoverCode = "+appoverCode);
		System.out.println("[SchemeClaimApprove] userInfoStr = "+userInfoStr);
		System.out.println("[SchemeClaimApprove] tranID = "+tranID);

		String retString = "";
		boolean isError = false;
		PreparedStatement pStmt = null;
		ResultSet rs = null;
		Connection conn = null;
		ConnDriver connDriver = null;
		String transDB = "";

		try
		{
			UserInfoBean userInfo = new UserInfoBean(userInfoStr);
			connDriver = new ConnDriver();

			if( userInfo != null )
			{
				transDB = userInfo.getTransDB();
			}
			System.out.println("get TransDB connection in SchemeClaimApprove : "+transDB);

			if (transDB != null && transDB.trim().length() > 0)
			{
				conn = connDriver.getConnectDB(transDB);
			}
			System.out.println("connectionObject >>>>>>"+conn);

			updateAprvAmt(xmlData,conn);
			String userId  = appoverCode.trim();
			DateFormat dtFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());
			java.util.Date date = Calendar.getInstance().getTime();
			String currDate = dtFormat.format( date );
			currDate = genericUtility.getValidDateTimeString( currDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );

			//String updRetSchmSql = "UPDATE RETAIL_SCH_CLAIM SET CONFIRMED = 'Y', EMP_CODE__APRV = ? ,CONF_DATE = ? WHERE TRAN_ID = ? ";
			String updRetSchmSql = "UPDATE RETAIL_SCH_CLAIM SET CONFIRMED = 'A' WHERE TRAN_ID = ? ";

			pStmt = conn.prepareStatement( updRetSchmSql );
			/*pStmt.setString(1, userId );
			pStmt.setTimestamp(2,java.sql.Timestamp.valueOf( currDate ));
			pStmt.setString(3, tranID );*/
			pStmt.setString(1, tranID );
			int updCnt = pStmt.executeUpdate();
			if(pStmt != null)
			{
				pStmt.close();
				pStmt = null;
			}
			System.out.println("updCnt[updRetSchmSql] =["+updCnt+"]");
		}
		catch (Exception e)
		{
			isError = true;
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( rs != null )
				{
					rs.close();
					rs = null;
				}
				if(pStmt != null )
				{
					pStmt.close();
					pStmt = null;
				}
				if(conn != null )
				{
					if(!isError)
					{
						conn.commit();
					}
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception 1 updRetSchmSql(String) :==>\n"+e.getMessage());
			}
		}
		return retString;
	}

	private void updateAprvAmt(String xmlData, Connection conn) throws SQLException, RemoteException 
	{
		Document dom = null;
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		String columnValue = null;
		String childNodeName = null;
		int childNodeListLength;
		String AprvAmt = "";
		int ctr;
		PreparedStatement pstmt = null;
		String sql= "",lineNo="",tranId="";
		try 
		{
			dom = parseString(xmlData);
			parentNodeList = dom.getElementsByTagName("Detail2");
			for(int i = 0; i < parentNodeList.getLength(); i++)
			{
				parentNode = parentNodeList.item(i);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();
				for (ctr = 0; ctr < childNodeListLength; ctr++)
				{
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					if(childNode.getFirstChild()!=null)
					{
						columnValue = childNode.getFirstChild().getNodeValue();
					}
					else
					{
						columnValue = "";
					}

					if (childNodeName.equalsIgnoreCase("aprv_amt"))
					{
						AprvAmt = columnValue.trim();
						System.out.println("AprvAmt10>>>>>" + AprvAmt);
					}
					if (childNodeName.equalsIgnoreCase("tran_id"))
					{
						tranId = columnValue.trim();
						System.out.println("tran_id>>>>>" + tranId);
					}
					if (childNodeName.equalsIgnoreCase("line_no"))
					{
						lineNo = columnValue.trim();
						System.out.println("line_no>>>>>" + lineNo);
					}
				} 
				sql = "update retail_sch_claim_det set aprv_amt = ? where tran_id = ? and line_no = ?";

				System.out.println( "updateaprvAmt:==>\n"+sql);
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, AprvAmt);
				pstmt.setString(2, tranId);
				pstmt.setString(3, lineNo);
				pstmt.executeQuery();
			}
			pstmt.close();
			pstmt = null;
		}
		catch (ITMException e) 
		{
			e.printStackTrace();
		}
	}

	public String schemeClaimRejected( String tranID ,String userInfoStr )throws RemoteException, ITMException
	{
		System.out.println("[SchemeClaimRejected] SchemeClaimRejected Method called...");

		System.out.println("[SchemeClaimRejected] tranID = "+tranID);
		System.out.println("[SchemeClaimRejected] userInfoStr = "+userInfoStr);

		boolean isError = false;
		PreparedStatement pStmt = null;
		ResultSet rs = null;
		String retString = "";
		Connection connectionObject = null;
		ConnDriver connDriver = null;
		String transDB = "";

		try
		{
			UserInfoBean userInfo = new UserInfoBean(userInfoStr);
			connDriver = new ConnDriver();

			if( userInfo != null )
			{
				transDB = userInfo.getTransDB();
			}
			System.out.println("get TransDB connection in SchemeClaimRejected : "+transDB);

			if (transDB != null && transDB.trim().length() > 0)
			{
				connectionObject = connDriver.getConnectDB(transDB);
			}

			//String updRetSchmSql2 = "UPDATE RETAIL_SCH_CLAIM SET CONFIRMED = 'N', WF_STATUS = 'D' WHERE TRAN_ID = ? ";
			String updRetSchmSql2 = "UPDATE RETAIL_SCH_CLAIM SET CONFIRMED = 'N', WF_STATUS = 'D', CONF_DATE = '', EMP_CODE__APRV = '' WHERE TRAN_ID = ? ";

			pStmt = connectionObject.prepareStatement(updRetSchmSql2);
			pStmt.setString(1, tranID );
			int updCnt = pStmt.executeUpdate();
			if(pStmt != null)
			{
				pStmt.close();
				pStmt = null;
			}
			System.out.println("updCnt>>>["+updCnt+"]");
			
			String updRetAprvAmt = "UPDATE RETAIL_SCH_CLAIM_DET SET APRV_AMT = '0' WHERE TRAN_ID = ? ";

			pStmt = connectionObject.prepareStatement(updRetAprvAmt);
			pStmt.setString(1, tranID );
			updCnt = pStmt.executeUpdate();
			if(pStmt != null)
			{
				pStmt.close();
				pStmt = null;
			}
			System.out.println("APRV_AMT updCnt>>>["+updCnt+"]");
		}
		catch (Exception e)
		{
			isError = true;
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( rs != null )
				{
					rs.close();
					rs = null;
				}
				if(pStmt != null )
				{
					pStmt.close();
					pStmt = null;
				}
				if(connectionObject != null )
				{
					if(!isError)
					{
						connectionObject.commit();
					}
					connectionObject.close();
					connectionObject = null;
				}

			}
			catch(Exception e)
			{
				System.out.println( "Exception 2 updRetSchmSql(String) :==>\n"+e.getMessage());
			}
		}
		return retString;
	}

	public String checkNull(String input)
	{
		if (input == null || "null".equalsIgnoreCase(input))
		{
			input= "";
		}
		return input.trim();
	}

	public String schemeClaimRejectedADM( String tranID ,String userInfoStr )throws RemoteException, ITMException
	{
		System.out.println("[SchemeClaimRejected] schemeClaimRejectedADM Method called...");

		System.out.println("[SchemeClaimRejected] tranID = "+tranID);
		System.out.println("[SchemeClaimRejected] userInfoStr = "+userInfoStr);

		boolean isError = false;
		PreparedStatement pStmt = null;
		ResultSet rs = null;
		String retString = "";
		Connection connectionObject = null;
		ConnDriver connDriver = null;
		String transDB = "";

		try
		{
			UserInfoBean userInfo = new UserInfoBean(userInfoStr);
			connDriver = new ConnDriver();

			if( userInfo != null )
			{
				transDB = userInfo.getTransDB();
			}
			System.out.println("get TransDB connection in SchemeClaimRejected : "+transDB);

			if (transDB != null && transDB.trim().length() > 0)
			{
				connectionObject = connDriver.getConnectDB(transDB);
			}

			String updRetSchmSql2 = "UPDATE RETAIL_SCH_CLAIM SET CONFIRMED = 'R', WF_STATUS = 'D', CONF_DATE = '', EMP_CODE__APRV = '' WHERE TRAN_ID = ? ";

			pStmt = connectionObject.prepareStatement(updRetSchmSql2);
			pStmt.setString(1, tranID );
			int updCnt = pStmt.executeUpdate();
			if(pStmt != null)
			{
				pStmt.close();
				pStmt = null;
			}
			System.out.println("updCnt>>>["+updCnt+"]");
			
			String updRetAprvAmt = "UPDATE RETAIL_SCH_CLAIM_DET SET APRV_AMT = '0' WHERE TRAN_ID = ? ";

			pStmt = connectionObject.prepareStatement(updRetAprvAmt);
			pStmt.setString(1, tranID );
			updCnt = pStmt.executeUpdate();
			if(pStmt != null)
			{
				pStmt.close();
				pStmt = null;
			}
			System.out.println("APRV_AMT updCnt>>>["+updCnt+"]");
		}
		catch (Exception e)
		{
			isError = true;
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( rs != null )
				{
					rs.close();
					rs = null;
				}
				if(pStmt != null )
				{
					pStmt.close();
					pStmt = null;
				}
				if(connectionObject != null )
				{
					if(!isError)
					{
						connectionObject.commit();
					}
					connectionObject.close();
					connectionObject = null;
				}

}
			catch(Exception e)
			{
				System.out.println( "Exception 2 updRetSchmSql(String) :==>\n"+e.getMessage());
			}
		}
		return retString;
	}
}
