/*
 * Decompiled with CFR 0.152.
 */
package ibase.bi.ejb.session;

import ibase.bi.common.system.config.DBInfo;
import ibase.bi.ejb.session.UserReportModfLocal;
import ibase.bi.ejb.session.UserReportModfRemote;
import ibase.bi.utility.BIException;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import javax.ejb.Stateless;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;

@Stateless
public class UserReportModfEJB
implements UserReportModfRemote,
UserReportModfLocal {
    private String objName = null;
    private String objOwner = null;
    private ArrayList colName = null;
    private String absFileName = null;

    @Override
    public void setUserReportModf(String objName, String objOwner) throws RemoteException, Exception {
        BaseLogger.log("2", null, null, "UserReportModfEJB is called");
        this.objName = objName;
        this.objOwner = objOwner;
        objName = String.valueOf(objName) + "~%";
        Connection con = null;
        Statement stmt = null;
        ResultSet resultSet = null;
        OutputStreamWriter fileWritter = null;
        try {
            try {
                ConnDriver conDriver = new ConnDriver();
                con = conDriver.getConnectDB(DBInfo.getDataProfileName("DriverBI"));
                String sql = "SELECT OBJ_NAME,OBJ_OWNER,REP_SCHEMA,OBJ_VERSION,LAST_EXE_DATE,CHG_DATE,CHG_USER,CHG_TERM FROM BI_OBJ_RESOURCE_HIST WHERE OBJ_OWNER= ? AND OBJ_NAME LIKE ? ORDER BY LAST_EXE_DATE DESC";
                stmt = con.prepareStatement(sql);
                stmt.setObject(1, objOwner);
                stmt.setObject(2, objName);
                resultSet = stmt.executeQuery();
                String suffix = "UserReporModf_" + Math.random();
                String prefix = ".xml";
                File tempDirectory = new File(String.valueOf(CommonConstants.BIHOME) + File.separator + "xmldatafiles");
                File absFileName = File.createTempFile(suffix, prefix, tempDirectory);
                String FilePath = absFileName.getAbsolutePath();
                fileWritter = new FileWriter(absFileName);
                StringBuffer stringbuffer = new StringBuffer();
                stringbuffer.append("<?xml version='1.0' encoding='" + CommonConstants.ENCODING + "'?>\n");
                stringbuffer.append("<BI>");
                stringbuffer.append("<BA>" + this.objName + "</BA>");
                stringbuffer.append("<USERID>" + this.objOwner + "</USERID>");
                stringbuffer.append("<ROWS>");
                stringbuffer.append("<DATA>\n");
                while (resultSet.next()) {
                    stringbuffer.append("<DETAIL id=''>");
                    stringbuffer.append("<OBJ_NAME>" + this.objName + "</OBJ_NAME>");
                    stringbuffer.append("<MODIFIED_OBJ_NAME>" + resultSet.getString(1) + "</MODIFIED_OBJ_NAME>");
                    stringbuffer.append("<OBJ_OWNER>" + resultSet.getString(2) + "</OBJ_OWNER>");
                    stringbuffer.append("<REP_SCHEMA>" + resultSet.getString(3) + "</REP_SCHEMA>");
                    stringbuffer.append("<OBJ_VERSION>" + resultSet.getInt(4) + "</OBJ_VERSION>");
                    E12GenericUtility genericUtility = new E12GenericUtility();
                    Timestamp timestamp = resultSet.getTimestamp(5);
                    String dateTime = genericUtility.getValidDateTimeString(timestamp, CommonConstants.DISP_DATE_FORMAT);
                    stringbuffer.append("<LAST_EXE_DATE>" + dateTime + "</LAST_EXE_DATE>");
                    stringbuffer.append("<MODIFIED_BY>" + resultSet.getString(7) + "</MODIFIED_BY>");
                    stringbuffer.append("<CHG_TERMINAL>" + resultSet.getString(8) + "</CHG_TERMINAL>");
                    stringbuffer.append("</DETAIL>\n");
                }
                stringbuffer.append("</DATA>");
                stringbuffer.append("</ROWS>");
                stringbuffer.append("</BI>");
                fileWritter.write(stringbuffer.toString());
                String xmlString = stringbuffer.toString();
                String string = this.genUserReportModfhtml(xmlString);
            }
            catch (Exception e) {
                try {
                    if (con != null) {
                        con.rollback();
                        con.close();
                        con = null;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                BIException.setErrorCode(0);
                e.printStackTrace();
                throw e;
            }
        }
        finally {
            if (con != null) {
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
                con.close();
                con = null;
            }
            resultSet.close();
            fileWritter.flush();
            fileWritter.close();
        }
        BaseLogger.log("2", null, null, "obj name [" + objName + "] abd obj owoner [" + objOwner + "]");
    }

    private String genUserReportModfhtml(String XMLData) throws RemoteException, Exception {
        String retString = null;
        ByteArrayOutputStream bos = null;
        OutputStreamWriter fileWriter = null;
        try {
            try {
                E12GenericUtility genericUtility = new E12GenericUtility();
                String data = XMLData;
                Document dom = genericUtility.parseString(data);
                String xslFile = genericUtility.readFile(String.valueOf(CommonConstants.APPLICATION_CONTEXT) + "bi" + File.separator + "xsl" + File.separator + "UserReportModf.xsl");
                String suffix = "UserReporModf_" + Math.random();
                String prefix = ".html";
                File tempDirectory = new File(String.valueOf(CommonConstants.BIHOME) + File.separator + "xmldatafiles");
                File absTempFileName = File.createTempFile(suffix, prefix, tempDirectory);
                fileWriter = new FileWriter(absTempFileName);
                String filePath = absTempFileName.getAbsolutePath();
                if (xslFile != null && xslFile.length() > 0) {
                    System.setProperty("javax.xml.transformer.TransformerFactory", "org.apache.xalan.processor.TransformerFactoryImpl");
                    TransformerFactory tFactory = TransformerFactory.newInstance();
                    Transformer transformer = tFactory.newTransformer(new StreamSource(new ByteArrayInputStream(xslFile.getBytes())));
                    bos = new ByteArrayOutputStream();
                    transformer.transform(new DOMSource(dom), new StreamResult(bos));
                    retString = bos.toString();
                    BaseLogger.log("3", null, null, "XML transformed..........");
                } else {
                    retString = genericUtility.serializeDom(dom);
                }
                this.absFileName = filePath;
                fileWriter.write(retString);
            }
            catch (Exception e) {
                e.printStackTrace();
                BaseLogger.log("0", null, null, "Exception : SignBean :getHTMLData:==>\n" + e.getMessage());
                throw e;
            }
        }
        finally {
            try {
                if (bos != null) {
                    bos.close();
                    bos = null;
                }
                fileWriter.flush();
                fileWriter.close();
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception in releasing file resource :");
                e.printStackTrace();
            }
        }
        return retString;
    }

    @Override
    public String getUserRepModfHtmlFileName() throws RemoteException, Exception {
        try {
            return this.absFileName;
        }
        catch (Exception e) {
            e.printStackTrace();
            BaseLogger.log("0", null, null, "Exception : SignBean :getHTMLData:==>\n" + e.getMessage());
            throw e;
        }
    }

    @Override
    public String removeUserModfReport(String Obj_name, String obj_owner) throws RemoteException, Exception {
        BaseLogger.log("2", null, null, "removeUserModfReport is called");
        Connection con = null;
        Statement stmt = null;
        int count = 0;
        Object fileWritter = null;
        try {
            try {
                String file;
                File xmlFile;
                boolean is_FileExit;
                ConnDriver conDriver = new ConnDriver();
                con = conDriver.getConnectDB(DBInfo.getDataProfileName("DriverBI"));
                String sql = "DELETE FROM BI_OBJ_RESOURCE_HIST WHERE OBJ_OWNER='" + obj_owner + "' AND OBJ_NAME='" + Obj_name + "'";
                stmt = con.prepareStatement(sql);
                count = stmt.executeUpdate(sql);
                BaseLogger.log("3", null, null, "Report name[" + Obj_name + "]is deleted from data base");
                if (count >= 1 && (is_FileExit = (xmlFile = new File(file = String.valueOf(CommonConstants.BI_RESOURCE_PATH) + File.separator + obj_owner.trim() + File.separator + "userbi" + File.separator + File.separator + "History" + File.separator + Obj_name + ".xml")).exists())) {
                    boolean status = xmlFile.delete();
                    BaseLogger.log("3", null, null, "Report name[" + Obj_name + "]is deleted from History");
                }
                con.commit();
            }
            catch (Exception e) {
                try {
                    if (con != null) {
                        con.rollback();
                        con.close();
                        con = null;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                BIException.setErrorCode(0);
                e.printStackTrace();
                throw e;
            }
        }
        finally {
            if (con != null) {
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
                con.close();
                con = null;
            }
        }
        return new String("removed");
    }
}

