package ibase.webitm.servlet.wsfa;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.json.JSONObject;
import org.json.simple.JSONArray;

import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.wsfa.masters.BrandCampaign;
import ibase.webitm.ejb.wsfa.masters.SellsStock;

public class BrandCompignServlet extends HttpServlet 
{
	private static final long serialVersionUID = 1L;

	public void doGet(HttpServletRequest request,HttpServletResponse response) throws IOException, ServletException
	{
		BaseLogger.log( "2", null, null, "Inside doGet....BrandCompignServlet" );
		doPost(request, response);
	}

	public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException
	{
		BaseLogger.log( "2", null, null, "In SalesPerformanceServlet" );
		String responseStr = "";
		try
		{
			HttpSession session = request.getSession();
			
			UserInfoBean userInfo = (UserInfoBean) session.getAttribute( "USER_INFO" );
			String saleperson = E12GenericUtility.checkNull( request.getParameter("SO-TEST") );
			BaseLogger.log( "3", userInfo, null, "saleperson : ["+ saleperson +"]" );	
			
			String uri = request.getScheme() + "://" +   
		             request.getServerName(); 
		                  
			System.out.println("uri = " + uri);
			
			if( userInfo != null && !saleperson.equalsIgnoreCase("Test") )
			{
			
				BaseLogger.log( "3", userInfo, null, "USER_INFO : ["+ userInfo +"]" );	
				BrandCampaign brandCampaign = new BrandCampaign();
				responseStr = brandCampaign.getBrandCompaign( userInfo );
				BaseLogger.log( "3", userInfo, null, "resultStr ["+ responseStr +"]" );
			}
			
			
			
			if ( userInfo != null && saleperson.equalsIgnoreCase("Test"))
			{
				BaseLogger.log( "3", userInfo, null, "USER_INFO : ["+ userInfo +"]" );
				
				String brandCode = E12GenericUtility.checkNull( request.getParameter("BRAND_CODE") );
				String campaignId = E12GenericUtility.checkNull( request.getParameter("CAMPGN_ID") );
				
				BaseLogger.log( "3", userInfo, null, "brandCode : ["+ brandCode  +"]" + "campaignId : ["+ campaignId  +"]");
				
				BrandCampaign brandCampaign = new BrandCampaign();
				responseStr = brandCampaign.getBrandCompaignSO( userInfo,brandCode ,campaignId );
				BaseLogger.log( "3", userInfo, null, "resultStr ["+ responseStr +"]" );
			}
			
			if ( userInfo != null && saleperson.equalsIgnoreCase("TestDoctor"))
			{
				BaseLogger.log( "3", userInfo, null, "USER_INFO : ["+ userInfo +"]" );	
				BrandCampaign brandCampaign = new BrandCampaign();
				String brandCode = E12GenericUtility.checkNull( request.getParameter("BRAND_CODE") );

				String campaginId = E12GenericUtility.checkNull( request.getParameter("CAMPGN_ID") );
				BaseLogger.log( "3", userInfo, null, "resultStr 655campaginId ::::: ["+ campaginId +"]" );
				

				String salperon = E12GenericUtility.checkNull( request.getParameter("SALESPER") );
				BaseLogger.log( "3", userInfo, null, "resultStr salperon ::::: ["+ salperon +"]" );

				responseStr = brandCampaign.getBrandCompaignDoctor( userInfo,brandCode,campaginId ,salperon,uri);
				BaseLogger.log( "3", userInfo, null, "resultStr 655 ::::: ["+ responseStr +"]" );
			}
			
			if ( userInfo != null && saleperson.equalsIgnoreCase("Ranking"))
			{
				BaseLogger.log( "3", userInfo, null, "USER_INFO : ["+ userInfo +"]" );	
				BrandCampaign brandCampaign = new BrandCampaign();
				String brandCode = E12GenericUtility.checkNull( request.getParameter("BRAND_CODE") );

				String campaginId = E12GenericUtility.checkNull( request.getParameter("CAMPGN_ID") );
				BaseLogger.log( "3", userInfo, null, "resultStr 655campaginId ::::: ["+ campaginId +"]" );
				
				String salperon = E12GenericUtility.checkNull( request.getParameter("SALESPER") );
				BaseLogger.log( "3", userInfo, null, "resultStr getRanking salperon ::::: ["+ salperon +"]" );
				
				responseStr = brandCampaign.getRanking( salperon,userInfo,brandCode,campaginId,uri);
				BaseLogger.log( "3", userInfo, null, "getRanking 93 ::::: ["+ responseStr +"]" );
				
				//responseStr = brandCampaign.getBrandCompaignDoctor( userInfo,brandCode,campaginId );
				BaseLogger.log( "3", userInfo, null, "resultStr 655 ::::: ["+ responseStr +"]" );
			}
				
			
	
			BaseLogger.log( "3", userInfo, null, "resultStr ["+ responseStr +"]" );
			
		}
		catch (Exception e)
		{
			BaseLogger.log( "0", null, null, "Exception :: SalesPerformanceServlet : ["+ responseStr +"]" );
			e.printStackTrace();
		}
		response.getWriter().write( responseStr );
	}

	private String checkNull( String nullStr )
	{
		return E12GenericUtility.checkNull(nullStr);
	}
}