/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.utility;

import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.utility.Column;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.SQLMaker;
import ibase.webitm.utility.TabSequenceComparator;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MetaDataObject {
    Document dom = null;
    ArrayList tableList;
    ArrayList columnsList;
    ArrayList argNamesList;
    ArrayList logicalNameList;
    String queryString = null;
    String tableToBeUpdated = null;
    ArrayList keyList;
    ArrayList primaryKeyPhyNameList;
    ArrayList primaryKeyLogNameList;
    ArrayList primaryKeyDataTypeList;
    HashMap colIDLogNameMap;
    HashMap colLogNameTypeMap;
    HashMap colLogNameSizeMap;
    HashMap physicalNameDisplayNameMap;
    HashMap physicalNameLogicalNameMap;
    Hashtable updateableLogPhyColNames;
    Hashtable nonEditableLogPhyColNames;
    Hashtable updateableLogNameColType;
    LinkedList noUpdateBandLinkList;
    String objContext;
    private HashMap dropDownColValueMap;
    private HashMap colDataTypeNameMap;
    String database = "oracle";
    protected String filename;
    private HashMap<String, String> tabOrderWiseLogicalNameMap;
    private HashMap<String, String> editableLogicalNameMap;
    private HashMap fieldCaseValMap;
    private HashMap fieldPrecisionValMap;
    private HashMap<String, String> nonEditableLogPhyColMap;
    private HashMap visibleFieldsValueMap;
    private HashMap<String, Integer> columnAlignmentMap;
    private UserInfoBean userInfo = null;

    public MetaDataObject(String filename, UserInfoBean userInfo) throws ITMException {
        try {
            this.filename = filename;
            File file = new File(filename);
            DocumentBuilder parser1 = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            this.dom = parser1.parse(file);
            this.userInfo = userInfo;
        }
        catch (FileNotFoundException fileNotFound) {
            BaseLogger.log("0", null, null, "Exception :DWObject :constructor :==>" + fileNotFound.getMessage());
            throw new ITMException(fileNotFound);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :DWObject :constructor :==>" + e.getMessage());
            throw new ITMException(e);
        }
    }

    public synchronized void initialize() throws ITMException {
        try {
            this.createColumns();
            this.setArgumentNames();
            this.createKeyList();
            this.createPrimaryKeyPhyNameList();
            this.createColIDLogNameMap();
            this.createColLogNameTypeMap();
            this.createColLogNameSizeMap();
            this.createPhysicalNameDisplayNameMap();
            this.createPhysicalNameLogicalNameMap();
            this.createUpdateableLogPhyColNames();
            this.createUpdateableLogNameColType();
            this.createDropDownColValueMap();
            this.createFieldCaseValueMap();
            this.createFieldPrecisionValueMap();
            this.createNonEditableLogPhyColMap();
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :DWObject :initialize :==>" + e.getMessage());
            throw new ITMException(e);
        }
    }

    private Node getCol_OtherTextInfo(Document dom, String nameSearch) throws ITMException {
        Node returnNode;
        block6: {
            returnNode = null;
            try {
                NodeList colDetailList = dom.getElementsByTagName("TextObject");
                int colDetailListLen = colDetailList.getLength();
                int i = 0;
                while (i < colDetailListLen) {
                    Node colNodeTextObject = colDetailList.item(i);
                    NodeList colNodeList = colNodeTextObject.getChildNodes();
                    int colNodeListLength = colNodeList.getLength();
                    int j = 1;
                    while (j < colNodeListLength) {
                        String tagName = null;
                        String tagValue = null;
                        Node colNode = colNodeList.item(j);
                        tagName = colNode.getNodeName().trim();
                        if (colNode.getFirstChild() != null && colNode.getFirstChild().getNodeValue() != null) {
                            tagValue = colNode.getFirstChild().getNodeValue().trim();
                        }
                        if (tagName.equals("name") && tagValue.equals(String.valueOf(nameSearch.trim()) + "_t")) {
                            returnNode = colDetailList.item(i);
                            break block6;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception :DWObject :getCol_OtherTextInfo :==>" + e.getMessage());
                throw new ITMException(e);
            }
        }
        return returnNode;
    }

    private Node getCol_OtherInfo(Document dom, String nameSearch) throws ITMException {
        Node returnNode;
        block6: {
            returnNode = null;
            try {
                NodeList colDetailList = dom.getElementsByTagName("ColumnObject");
                int colDetailListLength = colDetailList.getLength();
                int i = 0;
                while (i < colDetailListLength) {
                    Node colNodeColumnObject = colDetailList.item(i);
                    NodeList colNodeList = colNodeColumnObject.getChildNodes();
                    int colNodeListLength = colNodeList.getLength();
                    int j = 1;
                    while (j < colNodeListLength) {
                        String tagName = null;
                        String tagValue = null;
                        Node colNode = colNodeList.item(j);
                        tagName = colNode.getNodeName().trim();
                        if (colNode.getFirstChild() != null) {
                            tagValue = colNode.getFirstChild().getNodeValue().trim();
                        }
                        if (tagName.equals("name") && tagValue.equals(nameSearch)) {
                            returnNode = colDetailList.item(i);
                            break block6;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception :DWObject :getCol_OtherInfo :==>" + e.getMessage());
                throw new ITMException(e);
            }
        }
        return returnNode;
    }

    private void setArgumentNames() throws ITMException {
        try {
            this.argNamesList = new ArrayList();
            int size = this.dom.getElementsByTagName("argument").getLength();
            int k = 0;
            while (k < size) {
                String argFieldName = null;
                String argName = null;
                String argDataType = null;
                String datetype = "";
                NodeList nL = this.dom.getElementsByTagName("argument").item(k).getChildNodes();
                int argChildLength = nL.getLength();
                int i = 0;
                while (i < argChildLength) {
                    if (nL.item(i).getFirstChild() != null) {
                        if (nL.item(i).getNodeName().equals("field_name")) {
                            argFieldName = nL.item(i).getFirstChild().getNodeValue();
                        }
                        if (nL.item(i).getNodeName().equals("name")) {
                            argName = nL.item(i).getFirstChild().getNodeValue();
                            int nok = 0;
                            while (nok < this.columnsList.size()) {
                                Column col = (Column)this.columnsList.get(nok);
                                if (col.getDisplayName() != null && col.getLogicalName().equals(argName)) {
                                    datetype = ((Column)this.columnsList.get(nok)).getColType();
                                }
                                col = null;
                                ++nok;
                            }
                        }
                        if (nL.item(i).getNodeName().equals("type")) {
                            String type = nL.item(i).getFirstChild().getNodeValue();
                            if (datetype.length() > 0) {
                                argDataType = datetype;
                                datetype = "";
                            } else {
                                argDataType = type.equals("datetime") || type.equals("date") ? "date" : type;
                            }
                        }
                    }
                    ++i;
                }
                argFieldName = argFieldName != null && argFieldName.length() > 0 ? argFieldName : argName;
                this.argNamesList.add(String.valueOf(argFieldName) + "~" + argName + "~" + argDataType);
                ++k;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :DWObject :setArgumentName_Type :==>" + e.getMessage());
            throw new ITMException(e);
        }
    }

    private void setTableToBeUpdated() throws ITMException {
        try {
            NodeList nL = this.dom.getElementsByTagName("TableDefinition").item(0).getChildNodes();
            int size = nL.getLength();
            int i = 0;
            while (i < size) {
                if (nL.item(i).getFirstChild() != null && nL.item(i).getNodeName().equals("update")) {
                    this.tableToBeUpdated = nL.item(i).getFirstChild().getNodeValue();
                    break;
                }
                ++i;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :DWObject :setTableToBeUpdated :==>" + e.getMessage());
            throw new ITMException(e);
        }
    }

    private synchronized ArrayList createColumns() throws ITMException {
        try {
            E12GenericUtility genericUtility = new E12GenericUtility();
            BaseLogger.log("3", null, null, "In createColumns() filename:[" + this.filename + "]");
            this.columnsList = new ArrayList();
            Node Col_OtherInfoNode = null;
            Node Col_OtherTextInfo = null;
            String tagName = null;
            String tagValue = null;
            String database = null;
            String datetype = null;
            Document localDom = this.dom;
            Node databaseNode = localDom.getElementsByTagName("database").item(0);
            if (databaseNode != null && databaseNode.getFirstChild() != null) {
                database = databaseNode.getFirstChild().getNodeValue();
            }
            if (database == null) {
                database = CommonConstants.DB_NAME;
            }
            this.setDatabase(database);
            this.setTableToBeUpdated();
            NodeList columnsNodeList = localDom.getElementsByTagName("table_column");
            int tableColLength = columnsNodeList.getLength();
            int i = 0;
            while (i < tableColLength) {
                NodeList columnNodeList = columnsNodeList.item(i).getChildNodes();
                Column colObj = new Column();
                int tableColChildLength = columnNodeList.getLength();
                int j = 1;
                while (j < tableColChildLength) {
                    tagName = null;
                    tagValue = null;
                    Node colNode = columnNodeList.item(j);
                    tagName = colNode.getNodeName();
                    if (tagName != null) {
                        tagValue = colNode.getFirstChild().getNodeValue().trim();
                    }
                    colObj.setColID(i + 1);
                    if (tagName.equals("type")) {
                        datetype = tagValue;
                        colObj.setColType(tagValue);
                        String size = "0";
                        if (columnNodeList.item(j).getAttributes().getNamedItem("size") != null) {
                            size = columnNodeList.item(j).getAttributes().getNamedItem("size").getNodeValue();
                        }
                        colObj.setSize(Integer.parseInt(size));
                        int precision = 0;
                        if (columnNodeList.item(j).getAttributes().getNamedItem("precision") != null) {
                            precision = Integer.parseInt(columnNodeList.item(j).getAttributes().getNamedItem("precision").getNodeValue());
                        }
                        colObj.setFieldPresicion(precision);
                    } else if (tagName.equals("values")) {
                        String valuesDomStr = genericUtility.serializeDom(colNode);
                        Document valuesDom = genericUtility.parseString(valuesDomStr);
                        NodeList itemNodeList = valuesDom.getElementsByTagName("item");
                        int itmNodeLength = itemNodeList.getLength();
                        HashMap<String, String> dropDownFieldMap = new HashMap<String, String>();
                        int itemCtr = 0;
                        while (itemCtr < itmNodeLength) {
                            Node itemNode = itemNodeList.item(itemCtr);
                            String display = itemNode.getAttributes().getNamedItem("display").getNodeValue();
                            String data = itemNode.getAttributes().getNamedItem("data").getNodeValue();
                            dropDownFieldMap.put(data, display);
                            ++itemCtr;
                        }
                        colObj.setDropDownFieldMap(dropDownFieldMap);
                    } else if (tagName.equals("dbname")) {
                        colObj.setPhysicalName(tagValue);
                    } else if (tagName.equals("updatewhereclause")) {
                        colObj.setUpdateWhereClause(tagValue.equals("yes"));
                    } else if (tagName.equals("update")) {
                        colObj.setUpdate(tagValue);
                    } else if (tagName.equals("key")) {
                        colObj.setKey(tagValue.equals("yes"));
                    } else if (tagName.equals("name")) {
                        colObj.setLogicalName(tagValue);
                        Col_OtherTextInfo = this.getCol_OtherTextInfo(localDom, tagValue.trim());
                        if (Col_OtherTextInfo != null) {
                            NodeList textNodeInfo = Col_OtherTextInfo.getChildNodes();
                            int textNodeInfoLen = textNodeInfo.getLength();
                            int m = 1;
                            while (m < textNodeInfoLen) {
                                Node colNode2 = textNodeInfo.item(m);
                                if (colNode2.getNodeName().equals("text") && colNode2.getFirstChild() != null) {
                                    colObj.setDisplayName(colNode2.getFirstChild().getNodeValue());
                                }
                                m += 2;
                            }
                        }
                        if ((Col_OtherInfoNode = this.getCol_OtherInfo(localDom, tagValue.trim())) != null) {
                            NodeList otherNodeinfo = Col_OtherInfoNode.getChildNodes();
                            int height = 0;
                            int width = 0;
                            int otherInfoLen = otherNodeinfo.getLength();
                            int l = 1;
                            while (l < otherInfoLen) {
                                Node colNode2 = otherNodeinfo.item(l);
                                if (colNode2.getNodeName().equals("band") && colNode2.getFirstChild() != null) {
                                    colObj.setBand(colNode2.getFirstChild().getNodeValue());
                                } else if (colNode2.getNodeName().equals("format") && colNode2.getFirstChild() != null) {
                                    colObj.setFormat(colNode2.getFirstChild().getNodeValue());
                                } else if (colNode2.getNodeName().equals("alignment") && colNode2.getFirstChild() != null) {
                                    colObj.setAlignment(Integer.parseInt(colNode2.getFirstChild().getNodeValue()));
                                } else if (colNode2.getNodeName().equals("tabsequence") && colNode2.getFirstChild() != null) {
                                    colObj.setTabSequence(Integer.parseInt(colNode2.getFirstChild().getNodeValue()));
                                } else if (colNode2.getNodeName().equals("EditStyle") && colNode2.getFirstChild() != null) {
                                    NodeList editStyle_Nodeinfo = colNode2.getChildNodes();
                                    boolean maskPersent = false;
                                    int editStyle_NodeLen = editStyle_Nodeinfo.getLength();
                                    int k = 0;
                                    while (k < editStyle_NodeLen) {
                                        Node colMaskNode = editStyle_Nodeinfo.item(k);
                                        if (colMaskNode.getNodeName().equals("case") && colMaskNode.getFirstChild() != null) {
                                            String fieldCaseVal = colMaskNode.getFirstChild().getNodeValue();
                                            colObj.setFieldCase(fieldCaseVal);
                                        } else if (colMaskNode.getNodeName().equals("mask") && colMaskNode.getFirstChild() != null) {
                                            maskPersent = true;
                                            if ("datetime".equalsIgnoreCase(datetype) || "date".equalsIgnoreCase(datetype) || "timestamp".equalsIgnoreCase(datetype)) {
                                                if (colMaskNode.getFirstChild().getNodeValue().toLowerCase().startsWith("hh:mm:ss")) {
                                                    colObj.setColType("time");
                                                } else if (colMaskNode.getFirstChild().getNodeValue().toLowerCase().indexOf("hh:mm") != -1) {
                                                    colObj.setColType("datetime");
                                                } else {
                                                    colObj.setColType("date");
                                                }
                                            }
                                        } else if (!maskPersent && "datetime".equalsIgnoreCase(datetype) || "date".equalsIgnoreCase(datetype)) {
                                            colObj.setColType("date");
                                        }
                                        ++k;
                                    }
                                } else if (colNode2.getNodeName().equals("color") && colNode2.getFirstChild() != null) {
                                    colObj.setColor(Integer.parseInt(colNode2.getFirstChild().getNodeValue()));
                                } else if (colNode2.getNodeName().equals("x") && colNode2.getFirstChild() != null) {
                                    colObj.setX(Integer.parseInt(colNode2.getFirstChild().getNodeValue()));
                                } else if (colNode2.getNodeName().equals("y") && colNode2.getFirstChild() != null) {
                                    colObj.setY(Integer.parseInt(colNode2.getFirstChild().getNodeValue()));
                                } else if (colNode2.getNodeName().equals("height") && colNode2.getFirstChild() != null) {
                                    height = Integer.parseInt(colNode2.getFirstChild().getNodeValue());
                                } else if (colNode2.getNodeName().equals("width") && colNode2.getFirstChild() != null) {
                                    width = Integer.parseInt(colNode2.getFirstChild().getNodeValue());
                                } else if (colNode2.getNodeName().equals("visible") && colNode2.getFirstChild() != null) {
                                    colObj.setVisible(Integer.parseInt(colNode2.getFirstChild().getNodeValue()));
                                }
                                l += 2;
                            }
                        }
                    }
                    j += 2;
                }
                this.columnsList.add(colObj);
                colObj = null;
                ++i;
            }
            BaseLogger.log("3", null, null, " ..... Column List  created ");
            BaseLogger.log("3", null, null, "In createColumns() columnList size::[" + this.columnsList.size() + "]");
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :DWObject :createColumns :==>" + e.getMessage());
            throw new ITMException(e);
        }
        return this.columnsList;
    }

    public String getDatabase() {
        return this.database;
    }

    private void setDatabase(String database) {
        this.database = database;
    }

    private void createPhysicalNameDisplayNameMap() throws ITMException {
        try {
            this.physicalNameDisplayNameMap = new LinkedHashMap();
            String displayName = null;
            String physicalName = null;
            String logicalName = null;
            int i = 0;
            while (i < this.columnsList.size()) {
                physicalName = ((Column)this.columnsList.get(i)).getPhysicalName();
                logicalName = ((Column)this.columnsList.get(i)).getLogicalName();
                displayName = ((Column)this.columnsList.get(i)).getDisplayName();
                if (displayName == null) {
                    displayName = ((Column)this.columnsList.get(i)).getLogicalName();
                }
                this.physicalNameDisplayNameMap.put(logicalName, displayName);
                ++i;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :DWObject :createPhysicalNameDisplayNameMap :==>" + e.getMessage());
            throw new ITMException(e);
        }
    }

    private void createPhysicalNameLogicalNameMap() throws ITMException {
        try {
            this.physicalNameLogicalNameMap = new HashMap();
            int i = 0;
            while (i < this.columnsList.size()) {
                this.physicalNameLogicalNameMap.put(((Column)this.columnsList.get(i)).getLogicalName(), ((Column)this.columnsList.get(i)).getPhysicalName());
                ++i;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :DWObject :createPhysicalNameLogicalNameMap :==>" + e.getMessage());
            throw new ITMException(e);
        }
    }

    private void createNoUpdateBandLinkList() throws ITMException {
        try {
            this.noUpdateBandLinkList = new LinkedList();
            if (this.columnsList != null) {
                int i = 0;
                while (i < this.columnsList.size()) {
                    if (((Column)this.columnsList.get(i)).getBand() == null && ((Column)this.columnsList.get(i)).getUpdate() == null) {
                        this.noUpdateBandLinkList.add(((Column)this.columnsList.get(i)).getLogicalName());
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :DWObject :createNoUpdateBandLinkList :==>" + e.getMessage());
            throw new ITMException(e);
        }
    }

    private void createColIDLogNameMap() throws ITMException {
        try {
            this.colIDLogNameMap = new HashMap();
            int i = 0;
            while (i < this.columnsList.size()) {
                this.colIDLogNameMap.put(new Integer(((Column)this.columnsList.get(i)).getColID()), ((Column)this.columnsList.get(i)).getLogicalName());
                ++i;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :DWObject :createColIDLogNameMap :==>" + e.getMessage());
            throw new ITMException(e);
        }
    }

    private void createColLogNameTypeMap() throws ITMException {
        try {
            this.colLogNameTypeMap = new HashMap();
            int i = 0;
            while (i < this.columnsList.size()) {
                this.colLogNameTypeMap.put(((Column)this.columnsList.get(i)).getLogicalName(), ((Column)this.columnsList.get(i)).getColType());
                ++i;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :DWObject :createColLogNameTypeMap :==>" + e.getMessage());
            throw new ITMException(e);
        }
    }

    private void createColLogNameSizeMap() throws ITMException {
        try {
            this.colLogNameSizeMap = new HashMap();
            int i = 0;
            while (i < this.columnsList.size()) {
                this.colLogNameSizeMap.put(((Column)this.columnsList.get(i)).getLogicalName(), new Integer(((Column)this.columnsList.get(i)).getSize()));
                ++i;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :DWObject :createColLogNameSizeMap :==>" + e.getMessage());
            throw new ITMException(e);
        }
    }

    private void createKeyList() throws ITMException {
        try {
            this.keyList = new ArrayList();
            int i = 0;
            while (i < this.columnsList.size()) {
                if (((Column)this.columnsList.get(i)).isKey()) {
                    this.keyList.add(new Integer(((Column)this.columnsList.get(i)).getColID()));
                }
                ++i;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :DWObject :createKeyList :==>" + e.getMessage());
            throw new ITMException(e);
        }
    }

    private void createLogicalNameList() throws ITMException {
        try {
            this.logicalNameList = new ArrayList();
            int i = 0;
            while (i < this.columnsList.size()) {
                this.logicalNameList.add(((Column)this.columnsList.get(i)).getLogicalName());
                ++i;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :DWObject :createLogicalNameList :==>" + e.getMessage());
            throw new ITMException(e);
        }
    }

    private void createPrimaryKeyPhyNameList() throws ITMException {
        try {
            this.primaryKeyPhyNameList = new ArrayList();
            int i = 0;
            while (i < this.columnsList.size()) {
                if (((Column)this.columnsList.get(i)).isKey()) {
                    this.primaryKeyPhyNameList.add(((Column)this.columnsList.get(i)).getPhysicalName());
                }
                ++i;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :DWObject :createPrimaryKeyPhyNameList :==>" + e.getMessage());
            throw new ITMException(e);
        }
    }

    private synchronized void createPrimaryKeyLogNameList() throws ITMException {
        try {
            this.primaryKeyLogNameList = new ArrayList();
            this.primaryKeyDataTypeList = new ArrayList();
            if (this.columnsList == null) {
                this.createColumns();
            }
            int i = 0;
            while (i < this.columnsList.size()) {
                if (((Column)this.columnsList.get(i)).isKey()) {
                    this.primaryKeyLogNameList.add(((Column)this.columnsList.get(i)).getLogicalName());
                    this.primaryKeyDataTypeList.add(((Column)this.columnsList.get(i)).getColType());
                }
                ++i;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :DWObject :createPrimaryKeyLogNameList :==>" + e.getMessage());
            throw new ITMException(e);
        }
    }

    private void createUpdateableLogPhyColNames() throws ITMException {
        try {
            this.updateableLogPhyColNames = new Hashtable();
            int i = 0;
            while (i < this.columnsList.size()) {
                if (((Column)this.columnsList.get(i)).getUpdate() != null && ((Column)this.columnsList.get(i)).getUpdate().equals("yes")) {
                    this.updateableLogPhyColNames.put(((Column)this.columnsList.get(i)).getLogicalName(), ((Column)this.columnsList.get(i)).getPhysicalName());
                }
                ++i;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :DWObject :createUpdateableLogPhyColNames :==>" + e.getMessage());
            throw new ITMException(e);
        }
    }

    private void createNonEditableLogPhyColNames() throws ITMException {
        try {
            this.nonEditableLogPhyColNames = new Hashtable();
            int i = 0;
            while (i < this.columnsList.size()) {
                if (((Column)this.columnsList.get(i)).getUpdate() != null && ((Column)this.columnsList.get(i)).getUpdate().equals("yes") && ((Column)this.columnsList.get(i)).isKey() || ((Column)this.columnsList.get(i)).getTabSequence() != 32766) {
                    this.nonEditableLogPhyColNames.put(((Column)this.columnsList.get(i)).getLogicalName(), ((Column)this.columnsList.get(i)).getPhysicalName());
                }
                ++i;
            }
            BaseLogger.log("3", null, null, "nonEditableLogPhyColNames === [" + this.nonEditableLogPhyColNames + "]");
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :DWObject :createUpdateableLogPhyColNames :==>" + e.getMessage());
            throw new ITMException(e);
        }
    }

    private void createUpdateableLogNameColType() throws ITMException {
        try {
            this.updateableLogNameColType = new Hashtable();
            int i = 0;
            while (i < this.columnsList.size()) {
                if (((Column)this.columnsList.get(i)).getUpdate() != null && ((Column)this.columnsList.get(i)).getUpdate().equals("yes")) {
                    this.updateableLogNameColType.put(((Column)this.columnsList.get(i)).getLogicalName(), ((Column)this.columnsList.get(i)).getColType());
                }
                ++i;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :DWObject :createUpdateableLogNameColType :==>" + e.getMessage());
            throw new ITMException(e);
        }
    }

    public Hashtable getUpdateableLogPhyColNames() throws ITMException {
        try {
            if (this.updateableLogPhyColNames == null) {
                this.createUpdateableLogPhyColNames();
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :DWObject :getUpdateableLogPhyColNames :==>" + e.getMessage());
            throw new ITMException(e);
        }
        return this.updateableLogPhyColNames;
    }

    public Hashtable getNonEditableLogPhyColNames() throws ITMException {
        try {
            if (this.nonEditableLogPhyColNames == null) {
                this.createNonEditableLogPhyColNames();
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :DWObject :getNonEditableLogPhyColNames :==>" + e.getMessage());
            throw new ITMException(e);
        }
        return this.nonEditableLogPhyColNames;
    }

    public LinkedList getNoUpdateBandLinkList() throws ITMException {
        try {
            if (this.noUpdateBandLinkList == null) {
                this.createNoUpdateBandLinkList();
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :DWObject :getNoUpdateBandLinkList :==>" + e.getMessage());
            throw new ITMException(e);
        }
        return this.noUpdateBandLinkList;
    }

    public Hashtable getUpdateableLogNameColType() throws ITMException {
        try {
            if (this.updateableLogNameColType == null) {
                this.createUpdateableLogNameColType();
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :DWObject :getUpdateableLogNameColType :==>" + e.getMessage());
            throw new ITMException(e);
        }
        return this.updateableLogNameColType;
    }

    public synchronized ArrayList getColumnsList() throws ITMException {
        try {
            if (this.columnsList == null) {
                BaseLogger.log("3", null, null, "Create new columnList");
                this.columnsList = this.createColumns();
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :DWObject :getColumnsList :==>" + e.getMessage());
            throw new ITMException(e);
        }
        return this.columnsList;
    }

    public ArrayList getLogicalNameList() throws ITMException {
        try {
            if (this.logicalNameList == null) {
                this.createLogicalNameList();
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :DWObject :getLogicalNameList :==>" + e.getMessage());
            throw new ITMException(e);
        }
        return this.logicalNameList;
    }

    public String getQueryString(boolean isAlassRequired) throws ITMException {
        try {
            String stg;
            SQLMaker sqlmake = new SQLMaker(this.database, this.userInfo);
            this.queryString = stg = sqlmake.makeSQL(this.filename, isAlassRequired);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception : DWObject : getQueryString :==>" + e.getMessage());
            throw new ITMException(e);
        }
        return this.queryString;
    }

    public String getQueryString() throws ITMException {
        try {
            String stg;
            SQLMaker sqlmake = new SQLMaker(this.database, this.userInfo);
            this.queryString = stg = sqlmake.makeSQL(this.filename, false);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception : DWObject : getQueryString :==>" + e.getMessage());
            throw new ITMException(e);
        }
        return this.queryString;
    }

    public String getTableToBeUpdated() {
        return this.tableToBeUpdated;
    }

    public ArrayList getArgNamesList() {
        return this.argNamesList;
    }

    public HashMap getPhysicalNameDisplayNameMap() throws ITMException {
        try {
            if (this.physicalNameDisplayNameMap == null) {
                this.createPhysicalNameDisplayNameMap();
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :DWObject :getPhysicalNameDisplayNameMap :==>" + e.getMessage());
            throw new ITMException(e);
        }
        return this.physicalNameDisplayNameMap;
    }

    public HashMap getPhysicalNameLogicalNameMap() throws ITMException {
        try {
            if (this.physicalNameLogicalNameMap == null) {
                this.createPhysicalNameLogicalNameMap();
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :DWObject :getPhysicalNameLogicalNameMap :==>" + e.getMessage());
            throw new ITMException(e);
        }
        return this.physicalNameLogicalNameMap;
    }

    public HashMap getColIDLogNameMap() throws ITMException {
        try {
            if (this.colIDLogNameMap == null) {
                this.createColIDLogNameMap();
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :DWObject :getColIDLogNameMap :==>" + e.getMessage());
            throw new ITMException(e);
        }
        return this.colIDLogNameMap;
    }

    public HashMap getColLogNameTypeMap() throws ITMException {
        try {
            if (this.colLogNameTypeMap == null) {
                this.createColLogNameTypeMap();
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :DWObject :getColLogNameTypeMap :==>" + e.getMessage());
            throw new ITMException(e);
        }
        return this.colLogNameTypeMap;
    }

    public HashMap getColLogNameSizeMap() throws ITMException {
        try {
            if (this.colLogNameSizeMap == null) {
                this.createColLogNameSizeMap();
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :DWObject :getColLogNameSizeMap :==>" + e.getMessage());
            throw new ITMException(e);
        }
        return this.colLogNameSizeMap;
    }

    public ArrayList getKeyList() throws ITMException {
        try {
            if (this.keyList == null) {
                this.createKeyList();
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :DWObject :getKeyList :==>" + e.getMessage());
            throw new ITMException(e);
        }
        return this.keyList;
    }

    public ArrayList getPrimaryKeyPhyNameList() throws ITMException {
        try {
            if (this.primaryKeyPhyNameList == null) {
                this.createPrimaryKeyPhyNameList();
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :DWObject :getPrimaryKeyLogNameList :==>" + e.getMessage());
            throw new ITMException(e);
        }
        return this.primaryKeyPhyNameList;
    }

    public ArrayList getPrimaryKeyLogNameList() throws ITMException {
        try {
            if (this.primaryKeyLogNameList == null) {
                this.createPrimaryKeyLogNameList();
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :DWObject :getPrimaryKeyLogNameList :==>" + e.getMessage());
            throw new ITMException(e);
        }
        return this.primaryKeyLogNameList;
    }

    public ArrayList getPrimaryKeyDataTypeList() throws ITMException {
        try {
            if (this.primaryKeyDataTypeList == null) {
                this.createPrimaryKeyLogNameList();
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :DWObject :getPrimaryKeyDataTypeList :==>" + e.getMessage());
            throw new ITMException(e);
        }
        return this.primaryKeyDataTypeList;
    }

    public String getObjContext() {
        return this.objContext;
    }

    public void setObjContext(String objContext) {
        this.objContext = objContext;
    }

    public HashMap getColDataTypeMap() throws ITMException {
        if (this.colDataTypeNameMap == null) {
            try {
                this.setColDataTypeNameMap();
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception : MetaDataObject : getColDataTypeMap :==>" + e.getMessage());
                throw new ITMException(e);
            }
        }
        return this.colDataTypeNameMap;
    }

    private void setColDataTypeNameMap() throws ITMException {
        try {
            this.colDataTypeNameMap = new HashMap();
            if (this.columnsList != null) {
                int i = 0;
                while (i < this.columnsList.size()) {
                    this.colDataTypeNameMap.put(((Column)this.columnsList.get(i)).getLogicalName(), ((Column)this.columnsList.get(i)).getColType());
                    ++i;
                }
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception : MetaDataObject :setColDataTypeNameMap :==>" + e.getMessage());
            throw new ITMException(e);
        }
    }

    public void remove() {
        if (this.columnsList != null) {
            this.columnsList.clear();
            this.columnsList = null;
        }
    }

    public ArrayList getTableList() throws ITMException {
        try {
            SQLMaker sqlmake = new SQLMaker(this.database, this.userInfo);
            this.tableList = sqlmake.getTableList(this.filename);
        }
        catch (Exception e) {
            this.tableList = new ArrayList();
            BaseLogger.log("0", null, null, "Exception : DWObject : getQueryString :==>" + e.getMessage());
            throw new ITMException(e);
        }
        BaseLogger.log("2", null, null, "MetadataObject tableList[" + this.tableList + "]");
        return this.tableList;
    }

    public HashMap<String, String> getComputeColumns() throws ITMException {
        HashMap<String, String> computeColumnNamesMap = new HashMap();
        try {
            SQLMaker sqlmake = new SQLMaker(this.database, this.userInfo);
            computeColumnNamesMap = sqlmake.getComputeColumns(this.filename);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception : DWObject : getQueryString :==>" + e.getMessage());
            throw new ITMException(e);
        }
        BaseLogger.log("2", null, null, "MetadataObject computeColumnNamesMap[" + computeColumnNamesMap + "]");
        return computeColumnNamesMap;
    }

    public HashMap<String, String> getTabOrderWiseLogicalNameMap() throws ITMException {
        if (this.tabOrderWiseLogicalNameMap == null) {
            this.createTabOrderWiseLogicalNameMap();
        }
        return this.tabOrderWiseLogicalNameMap;
    }

    public HashMap<String, String> geteditableLogicalNameMap() throws ITMException {
        if (this.editableLogicalNameMap == null) {
            this.creatEditableOrderLogicalNameMap();
        }
        return this.editableLogicalNameMap;
    }

    public void createTabOrderWiseLogicalNameMap() throws ITMException {
        try {
            ArrayList columnList = new ArrayList();
            if (this.columnsList != null) {
                columnList = this.columnsList;
            }
            Collections.sort(columnList, new TabSequenceComparator());
            this.tabOrderWiseLogicalNameMap = new LinkedHashMap<String, String>();
            LinkedHashMap<String, String> protectedPKFldMap = new LinkedHashMap<String, String>();
            LinkedHashMap<String, String> remainingFldMap = new LinkedHashMap<String, String>();
            String displayName = null;
            String logicalName = null;
            int colNo = 0;
            while (colNo < columnList.size()) {
                int tabSeq = ((Column)columnList.get(colNo)).getTabSequence();
                logicalName = ((Column)columnList.get(colNo)).getLogicalName();
                displayName = ((Column)columnList.get(colNo)).getDisplayName();
                if (displayName == null) {
                    displayName = logicalName;
                }
                if (tabSeq == 32766 && ((Column)columnList.get(colNo)).isKey()) {
                    protectedPKFldMap.put(logicalName, displayName);
                } else {
                    remainingFldMap.put(logicalName, displayName);
                }
                ++colNo;
            }
            this.tabOrderWiseLogicalNameMap.putAll(protectedPKFldMap);
            this.tabOrderWiseLogicalNameMap.putAll(remainingFldMap);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :: DWObject : createTabOrderWiseLogicalNameMap : [" + e.getMessage() + "]");
            throw new ITMException(e);
        }
    }

    public void creatEditableOrderLogicalNameMap() throws ITMException {
        try {
            BaseLogger.log("3", null, null, "inside creatEditableOrderWiseLogicalNameMap start");
            ArrayList columnList = new ArrayList();
            if (this.columnsList != null) {
                columnList = this.columnsList;
            }
            Collections.sort(columnList, new TabSequenceComparator());
            this.editableLogicalNameMap = new LinkedHashMap<String, String>();
            LinkedHashMap protectedPKFldMap = new LinkedHashMap();
            LinkedHashMap<String, String> remainingFldMap = new LinkedHashMap<String, String>();
            String displayName = null;
            String logicalName = null;
            int colNo = 0;
            while (colNo < columnList.size()) {
                int tabSeq = ((Column)columnList.get(colNo)).getTabSequence();
                logicalName = ((Column)columnList.get(colNo)).getLogicalName();
                displayName = ((Column)columnList.get(colNo)).getDisplayName();
                if (displayName == null) {
                    displayName = logicalName;
                }
                if (tabSeq != 32766) {
                    BaseLogger.log("3", null, null, "inside create tab orderwise logical map... 1302..logicalName[" + logicalName + "]displayName[" + displayName + "]");
                    remainingFldMap.put(logicalName, displayName);
                }
                ++colNo;
            }
            this.editableLogicalNameMap.putAll(protectedPKFldMap);
            this.editableLogicalNameMap.putAll(remainingFldMap);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :: DWObject : createTabOrderWiseLogicalNameMap : [" + e.getMessage() + "]");
            throw new ITMException(e);
        }
        BaseLogger.log("2", null, null, "inside creatEditableOrderWiseLogicalNameMap end");
    }

    public HashMap getDropDownColValueMap() throws ITMException {
        try {
            if (this.dropDownColValueMap == null) {
                this.createDropDownColValueMap();
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :DWObject :createColValueItemDropDownMap :==>" + e.getMessage());
            throw new ITMException(e);
        }
        return this.dropDownColValueMap;
    }

    private void createDropDownColValueMap() throws ITMException {
        try {
            this.dropDownColValueMap = new HashMap();
            int i = 0;
            while (i < this.columnsList.size()) {
                this.dropDownColValueMap.put(((Column)this.columnsList.get(i)).getLogicalName(), ((Column)this.columnsList.get(i)).getDropDownFieldMap());
                ++i;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :DWObject :createColValueItemDropDownMap :==>" + e.getMessage());
            throw new ITMException(e);
        }
    }

    public HashMap getFieldCaseValueMap() throws ITMException {
        try {
            if (this.fieldCaseValMap == null) {
                this.createFieldCaseValueMap();
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :DWObject :getfieldCaseValueMap : [" + e.getMessage());
            throw new ITMException(e);
        }
        return this.fieldCaseValMap;
    }

    private void createFieldCaseValueMap() throws ITMException {
        try {
            this.fieldCaseValMap = new HashMap();
            int i = 0;
            while (i < this.columnsList.size()) {
                this.fieldCaseValMap.put(((Column)this.columnsList.get(i)).getLogicalName(), ((Column)this.columnsList.get(i)).getFieldCase());
                ++i;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :DWObject :createFieldCaseValueMap :[" + e.getMessage());
            throw new ITMException(e);
        }
    }

    public HashMap getFieldPrecisionValueMap() throws ITMException {
        try {
            if (this.fieldPrecisionValMap == null) {
                this.createFieldPrecisionValueMap();
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :DWObject :getFielPrecisionValueMap : [" + e.getMessage());
            throw new ITMException(e);
        }
        return this.fieldPrecisionValMap;
    }

    private void createFieldPrecisionValueMap() throws ITMException {
        try {
            this.fieldPrecisionValMap = new HashMap();
            int i = 0;
            while (i < this.columnsList.size()) {
                this.fieldPrecisionValMap.put(((Column)this.columnsList.get(i)).getLogicalName(), ((Column)this.columnsList.get(i)).setFieldPresicion());
                ++i;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :DWObject :createFieldPrecisionValueMap :[" + e.getMessage() + "]");
            throw new ITMException(e);
        }
    }

    public HashMap getVisibleFieldsValueMap() throws ITMException {
        try {
            if (this.visibleFieldsValueMap == null) {
                this.createVisibleFieldsValueMap();
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :DWObject :getFielPrecisionValueMap : [" + e.getMessage());
            throw new ITMException(e);
        }
        return this.visibleFieldsValueMap;
    }

    private void createVisibleFieldsValueMap() throws ITMException {
        try {
            this.visibleFieldsValueMap = new HashMap();
            try {
                String displayName = null;
                String physicalName = null;
                String logicalName = null;
                int visibile = 1;
                int i = 0;
                while (i < this.columnsList.size()) {
                    physicalName = ((Column)this.columnsList.get(i)).getPhysicalName();
                    logicalName = ((Column)this.columnsList.get(i)).getLogicalName();
                    displayName = ((Column)this.columnsList.get(i)).getDisplayName();
                    visibile = ((Column)this.columnsList.get(i)).getVisible();
                    BaseLogger.log("3", null, null, "visibile>>" + visibile);
                    if (displayName == null) {
                        displayName = ((Column)this.columnsList.get(i)).getLogicalName();
                    }
                    if (visibile == 1) {
                        this.visibleFieldsValueMap.put(logicalName, displayName);
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception :DWObject :createPhysicalNameDisplayNameMap :==>" + e.getMessage());
                throw new ITMException(e);
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :DWObject :createFieldPrecisionValueMap :[" + e.getMessage() + "]");
            throw new ITMException(e);
        }
    }

    public HashMap<String, String> getNonEditableLogPhyColMap() throws ITMException {
        try {
            if (this.nonEditableLogPhyColMap == null) {
                this.createNonEditableLogPhyColMap();
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :DWObject :getNonEditableLogPhyColMap :==>" + e.getMessage());
            throw new ITMException(e);
        }
        return this.nonEditableLogPhyColMap;
    }

    private void createNonEditableLogPhyColMap() throws ITMException {
        try {
            this.nonEditableLogPhyColMap = new HashMap();
            int columnCtr = 0;
            while (columnCtr < this.columnsList.size()) {
                if (((Column)this.columnsList.get(columnCtr)).getTabSequence() == 32766 && (((Column)this.columnsList.get(columnCtr)).isKey() || ((Column)this.columnsList.get(columnCtr)).getUpdate() != null && ((Column)this.columnsList.get(columnCtr)).getUpdate().equals("yes"))) {
                    this.nonEditableLogPhyColMap.put(((Column)this.columnsList.get(columnCtr)).getLogicalName(), ((Column)this.columnsList.get(columnCtr)).getPhysicalName());
                }
                ++columnCtr;
            }
            BaseLogger.log("3", null, null, "nonEditableLogPhyColMap === [" + this.nonEditableLogPhyColMap + "]");
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :DWObject :createNonEditableLogPhyColMap :==>" + e.getMessage());
            throw new ITMException(e);
        }
    }

    public HashMap getColumnAlignmentMap() throws ITMException {
        BaseLogger.log("3", null, null, "In getColumnAlignmentMap1669>>");
        try {
            if (this.columnAlignmentMap == null) {
                this.createColumnAlignmentMap();
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :DWObject :createColumnAlignmentMap : [" + e.getMessage());
            throw new ITMException(e);
        }
        return this.columnAlignmentMap;
    }

    private void createColumnAlignmentMap() throws ITMException {
        try {
            this.columnAlignmentMap = new HashMap();
            try {
                int columnAlignment = 1;
                String logicalName = null;
                boolean visibile = true;
                int i = 0;
                while (i < this.columnsList.size()) {
                    columnAlignment = ((Column)this.columnsList.get(i)).getAlignment();
                    logicalName = ((Column)this.columnsList.get(i)).getLogicalName();
                    this.columnAlignmentMap.put(logicalName, columnAlignment);
                    ++i;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception :DWObject :createColumnAlignmentMap :==>" + e.getMessage());
                throw new ITMException(e);
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :DWObject :createColumnAlignmentMap :[" + e.getMessage() + "]");
            throw new ITMException(e);
        }
    }
}

