/*
 * Decompiled with CFR 0.152.
 */
package ibase.utility;

import ibase.utility.BaseException;
import ibase.utility.BaseLogger;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;

public class ApplicationParams
implements Cloneable,
Serializable {
    int paramCount = -1;
    String applnName = null;
    String compName = null;
    String applnType = null;
    String methodName = null;
    ArrayList applnTypeList = null;
    ArrayList paramDataTypeList = null;
    ArrayList paramModeList = null;
    ArrayList paramList = null;
    String schedulable = null;
    String inputEditor = null;
    String lookupName = null;
    String activityType = null;
    HashMap extendedAttribMap = null;
    String applnId = "";

    public ApplicationParams() {
        this.applnTypeList = new ArrayList();
        this.applnTypeList.add("EJB");
        this.applnTypeList.add("JB");
        this.applnTypeList.add("NVO");
        this.paramDataTypeList = new ArrayList();
        this.paramDataTypeList.add("STRING");
        this.paramDataTypeList.add("CHAR");
        this.paramDataTypeList.add("VARCHAR");
        this.paramDataTypeList.add("VARCHAR2");
        this.paramDataTypeList.add("NUMBER");
        this.paramDataTypeList.add("INTEGER");
        this.paramDataTypeList.add("LONG");
        this.paramDataTypeList.add("DECIMAL");
        this.paramDataTypeList.add("DOUBLE");
        this.paramDataTypeList.add("FLOAT");
        this.paramDataTypeList.add("DATE");
        this.paramDataTypeList.add("DATETIME");
        this.paramDataTypeList.add("TIMESTAMP");
        this.paramDataTypeList.add("XML");
        this.paramModeList = new ArrayList();
        this.paramModeList.add("IN");
        this.paramModeList.add("OUT");
        this.paramList = new ArrayList();
        this.extendedAttribMap = new HashMap();
    }

    public ApplicationParams(String applnParamXML) {
    }

    public void setApplnName(String applnName) throws BaseException {
        try {
            if (applnName == null) {
                throw new Exception("Application Name cannot be null");
            }
            if (applnName.length() == 0) {
                throw new Exception("Invalid Application Name :[" + applnName + "]");
            }
            this.applnName = applnName;
            BaseLogger.log("3", null, null, "Inside ApplicationParams::setApplnName()::" + this.applnName);
        }
        catch (BaseException be) {
            throw be;
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
    }

    public String getApplnName() {
        return this.applnName;
    }

    public void setCompName(String compName) throws BaseException {
        try {
            if (compName == null) {
                throw new Exception("Component Name cannot be null");
            }
            if (compName.length() == 0) {
                throw new Exception("Invalid Component Name :[" + compName + "]");
            }
            this.compName = compName;
        }
        catch (BaseException be) {
            throw be;
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
    }

    public String getCompName() {
        return this.compName;
    }

    public void setApplnType(String applnType) throws BaseException {
        try {
            if (applnType == null) {
                throw new Exception("Application Type cannot be null");
            }
            if (!this.applnTypeList.contains(applnType.toUpperCase())) {
                throw new Exception("Unsupported Application Type- Possible Values " + this.applnTypeList);
            }
            this.applnType = applnType.toUpperCase();
        }
        catch (BaseException be) {
            throw be;
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
    }

    public String getApplnType() {
        return this.applnType;
    }

    public void setMethodName(String methodName) throws BaseException {
        try {
            if (methodName == null) {
                throw new Exception("Method Name cannot be null");
            }
            if (methodName.length() == 0) {
                throw new Exception("Method Application Name :[" + methodName + "]");
            }
            this.methodName = methodName;
        }
        catch (BaseException be) {
            throw be;
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setSchedulable(String schedulable) throws BaseException {
        try {
            if (schedulable == null) {
                throw new Exception("schedulable value should be 0 or 1");
            }
            this.schedulable = schedulable;
        }
        catch (BaseException be) {
            throw be;
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
    }

    public void setInputEditor(String inputEditor) throws BaseException {
        try {
            if (inputEditor == null) {
                throw new Exception("Url cannot be null");
            }
            this.inputEditor = inputEditor;
        }
        catch (BaseException be) {
            throw be;
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
    }

    public int addParam(String paramName, String paramDataType, int paramIndex, String paramMode, String paramValue, String paramType) throws BaseException {
        try {
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            if (paramDataType == null) {
                throw new Exception("Param Data Type cannot be null");
            }
            if (!this.paramDataTypeList.contains(paramDataType.toUpperCase())) {
                throw new Exception("Unsupported Data Type- Possible Values " + this.paramDataTypeList);
            }
            if (paramIndex <= 0) {
                throw new Exception("Invalid Param Index");
            }
            if (paramMode == null) {
                throw new Exception("Param Mode cannot be null");
            }
            if (!this.paramModeList.contains(paramMode.toUpperCase())) {
                throw new Exception("Invalid Param Mode- Possible Values " + this.paramModeList);
            }
            paramMap.put("PARAM_NAME", paramName);
            paramMap.put("PARAM_DATA_TYPE", paramDataType.toUpperCase());
            paramMap.put("PARAM_INDEX", new Integer(paramIndex));
            paramMap.put("PARAM_MODE", paramMode.toUpperCase());
            paramMap.put("PARAM_VALUE", paramValue);
            paramMap.put("PARAM_TYPE", paramType);
            this.paramList.add(paramMap);
            ++this.paramCount;
        }
        catch (BaseException be) {
            throw be;
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
        return 1;
    }

    public ArrayList getParamList() {
        return this.paramList;
    }

    private void sortParams() throws BaseException {
        try {
            throw new BaseException(new Exception());
        }
        catch (BaseException be) {
            throw be;
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
    }

    public String isSchedulable() {
        return this.schedulable;
    }

    public String getInputEditor() {
        return this.inputEditor;
    }

    public void setLookupName(String lookupName) throws BaseException {
        try {
            if (lookupName == null) {
                throw new Exception("lookupName cannot be null");
            }
            this.lookupName = lookupName;
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
    }

    public String getLookupName() {
        return this.lookupName;
    }

    public String getActivityType() {
        return this.activityType;
    }

    public void setActivityType(String activityType) throws BaseException {
        try {
            if (activityType == null) {
                throw new Exception("activityType cannot be null");
            }
            this.activityType = activityType;
        }
        catch (BaseException be) {
            throw be;
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
    }

    public void addExtenedParam(String extdName, String value) throws BaseException {
        try {
            if (extdName == null) {
                throw new Exception("extdName cannot be null");
            }
            this.extendedAttribMap.put(extdName, value);
        }
        catch (BaseException be) {
            throw be;
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
    }

    public HashMap getExtendedAttribMap() {
        return this.extendedAttribMap;
    }

    public Object clone() throws CloneNotSupportedException {
        ApplicationParams appParam = (ApplicationParams)super.clone();
        return appParam;
    }

    public String toString() {
        return this.getApplnName();
    }

    public String getApplnId() {
        return this.applnId;
    }

    public void setApplnId(String applnId) {
        this.applnId = applnId;
    }
}

