/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.ejb;

import ibase.ejb.CommonDBAccessEJB;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseException;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.AuditTrailExtLocal;
import ibase.webitm.ejb.AuditTrailExtRemote;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.TransIDGenerator;
import java.io.ByteArrayInputStream;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import javax.ejb.Stateless;
import oracle.sql.BLOB;

@Stateless
public class AuditTrailExtEJB
implements AuditTrailExtRemote,
AuditTrailExtLocal {
    @Override
    public String saveActionPerformedInAudit(String objName, String tranId, String formDispName, String actionPerformed, String loginCode, String chgTerm, String transDB, UserInfoBean userInfo) throws RemoteException, ITMException {
        Statement pStmt = null;
        Connection con = null;
        String auditTranId = "";
        String chgIp = "";
        try {
            try {
                String auditXMLString;
                if (userInfo != null) {
                    chgTerm = userInfo.getMacAddress();
                    chgIp = userInfo.getRemoteAddress();
                }
                ConnDriver connDriver = new ConnDriver();
                String database = connDriver.getDBName();
                con = connDriver.getConnectDB(transDB);
                con.setAutoCommit(false);
                connDriver = null;
                auditTranId = this.getAudiNextSeqId(con);
                CommonDBAccessEJB db = new CommonDBAccessEJB();
                tranId = db.refIDWithTrimForAuditTrail(tranId);
                tranId = tranId.replace(":", ",");
                String auditId = this.getAuditId(objName, tranId, con);
                String insertQuery = "INSERT INTO AUDIT_TRAIL (TRAN_ID, OBJ_NAME, CHG_ID, REF_ID, DATA_XML_BEFORE, CHG_XML, DATA_XML_AFTER, CHG_USER, CHG_DATE, CHG_TERM, ACTION_PRFRM, ACTION_STATUS, CHG_IP) VALUES ( ?, ?, ?, ?, EMPTY_BLOB(), EMPTY_BLOB(), EMPTY_BLOB(), ?, ?, ?, ?, ?, ?)";
                if ("mysql".equalsIgnoreCase(database) || "DB2".equalsIgnoreCase(database) || "MSSQL".equalsIgnoreCase(database) || "PGSQL".equalsIgnoreCase(database)) {
                    byte[] auditXmlBeforeArray = "<Root></Root>".getBytes();
                    ByteArrayInputStream auditBeforeByteArray = auditXmlBeforeArray != null ? new ByteArrayInputStream(auditXmlBeforeArray) : null;
                    auditXMLString = "<Root><Detail1  domID='1' title='" + formDispName + "'><chg_mode>" + actionPerformed + "</chg_mode></Detail1></Root>";
                    byte[] auditXmlArray = auditXMLString.getBytes();
                    ByteArrayInputStream chgXMLStringByteArray = auditXmlArray != null ? new ByteArrayInputStream(auditXmlArray) : null;
                    byte[] auditXmlAfterArray = "<Root></Root>".getBytes();
                    ByteArrayInputStream auditAfterByteArray = auditXmlAfterArray != null ? new ByteArrayInputStream(auditXmlAfterArray) : null;
                    insertQuery = "INSERT INTO AUDIT_TRAIL (TRAN_ID, OBJ_NAME, CHG_ID, REF_ID, DATA_XML_BEFORE, CHG_XML, DATA_XML_AFTER, CHG_USER, CHG_DATE, CHG_TERM, ACTION_PRFRM, ACTION_STATUS, CHG_IP ) VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                    pStmt = con.prepareStatement(insertQuery);
                    pStmt.setString(1, auditTranId);
                    pStmt.setString(2, objName);
                    pStmt.setString(3, auditId);
                    pStmt.setString(4, tranId.trim());
                    if (auditBeforeByteArray != null) {
                        pStmt.setBinaryStream(5, auditBeforeByteArray, auditBeforeByteArray.available());
                    } else {
                        pStmt.setBinaryStream(5, null, 0);
                    }
                    if (chgXMLStringByteArray != null) {
                        pStmt.setBinaryStream(6, chgXMLStringByteArray, chgXMLStringByteArray.available());
                    } else {
                        pStmt.setBinaryStream(6, null, 0);
                    }
                    if (auditAfterByteArray != null) {
                        pStmt.setBinaryStream(7, auditAfterByteArray, auditAfterByteArray.available());
                    } else {
                        pStmt.setBinaryStream(7, null, 0);
                    }
                    pStmt.setString(8, loginCode != null && loginCode.length() > 0 ? loginCode : "SYSTEM");
                    pStmt.setTimestamp(9, new Timestamp(System.currentTimeMillis()));
                    pStmt.setString(10, chgTerm != null && chgTerm.length() > 0 ? chgTerm : "SYSTEM");
                    pStmt.setString(11, actionPerformed);
                    pStmt.setString(12, "Pending");
                    pStmt.setString(13, chgIp);
                } else {
                    pStmt = con.prepareStatement(insertQuery);
                    pStmt.setString(1, auditTranId);
                    pStmt.setString(2, objName);
                    pStmt.setString(3, auditId);
                    pStmt.setString(4, tranId.trim());
                    pStmt.setString(5, loginCode != null && loginCode.length() > 0 ? loginCode : "SYSTEM");
                    pStmt.setTimestamp(6, new Timestamp(System.currentTimeMillis()));
                    pStmt.setString(7, chgTerm != null && chgTerm.length() > 0 ? chgTerm : "SYSTEM");
                    pStmt.setString(8, actionPerformed);
                    pStmt.setString(9, "Pending");
                    pStmt.setString(10, chgIp);
                }
                BaseLogger.log("3", null, null, "Inserting into Audit Trail For objName [" + objName + "] of tranId [" + tranId + "] with AuditId [" + auditId + "] From user [" + loginCode + "]");
                pStmt.executeUpdate();
                pStmt.close();
                pStmt = null;
                ArrayList<String> bindVarValues = new ArrayList<String>();
                bindVarValues.add(auditTranId);
                ArrayList<String> bindVarTypes = new ArrayList<String>();
                bindVarTypes.add("String");
                auditXMLString = "<Root><Detail1  domID='1' title='" + formDispName + "'><chg_mode>" + actionPerformed + "</chg_mode></Detail1></Root>";
                String query = "SELECT CHG_XML FROM AUDIT_TRAIL WHERE TRAN_ID=? FOR UPDATE";
                if (!("mysql".equalsIgnoreCase(database) || "DB2".equalsIgnoreCase(database) || "MSSQL".equalsIgnoreCase(database) || "PGSQL".equalsIgnoreCase(database))) {
                    this.updateBlob(query, auditXMLString, bindVarValues, bindVarTypes, con);
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception :UpdateAuditTrail :saveValuesInAudit :==>\n" + e);
                throw new ITMException(e);
            }
        }
        finally {
            try {
                con.commit();
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
                if (con != null) {
                    con.close();
                    con = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception :UpdateAuditTrail : saveValuesInAudit :finally==>");
                throw new ITMException(e);
            }
        }
        return auditTranId;
    }

    private String getAuditId(String objName, String refId, Connection con) throws ITMException {
        int auditId = 0;
        Statement stmt = null;
        try {
            try {
                ResultSet rs;
                ConnDriver connDriver = new ConnDriver();
                String database = connDriver.getDBName(con);
                con.setAutoCommit(false);
                stmt = con.createStatement();
                String sql = "SELECT MAX( CAST ( (CHG_ID) AS NUMBER(10) ) ) CHG_ID FROM AUDIT_TRAIL WHERE OBJ_NAME='" + objName + "' AND REF_ID ='" + refId.trim() + "'";
                if ("pgsql".equalsIgnoreCase(database) || "mysql".equalsIgnoreCase(database) || "db2".equalsIgnoreCase(database) || "MSSQL".equalsIgnoreCase(database)) {
                    sql = "SELECT MAX(CAST(CHG_ID AS DECIMAL(10))) CHG_ID FROM AUDIT_TRAIL WHERE OBJ_NAME='" + objName + "' AND REF_ID ='" + refId.trim() + "'";
                }
                if ((rs = stmt.executeQuery(sql)).next()) {
                    auditId = rs.getInt("CHG_ID");
                }
                stmt.close();
                stmt = null;
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception :UpdateAuditTrail :getAuditId() :==>\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        return "" + ++auditId;
    }

    private boolean updateBlob(String query, String dataStr, ArrayList bindVarValues, ArrayList bindVarTypes, Connection con) throws RemoteException, ITMException {
        BaseLogger.log("2", null, null, "bindVarTypes [" + bindVarTypes + "]");
        BaseLogger.log("2", null, null, "bindVarValues [" + bindVarValues + "]");
        boolean updStatus = false;
        PreparedStatement pStmt = null;
        try {
            try {
                pStmt = con.prepareStatement(query);
                int ctr = 0;
                while (ctr < bindVarValues.size()) {
                    if (((String)bindVarTypes.get(ctr)).indexOf("String") != -1) {
                        pStmt.setString(ctr + 1, (String)bindVarValues.get(ctr));
                    } else if (((String)bindVarTypes.get(ctr)).indexOf("Int") != -1) {
                        pStmt.setInt(ctr + 1, Integer.parseInt((String)bindVarValues.get(ctr)));
                    }
                    ++ctr;
                }
                ResultSet rs = pStmt.executeQuery();
                if (rs.next()) {
                    Blob mapBlob = rs.getBlob(1);
                    OutputStream blobOutputStream = ((BLOB)mapBlob).getBinaryOutputStream();
                    byte[] dataByteArray = null;
                    E12GenericUtility genericUtility = new E12GenericUtility();
                    if ((dataStr = genericUtility.remAllXmlDec(dataStr)) != null && dataStr.length() > 0 && dataStr.indexOf("</DocumentRoot>") != -1) {
                        dataStr = dataStr.substring(0, dataStr.indexOf("</DocumentRoot>") + 15);
                        dataByteArray = dataStr.getBytes();
                    } else if (dataStr != null && dataStr.length() > 0 && dataStr.indexOf("</Root>") != -1) {
                        dataStr = dataStr.substring(0, dataStr.indexOf("</Root>") + 7);
                        dataByteArray = dataStr.getBytes();
                    }
                    blobOutputStream.write(dataByteArray);
                    blobOutputStream.close();
                    updStatus = true;
                }
                pStmt.close();
                pStmt = null;
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (updStatus) {
                    con.commit();
                }
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
            }
            catch (Exception e) {
                System.err.println("Exception :UpdateAuditTrail :updateBlob :==>finally\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        return updStatus;
    }

    private String getAudiNextSeqId(Connection con) throws Exception {
        ResultSet rs = null;
        String tranId = "";
        String query = "";
        ConnDriver connDriver = new ConnDriver();
        String database = connDriver.getDBName(con);
        if ("db2".equalsIgnoreCase(database)) {
            query = "SELECT NEXTVAL FOR AUDIT_TRAIL_SEQ FROM DUAL";
        } else if ("mysql".equalsIgnoreCase(database) || "MSSQL".equalsIgnoreCase(database)) {
            String maxValueStr = "";
            String getMaxValue = "SELECT MAX(MAX_VALUE) FROM SEQUENCES WHERE SEQ_NAME = 'AUDIT_TRAIL_SEQ' ";
            PreparedStatement pstmt = con.prepareStatement(getMaxValue);
            ResultSet rst = pstmt.executeQuery();
            PreparedStatement pstm = null;
            if (rst.next()) {
                if (rst.getInt(1) != 0) {
                    tranId = String.valueOf(rst.getInt(1));
                    if (tranId != null && tranId.length() > 0) {
                        maxValueStr = "UPDATE SEQUENCES SET MAX_VALUE = ? WHERE SEQ_NAME = 'AUDIT_TRAIL_SEQ' ";
                        pstm = con.prepareStatement(maxValueStr);
                        pstm.setLong(1, rst.getInt(1) + 1);
                        tranId = Integer.toString(Integer.parseInt(tranId) + 1);
                    }
                } else {
                    tranId = String.valueOf(1);
                    maxValueStr = "INSERT INTO SEQUENCES ( MAX_VALUE ,SEQ_NAME) VALUES (?, ?) ";
                    pstm = con.prepareStatement(maxValueStr);
                    pstm.setInt(1, 1);
                    pstm.setString(2, "AUDIT_TRAIL_SEQ");
                }
            }
            pstm.executeUpdate();
            rst.close();
            rst = null;
            pstmt.close();
            pstmt = null;
            pstm.close();
            pstm = null;
        } else {
            query = "pgsql".equalsIgnoreCase(database) ? "SELECT NEXTVAL('AUDIT_TRAIL_SEQ') FROM DUAL" : "SELECT AUDIT_TRAIL_SEQ.NEXTVAL FROM DUAL";
        }
        Statement stmt = con.createStatement();
        if (!"mysql".equalsIgnoreCase(database) && !"MSSQL".equalsIgnoreCase(database)) {
            rs = stmt.executeQuery(query);
            while (rs.next()) {
                tranId = rs.getString(1);
            }
            if (rs != null) {
                rs.close();
                rs = null;
            }
        }
        String tmp1 = "000000000000000000000000" + tranId;
        int tm_len = tmp1.length() - 10;
        tranId = tmp1.substring(tm_len);
        if (stmt != null) {
            stmt.close();
            stmt = null;
        }
        if (con != null) {
            con.commit();
        }
        return tranId;
    }

    @Override
    public void updateAuditResponse(String auditTranId, String status, String responseStr, String transDB) throws RemoteException, BaseException {
        Connection mConnection = null;
        Statement mStatement = null;
        try {
            try {
                ConnDriver mConnDriver = new ConnDriver();
                mConnection = mConnDriver.getConnectDB(transDB);
                String query = "UPDATE AUDIT_TRAIL SET ACTION_STATUS = ?, ACTION_RESP = ? WHERE TRAN_ID = ?";
                mStatement = mConnection.prepareStatement(query);
                mStatement.setString(1, status);
                if (responseStr != null && responseStr.length() > 1000) {
                    responseStr = responseStr.substring(0, 1000);
                }
                mStatement.setString(2, responseStr);
                mStatement.setString(3, auditTranId);
                int rowCnt = mStatement.executeUpdate();
                BaseLogger.log("3", null, null, "Audit Trail UPDATED :" + rowCnt);
                mStatement.close();
                mStatement = null;
                mConnection.commit();
            }
            catch (BaseException be) {
                throw be;
            }
            catch (Exception e) {
                throw new BaseException(e);
            }
        }
        finally {
            try {
                if (mStatement != null) {
                    mStatement.close();
                    mStatement = null;
                }
                if (mConnection != null) {
                    mConnection.close();
                    mConnection = null;
                }
            }
            catch (Exception e) {
                throw new BaseException(e);
            }
        }
    }

    @Override
    public boolean saveValuesInAudit(String objName, String tranId, String formDispName, String fieldName, String fieldValue, String fieldLabel, String fieldOldValue, String loginCode, String chgTerm, UserInfoBean userInfo) throws RemoteException, ITMException {
        boolean updStatus = false;
        Statement pStmt = null;
        Connection con = null;
        try {
            try {
                String auditXMLString;
                String chgIp = "";
                if (userInfo != null) {
                    chgTerm = userInfo.getMacAddress();
                    chgIp = userInfo.getRemoteAddress();
                }
                String transDB = userInfo.getTransDB();
                ConnDriver connDriver = new ConnDriver();
                con = connDriver.getConnectDB(transDB);
                con.setAutoCommit(false);
                String database = connDriver.getDBName(con);
                connDriver = null;
                CommonDBAccessEJB db = new CommonDBAccessEJB();
                tranId = db.refIDWithTrimForAuditTrail(tranId);
                tranId = tranId.replace(":", ",");
                String auditId = this.getAuditId(objName, tranId, con);
                String insertQuery = "INSERT INTO AUDIT_TRAIL (OBJ_NAME, CHG_ID, REF_ID, DATA_XML_BEFORE, CHG_XML, DATA_XML_AFTER, CHG_USER, CHG_DATE, CHG_TERM, CHG_IP) VALUES ( ?, ?, ?, EMPTY_BLOB(), EMPTY_BLOB(), EMPTY_BLOB(), ?, ?, ?, ?)";
                if ("mysql".equalsIgnoreCase(database) || "DB2".equalsIgnoreCase(database) || "MSSQL".equalsIgnoreCase(database) || "PGSQL".equalsIgnoreCase(database)) {
                    byte[] auditXmlBeforeArray = "<Root></Root>".getBytes();
                    ByteArrayInputStream auditBeforeByteArray = auditXmlBeforeArray != null ? new ByteArrayInputStream(auditXmlBeforeArray) : null;
                    auditXMLString = "<Root><Detail1  domID='1' title='" + formDispName + "'><field_name>" + fieldName + "</field_name><field_disp_name>" + fieldLabel + "</field_disp_name><new_value>" + fieldValue + "</new_value><old_value>" + fieldOldValue + "</old_value><chg_mode></chg_mode></Detail1></Root>";
                    byte[] auditXmlArray = auditXMLString.getBytes();
                    ByteArrayInputStream chgXMLStringByteArray = auditXmlArray != null ? new ByteArrayInputStream(auditXmlArray) : null;
                    byte[] auditXmlAfterArray = "<Root></Root>".getBytes();
                    ByteArrayInputStream auditAfterByteArray = auditXmlAfterArray != null ? new ByteArrayInputStream(auditXmlAfterArray) : null;
                    insertQuery = "INSERT INTO AUDIT_TRAIL (OBJ_NAME, CHG_ID, REF_ID, DATA_XML_BEFORE, CHG_XML, DATA_XML_AFTER, CHG_USER, CHG_DATE, CHG_TERM, CHG_IP) VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                    pStmt = con.prepareStatement(insertQuery);
                    pStmt.setString(1, objName);
                    pStmt.setString(2, auditId);
                    pStmt.setString(3, tranId.trim());
                    if (auditBeforeByteArray != null) {
                        pStmt.setBinaryStream(4, auditBeforeByteArray, auditBeforeByteArray.available());
                    } else {
                        pStmt.setBinaryStream(4, null, 0);
                    }
                    if (chgXMLStringByteArray != null) {
                        pStmt.setBinaryStream(5, chgXMLStringByteArray, chgXMLStringByteArray.available());
                    } else {
                        pStmt.setBinaryStream(5, null, 0);
                    }
                    if (auditAfterByteArray != null) {
                        pStmt.setBinaryStream(6, auditAfterByteArray, auditAfterByteArray.available());
                    } else {
                        pStmt.setBinaryStream(6, null, 0);
                    }
                    pStmt.setString(7, loginCode != null && loginCode.length() > 0 ? loginCode : "SYSTEM");
                    pStmt.setTimestamp(8, new Timestamp(System.currentTimeMillis()));
                    pStmt.setString(9, chgTerm != null && chgTerm.length() > 0 ? chgTerm : "SYSTEM");
                    pStmt.setString(10, chgIp);
                } else {
                    pStmt = con.prepareStatement(insertQuery);
                    pStmt.setString(1, objName);
                    pStmt.setString(2, auditId);
                    pStmt.setString(3, tranId.trim());
                    pStmt.setString(4, loginCode != null && loginCode.length() > 0 ? loginCode : "SYSTEM");
                    pStmt.setTimestamp(5, new Timestamp(System.currentTimeMillis()));
                    pStmt.setString(6, chgTerm != null && chgTerm.length() > 0 ? chgTerm : "SYSTEM");
                    pStmt.setString(7, chgIp);
                }
                pStmt.executeUpdate();
                pStmt.close();
                pStmt = null;
                ArrayList<String> bindVarValues = new ArrayList<String>();
                bindVarValues.add(auditId);
                bindVarValues.add(objName);
                bindVarValues.add(tranId);
                ArrayList<String> bindVarTypes = new ArrayList<String>();
                bindVarTypes.add("String");
                bindVarTypes.add("String");
                bindVarTypes.add("String");
                auditXMLString = "<Root><Detail1  domID='1' title='" + formDispName + "'><field_name>" + fieldName + "</field_name><field_disp_name>" + fieldLabel + "</field_disp_name><new_value>" + fieldValue + "</new_value><old_value>" + fieldOldValue + "</old_value><chg_mode></chg_mode></Detail1></Root>";
                String query = "SELECT CHG_XML FROM AUDIT_TRAIL WHERE CHG_ID=? AND OBJ_NAME=? AND REF_ID=? FOR UPDATE";
                if (!("mysql".equalsIgnoreCase(database) || "mssql".equalsIgnoreCase(database) || "pgsql".equalsIgnoreCase(database) || "db2".equalsIgnoreCase(database))) {
                    updStatus = this.updateBlob(query, auditXMLString, bindVarValues, bindVarTypes, con);
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "Exception :UpdateAuditTrail :saveValuesInAudit :==>\n" + e);
                throw new ITMException(e);
            }
        }
        finally {
            try {
                con.commit();
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
                if (con != null) {
                    con.close();
                    con = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "Exception :UpdateAuditTrail : saveValuesInAudit :finally==>");
                throw new ITMException(e);
            }
        }
        return updStatus;
    }

    @Override
    public String saveActionPerformedInAudit(String objName, String tranId, String formDispName, String actionPerformed, String loginCode, String chgTerm, UserInfoBean userInfo) throws RemoteException, ITMException {
        return this.saveActionPerformedInAudit(objName, tranId, formDispName, actionPerformed, loginCode, chgTerm, userInfo, "");
    }

    public String saveActionPerformedInAudit(String objName, String tranId, String formDispName, String actionPerformed, String loginCode, String chgTerm, UserInfoBean userInfo, String chgXml) throws RemoteException, ITMException {
        Statement pStmt = null;
        Connection con = null;
        String auditTranId = "";
        try {
            try {
                String auditXMLString;
                String chgIp = "";
                if (userInfo != null) {
                    chgTerm = userInfo.getMacAddress();
                    chgIp = userInfo.getRemoteAddress();
                }
                String transDB = userInfo.getTransDB();
                ConnDriver connDriver = new ConnDriver();
                con = connDriver.getConnectDB(transDB);
                con.setAutoCommit(false);
                String database = connDriver.getDBName(con);
                connDriver = null;
                auditTranId = this.getAudiNextSeqId(con);
                CommonDBAccessEJB db = new CommonDBAccessEJB();
                tranId = db.refIDWithTrimForAuditTrail(tranId);
                tranId = tranId.replace(":", "");
                tranId = tranId.trim();
                String auditId = this.getAuditId(objName, tranId, con);
                String insertQuery = "INSERT INTO AUDIT_TRAIL (TRAN_ID, OBJ_NAME, CHG_ID, REF_ID, DATA_XML_BEFORE, CHG_XML, DATA_XML_AFTER, CHG_USER, CHG_DATE, CHG_TERM, ACTION_PRFRM, ACTION_STATUS, CHG_IP) VALUES ( ?, ?, ?, ?, EMPTY_BLOB(), EMPTY_BLOB(), EMPTY_BLOB(), ?, ?, ?, ?, ?, ?)";
                if ("mysql".equalsIgnoreCase(database) || "DB2".equalsIgnoreCase(database) || "MSSQL".equalsIgnoreCase(database) || "PGSQL".equalsIgnoreCase(database)) {
                    byte[] auditXmlBeforeArray = "<Root></Root>".getBytes();
                    ByteArrayInputStream auditBeforeByteArray = auditXmlBeforeArray != null ? new ByteArrayInputStream(auditXmlBeforeArray) : null;
                    auditXMLString = "";
                    auditXMLString = !"".equalsIgnoreCase(chgXml) ? chgXml : "<Root><Detail1  domID='1' title='" + formDispName + "'><chg_mode>" + actionPerformed + "</chg_mode></Detail1></Root>";
                    byte[] auditXmlArray = auditXMLString.getBytes();
                    ByteArrayInputStream chgXMLStringByteArray = auditXmlArray != null ? new ByteArrayInputStream(auditXmlArray) : null;
                    byte[] auditXmlAfterArray = "<Root></Root>".getBytes();
                    ByteArrayInputStream auditAfterByteArray = auditXmlAfterArray != null ? new ByteArrayInputStream(auditXmlAfterArray) : null;
                    insertQuery = "INSERT INTO AUDIT_TRAIL (TRAN_ID, OBJ_NAME, CHG_ID, REF_ID, DATA_XML_BEFORE, CHG_XML, DATA_XML_AFTER, CHG_USER, CHG_DATE, CHG_TERM, ACTION_PRFRM, ACTION_STATUS, CHG_IP ) VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                    pStmt = con.prepareStatement(insertQuery);
                    pStmt.setString(1, auditTranId);
                    pStmt.setString(2, objName);
                    pStmt.setString(3, auditId);
                    pStmt.setString(4, tranId.trim());
                    if (auditBeforeByteArray != null) {
                        pStmt.setBinaryStream(5, auditBeforeByteArray, auditBeforeByteArray.available());
                    } else {
                        pStmt.setBinaryStream(5, null, 0);
                    }
                    if (chgXMLStringByteArray != null) {
                        pStmt.setBinaryStream(6, chgXMLStringByteArray, chgXMLStringByteArray.available());
                    } else {
                        pStmt.setBinaryStream(6, null, 0);
                    }
                    if (auditAfterByteArray != null) {
                        pStmt.setBinaryStream(7, auditAfterByteArray, auditAfterByteArray.available());
                    } else {
                        pStmt.setBinaryStream(7, null, 0);
                    }
                    pStmt.setString(8, loginCode != null && loginCode.length() > 0 ? loginCode : "SYSTEM");
                    pStmt.setTimestamp(9, new Timestamp(System.currentTimeMillis()));
                    pStmt.setString(10, chgTerm != null && chgTerm.length() > 0 ? chgTerm : "SYSTEM");
                    pStmt.setString(11, actionPerformed);
                    pStmt.setString(12, "Pending");
                    pStmt.setString(13, chgIp);
                } else {
                    pStmt = con.prepareStatement(insertQuery);
                    pStmt.setString(1, auditTranId);
                    pStmt.setString(2, objName);
                    pStmt.setString(3, auditId);
                    pStmt.setString(4, tranId.trim());
                    pStmt.setString(5, loginCode != null && loginCode.length() > 0 ? loginCode : "SYSTEM");
                    pStmt.setTimestamp(6, new Timestamp(System.currentTimeMillis()));
                    pStmt.setString(7, chgTerm != null && chgTerm.length() > 0 ? chgTerm : "SYSTEM");
                    pStmt.setString(8, actionPerformed);
                    pStmt.setString(9, "Pending");
                    pStmt.setString(10, chgIp);
                }
                BaseLogger.log("3", userInfo, null, "Inserting into Audit Trail For objName [" + objName + "] of tranId [" + tranId + "] with AuditId [" + auditId + "] From user [" + loginCode + "]");
                pStmt.executeUpdate();
                pStmt.close();
                pStmt = null;
                ArrayList<String> bindVarValues = new ArrayList<String>();
                bindVarValues.add(auditTranId);
                ArrayList<String> bindVarTypes = new ArrayList<String>();
                bindVarTypes.add("String");
                auditXMLString = "";
                auditXMLString = !"".equalsIgnoreCase(chgXml) ? chgXml : "<Root><Detail1  domID='1' title='" + formDispName + "'><chg_mode>" + actionPerformed + "</chg_mode></Detail1></Root>";
                String query = "SELECT CHG_XML FROM AUDIT_TRAIL WHERE TRAN_ID=? FOR UPDATE";
                if (!("mysql".equalsIgnoreCase(database) || "DB2".equalsIgnoreCase(database) || "MSSQL".equalsIgnoreCase(database) || "PGSQL".equalsIgnoreCase(database))) {
                    this.updateBlob(query, auditXMLString, bindVarValues, bindVarTypes, con);
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "Exception :UpdateAuditTrail :saveValuesInAudit :==>\n" + e);
                throw new ITMException(e);
            }
        }
        finally {
            try {
                con.commit();
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
                if (con != null) {
                    con.close();
                    con = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "Exception :UpdateAuditTrail : saveValuesInAudit :finally==>");
                throw new ITMException(e);
            }
        }
        return auditTranId;
    }

    @Override
    public void updateAuditResponse(String auditTranId, String status, String responseStr, UserInfoBean userInfo) throws RemoteException, BaseException {
        Connection mConnection = null;
        Statement mStatement = null;
        try {
            try {
                String transDB = userInfo.getTransDB();
                ConnDriver mConnDriver = new ConnDriver();
                mConnection = mConnDriver.getConnectDB(transDB);
                String query = "UPDATE AUDIT_TRAIL SET ACTION_STATUS = ?, ACTION_RESP = ? WHERE TRAN_ID = ?";
                mStatement = mConnection.prepareStatement(query);
                mStatement.setString(1, status);
                if (responseStr != null && responseStr.length() > 1000) {
                    responseStr = responseStr.substring(0, 1000);
                }
                mStatement.setString(2, responseStr);
                mStatement.setString(3, auditTranId);
                int rowCnt = mStatement.executeUpdate();
                BaseLogger.log("3", userInfo, null, "Audit Trail UPDATED :" + rowCnt);
                mStatement.close();
                mStatement = null;
                mConnection.commit();
            }
            catch (BaseException be) {
                throw be;
            }
            catch (Exception e) {
                throw new BaseException(e);
            }
        }
        finally {
            try {
                if (mStatement != null) {
                    mStatement.close();
                    mStatement = null;
                }
                if (mConnection != null) {
                    mConnection.close();
                    mConnection = null;
                }
            }
            catch (Exception e) {
                throw new BaseException(e);
            }
        }
    }

    @Override
    public String getAuditTrailOpt(String objName, UserInfoBean userInfo) throws RemoteException, ITMException {
        String auditTrailOpt = "1";
        Statement stmt = null;
        Connection con = null;
        try {
            try {
                String transDB = userInfo.getTransDB();
                ConnDriver connDriver = new ConnDriver();
                con = connDriver.getConnectDB(transDB);
                con.setAutoCommit(false);
                connDriver = null;
                stmt = con.createStatement();
                String sql = "SELECT AUDIT_TRAIL_OPT FROM TRANSETUP WHERE TRAN_WINDOW ='w_" + objName + "' ";
                BaseLogger.log("3", userInfo, null, "sql [" + sql + "]");
                ResultSet rs = stmt.executeQuery(sql);
                if (rs.next()) {
                    auditTrailOpt = rs.getString("AUDIT_TRAIL_OPT");
                }
                stmt.close();
                stmt = null;
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "Exception :UpdateAuditTrail :getAuditId() :==>\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
                if (con != null) {
                    con.close();
                    con = null;
                }
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        return auditTrailOpt;
    }

    public String saveActionPerformedInAuditTrailDoc(String docId, String actionPerformed, String docType, String objName, String comments, String loginCode, String chgTerm, String transDB, UserInfoBean userInfo) throws RemoteException, ITMException {
        Statement pStmt = null;
        Connection con = null;
        String auditChgId = "";
        try {
            try {
                BaseLogger.log("3", userInfo, null, "Inside saveActionPerformedInAuditTrailDoc transDB :[" + transDB + "]");
                ConnDriver connDriver = new ConnDriver();
                if (transDB == null) {
                    if (userInfo != null) {
                        transDB = userInfo.getTransDB();
                    }
                    if ((transDB = E12GenericUtility.checkNull(transDB)).length() == 0) {
                        transDB = "Driver";
                    }
                }
                if (userInfo != null) {
                    chgTerm = userInfo.getMacAddress();
                }
                con = connDriver.getConnectDB(transDB);
                con.setAutoCommit(false);
                connDriver = null;
                BaseLogger.log("3", userInfo, null, "Inside saveActionPerformedInAuditTrailDoc con :[" + con + "]");
                TransIDGenerator idGenerator = new TransIDGenerator("<Root></Root>", userInfo.getLoginCode(), CommonConstants.DB_NAME);
                BaseLogger.log("3", userInfo, null, "Inside saveActionPerformedInAuditTrailDoc CommonConstants.DB_NAME :[" + CommonConstants.DB_NAME + "]");
                auditChgId = "mysql".equalsIgnoreCase(CommonConstants.DB_NAME) ? this.generateAuditTrailDocSeqID("CHGID", "seq10", "ATD", userInfo) : idGenerator.generateTranSeqID("CHGID", "CHG_ID", "seq10", con);
                String insertQuery = "INSERT INTO AUDIT_TRAIL_DOC (CHG_ID, DOC_ID__REF, ACTION, DOC_TYPE, OBJ_NAME, COMMENTS, CHG_USER, CHG_DATE, CHG_TERM) VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                pStmt = con.prepareStatement(insertQuery);
                BaseLogger.log("3", userInfo, null, "Inside saveActionPerformedInAuditTrailDoc pStmt :[" + pStmt + "]");
                pStmt.setString(1, E12GenericUtility.checkNull(auditChgId));
                pStmt.setString(2, E12GenericUtility.checkNull(docId));
                pStmt.setString(3, E12GenericUtility.checkNull(actionPerformed));
                pStmt.setString(4, E12GenericUtility.checkNull(docType));
                pStmt.setString(5, E12GenericUtility.checkNull(objName));
                pStmt.setString(6, E12GenericUtility.checkNull(comments));
                loginCode = E12GenericUtility.checkNull(loginCode);
                pStmt.setString(7, loginCode != null && loginCode.length() > 0 ? loginCode : "SYSTEM");
                pStmt.setTimestamp(8, new Timestamp(System.currentTimeMillis()));
                chgTerm = E12GenericUtility.checkNull(chgTerm);
                chgTerm = chgTerm != null && chgTerm.length() < 14 ? chgTerm : "SYSTEM";
                pStmt.setString(9, chgTerm);
                int i = pStmt.executeUpdate();
                BaseLogger.log("3", userInfo, null, "Inside saveActionPerformedInAuditTrailDoc i :[" + i + "]");
                if (i > 0) {
                    BaseLogger.log("3", userInfo, null, "Inserted data in AUDIT_TRAIL_DOC table ...");
                }
                pStmt.close();
                pStmt = null;
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception :UpdateAuditTrail :saveValuesInAudit :==>\n" + e);
                throw new ITMException(e);
            }
        }
        finally {
            try {
                con.commit();
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
                if (con != null) {
                    con.close();
                    con = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception : saveActionPerformedInAuditTrailDoc :finally==>");
                throw new ITMException(e);
            }
        }
        return auditChgId;
    }

    public void updateAuditTrailDoc(String auditTranId, String actionPerformed, String comments, UserInfoBean userInfo) throws RemoteException, BaseException {
        Connection mConnection = null;
        Statement mStatement = null;
        try {
            try {
                String transDB = userInfo.getTransDB();
                ConnDriver mConnDriver = new ConnDriver();
                mConnection = mConnDriver.getConnectDB(transDB);
                String query = "UPDATE AUDIT_TRAIL_DOC SET  ACTION = ?, COMMENTS = ? WHERE TRAN_ID = ?";
                mStatement = mConnection.prepareStatement(query);
                mStatement.setString(1, actionPerformed);
                mStatement.setString(2, comments);
                mStatement.setString(3, auditTranId);
                int rowCnt = mStatement.executeUpdate();
                BaseLogger.log("3", userInfo, null, "Audit Trail UPDATED :" + rowCnt);
                mStatement.close();
                mStatement = null;
                mConnection.commit();
            }
            catch (BaseException be) {
                throw be;
            }
            catch (Exception e) {
                throw new BaseException(e);
            }
        }
        finally {
            try {
                if (mStatement != null) {
                    mStatement.close();
                    mStatement = null;
                }
                if (mConnection != null) {
                    mConnection.close();
                    mConnection = null;
                }
            }
            catch (Exception e) {
                throw new BaseException(e);
            }
        }
    }

    private String generateAuditTrailDocSeqID(String transer, String keycont, String keystr, UserInfoBean userInfo) {
        String lastSeq;
        block33: {
            int SeqLen = 0;
            lastSeq = "0";
            Connection mConnection = null;
            Statement mStatement = null;
            Statement pst = null;
            Statement st = null;
            ResultSet rs = null;
            boolean recrdPresentForRefr = false;
            String sysdateStr = " DATE(CURRENT_TIMESTAMP) ";
            String termID = "<basenvl>";
            try {
                try {
                    String dbName;
                    ConnDriver mConnDriver = new ConnDriver();
                    String transDB = userInfo.getTransDB();
                    if (transDB == null) {
                        transDB = "Driver";
                    }
                    sysdateStr = "db2".equalsIgnoreCase(dbName = mConnDriver.getDBName(mConnection = mConnDriver.getConnectDB(transDB))) ? " CURRENT_DATE " : ("mysql".equalsIgnoreCase(dbName) ? " CURRENT_DATE " : ("pgsql".equalsIgnoreCase(dbName) ? " CURRENT_DATE " : ("mssql".equalsIgnoreCase(dbName) ? " GETDATE() " : " CURRENT_DATE ")));
                    SeqLen = Integer.parseInt(keycont.substring(3, 5));
                    String qry = "SELECT SEQ_NO FROM REFSEQ WHERE REF_SER='" + transer.trim() + "' AND REF_PREFIX='" + keystr.trim() + "'";
                    BaseLogger.log("3", null, null, "qry :[" + qry + "]");
                    mStatement = mConnection.prepareStatement(qry);
                    rs = mStatement.executeQuery(qry);
                    if (rs.next()) {
                        String seqNo = E12GenericUtility.checkNull(rs.getString(1));
                        BaseLogger.log("3", null, null, "inside generateAuditTrailDocSeqID seqNo :[" + seqNo + "]");
                        if (seqNo != null && seqNo.length() > 0) {
                            lastSeq = seqNo.trim();
                        }
                        recrdPresentForRefr = true;
                    }
                    BaseLogger.log("3", null, null, "inside generateAuditTrailDocSeqID lastSeq :[" + lastSeq + "]");
                    if (mStatement != null) {
                        mStatement.close();
                        mStatement = null;
                    }
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    lastSeq = this.genereateSequence(SeqLen, lastSeq);
                    BaseLogger.log("3", null, null, "inside generateAuditTrailDocSeqID Generating lastSeqNo :[" + lastSeq + "]");
                    if (!recrdPresentForRefr) {
                        try {
                            String qry_i = "INSERT INTO REFSEQ( REF_SER, REF_PREFIX, SEQ_NO, CHG_DATE, CHG_USER, CHG_TERM ) VALUES( '" + transer.trim() + "','" + keystr.trim() + "','" + lastSeq.trim() + "', " + sysdateStr + " ,'" + userInfo.getLoginCode().trim() + "','" + termID.trim() + "' )";
                            BaseLogger.log("3", null, null, "qry_i :" + qry_i + ":");
                            pst = mConnection.prepareStatement(qry_i);
                            int n = pst.executeUpdate();
                            BaseLogger.log("3", null, null, "No of Record Inserted :" + n + ":");
                            if (pst != null) {
                                pst.close();
                                pst = null;
                            }
                            break block33;
                        }
                        catch (Exception e) {
                            BaseLogger.log("0", null, null, "Exception in generateAuditTrailDocSeqID while insert:==>" + e.getMessage());
                        }
                        break block33;
                    }
                    try {
                        String qry_u = "UPDATE REFSEQ SET SEQ_NO='" + lastSeq.trim() + "' WHERE REF_SER='" + transer.trim() + "' AND  REF_PREFIX='" + keystr.trim() + "'";
                        BaseLogger.log("3", null, null, "qry_u :" + qry_u + ":");
                        st = mConnection.prepareStatement(qry_u);
                        int n = st.executeUpdate();
                        BaseLogger.log("3", null, null, "No of Record Updated :" + n + ":");
                        if (st != null) {
                            st.close();
                            st = null;
                        }
                    }
                    catch (Exception e) {
                        BaseLogger.log("0", null, null, "Exception in generateAuditTrailDocSeqID while update::" + e.getMessage());
                    }
                }
                catch (Exception ae) {
                    BaseLogger.log("0", null, null, "Exception in generateAuditTrailDocSeqID::" + ae.getMessage());
                    try {
                        if (mStatement != null) {
                            mStatement.close();
                            mStatement = null;
                        }
                        if (rs != null) {
                            rs.close();
                            rs = null;
                        }
                        if (pst != null) {
                            pst.close();
                            pst = null;
                        }
                        if (st != null) {
                            st.close();
                            st = null;
                        }
                        if (mConnection != null) {
                            mConnection.close();
                            mConnection = null;
                        }
                    }
                    catch (Exception e) {
                        BaseLogger.log("0", null, null, "Exception inside finally generateAuditTrailDocSeqID::" + e.getMessage());
                    }
                }
            }
            finally {
                try {
                    if (mStatement != null) {
                        mStatement.close();
                        mStatement = null;
                    }
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (pst != null) {
                        pst.close();
                        pst = null;
                    }
                    if (st != null) {
                        st.close();
                        st = null;
                    }
                    if (mConnection != null) {
                        mConnection.close();
                        mConnection = null;
                    }
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "Exception inside finally generateAuditTrailDocSeqID::" + e.getMessage());
                }
            }
        }
        return lastSeq;
    }

    private String genereateSequence(int seqlen, String lastSeq) {
        try {
            String errorCode = "";
            String lastDigit = "";
            String nextCharacter = "";
            int lsCount = 0;
            long lastNumber = 0L;
            lsCount = 0;
            while (lsCount < seqlen) {
                lastDigit = "" + lastSeq.charAt(lsCount);
                if (lastDigit.compareTo("9") <= 0) break;
                ++lsCount;
            }
            if (lsCount < 0) {
                errorCode = "VTMAXNO";
                lastNumber = Long.parseLong(lastSeq.substring(lsCount));
            } else {
                lastNumber = Long.parseLong(lastSeq.substring(lsCount));
            }
            if (("" + (lastNumber + 1L)).length() <= seqlen - lsCount) {
                String temp = "0000000000000000000000000" + (lastNumber + 1L);
                lastSeq = String.valueOf(lastSeq.substring(0, lsCount)) + temp.substring(temp.length() - (seqlen - lsCount));
            } else {
                lsCount = 0;
                while (lsCount < seqlen - 2) {
                    lastDigit = "" + lastSeq.charAt(lsCount);
                    if (lastDigit.compareTo("9") == 0) {
                        nextCharacter = "A";
                        break;
                    }
                    ++lsCount;
                }
                if (lastDigit.compareTo("A") >= 0 && lastDigit.compareTo("Z") < 0) {
                    nextCharacter = "" + (char)(lastSeq.charAt(--lsCount) + '\u0001');
                } else if (lastDigit.compareTo("Z") == 0) {
                    lsCount = lastSeq.indexOf("Z") - 1;
                    nextCharacter = "" + (char)(lastSeq.charAt(lsCount) + '\u0001');
                }
                if (nextCharacter.equals("") && nextCharacter.length() <= 0) {
                    errorCode = "VTMAXNO";
                } else {
                    String temp = "0000000000000000000000001";
                    lastSeq = String.valueOf(lastSeq.substring(0, lsCount)) + nextCharacter + temp.substring(temp.length() - (seqlen - lsCount - 1));
                }
            }
            if (errorCode.length() > 0) {
                return errorCode;
            }
        }
        catch (Exception ae) {
            BaseLogger.log("0", null, null, "Exception inside genereateSequence::" + ae.getMessage());
        }
        return lastSeq;
    }
}

