/*
 * Decompiled with CFR 0.152.
 */
package ibase.hibernate.dao;

import ibase.hibernate.bean.ObjUserPref;
import ibase.hibernate.utility.HibernateUtil;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.utility.ITMException;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.query.Query;
import org.json.JSONArray;
import org.json.JSONObject;

public class ObjUserPrefDao {
    public ObjUserPref saveExploreReport(String loginCode, String objName, String prefName, String reportConfig, String tranDB) {
        BaseLogger.log("2", null, null, "in save explore report");
        ObjUserPref objUserPrefDoc = null;
        try {
            loginCode = this.checkNull(loginCode);
            BaseLogger.log("3", null, null, "inside try of save explore report");
            Session session = HibernateUtil.getSessionFactory(tranDB).openSession();
            objUserPrefDoc = this.getExploreReport(loginCode, objName, prefName, tranDB);
            BaseLogger.log("3", null, null, "userPrefSoc value from getExploreReport" + objUserPrefDoc);
            Transaction tx = session.beginTransaction();
            if (objUserPrefDoc == null) {
                BaseLogger.log("3", null, null, "if userPrefDoc is null");
                objUserPrefDoc = new ObjUserPref();
                objUserPrefDoc.setUserId(loginCode);
                objUserPrefDoc.setObjName(this.checkNull(objName));
                objUserPrefDoc.setAddDate(new Date());
                objUserPrefDoc.setAddUser(loginCode);
                objUserPrefDoc.setAddTerm(loginCode);
                BaseLogger.log("3", null, null, "inside if userPrefData is null==>" + objUserPrefDoc);
            }
            objUserPrefDoc.setPrefName(this.checkNull(prefName));
            objUserPrefDoc.setPrefValue(reportConfig);
            objUserPrefDoc.setPrefType("L");
            objUserPrefDoc.setPrefValueType("JSON");
            objUserPrefDoc.setChgDate(new Date());
            objUserPrefDoc.setChgUser(loginCode);
            objUserPrefDoc.setChgTerm(loginCode);
            BaseLogger.log("2", null, null, "userPrefData==>" + objUserPrefDoc);
            session.saveOrUpdate((Object)objUserPrefDoc);
            session.flush();
            tx.commit();
            session.close();
        }
        catch (HibernateException e) {
            BaseLogger.log("0", null, null, "HibernateException inside insert in UserPref:");
            BaseLogger.log("0", null, null, e.getMessage());
            BaseLogger.log("0", null, null, "exception in hibernate for saveExploreReport" + e.getMessage());
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception inside insert in UserPref:");
            BaseLogger.log("0", null, null, e.getMessage());
            BaseLogger.log("0", null, null, "exception  for hibernate for saveExploreReport" + e.getMessage());
        }
        return objUserPrefDoc;
    }

    public String deleteExploreReport(String loginCode, String objName, String prefName, String reportConfig, String tranDB) {
        String str = "";
        try {
            ObjUserPref objUserPrefDoc = this.getExploreReport(loginCode, objName, prefName, tranDB);
            str = this.deleteExploreReport(objUserPrefDoc, tranDB);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :");
            BaseLogger.log("0", null, null, e.getMessage());
        }
        return str;
    }

    private String deleteExploreReport(ObjUserPref objUserPrefDoc, String tranDB) {
        String str = "";
        try {
            Session session = HibernateUtil.getSessionFactory(tranDB).openSession();
            session.beginTransaction();
            session.delete((Object)objUserPrefDoc);
            session.getTransaction().commit();
            session.close();
            str = "success";
        }
        catch (HibernateException e) {
            BaseLogger.log("0", null, null, "HibernateException :");
            BaseLogger.log("0", null, null, e.getMessage());
            str = "failure";
        }
        return str;
    }

    public ObjUserPref getExploreReport(String loginCode, String objName, String prefName, String tranDB) {
        BaseLogger.log("3", null, null, "in get explore report");
        ObjUserPref userPrefDoc = null;
        try {
            Session session = HibernateUtil.getSessionFactory(tranDB).openSession();
            Query query = session.createQuery("from ObjUserPref where userId='" + loginCode + "' and  objName='" + objName + "' and prefName='" + prefName + "'");
            List userPrefList = query.getResultList();
            BaseLogger.log("3", null, null, "data for geting explore userPrefList" + userPrefList);
            if (userPrefList != null && userPrefList.size() > 0) {
                userPrefDoc = (ObjUserPref)userPrefList.get(0);
                BaseLogger.log("3", null, null, "data for geting explore report data at util" + userPrefDoc);
            }
        }
        catch (HibernateException e) {
            BaseLogger.log("0", null, null, "HibernateException :");
            BaseLogger.log("0", null, null, e.getMessage());
            BaseLogger.log("0", null, null, "exception  for getExploreReprot" + e.getMessage());
        }
        return userPrefDoc;
    }

    public ObjUserPref setObjectPreference(UserInfoBean userInfo, String objName, String prefName, String prefValue, String prefValType) throws ITMException {
        BaseLogger.log("2", userInfo, null, "In setObjectPreference objName [" + objName + "] prefName [" + prefName + "] prefValue [" + prefValue + "] prefValType [" + prefValType + "]");
        ObjUserPref objUserPrefDoc = null;
        try {
            String transDB = userInfo.getTransDB();
            String userID = userInfo.getLoginCode();
            String chgTerm = userInfo.getRemoteAddress();
            Session session = HibernateUtil.getSessionFactory(transDB).openSession();
            objUserPrefDoc = this.getObjectPreference(userInfo, objName, prefName);
            BaseLogger.log("3", userInfo, null, "In setObjectPreference objUserPrefDoc :[" + objUserPrefDoc + "]");
            Transaction tx = session.beginTransaction();
            if (objUserPrefDoc == null) {
                BaseLogger.log("3", userInfo, null, "In if userPrefDoc is null");
                objUserPrefDoc = new ObjUserPref();
                objUserPrefDoc.setUserId(userID);
                objUserPrefDoc.setObjName(objName);
                objUserPrefDoc.setAddDate(new Date());
                objUserPrefDoc.setAddUser(userID);
                objUserPrefDoc.setAddTerm(chgTerm);
            }
            objUserPrefDoc.setPrefName(prefName);
            objUserPrefDoc.setPrefValue(prefValue);
            objUserPrefDoc.setPrefValueType(prefValType);
            objUserPrefDoc.setChgDate(new Date());
            objUserPrefDoc.setChgUser(userID);
            objUserPrefDoc.setChgTerm(chgTerm);
            BaseLogger.log("2", userInfo, null, "In setObjectPreference objUserPrefDoc after set :[" + objUserPrefDoc + "]");
            session.saveOrUpdate((Object)objUserPrefDoc);
            session.flush();
            tx.commit();
            session.close();
        }
        catch (HibernateException e) {
            BaseLogger.log("0", userInfo, null, "HibernateException in setObjectPreference :[" + E12GenericUtility.getStackTrace((Exception)((Object)e)) + "]");
            e.printStackTrace();
            throw new ITMException((Exception)((Object)e));
        }
        catch (Exception e) {
            BaseLogger.log("0", userInfo, null, "Exception in setObjectPreference :[" + E12GenericUtility.getStackTrace(e) + "]");
            e.printStackTrace();
            throw new ITMException(e);
        }
        return objUserPrefDoc;
    }

    public ObjUserPref getObjectPreference(UserInfoBean userInfo, String objName, String prefName) throws ITMException {
        ObjUserPref userPrefDoc = null;
        try {
            String transDB = userInfo.getTransDB();
            String userID = userInfo.getLoginCode();
            BaseLogger.log("3", userInfo, null, "In getObjectPreference userID [" + userID + "] objName [" + objName + "] transDB [" + transDB + "] prefName [" + prefName + "]");
            Session session = HibernateUtil.getSessionFactory(transDB).openSession();
            Query query = session.createQuery("from ObjUserPref where userId='" + userID + "' and objName='" + objName + "' and prefName='" + prefName + "'");
            List userPrefList = query.getResultList();
            BaseLogger.log("3", userInfo, null, "In getObjectPreference userPrefList :[" + userPrefList + "]");
            if (userPrefList.size() > 0) {
                userPrefDoc = (ObjUserPref)userPrefList.get(0);
                BaseLogger.log("3", userInfo, null, "In getObjectPreference userPrefDoc :[" + userPrefDoc + "]");
            }
        }
        catch (HibernateException e) {
            BaseLogger.log("0", userInfo, null, "HibernateException in getObjectPreference :[" + (Object)((Object)e) + "]");
            e.printStackTrace();
            throw new ITMException((Exception)((Object)e));
        }
        catch (Exception e) {
            BaseLogger.log("0", userInfo, null, "Exception in getObjectPreference :[" + e + "]");
            e.printStackTrace();
            throw new ITMException(e);
        }
        return userPrefDoc;
    }

    public ObjUserPref deleteObjectPreference(UserInfoBean userInfo, String objName, String prefName) throws ITMException {
        ObjUserPref objUserPrefDoc = null;
        try {
            BaseLogger.log("3", null, null, "In  deleteObjectPreference");
            String transDB = userInfo.getTransDB();
            String userId = userInfo.getLoginCode();
            Session session = HibernateUtil.getSessionFactory(transDB).openSession();
            objUserPrefDoc = this.getObjectPreference(userInfo, objName, prefName);
            BaseLogger.log("3", userInfo, null, "In deleteObjectPreference objUserPrefDoc :[" + objUserPrefDoc + "]");
            Transaction tx = session.beginTransaction();
            if (objUserPrefDoc != null) {
                session.delete((Object)objUserPrefDoc);
            }
            session.flush();
            tx.commit();
            session.close();
        }
        catch (HibernateException e) {
            BaseLogger.log("0", userInfo, null, "HibernateException in deleteObjectPreference :[" + (Object)((Object)e) + "]");
            e.printStackTrace();
            throw new ITMException((Exception)((Object)e));
        }
        catch (Exception e) {
            BaseLogger.log("0", userInfo, null, "Exception in deleteObjectPreference :[" + e + "]");
            e.printStackTrace();
            throw new ITMException(e);
        }
        return objUserPrefDoc;
    }

    public JSONObject getAllLayoutPreferences(String loginCode, String objName, String tranDB) {
        BaseLogger.log("3", null, null, "in get explore report");
        JSONObject allUserPrefJsonObj = new JSONObject();
        try {
            JSONArray userPrefArr = new JSONArray();
            JSONArray otherPrefArr = new JSONArray();
            List<ObjUserPref> allObjUserPrefList = this.getObjUserPrefList(objName, tranDB);
            loginCode = this.checkNull(loginCode);
            for (ObjUserPref objUserPref : allObjUserPrefList) {
                JSONObject jsonObj = new JSONObject((Object)objUserPref);
                if (loginCode.equalsIgnoreCase(this.checkNull(objUserPref.getUserId()))) {
                    if (userPrefArr.length() == 0) {
                        jsonObj.put("prefValue", (Object)new JSONObject(objUserPref.getPrefValue()));
                    } else {
                        jsonObj.put("prefValue", (Object)"");
                    }
                    userPrefArr.put((Object)jsonObj);
                    continue;
                }
                otherPrefArr.put((Object)jsonObj);
            }
            allUserPrefJsonObj.put("MY_LAYOUT", (Object)userPrefArr);
            allUserPrefJsonObj.put("OTHER_LAYOUT", (Object)otherPrefArr);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "HibernateException :");
            BaseLogger.log("0", null, null, e.getMessage());
            BaseLogger.log("0", null, null, "exception  for getExploreReprot" + e.getMessage());
        }
        return allUserPrefJsonObj;
    }

    private List<ObjUserPref> getObjUserPrefList(String objName, String tranDB) throws Exception {
        ArrayList<ObjUserPref> userPrefList = new ArrayList<ObjUserPref>();
        Connection autConn = null;
        Statement pstmt = null;
        ResultSet rs = null;
        BaseLogger.log("3", null, null, "<---  objName in getObjUserPrefList --> " + objName);
        try {
            try {
                String sql = "select oup.*, usr.name from obj_user_pref oup, users usr where oup.obj_name='" + objName + "' and usr.code=oup.user_id order by oup.chg_date desc";
                ConnDriver connDriver = new ConnDriver();
                autConn = connDriver.getConnectDB(tranDB);
                pstmt = autConn.prepareStatement(sql);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    ObjUserPref userPref = new ObjUserPref();
                    Clob prefValClob = rs.getClob("PREF_VALUE");
                    userPref.setUserId(rs.getString("USER_ID"));
                    userPref.setObjName(rs.getString("OBJ_NAME"));
                    userPref.setPrefName(rs.getString("PREF_NAME"));
                    userPref.setPrefValue(prefValClob.getSubString(1L, (int)prefValClob.length()));
                    userPref.setPrefValueType(rs.getString("PREF_VAL_TYPE"));
                    userPref.setAddDate(rs.getDate("ADD_DATE"));
                    userPref.setAddUser(rs.getString("ADD_USER"));
                    userPref.setAddTerm(rs.getString("ADD_TERM"));
                    userPref.setChgDate(rs.getDate("CHG_DATE"));
                    userPref.setChgUser(rs.getString("CHG_USER"));
                    userPref.setChgTerm(rs.getString("CHG_TERM"));
                    userPref.setPrefType(rs.getString("PREF_TYPE"));
                    userPref.setUserName(rs.getString("NAME"));
                    userPrefList.add(userPref);
                }
            }
            catch (Exception e) {
                throw new Exception(e);
            }
        }
        finally {
            if (pstmt != null) {
                try {
                    if (autConn != null) {
                        autConn.close();
                    }
                    if (pstmt != null) {
                        pstmt.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
        }
        return userPrefList;
    }

    private String checkNull(String value) {
        if (value != null) {
            return value.trim();
        }
        return value;
    }

    public String getUserPreference(String userID, UserInfoBean userInfo) throws ITMException {
        ObjUserPref userPrefDoc = null;
        String userPreferences = null;
        try {
            String transDB = userInfo.getTransDB();
            BaseLogger.log("3", userInfo, null, "transDB >>>>>>> [" + transDB + "]");
            BaseLogger.log("3", userInfo, null, "In getLoginPreference userID [" + userID + "]");
            Session session = HibernateUtil.getSessionFactory(transDB).openSession();
            Query query = session.createQuery("from ObjUserPref where userId='" + userID + "'");
            List userPrefList = query.getResultList();
            StringBuffer userPref = new StringBuffer();
            int i = 0;
            while (i < userPrefList.size()) {
                userPrefDoc = (ObjUserPref)userPrefList.get(i);
                String objName = E12GenericUtility.checkNull(userPrefDoc.getObjName());
                String prefName = E12GenericUtility.checkNull(userPrefDoc.getPrefName());
                String prefValue = E12GenericUtility.checkNull(userPrefDoc.getPrefValue());
                userPref = userPref.append(String.valueOf(objName) + "-SEP-" + prefName + "-SEP-" + prefValue + "~~");
                BaseLogger.log("3", userInfo, null, "<<<<<<<<< userPrefDoc values :[" + userPrefDoc + "] >>>>>");
                ++i;
            }
            if (userPref != null && userPref.length() > 0 && "~~".equals(userPref.substring(userPref.length() - 2))) {
                userPreferences = userPref.substring(0, userPref.length() - 2);
                BaseLogger.log("3", userInfo, null, "<<< tilde[" + userPref.substring(userPref.length() - 2) + "] >>>>>");
            } else {
                userPreferences = userPref.toString();
            }
            BaseLogger.log("3", userInfo, null, "<<<<<<<<< login pref values :[" + userPreferences + "] >>>>>> End");
        }
        catch (HibernateException e) {
            BaseLogger.log("0", userInfo, null, "HibernateException in getObjectPreference :[" + (Object)((Object)e) + "]");
            e.printStackTrace();
            throw new ITMException((Exception)((Object)e));
        }
        catch (Exception e) {
            BaseLogger.log("0", userInfo, null, "Exception in getObjectPreference :[" + e + "]");
            e.printStackTrace();
            throw new ITMException(e);
        }
        return userPreferences;
    }

    public String getLayoutList(String loginCode, String objName, String prefType, String tranDB) {
        BaseLogger.log("3", null, null, "In ObjUserPref getLayoutList");
        StringBuffer layoutListBuff = new StringBuffer();
        String layoutList = "";
        ObjUserPref userPrefDoc = null;
        try {
            objName = String.valueOf(objName) + "_explore";
            Session session = HibernateUtil.getSessionFactory(tranDB).openSession();
            Query query = session.createQuery("from ObjUserPref where userId='" + loginCode + "' and  objName='" + objName + "' and prefType='" + prefType + "'");
            List userPrefList = query.getResultList();
            BaseLogger.log("3", null, null, "In ObjUserPref getLayoutList data for geting userLayoutList:[" + userPrefList + "]");
            BaseLogger.log("3", null, null, "In ObjUserPref getLayoutList data for geting userLayoutList size:[" + userPrefList.size() + "]");
            int i = 0;
            while (i < userPrefList.size()) {
                userPrefDoc = (ObjUserPref)userPrefList.get(i);
                layoutListBuff.append(userPrefDoc.getPrefName()).append("~~");
                ++i;
            }
            BaseLogger.log("3", null, null, "In ObjUserPref getLayoutList layoutListBuff:[" + layoutListBuff + "]");
            if (layoutListBuff != null && !"".equals(E12GenericUtility.checkNull(layoutListBuff.toString())) && "~~".equals(layoutListBuff.substring(layoutListBuff.length() - 2))) {
                layoutList = layoutListBuff.substring(0, layoutListBuff.length() - 2);
            }
            BaseLogger.log("3", null, null, "In ObjUserPref getLayoutList layoutList:[" + layoutList + "]");
        }
        catch (HibernateException e) {
            BaseLogger.log("0", null, null, "HibernateException :");
            BaseLogger.log("0", null, null, e.getMessage());
            BaseLogger.log("0", null, null, "In ObjUserPref getLayoutList HibernateException : [" + e.getMessage() + "]");
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "In ObjUserPref getLayoutList Exception : [" + e.getMessage() + "]");
        }
        return layoutList;
    }
}

