package ibase.webitm.ejb.wsfa.masters;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;



//developed by Bhagyashri for define Campaign type[15-12-2020][W20ISUN021]
public class CampaignType extends ValidatorEJB

{

	public String wfValData() throws  ITMException
	{
		return "";
	}

	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams) throws  ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = null;
		GenericUtility genericUtility = GenericUtility.getInstance();
		try
		{
			System.out.println("Entering into CampaignType wfValdata1");
			System.out.println("xmlString::::: ["+xmlString+"]");
			System.out.println("xmlString:::::1 ["+xmlString1+"]");
			System.out.println("xmlString:::::2 ["+xmlString2+"]");
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString);
				System.out.println("xmlString::::: dom ["+xmlString+"]");
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1);
				System.out.println("xmlString::::1 dom1 ["+xmlString+"]");
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2);
				System.out.println("xmlString::::1 dom2 ["+xmlString+"]");
			}
			errString = wfValData(dom, dom1, dom2, objContext, editFlag, xtraParams);
			System.out.println ( "ErrString: " + errString);
		}
		catch(Exception e)
		{
			System.out.println ( "Exception:EventConfigEJB:wfValData(String xmlString): " + e.getMessage() + ":" );
			errString = genericUtility.createErrorString(e);
			e.printStackTrace();
		}
		System.out.println ( "Returning from EventConfigEJB CampaignType:wfValData" );
		return (errString);
	}


	
	public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String editFlag, String xtraParams) throws  ITMException
	{
		System.out.println("Entering into CampaignType wfValdata2");
		NodeList ParentNodeList = null;
        NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;
		String childNodeName = null;
        String userId = "";
        String errString = "";
		String sql = "";
		int cnt = 0;
		int ctr = 0;
		String columnValue = "";
		String campaignType = "";
		String descr = "";
		int currentFormNo = 0;
		Connection conn=null;
		PreparedStatement pstmt = null;
		PreparedStatement pstmt1 = null;
		ResultSet rs = null;
		ResultSet rs1 = null;
		boolean isLocalConn=false;   
		
		GenericUtility genericUtility = GenericUtility.getInstance();
		try
		{
			System.out.println("Entering into try of CampaignType wfValdata");
			conn = getConnection();
			System.out.println("editFlag::::::["+editFlag+"]");
			userId = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" );
			System.out.println("userId::::::["+userId+"]");

			if ( objContext != null && objContext.trim().length() > 0 )
			{
				currentFormNo = Integer.parseInt( objContext );
			}
			
			System.out.println("currentFormNo::::::"+currentFormNo);
			
			switch ( currentFormNo )
			{
				case 1:
				System.out.println("------------------Inside case 1------------------");
				parentList = dom.getElementsByTagName( "Detail" + currentFormNo );
				childList = parentList.item( 0 ).getChildNodes();
				int noOfChilds = childList.getLength();
				System.out.println("noOfChilds::::::"+noOfChilds);
				for ( ctr = 0; ctr < noOfChilds; ctr++)
				{
					childNode = childList.item(ctr);
					childNodeName = childNode.getNodeName();
					if(childNodeName.equalsIgnoreCase("campaign_type"))
					{
						if(childNode.getFirstChild() == null )
						{
							errString = getErrorString("campaign_type","NULLCAMP",userId);
						}
						else
						{
							campaignType = checkNull(genericUtility.getColumnValue( "campaign_type", dom ));
							
							cnt = 0;
							if ( editFlag != null && "A".equalsIgnoreCase(editFlag.trim()) )
							{
								sql = "SELECT COUNT(*) AS COUNT FROM CAMPAIGN_TYPE WHERE CAMPAIGN_TYPE = ?";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, campaignType);
								rs = pstmt.executeQuery();
								if( rs.next() )
								{
									cnt = rs.getInt("COUNT");
								}
								if(rs!=null)
								{
									rs.close();
									rs = null;
								}
								if(pstmt!=null)
								{
									pstmt.close();
									pstmt = null;
								}
								if(cnt!= 0)
								{
										errString = getErrorString("campaign_type","CAMPEXIST",userId); // EXIST
										break;
								}
							}

						} // end else 
					} // end if
					else if(childNodeName.equalsIgnoreCase("descr"))
					{
						if(childNode.getFirstChild() == null)				
						{
							errString = getErrorString("descr","NULLDESC",userId);
						}
					}//end else if
				}// end for
				break;
			}  // end switch
		}  // end try 
				
		catch (Exception e)
		{
			System.out.println ( "Exception: EventConfigEJB:CampaignTypewfValData(Document dom): " + e.getMessage() + ":" );
			errString = genericUtility.createErrorString(e);
		}
		finally
		{
			try
			{
				if( rs != null )
				{
					rs.close();
					rs = null;

				}
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;

				}
				if( conn != null )
				{
					conn.close();
					conn = null;
                }
			}
			catch(Exception e)
			{
				System.out.println( "Exception :EventConfigEJB:wfValData :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		return (errString);
	}//end of wfvaldata

	public String itemChanged() throws  ITMException
	{
		return "";
	}
	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws  ITMException
	{
		System.out.println("Entering into CampaignType Itemchange1");
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = null;
		GenericUtility genericUtility = GenericUtility.getInstance();
		System.out.println("xmlString ["+xmlString+"]");
		System.out.println("xmlString1 ["+xmlString1+"]");
		System.out.println("xmlString2 ["+xmlString2+"]");
		try
		{
			if (xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString);
			}
			if (xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1);
			}
			if (xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2);
			}
			errString = itemChanged( dom, dom1, dom2, objContext, currentColumn, editFlag, xtraParams );
			System.out.println ( "ErrString :" + errString);
		}
		catch (Exception e)
		{
			System.out.println ( "Exception :EventConfigEJB CampaignType:itemChanged(String,String):" + e.getMessage() + ":" );
			errString = genericUtility.createErrorString(e);
		}
		System.out.println ( "returning from EventConfigEJB CampaignType:itemChanged1" );
		return errString;
	}
	
	public String itemChanged(Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws  ITMException
	{
		System.out.println("Entering into CampaignType Itemchange2");
		int currentFormNo = 0;
		StringBuffer valueXmlString = new StringBuffer();
		GenericUtility genericUtility = GenericUtility.getInstance();
		String addDate="";
		String addUser="";
		String addTerm="";
		String chgDate = "";
		String chgUser = "";
		String chgTerm = "";
		
	    String sql = "";
	    String descr ="";
	    String shDescr ="";
	    String outcomeUnit ="";
	    
	    ResultSet rs = null;
	    PreparedStatement pstmt = null;
	    Connection conn = null;
	
	    try
	    {
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			addDate = sdf.format(new java.util.Date());
			addUser = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "logincode");
			addTerm = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"termId");
			chgDate = sdf.format(new java.util.Date());
			chgUser = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			chgTerm = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"termId");
            
			System.out.println("objContext :::"+objContext);
            if (objContext != null && objContext.trim().length() > 0 )
		    {
			    currentFormNo = Integer.parseInt(objContext);
		    }
            if(conn==null)
			{
			conn = getConnection();
			}
            valueXmlString = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<editFlag>");
			valueXmlString.append(editFlag).append("</editFlag>\r\n</Header>\r\n");
			System.out.println("currentform no"+currentFormNo);
		    switch (currentFormNo)
			{
				case 1:
					valueXmlString.append("<Detail1>\r\n");
					if (currentColumn.equalsIgnoreCase("itm_default"))
					{
					System.out.println("itm_default ["+currentFormNo+"]");
					valueXmlString.append("<chg_date><![CDATA[").append(checkNull(chgDate)).append("]]></chg_date>\r\n");
					valueXmlString.append("<chg_user><![CDATA[").append(checkNull(chgUser)).append("]]></chg_user>\r\n");
					valueXmlString.append("<chg_term><![CDATA[").append(checkNull(chgTerm)).append("]]></chg_term>\r\n");
					}
					else if(currentColumn.equalsIgnoreCase("itm_defaultedit"))
					{
						System.out.println("Inside itm_defaultedit");
					}
					else if(currentColumn.equalsIgnoreCase("campaign_type"))
					{
					String campaignType = checkNull(genericUtility.getColumnValue("campaign_type", dom));
					sql="select descr,sh_descr,outcome_unit from CAMPAIGN_TYPE where campaign_type=?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, campaignType);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
					 descr = rs.getString("descr");
					 shDescr = rs.getString("sh_descr");
					 outcomeUnit = rs.getString("outcome_unit");	 	
					}
					rs.close();
					rs = null;
					pstmt.close();
					System.out.println("Campaign type is ["+campaignType+"]");
					pstmt = null;
					System.out.println();
					valueXmlString.append("<descr><![CDATA[").append(checkNull(descr)).append("]]></descr>\r\n");
					valueXmlString.append("<sh_descr><![CDATA[").append(checkNull(shDescr)).append("]]></sh_descr>\r\n");
					valueXmlString.append("<outcome_unit><![CDATA[").append(checkNull(outcomeUnit)).append("]]></outcome_unit>\r\n");
					}
					valueXmlString.append("</Detail1>\r\n");
					break;		
				} //end of switch
	    }//end of try
        catch(Exception e)
        {
            e.printStackTrace();
			System.out.println("Exception :"+e.getMessage());
			throw new ITMException(e);
        }
        finally
		{
			try
			{
				 if( rs != null)
				{
					rs.close();
					rs = null;
				}
				if( pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(conn != null)
				{
					conn.close();
					conn = null;
				}
			                                                   
			}
			catch(Exception d)
			{
			  d.printStackTrace();
			}
			System.out.println(" CONNECTION is CLOSED");
        }
        System.out.println("valueXmlString:::::"+valueXmlString.toString());
        valueXmlString.append("</Root>\r\n");
		return valueXmlString.toString();
    } // end of itemchange
	
	private String checkNull(String input)
	{
		if (input == null)
		{
			input="";
		}
		return input.trim();
	}
}
	