<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
	<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
	
		<html>

		<head>
			<meta charset="ISO-8859-1">
			<title>Work Manager</title>
			<link rel="stylesheet" href="//code.jquery.com/ui/1.13.1/themes/base/jquery-ui.css">
			<link rel="stylesheet"
				href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
			<script src="https://code.jquery.com/jquery-3.6.0.js"></script>
			<script src="https://code.jquery.com/ui/1.13.1/jquery-ui.js"></script>

			<style type="text/css">
				body {
					size: 100%;
				}

				.center {
					margin: auto;
					width: 80%;
					padding: 10px;
				}

				.column {
					float: left;
					width: 50%;
					padding: 10px;
					height: 300px;
				}

				label {
					font-family: "Google Sans", Arial, sans-serif;
				}

				#empCode {
					font-family: "Google Sans", Arial, sans-serif;
					font-size: 14px;
				}

				.navbar {
					/*font-family: "Google Sans",Arial,sans-serif;*/
					font-family: "Roboto", sans-serif;
				}

				input[type="text"] {
					font-family: "Google Sans", Arial, sans-serif !important;
					font-size: 16px;
					width: 150px;
					border: 1px solid black;
				}

				button {
					font-family: "Google Sans", Arial, sans-serif !important;
					font-size: 14px;
				}

				input[type="date"],
				select {
					font-family: "Google Sans", Arial, sans-serif !important;
					border: 1px solid #c4c4c4;
					border-radius: 5px;
					background-color: #fff;
					padding: 3px 5px;
					box-shadow: inset 0 3px 6px rgba(0, 0, 0, 0.1);
				}

				input[type="submit"] {
					font-size: 16px;
				}

				input[type="button"] {
					font-family: "Google Sans", Arial, sans-serif !important;
				}

				#tableView {
					margin-top: 20px;
				}

				table {
					border-collapse: collapse;
					/* margin: 25px 0;*/
					font-size: 0.9em;
					font-family: "Google Sans", Arial, sans-serif !important;
					min-width: 400px;
					box-shadow: 0 0 20px rgba(0, 0, 0, 0.15);
				}

				table thead tr {
					text-align: left;
				}

				table th,
				table td {
					padding: 12px 15px;
				}

				table tbody tr {
					border-bottom: 1px solid #dddddd;
				}

				table tbody tr:nth-of-type(even) {
					background-color: #f3f3f3;
				}

				table tbody tr.active-row {
					font-weight: bold;
					color: #009879;
				}

				.head {
					font-family: "Google Sans", Arial, sans-serif !important;
					background-color: #009879;
					color: #ffffff;
				}

				table tbody tr:last-of-type {
					border-bottom: 2px solid #009879;
				}

				.headmenu {
					width: 100%;
					height: 100px;
					overflow-x: scroll;
					overflow-y: hidden;
				}

				.container {
					width: 2500px;
				}

				.grid-container {
					display: table;
					width: auto;
					border-spacing: 5px;
				}

				.div-table-row {
					display: table-row;
					width: auto;
					clear: both;
				}

				.div-table-col {
					float: left;
					display: table-column;
					width: 400px;
				}

				.navbar {
					margin-top: -10px;
					background-color: #ddd;
					overflow: hidden;
				}

				.navbar a {
					float: left;
					color: black;
					text-align: center;
					padding: 14px 16px;
					text-decoration: none;
					font-size: 16px;
				}

				.navbar a:hover {
					background-color: green;
					color: #fff;
				}

				.navbar a.select {
					background-color: #04AA6D;
					color: white;
				}

				/* The Modal*/
				.modal {
					display: none;
					/* Hidden by default */
					position: fixed;
					/* Stay in place */
					z-index: 1;
					/* Sit on top */
					/*padding-top: 100px;  Location of the box */
					left: 0;
					top: 0;
					width: 100%;
					/* Full width */
					height: 100%;
					/* Full height */
					overflow: auto;
					/* Enable scroll if needed */
					background-color: rgb(0, 0, 0);
					/* Fallback color */
					background-color: rgba(0, 0, 0, 0.4);
					/* Black w/ opacity */
				}

				.modal-header {
					text-align: center;
				}

				/* Modal Content */
				.modal-content {
					position: relative;
					background-color: #fefefe;
					margin: auto;
					padding: 0;
					border: 1px solid #888;
					width: 40%;
					box-shadow: 0 4px 8px 0 rgba(0, 0, 0, 0.2), 0 6px 20px 0 rgba(0, 0, 0, 0.19);
					-webkit-animation-name: animatetop;
					-webkit-animation-duration: 0.4s;
					animation-name: animatetop;
					animation-duration: 0.4s
				}

				/* The Close Button */
				.close {
					color: #aaaaaa;
					float: right;
					font-size: 28px;
					font-weight: bold;
				}

				.close:hover,
				.close:focus {
					color: #000;
					text-decoration: none;
					cursor: pointer;
				}

				/*Calendar css*/
				.dayBox {
					text-align: top;
				}

				#link {
					margin-top: 100px;
				}

				.dateLabel {
					top: 100px;
				}

				#calendarTable {
					border: 1px solid black !important;
				}

				#calendarTable td {
					padding: 0px 0px !important;
					vertical-align: text-top !important;
				}

				#app-calendar {
					display: grid;
					grid-template-columns: 1fr 1fr 1fr 1fr 1fr 1fr 1fr;
					grid-template-rows: repeat(5, 1fr);
					height: 100%;
					border: 1px solid #d3ecff;
				}

				.day {
					background-color: #fff;
					border: 1px solid #d3ecff;
					width: 100%;
					height: 100%;
				}

				.container1 {
					width: 100%;
					display: flex;
					justify-content: center;
					align-items: center;
				}

				.calendar {
					width: 70rem;
					height: 52rem;
					box-shadow: 0 0.5rem 3rem rgba(0, 0, 0, 0.4);
				}

				.weekdays div {
					width: 100%;
					display: flex;
					justify-content: center;
					align-items: center;
					border: 1px solid black;
				}

				#gantt-chart {
					display: block;
					font-family: 'Roboto';
					font-size: 16px;
				}

				#date-label {
					writing-mode: vertical-rl;
					text-orientation: mixed;
				}

				#chart-table td {
					border: 1px solid black !important;
					padding: 0px 0px !important;
				}

				.desc {
					color: black;
					/*width:70%;*/
				}

				.eng {
					background-color: #696969;
				}

				.holiday {
					background-color: #ffff80;
				}

				.leave {
					background-color: #ff8000;
				}

				.weekend {
					background-color: #87CEFA;
				}

				/*For Loading Icon*/
				#loading-overlay {
					position: fixed;
					top: 0;
					left: 0;
					width: 100%;
					height: 100%;
					background-color: rgba(0, 0, 0, 0.5);
					/* Semi-transparent background */
					z-index: 9999;
					display: none;
					/* Ensure the loading overlay appears on top of other elements */
				}

				#loading-icon {
					position: absolute;
					top: 50%;
					left: 50%;
					transform: translate(-50%, -50%);
					width: 150px;
					/* Adjust the width of the spinner */
					height: 150px;
					/* Adjust the height of the spinner */
					background-image: url(Spinner.svg);
					/* Specify the path to the spinner SVG file */
					background-repeat: no-repeat;
					background-position: center;
				}
			</style>

		</head>

		<body>
			<div id="loading-overlay">
				<div id="loading-icon"></div>
			</div>
			<div class="navbar">
				<a href="#" onClick="workManager('${pageContext.request.contextPath}/emp')">Work Manager</a>
				<a onClick="planView()">View Plan</a>
			</div>
			<div class="center1" id="center1" style="display: none;">

				<form action="/emp" method="POST">
					<div class="grid-container" id="controlls" style="display: block;">
						<div class="div-table-row" style="width: 800px;">
							<div class="div-table-col">
								<label>Team Member</label>
								<select name="empCode" id="empCode" onChange="" multiple>
									<option>Select Employee Code</option>
									<option value="${1} ">All</option>
								</select>
							</div>
							<div class="div-table-col">
								<label>Date From</label> <label style="margin-left: 40px;">Date To</label> <label
									style="margin-left: 50px;">Request ID</label> <input type="text" class="date"
									name="dateFrom" id="datepicker" placeholder="dd-mmm-yyyy"
									style="margin-top: -10px; width: 100px; z-index: 1;" /> <input type="text"
									class="date" name="dateTo" id="datepickerTo" placeholder="dd-mmm-yyyy"
									style="width: 100px; z-index: 1;" /> <input type="text" name="requestid"
									id="requestid" placeholder="Request ID" style="margin-top: 0px" />
							</div>
							<div class="div-table-col">
								<div class="grid-container" style="border-spacing: 0px;">
									<div class="div-table-row">
										<div class="div-table-col" style="width: 100px;">
											<label>Feedback</label>
											<button type="button" id="button" value="viewFeedback()"
												onClick="viewFeedback()">
												<i class="fa fa-table" aria-hidden="true"></i>
											</button>
											<button type="button" onClick="showCalendar()">
												<i class="fa fa-calendar" aria-hidden="true"></i>
											</button>

										</div>
										<div class="div-table-col" style="width: 100px;">
											<label>Plan </label><br />
											<button type="button" id="buttonPlan" value="getPlanReport()"
												onClick="getPlanReport()">
												<i class="fa fa-table" aria-hidden="true"></i>
											</button>
											<button type="button" onClick="showPlanCalendarView()">
												<i class="fa fa-calendar" aria-hidden="true"></i>
											</button>
											<button type="button" onClick="ganttChart()">
												<i class="fa fa-line-chart" aria-hidden="true"></i>
											</button>
										</div>

									</div>
								</div>
							</div>
						</div>
					</div>

					<!-- <div  id="selectedValues" style= "white-space: nowrap; overflow-x: auto; overflow-y: auto; margin-top:0px;text-align:justify;border:1px solid black;"> -->
					<div id="selectedValues"
						style="text-align: justify; border: 1px solid white; margin-top: 10px; width: 100%;">
						<label id="selectedDate"></label> <label id="selected"></label>

					</div>

					<div id="tableView" style="display: block;">
						<table width="100%" id="table">
							<thead>
								<tr class="head">
									<td>Person</td>
									<td>Date</td>
									<td>RequestID</td>
									<td>Descr</td>
									<td>Status</td>
									<td>Action</td>
								</tr>
							</thead>
							<tbody>
							</tbody>
						</table>
					</div>
					<!-- Calendar View -->
					<div id="calendarView" style="display: none;">
						<table id="calendarTable" width=100%>
							<tr>
								<td>MONDAY</td>
								<td>TUESDAY</td>
								<td>WEDNESDAY</td>
								<td>THURSDAY</td>
								<td>FRIDAY</td>
								<td>SATURDAY</td>
								<td>SUNDAY</td>
							</tr>

							<% int d=0; for (int i=1; i <=6; i++) { %>
								<tr>
									<% for (int j=1; j <=7; j++) { if (d !=42) { %>

										<td class="<%=d%>">
											<div class="dayBox" id="<%=d%>"></div>
										</td>
										<% d++; } } %>
								</tr>
								<% } %>

									<tr>
									</tr>
						</table>
					</div>
					<div id="gantt-chart">

						<table id="chart-table">
							<tr id="chart-head">
								<!-- 	<td>Emmployee</td>
					<td>RequestID</td> -->

							</tr>
						</table>
					</div>
				</form>
			</div>



			<!-- Modal Status update -->
			<div id="modal" class="modal">

				<!-- Modal content -->
				<div class="modal-content">
					<span class="close">&times;</span>
					<div class="modal-header">
						<h2>Status Update</h2>

					</div>
					<div class="modal-body">

						<form id="form" action="/ibase/servlet/email" method="POST" enctype="multipart/form-data">
							<div style="margin-left: 10px;">
								<label>Request ID:</label> <label id="requestidhead"></label><br />
								<input type="hidden" name="requestid" id="requestidheadtxt" /> 
								<label>Employee:</label>
								<label id="personhead">Employee:</label>
								<br /> 
								<input type="hidden" name="empcode" id="personheadtxt" /> 
								<label>Description:</label>
								<label id="descriptionhead">Description:</label>
								<input type="hidden" name="description" id="descriptionheadtxt" /> <input type="hidden" name="actiondtl"
									id="actiondtltxt" /> <input type="hidden" name="stdtime" id="stdtimetxt" /> <input
									type="hidden" name="startdate" id="startdatetxt" /> <input type="hidden"
									name="timespend" id="timespendtxt" /> <input type="hidden" name="action"
									id="timespendtxt" value="statusUpdate">

							</div>

							<table width="100%">
								<tr>
									<td><label>New Status</label></td>
									<td><select name="newStatus" id="newStatus">
											<option value="WIP">WIP</option>
											<option value="Hold">Hold</option>
											<option value="DevComplete">DevComplete</option>
											<option value="UT">UT</option>
											<option value="ToQC">ToQC</option>
											<option value="ReWork">ReWork</option>
											<option value="Done">Done</option>
											<option value="Delivered">Delivered</option>
											<option></option>
										</select></td>
								</tr>
								<tr>
									<td><label>Remark/Status</label></td>
									<td><textarea id="remark" rows="3" cols="40"
											placeholder="Enter your current status / Remark" name="newRemark"
											id="newRemark" style="width: 100%;" required></textarea>
									</td>
								</tr>
								<tr>
									<td><label>Hrs Spent Today</label></td>
									<td><input type="number" name="hrsSpendToday" id="hrsSpendToday" placeholder="Hrs"
											style="width: 100px;" required /> <label>Required Hrs</label> <input
											type="number" name="hrsLeft" id="hrsLeft" placeholder="Required Hrs"
											style="width: 100px;" required /></td>
								</tr>
								<tr>
									<td><label>New End Date</label></td>
									<td><input type="text" class="date" name="dateEnd" id="datepickerEnd"
											placeholder="dd/mm/yyyy" /></td>
								</tr>

								<tr>
									<td><label>Additional Email</label></td>
									<td><input type="email" name="additionalEmail" id="additionalEmail"
											placeholder="Additional Email" style="width: 100%;" /></td>
								</tr>

								<tr>
									<td><label>Attachment 1:</label></td>
									<td><input type="file" name="attachment1" id="attachment1" size="50" /></td>
								</tr>
								<tr>
									<td><label>Attachment 2:</label></td>
									<td><input type="file" name="attachment2" id="attachment2" size="50" /></td>
								</tr>
								<tr>
									<td><label>Attachment 3:</label></td>
									<td><input type="file" name="attachment3" id="attachment3" size="50" /></td>
								</tr>
								<tr>
									<td>
										<!-- 	<input type="submit"/> -->
										<button type="button" id="submit" onClick="statusUpdate()">SUBMIT</button>
									</td>
								</tr>
							</table>
						</form>
					</div>
				</div>
			</div>
			<!-- Request Status Modal -->
			<div id="modalReq" class="modal">
				<!-- Modal content -->
				<div class="modal-content">
					<span id="closeReq" class="close">&times;</span>
					<div class="modal-header">
						<h2>Request For Status</h2>
					</div>
					<div class="modal-body">

						<form id="formReq" action="/ibase/servlet/email" method="POST" enctype="multipart/form-data">
							<div style="margin-left: 10px;">
								<label>Request ID:</label> <label id="requestidheadReq"></label><br />

								<input type="hidden" name="requestid" id="requestidheadtxtReq" />

								<label>Employee:</label> <label id="personheadReq">Employee:</label><br />
								<input type="hidden" name="empcode" id="personheadtxtReq" /> <label>Description:</label>
								<label id="descriptionheadReq">Description:</label> <br /> <label>Status:
								</label> <label id="currentStatus"></label>
								<!-- <input type="text" name="currentStatus" id="currentStatus" readonly="readonly"/> -->

								<input type="hidden" name="description" id="descriptionheadtxtReq" />
								<input type="hidden" name="actiondtl" id="actiondtltxtReq" /> <input type="hidden"
									name="stdtime" id="stdtimetxtReq" /> <input type="hidden" name="startdate"
									id="startdatetxtReq" /> <input type="hidden" name="timespend"
									id="timespendtxtReq" /> <input type="hidden" name="action" id="timespendtxt"
									value="statusRequest">

							</div>

							<table width="100%">

								<tr>
									<td><label>Comment</label></td>
									<td><textarea id="remarkReq" rows="3" cols="40" placeholder="Enter Comment"
											name="newRemark" id="newRemark" style="width: 100%;" required></textarea>
									</td>
								</tr>
								<tr>
									<td><label>Email To</label></td>
									<td><input type="email" name="additionalEmail" id="emailTo"
											placeholder="Additional Email" style="width: 100%;" /></td>
								</tr>
								<tr>
									<td>
										<button type="button" id="submit" onClick="requestStatus()">SEND</button>
									</td>
								</tr>
							</table>
						</form>
					</div>
				</div>
			</div>
		</body>

		<script>
			var loadingOverlay = document.getElementById('loading-overlay');
			console.log(loadingOverlay);
			//	loadingOverlay.style.display='none';
			window.addEventListener('load', function () {
				//loadingOverlay.style.display = 'none';
				hideLoadingSpinner();
			});
			function showLoadingSpinner() {
				// Show the loading spinner
				console.log("showing spinner",loadingOverlay);
				loadingSpinner.style.display = 'block';
			}

			function hideLoadingSpinner() {
				// Hide the loading spinner\
				console.log("hiding spinner",loadingOverlay);
				loadingSpinner.style.display = 'none';
			}
			function workManager(url) {
				//loadingOverlay.style.display = 'block';
				showLoadingSpinner();
				document.getElementById("center1").style.display = "block";
				//window.location.href = "/ibase/emp";
				console.log("URl=" + url)
				// var xhr = new XMLHttpRequest();
				// xhr.open('GET', url, true);
				// xhr.send();
				fetch(url)
					.then(response => {
						console.log(response);
						if (!response.ok) {
							throw new Error('Request failed with status: ' + response.status);
						}
						//loadingOverlay.style.display = 'none';
						hideLoadingSpinner();
						return response.json();
					})
					.then(data => {
						//console.log('Response:', data);

						// Loop through the data and populate select options
						var select = document.getElementById('empCode');
						data.forEach(employee => {
							console.log('employee:', employee.name, employee.empcode);
							var option = document.createElement('option');
							option.value = employee.empcode;
							option.textContent = employee.name + " " + employee.empcode;
							select.appendChild(option);

						});
					})
					.catch(error => console.log(error));
				//loadingOverlay.style.display='none';

			}
			function redirect(url) {
				  var link = document.createElement("a");
				  link.href = url;
				  link.style.display = "none";
				  document.body.appendChild(link);
				  link.click();
				}
			function planView() {
				//loadingOverlay.style.display = 'block';
				//showLoadingSpinner();
				console.log("getting plan view");
				//window.location.href = "/ibase/planview";
				var action="plan";
				var xhr = new XMLHttpRequest();
				var url  = "/ibase/planview?action="+encodeURIComponent(action);
				console.log(url"",url);
				xhr.open('GET', url, true);
				xhr.onreadystatechange = function () {
					if (xhr.readyState === 4 && xhr.status === 200) {
						console.log("getting plan view success....");
						// Redirect to the new page
						//window.location.href = '/ibase/webitm/jsp/workManager_planview.jsp';
						//window.location.replace('/ibase/webitm/jsp/workManager_planview.jsp'); 
						redirect('/ibase/webitm/jsp/workManager_planview.jsp');
					}
					else {
						console.log("getting plan view failed");
					}
				};
				xhr.send();
			}
		</script>
		<script type="text/javascript" src="/ibase/webitm/js/workManager_calendar.js"></script>
		<script type="text/javascript" src="/ibase/webitm/js/workmanager.js"></script>

		</html>