/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.utility;

import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.utility.APIUtility;
import ibase.webitm.utility.ITMException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Properties;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.json.JSONObject;

public class E12ExternalAPICall {
    private String sessionID = "";

    public E12ExternalAPICall(String apiName, UserInfoBean userInfo) throws Exception {
        try {
            BaseLogger.log("3", userInfo, null, "E12ExternalAPICall.E12ExternalAPICall() apiName = [" + apiName + "]");
            BaseLogger.log("3", userInfo, null, "E12ExternalAPICall.E12ExternalAPICall() logincode = [" + userInfo.getLoginCode() + "]");
            BaseLogger.log("3", userInfo, null, "E12ExternalAPICall.E12ExternalAPICall() transdb = [" + userInfo.getTransDB() + "]");
            BaseLogger.log("3", userInfo, null, "E12ExternalAPICall.E12ExternalAPICall() enterprise = [" + userInfo.getEnterprise() + "]");
            this.callLoginApiAndSetSession(apiName, userInfo);
            BaseLogger.log("3", userInfo, null, "E12ExternalAPICall.E12ExternalAPICall() sessionID = [" + this.sessionID + "]");
        }
        catch (Exception ex) {
            BaseLogger.log("0", userInfo, null, "E12ExternalAPICall.E12ExternalAPICall() Exception = [" + E12GenericUtility.getStackTrace(ex) + "]");
            throw new ITMException(ex);
        }
    }

    static SSLContext insecureContext() {
        TrustManager[] noopTrustManager = new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] xcs, String string) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] xcs, String string) {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        }};
        try {
            SSLContext sc = SSLContext.getInstance("ssl");
            sc.init(null, noopTrustManager, null);
            return sc;
        }
        catch (KeyManagementException | NoSuchAlgorithmException generalSecurityException) {
            return null;
        }
    }

    private String callLoginApiAndSetSession(String apiName, UserInfoBean userInfo) throws Exception {
        String resposeStr = "";
        Connection connection = null;
        Statement preparedStatement = null;
        ResultSet resultSet = null;
        Statement pstmt = null;
        ResultSet rs = null;
        Statement countpstmt = null;
        ResultSet countrs = null;
        APIUtility apiUtility = new APIUtility();
        String apiKey = "";
        String apiUrl = "";
        String apiProvider = "";
        String apiPurpose = "";
        String apiAuthType = "";
        String apiLoginParameter = "";
        String apiRespType = "";
        String apiType = "";
        String apiScope = "";
        try {
            try {
                ConnDriver connDriver = new ConnDriver();
                connection = connDriver.getConnectDB("Driver");
                DateTimeFormatter dtf = DateTimeFormatter.ofPattern("dd-MMM-yy");
                LocalDateTime now = LocalDateTime.now();
                String sysDate = dtf.format(now);
                String sql = "SELECT COUNT(*) AS COUNT FROM ENT_EXT_API_KEY WHERE ENTERPRISE = ? AND API_NAME = ? AND API_SCOPE = ? AND EFF_FROM <= ? AND (VALID_UPTO = null OR VALID_UPTO = '' OR VALID_UPTO >= ?)";
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, userInfo.getEnterprise());
                pstmt.setString(2, apiName);
                pstmt.setString(3, "E");
                pstmt.setString(4, sysDate);
                pstmt.setString(5, sysDate);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    int count = rs.getInt("COUNT");
                    BaseLogger.log("3", userInfo, null, "E12ExternalAPICall.callLoginApiAndSetSession() api count against enterprise = [" + count + "]");
                    if (count > 0) {
                        sql = "SELECT * FROM ENT_EXT_API_KEY WHERE ENTERPRISE = ? AND API_NAME = ? AND API_SCOPE = ? AND EFF_FROM <= ? AND (VALID_UPTO = null OR VALID_UPTO = '' OR VALID_UPTO >= ?)";
                        preparedStatement = connection.prepareStatement(sql);
                        preparedStatement.setString(1, userInfo.getEnterprise());
                        preparedStatement.setString(2, apiName);
                        preparedStatement.setString(3, "E");
                        preparedStatement.setString(4, sysDate);
                        preparedStatement.setString(5, sysDate);
                        resultSet = preparedStatement.executeQuery();
                        if (resultSet.next()) {
                            apiKey = resultSet.getString("API_KEY");
                            apiUrl = resultSet.getString("API_URL");
                            apiProvider = resultSet.getString("API_PROVIDER");
                            apiPurpose = resultSet.getString("API_PURPOSE");
                            apiAuthType = resultSet.getString("API_AUTH_TYPE");
                            apiLoginParameter = resultSet.getString("API_LOGIN_PARAMETER");
                            apiRespType = resultSet.getString("API_RESP_TYPE");
                            apiType = resultSet.getString("API_TYPE");
                            apiScope = resultSet.getString("API_SCOPE");
                        }
                        resultSet.close();
                        resultSet = null;
                        preparedStatement.close();
                        preparedStatement = null;
                    } else {
                        sql = "SELECT COUNT(*) AS COUNT FROM ENT_EXT_API_KEY WHERE API_NAME = ? AND API_SCOPE = ? AND EFF_FROM <= ? AND (VALID_UPTO = null OR VALID_UPTO = '' OR VALID_UPTO >= ?)";
                        countpstmt = connection.prepareStatement(sql);
                        countpstmt.setString(1, apiName);
                        countpstmt.setString(2, "G");
                        countpstmt.setString(3, sysDate);
                        countpstmt.setString(4, sysDate);
                        countrs = countpstmt.executeQuery();
                        if (countrs.next()) {
                            count = countrs.getInt("COUNT");
                            BaseLogger.log("3", userInfo, null, "E12ExternalAPICall.callLoginApiAndSetSession() api count against global = [" + count + "]");
                            if (count > 0) {
                                sql = "SELECT * FROM ENT_EXT_API_KEY WHERE API_NAME = ? AND API_SCOPE = ? AND EFF_FROM <= ? AND (VALID_UPTO = null OR VALID_UPTO = '' OR VALID_UPTO >= ?)";
                                preparedStatement = connection.prepareStatement(sql);
                                preparedStatement.setString(1, apiName);
                                preparedStatement.setString(2, "G");
                                preparedStatement.setString(3, sysDate);
                                preparedStatement.setString(4, sysDate);
                                resultSet = preparedStatement.executeQuery();
                                if (resultSet.next()) {
                                    apiKey = resultSet.getString("API_KEY");
                                    apiUrl = resultSet.getString("API_URL");
                                    apiProvider = resultSet.getString("API_PROVIDER");
                                    apiPurpose = resultSet.getString("API_PURPOSE");
                                    apiAuthType = resultSet.getString("API_AUTH_TYPE");
                                    apiLoginParameter = resultSet.getString("API_LOGIN_PARAMETER");
                                    apiRespType = resultSet.getString("API_RESP_TYPE");
                                    apiType = resultSet.getString("API_TYPE");
                                    apiScope = resultSet.getString("API_SCOPE");
                                }
                                resultSet.close();
                                resultSet = null;
                                preparedStatement.close();
                                preparedStatement = null;
                            } else {
                                E12GenericUtility e12GenericUtility = new E12GenericUtility();
                                String resultStr = e12GenericUtility.getErrorString("", "INVALIDKEY", userInfo.getLoginCode());
                                String msg = "Valid OpenAI api key is not found against your enterprise " + userInfo.getEnterprise() + ".";
                                resultStr = e12GenericUtility.updateXMLString("description", msg, resultStr, userInfo);
                                BaseLogger.log("3", userInfo, null, "E12ExternalAPICall.callLoginApiAndSetSession() resultStr = [" + resultStr + "]");
                                throw new Exception(resultStr);
                            }
                        }
                        countrs.close();
                        countrs = null;
                        countpstmt.close();
                        countpstmt = null;
                    }
                }
                rs.close();
                rs = null;
                pstmt.close();
                pstmt = null;
                connection.close();
                connection = null;
                BaseLogger.log("3", userInfo, null, "E12ExternalAPICall.callLoginApiAndSetSession() apiName : [" + apiName + "]");
                BaseLogger.log("3", userInfo, null, "E12ExternalAPICall.callLoginApiAndSetSession() apiKey : [" + apiKey + "]");
                BaseLogger.log("3", userInfo, null, "E12ExternalAPICall.callLoginApiAndSetSession() apiUrl : [" + apiUrl + "]");
                BaseLogger.log("3", userInfo, null, "E12ExternalAPICall.callLoginApiAndSetSession() apiProvider : [" + apiProvider + "]");
                BaseLogger.log("3", userInfo, null, "E12ExternalAPICall.callLoginApiAndSetSession() apiPurpose : [" + apiPurpose + "]");
                BaseLogger.log("3", userInfo, null, "E12ExternalAPICall.callLoginApiAndSetSession() apiAuthType : [" + apiAuthType + "]");
                BaseLogger.log("3", userInfo, null, "E12ExternalAPICall.callLoginApiAndSetSession() apiLoginParameter : [" + apiLoginParameter + "]");
                BaseLogger.log("3", userInfo, null, "E12ExternalAPICall.callLoginApiAndSetSession() apiRespType : [" + apiRespType + "]");
                Properties props = System.getProperties();
                props.setProperty("jdk.internal.httpclient.disableHostnameVerification", Boolean.TRUE.toString());
                HttpRequest request = HttpRequest.newBuilder().uri(URI.create(apiUrl)).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(apiLoginParameter)).build();
                HttpClient client = HttpClient.newBuilder().sslContext(E12ExternalAPICall.insecureContext()).build();
                HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
                BaseLogger.log("3", userInfo, null, "E12ExternalAPICall.callLoginApiAndSetSession() Response Status = [" + response.statusCode() + "]");
                BaseLogger.log("3", userInfo, null, "E12ExternalAPICall.callLoginApiAndSetSession() Response Body = [" + response.body() + "]");
                resposeStr = response.body();
                if (resposeStr != null && resposeStr.trim().length() > 0) {
                    JSONObject loginObject = new JSONObject(resposeStr);
                    this.sessionID = loginObject.getString("SessionId");
                    if (loginObject.has("error")) {
                        System.out.print("inside if condition - callLoginApiAndSetSession method");
                        apiUtility.writeApiCallLog(userInfo, resposeStr, "E", "", "", "", apiName, apiUrl, apiScope, apiType, "", "");
                    } else {
                        System.out.print("inside else condition - callLoginApiAndSetSession method");
                        apiUtility.writeApiCallLog(userInfo, resposeStr, "S", "", "", "", apiName, apiUrl, apiScope, apiType, "", "");
                    }
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "E12ExternalAPICall.callLoginApiAndSetSession() Exception = [" + E12GenericUtility.getStackTrace(e) + "]");
                apiUtility.writeApiCallLog(userInfo, E12GenericUtility.getStackTrace(e), "F", "", "", "", apiName, apiUrl, apiScope, apiType, "", "");
                throw new ITMException(e);
            }
        }
        finally {
            if (connection != null) {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                    preparedStatement = null;
                }
                if (resultSet != null) {
                    resultSet.close();
                    resultSet = null;
                }
                if (countpstmt != null) {
                    countpstmt.close();
                    countpstmt = null;
                }
                if (countrs != null) {
                    countrs.close();
                    countrs = null;
                }
                if (connection != null) {
                    connection.close();
                    connection = null;
                }
            }
        }
        return resposeStr;
    }

    public String apiCallToPostData(String apiName, String apiUrl, String apiType, String apiScope, String refID, String refSer, String requestMethod, JSONObject jsonData, UserInfoBean userInfo, String apiLogTranId) throws Exception {
        String resposeStr = "";
        APIUtility apiUtility = new APIUtility();
        try {
            BaseLogger.log("3", userInfo, null, "E12ExternalAPICall.apiCallToPostData() apiName = [" + apiName + "]");
            BaseLogger.log("3", userInfo, null, "E12ExternalAPICall.apiCallToPostData() apiUrl = [" + apiUrl + "]");
            BaseLogger.log("3", userInfo, null, "E12ExternalAPICall.apiCallToPostData() apiType = [" + apiType + "]");
            BaseLogger.log("3", userInfo, null, "E12ExternalAPICall.apiCallToPostData() apiScope = [" + apiScope + "]");
            BaseLogger.log("3", userInfo, null, "E12ExternalAPICall.apiCallToPostData() refID = [" + refID + "]");
            BaseLogger.log("3", userInfo, null, "E12ExternalAPICall.apiCallToPostData() refSer = [" + refSer + "]");
            BaseLogger.log("3", userInfo, null, "E12ExternalAPICall.apiCallToPostD[ata() requestMethod = [" + requestMethod + "]");
            BaseLogger.log("3", userInfo, null, "E12ExternalAPICall.apiCallToPostData() apiLogTranId = [" + apiLogTranId + "]");
            BaseLogger.log("3", userInfo, null, "E12ExternalAPICall.apiCallToPostData() logincode = [" + userInfo.getLoginCode() + "]");
            BaseLogger.log("3", userInfo, null, "E12ExternalAPICall.apiCallToPostData() transdb = [" + userInfo.getTransDB() + "]");
            BaseLogger.log("3", userInfo, null, "E12ExternalAPICall.apiCallToPostData() enterprise = [" + userInfo.getEnterprise() + "]");
            BaseLogger.log("3", userInfo, null, "E12ExternalAPICall.apiCallToPostData() jsonData = [" + jsonData + "]");
            if (this.sessionID == null || this.sessionID.trim().length() == 0) {
                throw new Exception("Invalid Session");
            }
            if ("".equalsIgnoreCase(E12GenericUtility.checkNull(requestMethod))) {
                requestMethod = "POST";
            }
            Properties props = System.getProperties();
            props.setProperty("jdk.internal.httpclient.disableHostnameVerification", Boolean.TRUE.toString());
            String sesStr = "B1SESSION=" + this.sessionID + "; ROUTEID";
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(apiUrl)).header("Content-Type", "application/json").header("Cookie", sesStr).method(requestMethod, HttpRequest.BodyPublishers.ofString(jsonData.toString())).build();
            HttpClient client = HttpClient.newBuilder().sslContext(E12ExternalAPICall.insecureContext()).build();
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            BaseLogger.log("3", userInfo, null, "E12ExternalAPICall.apiCallToPostData() Response Status = [" + response.statusCode() + "]");
            BaseLogger.log("3", userInfo, null, "E12ExternalAPICall.apiCallToPostData() Response Body = [" + response.body() + "]");
            resposeStr = response.body();
            String callStatus = "S";
            if (resposeStr != null && resposeStr.trim().length() > 0) {
                JSONObject responseObject = new JSONObject(resposeStr);
                if (responseObject.has("errorCode")) {
                    System.out.print("Inside errorcode condition");
                    String errorCode = responseObject.optString("errorCode", "");
                    if (errorCode.equals("000")) {
                        System.out.print("Inside if condition- errorcode=000");
                        callStatus = "S";
                    } else {
                        System.out.print("Inside Else condition - errorcode other than 000");
                        callStatus = "E";
                    }
                } else if (responseObject.has("error")) {
                    System.out.print("Inside else if - if object is error");
                    callStatus = "E";
                }
            }
            if ("".equalsIgnoreCase(E12GenericUtility.checkNull(apiLogTranId))) {
                apiUtility.writeApiCallLog(userInfo, resposeStr, callStatus, "", "", jsonData.toString(), apiName, apiUrl, apiScope, apiType, refID, refSer);
            } else {
                apiUtility.updateApiCallLog(userInfo, resposeStr, callStatus, "", "", jsonData.toString(), apiName, apiUrl, apiScope, apiType, refID, refSer, apiLogTranId);
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", userInfo, null, "E12ExternalAPICall.apiCallToPostData() Exception = [" + E12GenericUtility.getStackTrace(e) + "]");
            if ("".equalsIgnoreCase(E12GenericUtility.checkNull(apiLogTranId))) {
                apiUtility.writeApiCallLog(userInfo, E12GenericUtility.getStackTrace(e), "F", "", "", jsonData.toString(), apiName, apiUrl, apiScope, apiType, refID, refSer);
            } else {
                apiUtility.updateApiCallLog(userInfo, E12GenericUtility.getStackTrace(e), "F", "", "", jsonData.toString(), apiName, apiUrl, apiScope, apiType, refID, refSer, apiLogTranId);
            }
            throw new ITMException(e);
        }
        return resposeStr;
    }
}

