/*
 * Decompiled with CFR 0.152.
 */
package ibase.servlet;

import ibase.entity.Employee;
import ibase.entity.Report;
import ibase.entity.TodaysPlan;
import ibase.util.EmployeeDao;
import ibase.utility.BaseLogger;
import java.text.SimpleDateFormat;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@WebServlet(value={"/view"})
public class View
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    EmployeeDao empDao;
    List<Report> yesterdayList = new ArrayList<Report>();
    List<Report> feedbackList = new ArrayList<Report>();
    List<Employee> empList;
    List<TodaysPlan> todaysPlanList = new ArrayList<TodaysPlan>();

    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        try {
            this.empDao = new EmployeeDao();
            this.yesterdayList = this.empDao.getYesterdayFeedback2();
            this.empList = this.empDao.getEmpList();
            this.feedbackList.clear();
            for (Employee emp : this.empList) {
                this.feedbackList.addAll(this.getReport(emp.getName(), emp.getEmpcode()));
            }
            this.todaysPlanList = this.calculateEndDate(this.empDao.getTodysPlan());
            request.setAttribute("feedbackList", this.feedbackList);
            request.setAttribute("todaysplan", this.todaysPlanList);
            RequestDispatcher dispatcher = request.getRequestDispatcher("/ibase/webitm/jsp/workManager/view.jsp");
            dispatcher.forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private List<TodaysPlan> calculateEndDate(List<TodaysPlan> todysPlan) {
        ArrayList<TodaysPlan> list = new ArrayList<TodaysPlan>();
        for (TodaysPlan plan : todysPlan) {
            plan.setEndDate(this.getEndDate(plan.getTime(), plan.getDate()));
            list.add(plan);
        }
        return list;
    }

    private List<Report> getReport(String emp, String empcode) {
        ArrayList<Report> list = new ArrayList<Report>();
        for (Report report : this.yesterdayList) {
            if (!report.getPerson().substring(report.getPerson().indexOf("(") + 1, report.getPerson().indexOf(")")).equals(empcode)) continue;
            list.add(report);
        }
        if (list.isEmpty()) {
            Report rt = new Report();
            rt.setPerson(String.valueOf(emp) + "(" + empcode + ")");
            rt.setRequestId("Not yet");
            list.add(rt);
            return list;
        }
        return list;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
    }

    String getEndDate(int stdtime, String startDate) {
        try {
            int time = (int)Math.ceil(stdtime / 9);
            SimpleDateFormat formate = new SimpleDateFormat("d-MMM-yyyy");
            Date dateStart = formate.parse(startDate);
            Calendar cal = Calendar.getInstance();
            cal.setTime(dateStart);
            cal.add(5, time);
            LocalDate start = LocalDateTime.ofInstant(cal.toInstant(), cal.getTimeZone().toZoneId()).toLocalDate();
            LocalDate end = start.plusDays(time);
            int i = 0;
            LocalDate date = start;
            while (date.isBefore(end)) {
                DayOfWeek day = date.getDayOfWeek();
                if (day.getValue() == 6 || day.getValue() == 7) {
                    ++i;
                }
                date = date.plusDays(1L);
            }
            end = start.plusDays(time += i);
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd-MMM-YYYY");
            return formatter.format(end);
        }
        catch (Exception e) {
            BaseLogger.log((String)"0", null, null, (Object)("Error.." + e.getMessage()));
            e.printStackTrace();
            return "";
        }
    }
}

