package ibase.webitm.bean.wsfa;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
//Nazia 9-5-07
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Vector;

import ibase.system.config.ConnDriver;
import ibase.utility.UserInfoBean;
import ibase.webitm.utility.wsfa.DBOperations;
import ibase.webitm.utility.wsfa.DateObject;
import ibase.webitm.utility.wsfa.DateUtilities;
import ibase.webitm.utility.wsfa.Utilities;



/**
  * Class DailyVisit - <br>
  * This class consists of all Queries applied to Dailly Visit in total
  *
  * @author Avinash Deshmukh
  * @version 1.0
  * @since Mar 11, 2002
  * History of change
  */

//Changed by Nazia on 29-Mar-08 [as Connection object is passed by  DBConnection and it causing max cursor exceedede exception so connection object is created in current class]
//public class DailyVisit 
public class DailyVisit // implements DBDriverInterface
{
	private String todaysDate ;
	//changed by Nazia on 29-Mar-08 [To store 29-Mar-08,username,password]
	private String driverName ;
	private String username ;
	private String password ;
	private String  dbUrl;
	//Changed by NAzia on 16-Apr-08 [store report mssing info ]
	private  String msgReportDays = "";
	private String isReportMissing = "true";
	private Connection con = null;
	private UserInfoBean userInfo = null;
	
	public DailyVisit( UserInfoBean userInfo )
	{
		try
		{
			this.userInfo = userInfo;
			DateUtilities dut = new DateUtilities();
			dut.setFormatString("dd/MMM/yyyy hh:mm aaa");
			todaysDate = dut.getCurrentDate();
			//DBConnection dbcon = new DBConnection();
			//con = dbcon.getConnection();
			/*ConnDriver connDriver = new ConnDriver();

			if( userInfo !=null )
			{
				this.userInfo = userInfo; 
				if ( con == null )
				{
					con = connDriver.getConnectDB( userInfo.getTransDB() );
				}
			}*/
		}
		catch( Exception ex )
		{
			ex.printStackTrace();
		}
	}
	
	/*public DailyVisit( Connection connect )
	{
		try
		{
			DateUtilities dut = new DateUtilities();
			dut.setFormatString("dd/MMM/yyyy hh:mm aaa");
			todaysDate = dut.getCurrentDate();
			//DBConnection dbcon = new DBConnection();
			con = connect;
		}
		catch( Exception ex )
		{
			ex.printStackTrace();
		}
		
		
	}*/


	/** 
	 * This method UPDATES the complition flag( COMPLETION_FLAG) from the DR_MAIN for particular salesCode for particular date
	 *
	 * @param   workDate   
	 * @param   salesCode   
	 * @param   connection   
	 * @return  
	 */
	public void updateCompFlag ( String workDate,String salesCode) throws Exception
	{
		System.out.println("DailyVisit.java : updating completion flag ....");
		DBOperations dbOpr = new DBOperations( userInfo );
		HashMap whereHm = new HashMap();
		whereHm.put("SALES_PERS", salesCode);
		whereHm.put("WORK_DATE", workDate);
		HashMap setHm = new HashMap();
		setHm.put("COMPLETION_FLAG", "Y");
		int result = dbOpr.update("DR_MAIN", setHm,whereHm);
		System.out.println(" Record is updated with result value ["+result+"]");
		//MLogger.writeToLog("The no of records updated in dr_main "+result,Logger.LOG_LEVEL_DEBUG,"DailyVisit.java","updateCompFlag");
	}
	
	// method to verify that NCL Doctor is visited by any other PSR anytime
	public boolean checkNCLDoctorVisited( String salesCode,String scCode) throws Exception
	{
		System.out.println("DailyVisit.java : Checking for nonCallListDoctor visit  ....");
        ResultSet rs = null;
        Statement stmt = null;
		Connection con = getConnection();
        

		int count=0;
		String query = "SELECT COUNT(*) FROM DR_DOCTOR_VISIT WHERE "+
							" SC_CODE = '"+ scCode + "' AND SALES_PERS = '"+ salesCode + "'";
		//MLogger.writeDBLog("execute query "+ query, Logger.LOG_LEVEL_DEBUG, "DailyVisit.java", "checkNCLDoctorVisited");
		try
		{
			stmt = con.createStatement();
			rs = stmt.executeQuery(query);
			while(rs.next())
			{
				count = rs.getInt(1);
			}
			if (rs!=null)
			{
				rs.close();
				rs = null;
			}
			if (stmt!=null)
			{
				stmt.close();
				stmt = null;
			}
			if(con !=null)
			{
				con.close();
				con = null;
			}
		}
		catch(Exception e)
		{
			throw e;
		}
		finally
		{			
			if (rs!=null)
			{
				rs.close();
				rs = null;
			}
			if (stmt!=null)
			{
				stmt.close();
				stmt = null;
			}
			if(con !=null)
			{
				con.close();
				con = null;
			}	
			
		}
		if(count==0 || count==1)
			return true;
		else
			return  false;
	}
/** 
 * This method DELETS all the records of NCL DOCTOR Related tables data of daily report for particular salesCode for particular date
 *
 * @param   workDate   
 * @param   salesCode   
 * @param   connection   
 * @return  
 */

	public void deleteNCLDoctorFromDB( String salesCode,String scCode) throws Exception
	{
		System.out.println("DailyVisit.java : Deleting NonCallListDoctor from DB ....");
		int result = 0;
		//deleting from NCL_STRG_CUSTOMER
		Connection con = getConnection();
		DBOperations dbOpr = new DBOperations( con );
		HashMap whereHm = new HashMap();
		whereHm.put("SC_CODE", scCode);
		result = dbOpr.delete("NCL_STRG_CUSTOMER",whereHm);
		//MLogger.writeToLog("The no of records deleted from NCL_STRG_CUSTOMER "+result,Logger.LOG_LEVEL_DEBUG,"DailyVisit.java","deleteNCLDoctorFromDB()");
		whereHm = null;
		//deleting from NCL_STRG_SPECIALITY
		whereHm = new HashMap();
		whereHm.put("SC_CODE", scCode);
		result = dbOpr.delete("NCL_STRG_SPECIALITY",whereHm);
		//MLogger.writeToLog("The no of records deleted from NCL_STRG_SPECIALITY "+result,Logger.LOG_LEVEL_DEBUG,"DailyVisit.java","deleteNCLDoctorFromDB()");
		whereHm = null;
		//deleting from NCL_STRG_QUALIFICATION
		whereHm = new HashMap();
		whereHm.put("SC_CODE", scCode);
		result = dbOpr.delete("NCL_STRG_QUALIFICATION",whereHm);
		//MLogger.writeToLog("The no of records deleted from NCL_STRG_QUALIFICATION "+result,Logger.LOG_LEVEL_DEBUG,"DailyVisit.java","deleteNCLDoctorFromDB()");
		whereHm = null;
		//deleting from NCL_DOCTOR_MAIN
		whereHm = new HashMap();
		whereHm.put("SALES_PERS", salesCode);
		whereHm.put("SC_CODE", scCode);
		result = dbOpr.delete("NCL_DOCTOR_MAIN",whereHm);
		//MLogger.writeToLog("The no of records deleted from NCL_DOCTOR_MAIN "+result,Logger.LOG_LEVEL_DEBUG,"DailyVisit.java","deleteNCLDoctorFromDB()");
		whereHm = null;
		
		if(dbOpr.con  != null) 
		{
			dbOpr.removeCon();
		}
	}  

	/** 
	 * This method selects the complition flag( COMPLETION_FLAG) from the DR_MAIN for particular salesCode for particular date
	 *
	 * @param   workDate   
	 * @param   salesCode   
	 * @param   connection   
	 * @return  
	 */
	public String checkCompFlag ( String workDate,String salesCode) throws Exception
	{
		System.out.println("DailyVisit.java : Checking for completion flag ....");

		ResultSet rs = null;
        Statement stmt = null;
		Connection con = getConnection();
		String compFlag = "";
		String checkCompFlagQuery = " SELECT COMPLETION_FLAG FROM DR_MAIN WHERE  " +
					                            " WORK_DATE='"+ workDate +"' AND SALES_PERS = '"+ salesCode + "'";
		//MLogger.writeDBLog("execute query "+ checkCompFlagQuery, Logger.LOG_LEVEL_DEBUG, "DailyVisit.java", "checkCompFlag");
		try
		{
			stmt = con.createStatement();
			rs = stmt.executeQuery(checkCompFlagQuery);
			while(rs.next())
			{
				System.out.println("DailyVisit checkCompFlag ():: COMPLETION_FLAG VAL IN WHILE["+rs.getString("COMPLETION_FLAG")+"]");
				compFlag = Utilities.checkNull(rs.getString("COMPLETION_FLAG"));
			}
			System.out.println("DailyVisit checkCompFlag ()::compFlag["+compFlag+"]");				
			if (rs!=null)
			{
				rs.close();
				rs = null;
			}
			if (stmt!=null)
			{
				stmt.close();
				stmt = null;
			}
			if(con !=null)
			{
				con.close();
				con = null;
			}
		}		
		catch(Exception e)
		{
			throw e;
		}
		finally
		{
			if (rs!=null)
			{
				rs.close();
				rs = null;
			}
			if (stmt!=null)
			{
				stmt.close();
				stmt = null;
			}
			if(con !=null)
			{
				con.close();
				con = null;
			}			
		}
		//MLogger.writeDBLog("COMPLETION_FLAG "+compFlag, Logger.LOG_LEVEL_DEBUG, "DailyVisit.java", "checkCompFlag");
		return compFlag;
	}

	public String reportCompFlag ( String workDate,String salesCode) throws Exception
	{
		System.out.println("DailyVisit.java : removing completion flag ....");

		Connection con = getConnection();
		ResultSet rs = null;
		Statement stDoctorVisit = null;
		Statement stmt = null;
		String sqlDoctorVisit  = "";
		String sqlChemistVisit = "";
		String sqlStockistVisit = "";
		String sqlSampleDis = "";
		String sqlMain = "";
		String sqlTravelDet = "";
		String reportFlag ="false";
		String activityDescr="";
		String flagTravel="false";
		try
		{
			sqlTravelDet =" SELECT DTD.ACTIVITY_CODE,FA.ACTIVITY_TYPE FROM DR_TRAVEL_DETAILS DTD, "
								+" FIELDACTIVITY FA WHERE DTD.SALES_PERS='"+salesCode+"'" 
								+"	AND DTD.WORK_DATE='"+workDate+"'"
								+"	AND DTD.ACTIVITY_CODE= FA.ACTIVITY_CODE";
			stmt = con.createStatement();
			rs= stmt.executeQuery(sqlTravelDet);
			while(rs.next())
			{
				activityDescr =rs.getString("ACTIVITY_TYPE");
			}
			if (rs!=null)
			{
				rs.close();
				stmt.close();
			}
			if(activityDescr.equalsIgnoreCase("FW"))
			{
				sqlDoctorVisit = " SELECT COUNT(*) FROM DR_DOCTOR_VISIT  WHERE WORK_DATE='"+workDate+"'" 
									+" AND SALES_PERS='"+salesCode +"'";
				stmt = con.createStatement();
				rs= stmt.executeQuery(sqlDoctorVisit);
				while(rs.next())
				{
					if(rs.getInt(1) > 0)
					{											
						reportFlag= "true";
					}
				}
				if (rs!=null)
				{
					rs.close();
					stmt.close();
				}
				if (reportFlag == "false")
				{
					sqlChemistVisit =" SELECT COUNT(*) FROM DR_CHEMIST_VISIT WHERE WORK_DATE='"+workDate+"'"
										 +" AND SALES_PERS='"+salesCode+"'";
					stmt = con.createStatement();
					rs= stmt.executeQuery(sqlChemistVisit);
					while(rs.next())
					{
						if(rs.getInt(1) > 0)
						{
							reportFlag = "true";
						}
					}
					if (rs!=null)
					{
						rs.close();
						stmt.close();
					}
				}

				if (reportFlag == "false")
				{

					sqlStockistVisit =" SELECT COUNT(*) FROM DR_STOCKIST_VISIT WHERE WORK_DATE='"+workDate+"'"
										+" AND SALES_PERS='"+salesCode+"'";
					stmt = con.createStatement();
					rs= stmt.executeQuery(sqlStockistVisit);
					while(rs.next())
					{
						if(rs.getInt(1) > 0)
						{
							reportFlag= "true";
						}
					}
					if (rs!=null)
					{
						rs.close();
					}
					if (stmt!=null)
					{
						stmt.close();
					}
				}
			} //FW end
			else
			{
				reportFlag= "true";
			}
		}//end try 
		catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			if (rs!=null)
			{
				rs.close();
				rs = null;
			}
			if (stmt!=null)
			{
				stmt.close();
				stmt = null;
			}
			if(con !=null)
			{
				con.close();
				con = null;
			}
		}

		return reportFlag;
	}

	/** 
	 * This method DELETS all the records of daily report for particular salesCode for particular date
	 *
	 * @param   workDate   
	 * @param   salesCode   
	 * @param   connection   
	 * @return  
	 */
	public void deleteReport( String workDate,String salesCode) throws Exception
	{
		System.out.println("DailyVisit.java : deleting Report ....");

		int result = 0;
		
		Connection con = getConnection();

		//deleting from DR_TRAVEL_DETAILS
		DBOperations dbOpr = new DBOperations( con );
		HashMap whereHm = new HashMap();
		whereHm.put("SALES_PERS", salesCode);
		whereHm.put("WORK_DATE", workDate);
		result = dbOpr.delete("DR_TRAVEL_DETAILS",whereHm);
		//MLogger.writeToLog("The no of records deleted from DR_TRAVEL_DETAILS "+result,Logger.LOG_LEVEL_DEBUG,"DailyVisit.java","deleteReport()");
		whereHm = null;

		//deleting from DR_DOCTOR_VISIT
		whereHm = new HashMap();
		whereHm.put("SALES_PERS", salesCode);
		whereHm.put("WORK_DATE", workDate);
		result = dbOpr.delete("DR_DOCTOR_VISIT",whereHm);
		//MLogger.writeToLog("The no of records deleted from DR_DOCTOR_VISIT "+result,Logger.LOG_LEVEL_DEBUG,"DailyVisit.java","deleteReport()");
		whereHm = null;

		//deleting from DR_SAMPLE_DISTRIBUTED
		whereHm = new HashMap();
		whereHm.put("SALES_PERS", salesCode);
		whereHm.put("WORK_DATE", workDate);
		result = dbOpr.delete("DR_SAMPLE_DISTRIBUTED",whereHm);
		//MLogger.writeToLog("The no of records deleted from DR_SAMPLE_DISTRIBUTED "+result,Logger.LOG_LEVEL_DEBUG,"DailyVisit.java","deleteReport()");

		whereHm = null;

		//deleting from DR_STOCKIST_VISIT
		whereHm = new HashMap();
		whereHm.put("SALES_PERS", salesCode);
		whereHm.put("WORK_DATE", workDate);
		result = dbOpr.delete("DR_STOCKIST_VISIT",whereHm);
		//MLogger.writeToLog("The no of records deleted from DR_STOCKIST_VISIT "+result,Logger.LOG_LEVEL_DEBUG,"DailyVisit.java","deleteReport()");
		whereHm = null;

		//dele	ting from DR_INVOICE_DETAILS
		whereHm = new HashMap();
		whereHm.put("UPDATED_BY", salesCode);
		whereHm.put("WORK_DATE", workDate);
		result = dbOpr.delete("DR_INVOICE_DETAILS",whereHm);
		//MLogger.writeToLog("The no of records deleted from DR_INVOICE_DETAILS "+result,Logger.LOG_LEVEL_DEBUG,"DailyVisit.java","deleteReport()");

		whereHm = null;

		//deleting from DR_CHEMIST_VISIT
		whereHm = new HashMap();
		whereHm.put("SALES_PERS", salesCode);
		whereHm.put("WORK_DATE", workDate);
		result = dbOpr.delete("DR_CHEMIST_VISIT",whereHm);
		//MLogger.writeToLog("The no of records deleted from DR_CHEMIST_VISIT "+result,Logger.LOG_LEVEL_DEBUG,"DailyVisit.java","deleteReport()");
		whereHm = null;

		//deleting from DR_CONS_RECIEVED
		whereHm = new HashMap();
		whereHm.put("SALES_PERS", salesCode);
		whereHm.put("WORK_DATE", workDate);
		result = dbOpr.delete("DR_CONS_RECIEVED",whereHm);
		//MLogger.writeToLog("The no of records deleted from DR_CONS_RECIEVED "+result,Logger.LOG_LEVEL_DEBUG,"DailyVisit.java","deleteReport()");
		whereHm = null;
	
		//deleting from DR_MAIN at 
		whereHm = new HashMap();
		whereHm.put("SALES_PERS", salesCode);
		whereHm.put("WORK_DATE", workDate);
		result = dbOpr.delete("DR_MAIN",whereHm);
		//MLogger.writeToLog("The no of records deleted from DR_MAIN "+result,Logger.LOG_LEVEL_DEBUG,"DailyVisit.java","deleteReport()");
		whereHm = null;
		if(dbOpr.con  != null) 
		{
			dbOpr.removeCon();
		}
	 }

	//Changed by Nazia on 17/03/2008 [New function to update item_ser,designation in dr_main of user who confirms report.WS78SUN034]start

	//Changed by Nazia on 18-Aug-2008[ Changed function name WS89SUN011]
	//public void updateDivDesig(DBConnection dbCon,String workDate,String salesCode)throws Exception
	public void updateDrMainEmpInfo( String workDate,String salesCode)throws Exception
	{
		System.out.println("DailyVisit.java : updating item_ser,designation in dr_main ....");
		ResultSet rs = null;
		Statement stmt = null;
		Connection con = getConnection();		
		HashMap whereHm = new HashMap();
		HashMap setHm = new HashMap();
		try
			{	
			//Changed by Nazia on 18-Aug-2008[Added new columns in sql GRADE,STAN_CODE__HQ,REPORT_TO]
				/*String itemSerQuery = " SELECT ITEM_SER ,DESIGNATION ,EMP.EMP_CODE FROM SALES_PERS SP ,EMPLOYEE 	"+	
									 " EMP WHERE SP.SALES_PERS ='"+salesCode+"'AND EMP.EMP_CODE =SP.EMP_CODE";*/

				String itemSerQuery = " SELECT ITEM_SER ,DESIGNATION ,EMP.EMP_CODE ,GRADE,STAN_CODE__HQ " +
									  "	,REPORT_TO " +
									  " FROM SALES_PERS SP ,EMPLOYEE EMP	" +										
									  "	WHERE " +
									  "		EMP.EMP_CODE  =SP.EMP_CODE " +
									  " 	AND SP.SALES_PERS ='"+salesCode+"'" ;
				
				DBOperations dbOpr = new DBOperations( con );
				stmt = con.createStatement();								
				rs = stmt.executeQuery(itemSerQuery);
				if(rs.next())
				{					
					setHm.put("ITEM_SER", rs.getString("ITEM_SER"));					
					setHm.put("DESIGNATION", rs.getString("DESIGNATION"));					
					setHm.put("GRADE", rs.getString("GRADE"));					
					setHm.put("STAN_CODE__HQ", rs.getString("STAN_CODE__HQ"));					
					setHm.put("REPORT_TO", rs.getString("REPORT_TO"));					
				}						
				System.out.println("DailyVisit:: Columns to update ["+setHm+"]");

				whereHm.put("SALES_PERS", salesCode);
				whereHm.put("WORK_DATE", workDate);								
				int result = dbOpr.update("DR_MAIN", setHm,whereHm);
				//MLogger.writeToLog("The no of records updated in dr_main "+result,Logger.LOG_LEVEL_DEBUG,"DailyVisit.java","updateCompFlag");	
				if (rs!=null)
				{
					rs.close();
					rs = null;
				}
				if (stmt!=null)
				{
					stmt.close();
					stmt = null;
				}
				if(con !=null)
				{
					con.close();
					con = null;
				}	
				if(dbOpr.con  != null) 
				{
					dbOpr.removeCon();
				}
			}
			catch(Exception e)
			{
				throw e;				
			}
			finally
			{
				if (rs!=null)
				{
					rs.close();
					rs = null;
				}
				if (stmt!=null)
				{
					stmt.close();
					stmt = null;
				}
				if(con !=null)
				{
					con.close();
					con = null;
				}			
			}
		
	}
//Changed by Nazia on 17/03/2008 [New function to update item_ser,designation in dr_main of user who confirms report.WS78SUN034]end

	/** 
	 * This method the checks whether workDate is holiday 
	 *
	 * @param   workDate   
	 * @param   salesCode   
	 * @param   connection   
	 * @return  
	 */

	public boolean checkHoliday( String workDate,String salesCode) throws Exception
	{	
		System.out.println("DailyVisit.java : Checking for Holiday ....workDate ["+workDate+"]");
		ResultSet rs = null;
		Statement stmt = null;
		Connection con = getConnection();
		String holDate = "" ;
		
		ResultSet rsPrd = null;
		Statement stmtPrd = null;
		String prdCodeFr ="";	
		String prdCodeTo ="";	
		String periodFrSql = "SELECT CODE FROM PERIOD WHERE '" + workDate + "' BETWEEN FR_DATE AND TO_DATE";
		String periodToSql = "SELECT CODE FROM PERIOD WHERE '" + workDate + "' BETWEEN FR_DATE AND TO_DATE";
		//29-Mar-08		
		//DBConnection dbConnection = new DBConnection();
		try
		{			
			stmtPrd = con.createStatement();
			rsPrd = stmtPrd.executeQuery(periodFrSql);
			while(rsPrd.next())
			{
				prdCodeFr = rsPrd.getString("CODE");
			}//changed by Nazia on 29-Mar-08			
			if (rsPrd!=null)
			{
				rsPrd.close();
			}
			if (stmtPrd!=null)
			{
				//rsPrd.close();
				stmtPrd.close();
			}
		}
		catch(Exception e)
		{
			throw e;
		}			
		try
		{	
			stmtPrd = con.createStatement();
			rsPrd = stmtPrd.executeQuery(periodToSql);
			while(rsPrd.next())
			{
				prdCodeTo = rsPrd.getString("CODE");
			}
			//changed by Nazia on 29-Mar-08
			/*if (rsPrd!=null)
			{
				rsPrd.close();
				stmtPrd.close();
			}*/
			if (stmtPrd!=null)
			{
				rsPrd.close();
				stmtPrd.close();
			}
			
		}
		catch(Exception e)
		{
			throw e;
		}
		//Changed by  on 05/10/2007 for [as per Nilesh Parikh Requirement to remove  DDF_GET_EMP_HOLIDAY] start
		/*String selHolidayQuery =" SELECT DDF_GET_EMP_HOLIDAY('"+salesCode+"',"+
										" '"+prdCodeFr+"','"+prdCodeTo+"' ,'"+workDate+"') HOLDATE FROM DUAL ";		*/
		String selHolidayQuery="SELECT DISTINCT TO_CHAR (HOL_DATE,'DD-MON-YYYY') A_HOL_DATE FROM HOLIDAY  " +
								" WHERE HOL_TBLNO = DDF_GET_HOLTBLNO('"+ salesCode +" ','"+ workDate +"') " +
								" AND HOL_DATE = '"+ workDate + "'"; 
		//Changed by Nazia on 05/10/2007 end

		//MLogger.writeDBLog("Execute Query "+ selHolidayQuery, Logger.LOG_LEVEL_DEBUG, "DailyVisit.java", "checkHoliday");
		try
		{//29-Mar-08
			stmt = con.createStatement();
			rs = stmt.executeQuery(selHolidayQuery);			
			while(rs.next())
			{
				holDate = Utilities.checkNull(rs.getString(1));
			}
			if (rs!=null)
			{
				rs.close();
			}
			if (stmt!=null)
			{
				stmt.close();
			}
			
			//MLogger.writeDBLog("Holiday Dates are "+ holDate, Logger.LOG_LEVEL_DEBUG, "DailyVisit.java", "checkHoliday");
			
			if (holDate.equals("") || holDate.trim().length() == 0 )
			{				
				System.out.println(" workDate ["+workDate+"] not Holiday ");
				return false;
			}
			else
			{	System.out.println(" workDate ["+workDate+"] is Holiday ");			
				return  true;  
			}			
		}
		catch(Exception e)
		{
			throw e;
		}
		finally
		{ //changed by Nazia on 29-Mar-08
			/*if (rs!=null)
			{
				rs.close();
				stmt.close();
			}	*/	
			if (rs!=null)
			{
				rs.close();
				rs = null;
			}
			if (stmtPrd!=null)
			{
				//rsPrd.close();
				stmtPrd.close();				
			}
			if (stmt!=null)
			{
				stmt.close();
				stmt = null;
			}
			if(con !=null)
			{
				con.close();
				con = null;
			}
		}
	}

	/** 
	 * This method the returns all the  holidays of particular employee between two dates
	 *
	 * @param   salesCode   
	 * @param   connection   
	 * @return  Vector of holiday dates 
	*/
	public Vector getHolidays ( String salesCode,String month ,String monthT, String year,String yearT) throws Exception
	{
		System.out.println("DailyVisit.java : Getting Holidays ....");
		ResultSet rs = null;
		Statement stmt = null;
		Connection con = getConnection();
		String fromDate = "1-" + month +"-"+year ;
		Utilities ut = new Utilities();
		String toDate = ut.getLastDateOfMonth(monthT,yearT);
		Vector holDate = new Vector() ;
		
		String selHolidayQuery =	" SELECT TO_CHAR(HOL_DATE,'DD-MON-YYYY') HOL_DATE FROM HOLIDAY HD, EMPLOYEE EMP " +
											" WHERE  HD.HOL_TBLNO = EMP.HOL_TBLNO " +
											" AND EMP.EMP_CODE= '"+ salesCode + "'" + 
											" AND HD.HOL_DATE BETWEEN '"+fromDate+"' AND '"+toDate+"'";

		//MLogger.writeDBLog("selHolidayQuery "+ selHolidayQuery, Logger.LOG_LEVEL_DEBUG, "DailyVisit.java", "getHolidays");
		try
		{
			stmt = con.createStatement();
			rs = stmt.executeQuery(selHolidayQuery);
			while(rs.next())
			{
				holDate.addElement(Utilities.checkNull(rs.getString("HOL_DATE")));
			}
			if (rs!=null)
			{
				rs.close();
				rs = null;
			}
			if (stmt!=null)
			{
				stmt.close();
				stmt = null;
			}
			if(con !=null)
			{
				con.close();
				con = null;
			}		
		}
		catch(Exception e)
		{
			throw e;
		}
		finally
		{
			if (rs!=null)
			{
				rs.close();
				rs = null;
			}
			if (stmt!=null)
			{
				stmt.close();
				stmt = null;
			}
			if(con !=null)
			{
				con.close();
				con = null;
			}
		}
		//MLogger.writeDBLog("Holiday Dates r "+ holDate, Logger.LOG_LEVEL_DEBUG, "DailyVisit.java", "getHolidays");
		System.out.println("holidays date"+holDate);
		return holDate;
	}

	public String getsubmission_date( String salesCode,String workDate) throws Exception
	{	
		System.out.println("DailyVisit.java : getting Submission Date....");

		ResultSet rs = null;
        Statement stmt = null;
		Connection con = getConnection();
		Utilities ut = new Utilities();
		
		String sub_date="";
		String selHolidayQuery = " SELECT TO_CHAR(SUBMISSION_DATE, 'DD-MON-YYYY hh:MI AM') SUBMIT, "+
											" WORK_DATE FROM DR_MAIN "+
										" WHERE SALES_PERS = '"+salesCode+"'"+
											//Changed by nazia on 09-Apr-2009[Requirment to add for field CONFIRMATION_FLAG=N to avoid  NULL check in sql query WI89SUN026]
											//" AND  NVL(CONFIRMATION_FLAG,'N') = 'N' "+
											" AND  CONFIRMATION_FLAG = 'N' "+
											" AND  COMPLETION_FLAG ='Y' AND WORK_DATE = '"+workDate+"'";

		//MLogger.writeDBLog("selHolidayQuery "+ selHolidayQuery, Logger.LOG_LEVEL_DEBUG, "DailyVisit.java", "getsubmission_date");
		try
		{
			stmt = con.createStatement();
			rs = stmt.executeQuery(selHolidayQuery);
			while(rs.next())
			{
				sub_date=Utilities.checkNull(rs.getString("submit"));
			}
			if (rs!=null)
			{
				rs.close();
				rs = null;
			}
			if (stmt!=null)
			{
				stmt.close();
				stmt = null;
			}
			if(con !=null)
			{
				con.close();
				con = null;
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw e;
		}
		finally
		{
			if (rs!=null)
			{
				rs.close();
				rs = null;
			}
			if (stmt!=null)
			{
				stmt.close();
				stmt = null;
			}
			if(con !=null)
			{
				con.close();
				con = null;
			}
		}
		//MLogger.writeDBLog("Holiday Dates"+ sub_date, Logger.LOG_LEVEL_DEBUG, "DailyVisit.java", "getsubmission_date");
		return sub_date;
	}

	/** 
	 * This method selects the  work date one next to last submitted report 
	 *
	 * @param   salesCode   
	 * @param   connection   
	 * @return  workDate
	 */
	public String selectLastReportDate ( String salesCode ) throws Exception
	{
		System.out.println("DailyVisit.java : getting Last Report Date ....");
		
        Connection con = getConnection();
		ResultSet rs = null;
        Statement stmt = null;
		//Connection con = null;
		String lastDate = "";

		String selLastReportDateQuery = " SELECT TO_CHAR( MAX(WORK_DATE)+1,'DD-MON-YYYY') LAST_WORK_DATE FROM DR_MAIN " +
													" WHERE SALES_PERS = '"+ salesCode + "'" +
													" AND COMPLETION_FLAG ='Y' ";

		//MLogger.writeDBLog("selLastReportDateQuery"+ selLastReportDateQuery, Logger.LOG_LEVEL_DEBUG, "DailyVisit.java", "selectLastReportDate");
		try
		{
			stmt = con.createStatement();
			rs = stmt.executeQuery(selLastReportDateQuery);
			while(rs.next())
			{
				lastDate = Utilities.checkNull(rs.getString("LAST_WORK_DATE"));
			}
			if (rs!=null)
			{
				rs.close();
				rs =null;
			}
			if (stmt!=null)
			{
				stmt.close();
				stmt = null;
			}
			if(con !=null)
			{
				con.close();
				con = null;
			}
		}
		catch(Exception e)
		{
			throw e;
		}
		finally
		{
			if (rs!=null)
			{
				rs.close();
				rs = null;
			}
			if (stmt!=null)
			{
				stmt.close();
				stmt = null;
			}
			if(con !=null)
			{
				con.close();
				con = null;
			}
		}
		//MLogger.writeDBLog("selLastReportDate lastDate"+ lastDate, Logger.LOG_LEVEL_DEBUG, "DailyVisit.java", "selectLastReportDate");
		return lastDate;
	}

	// This method Updates IssueQty in SPRS_ITEM for a particular SalesCode and Item_code. by Ravi
	public void updateIssueQty ( String workDate,String salesCode) throws Exception
	{	
		System.out.println("DailyVisit.java : updating Issue Quantity ....");

		ResultSet rs = null;
        Statement stmt = null;
		Statement stmt1=null;
		//Connection con = null;
		Connection con = getConnection();
		String itemCode="";
		int itemQtyTot=0;
		String selectQuery = " SELECT ITEM_CODE, SUM(ITEM_QTY) SUM_ITEM FROM DR_SAMPLE_DISTRIBUTED "+
									" WHERE SALES_PERS ='"+salesCode +"'" +
									" AND WORK_DATE ='"+workDate+"'"+
									" GROUP BY ITEM_CODE ";

		//MLogger.writeDBLog("updateIssueQty selectQuery"+ selectQuery, Logger.LOG_LEVEL_DEBUG, "DailyVisit.java", "updateIssueQty ");

		try
		{
			stmt = con.createStatement();
			rs = stmt.executeQuery(selectQuery);
			stmt1=con.createStatement();
			while(rs.next())
			{
			
				itemCode = Utilities.checkNull(rs.getString("item_code"));
				System.out.println("item code :"+itemCode);
				itemQtyTot = rs.getInt("sum_item");
				
				String updateQuery =" UPDATE SPRS_ITEM SET ISSUE_QTY =ISSUE_QTY+"+itemQtyTot +
											" WHERE SALES_PERS = '"+salesCode +"'"+
											" AND ITEM_CODE = '"+itemCode+"'";
				int result =stmt1.executeUpdate(updateQuery);
			}
			if (rs!=null)
			{
				rs.close();
				rs = null;
			}
			if (stmt!=null)
			{
				stmt.close();
				stmt = null;
			}
			if (stmt1!=null)
			{
				stmt1.close();
				stmt1 = null;
			}
			if(con !=null)
			{
				con.close();
				con = null;
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			if (rs!=null)
			{
				rs.close();
				rs = null;
			}
			if (stmt!=null)
			{
				stmt.close();
				stmt = null;
			}
			if(con !=null)
			{
				con.close();
				con = null;
			}
			
		}

	 }

	/** 
	 * This method UPDATES the confirmation flag( CONFIRMATION_FLAG) from the DR_MAIN for particular salesCode for particular date
	 *
	 * @param   workDate   
	 * @param   salesCode   
	 * @param   connection   
	 * @return  
	 */

	public void updateConfFlag (String workDate,String salesCode) throws Exception
	{	
		System.out.println("DailyVisit.java : updating confirmation flag ....");
		
		Connection con = getConnection();

		DBOperations dbOpr = new DBOperations( con );
		
		HashMap whereHm = new HashMap();
		whereHm.put("SALES_PERS", salesCode);
		whereHm.put("WORK_DATE", workDate);
		HashMap setHm = new HashMap();
		setHm.put("CONFIRMATION_FLAG", "Y");
		setHm.put("LAST_UPDATE","TO_DATE('"+todaysDate+"','dd/mon/yyyy hh:mi am')");
		int result = dbOpr.update("DR_MAIN", setHm,whereHm);
		//MLogger.writeToLog("The no of records updated in dr_main "+result,Logger.LOG_LEVEL_DEBUG,"DailyVisit.java","updateConfFlag");
		
		if(dbOpr.con  != null) 
		{
			dbOpr.removeCon();
		}
	 }

	/** 
	 * This method UPDATES the confirmation flag( CONFIRMATION_FLAG) from the DR_MAIN for particular salesCode for particular date
	 *This is to unconfirm the report
	 * @param   workDate   
	 * @param   salesCode   
	 * @param   connection   
	 * @return  
	 */

	public void updateUnConfFlag (String workDate,String salesCode) throws Exception
	{
		System.out.println("DailyVisit.java : updating unconfirmation flag ....");
		Connection con = getConnection();
		DBOperations dbOpr = new DBOperations( con );
		HashMap whereHm = new HashMap();
		whereHm.put("SALES_PERS", salesCode);
		whereHm.put("WORK_DATE", workDate);
		HashMap setHm = new HashMap();
		setHm.put("CONFIRMATION_FLAG", "N");
		setHm.put("LAST_UPDATE","TO_DATE('"+todaysDate+"','dd/mon/yyyy hh:mi am')");
		int result = dbOpr.update("DR_MAIN", setHm,whereHm);
		//MLogger.writeToLog("The no of records updated in dr_main "+result,Logger.LOG_LEVEL_DEBUG,"DailyVisit.java","updateConfFlag");
		if(dbOpr.con  != null) 
		{
			dbOpr.removeCon();
		}
	 }

	/** 
	 * This method UPDATES the confirmation flag( CONFIRMATION_FLAG) from the DR_MAIN 
	 * for particular salesCode for given set of dates
	 *
	 * @param   workDate[]   
	 * @param   salesCode   
	 * @param   connection   
	 * @return  
	 */
	public void updateConfFlag (String[] workDate,String salesCode) throws Exception
	{	
		System.out.println("DailyVisit.java : updating confirmation flag for multipla dates ....");
		Connection con = getConnection();
		DBOperations dbOpr = new DBOperations( con );
		
		HashMap whereHm;
		int result = 0 ;
		for(int i=0; i < workDate.length ; i++)
		{
			whereHm = new HashMap();
			whereHm.put("SALES_PERS", salesCode);
			whereHm.put("WORK_DATE", workDate[i]);
			
			HashMap setHm = new HashMap();
			setHm.put("CONFIRMATION_FLAG", "Y");
			setHm.put("LAST_UPDATE","TO_DATE('"+todaysDate+"','dd/mon/yyyy hh:mi am')");
			result = dbOpr.update("DR_MAIN", setHm,whereHm);
			//MLogger.writeToLog("The no of records updated in dr_main "+result,Logger.LOG_LEVEL_DEBUG,"DailyVisit.java","updateConfFlag");
		}
		if(dbOpr.con  != null) 
		{
			dbOpr.removeCon();
		}
	 }

	/** 
	 * This method selects the confirmation flag( CONFIRMATION_FLAG) from the DR_MAIN for particular salesCode for particular date
	 *
	 * @param   workDate   
	 * @param   salesCode   
	 * @param   connection   
	 * @return  
	 */
	public String checkConfFlag (String workDate,String salesCode) throws Exception
	{
		System.out.println("DailyVisit.java : Checking for confirmation flag ....");
		
		ResultSet rs = null;
        Statement stmt = null;
		//Connection con = null;
        Connection con = getConnection();
		String confFlag = "";

		String checkConfFlagQuery = " SELECT CONFIRMATION_FLAG FROM DR_MAIN WHERE  " +
					                            " WORK_DATE='"+ workDate +"' AND SALES_PERS = '"+ salesCode + "'";

		//MLogger.writeDBLog("checkConfFlagQuery"+ checkConfFlagQuery, Logger.LOG_LEVEL_DEBUG, "DailyVisit.java", "checkConfFlag");
		
		try
		{
			stmt = con.createStatement();
			rs = stmt.executeQuery(checkConfFlagQuery);
			while(rs.next())
			{
				confFlag = Utilities.checkNull(rs.getString("CONFIRMATION_FLAG"));
			}
			if (rs!=null)
			{
				rs.close();
				rs = null;
			}
			if (stmt!=null)
			{
				stmt.close();
				stmt = null;
			}
			if(con !=null)
			{
				con.close();
				con = null;
			}
		}
		catch(Exception e)
		{
			throw e;
		}
		finally
		{
			if (rs!=null)
			{
				rs.close();
				rs = null;
			}
			if (stmt!=null)
			{
				stmt.close();
				stmt = null;
			}
			if(con !=null)
			{
				con.close();
				con = null;
			}
		}
		//MLogger.writeDBLog("CONFIRMATION_FLAG is"+ confFlag, Logger.LOG_LEVEL_DEBUG, "DailyVisit.java", "checkConfFlag");
		return confFlag;
	}

	// this method is called from View report for the manager login where, manager
	//can approve the PSR Report.
	public void updatePSRApprovalDetails(String salesCode,String workDate,String flag,String comment,String loginid) throws Exception
	{
		System.out.println("DailyVisit.java : updating PSR Approval Details ....");

		Connection con = getConnection();
		DBOperations dbOpr = new DBOperations( con );

		HashMap whereHm = new HashMap();
		whereHm.put("SALES_PERS", salesCode);
		whereHm.put("WORK_DATE", workDate);
		HashMap setHm = new HashMap();
		setHm.put("APPROVAL_FLAG", flag);
		setHm.put("APPROVAL_ID", loginid);
		setHm.put("APPROVAL_COMMENT",comment);

		setHm.put("APPROVAL_DATE","TO_DATE('"+todaysDate+"','dd/mon/yyyy mi:ss:am')");

		int result = dbOpr.update("DR_MAIN", setHm,whereHm);
		//MLogger.writeToLog("The no of records updated in dr_main "+result,Logger.LOG_LEVEL_DEBUG,"TravelExpense.java","updateExpenseDetails()");
		
		if(dbOpr.con  != null) 
		{
			dbOpr.removeCon();
		}
	}

	public Vector selectApprovalDetail(String workDate,String salesCode) throws Exception
	{
		System.out.println("DailyVisit.java : selecting approval details ....");
		Vector appDet = new Vector();
		try
		{
			Connection con = getConnection();
			DBOperations dbOpr = new DBOperations( con );
			String selappDetQuery = " SELECT APPROVAL_FLAG,APPROVAL_COMMENT,APPROVAL_ID, "+
											 " TO_CHAR(APPROVAL_DATE, 'DD-MON-YYYY HH:MI')  FROM DR_MAIN " +
											 " WHERE SALES_PERS = '"+salesCode+"' AND WORK_DATE = '"+workDate+"' " ;
			appDet = dbOpr.selectVector(selappDetQuery);
			
			if(dbOpr.con  != null) 
			{
				dbOpr.removeCon();
			}
		}
		catch (Exception e)
		{
			System.out.println("The Error"+e.getMessage());
		}
		return appDet;
	}
	/** 
	 * This method selects all the unconfirmed report till date
	 *
	 * @param   salesCode   
	 * @param   connection   
	 * @return  workDates of unconfirmed report
	 */
	public Vector selectUnconfReports (String salesCode) throws Exception
	{	
		System.out.println("DailyVisit.java : getting unconfirm reports ....");

		ResultSet rs = null;
        Statement stmt = null;
		//Connection con = null;
        Connection con = getConnection();
		Vector reportDates = new Vector();
	//Added By Nilesh Start for holiday fill uncomplete dar throught mobile Start :: 20-11-18
	/*	String selUnconfReportQuery =" SELECT TO_CHAR(WORK_DATE,'DD-MON-YYYY')UNCONFIRM_WORK_DATE FROM DR_MAIN " +
												" WHERE SALES_PERS = '"+ salesCode + "'" +
												//Changed by nazia on 09-Apr-2009[Requirment to add for field CONFIRMATION_FLAG=N to avoid  NULL check in sql query WI89SUN026]
												//" AND  NVL(CONFIRMATION_FLAG,'N') ='N'" +
												" AND  CONFIRMATION_FLAG = 'N'" +
												" AND  COMPLETION_FLAG ='Y'" +
												//Changed by Nazia on 15-Sep-2008[Added order by work_date to keep date in assending order]
												"ORDER BY  WORK_DATE";*/
		String selUnconfReportQuery =" SELECT TO_CHAR(WORK_DATE,'DD-MON-YYYY')UNCONFIRM_WORK_DATE FROM DR_MAIN " +
				" WHERE SALES_PERS = '"+ salesCode + "'" +
				//Changed by nazia on 09-Apr-2009[Requirment to add for field CONFIRMATION_FLAG=N to avoid  NULL check in sql query WI89SUN026]
				//" AND  NVL(CONFIRMATION_FLAG,'N') ='N'" +
				//Change by Prasad on 11/12/19 [check if confirmation_flag is null then set N, suggested by Gulzar Sir] START
				//" AND  CONFIRMATION_FLAG = 'N'" +
				" AND (case when confirmation_flag is null then 'N' else confirmation_flag end) = 'N' " +
				//Change by Prasad on 11/12/19 [check if confirmation_flag is null then set N, suggested by Gulzar Sir] END
			/*	" AND  COMPLETION_FLAG ='Y'" +
*/				//Changed by Nazia on 15-Sep-2008[Added order by work_date to keep date in assending order]
				"ORDER BY  WORK_DATE";
		//Added By Nilesh Start for holiday fill uncomplete dar throught mobile End :: 20-11-18
		System.out.println("dailyVisit selectUnconfReports()::selUnconfReportQuery \n["+selUnconfReportQuery+"] ");			
		//MLogger.writeDBLog("selectUnconfirmReportQuery is"+ selUnconfReportQuery, Logger.LOG_LEVEL_DEBUG, "DailyVisit.java", "selectUnconfReports");
										 
		try
		{
			stmt = con.createStatement();
			rs = stmt.executeQuery(selUnconfReportQuery);
			while(rs.next())
			{
			//Changed by Nazia on 15-Sep-2008 []
				//if (rs.getString("WORK_DATE") != null)
				if (rs.getString("UNCONFIRM_WORK_DATE") != null)
				{
					reportDates.addElement(Utilities.checkNull(rs.getString("UNCONFIRM_WORK_DATE")));
				} 
			}
			if (rs!=null)
			{
				rs.close();
				rs = null;
			}
			if (stmt!=null)
			{
				stmt.close();
				stmt = null;
			}
			if(con !=null)
			{
				con.close();
				con = null;
			}
		
		}
		catch(Exception e)
		{
			System.out.println("exception :"+e);
			throw e;
		}
		finally
		{
			if (rs!=null)
			{
				rs.close();
				rs = null;
			}
			if (stmt!=null)
			{
				stmt.close();
				stmt = null;
			}
			if(con !=null)
			{
				con.close();
				con = null;
			}
		}
		//MLogger.writeToLog("The unconfirmed report dates are " + reportDates,Logger.LOG_LEVEL_DEBUG,"DailyVisit.java","selectUnconfReports");
		return reportDates;
	}

	/** 
	 * This method checks whether there is any entry for daily report particular salesCode for particular date
	 *
	 * @param   workDate   
	 * @param   salesCode   
	 * @param   connection   
	 * @return  
	 */
	public String checkDR (String workDate,String salesCode) throws Exception
	{
		System.out.println("DailyVisit.java : Checking DR ....");
		
		ResultSet rs = null;
        Statement stmt = null;
		//Connection con = null;
        Connection con = getConnection();
		String reportFlag = "N";

		String checkDRQuery =  " SELECT TO_CHAR(WORK_DATE,'DD-MON-YYYY HH:MI') FROM DR_MAIN WHERE  " +
			                             " WORK_DATE='"+ workDate +"' AND SALES_PERS = '"+ salesCode + "'";

		//MLogger.writeDBLog("checkDRQuery "+ checkDRQuery, Logger.LOG_LEVEL_DEBUG, "DailyVisit.java", "checkDR");
		try
		{
			stmt = con.createStatement();
			rs = stmt.executeQuery(checkDRQuery);
			while(rs.next())
			{
				reportFlag = "Y";
			}
			if (rs!=null)
			{
				rs.close();
				rs = null;
			}
			if (stmt!=null)
			{
				stmt.close();
				stmt = null;
			}
			if(con !=null)
			{
				con.close();
				con = null;
			}
		}
		catch(Exception e)
		{
			throw e;
		}
		finally
		{
			if (rs!=null)
			{
				rs.close();
				rs = null;
			}
			if (stmt!=null)
			{
				stmt.close();
				stmt = null;
			}
			if(con !=null)
			{
				con.close();
				con = null;
			}
		}
		return reportFlag;
	}

	/**
	 * This method returns maximum allowable unconfimed reports
	 */
	 //Changed by Nazia on 18-Aug-2008[Added new argument salesCode Apply property values depending upon Division(ITEM_SER)WS89SUN007]
	// public int getUnconfirmLimit(DBConnection dbCon) throws Exception
	 public int getUnconfirmLimit(String salesCode) throws Exception
	 {
		System.out.println("DailyVisit.java : getting unconfirm report limit ....");
		ResultSet rs = null;
		Statement stmt = null;
		Connection con = getConnection();
		//Connection con = null;
		//Changed by Nazia on 18-Aug-2008[to store Division WS89SUN007]
		//MedRep mr = new MedRep();
		MedRep mr = new MedRep( userInfo );
		String itemSer = mr.selectDivision(salesCode);

		System.out.println("DailyVisit.java : MR.selectDivision()= itemSer ["+itemSer+"]");

		int maxLimit = 0;
		String strMaxLimit = "";
		
		//Changed by Nazia on 18-Aug-2008[Apply property values depending upon Division(ITEM_SER)WS89SUN007]
		String selectMaxLimit;

		if (!mr.isPresentPropDiv("UNCONFIRM_MAXLIMIT",salesCode))
		{
			selectMaxLimit =  " SELECT PROP_VALUE FROM PROPERTIES WHERE PROP_NAME = 'UNCONFIRM_MAXLIMIT' AND upper(ITEM_SER) ='ALL'";
		}
		else
		{
			selectMaxLimit =  " SELECT PROP_VALUE FROM PROPERTIES WHERE PROP_NAME = 'UNCONFIRM_MAXLIMIT' AND ITEM_SER ='"+itemSer+"'";
		}
		//MLogger.writeDBLog(" in selectMaxLimit of unconfirm Report"+ selectMaxLimit, Logger.LOG_LEVEL_DEBUG, "DailyVisit.java", "getUnconfirmLimit");
		try
		{
			stmt = con.createStatement();
			rs = stmt.executeQuery(selectMaxLimit);
			while(rs.next())
			{
				strMaxLimit = rs.getString("PROP_VALUE");
			}
			maxLimit = Integer.parseInt(strMaxLimit);
			if (rs!=null)
			{
				rs.close();
				rs = null;
			}
			if (stmt!=null)
			{
				stmt.close();
				stmt = null;
			}
			if(con !=null)
			{
				con.close();
				con = null;
			}
		}
		catch(Exception e)
		{
			throw e;
		}
		finally
		{
			if (rs!=null)
			{
				rs.close();
				rs = null;
			}
			if (stmt!=null)
			{
				stmt.close();
				stmt = null;
			}
			if(con !=null)
			{
				con.close();
				con = null;
			}		
	
		}
		return maxLimit;
	}


public String getMsgReportDays()
{
	return msgReportDays;
}
public String isReportMissing()
	{
		return isReportMissing ;
	}

/*start *****************************************************************************
		Date 6-Jun-07
		Author : Nazia 
		This function checks last 60 missing reports from current date.
*/
	/*public String missingReport(DBConnection dbCon,String salesPers,String workDate)
	{

long startTime = System.currentTimeMillis();
//LogFile.writeToLog("["+salesPers+"]["+workDate+"]StartTime "+startTime,"DailyVisit.jsp");




		System.out.println(" DailyVisit: missingReport():: called........................ ");
		//Connection con = null;
		Statement stmt = null,stmt1 = null;
		ResultSet rs = null,rs1 = null;		
		java.util.Date fromDateObj = new java.util.Date();// report will be checked from this dateobject
		java.util.Date missingReportDate = new java.util.Date();//report is missing for this date.
		java.util.Date workDateForObj = new java.util.Date();	//Sales person is trying to submit report for this date.	
		java.util.Date workingDateForObj = new java.util.Date();		
		java.util.Date currentDateForObj = new java.util.Date();		

		Calendar calObj = Calendar.getInstance();			
		java.util.Date workDateObj = null;
		DateObject	dateObj = new DateObject();	
		String	strFromDate = ""; // report will be checked from this date in string format
		String strDate = "";//Report check for each and every day.compare this date with report date to find missing report
		String strTemp = "";//Report are submitted for this date.
		String msgReportDaysQuery = "";
		msgReportDays = "";
		Integer integer = null;
		boolean holFlag = false;	
		boolean missingReport = true;	
		DateUtilities dut = new DateUtilities();
		dut.setFormatString("dd-MMM-yyyy");
		String ServerDate = dut.getCurrentDate();//Get current system date.
		Vector 	workingDates = new Vector();// collect report dates from database

		//LogFile.writeToLog("after variable declaration"+new Long(System.currentTimeMillis()-startTime).toString(),"DailyVisit.java");
		try
		{				
				SimpleDateFormat simpleDateFormat =new SimpleDateFormat("dd-MMM-yyyy");			
				//simpleDateFormat = new SimpleDateFormat("dd-MMM-yyyy"); 
				workDateObj = simpleDateFormat.parse(ServerDate);				
				currentDateForObj = simpleDateFormat.parse(ServerDate);
				calObj.setTime(currentDateForObj);
				calObj.add(calObj.DATE,-1);
				currentDateForObj = calObj.getTime();
				ServerDate = simpleDateFormat.format(currentDateForObj);

				calObj.setTime(workDateObj);

//LogFile.writeToLog("["+salesPers+"]["+workDate+"]after calender date "+new Long(System.currentTimeMillis()-startTime).toString(),"DailyVisit.java");



				System.out.println(" Original work date *******************" + workDate);					
				//12/03/2008msgReportDaysQuery = " SELECT PROP_VALUE FROM PROPERTIES WHERE PROP_NAME ='MSG_REPORT_DAYS' ";
				msgReportDaysQuery = " SELECT PROP_VALUE FROM PROPERTIES WHERE PROP_NAME ='START_DATE_MSG_RPT' ";
				System.out.println("msgReportDaysQuery " + msgReportDaysQuery);
				con = dbCon.getConnection();
				stmt1 = con.createStatement();
				rs1 = stmt1.executeQuery(msgReportDaysQuery);				
				if(rs1.next())//Changed by Nazia on 22-May-2008[changed while to If]
				{
					msgReportDays = rs1.getString("PROP_VALUE"); //retrieve days to check missing reports
				}
//LogFile.writeToLog("["+salesPers+"]["+workDate+"] after missing report date query "+new Long(System.currentTimeMillis()-startTime).toString(),"DailyVisit.java");
				
				
				//22-Apr-08 START
				MedRep me = new MedRep();
				me.selectGenInfo(dbCon,salesPers);
				String dateOfJoin = me.getDateOfJoin();				
				System.out.println("dateOfJoin of employee ...............["+dateOfJoin+"]");
				System.out.println("missing days to check............ " +msgReportDays);

//LogFile.writeToLog("["+salesPers+"]["+workDate+"]after getting date of join  "+new Long(System.currentTimeMillis()-startTime).toString(),"DailyVisit.java");
				
				msgReportDays = simpleDateFormat.parse(dateOfJoin).compareTo(simpleDateFormat.parse(msgReportDays))==0 ||simpleDateFormat.parse(msgReportDays).before(simpleDateFormat.parse(dateOfJoin))?dateOfJoin:msgReportDays;
				
				
				//22-Apr-08 end
				System.out.println("missing days to check............ " +msgReportDays);
				//12/03/2008 Nazia
				fromDateObj = simpleDateFormat.parse(msgReportDays);	//start checking report from this date	
				System.out.println(" 111 fromDateObj......... ["+simpleDateFormat.format(fromDateObj)+"]");	
				//12/03/2008
				calObj.setTime(fromDateObj);
				strFromDate = simpleDateFormat.format(fromDateObj);
				System.out.println(" reports to check from strFromDate" + strFromDate);					

				
				String selectReportDates =" SELECT TO_CHAR(WORK_DATE,'DD-MON-YYYY')WORK_DATE FROM DR_MAIN "
									+	" WHERE SALES_PERS ='"+salesPers+"'"
									+	" AND  WORK_DATE  BETWEEN '"+strFromDate+"' AND '"+ServerDate+"'" 
									+	" AND COMPLETION_FLAG = 'Y' ";														
				stmt = con.createStatement();

//LogFile.writeToLog("["+salesPers+"]["+workDate+"]before selectReportDates sql "+new Long(System.currentTimeMillis()-startTime).toString(),"DailyVisit.java");

				rs = stmt.executeQuery(selectReportDates);

//LogFile.writeToLog("["+salesPers+"]["+workDate+"]after selectReportDates sql "+new Long(System.currentTimeMillis()-startTime).toString(),"DailyVisit.java");

				System.out.println(" DailyVisit.java: selectReportDates executed..." + selectReportDates);

				while(rs.next())
				{
					workingDates.addElement(Utilities.checkNull(rs.getString("WORK_DATE")));
				}				
				while( fromDateObj.compareTo(workDateObj)!=0)
				{	
					workingDateForObj =  simpleDateFormat.parse(workDate);//9-Jun-2007
					System.out.println("Sales person is submitting report on workingDateForObj..........." + simpleDateFormat.format(workingDateForObj));		
					System.out.println(" 222 Present date fromDateObj......... ["+simpleDateFormat.format(fromDateObj)+"]");								
					if( !workingDateForObj.before(fromDateObj))
					{																	
						strDate = simpleDateFormat.format(fromDateObj);
						if (workingDates.size()!=0 && !workingDateForObj.equals(fromDateObj) )
						{	
							System.out.println(" in if workingDates.size()>0");
							for(int i=0;i<workingDates.size();i++)
							{																	
								strDate = simpleDateFormat.format(fromDateObj);		
								strTemp =workingDates.elementAt(i).toString();		
								while( checkHoliday(dbCon,strDate,salesPers) ||dateObj.isSunday(strDate))
								{	
									if (!strDate.equalsIgnoreCase(strTemp ))
									{									
										System.out.println(" this is holiday " + strDate);
										//25/03/2008 [If user wants to submit report for holiday WS78SUN030]start
										if (strDate.equalsIgnoreCase(simpleDateFormat.format(workingDateForObj)))
										{
											break;																					
										}
										//25/03/2008 [If user wants to submit report for holiday WS78SUN030]end
										calObj.add(calObj.DATE,1);
										fromDateObj = calObj.getTime();
										strDate = simpleDateFormat.format(fromDateObj);
										System.out.println("  11 increased date " + strDate);
										holFlag = true;
									}
									else
									{
										System.out.println(" 22  Report present for holiday ["+strDate+"]");										
										//strTemp =workingDates.elementAt(i+1).toString();
										break;
									}
								}						
								System.out.println("After cheking Holiday strTemp ["+strTemp+"] strDate ["+strDate+"]");								
								if(!strDate.equalsIgnoreCase(strTemp )&& !strDate.equalsIgnoreCase(workDate ) )
								{										
									strDate = simpleDateFormat.format(fromDateObj);																	
									missingReportDate = calObj.getTime();	
									if( missingReportDate.compareTo(workingDateForObj)!=0  && ! workingDateForObj.before(missingReportDate) )						{
										System.out.println("\n\n 33 Report is missing for **********  " + missingReportDate);										
										return simpleDateFormat.format(missingReportDate);
									}
									else
									{								
										System.out.println(" 444 return false Report not missing workingDateForObj " + workingDateForObj);
										return "false";
									}																															
								}								
								calObj.add(calObj.DATE,1); //8-Jun-2007
								fromDateObj = calObj.getTime();							
						}//end of for loop workDates					
					}//end of if
					else if (!workingDateForObj.equals(fromDateObj))					
					{	System.out.println(" in if workingDates.size()==0");						
						missingReportDate=simpleDateFormat.parse(strDate);						
						 while(checkHoliday(dbCon,simpleDateFormat.format(missingReportDate),salesPers) ||dateObj.isSunday(simpleDateFormat.format(missingReportDate)) ) 
						{
							 System.out.println("555 IN  while(checkHoliday( ["+missingReportDate+"] ");	calObj.setTime(missingReportDate);
							calObj.add(calObj.DATE,1);
							missingReportDate =calObj.getTime();
							System.out.println(" 666 increased date ["+missingReportDate+"]");			
						}						 					
						 if(!workingDateForObj.equals(missingReportDate))
						{
						 System.out.println("\n\n 777 Report is missing for ******************" + simpleDateFormat.format(missingReportDate));
							return simpleDateFormat.format(missingReportDate);
						}
						else
						{
							return "false";
						}
					}
					else
					{//25/03/2008 [INCREASE DATE IF HOLIDAY PRESENT]
					System.out.println(" workingDateForObj.toString())["+workingDateForObj.toString()+"] ");	
					System.out.println(" simpleDateFormat.format(workingDateForObj) ["+simpleDateFormat.format(workingDateForObj)+"]");
						while(checkHoliday(dbCon,simpleDateFormat.format(workingDateForObj),salesPers) ||dateObj.isSunday(simpleDateFormat.format(workingDateForObj)) ) 
						{
							 System.out.println("  888 IN  while(checkHoliday( ["+workingDateForObj.toString()+"] ");	
							 calObj.setTime(workingDateForObj);
							calObj.add(calObj.DATE,1);
							workingDateForObj =calObj.getTime();
							System.out.println(" 999 increased date ["+workingDateForObj+"]");
						}	
						System.out.println(" 10101 return false Report not missing workingDateForObj " + workingDateForObj);
						//return "false";	25/03/2008 set the increased date
						return simpleDateFormat.format(workingDateForObj);
					}
				}				
				else
				{	
					System.out.println(" IN LAST ELSE............");
					//13/03/2008 return "false"; [AS report may be missing but we have to display date of properties table in ADD report text box]
					isReportMissing = "false";
					return strFromDate;
				}//9-Jun-2007																										
			}//End of Calender WHILE LOOP				
		}//end of try				
		catch(Exception e)
		{
			e.printStackTrace();
		}	
		if (missingReport ==false)
		{
			return "false";	
		}
		return "false";		
	}*/
//End-Nazia 6-Jun-2007********************************************************************************************


	
/*	Changed by Nazia on Date 23-Jun-07
	[Added Function :This function retrives last place of work of the last report
	REQUEST ID WI78SUN005] start
*/
public String getLastPlaceOfWork( String salesPers ,String workDate ) throws Exception
{
		//Connection con = null;
		Connection con = getConnection();
		Statement stmt = null;
		ResultSet rs =null;
		String lastPlaceOfWork = null;
		String lastWorkRoutId = null;		
		Calendar calendar = Calendar.getInstance();	
		SimpleDateFormat simpleDateFormat = new SimpleDateFormat ("dd-MMM-yyyy");
		DateObject	dateObj = new DateObject();			
		try
		{
			calendar.setTime( simpleDateFormat.parse(workDate) );
			calendar.add( calendar.DATE,-1 );
			java.util.Date  lstPlcWorkDate = calendar.getTime();
			while( checkHoliday( simpleDateFormat.format( lstPlcWorkDate ),salesPers) || dateObj.isSunday(simpleDateFormat.format(lstPlcWorkDate) ) )
			{				
				String rptPresentOnHolSql = "SELECT WORK_DATE FROM DR_MAIN WHERE SALES_PERS = '" + salesPers+" ' " +
										  " AND WORK_DATE ='" + simpleDateFormat.format(lstPlcWorkDate)+ "' AND COMPLETION_FLAG = 'Y' ";
				stmt = con.createStatement();		
				rs = stmt.executeQuery(rptPresentOnHolSql);
				if(rs.next())
				{
					lstPlcWorkDate = calendar.getTime();					
					break;
				}
				else
				{   
					calendar.add( calendar.DATE,-1 );
					lstPlcWorkDate = calendar.getTime();
				}	
				if (rs!=null)
				{
					rs.close();
				}
				if (stmt!=null)
				{
					stmt.close();
				}
					
			}							
			stmt = con.createStatement();			
			String lastPlaceQuery = " SELECT WORK_DATE ,WRK_ROUTE_DESCR,LINE_NO ,"+
									" WORK_ROUTE_ID FROM DR_TRAVEL_DETAILS " +
									" WHERE SALES_PERS =  '" + salesPers+" ' " +
									" AND LINE_NO =(SELECT MAX(LINE_NO) FROM DR_TRAVEL_DETAILS " + 
																" WHERE  SALES_PERS =  '" + salesPers+" ' " + 
																" AND WORK_DATE ='"+simpleDateFormat.format(lstPlcWorkDate)+"') "+
									" AND WORK_DATE ='"+simpleDateFormat.format(lstPlcWorkDate)+"'";
							
			System.out.println(" Last place of work lastPlaceQuery " + lastPlaceQuery);
			rs = stmt.executeQuery( lastPlaceQuery );
			while(rs.next())
			{
				lastPlaceOfWork = rs.getString( "WRK_ROUTE_DESCR" );
				lastWorkRoutId = rs.getString( "WORK_ROUTE_ID" );
			}
			if (rs!=null)
			{
				rs.close();
				rs = null;
			}
			if (stmt!=null)
			{
				stmt.close();
				stmt = null;
			}
			if(con !=null)
			{
				con.close();
				con = null;
			}	
		}
		catch(Exception e)
		{
			throw e;
		}
		finally
		{
			if (rs!=null)
			{
				rs.close();
				rs = null;
			}
			if (stmt!=null)
			{
				stmt.close();
				stmt = null;
			}
			if(con !=null)
			{
				con.close();
				con = null;
			}
		}
		return lastWorkRoutId + "#" + lastPlaceOfWork;

}/*	Changed by Nazia on Date 23-Jun-07
/*end ********************************************************************************************/

//Changed by nazia on 13-Apr-2009[Added new function If Monthly Activity Schedule has not been confirmed , system should not allow to confirm Daily Activity Report ( On Line Report ). WS89SUN093]Start
public boolean isPlanConfirmed( String salesPers, String workDate)throws Exception
{
		//Connection con = null;
		Connection con = getConnection();
		Statement stmt = null;
		ResultSet rs =null;
		boolean isPlanConfirmed = false;
		String month = workDate.substring (workDate.indexOf("-")+1,workDate.lastIndexOf("-"));
		String year  =  workDate.substring(workDate.lastIndexOf("-")+1);
		String fromDate = "1-"+month+"-"+year;
		System.out.println("DailyVisit::isPlanConfirmed() workDate ["+workDate+"] month ["+month+"] year ["+year+"]");

		Utilities ut = new Utilities();
		String lastDate = ut.getLastDateOfMonth(month,year);

		System.out.println(" DailyVisit::isPlanConfirmed()  fromDate ["+fromDate+"] lastDate ["+lastDate+"]");
		String sql = "SELECT COUNT(1) FROM SPRS_PLAN_FROZEN WHERE SPRS_CODE__FOR ='"+salesPers+"' AND PLAN_DATE BETWEEN '"+fromDate+"' AND '"+lastDate+"'";
		System.out.println(" DailyVisit::isPlanConfirmed() sql["+sql+"] ");
		try
		{
			stmt = con.createStatement();
			rs = stmt.executeQuery(sql);

			if(rs.next())
			{
				System.out.println(" getInt(1) ["+rs.getInt(1)+"]");
				if(rs.getInt(1)>0)
				{
					isPlanConfirmed = true;
				}
			}

			if (rs!=null)
			{
				rs.close();
				rs = null;
			}
			if (stmt!=null)
			{
				stmt.close();
				stmt = null;
			}
			if(con !=null)
			{
				con.close();
				con = null;
			}
		}
		catch(SQLException sqlExcep)
		{
			System.out.println(" DailyVisit::isPlanConfirmed() " + sqlExcep.getMessage());
		}
		finally
		{			
			if (rs!=null)
			{
				rs.close();
				rs = null;
			}
			if (stmt!=null)
			{
				stmt.close();
				stmt = null;
			}
			if(con !=null)
			{
				con.close();
				con = null;
			}
		}
		System.out.println(" DailyVisit::isPlanConfirmed() return isPlanConfirmed["+isPlanConfirmed+"]..........");
		return isPlanConfirmed;
}
//Changed by nazia on 13-Apr-2009 [Added new function If Monthly Activity Schedule has not been confirmed , system should not allow to confirm Daily Activity Report ( On Line Report ). WS89SUN093]End


/** 
	 * This main method to test other method of the class
	 *
	 * @param   argguments   
	 */
	public void removeCon() throws Exception
	{
		try
		{
			if ( con != null )
			{
				con.close();
				con = null;
			}
		}
		catch(Exception e)
		{
			throw e;
		}
	}
	
	private Connection getConnection()
	{
		Connection con = null;
		ConnDriver connDriver = new ConnDriver();

		if( userInfo !=null )
		{
			try 
			{
				con = connDriver.getConnectDB(userInfo.getTransDB());
			}
			catch (Exception e) 
			{
				e.printStackTrace();
				System.out.println("In DailyVisit GetConnetion Exception : ["+ e.getMessage() +"]");
			}
		}
		return con;
	}
	
	public static void main(String[] args) throws Exception
	{
		//DBConnection con = new DBConnection();
		//DailyVisit dv = new DailyVisit();
		//Vector repDates = dv.selectUnconfReports(con,"E07889");
		//con.conClose();
		//con = null;
   }
}