package ibase.webitm.ejb.wsfa.transactions;

import ibase.system.config.ConnDriver;
import ibase.utility.E12GenericUtility;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;


//@javax.ejb.Stateless		commented by Sagar M [22 Nov 2018].
public class PhotoCaptureReportEJB implements PhotoCaptureReportEJBRemote,PhotoCaptureReportEJBLocal //implements SessionBean
{
	@Override
	public String getPhotoCaptureDetails(String loginCode, String transDB, String teamSelection, String fromDate, String toDate, String photoAttch, String custType)throws RemoteException
	{
		StringBuffer xmlStringBuff = new StringBuffer();
		System.out.println("In PhotoCaptureReportEJB loginCode["+loginCode+"] transDB["+transDB+"] teamSelection["+teamSelection+"] fromDate["+fromDate+"] toDate["+toDate+"] photoAttch["+photoAttch+"] custType["+custType+"]");

		Connection mConnection = null;
		PreparedStatement mStatement = null;
		ResultSet mResultSet = null;
		ConnDriver connDriver = new ConnDriver();
		E12GenericUtility e12genericUtil = new E12GenericUtility();
		try
		{
			if(mConnection == null)
			{
				mConnection = connDriver.getConnectDB( transDB );
			}

			fromDate = e12genericUtil.getValidDateString(fromDate, e12genericUtil.getApplDateFormat(), e12genericUtil.getDBDateFormat());
		    toDate = e12genericUtil.getValidDateString(toDate, e12genericUtil.getApplDateFormat(), e12genericUtil.getDBDateFormat());
		    System.out.println("fromDateStr["+fromDate+"] toDateStr["+toDate+"]");
			String query = ""; //$NON-NLS-1$
			if( "Y".equalsIgnoreCase( photoAttch.trim() ))
			{
				query = "SELECT DISTINCT SUPERVISOR.EMP_FNAME||' '||SUPERVISOR.EMP_LNAME AS SUPERVISOR_NAME, "+
						"RSM.EMP_FNAME||' '||RSM.EMP_LNAME AS RSM_NAME, "+
						"ABM.EMP_FNAME||' '||ABM.EMP_LNAME AS ABM_NAME, "+
						"EMP.HOBBY1 AS REGION, "+
						"EMP.EMP_CODE   AS SP_CODE, "+
						"EMP.EMP_FNAME||' '||EMP.EMP_LNAME AS SALES_PERS, "+
						"SM.EVENT_DATE AS EVENT_DATE, "+
						"SM.STRG_TYPE AS STRG_TYPE, "+
						"SC.FIRST_NAME||' '||SC.LAST_NAME AS CUSTOMER_NAME, "+
						"SD.DOC_ID AS REF_ID, "+
						"DL.REF_SER AS REF_SER "+
						"FROM EMPLOYEE EMP "+
						"LEFT OUTER JOIN EMPLOYEE ABM "+
						"ON EMP.REPORT_TO = ABM.EMP_CODE "+
						"LEFT OUTER JOIN EMPLOYEE RSM "+
						"ON ABM.REPORT_TO=RSM.EMP_CODE "+
						"LEFT OUTER JOIN EMPLOYEE SUPERVISOR "+
						"ON RSM.REPORT_TO=SUPERVISOR.EMP_CODE, "+
						"STRG_MEET SM, "+
						"STRG_CUSTOMER SC, "+
						"STRG_ITEM_DISPLAY SD, "+
						"DOC_TRANSACTION_LINK DL "+
						"WHERE SM.SALES_PERS=EMP.EMP_CODE "+
						"AND SM.EVENT_DATE >= ? "+
						"AND SM.EVENT_DATE <= ? "+
						"AND EMP.EMP_CODE  IN "+E12GenericUtility.getFormattedProfileId( teamSelection )+" "+
						"AND SM.STRG_CODE   = SC.SC_CODE "+
						"AND SM.STRG_TYPE IN "+E12GenericUtility.getFormattedProfileId( custType )+" "+
						"AND SM.DCR_ID     = SD.DCR_ID "+
						"AND SM.STRG_CODE = SD.STRG_CODE "+
						"AND trim(DL.REF_ID) = SD.DOC_ID "+
						"ORDER BY SALES_PERS, EVENT_DATE";
			}
			else if( "N".equalsIgnoreCase( photoAttch.trim() ))
			{
				query = "SELECT DISTINCT SUPERVISOR.EMP_FNAME||' '||SUPERVISOR.EMP_LNAME AS SUPERVISOR_NAME, "+
						"RSM.EMP_FNAME||' '||RSM.EMP_LNAME AS RSM_NAME, "+
						"ABM.EMP_FNAME||' '||ABM.EMP_LNAME AS ABM_NAME, "+
						"EMP.HOBBY1 AS REGION, "+
						"EMP.EMP_CODE   AS SP_CODE, "+
						"EMP.EMP_FNAME||' '||EMP.EMP_LNAME AS SALES_PERS, "+
						"SM.EVENT_DATE AS EVENT_DATE, "+
						"SM.STRG_TYPE AS STRG_TYPE, "+
						"SC.FIRST_NAME||' '||SC.LAST_NAME AS CUSTOMER_NAME, "+
						"SD.DOC_ID AS REF_ID, "+
						"DL.REF_SER AS REF_SER "+
						"FROM EMPLOYEE EMP "+
						"LEFT OUTER JOIN EMPLOYEE ABM "+
						"ON EMP.REPORT_TO = ABM.EMP_CODE "+
						"LEFT OUTER JOIN EMPLOYEE RSM "+
						"ON ABM.REPORT_TO=RSM.EMP_CODE "+
						"LEFT OUTER JOIN EMPLOYEE SUPERVISOR "+
						"ON RSM.REPORT_TO=SUPERVISOR.EMP_CODE, "+
						"STRG_MEET SM, "+
						"STRG_CUSTOMER SC, "+
						"STRG_ITEM_DISPLAY SD "+
						"LEFT OUTER JOIN DOC_TRANSACTION_LINK DL "+
						"ON trim(DL.REF_ID) = SD.DOC_ID "+
						"WHERE SM.SALES_PERS=EMP.EMP_CODE "+
						"AND SM.EVENT_DATE >= ? "+
						"AND SM.EVENT_DATE <= ? "+
						"AND EMP.EMP_CODE  IN "+E12GenericUtility.getFormattedProfileId( teamSelection )+" "+
						"AND SM.STRG_CODE   = SC.SC_CODE "+
						"AND SM.STRG_TYPE IN "+E12GenericUtility.getFormattedProfileId( custType )+" "+
						"AND SM.DCR_ID     = SD.DCR_ID "+
						"AND SM.STRG_CODE = SD.STRG_CODE "+
						"AND SD.DOC_ID IS NULL "+
						"ORDER BY SALES_PERS, EVENT_DATE";
			}
			else
			{
				query = "SELECT DISTINCT SUPERVISOR.EMP_FNAME||' '||SUPERVISOR.EMP_LNAME AS SUPERVISOR_NAME, "+
						"RSM.EMP_FNAME||' '||RSM.EMP_LNAME AS RSM_NAME, "+
						"ABM.EMP_FNAME||' '||ABM.EMP_LNAME AS ABM_NAME, "+
						"EMP.HOBBY1 AS REGION, "+
						"EMP.EMP_CODE   AS SP_CODE, "+
						"EMP.EMP_FNAME||' '||EMP.EMP_LNAME AS SALES_PERS, "+
						"SM.EVENT_DATE AS EVENT_DATE, "+
						"SM.STRG_TYPE AS STRG_TYPE, "+
						"SC.FIRST_NAME||' '||SC.LAST_NAME AS CUSTOMER_NAME, "+
						"SD.DOC_ID AS REF_ID, "+
						"DL.REF_SER AS REF_SER "+
						"FROM EMPLOYEE EMP "+
						"LEFT OUTER JOIN EMPLOYEE ABM "+
						"ON EMP.REPORT_TO = ABM.EMP_CODE "+
						"LEFT OUTER JOIN EMPLOYEE RSM "+
						"ON ABM.REPORT_TO=RSM.EMP_CODE "+
						"LEFT OUTER JOIN EMPLOYEE SUPERVISOR "+
						"ON RSM.REPORT_TO=SUPERVISOR.EMP_CODE, "+
						"STRG_MEET SM, "+
						"STRG_CUSTOMER SC, "+
						"STRG_ITEM_DISPLAY SD "+
						"LEFT OUTER JOIN DOC_TRANSACTION_LINK DL "+
						"ON trim(DL.REF_ID) = SD.DOC_ID "+
						"WHERE SM.SALES_PERS=EMP.EMP_CODE "+
						"AND SM.EVENT_DATE >= ? "+
						"AND SM.EVENT_DATE <= ? "+
						"AND EMP.EMP_CODE  IN "+E12GenericUtility.getFormattedProfileId( teamSelection )+" "+
						"AND SM.STRG_CODE   = SC.SC_CODE "+
						"AND SM.STRG_TYPE IN "+E12GenericUtility.getFormattedProfileId( custType )+" "+
						"AND SM.DCR_ID     = SD.DCR_ID "+
						"AND SM.STRG_CODE = SD.STRG_CODE "+
						"ORDER BY SALES_PERS, EVENT_DATE";
			}
			mStatement = mConnection.prepareStatement(query);
			mStatement.setDate(1, java.sql.Date.valueOf(fromDate) );
			mStatement.setDate(2, java.sql.Date.valueOf(toDate) );
			//mStatement.setString(3, custType);
			mResultSet = mStatement.executeQuery();
			ResultSetMetaData rsmd = mResultSet.getMetaData();
		    int colCount = rsmd.getColumnCount();
			xmlStringBuff.append("<Root>");
			String prevValue = "";
			int counter = 0;
			while (mResultSet.next())
		    {
				String colValue = "";
//				for (int i = 1; i <= colCount; i++)
//			    {
//					String columnName = rsmd.getColumnName(i);
//			        System.out.println("columnName in loop:::"+columnName);
//			        String value = E12GenericUtility.checkNull(mResultSet.getString(i));
//			        System.out.println("Value in loop:::"+value);
//			        xmlStringBuff.append("<"+ columnName +">").append( value ).append("</"+ columnName +">");
//			        if( "SALES_PERS".equalsIgnoreCase( columnName ) )
//					{
//			        	System.out.println("inside for SALES_PERS");
//			        	salesColumn = columnName;
//			        	colValue = value;
//					}
//			    }
//				if( "SALES_PERS".equalsIgnoreCase( salesColumn ) )
//				{
					colValue = E12GenericUtility.checkNull(mResultSet.getString("SALES_PERS"));
					System.out.println("inside IF SALES_PERS prevValue["+prevValue+"] colValue["+colValue+"] counter["+counter+"]");
					if( prevValue.equals(colValue) )
					{
						counter++;
						prevValue = colValue;
					}
					else
					{
						if( prevValue != "" )
						{
							xmlStringBuff.append("<Detail1><CountDet><![CDATA[").append("Total Photos (Sales Person wise)").append("]]></CountDet>").append("<TotalCount><![CDATA[").append(counter).append("]]></TotalCount></Detail1>");
							counter = 0;
							counter++;
						}
						else
						{
							counter++;
						}
						prevValue = colValue;
					}
//				}
				xmlStringBuff.append("<Detail1>");
				xmlStringBuff.append("<SUPERVISOR_NAME><![CDATA[").append( E12GenericUtility.checkNull(mResultSet.getString("SUPERVISOR_NAME")) ).append("]]></SUPERVISOR_NAME>");
				xmlStringBuff.append("<RSM_NAME><![CDATA[").append( E12GenericUtility.checkNull(mResultSet.getString("RSM_NAME")) ).append("]]></RSM_NAME>");
				xmlStringBuff.append("<ABM_NAME><![CDATA[").append( E12GenericUtility.checkNull(mResultSet.getString("ABM_NAME")) ).append("]]></ABM_NAME>");
				xmlStringBuff.append("<REGION><![CDATA[").append( E12GenericUtility.checkNull(mResultSet.getString("REGION")) ).append("]]></REGION>");
				xmlStringBuff.append("<SP_CODE><![CDATA[").append( E12GenericUtility.checkNull(mResultSet.getString("SP_CODE")) ).append("]]></SP_CODE>");
				xmlStringBuff.append("<SALES_PERS><![CDATA[").append( E12GenericUtility.checkNull(mResultSet.getString("SALES_PERS")) ).append("]]></SALES_PERS>");
				xmlStringBuff.append("<EVENT_DATE><![CDATA[").append( e12genericUtil.getValidDateString( E12GenericUtility.checkNull(mResultSet.getDate("EVENT_DATE").toString()), e12genericUtil.getDBDateFormat(), e12genericUtil.getApplDateFormat()) ).append("]]></EVENT_DATE>");
				xmlStringBuff.append("<STRG_TYPE><![CDATA[").append( E12GenericUtility.checkNull(mResultSet.getString("STRG_TYPE")) ).append("]]></STRG_TYPE>");
				xmlStringBuff.append("<CUSTOMER_NAME><![CDATA[").append( E12GenericUtility.checkNull(mResultSet.getString("CUSTOMER_NAME")) ).append("]]></CUSTOMER_NAME>");
				xmlStringBuff.append("<REF_ID><![CDATA[").append( E12GenericUtility.checkNull(mResultSet.getString("REF_ID")) ).append("]]></REF_ID>");
				xmlStringBuff.append("<REF_SER><![CDATA[").append( E12GenericUtility.checkNull(mResultSet.getString("REF_SER")) ).append("]]></REF_SER>");
				xmlStringBuff.append("</Detail1>");
		    }
			if( counter > 0 )
			{
				xmlStringBuff.append("<Detail1><CountDet><![CDATA[").append("Total Photos (Sales Person wise)").append("]]></CountDet>").append("<TotalCount><![CDATA[").append(counter).append("]]></TotalCount></Detail1>");
			}
			xmlStringBuff.append("</Root>");
			if(mStatement!=null)
			{
				mStatement.close();
				mStatement=null;
			}
			if(mResultSet!=null)
			{
				mResultSet.close();
				mResultSet = null;
			}
			if(mConnection!= null && !mConnection.isClosed())
			{
				mConnection.close();
				mConnection = null;
			}
		}
		catch ( Exception e)
		{
			System.out.println("Exception in PhotoCaptureReportEJB.getPhotoCaptureDetails():["+e.getMessage()+"]");
			e.printStackTrace();
			//throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(mStatement!=null)
				{
					mStatement.close();
					mStatement=null;
				}
				if(mResultSet!=null)
				{
					mResultSet.close();
					mResultSet = null;
				}
				if(mConnection!= null && !mConnection.isClosed())
				{
					mConnection.close();
					mConnection = null;
				}
			}
			catch(SQLException se)
			{
				System.out.println("PhotoCaptureReportEJB.getPhotoCaptureDetails.finally["+se.getMessage()+"]");
				se.printStackTrace();
			}
		}
		System.out.println("xmlStringBuff:::["+xmlStringBuff+"]");
		return xmlStringBuff.toString();
	}
	//Added by sunny soni for getting NPC data from database according to datewise[Start]
	@Override
	public String getNPCDetailsData(String loginCode, String transDB, String fromDate, String toDate, String dispType, String teamSelection) throws RemoteException 
	{
		StringBuffer xmlStringBuff = new StringBuffer();
		System.out.println("[getNPCDetailsData]In PhotoCaptureReportEJB loginCode["+loginCode+"] transDB["+transDB+"]");

		Connection mConnection = null;
		PreparedStatement mStatement = null;
		ResultSet mResultSet = null;
		ConnDriver connDriver = new ConnDriver();
		E12GenericUtility e12genericUtil = new E12GenericUtility();
		try
		{
			if(mConnection == null)
			{
				mConnection = connDriver.getConnectDB( transDB );
			}

			fromDate = e12genericUtil.getValidDateString(fromDate, e12genericUtil.getApplDateFormat(), e12genericUtil.getDBDateFormat());
			toDate = e12genericUtil.getValidDateString(toDate, e12genericUtil.getApplDateFormat(), e12genericUtil.getDBDateFormat());
		    
		    System.out.println("fromDateStr["+fromDate+"] toDateStr["+toDate+"]");
			
		    String query = "SELECT DISTINCT SUPERVISOR.EMP_FNAME||' '||SUPERVISOR.EMP_LNAME AS SUPERVISOR_NAME, "+
						"RSM.EMP_FNAME||' '||RSM.EMP_LNAME AS RSM_NAME, "+
						"ABM.EMP_FNAME||' '||ABM.EMP_LNAME AS ABM_NAME, "+
						"EMP.HOBBY1 AS REGION, "+
						"EMP.EMP_CODE   AS SP_CODE, "+
						"EMP.EMP_FNAME||' '||EMP.EMP_LNAME AS SALES_PERS, "+
						"SM.EVENT_DATE AS EVENT_DATE, "+
						"SM.STRG_TYPE AS STRG_TYPE, "+
						"SC.FIRST_NAME||' '||SC.LAST_NAME AS CUSTOMER_NAME, "+
						"SD.DOC_ID AS REF_ID, "+
						"DL.REF_SER AS REF_SER "+
						"FROM EMPLOYEE EMP "+
						"LEFT OUTER JOIN EMPLOYEE ABM "+
						"ON EMP.REPORT_TO = ABM.EMP_CODE "+
						"LEFT OUTER JOIN EMPLOYEE RSM "+
						"ON ABM.REPORT_TO=RSM.EMP_CODE "+
						"LEFT OUTER JOIN EMPLOYEE SUPERVISOR "+
						"ON RSM.REPORT_TO=SUPERVISOR.EMP_CODE, "+
						"STRG_MEET SM, "+
						"STRG_CUSTOMER SC, "+
						"STRG_ITEM_DISPLAY SD "+
						"LEFT OUTER JOIN DOC_TRANSACTION_LINK DL "+
						"ON trim(DL.REF_ID) = SD.DOC_ID "+
						"WHERE SM.SALES_PERS=EMP.EMP_CODE "+
						"AND SM.EVENT_DATE >= ? "+
						"AND SM.EVENT_DATE <= ? "+
						"AND EMP.EMP_CODE  IN "+E12GenericUtility.getFormattedProfileId( teamSelection )+" "+
						//"AND SD.DISP_TYPE = ? "+
						"AND SD.DISP_TYPE IN( '"+dispType+"','NC' )"+
						"AND SM.STRG_CODE   = SC.SC_CODE "+
						"AND SM.DCR_ID     = SD.DCR_ID "+
						"AND SM.STRG_CODE = SD.STRG_CODE "+
						"ORDER BY SALES_PERS, EVENT_DATE";
			mStatement = mConnection.prepareStatement(query);
			mStatement.setDate(1, java.sql.Date.valueOf(fromDate) );
			mStatement.setDate(2, java.sql.Date.valueOf(toDate) );
			//mStatement.setString(3, dispType );
			mResultSet = mStatement.executeQuery();
			ResultSetMetaData rsmd = mResultSet.getMetaData();
		    int colCount = rsmd.getColumnCount();
			xmlStringBuff.append("<Root>");
			String prevValue = "";
			int counter = 0;
			while(mResultSet.next())
		    {
				String colValue = "";
				colValue = E12GenericUtility.checkNull(mResultSet.getString("SALES_PERS"));
				System.out.println("inside IF SALES_PERS prevValue["+prevValue+"] colValue["+colValue+"] counter["+counter+"]");
				if( prevValue.equals(colValue) )
				{
					counter++;
					prevValue = colValue;
				}
				else
				{
					if( prevValue != "" )
					{
						xmlStringBuff.append("<Detail1><CountDet>").append("Total Photos (Sales Person wise)").append("</CountDet>").append("<TotalCount>").append(counter).append("</TotalCount></Detail1>");
						counter = 0;
						counter++;
					}
					else
					{
						counter++;
					}
					prevValue = colValue;
				}
				xmlStringBuff.append("<Detail1>");
				xmlStringBuff.append("<SUPERVISOR_NAME><![CDATA[").append( E12GenericUtility.checkNull(mResultSet.getString("SUPERVISOR_NAME")) ).append("]]></SUPERVISOR_NAME>");
				xmlStringBuff.append("<RSM_NAME><![CDATA[").append( E12GenericUtility.checkNull(mResultSet.getString("RSM_NAME")) ).append("]]></RSM_NAME>");
				xmlStringBuff.append("<ABM_NAME><![CDATA[").append( E12GenericUtility.checkNull(mResultSet.getString("ABM_NAME")) ).append("]]></ABM_NAME>");
				xmlStringBuff.append("<REGION><![CDATA[").append( E12GenericUtility.checkNull(mResultSet.getString("REGION")) ).append("]]></REGION>");
				xmlStringBuff.append("<SP_CODE><![CDATA[").append( E12GenericUtility.checkNull(mResultSet.getString("SP_CODE")) ).append("]]></SP_CODE>");
				xmlStringBuff.append("<SALES_PERS><![CDATA[").append( E12GenericUtility.checkNull(mResultSet.getString("SALES_PERS")) ).append("]]></SALES_PERS>");
				xmlStringBuff.append("<EVENT_DATE><![CDATA[").append( e12genericUtil.getValidDateString( E12GenericUtility.checkNull(mResultSet.getDate("EVENT_DATE").toString()), e12genericUtil.getDBDateFormat(), e12genericUtil.getApplDateFormat()) ).append("]]></EVENT_DATE>");
				xmlStringBuff.append("<STRG_TYPE><![CDATA[").append( E12GenericUtility.checkNull(mResultSet.getString("STRG_TYPE")) ).append("]]></STRG_TYPE>");
				xmlStringBuff.append("<CUSTOMER_NAME><![CDATA[").append( E12GenericUtility.checkNull(mResultSet.getString("CUSTOMER_NAME")) ).append("]]></CUSTOMER_NAME>");
				xmlStringBuff.append("<REF_ID><![CDATA[").append( E12GenericUtility.checkNull(mResultSet.getString("REF_ID")) ).append("]]></REF_ID>");
				xmlStringBuff.append("<REF_SER><![CDATA[").append( E12GenericUtility.checkNull(mResultSet.getString("REF_SER")) ).append("]]></REF_SER>");
				xmlStringBuff.append("</Detail1>");
		    }
			if( counter > 0 )
			{
				xmlStringBuff.append("<Detail1><CountDet><![CDATA[").append("Total Photos (Sales Person wise)").append("]]></CountDet>").append("<TotalCount><![CDATA[").append(counter).append("]]></TotalCount></Detail1>");
			}
			xmlStringBuff.append("</Root>");
			if(mStatement!=null)
			{
				mStatement.close();
				mStatement=null;
			}
			if(mResultSet!=null)
			{
				mResultSet.close();
				mResultSet = null;
			}
			if(mConnection!= null && !mConnection.isClosed())
			{
				mConnection.close();
				mConnection = null;
			}
		}
		catch ( Exception e)
		{
			System.out.println("Exception in PhotoCaptureReportEJB.getNPCDetailsData():["+e.getMessage()+"]");
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if(mStatement!=null)
				{
					mStatement.close();
					mStatement=null;
				}
				if(mResultSet!=null)
				{
					mResultSet.close();
					mResultSet = null;
				}
				if(mConnection!= null && !mConnection.isClosed())
				{
					mConnection.close();
					mConnection = null;
				}
			}
			catch(SQLException se)
			{
				System.out.println("PhotoCaptureReportEJB.getNPCDetailsData.finally["+se.getMessage()+"]");
				se.printStackTrace();
			}
		}
		System.out.println("xmlStringBuff:::["+xmlStringBuff+"]");
		return xmlStringBuff.toString();
	}
	//Added by sunny soni for getting NPC data from database according to datewise[End]
}