/*
 * Decompiled with CFR 0.152.
 */
package ibase.servlet;

import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.utility.ITMException;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.sql.Connection;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import javax.naming.InitialContext;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class E12MonitorServersServlet
extends HttpServlet {
    protected InitialContext ctx = null;
    ServletContext servletContext = null;
    ServletConfig servletConfig = null;
    private static int MAX_UPLOAD_SIZE = 0xA00000;

    public void init(ServletConfig servletConfig) throws ServletException {
        try {
            this.servletConfig = servletConfig;
            this.servletContext = servletConfig.getServletContext();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.doPost(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        request.setCharacterEncoding(CommonConstants.ENCODING);
        response.setContentType("application/x-www-form-urlencoded; charset=" + CommonConstants.ENCODING);
        try {
            String action = request.getParameter("action");
            String respString = "";
            if (action.equals("insert2DB")) {
                String xmlFileData = request.getParameter("xmlData");
                respString = this.insert2DB(xmlFileData, response);
                request.getSession().setAttribute("responseString", (Object)respString);
                String respPath = "/jsp/LoadMonitorServerXml.jsp?action=getResponse";
                RequestDispatcher reqDis = this.servletContext.getRequestDispatcher(respPath);
                reqDis.forward((ServletRequest)request, (ServletResponse)response);
                BaseLogger.log("3", null, null, "status = " + respString);
            } else if (action.equals("getServerStatus")) {
                String lastStatus = "";
                if (request.getParameter("statusInfo") != null && request.getParameter("statusInfo").length() > 0 && request.getParameter("statusInfo") != null && request.getParameter("statusInfo").length() > 0) {
                    lastStatus = request.getParameter("statusInfo");
                }
                respString = this.getServerStatus(request, lastStatus);
                PrintWriter out = response.getWriter();
                response.setContentType("text/xml");
                BaseLogger.log("3", null, null, "status = " + respString);
                out.println(respString);
                if (respString != null) {
                    respString = "Status log generated successfully";
                }
                BaseLogger.log("3", null, null, "status = " + respString);
            } else {
                BaseLogger.log("3", null, null, "inavlid action");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getServerStatus(HttpServletRequest request, String lastStatus) {
        StringBuffer respXmlDataBuff = new StringBuffer();
        try {
            StringBuffer finalXmlDataBuff = new StringBuffer();
            String serverIp = "";
            String monitorIP = "";
            String logFileName = CommonConstants.STATUS_SERVER_lOG_FILE;
            String responseStatus = "";
            String serverName = "";
            String excepMessage = "";
            String userName = "NA";
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
            Date date = new Date();
            BaseLogger.log("3", null, null, "date = " + date);
            String requestTime = formatter.format(date);
            BaseLogger.log("3", null, null, "requestTime = " + requestTime);
            HashMap lastStatusMap = new HashMap();
            if (lastStatus != null && lastStatus.length() > 0) {
                lastStatusMap = this.getLastStatusMap(lastStatus);
            }
            HashMap configServerMap = this.getConfigServerMap();
            Iterator it = configServerMap.keySet().iterator();
            while (it.hasNext()) {
                String clientIp;
                String type;
                String Id2;
                boolean connectionStatus;
                String exceptionLogFile;
                block25: {
                    excepMessage = "NA";
                    exceptionLogFile = "";
                    connectionStatus = true;
                    Id2 = (String)it.next();
                    HashMap valueMap = (HashMap)configServerMap.get(Id2);
                    serverIp = (String)valueMap.get("SERVER_URL") != null ? (String)valueMap.get("SERVER_URL") : (String)valueMap.get("DRIVER_NAME");
                    monitorIP = (String)valueMap.get("MONITOR_IP");
                    serverName = (String)valueMap.get("SERVER_NAME");
                    type = (String)valueMap.get("TYPE");
                    if (type.equalsIgnoreCase("DB")) {
                        type = "D";
                        String driverName = (String)valueMap.get("DRIVER_NAME");
                        if (driverName == null) {
                            BaseLogger.log("3", null, null, "No Driver Specified");
                        }
                        Connection conn = null;
                        Statement stmt = null;
                        try {
                            try {
                                BaseLogger.log("3", null, null, "make connection");
                                conn = new ConnDriver().getConnectDB(driverName);
                                stmt = conn.createStatement();
                            }
                            catch (Exception exServer) {
                                exServer.printStackTrace();
                                connectionStatus = false;
                                excepMessage = exServer.toString();
                                String string = excepMessage = excepMessage.length() < 500 ? excepMessage : excepMessage.substring(0, 500);
                                if (conn != null) {
                                    stmt = null;
                                    conn.close();
                                    conn = null;
                                }
                                break block25;
                            }
                        }
                        catch (Throwable throwable) {
                            if (conn != null) {
                                stmt = null;
                                conn.close();
                                conn = null;
                            }
                            throw throwable;
                        }
                        if (conn != null) {
                            stmt = null;
                            conn.close();
                            conn = null;
                        }
                    } else if (type.equalsIgnoreCase("JBOSS") || type.equalsIgnoreCase("RFID")) {
                        type = type.equalsIgnoreCase("JBOSS") ? "J" : "F";
                        ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream(4096);
                        try {
                            try {
                                String serverUrl = (String)valueMap.get("SERVER_URL");
                                URL url = new URL(serverUrl);
                                HttpURLConnection httpConn = (HttpURLConnection)url.openConnection();
                                httpConn.setDoOutput(true);
                                httpConn.setUseCaches(false);
                                String lengthString = String.valueOf(byteOutputStream.size());
                                httpConn.setRequestProperty("Content-Length", lengthString);
                                byteOutputStream.writeTo(httpConn.getOutputStream());
                            }
                            catch (Exception exServer) {
                                connectionStatus = false;
                                exServer.printStackTrace();
                                connectionStatus = false;
                                excepMessage = exServer.toString();
                                excepMessage = excepMessage.length() < 500 ? excepMessage : excepMessage.substring(0, 500);
                                byteOutputStream.flush();
                                byteOutputStream.close();
                                break block25;
                            }
                        }
                        catch (Throwable throwable) {
                            byteOutputStream.flush();
                            byteOutputStream.close();
                            throw throwable;
                        }
                        byteOutputStream.flush();
                        byteOutputStream.close();
                    } else {
                        BaseLogger.log("3", null, null, "invalid type");
                    }
                }
                responseStatus = connectionStatus ? "S" : "F";
                if (exceptionLogFile == null || exceptionLogFile != null && exceptionLogFile.length() == 0) {
                    exceptionLogFile = "NA";
                }
                if ((clientIp = request.getHeader("X-Forwarded-For")) == null) {
                    clientIp = request.getRemoteAddr();
                }
                String machineName = InetAddress.getLocalHost().getHostName();
                if (lastStatusMap.containsKey(Id2)) {
                    BaseLogger.log("3", null, null, "id present in lastStatusMap");
                    String lastReponseValue = (String)lastStatusMap.get(Id2);
                    BaseLogger.log("3", null, null, "responseStatus not matched");
                    StringBuffer dataBuff = new StringBuffer();
                    dataBuff.append("<STATUS_LOG><MONITOR_IP>" + monitorIP + "</MONITOR_IP><SERVER_ID>" + Id2 + "</SERVER_ID>");
                    dataBuff.append("<SERVER_IP>" + serverIp + "</SERVER_IP><SERVER_TYPE>" + type + "</SERVER_TYPE>");
                    dataBuff.append("<SERVER_NAME>" + serverName + "</SERVER_NAME>");
                    dataBuff.append("<CLIENT_IP>" + clientIp + "</CLIENT_IP><REQUEST_TIME>" + requestTime + "</REQUEST_TIME>");
                    dataBuff.append("<RESPONSE_STATUS>" + responseStatus + "</RESPONSE_STATUS>");
                    dataBuff.append("<MACHINE_NAME>" + machineName + "</MACHINE_NAME>");
                    dataBuff.append("<LOG_FILE_NAME>" + exceptionLogFile + "</LOG_FILE_NAME>");
                    dataBuff.append("<LOGIN_USER>" + userName + "</LOGIN_USER>");
                    dataBuff.append("<EXCEPTION_MSG>" + excepMessage + "</EXCEPTION_MSG>");
                    dataBuff.append("</STATUS_LOG>");
                    respXmlDataBuff.append(dataBuff.toString());
                    if (!lastReponseValue.equalsIgnoreCase(responseStatus)) {
                        finalXmlDataBuff.append(dataBuff.toString());
                    }
                    dataBuff = null;
                    continue;
                }
                BaseLogger.log("3", null, null, "new server id");
                StringBuffer dataBuff = new StringBuffer();
                dataBuff.append("<STATUS_LOG><MONITOR_IP>" + monitorIP + "</MONITOR_IP><SERVER_ID>" + Id2 + "</SERVER_ID>");
                dataBuff.append("<SERVER_IP>" + serverIp + "</SERVER_IP><SERVER_TYPE>" + type + "</SERVER_TYPE>");
                dataBuff.append("<SERVER_NAME>" + serverName + "</SERVER_NAME>");
                dataBuff.append("<CLIENT_IP>" + clientIp + "</CLIENT_IP><REQUEST_TIME>" + requestTime + "</REQUEST_TIME>");
                dataBuff.append("<RESPONSE_STATUS>" + responseStatus + "</RESPONSE_STATUS>");
                dataBuff.append("<MACHINE_NAME>" + machineName + "</MACHINE_NAME>");
                dataBuff.append("<LOG_FILE_NAME>" + exceptionLogFile + "</LOG_FILE_NAME>");
                dataBuff.append("<LOGIN_USER>" + userName + "</LOGIN_USER>");
                dataBuff.append("<EXCEPTION_MSG>" + excepMessage + "</EXCEPTION_MSG>");
                dataBuff.append("</STATUS_LOG>");
                finalXmlDataBuff.append(dataBuff.toString());
                respXmlDataBuff.append(dataBuff.toString());
                dataBuff = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return respXmlDataBuff.toString();
    }

    private HashMap getConfigServerMap() {
        BaseLogger.log("2", null, null, "in getConfigServerMap");
        String filePath = String.valueOf(CommonConstants.APPLICATION_CONTEXT) + "setting" + File.separator + "monitorServer.xml";
        File file = new File(filePath);
        HashMap outerMap = new HashMap();
        if (file.exists()) {
            try {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document dom = db.parse(file);
                Element docEle = dom.getDocumentElement();
                String interval = docEle.getAttribute("INTERVAL");
                String monitorIp = docEle.getAttribute("MONITOR_IP");
                NodeList statusNodes = docEle.getElementsByTagName("SERVER");
                int statusNodesLen = statusNodes.getLength();
                int i = 0;
                while (i < statusNodesLen) {
                    Element element = (Element)statusNodes.item(i);
                    String type = element.getAttribute("SERVER_TYPE");
                    String id = element.getAttribute("ID");
                    HashMap<String, String> internalMap = new HashMap<String, String>();
                    internalMap.put("TYPE", type);
                    internalMap.put("MONITOR_IP", monitorIp);
                    internalMap.put("INTERVAL", interval);
                    Node parentNode = statusNodes.item(i);
                    NodeList childList = parentNode.getChildNodes();
                    int ctr = 0;
                    while (ctr < childList.getLength()) {
                        if (childList.item(ctr).getFirstChild() != null) {
                            internalMap.put(childList.item(ctr).getNodeName(), childList.item(ctr).getFirstChild().getNodeValue());
                        }
                        ++ctr;
                    }
                    outerMap.put(id, internalMap);
                    ++i;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return outerMap;
    }

    private String insert2DB(String xmlFileData, HttpServletResponse response) {
        String monitorIp = "";
        String serverId = "";
        String serverIp = "";
        String serverType = "";
        String serverName = "";
        String clientIp = "";
        String requestTime = "";
        String responseStatus = "";
        String logFileName = "";
        String respString = "";
        String execepMessage = "";
        String userName = "NA";
        String machineName = "";
        try {
            StringBuffer xmlString = new StringBuffer();
            xmlString.insert(0, "<ROOT>");
            if (xmlFileData != null && xmlFileData.length() > 0) {
                xmlFileData = xmlFileData.substring(xmlFileData.indexOf("<STATUS_LOG>"), xmlFileData.lastIndexOf("</STATUS_LOG>"));
                xmlString.append(xmlFileData);
                xmlString.append("</STATUS_LOG></ROOT>");
            }
            if (xmlFileData != null) {
                DBAccessEJB dbAccess = new DBAccessEJB();
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                dbf.setIgnoringComments(true);
                ByteArrayInputStream baos = new ByteArrayInputStream(xmlString.toString().getBytes());
                Document doc = db.parse(baos);
                NodeList statusNodes = doc.getElementsByTagName("STATUS_LOG");
                int statusNodesLen = statusNodes.getLength();
                int i = 0;
                while (i < statusNodesLen) {
                    Node curStatusNode = statusNodes.item(i);
                    NodeList statusDataNodList = curStatusNode.getChildNodes();
                    int statusDataNodListLen = statusDataNodList.getLength();
                    int ctr = 0;
                    while (ctr < statusDataNodListLen) {
                        Node dataNode = statusDataNodList.item(ctr);
                        String dataNodeName = dataNode.getNodeName();
                        if (dataNode.getFirstChild() != null) {
                            String dataNodeValue = dataNode.getFirstChild().getNodeValue();
                            if ("MONITOR_IP".equals(dataNodeName)) {
                                monitorIp = dataNodeValue;
                            } else if ("SERVER_ID".equals(dataNodeName)) {
                                serverId = dataNodeValue;
                            } else if ("SERVER_IP".equals(dataNodeName)) {
                                serverIp = dataNodeValue;
                            } else if ("SERVER_TYPE".equals(dataNodeName)) {
                                serverType = dataNodeValue;
                            } else if ("SERVER_NAME".equals(dataNodeName)) {
                                serverName = dataNodeValue;
                            } else if ("CLIENT_IP".equals(dataNodeName)) {
                                clientIp = dataNodeValue;
                            } else if ("REQUEST_TIME".equals(dataNodeName)) {
                                requestTime = dataNodeValue;
                            } else if ("RESPONSE_STATUS".equals(dataNodeName)) {
                                responseStatus = dataNodeValue;
                            } else if ("LOG_FILE_NAME".equals(dataNodeName)) {
                                logFileName = dataNodeValue;
                            } else if ("EXCEPTION_MSG".equals(dataNodeName)) {
                                execepMessage = dataNodeValue;
                            } else if ("USER_NAME".equals(dataNodeName)) {
                                userName = dataNodeValue;
                            } else if ("MACHINE_NAME".equals(dataNodeName)) {
                                machineName = dataNodeValue;
                            }
                        }
                        ++ctr;
                    }
                    if (serverType.equalsIgnoreCase("D")) {
                        serverIp = "NA";
                    }
                    respString = dbAccess.insertStatusLog(serverId, serverIp, serverType, serverName, clientIp, requestTime, responseStatus, logFileName, userName, execepMessage, machineName);
                    ++i;
                }
                dbAccess.remove();
                dbAccess = null;
                response.setContentType("text/xml");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return respString;
    }

    protected InitialContext getInitialContext() throws ITMException {
        InitialContext ctx = null;
        try {
            AppConnectParm appConnect = new AppConnectParm();
            ctx = new InitialContext(appConnect.getProperty());
        }
        catch (ITMException itme) {
            BaseLogger.log("0", null, null, "ITMException :RequestHandlerServlet :getInitialContext :==>");
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :RequestHandlerServlet :getInitialContext :==>");
            throw new ITMException(e);
        }
        return ctx;
    }

    protected HashMap getLastStatusMap(String lastStatus) {
        HashMap<String, String> lastStausMap = new HashMap<String, String>();
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            ByteArrayInputStream baos = new ByteArrayInputStream(lastStatus.toString().getBytes());
            Document doc = db.parse(baos);
            Element docEle = doc.getDocumentElement();
            NodeList statusNodes = docEle.getElementsByTagName("SERVER");
            int statusNodesLen = statusNodes.getLength();
            int i = 0;
            while (i < statusNodesLen) {
                Element element = (Element)statusNodes.item(i);
                String id = element.getAttribute("id");
                String serverStatus = element.getFirstChild().getNodeValue();
                lastStausMap.put(id, serverStatus);
                ++i;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return lastStausMap;
    }

    private String updateLog(Exception exServer) {
        String exceptionLogFile = "";
        File logFile = null;
        FileWriter fLogStream = null;
        BufferedWriter bwl = null;
        StringWriter writer = null;
        PrintWriter printWriter = null;
        try {
            try {
                Random random = new Random();
                int randomInt = random.nextInt(100000);
                String filePath = String.valueOf(CommonConstants.STATUS_SERVER_LOG) + File.separator + "log";
                File logDir = new File(filePath);
                exceptionLogFile = String.valueOf(randomInt) + "log";
                StringBuffer finalXmlDataBuff = new StringBuffer();
                if (!logDir.exists()) {
                    logDir.mkdirs();
                }
                logFile = new File(filePath, exceptionLogFile);
                logFile.createNewFile();
                fLogStream = new FileWriter(logFile);
                bwl = new BufferedWriter(fLogStream);
                writer = new StringWriter();
                printWriter = new PrintWriter(writer);
                exServer.printStackTrace(printWriter);
                bwl.write(((Object)writer).toString());
            }
            catch (Exception er) {
                er.printStackTrace();
                try {
                    logFile = null;
                    fLogStream = null;
                    bwl.flush();
                    bwl.close();
                    writer = null;
                    printWriter.close();
                    printWriter = null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            try {
                logFile = null;
                fLogStream = null;
                bwl.flush();
                bwl.close();
                writer = null;
                printWriter.close();
                printWriter = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return exceptionLogFile;
    }
}

