/*
 *		Developed by	: RADHESHYAM
 *		Company			: Base Information Management Pvt.Ltd
 *		Start Date		: 02/04/2014
 *		End Date		: 02/04/2014
 *		Name			: PostMarketingStudyEJBPos.java
 *		Purpose			: Creating for itemChanged/validation of post marketing study contains post_marketing_study object. 
 *		Request Id		: WS3LSUN004
 */

package ibase.webitm.ejb.wsfa.transactions;

import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.EMail;
import ibase.utility.UserInfoBean;
import ibase.webitm.utility.ITMException;
import ibase.webitm.ejb.*;
import java.sql.*;
import java.rmi.RemoteException;
import javax.ejb.*;
import org.w3c.dom.*;
import ibase.ejb.CommonDBAccessEJB;
import ibase.ejb.CommonDBAccessRemote;

@Stateless
public class RetailSchemeClaimAdmAprvPos extends ValidatorEJB 
{
	E12GenericUtility genericUtility = new E12GenericUtility();
	String routeId = "";
	protected static String database = CommonConstants.DB_NAME;
	public String postSave()throws RemoteException,ITMException
	{
		return "";
	}
	public String postSave(String domString, String tranId, String editFlag, String xtraParams, Connection conn) throws RemoteException,ITMException
	{
		System.out.println("XML for processing the dom:::"+domString);
		boolean isMailSend = false;
		String errString = "";
		String confirmed = "";
		String formatCode = "";
		String mailHeader = "";
		String salesPers = "";
		String objName = "";
		String sql = "";
		String loginEmpCode = "";
		String infoType = "ITM";
		String processInstanceId = "";
		PreparedStatement pstmt = null;
		ResultSet rs=null;
		NodeList parentNodeList = null;
		int parentNodeListLength = 0;
		tranId = checkNull(tranId);

		try
		{	
			Document dom = genericUtility.parseString(domString);
			parentNodeList = dom.getElementsByTagName("Detail1");				
			parentNodeListLength = parentNodeList.getLength();			
			System.out.println("tran_id value is"+tranId+", parentNodeListLength =["+parentNodeListLength+"]" );
			objName     = checkNull(getObjName(dom));
			String loginCode=checkNull(genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" ));
			loginEmpCode = checkNull(genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode"));			
			CommonDBAccessRemote dbAccessRemote = new CommonDBAccessEJB();
			UserInfoBean userInfo = dbAccessRemote.createUserInfo(loginCode);
			String transDB = userInfo.getTransDB();

			System.out.println("userInfo is:["+userInfo+"]transDB["+transDB+"]");

			confirmed = checkNull(genericUtility.getColumnValue("confirmed",dom));
			salesPers  = checkNull(genericUtility.getColumnValue("sales_pers",dom));

			if(confirmed.equalsIgnoreCase("R"))
			{
				sql = "UPDATE RETAIL_SCH_CLAIM SET WF_STATUS = 'D', CONFIRMED = 'N', CONF_DATE = '' WHERE TRAN_ID = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, tranId);
				int updateCount=0;
				updateCount = pstmt.executeUpdate();
				if (pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				
				formatCode = "SCHCLM_ADMREJ";

				mailHeader = 	"<ROOT>"+
						"<EMAIL_TYPE>link</EMAIL_TYPE>"+
						"<TRANS_INFO>"+
						"<OBJ_NAME>"+objName+"</OBJ_NAME>"+
						"<REF_SER>"+"CUSSTR"+"</REF_SER>"+
						"<LINE_NO>"+""+"</LINE_NO>"+
						"<XSL_FILE_NAME></XSL_FILE_NAME>"+
						"</TRANS_INFO>"+
						"<MAIL>"+
						"<ENTITY_CODE>"+salesPers+"</ENTITY_CODE>"+
						"<SUBJECT></SUBJECT>"+
						"<BODY_TEXT></BODY_TEXT>"+
						"<TO_ADD></TO_ADD>"+
						"<CC_ADD></CC_ADD>"+
						"<FORMAT_CODE>"+formatCode+"</FORMAT_CODE>"+
						"<LINK_ADDR><![CDATA[ITMTransactionEditor.jsp?OBJ_NAME=retail_sch_adm_aprv&OBJ_CONTEXT=1&EDIT_FLAG=E&DB_ID="+tranId.trim()+"]]></LINK_ADDR>"+
						"<ATTACHMENT><BODY></BODY><LOCATION></LOCATION></ATTACHMENT>"+
						"</MAIL>"+
						"<XML_DATA>"+domString+"</XML_DATA>"+
						"</ROOT>";
				System.out.println("retail_sch_adm_aprv REJECT mailHeader ------- "+mailHeader);
				isMailSend = sendMailStatus(mailHeader, infoType, processInstanceId);
				System.out.println("[RetailSchemeClaimAdmAprvPos::process()] mail delivered successful" + isMailSend);
			}

		}
		catch(Exception e)
		{		
			try
			{
				conn.rollback();
			}
			catch (SQLException ee)
			{
				// TODO Auto-generated catch block
				ee.printStackTrace();
			}
			e.printStackTrace();	
			System.out.println("Exception: RetailSchemeClaimAdmAprvPos: postSave(): " + e.getMessage() + ":");
			errString = genericUtility.createErrorString(e);
			e.printStackTrace();

		}
		System.out.println("Returning from RetailSchemeClaimAdmAprvPos postSave"+errString);
		return errString;		
	}	

	public boolean sendMailStatus(String mailXMLStr, String infoType, String processInstanceId)
	{	
		boolean isSendMail = false;
		try 
		{
			System.out.println("mailXMLStr"+mailXMLStr);
			System.out.println("infotype::"+infoType);
			EMail em = new EMail();
			String returnstrFromSendMailMethod = em.sendMail(mailXMLStr, infoType);
			System.out.println("@@@@ mail function called successfully : "+returnstrFromSendMailMethod);
			isSendMail = true;
		}
		catch (Exception e)
		{
			isSendMail = false;
			e.printStackTrace();
		}
		return isSendMail;		
	}

	private String checkNull(String input)
	{
		if (input==null)
		{
			input="";
		}
		else
		{
			input = input.trim();
		}
		return input;
	}
	private String getObjName(Document dom2)
	{	
		Node elementName = null, parentNode = null;
		NodeList elementList = null;
		Element elementAttr = null;
		String objName = "";
		elementList = dom2.getElementsByTagName("Detail1");
		elementName = elementList.item(0);
		if (elementName!=null && ("Detail1").equalsIgnoreCase(elementName.getNodeName()))
		{
			NamedNodeMap etlAttributes = elementName.getAttributes();
			if (etlAttributes!=null)
			{
				if (etlAttributes.getNamedItem("objName")!=null)
				{
					objName = etlAttributes.getNamedItem("objName").getNodeValue();
				}
			}
		}
		return objName;
	}

}

