/*
 * Developed by	: shraddha M [17-12-19]
 * 
 */
package ibase.webitm.ejb.wsfa.transactions;

import ibase.webitm.ejb.*;
import java.rmi.RemoteException;
import java.text.*;
import java.util.*;
import java.sql.*;
import java.sql.Date;
import java.io.File;
import org.w3c.dom.*;
import javax.xml.parsers.*;
import javax.ejb.*;
import javax.naming.InitialContext;

import ibase.system.config.*;
import java.text.*;
import ibase.webitm.utility.*;
import ibase.utility.CommonConstants;
import ibase.webitm.utility.GenericUtility;


@javax.ejb.Stateless

public class UnconfEventProcessItem extends ValidatorEJB implements UnconfEventProcessItemLocal,UnconfEventProcessItemRemote
{
	protected static String database = CommonConstants.DB_NAME;	

	public String wfValData() throws RemoteException,ITMException
	{
		return "";
	}

	public String wfValData(String xmlString, String xmlString1,String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = "";
		System.out.println("xmlString ["+xmlString+"]");
		System.out.println("xmlString1["+xmlString1+"]");
		System.out.println("xmlString2["+xmlString2+"]");
		try
		{
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				dom = parseString(xmlString); 
			}
			else
			{
				System.out.println("xmlstring is null");
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = parseString(xmlString1); 
			}
			else
			{
				System.out.println("xmlstring1 is null");
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = parseString(xmlString2);
			}
			else
			{
				System.out.println("xmlstring2 is null");
			}
			errString = wfValData(dom,dom1,dom2,objContext,editFlag,xtraParams);
		}
		catch(Exception e)
		{
			System.out.println("Exception : [PlanProcessValidationChange][wfValData(String xmlString)] : ==>\n"+e.getMessage());
			e.printStackTrace();
		}
		return (errString);
	}


	public String wfValData(Document dom, Document dom1,Document dom2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;
		GenericUtility genericUtility = GenericUtility.getInstance();
		String userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
		String errString = "";
		String columnValue = "";
		Connection connectionObject = null;		
		StringBuffer errStringXml;
		String errorType="";
		errStringXml = new StringBuffer();
		errStringXml.append("<?xml version=\"1.0\"?>\r\n<Root><Errors>\r\n");
		boolean isError = false;
		int ctr = 0;
		int noOfChilds = 0;
		int currentFormNo = 0;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try
		{
			ConnDriver connDriver = null;
			String childNodeName = null;
			ITMDBAccessEJB itmDBAccess = new ITMDBAccessEJB ();
			connectionObject =  getConnection();
			
			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}			
			parentList = dom2.getElementsByTagName("Detail" + currentFormNo);			
			int parentNodeListlength = parentList.getLength();			
			for (int prntCtr = 0; prntCtr < parentNodeListlength; prntCtr++ )
			{	
				parentNode = parentList.item( prntCtr );
				childList = parentNode.getChildNodes();
				noOfChilds = childList.getLength();
				
				for (ctr = 0; ctr < noOfChilds & !isError; ctr++)
				{
					childNode = childList.item(ctr);
					if( childNode.getNodeType() != Node.ELEMENT_NODE )
					{
						continue;
					}
					childNodeName = childNode.getNodeName();
					System.out.println("UnconfirmEventProcess:wfValData:childNodeName ["+childNodeName+"]");				
					switch ( currentFormNo )
					{					
						case 1:
						{
							if(childNodeName.equalsIgnoreCase("sales_pers"))
							{
								if(childNode.getFirstChild() == null)		
								{																											
									errString = itmDBAccess.getErrorString("sales_pers","NULLSLPRCD",userId );
									errorType =  errorType( connectionObject , "NULLSLPRCD" );
									if ( errorType.equalsIgnoreCase("E"))
									{
										break;
									}
									else
									{
										if ( errString.length() > 0)
										{
											String bifurErrString = errString.substring( errString.indexOf("<Errors>")+8,errString.indexOf("</Errors>"));
											errStringXml.append(bifurErrString);
											errString = "";
										}
									}
								}
							}
							
							else if ( childNodeName.equalsIgnoreCase("period_code") )
							{
								
								
								String periodCode = genericUtility.getColumnValue("period_code",dom);
								//System.out.println("periodCode>>>"+periodCode);
								String salesPerson = genericUtility.getColumnValue("sales_pers",dom);
								//System.out.println("salesPerson>>>"+periodCode);
								SimpleDateFormat sdfFormat = new SimpleDateFormat(getApplDateFormat());

								if ( childNode.getFirstChild() == null )
								{
									errString =  itmDBAccess.getErrorString("period_code","VMTRVPRDCD",userId );
									errorType =  errorType( connectionObject , "VMTRVPRDCD" );
									if ( errorType.equalsIgnoreCase("E"))
									{
										break;
									}
									else
									{
										if ( errString.length() > 0)
										{
											String bifurErrString = errString.substring( errString.indexOf("<Errors>")+8,errString.indexOf("</Errors>"));
											errStringXml.append(bifurErrString);
											errString = "";
										}
									}
								}
								else
								{
									String prdPresent = "SELECT COUNT(*) AS PRDCNT FROM STRG_EVENT_TRACK WHERE PRD_CODE = ? AND CONFIRMED ='Y' ";
									pstmt = connectionObject.prepareStatement(prdPresent);
									pstmt.setString(1,periodCode);
									rs = pstmt.executeQuery();
									int prdCnt = 0;
									if (rs.next())
									{
										prdCnt = rs.getInt("PRDCNT");
										System.out.println("PRDCNT>>"+prdCnt);
										
									}
									/*if (prdCnt == 0)
									{
										errString = getErrorString("period_code","NOPRDCODE",userId,errString);
										break;
									}*/
									if ( rs != null )
									{
										rs.close();
										rs = null;
									}
									if ( pstmt != null )
									{
										pstmt.close();
										pstmt = null;
									}
									//Added By Bhagyashri T  for Remove Dirty Connection.......[25-Jan-2022][START]
									if (prdCnt == 0)
									{
										errString = getErrorString("period_code","NOPRDCODE",userId,errString);
										break;
									}
									//Added By Bhagyashri T  for Remove Dirty Connection.......[25-Jan-2022][END]
								}
							}
						
						}	
						break;
						case 2:
						{
							if(childNodeName.equalsIgnoreCase("period_code"))
							{
								String periodCode= getValueOfField(parentNode, "period_code");
								String salesPers = getValueOfField(parentNode, "sales_pers");
								if ( childNode.getFirstChild() == null )
								{
									errString =  itmDBAccess.getErrorString("period_code","VMTRVPRDCD",userId );
									errorType =  errorType( connectionObject , "VMTRVPRDCD" );
									if ( errorType.equalsIgnoreCase("E"))
									{
										break;
									}
									
								}
								else
								{
									String periodPresent = "SELECT COUNT(*) AS EVENTCOUNT FROM STRG_EVENT_TRACK WHERE PRD_CODE > ? AND CONFIRMED='Y' AND SALES_PERS= ? ";
									pstmt = connectionObject.prepareStatement(periodPresent);
									pstmt.setString(1,periodCode);
									pstmt.setString(2,salesPers);
									rs = pstmt.executeQuery();
									int eventCnt = 0;
									if (rs.next())
									{
										eventCnt = rs.getInt("EVENTCOUNT");
										System.out.println("eventCnt>>"+eventCnt);
										
									}
									/*if (eventCnt > 0)
									{
										errString = getErrorString("period_code","UCFPRDCODE",userId,errString);
										break;
									}*/
									if ( rs != null )
									{
										rs.close();
										rs = null;
									}
									if ( pstmt != null )
									{
										pstmt.close();
										pstmt = null;
									}
									//Added by Bhagyashri T for Close Dirty Connection[25-jan-2022][start]
									if (eventCnt > 0)
									{
										errString = getErrorString("period_code","UCFPRDCODE",userId,errString);
										break;
									}
									//Added by Bhagyashri T for Close Dirty Connection[25-jan-2022][end]
								}
							}
						}
						break;
						
					}//Switch end
				}//End For
							
				if ( errString.length() > 0)
				{
					String bifurErrString = errString.substring( errString.indexOf("<Errors>")+8,errString.indexOf("</Errors>"));
					errStringXml.append(bifurErrString);
					errString = "";
				}
				
			}
		}//End Try
		catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			try
			{
				//Added by Bhagyashri T for Close Dirty Connection[25-jan-2022][start]
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if (connectionObject != null)
				{
					connectionObject.close();
					connectionObject = null;
				}
				//Added by Bhagyashri T for Close Dirty Connection[25-jan-2022][end]
				
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		errStringXml.append("</Errors></Root>\r\n");		
		errString = errStringXml.toString();
		Document responseDom = genericUtility.parseString( errString );			
		Node errorsNode = responseDom.getElementsByTagName( "Errors" ).item( 0 );
		System.out.println( "UnconfirmEventProcess:wfValData:errorsNode[" + errorsNode + "]" );
		if( errorsNode != null )
		{			
			NodeList errorChildNodeList = errorsNode.getChildNodes();			
			for(int appCnt = 0; appCnt < errorChildNodeList.getLength(); appCnt++)
			{
				Node currChild = errorChildNodeList.item(appCnt);				
				if (currChild.getNodeName().equalsIgnoreCase("error"))
				{					
					errString = errStringXml.toString();
					break;
				}
				else
				{
					errString =  "";

				}
			}
		}		
		return errString;
	}

	public String itemChanged(String xmlString, String xmlString1,String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException,ITMException 
	{

		System.out.println("xmlString ["+xmlString+"]");
		System.out.println("xmlString1["+xmlString1+"]");
		System.out.println("xmlString2["+xmlString2+"]");
		
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String valueXmlString = "";
		try
		{
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				dom = parseString(xmlString);
			}
			else
			{
				System.out.println("xmlstring is null");
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = parseString(xmlString1);
			}
			else
			{
				System.out.println("xmlstring1 is null");
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = parseString(xmlString2);
			}
			else
			{
				System.out.println("xmlstring2 is null");
			}

			valueXmlString = itemChanged(dom,dom1,dom2,objContext,currentColumn,editFlag,xtraParams);//Ratikant 23/Mar/2005
		}
		catch(Exception e)
		{
			System.out.println("Exception :UnconfirmEventProcess :itemChanged(String,String) :==>\n"+e.getMessage());
		}
		return (valueXmlString); 
		
	}
	
	public String itemChanged(Document dom, Document dom1,Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		System.out.println("UnconfirmEventProcess : itemChanged Called ");
		
		String columnValue = "";	
		String errCode = "";
		String resultString = "";
		String empCode = "";
		String domId = "";

		StringBuffer valueXmlString = null;
	
		Connection  conn = null;
		PreparedStatement pstmt = null;
		ResultSet rSet = null ;		
		ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
		GenericUtility genericUtility = GenericUtility.getInstance();
	
		int currentFormNo = 0;
		try
		{	
			conn = getConnection();
		
			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			if(currentColumn.equalsIgnoreCase("itm_default"))
			{
				columnValue = currentColumn;
			}
			domId = getDomId(dom,objContext);	
			//System.out.println("domId***"+domId);
			valueXmlString = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<editFlag>");
			valueXmlString.append(editFlag).append("</editFlag>\r\n</Header>\r\n");
						
			switch(currentFormNo)
			{

				case 1:
				{					
					valueXmlString.append("<Detail1 domID='1' >\r\n");
					if (currentColumn.trim().equalsIgnoreCase("itm_default"))
					{
						empCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode");
						
						
						valueXmlString.append("<sales_pers><![CDATA[").append( empCode ).append("]]></sales_pers>\r\n");						
						String empName = "SELECT (UPPER (EMP_FNAME )|| '  ' || UPPER(EMP_MNAME) || '  ' || UPPER(EMP_LNAME) )AS EMP_NAME,EMP_SITE FROM EMPLOYEE WHERE EMP_CODE = ?";
						pstmt = conn.prepareStatement(empName);						
						pstmt.setString(1,empCode);						
						rSet = pstmt.executeQuery();
						if( rSet.next() )
						{
							valueXmlString.append("<sales_pers_name><![CDATA[").append(rSet.getString("EMP_NAME")).append("]]></sales_pers_name>\r\n");
						}
						else
						{
							valueXmlString.append("<sales_pers_name><![CDATA[]]></sales_pers_name>\r\n");
						}
						if ( rSet != null )
						{
							rSet.close();
							rSet = null;
						}
						if( pstmt != null )
						{
							pstmt.close();
							pstmt = null;
						}

					}
					
					valueXmlString.append("</Detail1>\r\n");
				}
				break;
				
			}
			valueXmlString.append("</Root>\r\n");
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null ;
				}
				if ( rSet != null  )
				{
					rSet.close();
					rSet = null;
				}
				if ( conn != null )
				{
					conn.close();
					conn = null;
				}
			}
			catch (Exception e)
			{				
				e.printStackTrace();
			}		
			
		}
		if ( ! errCode.equals("") )
		{			
			resultString = itmDBAccessEJB.getErrorString("", errCode, "", "", conn);
		}
		else
		{
			resultString = valueXmlString.toString();
		}
		System.out.println("resultString [" + resultString + "]" );
		return resultString;
	}		
	
	private String checkNull(String input)
	{
		if (input==null)
		{
			input="";
		}
		return input;
	}
	
	private String getDomId(Document dom2,String objContext)
	{	
		Node elementName = null, parentNode = null;
		NodeList elementList = null;
		String domId = "";
		elementList = dom2.getElementsByTagName("Detail"+objContext);
		elementName = elementList.item(0);
		if (elementName!=null && ("Detail"+objContext).equalsIgnoreCase(elementName.getNodeName()))
		{
			NamedNodeMap etlAttributes = elementName.getAttributes();
			if (etlAttributes!=null)
			{
				if (etlAttributes.getNamedItem("domID")!=null)
				{
					domId = etlAttributes.getNamedItem("domID").getNodeValue();
				}
			}
		}
		return domId;
	}
	private String errorType( Connection conn , String errorCode )
	{
		String msgType = "";
		PreparedStatement pstmt = null ; 
		ResultSet rs = null;
		try
		{			
			String  sql = " SELECT MSG_TYPE FROM MESSAGES WHERE MSG_NO =   ? ";
			System.out.println("UnconfEventProcessItemEJB:errorType:sql["+sql+"]");
			pstmt = conn.prepareStatement( sql );			
			pstmt.setString(1, checkNull(errorCode));			
			rs = pstmt.executeQuery();
			while( rs.next() )
			{
				msgType = rs.getString("MSG_TYPE");
			}			
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
		}		
		finally
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}

			}
			catch ( Exception e )
			{
				e.printStackTrace();
			}
		}		
		return msgType;
	}
	private String getValueOfField(Node node, String currFieldName)throws Exception
	{
		String currFieldValue = null;
		NodeList childNodeList = node.getChildNodes();
		int noOfChilds = childNodeList.getLength();
		for(int ctr = 0; ctr < noOfChilds; ctr++)
		{
			Node currChild = childNodeList.item(ctr);
			if(currChild.getNodeName().equalsIgnoreCase(currFieldName) && currChild.getFirstChild() != null)
			{
				currFieldValue = currChild.getFirstChild().getNodeValue().trim();
				break;
			}
		}
		return currFieldValue;
	}
}
