package ibase.webitm.ejb.wsfa.masters;

import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.EMail;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.TransIDGenerator;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.GenericUtility;
import ibase.system.config.ConnDriver;

import java.net.InetAddress;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Calendar;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;

import javax.ejb.Stateless;
import javax.ejb.CreateException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

//@Stateless		commented by Sagar M [22 Nov 2018].
public class SprsRoutePos extends ValidatorEJB implements SprsRoutePosLocal,SprsRoutePosRemote
{
	E12GenericUtility genericUtility = new E12GenericUtility();
    public String postSaveRec() throws RemoteException,ITMException
	{
		return "";
	}
	public String postSaveRec(String xmlString1,String domId,String objContext,String editFlag, String xtraParams, Connection conn)throws RemoteException,ITMException
	{
		System.out.println("SprsRoutePos callel 1");
		Document dom = null;
		try
		{
			if (xmlString1 != null && xmlString1.trim().length() > 0)
			{
				dom = new E12GenericUtility().parseString(xmlString1);
				executepostSaveRec(dom,domId,objContext,editFlag,xtraParams,xmlString1,conn);
			}
		}
	   	catch(Exception e)
		{
			System.out.println("Exception :SprsRoutePos :postSaveRec() :" + e.getMessage() + ":");
			e.printStackTrace();
			throw new ITMException(e);
		}
		return "";
	}
	private String executepostSaveRec(Document dom, String domID,String objContext,String editFlag, String xtraParams,String xmlString, Connection conn)throws RemoteException,ITMException
	{ 
		System.out.println("executepostSaveRec called 2");
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String salesPers = "" ;
		String routeID = "";
		String sqlUpd = "";
		String userId = "";
		String chgTerm  = "";
		String status = "";
		String routeType="";
		java.sql.Timestamp chgDate = null;
		String loginEmpCode ="";
		int updCnt = 0;
		String sqlSelect = "";
		int selectStkCnt = 0;
		int selectChemCnt = 0;
		
		try
		{
			conn.setAutoCommit(false);
			//E12GenericUtility genericUtility = new E12GenericUtility(); //Commented by vinayak on [29/04/2016] as object has been declared on class level

			if (dom != null )
			{
				salesPers	= genericUtility.getColumnValue("sprs_code",dom);
				routeID		= genericUtility.getColumnValue("route_id",dom);
				status		= genericUtility.getColumnValue("status",dom);
				routeType   = checkNull(genericUtility.getColumnValue("route_type",dom));
				loginEmpCode = getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode");

				chgDate = new java.sql.Timestamp(System.currentTimeMillis());
				userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
				chgTerm = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"termId");
			}
			System.out.println("editflag is:["+editFlag+"]routeType is:["+routeType+"]status["+status+"]");
			
			String mgrCode = getMGREmployee(salesPers, conn); 
			System.out.println("MgrCode is:" +mgrCode);
			System.out.println("Connection establish for getMGREmployee ");
			ArrayList gradeArrayList = new ArrayList();
			String gradeS ="";
			String gradeArray = getGradeForSTP(salesPers,conn);
			System.out.println("::GradeCode for testPOW:::["+gradeArray+"]");
			String gradesql = "SELECT GRADE FROM EMPLOYEE WHERE EMP_CODE = ? ";
			pstmt = conn.prepareStatement(gradesql);
			pstmt.setString(1, salesPers);

			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				gradeS  = checkNull(rs.getString("GRADE"));
			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			System.out.println("::GradeCode for test of sales perPOW:::["+gradeS+"]");			
			if ( "N".equalsIgnoreCase(status) )
			{
				sqlUpd = "UPDATE STRG_SERIES SET STATUS = 'N', CHG_DATE = ?, CHG_USER = ?, CHG_TERM = ?  "+
								"WHERE SALES_PERS = '"+salesPers+"' " +
								"AND ROUTE_ID = '"+routeID+"' " +
								"AND STATUS = 'Y' ";
				System.out.println("Update Sql :"+sqlUpd);
				pstmt = conn.prepareStatement(sqlUpd);
				pstmt.setTimestamp(1,chgDate);
				pstmt.setString(2,userId);
				pstmt.setString(3,chgTerm);
				updCnt = pstmt.executeUpdate();
				if (updCnt >= 1)
				{
					System.out.println("Updated into strg_series Sucessfully : updCnt : " + updCnt);
				}
				pstmt.close();
				pstmt = null;
				
				
				sqlSelect = "SELECT COUNT(*) AS COUNT FROM SPRS_STOCKIST WHERE SPRS_CODE = '"+salesPers+"' AND ROUTE_ID = '"+routeID+"'";
				pstmt = conn.prepareStatement(sqlSelect);
				rs = pstmt.executeQuery();
				if (rs.next())
				{
					selectStkCnt = rs.getInt("COUNT");
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				
				if(selectStkCnt > 0)
				{
					sqlUpd = "UPDATE SPRS_STOCKIST SET STATUS = 'N', CHG_DATE = ?, CHG_USER = ?, CHG_TERM = ?  "+
							"WHERE SPRS_CODE = '"+salesPers+"' " +
							"AND ROUTE_ID = '"+routeID+"' " +
							"AND STATUS = 'Y' ";
					System.out.println("Update Sql :"+sqlUpd);
					pstmt = conn.prepareStatement(sqlUpd);
					pstmt.setTimestamp(1,chgDate);
					pstmt.setString(2,userId);
					pstmt.setString(3,chgTerm);
					updCnt = pstmt.executeUpdate();
					if (updCnt >= 1)
					{
						System.out.println("Updated into SPRS_STOCKIST Sucessfully : updCnt : " + updCnt);
					}
					pstmt.close();
					pstmt = null;
				}
				
				sqlSelect = "SELECT COUNT(*) AS COUNT FROM SPRS_CHEMIST WHERE SPRS_CODE = '"+salesPers+"' AND ROUTE_ID = '"+routeID+"'";
				pstmt = conn.prepareStatement(sqlSelect);
				rs = pstmt.executeQuery();
				if (rs.next())
				{
					selectChemCnt = rs.getInt("COUNT");
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}

				if(selectChemCnt > 0)
				{
					sqlUpd = "UPDATE SPRS_CHEMIST SET STATUS = 'N', CHG_DATE = ?, CHG_USER = ?, CHG_TERM = ?  "+
							"WHERE SPRS_CODE = '"+salesPers+"' " +
							"AND ROUTE_ID = '"+routeID+"' " +
							"AND STATUS = 'Y' ";
					System.out.println("Update Sql :"+sqlUpd);
					pstmt = conn.prepareStatement(sqlUpd);
					pstmt.setTimestamp(1,chgDate);
					pstmt.setString(2,userId);
					pstmt.setString(3,chgTerm);
					updCnt = pstmt.executeUpdate();
					if (updCnt >= 1)
					{
						System.out.println("Updated into SPRS_CHEMIST Sucessfully : updCnt : " + updCnt);
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
				}
			}
			//Added by mrunalini sinakr for update Sales pers status as resubmit on 21-March-20 CCf-IT2018-080 W19LSUN009(start)
			if(mgrCode ==null || mgrCode.trim().length() == 0)
			{
			if("A".equalsIgnoreCase(editFlag) && "Y".equalsIgnoreCase(status) && ("H".equalsIgnoreCase(routeType) || "X".equalsIgnoreCase(routeType) || "O".equalsIgnoreCase(routeType)))
			{
				//Added By Bhagyashri T For not update the sales pers for perticular Div[21/04/21]
				System.out.println("Inside add flag of Place of Wrk to be added");
				if(gradeArray != null && gradeArray.trim().length() > 0)
				{
					String[] grdArray = gradeArray.split(",");
					System.out.println("GradeCode is::>>::"+grdArray);

					for( int cntr = 0 ; cntr < grdArray.length ; cntr++ )
                    {
						gradeArrayList.add(checkNull(grdArray[cntr]));
                    }
				}
				System.out.println("GradearrayList POW::::>>::["+gradeArrayList+"]::SalesGradeCode POW val::["+gradeS+"]");
				
				if(gradeArrayList.contains(gradeS) )
				{
					int insertCnt=insertIntoSTPStatus(salesPers,loginEmpCode,conn);
					if(insertCnt>0)
					{
						String sql = "UPDATE SALES_PERS SET STP_STATUS  = ?,STP_STATUS_REASON=? WHERE SALES_PERS = ? "; 
						pstmt = conn.prepareStatement( sql );
						pstmt.setString(1, "2");
						pstmt.setString(2, "STP status is update from Place Of Work transaction");
						pstmt.setString(3, salesPers);
						int updateCount = pstmt.executeUpdate();
						if(pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						}
						if( updateCount > 0 )
						{
							System.out.println("Update statement executed. update the STP_STATUS AS 2 MEANS RESUBMIT STP AND BLOCK THE DAR::"+updateCount);
							String objName = getObjNameFromDom( dom, "objName" , 1);
							String refSer = getRefser(objName,conn);

							String formatCode = "ROUTSTP";
							String rejectMailSent=sendMailStatus(salesPers, xmlString,formatCode,objName,refSer,conn);
						}   
					}
				}
				
				//Added By Bhagyashri T For not update the sales pers for perticular Div[21/04/21]
			}
			if(!"A".equalsIgnoreCase(editFlag))
			{
				boolean isStpResubmit=false;
				String oldStatus=checkNull(genericUtility.getColumnValue("old_status",dom));
				String oldRouteType=checkNull(genericUtility.getColumnValue("old_route_type",dom));

				System.out.println("oldStatus is:["+oldStatus+"]oldRouteType is:["+oldRouteType+"]");
				if(!status.equalsIgnoreCase(oldStatus))
				{
					if("Y".equalsIgnoreCase(status) && ("H".equalsIgnoreCase(routeType) || "X".equalsIgnoreCase(routeType) || "O".equalsIgnoreCase(routeType)))
					{
						isStpResubmit=true;
					}
					else if("N".equalsIgnoreCase(status) && ("H".equalsIgnoreCase(oldRouteType) || "X".equalsIgnoreCase(oldRouteType) || "O".equalsIgnoreCase(oldRouteType)))
					{
						isStpResubmit=true;

					}
				}
				else if("Y".equalsIgnoreCase(oldStatus) && "Y".equalsIgnoreCase(status))
				{
					if(!oldRouteType.equalsIgnoreCase(routeType) && ("H".equalsIgnoreCase(routeType) || "X".equalsIgnoreCase(routeType) || "O".equalsIgnoreCase(routeType)) )
					{
						isStpResubmit=true;

					}
				}
				else
				{
					isStpResubmit=false;
				}
			
				if(isStpResubmit)
				{
					//Added By Bhagyashri T For not update the sales pers for perticular Div[21/04/21]
					System.out.println("Inside Edit flag of Place of Wrk to be added");
					if(gradeArray != null && gradeArray.trim().length() > 0)
					{
						String[] grdArray = gradeArray.split(",");
						System.out.println("GradeCode is EDIT POW::>>::"+grdArray);

						for( int cntr = 0 ; cntr < grdArray.length ; cntr++ )
	                    {
							gradeArrayList.add(checkNull(grdArray[cntr]));
	                    }
					}
					System.out.println("GradearrayList EDIT POW ::::>>::["+gradeArrayList+"]::SalesGradeCode EDIT POW val::["+gradeS+"]");
					
					if(gradeArrayList.contains(gradeS) )
					{
						int insertCnt=insertIntoSTPStatus(salesPers,loginEmpCode,conn);
						if(insertCnt>0)
						{
							String sql = "UPDATE SALES_PERS SET STP_STATUS  = ?,STP_STATUS_REASON=? WHERE SALES_PERS = ? "; 
							pstmt = conn.prepareStatement( sql );
							pstmt.setString(1, "2");
							pstmt.setString(2, "STP status is update from Place Of Work transaction");
							pstmt.setString(3, salesPers);
							int updateCount = pstmt.executeUpdate();
							if(pstmt != null)
							{
								pstmt.close();
								pstmt = null;
							}
							if( updateCount > 0 )
							{
								System.out.println("Update statement executed. update the STP_STATUS AS 2 MEANS RESUBMIT STP AND BLOCK THE DAR::"+updateCount);
								String objName = getObjNameFromDom( dom, "objName" , 1);
								String refSer = getRefser(objName,conn);

								String formatCode = "ROUTSTP";
								String rejectMailSent=sendMailStatus(salesPers, xmlString,formatCode,objName,refSer,conn);
							}   
						}
					}	
				}
				//Added By Bhagyashri T For not update the sales pers for perticular Div[21/04/21]

			}
		}
			//Added by mrunalini sinakr for update Sales pers status as resubmit on 21-March-20 CCf-IT2018-080 W19LSUN009(end)

		}
		catch (SQLException sqe)
		{
			System.out.println("The SQLException occurs in SprsRoutePos :: executepostSaveRec():: "+sqe);
			sqe.printStackTrace();
			try
			{
				conn.rollback();
			}
			catch(Exception e1)
			{
				
			}
			throw new ITMException(sqe);
		}
		catch(Exception e)
		{
			System.out.println("The Exception occurs in SprsRoutePos :: executepostSaveRec():: "+e);
			e.printStackTrace();
			try
			{
				conn.rollback();
			}
			catch(Exception e1){}
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception :SprsRoutePos :: executepostSaveRec():: \n"+e.getMessage());
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return "";
	}
	//Added by mrunalini sinakr for update Sales pers status as resubmit on 21-March-20 CCf-IT2018-080  W19LSUN009(start)
	public String checkNull(String input)
	{
		if (input == null || "null".equalsIgnoreCase(input))
		{
			input= "";
		}
		return input.trim();
	}
	public String sendMailStatus(String salesPers, String xmlString,String formatCode,String objName,String refSer,Connection conn) throws RemoteException ,ITMException
	{
		System.out.println("Inside sendMailStatus method:");
		String mailHeader = "";
		String infoType = "ITM";
		String returnstrFromSendMailMethod="";
		try
		{
			EMail em = new EMail();
			mailHeader = 	"<ROOT>"+
			"<TRANS_INFO>"+
			"<OBJ_NAME>"+objName+"</OBJ_NAME>"+
			"<REF_SER>"+refSer+"</REF_SER>"+
			"<LINE_NO>"+""+"</LINE_NO>"+
			"<XSL_FILE_NAME></XSL_FILE_NAME>"+
			"</TRANS_INFO>"+
			"<MAIL>"+
			"<SUBJECT></SUBJECT>"+
			"<ENTITY_CODE>"+salesPers.trim()+"</ENTITY_CODE>"+
			"<BODY_TEXT></BODY_TEXT>"+
			"<TO_ADD></TO_ADD>"+
			"<CC_ADD></CC_ADD>"+
			"<FORMAT_CODE>"+formatCode+"</FORMAT_CODE>"+
			"<ATTACHMENT><BODY></BODY><LOCATION></LOCATION></ATTACHMENT>"+
			"</MAIL>"+
			"<XML_DATA>"+xmlString+"</XML_DATA>"+
			"</ROOT>";

			returnstrFromSendMailMethod = em.sendMail(mailHeader, infoType,conn);
			System.out.println("@@@@ mail function called successfully : "+returnstrFromSendMailMethod);

		}
		catch (Exception ex)
		{
			ex.printStackTrace();
			throw new ITMException(ex);
		}

		return returnstrFromSendMailMethod;
	}
	public String getObjNameFromDom( Document dom, String attribute , int currFormNo) throws ITMException
	{
		System.out.println("inside the obj name method");
		String objName = "";
		try
		{
			NodeList detailList = null;
			Node currDetail = null;
			int	detailListLength = 0;

			detailList = dom.getElementsByTagName("Detail" + currFormNo);
			detailListLength = detailList.getLength();
			for (int ctr = 0;ctr < detailListLength;ctr++)
			{
				currDetail = detailList.item(ctr);
				objName = currDetail.getAttributes().getNamedItem(attribute).getNodeValue();
				System.out.println("objName is:"+objName);
				break;

			}
			if(objName == null || objName.trim().length() == 0)
			{
				NodeList objNameList = dom.getElementsByTagName("objName");
				if(objNameList != null && objNameList.getLength() > 0)
				{
					Node objNameNode = objNameList.item(0);
					if(objNameNode != null && objNameNode.getFirstChild() != null)
					{
						objName = checkNull(objNameNode.getFirstChild().getNodeValue());
					}
				}
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		return objName;
	}
	public String getRefser(String objName,Connection conn)
	{
		String refSer="",sql="";
		PreparedStatement pstmt=null;
		ResultSet rs=null;
		try
		{
			sql="SELECT REF_SER FROM TRANSETUP WHERE TRAN_WINDOW=?";
			pstmt=conn.prepareStatement(sql);
			pstmt.setString(1, "w_"+objName);
			rs=pstmt.executeQuery();
			if(rs.next())
			{
				refSer=checkNull(rs.getString("REF_SER"));
			}
			if( rs != null )
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}

		return refSer;
	}
	private int insertIntoSTPStatus(String salesPers,String loginEmpCode,Connection conn) throws ITMException
	{
		int insertCnt=0;
		PreparedStatement pstmt = null;

		try 
		{
			java.util.Date date = Calendar.getInstance().getTime();
			DateFormat dtFormat = new SimpleDateFormat(getApplDateFormat());
			String currentDate = dtFormat.format( date );
			String aftDateDB= genericUtility.getValidDateTimeString( currentDate , getApplDateFormat() , getDBDateFormat());
			InetAddress ownIP=InetAddress.getLocalHost();
			String chgTerm = ownIP.getHostAddress();
			
			String tranId=generateTranId(conn, "w_sprs_stp_status");
			String sql="Insert into SPRS_STP_STAT (TRAN_ID,TRAN_DATE,SALES_PERS,STP_STATUS,STP_STATUS_REASON,CHG_DATE,CHG_USER,CHG_TERM) values (?,?,?,?,?,?,?,?)";
			pstmt=conn.prepareStatement(sql);
			pstmt.setString(1, tranId);
			pstmt.setTimestamp(2, java.sql.Timestamp.valueOf(aftDateDB));
			pstmt.setString(3, salesPers);
			pstmt.setString(4, "2");
			pstmt.setString(5, "STP status is update from Place Of Work transaction");
			pstmt.setTimestamp(6, java.sql.Timestamp.valueOf(aftDateDB));
			pstmt.setString(7, loginEmpCode);
			pstmt.setString(8, chgTerm);
			insertCnt=pstmt.executeUpdate();
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}

		} 
		catch (Exception e) 
		{
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		finally
		{
			try
			{		
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch (Exception e)
			{
				throw new ITMException(e);
			}
		}
		System.out.println("insertCnt in sprsroute Master is["+insertCnt+']');
		return insertCnt;
	}
	
	private String generateTranId( Connection conn,String winName ) throws ITMException
	{
		String uniqueKey = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try
		{
			//System.out.println("RealTimeReportPos : Generating Primary Key ...........");

			String keyStringQuery = "SELECT KEY_STRING, TRAN_ID_COL, REF_SER FROM TRANSETUP WHERE TRAN_WINDOW = ? ";
			pstmt = conn.prepareStatement(keyStringQuery);
			pstmt.setString(1, winName);
			rs = pstmt.executeQuery();

			if(rs.next())
			{
				String keyString = rs.getString("KEY_STRING");
				String keyCol = rs.getString("TRAN_ID_COL");
				String tranSer = rs.getString("REF_SER");
				String xmlValues ="<?xml version=\"1.0\" encoding=\"utf-8\"?><Root>";
				xmlValues = xmlValues + "<Header></Header>";
				xmlValues = xmlValues + "<Detail1>";
				xmlValues = xmlValues +        "<tran_id></tran_id>";
				xmlValues = xmlValues + "</Detail1></Root>";
				TransIDGenerator tg = new TransIDGenerator(xmlValues, "BASE", CommonConstants.DB_NAME);
				uniqueKey = tg.generateTranSeqID(tranSer, keyCol, keyString, conn);
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}		
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		catch(Exception exp)
		{
			throw new ITMException(exp);
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}		
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch (Exception e)
			{
				throw new ITMException(e);
			}
		}
		System.out.println("Generated Primary Key :"+uniqueKey);
		return uniqueKey;
	}
	//Added by mrunalini sinakr for update Sales pers status as resubmit on 21-March-20 CCf-IT2018-080  W19LSUN009(end)
	public String getMGREmployee(String empCode,Connection conn) throws ITMException
	{
		 System.out.println("Entering into getMGREmployee");
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String empCodeMGR = "";
		String selectSql = "";
		try
		{
			selectSql = "SELECT A.EMP_CODE AS EMP_CODE FROM EMPLOYEE A, GRADE B " + "WHERE A.EMP_CODE = ? " + "AND A.GRADE = B.GRADE_CODE " + "AND B.GRADE_TYPE = 'M' ";

			pstmt = conn.prepareStatement(selectSql);
			pstmt.setString(1, empCode);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				empCodeMGR = checkNull(rs.getString("EMP_CODE"));
			}
			rs.close();
		} catch (Exception e)
		{
			throw new ITMException(e);
		} finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}


			}
			catch (Exception e1){}

		}
		System.out.println("Manager Employee Code is:" +empCodeMGR);
		return empCodeMGR;
	}
	//Added By Bhagyashri T For not update the sales pers for perticular Div[21/04/21]
	public String getGradeForSTP(String salesPers,Connection conn) throws ITMException
	{
		System.out.println("In side getGradeForstp............");
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		PreparedStatement pstmt1 = null;
		ResultSet rs1 = null;
		String empSite="";
		String itemSer="";
		String paramValue="";
		PreparedStatement allPstmt = null;
		ResultSet allRs = null;
		boolean isLocalConn =false;
		String grdCode="";
		try
		{
			if(conn == null)
			{
				conn = getConnection();
				isLocalConn =true;
			}
			String sql = "SELECT SITE_CODE__DEF FROM USERS WHERE CODE = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, salesPers);

			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				empSite  = checkNull(rs.getString("SITE_CODE__DEF"));
			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}

			String getSalesPerData = " SELECT SALES_PERS.ITEM_SER,ITEMSER.DESCR FROM ITEMSER LEFT OUTER JOIN SALES_PERS ON ITEMSER.ITEM_SER = SALES_PERS.ITEM_SER "+
					" WHERE  SALES_PERS.SALES_PERS = ? ";

			pstmt = conn.prepareStatement(getSalesPerData);
			pstmt.setString(1, salesPers);

			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				itemSer  = checkNull(rs.getString("ITEM_SER"));
			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String sysDate = sdf.format(new java.util.Date());
			sysDate  = genericUtility.getValidDateString(sysDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateTimeFormat());
			System.out.println("SiteCode is::"+empSite);
			System.out.println("Item_ser(Div) is::"+itemSer);
			sql=" SELECT PARM_VALUE  "+
					" FROM SFAPARM  "+
					" WHERE ORG_UNIT =?  "+
					" AND ACTIVE='Y'  "+
					" AND PARM_NAME='STP_APPL_GRADE' "+
					" AND ?  BETWEEN EFF_FROM AND VALID_UPTO ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,empSite+"_"+itemSer);
			pstmt.setTimestamp(2,java.sql.Timestamp.valueOf(sysDate));
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				grdCode  = checkNull(rs.getString(1));
				System.out.println("grdCode(Site_Div) getGradeCodeSTP:::["+grdCode+"]");
			}	
			else
			{
				pstmt1 = conn.prepareStatement(sql);
				pstmt1.setString(1, "X"+"_"+itemSer);
				pstmt1.setTimestamp(2,java.sql.Timestamp.valueOf(sysDate));
				rs1 = pstmt1.executeQuery();
				if(rs1.next())
				{
					grdCode  = checkNull(rs1.getString(1));
					System.out.println("GradeCode(X_Div) getGradeCodeSTP:::["+grdCode+"]");
				}
				else
				{
					allPstmt = conn.prepareStatement(sql);
					allPstmt.setString(1, "ALL");
					allPstmt.setTimestamp(2,java.sql.Timestamp.valueOf(sysDate));
					allRs = allPstmt.executeQuery();
					if(allRs.next())
					{
						grdCode  = checkNull(allRs.getString(1));
					}
					System.out.println("GradeCode(ALL) getGradeCodeSTP:::["+grdCode+"]");
				}
				
				if ( allRs != null )
				{
					allRs.close();
					allRs = null;
				}
				if ( allPstmt != null )
				{
					allPstmt.close();
					allPstmt = null;
				}
				if ( rs1 != null )
				{
					rs1.close();
					rs1 = null;
				}
				if ( pstmt1 != null )
				{
					pstmt1.close();
					pstmt1 = null;
				}
			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			System.out.println("Check Split before:::["+grdCode+"]");	
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if( isLocalConn && conn != null && ! conn.isClosed() )
				{
					conn.close();
					conn = null;
				}
			}
			catch (SQLException e) 
			{
				e.printStackTrace();
			}
		}
		System.out.println("GradeCode are:::["+grdCode+"]");
		return grdCode;
	}
	//Added By Bhagyashri T For not update the sales pers for perticular Div[21/04/21]
}
