package ibase.webitm.bean.wsfa;

import java.io.File;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.DateFormat;
import java.text.SimpleDateFormat;

import javax.servlet.http.HttpSession;

import ibase.system.config.ConnDriver;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
//import ibase.webitm.utility.GenericUtility;//changed by rahul 10-apr-2015
import ibase.webitm.utility.ITMException;


public class RetailSchemeClaimBean 
{

	private UserInfoBean userInfo = null;
	private HttpSession sessionCtx = null;
	private String objName = "";
	private String user_lang ="en"; 
	private String user_country = "US";
	private UserInfoBean userInfoBean = null;
	static int num = 1;

	public RetailSchemeClaimBean( String objName, HttpSession sessionCtx ) throws ITMException
	{
		try
		{
			this.objName = objName;
			this.sessionCtx = sessionCtx;
			this.userInfo = ( ibase.utility.UserInfoBean ) this.sessionCtx.getAttribute("USER_INFO");
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
	}

	public RetailSchemeClaimBean() throws ITMException
	{
		
	}

	public UserInfoBean getUserInfo()
	{
		return this.userInfo;
	}
	public void setUserInfo(UserInfoBean userInfo) 
	{
		System.out.println("getUserInfo"+userInfo);
		this.userInfo = userInfo;
		System.out.println("getUserInfo"+userInfo);
	}

	public String checkNull(String input)
	{
		if (input == null || "null".equalsIgnoreCase(input))
		{
			input= "";
		}
		return input.trim();
	}

	public String getRetailWorkflowData( String refId, String refSer, String linkTitle ) throws ITMException
	{
		String visitData = "";
		String custData = "";
		Connection connectionObject = null; 
		try
		{
			connectionObject =getConnection();
			String xslFileName = "";
			System.out.println("connectionObject ["+connectionObject+"linkTitle ["+linkTitle+"]");
			System.out.println("refId ["+refId+"]"); 
			visitData = getWorkflowData(refId, refSer, connectionObject);
			xslFileName = getXSLFileName( "retail_claim_workflow_data_wiz_" + this.user_lang + "_" + this.user_country + ".xsl" );
			visitData = ( new ibase.webitm.utility.GenericUtility() ).transformToString( xslFileName, visitData, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{

			try
			{
				if ( connectionObject != null && !connectionObject.isClosed()) 
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{

			}
		}

		System.out.println("visitData:::"+visitData);
		return visitData;
	}

	public String getWorkflowData( String refId, String refSer, Connection conn) throws ITMException
	{
		System.out.println("Inside getWorkflowData::::::::::::::::::"+refId);
		String sql = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		boolean isLocalConn = false;
		StringBuffer valueXmlString = new StringBuffer("<Root>\r\n");
		java.util.Date signDate = null;
		String dispSignDate = "", signDateStr = "", entityCode = "", roleCodeSign = "";
		String empName = "", designation = "";
		String [] empNameDesign = new String [2];
		try
		{
			if(conn == null)
			{
				conn =getConnection();
				isLocalConn =true;
			}
			
			DateFormat applDateTimeFormat = new SimpleDateFormat(genericUtility.getApplDateTimeFormat());
			
			DateFormat applFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());
			
			sql = "SELECT '' AS REF_SER, TRAN_ID AS REF_ID, 21 AS LINE_NO,'' AS ROLE_CODE__SIGN,CONF_DATE AS SIGN_DATE, REMARKS SIGN_REMARKS, CONFIRMED AS SIGN_STATUS, EMP_CODE__APRV AS ENTITY_CODE, "+ 
				  "(CASE WHEN TO_CHAR(CONF_DATE) = TO_CHAR(SYSDATE) THEN 'TODAY' WHEN TO_CHAR(CONF_DATE) = TO_CHAR(SYSDATE - 1) THEN 'YESTERDAY' ELSE TO_CHAR(CONF_DATE,'DD-MON-YYYY') END) AS DISP_SIGN_DATE "+ 
				  "FROM RETAIL_SCH_CLAIM WHERE TRAN_ID = ? AND CONFIRMED = 'Y' "+
				  "UNION "+
				  "SELECT REF_SER, REF_ID, LINE_NO, ROLE_CODE__SIGN, SIGN_DATE, SIGN_REMARKS, SIGN_STATUS, ENTITY_CODE, "+
				  "(CASE WHEN TO_CHAR(SIGN_DATE) = TO_CHAR(SYSDATE) THEN 'TODAY' WHEN TO_CHAR(SIGN_DATE) = TO_CHAR(SYSDATE - 1) " + 
				  "THEN 'YESTERDAY' ELSE TO_CHAR(SIGN_DATE,'DD-MON-YYYY HH12:MI AM') END) AS DISP_SIGN_DATE FROM OBJ_SIGN_TRANS WHERE REF_ID = ? AND REF_SER = ? " +
				  "ORDER BY LINE_NO DESC ";
			
			/*sql = "SELECT REF_SER, REF_ID, LINE_NO, ROLE_CODE__SIGN, SIGN_DATE, SIGN_REMARKS, SIGN_STATUS, ENTITY_CODE, "+
				  "(CASE WHEN TO_CHAR(SIGN_DATE) = TO_CHAR(SYSDATE) THEN 'TODAY' WHEN TO_CHAR(SIGN_DATE) = TO_CHAR(SYSDATE - 1) " + 
				  "THEN 'YESTERDAY' ELSE TO_CHAR(SIGN_DATE,'DD-MON-YYYY HH12:MI AM') END) AS DISP_SIGN_DATE FROM OBJ_SIGN_TRANS WHERE REF_ID = ? AND REF_SER = ? " +
				  "ORDER BY LINE_NO DESC ";*/
			
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, refId);
			pstmt.setString(2, refId);
			pstmt.setString(3, refSer);
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				signDate = rs.getDate("SIGN_DATE");
				dispSignDate = checkNull(rs.getString("DISP_SIGN_DATE"));
				entityCode = checkNull(rs.getString("ENTITY_CODE"));
				roleCodeSign = checkNull(rs.getString("ROLE_CODE__SIGN"));
				empNameDesign = getEmpNameDesign(entityCode, conn);
				empName = empNameDesign [0];
				designation = empNameDesign [1];
				
				signDateStr = applDateTimeFormat.format(signDate);
				
				valueXmlString.append("<prior_visit >\r\n");
				valueXmlString.append("<ref_ser><![CDATA[" ).append(checkNull(rs.getString("REF_SER"))).append( "]]></ref_ser>\r\n" );
				valueXmlString.append("<ref_id><![CDATA[").append(checkNull(rs.getString("REF_ID"))).append("]]></ref_id>\r\n");
				valueXmlString.append("<line_no><![CDATA[").append(checkNull(rs.getString("LINE_NO"))).append("]]></line_no>\r\n");
				valueXmlString.append("<sign_status><![CDATA[").append(checkNull(rs.getString("SIGN_STATUS"))).append("]]></sign_status>\r\n");
				valueXmlString.append("<sign_remarks><![CDATA[").append(checkNull(rs.getString("SIGN_REMARKS"))).append("]]></sign_remarks>\r\n");
				valueXmlString.append("<sign_date><![CDATA[").append(signDateStr).append("]]></sign_date>\r\n");
				valueXmlString.append("<sign_date_disp><![CDATA[").append(dispSignDate).append("]]></sign_date_disp>\r\n");
				valueXmlString.append("<emp_code><![CDATA[").append(entityCode).append("]]></emp_code>\r\n");
				valueXmlString.append("<emp_name><![CDATA[").append(empName).append("]]></emp_name>\r\n");
				valueXmlString.append("<role_code><![CDATA[").append(roleCodeSign).append("]]></role_code>\r\n");
				valueXmlString.append("<emp_designation><![CDATA[").append(designation).append("]]></emp_designation>\r\n");
				valueXmlString.append("</prior_visit>\r\n");
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(isLocalConn && conn != null && ! conn.isClosed() )
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{

			}
		}
		valueXmlString.append( "</Root>\r\n" );
		System.out.println( "\n****ValueXmlString :" + valueXmlString.toString() + ":********" );
		return valueXmlString.toString();
	}
	private String getXSLFileName( String xslFileName )throws ITMException
	{   
		String retFileName = null;
		try
		{
			String defaultPath = null;
			if( CommonConstants.APPLICATION_CONTEXT != null )
			{
				defaultPath = CommonConstants.APPLICATION_CONTEXT + CommonConstants.ITM_CONTEXT + File.separator;
			}
			else
			{
				defaultPath = ".." + File.separator + "webapps" + File.separator + "ibase" + File.separator + CommonConstants.ITM_CONTEXT + File.separator;
			}
			File xslPath = new File( defaultPath + File.separator  + "xsl" + File.separator);
			if ( !xslPath.exists() )
			{
				xslPath.mkdir();
			}
			System.out.println( " xslPath [" + xslPath +"] xslFileName ["+xslFileName +"]");
			File xslFile = new File(xslPath , xslFileName);
			if( xslFile.exists() )
			{
				retFileName = xslFile.getAbsolutePath();
			}
			else
			{
				throw new ITMException( new Exception( retFileName + " Wizard XSL file Not Found") );	
			}
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		return retFileName;
	}

	public Connection getConnection()
	{
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		try
		{
			System.out.println(" In StrgMeetwizardBean :: getConnection() :: ["+this.userInfo+"]");
			System.out.println(" In StrgMeetwizardBean :: getConnection() :: ["+this.userInfoBean+"]");
			if(this.userInfo != null)
			{
				String transDB = this.userInfo.getTransDB();

				System.out.println(" StrgMeetwizardBean getConnection :: transDB :: ["+transDB+"]");

				if( transDB != null && transDB.trim().length() > 0 && !"null".equalsIgnoreCase(transDB))
				{
					conn = connDriver.getConnectDB(transDB);
					connDriver = null;
					System.out.println(" StrgMeetwizardBean getConnection :: transDB :: on if condition :["+transDB+"]");
				}
				else
				{
					System.out.println(" StrgMeetwizardBean :: transDB is null :: So that creating connection using DriverITM....");					
					conn = connDriver.getConnectDB("DriverITM");
					connDriver = null;
				}
			}
			else
			{
				System.out.println(" StrgMeetwizardBean :: UserInfo is null :: So that creating connection using DriverITM....");
				conn = connDriver.getConnectDB("DriverITM");
				connDriver = null;
			}
		}
		catch(Exception e)
		{
			System.out.println("Exception : [StrgMeetwizardBean][getConnection] :==>\n"+e.getMessage());
			e.printStackTrace();
		}
		return conn;
	}

	public java.util.Date getDateObject(String date) throws RemoteException,ITMException
	{
		java.util.Date dat = null;
		E12GenericUtility genericUtility = new E12GenericUtility();

		try
		{			
			SimpleDateFormat simpleDateFormat = new SimpleDateFormat(genericUtility.getDBDateFormat());
			dat = simpleDateFormat.parse(date);
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		return dat;
	}
	private String[] getEmpNameDesign(String empCode,Connection conn) throws ITMException
	{
		String [] nameDesign = new String [2];
		String employeCode = "";
		try
		{
			PreparedStatement pstmt = null;
			ResultSet rs = null;

			String nameSql = "SELECT UPPER(EMP_FNAME) ||' '|| UPPER(EMP_LNAME) AS EMP_NAME,EMP_CODE, DESIGN_CODE from employee 	WHERE EMP_CODE= ? ";
			pstmt = conn.prepareStatement(nameSql);

			pstmt.setString(1,empCode);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				nameDesign[0] = checkNull(rs.getString("EMP_NAME"));
				employeCode = checkNull(rs.getString("EMP_CODE"));
				nameDesign[1] = checkNull(rs.getString("DESIGN_CODE"));
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}

		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		System.out.println("nameDesign::"+nameDesign);
		return nameDesign;
	}
}