package ibase.webitm.utility.wsfa;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import javax.ejb.Stateless;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ibase.system.config.ConnDriver;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;

public class PostWorkflowSign extends ValidatorEJB
{
	E12GenericUtility genericUtility = new E12GenericUtility();
	public String updateWFStatus()throws RemoteException,ITMException
	{
		return "";
	}

	public String updateWFStatus(String domString, Connection conn) throws RemoteException,ITMException
	{
		String retVal = "";
		String refSer = "";
		String tourID = "";
		String signStatus = "";
		String signRemarks = "";
		boolean isLocalConn = false;
		try
		{
			System.out.println("domString["+domString+"]");

			if (conn == null)
			{
				conn = getConnection();
				isLocalConn = true;
			}

			Document dom = genericUtility.parseString(domString);

			refSer = genericUtility.getColumnValue("ref_ser",dom,"1");
			tourID = genericUtility.getColumnValue("ref_id",dom,"1");
			signStatus = genericUtility.getColumnValue("sign_status",dom,"1");
			signRemarks = genericUtility.getColumnValue("sign_remarks",dom,"1");

			retVal = updateSignStatus( refSer, tourID, signStatus, signRemarks, conn);
			retVal = updateWfPrcStatus( refSer, tourID, conn );

		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if ( conn != null )
				{
					if ( isLocalConn )
					{
						conn.close();
						conn = null;
					}
				}
            }
			catch(Exception e)
			{
			}
		}
		return "";
	}

		public String updateSignStatus( String refSer, String refID, String signStatus, String signRemarks, Connection conn ) throws RemoteException, ITMException
		{
			System.out.println("[ExpenseConfirmation] signStatus Method called..refSer=["+refSer+"], refID=["+refID+"]");
			ResultSet rSet = null;
			PreparedStatement pstmt = null;
			PreparedStatement pstmtInsert = null;
			ResultSet rSet1 = null;
			PreparedStatement pstmtInner = null;
			boolean localConn = false;


			try
			{
				if ( conn == null )
				{
					conn = getConnection();
					localConn = true;
				}
				String sqlInsert = "";
				sqlInsert = "INSERT INTO OBJ_SIGN_STATUS_CHG (REF_SER, REF_ID, LINE_NO, ROLE_CODE__SIGN, SIGN_DATE, USER_ID__SIGN, SIGN_REMARKS, EMP_CODE, CREATE_DATE, ROLE_TYPE, ROLE_ENTITY, ENTITY_CODE, PRC_INST__WF, SIGN_STATUS__OLD, SIGN_STATUS__NEW, DATE_INSERT)  VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
				pstmtInsert =  conn.prepareStatement( sqlInsert );

				String sql = "SELECT REF_SER, REF_ID, LINE_NO, ROLE_CODE__SIGN, SIGN_DATE, USER_ID__SIGN, SIGN_REMARKS, EMP_CODE, CREATE_DATE, ROLE_TYPE, ROLE_ENTITY, ENTITY_CODE, PRC_INST__WF, SIGN_STATUS FROM OBJ_SIGN_TRANS WHERE REF_SER = ? AND REF_ID = ? AND SIGN_STATUS = 'U' ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, refSer);
				pstmt.setString(2, refID);
				rSet = pstmt.executeQuery();
				while ( rSet.next() )
				{
					pstmtInsert.setString(1, rSet.getString("REF_SER"));
					pstmtInsert.setString(2, rSet.getString("REF_ID"));
					pstmtInsert.setInt(3, rSet.getInt("LINE_NO"));
					pstmtInsert.setString(4, rSet.getString("ROLE_CODE__SIGN"));
					pstmtInsert.setTimestamp(5, rSet.getTimestamp("SIGN_DATE"));
					pstmtInsert.setString(6, rSet.getString("USER_ID__SIGN"));
					pstmtInsert.setString(7, rSet.getString("SIGN_REMARKS"));
					pstmtInsert.setString(8, rSet.getString("EMP_CODE"));
					pstmtInsert.setTimestamp(9, rSet.getTimestamp("CREATE_DATE"));
					pstmtInsert.setString(10, rSet.getString("ROLE_TYPE"));
					pstmtInsert.setString(11, rSet.getString("ROLE_ENTITY"));
					pstmtInsert.setString(12, rSet.getString("ENTITY_CODE"));
					pstmtInsert.setString(13, rSet.getString("PRC_INST__WF"));
					pstmtInsert.setString(14, rSet.getString("SIGN_STATUS"));
					pstmtInsert.setString(15, "Z");
					pstmtInsert.setTimestamp(16, new java.sql.Timestamp(System.currentTimeMillis()));
					int updtRow = pstmtInsert.executeUpdate();
					pstmtInsert.clearParameters();
					System.out.println(":ROWS INSERTED:["+updtRow+"]");
				}
			}
			catch (Exception e)
			{
				try
				{
					conn.rollback();
				}
				catch(Exception sqe)
				{
					sqe.printStackTrace();
					throw new ITMException(sqe);
	            }
				e.printStackTrace();
				throw new ITMException(e);
			}
			finally
			{
				try
				{
					if(rSet != null)
					{
						rSet.close();
						rSet = null;
					}
					if(pstmtInsert != null)
					{
						pstmtInsert.close();
						pstmtInsert = null;
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
				}
				catch ( Exception e)
				{
					e.printStackTrace();
				}
			}
			return "";
		}


		public String updateWfPrcStatus( String refSer, String refID, Connection conn ) throws RemoteException, ITMException
		{
			System.out.println("[ExpenseConfirmation] updateWfPrcStatus Method called..refSer=["+refSer+"], refID=["+refID+"]");

			String selectSql = "";
			String updateSql = "";
			String getStatus = "";
			String entityCode = "";
			String prcInstWf = "";
			String splitVal[] = null;

			int updCnt = 0;

			ResultSet rSet = null;
			PreparedStatement pstmt = null;
			PreparedStatement pstmtUpd = null;
			PreparedStatement pstmtInsert = null;
			boolean localConn = false;

			try
			{
				if ( conn == null )
				{
					conn = getConnection();
					localConn = true;
				}

				String sqlInsert = "INSERT INTO WF_PRC_STATUS_CHG ( PROCESS_ID, INSTANCE_ID, ACTIVITY_ID, PROCESS_STATUS, SEQ_ID, REF_SER, REF_ID, ENTITY_CODE__PERF, DATE_INSERT )  VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
				pstmtInsert =  conn.prepareStatement( sqlInsert );
				selectSql = "SELECT ENTITY_CODE, PRC_INST__WF FROM OBJ_SIGN_STATUS_CHG WHERE REF_SER = ? AND REF_ID = ? AND SIGN_STATUS__NEW = 'Z' ";
				pstmt = conn.prepareStatement(selectSql);
				pstmt.setString(1, refSer);
				pstmt.setString(2, refID);
				rSet = pstmt.executeQuery();
				while ( rSet.next() )
				{
					entityCode	= rSet.getString("ENTITY_CODE");
					prcInstWf	= rSet.getString("PRC_INST__WF");
					splitVal = prcInstWf.split(":");

					System.out.println("Start Setting parameter values \n");
					System.out.println("PROCESS_ID =["+splitVal[0]+"]");
					System.out.println("INSTANCE_ID =["+splitVal[1]+"]");
					System.out.println("ACTIVITY_ID =["+splitVal[2]+"]");
					System.out.println("SEQ_ID =["+splitVal[3]+"]");
					System.out.println("REF_SER =["+refSer+"]");
					System.out.println("REF_ID =["+refID+"]");
					System.out.println("ENTITY_CODE__PERF =["+entityCode+"]");
					System.out.println("\nEnd Setting parameter values \n");
					pstmtInsert.setString(1, splitVal[0]);
					pstmtInsert.setInt(2, Integer.parseInt(splitVal[1]));
					pstmtInsert.setString(3, splitVal[2]);
					pstmtInsert.setInt(4, 7 );
					pstmtInsert.setInt(5, Integer.parseInt(splitVal[3]));
					pstmtInsert.setString(6, refSer);
					pstmtInsert.setString(7, refID);
					pstmtInsert.setString(8, entityCode);
					pstmtInsert.setTimestamp(9, new java.sql.Timestamp(System.currentTimeMillis()));
					int updtRow = pstmtInsert.executeUpdate();
					pstmtInsert.clearParameters();
					System.out.println(":ROWS INSERTED:["+updtRow+"]");
					splitVal = null;
					entityCode = "";
					prcInstWf = "";
				}
			}
			catch (Exception e)
			{
				try
				{
					conn.rollback();
				}
				catch(Exception sqe)
				{
					sqe.printStackTrace();
					throw new ITMException(sqe);
	            }
				e.printStackTrace();
				throw new ITMException(e);
			}
			finally
			{
				try
				{
					if(rSet != null)
					{
						rSet.close();
						rSet = null;
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					if(pstmtInsert != null)
					{
						pstmtInsert.close();
						pstmtInsert = null;
					}
				}
				catch ( Exception e)
				{
					e.printStackTrace();
				}
			}
			return "";
		}
}
