/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.notification.servlet;

import ibase.system.config.AppConnectParm;
import ibase.utility.BaseException;
import ibase.utility.BaseLogger;
import ibase.utility.UserInfoBean;
import ibase.webitm.notification.ejb.NotificationEJB;
import ibase.webitm.notification.ejb.NotificationMessage;
import ibase.webitm.notification.ejb.PublishPushNotificationEJB;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class NotificationServlet
extends HttpServlet {
    private static final String SERVER_ID = "AIzaSyAYfiHifWwAMGOck_XHC2jakJpkciMxLN4";

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doPost(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        NotificationEJB foo = null;
        try {
            String output = "";
            UserInfoBean userInfo = (UserInfoBean)req.getSession().getAttribute("USER_INFO");
            String action = req.getParameter("action");
            BaseLogger.log("3", userInfo, null, "NotificationServlet action[" + action + "]userInfo[" + userInfo + "]");
            if (action != null) {
                String msgIds;
                String userCode;
                String userId;
                foo = new NotificationEJB();
                if (action.equals("LOGIN")) {
                    userId = req.getParameter("username");
                    BaseLogger.log("3", userInfo, null, "LOGIN : userId:" + userId);
                    this.login(req, userId);
                } else if (action.equals("SENDMSG")) {
                    userCode = "";
                    String userLevel = "";
                    if (userInfo != null) {
                        userCode = userInfo.getLoginCode();
                        userLevel = userInfo.getUserLevel();
                    }
                    int notifyType = Integer.parseInt(this.checkNull(req.getParameter("notifyType")));
                    String notifyTo = this.checkNull(req.getParameter("notifyTo"));
                    String message = this.checkNull(req.getParameter("notifyMessage"));
                    String sentBy = this.checkNull(req.getParameter("sentBy"));
                    BaseLogger.log("3", userInfo, null, "userCode[" + userCode + "]userLevel[" + userLevel + "]notifyType[" + notifyType + "]notifyTo[" + notifyTo + "]notifyMessage[" + message + "]sentBy[" + sentBy + "]");
                    this.sendMessage(userCode, userLevel, notifyType, notifyTo, message, sentBy, userInfo);
                } else if (action.equals("GETMSG")) {
                    userId = req.getParameter("userId");
                    output = userId != null && userId.trim().length() > 0 ? foo.getMessagesXML(userId) : "<MESSAGES></MESSAGES>";
                } else if (action.equals("ADDGRP")) {
                    String groupName = req.getParameter("groupName");
                    output = groupName != null && groupName.trim().length() > 0 ? foo.addGroup(groupName) : "ERROR: MISSING GROUP NAME";
                } else if (action.equals("GETUSRS")) {
                    userCode = "";
                    String userLevel = "";
                    if (userInfo != null) {
                        userCode = userInfo.getLoginCode();
                        userLevel = userInfo.getUserLevel();
                    }
                    String searchParam = req.getParameter("searchParam");
                    String searchParamValue = req.getParameter(searchParam);
                    BaseLogger.log("3", userInfo, null, "userCode[" + userCode + "]userLevel[" + userLevel + "]searchParam[" + searchParam + "]searchParamValue[" + searchParamValue + "]");
                    output = foo.getUsersXML(userCode, userLevel, searchParamValue);
                } else if (action.equals("GETPERMISSION")) {
                    userId = req.getParameter("userId");
                    output = userId != null && userId.trim().length() > 0 ? foo.getPermissionsForUser(userId) : "<PERMISSIONS></PERMISSIONS>";
                } else if (action.equals("UPDATEPERMISSION")) {
                    userId = req.getParameter("userId");
                    String groupNames = req.getParameter("groupNames");
                    if (userId != null && userId.trim().length() > 0) {
                        ArrayList<String> groups = new ArrayList<String>();
                        if (groupNames != null) {
                            StringTokenizer stringTokenizer = new StringTokenizer(groupNames, ",");
                            while (stringTokenizer.hasMoreTokens()) {
                                groups.add(stringTokenizer.nextToken());
                            }
                        }
                        foo.updatePermissions(userId, groups);
                        output = "SUCCESS";
                    } else {
                        output = "ERROR: MISSING GROUP NAMES";
                    }
                } else if (action.equals("UPDATESTATUS")) {
                    userId = req.getParameter("userId");
                    long msgId = new Long(req.getParameter("msgId"));
                    int status = new Integer(req.getParameter("status"));
                    foo.updateStatus(userId, msgId, status);
                    output = "SUCCESS";
                } else if ("GET_NOTIFICATION_LOG".equals(action)) {
                    if (userInfo != null) {
                        BaseLogger.log("3", userInfo, null, "==== GET_NOTIFICATION_LOG======");
                        output = foo.getNotificationLogData(userInfo.getLoginCode());
                    } else {
                        output = "Failure";
                    }
                } else if ("UPDATE_NOTIFICATION_LOG_STATUS".equals(action)) {
                    msgIds = this.checkNull(req.getParameter("msgIds"));
                    output = userInfo != null ? foo.updateNotificationLogStatus(msgIds, userInfo.getLoginCode()) : "Failure";
                } else if (action.equalsIgnoreCase("GET_NOTIFICATION_COUNT")) {
                    if (userInfo != null) {
                        String currentUserID = userInfo.getLoginCode();
                        try {
                            NotificationEJB notificationEJB = new NotificationEJB();
                            BaseLogger.log("3", userInfo, null, "----Calling NotificationServlet .getNotificationLogCounter(currentUserID) currentUserID[" + currentUserID + "]");
                            output = notificationEJB.getNotificationLogCounter(currentUserID);
                            BaseLogger.log("3", userInfo, null, "----After Calling NotificationServlet .getNotificationLogCounter(currentUserID) menucounter" + output);
                        }
                        catch (Exception ex) {
                            System.err.println("Exception In NotificationLogServlet :: doPost() : ACTION:GET_NOTIFICATION_COUNT" + ex.getMessage());
                        }
                    } else {
                        output = "Failure";
                    }
                } else if ("UPDATE_NOTIFICATION_LOG_STATUS".equals(action)) {
                    msgIds = this.checkNull(req.getParameter("msgIds"));
                    if (userInfo == null) {
                        output = "Failure";
                    }
                } else if ("GET_IMP_NOTIFICATION_LOG".equals(action)) {
                    if (userInfo != null) {
                        BaseLogger.log("3", userInfo, null, "==== GET_IMP_NOTIFICATION_LOG ======");
                        output = foo.getImpNotificationLogData(userInfo.getLoginCode());
                    } else {
                        output = "Failure";
                    }
                } else {
                    output = "ERROR: INVALID ACTION REQUEST";
                }
            }
            ServletOutputStream os = resp.getOutputStream();
            os.write(output.getBytes());
            os.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void login(HttpServletRequest request, String userId) throws Exception {
    }

    public void sendMessage(String userCode, String userLevel, int notifyType, String notifyTo, String message, String sentBy, UserInfoBean userInfoBean) throws Exception {
        ArrayList<String> usersList = new ArrayList();
        NotificationMessage dbMessage = new NotificationMessage();
        dbMessage.setId(new Date().getTime());
        dbMessage.setMessage(message);
        dbMessage.setFromCode(sentBy);
        dbMessage.setTime(new Timestamp(new Date().getTime()));
        NotificationEJB foo = new NotificationEJB();
        if (notifyType == 1) {
            usersList = foo.saveMessagesForAllUsers(dbMessage, userCode, userLevel);
        } else if (notifyType == 2) {
            StringTokenizer stringTokenizer = new StringTokenizer(notifyTo, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String u = stringTokenizer.nextToken();
                usersList.add(u);
            }
            if (usersList != null && usersList.size() > 0) {
                foo.saveMessagesForUsers(dbMessage, usersList);
            }
        }
        this.publishPushNotificationEJB().invockPushNotification(message, null, "S", "", usersList, null, userInfoBean);
    }

    private String checkNull(String value) {
        if (value == null || "undefined".equalsIgnoreCase(value)) {
            value = "";
        }
        return value.trim();
    }

    private PublishPushNotificationEJB publishPushNotificationEJB() throws BaseException {
        PublishPushNotificationEJB publishPushNotificationEJB = null;
        try {
            AppConnectParm appConnect = new AppConnectParm();
            Properties p = appConnect.getProperty();
            InitialContext ctx = new InitialContext(p);
            BaseLogger.log("3", null, null, "Looking Up for PublishPushNotification EJB with Properties==>\n" + p);
            publishPushNotificationEJB = new PublishPushNotificationEJB();
        }
        catch (BaseException be) {
            BaseLogger.log("0", null, null, "Exception: publishPushNotificationEJB:==>\n" + be);
            throw be;
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception: publishPushNotificationEJB:==>\n" + e);
            throw new BaseException(e);
        }
        return publishPushNotificationEJB;
    }
}

