/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.ejb.sys;

import ibase.scheduler.utility.interfaces.Schedule;
import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.ejb.sys.CreateRCPXML;
import ibase.webitm.reports.utility.JasperReportGenerator;
import ibase.webitm.reports.utility.XSDParser;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeMap;
import javax.naming.InitialContext;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AutoMailingScheduler
implements Schedule {
    String transDB = null;
    String objName = null;
    String mailFormat = null;
    String reportName = null;
    String startDate = null;
    String tranIdCol = "";
    String tableName = "";
    String tranDateCol = "";
    E12GenericUtility genericUtility = new E12GenericUtility();

    public String schedule(HashMap arg0) throws Exception {
        return null;
    }

    public String schedule(String scheduleParamXML) throws Exception {
        Connection conn = null;
        ConnDriver connDriver = new ConnDriver();
        String sql = "";
        String dataStr = "";
        Statement pstmt = null;
        ResultSet rs = null;
        boolean isError = false;
        BaseLogger.log((String)"3", null, null, (Object)"::::::::::::::::::::::::::::Inside AutoMailingScheduler:::::::::::::::::::::::");
        BaseLogger.log((String)"3", null, null, (Object)("::::::::::::::::::::::::::::scheduleParamXML:::::::::::::::::::::::" + scheduleParamXML));
        try {
            try {
                String emailIDMail = "";
                String cCMail = "";
                String mailSubjectMail = "";
                String bodyMail = "";
                String emailID = "";
                String cC = "";
                String mailSubject = "";
                String body = "";
                String argXmStr = "";
                int updCnt = 0;
                Document ediDataDom = null;
                HashMap mapTranSetup = null;
                TreeMap argMap = null;
                ArrayList<String> arrTranSiteCode = new ArrayList<String>();
                ArrayList<String> arrTranID = new ArrayList<String>();
                ArrayList<Timestamp> arrTranDate = new ArrayList<Timestamp>();
                Document document = new E12GenericUtility().parseString(scheduleParamXML);
                UserInfoBean userInfo = new UserInfoBean(new E12GenericUtility().serializeDom(document.getElementsByTagName("USERINFOXML").item(0).getChildNodes().item(0)));
                String userName = userInfo.getLoginCode();
                this.getArguments(scheduleParamXML);
                BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("transDB::::" + this.transDB));
                if (this.transDB != null && this.transDB.trim().length() > 0) {
                    conn = connDriver.getConnectDB(this.transDB);
                }
                connDriver = null;
                XSDParser xsdParser = new XSDParser(this.objName, userInfo);
                JasperReportGenerator jasperReport = new JasperReportGenerator(userInfo);
                mapTranSetup = this.getTranSetupDetails(conn);
                this.tranIdCol = (String)mapTranSetup.get("tran_id_col");
                this.tableName = (String)mapTranSetup.get("table_name");
                this.tranDateCol = (String)mapTranSetup.get("tran_date_col");
                Timestamp tranDate = Timestamp.valueOf(String.valueOf(this.genericUtility.getValidDateString(this.startDate, this.genericUtility.getApplDateFormat(), this.genericUtility.getDBDateFormat())) + " 00:00:00.0");
                sql = "select " + this.tranIdCol + " ,SITE_CODE, " + this.tranDateCol + " from " + this.tableName + " where " + this.tranDateCol + " >= ? and DOC_SENT = 'N'" + " order by " + this.tranIdCol + " ";
                pstmt = conn.prepareStatement(sql);
                pstmt.setTimestamp(1, tranDate);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    arrTranID.add(this.checkNull(rs.getString(1)));
                    arrTranSiteCode.add(this.checkNull(rs.getString(2)));
                    arrTranDate.add(rs.getTimestamp(3));
                }
                pstmt.close();
                pstmt = null;
                rs.close();
                rs = null;
                BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("Tran Id array list::::" + arrTranID));
                BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("Tran Site Code array list::::" + arrTranSiteCode));
                BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("Tran Date array list::::" + arrTranDate));
                sql = "select SEND_TO, COPY_TO,SUBJECT, BODY_TEXT from mail_format where FORMAT_CODE = ?";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, this.mailFormat);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    emailID = this.checkNull(rs.getString("SEND_TO"));
                    cC = this.checkNull(rs.getString("COPY_TO"));
                    mailSubject = this.checkNull(rs.getString("SUBJECT"));
                    body = this.checkNull(rs.getString("BODY_TEXT"));
                }
                pstmt.close();
                pstmt = null;
                rs.close();
                rs = null;
                BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("emailID::::" + emailID));
                BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("cC::::" + cC));
                BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("mailSubject::::" + mailSubject));
                BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("body::::" + body));
                CreateRCPXML createRCPXML = new CreateRCPXML("w_" + this.objName, this.tranIdCol);
                int i = 0;
                while (i < arrTranID.size()) {
                    dataStr = createRCPXML.getTranXML((String)arrTranID.get(i), conn);
                    ediDataDom = this.genericUtility.parseString(dataStr);
                    argXmStr = this.getReportArguments((String)arrTranID.get(i), (String)arrTranSiteCode.get(i), (Timestamp)arrTranDate.get(i));
                    argMap = jasperReport.createArgMap(argXmStr);
                    emailIDMail = this.getEmailAddress(emailID, ediDataDom, userInfo);
                    cCMail = this.getEmailAddress(cC, ediDataDom, userInfo);
                    mailSubjectMail = this.getFormatedEmailSub(mailSubject, ediDataDom);
                    bodyMail = this.getFormatedEmailBody(body, ediDataDom);
                    BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("emailIDMail::::" + emailIDMail));
                    BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("cCMail::::" + cCMail));
                    BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("mailSubjectMail::::" + mailSubjectMail));
                    BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("bodyMail::::" + bodyMail));
                    String outputFilename = String.valueOf(this.objName) + userName + System.currentTimeMillis();
                    try {
                        sql = CommonConstants.DB_NAME.equalsIgnoreCase("DB2") ? " select " + this.tranIdCol + " from " + this.tableName + " where " + this.tranIdCol + " =? for update " : (CommonConstants.DB_NAME.equalsIgnoreCase("MSSQL") ? " select " + this.tranIdCol + " from " + this.tableName + " (updlock) where " + this.tranIdCol + " =? " : " select " + this.tranIdCol + " from " + this.tableName + " where " + this.tranIdCol + " =? for update nowait ");
                        pstmt = conn.prepareStatement(sql);
                        pstmt.setString(1, (String)arrTranID.get(i));
                        rs = pstmt.executeQuery();
                        if (!rs.next()) {
                            rs.close();
                            pstmt.close();
                            BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)"Table Lock Unsuccessfull::::");
                        } else {
                            String tranIdColumn = rs.getString(1);
                            BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("tranIdColumn::::" + tranIdColumn));
                            rs.close();
                            rs = null;
                            pstmt.close();
                            pstmt = null;
                            jasperReport.createAndMailReport(this.reportName, argMap, xsdParser, userName, outputFilename, emailIDMail, cCMail, mailSubjectMail, bodyMail, userInfo);
                            sql = "update " + this.tableName + " set DOC_SENT = 'Y' where " + this.tranIdCol + " =?";
                            pstmt = conn.prepareStatement(sql);
                            pstmt.setString(1, (String)arrTranID.get(i));
                            updCnt = pstmt.executeUpdate();
                            if (updCnt > 0) {
                                conn.commit();
                            }
                            pstmt.close();
                            pstmt = null;
                            ediDataDom = null;
                        }
                    }
                    catch (Exception e) {
                        isError = true;
                        e.printStackTrace();
                        BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)"Report Generation and sending of mail failed");
                    }
                    ++i;
                }
            }
            catch (SQLException e) {
                isError = true;
                e.printStackTrace();
                throw new ITMException((Exception)e);
            }
            catch (ITMException e) {
                isError = true;
                e.printStackTrace();
                throw new ITMException((Exception)((Object)e));
            }
            catch (RemoteException e) {
                isError = true;
                e.printStackTrace();
                throw new ITMException((Exception)e);
            }
            catch (Exception e) {
                isError = true;
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (isError) {
                    conn.rollback();
                } else {
                    conn.commit();
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (conn != null && !conn.isClosed()) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new ITMException(ex);
            }
        }
        return null;
    }

    public String schedulePriority(String arg0) throws Exception {
        return null;
    }

    private void getArguments(String xmlParam) throws Exception {
        Document document = new E12GenericUtility().parseString(xmlParam);
        NodeList schldObjList = document.getElementsByTagName("SCHEDULE_OBJ");
        int noOfSchldObj = schldObjList.getLength();
        int schCtr = 0;
        while (schCtr < noOfSchldObj) {
            Node schldObj = schldObjList.item(schCtr);
            String activityId = null;
            if (schldObj.getAttributes() != null && schldObj.getAttributes().getNamedItem("name") != null) {
                activityId = schldObj.getAttributes().getNamedItem("name").getFirstChild().getNodeValue();
            }
            if (activityId.equalsIgnoreCase("Auto_Mail_Schedule")) {
                this.parseNode(schldObj);
                Node parm = schldObj.getChildNodes().item(0);
                BaseLogger.log((String)"3", null, null, (Object)("total nodes---" + schldObj.getChildNodes().getLength()));
                if (parm != null) {
                    this.parseNode(schldObj);
                }
            }
            ++schCtr;
        }
    }

    private String parseNode(Node paramNode) throws Exception {
        Node rootNode = paramNode.getChildNodes().item(0);
        NodeList ndList = null;
        if (rootNode != null) {
            ndList = rootNode.getChildNodes();
            int ndListLen = ndList.getLength();
            BaseLogger.log((String)"3", null, null, (Object)("ndListLen [" + ndListLen + "]"));
            if (ndListLen > 0) {
                if (rootNode != null && rootNode.getChildNodes() != null && rootNode.getChildNodes().item(0) != null && rootNode.getChildNodes().item(0).getFirstChild() != null) {
                    this.transDB = rootNode.getChildNodes().item(0).getFirstChild().getNodeValue();
                }
                if (ndListLen > 1 && rootNode != null && rootNode.getChildNodes() != null && rootNode.getChildNodes().item(1) != null && rootNode.getChildNodes().item(1).getFirstChild() != null) {
                    this.objName = rootNode.getChildNodes().item(1).getFirstChild().getNodeValue();
                }
                if (ndListLen > 2 && rootNode != null && rootNode.getChildNodes() != null && rootNode.getChildNodes().item(2) != null && rootNode.getChildNodes().item(2).getFirstChild() != null) {
                    this.mailFormat = rootNode.getChildNodes().item(2).getFirstChild().getNodeValue();
                }
                if (ndListLen > 3 && rootNode != null && rootNode.getChildNodes() != null && rootNode.getChildNodes().item(3) != null && rootNode.getChildNodes().item(3).getFirstChild() != null) {
                    this.reportName = rootNode.getChildNodes().item(3).getFirstChild().getNodeValue();
                }
                if (ndListLen > 4 && rootNode != null && rootNode.getChildNodes() != null && rootNode.getChildNodes().item(4) != null && rootNode.getChildNodes().item(4).getFirstChild() != null) {
                    this.startDate = rootNode.getChildNodes().item(4).getFirstChild().getNodeValue();
                }
            }
        } else {
            BaseLogger.log((String)"3", null, null, (Object)"Root Node Nulll");
        }
        return "";
    }

    private String getReportArguments(String tranID, String siteCode, Timestamp atranDate) throws ITMException, Exception {
        StringBuffer argStrBuff = new StringBuffer();
        String as_cust_fr = "00";
        String as_cust_to = "ZZ";
        String tranDate = null;
        SimpleDateFormat sdf = new SimpleDateFormat(this.genericUtility.getApplDateFormat());
        tranDate = sdf.format(atranDate).toString().trim();
        argStrBuff.append("<Arguments>");
        argStrBuff.append("<Argument id=\"as_site_code\" name=\"as_site_code\">");
        argStrBuff.append("<argType>java.lang.String</argType>");
        argStrBuff.append("<value>" + siteCode + "</value>");
        argStrBuff.append("</Argument>");
        argStrBuff.append("<Argument id=\"as_cust_fr\" name=\"as_cust_fr\">");
        argStrBuff.append("<argType>java.lang.String</argType>");
        argStrBuff.append("<value>" + as_cust_fr + "</value>");
        argStrBuff.append("</Argument>");
        argStrBuff.append("<Argument id=\"as_cust_to\" name=\"as_cust_to\">");
        argStrBuff.append("<argType>java.lang.String</argType>");
        argStrBuff.append("<value>" + as_cust_to + "</value>");
        argStrBuff.append("</Argument>");
        argStrBuff.append("<Argument id=\"as_invoice_dt_fr\" name=\"as_invoice_dt_fr\">");
        argStrBuff.append("<argType>java.util.Date</argType>");
        argStrBuff.append("<value>" + tranDate + "</value>");
        argStrBuff.append("</Argument>");
        argStrBuff.append("<Argument id=\"as_invoice_dt_to\" name=\"as_invoice_dt_to\">");
        argStrBuff.append("<argType>java.util.Date</argType>");
        argStrBuff.append("<value>" + tranDate + "</value>");
        argStrBuff.append("</Argument>");
        argStrBuff.append("<Argument id=\"as_invoice_id_fr\" name=\"as_invoice_id_fr\">");
        argStrBuff.append("<argType>java.lang.String</argType>");
        argStrBuff.append("<value>" + tranID + "</value>");
        argStrBuff.append("</Argument>");
        argStrBuff.append("<Argument id=\"as_invoice_id_to\" name=\"as_invoice_id_to\">");
        argStrBuff.append("<argType>java.lang.String</argType>");
        argStrBuff.append("<value>" + tranID + "</value>");
        argStrBuff.append("</Argument>");
        argStrBuff.append("<Argument id=\"report_save_type\" name=\"report_save_type\">");
        argStrBuff.append("<argType>java.lang.String</argType>");
        argStrBuff.append("<value>PDF</value>");
        argStrBuff.append("</Argument>");
        argStrBuff.append("<Argument id=\"data_source\" name=\"data_source\">");
        argStrBuff.append("<argType>java.lang.String</argType>");
        argStrBuff.append("<value>SQL</value>");
        argStrBuff.append("</Argument>");
        argStrBuff.append("</Arguments>");
        BaseLogger.log((String)"2", null, null, (Object)("AutoMailingScheduler:>Returning the arg value---------------" + argStrBuff.toString()));
        return argStrBuff.toString();
    }

    private HashMap getTranSetupDetails(Connection conn) throws Exception {
        String sql = "";
        String tran_id_col = "";
        String table_name = "";
        String tran_date_col = "";
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String tran_win = "w_" + this.objName;
        sql = "select TRAN_ID_COL, TABLE_NAME, TRAN_DATE_COL from transetup where tran_window = ?";
        pstmt = conn.prepareStatement(sql);
        pstmt.setString(1, tran_win);
        rs = pstmt.executeQuery();
        if (rs.next()) {
            tran_id_col = this.checkNull(rs.getString(1));
            table_name = this.checkNull(rs.getString(2));
            tran_date_col = this.checkNull(rs.getString(3));
        }
        pstmt.close();
        pstmt = null;
        rs.close();
        rs = null;
        HashMap<String, String> mapTranSetup = new HashMap<String, String>();
        mapTranSetup.put("tran_id_col", tran_id_col);
        mapTranSetup.put("table_name", table_name);
        mapTranSetup.put("tran_date_col", tran_date_col);
        return mapTranSetup;
    }

    private String getEmailAddress(String emailAddrFlds, Document tranDom, UserInfoBean userInfo) throws ITMException {
        String emailAddress = "";
        NodeList detailNodeList = null;
        Node detailNode = null;
        Document detailDom = null;
        String[] emailAddrFldArr = emailAddrFlds.split(",");
        String currentAddrFld = "";
        String currentAddrVal = "";
        String currentAddrFldFull = "";
        String findStr = "<Detail1.";
        String entityType = "";
        try {
            detailNodeList = tranDom.getElementsByTagName("Detail1");
            detailNode = detailNodeList.item(0);
            detailDom = this.genericUtility.parseString(this.genericUtility.serializeDom(detailNode));
            int pkCntr = 0;
            while (pkCntr < emailAddrFldArr.length) {
                currentAddrVal = "";
                currentAddrFldFull = emailAddrFldArr[pkCntr];
                if (currentAddrFldFull.startsWith(findStr)) {
                    currentAddrFld = currentAddrFldFull.substring(findStr.length(), currentAddrFldFull.lastIndexOf(">"));
                    BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)currentAddrFld);
                    if (detailDom.getElementsByTagName(currentAddrFld).item(0) != null && detailDom.getElementsByTagName(currentAddrFld).item(0).getFirstChild() != null) {
                        currentAddrVal = detailDom.getElementsByTagName(currentAddrFld).item(0).getFirstChild().getNodeValue();
                    }
                } else if (currentAddrFldFull.startsWith("{")) {
                    entityType = "";
                    if (currentAddrFldFull.charAt(1) == '(') {
                        entityType = currentAddrFldFull.substring(currentAddrFldFull.indexOf("(") + 1, currentAddrFldFull.indexOf(")"));
                        currentAddrFld = currentAddrFldFull.substring(currentAddrFldFull.indexOf(")") + 1, currentAddrFldFull.indexOf("}"));
                        currentAddrVal = this.getAddressValue(entityType, currentAddrFld, tranDom, userInfo);
                    }
                } else {
                    currentAddrVal = currentAddrFldFull;
                }
                if (currentAddrVal != null && currentAddrVal.length() > 0) {
                    emailAddress = String.valueOf(emailAddress) + currentAddrVal + ",";
                }
                ++pkCntr;
            }
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return emailAddress;
    }

    private String getAddressValue(String entityType, String argName, Document tranDom, UserInfoBean userInfo) throws ITMException {
        String retEmailAddr = "";
        NodeList detailNodeList = null;
        Node detailNode = null;
        Document detailDom = null;
        String whereFieldValue = "";
        try {
            String masterTable = null;
            String whereFieldName = null;
            String selFieldName = null;
            AppConnectParm appConnect = new AppConnectParm();
            InitialContext ctx = new InitialContext(appConnect.getProperty());
            DBAccessEJB dbAccess = new DBAccessEJB();
            if (entityType.equalsIgnoreCase("C")) {
                masterTable = "CUSTOMER";
                whereFieldName = "CUST_CODE";
                selFieldName = "EMAIL_ADDR";
            } else if (entityType.equalsIgnoreCase("S")) {
                masterTable = "SUPPLIER";
                whereFieldName = "SUPP_CODE";
                selFieldName = "EMAIL_ADDR";
            } else if (entityType.equalsIgnoreCase("E")) {
                masterTable = "EMPLOYEE";
                whereFieldName = "EMP_CODE";
                selFieldName = "EMAIL_ID_OFF";
            } else if (entityType.equalsIgnoreCase("P")) {
                masterTable = "SALES_PERS";
                whereFieldName = "SALES_PERS";
                selFieldName = "EMAIL_ADDR";
            } else if (entityType.equalsIgnoreCase("T")) {
                masterTable = "TRANSPORTER";
                whereFieldName = "TRAN_CODE";
                selFieldName = "EMAIL_ADDR";
            }
            detailNodeList = tranDom.getElementsByTagName("Detail1");
            detailNode = detailNodeList.item(0);
            detailDom = this.genericUtility.parseString(this.genericUtility.serializeDom(detailNode));
            BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("genericUtility.serializeDom(detailDom):" + this.genericUtility.serializeDom((Node)detailDom)));
            BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("AgrName:" + argName));
            if (detailDom.getElementsByTagName(argName) != null && detailDom.getElementsByTagName(argName).item(0) != null && detailDom.getElementsByTagName(argName).item(0).getFirstChild() != null) {
                whereFieldValue = detailDom.getElementsByTagName(argName).item(0).getFirstChild().getNodeValue();
            }
            BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("masterTable:" + masterTable + " \nwhereFieldName:" + whereFieldName + " \nselFieldName" + selFieldName + " \nwhereFieldValue:" + whereFieldValue));
            retEmailAddr = dbAccess.getEmailAddr(selFieldName, masterTable, whereFieldName, whereFieldValue, userInfo);
            dbAccess = null;
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return retEmailAddr;
    }

    private String getFormatedEmailSub(String subTextData, Document tranDom) throws ITMException {
        NodeList detailNodeList = null;
        Node detailNode = null;
        Document detailDom = null;
        String findStr = "<Detail1.";
        String colFullName = "";
        String colName = "";
        String currColVal = "";
        int currentIndex = 0;
        int nextSearchIndex = 0;
        try {
            detailNodeList = tranDom.getElementsByTagName("Detail1");
            if (subTextData != null) {
                detailNode = detailNodeList.item(0);
                detailDom = this.genericUtility.parseString(this.genericUtility.serializeDom(detailNode));
                while (subTextData.indexOf(findStr, nextSearchIndex) != -1) {
                    BaseLogger.log((String)"3", null, null, (Object)nextSearchIndex);
                    currColVal = "";
                    currentIndex = subTextData.indexOf(findStr, nextSearchIndex);
                    String firstPart = subTextData.substring(0, currentIndex);
                    String lastPart = subTextData.substring(currentIndex, subTextData.length());
                    colFullName = lastPart.substring(0, lastPart.indexOf(">") + 1);
                    BaseLogger.log((String)"3", null, null, (Object)("colFullName:" + colFullName));
                    colName = colFullName.substring(findStr.length(), colFullName.lastIndexOf(">"));
                    BaseLogger.log((String)"3", null, null, (Object)("colName:" + colName));
                    if (detailDom.getElementsByTagName(colName).item(0) != null && detailDom.getElementsByTagName(colName).item(0).getFirstChild() != null) {
                        currColVal = detailDom.getElementsByTagName(colName).item(0).getFirstChild().getNodeValue();
                    }
                    subTextData = String.valueOf(firstPart) + lastPart.replaceFirst(colFullName, currColVal);
                    nextSearchIndex = currentIndex + currColVal.length();
                    BaseLogger.log((String)"3", null, null, (Object)("SubTextData" + subTextData));
                }
            }
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return subTextData;
    }

    private String getFormatedEmailBody(String bodyTextData, Document tranDom) throws ITMException {
        NodeList detailNodeList = null;
        Node detailNode = null;
        Document detailDom = null;
        String findStr = "<Detail1.";
        String colFullName = "";
        String colName = "";
        String currColVal = "";
        int currentIndex = 0;
        int nextSearchIndex = 0;
        try {
            detailNodeList = tranDom.getElementsByTagName("Detail1");
            BaseLogger.log((String)"3", null, null, (Object)"Outside If Condition");
            if (bodyTextData != null) {
                detailNode = detailNodeList.item(0);
                detailDom = this.genericUtility.parseString(this.genericUtility.serializeDom(detailNode));
                BaseLogger.log((String)"3", null, null, (Object)"Outside While Condition");
                while (bodyTextData.indexOf(findStr, nextSearchIndex) != -1) {
                    BaseLogger.log((String)"3", null, null, (Object)nextSearchIndex);
                    currColVal = "";
                    currentIndex = bodyTextData.indexOf(findStr, nextSearchIndex);
                    String firstPart = bodyTextData.substring(0, currentIndex);
                    String lastPart = bodyTextData.substring(currentIndex, bodyTextData.length());
                    colFullName = lastPart.substring(0, lastPart.indexOf(">") + 1);
                    BaseLogger.log((String)"3", null, null, (Object)("colFullName:" + colFullName));
                    colName = colFullName.substring(findStr.length(), colFullName.lastIndexOf(">"));
                    BaseLogger.log((String)"3", null, null, (Object)("colName:" + colName));
                    if (detailDom.getElementsByTagName(colName).item(0) != null && detailDom.getElementsByTagName(colName).item(0).getFirstChild() != null) {
                        currColVal = detailDom.getElementsByTagName(colName).item(0).getFirstChild().getNodeValue();
                    }
                    bodyTextData = String.valueOf(firstPart) + lastPart.replaceFirst(colFullName, currColVal);
                    nextSearchIndex = currentIndex + currColVal.length();
                    BaseLogger.log((String)"3", null, null, (Object)("bodyTextData" + bodyTextData));
                }
            }
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return bodyTextData;
    }

    private String getValidDateFormat(String dateFormat) {
        if (dateFormat != null && dateFormat.indexOf("[.fffffffff]") != -1) {
            dateFormat = dateFormat.replace("[.fffffffff]", "");
        }
        return dateFormat;
    }

    private String checkNull(String inputStr) {
        if (inputStr == null) {
            inputStr = "";
        }
        return inputStr;
    }
}

