/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.ejb;

import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.InfinispanLocal;
import ibase.webitm.ejb.LocalizationLocal;
import ibase.webitm.ejb.LocalizationRemote;
import ibase.webitm.utility.ITMException;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Hashtable;
import javax.ejb.Stateless;
import javax.naming.InitialContext;

@Stateless
public class LocalizationEJB
implements LocalizationRemote,
LocalizationLocal {
    static InfinispanLocal infinispanLocalObj = null;
    static Hashtable jndiProperties = null;
    static InitialContext ctx = null;

    static {
        try {
            if (CommonConstants.CACHE_OPT != 0) {
                jndiProperties = new Hashtable();
                jndiProperties.put("java.naming.factory.url.pkgs", "org.jboss.ejb.client.naming");
                ctx = new InitialContext(jndiProperties);
                infinispanLocalObj = (InfinispanLocal)ctx.lookup("ibase/InfinispanEJB/local");
                BaseLogger.log("1", null, null, "LocalizationEJB infinispanLocalObj created.....");
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception in LocalizationEJB static block:[" + e.getMessage() + "]");
            e.printStackTrace();
        }
    }

    @Override
    public String getLocalizedXmlString(UserInfoBean userInfo, String objName, String pageContext, String objContext, String profileId, String editor, String formName) throws RemoteException, ITMException {
        StringBuffer xmlStringBuf = new StringBuffer();
        try {
            String profileIdRes = this.checkNull(userInfo.getProfileIdRes());
            BaseLogger.log("3", userInfo, null, "In LocalizationEJB - [profileIdRes] - [" + profileIdRes + "], formName =[" + formName + "]");
            String defaultPathForMetadataXML = "";
            String enterpriseIdRes = this.checkNull(userInfo.getEnterprise());
            String xmlString = "";
            HashMap<String, String> propEditorInfoMap = new HashMap<String, String>();
            propEditorInfoMap.put("PROFILE_ID_RES", profileIdRes);
            propEditorInfoMap.put("ENTERPRISE_ID_RES", enterpriseIdRes);
            propEditorInfoMap.put("EDITOR", editor);
            propEditorInfoMap.put("USER_ID", this.checkNull(userInfo.getLoginCode()));
            E12GenericUtility genericUtility = new E12GenericUtility();
            String newObjContext = "";
            newObjContext = formName != null && formName.trim().length() > 0 && !"null".equalsIgnoreCase(formName) ? formName : objContext;
            String userId = E12GenericUtility.checkNull((String)propEditorInfoMap.get("USER_ID"));
            String cacheMetadataFileName = String.valueOf(enterpriseIdRes) + "-" + profileIdRes + "-" + userId + "~~" + objName + pageContext + newObjContext;
            if (CommonConstants.CACHE_OPT != 0 && infinispanLocalObj != null) {
                if (infinispanLocalObj.contains(cacheMetadataFileName)) {
                    xmlString = infinispanLocalObj.getFormData(cacheMetadataFileName);
                } else {
                    String metadataFilePath = genericUtility.getMetaDataFilePath(objName, objContext, pageContext, formName, propEditorInfoMap, userInfo.getTransDB());
                    xmlString = this.readFile(metadataFilePath);
                    infinispanLocalObj.putFormData(cacheMetadataFileName, xmlString);
                }
            } else {
                String metadataFilePath = genericUtility.getMetaDataFilePath(objName, objContext, pageContext, formName, propEditorInfoMap, userInfo.getTransDB());
                xmlString = this.readFile(metadataFilePath);
            }
            xmlStringBuf.append(xmlString);
        }
        catch (ITMException itme) {
            BaseLogger.log("0", userInfo, null, "ITMException: LocalizationEJB: getLocalizedXmlString: ==>" + itme.getMessage());
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log("0", userInfo, null, "Exception: LocalizationEJB: getLocalizedXmlString: ==>" + e.getMessage());
            e.printStackTrace();
            throw new ITMException(e);
        }
        return xmlStringBuf.toString();
    }

    @Override
    public String getLocalizedXmlString(UserInfoBean userInfo, String objName, String pageContext, String objContext, String profileId, String editor) throws RemoteException, ITMException {
        StringBuffer xmlStringBuf = new StringBuffer();
        String localizedXmlStr = "";
        String formName = "";
        try {
            localizedXmlStr = this.getLocalizedXmlString(userInfo, objName, pageContext, objContext, profileId, editor, formName);
        }
        catch (ITMException itme) {
            BaseLogger.log("0", userInfo, null, "ITMException: LocalizationEJB: getLocalizedXmlString: ==>" + itme.getMessage());
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log("0", userInfo, null, "Exception: LocalizationEJB: getLocalizedXmlString: ==>" + e.getMessage());
            e.printStackTrace();
            throw new ITMException(e);
        }
        return localizedXmlStr;
    }

    private String readFile(String fileName) throws Exception {
        StringBuffer fileContent = new StringBuffer();
        BufferedReader bfr = null;
        try {
            FileInputStream fMainIn = new FileInputStream(fileName);
            bfr = new BufferedReader(new InputStreamReader((InputStream)fMainIn, CommonConstants.ENCODING));
            String outTempStr = null;
            while ((outTempStr = bfr.readLine()) != null) {
                fileContent.append(outTempStr);
            }
            bfr.close();
            bfr = null;
        }
        finally {
            try {
                if (bfr != null) {
                    bfr.close();
                    bfr = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception in releasing file resource :[" + fileName + "]");
                e.printStackTrace();
            }
        }
        return fileContent.toString();
    }

    private String checkNull(String input) {
        if (input == null || "null".equalsIgnoreCase(input)) {
            input = "";
        }
        return input.trim();
    }
}

