package ibase.utility.training;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

import javax.ejb.Stateless;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import ibase.bean.ExtAuthApplicationBean;
import ibase.utility.BaseLogger;
import ibase.utility.GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;

@Stateless
public class TaskMst extends ValidatorEJB {

	GenericUtility genericUtility = GenericUtility.getInstance();
	String userId = "";

	public String wfValData() throws RemoteException, ITMException {
		return "";
	}

	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag,
			String xtraParams) throws RemoteException, ITMException {

		BaseLogger.log("3", null, null, "Edit Flag value=" + editFlag);
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;

		String errString = null;
		GenericUtility genericUtility = GenericUtility.getInstance();
		try {
			BaseLogger.log("3", null, null, "wfValData value of xmlString [" + xmlString + "]");
			BaseLogger.log("3", null, null, "wfValData value of xmlString [" + xmlString1 + "]");
			BaseLogger.log("3", null, null, "wfValData value of xmlString [" + xmlString2 + "]");
			if (xmlString != null && xmlString.trim().length() != 0) {
				dom = genericUtility.parseString(xmlString);
			}
			if (xmlString1 != null && xmlString1.trim().length() != 0) {
				dom1 = genericUtility.parseString(xmlString1);
			}
			if (xmlString2 != null && xmlString2.trim().length() != 0) {
				dom2 = genericUtility.parseString(xmlString2);
			}
			errString = wfValData(dom, dom1, dom2, objContext, editFlag, xtraParams);
			BaseLogger.log("3", null, null, "ErrString: " + errString);
		} catch (Exception e) {
			BaseLogger.log("3", null, null, "Exception: wfValData(String xmlString): " + e.getMessage() + ":");
			errString = genericUtility.createErrorString(e);
			e.printStackTrace();
		}
		BaseLogger.log("3", null, null, "Returning from  wfValData errString=[" + errString + "]");
		return (errString);
	}

	public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String editFlag,
			String xtraParams) throws RemoteException, ITMException {
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		UserInfoBean userInfo = super.getUserInfo();
		int currentFormNo = 0, childNodeListLenght = 0;
		String childNodeName = null;

		String errString = "";

		String userId = "";

		try {
			userId = getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			// loginSite = getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode");

			parentNodeList = dom.getElementsByTagName("Detail1");

			parentNode = parentNodeList.item(0);
			childNodeList = parentNode.getChildNodes();
			childNodeListLenght = childNodeList.getLength();

			for (int i = 0; i < childNodeListLenght; i++) {
				childNode = childNodeList.item(i);
				BaseLogger.log("3", null, null, "Child Node=>" + i + "=>" + childNode);
				childNodeName = childNode.getNodeName().trim();
				BaseLogger.log("3", null, null, "Child Node Name=>" + i + "=>" + childNodeName);
				BaseLogger.log("3", null, null,
						"Child Node Value=>" + i + "=>" + genericUtility.getColumnValue(childNodeName, dom));

				if (childNodeName.equalsIgnoreCase("exp_tat")) {
					int exp_tatValue = Integer.parseInt(genericUtility.getColumnValue("exp_tat", dom));
					if (exp_tatValue < 0) {
						errString = getErrorString("exp_tat", "NGTVAL", userId);
					}

				}
				if (childNodeName.equalsIgnoreCase("task_code") && editFlag.equalsIgnoreCase("a")) {
                    if (duplicateValidationPropname(genericUtility.getColumnValue("task_code", dom))) {
                        errString = getErrorString("task_code", "DUPLTASK", userId);
                        break;

                    }
                }
					
				}
				
				

			}

		

		catch (

		Exception e) {
			e.getMessage();
			e.printStackTrace();
			BaseLogger.log("3", null, null, "Got Error in Validation=>" + e.getMessage());
		}
		BaseLogger.log("3", null, null, "Error String by Ankush==>" + errString + "<=");
		return errString;
	}
	
	
	private boolean duplicateValidationPropname(String task_code) {
        Connection connectionObject = null;
        Statement stmt = null;
        try {
            connectionObject = getConnection();
            String sql = "select task_code from task_mst where task_code ='" + task_code + "'";
            stmt = connectionObject.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            if (rs.next())
                return true;
            else
                return false;
        } catch (Exception e) {
            return false;
        } finally {
            try {
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
                if (connectionObject != null) {
                    connectionObject.close();
                    connectionObject = null;
                }
            } catch (Exception e) {
                BaseLogger.log("3", null, null, e.getMessage());
            }

        }

    }

//	private boolean ValidateExpTAT(int exp_tat) {
//		if (exp_tat < 0) {
//			return true;
//		}
//		return false;
//	}
}