package ibase.webitm.ejb.wsfa.masters;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;

import javax.ejb.Stateless;
import javax.naming.InitialContext;

import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.DBAccessLocal;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import ibase.wrkflw.utility.WorkflowLogger;
import oracle.jdbc.OracleConnection;
import oracle.sql.CLOB;

/* 
	 Author Name: Sachin Satre on [19-Jul-18] 
 	 Created Date : 26-Feb-19 
*/

@Stateless
public class LocalityConfirmation extends ValidatorEJB  implements  LocalityConfirmationRemote,LocalityConfirmationLocal 
{
	E12GenericUtility genericUtility = new E12GenericUtility();
	public String beatConfirm( String localityCode ,String xmlData ,String signBy ,String refSer, String SalesPers, String appoverCode ,String userInfoStr )throws RemoteException, ITMException
	{
		//String xtraParams ="";
		System.out.println("[LocalityConfirmation] localityChangesConfirm Method called..."+signBy+"]::appoverCode:::["+appoverCode+"]");
		System.out.println("tranID : "+localityCode);
		System.out.println("xmlData : "+xmlData);
		System.out.println("refSer : "+refSer);
		boolean isError=false;
		Connection connectionObject = null;		
		PreparedStatement pstmt = null;
		PreparedStatement pstmtInner = null;
		ResultSet rs = null;
		ResultSet rsInner = null;
		String childNodeName = "";
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null; 	
		int updCnt = 0;
		int parentNodeListLength = 0;
		int childNodeListLength = 0;	
		int noOfRecProcess = 0;
		String noVisit = "";
		String splCode = "";
		String classCode = "";
		String category = "";
		String noPatientDay = "";
		String businessToUs = "";
		String totalBusiness = "";
		String loginEmpCode = "";
		String chgTerm = "";
		String userId = "";
		String warningStr = "";
		String itemSer = "";
		String spCode = "";
		String scCode = "";
		String routeId = "";
		String status = "";
		String statusx = "";
		String sqlStr = null;
		String qualification="";
		String emailId="";
		String mobileNo="";
		Statement stmt = null;
		String returnString = "<ROOT><STATUS><![CDATA[1]]></STATUS><RESULT><![CDATA[Success]]></RESULT></ROOT>";
		String updtSql = "";
		String tranId ="";
		String lineNo ="";
		String occuType ="";
		String subSplCode ="";
		String rxMode ="";
		String patientProfile ="";
		String ageBracket ="";
		String assoType ="";
		
		String noVisitExists ="";
		String splCodeExists ="";
		String classCodeExists ="";
		String categoryExists ="";
		String noPatientDayExists ="";
		String businessToUsExists ="";
		String totalBusinessExists ="";
		String qualificationExists ="";
		String mobileNoExists ="";
		String emailIdExists ="";
		
		String occuTypeExists ="";
		String subSplCodeExists ="";
		String rxModeExists ="";
		String patientProfileExists ="";
		String ageBracketExists ="";
		String assoTypeExists ="";
		String updateFlag ="";
		
		try
		{
			
			ConnDriver connDriver = null;
			connDriver = new ConnDriver();
			//connectionObject = connDriver.getConnectDB("DriverValidator");
			//connectionObject = connDriver.getConnectDB("DriverITM");
			 
			
			String transDB="";
			System.out.println("Inside expenseConfirm confirm section: "+userInfoStr);
			UserInfoBean userInfo = new UserInfoBean(userInfoStr);
			if(userInfo!=null)
			{	
				transDB = userInfo.getTransDB();
			}
	    	System.out.println("get TransDB connection in expenseConfirm : "+transDB);
	    	
		    if (transDB != null && transDB.trim().length() > 0)
		    {
		    	connectionObject = connDriver.getConnectDB(transDB);
		    }
		    else
		    {
		    	connectionObject = connDriver.getConnectDB("DriverITM");
		    }
		    connectionObject.setAutoCommit( false );
			//connectionObject.setAutoCommit( false ); 
			Document dom = genericUtility.parseString(xmlData);
			// to find record COUNT for CONFIRMED ='A' [End]
			String tourCntSql = "SELECT count(*) as cnt FROM LOCALITY WHERE LOCALITY_CODE = ? AND WF_STATUS ='S' ";
			pstmtInner = connectionObject.prepareStatement(tourCntSql);
			pstmtInner.setString(1, localityCode);
			rsInner = pstmtInner.executeQuery();
			int submitCnt = 0;
			if ( rsInner.next() )
			{				
				submitCnt = rsInner.getInt("cnt");
			}
			System.out.println("submitCnt..["+submitCnt+"]");
			if ( rsInner != null )
			{
				rsInner.close();
				rsInner = null;
			}
			if ( pstmtInner != null )
			{
				pstmtInner.close();
				pstmtInner = null;
			}
			if (submitCnt == 0)
			{
				System.out.println("Inside the block of tour ID not sibmitted, now will throw exception");
				Exception exp = new Exception("Transaction Not Submitted");
				//generateLog( exp, tourID, "\r\n XML Data received as below : \r\n "+xmlData+" \r\n","TOUR");
				throw new Exception("Tour Not Submitted");
			}
			java.sql.Timestamp chgDate = new java.sql.Timestamp(System.currentTimeMillis()); 
			//userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			//chgTerm = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"termId");
			userId=appoverCode.trim() ;
			//System.out.println("::Updated into LOCALITY successfully [updCnt] SS:"+updCnt);
			String updateSql ="UPDATE  LOCALITY SET APRV_STAT ='A' , STATUS = 'A' ,EMP_CODE__APRV = '" + userId + "'  WHERE LOCALITY_CODE = '" + localityCode + "' ";
			pstmtInner = connectionObject.prepareStatement(updateSql);
			//pstmtInner.setString(1 , userId);
			//pstmtInner.setTimestamp(2,chgDate);
			updCnt = 0;
			updCnt = pstmtInner.executeUpdate();
			System.out.println("updCnt:LOCALITY in amd table:::::["+updCnt+"]");
			if ( pstmtInner != null )
			{
				pstmtInner.close();
				pstmtInner = null;
			}
		}
		catch (SQLException se)
		{
			try
			{
				isError=true;
				connectionObject.rollback();
			}
			catch(Exception sqe)
			{
				sqe.printStackTrace();
				isError=true; 
				returnString = "<ROOT><STATUS><![CDATA[0]]></STATUS><RESULT><![CDATA[Rollback failed during SQLException]]></RESULT></ROOT>";
           }
 			returnString = "<ROOT><STATUS><![CDATA[0]]></STATUS><RESULT><![CDATA[Some SQLException occurred ]]></RESULT></ROOT>";

		}
		catch( Exception ex )
		{
			try
			{
				connectionObject.rollback();
				isError=true;
			}
			catch(Exception e)
			{
				e.printStackTrace();
				isError=true;
            }
			returnString = "<ROOT><STATUS><![CDATA[0]]></STATUS><RESULT><![CDATA[Some other Exception came]]></RESULT></ROOT>";
		}
		finally
		{
			try
			{
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(!isError)
				{
					connectionObject.commit();
					System.out.println("Connection committed.");
				}
				if(connectionObject != null)
				{
					connectionObject.close();
					connectionObject = null;
				}				
			}
			catch ( Exception e)
			{
				e.printStackTrace();
			}		
		}
		return returnString;
	}
	public String rejectionUpdate(String localitCode ,String userInfoStr  ) throws RemoteException, ITMException 
	{

		System.out.println("rejectionUpdate CAALED");
		Connection conn = null;
		PreparedStatement pStmt = null;
		ConnDriver connDriver = null;
		boolean isError = false;
		int upateCnt =0;
		String salesPers ="";
		ResultSet rs1= null;
		ResultSet rs2= null;
		PreparedStatement pstmt1 = null;
		PreparedStatement pstmt2 = null; 
		int stpCount=0;
		String retString = "<ROOT><STATUS><![CDATA[1]]></STATUS><RESULT><![CDATA[ Rejected successfully ]]></RESULT></ROOT>";
		try
		{
			/*connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");
			connDriver = null;*/
			//ConnDriver connDriver = null;
			connDriver = new ConnDriver();
			
			String transDB="";
			System.out.println("Inside BeatConfirm confirm section: "+userInfoStr);
			UserInfoBean userInfo = new UserInfoBean(userInfoStr);
			if(userInfo!=null)
			{	
				transDB = userInfo.getTransDB();
			}
	    	System.out.println("get TransDB connection in expenseConfirm : "+transDB);
	    	
		    if (transDB != null && transDB.trim().length() > 0)
		    {
		    	conn = connDriver.getConnectDB(transDB);
		    }
		    else
		    {
		    	conn = connDriver.getConnectDB("DriverITM");
		    }
		    conn.setAutoCommit( false );

			System.out.println("localitCode ..> " + localitCode);
			localitCode = checkNull(localitCode);
			int updCnt = 0;

			String sql = "UPDATE LOCALITY SET WF_STATUS = 'D' , APRV_STAT='P' ,STATUS = 'N' WHERE LOCALITY_CODE = ?"; //confirm
			pStmt = conn.prepareStatement(sql);
			pStmt.setString(1, localitCode);
			updCnt = pStmt.executeUpdate();
			pStmt.clearParameters();
			System.out.println("in rejection records updated count is >>> "+updCnt);
			
			if(updCnt == 0)
			{
				retString = "<ROOT><STATUS><![CDATA[0]]></STATUS><RESULT><![CDATA[ Rejection Update failed for tran_id "+localitCode+"  ]]></RESULT></ROOT>";
			}
			System.out.println("updCntupdCnt:::["+updCnt+"]");
		} 
		catch (Exception e) 
		{
			isError = true;
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally 
		{
			if (conn != null) 
			{
				try 
				{
					if (isError) 
					{
						conn.rollback();
						System.out.println("BeatConfirm Connection Rollback");
					} 
					else 
					{
						conn.commit();
						System.out.println("BeatConfirm Connection Commit");
					}
					if(pStmt != null)
					{
						pStmt.close();
						pStmt = null;
					}
					if(conn != null)
					{
						conn.close();
						conn = null;
					}													
					
				}
				catch (Exception e) 
				{
					e.printStackTrace();
				}
			}
		}
		return retString;
	}
	private String checkNull(String input)
	{
		if (input==null)
		{
			input="";
		}
		else
		{
			input = input.trim();
		}
		return input;
	}
	public String getObjSignTransXmlData(String refSer,String refId,Connection conn) throws ITMException
	{
		System.out.println("getXmlDataObjSign called:::");
		System.out.println("");
		String retStr= "";
		try
		{
			String query1 = "";						
			
			if ( "oracle".equalsIgnoreCase( CommonConstants.DB_NAME )) 
			{
				query1 =  "SELECT WF.TRANS_INFO_XML.getClobval() FROM obj_sign_trans WF WHERE REF_SER = ? AND REF_ID = ? AND SIGN_STATUS = 'R' ";
			}
			else
			{
				query1 = "SELECT TRANS_INFO_XML FROM obj_sign_trans  WHERE REF_SER = ? AND REF_ID = ?  AND SIGN_STATUS = 'R' ";
			}	
			
			ArrayList bindVarValues1 = new ArrayList();
			bindVarValues1.add(refSer.trim());
			bindVarValues1.add(refId.trim());
			
			ArrayList bindVarTypes1 = new ArrayList();
			bindVarTypes1.add("String");
			
			//For DB2 Compatibility
			bindVarTypes1.add("Int");
			
			
			System.out.println("Getting BLOB obj signtrans from DBAccessEJB in SignManagerEJB sign4");
			String wfData1 ="";
			if( "oracle".equalsIgnoreCase( CommonConstants.DB_NAME ) )
			{	
				retStr = getXMLTypeStr( conn, query1, bindVarValues1, bindVarTypes1 );
			}
			else
			{
				retStr = getDBAccessObj().getBlob(query1, bindVarValues1, bindVarTypes1);
			}
			
			
		} 
		catch (Exception e) 
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		System.out.println("retStr string in getXmlDataObjSign::["+retStr+"]");
		return retStr;
		
	}
	private String getXMLTypeStr( Connection con, String query, ArrayList bindVarValues, ArrayList bindVarTypes) throws RemoteException, ITMException
	{
		System.out.println("@@@@ inside getXMLTypeStr with query :[ "+query+" ] bindVarValues :[ "+bindVarValues.toString()+" ] bindVarTypes :[ "+bindVarTypes+" ]");
		String dataStr = "";
		PreparedStatement pStmt = null;
		try
		{
			pStmt = con.prepareStatement(query);
			for (int ctr = 0; ctr < bindVarValues.size(); ctr++ )
			{
				if ( ((String)bindVarTypes.get(ctr)).indexOf("String") != -1)
				{
					pStmt.setString((ctr+1), (String)bindVarValues.get(ctr));
				}
				else if (((String)bindVarTypes.get(ctr)).indexOf("Int") != -1)
				{
					pStmt.setInt((ctr+1), Integer.parseInt((String)bindVarValues.get(ctr)) );
				}
			}
			
			ResultSet rs = pStmt.executeQuery();
			if (rs.next())
			{
				dataStr = (rs.getString(1) == null) ?"":rs.getString(1);
			}
			
			if (dataStr != null && dataStr.length() > 0 && dataStr.indexOf("</DocumentRoot>") != -1)
			{
				dataStr = dataStr.substring(0, dataStr.indexOf("</DocumentRoot>") + 15);
			}
			else if (dataStr != null && dataStr.length() > 0 && dataStr.indexOf("</Root>") != -1)
			{
				dataStr = dataStr.substring(0, dataStr.indexOf("</Root>") + 7);
			}
			rs.close();
			rs = null;
			pStmt.close();
			pStmt = null;
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{				
				if(pStmt != null)
				{
					pStmt.close();
					pStmt = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception :DBAccessEJB :getXMLTypeStr :==>finally\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		return dataStr;
	}
	private DBAccessLocal getDBAccessObj() throws ITMException
	{
		DBAccessLocal dbAccess = null;
		try
		{
			dbAccess = (DBAccessLocal)getInitialContext().lookup("ibase/DBAccessEJB/local");
		}
		catch (Exception e)
		{
			WorkflowLogger.info("Exception :SignManagerEJB :getDBAccessObj() :==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		return dbAccess;
	}
	private InitialContext getInitialContext()throws ITMException
	{
		InitialContext ctx = null;
		try
		{
			AppConnectParm appConnect = new AppConnectParm();
			ctx = new InitialContext(appConnect.getProperty());
		}
		catch(ITMException be)
		{
			throw be;
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		return ctx;
	}
	public String updateRejectedRemark(String domString, Connection conn) throws ITMException
	{
		System.out.println("updateAprvRemark() method called....["+domString+"]sd");
		String retStr="";
		PreparedStatement pStmt = null;
		ResultSet rs = null; 
		NodeList parentNodeList = null;
		Node parentNode = null;
		NodeList childNodeList = null;
		int childNodeListLength = 0;
		Node childNode = null;
		String childNodeName = "";
        Element nodeElement = null;
		int parentNodeListLength = 0;
		String refSer="";
		String refId="";
		String lineNo="";
		String roleCodeSign="";
		String signRemark="";
		String roleEntity="";
		String signStatus="";
		String signRemarkNew="",refSerNew="",trnID="",roleCodesign="",signStatusNew="";;
		Document dom =null;
		Document dom2 =null;
		Document dom1 =null;
		HashMap<String,String> signRamarkHM=  new HashMap<String, String>();
		String dataString ="";
		String dataStr ="";
		boolean isUpdate=false;
		boolean isError=false;
		String query="";
		String dataStrWfData="";
		String dataStringWfData="";
		String prcInst= "";
		String processId = "";
		String instanceId = "";
		try 
		{
			
			if (domString.trim().length() > 0 )
			{
				dom = genericUtility.parseString(domString);
			}
			refSerNew = genericUtility.getColumnValue("ref_ser",dom,"1");
			trnID = genericUtility.getColumnValue("ref_id",dom,"1");
			signStatusNew = genericUtility.getColumnValue("sign_status",dom,"1");
			signRemarkNew = genericUtility.getColumnValue("sign_remarks",dom,"1");
			roleCodesign = genericUtility.getColumnValue("role_code__sign",dom,"1");	
			System.out.println("updateAprvRemark::refSerNew["+refSerNew+"]::trnID:::["+trnID+"]::signStatusNew::["+signStatusNew+"]::roleCodesign:::["+roleCodesign+"]");
			parentNodeList = dom.getElementsByTagName("Detail1");
			parentNodeListLength = parentNodeList.getLength(); 
			System.out.println(":::updateAprvRemark:: parentNodeListLength Detail1:::::::>>::"+parentNodeListLength);
			for (int selectedRow = 0; selectedRow < parentNodeListLength; selectedRow++)
			{				
				parentNode = parentNodeList.item(selectedRow);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();
				System.out.println("updateAprvRemark .....childNodeListLength::: sasa>>>"+ childNodeListLength+"\n");
				
				for (int childRow = 0; childRow < childNodeListLength; childRow++)
				{
					System.out.println("childNodeListLengthchildNodeListLength:sdfds:"+ childNodeListLength);
					childNode = childNodeList.item(childRow);
					childNodeName = childNode.getNodeName();
					if (childNodeName.equalsIgnoreCase("ref_ser"))
					{
						if(childNode.getFirstChild()!=null)
						{
							refSer = childNode.getFirstChild().getNodeValue();
						}
						//System.out.println("refSer::["+refSer+"]");
					}
					if (childNodeName.equalsIgnoreCase("ref_id"))
					{
						if(childNode.getFirstChild()!=null)
						{
							refId = checkNull(childNode.getFirstChild().getNodeValue());
						}
						//System.out.println("refId::["+refId+"]");
					}					
					if (childNodeName.equalsIgnoreCase("line_no"))
					{
						if(childNode.getFirstChild()!=null)
						{
							lineNo = checkNull(childNode.getFirstChild().getNodeValue());
						}
						//System.out.println("lineNo::["+lineNo+"]");
					}	
					if (childNodeName.equalsIgnoreCase("role_code__sign"))//role_code__sign
					{
						if(childNode.getFirstChild()!=null)
						{
							roleCodeSign = checkNull(childNode.getFirstChild().getNodeValue());
						}
						//System.out.println("roleCodeSign::["+roleCodeSign+"]");
					}	
					
					if (childNodeName.equalsIgnoreCase("sign_remarks"))//sign_remarks
					{
						if(childNode.getFirstChild()!=null)
						{
							signRemark = checkNull(childNode.getFirstChild().getNodeValue());
						}
					}
					if (childNodeName.equalsIgnoreCase("role_entity"))//role_entity
					{
						if(childNode.getFirstChild()!=null)
						{
							roleEntity = checkNull(childNode.getFirstChild().getNodeValue());
						}
						//System.out.println("roleEntity::["+roleEntity+"]");
					}	
					if (childNodeName.equalsIgnoreCase("sign_status"))//sign_status
					{
						if(childNode.getFirstChild()!=null)
						{
							signStatus = checkNull(childNode.getFirstChild().getNodeValue());
						}
						//System.out.println("signStatus::["+signStatus+"]");
					}
					if (childNodeName.equalsIgnoreCase("prc_inst__wf"))//PRC_INST__WF
					{
						if(childNode.getFirstChild()!=null)
						{
							prcInst = checkNull(childNode.getFirstChild().getNodeValue());
						}
						System.out.println("prcInst::["+prcInst+"]");
					}
				} 
				if(roleCodeSign.equalsIgnoreCase("FLM_SIGN") && signStatus.equalsIgnoreCase("R") )
				{
					System.out.println("update remakrdfjdf aprv remakrs");
					signRamarkHM.put("rejected_remarks", signRemark);
				}
			}
			
			if (prcInst != null && prcInst.trim().length() > 0)
			{
				String str[] = prcInst.split(":");
				 processId = str[0];
				 instanceId = str[1];
			}
			System.out.println("processId :fgg: "+processId);
			System.out.println("instanceId :g: "+instanceId);
			
			String sql = "SELECT ARGUMENT_VALUE_XML FROM WF_PRC_DATA WHERE PROCESS_ID = ? AND INSTANCE_ID = ? AND ARGUMENT_ID='$XML_DATA_ALL'";
			
			if ( "oracle".equalsIgnoreCase( CommonConstants.DB_NAME )) 
			{
				query = "SELECT WPD.ARGUMENT_VALUE_XML.getClobval() FROM WF_PRC_DATA WPD WHERE PROCESS_ID=? AND INSTANCE_ID=? AND ARGUMENT_ID='$XML_DATA_ALL' ";
			}
			else
			{
				query = "SELECT ARGUMENT_VALUE FROM WF_PRC_DATA WHERE PROCESS_ID=? AND INSTANCE_ID=? AND ARGUMENT_ID='$XML_DATA_ALL' ";
			}	
			ArrayList bindVarValues = new ArrayList();
			bindVarValues.add(processId.trim());
			bindVarValues.add(instanceId.trim());
			
			ArrayList bindVarTypes = new ArrayList();
			bindVarTypes.add("String");
			
			//For DB2 Compatibility
			bindVarTypes.add("String");
			System.out.println("Getting BLOB from DBAccessEJB in SignManagerEJB sign4");
			
			String wfData ="";
			if( "oracle".equalsIgnoreCase( CommonConstants.DB_NAME ) )
			{	
				dataStrWfData = getXMLTypeStr( conn, query, bindVarValues, bindVarTypes );
			}
			else
			{
				dataStrWfData = getDBAccessObj().getBlob(query, bindVarValues, bindVarTypes);
			}
			dataStringWfData =applyDataToXML(signRamarkHM,dataStrWfData,"1");
			dom2 = genericUtility.parseString(dataStringWfData);
			String modifiedArgumentXml=genericUtility.serializeDom(dom2);;
			System.out.println("modifiedArgumentXml::::updateAprvRemarkupdateAprvRemarkasd:::::::+"+modifiedArgumentXml);
			String sqlUpdtWfData = "UPDATE WF_PRC_DATA SET ARGUMENT_VALUE_XML = XMLType(?) WHERE PROCESS_ID = ? AND INSTANCE_ID = ? AND ARGUMENT_ID='$XML_DATA_ALL'";				
			ArrayList bindVarValuesUpd = new ArrayList();
			bindVarValuesUpd.add(processId);
			bindVarValuesUpd.add(instanceId);

			ArrayList bindVarTypesUpd = new ArrayList();
			bindVarTypesUpd.add("String");
			bindVarTypesUpd.add("String");
			
			boolean	updStatus = updateXMLTypeStr( conn, sqlUpdtWfData, modifiedArgumentXml, bindVarValuesUpd, bindVarTypesUpd );
			if(updStatus)
			{
				System.out.println("Updated wf_prc_data Successfull in updateAprvRemark");
			}
			
			
			
			dataStr=getObjSignTransXmlData(refSer,refId,conn);
			dataString =applyDataToXML(signRamarkHM,dataStr,"1");
			System.out.println(" updateApproveLevel obj signtrans dataStr. updateAprvRemark::::::+"+dataString);
			dom1 = genericUtility.parseString(dataString);
			
			System.out.println("Dom getting elements obj signtrans  abcd.::updateAprvRemark::::+"+genericUtility.serializeDom(dom1));
			
			String modifiedArgumentXml1=genericUtility.serializeDom(dom1);;
			System.out.println("modifiedArgumentXml:::updateAprvRemark::::::::+"+modifiedArgumentXml1);
			String sqlUpdtWfData1 = "UPDATE obj_sign_trans SET TRANS_INFO_XML = XMLType(?) WHERE REF_SER = ? AND REF_ID= ? AND SIGN_STATUS <>'S' ";				
			ArrayList bindVarValuesUpd1 = new ArrayList();
			bindVarValuesUpd1.add(refSer);
			bindVarValuesUpd1.add(refId);

			ArrayList bindVarTypesUpd1 = new ArrayList();
			bindVarTypesUpd1.add("String");
			bindVarTypesUpd1.add("String");
			
			boolean	updStatus1 = updateXMLTypeStr( conn, sqlUpdtWfData1, modifiedArgumentXml1, bindVarValuesUpd1, bindVarTypesUpd1 );
			if(updStatus1)
			{
				System.out.println("Updated OBJ_SIGN_TRANS Successfull in updateAprvRemark()");
			}
			
		} 
		catch (Exception e) 
		{
			isError = true;
			e.printStackTrace();
			throw new ITMException(e);
		}
		/*finally 
		{
			if (conn != null) 
			{
				try 
				{
					if (isError) 
					{
						conn.rollback();
						System.out.println("ChgCoverageAreaApproval Connection Rollback");
					} 
					else 
					{
						conn.commit();
						System.out.println("ChgCoverageAreaApproval Connection Commit");
					}
					
				}
				catch (Exception e) 
				{
					e.printStackTrace();
				}
			}
		}*/
		return retStr;
	}
	private boolean updateXMLTypeStr( Connection con, String query, String dataStr, ArrayList bindVarValues, ArrayList bindVarTypes ) throws RemoteException,ITMException
	{
		System.out.println("@@@@ inside updateXMLType");
		WorkflowLogger.info("query ["+query+"]");
		WorkflowLogger.info("bindVarTypes ["+bindVarTypes+"]");
		WorkflowLogger.info("bindVarValues ["+bindVarValues+"]");
		boolean updStatus = false;
		PreparedStatement pStmt = null;
		OracleConnection oConnection=null;
		try
		{
			byte[] dataByteArray = null;
			E12GenericUtility genericUtility = new E12GenericUtility();
			dataStr = genericUtility.remAllXmlDec(dataStr);
			
			if ( dataStr != null && dataStr.length() > 0 && dataStr.indexOf( "</DocumentRoot>" ) != -1 )
			{
				dataStr = dataStr.substring( 0, dataStr.indexOf( "</DocumentRoot>" ) + 15 );
				dataByteArray = dataStr.getBytes();
			}
			else if ( dataStr != null && dataStr.length() > 0 && dataStr.indexOf( "</Root>" ) != -1 )
			{
				dataStr = dataStr.substring(0, dataStr.indexOf( "</Root>" ) + 7 );
				dataByteArray = dataStr.getBytes();
			}
			pStmt = con.prepareStatement(query);
			CLOB dataStrXml = CLOB.createTemporary( con.getMetaData().getConnection(), true, CLOB.DURATION_SESSION );
			dataStrXml.putString( 1, dataStr );         
			pStmt.setClob(1, dataStrXml);
			System.out.println("modifiedxmlstring in updateXMLTypeStr::"+dataStrXml);
			//Commented and changed by Gulzar for XMLType on 17/DEC/13 : END
			
			for (int ctr = 0; ctr < bindVarValues.size(); ctr++ )
			{
				if ( ( ( String )bindVarTypes.get(ctr)).indexOf( "String" ) != -1 )
				{
					pStmt.setString( ( ctr + 2 ), ( String )bindVarValues.get( ctr ) );
				}
				else if ( ( ( String )bindVarTypes.get( ctr ) ).indexOf( "Int" ) != -1 )
				{
					pStmt.setInt( ( ctr + 2 ), Integer.parseInt( ( String )bindVarValues.get( ctr ) ) );
				}
			}
			
			int updateCnt = pStmt.executeUpdate();
			System.out.println("@@@@ updateCnt in updateXMLType"+updateCnt);
			if( updateCnt > 0 )
			{
				updStatus = true;
			}
			pStmt.close();
			pStmt = null;
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(pStmt != null)
				{
					pStmt.close();
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception :SignManagerEJB :updateBlob :==>finally\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		return updStatus;
	}
	public String applyDataToXML(HashMap hashMap, String dataString, String formNo)throws ITMException
	{
		System.out.println("applyDataToXML called in approval screen");
		Document dataDom = null;
		GenericUtility genericUtility = GenericUtility.getInstance(); 
		try
		{
			System.out.println(" applyDataToXML Applying Data XML....");
			System.out.println("applyDataToXML hashMap :: " + hashMap);
			System.out.println("applyDataToXML dataString :: " + dataString);
			System.out.println("applyDataToXML formNo =[" + formNo + "]");
			dataDom = genericUtility.parseString(dataString);
			//System.out.println("DataDom Created :: " +genericUtility.serializeDom(dataDom));
			if (hashMap != null && hashMap.size() > 0)
			{
				NodeList parentNodeList = dataDom.getElementsByTagName("Detail"+formNo);
				int parentNodeListLen = parentNodeList.getLength();
				System.out.println("parentNodeListLen :sdf: " + parentNodeListLen);
				for(int pCtr = 0; pCtr < parentNodeListLen; pCtr++)
				{
					Node parent1Node = parentNodeList.item(pCtr);
					NodeList colNodeList = parent1Node.getChildNodes();
					int noOfColNodes = colNodeList.getLength();
					//System.out.println("noOfColNodes :sdfdsf: " + noOfColNodes);

					for(int colCtr = 0; colCtr < noOfColNodes; colCtr++)
					{
						Node currColNode = colNodeList.item(colCtr);
						if( currColNode.getNodeType() != Node.ELEMENT_NODE )
						{
							continue;
						}
						String colName = currColNode.getNodeName();
						//System.out.println("colName :sdfdf: " + colName);
						String key = colName;
						if( hashMap.containsKey(key))
						{
							//System.out.println("colName found in hasmap:fdghfg: " + colName);
							Node colValueNode = currColNode.getFirstChild();
							//if(colValueNode != null && colValueNode.getNodeValue() != null)
							if(colValueNode != null && colValueNode.getNodeValue() != null)
							{
								//System.out.println("colName found in hasmap:: " + colName);
								String colVal = (String)hashMap.get(key);
								if( colVal != null )
								{
									colValueNode.setNodeValue(colVal);
								}
							}
							else
							{
								//System.out.println("cdata createtnsection shdfkjd");
								CDATASection cDataSection = dataDom.createCDATASection((String)hashMap.get(key));
								currColNode.appendChild(cDataSection);
							}
						}//if( hashMap.containsKey(key))

					}//for(int colCtr = 0; colCtr < noOfColNodes; colCtr++)
				}//parent for loop

				if ( dataDom == null)
				{
					System.out.println(" datadom is null ");
				}
				dataString = genericUtility.serializeDom(dataDom);

			}//if (hashMap != null && hashMap.size() > 0)
		}
		catch (ITMException be)
		{
			throw be;
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}

		System.out.println("applyDataToXML DataDom Returned :: " + dataString);
		return dataString;
	}
	
}
