/*
 * Decompiled with CFR 0.152.
 */
package ibase.ejb;

import ibase.communication.Communication;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.ejb.MasterDataEJB;
import ibase.webitm.ejb.TransactionEmailTempltEJB;
import ibase.webitm.reports.utility.JasperReportGenerator;
import ibase.webitm.reports.utility.ResourceConstants;
import ibase.webitm.reports.utility.XSDParser;
import ibase.webitm.utility.ITMException;
import java.io.File;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashSet;
import java.util.TreeMap;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class E12TelegramComp {
    private UserInfoBean userInfo;
    String XMLString;
    String message;
    Communication communication;
    E12GenericUtility genericUtility = new E12GenericUtility();

    public String sendTelegram() {
        return "";
    }

    public String sendTelegram(String subject, String message, UserInfoBean userInfo) {
        String resultStr = "SEND_SUCCESS";
        try {
            this.userInfo = userInfo;
            this.message = message;
            this.communication = new Communication();
            this.XMLString = this.buildXMLString(this.userInfo, subject, message, "");
            resultStr = this.communication.communicate("Telegram", this.XMLString, "", userInfo, "");
            BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("ResultStr=[" + resultStr + "]"));
        }
        catch (Exception e) {
            e.printStackTrace();
            BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("Error in sendTelegramMessage " + e.getMessage()));
        }
        return resultStr;
    }

    public String sendTelegram(String filePath, UserInfoBean userInfo, boolean sendFile) {
        String resultStr = "SEND_SUCCESS";
        try {
            this.userInfo = userInfo;
            this.XMLString = this.buildXMLString(this.userInfo, "", "", filePath);
            this.communication = new Communication();
            resultStr = this.communication.communicate("Telegram", this.XMLString, "", userInfo, "");
            BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("ResultStr=[" + resultStr + "]"));
        }
        catch (Exception e) {
            e.printStackTrace();
            BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("Error in sendTelegramMessage " + e.getMessage()));
        }
        return resultStr;
    }

    public String sendTelegram(String XMLString, UserInfoBean userInfo) {
        BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("E12TelegramComp XMLString=[" + XMLString + "]"));
        String resultStr = "SEND_SUCCESS";
        try {
            this.userInfo = userInfo;
            this.communication = new Communication();
            resultStr = this.communication.communicate("Telegram", XMLString, "", userInfo, "");
            BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("ResultStr=[" + resultStr + "]"));
        }
        catch (Exception e) {
            e.printStackTrace();
            BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("Error in sendTelegramMessage " + e.getMessage()));
        }
        return resultStr;
    }

    private String buildXMLString(UserInfoBean userInfo, String subject, String message, String filePath) {
        StringBuilder XMLString = new StringBuilder("<Root>");
        E12GenericUtility utility = new E12GenericUtility();
        String tblName = "USER_ACC_CHANNEL";
        String tokenId = "";
        String chatId = "";
        String file = E12GenericUtility.checkNull((String)filePath);
        String transDB = userInfo.getTransDB();
        transDB = "APPVIS";
        try {
            DBAccessEJB dbAccess = new DBAccessEJB();
            tokenId = dbAccess.getDBColumnValue(tblName, "TOKEN_ID", "USER_ID='" + userInfo.getLoginCode() + "' AND APP_ID='TLG_APPVIS'", transDB);
            chatId = dbAccess.getDBColumnValue(tblName, "CHANNEL_UUID", "USER_ID='" + userInfo.getLoginCode() + "' AND APP_ID='TLG_APPVIS'", transDB);
            BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("sendTelegramMessage tokenId=[" + tokenId + "]"));
            BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("Got Telegram Chat Id=[" + chatId + "]"));
            BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("Got Telegram Message =[" + message + "]"));
            XMLString.append("<TOKEN_ID><![CDATA[" + tokenId + "]]></TOKEN_ID>");
            XMLString.append("<CHAT_ID><![CDATA[" + chatId + "]]></CHAT_ID>");
            if (!E12GenericUtility.checkNull((String)filePath).equals("")) {
                BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)"Sendin file to telegram");
                XMLString.append("<ATTACH_TEXT><![CDATA[" + file + "]]></ATTACH_TEXT>");
                XMLString.append("<BODY_TEXT><![CDATA[Please download]]></BODY_TEXT>");
                XMLString.append("<SUBJECT><![CDATA[Report File]]></SUBJECT>");
            } else {
                XMLString.append("<BODY_TEXT><![CDATA[" + E12GenericUtility.checkNull((String)message) + "]]></BODY_TEXT>");
                XMLString.append("<SUBJECT><![CDATA[" + E12GenericUtility.checkNull((String)subject) + "]]></SUBJECT>");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("Error in generateXMLStringForTelegram " + e.getMessage()));
        }
        XMLString.append("</Root>");
        BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("XMLString from generateXMLStringForTelegram ==>" + XMLString.toString()));
        return XMLString.toString();
    }

    public String buildXMLString(UserInfoBean userInfo, String transDom, String formatCode) {
        BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)"in E12TelegramCom buildXMLString");
        StringBuilder XMLString = new StringBuilder("<Root>");
        E12GenericUtility utility = new E12GenericUtility();
        String tblName = "USER_ACC_CHANNEL";
        String tokenId = "";
        String chatId = "";
        String message = "";
        String subject = "";
        String attachText = "";
        Document currentDom = null;
        String transDB = userInfo.getTransDB();
        transDB = "APPVIS";
        try {
            currentDom = utility.parseString(transDom);
            BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("sendTelegramMessage currentDom=[" + currentDom + "]"));
            DBAccessEJB dbAccess = new DBAccessEJB();
            tokenId = dbAccess.getDBColumnValue(tblName, "TOKEN_ID", "USER_ID='" + userInfo.getLoginCode() + "' AND APP_ID='TLG_APPVIS'", transDB);
            chatId = dbAccess.getDBColumnValue(tblName, "CHANNEL_UUID", "USER_ID='" + userInfo.getLoginCode() + "' AND APP_ID='TLG_APPVIS'", transDB);
            message = E12GenericUtility.checkNull((String)dbAccess.getDBColumnValue("COMM_FORMAT", "BODY_TEXT", "COMM_FORMAT='" + formatCode + "'", transDB));
            message = this.getFormatedMessageBody(message, currentDom);
            subject = E12GenericUtility.checkNull((String)dbAccess.getDBColumnValue("COMM_FORMAT", "subject", "COMM_FORMAT='" + formatCode + "'", transDB));
            attachText = E12GenericUtility.checkNull((String)dbAccess.getDBColumnValue("COMM_FORMAT", "ATTACH_TEXT", "COMM_FORMAT='" + formatCode + "'", transDB));
            BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("sendTelegramMessage tokenId=[" + tokenId + "]"));
            BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("Got Telegram Chat Id=[" + chatId + "]"));
            BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("Got Telegram Message =[" + message + "]"));
            XMLString.append("<TOKEN_ID><![CDATA[" + tokenId + "]]></TOKEN_ID>");
            XMLString.append("<CHAT_ID><![CDATA[" + chatId + "]]></CHAT_ID>");
            XMLString.append("<BODY_TEXT><![CDATA[" + E12GenericUtility.checkNull((String)message) + "]]></BODY_TEXT>");
            XMLString.append("<SUBJECT><![CDATA[" + E12GenericUtility.checkNull((String)subject) + "]]></SUBJECT>");
            if (attachText != "" && !attachText.equalsIgnoreCase("x")) {
                XMLString.append("<ATTACH_TEXT><![CDATA[" + attachText + "]]></ATTACH_TEXT>");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("Error in generateXMLStringForTelegram " + e.getMessage()));
        }
        XMLString.append("</Root>");
        BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("XMLString from generateXMLStringForTelegram ==>" + XMLString.toString()));
        return XMLString.toString();
    }

    public String buildXMLString(String objName, UserInfoBean userInfo, String tranDataStr, String sendTo, String copyTo, String blindCopy, String tranPKNames, String tranPKValues, String formatCode, String subject, String message, String attachmentText, String tranId) throws ITMException {
        StringBuilder XMLString = new StringBuilder("<Root>");
        try {
            String userCodes;
            String[] pkValues = tranPKValues.split(",");
            Document currentPkTranDom = null;
            int pkCount = 0;
            while (pkCount < pkValues.length) {
                try {
                    E12GenericUtility e12GenericUtility = new E12GenericUtility();
                    currentPkTranDom = E12GenericUtility.checkNull((String)tranDataStr).length() > 0 ? e12GenericUtility.parseString(tranDataStr) : this.getCurrentTranDom(pkValues[pkCount], userInfo, objName);
                }
                catch (Exception e) {
                    System.out.println("TransactionEmailTempltEJB.sendMail() Exception tranDataStr : [" + tranDataStr + "]");
                    currentPkTranDom = this.getCurrentTranDom(pkValues[pkCount], userInfo, objName);
                }
                ++pkCount;
            }
            BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("in E12TelegramCom currentPkTranDom=[" + currentPkTranDom + "]"));
            BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)"in E12TelegramCom buildXMLString");
            DBAccessEJB dbAccess = new DBAccessEJB();
            String chatId = "";
            if (sendTo.contains("<")) {
                String sendToChatId = this.getChatId(sendTo, currentPkTranDom, userInfo, dbAccess);
                BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("from chatId  sendTo=" + sendToChatId));
                chatId = sendToChatId;
            } else {
                userCodes = Arrays.asList(sendTo.split(",")).toString().replace("[", "").replace("]", "").replace(" ", "");
                chatId = this.getChatIdFromUserCode(userCodes, dbAccess);
            }
            if (copyTo.contains("<")) {
                String copyToChatId = this.getChatId(copyTo, currentPkTranDom, userInfo, dbAccess);
                BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("from chatId  copyTo=" + copyToChatId));
                chatId = String.valueOf(chatId) + "," + copyToChatId;
            } else {
                userCodes = Arrays.asList(copyTo.split(",")).toString().replace("[", "").replace("]", "").replace(" ", "");
                chatId = String.valueOf(chatId) + "," + userCodes;
            }
            if (blindCopy.contains("<")) {
                String blindCopyChatId = this.getChatId(blindCopy, currentPkTranDom, userInfo, dbAccess);
                BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("from chatId  blindCopy=" + blindCopyChatId));
                chatId = String.valueOf(chatId) + "," + blindCopyChatId;
            } else {
                userCodes = Arrays.asList(blindCopy.split(",")).toString().replace("[", "").replace("]", "").replace(" ", "");
                chatId = String.valueOf(chatId) + "," + userCodes;
            }
            String[] chatIdArry = chatId.split(",");
            StringBuilder allChatId = new StringBuilder();
            HashSet<String> set = new HashSet<String>();
            String[] stringArray = chatIdArry;
            int n = chatIdArry.length;
            int n2 = 0;
            while (n2 < n) {
                String chId = stringArray[n2];
                if (!chId.equals("")) {
                    if (allChatId.length() == 0) {
                        allChatId.append(chId);
                    } else if (set.add(chId)) {
                        allChatId.append("," + chId);
                    }
                }
                ++n2;
            }
            chatId = allChatId.toString();
            BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("All Chat Id=" + chatId));
            E12GenericUtility utility = new E12GenericUtility();
            String tblName = "USER_ACC_CHANNEL";
            String tokenId = "";
            String attachText = "";
            String transDB = userInfo.getTransDB();
            transDB = "APPVIS";
            tokenId = dbAccess.getDBColumnValue(tblName, "TOKEN_ID", "USER_ID='" + userInfo.getLoginCode() + "' AND APP_ID='TLG_APPVIS'", transDB);
            BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("objName bxs:: [" + attachText + "]"));
            BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("attachmentText bxs:: [" + attachmentText + "]"));
            BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("currentPkTranDom bxs:: [" + currentPkTranDom + "]"));
            BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("tranId bxs:: [" + tranId + "]"));
            attachText = this.getAttachmentPath(objName, attachmentText, userInfo, currentPkTranDom, tranId, "pdf");
            BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("attachText bxs:: [" + attachText + "]"));
            BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("sendTelegramMessage tokenId=[" + tokenId + "]"));
            BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("Got Telegram Chat Id=[" + chatId + "]"));
            BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("Got Telegram Message =[" + message + "]"));
            XMLString.append("<TOKEN_ID><![CDATA[" + tokenId + "]]></TOKEN_ID>");
            XMLString.append("<CHAT_ID><![CDATA[" + chatId + "]]></CHAT_ID>");
            XMLString.append("<BODY_TEXT><![CDATA[" + E12GenericUtility.checkNull((String)message) + "]]></BODY_TEXT>");
            XMLString.append("<SUBJECT><![CDATA[" + E12GenericUtility.checkNull((String)subject) + "]]></SUBJECT>");
            if (attachText != "" && !attachText.equalsIgnoreCase("x")) {
                XMLString.append("<ATTACH_TEXT><![CDATA[" + attachText + "]]></ATTACH_TEXT>");
            }
            XMLString.append("</Root>");
        }
        catch (ITMException itme) {
            BaseLogger.log((String)"0", (UserInfoBean)userInfo, null, (Object)"Exception :TransactionEmailTempltEJB :sendMail :==>");
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log((String)"0", (UserInfoBean)userInfo, null, (Object)"Exception :TransactionEmailTempltEJB :sendMail :==>");
            throw new ITMException(e);
        }
        BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("BuildXMLString() XMLString=[" + XMLString + "]"));
        return XMLString.toString();
    }

    private String getAttachmentPath(String objName, String attachObjLink, UserInfoBean userInfo, Document currentPkTranDom, String tranId, String attachType) throws ITMException {
        BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)"Inside getAttachmentPath");
        String attachmentPath = "";
        Statement pstmt = null;
        ResultSet rs = null;
        Connection conn = this.getConnection(userInfo);
        try {
            try {
                String selSql = "";
                String[] attachFormField = attachObjLink.split(":");
                String formNo = attachFormField[0];
                String formField = attachFormField[1];
                String reportFileName = "";
                Object linkArgsArr = null;
                Object detailNodeList = null;
                Object detailNode = null;
                Object detailDom = null;
                String linkAgrs = "";
                String linkTitle = "";
                selSql = "SELECT TARGET_OBJ_NAME,LINK_ARG,LINK_TITLE FROM OBJ_LINKS WHERE OBJ_NAME = ? AND FORM_NO = ? AND FIELD_NAME = ? AND LINK_TYPE = ?";
                pstmt = conn.prepareStatement(selSql);
                pstmt.setString(1, objName);
                pstmt.setString(2, formNo);
                pstmt.setString(3, formField);
                pstmt.setString(4, "5");
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    reportFileName = E12GenericUtility.checkNull((String)rs.getString("TARGET_OBJ_NAME"));
                    linkAgrs = E12GenericUtility.checkNull((String)rs.getString("LINK_ARG"));
                    linkTitle = E12GenericUtility.checkNull((String)rs.getString("LINK_TITLE"));
                }
                String outputFilename = String.valueOf(objName) + "_" + tranId + "_" + linkTitle;
                XSDParser xsdParser = new XSDParser(reportFileName, userInfo);
                BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("xsdParser:: [" + xsdParser + "]"));
                String argXmlString = xsdParser.getArgumentMetaDataString();
                BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("xsdParser.getArgumentMetaDataString():: [" + argXmlString + "]"));
                TransactionEmailTempltEJB transactionEmailTemplateEJB = new TransactionEmailTempltEJB();
                String reportArgString = transactionEmailTemplateEJB.genReportArgStr(reportFileName, attachType, argXmlString, currentPkTranDom, linkAgrs, userInfo);
                BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("ReportArgString[" + reportArgString + "]"));
                JasperReportGenerator jasperReport = new JasperReportGenerator(userInfo);
                TreeMap argMap = jasperReport.createArgMap(reportArgString);
                BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("reportFileName:::->" + reportFileName));
                BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("reportFileName:::->" + reportFileName));
                BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("xsdParser:::->" + xsdParser));
                BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("outputFilename:::->" + outputFilename));
                try {
                    jasperReport.createReport(reportFileName, argMap, xsdParser, "EmailAttachments", outputFilename);
                }
                catch (Throwable exp) {
                    BaseLogger.log((String)"0", null, null, (Object)"Exception in createReport");
                    exp.printStackTrace();
                }
                BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("b attachmentPath TransactionEmailTempltEJB:::->" + attachmentPath));
                attachmentPath = String.valueOf(ResourceConstants.REPORTDESTINATION) + File.separator + "EmailAttachments" + File.separator + outputFilename + "." + attachType;
                BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("a attachmentPath TransactionEmailTempltEJB:::->" + attachmentPath));
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception exception) {}
        }
        BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("attachmentPath TransactionEmailTempltEJB:::->" + attachmentPath));
        return attachmentPath;
    }

    private String getChatIdFromUserCode(String userCode, DBAccessEJB dbAccess) {
        try {
            String[] userArray;
            StringBuilder allChatId = new StringBuilder();
            String[] stringArray = userArray = userCode.split(",");
            int n = userArray.length;
            int n2 = 0;
            while (n2 < n) {
                String code = stringArray[n2];
                if (!code.equals("")) {
                    String chatId = E12GenericUtility.checkNull((String)dbAccess.getDBColumnValue("USER_ACC_CHANNEL", "CHANNEL_UUID", "USER_ID='" + code + "' AND APP_ID='TLG_APPVIS'", "APPVIS"));
                    if (allChatId.length() == 0) {
                        allChatId.append(chatId);
                    } else {
                        allChatId.append("," + chatId);
                    }
                }
                ++n2;
            }
            return allChatId.toString();
        }
        catch (Exception e) {
            BaseLogger.log((String)"0", (UserInfoBean)this.userInfo, null, (Object)("getChatIdFromUserCode() Error=[" + e.getMessage() + "]"));
            return "";
        }
    }

    private String getChatId(String sendToFlds, Document tranDom, UserInfoBean userInfo, DBAccessEJB dbAccess) throws ITMException {
        String userCodes = "";
        String chatId = "";
        NodeList detailNodeList = null;
        Node detailNode = null;
        Document detailDom = null;
        String[] userCodeFldArr = sendToFlds.split(",");
        String currentAddrFld = "";
        String currentAddrVal = "";
        String currentAddrFldFull = "";
        String findStr = "<Detail1.";
        String entityType = "";
        try {
            detailNodeList = tranDom.getElementsByTagName("Detail1");
            detailNode = detailNodeList.item(0);
            detailDom = this.genericUtility.parseString(this.genericUtility.serializeDom(detailNode));
            int pkCntr = 0;
            while (pkCntr < userCodeFldArr.length) {
                currentAddrVal = "";
                currentAddrFldFull = userCodeFldArr[pkCntr];
                if (currentAddrFldFull.startsWith(findStr)) {
                    currentAddrFld = currentAddrFldFull.substring(findStr.length(), currentAddrFldFull.lastIndexOf(">"));
                    BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)currentAddrFld);
                    if (detailDom.getElementsByTagName(currentAddrFld).item(0) != null && detailDom.getElementsByTagName(currentAddrFld).item(0).getFirstChild() != null) {
                        currentAddrVal = detailDom.getElementsByTagName(currentAddrFld).item(0).getFirstChild().getNodeValue();
                    }
                } else if (currentAddrFldFull.startsWith("{")) {
                    entityType = "";
                    if (currentAddrFldFull.charAt(1) == '(') {
                        entityType = currentAddrFldFull.substring(currentAddrFldFull.indexOf("(") + 1, currentAddrFldFull.indexOf(")"));
                        currentAddrFld = currentAddrFldFull.substring(currentAddrFldFull.indexOf(")") + 1, currentAddrFldFull.indexOf("}"));
                        BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("entityType=" + entityType));
                        BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("currentAddrFld=" + currentAddrFld));
                        currentAddrVal = this.getAddressValue(entityType, currentAddrFld, tranDom, userInfo);
                        BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("currentAddrVal=" + currentAddrVal));
                    }
                } else if (currentAddrFldFull.startsWith("[")) {
                    entityType = "";
                    if (currentAddrFldFull.charAt(1) == '(') {
                        entityType = currentAddrFldFull.substring(currentAddrFldFull.indexOf("(") + 1, currentAddrFldFull.indexOf(")"));
                        currentAddrFld = currentAddrFldFull.substring(currentAddrFldFull.indexOf(")") + 1, currentAddrFldFull.indexOf("]"));
                        BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("entityType=" + entityType));
                        BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("currentAddrFld=" + currentAddrFld));
                        currentAddrVal = this.getAddressValue(entityType, currentAddrFld, tranDom, userInfo);
                        BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("currentAddrVal=" + currentAddrVal));
                    }
                } else {
                    currentAddrVal = currentAddrFldFull;
                }
                if (currentAddrVal != null && currentAddrVal.length() > 0) {
                    userCodes = String.valueOf(userCodes) + currentAddrVal + ",";
                }
                ++pkCntr;
            }
            String[] users = userCodes.split(",");
            String transDB = "APPVIS";
            int userIndex = 0;
            while (userIndex < users.length) {
                if (!users[userIndex].contains("@")) {
                    String chid = E12GenericUtility.checkNull((String)dbAccess.getDBColumnValue("USER_ACC_CHANNEL", "CHANNEL_UUID", "USER_ID='" + users[userIndex] + "' AND APP_ID='TLG_APPVIS'", transDB));
                    chatId = chatId.equals("") ? chid : String.valueOf(chatId) + "," + chid;
                }
                ++userIndex;
            }
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return chatId;
    }

    private String getAddressValue(String entityType, String argName, Document tranDom, UserInfoBean userInfo) throws ITMException {
        String chatId = "";
        NodeList detailNodeList = null;
        Node detailNode = null;
        Document detailDom = null;
        String whereFieldValue = "";
        DBAccessEJB dbAccess = new DBAccessEJB();
        try {
            detailNodeList = tranDom.getElementsByTagName("Detail1");
            detailNode = detailNodeList.item(0);
            detailDom = this.genericUtility.parseString(this.genericUtility.serializeDom(detailNode));
            BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("genericUtility.serializeDom(detailDom):" + this.genericUtility.serializeDom((Node)detailDom)));
            BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("AgrName:" + argName));
            if (detailDom.getElementsByTagName(argName) != null && detailDom.getElementsByTagName(argName).item(0) != null && detailDom.getElementsByTagName(argName).item(0).getFirstChild() != null) {
                whereFieldValue = detailDom.getElementsByTagName(argName).item(0).getFirstChild().getNodeValue();
            }
            BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("getAddressValue()whereFieldValue =[" + whereFieldValue));
            chatId = dbAccess.getDBColumnValue("USER_ACC_CHANNEL", "CHANNEL_UUID", "USER_ID='" + whereFieldValue + "', AND APP_ID='TLG_APPVIS'", "APPVIS");
            BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("getAddressValue()chatId =[" + chatId));
            dbAccess = null;
        }
        catch (Exception e) {
            BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("Error in getAddressValue()" + e.getMessage()));
            throw new ITMException(e);
        }
        return chatId;
    }

    private String getChatId(String transDB, DBAccessEJB dbAccess, String formatCode) {
        String chatId = "";
        try {
            String sendTo = E12GenericUtility.checkNull((String)dbAccess.getDBColumnValue("COMM_FORMAT", "SEND_TO", "COMM_FORMAT='" + formatCode + "'", transDB));
            String copyTo = E12GenericUtility.checkNull((String)dbAccess.getDBColumnValue("COMM_FORMAT", "COPY_TO", "comm_format='" + formatCode + "'", transDB));
            String blindCopy = E12GenericUtility.checkNull((String)dbAccess.getDBColumnValue("COMM_FORMAT", "BLIND_COPY", "comm_format='" + formatCode + "'", transDB));
            String sentTochatId = E12GenericUtility.checkNull((String)dbAccess.getDBColumnValue("USER_ACC_CHANNEL", "CHANNEL_UUID", "USER_ID='" + sendTo + "' AND APP_ID='TLG_APPVIS'", transDB));
            String copyTochatId = E12GenericUtility.checkNull((String)dbAccess.getDBColumnValue("USER_ACC_CHANNEL", "CHANNEL_UUID", "USER_ID='" + copyTo + "' AND APP_ID='TLG_APPVIS'", transDB));
            String blindCopychatId = E12GenericUtility.checkNull((String)dbAccess.getDBColumnValue("USER_ACC_CHANNEL", "CHANNEL_UUID", "USER_ID='" + blindCopy + "' AND APP_ID='TLG_APPVIS'", transDB));
            if (!sentTochatId.equals("")) {
                chatId = sentTochatId;
            }
            if (!copyTochatId.equals("")) {
                chatId = String.valueOf(chatId) + "," + copyTochatId;
            }
            if (!blindCopychatId.equals("")) {
                chatId = String.valueOf(chatId) + "," + blindCopychatId;
            }
            if (chatId.contains("<")) {
                chatId = dbAccess.getDBColumnValue("USER_ACC_CHANNEL", "CHANNEL_UUID", "USER_ID='" + this.userInfo.getLoginCode() + "' AND APP_ID='TLG_APPVIS'", transDB);
            }
        }
        catch (Exception e) {
            BaseLogger.log((String)"0", (UserInfoBean)this.userInfo, null, (Object)("getChatId() Error=[" + e.getMessage() + "]"));
        }
        BaseLogger.log((String)"0", (UserInfoBean)this.userInfo, null, (Object)("getChatId() chatId=[" + chatId + "]"));
        return chatId;
    }

    private String getFormatedMessageBody(String bodyTextData, Document tranDom) throws ITMException {
        NodeList detailNodeList = null;
        Node detailNode = null;
        Document detailDom = null;
        String findStr = "<Detail1.";
        String colFullName = "";
        String colName = "";
        String currColVal = "";
        int currentIndex = 0;
        int nextSearchIndex = 0;
        E12GenericUtility genericUtility = new E12GenericUtility();
        try {
            BaseLogger.log((String)"3", null, null, (Object)("Telegram Message tranDome:" + genericUtility.parseString(genericUtility.serializeDom((Node)tranDom))));
            BaseLogger.log((String)"3", null, null, (Object)("Telegram Message bodyTextData:" + bodyTextData));
            BaseLogger.log((String)"3", null, null, (Object)("Telegram Message tranDom string:" + this.domToString(tranDom)));
            BaseLogger.log((String)"3", null, null, (Object)("Telegram Message findStr string:" + findStr));
            detailNodeList = tranDom.getElementsByTagName("Detail1");
            if (bodyTextData != null) {
                detailNode = detailNodeList.item(0);
                detailDom = genericUtility.parseString(genericUtility.serializeDom(detailNode));
                BaseLogger.log((String)"3", null, null, (Object)("detaildom: " + detailDom));
                while (bodyTextData.indexOf(findStr, nextSearchIndex) != -1) {
                    BaseLogger.log((String)"3", null, null, (Object)nextSearchIndex);
                    currColVal = "";
                    currentIndex = bodyTextData.indexOf(findStr, nextSearchIndex);
                    String firstPart = bodyTextData.substring(0, currentIndex);
                    String lastPart = bodyTextData.substring(currentIndex, bodyTextData.length());
                    colFullName = lastPart.substring(0, lastPart.indexOf(">") + 1);
                    BaseLogger.log((String)"3", null, null, (Object)("Telegram Message colFullName:" + colFullName));
                    colName = colFullName.substring(findStr.length(), colFullName.lastIndexOf(">"));
                    BaseLogger.log((String)"3", null, null, (Object)("telegram Message colName:" + colName));
                    if (detailDom.getElementsByTagName(colName).item(0) != null && detailDom.getElementsByTagName(colName).item(0).getFirstChild() != null) {
                        currColVal = detailDom.getElementsByTagName(colName).item(0).getFirstChild().getNodeValue();
                    }
                    bodyTextData = String.valueOf(firstPart) + lastPart.replaceFirst(colFullName, currColVal.trim());
                    nextSearchIndex = currentIndex + currColVal.length();
                    BaseLogger.log((String)"3", null, null, (Object)("bodyTextData for Telegram message=" + bodyTextData));
                }
            }
        }
        catch (Exception e) {
            BaseLogger.log((String)"3", null, null, (Object)("Error in getFormatedMessageBody()=" + e.getMessage()));
            throw new ITMException(e);
        }
        BaseLogger.log((String)"3", null, null, (Object)("getFormatedMessageBody bodyTextData:" + bodyTextData));
        return bodyTextData;
    }

    private String getFormatedMessageBody2(String bodyTextData, Document tranDom) throws ITMException {
        NodeList detailNodeList = null;
        Node detailNode = null;
        Document detailDom = null;
        String findStr = "<Detail1.";
        String colFullName = "";
        String colName = "";
        String currColVal = "";
        int currentIndex = 0;
        int nextSearchIndex = 0;
        E12GenericUtility genericUtility = new E12GenericUtility();
        try {
            BaseLogger.log((String)"3", null, null, (Object)("Telegram Message tranDome:" + genericUtility.parseString(genericUtility.serializeDom((Node)tranDom))));
            BaseLogger.log((String)"3", null, null, (Object)("Telegram Message bodyTextData:" + bodyTextData));
            BaseLogger.log((String)"3", null, null, (Object)("Telegram Message tranDom string:" + this.domToString(tranDom)));
            BaseLogger.log((String)"3", null, null, (Object)("Telegram Message findStr string:" + findStr));
            detailNodeList = tranDom.getElementsByTagName("Detail1");
            if (bodyTextData != null) {
                detailNode = detailNodeList.item(0);
                detailDom = genericUtility.parseString(genericUtility.serializeDom(detailNode));
                BaseLogger.log((String)"3", null, null, (Object)("detaildom: " + detailDom));
                while (bodyTextData.indexOf(findStr, nextSearchIndex) != -1) {
                    BaseLogger.log((String)"3", null, null, (Object)nextSearchIndex);
                    currColVal = "";
                    currentIndex = bodyTextData.indexOf(findStr, nextSearchIndex);
                    String firstPart = bodyTextData.substring(0, currentIndex);
                    String lastPart = bodyTextData.substring(currentIndex, bodyTextData.length());
                    colFullName = lastPart.substring(0, lastPart.indexOf("&gt;") + 4);
                    BaseLogger.log((String)"3", null, null, (Object)("Telegram Message colFullName:" + colFullName));
                    colName = colFullName.substring(findStr.length(), colFullName.lastIndexOf("&gt;"));
                    BaseLogger.log((String)"3", null, null, (Object)("telegram Message colName:" + colName));
                    if (detailDom.getElementsByTagName(colName).item(0) != null && detailDom.getElementsByTagName(colName).item(0).getFirstChild() != null) {
                        currColVal = detailDom.getElementsByTagName(colName).item(0).getFirstChild().getNodeValue();
                    }
                    bodyTextData = String.valueOf(firstPart) + lastPart.replaceFirst(colFullName, currColVal);
                    nextSearchIndex = currentIndex + currColVal.length();
                    BaseLogger.log((String)"3", null, null, (Object)("bodyTextData for Telegram message=" + bodyTextData));
                }
            }
        }
        catch (Exception e) {
            BaseLogger.log((String)"3", null, null, (Object)("Error in getFormatedMessageBody()=" + e.getMessage()));
            throw new ITMException(e);
        }
        BaseLogger.log((String)"3", null, null, (Object)("getFormatedMessageBody bodyTextData:" + bodyTextData));
        return bodyTextData;
    }

    private String domToString(Document dom) {
        String xmlStr = "";
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            StringWriter stringWriter = new StringWriter();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.transform(new DOMSource(dom), new StreamResult(stringWriter));
            xmlStr = stringWriter.toString();
        }
        catch (Exception e) {
            BaseLogger.log((String)"0", (UserInfoBean)this.userInfo, null, (Object)("domToString() Error=[" + e.getMessage() + "]"));
        }
        BaseLogger.log((String)"3", null, null, (Object)("domToString() xmlStr:" + xmlStr));
        return xmlStr;
    }

    private Document getCurrentTranDom(String pkValues, UserInfoBean userInfo, String objName) throws ITMException {
        String tranXml = "";
        E12GenericUtility genericUtility = new E12GenericUtility();
        try {
            MasterDataEJB masterDataEJB = new MasterDataEJB();
            tranXml = masterDataEJB.getXMLFromDBForBrow(objName, "1", "2", pkValues, null, null, userInfo);
            masterDataEJB = null;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ITMException(e);
        }
        return genericUtility.parseString(tranXml);
    }

    private Connection getConnection(UserInfoBean userInfo) throws ITMException {
        ConnDriver connDriver = null;
        Connection conn = null;
        String transDB = userInfo.getTransDB();
        try {
            connDriver = new ConnDriver();
            if (userInfo != null) {
                transDB = userInfo.getTransDB();
            }
            conn = connDriver.getConnectDB(transDB);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ITMException(e);
        }
        return conn;
    }
}

